/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.gui;

import com.nokia.svg2svgt.ServiceRegistry;
import com.nokia.svg2svgt.converter.BlackListAnalyzer;
import com.nokia.svg2svgt.converter.SVGAttribute;
import com.nokia.svg2svgt.converter.SVGElement;
import com.nokia.svg2svgt.converter.SVGModule;
import com.nokia.svg2svgt.gui.SVGTConverterController;
import com.nokia.svg2svgt.localiser.Localiser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BlackListPanel
extends JPanel {
    private SVGTConverterController myController = null;
    private JPanel blackListpanel;
    private JPanel tablePanel;
    private DefaultTableModel dtm;
    private JTable blackListTable;
    private TitledBorder titledBorder2;
    private JScrollPane scroll;
    private JButton addButton;
    private JButton removeButton;
    private JPanel buttonPanel;
    private Vector rowData;
    private Vector columns;
    private Vector rows;
    Localiser localiser = null;
    TableColumn myColumn;
    TableColumn myColumn1;
    JComboBox comboBox1;
    DefaultTableCellRenderer renderer1;

    public BlackListPanel(SVGTConverterController parent, Localiser localiser) {
        this.myController = parent;
        try {
            this.localiser = localiser;
            this.createPanel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createPanel() throws Exception {
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), this.localiser.getText("BlackList.Title"));
        this.blackListpanel = new JPanel();
        this.blackListpanel.setLayout(new BorderLayout());
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.setBorder(this.titledBorder2);
        this.columns = new Vector();
        this.columns.add(this.localiser.getText("BlackList.table.column1"));
        this.columns.add(this.localiser.getText("BlackList.table.column2"));
        this.columns.add(this.localiser.getText("BlackList.table.column3"));
        this.dtm = new DefaultTableModel();
        this.dtm.setDataVector(null, this.columns);
        this.blackListTable = new JTable(this.dtm);
        this.blackListTable.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                System.out.println(e.getKeyCode());
                if (e.getKeyCode() == 127) {
                    BlackListPanel.this.dtm.removeRow(BlackListPanel.this.blackListTable.getSelectedRow());
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.blackListTable.getTableHeader().setReorderingAllowed(false);
        BlackListAnalyzer analiser = (BlackListAnalyzer)ServiceRegistry.getService("com.nokia.svg2svgt.converter.BlackListAnalyzer");
        ArrayList allmodules = analiser.getBlackListModules();
        System.out.println(allmodules.size());
        SVGModule module = null;
        SVGElement element = null;
        JComboBox<String> combox = new JComboBox<String>();
        int i = 0;
        while (i < allmodules.size()) {
            module = (SVGModule)allmodules.get(i);
            ArrayList allelements = module.getModuleElements();
            if (allelements != null) {
                int j = 0;
                while (j < allelements.size()) {
                    element = (SVGElement)allelements.get(j);
                    combox.insertItemAt(element.getElementName(), j);
                    ArrayList allattributes = element.getElementAttributes();
                    if (allattributes == null) {
                        Vector<String> elem = new Vector<String>();
                        elem.add(element.getElementName());
                        elem.add("      -  ");
                        elem.add("      -  ");
                        this.dtm.addRow(elem);
                    } else {
                        int k = 0;
                        while (k < allattributes.size()) {
                            SVGAttribute attribute = (SVGAttribute)allattributes.get(k);
                            Vector<Object> rowdata = new Vector<Object>();
                            rowdata.add(element.getElementName());
                            rowdata.add(attribute.getAttributeName());
                            if (attribute.getAttributeValue() == null) {
                                rowdata.add("      -   ");
                            } else {
                                rowdata.add(attribute.getAttributeValue());
                            }
                            this.dtm.addRow(rowdata);
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        TableColumnModel tm = this.blackListTable.getColumnModel();
        int cols = tm.getColumnCount();
        TableColumn c1 = tm.getColumn(0);
        TableColumn c2 = tm.getColumn(1);
        this.scroll = new JScrollPane();
        this.scroll.getViewport().add(this.blackListTable);
        this.tablePanel.add(this.scroll);
        this.blackListpanel.add((Component)this.tablePanel, "Center");
        this.blackListpanel.setPreferredSize(new Dimension(414, 327));
        this.add(this.blackListpanel);
    }
}

