/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.converter.SVGAttribute;
import com.nokia.svg2svgt.converter.SVGElement;
import java.util.ArrayList;
import java.util.Iterator;

public class SVGModule {
    private ArrayList myElements = null;
    private String myName = null;

    public SVGModule(String moduleName) {
        this.myName = moduleName;
    }

    public void addElement(SVGElement element) {
        if (this.myElements == null) {
            this.myElements = new ArrayList();
        }
        if (element != null) {
            this.myElements.add(element);
        }
    }

    public void addElements(ArrayList elementList) {
        if (this.myElements == null) {
            this.myElements = new ArrayList();
        }
        if (elementList != null || elementList.size() > 0) {
            this.myElements.addAll(elementList);
        }
    }

    public void removeElement(String elementName) {
        int elementIndex = this.containsElement(elementName);
        if (-1 != elementIndex) {
            this.myElements.remove(elementIndex);
        }
    }

    public String getModuleName() {
        return this.myName;
    }

    public ArrayList getModuleElements() {
        return this.myElements;
    }

    public int containsElement(String elementName) {
        if (this.myElements == null) {
            return -1;
        }
        Iterator iter = this.myElements.iterator();
        SVGElement element = null;
        int indexCount = 0;
        while (iter.hasNext()) {
            element = (SVGElement)iter.next();
            if (element.getElementName().equalsIgnoreCase(elementName)) {
                return indexCount;
            }
            ++indexCount;
        }
        return -1;
    }

    public SVGAttribute getAttributeByTagName(String attrName) {
        if (this.myElements == null) {
            return null;
        }
        Iterator iter = this.myElements.iterator();
        SVGElement element = null;
        boolean indexCount = false;
        while (iter.hasNext()) {
            element = (SVGElement)iter.next();
            int attrIndex = element.containsAttribute(attrName);
            if (-1 == attrIndex) continue;
            return element.getAttributeAt(attrIndex);
        }
        return null;
    }

    public SVGElement getElementByTagName(String elemName) {
        int elementIndex = this.containsElement(elemName);
        if (-1 != elementIndex) {
            return (SVGElement)this.myElements.get(elementIndex);
        }
        return null;
    }

    public SVGElement getElementContainingAttribute(String attrName) {
        if (this.myElements == null) {
            return null;
        }
        Iterator iter = this.myElements.iterator();
        SVGElement element = null;
        while (iter.hasNext()) {
            element = (SVGElement)iter.next();
            int attrIndex = element.containsAttribute(attrName);
            if (-1 == attrIndex) continue;
            return element;
        }
        return null;
    }

    public String toString() {
        return this.myName;
    }

    public static void main(String[] args) {
    }
}

