/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.ServiceRegistry;
import com.nokia.svg2svgt.configuration.Configuration;
import com.nokia.svg2svgt.configuration.ConfigurationManager;
import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.converter.Conversions;
import com.nokia.svg2svgt.converter.ConversionsFactory;
import com.nokia.svg2svgt.converter.GradientDefinitionMerger;
import com.nokia.svg2svgt.converter.NameSpaceAnalyzer;
import com.nokia.svg2svgt.converter.NameSpaceRemover;
import com.nokia.svg2svgt.converter.NonReferredIdRemover;
import com.nokia.svg2svgt.converter.SVGNameSpace;
import com.nokia.svg2svgt.gui.SVGTConverterController;
import com.nokia.svg2svgt.gui.SVGTFileChooser;
import com.nokia.svg2svgt.log.LogListener;
import com.nokia.svg2svgt.log.LogMessages;
import com.nokia.svg2svgt.log.Logger;
import com.nokia.svg2svgt.util.XMLFileParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SVG2SVGTConverter
implements ConversionConstants,
Logger {
    private ArrayList myLogListenersList = new ArrayList();
    private Hashtable myConversionsInfo = new Hashtable();
    private Hashtable myConfigParams = new Hashtable();
    private Document mySVGTDoc = null;
    private NameSpaceAnalyzer myNameSpaceAnalyzer = null;
    private static Hashtable myNameSpaceData = new Hashtable();
    private Stack myParentNSStack = new Stack();
    public static String[] exceptionMessage = new String[8];

    public SVG2SVGTConverter(Hashtable configurationParams) {
        this.myConfigParams = configurationParams;
        if (configurationParams != null) {
            String conversionsFileName = (String)configurationParams.get("-convfile");
            ConfigurationManager confMgr = new ConfigurationManager(conversionsFileName);
            Configuration conf = confMgr.getConfiguration();
            Hashtable confData = conf.toHash();
            Enumeration enum1 = confData.keys();
            String key = null;
            String keyValue = null;
            while (enum1.hasMoreElements()) {
                Conversions instance;
                key = (String)enum1.nextElement();
                keyValue = (String)confData.get(key);
                if (keyValue == null || (instance = ConversionsFactory.getConversionsInstance(keyValue)) == null) continue;
                this.myConversionsInfo.put(key, instance);
            }
            String fileName = (String)configurationParams.get("-p");
            try {
                this.myNameSpaceAnalyzer = new NameSpaceAnalyzer(fileName, this);
                ServiceRegistry.registerService(this.myNameSpaceAnalyzer);
            }
            catch (FactoryConfigurationError fcerror) {
                this.logEvent(2900L, new String[]{fileName, fcerror.getMessage()});
                this.myNameSpaceAnalyzer = null;
            }
            catch (ParserConfigurationException pcex) {
                this.logEvent(2900L, new String[]{fileName, pcex.getMessage()});
                this.myNameSpaceAnalyzer = null;
            }
            catch (IOException iex) {
                this.logEvent(2900L, new String[]{fileName, iex.getMessage()});
                this.myNameSpaceAnalyzer = null;
            }
            catch (SAXException saxex) {
                this.logEvent(2900L, new String[]{fileName, saxex.getMessage()});
                this.myNameSpaceAnalyzer = null;
            }
            catch (IllegalArgumentException iaex) {
                this.logEvent(2900L, new String[]{fileName, iaex.getMessage()});
                this.myNameSpaceAnalyzer = null;
            }
            catch (Exception ex) {
                this.logEvent(2900L, new String[]{fileName, ex.getMessage()});
                this.myNameSpaceAnalyzer = null;
            }
        }
    }

    public void registerLogListener(LogListener listener) {
        if (this.myLogListenersList.contains(listener)) {
            this.myLogListenersList.remove(listener);
        }
        this.myLogListenersList.add(listener);
    }

    public void removeLogListener(LogListener listener) {
        this.myLogListenersList.remove(listener);
    }

    public void convert() {
        Document parsedDoc = null;
        ArrayList inputFileList = (ArrayList)this.myConfigParams.get("-svgfile");
        if (inputFileList == null) {
            return;
        }
        exceptionMessage = new String[8];
        int i = 0;
        while (i < inputFileList.size()) {
            block14: {
                try {
                    parsedDoc = XMLFileParser.parseFile((String)inputFileList.get(i), true);
                    this.mySVGTDoc = XMLFileParser.getEmptyDocument();
                }
                catch (FactoryConfigurationError fcerror) {
                    this.logEvent(2900L, new String[]{(String)inputFileList.get(i), fcerror.getMessage()});
                    SVG2SVGTConverter.exceptionMessage[0] = fcerror.getMessage();
                    fcerror.printStackTrace();
                    break block14;
                }
                catch (ParserConfigurationException pcex) {
                    this.logEvent(2900L, new String[]{(String)inputFileList.get(i), pcex.getMessage()});
                    SVG2SVGTConverter.exceptionMessage[1] = pcex.getMessage();
                    break block14;
                }
                catch (IOException iex) {
                    this.logEvent(2900L, new String[]{(String)inputFileList.get(i), iex.getMessage()});
                    SVG2SVGTConverter.exceptionMessage[2] = iex.getMessage();
                    break block14;
                }
                catch (SAXException saxex) {
                    this.logEvent(2900L, new String[]{(String)inputFileList.get(i), saxex.getMessage()});
                    SVG2SVGTConverter.exceptionMessage[3] = saxex.getMessage();
                    break block14;
                }
                catch (IllegalArgumentException iaex) {
                    this.logEvent(2900L, new String[]{(String)inputFileList.get(i), iaex.getMessage()});
                    SVG2SVGTConverter.exceptionMessage[4] = iaex.getMessage();
                    break block14;
                }
                try {
                    this.logEvent(3300L, new String[]{(String)inputFileList.get(i)});
                    this.convertSVGToSVGT(parsedDoc, this.mySVGTDoc);
                    this.logEvent(3400L, null);
                    this.mySVGTDoc = NameSpaceRemover.removeSVGNameSpaces(this.mySVGTDoc);
                    this.logEvent(3600L, null);
                    NonReferredIdRemover.processNonReferencedIDs(this.mySVGTDoc, this);
                    this.logEvent(3700L, null);
                    GradientDefinitionMerger.mergeGradientDefinitions(this.mySVGTDoc, this);
                    this.logEvent(3800L, null);
                    if (this.mySVGTDoc.getDocumentElement() != null) {
                        this.removeEmptyNodes(this.mySVGTDoc.getDocumentElement());
                    }
                    this.saveSVGTFile(this.mySVGTDoc, (String)inputFileList.get(i));
                }
                catch (DOMException domex) {
                    this.logEvent(3000L, new String[]{(String)inputFileList.get(i), domex.getMessage()});
                    domex.printStackTrace();
                    parsedDoc = null;
                    this.mySVGTDoc = null;
                    SVG2SVGTConverter.exceptionMessage[4] = domex.getMessage();
                    break block14;
                }
                catch (TransformerFactoryConfigurationError tfce) {
                    SVG2SVGTConverter.exceptionMessage[5] = tfce.getMessage();
                    break block14;
                }
                catch (TransformerConfigurationException tcex) {
                    SVG2SVGTConverter.exceptionMessage[6] = tcex.getMessage();
                    break block14;
                }
                catch (TransformerException tex) {
                    SVG2SVGTConverter.exceptionMessage[7] = tex.getMessage();
                    break block14;
                }
                parsedDoc = null;
                this.mySVGTDoc = null;
            }
            ++i;
        }
    }

    private void readAllNameSpacesUsed(Document parsedDoc) {
        Element rootElement = parsedDoc.getDocumentElement();
        ArrayList nsNames = this.myNameSpaceAnalyzer.getNSInPassThrough();
        Iterator iter = nsNames.iterator();
        SVGNameSpace svgNS = null;
        while (iter.hasNext()) {
            svgNS = (SVGNameSpace)iter.next();
            if (svgNS.getMyUri() == null) continue;
            myNameSpaceData.put(svgNS.getMyUri(), new ArrayList());
        }
        this.traverseNode(rootElement);
    }

    private void traverseNode(Node svgNode) throws DOMException {
        int i;
        NamedNodeMap attributeNodes = null;
        if (svgNode == null) {
            return;
        }
        Node node = null;
        String nodeName = null;
        String nodeValue = null;
        if (svgNode.hasAttributes()) {
            attributeNodes = svgNode.getAttributes();
            SVGNameSpace svgNS = null;
            i = 0;
            while (i < attributeNodes.getLength()) {
                node = attributeNodes.item(i);
                nodeName = node.getNodeName();
                if (nodeName.startsWith("xmlns") && -1 != nodeName.indexOf(":")) {
                    String nsVariable = nodeName.substring("xmlns".length() + 1, nodeName.length());
                    nodeValue = node.getNodeValue();
                    svgNS = this.getSVGNameSpace(nodeValue);
                    if (svgNS != null) {
                        ((ArrayList)myNameSpaceData.get(svgNS.getMyUri())).add(nsVariable);
                    }
                }
                ++i;
            }
        }
        NodeList childNodes = null;
        if (svgNode.hasChildNodes()) {
            childNodes = svgNode.getChildNodes();
            i = 0;
            while (i < childNodes.getLength()) {
                node = childNodes.item(i);
                if (1 == node.getNodeType()) {
                    this.traverseNode(node);
                }
                ++i;
            }
        }
    }

    private SVGNameSpace getSVGNameSpace(String nodeValue) {
        SVGNameSpace svgNS = null;
        ArrayList nsList = this.myNameSpaceAnalyzer.getNSInPassThrough();
        String url = null;
        if (nsList != null) {
            int i = 0;
            while (i < nsList.size()) {
                svgNS = (SVGNameSpace)nsList.get(i);
                url = svgNS.getMyUri();
                if (url != null && url.length() != 0 && (svgNS.isURI() ? url.equals(nodeValue) : -1 != nodeValue.indexOf(url))) {
                    return svgNS;
                }
                ++i;
            }
        }
        return null;
    }

    private void removeEmptyNodes(Node node) {
        block6: {
            block5: {
                if (node.getNodeName().equalsIgnoreCase("svg")) break block5;
                if (!node.hasAttributes() && !this.isHavingChildNodes(node)) {
                    Node parentNode = node.getParentNode();
                    parentNode.removeChild(node);
                }
                if (!node.hasChildNodes()) break block6;
                NodeList childNodes = node.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    if (1 == childNodes.item(i).getNodeType()) {
                        this.removeEmptyNodes(childNodes.item(i));
                    }
                    ++i;
                }
                break block6;
            }
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                if (1 == childNodes.item(i).getNodeType()) {
                    this.removeEmptyNodes(childNodes.item(i));
                }
                ++i;
            }
        }
    }

    private boolean isHavingChildNodes(Node node) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> tempList = new ArrayList<Node>();
        if (nodeList == null) {
            return false;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Node tempNode = nodeList.item(i);
            if (1 != tempNode.getNodeType()) {
                String value = tempNode.getNodeValue();
                if (value != null && value.trim().length() > 0) {
                    tempList.add(tempNode);
                }
            } else {
                tempList.add(tempNode);
            }
            ++i;
        }
        return tempList.size() != 0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void convertSVGToSVGT(Document svgDoc, Document svgtDoc) throws DOMException {
        block35: {
            isDefaultNS = false;
            this.readAllNameSpacesUsed(svgDoc);
            attributeNode = null;
            rootElement = svgDoc.getDocumentElement();
            isDefaultNS = this.setParentNameSpace(rootElement);
            nsName = null;
            nsURL = null;
            nodeName = null;
            nodeName = rootElement.getNodeName();
            index = nodeName.indexOf(":");
            if (-1 != index) {
                nsName = nodeName.substring(0, index);
                nodeName = nodeName.substring(index + 1, nodeName.length());
            }
            if (!this.checkNodeInPassThroughList(nsName, nsURL, nodeName, (short)1)) {
                return;
            }
            if (this.myNameSpaceAnalyzer.isWarningTag(nsName, nsURL, nodeName, (short)1)) {
                this.logWarning(2800L, new String[]{nodeName});
            }
            svgtRootElem = svgtDoc.createElement(rootElement.getNodeName());
            svgtDoc.appendChild(svgtRootElem);
            attrName = null;
            if (nodeName.equals("svg")) {
                attrName = nsName != null ? String.valueOf(nsName) + ":" + "baseProfile" : "baseProfile";
                baseProfileAttribute = svgtDoc.createAttribute(attrName);
                baseProfileAttribute.setValue("tiny");
                svgtRootElem.setAttributeNode(baseProfileAttribute);
            }
            if (!rootElement.hasAttributes()) break block35;
            attributeNode = rootElement.getAttributes();
            attrNode = null;
            i = 0;
            while (i < attributeNode.getLength()) {
                block38: {
                    block42: {
                        block41: {
                            block40: {
                                block36: {
                                    block39: {
                                        block37: {
                                            attrNode = attributeNode.item(i);
                                            nodeName = attrNode.getNodeName();
                                            if (!nodeName.startsWith("xmlns")) break block36;
                                            if (!nodeName.endsWith("xlink") && !nodeName.startsWith("xlink")) break block37;
                                            svgtAttr = svgtDoc.importNode(attrNode, false);
                                            svgtRootElem.setAttributeNode((Attr)svgtAttr);
                                            break block38;
                                        }
                                        index = nodeName.indexOf(":");
                                        tempNS = null;
                                        if (-1 != index) {
                                            tempNS = nodeName.substring(index + 1, nodeName.length());
                                        }
                                        if (tempNS == null || tempNS.equals(nsName)) break block39;
                                        tempNodeName = nodeName.substring(index + 1, nodeName.length());
                                        if (!this.checkNodeInPassThroughList(tempNS, attrNode.getNodeValue(), tempNodeName, (short)2)) break block38;
                                    }
                                    svgtAttr = svgtDoc.importNode(attrNode, false);
                                    svgtRootElem.setAttributeNode((Attr)svgtAttr);
                                    break block38;
                                }
                                if (!nodeName.equalsIgnoreCase("width") && !nodeName.equalsIgnoreCase("height")) break block40;
                                value /* !! */  = null;
                                bundle = ResourceBundle.getBundle("SVG2SVGTProperties");
                                try {
                                    value /* !! */  = bundle.getString("OVERWRITE_DIMENSION");
                                }
                                catch (MissingResourceException var16_19) {
                                    // empty catch block
                                }
                                if (this.myConfigParams.containsKey("-d")) {
                                    tempString = (String)this.myConfigParams.get("-d");
                                    value /* !! */  = tempString.equalsIgnoreCase("normal") != false ? null : tempString;
                                }
                                if (value /* !! */  != null && value /* !! */ .length() > 0) {
                                    svgtAttr = svgtDoc.createAttribute(nodeName);
                                    svgtAttr.setValue(value /* !! */ .trim());
                                    svgtRootElem.setAttributeNode(svgtAttr);
                                } else {
                                    svgtAttr = svgtDoc.createAttribute(nodeName);
                                    svgtAttr.setValue(((Attr)attrNode).getValue());
                                    svgtRootElem.setAttributeNode(svgtAttr);
                                }
                                break block38;
                            }
                            nsName = null;
                            nsURL = null;
                            index = nodeName.indexOf(":");
                            if (-1 != index) {
                                nsName = nodeName.substring(0, index);
                                nodeName = nodeName.substring(index + 1, nodeName.length());
                            }
                            if (nsName == null) break block41;
                            if (this.checkNSNameInCurrentDoc(nsName) || this.myNameSpaceAnalyzer.isNameSpacePresent(nsName)) break block42;
                            break block38;
                        }
                        temp = (Node)this.getParentNameSpace();
                        if (temp != null) {
                            nsURL = temp.getNodeValue();
                        }
                    }
                    if (this.isConversionsRequired(nodeName)) {
                        this.logEvent(2600L, new String[]{nodeName});
                        this.processConversions(attrNode, svgDoc, svgtRootElem, svgtDoc, nsURL);
                    } else if (this.checkNodeInPassThroughList(nsName, nsURL, nodeName, (short)2)) {
                        if (this.myNameSpaceAnalyzer.isWarningTag(nsName, nsURL, nodeName, (short)2)) {
                            this.logWarning(2800L, new String[]{nodeName});
                        }
                        svgtAttr = svgtDoc.importNode(attrNode, false);
                        svgtRootElem.setAttributeNode((Attr)svgtAttr);
                    }
                }
                ++i;
            }
        }
        childNodes = rootElement.getChildNodes();
        node = null;
        i = 0;
        while (i < childNodes.getLength()) {
            node = childNodes.item(i);
            nodeName = node.getNodeName();
            nsName = null;
            nsURL = null;
            index = nodeName.indexOf(":");
            if (-1 == index) ** GOTO lbl-1000
            nsName = nodeName.substring(0, index);
            nodeName = nodeName.substring(index + 1, nodeName.length());
            if (!this.checkNSNameInCurrentDoc(nsName) && !this.myNameSpaceAnalyzer.isNameSpacePresent(nsName)) {
                isDefaultNS = false;
            } else if (1 != node.getNodeType() || nodeName.equalsIgnoreCase("svg")) {
                if (3 == node.getNodeType() && (textValue = node.getNodeValue()) != null && textValue.trim().length() > 0) {
                    textNode = svgtDoc.createTextNode(textValue);
                    svgtRootElem.appendChild(textNode);
                }
            } else {
                isDefaultNS = this.setParentNameSpace((Element)node);
                if (nsName == null && (temp = (Node)this.getParentNameSpace()) != null) {
                    nsURL = temp.getNodeValue();
                }
                if (this.isConversionsRequired(nodeName)) {
                    this.logEvent(2600L, new String[]{nodeName});
                    this.processConversions(node, svgDoc, svgtRootElem, svgtDoc, nsURL);
                    if (isDefaultNS) {
                        this.myParentNSStack.pop();
                    }
                } else if (!this.checkNodeInPassThroughList(nsName, nsURL, nodeName, (short)1)) {
                    if (isDefaultNS) {
                        this.myParentNSStack.pop();
                    }
                } else {
                    if (this.myNameSpaceAnalyzer.isWarningTag(nsName, nsURL, nodeName, (short)1)) {
                        this.logWarning(2800L, new String[]{nodeName});
                    }
                    parentSVGTNode /* !! */  = null;
                    parentSVGTNode /* !! */  = svgtDoc.createElement(node.getNodeName());
                    parentSVGTNode /* !! */  = svgtRootElem.appendChild(parentSVGTNode /* !! */ );
                    this.traverseNode(node, svgDoc, parentSVGTNode /* !! */ , svgtDoc, isDefaultNS);
                    if (isDefaultNS) {
                        this.myParentNSStack.pop();
                    }
                }
            }
            ++i;
        }
        if (isDefaultNS) {
            this.myParentNSStack.pop();
        }
    }

    private boolean checkNSNameInCurrentDoc(String nsName) {
        Enumeration enum1 = myNameSpaceData.keys();
        ArrayList nsList = null;
        while (enum1.hasMoreElements()) {
            nsList = (ArrayList)myNameSpaceData.get((String)enum1.nextElement());
            if (!nsList.contains(nsName)) continue;
            return true;
        }
        return false;
    }

    public static Hashtable getNSInCurrentDoc() {
        return myNameSpaceData;
    }

    private Object getParentNameSpace() {
        if (this.myParentNSStack.size() != 0) {
            return this.myParentNSStack.peek();
        }
        return null;
    }

    private boolean setParentNameSpace(Element elemNode) {
        Attr attribute = null;
        String nsReference = null;
        String elemName = elemNode.getNodeName();
        if (-1 == elemName.indexOf(":")) {
            attribute = elemNode.getAttributeNode("xmlns");
            if (attribute != null) {
                this.myParentNSStack.push(attribute);
                return true;
            }
        } else {
            int indexOfColon = elemName.indexOf(":");
            nsReference = elemName.substring(0, indexOfColon);
            attribute = elemNode.getAttributeNode("xmlns:" + nsReference);
            if (attribute != null) {
                this.myParentNSStack.push(attribute);
                return true;
            }
        }
        return false;
    }

    private Document createDOCTYPEElement(Document svgDoc, Document svgtDoc) {
        DOMImplementation domImpl = svgtDoc.getImplementation();
        DocumentType docType = svgDoc.getDoctype();
        DocumentType svgtDocType = null;
        String docTypeName = null;
        docTypeName = docType == null ? "svg" : docType.getName();
        svgtDocType = domImpl.createDocumentType(docTypeName, "-//W3C//DTD SVG 1.1 Tiny//EN", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-tiny.dtd");
        svgtDoc = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", svgtDocType);
        return svgtDoc;
    }

    private boolean checkNodeInPassThroughList(String nsName, String nsURL, String nodeName, short nodeType) {
        boolean isAllowedTag = false;
        if (this.myNameSpaceAnalyzer != null) {
            isAllowedTag = this.myNameSpaceAnalyzer.isNodeAllowed(nsName, nsURL, nodeName, nodeType);
        }
        return isAllowedTag;
    }

    private boolean isConversionsRequired(String attrName) {
        return this.myConversionsInfo.containsKey(attrName);
    }

    private void traverseNode(Node svgNode, Document svgDoc, Node svgtNode, Document svgtDoc, boolean isDefaultNS) throws DOMException {
        int index;
        String nsURL;
        String nodeName;
        String nsName;
        Node node;
        block24: {
            NamedNodeMap nodeMap = null;
            node = null;
            nsName = null;
            nodeName = null;
            nsURL = null;
            index = -1;
            if (!svgNode.hasAttributes()) break block24;
            nodeMap = svgNode.getAttributes();
            int i = 0;
            while (i < nodeMap.getLength()) {
                block27: {
                    Node svgtAttr;
                    block30: {
                        block29: {
                            block28: {
                                block25: {
                                    block26: {
                                        node = nodeMap.item(i);
                                        nodeName = node.getNodeName();
                                        if (!nodeName.startsWith("xmlns")) break block25;
                                        index = nodeName.indexOf(":");
                                        String tempNS = null;
                                        if (-1 != index) {
                                            tempNS = nodeName.substring(index + 1, nodeName.length());
                                        }
                                        if (tempNS == null || tempNS.equalsIgnoreCase(nsName)) break block26;
                                        String tempNodeName = nodeName.substring(index + 1, nodeName.length());
                                        if (!this.checkNodeInPassThroughList(tempNS, node.getNodeValue(), tempNodeName, (short)2)) break block27;
                                    }
                                    svgtAttr = svgtDoc.importNode(node, false);
                                    ((Element)svgtNode).setAttributeNode((Attr)svgtAttr);
                                    break block27;
                                }
                                if (!nodeName.startsWith("xlink")) break block28;
                                Node svgtAttr2 = svgtDoc.importNode(node, false);
                                ((Element)svgtNode).setAttributeNode((Attr)svgtAttr2);
                                break block27;
                            }
                            nsName = null;
                            nsURL = null;
                            index = nodeName.indexOf(":");
                            if (-1 != index) {
                                nsName = nodeName.substring(0, index);
                                nodeName = nodeName.substring(index + 1, nodeName.length());
                            }
                            if (nsName == null) break block29;
                            if (this.checkNSNameInCurrentDoc(nsName) || this.myNameSpaceAnalyzer.isNameSpacePresent(nsName)) break block30;
                            break block27;
                        }
                        Node temp = (Node)this.getParentNameSpace();
                        if (temp != null) {
                            nsURL = temp.getNodeValue();
                        }
                    }
                    if (this.isConversionsRequired(nodeName)) {
                        this.logEvent(2600L, new String[]{nodeName});
                        this.processConversions(node, svgDoc, svgtNode, svgtDoc, nsURL);
                    } else if (this.checkNodeInPassThroughList(nsName, nsURL, nodeName, (short)2)) {
                        if (this.myNameSpaceAnalyzer.isWarningTag(nsName, nsURL, nodeName, (short)2)) {
                            this.logWarning(2800L, new String[]{nodeName});
                        }
                        Element parentSVGTNode = (Element)svgtNode;
                        svgtAttr = svgtDoc.importNode(node, false);
                        parentSVGTNode.setAttributeNode((Attr)svgtAttr);
                    }
                }
                ++i;
            }
        }
        if (!svgNode.hasChildNodes()) {
            return;
        }
        NodeList childNodes = svgNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            block32: {
                block34: {
                    block33: {
                        block31: {
                            String textValue;
                            node = childNodes.item(i);
                            nodeName = node.getNodeName();
                            index = nodeName.indexOf(":");
                            nsName = null;
                            nsURL = null;
                            if (-1 != index) {
                                nsName = nodeName.substring(0, index);
                                nodeName = nodeName.substring(index + 1, nodeName.length());
                            }
                            if (1 == node.getNodeType()) break block31;
                            if (3 == node.getNodeType() && (textValue = node.getNodeValue()) != null && textValue.trim().length() > 0) {
                                Text textNode = svgtDoc.createTextNode(textValue);
                                svgtNode.appendChild(textNode);
                            }
                            break block32;
                        }
                        isDefaultNS = this.setParentNameSpace((Element)node);
                        if (nsName == null) break block33;
                        if (this.checkNSNameInCurrentDoc(nsName) || this.myNameSpaceAnalyzer.isNameSpacePresent(nsName)) break block34;
                        if (isDefaultNS) {
                            this.myParentNSStack.pop();
                        }
                        break block32;
                    }
                    Node temp = (Node)this.getParentNameSpace();
                    if (temp != null) {
                        nsURL = temp.getNodeValue();
                    }
                }
                if (this.isConversionsRequired(nodeName)) {
                    this.logEvent(2600L, new String[]{nodeName});
                    this.processConversions(node, svgDoc, svgtNode, svgtDoc, nsURL);
                    if (isDefaultNS) {
                        this.myParentNSStack.pop();
                    }
                } else if (!this.checkNodeInPassThroughList(nsName, nsURL, nodeName, (short)1)) {
                    if (isDefaultNS) {
                        this.myParentNSStack.pop();
                    }
                } else {
                    if (this.myNameSpaceAnalyzer.isWarningTag(nsName, nsURL, nodeName, (short)1)) {
                        this.logWarning(2800L, new String[]{nodeName});
                    }
                    Element parentSVGTNode = null;
                    parentSVGTNode = svgtDoc.createElement(node.getNodeName());
                    parentSVGTNode = (Element)svgtNode.appendChild(parentSVGTNode);
                    this.traverseNode(node, svgDoc, parentSVGTNode, svgtDoc, isDefaultNS);
                    if (isDefaultNS) {
                        this.myParentNSStack.pop();
                    }
                }
            }
            ++i;
        }
    }

    private void doConversions(Node svgNode, Document svgDoc, Node svgtNode, Document svgtDoc, String nsURL) throws DOMException {
        String nodeName = svgNode.getNodeName();
        Conversions conv = (Conversions)this.myConversionsInfo.get(nodeName);
        conv.doConversion(svgNode, svgDoc, svgtNode, svgtDoc, this, nsURL);
    }

    private void processConversions(Node svgNode, Document svgDoc, Node svgtNode, Document svgtDoc, String nsURL) throws DOMException {
        this.doConversions(svgNode, svgDoc, svgtNode, svgtDoc, nsURL);
    }

    private void saveSVGTFile(Document svgtDoc, String fileName) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        File createDir;
        String outputDirectory = (String)this.myConfigParams.get("-o");
        File outDir = new File(outputDirectory);
        if (!outDir.isDirectory()) {
            boolean bl = outDir.mkdir();
        }
        fileName = this.getFileName(fileName);
        File[] filesList = outDir.listFiles();
        ArrayList<String> fileNamesList = null;
        String name = null;
        if (filesList != null) {
            fileNamesList = new ArrayList<String>(filesList.length);
            int i = 0;
            while (i < filesList.length) {
                fileNamesList.add(filesList[i].getName());
                ++i;
            }
        }
        int count = 1;
        int index = fileName.indexOf(".");
        name = fileName.substring(0, index);
        String extension = fileName.substring(index, fileName.length());
        while (this.doesFileNameExist(fileNamesList, fileName)) {
            fileName = String.valueOf(name) + "_" + count + extension;
            ++count;
        }
        this.logEvent(3500L, new String[]{fileName, outputDirectory});
        fileName = String.valueOf(outputDirectory) + System.getProperty("file.separator") + fileName;
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "-//W3C//DTD SVG 1.1 Tiny//EN");
        transformer.setOutputProperty("doctype-system", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-tiny.dtd");
        DOMSource source = new DOMSource(svgtDoc);
        File outFile = new File(fileName);
        FileWriter fr = null;
        if (fileName.indexOf(outputDirectory) != -1) {
            String subString = fileName.substring(fileName.indexOf(outputDirectory) + outputDirectory.length(), fileName.length());
            subString = subString.substring(0, subString.lastIndexOf(File.separator));
            StringTokenizer tok = new StringTokenizer(subString, File.separator);
            String dir = outputDirectory;
            File temp = null;
            while (tok.hasMoreElements()) {
                temp = new File(dir = String.valueOf(dir) + File.separator + tok.nextToken());
                if (temp.isDirectory()) continue;
                temp.mkdir();
            }
        }
        if (!(createDir = outFile.getParentFile()).exists()) {
            createDir.mkdir();
        }
        try {
            fr = new FileWriter(fileName);
            outFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StreamResult result = new StreamResult(fr);
        transformer.transform(source, result);
        try {
            float size = Float.parseFloat((String)this.myConfigParams.get("CriticalFileSize"));
            long fileSize = outFile.length();
            float fileSize1 = fileSize / 1024L;
            if (size <= fileSize1) {
                this.logWarning(4100L, null);
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "Only numeric values are allowed. Neglecting the critical size.");
        }
        try {
            fr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getFileName(String absoluteName) {
        String requiredString = " ";
        SVGTFileChooser chooser = (SVGTFileChooser)ServiceRegistry.getService("com.nokia.svg2svgt.gui.SVGTFileChooser");
        if (chooser != null) {
            String parentDir = chooser.getMyParentDirectory();
            if (chooser.isMaintainFolderStrucSelected()) {
                requiredString = absoluteName.substring(parentDir.length() + File.separator.length(), absoluteName.length());
                return requiredString;
            }
            int index = absoluteName.lastIndexOf(System.getProperty("file.separator"));
            return absoluteName.substring(index + 1, absoluteName.length());
        }
        int index = absoluteName.lastIndexOf(System.getProperty("file.separator"));
        return absoluteName.substring(index + 1, absoluteName.length());
    }

    private boolean doesFileNameExist(ArrayList filesList, String fileName) {
        boolean isAlreadyExisting = false;
        if (filesList != null) {
            int i = 0;
            while (i < filesList.size()) {
                if (((String)filesList.get(i)).equalsIgnoreCase(fileName)) {
                    isAlreadyExisting = true;
                }
                ++i;
            }
        }
        return isAlreadyExisting;
    }

    private void notifyLogListeners(String desc) {
        if (this.myLogListenersList != null) {
            for (SVGTConverterController listener : this.myLogListenersList) {
                listener.log(desc);
            }
        }
    }

    public void logEvent(long errorCode, Object[] params) {
        String desc = null;
        desc = params != null ? LogMessages.getLogMessage(errorCode, params) : LogMessages.getLogMessage(errorCode);
        this.notifyLogListeners(desc);
    }

    public void logWarning(long errorCode, Object[] params) {
        String desc = "Warning: ";
        desc = params != null ? String.valueOf(desc) + LogMessages.getLogMessage(errorCode, params) : String.valueOf(desc) + LogMessages.getLogMessage(errorCode);
        this.notifyLogListeners(desc);
    }

    public static void main(String[] args) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ArrayList<String> al = new ArrayList<String>();
        al.add(new String("C:\\SVG\\qgn_prop_nrtyp_pager.svg"));
        ht.put("-svgfile", al);
        ht.put("-convfile", ".\\config\\Conversions.properties");
        ht.put("PassThroughFileName", ".\\config\\passThrough.xml");
        SVG2SVGTConverter converter = new SVG2SVGTConverter(ht);
        converter.convert();
    }
}

