/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.MessagesService;

import java.util.Enumeration;
import java.util.Hashtable;

public class AccessPointFieldConstants {
    public static final int BEARER_DATA_CALL_CSD = 1;
    public static final int BEARER_PACKET_DATA_GPRS = 2;
    public static final int BEARER_DATA_CALL_HSCSD = 4;
    public static final int BEARER_PACKET_DATA_CDMA = 16;
    public static final int BEARER_WLAN = 32;
    public static final byte ACCESS_POINT_NAME = 58;
    public static final byte USERNAME = 23;
    public static final byte PROMPT_PASSWORD = 29;
    public static final byte PASSWORD = 24;
    public static final byte PASSWORD_AUTH = 46;
    public static final byte START_PAGE = 3;
    public static final byte IP_ADDRESS = 38;
    public static final byte PRIMARY_DNS = 42;
    public static final byte SECONDARY_DNS = 43;
    public static final byte PROXY_ADDRESS = 91;
    public static final byte PROXY_PORT = 93;
    public static final byte WLAN_NETWORK_NAME = -93;
    public static final byte WLAN_NETWORK_MODE = -92;
    public static final byte WLAN_SECURITY_MODE = -91;
    public static final byte PRIMARY_DNS_IPV6 = 104;
    public static final byte SECONDARY_DNS_IPV6 = 105;
    public static final byte ACCESS_NUMBER = 18;
    public static final byte DATA_CALL_TYPE = 50;
    public static final byte CONNECTION_SPEED = 49;
    public static final byte CALL_BACK = 33;
    public static final byte CALL_BACK_TYPE = 34;
    public static final byte CALL_BACK_NUMBER = 35;
    public static final byte PPP_COMPRESSION = 44;
    public static final byte USE_LOGIN = 20;
    public static final byte LOGIN_SCRIPT = 21;
    public static final byte INIT_STRING = 52;
    public static final byte NETWORK_TYPE = 59;
    public static final byte USE_ACCESS_POINT = -56;
    private static Hashtable keyMapping;

    public static Hashtable translateKeysAndValues(Hashtable input) {
        AccessPointFieldConstants.createKeyMapping();
        Hashtable<Byte, String> output = new Hashtable<Byte, String>();
        Enumeration e = input.keys();
        while (e.hasMoreElements()) {
            String keyString = (String)e.nextElement();
            String value = (String)input.remove(keyString);
            Byte keyByte = (Byte)keyMapping.get(keyString = keyString.trim().toLowerCase());
            if (keyByte == null) continue;
            switch (keyByte) {
                case 29: {
                    if ("false".equalsIgnoreCase(value)) {
                        value = "0";
                        break;
                    }
                    if (!"true".equalsIgnoreCase(value)) break;
                    value = "1";
                    break;
                }
                case 46: {
                    if ("normal".equalsIgnoreCase(value)) {
                        value = "0";
                        break;
                    }
                    if (!"secure".equalsIgnoreCase(value)) break;
                    value = "1";
                    break;
                }
                case -92: {
                    if ("adhoc".equalsIgnoreCase(value)) {
                        value = "0";
                        break;
                    }
                    if (!"infrastructure".equalsIgnoreCase(value)) break;
                    value = "1";
                    break;
                }
                case -91: {
                    if ("open".equalsIgnoreCase(value)) {
                        value = "1";
                        break;
                    }
                    if ("wep".equalsIgnoreCase(value)) {
                        value = "2";
                        break;
                    }
                    if ("802.1x".equalsIgnoreCase(value)) {
                        value = "4";
                        break;
                    }
                    if ("wpa".equalsIgnoreCase(value)) {
                        value = "8";
                        break;
                    }
                    if (!"wpa2".equalsIgnoreCase(value)) break;
                    value = "16";
                    break;
                }
                case 50: {
                    if ("analogue".equalsIgnoreCase(value)) {
                        value = "0";
                        break;
                    }
                    if ("ISDNv.110".equalsIgnoreCase(value)) {
                        value = "1";
                        break;
                    }
                    if (!"ISDNv.120".equalsIgnoreCase(value)) break;
                    value = "2";
                    break;
                }
                case 49: {
                    if ("auto".equalsIgnoreCase(value)) {
                        value = "0";
                        break;
                    }
                    if ("9600".equalsIgnoreCase(value)) {
                        value = "1";
                        break;
                    }
                    if ("14400".equalsIgnoreCase(value)) {
                        value = "2";
                        break;
                    }
                    if ("19200".equalsIgnoreCase(value)) {
                        value = "3";
                        break;
                    }
                    if ("28800".equalsIgnoreCase(value)) {
                        value = "4";
                        break;
                    }
                    if ("38400".equalsIgnoreCase(value)) {
                        value = "5";
                        break;
                    }
                    if ("43200".equalsIgnoreCase(value)) {
                        value = "6";
                        break;
                    }
                    if (!"56000".equalsIgnoreCase(value)) break;
                    value = "7";
                    break;
                }
                case 33: {
                    if ("false".equalsIgnoreCase(value)) {
                        value = "0";
                        break;
                    }
                    if (!"true".equalsIgnoreCase(value)) break;
                    value = "1";
                    break;
                }
                case 34: {
                    if ("type0".equalsIgnoreCase(value)) {
                        value = "0";
                        break;
                    }
                    if ("type1".equalsIgnoreCase(value)) {
                        value = "1";
                        break;
                    }
                    if ("type2".equalsIgnoreCase(value)) {
                        value = "2";
                        break;
                    }
                    if ("type3".equalsIgnoreCase(value)) {
                        value = "3";
                        break;
                    }
                    if ("type4".equalsIgnoreCase(value)) {
                        value = "4";
                        break;
                    }
                    if ("type5".equalsIgnoreCase(value)) {
                        value = "5";
                        break;
                    }
                    if ("require_client_number".equalsIgnoreCase(value)) {
                        value = "1001";
                        break;
                    }
                    if ("accept_server_number".equalsIgnoreCase(value)) {
                        value = "1002";
                        break;
                    }
                    if (!"override_server_number".equalsIgnoreCase(value)) break;
                    value = "1003";
                    break;
                }
                case 44: {
                    if ("false".equalsIgnoreCase(value)) {
                        value = "0";
                        break;
                    }
                    if (!"true".equalsIgnoreCase(value)) break;
                    value = "1";
                    break;
                }
                case 20: {
                    if ("false".equalsIgnoreCase(value)) {
                        value = "0";
                        break;
                    }
                    if (!"true".equalsIgnoreCase(value)) break;
                    value = "1";
                    break;
                }
                case 59: {
                    if ("ipv6".equalsIgnoreCase(value)) {
                        value = "1";
                        break;
                    }
                    if (!"ipv4".equalsIgnoreCase(value)) break;
                    value = "0";
                    break;
                }
                case -56: {
                    if ("false".equalsIgnoreCase(value)) {
                        value = "1";
                        break;
                    }
                    if (!"true".equalsIgnoreCase(value)) break;
                    value = "2";
                    break;
                }
            }
            output.put(keyByte, value);
        }
        return output;
    }

    private static synchronized void createKeyMapping() {
        if (keyMapping != null) {
            return;
        }
        keyMapping = new Hashtable();
        keyMapping.put("access_point_name", new Byte(58));
        keyMapping.put("username", new Byte(23));
        keyMapping.put("prompt_password", new Byte(29));
        keyMapping.put("password", new Byte(24));
        keyMapping.put("password_auth", new Byte(46));
        keyMapping.put("start_page", new Byte(3));
        keyMapping.put("ip_address", new Byte(38));
        keyMapping.put("primary_dns", new Byte(42));
        keyMapping.put("secondary_dns", new Byte(43));
        keyMapping.put("proxy_address", new Byte(91));
        keyMapping.put("proxy_port", new Byte(93));
        keyMapping.put("wlan_network_name", new Byte(-93));
        keyMapping.put("wlan_network_mode", new Byte(-92));
        keyMapping.put("wlan_security_mode", new Byte(-91));
        keyMapping.put("primary_dns_ipv6", new Byte(104));
        keyMapping.put("secondary_dns_ipv6", new Byte(105));
        keyMapping.put("access_number", new Byte(18));
        keyMapping.put("data_call_type", new Byte(50));
        keyMapping.put("connection_speed", new Byte(49));
        keyMapping.put("call_back", new Byte(33));
        keyMapping.put("call_back_type", new Byte(34));
        keyMapping.put("call_back_number", new Byte(35));
        keyMapping.put("ppp_compression", new Byte(44));
        keyMapping.put("use_login", new Byte(20));
        keyMapping.put("login_script", new Byte(21));
        keyMapping.put("init_string", new Byte(52));
        keyMapping.put("network_type", new Byte(59));
        keyMapping.put("use_access_point", new Byte(-56));
    }

    public static byte getBearerTypeByte(String bearerTypeString) {
        if ("csd".equals(bearerTypeString = bearerTypeString.trim().toLowerCase())) {
            return 1;
        }
        if ("gprs".equals(bearerTypeString)) {
            return 2;
        }
        if ("hscsd".equals(bearerTypeString)) {
            return 4;
        }
        if ("cdma".equals(bearerTypeString)) {
            return 16;
        }
        if ("wlan".equals(bearerTypeString)) {
            return 32;
        }
        return 0;
    }
}

