/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.jarprocessor;

import java.io.File;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.pde.internal.build.jarprocessor.AntBasedProcessorExecutor;
import org.eclipse.update.internal.jarprocessor.Main;

public class JarProcessorTask
extends Task {
    private Main.Options options = new Main.Options();
    private Properties signArgs = new Properties();
    public static final String ALIAS = "alias";
    public static final String KEYSTORE = "keystore";
    public static final String STOREPASS = "storepass";
    public static final String UNSIGN = "unsign";
    public static final String SIGN = "sign";
    private static final String FAKE_COMMAND = "fake";

    public void setAlias(String alias) {
        this.signArgs.setProperty(ALIAS, alias);
    }

    public void setKeystore(String keystore) {
        this.signArgs.setProperty(KEYSTORE, keystore);
    }

    public void setJar(File jar) {
        this.options.input = jar;
        this.options.outputDir = jar.getParentFile().getAbsolutePath();
    }

    public void setStorepass(String storepass) {
        this.signArgs.setProperty(STOREPASS, storepass);
    }

    public void setPack(boolean pack) {
        this.options.pack = pack;
    }

    public void setNormalize(boolean normalize) {
        this.options.repack = normalize;
    }

    public void setUnsign(boolean unsign) {
        if (unsign) {
            this.signArgs.put(UNSIGN, Boolean.TRUE.toString());
            this.options.signCommand = FAKE_COMMAND;
        }
    }

    public void setSign(boolean sign) {
        if (sign) {
            this.signArgs.put(SIGN, Boolean.TRUE.toString());
            this.options.signCommand = FAKE_COMMAND;
        }
    }

    private void adjustAndValidateConfiguration() {
        if (this.options.signCommand != null && this.options.pack) {
            this.options.repack = true;
        }
        if (this.options.signCommand != null && this.signArgs.getProperty(UNSIGN) == null) {
            if (this.signArgs.getProperty(ALIAS) == null) {
                throw new BuildException("Alias must be set");
            }
            if (this.signArgs.getProperty(STOREPASS) == null) {
                throw new BuildException("Storepass must be set");
            }
        }
    }

    public void execute() {
        this.options.processAll = true;
        this.adjustAndValidateConfiguration();
        new AntBasedProcessorExecutor(this.signArgs, this.getProject(), this.getTaskName()).runJarProcessor(this.options);
    }

    public void setVerbose(boolean verbose) {
        this.options.verbose = verbose;
    }
}

