/*
* Copyright (c) 2005 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

package com.nokia.sdt.sourcegen.doms.rss.dom.preprocessor;

import com.nokia.sdt.sourcegen.doms.rss.dom.IAstNode;

/**
 * An expression that represents a macro expansion.
 * These are recorded with appearances in directives 
 * as well as in source code.
 *  
 * 
 *
 */
public interface IAstPreprocessorMacroExpression extends
        IAstPreprocessorExpression {
    /** Get the macro that is referenced */
    public IMacro getMacro();

    /** Set the macro that is referenced */
    public void setMacro(IMacro macro);

    /** Get the actual parameter list
     * @return list of arguments, null for IObjectStyleMacro 
     */
    public IAstPreprocessorTextNode[] getParameters();

    /** Set the actual parameter list
     * @param expr list of arguments, may only be null for IObjectStyleMacro
     * @throws IllegalArgumentException if number of arguments does not match 
     */
    public void setParameters(IAstPreprocessorTextNode[] expr);
    
    /** Find the IAstNode(s) corresponding to this macro expansion.
     * If a node is not completely produced by a macro and it has
     * children, then only the children show up in this list.
     * Conversely, leaf nodes who are partially produced by macros
     * will show up in this list. 
     * @return an array of IAstNode (no IAstPreprocessor<i>xxx</i>)
     * whose contents are generated by this expansion (never null,
     * but may be zero-length, e.g. when used in #if)
     */
    public IAstNode[] getAstNodesProduced();
}
