/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
* The activator class controls the plug-in life cycle
*
*/
package com.nokia.carbide.cpp.internal.qt.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

import com.nokia.carbide.cdt.builder.CarbideBuilderPlugin;
import com.nokia.carbide.cdt.builder.project.ICarbideBuildConfiguration;
import com.nokia.carbide.cdt.builder.project.ICarbideProjectInfo;
import com.nokia.carbide.cdt.builder.project.ISISBuilderInfo;
import com.nokia.carbide.cdt.internal.api.builder.SISBuilderInfo2;

public class QtUIPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "com.nokia.carbide.cpp.qt.ui"; //$NON-NLS-1$

	// The shared instance
	private static QtUIPlugin plugin;
	
	/**
	 * The constructor
	 */
	public QtUIPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static QtUIPlugin getDefault() {
		return plugin;
	}

	/**
	 * Sets up the builder settings so the pkg files generated by qmake are built by
	 * the respective build configuration.
	 * @param project
	 */
	public static void setupSISBuilderSettings(IProject project) {

		// loop through the build configs and if a pkg file exists for it then
		// add it to the sis builder settings
		ICarbideProjectInfo cpi = CarbideBuilderPlugin.getBuildManager().getProjectInfo(project);
		if (cpi != null) {
			final String underscore = "_"; //$NON-NLS-1$
			
			for (ICarbideBuildConfiguration config : cpi.getBuildConfigurations()) {
				IFile file = project.getFile(project.getName() + underscore + config.getPlatformString().toLowerCase() +
						underscore + config.getTargetString().toLowerCase() + ".pkg"); //$NON-NLS-1$
				
				if (file != null && file.exists()) {
					SISBuilderInfo2 sisInfo = new SISBuilderInfo2(project);
					sisInfo.setPKGFile(file.getLocation().toOSString());
					// set to self signing
					sisInfo.setSigningType(ISISBuilderInfo.SELF_SIGN);
					config.getSISBuilderInfoList().add(sisInfo);
					config.saveConfiguration(false);
				}
			}
		}
	}
	
	public static void switchToQtPerspective() {
		// set the perspective to Qt C++
		try {
			IWorkbench workbench = getDefault().getWorkbench();
			IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
			if (activeWorkbenchWindow == null) {
				IWorkbenchWindow windows[] = workbench.getWorkbenchWindows();
				activeWorkbenchWindow = windows[0];
			}
	
			final IPerspectiveDescriptor perspective = workbench.getPerspectiveRegistry().findPerspectiveWithId("com.trolltech.qtcppproject.QtCppPerspective"); //$NON-NLS-1$
			final IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
			if (activePage != null) {
				
				UIJob job = new UIJob(""){ //$NON-NLS-1$
					public IStatus runInUIThread(IProgressMonitor monitor) {
						activePage.setPerspective(perspective);
						return Status.OK_STATUS;
					}};
				job.setSystem(true);
				job.setRule(null); // no rule needed here - could just block important jobs
				job.schedule();
			}
		} catch (IllegalStateException e) {
			// PlatformUI.getWorkbench() throws if running headless
		}
	}
}
