/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.runners.model.Statement;

public class FailOnTimeout
extends Statement {
    private Statement fNext;
    private final long fTimeout;

    public FailOnTimeout(Statement next, long timeout) {
        this.fNext = next;
        this.fTimeout = timeout;
    }

    public void evaluate() throws Throwable {
        ExecutorService service = Executors.newSingleThreadExecutor();
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    FailOnTimeout.this.fNext.evaluate();
                }
                catch (Throwable e) {
                    throw new ExecutionException(e);
                }
                return null;
            }
        };
        Future<Object> result = service.submit(callable);
        service.shutdown();
        try {
            boolean terminated = service.awaitTermination(this.fTimeout, TimeUnit.MILLISECONDS);
            if (!terminated) {
                service.shutdownNow();
            }
            result.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new Exception(String.format("test timed out after %d milliseconds", this.fTimeout));
        }
        catch (ExecutionException e) {
            throw this.unwrap(e);
        }
    }

    private Throwable unwrap(Throwable e) {
        if (e instanceof ExecutionException) {
            return this.unwrap(e.getCause());
        }
        return e;
    }
}

