/*
* Copyright (c) 2005 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

package com.nokia.sdt.scripting;

/**
 * This interface wraps an object that is generated by a script.
 * 
 *
 */
public interface IScriptObject {
    /** Get the scope defined by this object */
    public IScriptScope getScope();
    

    /** 
     * Wrap the object in a Java interface.  This returns only
     * one wrapper for a given interface.  Additionally, if multiple
     * interfaces are wrapped, they each refer to the same underlying
     * object.
     * @param iface the interface we expect the prototype to implement
     * @return a singleton wrapper for the prototype implementing iface
     * @throws ScriptException 
     */
    Object wrapObjectInInterface(Class iface) throws ScriptException;

}
