/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Script;
import org.apache.batik.svggen.font.table.ScriptRecord;

public class ScriptList {
    private int scriptCount = 0;
    private ScriptRecord[] scriptRecords;
    private Script[] scripts;

    protected ScriptList(RandomAccessFile randomAccessFile, int n) throws IOException {
        int n2;
        randomAccessFile.seek(n);
        this.scriptCount = randomAccessFile.readUnsignedShort();
        this.scriptRecords = new ScriptRecord[this.scriptCount];
        this.scripts = new Script[this.scriptCount];
        for (n2 = 0; n2 < this.scriptCount; ++n2) {
            this.scriptRecords[n2] = new ScriptRecord(randomAccessFile);
        }
        for (n2 = 0; n2 < this.scriptCount; ++n2) {
            this.scripts[n2] = new Script(randomAccessFile, n + this.scriptRecords[n2].getOffset());
        }
    }

    public int getScriptCount() {
        return this.scriptCount;
    }

    public ScriptRecord getScriptRecord(int n) {
        return this.scriptRecords[n];
    }

    public Script findScript(String string) {
        if (string.length() != 4) {
            return null;
        }
        int n = string.charAt(0) << 24 | string.charAt(1) << 16 | string.charAt(2) << 8 | string.charAt(3);
        for (int i = 0; i < this.scriptCount; ++i) {
            if (this.scriptRecords[i].getTag() != n) continue;
            return this.scripts[i];
        }
        return null;
    }
}

