/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.option;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.resource.ResourceHelper;

public abstract class OptionImpl
implements Option {
    private final int id;
    private final boolean required;
    private Option parent;

    public OptionImpl(int id, boolean required) {
        this.id = id;
        this.required = required;
    }

    public boolean canProcess(WriteableCommandLine commandLine, ListIterator arguments) {
        if (arguments.hasNext()) {
            String argument = (String)arguments.next();
            arguments.previous();
            return this.canProcess(commandLine, argument);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.appendUsage(buffer, DisplaySetting.ALL, null);
        return buffer.toString();
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object thatObj) {
        if (thatObj instanceof OptionImpl) {
            OptionImpl that = (OptionImpl)thatObj;
            return this.getId() == that.getId() && this.equals(this.getPreferredName(), that.getPreferredName()) && this.equals(this.getDescription(), that.getDescription()) && this.equals(this.getPrefixes(), that.getPrefixes()) && this.equals(this.getTriggers(), that.getTriggers());
        }
        return false;
    }

    private boolean equals(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public int hashCode() {
        int hashCode = this.getId();
        if (this.getPreferredName() != null) {
            hashCode = hashCode * 37 + this.getPreferredName().hashCode();
        }
        if (this.getDescription() != null) {
            hashCode = hashCode * 37 + this.getDescription().hashCode();
        }
        hashCode = hashCode * 37 + ((Object)this.getPrefixes()).hashCode();
        hashCode = hashCode * 37 + ((Object)this.getTriggers()).hashCode();
        return hashCode;
    }

    public Option findOption(String trigger) {
        if (this.getTriggers().contains(trigger)) {
            return this;
        }
        return null;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void defaults(WriteableCommandLine commandLine) {
    }

    public Option getParent() {
        return this.parent;
    }

    public void setParent(Option parent) {
        this.parent = parent;
    }

    protected void checkPrefixes(Set prefixes) {
        if (prefixes.isEmpty()) {
            return;
        }
        this.checkPrefix(prefixes, this.getPreferredName());
        this.getTriggers();
        Iterator i = this.getTriggers().iterator();
        while (i.hasNext()) {
            this.checkPrefix(prefixes, (String)i.next());
        }
    }

    private void checkPrefix(Set prefixes, String trigger) {
        for (String prefix : prefixes) {
            if (!trigger.startsWith(prefix)) continue;
            return;
        }
        ResourceHelper helper = ResourceHelper.getResourceHelper();
        String message = helper.getMessage("Option.trigger.needs.prefix", trigger, prefixes.toString());
        throw new IllegalArgumentException(message);
    }
}

