/*
* Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
* e32test\math\t_math2.cpp
*
*/


/**
Overview:
	Test accuracy of functions in the maths library.

API Information:
	Math. 

Details:
	- Test division and remainders of specified data is as per IEEE 754 standards.
	- Calculate sine, cosine, tangent of specified number and test its accuracy is
	  as expected.
	- Calculate exponential, Logarithm, Square root, Arctangent, Arcsine of 
	  specified number and test its accuracy is as expected.
	- Calculate the power of value raised to specified real value is as expected. 

Platforms/Drives/Compatibility:
	All 

Assumptions/Requirement/Pre-requisites:
	
Failures and causes:
	
Base Port information:
*/

#include <e32std.h>
#include <e32test.h>
#include <e32math.h>


LOCAL_D RTest test(_L("T_MATH2"));

LOCAL_D TUint32 IEEERemainderTestVectors[]=
	{
	// IEEE Remainder test vector data - 6 words per test
	// dividend high, dividend low, divisor high, divisor low, result high, result low

	// java lang spec tests
	0x7fffffff, 0xffffffff, 0x40080000, 0x00000000, 0x7fffffff, 0xffffffff,
	0x40080000, 0x00000000, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff,
	0x7ff00000, 0x00000000, 0x40080000, 0x00000000, 0x7fffffff, 0xffffffff,
	0xfff00000, 0x00000000, 0x40080000, 0x00000000, 0x7fffffff, 0xffffffff,
	0x40080000, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0xffffffff,
	0x40080000, 0x00000000, 0x80000000, 0x00000000, 0x7fffffff, 0xffffffff,
	0x40080000, 0x00000000, 0x7ff00000, 0x00000000, 0x40080000, 0x00000000,
	0x40080000, 0x00000000, 0xfff00000, 0x00000000, 0x40080000, 0x00000000,
	// Interval tests with first index from -1.000000e+04 to 1.000000e+05 by 4.375340e+02 and second index from -1.000000e+01 to 1.000000e+01 by 3.789500e+00
	0xc0c38800, 0x00000000, 0xc0240000, 0x00000000, 0x80000000, 0x00000000,
	0xc0c38800, 0x00000000, 0xc018d78d, 0x4fdf3b64, 0xbff1851e, 0xb851f460,
	0xc0c38800, 0x00000000, 0xc0035e35, 0x3f7ced91, 0x3ff26a7e, 0xf9db15a6,
	0xc0c38800, 0x00000000, 0x3ff5e560, 0x4189374c, 0xbfd7b645, 0xa1caa6f0,
	0xc0c38800, 0x00000000, 0x4014a1ca, 0xc083126e, 0x3ff5cac0, 0x83125ca8,
	0xc0c38800, 0x00000000, 0x4021e51e, 0xb851eb85, 0x400a70a3, 0xd70a3b58,
	0xc0c2ad3b, 0xa5e353f8, 0xc0240000, 0x00000000, 0xc003ba5e, 0x353f8000,
	0xc0c2ad3b, 0xa5e353f8, 0xc018d78d, 0x4fdf3b64, 0x3ffb4395, 0x81061640,
	0xc0c2ad3b, 0xa5e353f8, 0xc0035e35, 0x3f7ced91, 0x3fdef9db, 0x22d09a70,
	0xc0c2ad3b, 0xa5e353f8, 0x3ff5e560, 0x4189374c, 0x3fe39581, 0x0624dd20,
	0xc0c2ad3b, 0xa5e353f8, 0x4014a1ca, 0xc083126e, 0x3fddd2f1, 0xa9fb8a40,
	0xc0c2ad3b, 0xa5e353f8, 0x4021e51e, 0xb851eb85, 0x40034ac0, 0x83126984,
	0xc0c1d277, 0x4bc6a7f0, 0xc0240000, 0x00000000, 0xc013ba5e, 0x353f8000,
	0xc0c1d277, 0x4bc6a7f0, 0xc018d78d, 0x4fdf3b64, 0xbffb51eb, 0x851eccb0,
	0xc0c1d277, 0x4bc6a7f0, 0xc0035e35, 0x3f7ced91, 0xbfc76c8b, 0x43964370,
	0xc0c1d277, 0x4bc6a7f0, 0x3ff5e560, 0x4189374c, 0x3fcced91, 0x68727c80,
	0xc0c1d277, 0x4bc6a7f0, 0x4014a1ca, 0xc083126e, 0xbfdb851e, 0xb8525e20,
	0xc0c1d277, 0x4bc6a7f0, 0x4021e51e, 0xb851eb85, 0x3ff849ba, 0x5e352f60,
	0xc0c0f7b2, 0xf1a9fbe8, 0xc0240000, 0x00000000, 0x4004d0e5, 0x60418000,
	0xc0c0f7b2, 0xf1a9fbe8, 0xc018d78d, 0x4fdf3b64, 0x3ff176c8, 0xb4393df0,
	0xc0c0f7b2, 0xf1a9fbe8, 0xc0035e35, 0x3f7ced91, 0xbfeb3333, 0x33336ef0,
	0xc0c0f7b2, 0xf1a9fbe8, 0x3ff5e560, 0x4189374c, 0xbfc47ae1, 0x47ae7b80,
	0xc0c0f7b2, 0xf1a9fbe8, 0x4014a1ca, 0xc083126e, 0xbff5374b, 0xc6a811a0,
	0xc0c0f7b2, 0xf1a9fbe8, 0x4021e51e, 0xb851eb85, 0x3fe3fbe7, 0x6c8b1770,
	0xc0c01cee, 0x978d4fe0, 0xc0240000, 0x00000000, 0x3fc16872, 0xb0200000,
	0xc0c01cee, 0x978d4fe0, 0xc018d78d, 0x4fdf3b64, 0xc0028f5c, 0x28f5d280,
	0xc0c01cee, 0x978d4fe0, 0xc0035e35, 0x3f7ced91, 0x3feced91, 0x68726940,
	0xc0c01cee, 0x978d4fe0, 0x3ff5e560, 0x4189374c, 0xbfe178d4, 0xfdf3dce0,
	0xc0c01cee, 0x978d4fe0, 0x4014a1ca, 0xc083126e, 0xc001c6a7, 0xef9dc5dc,
	0xc0c01cee, 0x978d4fe0, 0x4021e51e, 0xb851eb85, 0xbfd1374b, 0xc6a85fc0,
	0xc0be8454, 0x7ae147b0, 0xc0240000, 0x00000000, 0xc002a3d7, 0x0a3d8000,
	0xc0be8454, 0x7ae147b0, 0xc018d78d, 0x4fdf3b64, 0x3fdea7ef, 0x9db19680,
	0xc0be8454, 0x7ae147b0, 0xc0035e35, 0x3f7ced91, 0x3fce5604, 0x18922cb0,
	0xc0be8454, 0x7ae147b0, 0x3ff5e560, 0x4189374c, 0x3fdbef9d, 0xb22ca770,
	0xc0be8454, 0x7ae147b0, 0x4014a1ca, 0xc083126e, 0x400051eb, 0x851ea1f4,
	0xc0be8454, 0x7ae147b0, 0x4021e51e, 0xb851eb85, 0xbff29999, 0x9999bb98,
	0xc0bccecb, 0xc6a7efa0, 0xc0240000, 0x00000000, 0xc0132f1a, 0x9fbe8000,
	0xc0bccecb, 0xc6a7efa0, 0xc018d78d, 0x4fdf3b64, 0xc00775c2, 0x8f5c3ea8,
	0xc0bccecb, 0xc6a7efa0, 0xc0035e35, 0x3f7ced91, 0xbfdb851e, 0xb852a5d0,
	0xc0bccecb, 0xc6a7efa0, 0x3ff5e560, 0x4189374c, 0x3fa9db22, 0xd0e15b80,
	0xc0bccecb, 0xc6a7efa0, 0x4014a1ca, 0xc083126e, 0x3ff24dd2, 0xf1a9c9d0,
	0xc0bccecb, 0xc6a7efa0, 0x4021e51e, 0xb851eb85, 0xc00072b0, 0x20c4afa0,
	0xc0bb1943, 0x126e9790, 0xc0240000, 0x00000000, 0x4005e76c, 0x8b438000,
	0xc0bb1943, 0x126e9790, 0xc018d78d, 0x4fdf3b64, 0xbfc11687, 0x2b039580,
	0xc0bb1943, 0x126e9790, 0xc0035e35, 0x3f7ced91, 0xbff18d4f, 0xdf3b987e,
	0xc0bb1943, 0x126e9790, 0x3ff5e560, 0x4189374c, 0xbfd578d4, 0xfdf45090,
	0xc0bb1943, 0x126e9790, 0x4014a1ca, 0xc083126e, 0x3fcfbe76, 0xc8b27dc0,
	0xc0bb1943, 0x126e9790, 0x4021e51e, 0xb851eb85, 0xc0079893, 0x74bc8174,
	0xc0b963ba, 0x5e353f80, 0xc0240000, 0x00000000, 0x3fd16872, 0xb0200000,
	0xc0b963ba, 0x5e353f80, 0xc018d78d, 0x4fdf3b64, 0x400552f1, 0xa9fbcbf8,
	0xc0b963ba, 0x5e353f80, 0xc0035e35, 0x3f7ced91, 0x3fe50624, 0xdd2ea734,
	0xc0b963ba, 0x5e353f80, 0x3ff5e560, 0x4189374c, 0x3fe4b439, 0x58100850,
	0xc0b963ba, 0x5e353f80, 0x4014a1ca, 0xc083126e, 0xbfe4bc6a, 0x7efa54c0,
	0xc0b963ba, 0x5e353f80, 0x4021e51e, 0xb851eb85, 0xc00ebe76, 0xc8b45348,
	0xc0b7ae31, 0xa9fbe770, 0xc0240000, 0x00000000, 0xc0018d4f, 0xdf3b8000,
	0xc0b7ae31, 0xa9fbe770, 0xc018d78d, 0x4fdf3b64, 0xbfe7df3b, 0x645a9600,
	0xc0b7ae31, 0xa9fbe770, 0xc0035e35, 0x3f7ced91, 0xbf847ae1, 0x47cdb800,
	0xc0b7ae31, 0xa9fbe770, 0x3ff5e560, 0x4189374c, 0x3fd0b439, 0x580f94a0,
	0xc0b7ae31, 0xa9fbe770, 0x4014a1ca, 0xc083126e, 0xbff8b439, 0x5810a478,
	0xc0b7ae31, 0xa9fbe770, 0x4021e51e, 0xb851eb85, 0x4010d810, 0x624dc47c,
	0xc0b5f8a8, 0xf5c28f60, 0xc0240000, 0x00000000, 0xc012a3d7, 0x0a3d8000,
	0xc0b5f8a8, 0xf5c28f60, 0xc018d78d, 0x4fdf3b64, 0x40006c8b, 0x43955fd0,
	0xc0b5f8a8, 0xf5c28f60, 0xc0035e35, 0x3f7ced91, 0xbfe5a9fb, 0xe76d14f4,
	0xc0b5f8a8, 0xf5c28f60, 0x3ff5e560, 0x4189374c, 0xbfc00000, 0x0001cec0,
	0xc0b5f8a8, 0xf5c28f60, 0x4014a1ca, 0xc083126e, 0xc003851e, 0xb8520f48,
	0xc0b5f8a8, 0xf5c28f60, 0x4021e51e, 0xb851eb85, 0x400a8a3d, 0x70a3b724,
	0xc0b44320, 0x41893750, 0xc0240000, 0x00000000, 0x4006fdf3, 0xb6458000,
	0xc0b44320, 0x41893750, 0xc018d78d, 0x4fdf3b64, 0xbff5bc6a, 0x7efa2350,
	0xc0b44320, 0x41893750, 0xc0035e35, 0x3f7ced91, 0x3ff13b64, 0x5a1c619e,
	0xc0b44320, 0x41893750, 0x3ff5e560, 0x4189374c, 0xbfe05a1c, 0xac08b1b0,
	0xc0b44320, 0x41893750, 0x4014a1ca, 0xc083126e, 0x3ffd26e9, 0x78d4b110,
	0xc0b44320, 0x41893750, 0x4021e51e, 0xb851eb85, 0x4003645a, 0x1cabe550,
	0xc0b28d97, 0x8d4fdf40, 0xc0240000, 0x00000000, 0x3fda1cac, 0x08300000,
	0xc0b28d97, 0x8d4fdf40, 0xc018d78d, 0x4fdf3b64, 0x3ff70c49, 0xba5de750,
	0xc0b28d97, 0x8d4fdf40, 0xc0035e35, 0x3f7ced91, 0x3fda3d70, 0xa3d5ca50,
	0xc0b28d97, 0x8d4fdf40, 0x3ff5e560, 0x4189374c, 0x3fde2d0e, 0x5602fdd0,
	0xc0b28d97, 0x8d4fdf40, 0x4014a1ca, 0xc083126e, 0x3feda1ca, 0xc0826df0,
	0xc0b28d97, 0x8d4fdf40, 0x4021e51e, 0xb851eb85, 0x3ff87ced, 0x916826f8,
	0xc0b0d80e, 0xd9168730, 0xc0240000, 0x00000000, 0xc00076c8, 0xb4398000,
	0xc0b0d80e, 0xd9168730, 0xc018d78d, 0x4fdf3b64, 0xbfff8937, 0x4bc6fba0,
	0xc0b0d80e, 0xd9168730, 0xc0035e35, 0x3f7ced91, 0xbfd072b0, 0x20c5f1d8,
	0xc0b0d80e, 0xd9168730, 0x3ff5e560, 0x4189374c, 0x3fb5e353, 0xf7ca0740,
	0xc0b0d80e, 0xd9168730, 0x4014a1ca, 0xc083126e, 0x3f9eb851, 0xeb6f3800,
	0xc0b0d80e, 0xd9168730, 0x4021e51e, 0xb851eb85, 0x3fe4624d, 0xd2f106a0,
	0xc0ae450c, 0x49ba5e3f, 0xc0240000, 0x00000000, 0xc0121893, 0x74bc7e00,
	0xc0ae450c, 0x49ba5e3f, 0xc018d78d, 0x4fdf3b64, 0x3fea7ef9, 0xdb222e00,
	0xc0ae450c, 0x49ba5e3f, 0xc0035e35, 0x3f7ced91, 0xbfed9168, 0x72b0c700,
	0xc0ae450c, 0x49ba5e3f, 0x3ff5e560, 0x4189374c, 0xbfd33b64, 0x5a1dda30,
	0xc0ae450c, 0x49ba5e3f, 0x4014a1ca, 0xc083126e, 0xbfebb645, 0xa1cb6a70,
	0xc0ae450c, 0x49ba5e3f, 0x4021e51e, 0xb851eb85, 0xbfd06a7e, 0xf9dc6160,
	0xc0aad9fa, 0xe147ae1e, 0xc0240000, 0x00000000, 0x4008147a, 0xe1478800,
	0xc0aad9fa, 0xe147ae1e, 0xc018d78d, 0x4fdf3b64, 0xc004ab02, 0x0c49e1f8,
	0xc0aad9fa, 0xe147ae1e, 0xc0035e35, 0x3f7ced91, 0x3fea8f5c, 0x28f52130,
	0xc0aad9fa, 0xe147ae1e, 0x3ff5e560, 0x4189374c, 0x3fe5d2f1, 0xa9fb5380,
	0xc0aad9fa, 0xe147ae1e, 0x4014a1ca, 0xc083126e, 0xbffc3126, 0xe9792750,
	0xc0aad9fa, 0xe147ae1e, 0x4021e51e, 0xb851eb85, 0xbff26666, 0x6666b400,
	0xc0a76ee9, 0x78d4fdfd, 0xc0240000, 0x00000000, 0x3fe16872, 0xb0203000,
	0xc0a76ee9, 0x78d4fdfd, 0xc018d78d, 0x4fdf3b64, 0x3fcb9581, 0x06227580,
	0xc0a76ee9, 0x78d4fdfd, 0xc0035e35, 0x3f7ced91, 0x3fc4dd2f, 0x1a9d4c70,
	0xc0a76ee9, 0x78d4fdfd, 0x3ff5e560, 0x4189374c, 0x3fd2f1a9, 0xfbe64b00,
	0xc0a76ee9, 0x78d4fdfd, 0x4014a1ca, 0xc083126e, 0x4003ffff, 0xffffd828,
	0xc0a76ee9, 0x78d4fdfd, 0x4021e51e, 0xb851eb85, 0xc0005916, 0x872b27d4,
	0xc0a403d8, 0x10624ddc, 0xc0240000, 0x00000000, 0xbffec083, 0x126ee000,
	0xc0a403d8, 0x10624ddc, 0xc018d78d, 0x4fdf3b64, 0x40081db2, 0x2d0e30a8,
	0xc0a403d8, 0x10624ddc, 0xc0035e35, 0x3f7ced91, 0xbfe020c4, 0x9ba67af8,
	0xc0a403d8, 0x10624ddc, 0x3ff5e560, 0x4189374c, 0xbfb70a3d, 0x70a84400,
	0xc0a403d8, 0x10624ddc, 0x4014a1ca, 0xc083126e, 0x3ff9a9fb, 0xe76c3e38,
	0xc0a403d8, 0x10624ddc, 0x4021e51e, 0xb851eb85, 0xc0077ef9, 0xdb22f5a8,
	0xc0a098c6, 0xa7ef9dbb, 0xc0240000, 0x00000000, 0xc0118d4f, 0xdf3b7600,
	0xc0a098c6, 0xa7ef9dbb, 0xc018d78d, 0x4fdf3b64, 0xbfd96872, 0xb021e680,
	0xc0a098c6, 0xa7ef9dbb, 0xc0035e35, 0x3f7ced91, 0xbff2bc6a, 0x7efa2486,
	0xc0a098c6, 0xa7ef9dbb, 0x3ff5e560, 0x4189374c, 0xbfde76c8, 0xb43a6d00,
	0xc0a098c6, 0xa7ef9dbb, 0x4014a1ca, 0xc083126e, 0x3fe6a7ef, 0x9db19840,
	0xc0a098c6, 0xa7ef9dbb, 0x4021e51e, 0xb851eb85, 0xc00ea4dd, 0x2f1ac37c,
	0xc09a5b6a, 0x7ef9db34, 0xc0240000, 0x00000000, 0x40092b02, 0x0c499800,
	0xc09a5b6a, 0x7ef9db34, 0xc018d78d, 0x4fdf3b64, 0x4003374b, 0xc6a7cc80,
	0xc09a5b6a, 0x7ef9db34, 0xc0035e35, 0x3f7ced91, 0x3fe2a7ef, 0x9db19f24,
	0xc09a5b6a, 0x7ef9db34, 0x3ff5e560, 0x4189374c, 0x3fe0353f, 0x7ced0a18,
	0xc09a5b6a, 0x7ef9db34, 0x4014a1ca, 0xc083126e, 0xbfc81062, 0x4dd52fc0,
	0xc09a5b6a, 0x7ef9db34, 0x4021e51e, 0xb851eb85, 0x4010e4dd, 0x2f1a8e62,
	0xc0938547, 0xae147af2, 0xc0240000, 0x00000000, 0x3fe5c28f, 0x5c287000,
	0xc0938547, 0xae147af2, 0xc018d78d, 0x4fdf3b64, 0xbff026e9, 0x78d541f0,
	0xc0938547, 0xae147af2, 0xc0035e35, 0x3f7ced91, 0xbfb58106, 0x24e17780,
	0xc0938547, 0xae147af2, 0x3ff5e560, 0x4189374c, 0x3fbed916, 0x8726e0c0,
	0xc0938547, 0xae147af2, 0x4014a1ca, 0xc083126e, 0xbff15810, 0x624e1810,
	0xc0938547, 0xae147af2, 0x4021e51e, 0xb851eb85, 0x400aa3d7, 0x0a3d4ef0,
	0xc0895e49, 0xba5e3561, 0xc0240000, 0x00000000, 0xbffc9374, 0xbc6ac200,
	0xc0895e49, 0xba5e3561, 0xc018d78d, 0x4fdf3b64, 0x3ffca1ca, 0xc082ceb0,
	0xc0895e49, 0xba5e3561, 0xc0035e35, 0x3f7ced91, 0xbfe80831, 0x26ea0104,
	0xc0895e49, 0xba5e3561, 0x3ff5e560, 0x4189374c, 0xbfd0fdf3, 0xb646abd0,
	0xc0895e49, 0xba5e3561, 0x4014a1ca, 0xc083126e, 0xbfffae14, 0x7ae18c28,
	0xc0895e49, 0xba5e3561, 0x4021e51e, 0xb851eb85, 0x40037df3, 0xb645801c,
	0xc0776408, 0x3126e9bc, 0xc0240000, 0x00000000, 0xc011020c, 0x49ba6f00,
	0xc0776408, 0x3126e9bc, 0xc018d78d, 0x4fdf3b64, 0xbff9f3b6, 0x45a20e40,
	0xc0776408, 0x3126e9bc, 0xc0035e35, 0x3f7ced91, 0x3ff00c49, 0xba5df196,
	0xc0776408, 0x3126e9bc, 0x3ff5e560, 0x4189374c, 0xbfe4d916, 0x872b87e8,
	0xc0776408, 0x3126e9bc, 0x4014a1ca, 0xc083126e, 0x40024189, 0x374ba4bc,
	0xc0776408, 0x3126e9bc, 0x4021e51e, 0xb851eb85, 0x3ff8b020, 0xc49b6290,
	0x404fa418, 0x9374ba50, 0xc0240000, 0x00000000, 0x400a4189, 0x374ba500,
	0x404fa418, 0x9374ba50, 0xc018d78d, 0x4fdf3b64, 0x3ff2d4fd, 0xf3b60260,
	0x404fa418, 0x9374ba50, 0xc0035e35, 0x3f7ced91, 0x3fd58106, 0x24dc2230,
	0x404fa418, 0x9374ba50, 0x3ff5e560, 0x4189374c, 0x3fd52f1a, 0x9fbd6960,
	0x404fa418, 0x9374ba50, 0x4014a1ca, 0xc083126e, 0x3ff62d0e, 0x5603d560,
	0x404fa418, 0x9374ba50, 0x4021e51e, 0xb851eb85, 0x3fe4c8b4, 0x395789d0,
	0x407f4d0e, 0x56041850, 0xc0240000, 0x00000000, 0x3fea1cac, 0x0830a000,
	0x407f4d0e, 0x56041850, 0xc018d78d, 0x4fdf3b64, 0xc001e041, 0x89376d48,
	0x407f4d0e, 0x56041850, 0xc0035e35, 0x3f7ced91, 0xbfd52f1a, 0x9fbf81f8,
	0x407f4d0e, 0x56041850, 0x3ff5e560, 0x4189374c, 0xbfac28f5, 0xc297d500,
	0x407f4d0e, 0x56041850, 0x4014a1ca, 0xc083126e, 0x3fdf5c28, 0xf5c18520,
	0x407f4d0e, 0x56041850, 0x4021e51e, 0xb851eb85, 0xbfcf3b64, 0x5a1ec600,
	0x408d52cc, 0xccccccab, 0xc0240000, 0x00000000, 0xbffa6666, 0x6666aa00,
	0x408d52cc, 0xccccccab, 0xc018d78d, 0x4fdf3b64, 0x3fe21062, 0x4dd26c20,
	0x408d52cc, 0xccccccab, 0xc0035e35, 0x3f7ced91, 0xbfefef9d, 0xb22d9310,
	0x408d52cc, 0xccccccab, 0x3ff5e560, 0x4189374c, 0xbfdc3958, 0x10635ea0,
	0x408d52cc, 0xccccccab, 0x4014a1ca, 0xc083126e, 0xbfd9fbe7, 0x6c8c4b40,
	0x408d52cc, 0xccccccab, 0x4021e51e, 0xb851eb85, 0xbff23333, 0x33337668,
	0x40957f89, 0x374bc697, 0xc0240000, 0x00000000, 0xc01076c8, 0xb4396900,
	0x40957f89, 0x374bc697, 0xc018d78d, 0x4fdf3b64, 0xc006c6a7, 0xef9dd370,
	0x40957f89, 0x374bc697, 0xc0035e35, 0x3f7ced91, 0x3fe83126, 0xe9785120,
	0x40957f89, 0x374bc697, 0x3ff5e560, 0x4189374c, 0x3fe153f7, 0xced88d48,
	0x40957f89, 0x374bc697, 0x4014a1ca, 0xc083126e, 0xbff4d4fd, 0xf3b686e8,
	0x40957f89, 0x374bc697, 0x4021e51e, 0xb851eb85, 0xc0003f7c, 0xed918a08,
	0x409c55ac, 0x083126d8, 0xc0240000, 0x00000000, 0x400b5810, 0x624db000,
	0x409c55ac, 0x083126d8, 0xc018d78d, 0x4fdf3b64, 0xbfa89374, 0xbc730800,
	0x409c55ac, 0x083126d8, 0xc0035e35, 0x3f7ced91, 0x3fb6c8b4, 0x3953d860,
	0x409c55ac, 0x083126d8, 0x3ff5e560, 0x4189374c, 0x3fc3e76c, 0x8b415d20,
	0x409c55ac, 0x083126d8, 0x4014a1ca, 0xc083126e, 0xc0019581, 0x0624fe80,
	0x409c55ac, 0x083126d8, 0x4021e51e, 0xb851eb85, 0xc0076560, 0x418959dc,
	0x40a195e7, 0x6c8b438d, 0xc0240000, 0x00000000, 0x3fee76c8, 0xb438d000,
	0x40a195e7, 0x6c8b438d, 0xc018d78d, 0x4fdf3b64, 0x4006020c, 0x49ba3d30,
	0x40a195e7, 0x6c8b438d, 0xc0035e35, 0x3f7ced91, 0xbfe27ef9, 0xdb235308,
	0x40a195e7, 0x6c8b438d, 0x3ff5e560, 0x4189374c, 0xbfcd8106, 0x24df5ae0,
	0x40a195e7, 0x6c8b438d, 0x4014a1ca, 0xc083126e, 0x40008312, 0x6e976d50,
	0x40a195e7, 0x6c8b438d, 0x4021e51e, 0xb851eb85, 0xc00e8b43, 0x958127b0,
	0x40a500f8, 0xd4fdf3ae, 0xc0240000, 0x00000000, 0xbff83958, 0x10629000,
	0x40a500f8, 0xd4fdf3ae, 0xc018d78d, 0x4fdf3b64, 0xbfe522d0, 0xe560c120,
	0x40a500f8, 0xd4fdf3ae, 0xc0035e35, 0x3f7ced91, 0x3ff2d0e5, 0x60414a94,
	0x40a500f8, 0xd4fdf3ae, 0x3ff5e560, 0x4189374c, 0xbfe3ba5e, 0x354004b8,
	0x40a500f8, 0xd4fdf3ae, 0x4014a1ca, 0xc083126e, 0x3ff2b020, 0xc49b6888,
	0x40a500f8, 0xd4fdf3ae, 0x4021e51e, 0xb851eb85, 0x4010f1a9, 0xfbe75c48,
	0x40a86c0a, 0x3d70a3cf, 0xc0240000, 0x00000000, 0xc00fd70a, 0x3d70c400,
	0x40a86c0a, 0x3d70a3cf, 0xc018d78d, 0x4fdf3b64, 0x40011ba5, 0xe353d908,
	0x40a86c0a, 0x3d70a3cf, 0xc0035e35, 0x3f7ced91, 0x3fe049ba, 0x5e34c714,
	0x40a86c0a, 0x3d70a3cf, 0x3ff5e560, 0x4189374c, 0x3fd76c8b, 0x439477c0,
	0x40a86c0a, 0x3d70a3cf, 0x4014a1ca, 0xc083126e, 0x3fd16872, 0xb01fd9c0,
	0x40a86c0a, 0x3d70a3cf, 0x4021e51e, 0xb851eb85, 0x400abd70, 0xa3d6eabc,
	0x40abd71b, 0xa5e353f0, 0xc0240000, 0x00000000, 0x400c6e97, 0x8d4fc000,
	0x40abd71b, 0xa5e353f0, 0xc018d78d, 0x4fdf3b64, 0xbff45e35, 0x3f7d28e0,
	0x40abd71b, 0xa5e353f0, 0xc0035e35, 0x3f7ced91, 0xbfc43958, 0x10641c00,
	0x40abd71b, 0xa5e353f0, 0x3ff5e560, 0x4189374c, 0xbf947ae1, 0x47be4400,
	0x40abd71b, 0xa5e353f0, 0x4014a1ca, 0xc083126e, 0xbfe3f7ce, 0xd916f750,
	0x40abd71b, 0xa5e353f0, 0x4021e51e, 0xb851eb85, 0x4003978d, 0x4fdf1ce8,
	0x40af422d, 0x0e560411, 0xc0240000, 0x00000000, 0x3ff16872, 0xb0208800,
	0x40af422d, 0x0e560411, 0xc018d78d, 0x4fdf3b64, 0x3ff86a7e, 0xf9dae9c0,
	0x40af422d, 0x0e560411, 0xc0035e35, 0x3f7ced91, 0xbfea6666, 0x6666d514,
	0x40af422d, 0x0e560411, 0x3ff5e560, 0x4189374c, 0xbfd9fbe7, 0x6c8c4040,
	0x40af422d, 0x0e560411, 0x4014a1ca, 0xc083126e, 0xbff851eb, 0x851eedc0,
	0x40af422d, 0x0e560411, 0x4021e51e, 0xb851eb85, 0x3ff8e353, 0xf7ce9e28,
	0x40b1569f, 0x3b645a19, 0xc0240000, 0x00000000, 0xbff60c49, 0xba5e7000,
	0x40b1569f, 0x3b645a19, 0xc018d78d, 0x4fdf3b64, 0xbffe2b02, 0x0c49f130,
	0x40b1569f, 0x3b645a19, 0xc0035e35, 0x3f7ced91, 0x3fedba5e, 0x353f131c,
	0x40b1569f, 0x3b645a19, 0x3ff5e560, 0x4189374c, 0x3fe272b0, 0x20c42078,
	0x40b1569f, 0x3b645a19, 0x4014a1ca, 0xc083126e, 0xc00353f7, 0xced92fec,
	0x40b1569f, 0x3b645a19, 0x4021e51e, 0xb851eb85, 0x3fe52f1a, 0x9fbe0500,
	0x40b30c27, 0xef9db229, 0xc0240000, 0x00000000, 0xc00ec083, 0x126eb800,
	0x40b30c27, 0xef9db229, 0xc018d78d, 0x4fdf3b64, 0x3fed3b64, 0x5a1c32e0,
	0x40b30c27, 0xef9db229, 0xc0035e35, 0x3f7ced91, 0x3fd0c49b, 0xa5e26a10,
	0x40b30c27, 0xef9db229, 0x3ff5e560, 0x4189374c, 0x3fc8624d, 0xd2ef89e0,
	0x40b30c27, 0xef9db229, 0x4014a1ca, 0xc083126e, 0x3ffd8937, 0x4bc66fc8,
	0x40b30c27, 0xef9db229, 0x4021e51e, 0xb851eb85, 0xbfcda1ca, 0xc0850940,
	0x40b4c1b0, 0xa3d70a39, 0xc0240000, 0x00000000, 0x400d851e, 0xb851c800,
	0x40b4c1b0, 0xa3d70a39, 0xc018d78d, 0x4fdf3b64, 0xc003fbe7, 0x6c8b64c0,
	0x40b4c1b0, 0xa3d70a39, 0xc0035e35, 0x3f7ced91, 0xbfd9eb85, 0x1eb95218,
	0x40b4c1b0, 0xa3d70a39, 0x3ff5e560, 0x4189374c, 0xbfc90624, 0xdd316e20,
	0x40b4c1b0, 0xa3d70a39, 0x4014a1ca, 0xc083126e, 0x3fee6666, 0x6665eb60,
	0x40b4c1b0, 0xa3d70a39, 0x4021e51e, 0xb851eb85, 0xbff20000, 0x000044d0,
	0x40b67739, 0x58106249, 0xc0240000, 0x00000000, 0x3ff39581, 0x06249000,
	0x40b67739, 0x58106249, 0xc018d78d, 0x4fdf3b64, 0x3fd34395, 0x81050480,
	0x40b67739, 0x58106249, 0xc0035e35, 0x3f7ced91, 0xbff126e9, 0x78d54390,
	0x40b67739, 0x58106249, 0x3ff5e560, 0x4189374c, 0xbfe29ba5, 0xe3549988,
	0x40b67739, 0x58106249, 0x4014a1ca, 0xc083126e, 0x3faba5e3, 0x53ef7300,
	0x40b67739, 0x58106249, 0x4021e51e, 0xb851eb85, 0xc00025e3, 0x53f7f43c,
	0x40b82cc2, 0x0c49ba59, 0xc0240000, 0x00000000, 0xbff3df3b, 0x645a7000,
	0x40b82cc2, 0x0c49ba59, 0xc018d78d, 0x4fdf3b64, 0x4008cccc, 0xcccca5e0,
	0x40b82cc2, 0x0c49ba59, 0xc0035e35, 0x3f7ced91, 0x3fe5d2f1, 0xa9fb5110,
	0x40b82cc2, 0x0c49ba59, 0x3ff5e560, 0x4189374c, 0x3fd9a9fb, 0xe76b2e20,
	0x40b82cc2, 0x0c49ba59, 0x4014a1ca, 0xc083126e, 0xbfeaf1a9, 0xfbe7fd00,
	0x40b82cc2, 0x0c49ba59, 0x4021e51e, 0xb851eb85, 0xc0074bc6, 0xa7efc610,
	0x40b9e24a, 0xc0831269, 0xc0240000, 0x00000000, 0xc00da9fb, 0xe76cb800,
	0x40b9e24a, 0xc0831269, 0xc018d78d, 0x4fdf3b64, 0xbfd3ef9d, 0xb22e5cc0,
	0x40b9e24a, 0xc0831269, 0xc0035e35, 0x3f7ced91, 0x3f8eb851, 0xeb5cbf00,
	0x40b9e24a, 0xc0831269, 0x3ff5e560, 0x4189374c, 0x3f8eb851, 0xeb564400,
	0x40b9e24a, 0xc0831269, 0x4014a1ca, 0xc083126e, 0xbffbced9, 0x16877898,
	0x40b9e24a, 0xc0831269, 0x4021e51e, 0xb851eb85, 0xc00e71a9, 0xfbe797e4,
	0x40bb97d3, 0x74bc6a79, 0xc0240000, 0x00000000, 0x400e9ba5, 0xe353c800,
	0x40bb97d3, 0x74bc6a79, 0xc018d78d, 0x4fdf3b64, 0x4003e666, 0x666639b8,
	0x40bb97d3, 0x74bc6a79, 0xc0035e35, 0x3f7ced91, 0xbfe4dd2f, 0x1aa06b18,
	0x40bb97d3, 0x74bc6a79, 0x3ff5e560, 0x4189374c, 0xbfd7be76, 0xc8b5c9e0,
	0x40bb97d3, 0x74bc6a79, 0x4014a1ca, 0xc083126e, 0x40043126, 0xe978ab84,
	0x40bb97d3, 0x74bc6a79, 0x4021e51e, 0xb851eb85, 0x4010fe76, 0xc8b4222e,
	0x40bd4d5c, 0x28f5c289, 0xc0240000, 0x00000000, 0x3ff5c28f, 0x5c289000,
	0x40bd4d5c, 0x28f5c289, 0xc018d78d, 0x4fdf3b64, 0xbfed9168, 0x72b0df00,
	0x40bd4d5c, 0x28f5c289, 0xc0035e35, 0x3f7ced91, 0x3ff1a1ca, 0xc082b68c,
	0x40bd4d5c, 0x28f5c289, 0x3ff5e560, 0x4189374c, 0x3fe39168, 0x72af4ba8,
	0x40bd4d5c, 0x28f5c289, 0x4014a1ca, 0xc083126e, 0x3ffa0c49, 0xba5ddcf0,
	0x40bd4d5c, 0x28f5c289, 0x4021e51e, 0xb851eb85, 0x400ad70a, 0x3d707288,
	0x40bf02e4, 0xdd2f1a99, 0xc0240000, 0x00000000, 0xbff1b22d, 0x0e567000,
	0x40bf02e4, 0xdd2f1a99, 0xc018d78d, 0x4fdf3b64, 0x3ffdffff, 0xffff9b20,
	0x40bf02e4, 0xdd2f1a99, 0xc0035e35, 0x3f7ced91, 0x3fdbd70a, 0x3d6f1e08,
	0x40bf02e4, 0xdd2f1a99, 0x3ff5e560, 0x4189374c, 0x3fccdd2f, 0x1a9c36a0,
	0x40bf02e4, 0xdd2f1a99, 0x4014a1ca, 0xc083126e, 0x3fe76c8b, 0x4394c5b0,
	0x40bf02e4, 0xdd2f1a99, 0x4021e51e, 0xb851eb85, 0x4003b126, 0xe978a0b4,
	0x40c05c36, 0xc8b43955, 0xc0240000, 0x00000000, 0xc00c9374, 0xbc6ab000,
	0x40c05c36, 0xc8b43955, 0xc018d78d, 0x4fdf3b64, 0xbff89581, 0x062537d0,
	0x40c05c36, 0xc8b43955, 0xc0035e35, 0x3f7ced91, 0xbfcdb22d, 0x0e58bc40,
	0x40c05c36, 0xc8b43955, 0x3ff5e560, 0x4189374c, 0xbfc48b43, 0x95844160,
	0x40c05c36, 0xc8b43955, 0x4014a1ca, 0xc083126e, 0xbfc4fdf3, 0xb6483a00,
	0x40c05c36, 0xc8b43955, 0x4021e51e, 0xb851eb85, 0x3ff91687, 0x2b01adc0,
	0x40c136fb, 0x22d0e55d, 0xc0240000, 0x00000000, 0x400fb22d, 0x0e55d000,
	0x40c136fb, 0x22d0e55d, 0xc018d78d, 0x4fdf3b64, 0x3ff43333, 0x3332d2d0,
	0x40c136fb, 0x22d0e55d, 0xc0035e35, 0x3f7ced91, 0xbfecc49b, 0xa5e40d24,
	0x40c136fb, 0x22d0e55d, 0x3ff5e560, 0x4189374c, 0xbfe17ced, 0x91694e58,
	0x40c136fb, 0x22d0e55d, 0x4014a1ca, 0xc083126e, 0xbff0f5c2, 0x8f5c8158,
	0x40c136fb, 0x22d0e55d, 0x4021e51e, 0xb851eb85, 0x3fe59581, 0x06241430,
	0x40c211bf, 0x7ced9165, 0xc0240000, 0x00000000, 0x3ff7ef9d, 0xb22ca000,
	0x40c211bf, 0x7ced9165, 0xc018d78d, 0x4fdf3b64, 0xc0013126, 0xe9790810,
	0x40c211bf, 0x7ced9165, 0xc0035e35, 0x3f7ced91, 0x3feb5c28, 0xf5c1cb0c,
	0x40c211bf, 0x7ced9165, 0x3ff5e560, 0x4189374c, 0x3fdbe76c, 0x8b41c480,
	0x40c211bf, 0x7ced9165, 0x4014a1ca, 0xc083126e, 0xbfff4bc6, 0xa7effb70,
	0x40c211bf, 0x7ced9165, 0x4021e51e, 0xb851eb85, 0xbfcc0831, 0x26eccc80,
	0x40c2ec83, 0xd70a3d6d, 0xc0240000, 0x00000000, 0xbfef0a3d, 0x70a4c000,
	0x40c2ec83, 0xd70a3d6d, 0xc018d78d, 0x4fdf3b64, 0x3fe4cccc, 0xcccbf500,
	0x40c2ec83, 0xd70a3d6d, 0xc0035e35, 0x3f7ced91, 0x3fc81062, 0x4dcfb3e0,
	0x40c2ec83, 0xd70a3d6d, 0x3ff5e560, 0x4189374c, 0x3fa99999, 0x998a4400,
	0x40c2ec83, 0xd70a3d6d, 0x4014a1ca, 0xc083126e, 0x400272b0, 0x20c46a18,
	0x40c2ec83, 0xd70a3d6d, 0x4021e51e, 0xb851eb85, 0xbff1cccc, 0xcccd3d38,
	0x40c3c748, 0x3126e975, 0xc0240000, 0x00000000, 0xc00b7ced, 0x9168b000,
	0x40c3c748, 0x3126e975, 0xc018d78d, 0x4fdf3b64, 0xc006178d, 0x4fdf7438,
	0x40c3c748, 0x3126e975, 0xc0035e35, 0x3f7ced91, 0xbfdea7ef, 0x9db3e238,
	0x40c3c748, 0x3126e975, 0x3ff5e560, 0x4189374c, 0xbfd58106, 0x24df3380,
	0x40c3c748, 0x3126e975, 0x4014a1ca, 0xc083126e, 0x3ff68f5c, 0x28f55a18,
	0x40c3c748, 0x3126e975, 0x4021e51e, 0xb851eb85, 0xc0000c49, 0xba5e7070,
	0x40c4a20c, 0x8b43957d, 0xc0240000, 0x00000000, 0x4010645a, 0x1cabe800,
	0x40c4a20c, 0x8b43957d, 0xc018d78d, 0x4fdf3b64, 0x3fa33333, 0x33244600,
	0x40c4a20c, 0x8b43957d, 0xc0035e35, 0x3f7ced91, 0xbff25604, 0x1893e798,
	0x40c4a20c, 0x8b43957d, 0x3ff5e560, 0x4189374c, 0x3fe4b020, 0xc49a96d8,
	0x40c4a20c, 0x8b43957d, 0x4014a1ca, 0xc083126e, 0x3fe072b0, 0x20c3c000,
	0x40c4a20c, 0x8b43957d, 0x4021e51e, 0xb851eb85, 0xc007322d, 0x0e564244,
	0x40c57cd0, 0xe5604185, 0xc0240000, 0x00000000, 0x3ffa1cac, 0x0830a000,
	0x40c57cd0, 0xe5604185, 0xc018d78d, 0x4fdf3b64, 0x4006b126, 0xe9789668,
	0x40c57cd0, 0xe5604185, 0xc0035e35, 0x3f7ced91, 0x3fe374bc, 0x6a7e0900,
	0x40c57cd0, 0xe5604185, 0x3ff5e560, 0x4189374c, 0x3fd0ac08, 0x3124b1b0,
	0x40c57cd0, 0xe5604185, 0x4014a1ca, 0xc083126e, 0xbfd872b0, 0x20c66860,
	0x40c57cd0, 0xe5604185, 0x4021e51e, 0xb851eb85, 0xc00e5810, 0x624e1418,
	0x40c65795, 0x3f7ced8d, 0xc0240000, 0x00000000, 0xbfeab020, 0xc49cc000,
	0x40c65795, 0x3f7ced8d, 0xc018d78d, 0x4fdf3b64, 0xbfe26666, 0x66676c40,
	0x40c65795, 0x3f7ced8d, 0xc0035e35, 0x3f7ced91, 0xbfae353f, 0x7cfd5140,
	0x40c65795, 0x3f7ced8d, 0x3ff5e560, 0x4189374c, 0xbfc01062, 0x4dd794a0,
	0x40c65795, 0x3f7ced8d, 0x4014a1ca, 0xc083126e, 0xbff472b0, 0x20c51430,
	0x40c65795, 0x3f7ced8d, 0x4021e51e, 0xb851eb85, 0x40110b43, 0x9580e414,
	0x40c73259, 0x99999995, 0xc0240000, 0x00000000, 0xc00a6666, 0x6666b000,
	0x40c73259, 0x99999995, 0xc018d78d, 0x4fdf3b64, 0x4001cac0, 0x83122a40,
	0x40c73259, 0x99999995, 0xc0035e35, 0x3f7ced91, 0xbfe73b64, 0x5a1db328,
	0x40c73259, 0x99999995, 0x3ff5e560, 0x4189374c, 0xbfe05e35, 0x3f7e2328,
	0x40c73259, 0x99999995, 0x4014a1ca, 0xc083126e, 0xc001645a, 0x1cac4724,
	0x40c73259, 0x99999995, 0x4021e51e, 0xb851eb85, 0x400af0a3, 0xd709f654,
	0x40c80d1d, 0xf3b6459d, 0xc0240000, 0x00000000, 0x4010ef9d, 0xb22ce800,
	0x40c80d1d, 0xf3b6459d, 0xc018d78d, 0x4fdf3b64, 0xbff30000, 0x00008e70,
	0x40c80d1d, 0xf3b6459d, 0xc0035e35, 0x3f7ced91, 0x3ff072b0, 0x20c41284,
	0x40c80d1d, 0xf3b6459d, 0x3ff5e560, 0x4189374c, 0x3fde24dd, 0x2f181ae0,
	0x40c80d1d, 0xf3b6459d, 0x4014a1ca, 0xc083126e, 0x4000b439, 0x581020ac,
	0x40c80d1d, 0xf3b6459d, 0x4021e51e, 0xb851eb85, 0x4003cac0, 0x83122480,
	0x40c8e7e2, 0x4dd2f1a5, 0xc0240000, 0x00000000, 0x3ffc49ba, 0x5e34a000,
	0x40c8e7e2, 0x4dd2f1a5, 0xc018d78d, 0x4fdf3b64, 0x3ff9c8b4, 0x39577c30,
	0x40c8e7e2, 0x4dd2f1a5, 0xc0035e35, 0x3f7ced91, 0x3fd71a9f, 0xbe748de8,
	0x40c8e7e2, 0x4dd2f1a5, 0x3ff5e560, 0x4189374c, 0x3fb5c28f, 0x5c1e7b80,
	0x40c8e7e2, 0x4dd2f1a5, 0x4014a1ca, 0xc083126e, 0x3ff3126e, 0x978cc740,
	0x40c8e7e2, 0x4dd2f1a5, 0x4021e51e, 0xb851eb85, 0x3ff949ba, 0x5e34a558,
	0x40c9c2a6, 0xa7ef9dad, 0xc0240000, 0x00000000, 0xbfe65604, 0x1894c000,
	0x40c9c2a6, 0xa7ef9dad, 0xc018d78d, 0x4fdf3b64, 0xbffccccc, 0xcccd66c0,
	0x40c9c2a6, 0xa7ef9dad, 0xc0035e35, 0x3f7ced91, 0xbfd39581, 0x06272e40,
	0x40c9c2a6, 0xa7ef9dad, 0x3ff5e560, 0x4189374c, 0xbfd34395, 0x8108dd20,
	0x40c9c2a6, 0xa7ef9dad, 0x4014a1ca, 0xc083126e, 0x3fd2f1a9, 0xfbe534a0,
	0x40c9c2a6, 0xa7ef9dad, 0x4021e51e, 0xb851eb85, 0x3fe5fbe7, 0x6c8a0360,
	0x40ca9d6b, 0x020c49b5, 0xc0240000, 0x00000000, 0xc0094fdf, 0x3b64b000,
	0x40ca9d6b, 0x020c49b5, 0xc018d78d, 0x4fdf3b64, 0x3feff7ce, 0xd91547c0,
	0x40ca9d6b, 0x020c49b5, 0xc0035e35, 0x3f7ced91, 0xbfef22d0, 0xe5617534,
	0x40ca9d6b, 0x020c49b5, 0x3ff5e560, 0x4189374c, 0x3fe5ced9, 0x1685c208,
	0x40ca9d6b, 0x020c49b5, 0x4014a1ca, 0xc083126e, 0xbfe33333, 0x333459e0,
	0x40ca9d6b, 0x020c49b5, 0x4021e51e, 0xb851eb85, 0xbfca6e97, 0x8d550fc0,
	0x40cb782f, 0x5c28f5bd, 0xc0240000, 0x00000000, 0x40117ae1, 0x47ade800,
	0x40cb782f, 0x5c28f5bd, 0xc018d78d, 0x4fdf3b64, 0xc0034ccc, 0xcccd1f88,
	0x40cb782f, 0x5c28f5bd, 0xc0035e35, 0x3f7ced91, 0x3fe8fdf3, 0xb64462fc,
	0x40cb782f, 0x5c28f5bd, 0x3ff5e560, 0x4189374c, 0x3fd2e978, 0xd4fb0810,
	0x40cb782f, 0x5c28f5bd, 0x4014a1ca, 0xc083126e, 0xbff7ef9d, 0xb22da708,
	0x40cb782f, 0x5c28f5bd, 0x4021e51e, 0xb851eb85, 0xbff19999, 0x999a45a0,
	0x40cc52f3, 0xb645a1c5, 0xc0240000, 0x00000000, 0x3ffe76c8, 0xb438a000,
	0x40cc52f3, 0xb645a1c5, 0xc018d78d, 0x4fdf3b64, 0x3fd8bc6a, 0x7ef72e40,
	0x40cc52f3, 0xb645a1c5, 0xc0035e35, 0x3f7ced91, 0x3fbd2f1a, 0x9fb42740,
	0x40cc52f3, 0xb645a1c5, 0x3ff5e560, 0x4189374c, 0xbfb72b02, 0x0c55cfc0,
	0x40cc52f3, 0xb645a1c5, 0x4014a1ca, 0xc083126e, 0xc00322d0, 0xe5609090,
	0x40cc52f3, 0xb645a1c5, 0x4021e51e, 0xb851eb85, 0xbfffe560, 0x4189e948,
	0x40cd2db8, 0x10624dcd, 0xc0240000, 0x00000000, 0xbfe1fbe7, 0x6c8cc000,
	0x40cd2db8, 0x10624dcd, 0xc018d78d, 0x4fdf3b64, 0xc0083333, 0x33338bb0,
	0x40cd2db8, 0x10624dcd, 0xc0035e35, 0x3f7ced91, 0xbfe1b22d, 0x0e57592c,
	0x40cd2db8, 0x10624dcd, 0x3ff5e560, 0x4189374c, 0xbfde7ef9, 0xdb25eff0,
	0x40cd2db8, 0x10624dcd, 0x4014a1ca, 0xc083126e, 0x3ffdeb85, 0x1eb7ae80,
	0x40cd2db8, 0x10624dcd, 0x4021e51e, 0xb851eb85, 0xc0071893, 0x74bcc678,
	0x40ce087c, 0x6a7ef9d5, 0xc0240000, 0x00000000, 0xc0083958, 0x1062b000,
	0x40ce087c, 0x6a7ef9d5, 0xc018d78d, 0x4fdf3b64, 0xbfcced91, 0x68786600,
	0x40ce087c, 0x6a7ef9d5, 0xc0035e35, 0x3f7ced91, 0x3ff3374b, 0xc6a73f82,
	0x40ce087c, 0x6a7ef9d5, 0x3ff5e560, 0x4189374c, 0x3fe03126, 0xe97738a0,
	0x40ce087c, 0x6a7ef9d5, 0x4014a1ca, 0xc083126e, 0x3fef2b02, 0x0c4868d0,
	0x40ce087c, 0x6a7ef9d5, 0x4021e51e, 0xb851eb85, 0xc00e3e76, 0xc8b4984c,
	0x40cee340, 0xc49ba5dd, 0xc0240000, 0x00000000, 0x40120624, 0xdd2ee800,
	0x40cee340, 0xc49ba5dd, 0xc018d78d, 0x4fdf3b64, 0x40049581, 0x06247ef0,
	0x40cee340, 0xc49ba5dd, 0xc0035e35, 0x3f7ced91, 0x3fe11687, 0x2b00a0f0,
	0x40cee340, 0xc49ba5dd, 0x3ff5e560, 0x4189374c, 0x3fbeb851, 0xeb77d500,
	0x40cee340, 0xc49ba5dd, 0x4014a1ca, 0xc083126e, 0x3fb3f7ce, 0xd90ba500,
	0x40cee340, 0xc49ba5dd, 0x4021e51e, 0xb851eb85, 0x40111810, 0x624da1fa,
	0x40cfbe05, 0x1eb851e5, 0xc0240000, 0x00000000, 0x400051eb, 0x851e5000,
	0x40cfbe05, 0x1eb851e5, 0xc018d78d, 0x4fdf3b64, 0xbfead4fd, 0xf3b7ca20,
	0x40cfbe05, 0x1eb851e5, 0xc0035e35, 0x3f7ced91, 0xbfc10624, 0xdd34f490,
	0x40cfbe05, 0x1eb851e5, 0x3ff5e560, 0x4189374c, 0xbfd10624, 0xdd3286c0,
	0x40cfbe05, 0x1eb851e5, 0x4014a1ca, 0xc083126e, 0xbfea2d0e, 0x56057f90,
	0x40cfbe05, 0x1eb851e5, 0x4021e51e, 0xb851eb85, 0x400b0a3d, 0x70a37220,
	0x40d04c64, 0xbc6a7ef7, 0xc0240000, 0x00000000, 0xbfdb4395, 0x81090000,
	0x40d04c64, 0xbc6a7ef7, 0xc018d78d, 0x4fdf3b64, 0x3fff5e35, 0x3f7c4590,
	0x40d04c64, 0xbc6a7ef7, 0xc0035e35, 0x3f7ced91, 0xbfe99999, 0x999adb38,
	0x40d04c64, 0xbc6a7ef7, 0x3ff5e560, 0x4189374c, 0xbfe4dd2f, 0x1aa14160,
	0x40d04c64, 0xbc6a7ef7, 0x4014a1ca, 0xc083126e, 0xbffb6c8b, 0x439619e0,
	0x40d04c64, 0xbc6a7ef7, 0x4021e51e, 0xb851eb85, 0x4003e45a, 0x1cabb04c,
	0x40d0b9c6, 0xe978d4fb, 0xc0240000, 0x00000000, 0xc00722d0, 0xe560a000,
	0x40d0b9c6, 0xe978d4fb, 0xc018d78d, 0x4fdf3b64, 0xbff7374b, 0xc6a89d60,
	0x40d0b9c6, 0xe978d4fb, 0xc0035e35, 0x3f7ced91, 0x3fee872b, 0x020afcf8,
	0x40d0b9c6, 0xe978d4fb, 0x3ff5e560, 0x4189374c, 0x3fd526e9, 0x78d1de70,
	0x40d0b9c6, 0xe978d4fb, 0x4014a1ca, 0xc083126e, 0x4004624d, 0xd2f15ae0,
	0x40d0b9c6, 0xe978d4fb, 0x4021e51e, 0xb851eb85, 0x3ff97ced, 0x9167bcf0,
	0x40d12729, 0x16872aff, 0xc0240000, 0x00000000, 0x40129168, 0x72aff000,
	0x40d12729, 0x16872aff, 0xc018d78d, 0x4fdf3b64, 0x3ff59168, 0x72af6d40,
	0x40d12729, 0x16872aff, 0xc0035e35, 0x3f7ced91, 0x3fd25e35, 0x3f7a3dc8,
	0x40d12729, 0x16872aff, 0x3ff5e560, 0x4189374c, 0xbfac6a7e, 0xf9f4ec80,
	0x40d12729, 0x16872aff, 0x4014a1ca, 0xc083126e, 0x3ffa6e97, 0x8d4f3ba8,
	0x40d12729, 0x16872aff, 0x4021e51e, 0xb851eb85, 0x3fe6624d, 0xd2f03290,
	0x40d1948b, 0x43958103, 0xc0240000, 0x00000000, 0x40016872, 0xb0206000,
	0x40d1948b, 0x43958103, 0xc018d78d, 0x4fdf3b64, 0xc000820c, 0x49babad8,
	0x40d1948b, 0x43958103, 0xc0035e35, 0x3f7ced91, 0xbfd851eb, 0x85217e60,
	0x40d1948b, 0x43958103, 0x3ff5e560, 0x4189374c, 0xbfdc4189, 0x374f1990,
	0x40d1948b, 0x43958103, 0x4014a1ca, 0xc083126e, 0x3fe83126, 0xe9778320,
	0x40d1948b, 0x43958103, 0x4021e51e, 0xb851eb85, 0xbfc8d4fd, 0xf3bc5300,
	0x40d201ed, 0x70a3d707, 0xc0240000, 0x00000000, 0xbfd28f5c, 0x28f90000,
	0x40d201ed, 0x70a3d707, 0xc018d78d, 0x4fdf3b64, 0x3fe78937, 0x4bc529e0,
	0x40d201ed, 0x70a3d707, 0xc0035e35, 0x3f7ced91, 0xbff0c083, 0x126f4ea2,
	0x40d201ed, 0x70a3d707, 0x3ff5e560, 0x4189374c, 0x3fe14fdf, 0x3b62a3d0,
	0x40d201ed, 0x70a3d707, 0x4014a1ca, 0xc083126e, 0xbfc1eb85, 0x1ebdc440,
	0x40d201ed, 0x70a3d707, 0x4021e51e, 0xb851eb85, 0xbff16666, 0x66672e08,
	0x40d26f4f, 0x9db22d0b, 0xc0240000, 0x00000000, 0xc0060c49, 0xba5ea000,
	0x40d26f4f, 0x9db22d0b, 0xc018d78d, 0x4fdf3b64, 0xc0056872, 0xb0212700,
	0x40d26f4f, 0x9db22d0b, 0xc0035e35, 0x3f7ced91, 0x3fe69fbe, 0x76c73aec,
	0x40d26f4f, 0x9db22d0b, 0x3ff5e560, 0x4189374c, 0x3fc3d70a, 0x3d699740,
	0x40d26f4f, 0x9db22d0b, 0x4014a1ca, 0xc083126e, 0xbff09374, 0xbc6b32a0,
	0x40d26f4f, 0x9db22d0b, 0x4021e51e, 0xb851eb85, 0xbfffb22d, 0x0e56d1b0,
	0x40d2dcb1, 0xcac0830f, 0xc0240000, 0x00000000, 0x40131cac, 0x0830f000,
	0x40d2dcb1, 0xcac0830f, 0xc018d78d, 0x4fdf3b64, 0x3fbf7ced, 0x915bca00,
	0x40d2dcb1, 0xcac0830f, 0xc0035e35, 0x3f7ced91, 0x3fa47ae1, 0x4795cd80,
	0x40d2dcb1, 0xcac0830f, 0x3ff5e560, 0x4189374c, 0xbfcd9168, 0x72b760c0,
	0x40d2dcb1, 0xcac0830f, 0x4014a1ca, 0xc083126e, 0xbffee978, 0xd4feacb8,
	0x40d2dcb1, 0xcac0830f, 0x4021e51e, 0xb851eb85, 0xc006fef9, 0xdb233aac,
	0x40d34a13, 0xf7ced913, 0xc0240000, 0x00000000, 0x40027ef9, 0xdb226000,
	0x40d34a13, 0xf7ced913, 0xc018d78d, 0x4fdf3b64, 0x40076041, 0x8936e3a0,
	0x40d34a13, 0xf7ced913, 0xc0035e35, 0x3f7ced91, 0xbfe41062, 0x4dd4813c,
	0x40d34a13, 0xf7ced913, 0x3ff5e560, 0x4189374c, 0xbfe3be76, 0xc8b61630,
	0x40d34a13, 0xf7ced913, 0x4014a1ca, 0xc083126e, 0x4002a3d7, 0x0a3d1174,
	0x40d34a13, 0xf7ced913, 0x4021e51e, 0xb851eb85, 0xc00e24dd, 0x2f1b0c80,
	0x40d3b776, 0x24dd2f17, 0xc0240000, 0x00000000, 0xbfc3b645, 0xa1d20000,
	0x40d3b776, 0x24dd2f17, 0xc018d78d, 0x4fdf3b64, 0xbfdf53f7, 0xcedc6ec0,
	0x40d3b776, 0x24dd2f17, 0xc0035e35, 0x3f7ced91, 0x3ff20831, 0x26e8ab7a,
	0x40d3b776, 0x24dd2f17, 0x3ff5e560, 0x4189374c, 0x3fd7645a, 0x1ca834d0,
	0x40d3b776, 0x24dd2f17, 0x4014a1ca, 0xc083126e, 0x3ff6f1a9, 0xfbe6a8d0,
	0x40d3b776, 0x24dd2f17, 0x4021e51e, 0xb851eb85, 0x401124dd, 0x2f1a67e0,
	0x40d424d8, 0x51eb851b, 0xc0240000, 0x00000000, 0xc004f5c2, 0x8f5ca000,
	0x40d424d8, 0x51eb851b, 0xc018d78d, 0x4fdf3b64, 0x400279db, 0x22d07778,
	0x40d424d8, 0x51eb851b, 0xc0035e35, 0x3f7ced91, 0x3fdd70a3, 0xd706f1c0,
	0x40d424d8, 0x51eb851b, 0x3ff5e560, 0x4189374c, 0xbf94fdf3, 0xb6847300,
	0x40d424d8, 0x51eb851b, 0x4014a1ca, 0xc083126e, 0x3fe1374b, 0xc6a65d70,
	0x40d424d8, 0x51eb851b, 0x4021e51e, 0xb851eb85, 0x400b23d7, 0x0a3cfdec,
	0x40d4923a, 0x7ef9db1f, 0xc0240000, 0x00000000, 0x4013a7ef, 0x9db1f000,
	0x40d4923a, 0x7ef9db1f, 0xc018d78d, 0x4fdf3b64, 0xbff1a1ca, 0xc083f400,
	0x40d4923a, 0x7ef9db1f, 0xc0035e35, 0x3f7ced91, 0xbfca7ef9, 0xdb2994d0,
	0x40d4923a, 0x7ef9db1f, 0x3ff5e560, 0x4189374c, 0xbfda0418, 0x9378c330,
	0x40d4923a, 0x7ef9db1f, 0x4014a1ca, 0xc083126e, 0xbfd6e978, 0xd5012d80,
	0x40d4923a, 0x7ef9db1f, 0x4021e51e, 0xb851eb85, 0x4003fdf3, 0xb6452c18,
	0x40d4ff9c, 0xac083123, 0xc0240000, 0x00000000, 0x40039581, 0x06246000,
	0x40d4ff9c, 0xac083123, 0xc018d78d, 0x4fdf3b64, 0x3ffb26e9, 0x78d416a0,
	0x40d4ff9c, 0xac083123, 0xc0035e35, 0x3f7ced91, 0xbfebf7ce, 0xd9184348,
	0x40d4ff9c, 0xac083123, 0x3ff5e560, 0x4189374c, 0x3fe26e97, 0x8d4dcf00,
	0x40d4ff9c, 0xac083123, 0x4014a1ca, 0xc083126e, 0xbff41062, 0x4dd3c578,
	0x40d4ff9c, 0xac083123, 0x4021e51e, 0xb851eb85, 0x3ff9b020, 0xc49ab488,
	0x40d56cfe, 0xd9168727, 0xc0240000, 0x00000000, 0xbf926e97, 0x8d900000,
	0x40d56cfe, 0xd9168727, 0xc018d78d, 0x4fdf3b64, 0xbffb6e97, 0x8d50cc50,
	0x40d56cfe, 0xd9168727, 0xc0035e35, 0x3f7ced91, 0x3fec28f5, 0xc28d94e8,
	0x40d56cfe, 0xd9168727, 0x3ff5e560, 0x4189374c, 0x3fc851eb, 0x85164400,
	0x40d56cfe, 0xd9168727, 0x4014a1ca, 0xc083126e, 0xc0013333, 0x33339fc8,
	0x40d56cfe, 0xd9168727, 0x4021e51e, 0xb851eb85, 0x3fe6c8b4, 0x395621c0,
	0x40d5da61, 0x0624dd2b, 0xc0240000, 0x00000000, 0xc003df3b, 0x645aa000,
	0x40d5da61, 0x0624dd2b, 0xc018d78d, 0x4fdf3b64, 0x3ff15a1c, 0xac073e50,
	0x40d5da61, 0x0624dd2b, 0xc0035e35, 0x3f7ced91, 0x3fcb4395, 0x80fedb50,
	0x40d5da61, 0x0624dd2b, 0x3ff5e560, 0x4189374c, 0xbfc91687, 0x2b0ab400,
	0x40d5da61, 0x0624dd2b, 0x4014a1ca, 0xc083126e, 0x4000e560, 0x4188c808,
	0x40d5da61, 0x0624dd2b, 0x4021e51e, 0xb851eb85, 0xbfc73b64, 0x5a249640,
	0x40d647c3, 0x3333332f, 0xc0240000, 0x00000000, 0xc013cccc, 0xcccd1000,
	0x40d647c3, 0x3333332f, 0xc018d78d, 0x4fdf3b64, 0xc0029db2, 0x2d0ed250,
	0x40d647c3, 0x3333332f, 0xc0035e35, 0x3f7ced91, 0xbfdd0e56, 0x041c4e80,
	0x40d647c3, 0x3333332f, 0x3ff5e560, 0x4189374c, 0xbfe29fbe, 0x76caeb00,
	0x40d647c3, 0x3333332f, 0x4014a1ca, 0xc083126e, 0x3ff374bc, 0x6a7e15f8,
	0x40d647c3, 0x3333332f, 0x4021e51e, 0xb851eb85, 0xbff13333, 0x33343670,
	0x40d6b525, 0x60418933, 0xc0240000, 0x00000000, 0x4004ac08, 0x31266000,
	0x40d6b525, 0x60418933, 0xc018d78d, 0x4fdf3b64, 0x3fde353f, 0x7ce99800,
	0x40d6b525, 0x60418933, 0xc0035e35, 0x3f7ced91, 0xbff1ef9d, 0xb22e02aa,
	0x40d6b525, 0x60418933, 0x3ff5e560, 0x4189374c, 0x3fd9a1ca, 0xc07e8b30,
	0x40d6b525, 0x60418933, 0x4014a1ca, 0xc083126e, 0x3fd47ae1, 0x47aa6f80,
	0x40d6b525, 0x60418933, 0x4021e51e, 0xb851eb85, 0xbfff7ef9, 0xdb23da18,
	0x40d72287, 0x8d4fdf37, 0xc0240000, 0x00000000, 0x3fbe353f, 0x7cdc0000,
	0x40d72287, 0x8d4fdf37, 0xc018d78d, 0x4fdf3b64, 0xc0078418, 0x93753e78,
	0x40d72287, 0x8d4fdf37, 0xc0035e35, 0x3f7ced91, 0x3fe44189, 0x3749d2dc,
	0x40d72287, 0x8d4fdf37, 0x3ff5e560, 0x4189374c, 0x3f8db22d, 0x0dc1e600,
	0x40d72287, 0x8d4fdf37, 0x4014a1ca, 0xc083126e, 0xbfe26e97, 0x8d51bc70,
	0x40d72287, 0x8d4fdf37, 0x4021e51e, 0xb851eb85, 0xc006e560, 0x4189bee0,
	0x40d78fe9, 0xba5e353b, 0xc0240000, 0x00000000, 0xc002c8b4, 0x3958a000,
	0x40d78fe9, 0xba5e353b, 0xc018d78d, 0x4fdf3b64, 0xbfc1fbe7, 0x6c939280,
	0x40d78fe9, 0xba5e353b, 0xc0035e35, 0x3f7ced91, 0xbfa16872, 0xb040b380,
	0x40d78fe9, 0xba5e353b, 0x3ff5e560, 0x4189374c, 0xbfd7c6a7, 0xefa26cd0,
	0x40d78fe9, 0xba5e353b, 0x4014a1ca, 0xc083126e, 0xbff78d4f, 0xdf3c5850,
	0x40d78fe9, 0xba5e353b, 0x4021e51e, 0xb851eb85, 0xc00e0b43, 0x958190b4,
	0x40d7fd4b, 0xe76c8b3f, 0xc0240000, 0x00000000, 0xc0134189, 0x374c1000,
	0x40d7fd4b, 0xe76c8b3f, 0xc018d78d, 0x4fdf3b64, 0x4005449b, 0xa5e2cc28,
	0x40d7fd4b, 0xe76c8b3f, 0xc0035e35, 0x3f7ced91, 0xbfe66e97, 0x8d51e94c,
	0x40d7fd4b, 0xe76c8b3f, 0x3ff5e560, 0x4189374c, 0x3fe38d4f, 0xdf38fa30,
	0x40d7fd4b, 0xe76c8b3f, 0x4014a1ca, 0xc083126e, 0xc002f1a9, 0xfbe7e934,
	0x40d7fd4b, 0xe76c8b3f, 0x4021e51e, 0xb851eb85, 0x401131a9, 0xfbe725c6,
	0x40d86aae, 0x147ae143, 0xc0240000, 0x00000000, 0x4005c28f, 0x5c286000,
	0x40d86aae, 0x147ae143, 0xc018d78d, 0x4fdf3b64, 0xbfe81893, 0x74be9540,
	0x40d86aae, 0x147ae143, 0xc0035e35, 0x3f7ced91, 0x3ff0d916, 0x8729f772,
	0x40d86aae, 0x147ae143, 0x3ff5e560, 0x4189374c, 0x3fcccccc, 0xccc2f0c0,
	0x40d86aae, 0x147ae143, 0x4014a1ca, 0xc083126e, 0x3ffe4dd2, 0xf1a8fd38,
	0x40d86aae, 0x147ae143, 0x4021e51e, 0xb851eb85, 0x400b3d70, 0xa3d679b8,
	0x40d8d810, 0x41893747, 0xc0240000, 0x00000000, 0x3fd04189, 0x37470000,
	0x40d8d810, 0x41893747, 0xc018d78d, 0x4fdf3b64, 0x40005e35, 0x3f7c6000,
	0x40d8d810, 0x41893747, 0xc0035e35, 0x3f7ced91, 0x3fd8b439, 0x580c21a0,
	0x40d8d810, 0x41893747, 0x3ff5e560, 0x4189374c, 0xbfc49ba5, 0xe35e0740,
	0x40d8d810, 0x41893747, 0x4014a1ca, 0xc083126e, 0x3fefef9d, 0xb22b0640,
	0x40d8d810, 0x41893747, 0x4021e51e, 0xb851eb85, 0x4004178d, 0x4fdea7e4,
	0x40d94572, 0x6e978d4b, 0xc0240000, 0x00000000, 0xc001b22d, 0x0e56a000,
	0x40d94572, 0x6e978d4b, 0xc018d78d, 0x4fdf3b64, 0xbff5d916, 0x872c22f0,
	0x40d94572, 0x6e978d4b, 0xc0035e35, 0x3f7ced91, 0xbfd1fbe7, 0x6c8f9a88,
	0x40d94572, 0x6e978d4b, 0x3ff5e560, 0x4189374c, 0xbfe18106, 0x24dfbfd0,
	0x40d94572, 0x6e978d4b, 0x4014a1ca, 0xc083126e, 0x3fba1cac, 0x08209080,
	0x40d94572, 0x6e978d4b, 0x4021e51e, 0xb851eb85, 0x3ff9e353, 0xf7cdac20,
	0x40d9b2d4, 0x9ba5e34f, 0xc0240000, 0x00000000, 0xc012b645, 0xa1cb1000,
	0x40d9b2d4, 0x9ba5e34f, 0xc018d78d, 0x4fdf3b64, 0x3ff6ef9d, 0xb22be7b0,
	0x40d9b2d4, 0x9ba5e34f, 0xc0035e35, 0x3f7ced91, 0xbfee5604, 0x1895ab58,
	0x40d9b2d4, 0x9ba5e34f, 0x3ff5e560, 0x4189374c, 0x3fdbdf3b, 0x6454e190,
	0x40d9b2d4, 0x9ba5e34f, 0x4014a1ca, 0xc083126e, 0xbfe96872, 0xb022e220,
	0x40d9b2d4, 0x9ba5e34f, 0x4021e51e, 0xb851eb85, 0x3fe72f1a, 0x9fbc10f0,
	0x40da2036, 0xc8b43953, 0xc0240000, 0x00000000, 0x4006d916, 0x872a6000,
	0x40da2036, 0xc8b43953, 0xc018d78d, 0x4fdf3b64, 0xbfffa5e3, 0x53f8fb40,
	0x40da2036, 0xc8b43953, 0xc0035e35, 0x3f7ced91, 0x3fe9cac0, 0x83102cd8,
	0x40da2036, 0xc8b43953, 0x3ff5e560, 0x4189374c, 0x3fa95810, 0x62232c80,
	0x40da2036, 0xc8b43953, 0x4014a1ca, 0xc083126e, 0xbffb0a3d, 0x70a4eb28,
	0x40da2036, 0xc8b43953, 0x4021e51e, 0xb851eb85, 0xbfc5a1ca, 0xc08cd980,
	0x40da8d98, 0xf5c28f57, 0xc0240000, 0x00000000, 0x3fd8f5c2, 0x8f570000,
	0x40da8d98, 0xf5c28f57, 0xc018d78d, 0x4fdf3b64, 0x3fea45a1, 0xcabe1ec0,
	0x40da8d98, 0xf5c28f57, 0xc0035e35, 0x3f7ced91, 0x3fc1cac0, 0x83093b10,
	0x40da8d98, 0xf5c28f57, 0x3ff5e560, 0x4189374c, 0xbfd58937, 0x4bcc1670,
	0x40da8d98, 0xf5c28f57, 0x4014a1ca, 0xc083126e, 0x40049374, 0xbc69f23c,
	0x40da8d98, 0xf5c28f57, 0x4021e51e, 0xb851eb85, 0xbff10000, 0x00013ed8,
	0x40dafafb, 0x22d0e55b, 0xc0240000, 0x00000000, 0xc0009ba5, 0xe354a000,
	0x40dafafb, 0x22d0e55b, 0xc018d78d, 0x4fdf3b64, 0xc004b958, 0x1062e9c8,
	0x40dafafb, 0x22d0e55b, 0xc0035e35, 0x3f7ced91, 0xbfe0e560, 0x418b8f50,
	0x40dafafb, 0x22d0e55b, 0x3ff5e560, 0x4189374c, 0x3fe4ac08, 0x31242560,
	0x40dafafb, 0x22d0e55b, 0x4014a1ca, 0xc083126e, 0x3ffad0e5, 0x60406a60,
	0x40dafafb, 0x22d0e55b, 0x4021e51e, 0xb851eb85, 0xbfff4bc6, 0xa7f0e280,
	0x40db685d, 0x4fdf3b5f, 0xc0240000, 0x00000000, 0xc0122b02, 0x0c4a1000,
	0x40db685d, 0x4fdf3b5f, 0xc018d78d, 0x4fdf3b64, 0x3fcab020, 0xc491b880,
	0x40db685d, 0x4fdf3b5f, 0xc0035e35, 0x3f7ced91, 0xbff31eb8, 0x51ecb6b2,
	0x40db685d, 0x4fdf3b5f, 0x3ff5e560, 0x4189374c, 0x3fd0a3d7, 0x0a37cec0,
	0x40db685d, 0x4fdf3b5f, 0x4014a1ca, 0xc083126e, 0x3fe8f5c2, 0x8f59e090,
	0x40db685d, 0x4fdf3b5f, 0x4021e51e, 0xb851eb85, 0xc006cbc6, 0xa7f04314,
	0x40dbd5bf, 0x7ced9163, 0xc0240000, 0x00000000, 0x4007ef9d, 0xb22c6000,
	0x40dbd5bf, 0x7ced9163, 0xc018d78d, 0x4fdf3b64, 0x40080f5c, 0x28f520d8,
	0x40dbd5bf, 0x7ced9163, 0xc0035e35, 0x3f7ced91, 0x3fe1e353, 0xf7cc6acc,
	0x40dbd5bf, 0x7ced9163, 0x3ff5e560, 0x4189374c, 0xbfc020c4, 0x9bb15a80,
	0x40dbd5bf, 0x7ced9163, 0x4014a1ca, 0xc083126e, 0xbfbdb22d, 0x0e689d00,
	0x40dbd5bf, 0x7ced9163, 0x4021e51e, 0xb851eb85, 0xc00df1a9, 0xfbe814e8,
	0x40dc4321, 0xa9fbe767, 0xc0240000, 0x00000000, 0x3fe0d4fd, 0xf3b38000,
	0x40dc4321, 0xa9fbe767, 0xc018d78d, 0x4fdf3b64, 0xbfd9db22, 0xd0ea8500,
	0x40dc4321, 0xa9fbe767, 0xc0035e35, 0x3f7ced91, 0xbfbba5e3, 0x540b9a40,
	0x40dc4321, 0xa9fbe767, 0x3ff5e560, 0x4189374c, 0xbfe0624d, 0xd2f494a0,
	0x40dc4321, 0xa9fbe767, 0x4014a1ca, 0xc083126e, 0xbff03126, 0xe97a03e8,
	0x40dc4321, 0xa9fbe767, 0x4021e51e, 0xb851eb85, 0x40113e76, 0xc8b3e3ac,
	0x40dcb083, 0xd70a3d6b, 0xc0240000, 0x00000000, 0xbfff0a3d, 0x70a54000,
	0x40dcb083, 0xd70a3d6b, 0xc018d78d, 0x4fdf3b64, 0x400328f5, 0xc28eb4b0,
	0x40dcb083, 0xd70a3d6b, 0xc0035e35, 0x3f7ced91, 0xbfe8cccc, 0xcccf515c,
	0x40dcb083, 0xd70a3d6b, 0x3ff5e560, 0x4189374c, 0x3fde1cac, 0x082b37f0,
	0x40dcb083, 0xd70a3d6b, 0x4014a1ca, 0xc083126e, 0xbffe872b, 0x020d7e00,
	0x40dcb083, 0xd70a3d6b, 0x4021e51e, 0xb851eb85, 0x400b570a, 0x3d6ff584,
	0x40dd1de6, 0x0418936f, 0xc0240000, 0x00000000, 0xc0119fbe, 0x76c91000,
	0x40dd1de6, 0x0418936f, 0xc018d78d, 0x4fdf3b64, 0xbff04395, 0x81077990,
	0x40dd1de6, 0x0418936f, 0xc0035e35, 0x3f7ced91, 0x3fef53f7, 0xced686d4,
	0x40dd1de6, 0x0418936f, 0x3ff5e560, 0x4189374c, 0x3fb5a1ca, 0xc06aefc0,
	0x40dd1de6, 0x0418936f, 0x4014a1ca, 0xc083126e, 0x4002d4fd, 0xf3b5a8d0,
	0x40dd1de6, 0x0418936f, 0x4021e51e, 0xb851eb85, 0x40043126, 0xe97823b0,
	0x40dd8b48, 0x3126e973, 0xc0240000, 0x00000000, 0x40090624, 0xdd2e6000,
	0x40dd8b48, 0x3126e973, 0xc018d78d, 0x4fdf3b64, 0x3ffc851e, 0xb8509110,
	0x40dd8b48, 0x3126e973, 0xc0035e35, 0x3f7ced91, 0x3fd3f7ce, 0xd9115180,
	0x40dd8b48, 0x3126e973, 0x3ff5e560, 0x4189374c, 0xbfd34bc6, 0xa7f5c010,
	0x40dd8b48, 0x3126e973, 0x4014a1ca, 0xc083126e, 0x3ff753f7, 0xced7d788,
	0x40dd8b48, 0x3126e973, 0x4021e51e, 0xb851eb85, 0x3ffa1687, 0x2b00a3b8,
	0x40ddf8aa, 0x5e353f77, 0xc0240000, 0x00000000, 0x3fe52f1a, 0x9fbb8000,
	0x40ddf8aa, 0x5e353f77, 0xc018d78d, 0x4fdf3b64, 0xbffa1062, 0x4dd451e0,
	0x40ddf8aa, 0x5e353f77, 0xc0035e35, 0x3f7ced91, 0xbfd6b851, 0xeb8a6aa8,
	0x40ddf8aa, 0x5e353f77, 0x3ff5e560, 0x4189374c, 0x3fe5cac0, 0x830f5090,
	0x40ddf8aa, 0x5e353f77, 0x4014a1ca, 0xc083126e, 0x3fe1fbe7, 0x6c88bae0,
	0x40ddf8aa, 0x5e353f77, 0x4021e51e, 0xb851eb85, 0x3fe79581, 0x06220020,
	0x40de660c, 0x8b43957b, 0xc0240000, 0x00000000, 0xbffcdd2f, 0x1aa14000,
	0x40de660c, 0x8b43957b, 0xc018d78d, 0x4fdf3b64, 0x3ff2b851, 0xeb83b8c0,
	0x40de660c, 0x8b43957b, 0xc0035e35, 0x3f7ced91, 0xbff05a1c, 0xac0989b4,
	0x40de660c, 0x8b43957b, 0x3ff5e560, 0x4189374c, 0x3fd2e147, 0xae0e2520,
	0x40de660c, 0x8b43957b, 0x4014a1ca, 0xc083126e, 0xbfd56041, 0x893c72a0,
	0x40de660c, 0x8b43957b, 0x4021e51e, 0xb851eb85, 0xbfc40831, 0x26f51cc0,
	0x40ded36e, 0xb851eb7f, 0xc0240000, 0x00000000, 0xc011147a, 0xe1481000,
	0x40ded36e, 0xb851eb7f, 0xc018d78d, 0x4fdf3b64, 0xc001ee97, 0x8d509518,
	0x40ded36e, 0xb851eb7f, 0xc0035e35, 0x3f7ced91, 0x3fe76c8b, 0x4392c4c8,
	0x40ded36e, 0xb851eb7f, 0x3ff5e560, 0x4189374c, 0xbfb74bc6, 0xa8095b80,
	0x40ded36e, 0xb851eb7f, 0x4014a1ca, 0xc083126e, 0xbff3ae14, 0x7ae296c0,
	0x40ded36e, 0xb851eb7f, 0x4021e51e, 0xb851eb85, 0xbff0cccc, 0xccce4740,
	0x40df40d0, 0xe5604183, 0xc0240000, 0x00000000, 0x400a1cac, 0x08306000,
	0x40df40d0, 0xe5604183, 0xc018d78d, 0x4fdf3b64, 0x3fe1d70a, 0x3d6dc0e0,
	0x40df40d0, 0xe5604183, 0xc0035e35, 0x3f7ced91, 0x3fb0a3d7, 0x0a2735a0,
	0x40df40d0, 0xe5604183, 0x3ff5e560, 0x4189374c, 0xbfde872b, 0x0212d2e0,
	0x40df40d0, 0xe5604183, 0x4014a1ca, 0xc083126e, 0xc001020c, 0x49bb086c,
	0x40df40d0, 0xe5604183, 0x4021e51e, 0xb851eb85, 0xbfff1893, 0x74bdeae8,
	0x40dfae33, 0x126e9787, 0xc0240000, 0x00000000, 0x3fe98937, 0x4bc38000,
	0x40dfae33, 0x126e9787, 0xc018d78d, 0x4fdf3b64, 0xc006d4fd, 0xf3b70140,
	0x40dfae33, 0x126e9787, 0xc0035e35, 0x3f7ced91, 0xbfe34395, 0x8108f760,
	0x40dfae33, 0x126e9787, 0x3ff5e560, 0x4189374c, 0x3fe02d0e, 0x5600c728,
	0x40dfae33, 0x126e9787, 0x4014a1ca, 0xc083126e, 0x40011687, 0x2b015f64,
	0x40dfae33, 0x126e9787, 0x4021e51e, 0xb851eb85, 0xc006b22d, 0x0e56c748,
	0x40e00dca, 0x9fbe76c6, 0xc0240000, 0x00000000, 0xbffab020, 0xc49d0000,
	0x40e00dca, 0x9fbe76c6, 0xc018d78d, 0x4fdf3b64, 0xbfac28f5, 0xc2b6fc00,
	0x40e00dca, 0x9fbe76c6, 0xc0035e35, 0x3f7ced91, 0x3ff26e97, 0x8d4eb068,
	0x40e00dca, 0x9fbe76c6, 0x3ff5e560, 0x4189374c, 0x3fbe978d, 0x4fc84940,
	0x40e00dca, 0x9fbe76c6, 0x4014a1ca, 0xc083126e, 0x3ff3d70a, 0x3d6f84b0,
	0x40e00dca, 0x9fbe76c6, 0x4021e51e, 0xb851eb85, 0xc00dd810, 0x624e791c,
	0x40e0447b, 0xb645a1c8, 0xc0240000, 0x00000000, 0xc0108937, 0x4bc70000,
	0x40e0447b, 0xb645a1c8, 0xc018d78d, 0x4fdf3b64, 0x4005f3b6, 0x45a12960,
	0x40e0447b, 0xb645a1c8, 0xc0035e35, 0x3f7ced91, 0x3fdf0a3d, 0x709f0578,
	0x40e0447b, 0xb645a1c8, 0x3ff5e560, 0x4189374c, 0xbfd10e56, 0x041e69b0,
	0x40e0447b, 0xb645a1c8, 0x4014a1ca, 0xc083126e, 0x3fd60418, 0x93702a60,
	0x40e0447b, 0xb645a1c8, 0x4021e51e, 0xb851eb85, 0x40114b43, 0x9580b192,
	0x40e07b2c, 0xccccccca, 0xc0240000, 0x00000000, 0x400b3333, 0x33328000,
	0x40e07b2c, 0xccccccca, 0xc018d78d, 0x4fdf3b64, 0xbfe55c28, 0xf5c52060,
	0x40e07b2c, 0xccccccca, 0xc0035e35, 0x3f7ced91, 0xbfc74bc6, 0xa7f96d60,
	0x40e07b2c, 0xccccccca, 0x3ff5e560, 0x4189374c, 0xbfe4e147, 0xae1772d8,
	0x40e07b2c, 0xccccccca, 0x4014a1ca, 0xc083126e, 0xbfe1a9fb, 0xe76edf00,
	0x40e07b2c, 0xccccccca, 0x4021e51e, 0xb851eb85, 0x400b70a3, 0xd7099150,
	0x40e0b1dd, 0xe353f7cc, 0xc0240000, 0x00000000, 0x3fede353, 0xf7cc0000,
	0x40e0b1dd, 0xe353f7cc, 0xc018d78d, 0x4fdf3b64, 0x40010d4f, 0xdf3abd38,
	0x40e0b1dd, 0xe353f7cc, 0xc0035e35, 0x3f7ced91, 0xbfeb2b02, 0x0c4c396c,
	0x40e0b1dd, 0xe353f7cc, 0x3ff5e560, 0x4189374c, 0x3fd51eb8, 0x51e57b80,
	0x40e0b1dd, 0xe353f7cc, 0x4014a1ca, 0xc083126e, 0xbff72b02, 0x0c4ae998,
	0x40e0b1dd, 0xe353f7cc, 0x4021e51e, 0xb851eb85, 0x40044ac0, 0x8311bf7c,
	0x40e0e88e, 0xf9db22ce, 0xc0240000, 0x00000000, 0xbff88312, 0x6e990000,
	0x40e0e88e, 0xf9db22ce, 0xc018d78d, 0x4fdf3b64, 0xbff47ae1, 0x47af6880,
	0x40e0e88e, 0xf9db22ce, 0xc0035e35, 0x3f7ced91, 0x3fecf5c2, 0x8f599ec4,
	0x40e0e88e, 0xf9db22ce, 0x3ff5e560, 0x4189374c, 0xbfacac08, 0x31580400,
	0x40e0e88e, 0xf9db22ce, 0x4014a1ca, 0xc083126e, 0xc002c083, 0x126f31d8,
	0x40e0e88e, 0xf9db22ce, 0x4021e51e, 0xb851eb85, 0x3ffa49ba, 0x5e33db50,
	0x40e11f40, 0x10624dd0, 0xc0240000, 0x00000000, 0xc00ffbe7, 0x6c8c0000,
	0x40e11f40, 0x10624dd0, 0xc018d78d, 0x4fdf3b64, 0x3ff84dd2, 0xf1a8a220,
	0x40e11f40, 0x10624dd0, 0xc0035e35, 0x3f7ced91, 0x3fce76c8, 0xb42f02c0,
	0x40e11f40, 0x10624dd0, 0x3ff5e560, 0x4189374c, 0xbfdc49ba, 0x5e3b7c80,
	0x40e11f40, 0x10624dd0, 0x4014a1ca, 0xc083126e, 0x3ffeb020, 0xc49a6bf0,
	0x40e11f40, 0x10624dd0, 0x4021e51e, 0xb851eb85, 0x3fe7fbe7, 0x6c886f50,
	0x40e155f1, 0x26e978d2, 0xc0240000, 0x00000000, 0x400c49ba, 0x5e348000,
	0x40e155f1, 0x26e978d2, 0xc018d78d, 0x4fdf3b64, 0xbffe47ae, 0x147c40d0,
	0x40e155f1, 0x26e978d2, 0xc0035e35, 0x3f7ced91, 0xbfdb74bc, 0x6a843ac8,
	0x40e155f1, 0x26e978d2, 0x3ff5e560, 0x4189374c, 0x3fe14bc6, 0xa7ec7258,
	0x40e155f1, 0x26e978d2, 0x4014a1ca, 0xc083126e, 0x3ff05a1c, 0xac06f1d8,
	0x40e155f1, 0x26e978d2, 0x4021e51e, 0xb851eb85, 0xbfc26e97, 0x8d5b6000,
	0x40e18ca2, 0x3d70a3d4, 0xc0240000, 0x00000000, 0x3ff11eb8, 0x51ea0000,
	0x40e18ca2, 0x3d70a3d4, 0xc018d78d, 0x4fdf3b64, 0x3fed020c, 0x49b793a0,
	0x40e18ca2, 0x3d70a3d4, 0xc0035e35, 0x3f7ced91, 0xbff18937, 0x4bc7fdbc,
	0x40e18ca2, 0x3d70a3d4, 0x3ff5e560, 0x4189374c, 0x3fc3c6a7, 0xef90d160,
	0x40e18ca2, 0x3d70a3d4, 0x4014a1ca, 0xc083126e, 0x3fc020c4, 0x9b9bbe00,
	0x40e18ca2, 0x3d70a3d4, 0x4021e51e, 0xb851eb85, 0xbff09999, 0x999b0fa8,
	0x40e1c353, 0x53f7ced6, 0xc0240000, 0x00000000, 0xbff65604, 0x18950000,
	0x40e1c353, 0x53f7ced6, 0xc018d78d, 0x4fdf3b64, 0xc0040a3d, 0x70a48c90,
	0x40e1c353, 0x53f7ced6, 0xc0035e35, 0x3f7ced91, 0x3fe50e56, 0x0415dcb8,
	0x40e1c353, 0x53f7ced6, 0x3ff5e560, 0x4189374c, 0xbfcda1ca, 0xc09026a0,
	0x40e1c353, 0x53f7ced6, 0x4014a1ca, 0xc083126e, 0xbfe8a3d7, 0x0a4004b0,
	0x40e1c353, 0x53f7ced6, 0x4021e51e, 0xb851eb85, 0xbffee560, 0x418ab350,
	0x40e1fa04, 0x6a7ef9d8, 0xc0240000, 0x00000000, 0xc00ee560, 0x418a0000,
	0x40e1fa04, 0x6a7ef9d8, 0xc018d78d, 0x4fdf3b64, 0x3fd2d0e5, 0x603bc600,
	0x40e1fa04, 0x6a7ef9d8, 0xc0035e35, 0x3f7ced91, 0xbf826e97, 0x8e005700,
	0x40e1fa04, 0x6a7ef9d8, 0x3ff5e560, 0x4189374c, 0xbfe3c28f, 0x5c2c47a8,
	0x40e1fa04, 0x6a7ef9d8, 0x4014a1ca, 0xc083126e, 0xbffaa7ef, 0x9db37c70,
	0x40e1fa04, 0x6a7ef9d8, 0x4021e51e, 0xb851eb85, 0xc0069893, 0x74bd2b7c,
	0x40e230b5, 0x810624da, 0xc0240000, 0x00000000, 0x400d6041, 0x89368000,
	0x40e230b5, 0x810624da, 0xc018d78d, 0x4fdf3b64, 0x4008be76, 0xc8b37e10,
	0x40e230b5, 0x810624da, 0xc0035e35, 0x3f7ced91, 0xbfe5a1ca, 0xc085df70,
	0x40e230b5, 0x810624da, 0x3ff5e560, 0x4189374c, 0x3fd75c28, 0xf5bbd1e0,
	0x40e230b5, 0x810624da, 0x4014a1ca, 0xc083126e, 0xc0047ef9, 0xdb237b44,
	0x40e230b5, 0x810624da, 0x4021e51e, 0xb851eb85, 0xc00dbe76, 0xc8b4fd50,
	0x40e26766, 0x978d4fdc, 0xc0240000, 0x00000000, 0x3ff34bc6, 0xa7ee0000,
	0x40e26766, 0x978d4fdc, 0xc018d78d, 0x4fdf3b64, 0xbfd4624d, 0xd2f79b40,
	0x40e26766, 0x978d4fdc, 0xc0035e35, 0x3f7ced91, 0x3ff13f7c, 0xed8ffc60,
	0x40e26766, 0x978d4fdc, 0x3ff5e560, 0x4189374c, 0xbf958106, 0x254aa200,
	0x40e26766, 0x978d4fdc, 0x4014a1ca, 0xc083126e, 0x3ffb3333, 0x3331d918,
	0x40e26766, 0x978d4fdc, 0x4021e51e, 0xb851eb85, 0x40115810, 0x624d6f78,
	0x40e29e17, 0xae147ade, 0xc0240000, 0x00000000, 0xbff428f5, 0xc2910000,
	0x40e29e17, 0xae147ade, 0xc018d78d, 0x4fdf3b64, 0x4003d810, 0x624d11e8,
	0x40e29e17, 0xae147ade, 0xc0035e35, 0x3f7ced91, 0x3fda4dd2, 0xf1a43558,
	0x40e29e17, 0xae147ade, 0x3ff5e560, 0x4189374c, 0xbfda0c49, 0xba652620,
	0x40e29e17, 0xae147ade, 0x4014a1ca, 0xc083126e, 0x3fe9ba5e, 0x353cbe00,
	0x40e29e17, 0xae147ade, 0x4021e51e, 0xb851eb85, 0x400b8a3d, 0x70a30d1c,
	0x40e2d4c8, 0xc49ba5e0, 0xc0240000, 0x00000000, 0xc00dced9, 0x16880000,
	0x40e2d4c8, 0xc49ba5e0, 0xc018d78d, 0x4fdf3b64, 0xbfedcac0, 0x83157e40,
	0x40e2d4c8, 0xc49ba5e0, 0xc0035e35, 0x3f7ced91, 0xbfd0624d, 0xd2f786d0,
	0x40e2d4c8, 0xc49ba5e0, 0x3ff5e560, 0x4189374c, 0x3fe26a7e, 0xf9d79d88,
	0x40e2d4c8, 0xc49ba5e0, 0x4014a1ca, 0xc083126e, 0xbfb78d4f, 0xdf51b180,
	0x40e2d4c8, 0xc49ba5e0, 0x4021e51e, 0xb851eb85, 0x4004645a, 0x1cab3b48,
	0x40e30b79, 0xdb22d0e2, 0xc0240000, 0x00000000, 0x400e76c8, 0xb4388000,
	0x40e30b79, 0xdb22d0e2, 0xc018d78d, 0x4fdf3b64, 0x3ffde353, 0xf7cd4b80,
	0x40e30b79, 0xdb22d0e2, 0xc0035e35, 0x3f7ced91, 0xbfed8937, 0x4bc9a17c,
	0x40e30b79, 0xdb22d0e2, 0x3ff5e560, 0x4189374c, 0x3fc84189, 0x373d7e20,
	0x40e30b79, 0xdb22d0e2, 0x4014a1ca, 0xc083126e, 0xbfef9db2, 0x2d112a60,
	0x40e30b79, 0xdb22d0e2, 0x4021e51e, 0xb851eb85, 0x3ffa7ced, 0x9166d2e8,
	0x40e3422a, 0xf1a9fbe4, 0xc0240000, 0x00000000, 0x3ff578d4, 0xfdf20000,
	0x40e3422a, 0xf1a9fbe4, 0xc018d78d, 0x4fdf3b64, 0xbff8b22d, 0x0e579770,
	0x40e3422a, 0xf1a9fbe4, 0xc0035e35, 0x3f7ced91, 0x3fea978d, 0x4fdc36b4,
	0x40e3422a, 0xf1a9fbe4, 0x3ff5e560, 0x4189374c, 0xbfc926e9, 0x78e379e0,
	0x40e3422a, 0xf1a9fbe4, 0x4014a1ca, 0xc083126e, 0xbffe24dd, 0x2f1c0f48,
	0x40e3422a, 0xf1a9fbe4, 0x4021e51e, 0xb851eb85, 0x3fe8624d, 0xd2ee5e80,
	0x40e378dc, 0x083126e6, 0xc0240000, 0x00000000, 0xbff1fbe7, 0x6c8d0000,
	0x40e378dc, 0x083126e6, 0xc018d78d, 0x4fdf3b64, 0x3ff41687, 0x2b007330,
	0x40e378dc, 0x083126e6, 0xc0035e35, 0x3f7ced91, 0x3fc4fdf3, 0xb6396280,
	0x40e378dc, 0x083126e6, 0x3ff5e560, 0x4189374c, 0xbfe2a3d7, 0x0a411c78,
	0x40e378dc, 0x083126e6, 0x4014a1ca, 0xc083126e, 0x40030624, 0xdd2e602c,
	0x40e378dc, 0x083126e6, 0x4021e51e, 0xb851eb85, 0xbfc0d4fd, 0xf3c3a340,
	0x40e3af8d, 0x1eb851e8, 0xc0240000, 0x00000000, 0xc00cb851, 0xeb860000,
	0x40e3af8d, 0x1eb851e8, 0xc018d78d, 0x4fdf3b64, 0xc0013f7c, 0xed9237e0,
	0x40e3af8d, 0x1eb851e8, 0xc0035e35, 0x3f7ced91, 0xbfe01893, 0x74bf8574,
	0x40e3af8d, 0x1eb851e8, 0x3ff5e560, 0x4189374c, 0x3fd99999, 0x99922840,
	0x40e3af8d, 0x1eb851e8, 0x4014a1ca, 0xc083126e, 0x3ff7b645, 0xa1c94640,
	0x40e3af8d, 0x1eb851e8, 0x4021e51e, 0xb851eb85, 0xbff06666, 0x66681810,
	0x40e3e63e, 0x353f7cea, 0xc0240000, 0x00000000, 0x400f8d4f, 0xdf3a8000,
	0x40e3e63e, 0x353f7cea, 0xc018d78d, 0x4fdf3b64, 0x3fe49374, 0xbc6735c0,
	0x40e3e63e, 0x353f7cea, 0xc0035e35, 0x3f7ced91, 0xbff2b851, 0xeb86b1c4,
	0x40e3e63e, 0x353f7cea, 0x3ff5e560, 0x4189374c, 0x3f8cac08, 0x30358800,
	0x40e3e63e, 0x353f7cea, 0x4014a1ca, 0xc083126e, 0x3fe2c083, 0x126b9850,
	0x40e3e63e, 0x353f7cea, 0x4021e51e, 0xb851eb85, 0xbffeb22d, 0x0e57bbb8,
	0x40e41cef, 0x4bc6a7ec, 0xc0240000, 0x00000000, 0x3ff7a5e3, 0x53f60000,
	0x40e41cef, 0x4bc6a7ec, 0xc018d78d, 0x4fdf3b64, 0xc00625e3, 0x53f8a408,
	0x40e41cef, 0x4bc6a7ec, 0xc0035e35, 0x3f7ced91, 0x3fe2b020, 0xc49874a8,
	0x40e41cef, 0x4bc6a7ec, 0x3ff5e560, 0x4189374c, 0xbfd7ced9, 0x168ecfc0,
	0x40e41cef, 0x4bc6a7ec, 0x4014a1ca, 0xc083126e, 0xbfd3d70a, 0x3d76b7c0,
	0x40e41cef, 0x4bc6a7ec, 0x4021e51e, 0xb851eb85, 0xc0067ef9, 0xdb23afb0,
	0x40e453a0, 0x624dd2ee, 0xc0240000, 0x00000000, 0xbfef9db2, 0x2d120000,
	0x40e453a0, 0x624dd2ee, 0xc018d78d, 0x4fdf3b64, 0x3f9f3b64, 0x59b0a400,
	0x40e453a0, 0x624dd2ee, 0xc0035e35, 0x3f7ced91, 0xbfb53f7c, 0xedab4b60,
	0x40e453a0, 0x624dd2ee, 0x3ff5e560, 0x4189374c, 0x3fe38937, 0x4bc2c8b8,
	0x40e453a0, 0x624dd2ee, 0x4014a1ca, 0xc083126e, 0xbff34bc6, 0xa7f12808,
	0x40e453a0, 0x624dd2ee, 0x4021e51e, 0xb851eb85, 0xc00da4dd, 0x2f1b8184,
	0x40e48a51, 0x78d4fdf0, 0xc0240000, 0x00000000, 0xc00ba1ca, 0xc0840000,
	0x40e48a51, 0x78d4fdf0, 0xc018d78d, 0x4fdf3b64, 0x4006a2d0, 0xe55f6698,
	0x40e48a51, 0x78d4fdf0, 0xc0035e35, 0x3f7ced91, 0xbfe80000, 0x00034780,
	0x40e48a51, 0x78d4fdf0, 0x3ff5e560, 0x4189374c, 0x3fccbc6a, 0x7eea2ae0,
	0x40e48a51, 0x78d4fdf0, 0x4014a1ca, 0xc083126e, 0xc000d0e5, 0x60425110,
	0x40e48a51, 0x78d4fdf0, 0x4021e51e, 0xb851eb85, 0x401164dd, 0x2f1a2d5e,
	0x40e4c102, 0x8f5c28f2, 0xc0240000, 0x00000000, 0x401051eb, 0x851e4000,
	0x40e4c102, 0x8f5c28f2, 0xc018d78d, 0x4fdf3b64, 0xbfe29fbe, 0x76cc2b80,
	0x40e4c102, 0x8f5c28f2, 0xc0035e35, 0x3f7ced91, 0x3ff01062, 0x4dd14858,
	0x40e4c102, 0x8f5c28f2, 0x3ff5e560, 0x4189374c, 0xbfc4ac08, 0x3136cd20,
	0x40e4c102, 0x8f5c28f2, 0x4014a1ca, 0xc083126e, 0x400147ae, 0x147a16c0,
	0x40e4c102, 0x8f5c28f2, 0x4021e51e, 0xb851eb85, 0x400ba3d7, 0x0a3c88e8,
	0x40e4f7b3, 0xa5e353f4, 0xc0240000, 0x00000000, 0x3ff9d2f1, 0xa9fa0000,
	0x40e4f7b3, 0xa5e353f4, 0xc018d78d, 0x4fdf3b64, 0x4001bc6a, 0x7ef8fa70,
	0x40e4f7b3, 0xa5e353f4, 0xc0035e35, 0x3f7ced91, 0x3fd59168, 0x72a96538,
	0x40e4f7b3, 0xa5e353f4, 0x3ff5e560, 0x4189374c, 0xbfe1851e, 0xb855f148,
	0x40e4f7b3, 0xa5e353f4, 0x4014a1ca, 0xc083126e, 0x3ff43958, 0x1060b368,
	0x40e4f7b3, 0xa5e353f4, 0x4021e51e, 0xb851eb85, 0x40047df3, 0xb644b714,
	0x40e52e64, 0xbc6a7ef6, 0xc0240000, 0x00000000, 0xbfeb4395, 0x810a0000,
	0x40e52e64, 0xbc6a7ef6, 0xc018d78d, 0x4fdf3b64, 0xbff31cac, 0x0832ee10,
	0x40e52e64, 0xbc6a7ef6, 0xc0035e35, 0x3f7ced91, 0xbfd51eb8, 0x51f256f0,
	0x40e52e64, 0xbc6a7ef6, 0x3ff5e560, 0x4189374c, 0x3fdbd70a, 0x3d687ea0,
	0x40e52e64, 0xbc6a7ef6, 0x4014a1ca, 0xc083126e, 0x3fd78d4f, 0xdf34e540,
	0x40e52e64, 0xbc6a7ef6, 0x4021e51e, 0xb851eb85, 0x3ffab020, 0xc499ca80,
	0x40e56515, 0xd2f1a9f8, 0xc0240000, 0x00000000, 0xc00a8b43, 0x95820000,
	0x40e56515, 0xd2f1a9f8, 0xc018d78d, 0x4fdf3b64, 0x3ff9ac08, 0x31251c90,
	0x40e56515, 0xd2f1a9f8, 0xc0035e35, 0x3f7ced91, 0xbfefe76c, 0x8b47098c,
	0x40e56515, 0xd2f1a9f8, 0x3ff5e560, 0x4189374c, 0x3fa91687, 0x2ac01500,
	0x40e56515, 0xd2f1a9f8, 0x4014a1ca, 0xc083126e, 0xbfe0e560, 0x418c8190,
	0x40e56515, 0xd2f1a9f8, 0x4021e51e, 0xb851eb85, 0x3fe8c8b4, 0x39544db0,
	0x40e59bc6, 0xe978d4fa, 0xc0240000, 0x00000000, 0x4010dd2f, 0x1a9f4000,
	0x40e59bc6, 0xe978d4fa, 0xc018d78d, 0x4fdf3b64, 0xbffce978, 0xd4ffc660,
	0x40e59bc6, 0xe978d4fa, 0xc0035e35, 0x3f7ced91, 0x3fe83958, 0x105ecea4,
	0x40e59bc6, 0xe978d4fa, 0x3ff5e560, 0x4189374c, 0xbfd59168, 0x72b87960,
	0x40e59bc6, 0xe978d4fa, 0x4014a1ca, 0xc083126e, 0xbff6c8b4, 0x3959bae0,
	0x40e59bc6, 0xe978d4fa, 0x4021e51e, 0xb851eb85, 0xbfbe76c8, 0xb457cd00,
	0x40e5d277, 0xfffffffc, 0xc0240000, 0x00000000, 0x3ffbffff, 0xfffe0000,
	0x40e5d277, 0xfffffffc, 0xc018d78d, 0x4fdf3b64, 0x3fefbe76, 0xc8b08880,
	0x40e5d277, 0xfffffffc, 0xc0035e35, 0x3f7ced91, 0x3fb70a3d, 0x70878480,
	0x40e5d277, 0xfffffffc, 0x3ff5e560, 0x4189374c, 0x3fe4a7ef, 0x9dadf3e8,
	0x40e5d277, 0xfffffffc, 0x4014a1ca, 0xc083126e, 0xc0028f5c, 0x28f69a7c,
	0x40e5d277, 0xfffffffc, 0x4021e51e, 0xb851eb85, 0xbff03333, 0x33352078,
	0x40e60929, 0x16872afe, 0xc0240000, 0x00000000, 0xbfe6e978, 0xd5020000,
	0x40e60929, 0x16872afe, 0xc018d78d, 0x4fdf3b64, 0xc0035b22, 0xd0e64f58,
	0x40e60929, 0x16872afe, 0xc0035e35, 0x3f7ced91, 0xbfe276c8, 0xb43ced84,
	0x40e60929, 0x16872afe, 0x3ff5e560, 0x4189374c, 0x3fd09ba5, 0xe34b6bd0,
	0x40e60929, 0x16872afe, 0x4014a1ca, 0xc083126e, 0x3fff126e, 0x978b9aa8,
	0x40e60929, 0x16872afe, 0x4021e51e, 0xb851eb85, 0xbffe7ef9, 0xdb24c420,
	0x40e63fda, 0x2d0e5600, 0xc0240000, 0x00000000, 0xc00974bc, 0x6a800000,
	0x40e63fda, 0x2d0e5600, 0xc018d78d, 0x4fdf3b64, 0x3fd849ba, 0x5e2dafc0,
	0x40e63fda, 0x2d0e5600, 0xc0035e35, 0x3f7ced91, 0x3ff2d4fd, 0xf3b47556,
	0x40e63fda, 0x2d0e5600, 0x3ff5e560, 0x4189374c, 0xbfc03126, 0xe98a2060,
	0x40e63fda, 0x2d0e5600, 0x4014a1ca, 0xc083126e, 0x3ff0bc6a, 0x7ef82090,
	0x40e63fda, 0x2d0e5600, 0x4021e51e, 0xb851eb85, 0xc0066560, 0x418a33e4,
	0x40e6768b, 0x43958102, 0xc0240000, 0x00000000, 0x40116872, 0xb0204000,
	0x40e6768b, 0x43958102, 0xc018d78d, 0x4fdf3b64, 0xc0084189, 0x374cbb80,
	0x40e6768b, 0x43958102, 0xc0035e35, 0x3f7ced91, 0x3fe051eb, 0x851b0c98,
	0x40e6768b, 0x43958102, 0x3ff5e560, 0x4189374c, 0xbfe06666, 0x666ac618,
	0x40e6768b, 0x43958102, 0x4014a1ca, 0xc083126e, 0x3fc33333, 0x332533c0,
	0x40e6768b, 0x43958102, 0x4021e51e, 0xb851eb85, 0xc00d8b43, 0x958205b8,
	0x40e6ad3c, 0x5a1cac04, 0xc0240000, 0x00000000, 0x3ffe2d0e, 0x56020000,
	0x40e6ad3c, 0x5a1cac04, 0xc018d78d, 0x4fdf3b64, 0xbfcdd2f1, 0xaa0b6300,
	0x40e6ad3c, 0x5a1cac04, 0xc0035e35, 0x3f7ced91, 0xbfc41893, 0x74cb45f0,
	0x40e6ad3c, 0x5a1cac04, 0x3ff5e560, 0x4189374c, 0x3fde147a, 0xe13ed500,
	0x40e6ad3c, 0x5a1cac04, 0x4014a1ca, 0xc083126e, 0xbfe7df3b, 0x645da740,
	0x40e6ad3c, 0x5a1cac04, 0x4021e51e, 0xb851eb85, 0x401171a9, 0xfbe6eb44,
	0x40e6e3ed, 0x70a3d706, 0xc0240000, 0x00000000, 0xbfe28f5c, 0x28fa0000,
	0x40e6e3ed, 0x70a3d706, 0xc018d78d, 0x4fdf3b64, 0x4004872b, 0x020b4f20,
	0x40e6e3ed, 0x70a3d706, 0xc0035e35, 0x3f7ced91, 0xbfea5e35, 0x3f80af90,
	0x40e6e3ed, 0x70a3d706, 0x3ff5e560, 0x4189374c, 0x3fb58106, 0x24b96400,
	0x40e6e3ed, 0x70a3d706, 0x4014a1ca, 0xc083126e, 0xbffa45a1, 0xcac24db8,
	0x40e6e3ed, 0x70a3d706, 0x4021e51e, 0xb851eb85, 0x400bbd70, 0xa3d604b4,
	0x40e71a9e, 0x872b0208, 0xc0240000, 0x00000000, 0xc0085e35, 0x3f7e0000,
	0x40e71a9e, 0x872b0208, 0xc018d78d, 0x4fdf3b64, 0xbfeb0e56, 0x041c8960,
	0x40e71a9e, 0x872b0208, 0xc0035e35, 0x3f7ced91, 0x3fedc28f, 0x5c2528a0,
	0x40e71a9e, 0x872b0208, 0x3ff5e560, 0x4189374c, 0xbfd353f7, 0xcee22300,
	0x40e71a9e, 0x872b0208, 0x4014a1ca, 0xc083126e, 0xc0044dd2, 0xf1aae3e8,
	0x40e71a9e, 0x872b0208, 0x4021e51e, 0xb851eb85, 0x4004978d, 0x4fde32e0,
	0x40e7514f, 0x9db22d0a, 0xc0240000, 0x00000000, 0x4011f3b6, 0x45a14000,
	0x40e7514f, 0x9db22d0a, 0xc018d78d, 0x4fdf3b64, 0x3fff4189, 0x3749c5f0,
	0x40e7514f, 0x9db22d0a, 0xc0035e35, 0x3f7ced91, 0x3fd0d4fd, 0xf3ae9518,
	0x40e7514f, 0x9db22d0a, 0x3ff5e560, 0x4189374c, 0x3fe5c6a7, 0xef991f18,
	0x40e7514f, 0x9db22d0a, 0x4014a1ca, 0xc083126e, 0x3ffb9581, 0x062307d0,
	0x40e7514f, 0x9db22d0a, 0x4021e51e, 0xb851eb85, 0x3ffae353, 0xf7ccc218,
	0x40e78800, 0xb439580c, 0xc0240000, 0x00000000, 0x40002d0e, 0x56030000,
	0x40e78800, 0xb439580c, 0xc018d78d, 0x4fdf3b64, 0xbff753f7, 0xcedb1d00,
	0x40e78800, 0xb439580c, 0xc0035e35, 0x3f7ced91, 0xbfd9db22, 0xd0ed2710,
	0x40e78800, 0xb439580c, 0x3ff5e560, 0x4189374c, 0x3fd2d916, 0x8721c230,
	0x40e78800, 0xb439580c, 0x4014a1ca, 0xc083126e, 0x3fea7ef9, 0xdb1f1b70,
	0x40e78800, 0xb439580c, 0x4021e51e, 0xb851eb85, 0x3fe92f1a, 0x9fba3ce0,
	0x40e7beb1, 0xcac0830e, 0xc0240000, 0x00000000, 0xbfdc6a7e, 0xf9e40000,
	0x40e7beb1, 0xcac0830e, 0xc018d78d, 0x4fdf3b64, 0x3ff574bc, 0x6a7ceda0,
	0x40e7beb1, 0xcac0830e, 0xc0035e35, 0x3f7ced91, 0xbff122d0, 0xe56238ce,
	0x40e7beb1, 0xcac0830e, 0x3ff5e560, 0x4189374c, 0xbfb76c8b, 0x43bae740,
	0x40e7beb1, 0xcac0830e, 0x4014a1ca, 0xc083126e, 0xbfb16872, 0xb03ec600,
	0x40e7beb1, 0xcac0830e, 0x4021e51e, 0xb851eb85, 0xbfbb4395, 0x81285380,
	0x40e7f562, 0xe147ae10, 0xc0240000, 0x00000000, 0xc00747ae, 0x147c0000,
	0x40e7f562, 0xe147ae10, 0xc018d78d, 0x4fdf3b64, 0xc0009062, 0x4dd3faa8,
	0x40e7f562, 0xe147ae10, 0xc0035e35, 0x3f7ced91, 0x3fe5db22, 0xd0e16694,
	0x40e7f562, 0xe147ae10, 0x3ff5e560, 0x4189374c, 0xbfde8f5c, 0x28ff35d0,
	0x40e7f562, 0xe147ae10, 0x4014a1ca, 0xc083126e, 0xbfeed916, 0x872eccf0,
	0x40e7f562, 0xe147ae10, 0x4021e51e, 0xb851eb85, 0xbff00000, 0x000228e0,
	0x40e82c13, 0xf7ced912, 0xc0240000, 0x00000000, 0x40127ef9, 0xdb224000,
	0x40e82c13, 0xf7ced912, 0xc018d78d, 0x4fdf3b64, 0x3fe74fdf, 0x3b602aa0,
	0x40e82c13, 0xf7ced912, 0xc0035e35, 0x3f7ced91, 0x3f90624d, 0xd2711000,
	0x40e82c13, 0xf7ced912, 0x3ff5e560, 0x4189374c, 0x3fe028f5, 0xc28a95b0,
	0x40e82c13, 0xf7ced912, 0x4014a1ca, 0xc083126e, 0xbffdc28f, 0x5c2ae090,
	0x40e82c13, 0xf7ced912, 0x4021e51e, 0xb851eb85, 0xbffe4bc6, 0xa7f1cc88,
	0x40e862c5, 0x0e560414, 0xc0240000, 0x00000000, 0x40014395, 0x81050000,
	0x40e862c5, 0x0e560414, 0xc018d78d, 0x4fdf3b64, 0xc00576c8, 0xb43a66d0,
	0x40e862c5, 0x0e560414, 0xc0035e35, 0x3f7ced91, 0xbfe4d4fd, 0xf3ba5594,
	0x40e862c5, 0x0e560414, 0x3ff5e560, 0x4189374c, 0x3fbe76c8, 0xb412bd80,
	0x40e862c5, 0x0e560414, 0x4014a1ca, 0xc083126e, 0x4003374b, 0xc6a6f788,
	0x40e862c5, 0x0e560414, 0x4021e51e, 0xb851eb85, 0xc0064bc6, 0xa7f0b818,
	0x40e89976, 0x24dd2f16, 0xc0240000, 0x00000000, 0xbfd3b645, 0xa1d40000,
	0x40e89976, 0x24dd2f16, 0xc018d78d, 0x4fdf3b64, 0x3fbdb22d, 0x0e33d000,
	0x40e89976, 0x24dd2f16, 0xc0035e35, 0x3f7ced91, 0x3ff1a5e3, 0x53f5c14e,
	0x40e89976, 0x24dd2f16, 0x3ff5e560, 0x4189374c, 0xbfd11687, 0x2b0bcca0,
	0x40e89976, 0x24dd2f16, 0x4014a1ca, 0xc083126e, 0x3ff81893, 0x74ba74f8,
	0x40e89976, 0x24dd2f16, 0x4021e51e, 0xb851eb85, 0xc00d71a9, 0xfbe889ec,
	0x40e8d027, 0x3b645a18, 0xc0240000, 0x00000000, 0xc0063126, 0xe97a0000,
	0x40e8d027, 0x3b645a18, 0xc018d78d, 0x4fdf3b64, 0x400751eb, 0x851da3d0,
	0x40e8d027, 0x3b645a18, 0xc0035e35, 0x3f7ced91, 0x3fdbe76c, 0x8b3b4910,
	0x40e8d027, 0x3b645a18, 0x3ff5e560, 0x4189374c, 0xbfe4e560, 0x418e2450,
	0x40e8d027, 0x3b645a18, 0x4014a1ca, 0xc083126e, 0x3fe3851e, 0xb84df5c0,
	0x40e8d027, 0x3b645a18, 0x4021e51e, 0xb851eb85, 0x40117e76, 0xc8b3a92a,
	0x40e906d8, 0x51eb851a, 0xc0240000, 0x00000000, 0x40130a3d, 0x70a34000,
	0x40e906d8, 0x51eb851a, 0xc018d78d, 0x4fdf3b64, 0xbfdfc6a7, 0xefa66d40,
	0x40e906d8, 0x51eb851a, 0xc0035e35, 0x3f7ced91, 0xbfcd9168, 0x72c0e630,
	0x40e906d8, 0x51eb851a, 0x3ff5e560, 0x4189374c, 0x3fd51687, 0x2af81890,
	0x40e906d8, 0x51eb851a, 0x4014a1ca, 0xc083126e, 0xbfd24dd2, 0xf1b1fce0,
	0x40e906d8, 0x51eb851a, 0x4021e51e, 0xb851eb85, 0x400bd70a, 0x3d6f8080,
	0x40e93d89, 0x6872b01c, 0xc0240000, 0x00000000, 0x40025a1c, 0xac070000,
	0x40e93d89, 0x6872b01c, 0xc018d78d, 0x4fdf3b64, 0x40026b85, 0x1eb737a8,
	0x40e93d89, 0x6872b01c, 0xc0035e35, 0x3f7ced91, 0xbfecbc6a, 0x7efe17a0,
	0x40e93d89, 0x6872b01c, 0x3ff5e560, 0x4189374c, 0xbfaced91, 0x68c31b80,
	0x40e93d89, 0x6872b01c, 0x4014a1ca, 0xc083126e, 0xbff2e978, 0xd4fff950,
	0x40e93d89, 0x6872b01c, 0x4021e51e, 0xb851eb85, 0x4004b126, 0xe977aeac,
	0x40e9743a, 0x7ef9db1e, 0xc0240000, 0x00000000, 0xbfc60418, 0x93880000,
	0x40e9743a, 0x7ef9db1e, 0xc018d78d, 0x4fdf3b64, 0xbff1be76, 0xc8b673a0,
	0x40e9743a, 0x7ef9db1e, 0xc0035e35, 0x3f7ced91, 0x3feb645a, 0x1ca7c090,
	0x40e9743a, 0x7ef9db1e, 0x3ff5e560, 0x4189374c, 0xbfdc51eb, 0x8528df70,
	0x40e9743a, 0x7ef9db1e, 0x4014a1ca, 0xc083126e, 0xc0009fbe, 0x76c9b9b4,
	0x40e9743a, 0x7ef9db1e, 0x4021e51e, 0xb851eb85, 0x3ffb1687, 0x2affb9b0,
	0x40e9aaeb, 0x95810620, 0xc0240000, 0x00000000, 0xc0051a9f, 0xbe780000,
	0x40e9aaeb, 0x95810620, 0xc018d78d, 0x4fdf3b64, 0x3ffb0a3d, 0x70a19700,
	0x40e9aaeb, 0x95810620, 0xc0035e35, 0x3f7ced91, 0x3fc83126, 0xe96789f0,
	0x40e9aaeb, 0x95810620, 0x3ff5e560, 0x4189374c, 0x3fe147ae, 0x1475c0e0,
	0x40e9aaeb, 0x95810620, 0x4014a1ca, 0xc083126e, 0x400178d4, 0xfdf2ae1c,
	0x40e9aaeb, 0x95810620, 0x4021e51e, 0xb851eb85, 0x3fe99581, 0x06202c10,
	0x40e9e19c, 0xac083122, 0xc0240000, 0x00000000, 0x40139581, 0x06244000,
	0x40e9e19c, 0xac083122, 0xc018d78d, 0x4fdf3b64, 0xbffb8b43, 0x95834bf0,
	0x40e9e19c, 0xac083122, 0xc0035e35, 0x3f7ced91, 0xbfde978d, 0x4fe7f730,
	0x40e9e19c, 0xac083122, 0x3ff5e560, 0x4189374c, 0x3fc3b645, 0xa1b60b80,
	0x40e9e19c, 0xac083122, 0x4014a1ca, 0xc083126e, 0x3ff49ba5, 0xe351e220,
	0x40e9e19c, 0xac083122, 0x4021e51e, 0xb851eb85, 0xbfb81062, 0x4df8da00,
	0x40ea184d, 0xc28f5c24, 0xc0240000, 0x00000000, 0x400370a3, 0xd7090000,
	0x40ea184d, 0xc28f5c24, 0xc018d78d, 0x4fdf3b64, 0x3ff13d70, 0xa3d4beb0,
	0x40ea184d, 0xc28f5c24, 0xc0035e35, 0x3f7ced91, 0xbff251eb, 0x8520ecd6,
	0x40ea184d, 0xc28f5c24, 0x3ff5e560, 0x4189374c, 0xbfcdb22d, 0x0e6aec80,
	0x40ea184d, 0xc28f5c24, 0x4014a1ca, 0xc083126e, 0x3fd91687, 0x2af9a020,
	0x40ea184d, 0xc28f5c24, 0x4021e51e, 0xb851eb85, 0xbfef9999, 0x999e6290,
	0x40ea4efe, 0xd9168726, 0xc0240000, 0x00000000, 0xbfa26e97, 0x8da00000,
	0x40ea4efe, 0xd9168726, 0xc018d78d, 0x4fdf3b64, 0xc002ac08, 0x31281220,
	0x40ea4efe, 0xd9168726, 0xc0035e35, 0x3f7ced91, 0x3fe37ced, 0x9163fe84,
	0x40ea4efe, 0xd9168726, 0x3ff5e560, 0x4189374c, 0xbfe3c6a7, 0xefa2f920,
	0x40ea4efe, 0xd9168726, 0x4014a1ca, 0xc083126e, 0xbfe020c4, 0x9baa2420,
	0x40ea4efe, 0xd9168726, 0x4021e51e, 0xb851eb85, 0xbffe1893, 0x74bed4f0,
	0x40ea85af, 0xef9db228, 0xc0240000, 0x00000000, 0xc0040418, 0x93760000,
	0x40ea85af, 0xef9db228, 0xc018d78d, 0x4fdf3b64, 0x3fddc28f, 0x5c1f9980,
	0x40ea85af, 0xef9db228, 0xc0035e35, 0x3f7ced91, 0xbfadb22d, 0x0e9df900,
	0x40ea85af, 0xef9db228, 0x3ff5e560, 0x4189374c, 0x3fd753f7, 0xcece6ef0,
	0x40ea85af, 0xef9db228, 0x4014a1ca, 0xc083126e, 0xbff66666, 0x66688c28,
	0x40ea85af, 0xef9db228, 0x4021e51e, 0xb851eb85, 0xc006322d, 0x0e573c4c,
	0x40eabc61, 0x0624dd2a, 0xc0240000, 0x00000000, 0xc013df3b, 0x645ac000,
	0x40eabc61, 0x0624dd2a, 0xc018d78d, 0x4fdf3b64, 0xc007926e, 0x978e7e48,
	0x40eabc61, 0x0624dd2a, 0xc0035e35, 0x3f7ced91, 0xbfe73333, 0x3337bda4,
	0x40eabc61, 0x0624dd2a, 0x3ff5e560, 0x4189374c, 0xbf960418, 0x9420d100,
	0x40eabc61, 0x0624dd2a, 0x4014a1ca, 0xc083126e, 0xc0025e35, 0x3f7e0320,
	0x40eabc61, 0x0624dd2a, 0x4021e51e, 0xb851eb85, 0xc00d5810, 0x624f0e20,
	0x40eaf312, 0x1cac082c, 0xc0240000, 0x00000000, 0x4004872b, 0x020b0000,
	0x40eaf312, 0x1cac082c, 0xc018d78d, 0x4fdf3b64, 0xbfc2e147, 0xae278f80,
	0x40eaf312, 0x1cac082c, 0xc0035e35, 0x3f7ced91, 0x3ff076c8, 0xb4370d46,
	0x40eaf312, 0x1cac082c, 0x3ff5e560, 0x4189374c, 0xbfda147a, 0xe1528910,
	0x40eaf312, 0x1cac082c, 0x4014a1ca, 0xc083126e, 0x3fff74bc, 0x6a7cc960,
	0x40eaf312, 0x1cac082c, 0x4021e51e, 0xb851eb85, 0x40118b43, 0x95806710,
	0x40eb29c3, 0x3333332e, 0xc0240000, 0x00000000, 0x3fb99999, 0x99700000,
	0x40eb29c3, 0x3333332e, 0xc018d78d, 0x4fdf3b64, 0x40053645, 0xa1c98c58,
	0x40eb29c3, 0x3333332e, 0xc0035e35, 0x3f7ced91, 0x3fd72b02, 0x0c4078f0,
	0x40eb29c3, 0x3333332e, 0x3ff5e560, 0x4189374c, 0x3fe26666, 0x6660ec10,
	0x40eb29c3, 0x3333332e, 0x4014a1ca, 0xc083126e, 0x3ff11eb8, 0x51e94f48,
	0x40eb29c3, 0x3333332e, 0x4021e51e, 0xb851eb85, 0x400bf0a3, 0xd708fc4c,
	0x40eb6074, 0x49ba5e30, 0xc0240000, 0x00000000, 0xc002ed91, 0x68740000,
	0x40eb6074, 0x49ba5e30, 0xc018d78d, 0x4fdf3b64, 0xbfe851eb, 0x85239480,
	0x40eb6074, 0x49ba5e30, 0xc0035e35, 0x3f7ced91, 0xbfd3851e, 0xb85b4338,
	0x40eb6074, 0x49ba5e30, 0x3ff5e560, 0x4189374c, 0x3fc83126, 0xe962b840,
	0x40eb6074, 0x49ba5e30, 0x4014a1ca, 0xc083126e, 0x3fc645a1, 0xcaaea980,
	0x40eb6074, 0x49ba5e30, 0x4021e51e, 0xb851eb85, 0x4004cac0, 0x83112a78,
	0x40eb9725, 0x60418932, 0xc0240000, 0x00000000, 0xc01353f7, 0xced9c000,
	0x40eb9725, 0x60418932, 0xc018d78d, 0x4fdf3b64, 0x40004fdf, 0x3b632030,
	0x40eb9725, 0x60418932, 0xc0035e35, 0x3f7ced91, 0xbfef1a9f, 0xbe7b7fb0,
	0x40eb9725, 0x60418932, 0x3ff5e560, 0x4189374c, 0xbfc9374b, 0xc6be3fc0,
	0x40eb9725, 0x60418932, 0x4014a1ca, 0xc083126e, 0xbfe71a9f, 0xbe7b49d0,
	0x40eb9725, 0x60418932, 0x4021e51e, 0xb851eb85, 0x3ffb49ba, 0x5e32b148,
	0x40ebcdd6, 0x76c8b434, 0xc0240000, 0x00000000, 0x40059db2, 0x2d0d0000,
	0x40ebcdd6, 0x76c8b434, 0xc018d78d, 0x4fdf3b64, 0xbff5f5c2, 0x8f5ea290,
	0x40ebcdd6, 0x76c8b434, 0xc0035e35, 0x3f7ced91, 0x3fe90624, 0xdd2a5880,
	0x40ebcdd6, 0x76c8b434, 0x3ff5e560, 0x4189374c, 0xbfe2a7ef, 0x9db7cdf0,
	0x40ebcdd6, 0x76c8b434, 0x4014a1ca, 0xc083126e, 0xbff9e353, 0xf7d11f00,
	0x40ebcdd6, 0x76c8b434, 0x4021e51e, 0xb851eb85, 0x3fe9fbe7, 0x6c861b40,
	0x40ec0487, 0x8d4fdf36, 0xc0240000, 0x00000000, 0x3fce353f, 0x7cd80000,
	0x40ec0487, 0x8d4fdf36, 0xc018d78d, 0x4fdf3b64, 0x3ff6d2f1, 0xa9f96810,
	0x40ec0487, 0x8d4fdf36, 0xc0035e35, 0x3f7ced91, 0x3fbd70a3, 0xd6e3d360,
	0x40ec0487, 0x8d4fdf36, 0x3ff5e560, 0x4189374c, 0x3fd99168, 0x72a4c550,
	0x40ec0487, 0x8d4fdf36, 0x4014a1ca, 0xc083126e, 0xc0041cac, 0x08324c8c,
	0x40ec0487, 0x8d4fdf36, 0x4021e51e, 0xb851eb85, 0xbfb4dd2f, 0x1ac96080,
	0x40ec3b38, 0xa3d70a38, 0xc0240000, 0x00000000, 0xc001d70a, 0x3d720000,
	0x40ec3b38, 0xa3d70a38, 0xc018d78d, 0x4fdf3b64, 0xbfffc28f, 0x5c2b7ae0,
	0x40ec3b38, 0xa3d70a38, 0xc0035e35, 0x3f7ced91, 0xbfe1a9fb, 0xe77163a8,
	0x40ec3b38, 0xa3d70a38, 0x3ff5e560, 0x4189374c, 0x3f8ba5e3, 0x52892a00,
	0x40ec3b38, 0xa3d70a38, 0x4014a1ca, 0xc083126e, 0x3ffbf7ce, 0xd9143688,
	0x40ec3b38, 0xa3d70a38, 0x4021e51e, 0xb851eb85, 0xbfef3333, 0x33387360,
	0x40ec71e9, 0xba5e353a, 0xc0240000, 0x00000000, 0xc012c8b4, 0x3958c000,
	0x40ec71e9, 0xba5e353a, 0xc018d78d, 0x4fdf3b64, 0x3fea0c49, 0xba591f80,
	0x40ec71e9, 0xba5e353a, 0xc0035e35, 0x3f7ced91, 0x3ff33b64, 0x5a1a3a44,
	0x40ec71e9, 0xba5e353a, 0x3ff5e560, 0x4189374c, 0xbfd7d70a, 0x3d7c32b0,
	0x40ec71e9, 0xba5e353a, 0x4014a1ca, 0xc083126e, 0x3feb4395, 0x810178e0,
	0x40ec71e9, 0xba5e353a, 0x4021e51e, 0xb851eb85, 0xbffde560, 0x418bdd58,
	0x40eca89a, 0xd0e5603c, 0xc0240000, 0x00000000, 0x4006b439, 0x580f0000,
	0x40eca89a, 0xd0e5603c, 0xc018d78d, 0x4fdf3b64, 0xc004c7ae, 0x147c2998,
	0x40eca89a, 0xd0e5603c, 0xc0035e35, 0x3f7ced91, 0x3fe11eb8, 0x51e69674,
	0x40eca89a, 0xd0e5603c, 0x3ff5e560, 0x4189374c, 0x3fe3851e, 0xb84c1740,
	0x40eca89a, 0xd0e5603c, 0x4014a1ca, 0xc083126e, 0xbfa6872b, 0x0257b500,
	0x40eca89a, 0xd0e5603c, 0x4021e51e, 0xb851eb85, 0xc0061893, 0x74bdc080,
	0x40ecdf4b, 0xe76c8b3e, 0xc0240000, 0x00000000, 0x3fd7ced9, 0x167c0000,
	0x40ecdf4b, 0xe76c8b3e, 0xc018d78d, 0x4fdf3b64, 0x3fc9cac0, 0x82fdbb80,
	0x40ecdf4b, 0xe76c8b3e, 0xc0035e35, 0x3f7ced91, 0xbfc0e560, 0x419d1e80,
	0x40ecdf4b, 0xe76c8b3e, 0x3ff5e560, 0x4189374c, 0x3fccac08, 0x310f6500,
	0x40ecdf4b, 0xe76c8b3e, 0x4014a1ca, 0xc083126e, 0xbfee147a, 0xe14c6f80,
	0x40ecdf4b, 0xe76c8b3e, 0x4021e51e, 0xb851eb85, 0xc00d3e76, 0xc8b59254,
	0x40ed15fc, 0xfdf3b640, 0xc0240000, 0x00000000, 0xc000c083, 0x12700000,
	0x40ed15fc, 0xfdf3b640, 0xc018d78d, 0x4fdf3b64, 0x40080106, 0x24dbe108,
	0x40ed15fc, 0xfdf3b640, 0xc0035e35, 0x3f7ced91, 0xbfe99168, 0x72b525b4,
	0x40ed15fc, 0xfdf3b640, 0x3ff5e560, 0x4189374c, 0xbfc4bc6a, 0x7f119300,
	0x40ed15fc, 0xfdf3b640, 0x4014a1ca, 0xc083126e, 0xbffd6041, 0x8939b1d8,
	0x40ed15fc, 0xfdf3b640, 0x4021e51e, 0xb851eb85, 0x40119810, 0x624d24f6,
	0x40ed4cae, 0x147ae142, 0xc0240000, 0x00000000, 0xc0123d70, 0xa3d7c000,
	0x40ed4cae, 0x147ae142, 0xc018d78d, 0x4fdf3b64, 0xbfda4dd2, 0xf1b48380,
	0x40ed4cae, 0x147ae142, 0xc0035e35, 0x3f7ced91, 0x3fee8f5c, 0x28f0b27c,
	0x40ed4cae, 0x147ae142, 0x3ff5e560, 0x4189374c, 0xbfe18937, 0x4bcca2c0,
	0x40ed4cae, 0x147ae142, 0x4014a1ca, 0xc083126e, 0x40036872, 0xb01f8ee4,
	0x40ed4cae, 0x147ae142, 0x4021e51e, 0xb851eb85, 0x400c0a3d, 0x70a27818,
	0x40ed835f, 0x2b020c44, 0xc0240000, 0x00000000, 0x4007cac0, 0x83110000,
	0x40ed835f, 0x2b020c44, 0xc018d78d, 0x4fdf3b64, 0x40031a9f, 0xbe7574e0,
	0x40ed835f, 0x2b020c44, 0xc0035e35, 0x3f7ced91, 0x3fd26e97, 0x8d45a8d0,
	0x40ed835f, 0x2b020c44, 0x3ff5e560, 0x4189374c, 0x3fdbced9, 0x167b1bb0,
	0x40ed835f, 0x2b020c44, 0x4014a1ca, 0xc083126e, 0x3ff87ae1, 0x47aba3b0,
	0x40ed835f, 0x2b020c44, 0x4021e51e, 0xb851eb85, 0x4004e45a, 0x1caaa644,
	0x40edba10, 0x41893746, 0xc0240000, 0x00000000, 0x3fe04189, 0x37460000,
	0x40edba10, 0x41893746, 0xc018d78d, 0x4fdf3b64, 0xbff06041, 0x8939f930,
	0x40edba10, 0x41893746, 0xc0035e35, 0x3f7ced91, 0xbfd84189, 0x37561358,
	0x40edba10, 0x41893746, 0x3ff5e560, 0x4189374c, 0x3fa8d4fd, 0xf354fd80,
	0x40edba10, 0x41893746, 0x4014a1ca, 0xc083126e, 0x3fe449ba, 0x5e305330,
	0x40edba10, 0x41893746, 0x4021e51e, 0xb851eb85, 0x3ffb7ced, 0x9165a8e0,
	0x40edf0c1, 0x58106248, 0xc0240000, 0x00000000, 0xbfff53f7, 0xcedc0000,
	0x40edf0c1, 0x58106248, 0xc018d78d, 0x4fdf3b64, 0x3ffc6872, 0xb01e1170,
	0x40edf0c1, 0x58106248, 0xc0035e35, 0x3f7ced91, 0xbff0bc6a, 0x7efc73e0,
	0x40edf0c1, 0x58106248, 0x3ff5e560, 0x4189374c, 0xbfd59999, 0x99a5dc50,
	0x40edf0c1, 0x58106248, 0x4014a1ca, 0xc083126e, 0xbfd0c49b, 0xa5ed4200,
	0x40edf0c1, 0x58106248, 0x4021e51e, 0xb851eb85, 0x3fea624d, 0xd2ec0a70,
	0x40ee2772, 0x6e978d4a, 0xc0240000, 0x00000000, 0xc011b22d, 0x0e56c000,
	0x40ee2772, 0x6e978d4a, 0xc018d78d, 0x4fdf3b64, 0xbffa2d0e, 0x5606d180,
	0x40ee2772, 0x6e978d4a, 0xc0035e35, 0x3f7ced91, 0x3fe6a7ef, 0x9dacf070,
	0x40ee2772, 0x6e978d4a, 0x3ff5e560, 0x4189374c, 0x3fe4a3d7, 0x0a374270,
	0x40ee2772, 0x6e978d4a, 0x4014a1ca, 0xc083126e, 0xbff2872b, 0x020eca98,
	0x40ee2772, 0x6e978d4a, 0x4021e51e, 0xb851eb85, 0xbfb1a9fb, 0xe799e700,
	0x40ee5e23, 0x851eb84c, 0xc0240000, 0x00000000, 0x4008e147, 0xae130000,
	0x40ee5e23, 0x851eb84c, 0xc018d78d, 0x4fdf3b64, 0x3ff29ba5, 0xe3513920,
	0x40ee5e23, 0x851eb84c, 0xc0035e35, 0x3f7ced91, 0x3fa4fdf3, 0xb5f125c0,
	0x40ee5e23, 0x851eb84c, 0x3ff5e560, 0x4189374c, 0x3fd09374, 0xbc5e08e0,
	0x40ee5e23, 0x851eb84c, 0x4014a1ca, 0xc083126e, 0xc0006e97, 0x8d512258,
	0x40ee5e23, 0x851eb84c, 0x4021e51e, 0xb851eb85, 0xbfeecccc, 0xccd28430,
	0x40ee94d4, 0x9ba5e34e, 0xc0240000, 0x00000000, 0x3fe49ba5, 0xe34e0000,
	0x40ee94d4, 0x9ba5e34e, 0xc018d78d, 0x4fdf3b64, 0xc001fced, 0x9169d4e8,
	0x40ee94d4, 0x9ba5e34e, 0xc0035e35, 0x3f7ced91, 0xbfe40831, 0x26eecbb8,
	0x40ee94d4, 0x9ba5e34e, 0x3ff5e560, 0x4189374c, 0xbfc04189, 0x3764e640,
	0x40ee94d4, 0x9ba5e34e, 0x4014a1ca, 0xc083126e, 0x4001a9fb, 0xe76b4578,
	0x40ee94d4, 0x9ba5e34e, 0x4021e51e, 0xb851eb85, 0xbffdb22d, 0x0e58e5c0,
	0x40eecb85, 0xb22d0e50, 0xc0240000, 0x00000000, 0xbffd26e9, 0x78d80000,
	0x40eecb85, 0xb22d0e50, 0xc018d78d, 0x4fdf3b64, 0x3fe19db2, 0x2d08c1a0,
	0x40eecb85, 0xb22d0e50, 0xc0035e35, 0x3f7ced91, 0x3ff20c49, 0xba5b863c,
	0x40eecb85, 0xb22d0e50, 0x3ff5e560, 0x4189374c, 0xbfe06a7e, 0xf9e17790,
	0x40eecb85, 0xb22d0e50, 0x4014a1ca, 0xc083126e, 0x3ff4fdf3, 0xb64310d8,
	0x40eecb85, 0xb22d0e50, 0x4021e51e, 0xb851eb85, 0xc005fef9, 0xdb2444b4,
	0x40ef0236, 0xc8b43952, 0xc0240000, 0x00000000, 0xc01126e9, 0x78d5c000,
	0x40ef0236, 0xc8b43952, 0xc018d78d, 0x4fdf3b64, 0xc006e353, 0xf7d04110,
	0x40ef0236, 0xc8b43952, 0xc0035e35, 0x3f7ced91, 0x3fdd8106, 0x24d25cc8,
	0x40ef0236, 0xc8b43952, 0x3ff5e560, 0x4189374c, 0x3fde0c49, 0xba517210,
	0x40ef0236, 0xc8b43952, 0x4014a1ca, 0xc083126e, 0x3fda9fbe, 0x76be5b00,
	0x40ef0236, 0xc8b43952, 0x4021e51e, 0xb851eb85, 0xc00d24dd, 0x2f1c1688,
	0x40ef38e7, 0xdf3b6454, 0xc0240000, 0x00000000, 0x4009f7ce, 0xd9150000,
	0x40ef38e7, 0xdf3b6454, 0xc018d78d, 0x4fdf3b64, 0xbfafbe76, 0xc90ef000,
	0x40ef38e7, 0xdf3b6454, 0xc0035e35, 0x3f7ced91, 0xbfca5e35, 0x3f92bec0,
	0x40ef38e7, 0xdf3b6454, 0x3ff5e560, 0x4189374c, 0x3fb56041, 0x8903d840,
	0x40ef38e7, 0xdf3b6454, 0x4014a1ca, 0xc083126e, 0xbfdeb851, 0xeb8f8d60,
	0x40ef38e7, 0xdf3b6454, 0x4021e51e, 0xb851eb85, 0x4011a4dd, 0x2f19e2dc,
	0x40ef6f98, 0xf5c28f56, 0xc0240000, 0x00000000, 0x3fe8f5c2, 0x8f560000,
	0x40ef6f98, 0xf5c28f56, 0xc018d78d, 0x4fdf3b64, 0x4005e560, 0x4187c990,
	0x40ef6f98, 0xf5c28f56, 0xc0035e35, 0x3f7ced91, 0xbfebef9d, 0xb2328dc4,
	0x40ef6f98, 0xf5c28f56, 0x3ff5e560, 0x4189374c, 0xbfd35c28, 0xf5cf85f0,
	0x40ef6f98, 0xf5c28f56, 0x4014a1ca, 0xc083126e, 0xbff60418, 0x93775d70,
	0x40ef6f98, 0xf5c28f56, 0x4021e51e, 0xb851eb85, 0x400c23d7, 0x0a3bf3e4,
	0x40efa64a, 0x0c49ba58, 0xc0240000, 0x00000000, 0xbffaf9db, 0x22d40000,
	0x40efa64a, 0x0c49ba58, 0xc018d78d, 0x4fdf3b64, 0xbfe59581, 0x062a9fa0,
	0x40efa64a, 0x0c49ba58, 0xc0035e35, 0x3f7ced91, 0x3fec3126, 0xe9734a6c,
	0x40efa64a, 0x0c49ba58, 0x3ff5e560, 0x4189374c, 0x3fe5c28f, 0x5c226da0,
	0x40efa64a, 0x0c49ba58, 0x4014a1ca, 0xc083126e, 0xc0022d0e, 0x56056bc4,
	0x40efa64a, 0x0c49ba58, 0x4021e51e, 0xb851eb85, 0x4004fdf3, 0xb6442210,
	0x40efdcfb, 0x22d0e55a, 0xc0240000, 0x00000000, 0xc0109ba5, 0xe354c000,
	0x40efdcfb, 0x22d0e55a, 0xc018d78d, 0x4fdf3b64, 0x4000fef9, 0xdb215d68,
	0x40efdcfb, 0x22d0e55a, 0xc0035e35, 0x3f7ced91, 0x3fcb645a, 0x1c95b160,
	0x40efdcfb, 0x22d0e55a, 0x3ff5e560, 0x4189374c, 0x3fd2d0e5, 0x60345f40,
	0x40efdcfb, 0x22d0e55a, 0x4014a1ca, 0xc083126e, 0x3fffd70a, 0x3d6df818,
	0x40efdcfb, 0x22d0e55a, 0x4021e51e, 0xb851eb85, 0x3ffbb020, 0xc498a078,
	0x40f009d6, 0x1cac082e, 0xc0240000, 0x00000000, 0x400b0e56, 0x04170000,
	0x40f009d6, 0x1cac082e, 0xc018d78d, 0x4fdf3b64, 0xbff4978d, 0x4fe22820,
	0x40f009d6, 0x1cac082e, 0xc0035e35, 0x3f7ced91, 0xbfdcfdf3, 0xb650e378,
	0x40f009d6, 0x1cac082e, 0x3ff5e560, 0x4189374c, 0xbfb78d4f, 0xdf707300,
	0x40f009d6, 0x1cac082e, 0x4014a1ca, 0xc083126e, 0x3ff18106, 0x24da7e00,
	0x40f009d6, 0x1cac082e, 0x4021e51e, 0xb851eb85, 0x3feac8b4, 0x3951f9a0,
	0x40f0252e, 0xa7ef9daf, 0xc0240000, 0x00000000, 0x3fed4fdf, 0x3b5e0000,
	0x40f0252e, 0xa7ef9daf, 0xc018d78d, 0x4fdf3b64, 0x3ff83126, 0xe975e280,
	0x40f0252e, 0xa7ef9daf, 0xc0035e35, 0x3f7ced91, 0xbff1eb85, 0x1ebb27e8,
	0x40f0252e, 0xa7ef9daf, 0x3ff5e560, 0x4189374c, 0xbfde978d, 0x4fec98c0,
	0x40f0252e, 0xa7ef9daf, 0x4014a1ca, 0xc083126e, 0x3fc95810, 0x62381f40,
	0x40f0252e, 0xa7ef9daf, 0x4021e51e, 0xb851eb85, 0xbfaced91, 0x68d4db00,
	0x40f04087, 0x33333330, 0xc0240000, 0x00000000, 0xbff8cccc, 0xccd00000,
	0x40f04087, 0x33333330, 0xc018d78d, 0x4fdf3b64, 0xbffe645a, 0x1caf0070,
	0x40f04087, 0x33333330, 0xc0035e35, 0x3f7ced91, 0x3fe449ba, 0x5e2f8860,
	0x40f04087, 0x33333330, 0x3ff5e560, 0x4189374c, 0x3fe024dd, 0x2f13e438,
	0x40f04087, 0x33333330, 0x4014a1ca, 0xc083126e, 0xbfe65604, 0x1898ec60,
	0x40f04087, 0x33333330, 0x4021e51e, 0xb851eb85, 0xbfee6666, 0x666c9500,
	0x40f05bdf, 0xbe76c8b1, 0xc0240000, 0x00000000, 0xc0101062, 0x4dd3c000,
	0x40f05bdf, 0xbe76c8b1, 0xc018d78d, 0x4fdf3b64, 0x3fecc8b4, 0x39521460,
	0x40f05bdf, 0xbe76c8b1, 0xc0035e35, 0x3f7ced91, 0xbfa0e560, 0x41e55b40,
	0x40f05bdf, 0xbe76c8b1, 0x3ff5e560, 0x4189374c, 0x3fbe5604, 0x185d31c0,
	0x40f05bdf, 0xbe76c8b1, 0x4014a1ca, 0xc083126e, 0xbff98106, 0x24dff048,
	0x40f05bdf, 0xbe76c8b1, 0x4021e51e, 0xb851eb85, 0xbffd7ef9, 0xdb25ee28,
	0x40f07738, 0x49ba5e32, 0xc0240000, 0x00000000, 0x400c24dd, 0x2f190000,
	0x40f07738, 0x49ba5e32, 0xc018d78d, 0x4fdf3b64, 0xc0041893, 0x74bdec60,
	0x40f07738, 0x49ba5e32, 0xc0035e35, 0x3f7ced91, 0xbfe66666, 0x666c33c8,
	0x40f07738, 0x49ba5e32, 0x3ff5e560, 0x4189374c, 0xbfd11eb8, 0x51f92f90,
	0x40f07738, 0x49ba5e32, 0x4014a1ca, 0xc083126e, 0xc003eb85, 0x1eb9b530,
	0x40f07738, 0x49ba5e32, 0x4021e51e, 0xb851eb85, 0xc005e560, 0x418ac8e8,
	0x40f09290, 0xd4fdf3b3, 0xc0240000, 0x00000000, 0x3ff0d4fd, 0xf3b30000,
	0x40f09290, 0xd4fdf3b3, 0xc018d78d, 0x4fdf3b64, 0x3fd25e35, 0x3f70c780,
	0x40f09290, 0xd4fdf3b3, 0xc0035e35, 0x3f7ced91, 0x3ff0dd2f, 0x1a9cd234,
	0x40f09290, 0xd4fdf3b3, 0x3ff5e560, 0x4189374c, 0xbfe4e978, 0xd504d5c8,
	0x40f09290, 0xd4fdf3b3, 0x4014a1ca, 0xc083126e, 0x3ffc5a1c, 0xac056540,
	0x40f09290, 0xd4fdf3b3, 0x4021e51e, 0xb851eb85, 0xc00d0b43, 0x95829abc,
	0x40f0ade9, 0x60418934, 0xc0240000, 0x00000000, 0xbff69fbe, 0x76cc0000,
	0x40f0ade9, 0x60418934, 0xc018d78d, 0x4fdf3b64, 0x4008b020, 0xc49a1e40,
	0x40f0ade9, 0x60418934, 0xc0035e35, 0x3f7ced91, 0x3fd8c49b, 0xa5d78ca8,
	0x40f0ade9, 0x60418934, 0x3ff5e560, 0x4189374c, 0x3fd50e56, 0x040ab5a0,
	0x40f0ade9, 0x60418934, 0x4014a1ca, 0xc083126e, 0x3fec0831, 0x26e3d650,
	0x40f0ade9, 0x60418934, 0x4021e51e, 0xb851eb85, 0x4011b1a9, 0xfbe6a0c2,
	0x40f0c941, 0xeb851eb5, 0xc0240000, 0x00000000, 0xc00f0a3d, 0x70a58000,
	0x40f0c941, 0xeb851eb5, 0xc018d78d, 0x4fdf3b64, 0xbfd4d4fd, 0xf3c299c0,
	0x40f0c941, 0xeb851eb5, 0xc0035e35, 0x3f7ced91, 0xbfd1eb85, 0x1ec42f80,
	0x40f0c941, 0xeb851eb5, 0x3ff5e560, 0x4189374c, 0xbfad2f1a, 0xa02e3300,
	0x40f0c941, 0xeb851eb5, 0x4014a1ca, 0xc083126e, 0xbf947ae1, 0x4863bc00,
	0x40f0c941, 0xeb851eb5, 0x4021e51e, 0xb851eb85, 0x400c3d70, 0xa3d56fb0,
	0x40f0e49a, 0x76c8b436, 0xc0240000, 0x00000000, 0x400d3b64, 0x5a1b0000,
	0x40f0e49a, 0x76c8b436, 0xc018d78d, 0x4fdf3b64, 0x4003c9ba, 0x5e33b218,
	0x40f0e49a, 0x76c8b436, 0xc0035e35, 0x3f7ced91, 0xbfee4dd2, 0xf1aff5d4,
	0x40f0e49a, 0x76c8b436, 0x3ff5e560, 0x4189374c, 0xbfdc5a1c, 0xac164260,
	0x40f0e49a, 0x76c8b436, 0x4014a1ca, 0xc083126e, 0xbfed4fdf, 0x3b6a1210,
	0x40f0e49a, 0x76c8b436, 0x4021e51e, 0xb851eb85, 0x4005178d, 0x4fdd9ddc,
	0x40f0fff3, 0x020c49b7, 0xc0240000, 0x00000000, 0x3ff3020c, 0x49b70000,
	0x40f0fff3, 0x020c49b7, 0xc018d78d, 0x4fdf3b64, 0xbfee0418, 0x937afd80,
	0x40f0fff3, 0x020c49b7, 0xc0035e35, 0x3f7ced91, 0x3fe9d2f1, 0xa9f5e25c,
	0x40f0fff3, 0x020c49b7, 0x3ff5e560, 0x4189374c, 0x3fe14395, 0x80ff0f68,
	0x40f0fff3, 0x020c49b7, 0x4014a1ca, 0xc083126e, 0xbffcfdf3, 0xb6488320,
	0x40f0fff3, 0x020c49b7, 0x4021e51e, 0xb851eb85, 0x3ffbe353, 0xf7cb9810,
	0x40f11b4b, 0x8d4fdf38, 0xc0240000, 0x00000000, 0xbff472b0, 0x20c80000,
	0x40f11b4b, 0x8d4fdf38, 0xc018d78d, 0x4fdf3b64, 0x3ffdc6a7, 0xef9a8be0,
	0x40f11b4b, 0x8d4fdf38, 0xc0035e35, 0x3f7ced91, 0x3fc1eb85, 0x1ea01120,
	0x40f11b4b, 0x8d4fdf38, 0x3ff5e560, 0x4189374c, 0x3fc3a5e3, 0x53db45a0,
	0x40f11b4b, 0x8d4fdf38, 0x4014a1ca, 0xc083126e, 0x40039999, 0x99982640,
	0x40f11b4b, 0x8d4fdf38, 0x4021e51e, 0xb851eb85, 0x3feb2f1a, 0x9fb7e8d0,
	0x40f136a4, 0x189374b9, 0xc0240000, 0x00000000, 0xc00df3b6, 0x45a38000,
	0x40f136a4, 0x189374b9, 0xc018d78d, 0x4fdf3b64, 0xbff8ced9, 0x168a5710,
	0x40f136a4, 0x189374b9, 0xc0035e35, 0x3f7ced91, 0xbfe0dd2f, 0x1aa5d9cc,
	0x40f136a4, 0x189374b9, 0x3ff5e560, 0x4189374c, 0xbfcdc28f, 0x5c45b260,
	0x40f136a4, 0x189374b9, 0x4014a1ca, 0xc083126e, 0x3ff8dd2f, 0x1a9cd268,
	0x40f136a4, 0x189374b9, 0x4021e51e, 0xb851eb85, 0xbfa6872b, 0x0275e800,
	0x40f151fc, 0xa3d70a3a, 0xc0240000, 0x00000000, 0x400e51eb, 0x851d0000,
	0x40f151fc, 0xa3d70a3a, 0xc018d78d, 0x4fdf3b64, 0x3ff3f9db, 0x22cdb390,
	0x40f151fc, 0xa3d70a3a, 0xc0035e35, 0x3f7ced91, 0xbff31a9f, 0xbe79dbf0,
	0x40f151fc, 0xa3d70a3a, 0x3ff5e560, 0x4189374c, 0xbfe3cac0, 0x8319aa98,
	0x40f151fc, 0xa3d70a3a, 0x4014a1ca, 0xc083126e, 0x3fe50e56, 0x0412b0a0,
	0x40f151fc, 0xa3d70a3a, 0x4021e51e, 0xb851eb85, 0xbfee0000, 0x0006a5d0,
	0x40f16d55, 0x2f1a9fbb, 0xc0240000, 0x00000000, 0x3ff52f1a, 0x9fbb0000,
	0x40f16d55, 0x2f1a9fbb, 0xc018d78d, 0x4fdf3b64, 0xc0014dd2, 0xf1ab97b0,
	0x40f16d55, 0x2f1a9fbb, 0xc0035e35, 0x3f7ced91, 0x3fe1eb85, 0x1eb22050,
	0x40f16d55, 0x2f1a9fbb, 0x3ff5e560, 0x4189374c, 0x3fd74bc6, 0xa7e10c00,
	0x40f16d55, 0x2f1a9fbb, 0x4014a1ca, 0xc083126e, 0xbfce76c8, 0xb4510e40,
	0x40f16d55, 0x2f1a9fbb, 0x4021e51e, 0xb851eb85, 0xbffd4bc6, 0xa7f2f690,
	0x40f188ad, 0xba5e353c, 0xc0240000, 0x00000000, 0xbff245a1, 0xcac40000,
	0x40f188ad, 0xba5e353c, 0xc018d78d, 0x4fdf3b64, 0x3fe45a1c, 0xac01b680,
	0x40f188ad, 0xba5e353c, 0xc0035e35, 0x3f7ced91, 0xbfbb645a, 0x1cddee20,
	0x40f188ad, 0xba5e353c, 0x3ff5e560, 0x4189374c, 0xbf96872b, 0x02f70000,
	0x40f188ad, 0xba5e353c, 0x4014a1ca, 0xc083126e, 0xbff224dd, 0x2f1d9be0,
	0x40f188ad, 0xba5e353c, 0x4021e51e, 0xb851eb85, 0xc005cbc6, 0xa7f14d1c,
	0x40f1a406, 0x45a1cabd, 0xc0240000, 0x00000000, 0xc00cdd2f, 0x1aa18000,
	0x40f1a406, 0x45a1cabd, 0xc018d78d, 0x4fdf3b64, 0xc0063439, 0x581203d8,
	0x40f1a406, 0x45a1cabd, 0xc0035e35, 0x3f7ced91, 0xbfe8c49b, 0xa5e99bd8,
	0x40f1a406, 0x45a1cabd, 0x3ff5e560, 0x4189374c, 0xbfda1cac, 0x083fec00,
	0x40f1a406, 0x45a1cabd, 0x4014a1ca, 0xc083126e, 0xc0003d70, 0xa3d88afc,
	0x40f1a406, 0x45a1cabd, 0x4021e51e, 0xb851eb85, 0xc00cf1a9, 0xfbe91ef0,
	0x40f1bf5e, 0xd0e5603e, 0xc0240000, 0x00000000, 0x400f6872, 0xb01f0000,
	0x40f1bf5e, 0xd0e5603e, 0xc018d78d, 0x4fdf3b64, 0x3f981062, 0x4d00bc00,
	0x40f1bf5e, 0xd0e5603e, 0xc0035e35, 0x3f7ced91, 0x3fef5c28, 0xf5bc3c58,
	0x40f1bf5e, 0xd0e5603e, 0x3ff5e560, 0x4189374c, 0x3fe2624d, 0xd2ea3a98,
	0x40f1bf5e, 0xd0e5603e, 0x4014a1ca, 0xc083126e, 0x4001db22, 0xd0e3dcd4,
	0x40f1bf5e, 0xd0e5603e, 0x4021e51e, 0xb851eb85, 0x4011be76, 0xc8b35ea8,
	0x40f1dab7, 0x5c28f5bf, 0xc0240000, 0x00000000, 0x3ff75c28, 0xf5bf0000,
	0x40f1dab7, 0x5c28f5bf, 0xc018d78d, 0x4fdf3b64, 0x4006947a, 0xe14606c8,
	0x40f1dab7, 0x5c28f5bf, 0xc0035e35, 0x3f7ced91, 0x3fd40831, 0x26dcbc88,
	0x40f1dab7, 0x5c28f5bf, 0x3ff5e560, 0x4189374c, 0x3fc820c4, 0x9b87f260,
	0x40f1dab7, 0x5c28f5bf, 0x4014a1ca, 0xc083126e, 0x3ff56041, 0x89343f90,
	0x40f1dab7, 0x5c28f5bf, 0x4021e51e, 0xb851eb85, 0x400c570a, 0x3d6eeb7c,
	0x40f1f60f, 0xe76c8b40, 0xc0240000, 0x00000000, 0xbff01893, 0x74c00000,
	0x40f1f60f, 0xe76c8b40, 0xc018d78d, 0x4fdf3b64, 0xbfe2d916, 0x8731aac0,
	0x40f1f60f, 0xe76c8b40, 0xc0035e35, 0x3f7ced91, 0xbfd6a7ef, 0x9dbeffa0,
	0x40f1f60f, 0xe76c8b40, 0x3ff5e560, 0x4189374c, 0xbfc947ae, 0x149905a0,
	0x40f1f60f, 0xe76c8b40, 0x4014a1ca, 0xc083126e, 0x3fdc28f5, 0xc28315e0,
	0x40f1f60f, 0xe76c8b40, 0x4021e51e, 0xb851eb85, 0x40053126, 0xe97719a8,
	0x40f21168, 0x72b020c1, 0xc0240000, 0x00000000, 0xc00bc6a7, 0xef9f8000,
	0x40f21168, 0x72b020c1, 0xc018d78d, 0x4fdf3b64, 0x4001ae14, 0x7adf9aa0,
	0x40f21168, 0x72b020c1, 0xc0035e35, 0x3f7ced91, 0xbff05604, 0x1896aef2,
	0x40f21168, 0x72b020c1, 0x3ff5e560, 0x4189374c, 0xbfe2ac08, 0x312e7f68,
	0x40f21168, 0x72b020c1, 0x4014a1ca, 0xc083126e, 0xbfdd2f1a, 0x9fcad280,
	0x40f21168, 0x72b020c1, 0x4021e51e, 0xb851eb85, 0x3ffc1687, 0x2afe8fa8,
	0x40f22cc0, 0xfdf3b642, 0xc0240000, 0x00000000, 0x40103f7c, 0xed908000,
	0x40f22cc0, 0xfdf3b642, 0xc018d78d, 0x4fdf3b64, 0xbff33958, 0x1065adb0,
	0x40f22cc0, 0xfdf3b642, 0xc0035e35, 0x3f7ced91, 0x3fe774bc, 0x6a787a4c,
	0x40f22cc0, 0xfdf3b642, 0x3ff5e560, 0x4189374c, 0x3fd98937, 0x4bb76260,
	0x40f22cc0, 0xfdf3b642, 0x4014a1ca, 0xc083126e, 0xbff5a1ca, 0xc0862eb8,
	0x40f22cc0, 0xfdf3b642, 0x4021e51e, 0xb851eb85, 0x3feb9581, 0x061dd800,
	0x40f24819, 0x89374bc3, 0xc0240000, 0x00000000, 0x3ff98937, 0x4bc30000,
	0x40f24819, 0x89374bc3, 0xc018d78d, 0x4fdf3b64, 0x3ff98f5c, 0x28f25cf0,
	0x40f24819, 0x89374bc3, 0xc0035e35, 0x3f7ced91, 0x3fb0e560, 0x4154e1c0,
	0x40f24819, 0x89374bc3, 0x3ff5e560, 0x4189374c, 0x3f8a9fbe, 0x74dccc00,
	0x40f24819, 0x89374bc3, 0x4014a1ca, 0xc083126e, 0xc001fbe7, 0x6c8cd468,
	0x40f24819, 0x89374bc3, 0x4021e51e, 0xb851eb85, 0xbfa020c4, 0x9c16f500,
	0x40f26372, 0x147ae144, 0xc0240000, 0x00000000, 0xbfebd70a, 0x3d780000,
	0x40f26372, 0x147ae144, 0xc018d78d, 0x4fdf3b64, 0xbffd0624, 0xdd328600,
	0x40f26372, 0x147ae144, 0xc0035e35, 0x3f7ced91, 0xbfe33b64, 0x5a2341dc,
	0x40f26372, 0x147ae144, 0x3ff5e560, 0x4189374c, 0xbfd7df3b, 0x646995a0,
	0x40f26372, 0x147ae144, 0x4014a1ca, 0xc083126e, 0x40001cac, 0x082f9368,
	0x40f26372, 0x147ae144, 0x4021e51e, 0xb851eb85, 0xbfed9999, 0x99a0b6a0,
	0x40f27eca, 0x9fbe76c5, 0xc0240000, 0x00000000, 0xc00ab020, 0xc49d8000,
	0x40f27eca, 0x9fbe76c5, 0xc018d78d, 0x4fdf3b64, 0x3fef851e, 0xb84b0940,
	0x40f27eca, 0x9fbe76c5, 0xc0035e35, 0x3f7ced91, 0x3ff272b0, 0x20c14b2a,
	0x40f27eca, 0x9fbe76c5, 0x3ff5e560, 0x4189374c, 0x3fe38106, 0x24d565c8,
	0x40f27eca, 0x9fbe76c5, 0x4014a1ca, 0xc083126e, 0x3ff1e353, 0xf7cbacb8,
	0x40f27eca, 0x9fbe76c5, 0x4021e51e, 0xb851eb85, 0xbffd1893, 0x74bffef8,
	0x40f29a23, 0x2b020c46, 0xc0240000, 0x00000000, 0x4010cac0, 0x83118000,
	0x40f29a23, 0x2b020c46, 0xc018d78d, 0x4fdf3b64, 0xc0036978, 0xd4ffaf28,
	0x40f29a23, 0x2b020c46, 0xc0035e35, 0x3f7ced91, 0x3fdf1a9f, 0xbe697080,
	0x40f29a23, 0x2b020c46, 0x3ff5e560, 0x4189374c, 0x3fcc9ba5, 0xe3349f20,
	0x40f29a23, 0x2b020c46, 0x4014a1ca, 0xc083126e, 0x3fcc6a7e, 0xf9c19500,
	0x40f29a23, 0x2b020c46, 0x4021e51e, 0xb851eb85, 0xc005b22d, 0x0e57d150,
	0x40f2b57b, 0xb645a1c7, 0xc0240000, 0x00000000, 0x3ffbb645, 0xa1c70000,
	0x40f2b57b, 0xb645a1c7, 0xc018d78d, 0x4fdf3b64, 0x3fd7d70a, 0x3d62b140,
	0x40f2b57b, 0xb645a1c7, 0xc0035e35, 0x3f7ced91, 0xbfc72b02, 0x0c649750,
	0x40f2b57b, 0xb645a1c7, 0x3ff5e560, 0x4189374c, 0xbfc4cccc, 0xccec58e0,
	0x40f2b57b, 0xb645a1c7, 0x4014a1ca, 0xc083126e, 0xbfe59168, 0x72b68ef0,
	0x40f2b57b, 0xb645a1c7, 0x4021e51e, 0xb851eb85, 0xc00cd810, 0x624fa324,
	0x40f2d0d4, 0x41893748, 0xc0240000, 0x00000000, 0xbfe77ced, 0x91700000,
	0x40f2d0d4, 0x41893748, 0xc018d78d, 0x4fdf3b64, 0xc0084fdf, 0x3b661b50,
	0x40f2d0d4, 0x41893748, 0xc0035e35, 0x3f7ced91, 0xbfeb22d0, 0xe56703e8,
	0x40f2d0d4, 0x41893748, 0x3ff5e560, 0x4189374c, 0xbfe18d4f, 0xdf435438,
	0x40f2d0d4, 0x41893748, 0x4014a1ca, 0xc083126e, 0xbff91eb8, 0x51eec190,
	0x40f2d0d4, 0x41893748, 0x4021e51e, 0xb851eb85, 0x4011cb43, 0x95801c8e,
	0x40f2ec2c, 0xccccccc9, 0xc0240000, 0x00000000, 0xc0099999, 0x999b8000,
	0x40f2ec2c, 0xccccccc9, 0xc018d78d, 0x4fdf3b64, 0xbfceb851, 0xeba16000,
	0x40f2ec2c, 0xccccccc9, 0xc0035e35, 0x3f7ced91, 0x3fecfdf3, 0xb63ed448,
	0x40f2ec2c, 0xccccccc9, 0x3ff5e560, 0x4189374c, 0x3fdbc6a7, 0xef8db8c0,
	0x40f2ec2c, 0xccccccc9, 0x4014a1ca, 0xc083126e, 0xc003ba5e, 0x35411dd4,
	0x40f2ec2c, 0xccccccc9, 0x4021e51e, 0xb851eb85, 0x400c70a3, 0xd7086748,
	0x40f30785, 0x5810624a, 0xc0240000, 0x00000000, 0x40115604, 0x18928000,
	0x40f30785, 0x5810624a, 0xc018d78d, 0x4fdf3b64, 0x400478d4, 0xfdf1ef50,
	0x40f30785, 0x5810624a, 0xc0035e35, 0x3f7ced91, 0x3fce978d, 0x4fc3d8d0,
	0x40f30785, 0x5810624a, 0x3ff5e560, 0x4189374c, 0x3fa89374, 0xbbe9e600,
	0x40f30785, 0x5810624a, 0x4014a1ca, 0xc083126e, 0x3ffcbc6a, 0x7ef693f8,
	0x40f30785, 0x5810624a, 0x4021e51e, 0xb851eb85, 0x40054ac0, 0x83109574,
	0x40f322dd, 0xe353f7cb, 0xc0240000, 0x00000000, 0x3ffde353, 0xf7cb0000,
	0x40f322dd, 0xe353f7cb, 0xc018d78d, 0x4fdf3b64, 0xbfeb47ae, 0x148208a0,
	0x40f322dd, 0xe353f7cb, 0xc0035e35, 0x3f7ced91, 0xbfdb645a, 0x1cb9cfc0,
	0x40f322dd, 0xe353f7cb, 0x3ff5e560, 0x4189374c, 0xbfd5a1ca, 0xc0933f40,
	0x40f322dd, 0xe353f7cb, 0x4014a1ca, 0xc083126e, 0x3feccccc, 0xccc633c0,
	0x40f322dd, 0xe353f7cb, 0x4021e51e, 0xb851eb85, 0x3ffc49ba, 0x5e318740,
	0x40f33e36, 0x6e978d4c, 0xc0240000, 0x00000000, 0xbfe322d0, 0xe5680000,
	0x40f33e36, 0x6e978d4c, 0xc018d78d, 0x4fdf3b64, 0x3fff24dd, 0x2f170650,
	0x40f33e36, 0x6e978d4c, 0xc0035e35, 0x3f7ced91, 0xbff1851e, 0xb85562fa,
	0x40f33e36, 0x6e978d4c, 0x3ff5e560, 0x4189374c, 0x3fe49fbe, 0x76c090f8,
	0x40f33e36, 0x6e978d4c, 0x4014a1ca, 0xc083126e, 0x3f70624d, 0xcf9fc800,
	0x40f33e36, 0x6e978d4c, 0x4021e51e, 0xb851eb85, 0x3febfbe7, 0x6c83c730,
	0x40f3598e, 0xf9db22cd, 0xc0240000, 0x00000000, 0xc0088312, 0x6e998000,
	0x40f3598e, 0xf9db22cd, 0xc018d78d, 0x4fdf3b64, 0xbff770a3, 0xd70ddca0,
	0x40f3598e, 0xf9db22cd, 0xc0035e35, 0x3f7ced91, 0x3fe51687, 0x2afb123c,
	0x40f3598e, 0xf9db22cd, 0x3ff5e560, 0x4189374c, 0x3fd08b43, 0x9570a5f0,
	0x40f3598e, 0xf9db22cd, 0x4014a1ca, 0xc083126e, 0xbfec8b43, 0x9587b4a0,
	0x40f3598e, 0xf9db22cd, 0x4021e51e, 0xb851eb85, 0xbf9374bc, 0x6b700400,
	0x40f374e7, 0x851eb84e, 0xc0240000, 0x00000000, 0x4011e147, 0xae138000,
	0x40f374e7, 0x851eb84e, 0xc018d78d, 0x4fdf3b64, 0x3ff55810, 0x624a2e00,
	0x40f374e7, 0x851eb84e, 0xc0035e35, 0x3f7ced91, 0xbf80624d, 0xd4b2f600,
	0x40f374e7, 0x851eb84e, 0x3ff5e560, 0x4189374c, 0xbfc051eb, 0x853fac20,
	0x40f374e7, 0x851eb84e, 0x4014a1ca, 0xc083126e, 0xbffc9ba5, 0xe3575468,
	0x40f374e7, 0x851eb84e, 0x4021e51e, 0xb851eb85, 0xbfed3333, 0x333ac770,
	0x40f39040, 0x10624dcf, 0xc0240000, 0x00000000, 0x40000831, 0x26e78000,
	0x40f39040, 0x10624dcf, 0xc018d78d, 0x4fdf3b64, 0xc0009eb8, 0x51ed5a78,
	0x40f39040, 0x10624dcf, 0xc0035e35, 0x3f7ced91, 0xbfe59999, 0x99a0a9ec,
	0x40f39040, 0x10624dcf, 0x3ff5e560, 0x4189374c, 0xbfe06e97, 0x8d582908,
	0x40f39040, 0x10624dcf, 0x4014a1ca, 0xc083126e, 0x4003cac0, 0x8310bd9c,
	0x40f39040, 0x10624dcf, 0x4021e51e, 0xb851eb85, 0xbffce560, 0x418d0760,
	0x40f3ab98, 0x9ba5e350, 0xc0240000, 0x00000000, 0xbfdd9168, 0x72c00000,
	0x40f3ab98, 0x9ba5e350, 0xc018d78d, 0x4fdf3b64, 0x3fe71687, 0x2afaab60,
	0x40f3ab98, 0x9ba5e350, 0xc0035e35, 0x3f7ced91, 0x3ff14395, 0x81029722,
	0x40f3ab98, 0x9ba5e350, 0x3ff5e560, 0x4189374c, 0x3fde0418, 0x93640f20,
	0x40f3ab98, 0x9ba5e350, 0x4014a1ca, 0xc083126e, 0x3ff93f7c, 0xed8e0120,
	0x40f3ab98, 0x9ba5e350, 0x4021e51e, 0xb851eb85, 0xc0059893, 0x74be5584,
	0x40f3c6f1, 0x26e978d1, 0xc0240000, 0x00000000, 0xc0076c8b, 0x43978000,
	0x40f3c6f1, 0x26e978d1, 0xc018d78d, 0x4fdf3b64, 0xc005851e, 0xb853c6a0,
	0x40f3c6f1, 0x26e978d1, 0xc0035e35, 0x3f7ced91, 0x3fda5e35, 0x3f6ea060,
	0x40f3c6f1, 0x26e978d1, 0x3ff5e560, 0x4189374c, 0x3fb53f7c, 0xed4e4c80,
	0x40f3c6f1, 0x26e978d1, 0x4014a1ca, 0xc083126e, 0x3fe5d2f1, 0xa9f50e10,
	0x40f3c6f1, 0x26e978d1, 0x4021e51e, 0xb851eb85, 0xc00cbe76, 0xc8b62758,
	0x40f3e249, 0xb22d0e52, 0xc0240000, 0x00000000, 0x40126c8b, 0x43948000,
	0x40f3e249, 0xb22d0e52, 0xc018d78d, 0x4fdf3b64, 0x3fbbe76c, 0x8b07d600,
	0x40f3e249, 0xb22d0e52, 0xc0035e35, 0x3f7ced91, 0xbfd051eb, 0x852d1bc8,
	0x40f3e249, 0xb22d0e52, 0x3ff5e560, 0x4189374c, 0xbfd3645a, 0x1cbce8e0,
	0x40f3e249, 0xb22d0e52, 0x4014a1ca, 0xc083126e, 0xbfcb645a, 0x1cc79880,
	0x40f3e249, 0xb22d0e52, 0x4021e51e, 0xb851eb85, 0x4011d810, 0x624cda74,
	0x40f3fda2, 0x3d70a3d3, 0xc0240000, 0x00000000, 0x40011eb8, 0x51e98000,
	0x40f3fda2, 0x3d70a3d3, 0xc018d78d, 0x4fdf3b64, 0x40074395, 0x81044400,
	0x40f3fda2, 0x3d70a3d3, 0xc0035e35, 0x3f7ced91, 0xbfed8106, 0x24e46bf8,
	0x40f3fda2, 0x3d70a3d3, 0x3ff5e560, 0x4189374c, 0x3fe5be76, 0xc8abbc28,
	0x40f3fda2, 0x3d70a3d3, 0x4014a1ca, 0xc083126e, 0xbff1c28f, 0x5c2c6d28,
	0x40f3fda2, 0x3d70a3d3, 0x4021e51e, 0xb851eb85, 0x400c8a3d, 0x70a1e314,
	0x40f418fa, 0xc8b43954, 0xc0240000, 0x00000000, 0xbfd4dd2f, 0x1ab00000,
	0x40f418fa, 0xc8b43954, 0xc018d78d, 0x4fdf3b64, 0xbfe01cac, 0x0838b5e0,
	0x40f418fa, 0xc8b43954, 0xc0035e35, 0x3f7ced91, 0x3fea9fbe, 0x76c16c38,
	0x40f418fa, 0xc8b43954, 0x3ff5e560, 0x4189374c, 0x3fd2c8b4, 0x3946fc50,
	0x40f418fa, 0xc8b43954, 0x4014a1ca, 0xc083126e, 0xc0000c49, 0xba5ff3a0,
	0x40f418fa, 0xc8b43954, 0x4021e51e, 0xb851eb85, 0x4005645a, 0x1caa1140,
	0x40f43453, 0x53f7ced5, 0xc0240000, 0x00000000, 0xc0065604, 0x18958000,
	0x40f43453, 0x53f7ced5, 0xc018d78d, 0x4fdf3b64, 0x40025d2f, 0x1a9dd7d8,
	0x40f43453, 0x53f7ced5, 0xc0035e35, 0x3f7ced91, 0x3fc51eb8, 0x51ce3890,
	0x40f43453, 0x53f7ced5, 0x3ff5e560, 0x4189374c, 0xbfb7ae14, 0x7b25fec0,
	0x40f43453, 0x53f7ced5, 0x4014a1ca, 0xc083126e, 0x40020c49, 0xba5c7430,
	0x40f43453, 0x53f7ced5, 0x4021e51e, 0xb851eb85, 0x3ffc7ced, 0x91647ed8,
	0x40f44fab, 0xdf3b6456, 0xc0240000, 0x00000000, 0x4012f7ce, 0xd9158000,
	0x40f44fab, 0xdf3b6456, 0xc018d78d, 0x4fdf3b64, 0xbff1db22, 0xd0e93340,
	0x40f44fab, 0xdf3b6456, 0xc0035e35, 0x3f7ced91, 0xbfe01062, 0x4dda4ff0,
	0x40f44fab, 0xdf3b6456, 0x3ff5e560, 0x4189374c, 0xbfde9fbe, 0x76d9fbb0,
	0x40f44fab, 0xdf3b6456, 0x4014a1ca, 0xc083126e, 0x3ff5c28f, 0x5c256e48,
	0x40f44fab, 0xdf3b6456, 0x4021e51e, 0xb851eb85, 0x3fec624d, 0xd2e9b660,
	0x40f46b04, 0x6a7ef9d7, 0xc0240000, 0x00000000, 0x4002353f, 0x7ceb8000,
	0x40f46b04, 0x6a7ef9d7, 0xc018d78d, 0x4fdf3b64, 0x3ffaed91, 0x686ed760,
	0x40f46b04, 0x6a7ef9d7, 0xc0035e35, 0x3f7ced91, 0xbff2b439, 0x58141702,
	0x40f46b04, 0x6a7ef9d7, 0x3ff5e560, 0x4189374c, 0x3fe020c4, 0x9b9d32c0,
	0x40f46b04, 0x6a7ef9d7, 0x4014a1ca, 0xc083126e, 0x3fddb22d, 0x0e47d0c0,
	0x40f46b04, 0x6a7ef9d7, 0x4021e51e, 0xb851eb85, 0xbf7a9fbe, 0x7ac87800,
	0x40f4865c, 0xf5c28f58, 0xc0240000, 0x00000000, 0xbfc851eb, 0x85400000,
	0x40f4865c, 0xf5c28f58, 0xc018d78d, 0x4fdf3b64, 0xbffba7ef, 0x9db60b90,
	0x40f4865c, 0xf5c28f58, 0xc0035e35, 0x3f7ced91, 0x3fe2b851, 0xeb7daa2c,
	0x40f4865c, 0xf5c28f58, 0x3ff5e560, 0x4189374c, 0x3fbe353f, 0x7ca7a600,
	0x40f4865c, 0xf5c28f58, 0x4014a1ca, 0xc083126e, 0xbfdba5e3, 0x540617a0,
	0x40f4865c, 0xf5c28f58, 0x4021e51e, 0xb851eb85, 0xbfeccccc, 0xccd4d840,
	0x40f4a1b5, 0x810624d9, 0xc0240000, 0x00000000, 0xc0053f7c, 0xed938000,
	0x40f4a1b5, 0x810624d9, 0xc018d78d, 0x4fdf3b64, 0x3ff120c4, 0x9ba1ff10,
	0x40f4a1b5, 0x810624d9, 0xc0035e35, 0x3f7ced91, 0xbfb4fdf3, 0xb6819f40,
	0x40f4a1b5, 0x810624d9, 0x3ff5e560, 0x4189374c, 0xbfd126e9, 0x78e69280,
	0x40f4a1b5, 0x810624d9, 0x4014a1ca, 0xc083126e, 0xbff53f7c, 0xed950000,
	0x40f4a1b5, 0x810624d9, 0x4021e51e, 0xb851eb85, 0xbffcb22d, 0x0e5a0fc8,
	0x40f4bd0e, 0x0c49ba5a, 0xc0240000, 0x00000000, 0x40138312, 0x6e968000,
	0x40f4bd0e, 0x0c49ba5a, 0xc018d78d, 0x4fdf3b64, 0xc002ba5e, 0x354171f0,
	0x40f4bd0e, 0x0c49ba5a, 0xc0035e35, 0x3f7ced91, 0xbfe7f7ce, 0xd91e11fc,
	0x40f4bd0e, 0x0c49ba5a, 0x3ff5e560, 0x4189374c, 0xbfe4ed91, 0x687b8740,
	0x40f4bd0e, 0x0c49ba5a, 0x4014a1ca, 0xc083126e, 0xc001cac0, 0x83143d0c,
	0x40f4bd0e, 0x0c49ba5a, 0x4021e51e, 0xb851eb85, 0xc0057ef9, 0xdb24d9b8,
	0x40f4d866, 0x978d4fdb, 0xc0240000, 0x00000000, 0x40034bc6, 0xa7ed8000,
	0x40f4d866, 0x978d4fdb, 0xc018d78d, 0x4fdf3b64, 0x3fdd4fdf, 0x3b549b00,
	0x40f4d866, 0x978d4fdb, 0xc0035e35, 0x3f7ced91, 0x3ff0147a, 0xe143e31a,
	0x40f4d866, 0x978d4fdb, 0x3ff5e560, 0x4189374c, 0x3fd50624, 0xdd1d52b0,
	0x40f4d866, 0x978d4fdb, 0x4014a1ca, 0xc083126e, 0x40004dd2, 0xf1a82ac4,
	0x40f4d866, 0x978d4fdb, 0x4021e51e, 0xb851eb85, 0xc00ca4dd, 0x2f1cab8c,
	0x40f4f3bf, 0x22d0e55c, 0xc0240000, 0x00000000, 0xbfaba5e3, 0x54800000,
	0x40f4f3bf, 0x22d0e55c, 0xc018d78d, 0x4fdf3b64, 0xc007a0c4, 0x9ba7de18,
	0x40f4f3bf, 0x22d0e55c, 0xc0035e35, 0x3f7ced91, 0x3fd5a1ca, 0xc073d040,
	0x40f4f3bf, 0x22d0e55c, 0x3ff5e560, 0x4189374c, 0xbfad70a3, 0xd7994a80,
	0x40f4f3bf, 0x22d0e55c, 0x4014a1ca, 0xc083126e, 0x3ff245a1, 0xcabcdb70,
	0x40f4f3bf, 0x22d0e55c, 0x4021e51e, 0xb851eb85, 0x4011e4dd, 0x2f19985a,
	0x40f50f17, 0xae147add, 0xc0240000, 0x00000000, 0xc00428f5, 0xc2918000,
	0x40f50f17, 0xae147add, 0xc018d78d, 0x4fdf3b64, 0xbfc3c6a7, 0xefbd8c80,
	0x40f50f17, 0xae147add, 0xc0035e35, 0x3f7ced91, 0xbfd50e56, 0x0427ebe8,
	0x40f50f17, 0xae147add, 0x3ff5e560, 0x4189374c, 0xbfdc624d, 0xd303a550,
	0x40f50f17, 0xae147add, 0x4014a1ca, 0xc083126e, 0x3fcf7ced, 0x914b0ac0,
	0x40f50f17, 0xae147add, 0x4021e51e, 0xb851eb85, 0x400ca3d7, 0x0a3b5ee0,
	0x40f52a70, 0x3958105e, 0xc0240000, 0x00000000, 0xc013f1a9, 0xfbe88000,
	0x40f52a70, 0x3958105e, 0xc018d78d, 0x4fdf3b64, 0x400527ef, 0x9db02c88,
	0x40f52a70, 0x3958105e, 0xc0035e35, 0x3f7ced91, 0xbfefdf3b, 0x6461d408,
	0x40f52a70, 0x3958105e, 0x3ff5e560, 0x4189374c, 0x3fe13f7c, 0xed885df0,
	0x40f52a70, 0x3958105e, 0x4014a1ca, 0xc083126e, 0xbfe4cccc, 0xccd43180,
	0x40f52a70, 0x3958105e, 0x4021e51e, 0xb851eb85, 0x40057df3, 0xb6438d0c,
	0x40f545c8, 0xc49ba5df, 0xc0240000, 0x00000000, 0x4004624d, 0xd2ef8000,
	0x40f545c8, 0xc49ba5df, 0xc018d78d, 0x4fdf3b64, 0xbfe88b43, 0x958913c0,
	0x40f545c8, 0xc49ba5df, 0xc0035e35, 0x3f7ced91, 0x3fe84189, 0x37440428,
	0x40f545c8, 0xc49ba5df, 0x3ff5e560, 0x4189374c, 0x3fc39581, 0x06007fc0,
	0x40f545c8, 0xc49ba5df, 0x4014a1ca, 0xc083126e, 0xbff8bc6a, 0x7efd92d8,
	0x40f545c8, 0xc49ba5df, 0x4021e51e, 0xb851eb85, 0x3ffcb020, 0xc4977670,
	0x40f56121, 0x4fdf3b60, 0xc0240000, 0x00000000, 0x3fb4fdf3, 0xb6000000,
	0x40f56121, 0x4fdf3b60, 0xc018d78d, 0x4fdf3b64, 0x40004189, 0x3749c060,
	0x40f56121, 0x4fdf3b60, 0xc0035e35, 0x3f7ced91, 0x3fb74bc6, 0xa7b130a0,
	0x40f56121, 0x4fdf3b60, 0x3ff5e560, 0x4189374c, 0xbfcdd2f1, 0xaa207840,
	0x40f56121, 0x4fdf3b60, 0x4014a1ca, 0xc083126e, 0xc0038937, 0x4bc88678,
	0x40f56121, 0x4fdf3b60, 0x4021e51e, 0xb851eb85, 0x3fecc8b4, 0x394fa590,
	0x40f57c79, 0xdb22d0e1, 0xc0240000, 0x00000000, 0xc003126e, 0x978f8000,
	0x40f57c79, 0xdb22d0e1, 0xc018d78d, 0x4fdf3b64, 0xbff6126e, 0x97916230,
	0x40f57c79, 0xdb22d0e1, 0xc0035e35, 0x3f7ced91, 0xbfe26e97, 0x8d57b800,
	0x40f57c79, 0xdb22d0e1, 0x3ff5e560, 0x4189374c, 0xbfe3ced9, 0x16905c10,
	0x40f57c79, 0xdb22d0e1, 0x4014a1ca, 0xc083126e, 0x3ffd1eb8, 0x51e7c2b0,
	0x40f57c79, 0xdb22d0e1, 0x4021e51e, 0xb851eb85, 0x3f789374, 0xb82f2000,
	0x40f597d2, 0x66666662, 0xc0240000, 0x00000000, 0xc0136666, 0x66678000,
	0x40f597d2, 0x66666662, 0xc018d78d, 0x4fdf3b64, 0x3ff6b645, 0xa1c6a870,
	0x40f597d2, 0x66666662, 0xc0035e35, 0x3f7ced91, 0x3ff2d916, 0x87271018,
	0x40f597d2, 0x66666662, 0x3ff5e560, 0x4189374c, 0x3fd74395, 0x80f3a910,
	0x40f597d2, 0x66666662, 0x4014a1ca, 0xc083126e, 0x3fed9168, 0x72a89130,
	0x40f597d2, 0x66666662, 0x4021e51e, 0xb851eb85, 0xbfec6666, 0x666ee910,
	0x40f5b32a, 0xf1a9fbe3, 0xc0240000, 0x00000000, 0x400578d4, 0xfdf18000,
	0x40f5b32a, 0xf1a9fbe3, 0xc018d78d, 0x4fdf3b64, 0xbfffdf3b, 0x645e3a80,
	0x40f5b32a, 0xf1a9fbe3, 0xc0035e35, 0x3f7ced91, 0x3fe05a1c, 0xac00421c,
	0x40f5b32a, 0xf1a9fbe3, 0x3ff5e560, 0x4189374c, 0xbf970a3d, 0x71cd2f00,
	0x40f5b32a, 0xf1a9fbe3, 0x4014a1ca, 0xc083126e, 0x3f9cac08, 0x3033a000,
	0x40f5b32a, 0xf1a9fbe3, 0x4021e51e, 0xb851eb85, 0xbffc7ef9, 0xdb271830,
	0x40f5ce83, 0x7ced9164, 0xc0240000, 0x00000000, 0x3fcbe76c, 0x8b200000,
	0x40f5ce83, 0x7ced9164, 0xc018d78d, 0x4fdf3b64, 0x3fe9d2f1, 0xa9f3a040,
	0x40f5ce83, 0x7ced9164, 0xc0035e35, 0x3f7ced91, 0xbfc3f7ce, 0xd9366fe0,
	0x40f5ce83, 0x7ced9164, 0x3ff5e560, 0x4189374c, 0xbfda24dd, 0x2f2d4ef0,
	0x40f5ce83, 0x7ced9164, 0x4014a1ca, 0xc083126e, 0xbfebc6a7, 0xefa55730,
	0x40f5ce83, 0x7ced9164, 0x4021e51e, 0xb851eb85, 0xc0056560, 0x418b5dec,
	0x40f5e9dc, 0x083126e5, 0xc0240000, 0x00000000, 0xc001fbe7, 0x6c8d8000,
	0x40f5e9dc, 0x083126e5, 0xc018d78d, 0x4fdf3b64, 0xc004d604, 0x18958968,
	0x40f5e9dc, 0x083126e5, 0xc0035e35, 0x3f7ced91, 0xbfea5604, 0x189b7a0c,
	0x40f5e9dc, 0x083126e5, 0x3ff5e560, 0x4189374c, 0x3fe25e35, 0x3f738920,
	0x40f5e9dc, 0x083126e5, 0x4014a1ca, 0xc083126e, 0xbffc3958, 0x106625b0,
	0x40f5e9dc, 0x083126e5, 0x4021e51e, 0xb851eb85, 0xc00c8b43, 0x95832fc0,
	0x40f60534, 0x9374bc66, 0xc0240000, 0x00000000, 0xc012db22, 0xd0e68000,
	0x40f60534, 0x9374bc66, 0xc018d78d, 0x4fdf3b64, 0x3fc8e560, 0x4167be80,
	0x40f60534, 0x9374bc66, 0xc0035e35, 0x3f7ced91, 0x3fedcac0, 0x830a5e24,
	0x40f60534, 0x9374bc66, 0x3ff5e560, 0x4189374c, 0x3fc81062, 0x4dad2c80,
	0x40f60534, 0x9374bc66, 0x4014a1ca, 0xc083126e, 0x4003fbe7, 0x6c8954f8,
	0x40f60534, 0x9374bc66, 0x4021e51e, 0xb851eb85, 0xc011d893, 0x74bd80ca,
	0x40f6208d, 0x1eb851e7, 0xc0240000, 0x00000000, 0x40068f5c, 0x28f38000,
	0x40f6208d, 0x1eb851e7, 0xc018d78d, 0x4fdf3b64, 0x4007f2b0, 0x20c28138,
	0x40f6208d, 0x1eb851e7, 0xc0035e35, 0x3f7ced91, 0x3fd0e560, 0x41790020,
	0x40f6208d, 0x1eb851e7, 0x3ff5e560, 0x4189374c, 0xbfc95810, 0x6273cb80,
	0x40f6208d, 0x1eb851e7, 0x4014a1ca, 0xc083126e, 0x3ff9a1ca, 0xc07f2fd8,
	0x40f6208d, 0x1eb851e7, 0x4021e51e, 0xb851eb85, 0x400cbd70, 0xa3d4daac,
	0x40f63be5, 0xa9fbe768, 0xc0240000, 0x00000000, 0x3fd6a7ef, 0x9da00000,
	0x40f63be5, 0xa9fbe768, 0xc018d78d, 0x4fdf3b64, 0xbfdac083, 0x127f8200,
	0x40f63be5, 0xa9fbe768, 0xc0035e35, 0x3f7ced91, 0xbfd9cac0, 0x8322bc08,
	0x40f63be5, 0xa9fbe768, 0x3ff5e560, 0x4189374c, 0xbfe2b020, 0xc4a530e0,
	0x40f63be5, 0xa9fbe768, 0x4014a1ca, 0xc083126e, 0x3fe6978d, 0x4fd76b80,
	0x40f63be5, 0xa9fbe768, 0x4021e51e, 0xb851eb85, 0x4005978d, 0x4fdd08d8,
	0x40f6573e, 0x353f7ce9, 0xc0240000, 0x00000000, 0xc000e560, 0x418b8000,
	0x40f6573e, 0x353f7ce9, 0xc018d78d, 0x4fdf3b64, 0x40030c49, 0xba5c1510,
	0x40f6573e, 0x353f7ce9, 0xc0035e35, 0x3f7ced91, 0xbff11eb8, 0x51ef9e0c,
	0x40f6573e, 0x353f7ce9, 0x3ff5e560, 0x4189374c, 0x3fd98106, 0x24c9ff70,
	0x40f6573e, 0x353f7ce9, 0x4014a1ca, 0xc083126e, 0xbfc851eb, 0x853e22c0,
	0x40f6573e, 0x353f7ce9, 0x4021e51e, 0xb851eb85, 0x3ffce353, 0xf7ca6e08,
	0x40f67296, 0xc083126a, 0xc0240000, 0x00000000, 0xc0124fdf, 0x3b658000,
	0x40f67296, 0xc083126a, 0xc018d78d, 0x4fdf3b64, 0xbff07ced, 0x916cb8d0,
	0x40f67296, 0xc083126a, 0xc0035e35, 0x3f7ced91, 0x3fe5e353, 0xf7c69c18,
	0x40f67296, 0xc083126a, 0x3ff5e560, 0x4189374c, 0x3f899999, 0x97306e00,
	0x40f67296, 0xc083126a, 0x4014a1ca, 0xc083126e, 0xbff16041, 0x893b3e70,
	0x40f67296, 0xc083126a, 0x4021e51e, 0xb851eb85, 0x3fed2f1a, 0x9fb594c0,
	0x40f68def, 0x4bc6a7eb, 0xc0240000, 0x00000000, 0x4007a5e3, 0x53f58000,
	0x40f68def, 0x4bc6a7eb, 0xc018d78d, 0x4fdf3b64, 0x3ffc4bc6, 0xa7eb51d0,
	0x40f68def, 0x4bc6a7eb, 0xc0035e35, 0x3f7ced91, 0x3f916872, 0xaf17c080,
	0x40f68def, 0x4bc6a7eb, 0x3ff5e560, 0x4189374c, 0xbfd7e76c, 0x8b56f890,
	0x40f68def, 0x4bc6a7eb, 0x4014a1ca, 0xc083126e, 0xbfffb645, 0xa1ceb888,
	0x40f68def, 0x4bc6a7eb, 0x4021e51e, 0xb851eb85, 0x3f92f1a9, 0xfac9ae00,
	0x40f6a947, 0xd70a3d6c, 0xc0240000, 0x00000000, 0x3fdf5c28, 0xf5b00000,
	0x40f6a947, 0xd70a3d6c, 0xc018d78d, 0x4fdf3b64, 0xbffa49ba, 0x5e399120,
	0x40f6a947, 0xd70a3d6c, 0xc0035e35, 0x3f7ced91, 0xbfe4cccc, 0xccd52010,
	0x40f6a947, 0xd70a3d6c, 0x3ff5e560, 0x4189374c, 0x3fe37ced, 0x915eb450,
	0x40f6a947, 0xd70a3d6c, 0x4014a1ca, 0xc083126e, 0x40023d70, 0xa3d50b8c,
	0x40f6a947, 0xd70a3d6c, 0x4021e51e, 0xb851eb85, 0xbfec0000, 0x0008f9e0,
	0x40f6c4a0, 0x624dd2ed, 0xc0240000, 0x00000000, 0xbfff9db2, 0x2d130000,
	0x40f6c4a0, 0x624dd2ed, 0xc018d78d, 0x4fdf3b64, 0x3ff27ef9, 0xdb1e7980,
	0x40f6c4a0, 0x624dd2ed, 0xc0035e35, 0x3f7ced91, 0x3ff1a9fb, 0xe7685c10,
	0x40f6c4a0, 0x624dd2ed, 0x3ff5e560, 0x4189374c, 0x3fcc8b43, 0x9559d940,
	0x40f6c4a0, 0x624dd2ed, 0x4014a1ca, 0xc083126e, 0x3ff624dd, 0x2f169d00,
	0x40f6c4a0, 0x624dd2ed, 0x4021e51e, 0xb851eb85, 0xbffc4bc6, 0xa7f42098,
	0x40f6dff8, 0xed91686e, 0xc0240000, 0x00000000, 0xc011c49b, 0xa5e48000,
	0x40f6dff8, 0xed91686e, 0xc018d78d, 0x4fdf3b64, 0xc0020b43, 0x958334b8,
	0x40f6dff8, 0xed91686e, 0xc0035e35, 0x3f7ced91, 0x3fdbf7ce, 0xd905b418,
	0x40f6dff8, 0xed91686e, 0x3ff5e560, 0x4189374c, 0xbfc4dd2f, 0x1ac71ec0,
	0x40f6dff8, 0xed91686e, 0x4014a1ca, 0xc083126e, 0x3fdf3b64, 0x5a0c8ba0,
	0x40f6dff8, 0xed91686e, 0x4021e51e, 0xb851eb85, 0xc0054bc6, 0xa7f1e220,
	0x40f6fb51, 0x78d4fdef, 0xc0240000, 0x00000000, 0x4008bc6a, 0x7ef78000,
	0x40f6fb51, 0x78d4fdef, 0xc018d78d, 0x4fdf3b64, 0x3fe1645a, 0x1ca34260,
	0x40f6fb51, 0x78d4fdef, 0xc0035e35, 0x3f7ced91, 0xbfcd70a3, 0xd72c1020,
	0x40f6fb51, 0x78d4fdef, 0x3ff5e560, 0x4189374c, 0xbfe19168, 0x72ba05b0,
	0x40f6fb51, 0x78d4fdef, 0x4014a1ca, 0xc083126e, 0xbfda1cac, 0x08415cc0,
	0x40f6fb51, 0x78d4fdef, 0x4021e51e, 0xb851eb85, 0xc00c71a9, 0xfbe9b3f4,
	0x40f716aa, 0x04189370, 0xc0240000, 0x00000000, 0x3fe40831, 0x26e00000,
	0x40f716aa, 0x04189370, 0xc018d78d, 0x4fdf3b64, 0xc006f1a9, 0xfbe9a0e0,
	0x40f716aa, 0x04189370, 0xc0035e35, 0x3f7ced91, 0xbfecb439, 0x5818e21c,
	0x40f716aa, 0x04189370, 0x3ff5e560, 0x4189374c, 0x3fdbbe76, 0xc8a055d0,
	0x40f716aa, 0x04189370, 0x4014a1ca, 0xc083126e, 0xbff4dd2f, 0x1aa3d148,
	0x40f716aa, 0x04189370, 0x4021e51e, 0xb851eb85, 0xc011cbc6, 0xa7f0c2e4,
	0x40f73202, 0x8f5c28f1, 0xc0240000, 0x00000000, 0xbffd70a3, 0xd70f0000,
	0x40f73202, 0x8f5c28f1, 0xc018d78d, 0x4fdf3b64, 0xbfb1a9fb, 0xe7b37200,
	0x40f73202, 0x8f5c28f1, 0xc0035e35, 0x3f7ced91, 0x3feb6c8b, 0x438cf614,
	0x40f73202, 0x8f5c28f1, 0x3ff5e560, 0x4189374c, 0x3fa851eb, 0x847ece80,
	0x40f73202, 0x8f5c28f1, 0x4014a1ca, 0xc083126e, 0xc0019999, 0x999ba5b0,
	0x40f73202, 0x8f5c28f1, 0x4021e51e, 0xb851eb85, 0x400cd70a, 0x3d6e5678,
	0x40f74d5b, 0x1a9fbe72, 0xc0240000, 0x00000000, 0xc0113958, 0x10638000,
	0x40f74d5b, 0x1a9fbe72, 0xc018d78d, 0x4fdf3b64, 0x4005d70a, 0x3d6e69c0,
	0x40f74d5b, 0x1a9fbe72, 0xc0035e35, 0x3f7ced91, 0x3fc851eb, 0x84fc6000,
	0x40f74d5b, 0x1a9fbe72, 0x3ff5e560, 0x4189374c, 0xbfd5a9fb, 0xe780a230,
	0x40f74d5b, 0x1a9fbe72, 0x4014a1ca, 0xc083126e, 0x40007ef9, 0xdb20c220,
	0x40f74d5b, 0x1a9fbe72, 0x4021e51e, 0xb851eb85, 0x4005b126, 0xe97684a4,
	0x40f768b3, 0xa5e353f3, 0xc0240000, 0x00000000, 0x4009d2f1, 0xa9f98000,
	0x40f768b3, 0xa5e353f3, 0xc018d78d, 0x4fdf3b64, 0xbfe5ced9, 0x16901ee0,
	0x40f768b3, 0xa5e353f3, 0xc0035e35, 0x3f7ced91, 0xbfde872b, 0x021d8c28,
	0x40f768b3, 0xa5e353f3, 0x3ff5e560, 0x4189374c, 0x3fe49ba5, 0xe349df80,
	0x40f768b3, 0xa5e353f3, 0x4014a1ca, 0xc083126e, 0x3ff2a7ef, 0x9dae0a28,
	0x40f768b3, 0xa5e353f3, 0x4021e51e, 0xb851eb85, 0x3ffd1687, 0x2afd65a0,
	0x40f7840c, 0x3126e974, 0xc0240000, 0x00000000, 0x3fe8624d, 0xd2e80000,
	0x40f7840c, 0x3126e974, 0xc018d78d, 0x4fdf3b64, 0x4000f0a3, 0xd707fd98,
	0x40f7840c, 0x3126e974, 0xc0035e35, 0x3f7ced91, 0xbff24dd2, 0xf1ae5214,
	0x40f7840c, 0x3126e974, 0x3ff5e560, 0x4189374c, 0x3fd08312, 0x6e834300,
	0x40f7840c, 0x3126e974, 0x4014a1ca, 0xc083126e, 0x3fd147ae, 0x146a4040,
	0x40f7840c, 0x3126e974, 0x4021e51e, 0xb851eb85, 0x3fed9581, 0x061b83f0,
	0x40f79f64, 0xbc6a7ef5, 0xc0240000, 0x00000000, 0xbffb4395, 0x810b0000,
	0x40f79f64, 0xbc6a7ef5, 0xc018d78d, 0x4fdf3b64, 0xbff4b439, 0x5814e7c0,
	0x40f79f64, 0xbc6a7ef5, 0xc0035e35, 0x3f7ced91, 0x3fe3851e, 0xb8493408,
	0x40f79f64, 0xbc6a7ef5, 0x3ff5e560, 0x4189374c, 0xbfc0624d, 0xd31a7200,
	0x40f79f64, 0xbc6a7ef5, 0x4014a1ca, 0xc083126e, 0xbfe40831, 0x26f1d410,
	0x40f79f64, 0xbc6a7ef5, 0x4021e51e, 0xb851eb85, 0x3f9fbe76, 0xc7879400,
	0x40f7babd, 0x47ae1476, 0xc0240000, 0x00000000, 0xc010ae14, 0x7ae28000,
	0x40f7babd, 0x47ae1476, 0xc018d78d, 0x4fdf3b64, 0x3ff8147a, 0xe14322e0,
	0x40f7babd, 0x47ae1476, 0xc0035e35, 0x3f7ced91, 0xbfad2f1a, 0xa04aa0c0,
	0x40f7babd, 0x47ae1476, 0x3ff5e560, 0x4189374c, 0xbfe072b0, 0x20ceda80,
	0x40f7babd, 0x47ae1476, 0x4014a1ca, 0xc083126e, 0xbff85a1c, 0xac0c6420,
	0x40f7babd, 0x47ae1476, 0x4021e51e, 0xb851eb85, 0xbfeb9999, 0x99a30ab0,
	0x40f7d615, 0xd2f1a9f7, 0xc0240000, 0x00000000, 0x400ae978, 0xd4fb8000,
	0x40f7d615, 0xd2f1a9f7, 0xc018d78d, 0x4fdf3b64, 0xbffe8106, 0x24e1c010,
	0x40f7d615, 0xd2f1a9f7, 0xc0035e35, 0x3f7ced91, 0xbfe72b02, 0x0c528820,
	0x40f7d615, 0xd2f1a9f7, 0x3ff5e560, 0x4189374c, 0x3fddfbe7, 0x6c76ac30,
	0x40f7d615, 0xd2f1a9f7, 0x4014a1ca, 0xc083126e, 0xc0035810, 0x624fef1c,
	0x40f7d615, 0xd2f1a9f7, 0x4021e51e, 0xb851eb85, 0xbffc1893, 0x74c12900,
	0x40f7f16e, 0x5e353f78, 0xc0240000, 0x00000000, 0x3fecbc6a, 0x7ef00000,
	0x40f7f16e, 0x5e353f78, 0xc018d78d, 0x4fdf3b64, 0x3fec8f5c, 0x28ec9520,
	0x40f7f16e, 0x5e353f78, 0xc0035e35, 0x3f7ced91, 0x3ff07ae1, 0x47a9a808,
	0x40f7f16e, 0x5e353f78, 0x3ff5e560, 0x4189374c, 0x3fb51eb8, 0x5198c0c0,
	0x40f7f16e, 0x5e353f78, 0x4014a1ca, 0xc083126e, 0x3ffd8106, 0x24d8f168,
	0x40f7f16e, 0x5e353f78, 0x4021e51e, 0xb851eb85, 0xc005322d, 0x0e586654,
	0x40f80cc6, 0xe978d4f9, 0xc0240000, 0x00000000, 0xbff91687, 0x2b070000,
	0x40f80cc6, 0xe978d4f9, 0xc018d78d, 0x4fdf3b64, 0xc00426e9, 0x78d74c30,
	0x40f80cc6, 0xe978d4f9, 0xc0035e35, 0x3f7ced91, 0x3fd73b64, 0x5a0ae3f8,
	0x40f80cc6, 0xe978d4f9, 0x3ff5e560, 0x4189374c, 0xbfd36c8b, 0x43aa4bd0,
	0x40f80cc6, 0xe978d4f9, 0x4014a1ca, 0xc083126e, 0x3fee5604, 0x188aeea0,
	0x40f80cc6, 0xe978d4f9, 0x4021e51e, 0xb851eb85, 0xc00c5810, 0x62503828,
	0x40f8281f, 0x74bc6a7a, 0xc0240000, 0x00000000, 0xc01022d0, 0xe5618000,
	0x40f8281f, 0x74bc6a7a, 0xc018d78d, 0x4fdf3b64, 0x3fd1eb85, 0x1ea5c900,
	0x40f8281f, 0x74bc6a7a, 0xc0035e35, 0x3f7ced91, 0xbfd374bc, 0x6a90d830,
	0x40f8281f, 0x74bc6a7a, 0x3ff5e560, 0x4189374c, 0x3fe5ba5e, 0x35350ab0,
	0x40f8281f, 0x74bc6a7a, 0x4014a1ca, 0xc083126e, 0x3faa9fbe, 0x763fa700,
	0x40f8281f, 0x74bc6a7a, 0x4021e51e, 0xb851eb85, 0xc011bef9, 0xdb2404fe,
	0x40f84377, 0xfffffffb, 0xc0240000, 0x00000000, 0x400bffff, 0xfffd8000,
	0x40f84377, 0xfffffffb, 0xc018d78d, 0x4fdf3b64, 0x4008a1ca, 0xc080be70,
	0x40f84377, 0xfffffffb, 0xc0035e35, 0x3f7ced91, 0xbfef126e, 0x97964a2c,
	0x40f84377, 0xfffffffb, 0x3ff5e560, 0x4189374c, 0x3fd2c083, 0x12599960,
	0x40f84377, 0xfffffffb, 0x4014a1ca, 0xc083126e, 0xbfeb020c, 0x49c2f9c0,
	0x40f84377, 0xfffffffb, 0x4021e51e, 0xb851eb85, 0x400cf0a3, 0xd707d244,
	0x40f85ed0, 0x8b43957c, 0xc0240000, 0x00000000, 0x3ff08b43, 0x957c0000,
	0x40f85ed0, 0x8b43957c, 0xc018d78d, 0x4fdf3b64, 0xbfd547ae, 0x148d9840,
	0x40f85ed0, 0x8b43957c, 0xc0035e35, 0x3f7ced91, 0x3fe90e56, 0x040f8e04,
	0x40f85ed0, 0x8b43957c, 0x3ff5e560, 0x4189374c, 0xbfb7ced9, 0x16db8a80,
	0x40f85ed0, 0x8b43957c, 0x4014a1ca, 0xc083126e, 0xbffbd70a, 0x3d74f6f8,
	0x40f85ed0, 0x8b43957c, 0x4021e51e, 0xb851eb85, 0x4005cac0, 0x83100070,
	// IEEEremainder(6.0,9.0) should be -3.0
	0x40180000, 0x00000000, 0x40220000, 0x00000000, 0xc0080000, 0x00000000
	};

LOCAL_D const TUint32 SineTest[] =
	{
	0x00000000,0x00000000, 0x00000000,0x00000000,
	0x3F50624D,0xD2F1A9FC, 0x3F50624D,0xA5218A62,
	0x3F60624D,0xD2F1A9FC, 0x3F60624D,0x1BB12D61,
	0x3F689374,0xBC6A7EFA, 0x3F689372,0x51F0E492,
	0x3F70624D,0xD2F1A9FC, 0x3F70624A,0xF5EFD464,
	0x3F747AE1,0x47AE147B, 0x3F747ADB,0xB006A986,
	0x3F789374,0xBC6A7EFA, 0x3F78936B,0x1284F039,
	0x3F7CAC08,0x3126E979, 0x3F7CABF8,0xD8B2BD8A,
	0x3F80624D,0xD2F1A9FC, 0x3F806242,0x5EEC20C6,
	0x3F826E97,0x8D4FDF3B, 0x3F826E87,0x3E9EE5EC,
	0x3F847AE1,0x47AE147B, 0x3F847ACA,0xE915E807,
	0x3F86872B,0x020C49BA, 0x3F86870D,0x3BF5752C,
	0x3F889374,0xBC6A7EFA, 0x3F88934E,0x14E1F1F4,
	0x3F8A9FBE,0x76C8B439, 0x3F8A9F8D,0x517FDBBB,
	0x3F8CAC08,0x3126E979, 0x3F8CABCA,0xCF73CAE6,
	0x3F8EB851,0xEB851EB8, 0x3F8EB806,0x6C62751D,
	0x3F90624D,0xD2F1A9FC, 0x3F906220,0x02F857C9,
	0x3F916872,0xB020C49C, 0x3F91683B,0xBCE1B89B,
	0x3F926E97,0x8D4FDF3B, 0x3F926E56,0x52BFEA83,
	0x3F9374BC,0x6A7EF9DB, 0x3F93746F,0xB3658E26,
	0x3F947AE1,0x47AE147B, 0x3F947A87,0xCDA55867,
	0x3F958106,0x24DD2F1B, 0x3F95809E,0x90521391,
	0x3F96872B,0x020C49BA, 0x3F9686B3,0xEA3EA071,
	0x3F978D4F,0xDF3B645A, 0x3F978CC7,0xCA3DF77B,
	0x3F989374,0xBC6A7EFA, 0x3F9892DA,0x1F2329E6,
	0x3F999999,0x9999999A, 0x3F9998EA,0xD7C162CE,
	0x3F9A9FBE,0x76C8B439, 0x3F9A9EF9,0xE2EBE852,
	0x3F9BA5E3,0x53F7CED9, 0x3F9BA507,0x2F761CB9,
	0x3F9CAC08,0x3126E979, 0x3F9CAB12,0xAC337F8E,
	0x3F9DB22D,0x0E560419, 0x3F9DB11C,0x47F7AEC1,
	0x3F9EB851,0xEB851EB8, 0x3F9EB723,0xF19667C6,
	0x3F9FBE76,0xC8B43958, 0x3F9FBD29,0x97E388BA,
	0x3FA0624D,0xD2F1A9FC, 0x3FA06196,0x94D988BF,
	0x3FA0E560,0x4189374C, 0x3FA0E497,0x4AEC926B,
	0x3FA16872,0xB020C49C, 0x3FA16796,0xE59504C8,
	0x3FA1EB85,0x1EB851EC, 0x3FA1EA95,0x5C3D15CE,
	0x3FA26E97,0x8D4FDF3B, 0x3FA26D92,0xA64F0E99,
	0x3FA2F1A9,0xFBE76C8B, 0x3FA2F08E,0xBB354BFA,
	0x3FA374BC,0x6A7EF9DB, 0x3FA37389,0x925A3F01,
	0x3FA3F7CE,0xD916872B, 0x3FA3F683,0x23286D94,
	0x3FA47AE1,0x47AE147B, 0x3FA4797B,0x650A72FB,
	0x3FA4FDF3,0xB645A1CB, 0x3FA4FC72,0x4F6B0071,
	0x3FA58106,0x24DD2F1B, 0x3FA57F67,0xD9B4DDB3,
	0x3FA60418,0x9374BC6A, 0x3FA6025B,0xFB52E994,
	0x3FA6872B,0x020C49BA, 0x3FA6854E,0xABB01A88,
	0x3FA70A3D,0x70A3D70A, 0x3FA7083F,0xE2377F36,
	0x3FA78D4F,0xDF3B645A, 0x3FA78B2F,0x96543F09,
	0x3FA81062,0x4DD2F1AA, 0x3FA80E1D,0xBF719ABE,
	0x3FA89374,0xBC6A7EFA, 0x3FA8910A,0x54FAECF6,
	0x3FA91687,0x2B020C4A, 0x3FA913F5,0x4E5BAAC3,
	0x3FA99999,0x9999999A, 0x3FA996DE,0xA2FF643C,
	0x3FAA1CAC,0x083126E9, 0x3FAA19C6,0x4A51C509,
	0x3FAA9FBE,0x76C8B439, 0x3FAA9CAC,0x3BBE94F8,
	0x3FAB22D0,0xE5604189, 0x3FAB1F90,0x6EB1B886,
	0x3FABA5E3,0x53F7CED9, 0x3FABA272,0xDA973174,
	0x3FAC28F5,0xC28F5C29, 0x3FAC2553,0x76DB1F55,
	0x3FACAC08,0x3126E979, 0x3FACA832,0x3AE9C021,
	0x3FAD2F1A,0x9FBE76C9, 0x3FAD2B0F,0x1E2F70BE,
	0x3FADB22D,0x0E560419, 0x3FADADEA,0x1818AD98,
	0x3FAE353F,0x7CED9168, 0x3FAE30C3,0x2012132B,
	0x3FAEB851,0xEB851EB8, 0x3FAEB39A,0x2D885E96,
	0x3FAF3B64,0x5A1CAC08, 0x3FAF366F,0x37E86E2A,
	0x3FAFBE76,0xC8B43958, 0x3FAFB942,0x369F41F9,
	0x3FB020C4,0x9BA5E354, 0x3FB01E09,0x908CFE33,
	0x3FB0624D,0xD2F1A9FC, 0x3FB05F70,0xF762F15C,
	0x3FB0A3D7,0x0A3D70A4, 0x3FB0A0D7,0x4B882ED2,
	0x3FB0E560,0x4189374C, 0x3FB0E23C,0x88B37CF1,
	0x3FB126E9,0x78D4FDF4, 0x3FB123A0,0xAA9BB45E,
	0x3FB16872,0xB020C49C, 0x3FB16503,0xACF7C04C,
	0x3FB1A9FB,0xE76C8B44, 0x3FB1A665,0x8B7E9EC9,
	0x3FB1EB85,0x1EB851EC, 0x3FB1E7C6,0x41E76101,
	0x3FB22D0E,0x56041893, 0x3FB22925,0xCBE92B89,
	0x3FB26E97,0x8D4FDF3B, 0x3FB26A84,0x253B36A8,
	0x3FB2B020,0xC49BA5E3, 0x3FB2ABE1,0x4994CE9A,
	0x3FB2F1A9,0xFBE76C8B, 0x3FB2ED3D,0x34AD53D9,
	0x3FB33333,0x33333333, 0x3FB32E97,0xE23C3B6C,
	0x3FB374BC,0x6A7EF9DB, 0x3FB36FF1,0x4DF90F24,
	0x3FB3B645,0xA1CAC083, 0x3FB3B149,0x739B6DED,
	0x3FB3F7CE,0xD916872B, 0x3FB3F2A0,0x4EDB0C10,
	0x3FB43958,0x10624DD3, 0x3FB433F5,0xDB6FB37E,
	0x3FB47AE1,0x47AE147B, 0x3FB4754A,0x15114416,
	0x3FB4BC6A,0x7EF9DB23, 0x3FB4B69C,0xF777B3EE,
	0x3FB4FDF3,0xB645A1CB, 0x3FB4F7EE,0x7E5B0F9A,
	0x3FB53F7C,0xED916873, 0x3FB5393E,0xA5737A76,
	0x3FB58106,0x24DD2F1B, 0x3FB57A8D,0x68792EEB,
	0x3FB5C28F,0x5C28F5C3, 0x3FB5BBDA,0xC3247EB6,
	0x3FB60418,0x9374BC6A, 0x3FB5FD26,0xB12DD335,
	0x3FB645A1,0xCAC08312, 0x3FB63E71,0x2E4DADAA,
	0x3FB6872B,0x020C49BA, 0x3FB67FBA,0x363CA784,
	0x3FB6C8B4,0x39581062, 0x3FB6C101,0xC4B372A7,
	0x3FB70A3D,0x70A3D70A, 0x3FB70247,0xD56AD9B5,
	0x3FB74BC6,0xA7EF9DB2, 0x3FB7438C,0x641BC055,
	0x3FB78D4F,0xDF3B645A, 0x3FB784CF,0x6C7F2377,
	0x3FB7CED9,0x16872B02, 0x3FB7C610,0xEA4E19A4,
	0x3FB81062,0x4DD2F1AA, 0x3FB80750,0xD941D33D,
	0x3FB851EB,0x851EB852, 0x3FB8488F,0x35139AC9,
	0x3FB89374,0xBC6A7EFA, 0x3FB889CB,0xF97CD539,
	0x3FB8D4FD,0xF3B645A2, 0x3FB8CB07,0x22370233,
	0x3FB91687,0x2B020C4A, 0x3FB90C40,0xAAFBBC56,
	0x3FB95810,0x624DD2F2, 0x3FB94D78,0x8F84B985,
	0x3FB99999,0x9999999A, 0x3FB98EAE,0xCB8BCB2C,
	0x3FB9DB22,0xD0E56042, 0x3FB9CFE3,0x5ACADE8B,
	0x3FBA1CAC,0x083126E9, 0x3FBA1116,0x38FBFCF8,
	0x3FBA5E35,0x3F7CED91, 0x3FBA5247,0x61D94C31,
	0x3FBA9FBE,0x76C8B439, 0x3FBA9376,0xD11D0E97,
	0x3FBAE147,0xAE147AE1, 0x3FBAD4A4,0x8281A37D,
	0x3FBB22D0,0xE5604189, 0x3FBB15D0,0x71C18772,
	0x3FBB645A,0x1CAC0831, 0x3FBB56FA,0x9A975480,
	0x3FBBA5E3,0x53F7CED9, 0x3FBB9822,0xF8BDC27E,
	0x3FBBE76C,0x8B439581, 0x3FBBD949,0x87EFA74D,
	0x3FBC28F5,0xC28F5C29, 0x3FBC1A6E,0x43E7F72B,
	0x3FBC6A7E,0xF9DB22D1, 0x3FBC5B91,0x2861C4F0,
	0x3FBCAC08,0x3126E979, 0x3FBC9CB2,0x3118425C,
	0x3FBCED91,0x6872B021, 0x3FBCDDD1,0x59C6C05D,
	0x3FBD2F1A,0x9FBE76C9, 0x3FBD1EEE,0x9E28AF58,
	0x3FBD70A3,0xD70A3D71, 0x3FBD6009,0xF9F99F6D,
	0x3FBDB22D,0x0E560419, 0x3FBDA123,0x68F540C1,
	0x3FBDF3B6,0x45A1CAC1, 0x3FBDE23A,0xE6D763C6,
	0x3FBE353F,0x7CED9168, 0x3FBE2350,0x6F5BF983,
	0x3FBE76C8,0xB4395810, 0x3FBE6463,0xFE3F13D9,
	0x3FBEB851,0xEB851EB8, 0x3FBEA575,0x8F3CE5CD,
	0x3FBEF9DB,0x22D0E560, 0x3FBEE685,0x1E11C3CD,
	0x3FBF3B64,0x5A1CAC08, 0x3FBF2792,0xA67A23FB,
	0x3FBF7CED,0x916872B0, 0x3FBF689E,0x24329E72,
	0x3FBFBE76,0xC8B43958, 0x3FBFA9A7,0x92F7ED8F,
	0x3FC00000,0x00000000, 0x3FBFEAAE,0xEE86EE36,
	0x3FC020C4,0x9BA5E354, 0x3FC015DA,0x194E500E,
	0x3FC04189,0x374BC6A8, 0x3FC0365B,0xAD7B1308,
	0x3FC0624D,0xD2F1A9FC, 0x3FC056DC,0x31A8631E,
	0x3FC08312,0x6E978D50, 0x3FC0775B,0xA3B4F53A,
	0x3FC0A3D7,0x0A3D70A4, 0x3FC097DA,0x017F903C,
	0x3FC0C49B,0xA5E353F8, 0x3FC0B857,0x48E70D21,
	0x3FC0E560,0x4189374C, 0x3FC0D8D3,0x77CA5721,
	0x3FC10624,0xDD2F1AA0, 0x3FC0F94E,0x8C086BDA,
	0x3FC126E9,0x78D4FDF4, 0x3FC119C8,0x83805B6E,
	0x3FC147AE,0x147AE148, 0x3FC13A41,0x5C1148A8,
	0x3FC16872,0xB020C49C, 0x3FC15AB9,0x139A6923,
	0x3FC18937,0x4BC6A7F0, 0x3FC17B2F,0xA7FB0568,
	0x3FC1A9FB,0xE76C8B44, 0x3FC19BA5,0x17127917,
	0x3FC1CAC0,0x83126E98, 0x3FC1BC19,0x5EC03308,
	0x3FC1EB85,0x1EB851EC, 0x3FC1DC8C,0x7CE3B56F,
	0x3FC20C49,0xBA5E353F, 0x3FC1FCFE,0x6F5C95FF,
	0x3FC22D0E,0x56041893, 0x3FC21D6F,0x340A7E12,
	0x3FC24DD2,0xF1A9FBE7, 0x3FC23DDE,0xC8CD2AC5,
	0x3FC26E97,0x8D4FDF3B, 0x3FC25E4D,0x2B846D23,
	0x3FC28F5C,0x28F5C28F, 0x3FC27EBA,0x5A102A42,
	0x3FC2B020,0xC49BA5E3, 0x3FC29F26,0x52505B6F,
	0x3FC2D0E5,0x60418937, 0x3FC2BF91,0x12250E49,
	0x3FC2F1A9,0xFBE76C8B, 0x3FC2DFFA,0x976E64EB,
	0x3FC3126E,0x978D4FDF, 0x3FC30062,0xE00C960B,
	0x3FC33333,0x33333333, 0x3FC320C9,0xE9DFED22,
	0x3FC353F7,0xCED91687, 0x3FC3412F,0xB2C8CA8C,
	0x3FC374BC,0x6A7EF9DB, 0x3FC36194,0x38A7A3AC,
	0x3FC39581,0x0624DD2F, 0x3FC381F7,0x795D0315,
	0x3FC3B645,0xA1CAC083, 0x3FC3A259,0x72C988A4,
	0x3FC3D70A,0x3D70A3D7, 0x3FC3C2BA,0x22CDE9AD,
	0x3FC3F7CE,0xD916872B, 0x3FC3E319,0x874AF119,
	0x3FC41893,0x74BC6A7F, 0x3FC40377,0x9E217F8A,
	0x3FC43958,0x10624DD3, 0x3FC423D4,0x65328B81,
	0x3FC45A1C,0xAC083127, 0x3FC4442F,0xDA5F2180,
	0x3FC47AE1,0x47AE147B, 0x3FC46489,0xFB88642F,
	0x3FC49BA5,0xE353F7CF, 0x3FC484E2,0xC68F8C7C,
	0x3FC4BC6A,0x7EF9DB23, 0x3FC4A53A,0x3955E9C4,
	0x3FC4DD2F,0x1A9FBE77, 0x3FC4C590,0x51BCE1F1,
	0x3FC4FDF3,0xB645A1CB, 0x3FC4E5E5,0x0DA5F1A2,
	0x3FC51EB8,0x51EB851F, 0x3FC50638,0x6AF2AC4C,
	0x3FC53F7C,0xED916873, 0x3FC5268A,0x6784BC5E,
	0x3FC56041,0x89374BC7, 0x3FC546DB,0x013DE364,
	0x3FC58106,0x24DD2F1B, 0x3FC5672A,0x35FFFA2F,
	0x3FC5A1CA,0xC083126F, 0x3FC58778,0x03ACF0F0,
	0x3FC5C28F,0x5C28F5C3, 0x3FC5A7C4,0x6826CF64,
	0x3FC5E353,0xF7CED917, 0x3FC5C80F,0x614FB4F2,
	0x3FC60418,0x9374BC6A, 0x3FC5E858,0xED09D8D0,
	0x3FC624DD,0x2F1A9FBE, 0x3FC608A1,0x09378A2B,
	0x3FC645A1,0xCAC08312, 0x3FC628E7,0xB3BB3041,
	0x3FC66666,0x66666666, 0x3FC6492C,0xEA774A8E,
	0x3FC6872B,0x020C49BA, 0x3FC66970,0xAB4E70E8,
	0x3FC6A7EF,0x9DB22D0E, 0x3FC689B2,0xF42353AA,
	0x3FC6C8B4,0x39581062, 0x3FC6A9F3,0xC2D8BBCF,
	0x3FC6E978,0xD4FDF3B6, 0x3FC6CA33,0x15518B1D,
	0x3FC70A3D,0x70A3D70A, 0x3FC6EA70,0xE970BC45,
	0x3FC72B02,0x0C49BA5E, 0x3FC70AAD,0x3D196304,
	0x3FC74BC6,0xA7EF9DB2, 0x3FC72AE8,0x0E2EAC4D,
	0x3FC76C8B,0x43958106, 0x3FC74B21,0x5A93DE66,
	0x3FC78D4F,0xDF3B645A, 0x3FC76B59,0x202C5910,
	0x3FC7AE14,0x7AE147AE, 0x3FC78B8F,0x5CDB95A7,
	0x3FC7CED9,0x16872B02, 0x3FC7ABC4,0x0E852747,
	0x3FC7EF9D,0xB22D0E56, 0x3FC7CBF7,0x330CBAF0,
	0x3FC81062,0x4DD2F1AA, 0x3FC7EC28,0xC85617A9,
	0x3FC83126,0xE978D4FE, 0x3FC80C58,0xCC451EA4,
	0x3FC851EB,0x851EB852, 0x3FC82C87,0x3CBDCB5D,
	0x3FC872B0,0x20C49BA6, 0x3FC84CB4,0x17A433C5,
	0x3FC89374,0xBC6A7EFA, 0x3FC86CDF,0x5ADC8860,
	0x3FC8B439,0x5810624E, 0x3FC88D09,0x044B1469,
	0x3FC8D4FD,0xF3B645A2, 0x3FC8AD31,0x11D43DF6,
	0x3FC8F5C2,0x8F5C28F6, 0x3FC8CD57,0x815C861D,
	0x3FC91687,0x2B020C4A, 0x3FC8ED7C,0x50C88914,
	0x3FC9374B,0xC6A7EF9E, 0x3FC90D9F,0x7DFCFE58,
	0x3FC95810,0x624DD2F2, 0x3FC92DC1,0x06DEB8CD,
	0x3FC978D4,0xFDF3B646, 0x3FC94DE0,0xE952A6E4,
	0x3FC99999,0x9999999A, 0x3FC96DFF,0x233DD2BC,
	0x3FC9BA5E,0x353F7CEE, 0x3FC98E1B,0xB2856248,
	0x3FC9DB22,0xD0E56042, 0x3FC9AE36,0x950E976F,
	0x3FC9FBE7,0x6C8B4396, 0x3FC9CE4F,0xC8BED032,
	0x3FCA1CAC,0x083126E9, 0x3FC9EE67,0x4B7B86CE,
	0x3FCA3D70,0xA3D70A3D, 0x3FCA0E7D,0x1B2A51E2,
	0x3FCA5E35,0x3F7CED91, 0x3FCA2E91,0x35B0E48D,
	0x3FCA7EF9,0xDB22D0E5, 0x3FCA4EA3,0x98F50E96,
	0x3FCA9FBE,0x76C8B439, 0x3FCA6EB4,0x42DCBC8D,
	0x3FCAC083,0x126E978D, 0x3FCA8EC3,0x314DF7EE,
	0x3FCAE147,0xAE147AE1, 0x3FCAAED0,0x622EE747,
	0x3FCB020C,0x49BA5E35, 0x3FCACEDB,0xD365CE58,
	0x3FCB22D0,0xE5604189, 0x3FCAEEE5,0x82D90E37,
	0x3FCB4395,0x810624DD, 0x3FCB0EED,0x6E6F2575,
	0x3FCB645A,0x1CAC0831, 0x3FCB2EF3,0x940EB040,
	0x3FCB851E,0xB851EB85, 0x3FCB4EF7,0xF19E6886,
	0x3FCBA5E3,0x53F7CED9, 0x3FCB6EFA,0x85052617,
	0x3FCBC6A7,0xEF9DB22D, 0x3FCB8EFB,0x4C29DECC,
	0x3FCBE76C,0x8B439581, 0x3FCBAEFA,0x44F3A6A6,
	0x3FCC0831,0x26E978D5, 0x3FCBCEF7,0x6D49AFF5,
	0x3FCC28F5,0xC28F5C29, 0x3FCBEEF2,0xC3134B77,
	0x3FCC49BA,0x5E353F7D, 0x3FCC0EEC,0x4437E87F,
	0x3FCC6A7E,0xF9DB22D1, 0x3FCC2EE3,0xEE9F1515,
	0x3FCC8B43,0x95810625, 0x3FCC4ED9,0xC0307E1D,
	0x3FCCAC08,0x3126E979, 0x3FCC6ECD,0xB6D3EF75,
	0x3FCCCCCC,0xCCCCCCCD, 0x3FCC8EBF,0xD071541E,
	0x3FCCED91,0x6872B021, 0x3FCCAEB0,0x0AF0B65A,
	0x3FCD0E56,0x04189375, 0x3FCCCE9E,0x643A3FD2,
	0x3FCD2F1A,0x9FBE76C9, 0x3FCCEE8A,0xDA3639B7,
	0x3FCD4FDF,0x3B645A1D, 0x3FCD0E75,0x6ACD0CEA,
	0x3FCD70A3,0xD70A3D71, 0x3FCD2E5E,0x13E74218,
	0x3FCD9168,0x72B020C5, 0x3FCD4E44,0xD36D81E2,
	0x3FCDB22D,0x0E560419, 0x3FCD6E29,0xA74894FF,
	0x3FCDD2F1,0xA9FBE76D, 0x3FCD8E0C,0x8D61645E,
	0x3FCDF3B6,0x45A1CAC1, 0x3FCDADED,0x83A0F94B,
	0x3FCE147A,0xE147AE14, 0x3FCDCDCC,0x87F07D90,
	0x3FCE353F,0x7CED9168, 0x3FCDEDA9,0x98393B9A,
	0x3FCE5604,0x189374BC, 0x3FCE0D84,0xB2649E9B,
	0x3FCE76C8,0xB4395810, 0x3FCE2D5D,0xD45C32AB,
	0x3FCE978D,0x4FDF3B64, 0x3FCE4D34,0xFC09A4F0,
	0x3FCEB851,0xEB851EB8, 0x3FCE6D0A,0x2756C3BC,
	0x3FCED916,0x872B020C, 0x3FCE8CDD,0x542D7EB4,
	0x3FCEF9DB,0x22D0E560, 0x3FCEACAE,0x8077E6EE,
	0x3FCF1A9F,0xBE76C8B4, 0x3FCECC7D,0xAA202F1C,
	0x3FCF3B64,0x5A1CAC08, 0x3FCEEC4A,0xCF10ABA5,
	0x3FCF5C28,0xF5C28F5C, 0x3FCF0C15,0xED33D2D1,
	0x3FCF7CED,0x916872B0, 0x3FCF2BDF,0x02743CE5,
	0x3FCF9DB2,0x2D0E5604, 0x3FCF4BA6,0x0CBCA44C,
	0x3FCFBE76,0xC8B43958, 0x3FCF6B6B,0x09F7E5B4,
	0x3FCFDF3B,0x645A1CAC, 0x3FCF8B2D,0xF8110036,
	0x3FD00000,0x00000000, 0x3FCFAAEE,0xD4F31577,
	0x3FD01062,0x4DD2F1AA, 0x3FCFCAAD,0x9E8969C8,
	0x3FD020C4,0x9BA5E354, 0x3FCFEA6A,0x52BF6450,
	0x3FD03126,0xE978D4FE, 0x3FD00512,0x77C04793,
	0x3FD04189,0x374BC6A8, 0x3FD014EE,0xB95C4BBE,
	0x3FD051EB,0x851EB852, 0x3FD024C9,0xED29A6DE,
	0x3FD0624D,0xD2F1A9FC, 0x3FD034A4,0x121E52D8,
	0x3FD072B0,0x20C49BA6, 0x3FD0447D,0x27305B4F,
	0x3FD08312,0x6E978D50, 0x3FD05455,0x2B55DDB9,
	0x3FD09374,0xBC6A7EFA, 0x3FD0642C,0x1D85096F,
	0x3FD0A3D7,0x0A3D70A4, 0x3FD07401,0xFCB41FBD,
	0x3FD0B439,0x5810624E, 0x3FD083D6,0xC7D973F6,
	0x3FD0C49B,0xA5E353F8, 0x3FD093AA,0x7DEB6B84,
	0x3FD0D4FD,0xF3B645A2, 0x3FD0A37D,0x1DE07DFA,
	0x3FD0E560,0x4189374C, 0x3FD0B34E,0xA6AF3523,
	0x3FD0F5C2,0x8F5C28F6, 0x3FD0C31F,0x174E2D16,
	0x3FD10624,0xDD2F1AA0, 0x3FD0D2EE,0x6EB4144A,
	0x3FD11687,0x2B020C4A, 0x3FD0E2BC,0xABD7AB9F,
	0x3FD126E9,0x78D4FDF4, 0x3FD0F289,0xCDAFC678,
	0x3FD1374B,0xC6A7EF9E, 0x3FD10255,0xD3334AC8,
	0x3FD147AE,0x147AE148, 0x3FD11220,0xBB593124,
	0x3FD15810,0x624DD2F2, 0x3FD121EA,0x851884D5,
	0x3FD16872,0xB020C49C, 0x3FD131B3,0x2F6863E9,
	0x3FD178D4,0xFDF3B646, 0x3FD1417A,0xB93FFF43,
	0x3FD18937,0x4BC6A7F0, 0x3FD15141,0x21969AB1,
	0x3FD19999,0x9999999A, 0x3FD16106,0x67638CF6,
	0x3FD1A9FB,0xE76C8B44, 0x3FD170CA,0x899E3FE3,
	0x3FD1BA5E,0x353F7CEE, 0x3FD1808D,0x873E3062,
	0x3FD1CAC0,0x83126E98, 0x3FD1904F,0x5F3AEE8C,
	0x3FD1DB22,0xD0E56042, 0x3FD1A010,0x108C1DB7,
	0x3FD1EB85,0x1EB851EC, 0x3FD1AFCF,0x9A29748A,
	0x3FD1FBE7,0x6C8B4396, 0x3FD1BF8D,0xFB0ABD0C,
	0x3FD20C49,0xBA5E353F, 0x3FD1CF4B,0x3227D4B7,
	0x3FD21CAC,0x083126E9, 0x3FD1DF07,0x3E78AC89,
	0x3FD22D0E,0x56041893, 0x3FD1EEC2,0x1EF54914,
	0x3FD23D70,0xA3D70A3D, 0x3FD1FE7B,0xD295C292,
	0x3FD24DD2,0xF1A9FBE7, 0x3FD20E34,0x585244F2,
	0x3FD25E35,0x3F7CED91, 0x3FD21DEB,0xAF230FEE,
	0x3FD26E97,0x8D4FDF3B, 0x3FD22DA1,0xD6007719,
	0x3FD27EF9,0xDB22D0E5, 0x3FD23D56,0xCBE2E1F2,
	0x3FD28F5C,0x28F5C28F, 0x3FD24D0A,0x8FC2CBF6,
	0x3FD29FBE,0x76C8B439, 0x3FD25CBD,0x2098C4AD,
	0x3FD2B020,0xC49BA5E3, 0x3FD26C6E,0x7D5D6FC0,
	0x3FD2C083,0x126E978D, 0x3FD27C1E,0xA5098509,
	0x3FD2D0E5,0x60418937, 0x3FD28BCD,0x9695D0A4,
	0x3FD2E147,0xAE147AE1, 0x3FD29B7B,0x50FB32FD,
	0x3FD2F1A9,0xFBE76C8B, 0x3FD2AB27,0xD332A0E9,
	0x3FD3020C,0x49BA5E35, 0x3FD2BAD3,0x1C3523AE,
	0x3FD3126E,0x978D4FDF, 0x3FD2CA7D,0x2AFBD91B,
	0x3FD322D0,0xE5604189, 0x3FD2DA25,0xFE7FF398,
	0x3FD33333,0x33333333, 0x3FD2E9CD,0x95BABA33,
	0x3FD34395,0x810624DD, 0x3FD2F973,0xEFA588B8,
	0x3FD353F7,0xCED91687, 0x3FD30919,0x0B39CFBC,
	0x3FD3645A,0x1CAC0831, 0x3FD318BC,0xE77114B2,
	0x3FD374BC,0x6A7EF9DB, 0x3FD3285F,0x8344F1FA,
	0x3FD3851E,0xB851EB85, 0x3FD33800,0xDDAF16F5,
	0x3FD39581,0x0624DD2F, 0x3FD347A0,0xF5A94813,
	0x3FD3A5E3,0x53F7CED9, 0x3FD3573F,0xCA2D5EE5,
	0x3FD3B645,0xA1CAC083, 0x3FD366DD,0x5A354A32,
	0x3FD3C6A7,0xEF9DB22D, 0x3FD37679,0xA4BB0E00,
	0x3FD3D70A,0x3D70A3D7, 0x3FD38614,0xA8B8C3AF,
	0x3FD3E76C,0x8B439581, 0x3FD395AE,0x65289A02,
	0x3FD3F7CE,0xD916872B, 0x3FD3A546,0xD904D535,
	0x3FD40831,0x26E978D5, 0x3FD3B4DE,0x0347CF0C,
	0x3FD41893,0x74BC6A7F, 0x3FD3C473,0xE2EBF6E5,
	0x3FD428F5,0xC28F5C29, 0x3FD3D408,0x76EBD1C9,
	0x3FD43958,0x10624DD3, 0x3FD3E39B,0xBE41FA7C,
	0x3FD449BA,0x5E353F7D, 0x3FD3F32D,0xB7E92191,
	0x3FD45A1C,0xAC083127, 0x3FD402BE,0x62DC0D78,
	0x3FD46A7E,0xF9DB22D1, 0x3FD4124D,0xBE159A90,
	0x3FD47AE1,0x47AE147B, 0x3FD421DB,0xC890BB3A,
	0x3FD48B43,0x95810625, 0x3FD43168,0x814877E8,
	0x3FD49BA5,0xE353F7CF, 0x3FD440F3,0xE737EF2D,
	0x3FD4AC08,0x3126E979, 0x3FD4507D,0xF95A55D3,
	0x3FD4BC6A,0x7EF9DB23, 0x3FD46006,0xB6AAF6E7,
	0x3FD4CCCC,0xCCCCCCCD, 0x3FD46F8E,0x1E2533CC,
	0x3FD4DD2F,0x1A9FBE77, 0x3FD47F14,0x2EC4844C,
	0x3FD4ED91,0x6872B021, 0x3FD48E98,0xE78476AA,
	0x3FD4FDF3,0xB645A1CB, 0x3FD49E1C,0x4760AFB2,
	0x3FD50E56,0x04189375, 0x3FD4AD9E,0x4D54EAC9,
	0x3FD51EB8,0x51EB851F, 0x3FD4BD1E,0xF85CFA01,
	0x3FD52F1A,0x9FBE76C9, 0x3FD4CC9E,0x4774C628,
	0x3FD53F7C,0xED916873, 0x3FD4DC1C,0x39984ED8,
	0x3FD54FDF,0x3B645A1D, 0x3FD4EB98,0xCDC3AA8D,
	0x3FD56041,0x89374BC7, 0x3FD4FB14,0x02F306AE,
	0x3FD570A3,0xD70A3D71, 0x3FD50A8D,0xD822A7A6,
	0x3FD58106,0x24DD2F1B, 0x3FD51A06,0x4C4EE8EF,
	0x3FD59168,0x72B020C5, 0x3FD5297D,0x5E743D28,
	0x3FD5A1CA,0xC083126F, 0x3FD538F3,0x0D8F2E23,
	0x3FD5B22D,0x0E560419, 0x3FD54867,0x589C5CF4,
	0x3FD5C28F,0x5C28F5C3, 0x3FD557DA,0x3E988208,
	0x3FD5D2F1,0xA9FBE76D, 0x3FD5674B,0xBE806D32,
	0x3FD5E353,0xF7CED917, 0x3FD576BB,0xD75105BA,
	0x3FD5F3B6,0x45A1CAC1, 0x3FD5862A,0x88074A73,
	0x3FD60418,0x9374BC6A, 0x3FD59597,0xCFA051C9,
	0x3FD6147A,0xE147AE14, 0x3FD5A503,0xAD1949D2,
	0x3FD624DD,0x2F1A9FBE, 0x3FD5B46E,0x1F6F7861,
	0x3FD6353F,0x7CED9168, 0x3FD5C3D7,0x25A03B13,
	0x3FD645A1,0xCAC08312, 0x3FD5D33E,0xBEA90765,
	0x3FD65604,0x189374BC, 0x3FD5E2A4,0xE9876ABF,
	0x3FD66666,0x66666666, 0x3FD5F209,0xA5390A8B,
	0x3FD676C8,0xB4395810, 0x3FD6016C,0xF0BBA442,
	0x3FD6872B,0x020C49BA, 0x3FD610CE,0xCB0D0D7F,
	0x3FD6978D,0x4FDF3B64, 0x3FD6202F,0x332B340E,
	0x3FD6A7EF,0x9DB22D0E, 0x3FD62F8E,0x28141DFE,
	0x3FD6B851,0xEB851EB8, 0x3FD63EEB,0xA8C5E9B3,
	0x3FD6C8B4,0x39581062, 0x3FD64E47,0xB43ECDF4,
	0x3FD6D916,0x872B020C, 0x3FD65DA2,0x497D19FF,
	0x3FD6E978,0xD4FDF3B6, 0x3FD66CFB,0x677F3598,
	0x3FD6F9DB,0x22D0E560, 0x3FD67C53,0x0D43A11A,
	0x3FD70A3D,0x70A3D70A, 0x3FD68BA9,0x39C8F589,
	0x3FD71A9F,0xBE76C8B4, 0x3FD69AFD,0xEC0DE4A3,
	0x3FD72B02,0x0C49BA5E, 0x3FD6AA51,0x231138ED,
	0x3FD73B64,0x5A1CAC08, 0x3FD6B9A2,0xDDD1D5CA,
	0x3FD74BC6,0xA7EF9DB2, 0x3FD6C8F3,0x1B4EB787,
	0x3FD75C28,0xF5C28F5C, 0x3FD6D841,0xDA86F36E,
	0x3FD76C8B,0x43958106, 0x3FD6E78F,0x1A79B7D7,
	0x3FD77CED,0x916872B0, 0x3FD6F6DA,0xDA264C36,
	0x3FD78D4F,0xDF3B645A, 0x3FD70625,0x188C1132,
	0x3FD79DB2,0x2D0E5604, 0x3FD7156D,0xD4AA80AE,
	0x3FD7AE14,0x7AE147AE, 0x3FD724B5,0x0D812DDF,
	0x3FD7BE76,0xC8B43958, 0x3FD733FA,0xC20FC55C,
	0x3FD7CED9,0x16872B02, 0x3FD7433E,0xF1560D2F,
	0x3FD7DF3B,0x645A1CAC, 0x3FD75281,0x9A53E4E3,
	0x3FD7EF9D,0xB22D0E56, 0x3FD761C2,0xBC094599,
	0x3FD80000,0x00000000, 0x3FD77102,0x55764214,
	0x3FD81062,0x4DD2F1AA, 0x3FD78040,0x659B06CF,
	0x3FD820C4,0x9BA5E354, 0x3FD78F7C,0xEB77DA0A,
	0x3FD83126,0xE978D4FE, 0x3FD79EB7,0xE60D1BDC,
	0x3FD84189,0x374BC6A8, 0x3FD7ADF1,0x545B4644,
	0x3FD851EB,0x851EB852, 0x3FD7BD29,0x3562ED39,
	0x3FD8624D,0xD2F1A9FC, 0x3FD7CC5F,0x8824BEBC,
	0x3FD872B0,0x20C49BA6, 0x3FD7DB94,0x4BA182E6,
	0x3FD88312,0x6E978D50, 0x3FD7EAC7,0x7EDA1BFD,
	0x3FD89374,0xBC6A7EFA, 0x3FD7F9F9,0x20CF8681,
	0x3FD8A3D7,0x0A3D70A4, 0x3FD80929,0x3082D93F,
	0x3FD8B439,0x5810624E, 0x3FD81857,0xACF5455F,
	0x3FD8C49B,0xA5E353F8, 0x3FD82784,0x95281678,
	0x3FD8D4FD,0xF3B645A2, 0x3FD836AF,0xE81CB29F,
	0x3FD8E560,0x4189374C, 0x3FD845D9,0xA4D49A78,
	0x3FD8F5C2,0x8F5C28F6, 0x3FD85501,0xCA516945,
	0x3FD90624,0xDD2F1AA0, 0x3FD86428,0x5794D4FB,
	0x3FD91687,0x2B020C4A, 0x3FD8734D,0x4BA0AE4C,
	0x3FD926E9,0x78D4FDF4, 0x3FD88270,0xA576E0C0,
	0x3FD9374B,0xC6A7EF9E, 0x3FD89192,0x641972BD,
	0x3FD947AE,0x147AE148, 0x3FD8A0B2,0x868A859F,
	0x3FD95810,0x624DD2F2, 0x3FD8AFD1,0x0BCC55C4,
	0x3FD96872,0xB020C49C, 0x3FD8BEED,0xF2E13A9E,
	0x3FD978D4,0xFDF3B646, 0x3FD8CE09,0x3ACBA6C4,
	0x3FD98937,0x4BC6A7F0, 0x3FD8DD22,0xE28E2802,
	0x3FD99999,0x9999999A, 0x3FD8EC3A,0xE92B676B,
	0x3FD9A9FB,0xE76C8B44, 0x3FD8FB51,0x4DA62967,
	0x3FD9BA5E,0x353F7CEE, 0x3FD90A66,0x0F014DC6,
	0x3FD9CAC0,0x83126E98, 0x3FD91979,0x2C3FCFD1,
	0x3FD9DB22,0xD0E56042, 0x3FD9288A,0xA464C656,
	0x3FD9EB85,0x1EB851EC, 0x3FD9379A,0x767363BE,
	0x3FD9FBE7,0x6C8B4396, 0x3FD946A8,0xA16EF61D,
	0x3FDA0C49,0xBA5E353F, 0x3FD955B5,0x245AE73D,
	0x3FDA1CAC,0x083126E9, 0x3FD964BF,0xFE3ABCB8,
	0x3FDA2D0E,0x56041893, 0x3FD973C9,0x2E1217FD,
	0x3FDA3D70,0xA3D70A3D, 0x3FD982D0,0xB2E4B66B,
	0x3FDA4DD2,0xF1A9FBE7, 0x3FD991D6,0x8BB6715B,
	0x3FDA5E35,0x3F7CED91, 0x3FD9A0DA,0xB78B3E34,
	0x3FDA6E97,0x8D4FDF3B, 0x3FD9AFDD,0x35672E7B,
	0x3FDA7EF9,0xDB22D0E5, 0x3FD9BEDE,0x044E6FDF,
	0x3FDA8F5C,0x28F5C28F, 0x3FD9CDDD,0x23454C51,
	0x3FDA9FBE,0x76C8B439, 0x3FD9DCDA,0x91502A0F,
	0x3FDAB020,0xC49BA5E3, 0x3FD9EBD6,0x4D738BB8,
	0x3FDAC083,0x126E978D, 0x3FD9FAD0,0x56B41057,
	0x3FDAD0E5,0x60418937, 0x3FDA09C8,0xAC16737C,
	0x3FDAE147,0xAE147AE1, 0x3FDA18BF,0x4C9F8D43,
	0x3FDAF1A9,0xFBE76C8B, 0x3FDA27B4,0x3754526D,
	0x3FDB020C,0x49BA5E35, 0x3FDA36A7,0x6B39D46A,
	0x3FDB126E,0x978D4FDF, 0x3FDA4598,0xE755416D,
	0x3FDB22D0,0xE5604189, 0x3FDA5488,0xAAABE47B,
	0x3FDB3333,0x33333333, 0x3FDA6376,0xB443257D,
	0x3FDB4395,0x810624DD, 0x3FDA7263,0x0320894E,
	0x3FDB53F7,0xCED91687, 0x3FDA814D,0x9649B1CD,
	0x3FDB645A,0x1CAC0831, 0x3FDA9036,0x6CC45DED,
	0x3FDB74BC,0x6A7EF9DB, 0x3FDA9F1D,0x859669C6,
	0x3FDB851E,0xB851EB85, 0x3FDAAE02,0xDFC5CEA5,
	0x3FDB9581,0x0624DD2F, 0x3FDABCE6,0x7A58A31C,
	0x3FDBA5E3,0x53F7CED9, 0x3FDACBC8,0x54551B12,
	0x3FDBB645,0xA1CAC083, 0x3FDADAA8,0x6CC187D6,
	0x3FDBC6A7,0xEF9DB22D, 0x3FDAE986,0xC2A4582C,
	0x3FDBD70A,0x3D70A3D7, 0x3FDAF863,0x5504185D,
	0x3FDBE76C,0x8B439581, 0x3FDB073E,0x22E7724D,
	0x3FDBF7CE,0xD916872B, 0x3FDB1617,0x2B552D85,
	0x3FDC0831,0x26E978D5, 0x3FDB24EE,0x6D542F46,
	0x3FDC1893,0x74BC6A7F, 0x3FDB33C3,0xE7EB7A99,
	0x3FDC28F5,0xC28F5C29, 0x3FDB4297,0x9A223061,
	0x3FDC3958,0x10624DD3, 0x3FDB5169,0x82FF8F67,
	0x3FDC49BA,0x5E353F7D, 0x3FDB6039,0xA18AF470,
	0x3FDC5A1C,0xAC083127, 0x3FDB6F07,0xF4CBDA48,
	0x3FDC6A7E,0xF9DB22D1, 0x3FDB7DD4,0x7BC9D9D6,
	0x3FDC7AE1,0x47AE147B, 0x3FDB8C9F,0x358CAA2B,
	0x3FDC8B43,0x95810625, 0x3FDB9B68,0x211C2090,
	0x3FDC9BA5,0xE353F7CF, 0x3FDBAA2F,0x3D80309B,
	0x3FDCAC08,0x3126E979, 0x3FDBB8F4,0x89C0EC3C,
	0x3FDCBC6A,0x7EF9DB23, 0x3FDBC7B8,0x04E683CD,
	0x3FDCCCCC,0xCCCCCCCD, 0x3FDBD679,0xADF94625,
	0x3FDCDD2F,0x1A9FBE77, 0x3FDBE539,0x8401A0A4,
	0x3FDCED91,0x6872B021, 0x3FDBF3F7,0x86081F48,
	0x3FDCFDF3,0xB645A1CB, 0x3FDC02B3,0xB3156CB9,
	0x3FDD0E56,0x04189375, 0x3FDC116E,0x0A32525C,
	0x3FDD1EB8,0x51EB851F, 0x3FDC2026,0x8A67B863,
	0x3FDD2F1A,0x9FBE76C9, 0x3FDC2EDD,0x32BEA5DA,
	0x3FDD3F7C,0xED916873, 0x3FDC3D92,0x024040BD,
	0x3FDD4FDF,0x3B645A1D, 0x3FDC4C44,0xF7F5CE02,
	0x3FDD6041,0x89374BC7, 0x3FDC5AF6,0x12E8B1AD,
	0x3FDD70A3,0xD70A3D71, 0x3FDC69A5,0x52226EE0,
	0x3FDD8106,0x24DD2F1B, 0x3FDC7852,0xB4ACA7E9,
	0x3FDD9168,0x72B020C5, 0x3FDC86FE,0x39911E54,
	0x3FDDA1CA,0xC083126F, 0x3FDC95A7,0xDFD9B2FA,
	0x3FDDB22D,0x0E560419, 0x3FDCA44F,0xA6906613,
	0x3FDDC28F,0x5C28F5C3, 0x3FDCB2F5,0x8CBF5745,
	0x3FDDD2F1,0xA9FBE76D, 0x3FDCC199,0x9170C5B2,
	0x3FDDE353,0xF7CED917, 0x3FDCD03B,0xB3AF100B,
	0x3FDDF3B6,0x45A1CAC1, 0x3FDCDEDB,0xF284B49F,
	0x3FDE0418,0x9374BC6A, 0x3FDCED7A,0x4CFC516D,
	0x3FDE147A,0xE147AE14, 0x3FDCFC16,0xC220A430,
	0x3FDE24DD,0x2F1A9FBE, 0x3FDD0AB1,0x50FC8A73,
	0x3FDE353F,0x7CED9168, 0x3FDD1949,0xF89B019E,
	0x3FDE45A1,0xCAC08312, 0x3FDD27E0,0xB8072709,
	0x3FDE5604,0x189374BC, 0x3FDD3675,0x8E4C380A,
	0x3FDE6666,0x66666666, 0x3FDD4508,0x7A759204,
	0x3FDE76C8,0xB4395810, 0x3FDD5399,0x7B8EB27D,
	0x3FDE872B,0x020C49BA, 0x3FDD6228,0x90A33724,
	0x3FDE978D,0x4FDF3B64, 0x3FDD70B5,0xB8BEDDEB,
	0x3FDEA7EF,0x9DB22D0E, 0x3FDD7F40,0xF2ED8511,
	0x3FDEB851,0xEB851EB8, 0x3FDD8DCA,0x3E3B2B35,
	0x3FDEC8B4,0x39581062, 0x3FDD9C51,0x99B3EF61,
	0x3FDED916,0x872B020C, 0x3FDDAAD7,0x04641123,
	0x3FDEE978,0xD4FDF3B6, 0x3FDDB95A,0x7D57F094,
	0x3FDEF9DB,0x22D0E560, 0x3FDDC7DC,0x039C0E6C,
	0x3FDF0A3D,0x70A3D70A, 0x3FDDD65B,0x963D0C13,
	0x3FDF1A9F,0xBE76C8B4, 0x3FDDE4D9,0x3447ABAE,
	0x3FDF2B02,0x0C49BA5E, 0x3FDDF354,0xDCC8D032,
	0x3FDF3B64,0x5A1CAC08, 0x3FDE01CE,0x8ECD7D70,
	0x3FDF4BC6,0xA7EF9DB2, 0x3FDE1046,0x4962D82B,
	0x3FDF5C28,0xF5C28F5C, 0x3FDE1EBC,0x0B962620,
	0x3FDF6C8B,0x43958106, 0x3FDE2D2F,0xD474CE1D,
	0x3FDF7CED,0x916872B0, 0x3FDE3BA1,0xA30C580E,
	0x3FDF8D4F,0xDF3B645A, 0x3FDE4A11,0x766A6D0C,
	0x3FDF9DB2,0x2D0E5604, 0x3FDE587F,0x4D9CD76C,
	0x3FDFAE14,0x7AE147AE, 0x3FDE66EB,0x27B182D6,
	0x3FDFBE76,0xC8B43958, 0x3FDE7555,0x03B67C49,
	0x3FDFCED9,0x16872B02, 0x3FDE83BC,0xE0B9F237,
	0x3FDFDF3B,0x645A1CAC, 0x3FDE9222,0xBDCA348C,
	0x3FDFEF9D,0xB22D0E56, 0x3FDEA086,0x99F5B4C2,
	0x3FE00000,0x00000000, 0x3FDEAEE8,0x744B05F0,
	0x3FE00831,0x26E978D5, 0x3FDEBD48,0x4BD8DCDA,
	0x3FE01062,0x4DD2F1AA, 0x3FDECBA6,0x1FAE0FFF,
	0x3FE01893,0x74BC6A7F, 0x3FDEDA01,0xEED997AD,
	0x3FE020C4,0x9BA5E354, 0x3FDEE85B,0xB86A8E0C,
	0x3FE028F5,0xC28F5C29, 0x3FDEF6B3,0x7B702F32,
	0x3FE03126,0xE978D4FE, 0x3FDF0509,0x36F9D92E,
	0x3FE03958,0x10624DD3, 0x3FDF135C,0xEA170C1C,
	0x3FE04189,0x374BC6A8, 0x3FDF21AE,0x93D76A34,
	0x3FE049BA,0x5E353F7D, 0x3FDF2FFE,0x334AB7D7,
	0x3FE051EB,0x851EB852, 0x3FDF3E4B,0xC780DBA3,
	0x3FE05A1C,0xAC083127, 0x3FDF4C97,0x4F89DE80,
	0x3FE0624D,0xD2F1A9FC, 0x3FDF5AE0,0xCA75EBAF,
	0x3FE06A7E,0xF9DB22D1, 0x3FDF6928,0x375550DB,
	0x3FE072B0,0x20C49BA6, 0x3FDF776D,0x95387E29,
	0x3FE07AE1,0x47AE147B, 0x3FDF85B0,0xE330064A,
	0x3FE08312,0x6E978D50, 0x3FDF93F2,0x204C9E83,
	0x3FE08B43,0x95810625, 0x3FDFA231,0x4B9F1EC6,
	0x3FE09374,0xBC6A7EFA, 0x3FDFB06E,0x643881BB,
	0x3FE09BA5,0xE353F7CF, 0x3FDFBEA9,0x6929E4D2,
	0x3FE0A3D7,0x0A3D70A4, 0x3FDFCCE2,0x59848856,
	0x3FE0AC08,0x3126E979, 0x3FDFDB19,0x3459CF74,
	0x3FE0B439,0x5810624E, 0x3FDFE94D,0xF8BB4055,
	0x3FE0BC6A,0x7EF9DB23, 0x3FDFF780,0xA5BA8426,
	0x3FE0C49B,0xA5E353F8, 0x3FE002D8,0x9D34B395,
	0x3FE0CCCC,0xCCCCCCCD, 0x3FE009EF,0xDAECEC66,
	0x3FE0D4FD,0xF3B645A2, 0x3FE01106,0x0B8EF5D4,
	0x3FE0DD2F,0x1A9FBE77, 0x3FE0181B,0x2EA3EAD3,
	0x3FE0E560,0x4189374C, 0x3FE01F2F,0x43B4F7FE,
	0x3FE0ED91,0x6872B021, 0x3FE02642,0x4A4B5BA4,
	0x3FE0F5C2,0x8F5C28F6, 0x3FE02D54,0x41F065CD,
	0x3FE0FDF3,0xB645A1CB, 0x3FE03465,0x2A2D7844,
	0x3FE10624,0xDD2F1AA0, 0x3FE03B75,0x028C069B,
	0x3FE10E56,0x04189375, 0x3FE04283,0xCA959638,
	0x3FE11687,0x2B020C4A, 0x3FE04991,0x81D3BE58,
	0x3FE11EB8,0x51EB851F, 0x3FE0509E,0x27D0281A,
	0x3FE126E9,0x78D4FDF4, 0x3FE057A9,0xBC148E83,
	0x3FE12F1A,0x9FBE76C9, 0x3FE05EB4,0x3E2ABE8D,
	0x3FE1374B,0xC6A7EF9E, 0x3FE065BD,0xAD9C9724,
	0x3FE13F7C,0xED916873, 0x3FE06CC6,0x09F40939,
	0x3FE147AE,0x147AE148, 0x3FE073CD,0x52BB17C2,
	0x3FE14FDF,0x3B645A1D, 0x3FE07AD3,0x877BD7C3,
	0x3FE15810,0x624DD2F2, 0x3FE081D8,0xA7C0705A,
	0x3FE16041,0x89374BC7, 0x3FE088DC,0xB3131AC2,
	0x3FE16872,0xB020C49C, 0x3FE08FDF,0xA8FE225B,
	0x3FE170A3,0xD70A3D71, 0x3FE096E1,0x890BE4B6,
	0x3FE178D4,0xFDF3B646, 0x3FE09DE2,0x52C6D197,
	0x3FE18106,0x24DD2F1B, 0x3FE0A4E2,0x05B96B02,
	0x3FE18937,0x4BC6A7F0, 0x3FE0ABE0,0xA16E453F,
	0x3FE19168,0x72B020C5, 0x3FE0B2DE,0x257006E1,
	0x3FE19999,0x9999999A, 0x3FE0B9DA,0x914968D4,
	0x3FE1A1CA,0xC083126F, 0x3FE0C0D5,0xE485365C,
	0x3FE1A9FB,0xE76C8B44, 0x3FE0C7D0,0x1EAE4D23,
	0x3FE1B22D,0x0E560419, 0x3FE0CEC9,0x3F4F9D3E,
	0x3FE1BA5E,0x353F7CEE, 0x3FE0D5C1,0x45F42936,
	0x3FE1C28F,0x5C28F5C3, 0x3FE0DCB8,0x3227060F,
	0x3FE1CAC0,0x83126E98, 0x3FE0E3AE,0x03735B4F,
	0x3FE1D2F1,0xA9FBE76D, 0x3FE0EAA2,0xB9646305,
	0x3FE1DB22,0xD0E56042, 0x3FE0F196,0x538569D5,
	0x3FE1E353,0xF7CED917, 0x3FE0F888,0xD161CEFA,
	0x3FE1EB85,0x1EB851EC, 0x3FE0FF7A,0x32850452,
	0x3FE1F3B6,0x45A1CAC1, 0x3FE1066A,0x767A8E63,
	0x3FE1FBE7,0x6C8B4396, 0x3FE10D59,0x9CCE0463,
	0x3FE20418,0x9374BC6A, 0x3FE11447,0xA50B1040,
	0x3FE20C49,0xBA5E353F, 0x3FE11B34,0x8EBD6EAA,
	0x3FE2147A,0xE147AE14, 0x3FE12220,0x5970EF16,
	0x3FE21CAC,0x083126E9, 0x3FE1290B,0x04B173CA,
	0x3FE224DD,0x2F1A9FBE, 0x3FE12FF4,0x900AF1DF,
	0x3FE22D0E,0x56041893, 0x3FE136DC,0xFB097151,
	0x3FE2353F,0x7CED9168, 0x3FE13DC4,0x45390CFD,
	0x3FE23D70,0xA3D70A3D, 0x3FE144AA,0x6E25F2B2,
	0x3FE245A1,0xCAC08312, 0x3FE14B8F,0x755C6331,
	0x3FE24DD2,0xF1A9FBE7, 0x3FE15273,0x5A68B238,
	0x3FE25604,0x189374BC, 0x3FE15956,0x1CD74689,
	0x3FE25E35,0x3F7CED91, 0x3FE16037,0xBC3499F4,
	0x3FE26666,0x66666666, 0x3FE16718,0x380D3959,
	0x3FE26E97,0x8D4FDF3B, 0x3FE16DF7,0x8FEDC4B4,
	0x3FE276C8,0xB4395810, 0x3FE174D5,0xC362EF26,
	0x3FE27EF9,0xDB22D0E5, 0x3FE17BB2,0xD1F97EF6,
	0x3FE2872B,0x020C49BA, 0x3FE1828E,0xBB3E4D9F,
	0x3FE28F5C,0x28F5C28F, 0x3FE18969,0x7EBE47D4,
	0x3FE2978D,0x4FDF3B64, 0x3FE19043,0x1C066D89,
	0x3FE29FBE,0x76C8B439, 0x3FE1971B,0x92A3D1FB,
	0x3FE2A7EF,0x9DB22D0E, 0x3FE19DF2,0xE2239BB5,
	0x3FE2B020,0xC49BA5E3, 0x3FE1A4C9,0x0A13049B,
	0x3FE2B851,0xEB851EB8, 0x3FE1AB9E,0x09FF59EE,
	0x3FE2C083,0x126E978D, 0x3FE1B271,0xE175FC57,
	0x3FE2C8B4,0x39581062, 0x3FE1B944,0x90045FEB,
	0x3FE2D0E5,0x60418937, 0x3FE1C016,0x15380C35,
	0x3FE2D916,0x872B020C, 0x3FE1C6E6,0x709E9C3E,
	0x3FE2E147,0xAE147AE1, 0x3FE1CDB5,0xA1C5BE92,
	0x3FE2E978,0xD4FDF3B6, 0x3FE1D483,0xA83B3548,
	0x3FE2F1A9,0xFBE76C8B, 0x3FE1DB50,0x838CD60C,
	0x3FE2F9DB,0x22D0E560, 0x3FE1E21C,0x33488A24,
	0x3FE3020C,0x49BA5E35, 0x3FE1E8E6,0xB6FC4E78,
	0x3FE30A3D,0x70A3D70A, 0x3FE1EFB0,0x0E36339A,
	0x3FE3126E,0x978D4FDF, 0x3FE1F678,0x38845DCD,
	0x3FE31A9F,0xBE76C8B4, 0x3FE1FD3F,0x3575050D,
	0x3FE322D0,0xE5604189, 0x3FE20405,0x04967515,
	0x3FE32B02,0x0C49BA5E, 0x3FE20AC9,0xA5770D68,
	0x3FE33333,0x33333333, 0x3FE2118D,0x17A54159,
	0x3FE33B64,0x5A1CAC08, 0x3FE2184F,0x5AAF9810,
	0x3FE34395,0x810624DD, 0x3FE21F10,0x6E24AC94,
	0x3FE34BC6,0xA7EF9DB2, 0x3FE225D0,0x51932DD0,
	0x3FE353F7,0xCED91687, 0x3FE22C8F,0x0489DE9D,
	0x3FE35C28,0xF5C28F5C, 0x3FE2334C,0x869795C8,
	0x3FE3645A,0x1CAC0831, 0x3FE23A08,0xD74B3E18,
	0x3FE36C8B,0x43958106, 0x3FE240C3,0xF633D658,
	0x3FE374BC,0x6A7EF9DB, 0x3FE2477D,0xE2E0715F,
	0x3FE37CED,0x916872B0, 0x3FE24E36,0x9CE03613,
	0x3FE3851E,0xB851EB85, 0x3FE254EE,0x23C25F74,
	0x3FE38D4F,0xDF3B645A, 0x3FE25BA4,0x77163CA3,
	0x3FE39581,0x0624DD2F, 0x3FE26259,0x966B30EA,
	0x3FE39DB2,0x2D0E5604, 0x3FE2690D,0x8150B3BF,
	0x3FE3A5E3,0x53F7CED9, 0x3FE26FC0,0x375650D3,
	0x3FE3AE14,0x7AE147AE, 0x3FE27671,0xB80BA812,
	0x3FE3B645,0xA1CAC083, 0x3FE27D22,0x03006DAE,
	0x3FE3BE76,0xC8B43958, 0x3FE283D1,0x17C46A26,
	0x3FE3C6A7,0xEF9DB22D, 0x3FE28A7E,0xF5E77A4D,
	0x3FE3CED9,0x16872B02, 0x3FE2912B,0x9CF98F52,
	0x3FE3D70A,0x3D70A3D7, 0x3FE297D7,0x0C8AAEC7,
	0x3FE3DF3B,0x645A1CAC, 0x3FE29E81,0x442AF2A7,
	0x3FE3E76C,0x8B439581, 0x3FE2A52A,0x436A895F,
	0x3FE3EF9D,0xB22D0E56, 0x3FE2ABD2,0x09D9B5D6,
	0x3FE3F7CE,0xD916872B, 0x3FE2B278,0x9708CF71,
	0x3FE40000,0x00000000, 0x3FE2B91D,0xEA88421E,
	0x3FE40831,0x26E978D5, 0x3FE2BFC2,0x03E88E59,
	0x3FE41062,0x4DD2F1AA, 0x3FE2C664,0xE2BA4935,
	0x3FE41893,0x74BC6A7F, 0x3FE2CD06,0x868E1C62,
	0x3FE420C4,0x9BA5E354, 0x3FE2D3A6,0xEEF4C634,
	0x3FE428F5,0xC28F5C29, 0x3FE2DA46,0x1B7F19AC,
	0x3FE43126,0xE978D4FE, 0x3FE2E0E4,0x0BBDFE7E,
	0x3FE43958,0x10624DD3, 0x3FE2E780,0xBF427117,
	0x3FE44189,0x374BC6A8, 0x3FE2EE1C,0x359D82A8,
	0x3FE449BA,0x5E353F7D, 0x3FE2F4B6,0x6E60592B,
	0x3FE451EB,0x851EB852, 0x3FE2FB4F,0x691C2F68,
	0x3FE45A1C,0xAC083127, 0x3FE301E7,0x25625502,
	0x3FE4624D,0xD2F1A9FC, 0x3FE3087D,0xA2C42E77,
	0x3FE46A7E,0xF9DB22D1, 0x3FE30F12,0xE0D3352F,
	0x3FE472B0,0x20C49BA6, 0x3FE315A6,0xDF20F77C,
	0x3FE47AE1,0x47AE147B, 0x3FE31C39,0x9D3F18A8,
	0x3FE48312,0x6E978D50, 0x3FE322CB,0x1ABF50F5,
	0x3FE48B43,0x95810625, 0x3FE3295B,0x57336DAB,
	0x3FE49374,0xBC6A7EFA, 0x3FE32FEA,0x522D511B,
	0x3FE49BA5,0xE353F7CF, 0x3FE33678,0x0B3EF2A9,
	0x3FE4A3D7,0x0A3D70A4, 0x3FE33D04,0x81FA5ECF,
	0x3FE4AC08,0x3126E979, 0x3FE3438F,0xB5F1B728,
	0x3FE4B439,0x5810624E, 0x3FE34A19,0xA6B73279,
	0x3FE4BC6A,0x7EF9DB23, 0x3FE350A2,0x53DD1CB0,
	0x3FE4C49B,0xA5E353F8, 0x3FE35729,0xBCF5D6F5,
	0x3FE4CCCC,0xCCCCCCCD, 0x3FE35DAF,0xE193D7AB,
	0x3FE4D4FD,0xF3B645A2, 0x3FE36434,0xC149AA79,
	0x3FE4DD2F,0x1A9FBE77, 0x3FE36AB8,0x5BA9F04F,
	0x3FE4E560,0x4189374C, 0x3FE3713A,0xB0475F74,
	0x3FE4ED91,0x6872B021, 0x3FE377BB,0xBEB4C383,
	0x3FE4F5C2,0x8F5C28F6, 0x3FE37E3B,0x8684FD7C,
	0x3FE4FDF3,0xB645A1CB, 0x3FE384BA,0x074B03C3,
	0x3FE50624,0xDD2F1AA0, 0x3FE38B37,0x4099E22D,
	0x3FE50E56,0x04189375, 0x3FE391B3,0x3204BA05,
	0x3FE51687,0x2B020C4A, 0x3FE3982D,0xDB1EC212,
	0x3FE51EB8,0x51EB851F, 0x3FE39EA7,0x3B7B46A0,
	0x3FE526E9,0x78D4FDF4, 0x3FE3A51F,0x52ADA986,
	0x3FE52F1A,0x9FBE76C9, 0x3FE3AB96,0x2049622E,
	0x3FE5374B,0xC6A7EF9E, 0x3FE3B20B,0xA3E1FD9A,
	0x3FE53F7C,0xED916873, 0x3FE3B87F,0xDD0B1E6F,
	0x3FE547AE,0x147AE148, 0x3FE3BEF2,0xCB587CF9,
	0x3FE54FDF,0x3B645A1D, 0x3FE3C564,0x6E5DE731,
	0x3FE55810,0x624DD2F2, 0x3FE3CBD4,0xC5AF40C8,
	0x3FE56041,0x89374BC7, 0x3FE3D243,0xD0E0832C,
	0x3FE56872,0xB020C49C, 0x3FE3D8B1,0x8F85BD8E,
	0x3FE570A3,0xD70A3D71, 0x3FE3DF1E,0x013314EC,
	0x3FE578D4,0xFDF3B646, 0x3FE3E589,0x257CC414,
	0x3FE58106,0x24DD2F1B, 0x3FE3EBF2,0xFBF71BAF,
	0x3FE58937,0x4BC6A7F0, 0x3FE3F25B,0x84368246,
	0x3FE59168,0x72B020C5, 0x3FE3F8C2,0xBDCF744A,
	0x3FE59999,0x9999999A, 0x3FE3FF28,0xA8568418,
	0x3FE5A1CA,0xC083126F, 0x3FE4058D,0x43605A06,
	0x3FE5A9FB,0xE76C8B44, 0x3FE40BF0,0x8E81B464,
	0x3FE5B22D,0x0E560419, 0x3FE41252,0x894F6788,
	0x3FE5BA5E,0x353F7CEE, 0x3FE418B3,0x335E5DD0,
	0x3FE5C28F,0x5C28F5C3, 0x3FE41F12,0x8C4397AD,
	0x3FE5CAC0,0x83126E98, 0x3FE42570,0x93942BA8,
	0x3FE5D2F1,0xA9FBE76D, 0x3FE42BCD,0x48E5466C,
	0x3FE5DB22,0xD0E56042, 0x3FE43228,0xABCC2AC7,
	0x3FE5E353,0xF7CED917, 0x3FE43882,0xBBDE31B7,
	0x3FE5EB85,0x1EB851EC, 0x3FE43EDB,0x78B0CA6E,
	0x3FE5F3B6,0x45A1CAC1, 0x3FE44532,0xE1D97A5B,
	0x3FE5FBE7,0x6C8B4396, 0x3FE44B88,0xF6EDDD2D,
	0x3FE60418,0x9374BC6A, 0x3FE451DD,0xB783A4DE,
	0x3FE60C49,0xBA5E353F, 0x3FE45831,0x233099B9,
	0x3FE6147A,0xE147AE14, 0x3FE45E83,0x398A9A60,
	0x3FE61CAC,0x083126E9, 0x3FE464D3,0xFA279BD4,
	0x3FE624DD,0x2F1A9FBE, 0x3FE46B23,0x649DA97A,
	0x3FE62D0E,0x56041893, 0x3FE47171,0x7882E525,
	0x3FE6353F,0x7CED9168, 0x3FE477BE,0x356D871A,
	0x3FE63D70,0xA3D70A3D, 0x3FE47E09,0x9AF3DE19,
	0x3FE645A1,0xCAC08312, 0x3FE48453,0xA8AC4F63,
	0x3FE64DD2,0xF1A9FBE7, 0x3FE48A9C,0x5E2D56C1,
	0x3FE65604,0x189374BC, 0x3FE490E3,0xBB0D868B,
	0x3FE65E35,0x3F7CED91, 0x3FE49729,0xBEE387AF,
	0x3FE66666,0x66666666, 0x3FE49D6E,0x694619B8,
	0x3FE66E97,0x8D4FDF3B, 0x3FE4A3B1,0xB9CC12D4,
	0x3FE676C8,0xB4395810, 0x3FE4A9F3,0xB00C5FDC,
	0x3FE67EF9,0xDB22D0E5, 0x3FE4B034,0x4B9E045B,
	0x3FE6872B,0x020C49BA, 0x3FE4B673,0x8C181A94,
	0x3FE68F5C,0x28F5C28F, 0x3FE4BCB1,0x7111D388,
	0x3FE6978D,0x4FDF3B64, 0x3FE4C2ED,0xFA227700,
	0x3FE69FBE,0x76C8B439, 0x3FE4C929,0x26E16392,
	0x3FE6A7EF,0x9DB22D0E, 0x3FE4CF62,0xF6E60EA5,
	0x3FE6B020,0xC49BA5E3, 0x3FE4D59B,0x69C8047F,
	0x3FE6B851,0xEB851EB8, 0x3FE4DBD2,0x7F1EE843,
	0x3FE6C083,0x126E978D, 0x3FE4E208,0x36827401,
	0x3FE6C8B4,0x39581062, 0x3FE4E83C,0x8F8A78B4,
	0x3FE6D0E5,0x60418937, 0x3FE4EE6F,0x89CEDE4F,
	0x3FE6D916,0x872B020C, 0x3FE4F4A1,0x24E7A3C2,
	0x3FE6E147,0xAE147AE1, 0x3FE4FAD1,0x606CDF00,
	0x3FE6E978,0xD4FDF3B6, 0x3FE50100,0x3BF6BD07,
	0x3FE6F1A9,0xFBE76C8B, 0x3FE5072D,0xB71D81E7,
	0x3FE6F9DB,0x22D0E560, 0x3FE50D59,0xD17988C6,
	0x3FE7020C,0x49BA5E35, 0x3FE51384,0x8AA343E9,
	0x3FE70A3D,0x70A3D70A, 0x3FE519AD,0xE2333CBE,
	0x3FE7126E,0x978D4FDF, 0x3FE51FD5,0xD7C213DC,
	0x3FE71A9F,0xBE76C8B4, 0x3FE525FC,0x6AE8810E,
	0x3FE722D0,0xE5604189, 0x3FE52C21,0x9B3F535A,
	0x3FE72B02,0x0C49BA5E, 0x3FE53245,0x685F7105,
	0x3FE73333,0x33333333, 0x3FE53867,0xD1E1D79D,
	0x3FE73B64,0x5A1CAC08, 0x3FE53E88,0xD75F9BFE,
	0x3FE74395,0x810624DD, 0x3FE544A8,0x7871EA58,
	0x3FE74BC6,0xA7EF9DB2, 0x3FE54AC6,0xB4B20639,
	0x3FE753F7,0xCED91687, 0x3FE550E3,0x8BB94A8E,
	0x3FE75C28,0xF5C28F5C, 0x3FE556FE,0xFD2129B1,
	0x3FE7645A,0x1CAC0831, 0x3FE55D19,0x08832D68,
	0x3FE76C8B,0x43958106, 0x3FE56331,0xAD78F6F4,
	0x3FE774BC,0x6A7EF9DB, 0x3FE56948,0xEB9C3F0F,
	0x3FE77CED,0x916872B0, 0x3FE56F5E,0xC286D5FA,
	0x3FE7851E,0xB851EB85, 0x3FE57573,0x31D2A380,
	0x3FE78D4F,0xDF3B645A, 0x3FE57B86,0x3919A6FD,
	0x3FE79581,0x0624DD2F, 0x3FE58197,0xD7F5F765,
	0x3FE79DB2,0x2D0E5604, 0x3FE587A8,0x0E01C34B,
	0x3FE7A5E3,0x53F7CED9, 0x3FE58DB6,0xDAD750E8,
	0x3FE7AE14,0x7AE147AE, 0x3FE593C4,0x3E10FE20,
	0x3FE7B645,0xA1CAC083, 0x3FE599D0,0x3749408C,
	0x3FE7BE76,0xC8B43958, 0x3FE59FDA,0xC61AA57B,
	0x3FE7C6A7,0xEF9DB22D, 0x3FE5A5E3,0xEA1FD1FF,
	0x3FE7CED9,0x16872B02, 0x3FE5ABEB,0xA2F382F0,
	0x3FE7D70A,0x3D70A3D7, 0x3FE5B1F1,0xF0308CF4,
	0x3FE7DF3B,0x645A1CAC, 0x3FE5B7F6,0xD171DC82,
	0x3FE7E76C,0x8B439581, 0x3FE5BDFA,0x465275EE,
	0x3FE7EF9D,0xB22D0E56, 0x3FE5C3FC,0x4E6D756F,
	0x3FE7F7CE,0xD916872B, 0x3FE5C9FC,0xE95E0F20,
	0x3FE80000,0x00000000, 0x3FE5CFFC,0x16BF8F0D,
	0x3FE80831,0x26E978D5, 0x3FE5D5F9,0xD62D5937,
	0x3FE81062,0x4DD2F1AA, 0x3FE5DBF6,0x2742E999,
	0x3FE81893,0x74BC6A7F, 0x3FE5E1F1,0x099BD432,
	0x3FE820C4,0x9BA5E354, 0x3FE5E7EA,0x7CD3C508,
	0x3FE828F5,0xC28F5C29, 0x3FE5EDE2,0x80868033,
	0x3FE83126,0xE978D4FE, 0x3FE5F3D9,0x144FE1DE,
	0x3FE83958,0x10624DD3, 0x3FE5F9CE,0x37CBDE53,
	0x3FE84189,0x374BC6A8, 0x3FE5FFC1,0xEA9681FE,
	0x3FE849BA,0x5E353F7D, 0x3FE605B4,0x2C4BF175,
	0x3FE851EB,0x851EB852, 0x3FE60BA4,0xFC88697D,
	0x3FE85A1C,0xAC083127, 0x3FE61194,0x5AE83F14,
	0x3FE8624D,0xD2F1A9FC, 0x3FE61782,0x4707DF72,
	0x3FE86A7E,0xF9DB22D1, 0x3FE61D6E,0xC083D016,
	0x3FE872B0,0x20C49BA6, 0x3FE62359,0xC6F8AEC8,
	0x3FE87AE1,0x47AE147B, 0x3FE62943,0x5A0331A0,
	0x3FE88312,0x6E978D50, 0x3FE62F2B,0x7940270E,
	0x3FE88B43,0x95810625, 0x3FE63512,0x244C75E1,
	0x3FE89374,0xBC6A7EFA, 0x3FE63AF7,0x5AC51D4A,
	0x3FE89BA5,0xE353F7CF, 0x3FE640DB,0x1C4734E7,
	0x3FE8A3D7,0x0A3D70A4, 0x3FE646BD,0x686FECC6,
	0x3FE8AC08,0x3126E979, 0x3FE64C9E,0x3EDC8D6D,
	0x3FE8B439,0x5810624E, 0x3FE6527D,0x9F2A77E1,
	0x3FE8BC6A,0x7EF9DB23, 0x3FE6585B,0x88F725A9,
	0x3FE8C49B,0xA5E353F8, 0x3FE65E37,0xFBE028DB,
	0x3FE8CCCC,0xCCCCCCCD, 0x3FE66412,0xF7832C1B,
	0x3FE8D4FD,0xF3B645A2, 0x3FE669EC,0x7B7DF2A9,
	0x3FE8DD2F,0x1A9FBE77, 0x3FE66FC4,0x876E5860,
	0x3FE8E560,0x4189374C, 0x3FE6759B,0x1AF251C0,
	0x3FE8ED91,0x6872B021, 0x3FE67B70,0x35A7EBF8,
	0x3FE8F5C2,0x8F5C28F6, 0x3FE68143,0xD72D4CE4,
	0x3FE8FDF3,0xB645A1CB, 0x3FE68715,0xFF20B31C,
	0x3FE90624,0xDD2F1AA0, 0x3FE68CE6,0xAD2075F5,
	0x3FE90E56,0x04189375, 0x3FE692B5,0xE0CB0587,
	0x3FE91687,0x2B020C4A, 0x3FE69883,0x99BEEABA,
	0x3FE91EB8,0x51EB851F, 0x3FE69E4F,0xD79AC743,
	0x3FE926E9,0x78D4FDF4, 0x3FE6A41A,0x99FD55B2,
	0x3FE92F1A,0x9FBE76C9, 0x3FE6A9E3,0xE0856975,
	0x3FE9374B,0xC6A7EF9E, 0x3FE6AFAB,0xAAD1EEDF,
	0x3FE93F7C,0xED916873, 0x3FE6B571,0xF881EB2C,
	0x3FE947AE,0x147AE148, 0x3FE6BB36,0xC9347C8E,
	0x3FE94FDF,0x3B645A1D, 0x3FE6C0FA,0x1C88DA2B,
	0x3FE95810,0x624DD2F2, 0x3FE6C6BB,0xF21E5429,
	0x3FE96041,0x89374BC7, 0x3FE6CC7C,0x499453B2,
	0x3FE96872,0xB020C49C, 0x3FE6D23B,0x228A5AFC,
	0x3FE970A3,0xD70A3D71, 0x3FE6D7F8,0x7CA0054E,
	0x3FE978D4,0xFDF3B646, 0x3FE6DDB4,0x57750704,
	0x3FE98106,0x24DD2F1B, 0x3FE6E36E,0xB2A92D9D,
	0x3FE98937,0x4BC6A7F0, 0x3FE6E927,0x8DDC5FB7,
	0x3FE99168,0x72B020C5, 0x3FE6EEDE,0xE8AE9D1E,
	0x3FE99999,0x9999999A, 0x3FE6F494,0xC2BFFECD,
	0x3FE9A1CA,0xC083126F, 0x3FE6FA49,0x1BB0B6F7,
	0x3FE9A9FB,0xE76C8B44, 0x3FE6FFFB,0xF321110D,
	0x3FE9B22D,0x0E560419, 0x3FE705AD,0x48B171C2,
	0x3FE9BA5E,0x353F7CEE, 0x3FE70B5D,0x1C025713,
	0x3FE9C28F,0x5C28F5C3, 0x3FE7110B,0x6CB4584E,
	0x3FE9CAC0,0x83126E98, 0x3FE716B8,0x3A682619,
	0x3FE9D2F1,0xA9FBE76D, 0x3FE71C63,0x84BE8A72,
	0x3FE9DB22,0xD0E56042, 0x3FE7220D,0x4B5868C0,
	0x3FE9E353,0xF7CED917, 0x3FE727B5,0x8DD6BDCD,
	0x3FE9EB85,0x1EB851EC, 0x3FE72D5C,0x4BDA9FD7,
	0x3FE9F3B6,0x45A1CAC1, 0x3FE73301,0x85053E8F,
	0x3FE9FBE7,0x6C8B4396, 0x3FE738A5,0x38F7E324,
	0x3FEA0418,0x9374BC6A, 0x3FE73E47,0x6753F043,
	0x3FEA0C49,0xBA5E353F, 0x3FE743E8,0x0FBAE227,
	0x3FEA147A,0xE147AE14, 0x3FE74987,0x31CE4E95,
	0x3FEA1CAC,0x083126E9, 0x3FE74F24,0xCD2FE4E8,
	0x3FEA24DD,0x2F1A9FBE, 0x3FE754C0,0xE1816E16,
	0x3FEA2D0E,0x56041893, 0x3FE75A5B,0x6E64CCB4,
	0x3FEA353F,0x7CED9168, 0x3FE75FF4,0x737BFD01,
	0x3FEA3D70,0xA3D70A3D, 0x3FE7658B,0xF06914E8,
	0x3FEA45A1,0xCAC08312, 0x3FE76B21,0xE4CE4408,
	0x3FEA4DD2,0xF1A9FBE7, 0x3FE770B6,0x504DD3B7,
	0x3FEA5604,0x189374BC, 0x3FE77649,0x328A270E,
	0x3FEA5E35,0x3F7CED91, 0x3FE77BDA,0x8B25BAEB,
	0x3FEA6666,0x66666666, 0x3FE7816A,0x59C325F7,
	0x3FEA6E97,0x8D4FDF3B, 0x3FE786F8,0x9E0518AD,
	0x3FEA76C8,0xB4395810, 0x3FE78C85,0x578E5D61,
	0x3FEA7EF9,0xDB22D0E5, 0x3FE79210,0x8601D846,
	0x3FEA872B,0x020C49BA, 0x3FE7979A,0x29028772,
	0x3FEA8F5C,0x28F5C28F, 0x3FE79D22,0x403382E6,
	0x3FEA978D,0x4FDF3B64, 0x3FE7A2A8,0xCB37FC95,
	0x3FEA9FBE,0x76C8B439, 0x3FE7A82D,0xC9B34065,
	0x3FEAA7EF,0x9DB22D0E, 0x3FE7ADB1,0x3B48B43E,
	0x3FEAB020,0xC49BA5E3, 0x3FE7B333,0x1F9BD806,
	0x3FEAB851,0xEB851EB8, 0x3FE7B8B3,0x765045AE,
	0x3FEAC083,0x126E978D, 0x3FE7BE32,0x3F09B137,
	0x3FEAC8B4,0x39581062, 0x3FE7C3AF,0x796BE8B5,
	0x3FEAD0E5,0x60418937, 0x3FE7C92B,0x251AD459,
	0x3FEAD916,0x872B020C, 0x3FE7CEA5,0x41BA7673,
	0x3FEAE147,0xAE147AE1, 0x3FE7D41D,0xCEEEEB7B,
	0x3FEAE978,0xD4FDF3B6, 0x3FE7D994,0xCC5C6A17,
	0x3FEAF1A9,0xFBE76C8B, 0x3FE7DF0A,0x39A7431F,
	0x3FEAF9DB,0x22D0E560, 0x3FE7E47E,0x1673E1A5,
	0x3FEB020C,0x49BA5E35, 0x3FE7E9F0,0x6266CAF9,
	0x3FEB0A3D,0x70A3D70A, 0x3FE7EF61,0x1D249EB1,
	0x3FEB126E,0x978D4FDF, 0x3FE7F4D0,0x465216AF,
	0x3FEB1A9F,0xBE76C8B4, 0x3FE7FA3D,0xDD940724,
	0x3FEB22D0,0xE5604189, 0x3FE7FFA9,0xE28F5E99,
	0x3FEB2B02,0x0C49BA5E, 0x3FE80514,0x54E925F6,
	0x3FEB3333,0x33333333, 0x3FE80A7D,0x34468083,
	0x3FEB3B64,0x5A1CAC08, 0x3FE80FE4,0x804CABF2,
	0x3FEB4395,0x810624DD, 0x3FE8154A,0x38A10066,
	0x3FEB4BC6,0xA7EF9DB2, 0x3FE81AAE,0x5CE8F073,
	0x3FEB53F7,0xCED91687, 0x3FE82010,0xECCA092C,
	0x3FEB5C28,0xF5C28F5C, 0x3FE82571,0xE7E9F221,
	0x3FEB645A,0x1CAC0831, 0x3FE82AD1,0x4DEE6D6B,
	0x3FEB6C8B,0x43958106, 0x3FE8302F,0x1E7D57AE,
	0x3FEB74BC,0x6A7EF9DB, 0x3FE8358B,0x593CA823,
	0x3FEB7CED,0x916872B0, 0x3FE83AE5,0xFDD27099,
	0x3FEB851E,0xB851EB85, 0x3FE8403F,0x0BE4DD7E,
	0x3FEB8D4F,0xDF3B645A, 0x3FE84596,0x831A35E4,
	0x3FEB9581,0x0624DD2F, 0x3FE84AEC,0x6318DB87,
	0x3FEB9DB2,0x2D0E5604, 0x3FE85040,0xAB874AD4,
	0x3FEBA5E3,0x53F7CED9, 0x3FE85593,0x5C0C1AEC,
	0x3FEBAE14,0x7AE147AE, 0x3FE85AE4,0x744DFDAD,
	0x3FEBB645,0xA1CAC083, 0x3FE86033,0xF3F3BFB6,
	0x3FEBBE76,0xC8B43958, 0x3FE86581,0xDAA4486D,
	0x3FEBC6A7,0xEF9DB22D, 0x3FE86ACE,0x28069A06,
	0x3FEBCED9,0x16872B02, 0x3FE87018,0xDBC1D187,
	0x3FEBD70A,0x3D70A3D7, 0x3FE87561,0xF57D26D0,
	0x3FEBDF3B,0x645A1CAC, 0x3FE87AA9,0x74DFEC9F,
	0x3FEBE76C,0x8B439581, 0x3FE87FEF,0x59919096,
	0x3FEBEF9D,0xB22D0E56, 0x3FE88533,0xA3399B42,
	0x3FEBF7CE,0xD916872B, 0x3FE88A76,0x517FB01F,
	0x3FEC0000,0x00000000, 0x3FE88FB7,0x640B8DA2,
	0x3FEC0831,0x26E978D5, 0x3FE894F6,0xDA850D37,
	0x3FEC1062,0x4DD2F1AA, 0x3FE89A34,0xB494234E,
	0x3FEC1893,0x74BC6A7F, 0x3FE89F70,0xF1E0DF5F,
	0x3FEC20C4,0x9BA5E354, 0x3FE8A4AB,0x92136BEE,
	0x3FEC28F5,0xC28F5C29, 0x3FE8A9E4,0x94D40E90,
	0x3FEC3126,0xE978D4FE, 0x3FE8AF1B,0xF9CB27F5,
	0x3FEC3958,0x10624DD3, 0x3FE8B451,0xC0A133EA,
	0x3FEC4189,0x374BC6A8, 0x3FE8B985,0xE8FEC961,
	0x3FEC49BA,0x5E353F7D, 0x3FE8BEB8,0x728C9A73,
	0x3FEC51EB,0x851EB852, 0x3FE8C3E9,0x5CF3746C,
	0x3FEC5A1C,0xAC083127, 0x3FE8C918,0xA7DC3FCB,
	0x3FEC624D,0xD2F1A9FC, 0x3FE8CE46,0x52F00049,
	0x3FEC6A7E,0xF9DB22D1, 0x3FE8D372,0x5DD7D4E1,
	0x3FEC72B0,0x20C49BA6, 0x3FE8D89C,0xC83CF7D5,
	0x3FEC7AE1,0x47AE147B, 0x3FE8DDC5,0x91C8BEB0,
	0x3FEC8312,0x6E978D50, 0x3FE8E2EC,0xBA249A52,
	0x3FEC8B43,0x95810625, 0x3FE8E812,0x40FA16EF,
	0x3FEC9374,0xBC6A7EFA, 0x3FE8ED36,0x25F2DC1A,
	0x3FEC9BA5,0xE353F7CF, 0x3FE8F258,0x68B8ACC8,
	0x3FECA3D7,0x0A3D70A4, 0x3FE8F779,0x08F56756,
	0x3FECAC08,0x3126E979, 0x3FE8FC98,0x0653058F,
	0x3FECB439,0x5810624E, 0x3FE901B5,0x607B9CB2,
	0x3FECBC6A,0x7EF9DB23, 0x3FE906D1,0x17195D76,
	0x3FECC49B,0xA5E353F8, 0x3FE90BEB,0x29D69412,
	0x3FECCCCC,0xCCCCCCCD, 0x3FE91103,0x985DA841,
	0x3FECD4FD,0xF3B645A2, 0x3FE9161A,0x62591D47,
	0x3FECDD2F,0x1A9FBE77, 0x3FE91B2F,0x877391F9,
	0x3FECE560,0x4189374C, 0x3FE92043,0x0757C0C0,
	0x3FECED91,0x6872B021, 0x3FE92554,0xE1B07FA0,
	0x3FECF5C2,0x8F5C28F6, 0x3FE92A65,0x1628C03F,
	0x3FECFDF3,0xB645A1CB, 0x3FE92F73,0xA46B8FE6,
	0x3FED0624,0xDD2F1AA0, 0x3FE93480,0x8C24178C,
	0x3FED0E56,0x04189375, 0x3FE9398B,0xCCFD9BD8,
	0x3FED1687,0x2B020C4A, 0x3FE93E95,0x66A37D27,
	0x3FED1EB8,0x51EB851F, 0x3FE9439D,0x58C13794,
	0x3FED26E9,0x78D4FDF4, 0x3FE948A3,0xA30262F9,
	0x3FED2F1A,0x9FBE76C9, 0x3FE94DA8,0x4512B2FA,
	0x3FED374B,0xC6A7EF9E, 0x3FE952AB,0x3E9DF706,
	0x3FED3F7C,0xED916873, 0x3FE957AC,0x8F501A5F,
	0x3FED47AE,0x147AE148, 0x3FE95CAC,0x36D5241F,
	0x3FED4FDF,0x3B645A1D, 0x3FE961AA,0x34D9373B,
	0x3FED5810,0x624DD2F2, 0x3FE966A6,0x8908928E,
	0x3FED6041,0x89374BC7, 0x3FE96BA1,0x330F90D9,
	0x3FED6872,0xB020C49C, 0x3FE9709A,0x329AA8CC,
	0x3FED70A3,0xD70A3D71, 0x3FE97591,0x87566D0A,
	0x3FED78D4,0xFDF3B646, 0x3FE97A87,0x30EF8C2E,
	0x3FED8106,0x24DD2F1B, 0x3FE97F7B,0x2F12D0D2,
	0x3FED8937,0x4BC6A7F0, 0x3FE9846D,0x816D2193,
	0x3FED9168,0x72B020C5, 0x3FE9895E,0x27AB8116,
	0x3FED9999,0x9999999A, 0x3FE98E4D,0x217B0E12,
	0x3FEDA1CA,0xC083126F, 0x3FE9933A,0x6E89034D,
	0x3FEDA9FB,0xE76C8B44, 0x3FE99826,0x0E82B7AB,
	0x3FEDB22D,0x0E560419, 0x3FE99D10,0x01159E2C,
	0x3FEDBA5E,0x353F7CEE, 0x3FE9A1F8,0x45EF45F5,
	0x3FEDC28F,0x5C28F5C3, 0x3FE9A6DE,0xDCBD5A54,
	0x3FEDCAC0,0x83126E98, 0x3FE9ABC3,0xC52DA2C6,
	0x3FEDD2F1,0xA9FBE76D, 0x3FE9B0A6,0xFEEE02FE,
	0x3FEDDB22,0xD0E56042, 0x3FE9B588,0x89AC7AE7,
	0x3FEDE353,0xF7CED917, 0x3FE9BA68,0x651726AB,
	0x3FEDEB85,0x1EB851EC, 0x3FE9BF46,0x90DC3EB9,
	0x3FEDF3B6,0x45A1CAC1, 0x3FE9C423,0x0CAA17CA,
	0x3FEDFBE7,0x6C8B4396, 0x3FE9C8FD,0xD82F22E7,
	0x3FEE0418,0x9374BC6A, 0x3FE9CDD6,0xF319ED6B,
	0x3FEE0C49,0xBA5E353F, 0x3FE9D2AE,0x5D19210E,
	0x3FEE147A,0xE147AE14, 0x3FE9D784,0x15DB83E4,
	0x3FEE1CAC,0x083126E9, 0x3FE9DC58,0x1D0FF869,
	0x3FEE24DD,0x2F1A9FBE, 0x3FE9E12A,0x72657D80,
	0x3FEE2D0E,0x56041893, 0x3FE9E5FB,0x158B2E7B,
	0x3FEE353F,0x7CED9168, 0x3FE9EACA,0x06304324,
	0x3FEE3D70,0xA3D70A3D, 0x3FE9EF97,0x44040FBA,
	0x3FEE45A1,0xCAC08312, 0x3FE9F462,0xCEB604FF,
	0x3FEE4DD2,0xF1A9FBE7, 0x3FE9F92C,0xA5F5B037,
	0x3FEE5604,0x189374BC, 0x3FE9FDF4,0xC972BB30,
	0x3FEE5E35,0x3F7CED91, 0x3FEA02BB,0x38DCEC48,
	0x3FEE6666,0x66666666, 0x3FEA077F,0xF3E4266F,
	0x3FEE6E97,0x8D4FDF3B, 0x3FEA0C42,0xFA386930,
	0x3FEE76C8,0xB4395810, 0x3FEA1104,0x4B89D0B4,
	0x3FEE7EF9,0xDB22D0E5, 0x3FEA15C3,0xE78895C8,
	0x3FEE872B,0x020C49BA, 0x3FEA1A81,0xCDE50DE2,
	0x3FEE8F5C,0x28F5C28F, 0x3FEA1F3D,0xFE4FAB27,
	0x3FEE978D,0x4FDF3B64, 0x3FEA23F8,0x7878FC6E,
	0x3FEE9FBE,0x76C8B439, 0x3FEA28B1,0x3C11AD47,
	0x3FEEA7EF,0x9DB22D0E, 0x3FEA2D68,0x48CA8602,
	0x3FEEB020,0xC49BA5E3, 0x3FEA321D,0x9E546BAF,
	0x3FEEB851,0xEB851EB8, 0x3FEA36D1,0x3C606028,
	0x3FEEC083,0x126E978D, 0x3FEA3B83,0x229F8214,
	0x3FEEC8B4,0x39581062, 0x3FEA4033,0x50C30CEE,
	0x3FEED0E5,0x60418937, 0x3FEA44E1,0xC67C5907,
	0x3FEED916,0x872B020C, 0x3FEA498E,0x837CDB8C,
	0x3FEEE147,0xAE147AE1, 0x3FEA4E39,0x87762690,
	0x3FEEE978,0xD4FDF3B6, 0x3FEA52E2,0xD219E90A,
	0x3FEEF1A9,0xFBE76C8B, 0x3FEA578A,0x6319EEDD,
	0x3FEEF9DB,0x22D0E560, 0x3FEA5C30,0x3A2820E1,
	0x3FEF020C,0x49BA5E35, 0x3FEA60D4,0x56F684E0,
	0x3FEF0A3D,0x70A3D70A, 0x3FEA6576,0xB9373DA3,
	0x3FEF126E,0x978D4FDF, 0x3FEA6A17,0x609C8AF3,
	0x3FEF1A9F,0xBE76C8B4, 0x3FEA6EB6,0x4CD8C99E,
	0x3FEF22D0,0xE5604189, 0x3FEA7353,0x7D9E737E,
	0x3FEF2B02,0x0C49BA5E, 0x3FEA77EE,0xF2A01F7E,
	0x3FEF3333,0x33333333, 0x3FEA7C88,0xAB90819B,
	0x3FEF3B64,0x5A1CAC08, 0x3FEA8120,0xA8226AEF,
	0x3FEF4395,0x810624DD, 0x3FEA85B6,0xE808C9B3,
	0x3FEF4BC6,0xA7EF9DB2, 0x3FEA8A4B,0x6AF6A943,
	0x3FEF53F7,0xCED91687, 0x3FEA8EDE,0x309F3225,
	0x3FEF5C28,0xF5C28F5C, 0x3FEA936F,0x38B5AA0E,
	0x3FEF645A,0x1CAC0831, 0x3FEA97FE,0x82ED73E6,
	0x3FEF6C8B,0x43958106, 0x3FEA9C8C,0x0EFA0FCD,
	0x3FEF74BC,0x6A7EF9DB, 0x3FEAA117,0xDC8F1B21,
	0x3FEF7CED,0x916872B0, 0x3FEAA5A1,0xEB605083,
	0x3FEF851E,0xB851EB85, 0x3FEAAA2A,0x3B2187DA,
	0x3FEF8D4F,0xDF3B645A, 0x3FEAAEB0,0xCB86B65A,
	0x3FEF9581,0x0624DD2F, 0x3FEAB335,0x9C43EE8A,
	0x3FEF9DB2,0x2D0E5604, 0x3FEAB7B8,0xAD0D6045,
	0x3FEFA5E3,0x53F7CED9, 0x3FEABC39,0xFD9758C4,
	0x3FEFAE14,0x7AE147AE, 0x3FEAC0B9,0x8D96429D,
	0x3FEFB645,0xA1CAC083, 0x3FEAC537,0x5CBEA5CE,
	0x3FEFBE76,0xC8B43958, 0x3FEAC9B3,0x6AC527BF,
	0x3FEFC6A7,0xEF9DB22D, 0x3FEACE2D,0xB75E8B46,
	0x3FEFCED9,0x16872B02, 0x3FEAD2A6,0x423FB0AF,
	0x3FEFD70A,0x3D70A3D7, 0x3FEAD71D,0x0B1D95BC,
	0x3FEFDF3B,0x645A1CAC, 0x3FEADB92,0x11AD55AF,
	0x3FEFE76C,0x8B439581, 0x3FEAE005,0x55A4294E,
	0x3FEFEF9D,0xB22D0E56, 0x3FEAE476,0xD6B766E4,
	0x3FEFF7CE,0xD916872B, 0x3FEAE8E6,0x949C824C,
	0x3FF00000,0x00000000, 0x3FEAED54,0x8F090CEE,
	0x3FF00418,0x9374BC6A, 0x3FEAF1C0,0xC5B2B5CC,
	0x3FF00831,0x26E978D5, 0x3FEAF62B,0x384F4984,
	0x3FF00C49,0xBA5E353F, 0x3FEAFA93,0xE694B251,
	0x3FF01062,0x4DD2F1AA, 0x3FEAFEFA,0xD038F814,
	0x3FF0147A,0xE147AE14, 0x3FEB035F,0xF4F24059,
	0x3FF01893,0x74BC6A7F, 0x3FEB07C3,0x5476CE5C,
	0x3FF01CAC,0x083126E9, 0x3FEB0C24,0xEE7D0306,
	0x3FF020C4,0x9BA5E354, 0x3FEB1084,0xC2BB5D02,
	0x3FF024DD,0x2F1A9FBE, 0x3FEB14E2,0xD0E878B0,
	0x3FF028F5,0xC28F5C29, 0x3FEB193F,0x18BB1036,
	0x3FF02D0E,0x56041893, 0x3FEB1D99,0x99E9FB7F,
	0x3FF03126,0xE978D4FE, 0x3FEB21F2,0x542C3045,
	0x3FF0353F,0x7CED9168, 0x3FEB2649,0x4738C20D,
	0x3FF03958,0x10624DD3, 0x3FEB2A9E,0x72C6E236,
	0x3FF03D70,0xA3D70A3D, 0x3FEB2EF1,0xD68DDFF6,
	0x3FF04189,0x374BC6A8, 0x3FEB3343,0x72452863,
	0x3FF045A1,0xCAC08312, 0x3FEB3793,0x45A44675,
	0x3FF049BA,0x5E353F7D, 0x3FEB3BE1,0x5062E30F,
	0x3FF04DD2,0xF1A9FBE7, 0x3FEB402D,0x9238C4FE,
	0x3FF051EB,0x851EB852, 0x3FEB4478,0x0ADDD103,
	0x3FF05604,0x189374BC, 0x3FEB48C0,0xBA0A09D2,
	0x3FF05A1C,0xAC083127, 0x3FEB4D07,0x9F75901E,
	0x3FF05E35,0x3F7CED91, 0x3FEB514C,0xBAD8A298,
	0x3FF0624D,0xD2F1A9FC, 0x3FEB5590,0x0BEB9DF6,
	0x3FF06666,0x66666666, 0x3FEB59D1,0x9266FCF5,
	0x3FF06A7E,0xF9DB22D1, 0x3FEB5E11,0x4E035864,
	0x3FF06E97,0x8D4FDF3B, 0x3FEB624F,0x3E796721,
	0x3FF072B0,0x20C49BA6, 0x3FEB668B,0x6381FE24,
	0x3FF076C8,0xB4395810, 0x3FEB6AC5,0xBCD6107D,
	0x3FF07AE1,0x47AE147B, 0x3FEB6EFE,0x4A2EAF62,
	0x3FF07EF9,0xDB22D0E5, 0x3FEB7335,0x0B450A29,
	0x3FF08312,0x6E978D50, 0x3FEB7769,0xFFD26E56,
	0x3FF0872B,0x020C49BA, 0x3FEB7B9D,0x27904798,
	0x3FF08B43,0x95810625, 0x3FEB7FCE,0x82381FD5,
	0x3FF08F5C,0x28F5C28F, 0x3FEB83FE,0x0F839F26,
	0x3FF09374,0xBC6A7EFA, 0x3FEB882B,0xCF2C8BE5,
	0x3FF0978D,0x4FDF3B64, 0x3FEB8C57,0xC0ECCAA8,
	0x3FF09BA5,0xE353F7CF, 0x3FEB9081,0xE47E5E51,
	0x3FF09FBE,0x76C8B439, 0x3FEB94AA,0x399B6806,
	0x3FF0A3D7,0x0A3D70A4, 0x3FEB98D0,0xBFFE273F,
	0x3FF0A7EF,0x9DB22D0E, 0x3FEB9CF5,0x7760F9C6,
	0x3FF0AC08,0x3126E979, 0x3FEBA118,0x5F7E5BBE,
	0x3FF0B020,0xC49BA5E3, 0x3FEBA539,0x7810E7A5,
	0x3FF0B439,0x5810624E, 0x3FEBA958,0xC0D3565D,
	0x3FF0B851,0xEB851EB8, 0x3FEBAD76,0x39807F27,
	0x3FF0BC6A,0x7EF9DB23, 0x3FEBB191,0xE1D357B6,
	0x3FF0C083,0x126E978D, 0x3FEBB5AB,0xB986F426,
	0x3FF0C49B,0xA5E353F8, 0x3FEBB9C3,0xC0568708,
	0x3FF0C8B4,0x39581062, 0x3FEBBDD9,0xF5FD6165,
	0x3FF0CCCC,0xCCCCCCCD, 0x3FEBC1EE,0x5A36F2C1,
	0x3FF0D0E5,0x60418937, 0x3FEBC600,0xECBEC920,
	0x3FF0D4FD,0xF3B645A2, 0x3FEBCA11,0xAD50910E,
	0x3FF0D916,0x872B020C, 0x3FEBCE20,0x9BA8159C,
	0x3FF0DD2F,0x1A9FBE77, 0x3FEBD22D,0xB781406F,
	0x3FF0E147,0xAE147AE1, 0x3FEBD639,0x009819B8,
	0x3FF0E560,0x4189374C, 0x3FEBDA42,0x76A8C845,
	0x3FF0E978,0xD4FDF3B6, 0x3FEBDE4A,0x196F9179,
	0x3FF0ED91,0x6872B021, 0x3FEBE24F,0xE8A8D95D,
	0x3FF0F1A9,0xFBE76C8B, 0x3FEBE653,0xE411229A,
	0x3FF0F5C2,0x8F5C28F6, 0x3FEBEA56,0x0B650E83,
	0x3FF0F9DB,0x22D0E560, 0x3FEBEE56,0x5E615D18,
	0x3FF0FDF3,0xB645A1CB, 0x3FEBF254,0xDCC2ED0C,
	0x3FF1020C,0x49BA5E35, 0x3FEBF651,0x8646BBC4,
	0x3FF10624,0xDD2F1AA0, 0x3FEBFA4C,0x5AA9E564,
	0x3FF10A3D,0x70A3D70A, 0x3FEBFE45,0x59A9A4CB,
	0x3FF10E56,0x04189375, 0x3FEC023C,0x8303539E,
	0x3FF1126E,0x978D4FDF, 0x3FEC0631,0xD6746A45,
	0x3FF11687,0x2B020C4A, 0x3FEC0A25,0x53BA7FFA,
	0x3FF11A9F,0xBE76C8B4, 0x3FEC0E16,0xFA934AC1,
	0x3FF11EB8,0x51EB851F, 0x3FEC1206,0xCABC9F77,
	0x3FF122D0,0xE5604189, 0x3FEC15F4,0xC3F471CE,
	0x3FF126E9,0x78D4FDF4, 0x3FEC19E0,0xE5F8D459,
	0x3FF12B02,0x0C49BA5E, 0x3FEC1DCB,0x3087F889,
	0x3FF12F1A,0x9FBE76C9, 0x3FEC21B3,0xA3602EB7,
	0x3FF13333,0x33333333, 0x3FEC259A,0x3E3FE625,
	0x3FF1374B,0xC6A7EF9E, 0x3FEC297F,0x00E5AD04,
	0x3FF13B64,0x5A1CAC08, 0x3FEC2D61,0xEB103077,
	0x3FF13F7C,0xED916873, 0x3FEC3142,0xFC7E3C99,
	0x3FF14395,0x810624DD, 0x3FEC3522,0x34EEBC7D,
	0x3FF147AE,0x147AE148, 0x3FEC38FF,0x9420BA3B,
	0x3FF14BC6,0xA7EF9DB2, 0x3FEC3CDB,0x19D35EE9,
	0x3FF14FDF,0x3B645A1D, 0x3FEC40B4,0xC5C5F2AA,
	0x3FF153F7,0xCED91687, 0x3FEC448C,0x97B7DCA8,
	0x3FF15810,0x624DD2F2, 0x3FEC4862,0x8F68A322,
	0x3FF15C28,0xF5C28F5C, 0x3FEC4C36,0xAC97EB6A,
	0x3FF16041,0x89374BC7, 0x3FEC5008,0xEF0579EA,
	0x3FF1645A,0x1CAC0831, 0x3FEC53D9,0x5671322A,
	0x3FF16872,0xB020C49C, 0x3FEC57A7,0xE29B16D4,
	0x3FF16C8B,0x43958106, 0x3FEC5B74,0x934349B5,
	0x3FF170A3,0xD70A3D71, 0x3FEC5F3F,0x682A0BC7,
	0x3FF174BC,0x6A7EF9DB, 0x3FEC6308,0x610FBD2F,
	0x3FF178D4,0xFDF3B646, 0x3FEC66CF,0x7DB4DD46,
	0x3FF17CED,0x916872B0, 0x3FEC6A94,0xBDDA0A99,
	0x3FF18106,0x24DD2F1B, 0x3FEC6E58,0x214002F3,
	0x3FF1851E,0xB851EB85, 0x3FEC7219,0xA7A7A359,
	0x3FF18937,0x4BC6A7F0, 0x3FEC75D9,0x50D1E817,
	0x3FF18D4F,0xDF3B645A, 0x3FEC7997,0x1C7FECBB,
	0x3FF19168,0x72B020C5, 0x3FEC7D53,0x0A72EC23,
	0x3FF19581,0x0624DD2F, 0x3FEC810D,0x1A6C4078,
	0x3FF19999,0x9999999A, 0x3FEC84C5,0x4C2D6338,
	0x3FF19DB2,0x2D0E5604, 0x3FEC887B,0x9F77ED36,
	0x3FF1A1CA,0xC083126F, 0x3FEC8C30,0x140D96A6,
	0x3FF1A5E3,0x53F7CED9, 0x3FEC8FE2,0xA9B03713,
	0x3FF1A9FB,0xE76C8B44, 0x3FEC9393,0x6021C573,
	0x3FF1AE14,0x7AE147AE, 0x3FEC9742,0x3724581E,
	0x3FF1B22D,0x0E560419, 0x3FEC9AEF,0x2E7A24DC,
	0x3FF1B645,0xA1CAC083, 0x3FEC9E9A,0x45E580E1,
	0x3FF1BA5E,0x353F7CEE, 0x3FECA243,0x7D28E0D7,
	0x3FF1BE76,0xC8B43958, 0x3FECA5EA,0xD406D8DE,
	0x3FF1C28F,0x5C28F5C3, 0x3FECA990,0x4A421C93,
	0x3FF1C6A7,0xEF9DB22D, 0x3FECAD33,0xDF9D7F12,
	0x3FF1CAC0,0x83126E98, 0x3FECB0D5,0x93DBF2FC,
	0x3FF1CED9,0x16872B02, 0x3FECB475,0x66C08A77,
	0x3FF1D2F1,0xA9FBE76D, 0x3FECB813,0x580E7738,
	0x3FF1D70A,0x3D70A3D7, 0x3FECBBAF,0x67890A81,
	0x3FF1DB22,0xD0E56042, 0x3FECBF49,0x94F3B52A,
	0x3FF1DF3B,0x645A1CAC, 0x3FECC2E1,0xE012079F,
	0x3FF1E353,0xF7CED917, 0x3FECC678,0x48A7B1EE,
	0x3FF1E76C,0x8B439581, 0x3FECCA0C,0xCE7883BE,
	0x3FF1EB85,0x1EB851EC, 0x3FECCD9F,0x71486C5E,
	0x3FF1EF9D,0xB22D0E56, 0x3FECD130,0x30DB7AC0,
	0x3FF1F3B6,0x45A1CAC1, 0x3FECD4BF,0x0CF5DD87,
	0x3FF1F7CE,0xD916872B, 0x3FECD84C,0x055BE300,
	0x3FF1FBE7,0x6C8B4396, 0x3FECDBD7,0x19D1F930,
	0x3FF20000,0x00000000, 0x3FECDF60,0x4A1CADCE,
	0x3FF20418,0x9374BC6A, 0x3FECE2E7,0x9600AE50,
	0x3FF20831,0x26E978D5, 0x3FECE66C,0xFD42C7EB,
	0x3FF20C49,0xBA5E353F, 0x3FECE9F0,0x7FA7E793,
	0x3FF21062,0x4DD2F1AA, 0x3FECED72,0x1CF51A07,
	0x3FF2147A,0xE147AE14, 0x3FECF0F1,0xD4EF8BCD,
	0x3FF21893,0x74BC6A7F, 0x3FECF46F,0xA75C893D,
	0x3FF21CAC,0x083126E9, 0x3FECF7EB,0x94017E7D,
	0x3FF220C4,0x9BA5E354, 0x3FECFB65,0x9AA3F78C,
	0x3FF224DD,0x2F1A9FBE, 0x3FECFEDD,0xBB09A042,
	0x3FF228F5,0xC28F5C29, 0x3FED0253,0xF4F84456,
	0x3FF22D0E,0x56041893, 0x3FED05C8,0x4835CF5D,
	0x3FF23126,0xE978D4FE, 0x3FED093A,0xB4884CD6,
	0x3FF2353F,0x7CED9168, 0x3FED0CAB,0x39B5E826,
	0x3FF23958,0x10624DD3, 0x3FED1019,0xD784EC9F,
	0x3FF23D70,0xA3D70A3D, 0x3FED1386,0x8DBBC585,
	0x3FF24189,0x374BC6A8, 0x3FED16F1,0x5C20FE11,
	0x3FF245A1,0xCAC08312, 0x3FED1A5A,0x427B4171,
	0x3FF249BA,0x5E353F7D, 0x3FED1DC1,0x40915AD3,
	0x3FF24DD2,0xF1A9FBE7, 0x3FED2126,0x562A3562,
	0x3FF251EB,0x851EB852, 0x3FED2489,0x830CDC4E,
	0x3FF25604,0x189374BC, 0x3FED27EA,0xC7007ACC,
	0x3FF25A1C,0xAC083127, 0x3FED2B4A,0x21CC5C20,
	0x3FF25E35,0x3F7CED91, 0x3FED2EA7,0x9337EB98,
	0x3FF2624D,0xD2F1A9FC, 0x3FED3203,0x1B0AB499,
	0x3FF26666,0x66666666, 0x3FED355C,0xB90C6298,
	0x3FF26A7E,0xF9DB22D1, 0x3FED38B4,0x6D04C12C,
	0x3FF26E97,0x8D4FDF3B, 0x3FED3C0A,0x36BBBC01,
	0x3FF272B0,0x20C49BA6, 0x3FED3F5E,0x15F95EEA,
	0x3FF276C8,0xB4395810, 0x3FED42B0,0x0A85D5DC,
	0x3FF27AE1,0x47AE147B, 0x3FED4600,0x14296CF6,
	0x3FF27EF9,0xDB22D0E5, 0x3FED494E,0x32AC9081,
	0x3FF28312,0x6E978D50, 0x3FED4C9A,0x65D7CCF9,
	0x3FF2872B,0x020C49BA, 0x3FED4FE4,0xAD73CF0A,
	0x3FF28B43,0x95810625, 0x3FED532D,0x09496398,
	0x3FF28F5C,0x28F5C28F, 0x3FED5673,0x792177C3,
	0x3FF29374,0xBC6A7EFA, 0x3FED59B7,0xFCC518E9,
	0x3FF2978D,0x4FDF3B64, 0x3FED5CFA,0x93FD74A7,
	0x3FF29BA5,0xE353F7CF, 0x3FED603B,0x3E93D8E4,
	0x3FF29FBE,0x76C8B439, 0x3FED6379,0xFC51B3CB,
	0x3FF2A3D7,0x0A3D70A4, 0x3FED66B6,0xCD0093D9,
	0x3FF2A7EF,0x9DB22D0E, 0x3FED69F1,0xB06A27D5,
	0x3FF2AC08,0x3126E979, 0x3FED6D2A,0xA6583EDF,
	0x3FF2B020,0xC49BA5E3, 0x3FED7061,0xAE94C86B,
	0x3FF2B439,0x5810624E, 0x3FED7396,0xC8E9D44B,
	0x3FF2B851,0xEB851EB8, 0x3FED76C9,0xF52192AC,
	0x3FF2BC6A,0x7EF9DB23, 0x3FED79FB,0x3306541E,
	0x3FF2C083,0x126E978D, 0x3FED7D2A,0x82628997,
	0x3FF2C49B,0xA5E353F8, 0x3FED8057,0xE300C476,
	0x3FF2C8B4,0x39581062, 0x3FED8383,0x54ABB684,
	0x3FF2CCCC,0xCCCCCCCD, 0x3FED86AC,0xD72E31FF,
	0x3FF2D0E5,0x60418937, 0x3FED89D4,0x6A532992,
	0x3FF2D4FD,0xF3B645A2, 0x3FED8CFA,0x0DE5B064,
	0x3FF2D916,0x872B020C, 0x3FED901D,0xC1B0FA13,
	0x3FF2DD2F,0x1A9FBE77, 0x3FED933F,0x85805ABE,
	0x3FF2E147,0xAE147AE1, 0x3FED965F,0x591F4701,
	0x3FF2E560,0x4189374C, 0x3FED997D,0x3C595401,
	0x3FF2E978,0xD4FDF3B6, 0x3FED9C99,0x2EFA3767,
	0x3FF2ED91,0x6872B021, 0x3FED9FB3,0x30CDC76C,
	0x3FF2F1A9,0xFBE76C8B, 0x3FEDA2CB,0x419FFAD4,
	0x3FF2F5C2,0x8F5C28F6, 0x3FEDA5E1,0x613CE8F8,
	0x3FF2F9DB,0x22D0E560, 0x3FEDA8F5,0x8F70C9C5,
	0x3FF2FDF3,0xB645A1CB, 0x3FEDAC07,0xCC07F5C2,
	0x3FF3020C,0x49BA5E35, 0x3FEDAF18,0x16CEE612,
	0x3FF30624,0xDD2F1AA0, 0x3FEDB226,0x6F92347A,
	0x3FF30A3D,0x70A3D70A, 0x3FEDB532,0xD61E9B5E,
	0x3FF30E56,0x04189375, 0x3FEDB83D,0x4A40F5CF,
	0x3FF3126E,0x978D4FDF, 0x3FEDBB45,0xCBC63F81,
	0x3FF31687,0x2B020C4A, 0x3FEDBE4C,0x5A7B94DA,
	0x3FF31A9F,0xBE76C8B4, 0x3FEDC150,0xF62E32EF,
	0x3FF31EB8,0x51EB851F, 0x3FEDC453,0x9EAB778A,
	0x3FF322D0,0xE5604189, 0x3FEDC754,0x53C0E12B,
	0x3FF326E9,0x78D4FDF4, 0x3FEDCA53,0x153C0F0E,
	0x3FF32B02,0x0C49BA5E, 0x3FEDCD4F,0xE2EAC12B,
	0x3FF32F1A,0x9FBE76C9, 0x3FEDD04A,0xBC9AD83E,
	0x3FF33333,0x33333333, 0x3FEDD343,0xA21A55C4,
	0x3FF3374B,0xC6A7EF9E, 0x3FEDD63A,0x93375C07,
	0x3FF33B64,0x5A1CAC08, 0x3FEDD92F,0x8FC02E15,
	0x3FF33F7C,0xED916873, 0x3FEDDC22,0x97832FD2,
	0x3FF34395,0x810624DD, 0x3FEDDF13,0xAA4EE5EC,
	0x3FF347AE,0x147AE148, 0x3FEDE202,0xC7F1F5ED,
	0x3FF34BC6,0xA7EF9DB2, 0x3FEDE4EF,0xF03B2631,
	0x3FF34FDF,0x3B645A1D, 0x3FEDE7DB,0x22F95DF4,
	0x3FF353F7,0xCED91687, 0x3FEDEAC4,0x5FFBA54C,
	0x3FF35810,0x624DD2F2, 0x3FEDEDAB,0xA7112535,
	0x3FF35C28,0xF5C28F5C, 0x3FEDF090,0xF809278C,
	0x3FF36041,0x89374BC7, 0x3FEDF374,0x52B3171B,
	0x3FF3645A,0x1CAC0831, 0x3FEDF655,0xB6DE7F92,
	0x3FF36872,0xB020C49C, 0x3FEDF935,0x245B0D93,
	0x3FF36C8B,0x43958106, 0x3FEDFC12,0x9AF88EAF,
	0x3FF370A3,0xD70A3D71, 0x3FEDFEEE,0x1A86F16F,
	0x3FF374BC,0x6A7EF9DB, 0x3FEE01C7,0xA2D64551,
	0x3FF378D4,0xFDF3B646, 0x3FEE049F,0x33B6BACF,
	0x3FF37CED,0x916872B0, 0x3FEE0774,0xCCF8A362,
	0x3FF38106,0x24DD2F1B, 0x3FEE0A48,0x6E6C7184,
	0x3FF3851E,0xB851EB85, 0x3FEE0D1A,0x17E2B8B3,
	0x3FF38937,0x4BC6A7F0, 0x3FEE0FE9,0xC92C2D74,
	0x3FF38D4F,0xDF3B645A, 0x3FEE12B7,0x8219A558,
	0x3FF39168,0x72B020C5, 0x3FEE1583,0x427C16FD,
	0x3FF39581,0x0624DD2F, 0x3FEE184D,0x0A249A12,
	0x3FF39999,0x9999999A, 0x3FEE1B14,0xD8E4675B,
	0x3FF39DB2,0x2D0E5604, 0x3FEE1DDA,0xAE8CD8AF,
	0x3FF3A1CA,0xC083126F, 0x3FEE209E,0x8AEF6904,
	0x3FF3A5E3,0x53F7CED9, 0x3FEE2360,0x6DDDB46B,
	0x3FF3A9FB,0xE76C8B44, 0x3FEE2620,0x57297815,
	0x3FF3AE14,0x7AE147AE, 0x3FEE28DE,0x46A49254,
	0x3FF3B22D,0x0E560419, 0x3FEE2B9A,0x3C2102A6,
	0x3FF3B645,0xA1CAC083, 0x3FEE2E54,0x3770E9AB,
	0x3FF3BA5E,0x353F7CEE, 0x3FEE310C,0x38668935,
	0x3FF3BE76,0xC8B43958, 0x3FEE33C2,0x3ED44442,
	0x3FF3C28F,0x5C28F5C3, 0x3FEE3676,0x4A8C9F04,
	0x3FF3C6A7,0xEF9DB22D, 0x3FEE3928,0x5B623EE0,
	0x3FF3CAC0,0x83126E98, 0x3FEE3BD8,0x7127EA75,
	0x3FF3CED9,0x16872B02, 0x3FEE3E86,0x8BB0899D,
	0x3FF3D2F1,0xA9FBE76D, 0x3FEE4132,0xAACF256F,
	0x3FF3D70A,0x3D70A3D7, 0x3FEE43DC,0xCE56E842,
	0x3FF3DB22,0xD0E56042, 0x3FEE4684,0xF61B1DB6,
	0x3FF3DF3B,0x645A1CAC, 0x3FEE492B,0x21EF32AA,
	0x3FF3E353,0xF7CED917, 0x3FEE4BCF,0x51A6B54F,
	0x3FF3E76C,0x8B439581, 0x3FEE4E71,0x8515551D,
	0x3FF3EB85,0x1EB851EC, 0x3FEE5111,0xBC0EE2DD,
	0x3FF3EF9D,0xB22D0E56, 0x3FEE53AF,0xF66750AB,
	0x3FF3F3B6,0x45A1CAC1, 0x3FEE564C,0x33F2B1FA,
	0x3FF3F7CE,0xD916872B, 0x3FEE58E6,0x74853B91,
	0x3FF3FBE7,0x6C8B4396, 0x3FEE5B7E,0xB7F34397,
	0x3FF40000,0x00000000, 0x3FEE5E14,0xFE11418C,
	0x3FF40418,0x9374BC6A, 0x3FEE60A9,0x46B3CE56,
	0x3FF40831,0x26E978D5, 0x3FEE633B,0x91AFA43B,
	0x3FF40C49,0xBA5E353F, 0x3FEE65CB,0xDED99EE9,
	0x3FF41062,0x4DD2F1AA, 0x3FEE685A,0x2E06BB78,
	0x3FF4147A,0xE147AE14, 0x3FEE6AE6,0x7F0C186A,
	0x3FF41893,0x74BC6A7F, 0x3FEE6D70,0xD1BEF5B2,
	0x3FF41CAC,0x083126E9, 0x3FEE6FF9,0x25F4B4B2,
	0x3FF420C4,0x9BA5E354, 0x3FEE727F,0x7B82D846,
	0x3FF424DD,0x2F1A9FBE, 0x3FEE7503,0xD23F04BC,
	0x3FF428F5,0xC28F5C29, 0x3FEE7786,0x29FEFFDE,
	0x3FF42D0E,0x56041893, 0x3FEE7A06,0x8298B0F3,
	0x3FF43126,0xE978D4FE, 0x3FEE7C84,0xDBE220C3,
	0x3FF4353F,0x7CED9168, 0x3FEE7F01,0x35B17996,
	0x3FF43958,0x10624DD3, 0x3FEE817B,0x8FDD073B,
	0x3FF43D70,0xA3D70A3D, 0x3FEE83F3,0xEA3B3706,
	0x3FF44189,0x374BC6A8, 0x3FEE866A,0x44A297DB,
	0x3FF445A1,0xCAC08312, 0x3FEE88DE,0x9EE9DA26,
	0x3FF449BA,0x5E353F7D, 0x3FEE8B50,0xF8E7CFE6,
	0x3FF44DD2,0xF1A9FBE7, 0x3FEE8DC1,0x52736CAA,
	0x3FF451EB,0x851EB852, 0x3FEE902F,0xAB63C59C,
	0x3FF45604,0x189374BC, 0x3FEE929C,0x03901177,
	0x3FF45A1C,0xAC083127, 0x3FEE9506,0x5ACFA896,
	0x3FF45E35,0x3F7CED91, 0x3FEE976E,0xB0FA04EE,
	0x3FF4624D,0xD2F1A9FC, 0x3FEE99D5,0x05E6C218,
	0x3FF46666,0x66666666, 0x3FEE9C39,0x596D9D4C,
	0x3FF46A7E,0xF9DB22D1, 0x3FEE9E9B,0xAB66756A,
	0x3FF46E97,0x8D4FDF3B, 0x3FEEA0FB,0xFBA94AF7,
	0x3FF472B0,0x20C49BA6, 0x3FEEA35A,0x4A0E4027,
	0x3FF476C8,0xB4395810, 0x3FEEA5B6,0x966D98D6,
	0x3FF47AE1,0x47AE147B, 0x3FEEA810,0xE09FBA95,
	0x3FF47EF9,0xDB22D0E5, 0x3FEEAA69,0x287D2CA4,
	0x3FF48312,0x6E978D50, 0x3FEEACBF,0x6DDE97FA,
	0x3FF4872B,0x020C49BA, 0x3FEEAF13,0xB09CC744,
	0x3FF48B43,0x95810625, 0x3FEEB165,0xF090A6EA,
	0x3FF48F5C,0x28F5C28F, 0x3FEEB3B6,0x2D934510,
	0x3FF49374,0xBC6A7EFA, 0x3FEEB604,0x677DD19C,
	0x3FF4978D,0x4FDF3B64, 0x3FEEB850,0x9E299E32,
	0x3FF49BA5,0xE353F7CF, 0x3FEEBA9A,0xD1701E3D,
	0x3FF49FBE,0x76C8B439, 0x3FEEBCE3,0x012AE6ED,
	0x3FF4A3D7,0x0A3D70A4, 0x3FEEBF29,0x2D33AF3F,
	0x3FF4A7EF,0x9DB22D0E, 0x3FEEC16D,0x55644FF7,
	0x3FF4AC08,0x3126E979, 0x3FEEC3AF,0x7996C3AB,
	0x3FF4B020,0xC49BA5E3, 0x3FEEC5EF,0x99A526C1,
	0x3FF4B439,0x5810624E, 0x3FEEC82D,0xB569B772,
	0x3FF4B851,0xEB851EB8, 0x3FEECA69,0xCCBED5CC,
	0x3FF4BC6A,0x7EF9DB23, 0x3FEECCA3,0xDF7F03B9,
	0x3FF4C083,0x126E978D, 0x3FEECEDB,0xED84E4F9,
	0x3FF4C49B,0xA5E353F8, 0x3FEED111,0xF6AB3F2C,
	0x3FF4C8B4,0x39581062, 0x3FEED345,0xFACCF9D1,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FEED577,0xF9C51E4B,
	0x3FF4D0E5,0x60418937, 0x3FEED7A7,0xF36ED7DE,
	0x3FF4D4FD,0xF3B645A2, 0x3FEED9D5,0xE7A573B8,
	0x3FF4D916,0x872B020C, 0x3FEEDC01,0xD64460EE,
	0x3FF4DD2F,0x1A9FBE77, 0x3FEEDE2B,0xBF273083,
	0x3FF4E147,0xAE147AE1, 0x3FEEE053,0xA2299567,
	0x3FF4E560,0x4189374C, 0x3FEEE279,0x7F27647A,
	0x3FF4E978,0xD4FDF3B6, 0x3FEEE49D,0x55FC9490,
	0x3FF4ED91,0x6872B021, 0x3FEEE6BF,0x26853E71,
	0x3FF4F1A9,0xFBE76C8B, 0x3FEEE8DE,0xF09D9CDF,
	0x3FF4F5C2,0x8F5C28F6, 0x3FEEEAFC,0xB4220C93,
	0x3FF4F9DB,0x22D0E560, 0x3FEEED18,0x70EF0C45,
	0x3FF4FDF3,0xB645A1CB, 0x3FEEEF32,0x26E13CA9,
	0x3FF5020C,0x49BA5E35, 0x3FEEF149,0xD5D56075,
	0x3FF50624,0xDD2F1AA0, 0x3FEEF35F,0x7DA85C63,
	0x3FF50A3D,0x70A3D70A, 0x3FEEF573,0x1E373732,
	0x3FF50E56,0x04189375, 0x3FEEF784,0xB75F19AA,
	0x3FF5126E,0x978D4FDF, 0x3FEEF994,0x48FD4E9A,
	0x3FF51687,0x2B020C4A, 0x3FEEFBA1,0xD2EF42E0,
	0x3FF51A9F,0xBE76C8B4, 0x3FEEFDAD,0x55128569,
	0x3FF51EB8,0x51EB851F, 0x3FEEFFB6,0xCF44C730,
	0x3FF522D0,0xE5604189, 0x3FEF01BE,0x4163DB47,
	0x3FF526E9,0x78D4FDF4, 0x3FEF03C3,0xAB4DB6D3,
	0x3FF52B02,0x0C49BA5E, 0x3FEF05C7,0x0CE07111,
	0x3FF52F1A,0x9FBE76C9, 0x3FEF07C8,0x65FA4358,
	0x3FF53333,0x33333333, 0x3FEF09C7,0xB679891A,
	0x3FF5374B,0xC6A7EF9E, 0x3FEF0BC4,0xFE3CBFEB,
	0x3FF53B64,0x5A1CAC08, 0x3FEF0DC0,0x3D22877A,
	0x3FF53F7C,0xED916873, 0x3FEF0FB9,0x7309A19D,
	0x3FF54395,0x810624DD, 0x3FEF11B0,0x9FD0F24E,
	0x3FF547AE,0x147AE148, 0x3FEF13A5,0xC3577FAC,
	0x3FF54BC6,0xA7EF9DB2, 0x3FEF1598,0xDD7C7201,
	0x3FF54FDF,0x3B645A1D, 0x3FEF1789,0xEE1F13C2,
	0x3FF553F7,0xCED91687, 0x3FEF1978,0xF51ED191,
	0x3FF55810,0x624DD2F2, 0x3FEF1B65,0xF25B3A41,
	0x3FF55C28,0xF5C28F5C, 0x3FEF1D50,0xE5B3FED5,
	0x3FF56041,0x89374BC7, 0x3FEF1F39,0xCF08F284,
	0x3FF5645A,0x1CAC0831, 0x3FEF2120,0xAE3A0ABB,
	0x3FF56872,0xB020C49C, 0x3FEF2305,0x83275F22,
	0x3FF56C8B,0x43958106, 0x3FEF24E8,0x4DB12996,
	0x3FF570A3,0xD70A3D71, 0x3FEF26C9,0x0DB7C635,
	0x3FF574BC,0x6A7EF9DB, 0x3FEF28A7,0xC31BB357,
	0x3FF578D4,0xFDF3B646, 0x3FEF2A84,0x6DBD9199,
	0x3FF57CED,0x916872B0, 0x3FEF2C5F,0x0D7E23D6,
	0x3FF58106,0x24DD2F1B, 0x3FEF2E37,0xA23E4F31,
	0x3FF5851E,0xB851EB85, 0x3FEF300E,0x2BDF1B11,
	0x3FF58937,0x4BC6A7F0, 0x3FEF31E2,0xAA41B127,
	0x3FF58D4F,0xDF3B645A, 0x3FEF33B5,0x1D475D6D,
	0x3FF59168,0x72B020C5, 0x3FEF3585,0x84D18E2D,
	0x3FF59581,0x0624DD2F, 0x3FEF3753,0xE0C1D3FA,
	0x3FF59999,0x9999999A, 0x3FEF3920,0x30F9E1BE,
	0x3FF59DB2,0x2D0E5604, 0x3FEF3AEA,0x755B8CB0,
	0x3FF5A1CA,0xC083126F, 0x3FEF3CB2,0xADC8CC60,
	0x3FF5A5E3,0x53F7CED9, 0x3FEF3E78,0xDA23BAB0,
	0x3FF5A9FB,0xE76C8B44, 0x3FEF403C,0xFA4E93DF,
	0x3FF5AE14,0x7AE147AE, 0x3FEF41FF,0x0E2BB682,
	0x3FF5B22D,0x0E560419, 0x3FEF43BF,0x159DA38F,
	0x3FF5B645,0xA1CAC083, 0x3FEF457D,0x1086FE57,
	0x3FF5BA5E,0x353F7CEE, 0x3FEF4738,0xFECA8C8B,
	0x3FF5BE76,0xC8B43958, 0x3FEF48F2,0xE04B3641,
	0x3FF5C28F,0x5C28F5C3, 0x3FEF4AAA,0xB4EC05F1,
	0x3FF5C6A7,0xEF9DB22D, 0x3FEF4C60,0x7C902877,
	0x3FF5CAC0,0x83126E98, 0x3FEF4E14,0x371AED1C,
	0x3FF5CED9,0x16872B02, 0x3FEF4FC5,0xE46FC58E,
	0x3FF5D2F1,0xA9FBE76D, 0x3FEF5175,0x847245E9,
	0x3FF5D70A,0x3D70A3D7, 0x3FEF5323,0x170624B5,
	0x3FF5DB22,0xD0E56042, 0x3FEF54CE,0x9C0F3AEC,
	0x3FF5DF3B,0x645A1CAC, 0x3FEF5678,0x137183F4,
	0x3FF5E353,0xF7CED917, 0x3FEF581F,0x7D111DAB,
	0x3FF5E76C,0x8B439581, 0x3FEF59C4,0xD8D24862,
	0x3FF5EB85,0x1EB851EC, 0x3FEF5B68,0x269966E0,
	0x3FF5EF9D,0xB22D0E56, 0x3FEF5D09,0x664AFE66,
	0x3FF5F3B6,0x45A1CAC1, 0x3FEF5EA8,0x97CBB6AC,
	0x3FF5F7CE,0xD916872B, 0x3FEF6045,0xBB0059EB,
	0x3FF5FBE7,0x6C8B4396, 0x3FEF61E0,0xCFCDD4D5,
	0x3FF60000,0x00000000, 0x3FEF6379,0xD619369D,
	0x3FF60418,0x9374BC6A, 0x3FEF6510,0xCDC7B0FA,
	0x3FF60831,0x26E978D5, 0x3FEF66A5,0xB6BE9823,
	0x3FF60C49,0xBA5E353F, 0x3FEF6838,0x90E362D5,
	0x3FF61062,0x4DD2F1AA, 0x3FEF69C9,0x5C1BAA54,
	0x3FF6147A,0xE147AE14, 0x3FEF6B58,0x184D2A6A,
	0x3FF61893,0x74BC6A7F, 0x3FEF6CE4,0xC55DC16F,
	0x3FF61CAC,0x083126E9, 0x3FEF6E6F,0x63337043,
	0x3FF620C4,0x9BA5E354, 0x3FEF6FF7,0xF1B45A56,
	0x3FF624DD,0x2F1A9FBE, 0x3FEF717E,0x70C6C5A4,
	0x3FF628F5,0xC28F5C29, 0x3FEF7302,0xE0511ABF,
	0x3FF62D0E,0x56041893, 0x3FEF7485,0x4039E4C7,
	0x3FF63126,0xE978D4FE, 0x3FEF7605,0x9067D172,
	0x3FF6353F,0x7CED9168, 0x3FEF7783,0xD0C1B10B,
	0x3FF63958,0x10624DD3, 0x3FEF7900,0x012E7675,
	0x3FF63D70,0xA3D70A3D, 0x3FEF7A7A,0x2195372D,
	0x3FF64189,0x374BC6A8, 0x3FEF7BF2,0x31DD2B49,
	0x3FF645A1,0xCAC08312, 0x3FEF7D68,0x31EDAD7C,
	0x3FF649BA,0x5E353F7D, 0x3FEF7EDC,0x21AE3B19,
	0x3FF64DD2,0xF1A9FBE7, 0x3FEF804E,0x0106740F,
	0x3FF651EB,0x851EB852, 0x3FEF81BD,0xCFDE1AF1,
	0x3FF65604,0x189374BC, 0x3FEF832B,0x8E1D14F3,
	0x3FF65A1C,0xAC083127, 0x3FEF8497,0x3BAB69F0,
	0x3FF65E35,0x3F7CED91, 0x3FEF8600,0xD8714466,
	0x3FF6624D,0xD2F1A9FC, 0x3FEF8768,0x6456F17D,
	0x3FF66666,0x66666666, 0x3FEF88CD,0xDF44E102,
	0x3FF66A7E,0xF9DB22D1, 0x3FEF8A31,0x4923A572,
	0x3FF66E97,0x8D4FDF3B, 0x3FEF8B92,0xA1DBF3F3,
	0x3FF672B0,0x20C49BA6, 0x3FEF8CF1,0xE956A458,
	0x3FF676C8,0xB4395810, 0x3FEF8E4F,0x1F7CB126,
	0x3FF67AE1,0x47AE147B, 0x3FEF8FAA,0x44373790,
	0x3FF67EF9,0xDB22D0E5, 0x3FEF9103,0x576F777D,
	0x3FF68312,0x6E978D50, 0x3FEF925A,0x590ED386,
	0x3FF6872B,0x020C49BA, 0x3FEF93AF,0x48FED0FB,
	0x3FF68B43,0x95810625, 0x3FEF9502,0x272917E1,
	0x3FF68F5C,0x28F5C28F, 0x3FEF9652,0xF37772F7,
	0x3FF69374,0xBC6A7EFA, 0x3FEF97A1,0xADD3CFB3,
	0x3FF6978D,0x4FDF3B64, 0x3FEF98EE,0x56283E48,
	0x3FF69BA5,0xE353F7CF, 0x3FEF9A38,0xEC5EF1A6,
	0x3FF69FBE,0x76C8B439, 0x3FEF9B81,0x70623F78,
	0x3FF6A3D7,0x0A3D70A4, 0x3FEF9CC7,0xE21CA02B,
	0x3FF6A7EF,0x9DB22D0E, 0x3FEF9E0C,0x4178AEEB,
	0x3FF6AC08,0x3126E979, 0x3FEF9F4E,0x8E6129A8,
	0x3FF6B020,0xC49BA5E3, 0x3FEFA08E,0xC8C0F114,
	0x3FF6B439,0x5810624E, 0x3FEFA1CC,0xF08308A6,
	0x3FF6B851,0xEB851EB8, 0x3FEFA309,0x0592969A,
	0x3FF6BC6A,0x7EF9DB23, 0x3FEFA443,0x07DAE3F8,
	0x3FF6C083,0x126E978D, 0x3FEFA57A,0xF7475C8C,
	0x3FF6C49B,0xA5E353F8, 0x3FEFA6B0,0xD3C38EEF,
	0x3FF6C8B4,0x39581062, 0x3FEFA7E4,0x9D3B2C85,
	0x3FF6CCCC,0xCCCCCCCD, 0x3FEFA916,0x539A0980,
	0x3FF6D0E5,0x60418937, 0x3FEFAA45,0xF6CC1CDE,
	0x3FF6D4FD,0xF3B645A2, 0x3FEFAB73,0x86BD806F,
	0x3FF6D916,0x872B020C, 0x3FEFAC9F,0x035A70D2,
	0x3FF6DD2F,0x1A9FBE77, 0x3FEFADC8,0x6C8F4D7A,
	0x3FF6E147,0xAE147AE1, 0x3FEFAEEF,0xC24898AD,
	0x3FF6E560,0x4189374C, 0x3FEFB015,0x0472F786,
	0x3FF6E978,0xD4FDF3B6, 0x3FEFB138,0x32FB31F3,
	0x3FF6ED91,0x6872B021, 0x3FEFB259,0x4DCE32BF,
	0x3FF6F1A9,0xFBE76C8B, 0x3FEFB378,0x54D90789,
	0x3FF6F5C2,0x8F5C28F6, 0x3FEFB495,0x4808E0CC,
	0x3FF6F9DB,0x22D0E560, 0x3FEFB5B0,0x274B11DC,
	0x3FF6FDF3,0xB645A1CB, 0x3FEFB6C8,0xF28D10ED,
	0x3FF7020C,0x49BA5E35, 0x3FEFB7DF,0xA9BC770B,
	0x3FF70624,0xDD2F1AA0, 0x3FEFB8F4,0x4CC70027,
	0x3FF70A3D,0x70A3D70A, 0x3FEFBA06,0xDB9A8B0D,
	0x3FF70E56,0x04189375, 0x3FEFBB17,0x5625196D,
	0x3FF7126E,0x978D4FDF, 0x3FEFBC25,0xBC54CFD6,
	0x3FF71687,0x2B020C4A, 0x3FEFBD32,0x0E17F5BF,
	0x3FF71A9F,0xBE76C8B4, 0x3FEFBE3C,0x4B5CF57F,
	0x3FF71EB8,0x51EB851F, 0x3FEFBF44,0x74125C57,
	0x3FF722D0,0xE5604189, 0x3FEFC04A,0x8826DA6B,
	0x3FF726E9,0x78D4FDF4, 0x3FEFC14E,0x878942C9,
	0x3FF72B02,0x0C49BA5E, 0x3FEFC250,0x72288B69,
	0x3FF72F1A,0x9FBE76C9, 0x3FEFC350,0x47F3CD2B,
	0x3FF73333,0x33333333, 0x3FEFC44E,0x08DA43DC,
	0x3FF7374B,0xC6A7EF9E, 0x3FEFC549,0xB4CB4E36,
	0x3FF73B64,0x5A1CAC08, 0x3FEFC643,0x4BB66DDD,
	0x3FF73F7C,0xED916873, 0x3FEFC73A,0xCD8B4769,
	0x3FF74395,0x810624DD, 0x3FEFC830,0x3A39A25E,
	0x3FF747AE,0x147AE148, 0x3FEFC923,0x91B16932,
	0x3FF74BC6,0xA7EF9DB2, 0x3FEFCA14,0xD3E2A94B,
	0x3FF74FDF,0x3B645A1D, 0x3FEFCB04,0x00BD9305,
	0x3FF753F7,0xCED91687, 0x3FEFCBF1,0x183279AE,
	0x3FF75810,0x624DD2F2, 0x3FEFCCDC,0x1A31D38A,
	0x3FF75C28,0xF5C28F5C, 0x3FEFCDC5,0x06AC39D1,
	0x3FF76041,0x89374BC7, 0x3FEFCEAB,0xDD9268B4,
	0x3FF7645A,0x1CAC0831, 0x3FEFCF90,0x9ED53F5A,
	0x3FF76872,0xB020C49C, 0x3FEFD073,0x4A65BFE6,
	0x3FF76C8B,0x43958106, 0x3FEFD153,0xE0350F72,
	0x3FF770A3,0xD70A3D71, 0x3FEFD232,0x60347615,
	0x3FF774BC,0x6A7EF9DB, 0x3FEFD30E,0xCA555EDF,
	0x3FF778D4,0xFDF3B646, 0x3FEFD3E9,0x1E8957E0,
	0x3FF77CED,0x916872B0, 0x3FEFD4C1,0x5CC21225,
	0x3FF78106,0x24DD2F1B, 0x3FEFD597,0x84F161B8,
	0x3FF7851E,0xB851EB85, 0x3FEFD66B,0x97093DA5,
	0x3FF78937,0x4BC6A7F0, 0x3FEFD73D,0x92FBBFF6,
	0x3FF78D4F,0xDF3B645A, 0x3FEFD80D,0x78BB25BA,
	0x3FF79168,0x72B020C5, 0x3FEFD8DB,0x4839CEFF,
	0x3FF79581,0x0624DD2F, 0x3FEFD9A7,0x016A3ED7,
	0x3FF79999,0x9999999A, 0x3FEFDA70,0xA43F1B5A,
	0x3FF79DB2,0x2D0E5604, 0x3FEFDB38,0x30AB2DA4,
	0x3FF7A1CA,0xC083126F, 0x3FEFDBFD,0xA6A161D5,
	0x3FF7A5E3,0x53F7CED9, 0x3FEFDCC1,0x0614C717,
	0x3FF7A9FB,0xE76C8B44, 0x3FEFDD82,0x4EF88F9A,
	0x3FF7AE14,0x7AE147AE, 0x3FEFDE41,0x81401095,
	0x3FF7B22D,0x0E560419, 0x3FEFDEFE,0x9CDEC24C,
	0x3FF7B645,0xA1CAC083, 0x3FEFDFB9,0xA1C84008,
	0x3FF7BA5E,0x353F7CEE, 0x3FEFE072,0x8FF04823,
	0x3FF7BE76,0xC8B43958, 0x3FEFE129,0x674ABBFD,
	0x3FF7C28F,0x5C28F5C3, 0x3FEFE1DE,0x27CBA006,
	0x3FF7C6A7,0xEF9DB22D, 0x3FEFE290,0xD1671BBA,
	0x3FF7CAC0,0x83126E98, 0x3FEFE341,0x641179A4,
	0x3FF7CED9,0x16872B02, 0x3FEFE3EF,0xDFBF275C,
	0x3FF7D2F1,0xA9FBE76D, 0x3FEFE49C,0x4464B58C,
	0x3FF7D70A,0x3D70A3D7, 0x3FEFE546,0x91F6D7ED,
	0x3FF7DB22,0xD0E56042, 0x3FEFE5EE,0xC86A6548,
	0x3FF7DF3B,0x645A1CAC, 0x3FEFE694,0xE7B4577A,
	0x3FF7E353,0xF7CED917, 0x3FEFE738,0xEFC9CB72,
	0x3FF7E76C,0x8B439581, 0x3FEFE7DA,0xE0A00130,
	0x3FF7EB85,0x1EB851EC, 0x3FEFE87A,0xBA2C5BCC,
	0x3FF7EF9D,0xB22D0E56, 0x3FEFE918,0x7C64616E,
	0x3FF7F3B6,0x45A1CAC1, 0x3FEFE9B4,0x273DBB58,
	0x3FF7F7CE,0xD916872B, 0x3FEFEA4D,0xBAAE35DE,
	0x3FF7FBE7,0x6C8B4396, 0x3FEFEAE5,0x36ABC06E,
	0x3FF80000,0x00000000, 0x3FEFEB7A,0x9B2C6D8B,
	0x3FF80418,0x9374BC6A, 0x3FEFEC0D,0xE82672D0,
	0x3FF80831,0x26E978D5, 0x3FEFEC9F,0x1D9028F3,
	0x3FF80C49,0xBA5E353F, 0x3FEFED2E,0x3B600BC1,
	0x3FF81062,0x4DD2F1AA, 0x3FEFEDBB,0x418CBA21,
	0x3FF8147A,0xE147AE14, 0x3FEFEE46,0x300CF615,
	0x3FF81893,0x74BC6A7F, 0x3FEFEECF,0x06D7A4BB,
	0x3FF81CAC,0x083126E9, 0x3FEFEF55,0xC5E3CE4C,
	0x3FF820C4,0x9BA5E354, 0x3FEFEFDA,0x6D289E1C,
	0x3FF824DD,0x2F1A9FBE, 0x3FEFF05C,0xFC9D629E,
	0x3FF828F5,0xC28F5C29, 0x3FEFF0DD,0x74398D62,
	0x3FF82D0E,0x56041893, 0x3FEFF15B,0xD3F4B314,
	0x3FF83126,0xE978D4FE, 0x3FEFF1D8,0x1BC68B81,
	0x3FF8353F,0x7CED9168, 0x3FEFF252,0x4BA6F195,
	0x3FF83958,0x10624DD3, 0x3FEFF2CA,0x638DE359,
	0x3FF83D70,0xA3D70A3D, 0x3FEFF340,0x637381F9,
	0x3FF84189,0x374BC6A8, 0x3FEFF3B4,0x4B5011C0,
	0x3FF845A1,0xCAC08312, 0x3FEFF426,0x1B1BFA1C,
	0x3FF849BA,0x5E353F7D, 0x3FEFF495,0xD2CFC59A,
	0x3FF84DD2,0xF1A9FBE7, 0x3FEFF503,0x726421EC,
	0x3FF851EB,0x851EB852, 0x3FEFF56E,0xF9D1DFE4,
	0x3FF85604,0x189374BC, 0x3FEFF5D8,0x6911F37A,
	0x3FF85A1C,0xAC083127, 0x3FEFF63F,0xC01D73C6,
	0x3FF85E35,0x3F7CED91, 0x3FEFF6A4,0xFEED9B08,
	0x3FF8624D,0xD2F1A9FC, 0x3FEFF708,0x257BC6A1,
	0x3FF86666,0x66666666, 0x3FEFF769,0x33C1771A,
	0x3FF86A7E,0xF9DB22D1, 0x3FEFF7C8,0x29B8501E,
	0x3FF86E97,0x8D4FDF3B, 0x3FEFF825,0x075A1881,
	0x3FF872B0,0x20C49BA6, 0x3FEFF87F,0xCCA0BA3B,
	0x3FF876C8,0xB4395810, 0x3FEFF8D8,0x7986426B,
	0x3FF87AE1,0x47AE147B, 0x3FEFF92F,0x0E04E157,
	0x3FF87EF9,0xDB22D0E5, 0x3FEFF983,0x8A16EA6D,
	0x3FF88312,0x6E978D50, 0x3FEFF9D5,0xEDB6D443,
	0x3FF8872B,0x020C49BA, 0x3FEFFA26,0x38DF3895,
	0x3FF88B43,0x95810625, 0x3FEFFA74,0x6B8AD449,
	0x3FF88F5C,0x28F5C28F, 0x3FEFFAC0,0x85B4876E,
	0x3FF89374,0xBC6A7EFA, 0x3FEFFB0A,0x8757553B,
	0x3FF8978D,0x4FDF3B64, 0x3FEFFB52,0x706E6412,
	0x3FF89BA5,0xE353F7CF, 0x3FEFFB98,0x40F4FD7C,
	0x3FF89FBE,0x76C8B439, 0x3FEFFBDB,0xF8E68E2F,
	0x3FF8A3D7,0x0A3D70A4, 0x3FEFFC1D,0x983EA60A,
	0x3FF8A7EF,0x9DB22D0E, 0x3FEFFC5D,0x1EF8F817,
	0x3FF8AC08,0x3126E979, 0x3FEFFC9A,0x8D115A8A,
	0x3FF8B020,0xC49BA5E3, 0x3FEFFCD5,0xE283C6C3,
	0x3FF8B439,0x5810624E, 0x3FEFFD0F,0x1F4C594F,
	0x3FF8B851,0xEB851EB8, 0x3FEFFD46,0x436751E3,
	0x3FF8BC6A,0x7EF9DB23, 0x3FEFFD7B,0x4ED11363,
	0x3FF8C083,0x126E978D, 0x3FEFFDAE,0x418623DE,
	0x3FF8C49B,0xA5E353F8, 0x3FEFFDDF,0x1B832C90,
	0x3FF8C8B4,0x39581062, 0x3FEFFE0D,0xDCC4F9E2,
	0x3FF8CCCC,0xCCCCCCCD, 0x3FEFFE3A,0x85487B68,
	0x3FF8D0E5,0x60418937, 0x3FEFFE65,0x150AC3E4,
	0x3FF8D4FD,0xF3B645A2, 0x3FEFFE8D,0x8C090947,
	0x3FF8D916,0x872B020C, 0x3FEFFEB3,0xEA40A4AD,
	0x3FF8DD2F,0x1A9FBE77, 0x3FEFFED8,0x2FAF1261,
	0x3FF8E147,0xAE147AE1, 0x3FEFFEFA,0x5C51F1DB,
	0x3FF8E560,0x4189374C, 0x3FEFFF1A,0x702705C1,
	0x3FF8E978,0xD4FDF3B6, 0x3FEFFF38,0x6B2C33E8,
	0x3FF8ED91,0x6872B021, 0x3FEFFF54,0x4D5F8552,
	0x3FF8F1A9,0xFBE76C8B, 0x3FEFFF6E,0x16BF2630,
	0x3FF8F5C2,0x8F5C28F6, 0x3FEFFF85,0xC74965E2,
	0x3FF8F9DB,0x22D0E560, 0x3FEFFF9B,0x5EFCB6F5,
	0x3FF8FDF3,0xB645A1CB, 0x3FEFFFAE,0xDDD7AF26,
	0x3FF9020C,0x49BA5E35, 0x3FEFFFC0,0x43D90760,
	0x3FF90624,0xDD2F1AA0, 0x3FEFFFCF,0x90FF9BBD,
	0x3FF90A3D,0x70A3D70A, 0x3FEFFFDC,0xC54A6B87,
	0x3FF90E56,0x04189375, 0x3FEFFFE7,0xE0B89936,
	0x3FF9126E,0x978D4FDF, 0x3FEFFFF0,0xE3496A70,
	0x3FF91687,0x2B020C4A, 0x3FEFFFF7,0xCCFC480D,
	0x3FF91A9F,0xBE76C8B4, 0x3FEFFFFC,0x9DD0BE11,
	0x3FF91EB8,0x51EB851F, 0x3FEFFFFF,0x55C67BB1,
	0x3FF922D0,0xE5604189, 0x3FEFFFFF,0xF4DD5351,
	0x3FF926E9,0x78D4FDF4, 0x3FEFFFFE,0x7B153A84,
	0x3FF92B02,0x0C49BA5E, 0x3FEFFFFA,0xE86E4A0B,
	0x3FF92F1A,0x9FBE76C9, 0x3FEFFFF5,0x3CE8BDD8,
	0x3FF93333,0x33333333, 0x3FEFFFED,0x7884F50C,
	0x3FF9374B,0xC6A7EF9E, 0x3FEFFFE3,0x9B4371F7,
	0x3FF93B64,0x5A1CAC08, 0x3FEFFFD7,0xA524DA16,
	0x3FF93F7C,0xED916873, 0x3FEFFFC9,0x9629F618,
	0x3FF94395,0x810624DD, 0x3FEFFFB9,0x6E53B1DA,
	0x3FF947AE,0x147AE148, 0x3FEFFFA7,0x2DA31C68,
	0x3FF94BC6,0xA7EF9DB2, 0x3FEFFF92,0xD41967FB,
	0x3FF94FDF,0x3B645A1D, 0x3FEFFF7C,0x61B7E9FF,
	0x3FF953F7,0xCED91687, 0x3FEFFF63,0xD6801B0A,
	0x3FF95810,0x624DD2F2, 0x3FEFFF49,0x327396E5,
	0x3FF95C28,0xF5C28F5C, 0x3FEFFF2C,0x75941C84,
	0x3FF96041,0x89374BC7, 0x3FEFFF0D,0x9FE38E0B,
	0x3FF9645A,0x1CAC0831, 0x3FEFFEEC,0xB163F0CC,
	0x3FF96872,0xB020C49C, 0x3FEFFEC9,0xAA176D48,
	0x3FF96C8B,0x43958106, 0x3FEFFEA4,0x8A004F2D,
	0x3FF970A3,0xD70A3D71, 0x3FEFFE7D,0x51210557,
	0x3FF974BC,0x6A7EF9DB, 0x3FEFFE53,0xFF7C21D0,
	0x3FF978D4,0xFDF3B646, 0x3FEFFE28,0x951459CF,
	0x3FF97CED,0x916872B0, 0x3FEFFDFB,0x11EC85BA,
	0x3FF98106,0x24DD2F1B, 0x3FEFFDCB,0x7607A121,
	0x3FF9851E,0xB851EB85, 0x3FEFFD99,0xC168CAC5,
	0x3FF98937,0x4BC6A7F0, 0x3FEFFD65,0xF4134490,
	0x3FF98D4F,0xDF3B645A, 0x3FEFFD30,0x0E0A739B,
	0x3FF99168,0x72B020C5, 0x3FEFFCF8,0x0F51E02A,
	0x3FF99581,0x0624DD2F, 0x3FEFFCBD,0xF7ED35AF,
	0x3FF99999,0x9999999A, 0x3FEFFC81,0xC7E042C5,
	0x3FF9C28F,0x5C28F5C3, 0x3FEFF9B4,0x9EDEFDF4,
	0x3FF9EB85,0x1EB851EC, 0x3FEFF615,0xE87927FA,
	0x3FFA147A,0xE147AE14, 0x3FEFF1A5,0xBC680174,
	0x3FFA3D70,0xA3D70A3D, 0x3FEFEC64,0x37C17F07,
	0x3FFA6666,0x66666666, 0x3FEFE651,0x7CF78AC8,
	0x3FFA8F5C,0x28F5C28F, 0x3FEFDF6D,0xB3D7227B,
	0x3FFAB851,0xEB851EB8, 0x3FEFD7B9,0x098752C1,
	0x3FFAE147,0xAE147AE1, 0x3FEFCF33,0xB0880F2B,
	0x3FFB0A3D,0x70A3D70A, 0x3FEFC5DD,0xE0B0E74A,
	0x3FFB3333,0x33333333, 0x3FEFBBB7,0xD72F98B6,
	0x3FFB5C28,0xF5C28F5C, 0x3FEFB0C1,0xD6867E1F,
	0x3FFB851E,0xB851EB85, 0x3FEFA4FC,0x268ADB6D,
	0x3FFBAE14,0x7AE147AE, 0x3FEF9867,0x146306FE,
	0x3FFBD70A,0x3D70A3D7, 0x3FEF8B02,0xF284700C,
	0x3FFC0000,0x00000000, 0x3FEF7CD0,0x18B18246,
	0x3FFC28F5,0xC28F5C29, 0x3FEF6DCE,0xE3F766AD,
	0x3FFC51EB,0x851EB852, 0x3FEF5DFF,0xB6ABA1C5,
	0x3FFC7AE1,0x47AE147B, 0x3FEF4D62,0xF8698F23,
	0x3FFCA3D7,0x0A3D70A4, 0x3FEF3BF9,0x160FBA71,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FEF29C2,0x81BD15F0,
	0x3FFCF5C2,0x8F5C28F6, 0x3FEF16BF,0xB2CE0E97,
	0x3FFD1EB8,0x51EB851F, 0x3FEF02F1,0x25D97DD2,
	0x3FFD47AE,0x147AE148, 0x3FEEEE57,0x5CAD7904,
	0x3FFD70A3,0xD70A3D71, 0x3FEED8F2,0xDE4BFED7,
	0x3FFD9999,0x9999999A, 0x3FEEC2C4,0x36E78275,
	0x3FFDC28F,0x5C28F5C3, 0x3FEEABCB,0xF7DF54BE,
	0x3FFDEB85,0x1EB851EC, 0x3FEE940A,0xB7BBEB94,
	0x3FFE147A,0xE147AE14, 0x3FEE7B81,0x122B0754,
	0x3FFE3D70,0xA3D70A3D, 0x3FEE622F,0xA7FBB698,
	0x3FFE6666,0x66666666, 0x3FEE4817,0x1F1A3857,
	0x3FFE8F5C,0x28F5C28F, 0x3FEE2D38,0x228BBC85,
	0x3FFEB851,0xEB851EB8, 0x3FEE1193,0x626A0345,
	0x3FFEE147,0xAE147AE1, 0x3FEDF529,0x93DEDADB,
	0x3FFF0A3D,0x70A3D70A, 0x3FEDD7FB,0x711F7C60,
	0x3FFF3333,0x33333333, 0x3FEDBA09,0xB967C778,
	0x3FFF5C28,0xF5C28F5C, 0x3FED9B55,0x30F55D09,
	0x3FFF851E,0xB851EB85, 0x3FED7BDE,0xA102992C,
	0x3FFFAE14,0x7AE147AE, 0x3FED5BA6,0xD7C16C69,
	0x3FFFD70A,0x3D70A3D7, 0x3FED3AAE,0xA856146C,
	0x40000000,0x00000000, 0x3FED18F6,0xEAD1B446,
	0x4000147A,0xE147AE14, 0x3FECF680,0x7C2CCC6F,
	0x400028F5,0xC28F5C29, 0x3FECD34C,0x3E4192A0,
	0x40003D70,0xA3D70A3D, 0x3FECAF5B,0x17C629B6,
	0x400051EB,0x851EB852, 0x3FEC8AAD,0xF446B9AB,
	0x40006666,0x66666666, 0x3FEC6545,0xC41F67FD,
	0x40007AE1,0x47AE147B, 0x3FEC3F23,0x7C763065,
	0x40008F5C,0x28F5C28F, 0x3FEC1848,0x17349E4E,
	0x4000A3D7,0x0A3D70A4, 0x3FEBF0B4,0x930166FC,
	0x4000B851,0xEB851EB8, 0x3FEBC869,0xF339E4B7,
	0x4000CCCC,0xCCCCCCCD, 0x3FEB9F69,0x3FEB72FB,
	0x4000E147,0xAE147AE1, 0x3FEB75B3,0x85CCAC10,
	0x4000F5C2,0x8F5C28F6, 0x3FEB4B49,0xD63687F1,
	0x40010A3D,0x70A3D70A, 0x3FEB202D,0x471D5CF8,
	0x40011EB8,0x51EB851F, 0x3FEAF45E,0xF309C235,
	0x40013333,0x33333333, 0x3FEAC7DF,0xF91153EA,
	0x400147AE,0x147AE148, 0x3FEA9AB1,0x7CCF5A0D,
	0x40015C28,0xF5C28F5C, 0x3FEA6CD4,0xA65D5148,
	0x400170A3,0xD70A3D71, 0x3FEA3E4A,0xA24B566B,
	0x4001851E,0xB851EB85, 0x3FEA0F14,0xA19874B8,
	0x40019999,0x9999999A, 0x3FE9DF33,0xD9AAD708,
	0x4001AE14,0x7AE147AE, 0x3FE9AEA9,0x8447DC31,
	0x4001C28F,0x5C28F5C3, 0x3FE97D76,0xDF8C0EA5,
	0x4001D70A,0x3D70A3D7, 0x3FE94B9D,0x2DE2FFBF,
	0x4001EB85,0x1EB851EC, 0x3FE9191D,0xB5FF06B6,
	0x40020000,0x00000000, 0x3FE8E5F9,0xC2D0E3A9,
	0x4002147A,0xE147AE14, 0x3FE8B232,0xA37F46B7,
	0x400228F5,0xC28F5C29, 0x3FE87DC9,0xAB5E3B9C,
	0x40023D70,0xA3D70A3D, 0x3FE848C0,0x31E679E5,
	0x400251EB,0x851EB852, 0x3FE81317,0x92AC99F3,
	0x40026666,0x66666666, 0x3FE7DCD1,0x2D582F24,
	0x40027AE1,0x47AE147B, 0x3FE7A5EE,0x659AC72D,
	0x40028F5C,0x28F5C28F, 0x3FE76E70,0xA326CF21,
	0x4002A3D7,0x0A3D70A4, 0x3FE73659,0x51A65E10,
	0x4002B851,0xEB851EB8, 0x3FE6FDA9,0xE0B1E5D3,
	0x4002CCCC,0xCCCCCCCD, 0x3FE6C463,0xC3C6C9E8,
	0x4002E147,0xAE147AE1, 0x3FE68A88,0x723DDCF7,
	0x4002F5C2,0x8F5C28F6, 0x3FE65019,0x6741C4DC,
	0x40030A3D,0x70A3D70A, 0x3FE61518,0x21C545E0,
	0x40031EB8,0x51EB851F, 0x3FE5D986,0x247974F6,
	0x40033333,0x33333333, 0x3FE59D64,0xF5C3D19B,
	0x400347AE,0x147AE148, 0x3FE560B6,0x1FB44749,
	0x40035C28,0xF5C28F5C, 0x3FE5237B,0x2FFB1706,
	0x400370A3,0xD70A3D71, 0x3FE4E5B5,0xB7DEA911,
	0x4003851E,0xB851EB85, 0x3FE4A767,0x4C314729,
	0x40039999,0x9999999A, 0x3FE46891,0x8546BF7C,
	0x4003AE14,0x7AE147AE, 0x3FE42935,0xFEE9F0B6,
	0x4003C28F,0x5C28F5C3, 0x3FE3E956,0x58523F3F,
	0x4003D70A,0x3D70A3D7, 0x3FE3A8F4,0x3418F429,
	0x4003EB85,0x1EB851EC, 0x3FE36811,0x382E85CD,
	0x40040000,0x00000000, 0x3FE326AF,0x0DCFCAB1,
	0x4004147A,0xE147AE14, 0x3FE2E4CF,0x617B169D,
	0x400428F5,0xC28F5C29, 0x3FE2A273,0xE2E54284,
	0x40043D70,0xA3D70A3D, 0x3FE25F9E,0x44EE9F55,
	0x400451EB,0x851EB852, 0x3FE21C50,0x3D97D3E9,
	0x40046666,0x66666666, 0x3FE1D88B,0x85F6A6A5,
	0x40047AE1,0x47AE147B, 0x3FE19451,0xDA2AB2B7,
	0x40048F5C,0x28F5C28F, 0x3FE14FA4,0xF9520997,
	0x4004A3D7,0x0A3D70A4, 0x3FE10A86,0xA57DC0BA,
	0x4004B851,0xEB851EB8, 0x3FE0C4F8,0xA3A66C23,
	0x4004CCCC,0xCCCCCCCD, 0x3FE07EFC,0xBBA085BB,
	0x4004E147,0xAE147AE1, 0x3FE03894,0xB810C219,
	0x4004F5C2,0x8F5C28F6, 0x3FDFE384,0xCCC0A55E,
	0x40050A3D,0x70A3D70A, 0x3FDF550F,0x2D622BFF,
	0x40051EB8,0x51EB851F, 0x3FDEC5CC,0x37A36B9F,
	0x40053333,0x33333333, 0x3FDE35BF,0x96636804,
	0x400547AE,0x147AE148, 0x3FDDA4EC,0xF9AACC0D,
	0x40055C28,0xF5C28F5C, 0x3FDD1358,0x1693BF1F,
	0x400570A3,0xD70A3D71, 0x3FDC8104,0xA73198F8,
	0x4005851E,0xB851EB85, 0x3FDBEDF6,0x6A78754D,
	0x40059999,0x9999999A, 0x3FDB5A31,0x2424A70C,
	0x4005AE14,0x7AE147AE, 0x3FDAC5B8,0x9CA20CAC,
	0x4005C28F,0x5C28F5C3, 0x3FDA3090,0xA0F34560,
	0x4005D70A,0x3D70A3D7, 0x3FD99ABD,0x0298C8A6,
	0x4005EB85,0x1EB851EC, 0x3FD90441,0x9777DFF0,
	0x40060000,0x00000000, 0x3FD86D22,0x39C183FB,
	0x4006147A,0xE147AE14, 0x3FD7D562,0xC7D91D8E,
	0x400628F5,0xC28F5C29, 0x3FD73D07,0x243B2B02,
	0x40063D70,0xA3D70A3D, 0x3FD6A413,0x3563CAEE,
	0x400651EB,0x851EB852, 0x3FD60A8A,0xE5B52C59,
	0x40066666,0x66666666, 0x3FD57072,0x235DE5C8,
	0x40067AE1,0x47AE147B, 0x3FD4D5CC,0xE03F32F1,
	0x40068F5C,0x28F5C28F, 0x3FD43A9F,0x11D31AB2,
	0x4006A3D7,0x0A3D70A4, 0x3FD39EEC,0xB1127CF3,
	0x4006B851,0xEB851EB8, 0x3FD302B9,0xBA5B0A1C,
	0x4006CCCC,0xCCCCCCCD, 0x3FD2660A,0x2D5523D7,
	0x4006E147,0xAE147AE1, 0x3FD1C8E2,0x0CD9A8B6,
	0x4006F5C2,0x8F5C28F6, 0x3FD12B45,0x5ED7AA77,
	0x40070A3D,0x70A3D70A, 0x3FD08D38,0x2C3A108B,
	0x40071EB8,0x51EB851F, 0x3FCFDD7D,0x019A4D22,
	0x40073333,0x33333333, 0x3FCE9FB8,0xD64830E3,
	0x400747AE,0x147AE148, 0x3FCD612B,0xF8FCB783,
	0x40075C28,0xF5C28F5C, 0x3FCC21DE,0x915A1052,
	0x400770A3,0xD70A3D71, 0x3FCAE1D8,0xCBF03CDB,
	0x4007851E,0xB851EB85, 0x3FC9A122,0xDA077FAF,
	0x40079999,0x9999999A, 0x3FC85FC4,0xF16AAB46,
	0x4007AE14,0x7AE147AE, 0x3FC71DC7,0x4C31544D,
	0x4007C28F,0x5C28F5C3, 0x3FC5DB32,0x2889E6C6,
	0x4007D70A,0x3D70A3D7, 0x3FC4980D,0xC883A15C,
	0x4007EB85,0x1EB851EC, 0x3FC35462,0x71D87651,
	0x40080000,0x00000000, 0x3FC21038,0x6DB6D55B,
	0x4008147A,0xE147AE14, 0x3FC0CB98,0x088B5DF8,
	0x400828F5,0xC28F5C29, 0x3FBF0D13,0x2394FA2B,
	0x40083D70,0xA3D70A3D, 0x3FBC822A,0xB773EDC8,
	0x400851EB,0x851EB852, 0x3FB9F687,0x7674BB23,
	0x40086666,0x66666666, 0x3FB76A3A,0x0F20EFBE,
	0x40087AE1,0x47AE147B, 0x3FB4DD53,0x345D2E1A,
	0x40088F5C,0x28F5C28F, 0x3FB24FE3,0x9CFBBF03,
	0x4008A3D7,0x0A3D70A4, 0x3FAF83F8,0x069E0E35,
	0x4008B851,0xEB851EB8, 0x3FAA675A,0x4977CEEC,
	0x4008CCCC,0xCCCCCCCD, 0x3FA54A0F,0x8298102E,
	0x4008E147,0xAE147AE1, 0x3FA02C39,0x36802625,
	0x4008F5C2,0x8F5C28F6, 0x3F961BF1,0xDA877CCC,
	0x40090A3D,0x70A3D70A, 0x3F87BDC0,0xC6B48734,
	0x40091EB8,0x51EB851F, 0x3F5A1812,0x0C2C1274,
	0x40093333,0x33333333, 0xBF8137D1,0xA3EE270D,
	0x400947AE,0x147AE148, 0xBF92D91A,0x59453A07,
	0x40095C28,0xF5C28F5C, 0xBF9D15D0,0x5B0B6F91,
	0x400970A3,0xD70A3D71, 0xBFA3A8E3,0xE02B7A3E,
	0x4009851E,0xB851EB85, 0xBFA8C65E,0xBB8B1A8A,
	0x40099999,0x9999999A, 0xBFADE337,0x39E82D32,
	0x4009AE14,0x7AE147AE, 0xBFB17FA5,0xECD729F6,
	0x4009C28F,0x5C28F5C3, 0xBFB40D3D,0x8F266A95,
	0x4009D70A,0x3D70A3D7, 0xBFB69A51,0xC8890766,
	0x4009EB85,0x1EB851EC, 0xBFB926D1,0xE103632B,
	0x400A0000,0x00000000, 0xBFBBB2AD,0x2464A48C,
	0x400A147A,0xE147AE14, 0xBFBE3DD2,0xE2B42F28,
	0x400A28F5,0xC28F5C29, 0xBFC06419,0x384F7FE2,
	0x400A3D70,0xA3D70A3D, 0xBFC1A8DD,0x93F27504,
	0x400A51EB,0x851EB852, 0xBFC2ED2E,0x33E2DB1E,
	0x400A6666,0x66666666, 0xBFC43102,0xCAB70C87,
	0x400A7AE1,0x47AE147B, 0xBFC57453,0x0E32434A,
	0x400A8F5C,0x28F5C28F, 0xBFC6B716,0xB77AECD3,
	0x400AA3D7,0x0A3D70A4, 0xBFC7F945,0x8350E869,
	0x400AB851,0xEB851EB8, 0xBFC93AD7,0x3243AD13,
	0x400ACCCC,0xCCCCCCCD, 0xBFCA7BC3,0x88E85781,
	0x400AE147,0xAE147AE1, 0xBFCBBC02,0x500F9C99,
	0x400AF5C2,0x8F5C28F6, 0xBFCCFB8B,0x54FBA14D,
	0x400B0A3D,0x70A3D70A, 0xBFCE3A56,0x6995B44A,
	0x400B1EB8,0x51EB851F, 0xBFCF785B,0x64A3EA2C,
	0x400B3333,0x33333333, 0xBFD05AC9,0x10FF4C6C,
	0x400B47AE,0x147AE148, 0xBFD0F8F9,0x4162D949,
	0x400B5C28,0xF5C28F5C, 0xBFD196BA,0x36CAFEC3,
	0x400B70A3,0xD70A3D71, 0xBFD23407,0xE75F1422,
	0x400B851E,0xB851EB85, 0xBFD2D0DE,0x4C39DC04,
	0x400B9999,0x9999999A, 0xBFD36D39,0x6183E89C,
	0x400BAE14,0x7AE147AE, 0xBFD40915,0x268DEB78,
	0x400BC28F,0x5C28F5C3, 0xBFD4A46D,0x9DEAF10F,
	0x400BD70A,0x3D70A3D7, 0xBFD53F3E,0xCD8A8678,
	0x400BEB85,0x1EB851EC, 0xBFD5D984,0xBED2C998,
	0x400C0000,0x00000000, 0xBFD6733B,0x7EBA621F,
	0x400C147A,0xE147AE14, 0xBFD70C5F,0x1DE2639E,
	0x400C28F5,0xC28F5C29, 0xBFD7A4EB,0xB0B01748,
	0x400C3D70,0xA3D70A3D, 0xBFD83CDD,0x4F66AD08,
	0x400C51EB,0x851EB852, 0xBFD8D430,0x1640D38A,
	0x400C6666,0x66666666, 0xBFD96AE0,0x258A35D0,
	0x400C7AE1,0x47AE147B, 0xBFDA00E9,0xA1B8DE9D,
	0x400C8F5C,0x28F5C28F, 0xBFDA9648,0xB386801C,
	0x400CA3D7,0x0A3D70A4, 0xBFDB2AF9,0x8809A00B,
	0x400CB851,0xEB851EB8, 0xBFDBBEF8,0x50CEA6D7,
	0x400CCCCC,0xCCCCCCCD, 0xBFDC5241,0x43F0D1F1,
	0x400CE147,0xAE147AE1, 0xBFDCE4D0,0x9C3307D8,
	0x400CF5C2,0x8F5C28F6, 0xBFDD76A2,0x99188E09,
	0x400D0A3D,0x70A3D70A, 0xBFDE07B3,0x7EFD9F61,
	0x400D1EB8,0x51EB851F, 0xBFDE97FF,0x972FE32A,
	0x400D3333,0x33333333, 0xBFDF2783,0x3006C351,
	0x400D47AE,0x147AE148, 0xBFDFB63A,0x9CFBA20A,
	0x400D5C28,0xF5C28F5C, 0xBFE02211,0x1B60F6AE,
	0x400D70A3,0xD70A3D71, 0xBFE0689B,0x2DAF8872,
	0x400D851E,0xB851EB85, 0xBFE0AEB9,0xB7212221,
	0x400D9999,0x9999999A, 0xBFE0F46A,0xEC2E1B41,
	0x400DAE14,0x7AE147AE, 0xBFE139AD,0x041B4A7D,
	0x400DC28F,0x5C28F5C3, 0xBFE17E7E,0x3905B6F8,
	0x400DD70A,0x3D70A3D7, 0xBFE1C2DC,0xC7EE36C4,
	0x400DEB85,0x1EB851EC, 0xBFE206C6,0xF0C4FA98,
	0x400E0000,0x00000000, 0xBFE24A3A,0xF6750621,
	0x400E147A,0xE147AE14, 0xBFE28D37,0x1EEF94F2,
	0x400E28F5,0xC28F5C29, 0xBFE2CFB9,0xB3376B84,
	0x400E3D70,0xA3D70A3D, 0xBFE311C0,0xFF6C1424,
	0x400E51EB,0x851EB852, 0xBFE3534B,0x52D50789,
	0x400E6666,0x66666666, 0xBFE39456,0xFFECC09D,
	0x400E7AE1,0x47AE147B, 0xBFE3D4E2,0x5C6BBB78,
	0x400E8F5C,0x28F5C28F, 0xBFE414EB,0xC1535EE7,
	0x400EA3D7,0x0A3D70A4, 0xBFE45471,0x8AF8D0AA,
	0x400EB851,0xEB851EB8, 0xBFE49372,0x190FB3A3,
	0x400ECCCC,0xCCCCCCCD, 0xBFE4D1EB,0xCEB4D02B,
	0x400EE147,0xAE147AE1, 0xBFE50FDD,0x1278A5E0,
	0x400EF5C2,0x8F5C28F6, 0xBFE54D44,0x4E69E6F5,
	0x400F0A3D,0x70A3D70A, 0xBFE58A1F,0xF01FDC7F,
	0x400F1EB8,0x51EB851F, 0xBFE5C66E,0x68C4B3BD,
	0x400F3333,0x33333333, 0xBFE6022E,0x2D1FB3CB,
	0x400F47AE,0x147AE148, 0xBFE63D5D,0xB59F5BD3,
	0x400F5C28,0xF5C28F5C, 0xBFE677FB,0x7E636920,
	0x400F70A3,0xD70A3D71, 0xBFE6B206,0x0746C52B,
	0x400F851E,0xB851EB85, 0xBFE6EB7B,0xD3E95B05,
	0x400F9999,0x9999999A, 0xBFE7245B,0x6BB9D440,
	0x400FAE14,0x7AE147AE, 0xBFE75CA3,0x59FF3CB1,
	0x400FC28F,0x5C28F5C3, 0xBFE79452,0x2DE28D2E,
	0x400FD70A,0x3D70A3D7, 0xBFE7CB66,0x7A781CAB,
	0x400FEB85,0x1EB851EC, 0xBFE801DE,0xD6C8F7DB,
	0x40100000,0x00000000, 0xBFE837B9,0xDDDC1EAE,
	0x40100A3D,0x70A3D70A, 0xBFE86CF6,0x2EBFA7DA,
	0x4010147A,0xE147AE14, 0xBFE8A192,0x6C91C9D3,
	0x40101EB8,0x51EB851F, 0xBFE8D58D,0x3E89C943,
	0x401028F5,0xC28F5C29, 0xBFE908E5,0x5000CC81,
	0x40103333,0x33333333, 0xBFE93B99,0x507A942B,
	0x40103D70,0xA3D70A3D, 0xBFE96DA7,0xF3AE183E,
	0x401047AE,0x147AE148, 0xBFE99F0F,0xF18E09C5,
	0x401051EB,0x851EB852, 0xBFE9CFD0,0x065138AD,
	0x40105C28,0xF5C28F5C, 0xBFE9FFE6,0xF27ADDD3,
	0x40106666,0x66666666, 0xBFEA2F53,0x7AE2C8B8,
	0x401070A3,0xD70A3D71, 0xBFEA5E14,0x68BD70F3,
	0x40107AE1,0x47AE147B, 0xBFEA8C28,0x89A3EAE6,
	0x4010851E,0xB851EB85, 0xBFEAB98E,0xAF9BBFE6,
	0x40108F5C,0x28F5C28F, 0xBFEAE645,0xB11EA92E,
	0x40109999,0x9999999A, 0xBFEB124C,0x69222DBC,
	0x4010A3D7,0x0A3D70A4, 0xBFEB3DA1,0xB71F22B8,
	0x4010AE14,0x7AE147AE, 0xBFEB6844,0x7F190E71,
	0x4010B851,0xEB851EB8, 0xBFEB9233,0xA9A56D63,
	0x4010C28F,0x5C28F5C3, 0xBFEBBB6E,0x23F2D970,
	0x4010CCCC,0xCCCCCCCD, 0xBFEBE3F2,0xDFD012D8,
	0x4010D70A,0x3D70A3D7, 0xBFEC0BC0,0xD3B2EB03,
	0x4010E147,0xAE147AE1, 0xBFEC32D6,0xFABF10B3,
	0x4010EB85,0x1EB851EC, 0xBFEC5934,0x54CCBD95,
	0x4010F5C2,0x8F5C28F6, 0xBFEC7ED7,0xE66F44EF,
	0x40110000,0x00000000, 0xBFECA3C0,0xB8FB8370,
	0x40110A3D,0x70A3D70A, 0xBFECC7ED,0xDA8E2FAD,
	0x4011147A,0xE147AE14, 0xBFECEB5E,0x5E120B5D,
	0x40111EB8,0x51EB851F, 0xBFED0E11,0x5B45F51B,
	0x401128F5,0xC28F5C29, 0xBFED3005,0xEEC2DA6D,
	0x40113333,0x33333333, 0xBFED513B,0x3A018A25,
	0x40113D70,0xA3D70A3D, 0xBFED71B0,0x636066AD,
	0x401147AE,0x147AE148, 0xBFED9164,0x9628F84B,
	0x401151EB,0x851EB852, 0xBFEDB057,0x02955F22,
	0x40115C28,0xF5C28F5C, 0xBFEDCE86,0xDDD5A4E3,
	0x40116666,0x66666666, 0xBFEDEBF3,0x6214EDEA,
	0x401170A3,0xD70A3D71, 0xBFEE089B,0xCE7E89BF,
	0x40117AE1,0x47AE147B, 0xBFEE247F,0x6742E2C9,
	0x4011851E,0xB851EB85, 0xBFEE3F9D,0x759C4D2E,
	0x40118F5C,0x28F5C28F, 0xBFEE59F5,0x47D3B49C,
	0x40119999,0x9999999A, 0xBFEE7386,0x314528EF,
	0x4011A3D7,0x0A3D70A4, 0xBFEE8C4F,0x8A64499B,
	0x4011AE14,0x7AE147AE, 0xBFEEA450,0xB0C08FB8,
	0x4011B851,0xEB851EB8, 0xBFEEBB89,0x07097691,
	0x4011C28F,0x5C28F5C3, 0xBFEED1F7,0xF5128298,
	0x4011CCCC,0xCCCCCCCD, 0xBFEEE79C,0xE7D726A9,
	0x4011D70A,0x3D70A3D7, 0xBFEEFC77,0x517E8793,
	0x4011E147,0xAE147AE1, 0xBFEF1086,0xA95F1DA8,
	0x4011EB85,0x1EB851EC, 0xBFEF23CA,0x6C023462,
	0x4011F5C2,0x8F5C28F6, 0xBFEF3642,0x1B2747E8,
	0x40120000,0x00000000, 0xBFEF47ED,0x3DC74080,
	0x40120A3D,0x70A3D70A, 0xBFEF58CB,0x60178BB1,
	0x4012147A,0xE147AE14, 0xBFEF68DC,0x138D1319,
	0x40121EB8,0x51EB851F, 0xBFEF781E,0xEEDF10E9,
	0x401228F5,0xC28F5C29, 0xBFEF8693,0x8E09C1D3,
	0x40123333,0x33333333, 0xBFEF9439,0x9250F48D,
	0x40123D70,0xA3D70A3D, 0xBFEFA110,0xA24276A3,
	0x401247AE,0x147AE148, 0xBFEFAD18,0x69B85EA7,
	0x401251EB,0x851EB852, 0xBFEFB850,0x99DB33A8,
	0x40125C28,0xF5C28F5C, 0xBFEFC2B8,0xE923F1E9,
	0x40126666,0x66666666, 0xBFEFCC51,0x135DECB9,
	0x401270A3,0xD70A3D71, 0xBFEFD518,0xD9A88D75,
	0x40127AE1,0x47AE147B, 0xBFEFDD10,0x0278EF91,
	0x4012851E,0xB851EB85, 0xBFEFE436,0x599B59C0,
	0x40128F5C,0x28F5C28F, 0xBFEFEA8B,0xB0349405,
	0x40129999,0x9999999A, 0xBFEFF00F,0xDCC31ACE,
	0x4012A3D7,0x0A3D70A4, 0xBFEFF4C2,0xBB202EEF,
	0x4012AE14,0x7AE147AE, 0xBFEFF8A4,0x2C80C295,
	0x4012B851,0xEB851EB8, 0xBFEFFBB4,0x17764310,
	0x4012C28F,0x5C28F5C3, 0xBFEFFDF2,0x67EF3F7E,
	0x4012CCCC,0xCCCCCCCD, 0xBFEFFF5F,0x0F37EC52,
	0x4012D70A,0x3D70A3D7, 0xBFEFFFFA,0x03FA83AC,
	0x4012E147,0xAE147AE1, 0xBFEFFFC3,0x423F8286,
	0x4012EB85,0x1EB851EC, 0xBFEFFEBA,0xCB6DC2B5,
	0x4012F5C2,0x8F5C28F6, 0xBFEFFCE0,0xA64A71BA,
	0x40130000,0x00000000, 0xBFEFFA34,0xDEF8E460,
	0x40130A3D,0x70A3D70A, 0xBFEFF6B7,0x86FA4733,
	0x4013147A,0xE147AE14, 0xBFEFF268,0xB52D2BC8,
	0x40131EB8,0x51EB851F, 0xBFEFED48,0x85CCF2DC,
	0x401328F5,0xC28F5C29, 0xBFEFE757,0x1A71134F,
	0x40133333,0x33333333, 0xBFEFE094,0x9A0C3E00,
	0x40133D70,0xA3D70A3D, 0xBFEFD901,0x30EB5E8D,
	0x401347AE,0x147AE148, 0xBFEFD09D,0x10B478FD,
	0x401351EB,0x851EB852, 0xBFEFC768,0x70656469,
	0x40135C28,0xF5C28F5C, 0xBFEFBD63,0x8C52628E,
	0x40136666,0x66666666, 0xBFEFB28E,0xA6249473,
	0x401370A3,0xD70A3D71, 0xBFEFA6EA,0x04D84C19,
	0x40137AE1,0x47AE147B, 0xBFEF9A75,0xF4BB3B4A,
	0x4013851E,0xB851EB85, 0xBFEF8D32,0xC76A7F82,
	0x40138F5C,0x28F5C28F, 0xBFEF7F20,0xD3D08B19,
	0x40139999,0x9999999A, 0xBFEF7040,0x7622EBA4,
	0x4013A3D7,0x0A3D70A4, 0xBFEF6092,0x0FDFEDB0,
	0x4013AE14,0x7AE147AE, 0xBFEF5016,0x07CC1DCA,
	0x4013B851,0xEB851EB8, 0xBFEF3ECC,0xC9EFA709,
	0x4013C28F,0x5C28F5C3, 0xBFEF2CB6,0xC7938F0C,
	0x4013CCCC,0xCCCCCCCD, 0xBFEF19D4,0x773ECF93,
	0x4013D70A,0x3D70A3D7, 0xBFEF0626,0x54B34DB1,
	0x4013E147,0xAE147AE1, 0xBFEEF1AC,0xE0EAAEC8,
	0x4013EB85,0x1EB851EC, 0xBFEEDC68,0xA2130B42,
	0x4013F5C2,0x8F5C28F6, 0xBFEEC65A,0x238B7F41,
	0x40140000,0x00000000, 0xBFEEAF81,0xF5E09933,
	0x40140A3D,0x70A3D70A, 0xBFEE97E0,0xAEC8A688,
	0x4014147A,0xE147AE14, 0xBFEE7F76,0xE91FDE8D,
	0x40141EB8,0x51EB851F, 0xBFEE6645,0x44E46B89,
	0x401428F5,0xC28F5C29, 0xBFEE4C4C,0x6732523C,
	0x40143333,0x33333333, 0xBFEE318C,0xFA3F37C9,
	0x40143D70,0xA3D70A3D, 0xBFEE1607,0xAD560644,
	0x401447AE,0x147AE148, 0xBFEDF9BD,0x34D26FE0,
	0x401451EB,0x851EB852, 0xBFEDDCAE,0x4A1C5102,
	0x40145C28,0xF5C28F5C, 0xBFEDBEDB,0xABA2F11E,
	0x40146666,0x66666666, 0xBFEDA046,0x1CD822BC,
	0x401470A3,0xD70A3D71, 0xBFED80EE,0x662B4296,
	0x40147AE1,0x47AE147B, 0xBFED60D5,0x5504161A,
	0x4014851E,0xB851EB85, 0xBFED3FFB,0xBBBD8930,
	0x40148F5C,0x28F5C28F, 0xBFED1E62,0x71A04BB4,
	0x40149999,0x9999999A, 0xBFECFC0A,0x52DD4E96,
	0x4014A3D7,0x0A3D70A4, 0xBFECD8F4,0x408820D8,
	0x4014AE14,0x7AE147AE, 0xBFECB521,0x20912C71,
	0x4014B851,0xEB851EB8, 0xBFEC9091,0xDDBFD36F,
	0x4014C28F,0x5C28F5C3, 0xBFEC6B47,0x67AC6D4F,
	0x4014CCCC,0xCCCCCCCD, 0xBFEC4542,0xB2BA24D7,
	0x4014D70A,0x3D70A3D7, 0xBFEC1E84,0xB810B668,
	0x4014E147,0xAE147AE1, 0xBFEBF70E,0x75960F2E,
	0x4014EB85,0x1EB851EC, 0xBFEBCEE0,0xEDE7CD32,
	0x4014F5C2,0x8F5C28F6, 0xBFEBA5FD,0x2854A088,
	0x40150000,0x00000000, 0xBFEB7C64,0x30D58DA3,
	0x40150A3D,0x70A3D70A, 0xBFEB5217,0x18071138,
	0x4015147A,0xE147AE14, 0xBFEB2716,0xF32225A8,
	0x40151EB8,0x51EB851F, 0xBFEAFB64,0xDBF52A31,
	0x401528F5,0xC28F5C29, 0xBFEACF01,0xF0DCAC29,
	0x40153333,0x33333333, 0xBFEAA1EF,0x54BC123B,
	0x40153D70,0xA3D70A3D, 0xBFEA742E,0x2EF62A19,
	0x401547AE,0x147AE148, 0xBFEA45BF,0xAB6598A1,
	0x401551EB,0x851EB852, 0xBFEA16A4,0xFA552CD7,
	0x40155C28,0xF5C28F5C, 0xBFE9E6DF,0x50781594,
	0x40156666,0x66666666, 0xBFE9B66F,0xE6E1FA88,
	0x401570A3,0xD70A3D71, 0xBFE98557,0xFAFEF867,
	0x40157AE1,0x47AE147B, 0xBFE95398,0xCE8B80C9,
	0x4015851E,0xB851EB85, 0xBFE92133,0xA78C1D7E,
	0x40158F5C,0x28F5C28F, 0xBFE8EE29,0xD0451817,
	0x40159999,0x9999999A, 0xBFE8BA7C,0x97320570,
	0x4015A3D7,0x0A3D70A4, 0xBFE8862D,0x4EFD35B4,
	0x4015AE14,0x7AE147AE, 0xBFE8513D,0x4E7708CC,
	0x4015B851,0xEB851EB8, 0xBFE81BAD,0xF08D27D0,
	0x4015C28F,0x5C28F5C3, 0xBFE7E580,0x9441A35C,
	0x4015CCCC,0xCCCCCCCD, 0xBFE7AEB6,0x9CA1F74F,
	0x4015D70A,0x3D70A3D7, 0xBFE77751,0x70BDF3CE,
	0x4015E147,0xAE147AE1, 0xBFE73F52,0x7B9E8C3D,
	0x4015EB85,0x1EB851EC, 0xBFE706BB,0x2C3C8C04,
	0x4015F5C2,0x8F5C28F6, 0xBFE6CD8C,0xF57731B3,
	0x40160000,0x00000000, 0xBFE693C9,0x4E0AB057,
	0x40160A3D,0x70A3D70A, 0xBFE65971,0xB08697B7,
	0x4016147A,0xE147AE14, 0xBFE61E87,0x9B442369,
	0x40161EB8,0x51EB851F, 0xBFE5E30C,0x905C7109,
	0x401628F5,0xC28F5C29, 0xBFE5A702,0x159E9E04,
	0x40163333,0x33333333, 0xBFE56A69,0xB485CCD3,
	0x40163D70,0xA3D70A3D, 0xBFE52D44,0xFA2F1262,
	0x401647AE,0x147AE148, 0xBFE4EF95,0x774F4B7F,
	0x401651EB,0x851EB852, 0xBFE4B15C,0xC028DAE9,
	0x40165C28,0xF5C28F5C, 0xBFE4729C,0x6C814FD9,
	0x40166666,0x66666666, 0xBFE43356,0x1796F5BB,
	0x401670A3,0xD70A3D71, 0xBFE3F38B,0x60164D0B,
	0x40167AE1,0x47AE147B, 0xBFE3B33D,0xE80F6DD8,
	0x4016851E,0xB851EB85, 0xBFE3726F,0x54EB53D5,
	0x40168F5C,0x28F5C28F, 0xBFE33121,0x4F6114B4,
	0x40169999,0x9999999A, 0xBFE2EF55,0x836B00B5,
	0x4016A3D7,0x0A3D70A4, 0xBFE2AD0D,0xA03BADFF,
	0x4016AE14,0x7AE147AE, 0xBFE26A4B,0x5832EE95,
	0x4016B851,0xEB851EB8, 0xBFE22710,0x60D2B1C0,
	0x4016C28F,0x5C28F5C3, 0xBFE1E35E,0x72B3D0CB,
	0x4016CCCC,0xCCCCCCCD, 0xBFE19F37,0x497AC7A0,
	0x4016D70A,0x3D70A3D7, 0xBFE15A9C,0xA3CC5935,
	0x4016E147,0xAE147AE1, 0xBFE11590,0x4342208A,
	0x4016EB85,0x1EB851EC, 0xBFE0D013,0xEC5F0E27,
	0x4016F5C2,0x8F5C28F6, 0xBFE08A29,0x6683D2A4,
	0x40170000,0x00000000, 0xBFE043D2,0x7BE3362F,
	0x40170A3D,0x70A3D70A, 0xBFDFFA21,0xF2ECBB9B,
	0x4017147A,0xE147AE14, 0xBFDF6BCD,0x5DE1FCB6,
	0x40171EB8,0x51EB851F, 0xBFDEDCAA,0xDD6AFB2F,
	0x401728F5,0xC28F5C29, 0xBFDE4CBE,0x1B92039D,
	0x40173333,0x33333333, 0xBFDDBC0A,0xC78EDFD8,
	0x40173D70,0xA3D70A3D, 0xBFDD2A94,0x95AEB1CA,
	0x401747AE,0x147AE148, 0xBFDC985F,0x3F3BAC93,
	0x401751EB,0x851EB852, 0xBFDC056E,0x8264AD54,
	0x40175C28,0xF5C28F5C, 0xBFDB71C6,0x2224B35F,
	0x40176666,0x66666666, 0xBFDADD69,0xE62A3979,
	0x401770A3,0xD70A3D71, 0xBFDA485D,0x9ABE7006,
	0x40177AE1,0x47AE147B, 0xBFD9B2A5,0x10AC5952,
	0x4017851E,0xB851EB85, 0xBFD91C44,0x1D27C7C9,
	0x40178F5C,0x28F5C28F, 0xBFD8853E,0x99B43FD2,
	0x40179999,0x9999999A, 0xBFD7ED98,0x640BBD1B,
	0x4017A3D7,0x0A3D70A4, 0xBFD75555,0x5E055C97,
	0x4017AE14,0x7AE147AE, 0xBFD6BC79,0x6D7BEAFC,
	0x4017B851,0xEB851EB8, 0xBFD62308,0x7C345980,
	0x4017C28F,0x5C28F5C3, 0xBFD58906,0x77C41896,
	0x4017CCCC,0xCCCCCCCD, 0xBFD4EE77,0x51775A0A,
	0x4017D70A,0x3D70A3D7, 0xBFD4535E,0xFE373A29,
	0x4017E147,0xAE147AE1, 0xBFD3B7C1,0x766FD1D8,
	0x4017EB85,0x1EB851EC, 0xBFD31BA2,0xB5F63148,
	0x4017F5C2,0x8F5C28F6, 0xBFD27F06,0xBBEE44B0,
	0x40180000,0x00000000, 0xBFD1E1F1,0x8AB0A2C0,
	0x40180A3D,0x70A3D70A, 0xBFD14467,0x27B046A7,
	0x4018147A,0xE147AE14, 0xBFD0A66B,0x9B60357B,
	0x40181EB8,0x51EB851F, 0xBFD00802,0xF1190FF5,
	0x401828F5,0xC28F5C29, 0xBFCED262,0x6DFD22FC,
	0x40183333,0x33333333, 0xBFCD93F4,0xFBC9F8AA,
	0x40183D70,0xA3D70A3D, 0xBFCC54C5,0xB26CE959,
	0x401847AE,0x147AE148, 0xBFCB14DC,0xBDB094F6,
	0x401851EB,0x851EB852, 0xBFC9D442,0x4E2066CE,
	0x40185C28,0xF5C28F5C, 0xBFC892FE,0x98D2E904,
	0x40186666,0x66666666, 0xBFC75119,0xD733FB7B,
	0x401870A3,0xD70A3D71, 0xBFC60E9C,0x46CEED9F,
	0x40187AE1,0x47AE147B, 0xBFC4CB8E,0x29187DE2,
	0x4018851E,0xB851EB85, 0xBFC387F7,0xC338BE5F,
	0x40188F5C,0x28F5C28F, 0xBFC243E1,0x5DD4E279,
	0x40189999,0x9999999A, 0xBFC0FF53,0x44D8F4DA,
	0x4018A3D7,0x0A3D70A4, 0xBFBF74AB,0x8E82F16F,
	0x4018AE14,0x7AE147AE, 0xBFBCE9E2,0x6DC9EB9B,
	0x4018B851,0xEB851EB8, 0xBFBA5E5B,0xD07AE5B3,
	0x4018C28F,0x5C28F5C3, 0xBFB7D228,0x6463BC2E,
	0x4018CCCC,0xCCCCCCCD, 0xBFB54558,0xDBBECD1D,
	0x4018D70A,0x3D70A3D7, 0xBFB2B7FD,0xECC58B58,
	0x4018E147,0xAE147AE1, 0xBFB02A28,0x5142F9F1,
	0x4018EB85,0x1EB851EC, 0xBFAB37D1,0x8C4C1D8D,
	0x4018F5C2,0x8F5C28F6, 0xBFA61AA0,0x1628040A,
	0x40190000,0x00000000, 0xBFA0FCDD,0xC3F512BC,
	0x40190A3D,0x70A3D70A, 0xBF97BD58,0x3A881B26,
	0x4019147A,0xE147AE14, 0xBF8B00B2,0xB1FD4F19,
	0x40191EB8,0x51EB851F, 0xBF6A180F,0xE0F0FDA7,
	0x401928F5,0xC28F5C29, 0x3F7BE9AB,0x04151703,
	0x40193333,0x33333333, 0x3F9137A9,0xC2CB3E7E,
	};

LOCAL_D const TUint32 CosineTest[] =
	{
	0x00000000,0x00000000, 0x3FF00000,0x00000000,
	0x3F50624D,0xD2F1A9FC, 0x3FEFFFFE,0xF390876C,
	0x3F60624D,0xD2F1A9FC, 0x3FEFFFFB,0xCE422F47,
	0x3F689374,0xBC6A7EFA, 0x3FEFFFF6,0x90152C59,
	0x3F70624D,0xD2F1A9FC, 0x3FEFFFEF,0x3909D697,
	0x3F747AE1,0x47AE147B, 0x3FEFFFE5,0xC920A926,
	0x3F789374,0xBC6A7EFA, 0x3FEFFFDA,0x405A425B,
	0x3F7CAC08,0x3126E979, 0x3FEFFFCC,0x9EB763B9,
	0x3F80624D,0xD2F1A9FC, 0x3FEFFFBC,0xE438F1F2,
	0x3F826E97,0x8D4FDF3B, 0x3FEFFFAB,0x10DFF4E7,
	0x3F847AE1,0x47AE147B, 0x3FEFFF97,0x24AD97AA,
	0x3F86872B,0x020C49BA, 0x3FEFFF81,0x1FA32879,
	0x3F889374,0xBC6A7EFA, 0x3FEFFF69,0x01C218C1,
	0x3F8A9FBE,0x76C8B439, 0x3FEFFF4E,0xCB0BFD20,
	0x3F8CAC08,0x3126E979, 0x3FEFFF32,0x7B828D61,
	0x3F8EB851,0xEB851EB8, 0x3FEFFF14,0x1327A47C,
	0x3F90624D,0xD2F1A9FC, 0x3FEFFEF3,0x91FD409A,
	0x3F916872,0xB020C49C, 0x3FEFFED0,0xF8058311,
	0x3F926E97,0x8D4FDF3B, 0x3FEFFEAC,0x4542B064,
	0x3F9374BC,0x6A7EF9DB, 0x3FEFFE85,0x79B73046,
	0x3F947AE1,0x47AE147B, 0x3FEFFE5C,0x95658D96,
	0x3F958106,0x24DD2F1B, 0x3FEFFE31,0x98507662,
	0x3F96872B,0x020C49BA, 0x3FEFFE04,0x827ABBE4,
	0x3F978D4F,0xDF3B645A, 0x3FEFFDD5,0x53E75284,
	0x3F989374,0xBC6A7EFA, 0x3FEFFDA4,0x0C9951D6,
	0x3F999999,0x9999999A, 0x3FEFFD70,0xAC93F49E,
	0x3F9A9FBE,0x76C8B439, 0x3FEFFD3B,0x33DA98C8,
	0x3F9BA5E3,0x53F7CED9, 0x3FEFFD03,0xA270BF6F,
	0x3F9CAC08,0x3126E979, 0x3FEFFCC9,0xF85A0CDB,
	0x3F9DB22D,0x0E560419, 0x3FEFFC8E,0x359A487E,
	0x3F9EB851,0xEB851EB8, 0x3FEFFC50,0x5A355CF6,
	0x3F9FBE76,0xC8B43958, 0x3FEFFC10,0x662F580D,
	0x3FA0624D,0xD2F1A9FC, 0x3FEFFBCE,0x598C6AB9,
	0x3FA0E560,0x4189374C, 0x3FEFFB8A,0x3450E918,
	0x3FA16872,0xB020C49C, 0x3FEFFB43,0xF6814A76,
	0x3FA1EB85,0x1EB851EC, 0x3FEFFAFB,0xA0222947,
	0x3FA26E97,0x8D4FDF3B, 0x3FEFFAB1,0x3138432A,
	0x3FA2F1A9,0xFBE76C8B, 0x3FEFFA64,0xA9C878E6,
	0x3FA374BC,0x6A7EF9DB, 0x3FEFFA16,0x09D7CE6F,
	0x3FA3F7CE,0xD916872B, 0x3FEFF9C5,0x516B6ADF,
	0x3FA47AE1,0x47AE147B, 0x3FEFF972,0x80889878,
	0x3FA4FDF3,0xB645A1CB, 0x3FEFF91D,0x9734C4A8,
	0x3FA58106,0x24DD2F1B, 0x3FEFF8C6,0x95758001,
	0x3FA60418,0x9374BC6A, 0x3FEFF86D,0x7B507E3F,
	0x3FA6872B,0x020C49BA, 0x3FEFF812,0x48CB9646,
	0x3FA70A3D,0x70A3D70A, 0x3FEFF7B4,0xFDECC21E,
	0x3FA78D4F,0xDF3B645A, 0x3FEFF755,0x9ABA1EF7,
	0x3FA81062,0x4DD2F1AA, 0x3FEFF6F4,0x1F39ED28,
	0x3FA89374,0xBC6A7EFA, 0x3FEFF690,0x8B72902C,
	0x3FA91687,0x2B020C4A, 0x3FEFF62A,0xDF6A8EA5,
	0x3FA99999,0x9999999A, 0x3FEFF5C3,0x1B289258,
	0x3FAA1CAC,0x083126E9, 0x3FEFF559,0x3EB3682F,
	0x3FAA9FBE,0x76C8B439, 0x3FEFF4ED,0x4A12003A,
	0x3FAB22D0,0xE5604189, 0x3FEFF47F,0x3D4B6DA8,
	0x3FABA5E3,0x53F7CED9, 0x3FEFF40F,0x1866E6D0,
	0x3FAC28F5,0xC28F5C29, 0x3FEFF39C,0xDB6BC529,
	0x3FACAC08,0x3126E979, 0x3FEFF328,0x8661854B,
	0x3FAD2F1A,0x9FBE76C9, 0x3FEFF2B2,0x194FC6F1,
	0x3FADB22D,0x0E560419, 0x3FEFF239,0x943E4CF8,
	0x3FAE353F,0x7CED9168, 0x3FEFF1BE,0xF734FD5D,
	0x3FAEB851,0xEB851EB8, 0x3FEFF142,0x423BE13B,
	0x3FAF3B64,0x5A1CAC08, 0x3FEFF0C3,0x755B24CF,
	0x3FAFBE76,0xC8B43958, 0x3FEFF042,0x909B1774,
	0x3FB020C4,0x9BA5E354, 0x3FEFEFBF,0x94042BA3,
	0x3FB0624D,0xD2F1A9FC, 0x3FEFEF3A,0x7F9EF6F5,
	0x3FB0A3D7,0x0A3D70A4, 0x3FEFEEB3,0x5374321D,
	0x3FB0E560,0x4189374C, 0x3FEFEE2A,0x0F8CB8ED,
	0x3FB126E9,0x78D4FDF4, 0x3FEFED9E,0xB3F18A54,
	0x3FB16872,0xB020C49C, 0x3FEFED11,0x40ABC85A,
	0x3FB1A9FB,0xE76C8B44, 0x3FEFEC81,0xB5C4B823,
	0x3FB1EB85,0x1EB851EC, 0x3FEFEBF0,0x1345C1EF,
	0x3FB22D0E,0x56041893, 0x3FEFEB5C,0x59387115,
	0x3FB26E97,0x8D4FDF3B, 0x3FEFEAC6,0x87A67408,
	0x3FB2B020,0xC49BA5E3, 0x3FEFEA2E,0x9E999C51,
	0x3FB2F1A9,0xFBE76C8B, 0x3FEFE994,0x9E1BDE93,
	0x3FB33333,0x33333333, 0x3FEFE8F8,0x86375286,
	0x3FB374BC,0x6A7EF9DB, 0x3FEFE85A,0x56F632FA,
	0x3FB3B645,0xA1CAC083, 0x3FEFE7BA,0x1062DDD4,
	0x3FB3F7CE,0xD916872B, 0x3FEFE717,0xB287D411,
	0x3FB43958,0x10624DD3, 0x3FEFE673,0x3D6FB9BE,
	0x3FB47AE1,0x47AE147B, 0x3FEFE5CC,0xB12555FF,
	0x3FB4BC6A,0x7EF9DB23, 0x3FEFE524,0x0DB39309,
	0x3FB4FDF3,0xB645A1CB, 0x3FEFE479,0x53257E27,
	0x3FB53F7C,0xED916873, 0x3FEFE3CC,0x818647B2,
	0x3FB58106,0x24DD2F1B, 0x3FEFE31D,0x98E14314,
	0x3FB5C28F,0x5C28F5C3, 0x3FEFE26C,0x9941E6CA,
	0x3FB60418,0x9374BC6A, 0x3FEFE1B9,0x82B3CC5F,
	0x3FB645A1,0xCAC08312, 0x3FEFE104,0x5542B06B,
	0x3FB6872B,0x020C49BA, 0x3FEFE04D,0x10FA7296,
	0x3FB6C8B4,0x39581062, 0x3FEFDF93,0xB5E71595,
	0x3FB70A3D,0x70A3D70A, 0x3FEFDED8,0x4414BF29,
	0x3FB74BC6,0xA7EF9DB2, 0x3FEFDE1A,0xBB8FB81D,
	0x3FB78D4F,0xDF3B645A, 0x3FEFDD5B,0x1C646C4A,
	0x3FB7CED9,0x16872B02, 0x3FEFDC99,0x669F6A90,
	0x3FB81062,0x4DD2F1AA, 0x3FEFDBD5,0x9A4D64DA,
	0x3FB851EB,0x851EB852, 0x3FEFDB0F,0xB77B301A,
	0x3FB89374,0xBC6A7EFA, 0x3FEFDA47,0xBE35C449,
	0x3FB8D4FD,0xF3B645A2, 0x3FEFD97D,0xAE8A3C69,
	0x3FB91687,0x2B020C4A, 0x3FEFD8B1,0x8885D67F,
	0x3FB95810,0x624DD2F2, 0x3FEFD7E3,0x4C35F398,
	0x3FB99999,0x9999999A, 0x3FEFD712,0xF9A817C1,
	0x3FB9DB22,0xD0E56042, 0x3FEFD640,0x90E9EA0C,
	0x3FBA1CAC,0x083126E9, 0x3FEFD56C,0x1209348F,
	0x3FBA5E35,0x3F7CED91, 0x3FEFD495,0x7D13E45F,
	0x3FBA9FBE,0x76C8B439, 0x3FEFD3BC,0xD2180992,
	0x3FBAE147,0xAE147AE1, 0x3FEFD2E2,0x1123D73D,
	0x3FBB22D0,0xE5604189, 0x3FEFD205,0x3A45A375,
	0x3FBB645A,0x1CAC0831, 0x3FEFD126,0x4D8BE74B,
	0x3FBBA5E3,0x53F7CED9, 0x3FEFD045,0x4B053ECD,
	0x3FBBE76C,0x8B439581, 0x3FEFCF62,0x32C06905,
	0x3FBC28F5,0xC28F5C29, 0x3FEFCE7D,0x04CC47F8,
	0x3FBC6A7E,0xF9DB22D1, 0x3FEFCD95,0xC137E0A5,
	0x3FBCAC08,0x3126E979, 0x3FEFCCAC,0x68125B02,
	0x3FBCED91,0x6872B021, 0x3FEFCBC0,0xF96B01FE,
	0x3FBD2F1A,0x9FBE76C9, 0x3FEFCAD3,0x7551437F,
	0x3FBD70A3,0xD70A3D71, 0x3FEFC9E3,0xDBD4B061,
	0x3FBDB22D,0x0E560419, 0x3FEFC8F2,0x2D04FC74,
	0x3FBDF3B6,0x45A1CAC1, 0x3FEFC7FE,0x68F1FE7B,
	0x3FBE353F,0x7CED9168, 0x3FEFC708,0x8FABB02E,
	0x3FBE76C8,0xB4395810, 0x3FEFC610,0xA1422E33,
	0x3FBEB851,0xEB851EB8, 0x3FEFC516,0x9DC5B825,
	0x3FBEF9DB,0x22D0E560, 0x3FEFC41A,0x8546B08B,
	0x3FBF3B64,0x5A1CAC08, 0x3FEFC31C,0x57D59CDC,
	0x3FBF7CED,0x916872B0, 0x3FEFC21C,0x1583257B,
	0x3FBFBE76,0xC8B43958, 0x3FEFC119,0xBE6015BA,
	0x3FC00000,0x00000000, 0x3FEFC015,0x527D5BD3,
	0x3FC020C4,0x9BA5E354, 0x3FEFBF0E,0xD1EC08ED,
	0x3FC04189,0x374BC6A8, 0x3FEFBE06,0x3CBD5114,
	0x3FC0624D,0xD2F1A9FC, 0x3FEFBCFB,0x93028B40,
	0x3FC08312,0x6E978D50, 0x3FEFBBEE,0xD4CD314D,
	0x3FC0A3D7,0x0A3D70A4, 0x3FEFBAE0,0x022EDFFE,
	0x3FC0C49B,0xA5E353F8, 0x3FEFB9CF,0x1B3956F8,
	0x3FC0E560,0x4189374C, 0x3FEFB8BC,0x1FFE78C7,
	0x3FC10624,0xDD2F1AA0, 0x3FEFB7A7,0x10904AD6,
	0x3FC126E9,0x78D4FDF4, 0x3FEFB68F,0xED00F571,
	0x3FC147AE,0x147AE148, 0x3FEFB576,0xB562C3C5,
	0x3FC16872,0xB020C49C, 0x3FEFB45B,0x69C823DD,
	0x3FC18937,0x4BC6A7F0, 0x3FEFB33E,0x0A43A6A1,
	0x3FC1A9FB,0xE76C8B44, 0x3FEFB21E,0x96E7FFD5,
	0x3FC1CAC0,0x83126E98, 0x3FEFB0FD,0x0FC80618,
	0x3FC1EB85,0x1EB851EC, 0x3FEFAFD9,0x74F6B2E2,
	0x3FC20C49,0xBA5E353F, 0x3FEFAEB3,0xC6872285,
	0x3FC22D0E,0x56041893, 0x3FEFAD8C,0x048C9427,
	0x3FC24DD2,0xF1A9FBE7, 0x3FEFAC62,0x2F1A69C7,
	0x3FC26E97,0x8D4FDF3B, 0x3FEFAB36,0x46442837,
	0x3FC28F5C,0x28F5C28F, 0x3FEFAA08,0x4A1D771C,
	0x3FC2B020,0xC49BA5E3, 0x3FEFA8D8,0x3ABA20EE,
	0x3FC2D0E5,0x60418937, 0x3FEFA7A6,0x182E12F5,
	0x3FC2F1A9,0xFBE76C8B, 0x3FEFA671,0xE28D5D49,
	0x3FC3126E,0x978D4FDF, 0x3FEFA53B,0x99EC32CE,
	0x3FC33333,0x33333333, 0x3FEFA403,0x3E5EE937,
	0x3FC353F7,0xCED91687, 0x3FEFA2C8,0xCFF9F903,
	0x3FC374BC,0x6A7EF9DB, 0x3FEFA18C,0x4ED1FD78,
	0x3FC39581,0x0624DD2F, 0x3FEFA04D,0xBAFBB4A7,
	0x3FC3B645,0xA1CAC083, 0x3FEF9F0D,0x148BFF67,
	0x3FC3D70A,0x3D70A3D7, 0x3FEF9DCA,0x5B97E158,
	0x3FC3F7CE,0xD916872B, 0x3FEF9C85,0x903480DA,
	0x3FC41893,0x74BC6A7F, 0x3FEF9B3E,0xB2772714,
	0x3FC43958,0x10624DD3, 0x3FEF99F5,0xC2753FED,
	0x3FC45A1C,0xAC083127, 0x3FEF98AA,0xC0445A0C,
	0x3FC47AE1,0x47AE147B, 0x3FEF975D,0xABFA26D9,
	0x3FC49BA5,0xE353F7CF, 0x3FEF960E,0x85AC7A78,
	0x3FC4BC6A,0x7EF9DB23, 0x3FEF94BD,0x4D714BC9,
	0x3FC4DD2F,0x1A9FBE77, 0x3FEF936A,0x035EB469,
	0x3FC4FDF3,0xB645A1CB, 0x3FEF9214,0xA78AF0AA,
	0x3FC51EB8,0x51EB851F, 0x3FEF90BD,0x3A0C5F9A,
	0x3FC53F7C,0xED916873, 0x3FEF8F63,0xBAF982FB,
	0x3FC56041,0x89374BC7, 0x3FEF8E08,0x2A68FF45,
	0x3FC58106,0x24DD2F1B, 0x3FEF8CAA,0x88719BA3,
	0x3FC5A1CA,0xC083126F, 0x3FEF8B4A,0xD52A41F1,
	0x3FC5C28F,0x5C28F5C3, 0x3FEF89E9,0x10A9FEBE,
	0x3FC5E353,0xF7CED917, 0x3FEF8885,0x3B080143,
	0x3FC60418,0x9374BC6A, 0x3FEF871F,0x545B9B6C,
	0x3FC624DD,0x2F1A9FBE, 0x3FEF85B7,0x5CBC41CE,
	0x3FC645A1,0xCAC08312, 0x3FEF844D,0x54418BA7,
	0x3FC66666,0x66666666, 0x3FEF82E1,0x3B0332E1,
	0x3FC6872B,0x020C49BA, 0x3FEF8173,0x1119140B,
	0x3FC6A7EF,0x9DB22D0E, 0x3FEF8002,0xD69B2E59,
	0x3FC6C8B4,0x39581062, 0x3FEF7E90,0x8BA1A3A6,
	0x3FC6E978,0xD4FDF3B6, 0x3FEF7D1C,0x3044B86C,
	0x3FC70A3D,0x70A3D70A, 0x3FEF7BA5,0xC49CD3C9,
	0x3FC72B02,0x0C49BA5E, 0x3FEF7A2D,0x48C27F77,
	0x3FC74BC6,0xA7EF9DB2, 0x3FEF78B2,0xBCCE67D1,
	0x3FC76C8B,0x43958106, 0x3FEF7736,0x20D95BCC,
	0x3FC78D4F,0xDF3B645A, 0x3FEF75B7,0x74FC4CF8,
	0x3FC7AE14,0x7AE147AE, 0x3FEF7436,0xB9504F7E,
	0x3FC7CED9,0x16872B02, 0x3FEF72B3,0xEDEE9A1D,
	0x3FC7EF9D,0xB22D0E56, 0x3FEF712F,0x12F0862C,
	0x3FC81062,0x4DD2F1AA, 0x3FEF6FA8,0x286F8F92,
	0x3FC83126,0xE978D4FE, 0x3FEF6E1F,0x2E8554CD,
	0x3FC851EB,0x851EB852, 0x3FEF6C94,0x254B96E7,
	0x3FC872B0,0x20C49BA6, 0x3FEF6B07,0x0CDC397C,
	0x3FC89374,0xBC6A7EFA, 0x3FEF6977,0xE55142B2,
	0x3FC8B439,0x5810624E, 0x3FEF67E6,0xAEC4DB3F,
	0x3FC8D4FD,0xF3B645A2, 0x3FEF6653,0x69514E5D,
	0x3FC8F5C2,0x8F5C28F6, 0x3FEF64BE,0x151109D3,
	0x3FC91687,0x2B020C4A, 0x3FEF6326,0xB21E9DEB,
	0x3FC9374B,0xC6A7EF9E, 0x3FEF618D,0x4094BD75,
	0x3FC95810,0x624DD2F2, 0x3FEF5FF1,0xC08E3DC4,
	0x3FC978D4,0xFDF3B646, 0x3FEF5E54,0x322616AA,
	0x3FC99999,0x9999999A, 0x3FEF5CB4,0x9577627A,
	0x3FC9BA5E,0x353F7CEE, 0x3FEF5B12,0xEA9D5E04,
	0x3FC9DB22,0xD0E56042, 0x3FEF596F,0x31B36894,
	0x3FC9FBE7,0x6C8B4396, 0x3FEF57C9,0x6AD503EF,
	0x3FCA1CAC,0x083126E9, 0x3FEF5621,0x961DD453,
	0x3FCA3D70,0xA3D70A3D, 0x3FEF5477,0xB3A9A074,
	0x3FCA5E35,0x3F7CED91, 0x3FEF52CB,0xC3945179,
	0x3FCA7EF9,0xDB22D0E5, 0x3FEF511D,0xC5F9F2FE,
	0x3FCA9FBE,0x76C8B439, 0x3FEF4F6D,0xBAF6B30E,
	0x3FCAC083,0x126E978D, 0x3FEF4DBB,0xA2A6E224,
	0x3FCAE147,0xAE147AE1, 0x3FEF4C07,0x7D26F327,
	0x3FCB020C,0x49BA5E35, 0x3FEF4A51,0x4A937B6A,
	0x3FCB22D0,0xE5604189, 0x3FEF4899,0x0B0932A8,
	0x3FCB4395,0x810624DD, 0x3FEF46DE,0xBEA4F306,
	0x3FCB645A,0x1CAC0831, 0x3FEF4522,0x6583B90D,
	0x3FCB851E,0xB851EB85, 0x3FEF4363,0xFFC2A3A8,
	0x3FCBA5E3,0x53F7CED9, 0x3FEF41A3,0x8D7EF428,
	0x3FCBC6A7,0xEF9DB22D, 0x3FEF3FE1,0x0ED60E39,
	0x3FCBE76C,0x8B439581, 0x3FEF3E1C,0x83E577E7,
	0x3FCC0831,0x26E978D5, 0x3FEF3C55,0xECCAD99C,
	0x3FCC28F5,0xC28F5C29, 0x3FEF3A8D,0x49A3FE19,
	0x3FCC49BA,0x5E353F7D, 0x3FEF38C2,0x9A8ED278,
	0x3FCC6A7E,0xF9DB22D1, 0x3FEF36F5,0xDFA96629,
	0x3FCC8B43,0x95810625, 0x3FEF3527,0x1911EAF1,
	0x3FCCAC08,0x3126E979, 0x3FEF3356,0x46E6B4E7,
	0x3FCCCCCC,0xCCCCCCCD, 0x3FEF3183,0x69463A71,
	0x3FCCED91,0x6872B021, 0x3FEF2FAE,0x804F1443,
	0x3FCD0E56,0x04189375, 0x3FEF2DD7,0x8C1FFD60,
	0x3FCD2F1A,0x9FBE76C9, 0x3FEF2BFE,0x8CD7D312,
	0x3FCD4FDF,0x3B645A1D, 0x3FEF2A23,0x829594EC,
	0x3FCD70A3,0xD70A3D71, 0x3FEF2846,0x6D7864C9,
	0x3FCD9168,0x72B020C5, 0x3FEF2667,0x4D9F86C4,
	0x3FCDB22D,0x0E560419, 0x3FEF2486,0x232A613F,
	0x3FCDD2F1,0xA9FBE76D, 0x3FEF22A2,0xEE387CD7,
	0x3FCDF3B6,0x45A1CAC1, 0x3FEF20BD,0xAEE9846C,
	0x3FCE147A,0xE147AE14, 0x3FEF1ED6,0x655D4515,
	0x3FCE353F,0x7CED9168, 0x3FEF1CED,0x11B3AE25,
	0x3FCE5604,0x189374BC, 0x3FEF1B01,0xB40CD128,
	0x3FCE76C8,0xB4395810, 0x3FEF1914,0x4C88E1DC,
	0x3FCE978D,0x4FDF3B64, 0x3FEF1724,0xDB483636,
	0x3FCEB851,0xEB851EB8, 0x3FEF1533,0x606B465A,
	0x3FCED916,0x872B020C, 0x3FEF133F,0xDC12AC9B,
	0x3FCEF9DB,0x22D0E560, 0x3FEF114A,0x4E5F257C,
	0x3FCF1A9F,0xBE76C8B4, 0x3FEF0F52,0xB7718FA7,
	0x3FCF3B64,0x5A1CAC08, 0x3FEF0D59,0x176AEBF1,
	0x3FCF5C28,0xF5C28F5C, 0x3FEF0B5D,0x6E6C5D55,
	0x3FCF7CED,0x916872B0, 0x3FEF095F,0xBC9728F3,
	0x3FCF9DB2,0x2D0E5604, 0x3FEF0760,0x020CB60C,
	0x3FCFBE76,0xC8B43958, 0x3FEF055E,0x3EEE8E03,
	0x3FCFDF3B,0x645A1CAC, 0x3FEF035A,0x735E5C56,
	0x3FD00000,0x00000000, 0x3FEF0154,0x9F7DEEA1,
	0x3FD01062,0x4DD2F1AA, 0x3FEEFF4C,0xC36F3499,
	0x3FD020C4,0x9BA5E354, 0x3FEEFD42,0xDF544009,
	0x3FD03126,0xE978D4FE, 0x3FEEFB36,0xF34F44D2,
	0x3FD04189,0x374BC6A8, 0x3FEEF928,0xFF8298E8,
	0x3FD051EB,0x851EB852, 0x3FEEF719,0x0410B44E,
	0x3FD0624D,0xD2F1A9FC, 0x3FEEF507,0x011C3117,
	0x3FD072B0,0x20C49BA6, 0x3FEEF2F2,0xF6C7CB60,
	0x3FD08312,0x6E978D50, 0x3FEEF0DC,0xE5366151,
	0x3FD09374,0xBC6A7EFA, 0x3FEEEEC4,0xCC8AF31A,
	0x3FD0A3D7,0x0A3D70A4, 0x3FEEECAA,0xACE8A2EF,
	0x3FD0B439,0x5810624E, 0x3FEEEA8E,0x8672B506,
	0x3FD0C49B,0xA5E353F8, 0x3FEEE870,0x594C8F97,
	0x3FD0D4FD,0xF3B645A2, 0x3FEEE650,0x2599BAD8,
	0x3FD0E560,0x4189374C, 0x3FEEE42D,0xEB7DE0F9,
	0x3FD0F5C2,0x8F5C28F6, 0x3FEEE209,0xAB1CCE26,
	0x3FD10624,0xDD2F1AA0, 0x3FEEDFE3,0x649A7081,
	0x3FD11687,0x2B020C4A, 0x3FEEDDBB,0x181AD820,
	0x3FD126E9,0x78D4FDF4, 0x3FEEDB90,0xC5C2370D,
	0x3FD1374B,0xC6A7EF9E, 0x3FEED964,0x6DB4E141,
	0x3FD147AE,0x147AE148, 0x3FEED736,0x10174CA3,
	0x3FD15810,0x624DD2F2, 0x3FEED505,0xAD0E1104,
	0x3FD16872,0xB020C49C, 0x3FEED2D3,0x44BDE821,
	0x3FD178D4,0xFDF3B646, 0x3FEED09E,0xD74BAD9A,
	0x3FD18937,0x4BC6A7F0, 0x3FEECE68,0x64DC5EF5,
	0x3FD19999,0x9999999A, 0x3FEECC2F,0xED951B99,
	0x3FD1A9FB,0xE76C8B44, 0x3FEEC9F5,0x719B24CC,
	0x3FD1BA5E,0x353F7CEE, 0x3FEEC7B8,0xF113DDB3,
	0x3FD1CAC0,0x83126E98, 0x3FEEC57A,0x6C24CB49,
	0x3FD1DB22,0xD0E56042, 0x3FEEC339,0xE2F39465,
	0x3FD1EB85,0x1EB851EC, 0x3FEEC0F7,0x55A601B1,
	0x3FD1FBE7,0x6C8B4396, 0x3FEEBEB2,0xC461FDAB,
	0x3FD20C49,0xBA5E353F, 0x3FEEBC6C,0x2F4D94A1,
	0x3FD21CAC,0x083126E9, 0x3FEEBA23,0x968EF4AE,
	0x3FD22D0E,0x56041893, 0x3FEEB7D8,0xFA4C6DB9,
	0x3FD23D70,0xA3D70A3D, 0x3FEEB58C,0x5AAC7174,
	0x3FD24DD2,0xF1A9FBE7, 0x3FEEB33D,0xB7D59355,
	0x3FD25E35,0x3F7CED91, 0x3FEEB0ED,0x11EE8895,
	0x3FD26E97,0x8D4FDF3B, 0x3FEEAE9A,0x691E2832,
	0x3FD27EF9,0xDB22D0E5, 0x3FEEAC45,0xBD8B6AE5,
	0x3FD28F5C,0x28F5C28F, 0x3FEEA9EF,0x0F5D6B26,
	0x3FD29FBE,0x76C8B439, 0x3FEEA796,0x5EBB6524,
	0x3FD2B020,0xC49BA5E3, 0x3FEEA53B,0xABCCB6C8,
	0x3FD2C083,0x126E978D, 0x3FEEA2DE,0xF6B8DFAE,
	0x3FD2D0E5,0x60418937, 0x3FEEA080,0x3FA78123,
	0x3FD2E147,0xAE147AE1, 0x3FEE9E1F,0x86C05E25,
	0x3FD2F1A9,0xFBE76C8B, 0x3FEE9BBC,0xCC2B5B5E,
	0x3FD3020C,0x49BA5E35, 0x3FEE9958,0x10107F22,
	0x3FD3126E,0x978D4FDF, 0x3FEE96F1,0x5297F16D,
	0x3FD322D0,0xE5604189, 0x3FEE9488,0x93E9FBDF,
	0x3FD33333,0x33333333, 0x3FEE921D,0xD42F09BA,
	0x3FD34395,0x810624DD, 0x3FEE8FB1,0x138FA7E2,
	0x3FD353F7,0xCED91687, 0x3FEE8D42,0x523484D6,
	0x3FD3645A,0x1CAC0831, 0x3FEE8AD1,0x904670AE,
	0x3FD374BC,0x6A7EF9DB, 0x3FEE885E,0xCDEE5D1C,
	0x3FD3851E,0xB851EB85, 0x3FEE85EA,0x0B555D66,
	0x3FD39581,0x0624DD2F, 0x3FEE8373,0x48A4A663,
	0x3FD3A5E3,0x53F7CED9, 0x3FEE80FA,0x86058E7B,
	0x3FD3B645,0xA1CAC083, 0x3FEE7E7F,0xC3A18DA3,
	0x3FD3C6A7,0xEF9DB22D, 0x3FEE7C03,0x01A23D59,
	0x3FD3D70A,0x3D70A3D7, 0x3FEE7984,0x403158A2,
	0x3FD3E76C,0x8B439581, 0x3FEE7703,0x7F78BC09,
	0x3FD3F7CE,0xD916872B, 0x3FEE7480,0xBFA2659B,
	0x3FD40831,0x26E978D5, 0x3FEE71FC,0x00D874E1,
	0x3FD41893,0x74BC6A7F, 0x3FEE6F75,0x43452AE5,
	0x3FD428F5,0xC28F5C29, 0x3FEE6CEC,0x8712EA26,
	0x3FD43958,0x10624DD3, 0x3FEE6A61,0xCC6C369E,
	0x3FD449BA,0x5E353F7D, 0x3FEE67D5,0x137BB5B8,
	0x3FD45A1C,0xAC083127, 0x3FEE6546,0x5C6C2E51,
	0x3FD46A7E,0xF9DB22D1, 0x3FEE62B5,0xA76888B5,
	0x3FD47AE1,0x47AE147B, 0x3FEE6022,0xF49BCE9B,
	0x3FD48B43,0x95810625, 0x3FEE5D8E,0x44312B24,
	0x3FD49BA5,0xE353F7CF, 0x3FEE5AF7,0x9653EAD4,
	0x3FD4AC08,0x3126E979, 0x3FEE585E,0xEB2F7B96,
	0x3FD4BC6A,0x7EF9DB23, 0x3FEE55C4,0x42EF6CB2,
	0x3FD4CCCC,0xCCCCCCCD, 0x3FEE5327,0x9DBF6ED0,
	0x3FD4DD2F,0x1A9FBE77, 0x3FEE5088,0xFBCB53F0,
	0x3FD4ED91,0x6872B021, 0x3FEE4DE8,0x5D3F0F6C,
	0x3FD4FDF3,0xB645A1CB, 0x3FEE4B45,0xC246B5F1,
	0x3FD50E56,0x04189375, 0x3FEE48A1,0x2B0E7D7F,
	0x3FD51EB8,0x51EB851F, 0x3FEE45FA,0x97C2BD65,
	0x3FD52F1A,0x9FBE76C9, 0x3FEE4352,0x088FEE3D,
	0x3FD53F7C,0xED916873, 0x3FEE40A7,0x7DA2A9EC,
	0x3FD54FDF,0x3B645A1D, 0x3FEE3DFA,0xF727AB9B,
	0x3FD56041,0x89374BC7, 0x3FEE3B4C,0x754BCFB9,
	0x3FD570A3,0xD70A3D71, 0x3FEE389B,0xF83C13F4,
	0x3FD58106,0x24DD2F1B, 0x3FEE35E9,0x80259736,
	0x3FD59168,0x72B020C5, 0x3FEE3335,0x0D3599A5,
	0x3FD5A1CA,0xC083126F, 0x3FEE307E,0x9F997CA0,
	0x3FD5B22D,0x0E560419, 0x3FEE2DC6,0x377EC2B8,
	0x3FD5C28F,0x5C28F5C3, 0x3FEE2B0B,0xD5130FB1,
	0x3FD5D2F1,0xA9FBE76D, 0x3FEE284F,0x7884287D,
	0x3FD5E353,0xF7CED917, 0x3FEE2591,0x21FFF339,
	0x3FD5F3B6,0x45A1CAC1, 0x3FEE22D0,0xD1B4772D,
	0x3FD60418,0x9374BC6A, 0x3FEE200E,0x87CFDCC3,
	0x3FD6147A,0xE147AE14, 0x3FEE1D4A,0x44806D8A,
	0x3FD624DD,0x2F1A9FBE, 0x3FEE1A84,0x07F49430,
	0x3FD6353F,0x7CED9168, 0x3FEE17BB,0xD25ADC7F,
	0x3FD645A1,0xCAC08312, 0x3FEE14F1,0xA3E1F35C,
	0x3FD65604,0x189374BC, 0x3FEE1225,0x7CB8A6BF,
	0x3FD66666,0x66666666, 0x3FEE0F57,0x5D0DE5B7,
	0x3FD676C8,0xB4395810, 0x3FEE0C87,0x4510C061,
	0x3FD6872B,0x020C49BA, 0x3FEE09B5,0x34F067E8,
	0x3FD6978D,0x4FDF3B64, 0x3FEE06E1,0x2CDC2E80,
	0x3FD6A7EF,0x9DB22D0E, 0x3FEE040B,0x2D038765,
	0x3FD6B851,0xEB851EB8, 0x3FEE0133,0x359606D7,
	0x3FD6C8B4,0x39581062, 0x3FEDFE59,0x46C36215,
	0x3FD6D916,0x872B020C, 0x3FEDFB7D,0x60BB6F5D,
	0x3FD6E978,0xD4FDF3B6, 0x3FEDF89F,0x83AE25E7,
	0x3FD6F9DB,0x22D0E560, 0x3FEDF5BF,0xAFCB9DE3,
	0x3FD70A3D,0x70A3D70A, 0x3FEDF2DD,0xE5441074,
	0x3FD71A9F,0xBE76C8B4, 0x3FEDEFFA,0x2447D7B0,
	0x3FD72B02,0x0C49BA5E, 0x3FEDED14,0x6D076E97,
	0x3FD73B64,0x5A1CAC08, 0x3FEDEA2C,0xBFB37117,
	0x3FD74BC6,0xA7EF9DB2, 0x3FEDE743,0x1C7C9C04,
	0x3FD75C28,0xF5C28F5C, 0x3FEDE457,0x8393CD18,
	0x3FD76C8B,0x43958106, 0x3FEDE169,0xF52A02EB,
	0x3FD77CED,0x916872B0, 0x3FEDDE7A,0x71705CF6,
	0x3FD78D4F,0xDF3B645A, 0x3FEDDB88,0xF8981B8A,
	0x3FD79DB2,0x2D0E5604, 0x3FEDD895,0x8AD29FD1,
	0x3FD7AE14,0x7AE147AE, 0x3FEDD5A0,0x28516BC9,
	0x3FD7BE76,0xC8B43958, 0x3FEDD2A8,0xD1462240,
	0x3FD7CED9,0x16872B02, 0x3FEDCFAF,0x85E286D2,
	0x3FD7DF3B,0x645A1CAC, 0x3FEDCCB4,0x46587DE7,
	0x3FD7EF9D,0xB22D0E56, 0x3FEDC9B7,0x12DA0CAC,
	0x3FD80000,0x00000000, 0x3FEDC6B7,0xEB995912,
	0x3FD81062,0x4DD2F1AA, 0x3FEDC3B6,0xD0C8A9CC,
	0x3FD820C4,0x9BA5E354, 0x3FEDC0B3,0xC29A664A,
	0x3FD83126,0xE978D4FE, 0x3FEDBDAE,0xC14116B4,
	0x3FD84189,0x374BC6A8, 0x3FEDBAA7,0xCCEF63EB,
	0x3FD851EB,0x851EB852, 0x3FEDB79E,0xE5D81782,
	0x3FD8624D,0xD2F1A9FC, 0x3FEDB494,0x0C2E1BBD,
	0x3FD872B0,0x20C49BA6, 0x3FEDB187,0x40247B8B,
	0x3FD88312,0x6E978D50, 0x3FEDAE78,0x81EE6287,
	0x3FD89374,0xBC6A7EFA, 0x3FEDAB67,0xD1BF1CEE,
	0x3FD8A3D7,0x0A3D70A4, 0x3FEDA855,0x2FCA17A5,
	0x3FD8B439,0x5810624E, 0x3FEDA540,0x9C42E02B,
	0x3FD8C49B,0xA5E353F8, 0x3FEDA22A,0x175D249D,
	0x3FD8D4FD,0xF3B645A2, 0x3FED9F11,0xA14CB3B2,
	0x3FD8E560,0x4189374C, 0x3FED9BF7,0x3A457CB3,
	0x3FD8F5C2,0x8F5C28F6, 0x3FED98DA,0xE27B8F7E,
	0x3FD90624,0xDD2F1AA0, 0x3FED95BC,0x9A231C7C,
	0x3FD91687,0x2B020C4A, 0x3FED929C,0x617074A3,
	0x3FD926E9,0x78D4FDF4, 0x3FED8F7A,0x3898096F,
	0x3FD9374B,0xC6A7EF9E, 0x3FED8C56,0x1FCE6CE3,
	0x3FD947AE,0x147AE148, 0x3FED8930,0x1748517E,
	0x3FD95810,0x624DD2F2, 0x3FED8608,0x1F3A8A3F,
	0x3FD96872,0xB020C49C, 0x3FED82DE,0x37DA0A9E,
	0x3FD978D4,0xFDF3B646, 0x3FED7FB2,0x615BE68A,
	0x3FD98937,0x4BC6A7F0, 0x3FED7C84,0x9BF55262,
	0x3FD99999,0x9999999A, 0x3FED7954,0xE7DBA2F8,
	0x3FD9A9FB,0xE76C8B44, 0x3FED7623,0x45444D86,
	0x3FD9BA5E,0x353F7CEE, 0x3FED72EF,0xB464E7B0,
	0x3FD9CAC0,0x83126E98, 0x3FED6FBA,0x35732780,
	0x3FD9DB22,0xD0E56042, 0x3FED6C82,0xC8A4E35E,
	0x3FD9EB85,0x1EB851EC, 0x3FED6949,0x6E301211,
	0x3FD9FBE7,0x6C8B4396, 0x3FED660E,0x264ACABC,
	0x3FDA0C49,0xBA5E353F, 0x3FED62D0,0xF12B44D6,
	0x3FDA1CAC,0x083126E9, 0x3FED5F91,0xCF07D82A,
	0x3FDA2D0E,0x56041893, 0x3FED5C50,0xC016FCD1,
	0x3FDA3D70,0xA3D70A3D, 0x3FED590D,0xC48F4B33,
	0x3FDA4DD2,0xF1A9FBE7, 0x3FED55C8,0xDCA77BFD,
	0x3FDA5E35,0x3F7CED91, 0x3FED5282,0x08966824,
	0x3FDA6E97,0x8D4FDF3B, 0x3FED4F39,0x489308DA,
	0x3FDA7EF9,0xDB22D0E5, 0x3FED4BEE,0x9CD47791,
	0x3FDA8F5C,0x28F5C28F, 0x3FED48A2,0x0591EDF6,
	0x3FDA9FBE,0x76C8B439, 0x3FED4553,0x8302C5E9,
	0x3FDAB020,0xC49BA5E3, 0x3FED4203,0x155E7980,
	0x3FDAC083,0x126E978D, 0x3FED3EB0,0xBCDCA2FE,
	0x3FDAD0E5,0x60418937, 0x3FED3B5C,0x79B4FCD2,
	0x3FDAE147,0xAE147AE1, 0x3FED3806,0x4C1F6191,
	0x3FDAF1A9,0xFBE76C8B, 0x3FED34AE,0x3453CBF7,
	0x3FDB020C,0x49BA5E35, 0x3FED3154,0x328A56DF,
	0x3FDB126E,0x978D4FDF, 0x3FED2DF8,0x46FB3D40,
	0x3FDB22D0,0xE5604189, 0x3FED2A9A,0x71DEDA2B,
	0x3FDB3333,0x33333333, 0x3FED273A,0xB36DA8C6,
	0x3FDB4395,0x810624DD, 0x3FED23D9,0x0BE04448,
	0x3FDB53F7,0xCED91687, 0x3FED2075,0x7B6F67F6,
	0x3FDB645A,0x1CAC0831, 0x3FED1D10,0x0253EF22,
	0x3FDB74BC,0x6A7EF9DB, 0x3FED19A8,0xA0C6D51F,
	0x3FDB851E,0xB851EB85, 0x3FED163F,0x57013548,
	0x3FDB9581,0x0624DD2F, 0x3FED12D4,0x253C4AF5,
	0x3FDBA5E3,0x53F7CED9, 0x3FED0F67,0x0BB17177,
	0x3FDBB645,0xA1CAC083, 0x3FED0BF8,0x0A9A241B,
	0x3FDBC6A7,0xEF9DB22D, 0x3FED0887,0x222FFE1D,
	0x3FDBD70A,0x3D70A3D7, 0x3FED0514,0x52ACBAAD,
	0x3FDBE76C,0x8B439581, 0x3FED019F,0x9C4A34E4,
	0x3FDBF7CE,0xD916872B, 0x3FECFE28,0xFF4267C5,
	0x3FDC0831,0x26E978D5, 0x3FECFAB0,0x7BCF6E38,
	0x3FDC1893,0x74BC6A7F, 0x3FECF736,0x122B8305,
	0x3FDC28F5,0xC28F5C29, 0x3FECF3B9,0xC29100CF,
	0x3FDC3958,0x10624DD3, 0x3FECF03B,0x8D3A6217,
	0x3FDC49BA,0x5E353F7D, 0x3FECECBB,0x7262412E,
	0x3FDC5A1C,0xAC083127, 0x3FECE939,0x72435839,
	0x3FDC6A7E,0xF9DB22D1, 0x3FECE5B5,0x8D18812B,
	0x3FDC7AE1,0x47AE147B, 0x3FECE22F,0xC31CB5C0,
	0x3FDC8B43,0x95810625, 0x3FECDEA8,0x148B0F7A,
	0x3FDC9BA5,0xE353F7CF, 0x3FECDB1E,0x819EC79D,
	0x3FDCAC08,0x3126E979, 0x3FECD793,0x0A93372B,
	0x3FDCBC6A,0x7EF9DB23, 0x3FECD405,0xAFA3D6DF,
	0x3FDCCCCC,0xCCCCCCCD, 0x3FECD076,0x710C3F2D,
	0x3FDCDD2F,0x1A9FBE77, 0x3FECCCE5,0x4F08283A,
	0x3FDCED91,0x6872B021, 0x3FECC952,0x49D369D9,
	0x3FDCFDF3,0xB645A1CB, 0x3FECC5BD,0x61A9FB88,
	0x3FDD0E56,0x04189375, 0x3FECC226,0x96C7F46C,
	0x3FDD1EB8,0x51EB851F, 0x3FECBE8D,0xE9698B4D,
	0x3FDD2F1A,0x9FBE76C9, 0x3FECBAF3,0x59CB1690,
	0x3FDD3F7C,0xED916873, 0x3FECB756,0xE8290C37,
	0x3FDD4FDF,0x3B645A1D, 0x3FECB3B8,0x94C001DA,
	0x3FDD6041,0x89374BC7, 0x3FECB018,0x5FCCACA2,
	0x3FDD70A3,0xD70A3D71, 0x3FECAC76,0x498BE14B,
	0x3FDD8106,0x24DD2F1B, 0x3FECA8D2,0x523A9419,
	0x3FDD9168,0x72B020C5, 0x3FECA52C,0x7A15D8D7,
	0x3FDDA1CA,0xC083126F, 0x3FECA184,0xC15AE2D3,
	0x3FDDB22D,0x0E560419, 0x3FEC9DDB,0x284704DC,
	0x3FDDC28F,0x5C28F5C3, 0x3FEC9A2F,0xAF17B138,
	0x3FDDD2F1,0xA9FBE76D, 0x3FEC9682,0x560A79A8,
	0x3FDDE353,0xF7CED917, 0x3FEC92D3,0x1D5D0F5D,
	0x3FDDF3B6,0x45A1CAC1, 0x3FEC8F22,0x054D42F8,
	0x3FDE0418,0x9374BC6A, 0x3FEC8B6F,0x0E190485,
	0x3FDE147A,0xE147AE14, 0x3FEC87BA,0x37FE6375,
	0x3FDE24DD,0x2F1A9FBE, 0x3FEC8403,0x833B8E9D,
	0x3FDE353F,0x7CED9168, 0x3FEC804A,0xF00ED431,
	0x3FDE45A1,0xCAC08312, 0x3FEC7C90,0x7EB6A1BD,
	0x3FDE5604,0x189374BC, 0x3FEC78D4,0x2F718428,
	0x3FDE6666,0x66666666, 0x3FEC7516,0x027E27A5,
	0x3FDE76C8,0xB4395810, 0x3FEC7155,0xF81B57BB,
	0x3FDE872B,0x020C49BA, 0x3FEC6D94,0x1087FF37,
	0x3FDE978D,0x4FDF3B64, 0x3FEC69D0,0x4C03282F,
	0x3FDEA7EF,0x9DB22D0E, 0x3FEC660A,0xAACBFBF7,
	0x3FDEB851,0xEB851EB8, 0x3FEC6243,0x2D21C324,
	0x3FDEC8B4,0x39581062, 0x3FEC5E79,0xD343E584,
	0x3FDED916,0x872B020C, 0x3FEC5AAE,0x9D71EA19,
	0x3FDEE978,0xD4FDF3B6, 0x3FEC56E1,0x8BEB7717,
	0x3FDEF9DB,0x22D0E560, 0x3FEC5312,0x9EF051DE,
	0x3FDF0A3D,0x70A3D70A, 0x3FEC4F41,0xD6C05EF9,
	0x3FDF1A9F,0xBE76C8B4, 0x3FEC4B6F,0x339BA216,
	0x3FDF2B02,0x0C49BA5E, 0x3FEC479A,0xB5C23E03,
	0x3FDF3B64,0x5A1CAC08, 0x3FEC43C4,0x5D7474AC,
	0x3FDF4BC6,0xA7EF9DB2, 0x3FEC3FEC,0x2AF2A713,
	0x3FDF5C28,0xF5C28F5C, 0x3FEC3C12,0x1E7D554F,
	0x3FDF6C8B,0x43958106, 0x3FEC3836,0x38551E88,
	0x3FDF7CED,0x916872B0, 0x3FEC3458,0x78BAC0EE,
	0x3FDF8D4F,0xDF3B645A, 0x3FEC3078,0xDFEF19BA,
	0x3FDF9DB2,0x2D0E5604, 0x3FEC2C97,0x6E332528,
	0x3FDFAE14,0x7AE147AE, 0x3FEC28B4,0x23C7FE73,
	0x3FDFBE76,0xC8B43958, 0x3FEC24CF,0x00EEDFCF,
	0x3FDFCED9,0x16872B02, 0x3FEC20E8,0x05E92266,
	0x3FDFDF3B,0x645A1CAC, 0x3FEC1CFF,0x32F83E56,
	0x3FDFEF9D,0xB22D0E56, 0x3FEC1914,0x885DCAA8,
	0x3FE00000,0x00000000, 0x3FEC1528,0x065B7D50,
	0x3FE00831,0x26E978D5, 0x3FEC1139,0xAD332B24,
	0x3FE01062,0x4DD2F1AA, 0x3FEC0D49,0x7D26C7DF,
	0x3FE01893,0x74BC6A7F, 0x3FEC0957,0x76786614,
	0x3FE020C4,0x9BA5E354, 0x3FEC0563,0x996A3730,
	0x3FE028F5,0xC28F5C29, 0x3FEC016D,0xE63E8B74,
	0x3FE03126,0xE978D4FE, 0x3FEBFD76,0x5D37D1EF,
	0x3FE03958,0x10624DD3, 0x3FEBF97C,0xFE98987C,
	0x3FE04189,0x374BC6A8, 0x3FEBF581,0xCAA38BBA,
	0x3FE049BA,0x5E353F7D, 0x3FEBF184,0xC19B770F,
	0x3FE051EB,0x851EB852, 0x3FEBED85,0xE3C34499,
	0x3FE05A1C,0xAC083127, 0x3FEBE985,0x315DFD33,
	0x3FE0624D,0xD2F1A9FC, 0x3FEBE582,0xAAAEC86D,
	0x3FE06A7E,0xF9DB22D1, 0x3FEBE17E,0x4FF8EC86,
	0x3FE072B0,0x20C49BA6, 0x3FEBDD78,0x217FCE6A,
	0x3FE07AE1,0x47AE147B, 0x3FEBD970,0x1F86F1AC,
	0x3FE08312,0x6E978D50, 0x3FEBD566,0x4A51F884,
	0x3FE08B43,0x95810625, 0x3FEBD15A,0xA224A3C8,
	0x3FE09374,0xBC6A7EFA, 0x3FEBCD4D,0x2742D2E7,
	0x3FE09BA5,0xE353F7CF, 0x3FEBC93D,0xD9F083E8,
	0x3FE0A3D7,0x0A3D70A4, 0x3FEBC52C,0xBA71D363,
	0x3FE0AC08,0x3126E979, 0x3FEBC119,0xC90AFC7D,
	0x3FE0B439,0x5810624E, 0x3FEBBD05,0x060058E4,
	0x3FE0BC6A,0x7EF9DB23, 0x3FEBB8EE,0x719660C9,
	0x3FE0C49B,0xA5E353F8, 0x3FEBB4D6,0x0C11AADD,
	0x3FE0CCCC,0xCCCCCCCD, 0x3FEBB0BB,0xD5B6EC4E,
	0x3FE0D4FD,0xF3B645A2, 0x3FEBAC9F,0xCECAF8BF,
	0x3FE0DD2F,0x1A9FBE77, 0x3FEBA881,0xF792C244,
	0x3FE0E560,0x4189374C, 0x3FEBA462,0x50535960,
	0x3FE0ED91,0x6872B021, 0x3FEBA040,0xD951ED01,
	0x3FE0F5C2,0x8F5C28F6, 0x3FEB9C1D,0x92D3CA76,
	0x3FE0FDF3,0xB645A1CB, 0x3FEB97F8,0x7D1E5D70,
	0x3FE10624,0xDD2F1AA0, 0x3FEB93D1,0x98772FFB,
	0x3FE10E56,0x04189375, 0x3FEB8FA8,0xE523EA7B,
	0x3FE11687,0x2B020C4A, 0x3FEB8B7E,0x636A53A4,
	0x3FE11EB8,0x51EB851F, 0x3FEB8752,0x1390507A,
	0x3FE126E9,0x78D4FDF4, 0x3FEB8323,0xF5DBE44A,
	0x3FE12F1A,0x9FBE76C9, 0x3FEB7EF4,0x0A9330A3,
	0x3FE1374B,0xC6A7EF9E, 0x3FEB7AC2,0x51FC7558,
	0x3FE13F7C,0xED916873, 0x3FEB768E,0xCC5E1074,
	0x3FE147AE,0x147AE148, 0x3FEB7259,0x79FE7E3C,
	0x3FE14FDF,0x3B645A1D, 0x3FEB6E22,0x5B245923,
	0x3FE15810,0x624DD2F2, 0x3FEB69E9,0x701659CE,
	0x3FE16041,0x89374BC7, 0x3FEB65AE,0xB91B5708,
	0x3FE16872,0xB020C49C, 0x3FEB6172,0x367A45C0,
	0x3FE170A3,0xD70A3D71, 0x3FEB5D33,0xE87A3908,
	0x3FE178D4,0xFDF3B646, 0x3FEB58F3,0xCF62620A,
	0x3FE18106,0x24DD2F1B, 0x3FEB54B1,0xEB7A1006,
	0x3FE18937,0x4BC6A7F0, 0x3FEB506E,0x3D08B04F,
	0x3FE19168,0x72B020C5, 0x3FEB4C28,0xC455CE45,
	0x3FE19999,0x9999999A, 0x3FEB47E1,0x81A91350,
	0x3FE1A1CA,0xC083126F, 0x3FEB4398,0x754A46DB,
	0x3FE1A9FB,0xE76C8B44, 0x3FEB3F4D,0x9F814E51,
	0x3FE1B22D,0x0E560419, 0x3FEB3B01,0x00962D16,
	0x3FE1BA5E,0x353F7CEE, 0x3FEB36B2,0x98D10483,
	0x3FE1C28F,0x5C28F5C3, 0x3FEB3262,0x687A13E3,
	0x3FE1CAC0,0x83126E98, 0x3FEB2E10,0x6FD9B86D,
	0x3FE1D2F1,0xA9FBE76D, 0x3FEB29BC,0xAF386D3F,
	0x3FE1DB22,0xD0E56042, 0x3FEB2567,0x26DECB58,
	0x3FE1E353,0xF7CED917, 0x3FEB210F,0xD7158997,
	0x3FE1EB85,0x1EB851EC, 0x3FEB1CB6,0xC0257CB2,
	0x3FE1F3B6,0x45A1CAC1, 0x3FEB185B,0xE2579735,
	0x3FE1FBE7,0x6C8B4396, 0x3FEB13FF,0x3DF4E979,
	0x3FE20418,0x9374BC6A, 0x3FEB0FA0,0xD346A1A5,
	0x3FE20C49,0xBA5E353F, 0x3FEB0B40,0xA2960BA2,
	0x3FE2147A,0xE147AE14, 0x3FEB06DE,0xAC2C911D,
	0x3FE21CAC,0x083126E9, 0x3FEB027A,0xF053B97E,
	0x3FE224DD,0x2F1A9FBE, 0x3FEAFE15,0x6F5529E3,
	0x3FE22D0E,0x56041893, 0x3FEAF9AE,0x297AA520,
	0x3FE2353F,0x7CED9168, 0x3FEAF545,0x1F0E0BB3,
	0x3FE23D70,0xA3D70A3D, 0x3FEAF0DA,0x50595BC6,
	0x3FE245A1,0xCAC08312, 0x3FEAEC6D,0xBDA6B124,
	0x3FE24DD2,0xF1A9FBE7, 0x3FEAE7FF,0x6740453A,
	0x3FE25604,0x189374BC, 0x3FEAE38F,0x4D706F0E,
	0x3FE25E35,0x3F7CED91, 0x3FEADF1D,0x7081A33B,
	0x3FE26666,0x66666666, 0x3FEADAA9,0xD0BE73ED,
	0x3FE26E97,0x8D4FDF3B, 0x3FEAD634,0x6E7190DD,
	0x3FE276C8,0xB4395810, 0x3FEAD1BD,0x49E5C747,
	0x3FE27EF9,0xDB22D0E5, 0x3FEACD44,0x636601EE,
	0x3FE2872B,0x020C49BA, 0x3FEAC8C9,0xBB3D490D,
	0x3FE28F5C,0x28F5C28F, 0x3FEAC44D,0x51B6C25B,
	0x3FE2978D,0x4FDF3B64, 0x3FEABFCF,0x271DB100,
	0x3FE29FBE,0x76C8B439, 0x3FEABB4F,0x3BBD7593,
	0x3FE2A7EF,0x9DB22D0E, 0x3FEAB6CD,0x8FE18E13,
	0x3FE2B020,0xC49BA5E3, 0x3FEAB24A,0x23D595E4,
	0x3FE2B851,0xEB851EB8, 0x3FEAADC4,0xF7E545CB,
	0x3FE2C083,0x126E978D, 0x3FEAA93E,0x0C5C73E5,
	0x3FE2C8B4,0x39581062, 0x3FEAA4B5,0x618713A5,
	0x3FE2D0E5,0x60418937, 0x3FEAA02A,0xF7B135D0,
	0x3FE2D916,0x872B020C, 0x3FEA9B9E,0xCF270874,
	0x3FE2E147,0xAE147AE1, 0x3FEA9710,0xE834D6E7,
	0x3FE2E978,0xD4FDF3B6, 0x3FEA9281,0x432709C0,
	0x3FE2F1A9,0xFBE76C8B, 0x3FEA8DEF,0xE04A26D3,
	0x3FE2F9DB,0x22D0E560, 0x3FEA895C,0xBFEAD12A,
	0x3FE3020C,0x49BA5E35, 0x3FEA84C7,0xE255C904,
	0x3FE30A3D,0x70A3D70A, 0x3FEA8031,0x47D7EBCB,
	0x3FE3126E,0x978D4FDF, 0x3FEA7B98,0xF0BE3412,
	0x3FE31A9F,0xBE76C8B4, 0x3FEA76FE,0xDD55B98F,
	0x3FE322D0,0xE5604189, 0x3FEA7263,0x0DEBB117,
	0x3FE32B02,0x0C49BA5E, 0x3FEA6DC5,0x82CD6C99,
	0x3FE33333,0x33333333, 0x3FEA6926,0x3C485B15,
	0x3FE33B64,0x5A1CAC08, 0x3FEA6485,0x3AAA089D,
	0x3FE34395,0x810624DD, 0x3FEA5FE2,0x7E401E4C,
	0x3FE34BC6,0xA7EF9DB2, 0x3FEA5B3E,0x07586242,
	0x3FE353F7,0xCED91687, 0x3FEA5697,0xD640B79F,
	0x3FE35C28,0xF5C28F5C, 0x3FEA51EF,0xEB471E7C,
	0x3FE3645A,0x1CAC0831, 0x3FEA4D46,0x46B9B3EA,
	0x3FE36C8B,0x43958106, 0x3FEA489A,0xE8E6B1E8,
	0x3FE374BC,0x6A7EF9DB, 0x3FEA43ED,0xD21C6F63,
	0x3FE37CED,0x916872B0, 0x3FEA3F3F,0x02A9602C,
	0x3FE3851E,0xB851EB85, 0x3FEA3A8E,0x7ADC14F6,
	0x3FE38D4F,0xDF3B645A, 0x3FEA35DC,0x3B033B50,
	0x3FE39581,0x0624DD2F, 0x3FEA3128,0x436D9DA0,
	0x3FE39DB2,0x2D0E5604, 0x3FEA2C72,0x946A231B,
	0x3FE3A5E3,0x53F7CED9, 0x3FEA27BB,0x2E47CFC6,
	0x3FE3AE14,0x7AE147AE, 0x3FEA2302,0x1155C46B,
	0x3FE3B645,0xA1CAC083, 0x3FEA1E47,0x3DE33E97,
	0x3FE3BE76,0xC8B43958, 0x3FEA198A,0xB43F9893,
	0x3FE3C6A7,0xEF9DB22D, 0x3FEA14CC,0x74BA4961,
	0x3FE3CED9,0x16872B02, 0x3FEA100C,0x7FA2E4B4,
	0x3FE3D70A,0x3D70A3D7, 0x3FEA0B4A,0xD5491AEC,
	0x3FE3DF3B,0x645A1CAC, 0x3FEA0687,0x75FCB914,
	0x3FE3E76C,0x8B439581, 0x3FEA01C2,0x620DA8D5,
	0x3FE3EF9D,0xB22D0E56, 0x3FE9FCFB,0x99CBF07A,
	0x3FE3F7CE,0xD916872B, 0x3FE9F833,0x1D87B2E3,
	0x3FE40000,0x00000000, 0x3FE9F368,0xED912F85,
	0x3FE40831,0x26E978D5, 0x3FE9EE9D,0x0A38C262,
	0x3FE41062,0x4DD2F1AA, 0x3FE9E9CF,0x73CEE405,
	0x3FE41893,0x74BC6A7F, 0x3FE9E500,0x2AA4297B,
	0x3FE420C4,0x9BA5E354, 0x3FE9E02F,0x2F094451,
	0x3FE428F5,0xC28F5C29, 0x3FE9DB5C,0x814F028B,
	0x3FE43126,0xE978D4FE, 0x3FE9D688,0x21C64EA1,
	0x3FE43958,0x10624DD3, 0x3FE9D1B2,0x10C02F78,
	0x3FE44189,0x374BC6A8, 0x3FE9CCDA,0x4E8DC860,
	0x3FE449BA,0x5E353F7D, 0x3FE9C800,0xDB80590B,
	0x3FE451EB,0x851EB852, 0x3FE9C325,0xB7E93D88,
	0x3FE45A1C,0xAC083127, 0x3FE9BE48,0xE419EE41,
	0x3FE4624D,0xD2F1A9FC, 0x3FE9B96A,0x6063FFF2,
	0x3FE46A7E,0xF9DB22D1, 0x3FE9B48A,0x2D1923A6,
	0x3FE472B0,0x20C49BA6, 0x3FE9AFA8,0x4A8B26B1,
	0x3FE47AE1,0x47AE147B, 0x3FE9AAC4,0xB90BF2A8,
	0x3FE48312,0x6E978D50, 0x3FE9A5DF,0x78ED8D60,
	0x3FE48B43,0x95810625, 0x3FE9A0F8,0x8A8218E7,
	0x3FE49374,0xBC6A7EFA, 0x3FE99C0F,0xEE1BD37D,
	0x3FE49BA5,0xE353F7CF, 0x3FE99725,0xA40D1791,
	0x3FE4A3D7,0x0A3D70A4, 0x3FE99239,0xACA85BBA,
	0x3FE4AC08,0x3126E979, 0x3FE98D4C,0x084032B1,
	0x3FE4B439,0x5810624E, 0x3FE9885C,0xB7274B4E,
	0x3FE4BC6A,0x7EF9DB23, 0x3FE9836B,0xB9B07081,
	0x3FE4C49B,0xA5E353F8, 0x3FE97E79,0x102E894D,
	0x3FE4CCCC,0xCCCCCCCD, 0x3FE97984,0xBAF498C2,
	0x3FE4D4FD,0xF3B645A2, 0x3FE9748E,0xBA55BDF6,
	0x3FE4DD2F,0x1A9FBE77, 0x3FE96F97,0x0EA53406,
	0x3FE4E560,0x4189374C, 0x3FE96A9D,0xB8365209,
	0x3FE4ED91,0x6872B021, 0x3FE965A2,0xB75C8B0C,
	0x3FE4F5C2,0x8F5C28F6, 0x3FE960A6,0x0C6B6E13,
	0x3FE4FDF3,0xB645A1CB, 0x3FE95BA7,0xB7B6A609,
	0x3FE50624,0xDD2F1AA0, 0x3FE956A7,0xB991F9C5,
	0x3FE50E56,0x04189375, 0x3FE951A6,0x12514BFD,
	0x3FE51687,0x2B020C4A, 0x3FE94CA2,0xC2489B42,
	0x3FE51EB8,0x51EB851F, 0x3FE9479D,0xC9CC0200,
	0x3FE526E9,0x78D4FDF4, 0x3FE94297,0x292FB670,
	0x3FE52F1A,0x9FBE76C9, 0x3FE93D8E,0xE0C80A98,
	0x3FE5374B,0xC6A7EF9E, 0x3FE93884,0xF0E96C44,
	0x3FE53F7C,0xED916873, 0x3FE93379,0x59E86502,
	0x3FE547AE,0x147AE148, 0x3FE92E6C,0x1C199A18,
	0x3FE54FDF,0x3B645A1D, 0x3FE9295D,0x37D1CC85,
	0x3FE55810,0x624DD2F2, 0x3FE9244C,0xAD65D8F4,
	0x3FE56041,0x89374BC7, 0x3FE91F3A,0x7D2AB7BF,
	0x3FE56872,0xB020C49C, 0x3FE91A26,0xA7757CE0,
	0x3FE570A3,0xD70A3D71, 0x3FE91511,0x2C9B57F4,
	0x3FE578D4,0xFDF3B646, 0x3FE90FFA,0x0CF19430,
	0x3FE58106,0x24DD2F1B, 0x3FE90AE1,0x48CD985C,
	0x3FE58937,0x4BC6A7F0, 0x3FE905C6,0xE084E6D1,
	0x3FE59168,0x72B020C5, 0x3FE900AA,0xD46D1D6E,
	0x3FE59999,0x9999999A, 0x3FE8FB8D,0x24DBF597,
	0x3FE5A1CA,0xC083126F, 0x3FE8F66D,0xD227442E,
	0x3FE5A9FB,0xE76C8B44, 0x3FE8F14C,0xDCA4F98C,
	0x3FE5B22D,0x0E560419, 0x3FE8EC2A,0x44AB217D,
	0x3FE5BA5E,0x353F7CEE, 0x3FE8E706,0x0A8FE338,
	0x3FE5C28F,0x5C28F5C3, 0x3FE8E1E0,0x2EA9815D,
	0x3FE5CAC0,0x83126E98, 0x3FE8DCB8,0xB14E59ED,
	0x3FE5D2F1,0xA9FBE76D, 0x3FE8D78F,0x92D4E644,
	0x3FE5DB22,0xD0E56042, 0x3FE8D264,0xD393BB15,
	0x3FE5E353,0xF7CED917, 0x3FE8CD38,0x73E18863,
	0x3FE5EB85,0x1EB851EC, 0x3FE8C80A,0x7415197C,
	0x3FE5F3B6,0x45A1CAC1, 0x3FE8C2DA,0xD48554F2,
	0x3FE5FBE7,0x6C8B4396, 0x3FE8BDA9,0x95893C98,
	0x3FE60418,0x9374BC6A, 0x3FE8B876,0xB777ED7A,
	0x3FE60C49,0xBA5E353F, 0x3FE8B342,0x3AA89FD6,
	0x3FE6147A,0xE147AE14, 0x3FE8AE0C,0x1F72A71B,
	0x3FE61CAC,0x083126E9, 0x3FE8A8D4,0x662D71DF,
	0x3FE624DD,0x2F1A9FBE, 0x3FE8A39B,0x0F3089DC,
	0x3FE62D0E,0x56041893, 0x3FE89E60,0x1AD393E8,
	0x3FE6353F,0x7CED9168, 0x3FE89923,0x896E4FF1,
	0x3FE63D70,0xA3D70A3D, 0x3FE893E5,0x5B5898F4,
	0x3FE645A1,0xCAC08312, 0x3FE88EA5,0x90EA64FE,
	0x3FE64DD2,0xF1A9FBE7, 0x3FE88964,0x2A7BC51E,
	0x3FE65604,0x189374BC, 0x3FE88421,0x2864E567,
	0x3FE65E35,0x3F7CED91, 0x3FE87EDC,0x8AFE0CE3,
	0x3FE66666,0x66666666, 0x3FE87996,0x529F9D93,
	0x3FE66E97,0x8D4FDF3B, 0x3FE8744E,0x7FA21465,
	0x3FE676C8,0xB4395810, 0x3FE86F05,0x125E0933,
	0x3FE67EF9,0xDB22D0E5, 0x3FE869BA,0x0B2C2EB7,
	0x3FE6872B,0x020C49BA, 0x3FE8646D,0x6A65528A,
	0x3FE68F5C,0x28F5C28F, 0x3FE85F1F,0x30625D1D,
	0x3FE6978D,0x4FDF3B64, 0x3FE859CF,0x5D7C51B2,
	0x3FE69FBE,0x76C8B439, 0x3FE8547D,0xF20C4E58,
	0x3FE6A7EF,0x9DB22D0E, 0x3FE84F2A,0xEE6B8BE3,
	0x3FE6B020,0xC49BA5E3, 0x3FE849D6,0x52F35DE8,
	0x3FE6B851,0xEB851EB8, 0x3FE84480,0x1FFD32B6,
	0x3FE6C083,0x126E978D, 0x3FE83F28,0x55E29351,
	0x3FE6C8B4,0x39581062, 0x3FE839CE,0xF4FD236C,
	0x3FE6D0E5,0x60418937, 0x3FE83473,0xFDA6A161,
	0x3FE6D916,0x872B020C, 0x3FE82F17,0x7038E630,
	0x3FE6E147,0xAE147AE1, 0x3FE829B9,0x4D0DE573,
	0x3FE6E978,0xD4FDF3B6, 0x3FE82459,0x947FAD5E,
	0x3FE6F1A9,0xFBE76C8B, 0x3FE81EF8,0x46E866B4,
	0x3FE6F9DB,0x22D0E560, 0x3FE81995,0x64A254C4,
	0x3FE7020C,0x49BA5E35, 0x3FE81430,0xEE07D563,
	0x3FE70A3D,0x70A3D70A, 0x3FE80ECA,0xE37360E6,
	0x3FE7126E,0x978D4FDF, 0x3FE80963,0x453F8A19,
	0x3FE71A9F,0xBE76C8B4, 0x3FE803FA,0x13C6FE3F,
	0x3FE722D0,0xE5604189, 0x3FE7FE8F,0x4F648507,
	0x3FE72B02,0x0C49BA5E, 0x3FE7F922,0xF8730088,
	0x3FE73333,0x33333333, 0x3FE7F3B5,0x0F4D6D3A,
	0x3FE73B64,0x5A1CAC08, 0x3FE7EE45,0x944EE1F2,
	0x3FE74395,0x810624DD, 0x3FE7E8D4,0x87D28FDB,
	0x3FE74BC6,0xA7EF9DB2, 0x3FE7E361,0xEA33C26F,
	0x3FE753F7,0xCED91687, 0x3FE7DDED,0xBBCDDF72,
	0x3FE75C28,0xF5C28F5C, 0x3FE7D877,0xFCFC66ED,
	0x3FE7645A,0x1CAC0831, 0x3FE7D300,0xAE1AF326,
	0x3FE76C8B,0x43958106, 0x3FE7CD87,0xCF85389A,
	0x3FE774BC,0x6A7EF9DB, 0x3FE7C80D,0x619705FB,
	0x3FE77CED,0x916872B0, 0x3FE7C291,0x64AC4424,
	0x3FE7851E,0xB851EB85, 0x3FE7BD13,0xD920F617,
	0x3FE78D4F,0xDF3B645A, 0x3FE7B794,0xBF5138F6,
	0x3FE79581,0x0624DD2F, 0x3FE7B214,0x179943FB,
	0x3FE79DB2,0x2D0E5604, 0x3FE7AC91,0xE2556877,
	0x3FE7A5E3,0x53F7CED9, 0x3FE7A70E,0x1FE211C7,
	0x3FE7AE14,0x7AE147AE, 0x3FE7A188,0xD09BC54F,
	0x3FE7B645,0xA1CAC083, 0x3FE79C01,0xF4DF2275,
	0x3FE7BE76,0xC8B43958, 0x3FE79679,0x8D08E29B,
	0x3FE7C6A7,0xEF9DB22D, 0x3FE790EF,0x9975D91A,
	0x3FE7CED9,0x16872B02, 0x3FE78B64,0x1A82F336,
	0x3FE7D70A,0x3D70A3D7, 0x3FE785D7,0x108D3820,
	0x3FE7DF3B,0x645A1CAC, 0x3FE78048,0x7BF1C8EC,
	0x3FE7E76C,0x8B439581, 0x3FE77AB8,0x5D0DE089,
	0x3FE7EF9D,0xB22D0E56, 0x3FE77526,0xB43ED3BF,
	0x3FE7F7CE,0xD916872B, 0x3FE76F93,0x81E21125,
	0x3FE80000,0x00000000, 0x3FE769FE,0xC655211F,
	0x3FE80831,0x26E978D5, 0x3FE76468,0x81F5A5D4,
	0x3FE81062,0x4DD2F1AA, 0x3FE75ED0,0xB5215B29,
	0x3FE81893,0x74BC6A7F, 0x3FE75937,0x603616BD,
	0x3FE820C4,0x9BA5E354, 0x3FE7539C,0x8391C7E0,
	0x3FE828F5,0xC28F5C29, 0x3FE74E00,0x1F92778E,
	0x3FE83126,0xE978D4FE, 0x3FE74862,0x3496486A,
	0x3FE83958,0x10624DD3, 0x3FE742C2,0xC2FB76B6,
	0x3FE84189,0x374BC6A8, 0x3FE73D21,0xCB20584D,
	0x3FE849BA,0x5E353F7D, 0x3FE7377F,0x4D635C9D,
	0x3FE851EB,0x851EB852, 0x3FE731DB,0x4A230CA3,
	0x3FE85A1C,0xAC083127, 0x3FE72C35,0xC1BE0AE1,
	0x3FE8624D,0xD2F1A9FC, 0x3FE7268E,0xB493135B,
	0x3FE86A7E,0xF9DB22D1, 0x3FE720E6,0x2300FB8E,
	0x3FE872B0,0x20C49BA6, 0x3FE71B3C,0x0D66B26F,
	0x3FE87AE1,0x47AE147B, 0x3FE71590,0x7423405C,
	0x3FE88312,0x6E978D50, 0x3FE70FE3,0x5795C71E,
	0x3FE88B43,0x95810625, 0x3FE70A34,0xB81D81DF,
	0x3FE89374,0xBC6A7EFA, 0x3FE70484,0x9619C525,
	0x3FE89BA5,0xE353F7CF, 0x3FE6FED2,0xF1E9FECA,
	0x3FE8A3D7,0x0A3D70A4, 0x3FE6F91F,0xCBEDB5F7,
	0x3FE8AC08,0x3126E979, 0x3FE6F36B,0x24848B20,
	0x3FE8B439,0x5810624E, 0x3FE6EDB4,0xFC0E37F7,
	0x3FE8BC6A,0x7EF9DB23, 0x3FE6E7FD,0x52EA8F6D,
	0x3FE8C49B,0xA5E353F8, 0x3FE6E244,0x29797DAA,
	0x3FE8CCCC,0xCCCCCCCD, 0x3FE6DC89,0x801B0802,
	0x3FE8D4FD,0xF3B645A2, 0x3FE6D6CD,0x572F4CF4,
	0x3FE8DD2F,0x1A9FBE77, 0x3FE6D10F,0xAF168424,
	0x3FE8E560,0x4189374C, 0x3FE6CB50,0x8830FE4F,
	0x3FE8ED91,0x6872B021, 0x3FE6C58F,0xE2DF254A,
	0x3FE8F5C2,0x8F5C28F6, 0x3FE6BFCD,0xBF817BFA,
	0x3FE8FDF3,0xB645A1CB, 0x3FE6BA0A,0x1E789E4F,
	0x3FE90624,0xDD2F1AA0, 0x3FE6B445,0x00254139,
	0x3FE90E56,0x04189375, 0x3FE6AE7E,0x64E832A7,
	0x3FE91687,0x2B020C4A, 0x3FE6A8B6,0x4D225980,
	0x3FE91EB8,0x51EB851F, 0x3FE6A2EC,0xB934B59A,
	0x3FE926E9,0x78D4FDF4, 0x3FE69D21,0xA9805FB3,
	0x3FE92F1A,0x9FBE76C9, 0x3FE69755,0x1E668970,
	0x3FE9374B,0xC6A7EF9E, 0x3FE69187,0x18487D51,
	0x3FE93F7C,0xED916873, 0x3FE68BB7,0x97879EAE,
	0x3FE947AE,0x147AE148, 0x3FE685E6,0x9C8569AF,
	0x3FE94FDF,0x3B645A1D, 0x3FE68014,0x27A37345,
	0x3FE95810,0x624DD2F2, 0x3FE67A40,0x39436927,
	0x3FE96041,0x89374BC7, 0x3FE6746A,0xD1C711C7,
	0x3FE96872,0xB020C49C, 0x3FE66E93,0xF1904C50,
	0x3FE970A3,0xD70A3D71, 0x3FE668BB,0x9901109B,
	0x3FE978D4,0xFDF3B646, 0x3FE662E1,0xC87B6F2C,
	0x3FE98106,0x24DD2F1B, 0x3FE65D06,0x8061912D,
	0x3FE98937,0x4BC6A7F0, 0x3FE65729,0xC115B861,
	0x3FE99168,0x72B020C5, 0x3FE6514B,0x8AFA3F25,
	0x3FE99999,0x9999999A, 0x3FE64B6B,0xDE719865,
	0x3FE9A1CA,0xC083126F, 0x3FE6458A,0xBBDE4F97,
	0x3FE9A9FB,0xE76C8B44, 0x3FE63FA8,0x23A308B3,
	0x3FE9B22D,0x0E560419, 0x3FE639C4,0x16228031,
	0x3FE9BA5E,0x353F7CEE, 0x3FE633DE,0x93BF8AFD,
	0x3FE9C28F,0x5C28F5C3, 0x3FE62DF7,0x9CDD1674,
	0x3FE9CAC0,0x83126E98, 0x3FE6280F,0x31DE285B,
	0x3FE9D2F1,0xA9FBE76D, 0x3FE62225,0x5325DEDC,
	0x3FE9DB22,0xD0E56042, 0x3FE61C3A,0x0117707C,
	0x3FE9E353,0xF7CED917, 0x3FE6164D,0x3C162C18,
	0x3FE9EB85,0x1EB851EC, 0x3FE6105F,0x048578D9,
	0x3FE9F3B6,0x45A1CAC1, 0x3FE60A6F,0x5AC8D635,
	0x3FE9FBE7,0x6C8B4396, 0x3FE6047E,0x3F43DBE1,
	0x3FEA0418,0x9374BC6A, 0x3FE5FE8B,0xB25A39D1,
	0x3FEA0C49,0xBA5E353F, 0x3FE5F897,0xB46FB82B,
	0x3FEA147A,0xE147AE14, 0x3FE5F2A2,0x45E83747,
	0x3FEA1CAC,0x083126E9, 0x3FE5ECAB,0x6727AFA2,
	0x3FEA24DD,0x2F1A9FBE, 0x3FE5E6B3,0x189231DF,
	0x3FEA2D0E,0x56041893, 0x3FE5E0B9,0x5A8BE6BA,
	0x3FEA353F,0x7CED9168, 0x3FE5DABE,0x2D790F01,
	0x3FEA3D70,0xA3D70A3D, 0x3FE5D4C1,0x91BE0395,
	0x3FEA45A1,0xCAC08312, 0x3FE5CEC3,0x87BF355B,
	0x3FEA4DD2,0xF1A9FBE7, 0x3FE5C8C4,0x0FE12D3A,
	0x3FEA5604,0x189374BC, 0x3FE5C2C3,0x2A888C14,
	0x3FEA5E35,0x3F7CED91, 0x3FE5BCC0,0xD81A0ABD,
	0x3FEA6666,0x66666666, 0x3FE5B6BD,0x18FA79F8,
	0x3FEA6E97,0x8D4FDF3B, 0x3FE5B0B7,0xED8EC26D,
	0x3FEA76C8,0xB4395810, 0x3FE5AAB1,0x563BE4A5,
	0x3FEA7EF9,0xDB22D0E5, 0x3FE5A4A9,0x5366F901,
	0x3FEA872B,0x020C49BA, 0x3FE59E9F,0xE5752FB7,
	0x3FEA8F5C,0x28F5C28F, 0x3FE59895,0x0CCBD0C6,
	0x3FEA978D,0x4FDF3B64, 0x3FE59288,0xC9D03BF4,
	0x3FEA9FBE,0x76C8B439, 0x3FE58C7B,0x1CE7E8C7,
	0x3FEAA7EF,0x9DB22D0E, 0x3FE5866C,0x0678667A,
	0x3FEAB020,0xC49BA5E3, 0x3FE5805B,0x86E75BFC,
	0x3FEAB851,0xEB851EB8, 0x3FE57A49,0x9E9A87E6,
	0x3FEAC083,0x126E978D, 0x3FE57436,0x4DF7C074,
	0x3FEAC8B4,0x39581062, 0x3FE56E21,0x9564F382,
	0x3FEAD0E5,0x60418937, 0x3FE5680B,0x75482680,
	0x3FEAD916,0x872B020C, 0x3FE561F3,0xEE07766F,
	0x3FEAE147,0xAE147AE1, 0x3FE55BDB,0x000917DB,
	0x3FEAE978,0xD4FDF3B6, 0x3FE555C0,0xABB356D1,
	0x3FEAF1A9,0xFBE76C8B, 0x3FE54FA4,0xF16C96D9,
	0x3FEAF9DB,0x22D0E560, 0x3FE54987,0xD19B52F2,
	0x3FEB020C,0x49BA5E35, 0x3FE54369,0x4CA61D8A,
	0x3FEB0A3D,0x70A3D70A, 0x3FE53D49,0x62F3A075,
	0x3FEB126E,0x978D4FDF, 0x3FE53728,0x14EA9CE9,
	0x3FEB1A9F,0xBE76C8B4, 0x3FE53105,0x62F1EB77,
	0x3FEB22D0,0xE5604189, 0x3FE52AE1,0x4D707C02,
	0x3FEB2B02,0x0C49BA5E, 0x3FE524BB,0xD4CD55BC,
	0x3FEB3333,0x33333333, 0x3FE51E94,0xF96F971B,
	0x3FEB3B64,0x5A1CAC08, 0x3FE5186C,0xBBBE75D6,
	0x3FEB4395,0x810624DD, 0x3FE51243,0x1C213EDB,
	0x3FEB4BC6,0xA7EF9DB2, 0x3FE50C18,0x1AFF564B,
	0x3FEB53F7,0xCED91687, 0x3FE505EB,0xB8C03773,
	0x3FEB5C28,0xF5C28F5C, 0x3FE4FFBD,0xF5CB74C1,
	0x3FEB645A,0x1CAC0831, 0x3FE4F98E,0xD288B7C5,
	0x3FEB6C8B,0x43958106, 0x3FE4F35E,0x4F5FC121,
	0x3FEB74BC,0x6A7EF9DB, 0x3FE4ED2C,0x6CB8688B,
	0x3FEB7CED,0x916872B0, 0x3FE4E6F9,0x2AFA9CBE,
	0x3FEB851E,0xB851EB85, 0x3FE4E0C4,0x8A8E637C,
	0x3FEB8D4F,0xDF3B645A, 0x3FE4DA8E,0x8BDBD97E,
	0x3FEB9581,0x0624DD2F, 0x3FE4D457,0x2F4B3274,
	0x3FEB9DB2,0x2D0E5604, 0x3FE4CE1E,0x7544B8FC,
	0x3FEBA5E3,0x53F7CED9, 0x3FE4C7E4,0x5E30CE9A,
	0x3FEBAE14,0x7AE147AE, 0x3FE4C1A8,0xEA77EBB3,
	0x3FEBB645,0xA1CAC083, 0x3FE4BB6C,0x1A829F84,
	0x3FEBBE76,0xC8B43958, 0x3FE4B52D,0xEEB9901D,
	0x3FEBC6A7,0xEF9DB22D, 0x3FE4AEEE,0x67857A5A,
	0x3FEBCED9,0x16872B02, 0x3FE4A8AD,0x854F31DD,
	0x3FEBD70A,0x3D70A3D7, 0x3FE4A26B,0x487FA102,
	0x3FEBDF3B,0x645A1CAC, 0x3FE49C27,0xB17FC8DF,
	0x3FEBE76C,0x8B439581, 0x3FE495E2,0xC0B8C13A,
	0x3FEBEF9D,0xB22D0E56, 0x3FE48F9C,0x7693B882,
	0x3FEBF7CE,0xD916872B, 0x3FE48954,0xD379F3C6,
	0x3FEC0000,0x00000000, 0x3FE4830B,0xD7D4CEB3,
	0x3FEC0831,0x26E978D5, 0x3FE47CC1,0x840DBB8B,
	0x3FEC1062,0x4DD2F1AA, 0x3FE47675,0xD88E431B,
	0x3FEC1893,0x74BC6A7F, 0x3FE47028,0xD5C004B8,
	0x3FEC20C4,0x9BA5E354, 0x3FE469DA,0x7C0CB637,
	0x3FEC28F5,0xC28F5C29, 0x3FE4638A,0xCBDE23E6,
	0x3FEC3126,0xE978D4FE, 0x3FE45D39,0xC59E3084,
	0x3FEC3958,0x10624DD3, 0x3FE456E7,0x69B6D53B,
	0x3FEC4189,0x374BC6A8, 0x3FE45093,0xB892219A,
	0x3FEC49BA,0x5E353F7D, 0x3FE44A3E,0xB29A3B8D,
	0x3FEC51EB,0x851EB852, 0x3FE443E8,0x58395F54,
	0x3FEC5A1C,0xAC083127, 0x3FE43D90,0xA9D9DF81,
	0x3FEC624D,0xD2F1A9FC, 0x3FE43737,0xA7E624EC,
	0x3FEC6A7E,0xF9DB22D1, 0x3FE430DD,0x52C8AEB0,
	0x3FEC72B0,0x20C49BA6, 0x3FE42A81,0xAAEC1220,
	0x3FEC7AE1,0x47AE147B, 0x3FE42424,0xB0BAFAC4,
	0x3FEC8312,0x6E978D50, 0x3FE41DC6,0x64A02A50,
	0x3FEC8B43,0x95810625, 0x3FE41766,0xC706789C,
	0x3FEC9374,0xBC6A7EFA, 0x3FE41105,0xD858D3A1,
	0x3FEC9BA5,0xE353F7CF, 0x3FE40AA3,0x99023F6C,
	0x3FECA3D7,0x0A3D70A4, 0x3FE40440,0x096DD61B,
	0x3FECAC08,0x3126E979, 0x3FE3FDDB,0x2A06C7D8,
	0x3FECB439,0x5810624E, 0x3FE3F774,0xFB385ACB,
	0x3FECBC6A,0x7EF9DB23, 0x3FE3F10D,0x7D6DEB19,
	0x3FECC49B,0xA5E353F8, 0x3FE3EAA4,0xB112EADD,
	0x3FECCCCC,0xCCCCCCCD, 0x3FE3E43A,0x9692E21C,
	0x3FECD4FD,0xF3B645A2, 0x3FE3DDCF,0x2E596EC3,
	0x3FECDD2F,0x1A9FBE77, 0x3FE3D762,0x78D2449D,
	0x3FECE560,0x4189374C, 0x3FE3D0F4,0x76692D4D,
	0x3FECED91,0x6872B021, 0x3FE3CA85,0x278A0847,
	0x3FECF5C2,0x8F5C28F6, 0x3FE3C414,0x8CA0CAC8,
	0x3FECFDF3,0xB645A1CB, 0x3FE3BDA2,0xA6197FD3,
	0x3FED0624,0xDD2F1AA0, 0x3FE3B72F,0x74604821,
	0x3FED0E56,0x04189375, 0x3FE3B0BA,0xF7E15A25,
	0x3FED1687,0x2B020C4A, 0x3FE3AA45,0x310901FC,
	0x3FED1EB8,0x51EB851F, 0x3FE3A3CE,0x2043A16B,
	0x3FED26E9,0x78D4FDF4, 0x3FE39D55,0xC5FDAFD5,
	0x3FED2F1A,0x9FBE76C9, 0x3FE396DC,0x22A3BA36,
	0x3FED374B,0xC6A7EF9E, 0x3FE39061,0x36A2631B,
	0x3FED3F7C,0xED916873, 0x3FE389E5,0x0266629A,
	0x3FED47AE,0x147AE148, 0x3FE38367,0x865C864D,
	0x3FED4FDF,0x3B645A1D, 0x3FE37CE8,0xC2F1B14A,
	0x3FED5810,0x624DD2F2, 0x3FE37668,0xB892DC19,
	0x3FED6041,0x89374BC7, 0x3FE36FE7,0x67AD14B2,
	0x3FED6872,0xB020C49C, 0x3FE36964,0xD0AD7E72,
	0x3FED70A3,0xD70A3D71, 0x3FE362E0,0xF4015215,
	0x3FED78D4,0xFDF3B646, 0x3FE35C5B,0xD215DDB0,
	0x3FED8106,0x24DD2F1B, 0x3FE355D5,0x6B5884A6,
	0x3FED8937,0x4BC6A7F0, 0x3FE34F4D,0xC036BFA7,
	0x3FED9168,0x72B020C5, 0x3FE348C4,0xD11E1CA4,
	0x3FED9999,0x9999999A, 0x3FE3423A,0x9E7C3EC9,
	0x3FEDA1CA,0xC083126F, 0x3FE33BAF,0x28BEDE75,
	0x3FEDA9FB,0xE76C8B44, 0x3FE33522,0x7053C936,
	0x3FEDB22D,0x0E560419, 0x3FE32E94,0x75A8E1BE,
	0x3FEDBA5E,0x353F7CEE, 0x3FE32805,0x392C1FDE,
	0x3FEDC28F,0x5C28F5C3, 0x3FE32174,0xBB4B9080,
	0x3FEDCAC0,0x83126E98, 0x3FE31AE2,0xFC75559A,
	0x3FEDD2F1,0xA9FBE76D, 0x3FE3144F,0xFD17A62F,
	0x3FEDDB22,0xD0E56042, 0x3FE30DBB,0xBDA0CE40,
	0x3FEDE353,0xF7CED917, 0x3FE30726,0x3E7F2ECB,
	0x3FEDEB85,0x1EB851EC, 0x3FE3008F,0x80213DC1,
	0x3FEDF3B6,0x45A1CAC1, 0x3FE2F9F7,0x82F585FC,
	0x3FEDFBE7,0x6C8B4396, 0x3FE2F35E,0x476AA73F,
	0x3FEE0418,0x9374BC6A, 0x3FE2ECC3,0xCDEF5627,
	0x3FEE0C49,0xBA5E353F, 0x3FE2E628,0x16F25C28,
	0x3FEE147A,0xE147AE14, 0x3FE2DF8B,0x22E29786,
	0x3FEE1CAC,0x083126E9, 0x3FE2D8EC,0xF22EFB4B,
	0x3FEE24DD,0x2F1A9FBE, 0x3FE2D24D,0x85468F41,
	0x3FEE2D0E,0x56041893, 0x3FE2CBAC,0xDC986FEF,
	0x3FEE353F,0x7CED9168, 0x3FE2C50A,0xF893CE88,
	0x3FEE3D70,0xA3D70A3D, 0x3FE2BE67,0xD9A7F0EF,
	0x3FEE45A1,0xCAC08312, 0x3FE2B7C3,0x804431A5,
	0x3FEE4DD2,0xF1A9FBE7, 0x3FE2B11D,0xECD7FFCB,
	0x3FEE5604,0x189374BC, 0x3FE2AA77,0x1FD2DF16,
	0x3FEE5E35,0x3F7CED91, 0x3FE2A3CF,0x19A467C5,
	0x3FEE6666,0x66666666, 0x3FE29D25,0xDABC46A2,
	0x3FEE6E97,0x8D4FDF3B, 0x3FE2967B,0x638A3CF0,
	0x3FEE76C8,0xB4395810, 0x3FE28FCF,0xB47E206F,
	0x3FEE7EF9,0xDB22D0E5, 0x3FE28922,0xCE07DB4C,
	0x3FEE872B,0x020C49BA, 0x3FE28274,0xB0976C1C,
	0x3FEE8F5C,0x28F5C28F, 0x3FE27BC5,0x5C9CE5D6,
	0x3FEE978D,0x4FDF3B64, 0x3FE27514,0xD2886FCD,
	0x3FEE9FBE,0x76C8B439, 0x3FE26E63,0x12CA45A4,
	0x3FEEA7EF,0x9DB22D0E, 0x3FE267B0,0x1DD2B74B,
	0x3FEEB020,0xC49BA5E3, 0x3FE260FB,0xF41228F4,
	0x3FEEB851,0xEB851EB8, 0x3FE25A46,0x95F91310,
	0x3FEEC083,0x126E978D, 0x3FE25390,0x03F80243,
	0x3FEEC8B4,0x39581062, 0x3FE24CD8,0x3E7F9760,
	0x3FEED0E5,0x60418937, 0x3FE2461F,0x46008761,
	0x3FEED916,0x872B020C, 0x3FE23F65,0x1AEB9B5C,
	0x3FEEE147,0xAE147AE1, 0x3FE238A9,0xBDB1B084,
	0x3FEEE978,0xD4FDF3B6, 0x3FE231ED,0x2EC3B816,
	0x3FEEF1A9,0xFBE76C8B, 0x3FE22B2F,0x6E92B75D,
	0x3FEEF9DB,0x22D0E560, 0x3FE22470,0x7D8FC7A3,
	0x3FEF020C,0x49BA5E35, 0x3FE21DB0,0x5C2C162C,
	0x3FEF0A3D,0x70A3D70A, 0x3FE216EF,0x0AD8E430,
	0x3FEF126E,0x978D4FDF, 0x3FE2102C,0x8A0786D0,
	0x3FEF1A9F,0xBE76C8B4, 0x3FE20968,0xDA296712,
	0x3FEF22D0,0xE5604189, 0x3FE202A3,0xFBB001DA,
	0x3FEF2B02,0x0C49BA5E, 0x3FE1FBDD,0xEF0CE7DD,
	0x3FEF3333,0x33333333, 0x3FE1F516,0xB4B1BDA1,
	0x3FEF3B64,0x5A1CAC08, 0x3FE1EE4E,0x4D103B71,
	0x3FEF4395,0x810624DD, 0x3FE1E784,0xB89A2D56,
	0x3FEF4BC6,0xA7EF9DB2, 0x3FE1E0B9,0xF7C1730F,
	0x3FEF53F7,0xCED91687, 0x3FE1D9EE,0x0AF8000E,
	0x3FEF5C28,0xF5C28F5C, 0x3FE1D320,0xF2AFDB6A,
	0x3FEF645A,0x1CAC0831, 0x3FE1CC52,0xAF5B1FDC,
	0x3FEF6C8B,0x43958106, 0x3FE1C583,0x416BFBB6,
	0x3FEF74BC,0x6A7EF9DB, 0x3FE1BEB2,0xA954B0DB,
	0x3FEF7CED,0x916872B0, 0x3FE1B7E0,0xE78794BB,
	0x3FEF851E,0xB851EB85, 0x3FE1B10D,0xFC771045,
	0x3FEF8D4F,0xDF3B645A, 0x3FE1AA39,0xE8959FE5,
	0x3FEF9581,0x0624DD2F, 0x3FE1A364,0xAC55D37C,
	0x3FEF9DB2,0x2D0E5604, 0x3FE19C8E,0x482A4E55,
	0x3FEFA5E3,0x53F7CED9, 0x3FE195B6,0xBC85C721,
	0x3FEFAE14,0x7AE147AE, 0x3FE18EDE,0x09DB07EE,
	0x3FEFB645,0xA1CAC083, 0x3FE18804,0x309CEE20,
	0x3FEFBE76,0xC8B43958, 0x3FE18129,0x313E6A68,
	0x3FEFC6A7,0xEF9DB22D, 0x3FE17A4D,0x0C3280BE,
	0x3FEFCED9,0x16872B02, 0x3FE1736F,0xC1EC485B,
	0x3FEFD70A,0x3D70A3D7, 0x3FE16C91,0x52DEEBAD,
	0x3FEFDF3B,0x645A1CAC, 0x3FE165B1,0xBF7DA853,
	0x3FEFE76C,0x8B439581, 0x3FE15ED1,0x083BCF15,
	0x3FEFEF9D,0xB22D0E56, 0x3FE157EF,0x2D8CC3DB,
	0x3FEFF7CE,0xD916872B, 0x3FE1510C,0x2FE3FDA7,
	0x3FF00000,0x00000000, 0x3FE14A28,0x0FB5068C,
	0x3FF00418,0x9374BC6A, 0x3FE14342,0xCD737BA8,
	0x3FF00831,0x26E978D5, 0x3FE13C5C,0x69930D1A,
	0x3FF00C49,0xBA5E353F, 0x3FE13574,0xE4877E00,
	0x3FF01062,0x4DD2F1AA, 0x3FE12E8C,0x3EC4A465,
	0x3FF0147A,0xE147AE14, 0x3FE127A2,0x78BE6947,
	0x3FF01893,0x74BC6A7F, 0x3FE120B7,0x92E8C882,
	0x3FF01CAC,0x083126E9, 0x3FE119CB,0x8DB7D0D5,
	0x3FF020C4,0x9BA5E354, 0x3FE112DE,0x699FA3CC,
	0x3FF024DD,0x2F1A9FBE, 0x3FE10BF0,0x271475C9,
	0x3FF028F5,0xC28F5C29, 0x3FE10500,0xC68A8DED,
	0x3FF02D0E,0x56041893, 0x3FE0FE10,0x4876461C,
	0x3FF03126,0xE978D4FE, 0x3FE0F71E,0xAD4C0AEC,
	0x3FF0353F,0x7CED9168, 0x3FE0F02B,0xF5805BA8,
	0x3FF03958,0x10624DD3, 0x3FE0E938,0x2187CA3B,
	0x3FF03D70,0xA3D70A3D, 0x3FE0E243,0x31D6FB38,
	0x3FF04189,0x374BC6A8, 0x3FE0DB4D,0x26E2A5C0,
	0x3FF045A1,0xCAC08312, 0x3FE0D456,0x011F938E,
	0x3FF049BA,0x5E353F7D, 0x3FE0CD5D,0xC102A0DF,
	0x3FF04DD2,0xF1A9FBE7, 0x3FE0C664,0x6700BC77,
	0x3FF051EB,0x851EB852, 0x3FE0BF69,0xF38EE78C,
	0x3FF05604,0x189374BC, 0x3FE0B86E,0x672235CE,
	0x3FF05A1C,0xAC083127, 0x3FE0B171,0xC22FCD4E,
	0x3FF05E35,0x3F7CED91, 0x3FE0AA74,0x052CE689,
	0x3FF0624D,0xD2F1A9FC, 0x3FE0A375,0x308ECC4E,
	0x3FF06666,0x66666666, 0x3FE09C75,0x44CADBC7,
	0x3FF06A7E,0xF9DB22D1, 0x3FE09574,0x42568460,
	0x3FF06E97,0x8D4FDF3B, 0x3FE08E72,0x29A747D4,
	0x3FF072B0,0x20C49BA6, 0x3FE0876E,0xFB32BA0E,
	0x3FF076C8,0xB4395810, 0x3FE0806A,0xB76E8138,
	0x3FF07AE1,0x47AE147B, 0x3FE07965,0x5ED055A0,
	0x3FF07EF9,0xDB22D0E5, 0x3FE0725E,0xF1CE01BF,
	0x3FF08312,0x6E978D50, 0x3FE06B57,0x70DD6225,
	0x3FF0872B,0x020C49BA, 0x3FE0644E,0xDC74657F,
	0x3FF08B43,0x95810625, 0x3FE05D45,0x35090C80,
	0x3FF08F5C,0x28F5C28F, 0x3FE0563A,0x7B1169E7,
	0x3FF09374,0xBC6A7EFA, 0x3FE04F2E,0xAF03A26B,
	0x3FF0978D,0x4FDF3B64, 0x3FE04821,0xD155ECC0,
	0x3FF09BA5,0xE353F7CF, 0x3FE04113,0xE27E9184,
	0x3FF09FBE,0x76C8B439, 0x3FE03A04,0xE2F3EB3E,
	0x3FF0A3D7,0x0A3D70A4, 0x3FE032F4,0xD32C6653,
	0x3FF0A7EF,0x9DB22D0E, 0x3FE02BE3,0xB39E8101,
	0x3FF0AC08,0x3126E979, 0x3FE024D1,0x84C0CB53,
	0x3FF0B020,0xC49BA5E3, 0x3FE01DBE,0x4709E71F,
	0x3FF0B439,0x5810624E, 0x3FE016A9,0xFAF087F8,
	0x3FF0B851,0xEB851EB8, 0x3FE00F94,0xA0EB732D,
	0x3FF0BC6A,0x7EF9DB23, 0x3FE0087E,0x39717FB8,
	0x3FF0C083,0x126E978D, 0x3FE00166,0xC4F99643,
	0x3FF0C49B,0xA5E353F8, 0x3FDFF49C,0x87F56223,
	0x3FF0C8B4,0x39581062, 0x3FDFE669,0x6DD7B80E,
	0x3FF0CCCC,0xCCCCCCCD, 0x3FDFD834,0x3C886923,
	0x3FF0D0E5,0x60418937, 0x3FDFC9FC,0xF4F5D35F,
	0x3FF0D4FD,0xF3B645A2, 0x3FDFBBC3,0x980E77B4,
	0x3FF0D916,0x872B020C, 0x3FDFAD88,0x26C0FA17,
	0x3FF0DD2F,0x1A9FBE77, 0x3FDF9F4A,0xA1FC2152,
	0x3FF0E147,0xAE147AE1, 0x3FDF910B,0x0AAED712,
	0x3FF0E560,0x4189374C, 0x3FDF82C9,0x61C827BB,
	0x3FF0E978,0xD4FDF3B6, 0x3FDF7485,0xA8374274,
	0x3FF0ED91,0x6872B021, 0x3FDF663F,0xDEEB78FC,
	0x3FF0F1A9,0xFBE76C8B, 0x3FDF57F8,0x06D43FB5,
	0x3FF0F5C2,0x8F5C28F6, 0x3FDF49AE,0x20E12D79,
	0x3FF0F9DB,0x22D0E560, 0x3FDF3B62,0x2E01FBA8,
	0x3FF0FDF3,0xB645A1CB, 0x3FDF2D14,0x2F2685FA,
	0x3FF1020C,0x49BA5E35, 0x3FDF1EC4,0x253ECA8A,
	0x3FF10624,0xDD2F1AA0, 0x3FDF1072,0x113AE9B0,
	0x3FF10A3D,0x70A3D70A, 0x3FDF021D,0xF40B2606,
	0x3FF10E56,0x04189375, 0x3FDEF3C7,0xCE9FE443,
	0x3FF1126E,0x978D4FDF, 0x3FDEE56F,0xA1E9AB41,
	0x3FF11687,0x2B020C4A, 0x3FDED715,0x6ED923D6,
	0x3FF11A9F,0xBE76C8B4, 0x3FDEC8B9,0x365F18DF,
	0x3FF11EB8,0x51EB851F, 0x3FDEBA5A,0xF96C7713,
	0x3FF122D0,0xE5604189, 0x3FDEABFA,0xB8F24D0F,
	0x3FF126E9,0x78D4FDF4, 0x3FDE9D98,0x75E1CB2C,
	0x3FF12B02,0x0C49BA5E, 0x3FDE8F34,0x312C438C,
	0x3FF12F1A,0x9FBE76C9, 0x3FDE80CD,0xEBC329E9,
	0x3FF13333,0x33333333, 0x3FDE7265,0xA69813A9,
	0x3FF1374B,0xC6A7EF9E, 0x3FDE63FB,0x629CB7A9,
	0x3FF13B64,0x5A1CAC08, 0x3FDE558F,0x20C2EE52,
	0x3FF13F7C,0xED916873, 0x3FDE4720,0xE1FCB167,
	0x3FF14395,0x810624DD, 0x3FDE38B0,0xA73C1C14,
	0x3FF147AE,0x147AE148, 0x3FDE2A3E,0x71736AC3,
	0x3FF14BC6,0xA7EF9DB2, 0x3FDE1BCA,0x4194FB23,
	0x3FF14FDF,0x3B645A1D, 0x3FDE0D54,0x18934C04,
	0x3FF153F7,0xCED91687, 0x3FDDFEDB,0xF760FD5B,
	0x3FF15810,0x624DD2F2, 0x3FDDF061,0xDEF0D01B,
	0x3FF15C28,0xF5C28F5C, 0x3FDDE1E5,0xD035A642,
	0x3FF16041,0x89374BC7, 0x3FDDD367,0xCC2282A9,
	0x3FF1645A,0x1CAC0831, 0x3FDDC4E7,0xD3AA8912,
	0x3FF16872,0xB020C49C, 0x3FDDB665,0xE7C0FDFE,
	0x3FF16C8B,0x43958106, 0x3FDDA7E2,0x095946B6,
	0x3FF170A3,0xD70A3D71, 0x3FDD995C,0x3966E91F,
	0x3FF174BC,0x6A7EF9DB, 0x3FDD8AD4,0x78DD8BCB,
	0x3FF178D4,0xFDF3B646, 0x3FDD7C4A,0xC8B0F5C6,
	0x3FF17CED,0x916872B0, 0x3FDD6DBF,0x29D50EA8,
	0x3FF18106,0x24DD2F1B, 0x3FDD5F31,0x9D3DDE63,
	0x3FF1851E,0xB851EB85, 0x3FDD50A2,0x23DF8D56,
	0x3FF18937,0x4BC6A7F0, 0x3FDD4210,0xBEAE641C,
	0x3FF18D4F,0xDF3B645A, 0x3FDD337D,0x6E9ECB99,
	0x3FF19168,0x72B020C5, 0x3FDD24E8,0x34A54CCF,
	0x3FF19581,0x0624DD2F, 0x3FDD1651,0x11B690EA,
	0x3FF19999,0x9999999A, 0x3FDD07B8,0x06C76111,
	0x3FF19DB2,0x2D0E5604, 0x3FDCF91D,0x14CCA677,
	0x3FF1A1CA,0xC083126F, 0x3FDCEA80,0x3CBB6A2B,
	0x3FF1A5E3,0x53F7CED9, 0x3FDCDBE1,0x7F88D525,
	0x3FF1A9FB,0xE76C8B44, 0x3FDCCD40,0xDE2A301A,
	0x3FF1AE14,0x7AE147AE, 0x3FDCBE9E,0x5994E38A,
	0x3FF1B22D,0x0E560419, 0x3FDCAFF9,0xF2BE7790,
	0x3FF1B645,0xA1CAC083, 0x3FDCA153,0xAA9C93F0,
	0x3FF1BA5E,0x353F7CEE, 0x3FDC92AB,0x8224FFEB,
	0x3FF1BE76,0xC8B43958, 0x3FDC8401,0x7A4DA24C,
	0x3FF1C28F,0x5C28F5C3, 0x3FDC7555,0x940C8139,
	0x3FF1C6A7,0xEF9DB22D, 0x3FDC66A7,0xD057C240,
	0x3FF1CAC0,0x83126E98, 0x3FDC57F8,0x3025AA2C,
	0x3FF1CED9,0x16872B02, 0x3FDC4946,0xB46C9D12,
	0x3FF1D2F1,0xA9FBE76D, 0x3FDC3A93,0x5E231E21,
	0x3FF1D70A,0x3D70A3D7, 0x3FDC2BDE,0x2E3FCFAF,
	0x3FF1DB22,0xD0E56042, 0x3FDC1D27,0x25B97310,
	0x3FF1DF3B,0x645A1CAC, 0x3FDC0E6E,0x4586E89F,
	0x3FF1E353,0xF7CED917, 0x3FDBFFB3,0x8E9F2F90,
	0x3FF1E76C,0x8B439581, 0x3FDBF0F7,0x01F96601,
	0x3FF1EB85,0x1EB851EC, 0x3FDBE238,0xA08CC8CB,
	0x3FF1EF9D,0xB22D0E56, 0x3FDBD378,0x6B50B38B,
	0x3FF1F3B6,0x45A1CAC1, 0x3FDBC4B6,0x633CA07B,
	0x3FF1F7CE,0xD916872B, 0x3FDBB5F2,0x8948287A,
	0x3FF1FBE7,0x6C8B4396, 0x3FDBA72C,0xDE6B02E3,
	0x3FF20000,0x00000000, 0x3FDB9865,0x639D0596,
	0x3FF20418,0x9374BC6A, 0x3FDB899C,0x19D624CD,
	0x3FF20831,0x26E978D5, 0x3FDB7AD1,0x020E731F,
	0x3FF20C49,0xBA5E353F, 0x3FDB6C04,0x1D3E2171,
	0x3FF21062,0x4DD2F1AA, 0x3FDB5D35,0x6C5D7ED0,
	0x3FF2147A,0xE147AE14, 0x3FDB4E64,0xF064F881,
	0x3FF21893,0x74BC6A7F, 0x3FDB3F92,0xAA4D19CF,
	0x3FF21CAC,0x083126E9, 0x3FDB30BE,0x9B0E8C1A,
	0x3FF220C4,0x9BA5E354, 0x3FDB21E8,0xC3A216A8,
	0x3FF224DD,0x2F1A9FBE, 0x3FDB1311,0x25009EB5,
	0x3FF228F5,0xC28F5C29, 0x3FDB0437,0xC0232741,
	0x3FF22D0E,0x56041893, 0x3FDAF55C,0x9602D123,
	0x3FF23126,0xE978D4FE, 0x3FDAE67F,0xA798DAD5,
	0x3FF2353F,0x7CED9168, 0x3FDAD7A0,0xF5DEA083,
	0x3FF23958,0x10624DD3, 0x3FDAC8C0,0x81CD9BE1,
	0x3FF23D70,0xA3D70A3D, 0x3FDAB9DE,0x4C5F6434,
	0x3FF24189,0x374BC6A8, 0x3FDAAAFA,0x568DAE24,
	0x3FF245A1,0xCAC08312, 0x3FDA9C14,0xA1524BCD,
	0x3FF249BA,0x5E353F7D, 0x3FDA8D2D,0x2DA72C8B,
	0x3FF24DD2,0xF1A9FBE7, 0x3FDA7E43,0xFC865D0F,
	0x3FF251EB,0x851EB852, 0x3FDA6F59,0x0EEA0729,
	0x3FF25604,0x189374BC, 0x3FDA606C,0x65CC71DB,
	0x3FF25A1C,0xAC083127, 0x3FDA517E,0x0228012A,
	0x3FF25E35,0x3F7CED91, 0x3FDA428D,0xE4F73627,
	0x3FF2624D,0xD2F1A9FC, 0x3FDA339C,0x0F34AEC6,
	0x3FF26666,0x66666666, 0x3FDA24A8,0x81DB25EB,
	0x3FF26A7E,0xF9DB22D1, 0x3FDA15B3,0x3DE57336,
	0x3FF26E97,0x8D4FDF3B, 0x3FDA06BC,0x444E8B19,
	0x3FF272B0,0x20C49BA6, 0x3FD9F7C3,0x96117EA3,
	0x3FF276C8,0xB4395810, 0x3FD9E8C9,0x34297B8F,
	0x3FF27AE1,0x47AE147B, 0x3FD9D9CD,0x1F91CC19,
	0x3FF27EF9,0xDB22D0E5, 0x3FD9CACF,0x5945D705,
	0x3FF28312,0x6E978D50, 0x3FD9BBCF,0xE2411F79,
	0x3FF2872B,0x020C49BA, 0x3FD9ACCE,0xBB7F4501,
	0x3FF28B43,0x95810625, 0x3FD99DCB,0xE5FC0369,
	0x3FF28F5C,0x28F5C28F, 0x3FD98EC7,0x62B332C5,
	0x3FF29374,0xBC6A7EFA, 0x3FD97FC1,0x32A0C746,
	0x3FF2978D,0x4FDF3B64, 0x3FD970B9,0x56C0D144,
	0x3FF29BA5,0xE353F7CF, 0x3FD961AF,0xD00F7D13,
	0x3FF29FBE,0x76C8B439, 0x3FD952A4,0x9F89130D,
	0x3FF2A3D7,0x0A3D70A4, 0x3FD94397,0xC629F767,
	0x3FF2A7EF,0x9DB22D0E, 0x3FD93489,0x44EEAA3C,
	0x3FF2AC08,0x3126E979, 0x3FD92579,0x1CD3C75F,
	0x3FF2B020,0xC49BA5E3, 0x3FD91667,0x4ED60669,
	0x3FF2B439,0x5810624E, 0x3FD90753,0xDBF23A89,
	0x3FF2B851,0xEB851EB8, 0x3FD8F83E,0xC5255295,
	0x3FF2BC6A,0x7EF9DB23, 0x3FD8E928,0x0B6C58D7,
	0x3FF2C083,0x126E978D, 0x3FD8DA0F,0xAFC4731C,
	0x3FF2C49B,0xA5E353F8, 0x3FD8CAF5,0xB32AE287,
	0x3FF2C8B4,0x39581062, 0x3FD8BBDA,0x169D039C,
	0x3FF2CCCC,0xCCCCCCCD, 0x3FD8ACBC,0xDB184E14,
	0x3FF2D0E5,0x60418937, 0x3FD89D9E,0x019A54E8,
	0x3FF2D4FD,0xF3B645A2, 0x3FD88E7D,0x8B20C623,
	0x3FF2D916,0x872B020C, 0x3FD87F5B,0x78A96AF1,
	0x3FF2DD2F,0x1A9FBE77, 0x3FD87037,0xCB32276D,
	0x3FF2E147,0xAE147AE1, 0x3FD86112,0x83B8FAB3,
	0x3FF2E560,0x4189374C, 0x3FD851EB,0xA33BFEAC,
	0x3FF2E978,0xD4FDF3B6, 0x3FD842C3,0x2AB96821,
	0x3FF2ED91,0x6872B021, 0x3FD83399,0x1B2F8687,
	0x3FF2F1A9,0xFBE76C8B, 0x3FD8246D,0x759CC411,
	0x3FF2F5C2,0x8F5C28F6, 0x3FD81540,0x3AFFA57C,
	0x3FF2F9DB,0x22D0E560, 0x3FD80611,0x6C56CA24,
	0x3FF2FDF3,0xB645A1CB, 0x3FD7F6E1,0x0AA0EBCC,
	0x3FF3020C,0x49BA5E35, 0x3FD7E7AF,0x16DCDEB4,
	0x3FF30624,0xDD2F1AA0, 0x3FD7D87B,0x92099163,
	0x3FF30A3D,0x70A3D70A, 0x3FD7C946,0x7D260CBA,
	0x3FF30E56,0x04189375, 0x3FD7BA0F,0xD93173C3,
	0x3FF3126E,0x978D4FDF, 0x3FD7AAD7,0xA72B03BC,
	0x3FF31687,0x2B020C4A, 0x3FD79B9D,0xE81213ED,
	0x3FF31A9F,0xBE76C8B4, 0x3FD78C62,0x9CE615B1,
	0x3FF31EB8,0x51EB851F, 0x3FD77D25,0xC6A6944B,
	0x3FF322D0,0xE5604189, 0x3FD76DE7,0x665334EF,
	0x3FF326E9,0x78D4FDF4, 0x3FD75EA7,0x7CEBB697,
	0x3FF32B02,0x0C49BA5E, 0x3FD74F66,0x0B6FF20E,
	0x3FF32F1A,0x9FBE76C9, 0x3FD74023,0x12DFD9C3,
	0x3FF33333,0x33333333, 0x3FD730DE,0x943B79D4,
	0x3FF3374B,0xC6A7EF9E, 0x3FD72198,0x9082F7E1,
	0x3FF33B64,0x5A1CAC08, 0x3FD71251,0x08B69318,
	0x3FF33F7C,0xED916873, 0x3FD70307,0xFDD6A409,
	0x3FF34395,0x810624DD, 0x3FD6F3BD,0x70E39CAF,
	0x3FF347AE,0x147AE148, 0x3FD6E471,0x62DE0843,
	0x3FF34BC6,0xA7EF9DB2, 0x3FD6D523,0xD4C68B4B,
	0x3FF34FDF,0x3B645A1D, 0x3FD6C5D4,0xC79DE369,
	0x3FF353F7,0xCED91687, 0x3FD6B684,0x3C64E769,
	0x3FF35810,0x624DD2F2, 0x3FD6A732,0x341C8711,
	0x3FF35C28,0xF5C28F5C, 0x3FD697DE,0xAFC5CB30,
	0x3FF36041,0x89374BC7, 0x3FD68889,0xB061D56D,
	0x3FF3645A,0x1CAC0831, 0x3FD67933,0x36F1E059,
	0x3FF36872,0xB020C49C, 0x3FD669DB,0x44773F38,
	0x3FF36C8B,0x43958106, 0x3FD65A81,0xD9F35E15,
	0x3FF370A3,0xD70A3D71, 0x3FD64B26,0xF867C192,
	0x3FF374BC,0x6A7EF9DB, 0x3FD63BCA,0xA0D606F1,
	0x3FF378D4,0xFDF3B646, 0x3FD62C6C,0xD43FE3EA,
	0x3FF37CED,0x916872B0, 0x3FD61D0D,0x93A726B7,
	0x3FF38106,0x24DD2F1B, 0x3FD60DAC,0xE00DB5E2,
	0x3FF3851E,0xB851EB85, 0x3FD5FE4A,0xBA759056,
	0x3FF38937,0x4BC6A7F0, 0x3FD5EEE7,0x23E0CD2E,
	0x3FF38D4F,0xDF3B645A, 0x3FD5DF82,0x1D519BC2,
	0x3FF39168,0x72B020C5, 0x3FD5D01B,0xA7CA437A,
	0x3FF39581,0x0624DD2F, 0x3FD5C0B3,0xC44D23D9,
	0x3FF39999,0x9999999A, 0x3FD5B14A,0x73DCB44E,
	0x3FF39DB2,0x2D0E5604, 0x3FD5A1DF,0xB77B8443,
	0x3FF3A1CA,0xC083126F, 0x3FD59273,0x902C3AED,
	0x3FF3A5E3,0x53F7CED9, 0x3FD58305,0xFEF19758,
	0x3FF3A9FB,0xE76C8B44, 0x3FD57397,0x04CE703A,
	0x3FF3AE14,0x7AE147AE, 0x3FD56426,0xA2C5B3FE,
	0x3FF3B22D,0x0E560419, 0x3FD554B4,0xD9DA6896,
	0x3FF3B645,0xA1CAC083, 0x3FD54541,0xAB0FAB8A,
	0x3FF3BA5E,0x353F7CEE, 0x3FD535CD,0x1768B1C5,
	0x3FF3BE76,0xC8B43958, 0x3FD52657,0x1FE8C7A5,
	0x3FF3C28F,0x5C28F5C3, 0x3FD516DF,0xC59350CB,
	0x3FF3C6A7,0xEF9DB22D, 0x3FD50767,0x096BC829,
	0x3FF3CAC0,0x83126E98, 0x3FD4F7EC,0xEC75BFCF,
	0x3FF3CED9,0x16872B02, 0x3FD4E871,0x6FB4E100,
	0x3FF3D2F1,0xA9FBE76D, 0x3FD4D8F4,0x942CEBFA,
	0x3FF3D70A,0x3D70A3D7, 0x3FD4C976,0x5AE1B809,
	0x3FF3DB22,0xD0E56042, 0x3FD4B9F6,0xC4D73356,
	0x3FF3DF3B,0x645A1CAC, 0x3FD4AA75,0xD31162F3,
	0x3FF3E353,0xF7CED917, 0x3FD49AF3,0x869462AD,
	0x3FF3E76C,0x8B439581, 0x3FD48B6F,0xE064651B,
	0x3FF3EB85,0x1EB851EC, 0x3FD47BEA,0xE185B36A,
	0x3FF3EF9D,0xB22D0E56, 0x3FD46C64,0x8AFCAD6F,
	0x3FF3F3B6,0x45A1CAC1, 0x3FD45CDC,0xDDCDC975,
	0x3FF3F7CE,0xD916872B, 0x3FD44D53,0xDAFD944B,
	0x3FF3FBE7,0x6C8B4396, 0x3FD43DC9,0x8390B113,
	0x3FF40000,0x00000000, 0x3FD42E3D,0xD88BD952,
	0x3FF40418,0x9374BC6A, 0x3FD41EB0,0xDAF3DCC3,
	0x3FF40831,0x26E978D5, 0x3FD40F22,0x8BCDA152,
	0x3FF40C49,0xBA5E353F, 0x3FD3FF92,0xEC1E2314,
	0x3FF41062,0x4DD2F1AA, 0x3FD3F001,0xFCEA741F,
	0x3FF4147A,0xE147AE14, 0x3FD3E06F,0xBF37BC92,
	0x3FF41893,0x74BC6A7F, 0x3FD3D0DC,0x340B3A6C,
	0x3FF41CAC,0x083126E9, 0x3FD3C147,0x5C6A4195,
	0x3FF420C4,0x9BA5E354, 0x3FD3B1B1,0x395A3BAE,
	0x3FF424DD,0x2F1A9FBE, 0x3FD3A219,0xCBE0A823,
	0x3FF428F5,0xC28F5C29, 0x3FD39281,0x15031BF4,
	0x3FF42D0E,0x56041893, 0x3FD382E7,0x15C741C9,
	0x3FF43126,0xE978D4FE, 0x3FD3734B,0xCF32D9C0,
	0x3FF4353F,0x7CED9168, 0x3FD363AF,0x424BB97A,
	0x3FF43958,0x10624DD3, 0x3FD35411,0x7017CBEB,
	0x3FF43D70,0xA3D70A3D, 0x3FD34472,0x599D1168,
	0x3FF44189,0x374BC6A8, 0x3FD334D1,0xFFE19F77,
	0x3FF445A1,0xCAC08312, 0x3FD32530,0x63EBA0DD,
	0x3FF449BA,0x5E353F7D, 0x3FD3158D,0x86C1556D,
	0x3FF44DD2,0xF1A9FBE7, 0x3FD305E9,0x69691219,
	0x3FF451EB,0x851EB852, 0x3FD2F644,0x0CE940BB,
	0x3FF45604,0x189374BC, 0x3FD2E69D,0x7248602A,
	0x3FF45A1C,0xAC083127, 0x3FD2D6F5,0x9A8D0406,
	0x3FF45E35,0x3F7CED91, 0x3FD2C74C,0x86BDD4C7,
	0x3FF4624D,0xD2F1A9FC, 0x3FD2B7A2,0x37E18F8B,
	0x3FF46666,0x66666666, 0x3FD2A7F6,0xAEFF0628,
	0x3FF46A7E,0xF9DB22D1, 0x3FD29849,0xED1D1EF6,
	0x3FF46E97,0x8D4FDF3B, 0x3FD2889B,0xF342D4E1,
	0x3FF472B0,0x20C49BA6, 0x3FD278EC,0xC2773737,
	0x3FF476C8,0xB4395810, 0x3FD2693C,0x5BC169B8,
	0x3FF47AE1,0x47AE147B, 0x3FD2598A,0xC028A462,
	0x3FF47EF9,0xDB22D0E5, 0x3FD249D7,0xF0B43380,
	0x3FF48312,0x6E978D50, 0x3FD23A23,0xEE6B777E,
	0x3FF4872B,0x020C49BA, 0x3FD22A6E,0xBA55E4F0,
	0x3FF48B43,0x95810625, 0x3FD21AB8,0x557B0467,
	0x3FF48F5C,0x28F5C28F, 0x3FD20B00,0xC0E2727B,
	0x3FF49374,0xBC6A7EFA, 0x3FD1FB47,0xFD93DF9E,
	0x3FF4978D,0x4FDF3B64, 0x3FD1EB8E,0x0C971026,
	0x3FF49BA5,0xE353F7CF, 0x3FD1DBD2,0xEEF3DC22,
	0x3FF49FBE,0x76C8B439, 0x3FD1CC16,0xA5B22F62,
	0x3FF4A3D7,0x0A3D70A4, 0x3FD1BC59,0x31DA094A,
	0x3FF4A7EF,0x9DB22D0E, 0x3FD1AC9A,0x94737CE0,
	0x3FF4AC08,0x3126E979, 0x3FD19CDA,0xCE86B099,
	0x3FF4B020,0xC49BA5E3, 0x3FD18D19,0xE11BDE68,
	0x3FF4B439,0x5810624E, 0x3FD17D57,0xCD3B5392,
	0x3FF4B851,0xEB851EB8, 0x3FD16D94,0x93ED70B2,
	0x3FF4BC6A,0x7EF9DB23, 0x3FD15DD0,0x363AA993,
	0x3FF4C083,0x126E978D, 0x3FD14E0A,0xB52B8536,
	0x3FF4C49B,0xA5E353F8, 0x3FD13E44,0x11C89DA8,
	0x3FF4C8B4,0x39581062, 0x3FD12E7C,0x4D1AA008,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FD11EB3,0x682A4C5F,
	0x3FF4D0E5,0x60418937, 0x3FD10EE9,0x640075A8,
	0x3FF4D4FD,0xF3B645A2, 0x3FD0FF1E,0x41A601A1,
	0x3FF4D916,0x872B020C, 0x3FD0EF52,0x0223E8DA,
	0x3FF4DD2F,0x1A9FBE77, 0x3FD0DF84,0xA6833683,
	0x3FF4E147,0xAE147AE1, 0x3FD0CFB6,0x2FCD0879,
	0x3FF4E560,0x4189374C, 0x3FD0BFE6,0x9F0A8F1A,
	0x3FF4E978,0xD4FDF3B6, 0x3FD0B015,0xF5450D4D,
	0x3FF4ED91,0x6872B021, 0x3FD0A044,0x3385D853,
	0x3FF4F1A9,0xFBE76C8B, 0x3FD09071,0x5AD657DA,
	0x3FF4F5C2,0x8F5C28F6, 0x3FD0809D,0x6C4005C5,
	0x3FF4F9DB,0x22D0E560, 0x3FD070C8,0x68CC6E3C,
	0x3FF4FDF3,0xB645A1CB, 0x3FD060F2,0x51852F80,
	0x3FF5020C,0x49BA5E35, 0x3FD0511B,0x2773F9F3,
	0x3FF50624,0xDD2F1AA0, 0x3FD04142,0xEBA28FE9,
	0x3FF50A3D,0x70A3D70A, 0x3FD03169,0x9F1AC5B8,
	0x3FF50E56,0x04189375, 0x3FD0218F,0x42E68185,
	0x3FF5126E,0x978D4FDF, 0x3FD011B3,0xD80FBB52,
	0x3FF51687,0x2B020C4A, 0x3FD001D7,0x5FA07CD0,
	0x3FF51A9F,0xBE76C8B4, 0x3FCFE3F3,0xB545C2CE,
	0x3FF51EB8,0x51EB851F, 0x3FCFC436,0x94422C19,
	0x3FF522D0,0xE5604189, 0x3FCFA477,0x5E4AB298,
	0x3FF526E9,0x78D4FDF4, 0x3FCF84B6,0x1573F632,
	0x3FF52B02,0x0C49BA5E, 0x3FCF64F2,0xBBD2B9B6,
	0x3FF52F1A,0x9FBE76C9, 0x3FCF452D,0x537BE27D,
	0x3FF53333,0x33333333, 0x3FCF2565,0xDE847882,
	0x3FF5374B,0xC6A7EF9E, 0x3FCF059C,0x5F01A605,
	0x3FF53B64,0x5A1CAC08, 0x3FCEE5D0,0xD708B7A3,
	0x3FF53F7C,0xED916873, 0x3FCEC603,0x48AF1BF4,
	0x3FF54395,0x810624DD, 0x3FCEA633,0xB60A63AB,
	0x3FF547AE,0x147AE148, 0x3FCE8662,0x21304130,
	0x3FF54BC6,0xA7EF9DB2, 0x3FCE668E,0x8C3688BE,
	0x3FF54FDF,0x3B645A1D, 0x3FCE46B8,0xF9333000,
	0x3FF553F7,0xCED91687, 0x3FCE26E1,0x6A3C4E2E,
	0x3FF55810,0x624DD2F2, 0x3FCE0707,0xE1681BAA,
	0x3FF55C28,0xF5C28F5C, 0x3FCDE72C,0x60CCF21E,
	0x3FF56041,0x89374BC7, 0x3FCDC74E,0xEA814C15,
	0x3FF5645A,0x1CAC0831, 0x3FCDA76F,0x809BC51F,
	0x3FF56872,0xB020C49C, 0x3FCD878E,0x25331967,
	0x3FF56C8B,0x43958106, 0x3FCD67AA,0xDA5E25D3,
	0x3FF570A3,0xD70A3D71, 0x3FCD47C5,0xA233E7A3,
	0x3FF574BC,0x6A7EF9DB, 0x3FCD27DE,0x7ECB7C8A,
	0x3FF578D4,0xFDF3B646, 0x3FCD07F5,0x723C224C,
	0x3FF57CED,0x916872B0, 0x3FCCE80A,0x7E9D36DE,
	0x3FF58106,0x24DD2F1B, 0x3FCCC81D,0xA60637FF,
	0x3FF5851E,0xB851EB85, 0x3FCCA82E,0xEA8EC355,
	0x3FF58937,0x4BC6A7F0, 0x3FCC883E,0x4E4E960F,
	0x3FF58D4F,0xDF3B645A, 0x3FCC684B,0xD35D8CFB,
	0x3FF59168,0x72B020C5, 0x3FCC4857,0x7BD3A428,
	0x3FF59581,0x0624DD2F, 0x3FCC2861,0x49C8F6FF,
	0x3FF59999,0x9999999A, 0x3FCC0869,0x3F55BFE4,
	0x3FF59DB2,0x2D0E5604, 0x3FCBE86F,0x5E92584F,
	0x3FF5A1CA,0xC083126F, 0x3FCBC873,0xA997386C,
	0x3FF5A5E3,0x53F7CED9, 0x3FCBA876,0x227CF736,
	0x3FF5A9FB,0xE76C8B44, 0x3FCB8876,0xCB5C4A13,
	0x3FF5AE14,0x7AE147AE, 0x3FCB6875,0xA64E04F3,
	0x3FF5B22D,0x0E560419, 0x3FCB4872,0xB56B19ED,
	0x3FF5B645,0xA1CAC083, 0x3FCB286D,0xFACC9958,
	0x3FF5BA5E,0x353F7CEE, 0x3FCB0867,0x788BB16C,
	0x3FF5BE76,0xC8B43958, 0x3FCAE85F,0x30C1AE5E,
	0x3FF5C28F,0x5C28F5C3, 0x3FCAC855,0x2587F9FC,
	0x3FF5C6A7,0xEF9DB22D, 0x3FCAA849,0x58F81BC8,
	0x3FF5CAC0,0x83126E98, 0x3FCA883B,0xCD2BB898,
	0x3FF5CED9,0x16872B02, 0x3FCA682C,0x843C92B1,
	0x3FF5D2F1,0xA9FBE76D, 0x3FCA481B,0x80448964,
	0x3FF5D70A,0x3D70A3D7, 0x3FCA2808,0xC35D992D,
	0x3FF5DB22,0xD0E56042, 0x3FCA07F4,0x4FA1DB4A,
	0x3FF5DF3B,0x645A1CAC, 0x3FC9E7DE,0x272B85DD,
	0x3FF5E353,0xF7CED917, 0x3FC9C7C6,0x4C14EB89,
	0x3FF5E76C,0x8B439581, 0x3FC9A7AC,0xC0787B89,
	0x3FF5EB85,0x1EB851EC, 0x3FC98791,0x8670C154,
	0x3FF5EF9D,0xB22D0E56, 0x3FC96774,0xA01864B5,
	0x3FF5F3B6,0x45A1CAC1, 0x3FC94756,0x0F8A2968,
	0x3FF5F7CE,0xD916872B, 0x3FC92735,0xD6E0EF39,
	0x3FF5FBE7,0x6C8B4396, 0x3FC90713,0xF837B19E,
	0x3FF60000,0x00000000, 0x3FC8E6F0,0x75A987D6,
	0x3FF60418,0x9374BC6A, 0x3FC8C6CB,0x5151A48D,
	0x3FF60831,0x26E978D5, 0x3FC8A6A4,0x8D4B55CF,
	0x3FF60C49,0xBA5E353F, 0x3FC8867C,0x2BB204FE,
	0x3FF61062,0x4DD2F1AA, 0x3FC86652,0x2EA13679,
	0x3FF6147A,0xE147AE14, 0x3FC84626,0x983489B3,
	0x3FF61893,0x74BC6A7F, 0x3FC825F9,0x6A87B8D6,
	0x3FF61CAC,0x083126E9, 0x3FC805CA,0xA7B698D9,
	0x3FF620C4,0x9BA5E354, 0x3FC7E59A,0x51DD1924,
	0x3FF624DD,0x2F1A9FBE, 0x3FC7C568,0x6B1743A5,
	0x3FF628F5,0xC28F5C29, 0x3FC7A534,0xF5813C74,
	0x3FF62D0E,0x56041893, 0x3FC784FF,0xF33741E9,
	0x3FF63126,0xE978D4FE, 0x3FC764C9,0x6655AC3E,
	0x3FF6353F,0x7CED9168, 0x3FC74491,0x50F8EDA7,
	0x3FF63958,0x10624DD3, 0x3FC72457,0xB53D91F2,
	0x3FF63D70,0xA3D70A3D, 0x3FC7041C,0x95403EA2,
	0x3FF64189,0x374BC6A8, 0x3FC6E3DF,0xF31DB28B,
	0x3FF645A1,0xCAC08312, 0x3FC6C3A1,0xD0F2C5F2,
	0x3FF649BA,0x5E353F7D, 0x3FC6A362,0x30DC6A25,
	0x3FF64DD2,0xF1A9FBE7, 0x3FC68321,0x14F7A999,
	0x3FF651EB,0x851EB852, 0x3FC662DE,0x7F61A789,
	0x3FF65604,0x189374BC, 0x3FC6429A,0x7237A00F,
	0x3FF65A1C,0xAC083127, 0x3FC62254,0xEF96E7C3,
	0x3FF65E35,0x3F7CED91, 0x3FC6020D,0xF99CEBD6,
	0x3FF6624D,0xD2F1A9FC, 0x3FC5E1C5,0x926731AF,
	0x3FF66666,0x66666666, 0x3FC5C17B,0xBC13570B,
	0x3FF66A7E,0xF9DB22D1, 0x3FC5A130,0x78BF1191,
	0x3FF66E97,0x8D4FDF3B, 0x3FC580E3,0xCA882EF7,
	0x3FF672B0,0x20C49BA6, 0x3FC56095,0xB38C949B,
	0x3FF676C8,0xB4395810, 0x3FC54046,0x35EA3F9E,
	0x3FF67AE1,0x47AE147B, 0x3FC51FF5,0x53BF4485,
	0x3FF67EF9,0xDB22D0E5, 0x3FC4FFA3,0x0F29CF50,
	0x3FF68312,0x6E978D50, 0x3FC4DF4F,0x6A48231A,
	0x3FF6872B,0x020C49BA, 0x3FC4BEFA,0x67389A35,
	0x3FF68B43,0x95810625, 0x3FC49EA4,0x0819A5C5,
	0x3FF68F5C,0x28F5C28F, 0x3FC47E4C,0x4F09CDDF,
	0x3FF69374,0xBC6A7EFA, 0x3FC45DF3,0x3E27B123,
	0x3FF6978D,0x4FDF3B64, 0x3FC43D98,0xD79204D9,
	0x3FF69BA5,0xE353F7CF, 0x3FC41D3D,0x1D67948F,
	0x3FF69FBE,0x76C8B439, 0x3FC3FCE0,0x11C74233,
	0x3FF6A3D7,0x0A3D70A4, 0x3FC3DC81,0xB6D005B1,
	0x3FF6A7EF,0x9DB22D0E, 0x3FC3BC22,0x0EA0ED0F,
	0x3FF6AC08,0x3126E979, 0x3FC39BC1,0x1B591C0B,
	0x3FF6B020,0xC49BA5E3, 0x3FC37B5E,0xDF17CC33,
	0x3FF6B439,0x5810624E, 0x3FC35AFB,0x5BFC4C87,
	0x3FF6B851,0xEB851EB8, 0x3FC33A96,0x94260190,
	0x3FF6BC6A,0x7EF9DB23, 0x3FC31A30,0x89B46502,
	0x3FF6C083,0x126E978D, 0x3FC2F9C9,0x3EC705D4,
	0x3FF6C49B,0xA5E353F8, 0x3FC2D960,0xB57D87DD,
	0x3FF6C8B4,0x39581062, 0x3FC2B8F6,0xEFF7A3F2,
	0x3FF6CCCC,0xCCCCCCCD, 0x3FC2988B,0xF0552782,
	0x3FF6D0E5,0x60418937, 0x3FC2781F,0xB8B5F4B2,
	0x3FF6D4FD,0xF3B645A2, 0x3FC257B2,0x4B3A01F7,
	0x3FF6D916,0x872B020C, 0x3FC23743,0xAA015A39,
	0x3FF6DD2F,0x1A9FBE77, 0x3FC216D3,0xD72C1C66,
	0x3FF6E147,0xAE147AE1, 0x3FC1F662,0xD4DA7B97,
	0x3FF6E560,0x4189374C, 0x3FC1D5F0,0xA52CBEA6,
	0x3FF6E978,0xD4FDF3B6, 0x3FC1B57D,0x4A434050,
	0x3FF6ED91,0x6872B021, 0x3FC19508,0xC63E6ECC,
	0x3FF6F1A9,0xFBE76C8B, 0x3FC17493,0x1B3ECBEA,
	0x3FF6F5C2,0x8F5C28F6, 0x3FC1541C,0x4B64ECAF,
	0x3FF6F9DB,0x22D0E560, 0x3FC133A4,0x58D17972,
	0x3FF6FDF3,0xB645A1CB, 0x3FC1132B,0x45A52D77,
	0x3FF7020C,0x49BA5E35, 0x3FC0F2B1,0x1400D70B,
	0x3FF70624,0xDD2F1AA0, 0x3FC0D235,0xC6055722,
	0x3FF70A3D,0x70A3D70A, 0x3FC0B1B9,0x5DD3A173,
	0x3FF70E56,0x04189375, 0x3FC0913B,0xDD8CBC13,
	0x3FF7126E,0x978D4FDF, 0x3FC070BD,0x4751BF93,
	0x3FF71687,0x2B020C4A, 0x3FC0503D,0x9D43D699,
	0x3FF71A9F,0xBE76C8B4, 0x3FC02FBC,0xE1843E00,
	0x3FF71EB8,0x51EB851F, 0x3FC00F3B,0x16344474,
	0x3FF722D0,0xE5604189, 0x3FBFDD70,0x7AEA9516,
	0x3FF726E9,0x78D4FDF4, 0x3FBF9C68,0xB2D184CA,
	0x3FF72B02,0x0C49BA5E, 0x3FBF5B5E,0xD8605F8A,
	0x3FF72F1A,0x9FBE76C9, 0x3FBF1A52,0xEFDA4F61,
	0x3FF73333,0x33333333, 0x3FBED944,0xFD82A112,
	0x3FF7374B,0xC6A7EF9E, 0x3FBE9835,0x059CC352,
	0x3FF73B64,0x5A1CAC08, 0x3FBE5723,0x0C6C4704,
	0x3FF73F7C,0xED916873, 0x3FBE160F,0x1634DE6D,
	0x3FF74395,0x810624DD, 0x3FBDD4F9,0x273A5D6D,
	0x3FF747AE,0x147AE148, 0x3FBD93E1,0x43C0B8BA,
	0x3FF74BC6,0xA7EF9DB2, 0x3FBD52C7,0x700C0617,
	0x3FF74FDF,0x3B645A1D, 0x3FBD11AB,0xB0607B8B,
	0x3FF753F7,0xCED91687, 0x3FBCD08E,0x09026F9C,
	0x3FF75810,0x624DD2F2, 0x3FBC8F6E,0x7E365886,
	0x3FF75C28,0xF5C28F5C, 0x3FBC4E4D,0x1440CC73,
	0x3FF76041,0x89374BC7, 0x3FBC0D29,0xCF6680B5,
	0x3FF7645A,0x1CAC0831, 0x3FBBCC04,0xB3EC49FD,
	0x3FF76872,0xB020C49C, 0x3FBB8ADD,0xC6171B93,
	0x3FF76C8B,0x43958106, 0x3FBB49B5,0x0A2C0790,
	0x3FF770A3,0xD70A3D71, 0x3FBB088A,0x84703E15,
	0x3FF774BC,0x6A7EF9DB, 0x3FBAC75E,0x39290D85,
	0x3FF778D4,0xFDF3B646, 0x3FBA8630,0x2C9BE1BB,
	0x3FF77CED,0x916872B0, 0x3FBA4500,0x630E4443,
	0x3FF78106,0x24DD2F1B, 0x3FBA03CE,0xE0C5DB95,
	0x3FF7851E,0xB851EB85, 0x3FB9C29B,0xAA086B4A,
	0x3FF78937,0x4BC6A7F0, 0x3FB98166,0xC31BD354,
	0x3FF78D4F,0xDF3B645A, 0x3FB94030,0x3046103B,
	0x3FF79168,0x72B020C5, 0x3FB8FEF7,0xF5CD3A50,
	0x3FF79581,0x0624DD2F, 0x3FB8BDBE,0x17F785E8,
	0x3FF79999,0x9999999A, 0x3FB87C82,0x9B0B4294,
	0x3FF79DB2,0x2D0E5604, 0x3FB83B45,0x834EDB58,
	0x3FF7A1CA,0xC083126F, 0x3FB7FA06,0xD508D5E6,
	0x3FF7A5E3,0x53F7CED9, 0x3FB7B8C6,0x947FD2D3,
	0x3FF7A9FB,0xE76C8B44, 0x3FB77784,0xC5FA8CD2,
	0x3FF7AE14,0x7AE147AE, 0x3FB73641,0x6DBFD8EA,
	0x3FF7B22D,0x0E560419, 0x3FB6F4FC,0x9016A5AF,
	0x3FF7B645,0xA1CAC083, 0x3FB6B3B6,0x3145FB7E,
	0x3FF7BA5E,0x353F7CEE, 0x3FB6726E,0x5594FBAD,
	0x3FF7BE76,0xC8B43958, 0x3FB63125,0x014AE0CB,
	0x3FF7C28F,0x5C28F5C3, 0x3FB5EFDA,0x38AEFDD5,
	0x3FF7C6A7,0xEF9DB22D, 0x3FB5AE8E,0x0008BE6E,
	0x3FF7CAC0,0x83126E98, 0x3FB56D40,0x5B9FA617,
	0x3FF7CED9,0x16872B02, 0x3FB52BF1,0x4FBB5069,
	0x3FF7D2F1,0xA9FBE76D, 0x3FB4EAA0,0xE0A3704C,
	0x3FF7D70A,0x3D70A3D7, 0x3FB4A94F,0x129FD030,
	0x3FF7DB22,0xD0E56042, 0x3FB467FB,0xE9F85141,
	0x3FF7DF3B,0x645A1CAC, 0x3FB426A7,0x6AF4EBA7,
	0x3FF7E353,0xF7CED917, 0x3FB3E551,0x99DDADB8,
	0x3FF7E76C,0x8B439581, 0x3FB3A3FA,0x7AFABC32,
	0x3FF7EB85,0x1EB851EC, 0x3FB362A2,0x12945172,
	0x3FF7EF9D,0xB22D0E56, 0x3FB32148,0x64F2BDAF,
	0x3FF7F3B6,0x45A1CAC1, 0x3FB2DFED,0x765E6631,
	0x3FF7F7CE,0xD916872B, 0x3FB29E91,0x4B1FC587,
	0x3FF7FBE7,0x6C8B4396, 0x3FB25D33,0xE77F6AC0,
	0x3FF80000,0x00000000, 0x3FB21BD5,0x4FC5F9A7,
	0x3FF80418,0x9374BC6A, 0x3FB1DA75,0x883C2A06,
	0x3FF80831,0x26E978D5, 0x3FB19914,0x952AC790,
	0x3FF80C49,0xBA5E353F, 0x3FB157B2,0x7ADAB1C9,
	0x3FF81062,0x4DD2F1AA, 0x3FB1164F,0x3D94DB50,
	0x3FF8147A,0xE147AE14, 0x3FB0D4EA,0xE1A24A14,
	0x3FF81893,0x74BC6A7F, 0x3FB09385,0x6B4C168F,
	0x3FF81CAC,0x083126E9, 0x3FB0521E,0xDEDB6BFC,
	0x3FF820C4,0x9BA5E354, 0x3FB010B7,0x4099878E,
	0x3FF824DD,0x2F1A9FBE, 0x3FAF9E9D,0x299F715A,
	0x3FF828F5,0xC28F5C29, 0x3FAF1BC9,0xBF8EC052,
	0x3FF82D0E,0x56041893, 0x3FAE98F4,0x4B93E0E9,
	0x3FF83126,0xE978D4FE, 0x3FAE161C,0xD641D9BA,
	0x3FF8353F,0x7CED9168, 0x3FAD9343,0x682BD381,
	0x3FF83958,0x10624DD3, 0x3FAD1068,0x09E51792,
	0x3FF83D70,0xA3D70A3D, 0x3FAC8D8A,0xC4011043,
	0x3FF84189,0x374BC6A8, 0x3FAC0AAB,0x9F134761,
	0x3FF845A1,0xCAC08312, 0x3FAB87CA,0xA3AF669C,
	0x3FF849BA,0x5E353F7D, 0x3FAB04E7,0xDA6935FA,
	0x3FF84DD2,0xF1A9FBE7, 0x3FAA8203,0x4BD49C47,
	0x3FF851EB,0x851EB852, 0x3FA9FF1D,0x00859D82,
	0x3FF85604,0x189374BC, 0x3FA97C35,0x01105B51,
	0x3FF85A1C,0xAC083127, 0x3FA8F94B,0x5609136F,
	0x3FF85E35,0x3F7CED91, 0x3FA87660,0x0804201D,
	0x3FF8624D,0xD2F1A9FC, 0x3FA7F373,0x1F95F690,
	0x3FF86666,0x66666666, 0x3FA77084,0xA5532764,
	0x3FF86A7E,0xF9DB22D1, 0x3FA6ED94,0xA1D05D09,
	0x3FF86E97,0x8D4FDF3B, 0x3FA66AA3,0x1DA25C37,
	0x3FF872B0,0x20C49BA6, 0x3FA5E7B0,0x215E025A,
	0x3FF876C8,0xB4395810, 0x3FA564BB,0xB5984603,
	0x3FF87AE1,0x47AE147B, 0x3FA4E1C5,0xE2E6355C,
	0x3FF87EF9,0xDB22D0E5, 0x3FA45ECE,0xB1DCF690,
	0x3FF88312,0x6E978D50, 0x3FA3DBD6,0x2B11C643,
	0x3FF8872B,0x020C49BA, 0x3FA358DC,0x5719F7FF,
	0x3FF88B43,0x95810625, 0x3FA2D5E1,0x3E8AF4A2,
	0x3FF88F5C,0x28F5C28F, 0x3FA252E4,0xE9FA3AD0,
	0x3FF89374,0xBC6A7EFA, 0x3FA1CFE7,0x61FD5D63,
	0x3FF8978D,0x4FDF3B64, 0x3FA14CE8,0xAF2A03DC,
	0x3FF89BA5,0xE353F7CF, 0x3FA0C9E8,0xDA15E8D0,
	0x3FF89FBE,0x76C8B439, 0x3FA046E7,0xEB56DA59,
	0x3FF8A3D7,0x0A3D70A4, 0x3F9F87CB,0xD7057113,
	0x3FF8A7EF,0x9DB22D0E, 0x3F9E81C5,0xC65EEBAE,
	0x3FF8AC08,0x3126E979, 0x3F9D7BBD,0xB5E62B1A,
	0x3FF8B020,0xC49BA5E3, 0x3F9C75B3,0xB6C7587B,
	0x3FF8B439,0x5810624E, 0x3F9B6FA7,0xDA2EBC5D,
	0x3FF8B851,0xEB851EB8, 0x3F9A699A,0x3148BF98,
	0x3FF8BC6A,0x7EF9DB23, 0x3F99638A,0xCD41E830,
	0x3FF8C083,0x126E978D, 0x3F985D79,0xBF46DA32,
	0x3FF8C49B,0xA5E353F8, 0x3F975767,0x18845494,
	0x3FF8C8B4,0x39581062, 0x3F965152,0xEA273219,
	0x3FF8CCCC,0xCCCCCCCD, 0x3F954B3D,0x455C662C,
	0x3FF8D0E5,0x60418937, 0x3F944526,0x3B50FDC3,
	0x3FF8D4FD,0xF3B645A2, 0x3F933F0D,0xDD321C3D,
	0x3FF8D916,0x872B020C, 0x3F9238F4,0x3C2CFC43,
	0x3FF8DD2F,0x1A9FBE77, 0x3F9132D9,0x696EECA7,
	0x3FF8E147,0xAE147AE1, 0x3F902CBD,0x76255144,
	0x3FF8E560,0x4189374C, 0x3F8E4D40,0xE6FB3FBC,
	0x3FF8E978,0xD4FDF3B6, 0x3F8C4104,0xE54AC206,
	0x3FF8ED91,0x6872B021, 0x3F8A34C7,0x099459CF,
	0x3FF8F1A9,0xFBE76C8B, 0x3F882887,0x76335895,
	0x3FF8F5C2,0x8F5C28F6, 0x3F861C46,0x4D832AA4,
	0x3FF8F9DB,0x22D0E560, 0x3F841003,0xB1DF58D9,
	0x3FF8FDF3,0xB645A1CB, 0x3F8203BF,0xC5A3825E,
	0x3FF9020C,0x49BA5E35, 0x3F7FEEF5,0x5656BCE0,
	0x3FF90624,0xDD2F1AA0, 0x3F7BD669,0x09A56C2F,
	0x3FF90A3D,0x70A3D70A, 0x3F77BDDA,0xE9EACBDB,
	0x3FF90E56,0x04189375, 0x3F73A54B,0x3BDEAFAE,
	0x3FF9126E,0x978D4FDF, 0x3F6F1974,0x8872131E,
	0x3FF91687,0x2B020C4A, 0x3F66E850,0x8F63B9FC,
	0x3FF91A9F,0xBE76C8B4, 0x3F5D6E56,0x2C050A4C,
	0x3FF91EB8,0x51EB851F, 0x3F4A1812,0x96FADBFB,
	0x3FF922D0,0xE5604189, 0xBF2AB223,0x7F755EA9,
	0x3FF926E9,0x78D4FDF4, 0xBF53B891,0xF35E8FB4,
	0x3FF92B02,0x0C49BA5E, 0xBF620D6F,0x15F8BEEA,
	0x3FF92F1A,0x9FBE76C9, 0xBF6A3E94,0x03636E0B,
	0x3FF93333,0x33333333, 0xBF7137DB,0x9C3F8A04,
	0x3FF9374B,0xC6A7EF9E, 0xBF75506C,0x15EDCA44,
	0x3FF93B64,0x5A1CAC08, 0xBF7968FB,0x2A047886,
	0x3FF93F7C,0xED916873, 0xBF7D8188,0x93CBB0FB,
	0x3FF94395,0x810624DD, 0xBF80CD0A,0x0745D3E2,
	0x3FF947AE,0x147AE148, 0xBF82D94E,0xAAC65ABB,
	0x3FF94BC6,0xA7EF9DB2, 0xBF84E592,0x120BA9C8,
	0x3FF94FDF,0x3B645A1D, 0xBF86F1D4,0x1ABA1487,
	0x3FF953F7,0xCED91687, 0xBF88FE14,0xA276036D,
	0x3FF95810,0x624DD2F2, 0xBF8B0A53,0x86E3FA29,
	0x3FF95C28,0xF5C28F5C, 0xBF8D1690,0xA5A895E7,
	0x3FF96041,0x89374BC7, 0xBF8F22CB,0xDC68938C,
	0x3FF9645A,0x1CAC0831, 0xBF909782,0x846466FD,
	0x3FF96872,0xB020C49C, 0xBF919D9E,0x04372227,
	0x3FF96C8B,0x43958106, 0xBF92A3B8,0x5C7F0C11,
	0x3FF970A3,0xD70A3D71, 0xBF93A9D1,0x7C0EC9E7,
	0x3FF974BC,0x6A7EF9DB, 0xBF94AFE9,0x51B91451,
	0x3FF978D4,0xFDF3B646, 0xBF95B5FF,0xCC50BA99,
	0x3FF97CED,0x916872B0, 0xBF96BC14,0xDAA8A1C7,
	0x3FF98106,0x24DD2F1B, 0xBF97C228,0x6B93C7C0,
	0x3FF9851E,0xB851EB85, 0xBF98C83A,0x6DE5426B,
	0x3FF98937,0x4BC6A7F0, 0xBF99CE4A,0xD07042CC,
	0x3FF98D4F,0xDF3B645A, 0xBF9AD459,0x82081429,
	0x3FF99168,0x72B020C5, 0xBF9BDA66,0x71801F27,
	0x3FF99581,0x0624DD2F, 0xBF9CE071,0x8DABE8E9,
	0x3FF99999,0x9999999A, 0xBF9DE67A,0xC55F1633,
	0x3FF9C28F,0x5C28F5C3, 0xBFA41130,0x0D5A577C,
	0x3FF9EB85,0x1EB851EC, 0xBFA92E9F,0x353A306B,
	0x3FFA147A,0xE147AE14, 0xBFAE4B69,0x54DF58F0,
	0x3FFA3D70,0xA3D70A3D, 0xBFB1B3B6,0x7589D014,
	0x3FFA6666,0x66666666, 0xBFB44144,0x3DDAF9D1,
	0x3FFA8F5C,0x28F5C28F, 0xBFB6CE4D,0x484AE8DE,
	0x3FFAB851,0xEB851EB8, 0xBFB95AC0,0xDD274A32,
	0x3FFAE147,0xAE147AE1, 0xBFBBE68E,0x489147C2,
	0x3FFB0A3D,0x70A3D70A, 0xBFBE71A4,0xDAEAFE97,
	0x3FFB3333,0x33333333, 0xBFC07DF9,0xF4A26C86,
	0x3FFB5C28,0xF5C28F5C, 0xBFC1C2B5,0x66E56530,
	0x3FFB851E,0xB851EB85, 0xBFC306FC,0x7418B465,
	0x3FFBAE14,0x7AE147AE, 0xBFC44AC6,0xCF1171A2,
	0x3FFBD70A,0x3D70A3D7, 0xBFC58E0C,0x2DD5E82E,
	0x3FFC0000,0x00000000, 0xBFC6D0C4,0x49D3E98A,
	0x3FFC28F5,0xC28F5C29, 0xBFC812E6,0xE017099D,
	0x3FFC51EB,0x851EB852, 0xBFC9546B,0xB17EC324,
	0x3FFC7AE1,0x47AE147B, 0xBFCA954A,0x82F48311,
	0x3FFCA3D7,0x0A3D70A4, 0xBFCBD57B,0x1DA19971,
	0x3FFCCCCC,0xCCCCCCCD, 0xBFCD14F5,0x4F250E7A,
	0x3FFCF5C2,0x8F5C28F6, 0xBFCE53B0,0xE9C95A58,
	0x3FFD1EB8,0x51EB851F, 0xBFCF91A5,0xC4B9FE6D,
	0x3FFD47AE,0x147AE148, 0xBFD06765,0xDE1C7F43,
	0x3FFD70A3,0xD70A3D71, 0xBFD1058D,0x58EA1C64,
	0x3FFD9999,0x9999999A, 0xBFD1A345,0x464D4D6E,
	0x3FFDC28F,0x5C28F5C3, 0xBFD24089,0x9CA89989,
	0x3FFDEB85,0x1EB851EC, 0xBFD2DD56,0x55540E05,
	0x3FFE147A,0xE147AE14, 0xBFD379A7,0x6CB7A0CC,
	0x3FFE3D70,0xA3D70A3D, 0xBFD41578,0xE2657ED4,
	0x3FFE6666,0x66666666, 0xBFD4B0C6,0xB93445AB,
	0x3FFE8F5C,0x28F5C28F, 0xBFD54B8C,0xF75927C0,
	0x3FFEB851,0xEB851EB8, 0xBFD5E5C7,0xA681FA89,
	0x3FFEE147,0xAE147AE1, 0xBFD67F72,0xD3EF2DE3,
	0x3FFF0A3D,0x70A3D70A, 0xBFD7188A,0x908DAC14,
	0x3FFF3333,0x33333333, 0xBFD7B10A,0xF110A1B0,
	0x3FFF5C28,0xF5C28F5C, 0xBFD848F0,0x0E0B2CC7,
	0x3FFF851E,0xB851EB85, 0xBFD8E036,0x0409F2A9,
	0x3FFFAE14,0x7AE147AE, 0xBFD976D8,0xF3AC9BA9,
	0x3FFFD70A,0x3D70A3D7, 0xBFDA0CD5,0x01BF3419,
	0x40000000,0x00000000, 0xBFDAA226,0x57537205,
	0x4000147A,0xE147AE14, 0xBFDB36C9,0x21D9DED1,
	0x400028F5,0xC28F5C29, 0xBFDBCAB9,0x933AE461,
	0x40003D70,0xA3D70A3D, 0xBFDC5DF3,0xE1EFBCA9,
	0x400051EB,0x851EB852, 0xBFDCF074,0x491B43C0,
	0x40006666,0x66666666, 0xBFDD8237,0x08A2AAED,
	0x40007AE1,0x47AE147B, 0xBFDE1338,0x65460CF2,
	0x40008F5C,0x28F5C28F, 0xBFDEA374,0xA8B8E21F,
	0x4000A3D7,0x0A3D70A4, 0xBFDF32E8,0x21BA545C,
	0x4000B851,0xEB851EB8, 0xBFDFC18F,0x242D71B0,
	0x4000CCCC,0xCCCCCCCD, 0xBFE027B3,0x04989ECA,
	0x4000E147,0xAE147AE1, 0xBFE06E34,0x979C4FBA,
	0x4000F5C2,0x8F5C28F6, 0xBFE0B44A,0x7D111769,
	0x40010A3D,0x70A3D70A, 0xBFE0F9F2,0xE9A7EDAB,
	0x40011EB8,0x51EB851F, 0xBFE13F2C,0x14DF389D,
	0x40013333,0x33333333, 0xBFE183F4,0x390E7C4A,
	0x400147AE,0x147AE148, 0xBFE1C849,0x9371F7D4,
	0x40015C28,0xF5C28F5C, 0xBFE20C2A,0x64362F76,
	0x400170A3,0xD70A3D71, 0xBFE24F94,0xEE836376,
	0x4001851E,0xB851EB85, 0xBFE29287,0x7888F359,
	0x40019999,0x9999999A, 0xBFE2D500,0x4B88AD70,
	0x4001AE14,0x7AE147AE, 0xBFE316FD,0xB3E20A13,
	0x4001C28F,0x5C28F5C3, 0xBFE3587E,0x011D529E,
	0x4001D70A,0x3D70A3D7, 0xBFE3997F,0x85F6B38B,
	0x4001EB85,0x1EB851EC, 0xBFE3DA00,0x986939C2,
	0x40020000,0x00000000, 0xBFE419FF,0x91B9BA6D,
	0x4002147A,0xE147AE14, 0xBFE4597A,0xCE81A573,
	0x400228F5,0xC28F5C29, 0xBFE49870,0xAEB9C1FF,
	0x40023D70,0xA3D70A3D, 0xBFE4D6DF,0x95C4D4E9,
	0x400251EB,0x851EB852, 0xBFE514C5,0xEA7A30E8,
	0x40026666,0x66666666, 0xBFE55222,0x17302FE1,
	0x40027AE1,0x47AE147B, 0xBFE58EF2,0x89C6958F,
	0x40028F5C,0x28F5C28F, 0xBFE5CB35,0xB3B0DAC2,
	0x4002A3D7,0x0A3D70A4, 0xBFE606EA,0x0A00615E,
	0x4002B851,0xEB851EB8, 0xBFE6420E,0x056E9079,
	0x4002CCCC,0xCCCCCCCD, 0xBFE67CA0,0x2266D8B1,
	0x4002E147,0xAE147AE1, 0xBFE6B69E,0xE110A01B,
	0x4002F5C2,0x8F5C28F6, 0xBFE6F008,0xC55915E8,
	0x40030A3D,0x70A3D70A, 0xBFE728DC,0x56FCED22,
	0x40031EB8,0x51EB851F, 0xBFE76118,0x2191FE9D,
	0x40033333,0x33333333, 0xBFE798BA,0xB490D185,
	0x400347AE,0x147AE148, 0xBFE7CFC2,0xA35E0A9E,
	0x40035C28,0xF5C28F5C, 0xBFE8062E,0x8553C1AA,
	0x400370A3,0xD70A3D71, 0xBFE83BFC,0xF5CABCFF,
	0x4003851E,0xB851EB85, 0xBFE8712C,0x942392CF,
	0x40039999,0x9999999A, 0xBFE8A5BC,0x03CFB027,
	0x4003AE14,0x7AE147AE, 0xBFE8D9A9,0xEC5A4526,
	0x4003C28F,0x5C28F5C3, 0xBFE90CF4,0xF9711676,
	0x4003D70A,0x3D70A3D7, 0xBFE93F9B,0xDAED338D,
	0x4003EB85,0x1EB851EC, 0xBFE9719D,0x44DB91B8,
	0x40040000,0x00000000, 0xBFE9A2F7,0xEF858B7D,
	0x4004147A,0xE147AE14, 0xBFE9D3AA,0x9779445D,
	0x400428F5,0xC28F5C29, 0xBFEA03B3,0xFD91F07C,
	0x40043D70,0xA3D70A3D, 0xBFEA3312,0xE7000028,
	0x400451EB,0x851EB852, 0xBFEA61C6,0x1D512F03,
	0x40046666,0x66666666, 0xBFEA8FCC,0x6E78767A,
	0x40047AE1,0x47AE147B, 0xBFEABD24,0xACD5E390,
	0x40048F5C,0x28F5C28F, 0xBFEAE9CD,0xAF3E4F7E,
	0x4004A3D7,0x0A3D70A4, 0xBFEB15C6,0x5102FB4D,
	0x4004B851,0xEB851EB8, 0xBFEB410D,0x71F90DDA,
	0x4004CCCC,0xCCCCCCCD, 0xBFEB6BA1,0xF680F470,
	0x4004E147,0xAE147AE1, 0xBFEB9582,0xC78DA573,
	0x4004F5C2,0x8F5C28F6, 0xBFEBBEAE,0xD2ABC535,
	0x40050A3D,0x70A3D70A, 0xBFEBE725,0x0A08AC8A,
	0x40051EB8,0x51EB851F, 0xBFEC0EE4,0x6479511D,
	0x40053333,0x33333333, 0xBFEC35EB,0xDD810F30,
	0x400547AE,0x147AE148, 0xBFEC5C3A,0x755854C7,
	0x40055C28,0xF5C28F5C, 0xBFEC81CF,0x30F32DDD,
	0x400570A3,0xD70A3D71, 0xBFECA6A9,0x1A07B1B0,
	0x4005851E,0xB851EB85, 0xBFECCAC7,0x3F1450C3,
	0x40059999,0x9999999A, 0xBFECEE28,0xB36603A6,
	0x4005AE14,0x7AE147AE, 0xBFED10CC,0x8F1E5A21,
	0x4005C28F,0x5C28F5C3, 0xBFED32B1,0xEF396AD0,
	0x4005D70A,0x3D70A3D7, 0xBFED53D7,0xF593A2D8,
	0x4005EB85,0x1EB851EC, 0xBFED743D,0xC8EF75BF,
	0x40060000,0x00000000, 0xBFED93E2,0x94FAED14,
	0x4006147A,0xE147AE14, 0xBFEDB2C5,0x8A5517E9,
	0x400628F5,0xC28F5C29, 0xBFEDD0E5,0xDE9359E3,
	0x40063D70,0xA3D70A3D, 0xBFEDEE42,0xCC4699C0,
	0x400651EB,0x851EB852, 0xBFEE0ADB,0x93004F43,
	0x40066666,0x66666666, 0xBFEE26AF,0x7757704A,
	0x40067AE1,0x47AE147B, 0xBFEE41BD,0xC2ED3D08,
	0x40068F5C,0x28F5C28F, 0xBFEE5C05,0xC471EB28,
	0x4006A3D7,0x0A3D70A4, 0xBFEE7586,0xCFA92FDE,
	0x4006B851,0xEB851EB8, 0xBFEE8E40,0x3D6EA89A,
	0x4006CCCC,0xCCCCCCCD, 0xBFEEA631,0x6BBA2275,
	0x4006E147,0xAE147AE1, 0xBFEEBD59,0xBDA3C008,
	0x4006F5C2,0x8F5C28F6, 0xBFEED3B8,0x9B67FDC1,
	0x40070A3D,0x70A3D70A, 0xBFEEE94D,0x726B946E,
	0x40071EB8,0x51EB851F, 0xBFEEFE17,0xB53F3A13,
	0x40073333,0x33333333, 0xBFEF1216,0xDBA340C9,
	0x400747AE,0x147AE148, 0xBFEF254A,0x628B13AA,
	0x40075C28,0xF5C28F5C, 0xBFEF37B1,0xCC2091A6,
	0x400770A3,0xD70A3D71, 0xBFEF494C,0x9FC74636,
	0x4007851E,0xB851EB85, 0xBFEF5A1A,0x6A1F7FBC,
	0x40079999,0x9999999A, 0xBFEF6A1A,0xBD0943B2,
	0x4007AE14,0x7AE147AE, 0xBFEF794D,0x2FA7204B,
	0x4007C28F,0x5C28F5C3, 0xBFEF87B1,0x5E60DBC2,
	0x4007D70A,0x3D70A3D7, 0xBFEF9546,0xEAE600FE,
	0x4007EB85,0x1EB851EC, 0xBFEFA20D,0x7C3049B5,
	0x40080000,0x00000000, 0xBFEFAE04,0xBE85E5D2,
	0x4008147A,0xE147AE14, 0xBFEFB92C,0x637BA02C,
	0x400828F5,0xC28F5C29, 0xBFEFC384,0x21F6E06F,
	0x40083D70,0xA3D70A3D, 0xBFEFCD0B,0xB62F8A36,
	0x400851EB,0x851EB852, 0xBFEFD5C2,0xE1B1B93F,
	0x40086666,0x66666666, 0xBFEFDDA9,0x6B5F5AB4,
	0x40087AE1,0x47AE147B, 0xBFEFE4BF,0x1F71A380,
	0x40088F5C,0x28F5C28F, 0xBFEFEB03,0xCF7A639D,
	0x4008A3D7,0x0A3D70A4, 0xBFEFF077,0x52653661,
	0x4008B851,0xEB851EB8, 0xBFEFF519,0x84788FB0,
	0x4008CCCC,0xCCCCCCCD, 0xBFEFF8EA,0x4756A624,
	0x4008E147,0xAE147AE1, 0xBFEFFBE9,0x81FE3A05,
	0x4008F5C2,0x8F5C28F6, 0xBFEFFE17,0x20CB3931,
	0x40090A3D,0x70A3D70A, 0xBFEFFF73,0x15773FCE,
	0x40091EB8,0x51EB851F, 0xBFEFFFFD,0x5719F5D7,
	0x40093333,0x33333333, 0xBFEFFFB5,0xE2294982,
	0x400947AE,0x147AE148, 0xBFEFFE9C,0xB879866A,
	0x40095C28,0xF5C28F5C, 0xBFEFFCB1,0xE13D499A,
	0x400970A3,0xD70A3D71, 0xBFEFF9F5,0x6905525B,
	0x4009851E,0xB851EB85, 0xBFEFF667,0x61C02FDD,
	0x40099999,0x9999999A, 0xBFEFF207,0xE2B9CBB6,
	0x4009AE14,0x7AE147AE, 0xBFEFECD7,0x089AD12E,
	0x4009C28F,0x5C28F5C3, 0xBFEFE6D4,0xF567F175,
	0x4009D70A,0x3D70A3D7, 0xBFEFE001,0xD08104AF,
	0x4009EB85,0x1EB851EC, 0xBFEFD85D,0xC6A007E8,
	0x400A0000,0x00000000, 0xBFEFCFE9,0x09D7F7F8,
	0x400A147A,0xE147AE14, 0xBFEFC6A3,0xD1938959,
	0x400A28F5,0xC28F5C29, 0xBFEFBC8E,0x5A93BCF9,
	0x400A3D70,0xA3D70A3D, 0xBFEFB1A8,0xE6EE5214,
	0x400A51EB,0x851EB852, 0xBFEFA5F3,0xBE0C1519,
	0x400A6666,0x66666666, 0xBFEF996F,0x2CA70BB6,
	0x400A7AE1,0x47AE147B, 0xBFEF8C1B,0x84C87DF9,
	0x400A8F5C,0x28F5C28F, 0xBFEF7DF9,0x1DC6DCB6,
	0x400AA3D7,0x0A3D70A4, 0xBFEF6F08,0x54438527,
	0x400AB851,0xEB851EB8, 0xBFEF5F49,0x8A2861DA,
	0x400ACCCC,0xCCCCCCCD, 0xBFEF4EBD,0x26A56907,
	0x400AE147,0xAE147AE1, 0xBFEF3D63,0x962DF84F,
	0x400AF5C2,0x8F5C28F6, 0xBFEF2B3D,0x4A760DFE,
	0x400B0A3D,0x70A3D70A, 0xBFEF184A,0xBA6F5FEA,
	0x400B1EB8,0x51EB851F, 0xBFEF048C,0x62464FE5,
	0x400B3333,0x33333333, 0xBFEEF002,0xC35EBE04,
	0x400B47AE,0x147AE148, 0xBFEEDAAE,0x6450B89B,
	0x400B5C28,0xF5C28F5C, 0xBFEEC48F,0xD0E50A38,
	0x400B70A3,0xD70A3D71, 0xBFEEADA7,0x9A11A585,
	0x400B851E,0xB851EB85, 0xBFEE95F6,0x55F5EF4B,
	0x400B9999,0x9999999A, 0xBFEE7D7C,0x9FD6E698,
	0x400BAE14,0x7AE147AE, 0xBFEE643B,0x181B2B33,
	0x400BC28F,0x5C28F5C3, 0xBFEE4A32,0x6446E264,
	0x400BD70A,0x3D70A3D7, 0xBFEE2F63,0x2EF77A47,
	0x400BEB85,0x1EB851EC, 0xBFEE13CE,0x27DF4B9A,
	0x400C0000,0x00000000, 0xBFEDF774,0x03C11A5F,
	0x400C147A,0xE147AE14, 0xBFEDDA55,0x7C6B752D,
	0x400C28F5,0xC28F5C29, 0xBFEDBC73,0x50B3F388,
	0x400C3D70,0xA3D70A3D, 0xBFED9DCE,0x44725339,
	0x400C51EB,0x851EB852, 0xBFED7E67,0x207B74D8,
	0x400C6666,0x66666666, 0xBFED5E3E,0xB29C37A4,
	0x400C7AE1,0x47AE147B, 0xBFED3D55,0xCD9434C8,
	0x400C8F5C,0x28F5C28F, 0xBFED1BAD,0x49105A38,
	0x400CA3D7,0x0A3D70A4, 0xBFECF946,0x01A5653C,
	0x400CB851,0xEB851EB8, 0xBFECD620,0xD8CA3CE2,
	0x400CCCCC,0xCCCCCCCD, 0xBFECB23E,0xB4D22C59,
	0x400CE147,0xAE147AE1, 0xBFEC8DA0,0x80E6FD8F,
	0x400CF5C2,0x8F5C28F6, 0xBFEC6847,0x2D02F3F8,
	0x400D0A3D,0x70A3D70A, 0xBFEC4233,0xADEAA7EE,
	0x400D1EB8,0x51EB851F, 0xBFEC1B66,0xFD26C281,
	0x400D3333,0x33333333, 0xBFEBF3E2,0x18FD9A38,
	0x400D47AE,0x147AE148, 0xBFEBCBA6,0x046CB098,
	0x400D5C28,0xF5C28F5C, 0xBFEBA2B3,0xC72210E8,
	0x400D70A3,0xD70A3D71, 0xBFEB790C,0x6D759014,
	0x400D851E,0xB851EB85, 0xBFEB4EB1,0x0861EE25,
	0x400D9999,0x9999999A, 0xBFEB23A2,0xAD7DD937,
	0x400DAE14,0x7AE147AE, 0xBFEAF7E2,0x76F4D258,
	0x400DC28F,0x5C28F5C3, 0xBFEACB71,0x837FF43F,
	0x400DD70A,0x3D70A3D7, 0xBFEA9E50,0xF65E9C50,
	0x400DEB85,0x1EB851EC, 0xBFEA7081,0xF74EF5D9,
	0x400E0000,0x00000000, 0xBFEA4205,0xB28667F7,
	0x400E147A,0xE147AE14, 0xBFEA12DD,0x58A9E618,
	0x400E28F5,0xC28F5C29, 0xBFE9E30A,0x1EC62384,
	0x400E3D70,0xA3D70A3D, 0xBFE9B28D,0x3E47AA03,
	0x400E51EB,0x851EB852, 0xBFE98167,0xF4F2D3C3,
	0x400E6666,0x66666666, 0xBFE94F9B,0x84DBA8EB,
	0x400E7AE1,0x47AE147B, 0xBFE91D29,0x345DA0C8,
	0x400E8F5C,0x28F5C28F, 0xBFE8EA12,0x4E134713,
	0x400EA3D7,0x0A3D70A4, 0xBFE8B658,0x20CDC53C,
	0x400EB851,0xEB851EB8, 0xBFE881FB,0xFF8C5044,
	0x400ECCCC,0xCCCCCCCD, 0xBFE84CFF,0x41737B03,
	0x400EE147,0xAE147AE1, 0xBFE81763,0x41C46D74,
	0x400EF5C2,0x8F5C28F6, 0xBFE7E129,0x5FD400DB,
	0x400F0A3D,0x70A3D70A, 0xBFE7AA52,0xFF01C167,
	0x400F1EB8,0x51EB851F, 0xBFE772E1,0x86AED527,
	0x400F3333,0x33333333, 0xBFE73AD6,0x6234C8EA,
	0x400F47AE,0x147AE148, 0xBFE70233,0x00DC42ED,
	0x400F5C28,0xF5C28F5C, 0xBFE6C8F8,0xD5D39BEF,
	0x400F70A3,0xD70A3D71, 0xBFE68F29,0x58255E91,
	0x400F851E,0xB851EB85, 0xBFE654C6,0x02AEAD8D,
	0x400F9999,0x9999999A, 0xBFE619D0,0x541590BD,
	0x400FAE14,0x7AE147AE, 0xBFE5DE49,0xCEBF2979,
	0x400FC28F,0x5C28F5C3, 0xBFE5A233,0xF8C5CE47,
	0x400FD70A,0x3D70A3D7, 0xBFE56590,0x5BEF0E57,
	0x400FEB85,0x1EB851EC, 0xBFE52860,0x85A19CDE,
	0x40100000,0x00000000, 0xBFE4EAA6,0x06DB24C1,
	0x40100A3D,0x70A3D70A, 0xBFE4AC62,0x7426049D,
	0x4010147A,0xE147AE14, 0xBFE46D97,0x658EF3A5,
	0x40101EB8,0x51EB851F, 0xBFE42E46,0x769A8F69,
	0x401028F5,0xC28F5C29, 0xBFE3EE71,0x463AD30E,
	0x40103333,0x33333333, 0xBFE3AE19,0x76C477C5,
	0x40103D70,0xA3D70A3D, 0xBFE36D40,0xADE43F5E,
	0x401047AE,0x147AE148, 0xBFE32BE8,0x949428BF,
	0x401051EB,0x851EB852, 0xBFE2EA12,0xD7108EE5,
	0x40105C28,0xF5C28F5C, 0xBFE2A7C1,0x24CD3249,
	0x40106666,0x66666666, 0xBFE264F5,0x306A2D6A,
	0x401070A3,0xD70A3D71, 0xBFE221B0,0xAFA8D471,
	0x40107AE1,0x47AE147B, 0xBFE1DDF5,0x5B60806A,
	0x4010851E,0xB851EB85, 0xBFE199C4,0xEF734612,
	0x40108F5C,0x28F5C28F, 0xBFE15521,0x2AC298E8,
	0x40109999,0x9999999A, 0xBFE1100B,0xCF23DA7C,
	0x4010A3D7,0x0A3D70A4, 0xBFE0CA86,0xA154D68B,
	0x4010AE14,0x7AE147AE, 0xBFE08493,0x68F02BC1,
	0x4010B851,0xEB851EB8, 0xBFE03E33,0xF061A208,
	0x4010C28F,0x5C28F5C3, 0xBFDFEED4,0x09B4DC5B,
	0x4010CCCC,0xCCCCCCCD, 0xBFDF606E,0xEC8AC71D,
	0x4010D70A,0x3D70A3D7, 0xBFDED13C,0x2E762740,
	0x4010E147,0xAE147AE1, 0xBFDE413F,0x79EBB85C,
	0x4010EB85,0x1EB851EC, 0xBFDDB07C,0x7E8BC86A,
	0x4010F5C2,0x8F5C28F6, 0xBFDD1EF6,0xF10A0FDD,
	0x40110000,0x00000000, 0xBFDC8CB2,0x8B1567F5,
	0x40110A3D,0x70A3D70A, 0xBFDBF9B3,0x0B3F60F2,
	0x4011147A,0xE147AE14, 0xBFDB65FC,0x34E3B807,
	0x40111EB8,0x51EB851F, 0xBFDAD191,0xD00FADDB,
	0x401128F5,0xC28F5C29, 0xBFDA3C77,0xA9693E9A,
	0x40113333,0x33333333, 0xBFD9A6B1,0x92163B53,
	0x40113D70,0xA3D70A3D, 0xBFD91043,0x5FA34669,
	0x401147AE,0x147AE148, 0xBFD87930,0xEBEAB2D4,
	0x401151EB,0x851EB852, 0xBFD7E17E,0x14FB478A,
	0x40115C28,0xF5C28F5C, 0xBFD7492E,0xBCFEE6BF,
	0x40116666,0x66666666, 0xBFD6B046,0xCA211AD8,
	0x401170A3,0xD70A3D71, 0xBFD616CA,0x267588BE,
	0x40117AE1,0x47AE147B, 0xBFD57CBC,0xBFDE48F2,
	0x4011851E,0xB851EB85, 0xBFD4E222,0x87F22719,
	0x40118F5C,0x28F5C28F, 0xBFD446FF,0x73E2C9D7,
	0x40119999,0x9999999A, 0xBFD3AB57,0x7C62C2AA,
	0x4011A3D7,0x0A3D70A4, 0xBFD30F2E,0x9D8B8730,
	0x4011AE14,0x7AE147AE, 0xBFD27288,0xD6C35386,
	0x4011B851,0xEB851EB8, 0xBFD1D56A,0x2AA2F7A3,
	0x4011C28F,0x5C28F5C3, 0xBFD137D6,0x9EDB8F5A,
	0x4011CCCC,0xCCCCCCCD, 0xBFD099D2,0x3C1C267C,
	0x4011D70A,0x3D70A3D7, 0xBFCFF6C2,0x1BEE9175,
	0x4011E147,0xAE147AE1, 0xBFCEB90E,0x4590FE71,
	0x4011EB85,0x1EB851EC, 0xBFCD7A91,0x17337707,
	0x4011F5C2,0x8F5C28F6, 0xBFCC3B52,0xB811629D,
	0x40120000,0x00000000, 0xBFCAFB5B,0x54583D6A,
	0x40120A3D,0x70A3D70A, 0xBFC9BAB3,0x1CF209C1,
	0x4012147A,0xE147AE14, 0xBFC87962,0x474FA1B8,
	0x40121EB8,0x51EB851F, 0xBFC73771,0x0D32EB2A,
	0x401228F5,0xC28F5C29, 0xBFC5F4E7,0xAC78F004,
	0x40123333,0x33333333, 0xBFC4B1CE,0x66E3DA72,
	0x40123D70,0xA3D70A3D, 0xBFC36E2D,0x81E4D8C1,
	0x401247AE,0x147AE148, 0xBFC22A0D,0x4665E862,
	0x401251EB,0x851EB852, 0xBFC0E576,0x00938AE2,
	0x40125C28,0xF5C28F5C, 0xBFBF40DF,0xFF4CC8A1,
	0x40126666,0x66666666, 0xBFBCB607,0x2B598DCA,
	0x401270A3,0xD70A3D71, 0xBFBA2A72,0x2EA856AE,
	0x40127AE1,0x47AE147B, 0xBFB79E31,0xB7653184,
	0x4012851E,0xB851EB85, 0xBFB51156,0x781FF707,
	0x40128F5C,0x28F5C28F, 0xBFB283F1,0x275EDDF2,
	0x40129999,0x9999999A, 0xBFAFEC24,0xFE61E5F2,
	0x4012A3D7,0x0A3D70A4, 0xBFAACF96,0x7980F640,
	0x4012AE14,0x7AE147AE, 0xBFA5B258,0x3FCA7E71,
	0x4012B851,0xEB851EB8, 0xBFA0948B,0xD56D9095,
	0x4012C28F,0x5C28F5C3, 0xBF96ECA5,0x847A2F19,
	0x4012CCCC,0xCCCCCCCD, 0xBF895F3A,0x43506A34,
	0x4012D70A,0x3D70A3D7, 0xBF63920C,0xDB9E96D1,
	0x4012E147,0xAE147AE1, 0x3F7F2CA7,0xCBCDF569,
	0x4012EB85,0x1EB851EC, 0x3F920862,0x6DF53129,
	0x4012F5C2,0x8F5C28F6, 0x3F9C4524,0xBB47756D,
	0x40130000,0x00000000, 0x3FA34096,0xE1D37B74,
	0x40130A3D,0x70A3D70A, 0x3FA85E1D,0x3A474690,
	0x4013147A,0xE147AE14, 0x3FAD7B03,0xE0F76592,
	0x40131EB8,0x51EB851F, 0x3FB14B94,0xA9F95981,
	0x401328F5,0xC28F5C29, 0x3FB3D936,0x0B1D182D,
	0x40133333,0x33333333, 0x3FB66655,0x584E4040,
	0x40133D70,0xA3D70A3D, 0x3FB8F2E1,0xD9489BA6,
	0x401347AE,0x147AE148, 0x3FBB7ECA,0xD98A0030,
	0x401351EB,0x851EB852, 0x3FBE09FF,0xA8BFC8DD,
	0x40135C28,0xF5C28F5C, 0x3FC04A37,0xCD9A1B1B,
	0x40136666,0x66666666, 0x3FC18F05,0x051DD6F7,
	0x401370A3,0xD70A3D71, 0x3FC2D35F,0x2A50ED81,
	0x40137AE1,0x47AE147B, 0x3FC4173D,0xEF8B5440,
	0x4013851E,0xB851EB85, 0x3FC55A99,0x0A4D8C16,
	0x40138F5C,0x28F5C28F, 0x3FC69D68,0x3376F6A7,
	0x40139999,0x9999999A, 0x3FC7DFA3,0x277C1664,
	0x4013A3D7,0x0A3D70A4, 0x3FC92141,0xA69CB65C,
	0x4013AE14,0x7AE147AE, 0x3FCA623B,0x7519FA71,
	0x4013B851,0xEB851EB8, 0x3FCBA288,0x5B6C540E,
	0x4013C28F,0x5C28F5C3, 0x3FCCE220,0x26795BF7,
	0x4013CCCC,0xCCCCCCCD, 0x3FCE20FA,0xA7C98E60,
	0x4013D70A,0x3D70A3D7, 0x3FCF5F0F,0xB5BDE9D5,
	0x4013E147,0xAE147AE1, 0x3FD04E2B,0x95E2B697,
	0x4013EB85,0x1EB851EC, 0x3FD0EC64,0x75493A8B,
	0x4013F5C2,0x8F5C28F6, 0x3FD18A2E,0x6C27FB2F,
	0x40140000,0x00000000, 0x3FD22785,0x706B4AD9,
	0x40140A3D,0x70A3D70A, 0x3FD2C465,0x7AF0CC69,
	0x4014147A,0xE147AE14, 0x3FD360CA,0x87A1D8F0,
	0x40141EB8,0x51EB851F, 0x3FD3FCB0,0x958DD15E,
	0x401428F5,0xC28F5C29, 0x3FD49813,0xA7045B45,
	0x40143333,0x33333333, 0x3FD532EF,0xC1AF88E2,
	0x40143D70,0xA3D70A3D, 0x3FD5CD40,0xEEADEA96,
	0x401447AE,0x147AE148, 0x3FD66703,0x3AAC8A13,
	0x401451EB,0x851EB852, 0x3FD70032,0xB600CDE7,
	0x40145C28,0xF5C28F5C, 0x3FD798CB,0x74C24599,
	0x40146666,0x66666666, 0x3FD830C9,0x8EE45C9C,
	0x401470A3,0xD70A3D71, 0x3FD8C829,0x204FF446,
	0x40147AE1,0x47AE147B, 0x3FD95EE6,0x48FCE382,
	0x4014851E,0xB851EB85, 0x3FD9F4FD,0x2D0B5C7E,
	0x40148F5C,0x28F5C28F, 0x3FDA8A69,0xF4DD3682,
	0x40149999,0x9999999A, 0x3FDB1F28,0xCD2F1C3E,
	0x4014A3D7,0x0A3D70A4, 0x3FDBB335,0xE7319D34,
	0x4014AE14,0x7AE147AE, 0x3FDC468D,0x78A22286,
	0x4014B851,0xEB851EB8, 0x3FDCD92B,0xBBE3C55E,
	0x4014C28F,0x5C28F5C3, 0x3FDD6B0C,0xF0180743,
	0x4014CCCC,0xCCCCCCCD, 0x3FDDFC2D,0x59376AEE,
	0x4014D70A,0x3D70A3D7, 0x3FDE8C89,0x4029EE0C,
	0x4014E147,0xAE147AE1, 0x3FDF1C1C,0xF2DF6206,
	0x4014EB85,0x1EB851EC, 0x3FDFAAE4,0xC467A434,
	0x4014F5C2,0x8F5C28F6, 0x3FE01C6E,0x86855A0E,
	0x40150000,0x00000000, 0x3FE06301,0x15305409,
	0x40150A3D,0x70A3D70A, 0x3FE0A928,0x3FB4BF36,
	0x4015147A,0xE147AE14, 0x3FE0EEE2,0x3A5265D1,
	0x40151EB8,0x51EB851F, 0x3FE1342D,0x3C14A22B,
	0x401528F5,0xC28F5C29, 0x3FE17907,0x7EDE1139,
	0x40153333,0x33333333, 0x3FE1BD6F,0x3F7432D5,
	0x40153D70,0xA3D70A3D, 0x3FE20162,0xBD8AF6C1,
	0x401547AE,0x147AE148, 0x3FE244E0,0x3BD036A5,
	0x401551EB,0x851EB852, 0x3FE287E5,0xFFF71C68,
	0x40155C28,0xF5C28F5C, 0x3FE2CA72,0x52C374F4,
	0x40156666,0x66666666, 0x3FE30C83,0x8014EEAA,
	0x401570A3,0xD70A3D71, 0x3FE34E17,0xD6F2439C,
	0x40157AE1,0x47AE147B, 0x3FE38F2D,0xA9944EF5,
	0x4015851E,0xB851EB85, 0x3FE3CFC3,0x4D710DB3,
	0x40158F5C,0x28F5C28F, 0x3FE40FD7,0x1B4689E5,
	0x40159999,0x9999999A, 0x3FE44F67,0x6F25B08C,
	0x4015A3D7,0x0A3D70A4, 0x3FE48E72,0xA87D1193,
	0x4015AE14,0x7AE147AE, 0x3FE4CCF7,0x2A2389F3,
	0x4015B851,0xEB851EB8, 0x3FE50AF3,0x5A62D745,
	0x4015C28F,0x5C28F5C3, 0x3FE54865,0xA30214DE,
	0x4015CCCC,0xCCCCCCCD, 0x3FE5854C,0x715021EB,
	0x4015D70A,0x3D70A3D7, 0x3FE5C1A6,0x362DF0A2,
	0x4015E147,0xAE147AE1, 0x3FE5FD71,0x6618BDD6,
	0x4015EB85,0x1EB851EC, 0x3FE638AC,0x793430FE,
	0x4015F5C2,0x8F5C28F6, 0x3FE67355,0xEB546437,
	0x40160000,0x00000000, 0x3FE6AD6C,0x3C07D448,
	0x40160A3D,0x70A3D70A, 0x3FE6E6ED,0xEEA13805,
	0x4016147A,0xE147AE14, 0x3FE71FD9,0x8A413F1C,
	0x40161EB8,0x51EB851F, 0x3FE7582D,0x99E037F6,
	0x401628F5,0xC28F5C29, 0x3FE78FE8,0xAC579C4B,
	0x40163333,0x33333333, 0x3FE7C709,0x546B8482,
	0x40163D70,0xA3D70A3D, 0x3FE7FD8E,0x28D4012C,
	0x401647AE,0x147AE148, 0x3FE83375,0xC4465AC2,
	0x401651EB,0x851EB852, 0x3FE868BE,0xC57E370F,
	0x40165C28,0xF5C28F5C, 0x3FE89D67,0xCF46A47B,
	0x40166666,0x66666666, 0x3FE8D16F,0x88830A7F,
	0x401670A3,0xD70A3D71, 0x3FE904D4,0x9C37FF65,
	0x40167AE1,0x47AE147B, 0x3FE93795,0xB99402DA,
	0x4016851E,0xB851EB85, 0x3FE969B1,0x93F81D60,
	0x40168F5C,0x28F5C28F, 0x3FE99B26,0xE300641A,
	0x40169999,0x9999999A, 0x3FE9CBF4,0x628C60F3,
	0x4016A3D7,0x0A3D70A4, 0x3FE9FC18,0xD2C75EB5,
	0x4016AE14,0x7AE147AE, 0x3FEA2B92,0xF8309930,
	0x4016B851,0xEB851EB8, 0x3FEA5A61,0x9BA350D2,
	0x4016C28F,0x5C28F5C3, 0x3FEA8883,0x8A5EC1C3,
	0x4016CCCC,0xCCCCCCCD, 0x3FEAB5F7,0x960DFE2A,
	0x4016D70A,0x3D70A3D7, 0x3FEAE2BC,0x94CFAB9D,
	0x4016E147,0xAE147AE1, 0x3FEB0ED1,0x613DA33D,
	0x4016EB85,0x1EB851EC, 0x3FEB3A34,0xDA74748B,
	0x4016F5C2,0x8F5C28F6, 0x3FEB64E5,0xE41ACA96,
	0x40170000,0x00000000, 0x3FEB8EE3,0x6668B394,
	0x40170A3D,0x70A3D70A, 0x3FEBB82C,0x4E2ECA5E,
	0x4017147A,0xE147AE14, 0x3FEBE0BF,0x8CDD41E4,
	0x40171EB8,0x51EB851F, 0x3FEC089C,0x188AD258,
	0x401728F5,0xC28F5C29, 0x3FEC2FC0,0xEBFB87C3,
	0x40173333,0x33333333, 0x3FEC562D,0x06A77223,
	0x40173D70,0xA3D70A3D, 0x3FEC7BDF,0x6CC13689,
	0x401747AE,0x147AE148, 0x3FECA0D7,0x273C8152,
	0x401751EB,0x851EB852, 0x3FECC513,0x43D45928,
	0x40175C28,0xF5C28F5C, 0x3FECE892,0xD51152CB,
	0x40176666,0x66666666, 0x3FED0B54,0xF24FA546,
	0x401770A3,0xD70A3D71, 0x3FED2D58,0xB7C51E91,
	0x40177AE1,0x47AE147B, 0x3FED4E9D,0x4686F85A,
	0x4017851E,0xB851EB85, 0x3FED6F21,0xC48F8CFE,
	0x40178F5C,0x28F5C28F, 0x3FED8EE5,0x5CC3EC4D,
	0x40179999,0x9999999A, 0x3FEDADE7,0x3EF95029,
	0x4017A3D7,0x0A3D70A4, 0x3FEDCC26,0x9FFA70B4,
	0x4017AE14,0x7AE147AE, 0x3FEDE9A2,0xB98CB822,
	0x4017B851,0xEB851EB8, 0x3FEE065A,0xCA7555BF,
	0x4017C28F,0x5C28F5C3, 0x3FEE224E,0x167E3056,
	0x4017CCCC,0xCCCCCCCD, 0x3FEE3D7B,0xE67AB792,
	0x4017D70A,0x3D70A3D7, 0x3FEE57E3,0x884C9480,
	0x4017E147,0xAE147AE1, 0x3FEE7184,0x4EE838D6,
	0x4017EB85,0x1EB851EC, 0x3FEE8A5D,0x92594D06,
	0x4017F5C2,0x8F5C28F6, 0x3FEEA26E,0xAFC6FCE5,
	0x40180000,0x00000000, 0x3FEEB9B7,0x097822F5,
	0x40180A3D,0x70A3D70A, 0x3FEED036,0x06D75201,
	0x4018147A,0xE147AE14, 0x3FEEE5EB,0x1476BD14,
	0x40181EB8,0x51EB851F, 0x3FEEFAD5,0xA413FDAC,
	0x401828F5,0xC28F5C29, 0x3FEF0EF5,0x2C9BB7FF,
	0x40183333,0x33333333, 0x3FEF2249,0x2A2D1D5A,
	0x40183D70,0xA3D70A3D, 0x3FEF34D1,0x1E1D4C62,
	0x401847AE,0x147AE148, 0x3FEF468C,0x8EFA8F33,
	0x401851EB,0x851EB852, 0x3FEF577B,0x088F773D,
	0x40185C28,0xF5C28F5C, 0x3FEF679C,0x1BE5D6E7,
	0x40186666,0x66666666, 0x3FEF76EF,0x5F4998B2,
	0x401870A3,0xD70A3D71, 0x3FEF8574,0x6E4B7400,
	0x40187AE1,0x47AE147B, 0x3FEF932A,0xE9C37F3B,
	0x4018851E,0xB851EB85, 0x3FEFA012,0x77D39F7D,
	0x40188F5C,0x28F5C28F, 0x3FEFAC2A,0xC3E9D57F,
	0x40189999,0x9999999A, 0x3FEFB773,0x7EC267D5,
	0x4018A3D7,0x0A3D70A4, 0x3FEFC1EC,0x5E69EA60,
	0x4018AE14,0x7AE147AE, 0x3FEFCB95,0x1E3F22FC,
	0x4018B851,0xEB851EB8, 0x3FEFD46D,0x7EF4CB3D,
	0x4018C28F,0x5C28F5C3, 0x3FEFDC75,0x46932F4E,
	0x4018CCCC,0xCCCCCCCD, 0x3FEFE3AC,0x4079A9CE,
	0x4018D70A,0x3D70A3D7, 0x3FEFEA12,0x3D5FFCBF,
	0x4018E147,0xAE147AE1, 0x3FEFEFA7,0x1357875E,
	0x4018EB85,0x1EB851EC, 0x3FEFF46A,0x9DCC58F2,
	0x4018F5C2,0x8F5C28F6, 0x3FEFF85C,0xBD862083,
	0x40190000,0x00000000, 0x3FEFFB7D,0x58A8F975,
	0x40190A3D,0x70A3D70A, 0x3FEFFDCC,0x5AB614FE,
	0x4019147A,0xE147AE14, 0x3FEFFF49,0xB48C407A,
	0x40191EB8,0x51EB851F, 0x3FEFFFF5,0x5C68488E,
	0x401928F5,0xC28F5C29, 0x3FEFFFCF,0x4DE53926,
	0x40193333,0x33333333, 0x3FEFFED7,0x89FC7A41,
	};

LOCAL_D const TUint32 TanTest[] =
	{
	0x00000000,0x00000000, 0x00000000,0x00000000,
	0x3F50624D,0xD2F1A9FC, 0x3F50624E,0x2E91EBE4,
	0x3F60624D,0xD2F1A9FC, 0x3F60624F,0x4172CE6E,
	0x3F689374,0xBC6A7EFA, 0x3F689379,0x915EFC1B,
	0x3F70624D,0xD2F1A9FC, 0x3F706253,0x8CF808EE,
	0x3F747AE1,0x47AE147B, 0x3F747AEC,0x77052979,
	0x3F789374,0xBC6A7EFA, 0x3F789388,0x104A218C,
	0x3F7CAC08,0x3126E979, 0x3F7CAC26,0xE23B9B56,
	0x3F80624D,0xD2F1A9FC, 0x3F806264,0xBB27F8B4,
	0x3F826E97,0x8D4FDF3B, 0x3F826EB8,0x2AFFBB68,
	0x3F847AE1,0x47AE147B, 0x3F847B0E,0x05625F97,
	0x3F86872B,0x020C49BA, 0x3F868766,0x8F0E7362,
	0x3F889374,0xBC6A7EFA, 0x3F8893C2,0x0CC3ED54,
	0x3F8A9FBE,0x76C8B439, 0x3F8AA020,0xC3445068,
	0x3F8CAC08,0x3126E979, 0x3F8CAC82,0xF752D022,
	0x3F8EB851,0xEB851EB8, 0x3F8EB8E8,0xEDB4749D,
	0x3F90624D,0xD2F1A9FC, 0x3F9062A9,0x75981F52,
	0x3F916872,0xB020C49C, 0x3F9168E0,0x9A47A5E6,
	0x3F926E97,0x8D4FDF3B, 0x3F926F1A,0x074E7D43,
	0x3F9374BC,0x6A7EF9DB, 0x3F937555,0xDF138724,
	0x3F947AE1,0x47AE147B, 0x3F947B94,0x43FEE9CF,
	0x3F958106,0x24DD2F1B, 0x3F9581D5,0x587A222E,
	0x3F96872B,0x020C49BA, 0x3F968819,0x3EF015D9,
	0x3F978D4F,0xDF3B645A, 0x3F978E60,0x19CD2533,
	0x3F989374,0xBC6A7EFA, 0x3F9894AA,0x0B7F3D7A,
	0x3F999999,0x9999999A, 0x3F999AF7,0x3675EADF,
	0x3F9A9FBE,0x76C8B439, 0x3F9AA147,0xBD226AA2,
	0x3F9BA5E3,0x53F7CED9, 0x3F9BA79B,0xC1F7BD2C,
	0x3F9CAC08,0x3126E979, 0x3F9CADF3,0x676AB82B,
	0x3F9DB22D,0x0E560419, 0x3F9DB44E,0xCFF218B4,
	0x3F9EB851,0xEB851EB8, 0x3F9EBAAE,0x1E06955E,
	0x3F9FBE76,0xC8B43958, 0x3F9FC111,0x7422F073,
	0x3FA0624D,0xD2F1A9FC, 0x3FA063BC,0x7A620502,
	0x3FA0E560,0x4189374C, 0x3FA0E6F2,0x61347911,
	0x3FA16872,0xB020C49C, 0x3FA16A2A,0x7FC97D7E,
	0x3FA1EB85,0x1EB851EC, 0x3FA1ED64,0xE762E589,
	0x3FA26E97,0x8D4FDF3B, 0x3FA270A1,0xA943B7B3,
	0x3FA2F1A9,0xFBE76C8B, 0x3FA2F3E0,0xD6B036D7,
	0x3FA374BC,0x6A7EF9DB, 0x3FA37722,0x80EDEB43,
	0x3FA3F7CE,0xD916872B, 0x3FA3FA66,0xB943ABD4,
	0x3FA47AE1,0x47AE147B, 0x3FA47DAD,0x90F9A717,
	0x3FA4FDF3,0xB645A1CB, 0x3FA500F7,0x19596C62,
	0x3FA58106,0x24DD2F1B, 0x3FA58443,0x63ADF4FC,
	0x3FA60418,0x9374BC6A, 0x3FA60792,0x8143AD38,
	0x3FA6872B,0x020C49BA, 0x3FA68AE4,0x83687D9F,
	0x3FA70A3D,0x70A3D70A, 0x3FA70E39,0x7B6BD410,
	0x3FA78D4F,0xDF3B645A, 0x3FA79191,0x7A9EACEA,
	0x3FA81062,0x4DD2F1AA, 0x3FA814EC,0x92539C35,
	0x3FA89374,0xBC6A7EFA, 0x3FA8984A,0xD3DED6CC,
	0x3FA91687,0x2B020C4A, 0x3FA91BAC,0x50963B88,
	0x3FA99999,0x9999999A, 0x3FA99F11,0x19D15C71,
	0x3FAA1CAC,0x083126E9, 0x3FAA2279,0x40E987EC,
	0x3FAA9FBE,0x76C8B439, 0x3FAAA5E4,0xD739D1F0,
	0x3FAB22D0,0xE5604189, 0x3FAB2953,0xEE1F1D37,
	0x3FABA5E3,0x53F7CED9, 0x3FABACC6,0x96F82475,
	0x3FAC28F5,0xC28F5C29, 0x3FAC303C,0xE3258391,
	0x3FACAC08,0x3126E979, 0x3FACB3B6,0xE409C0E0,
	0x3FAD2F1A,0x9FBE76C9, 0x3FAD3734,0xAB09565F,
	0x3FADB22D,0x0E560419, 0x3FADBAB6,0x498ABAF4,
	0x3FAE353F,0x7CED9168, 0x3FAE3E3B,0xD0F66BAC,
	0x3FAEB851,0xEB851EB8, 0x3FAEC1C5,0x52B6F506,
	0x3FAF3B64,0x5A1CAC08, 0x3FAF4552,0xE038FC2E,
	0x3FAFBE76,0xC8B43958, 0x3FAFC8E4,0x8AEB4849,
	0x3FB020C4,0x9BA5E354, 0x3FB0263D,0x321F65E1,
	0x3FB0624D,0xD2F1A9FC, 0x3FB0680A,0x3ED356CA,
	0x3FB0A3D7,0x0A3D70A4, 0x3FB0A9D9,0x744C294D,
	0x3FB0E560,0x4189374C, 0x3FB0EBAA,0xDB45B370,
	0x3FB126E9,0x78D4FDF4, 0x3FB12D7E,0x7C7CF37B,
	0x3FB16872,0xB020C49C, 0x3FB16F54,0x60B014A5,
	0x3FB1A9FB,0xE76C8B44, 0x3FB1B12C,0x909E73C1,
	0x3FB1EB85,0x1EB851EC, 0x3FB1F307,0x1508A3E8,
	0x3FB22D0E,0x56041893, 0x3FB234E3,0xF6B0732E,
	0x3FB26E97,0x8D4FDF3B, 0x3FB276C3,0x3E58EF50,
	0x3FB2B020,0xC49BA5E3, 0x3FB2B8A4,0xF4C66A65,
	0x3FB2F1A9,0xFBE76C8B, 0x3FB2FA89,0x22BE7F94,
	0x3FB33333,0x33333333, 0x3FB33C6F,0xD10817C8,
	0x3FB374BC,0x6A7EF9DB, 0x3FB37E59,0x086B6E68,
	0x3FB3B645,0xA1CAC083, 0x3FB3C044,0xD1B2160D,
	0x3FB3F7CE,0xD916872B, 0x3FB40233,0x35A6FD3A,
	0x3FB43958,0x10624DD3, 0x3FB44424,0x3D16731E,
	0x3FB47AE1,0x47AE147B, 0x3FB48617,0xF0CE2C49,
	0x3FB4BC6A,0x7EF9DB23, 0x3FB4C80E,0x599D476F,
	0x3FB4FDF3,0xB645A1CB, 0x3FB50A07,0x80545224,
	0x3FB53F7C,0xED916873, 0x3FB54C03,0x6DC54DA3,
	0x3FB58106,0x24DD2F1B, 0x3FB58E02,0x2AC3B38B,
	0x3FB5C28F,0x5C28F5C3, 0x3FB5D003,0xC0247AA7,
	0x3FB60418,0x9374BC6A, 0x3FB61208,0x36BE1BB4,
	0x3FB645A1,0xCAC08312, 0x3FB6540F,0x9768962B,
	0x3FB6872B,0x020C49BA, 0x3FB69619,0xEAFD7506,
	0x3FB6C8B4,0x39581062, 0x3FB6D827,0x3A57D390,
	0x3FB70A3D,0x70A3D70A, 0x3FB71A37,0x8E546231,
	0x3FB74BC6,0xA7EF9DB2, 0x3FB75C4A,0xEFD16B3C,
	0x3FB78D4F,0xDF3B645A, 0x3FB79E61,0x67AED7C2,
	0x3FB7CED9,0x16872B02, 0x3FB7E07A,0xFECE3462,
	0x3FB81062,0x4DD2F1AA, 0x3FB82297,0xBE12B622,
	0x3FB851EB,0x851EB852, 0x3FB864B7,0xAE613F42,
	0x3FB89374,0xBC6A7EFA, 0x3FB8A6DA,0xD8A06415,
	0x3FB8D4FD,0xF3B645A2, 0x3FB8E901,0x45B86FDC,
	0x3FB91687,0x2B020C4A, 0x3FB92B2A,0xFE9369A1,
	0x3FB95810,0x624DD2F2, 0x3FB96D58,0x0C1D1919,
	0x3FB99999,0x9999999A, 0x3FB9AF88,0x77430B80,
	0x3FB9DB22,0xD0E56042, 0x3FB9F1BC,0x48F4987D,
	0x3FBA1CAC,0x083126E9, 0x3FBA33F3,0x8A22E705,
	0x3FBA5E35,0x3F7CED91, 0x3FBA762E,0x43C0F247,
	0x3FBA9FBE,0x76C8B439, 0x3FBAB86C,0x7EC38E8B,
	0x3FBAE147,0xAE147AE1, 0x3FBAFAAE,0x44216E25,
	0x3FBB22D0,0xE5604189, 0x3FBB3CF3,0x9CD3265C,
	0x3FBB645A,0x1CAC0831, 0x3FBB7F3C,0x91D3345E,
	0x3FBBA5E3,0x53F7CED9, 0x3FBBC189,0x2C1E022B,
	0x3FBBE76C,0x8B439581, 0x3FBC03D9,0x74B1EB8D,
	0x3FBC28F5,0xC28F5C29, 0x3FBC462D,0x748F430D,
	0x3FBC6A7E,0xF9DB22D1, 0x3FBC8885,0x34B856E6,
	0x3FBCAC08,0x3126E979, 0x3FBCCAE0,0xBE317607,
	0x3FBCED91,0x6872B021, 0x3FBD0D40,0x1A00F506,
	0x3FBD2F1A,0x9FBE76C9, 0x3FBD4FA3,0x512F3325,
	0x3FBD70A3,0xD70A3D71, 0x3FBD920A,0x6CC69F53,
	0x3FBDB22D,0x0E560419, 0x3FBDD475,0x75D3BD29,
	0x3FBDF3B6,0x45A1CAC1, 0x3FBE16E4,0x756529F6,
	0x3FBE353F,0x7CED9168, 0x3FBE5957,0x748BA1C5,
	0x3FBE76C8,0xB4395810, 0x3FBE9BCE,0x7C5A0467,
	0x3FBEB851,0xEB851EB8, 0x3FBEDE49,0x95E55A7F,
	0x3FBEF9DB,0x22D0E560, 0x3FBF20C8,0xCA44DA93,
	0x3FBF3B64,0x5A1CAC08, 0x3FBF634C,0x2291EE1D,
	0x3FBF7CED,0x916872B0, 0x3FBFA5D3,0xA7E8369F,
	0x3FBFBE76,0xC8B43958, 0x3FBFE85F,0x636592BA,
	0x3FC00000,0x00000000, 0x3FC01577,0xAF1511A5,
	0x3FC020C4,0x9BA5E354, 0x3FC036C1,0xD0AC283F,
	0x3FC04189,0x374BC6A8, 0x3FC0580E,0x1B0A677C,
	0x3FC0624D,0xD2F1A9FC, 0x3FC0795C,0x92C35279,
	0x3FC08312,0x6E978D50, 0x3FC09AAD,0x3C6B97AE,
	0x3FC0A3D7,0x0A3D70A4, 0x3FC0BC00,0x1C991383,
	0x3FC0C49B,0xA5E353F8, 0x3FC0DD55,0x37E2D2E5,
	0x3FC0E560,0x4189374C, 0x3FC0FEAC,0x92E115DB,
	0x3FC10624,0xDD2F1AA0, 0x3FC12006,0x322D5220,
	0x3FC126E9,0x78D4FDF4, 0x3FC14162,0x1A6235B7,
	0x3FC147AE,0x147AE148, 0x3FC162C0,0x501BA989,
	0x3FC16872,0xB020C49C, 0x3FC18420,0xD7F6D401,
	0x3FC18937,0x4BC6A7F0, 0x3FC1A583,0xB6921BA7,
	0x3FC1A9FB,0xE76C8B44, 0x3FC1C6E8,0xF08D29C0,
	0x3FC1CAC0,0x83126E98, 0x3FC1E850,0x8A88ECEC,
	0x3FC1EB85,0x1EB851EC, 0x3FC209BA,0x89279BCC,
	0x3FC20C49,0xBA5E353F, 0x3FC22B26,0xF10CB79E,
	0x3FC22D0E,0x56041893, 0x3FC24C95,0xC6DD0EE9,
	0x3FC24DD2,0xF1A9FBE7, 0x3FC26E07,0x0F3EC01D,
	0x3FC26E97,0x8D4FDF3B, 0x3FC28F7A,0xCED93C3F,
	0x3FC28F5C,0x28F5C28F, 0x3FC2B0F1,0x0A55498E,
	0x3FC2B020,0xC49BA5E3, 0x3FC2D269,0xC65D062F,
	0x3FC2D0E5,0x60418937, 0x3FC2F3E5,0x079BEADC,
	0x3FC2F1A9,0xFBE76C8B, 0x3FC31562,0xD2BECD8E,
	0x3FC3126E,0x978D4FDF, 0x3FC336E3,0x2C73E42D,
	0x3FC33333,0x33333333, 0x3FC35866,0x196AC743,
	0x3FC353F7,0xCED91687, 0x3FC379EB,0x9E5474AA,
	0x3FC374BC,0x6A7EF9DB, 0x3FC39B73,0xBFE35248,
	0x3FC39581,0x0624DD2F, 0x3FC3BCFE,0x82CB30BC,
	0x3FC3B645,0xA1CAC083, 0x3FC3DE8B,0xEBC14E1A,
	0x3FC3D70A,0x3D70A3D7, 0x3FC4001B,0xFF7C58A4,
	0x3FC3F7CE,0xD916872B, 0x3FC421AE,0xC2B47185,
	0x3FC41893,0x74BC6A7F, 0x3FC44344,0x3A232F8C,
	0x3FC43958,0x10624DD3, 0x3FC464DC,0x6A83A1E9,
	0x3FC45A1C,0xAC083127, 0x3FC48677,0x589252F1,
	0x3FC47AE1,0x47AE147B, 0x3FC4A815,0x090D4ADD,
	0x3FC49BA5,0xE353F7CF, 0x3FC4C9B5,0x80B4128D,
	0x3FC4BC6A,0x7EF9DB23, 0x3FC4EB58,0xC447B64F,
	0x3FC4DD2F,0x1A9FBE77, 0x3FC50CFE,0xD88AC8A2,
	0x3FC4FDF3,0xB645A1CB, 0x3FC52EA7,0xC2416505,
	0x3FC51EB8,0x51EB851F, 0x3FC55053,0x863132BB,
	0x3FC53F7C,0xED916873, 0x3FC57202,0x2921679D,
	0x3FC56041,0x89374BC7, 0x3FC593B3,0xAFDACAE2,
	0x3FC58106,0x24DD2F1B, 0x3FC5B568,0x1F27B7F5,
	0x3FC5A1CA,0xC083126F, 0x3FC5D71F,0x7BD42144,
	0x3FC5C28F,0x5C28F5C3, 0x3FC5F8D9,0xCAAD9312,
	0x3FC5E353,0xF7CED917, 0x3FC61A97,0x10833651,
	0x3FC60418,0x9374BC6A, 0x3FC63C57,0x5225D373,
	0x3FC624DD,0x2F1A9FBE, 0x3FC65E1A,0x9467D54F,
	0x3FC645A1,0xCAC08312, 0x3FC67FE0,0xDC1D4BED,
	0x3FC66666,0x66666666, 0x3FC6A1AA,0x2E1BEF6F,
	0x3FC6872B,0x020C49BA, 0x3FC6C376,0x8F3B22EC,
	0x3FC6A7EF,0x9DB22D0E, 0x3FC6E546,0x0453F750,
	0x3FC6C8B4,0x39581062, 0x3FC70718,0x92412E43,
	0x3FC6E978,0xD4FDF3B6, 0x3FC728EE,0x3DDF3D0B,
	0x3FC70A3D,0x70A3D70A, 0x3FC74AC7,0x0C0C4F74,
	0x3FC72B02,0x0C49BA5E, 0x3FC76CA3,0x01A84ABA,
	0x3FC74BC6,0xA7EF9DB2, 0x3FC78E82,0x2394D074,
	0x3FC76C8B,0x43958106, 0x3FC7B064,0x76B54180,
	0x3FC78D4F,0xDF3B645A, 0x3FC7D249,0xFFEEC0F6,
	0x3FC7AE14,0x7AE147AE, 0x3FC7F432,0xC4283716,
	0x3FC7CED9,0x16872B02, 0x3FC8161E,0xC84A543C,
	0x3FC7EF9D,0xB22D0E56, 0x3FC8380E,0x113F93D8,
	0x3FC81062,0x4DD2F1AA, 0x3FC85A00,0xA3F43F66,
	0x3FC83126,0xE978D4FE, 0x3FC87BF6,0x85567163,
	0x3FC851EB,0x851EB852, 0x3FC89DEF,0xBA561850,
	0x3FC872B0,0x20C49BA6, 0x3FC8BFEC,0x47E4F9AD,
	0x3FC89374,0xBC6A7EFA, 0x3FC8E1EC,0x32F6B4F9,
	0x3FC8B439,0x5810624E, 0x3FC903EF,0x8080C6B8,
	0x3FC8D4FD,0xF3B645A2, 0x3FC925F6,0x357A8B73,
	0x3FC8F5C2,0x8F5C28F6, 0x3FC94800,0x56DD42C4,
	0x3FC91687,0x2B020C4A, 0x3FC96A0D,0xE9A41260,
	0x3FC9374B,0xC6A7EF9E, 0x3FC98C1E,0xF2CC091C,
	0x3FC95810,0x624DD2F2, 0x3FC9AE33,0x77542205,
	0x3FC978D4,0xFDF3B646, 0x3FC9D04B,0x7C3D4769,
	0x3FC99999,0x9999999A, 0x3FC9F267,0x068A55EC,
	0x3FC9BA5E,0x353F7CEE, 0x3FCA1486,0x1B401F9E,
	0x3FC9DB22,0xD0E56042, 0x3FCA36A8,0xBF656F12,
	0x3FC9FBE7,0x6C8B4396, 0x3FCA58CE,0xF8030A79,
	0x3FCA1CAC,0x083126E9, 0x3FCA7AF8,0xCA23B6BB,
	0x3FCA3D70,0xA3D70A3D, 0x3FCA9D26,0x3AD43A9A,
	0x3FCA5E35,0x3F7CED91, 0x3FCABF57,0x4F2361D1,
	0x3FCA7EF9,0xDB22D0E5, 0x3FCAE18C,0x0C220035,
	0x3FCA9FBE,0x76C8B439, 0x3FCB03C4,0x76E2F4E0,
	0x3FCAC083,0x126E978D, 0x3FCB2600,0x947B2D57,
	0x3FCAE147,0xAE147AE1, 0x3FCB4840,0x6A01A8B4,
	0x3FCB020C,0x49BA5E35, 0x3FCB6A83,0xFC8F7AD5,
	0x3FCB22D0,0xE5604189, 0x3FCB8CCB,0x513FCF8D,
	0x3FCB4395,0x810624DD, 0x3FCBAF16,0x6D2FEDD5,
	0x3FCB645A,0x1CAC0831, 0x3FCBD165,0x557F3AFF,
	0x3FCB851E,0xB851EB85, 0x3FCBF3B8,0x0F4F3DF4,
	0x3FCBA5E3,0x53F7CED9, 0x3FCC160E,0x9FC3A267,
	0x3FCBC6A7,0xEF9DB22D, 0x3FCC3869,0x0C023C18,
	0x3FCBE76C,0x8B439581, 0x3FCC5AC7,0x59330A10,
	0x3FCC0831,0x26E978D5, 0x3FCC7D29,0x8C8039E5,
	0x3FCC28F5,0xC28F5C29, 0x3FCC9F8F,0xAB162AFC,
	0x3FCC49BA,0x5E353F7D, 0x3FCCC1F9,0xBA2371D7,
	0x3FCC6A7E,0xF9DB22D1, 0x3FCCE467,0xBED8DB56,
	0x3FCC8B43,0x95810625, 0x3FCD06D9,0xBE69700E,
	0x3FCCAC08,0x3126E979, 0x3FCD294F,0xBE0A778F,
	0x3FCCCCCC,0xCCCCCCCD, 0x3FCD4BC9,0xC2F37BC0,
	0x3FCCED91,0x6872B021, 0x3FCD6E47,0xD25E4C2D,
	0x3FCD0E56,0x04189375, 0x3FCD90C9,0xF1870162,
	0x3FCD2F1A,0x9FBE76C9, 0x3FCDB350,0x25AC0046,
	0x3FCD4FDF,0x3B645A1D, 0x3FCDD5DA,0x740DFD78,
	0x3FCD70A3,0xD70A3D71, 0x3FCDF868,0xE1F000B0,
	0x3FCD9168,0x72B020C5, 0x3FCE1AFB,0x74976824,
	0x3FCDB22D,0x0E560419, 0x3FCE3D92,0x314BEBEB,
	0x3FCDD2F1,0xA9FBE76D, 0x3FCE602D,0x1D57A168,
	0x3FCDF3B6,0x45A1CAC1, 0x3FCE82CC,0x3E06FEB6,
	0x3FCE147A,0xE147AE14, 0x3FCEA56F,0x98A8DE18,
	0x3FCE353F,0x7CED9168, 0x3FCEC817,0x328E816C,
	0x3FCE5604,0x189374BC, 0x3FCEEAC3,0x110B959C,
	0x3FCE76C8,0xB4395810, 0x3FCF0D73,0x39763619,
	0x3FCE978D,0x4FDF3B64, 0x3FCF3027,0xB126F057,
	0x3FCEB851,0xEB851EB8, 0x3FCF52E0,0x7D78C747,
	0x3FCED916,0x872B020C, 0x3FCF759D,0xA3C936DE,
	0x3FCEF9DB,0x22D0E560, 0x3FCF985F,0x29783796,
	0x3FCF1A9F,0xBE76C8B4, 0x3FCFBB25,0x13E841F3,
	0x3FCF3B64,0x5A1CAC08, 0x3FCFDDEF,0x687E5213,
	0x3FCF5C28,0xF5C28F5C, 0x3FD0005F,0x1650F59C,
	0x3FCF7CED,0x916872B0, 0x3FD011C8,0xB2DE8DAD,
	0x3FCF9DB2,0x2D0E5604, 0x3FD02334,0x8C9E3F5D,
	0x3FCFBE76,0xC8B43958, 0x3FD034A2,0xA647A1BD,
	0x3FCFDF3B,0x645A1CAC, 0x3FD04613,0x0293969C,
	0x3FD00000,0x00000000, 0x3FD05785,0xA43C4C56,
	0x3FD01062,0x4DD2F1AA, 0x3FD068FA,0x8DFD3FA2,
	0x3FD020C4,0x9BA5E354, 0x3FD07A71,0xC2933D69,
	0x3FD03126,0xE978D4FE, 0x3FD08BEB,0x44BC6495,
	0x3FD04189,0x374BC6A8, 0x3FD09D67,0x173827E8,
	0x3FD051EB,0x851EB852, 0x3FD0AEE5,0x3CC74FD5,
	0x3FD0624D,0xD2F1A9FC, 0x3FD0C065,0xB82BFC56,
	0x3FD072B0,0x20C49BA6, 0x3FD0D1E8,0x8C29A6C9,
	0x3FD08312,0x6E978D50, 0x3FD0E36D,0xBB8523CA,
	0x3FD09374,0xBC6A7EFA, 0x3FD0F4F5,0x4904A512,
	0x3FD0A3D7,0x0A3D70A4, 0x3FD1067F,0x376FBB57,
	0x3FD0B439,0x5810624E, 0x3FD1180B,0x898F582C,
	0x3FD0C49B,0xA5E353F8, 0x3FD1299A,0x422DCFE6,
	0x3FD0D4FD,0xF3B645A2, 0x3FD13B2B,0x6416DB80,
	0x3FD0E560,0x4189374C, 0x3FD14CBE,0xF2179A81,
	0x3FD0F5C2,0x8F5C28F6, 0x3FD15E54,0xEEFE94E6,
	0x3FD10624,0xDD2F1AA0, 0x3FD16FED,0x5D9BBD0B,
	0x3FD11687,0x2B020C4A, 0x3FD18188,0x40C07198,
	0x3FD126E9,0x78D4FDF4, 0x3FD19325,0x9B3F7F6D,
	0x3FD1374B,0xC6A7EF9E, 0x3FD1A4C5,0x6FED2395,
	0x3FD147AE,0x147AE148, 0x3FD1B667,0xC19F0D33,
	0x3FD15810,0x624DD2F2, 0x3FD1C80C,0x932C5F7C,
	0x3FD16872,0xB020C49C, 0x3FD1D9B3,0xE76DB3A6,
	0x3FD178D4,0xFDF3B646, 0x3FD1EB5D,0xC13D1AE0,
	0x3FD18937,0x4BC6A7F0, 0x3FD1FD0A,0x23762050,
	0x3FD19999,0x9999999A, 0x3FD20EB9,0x10F5CB09,
	0x3FD1A9FB,0xE76C8B44, 0x3FD2206A,0x8C9AA009,
	0x3FD1BA5E,0x353F7CEE, 0x3FD2321E,0x9944A439,
	0x3FD1CAC0,0x83126E98, 0x3FD243D5,0x39D55E6C,
	0x3FD1DB22,0xD0E56042, 0x3FD2558E,0x712FD964,
	0x3FD1EB85,0x1EB851EC, 0x3FD2674A,0x4238A5D5,
	0x3FD1FBE7,0x6C8B4396, 0x3FD27908,0xAFD5DC69,
	0x3FD20C49,0xBA5E353F, 0x3FD28AC9,0xBCEF1FD0,
	0x3FD21CAC,0x083126E9, 0x3FD29C8D,0x6C6D9EC4,
	0x3FD22D0E,0x56041893, 0x3FD2AE53,0xC13C1617,
	0x3FD23D70,0xA3D70A3D, 0x3FD2C01C,0xBE46D2C4,
	0x3FD24DD2,0xF1A9FBE7, 0x3FD2D1E8,0x667BB3FC,
	0x3FD25E35,0x3F7CED91, 0x3FD2E3B6,0xBCCA2D3C,
	0x3FD26E97,0x8D4FDF3B, 0x3FD2F587,0xC4234860,
	0x3FD27EF9,0xDB22D0E5, 0x3FD3075B,0x7F79A7BB,
	0x3FD28F5C,0x28F5C28F, 0x3FD31931,0xF1C1882F,
	0x3FD29FBE,0x76C8B439, 0x3FD32B0B,0x1DF0C347,
	0x3FD2B020,0xC49BA5E3, 0x3FD33CE7,0x06FED157,
	0x3FD2C083,0x126E978D, 0x3FD34EC5,0xAFE4CB9A,
	0x3FD2D0E5,0x60418937, 0x3FD360A7,0x1B9D6E52,
	0x3FD2E147,0xAE147AE1, 0x3FD3728B,0x4D251AED,
	0x3FD2F1A9,0xFBE76C8B, 0x3FD38472,0x4779DA2B,
	0x3FD3020C,0x49BA5E35, 0x3FD3965C,0x0D9B5E46,
	0x3FD3126E,0x978D4FDF, 0x3FD3A848,0xA28B0518,
	0x3FD322D0,0xE5604189, 0x3FD3BA38,0x094BDA50,
	0x3FD33333,0x33333333, 0x3FD3CC2A,0x44E29998,
	0x3FD34395,0x810624DD, 0x3FD3DE1F,0x5855B0C8,
	0x3FD353F7,0xCED91687, 0x3FD3F017,0x46AD421F,
	0x3FD3645A,0x1CAC0831, 0x3FD40212,0x12F3266E,
	0x3FD374BC,0x6A7EF9DB, 0x3FD4140F,0xC032EF59,
	0x3FD3851E,0xB851EB85, 0x3FD42610,0x5179E98A,
	0x3FD39581,0x0624DD2F, 0x3FD43813,0xC9D71EF1,
	0x3FD3A5E3,0x53F7CED9, 0x3FD44A1A,0x2C5B5903,
	0x3FD3B645,0xA1CAC083, 0x3FD45C23,0x7C1922F7,
	0x3FD3C6A7,0xEF9DB22D, 0x3FD46E2F,0xBC24CC0D,
	0x3FD3D70A,0x3D70A3D7, 0x3FD4803E,0xEF9469D0,
	0x3FD3E76C,0x8B439581, 0x3FD49251,0x197FDA61,
	0x3FD3F7CE,0xD916872B, 0x3FD4A466,0x3D00C6C1,
	0x3FD40831,0x26E978D5, 0x3FD4B67E,0x5D32A51C,
	0x3FD41893,0x74BC6A7F, 0x3FD4C899,0x7D32BB17,
	0x3FD428F5,0xC28F5C29, 0x3FD4DAB7,0xA0202027,
	0x3FD43958,0x10624DD3, 0x3FD4ECD8,0xC91BBFDE,
	0x3FD449BA,0x5E353F7D, 0x3FD4FEFC,0xFB485C46,
	0x3FD45A1C,0xAC083127, 0x3FD51124,0x39CA903B,
	0x3FD46A7E,0xF9DB22D1, 0x3FD5234E,0x87C8D1C0,
	0x3FD47AE1,0x47AE147B, 0x3FD5357B,0xE86B7466,
	0x3FD48B43,0x95810625, 0x3FD547AC,0x5EDCABA2,
	0x3FD49BA5,0xE353F7CF, 0x3FD559DF,0xEE488D3B,
	0x3FD4AC08,0x3126E979, 0x3FD56C16,0x99DD13A7,
	0x3FD4BC6A,0x7EF9DB23, 0x3FD57E50,0x64CA2078,
	0x3FD4CCCC,0xCCCCCCCD, 0x3FD5908D,0x52417EC4,
	0x3FD4DD2F,0x1A9FBE77, 0x3FD5A2CD,0x6576E593,
	0x3FD4ED91,0x6872B021, 0x3FD5B510,0xA19FFA51,
	0x3FD4FDF3,0xB645A1CB, 0x3FD5C757,0x09F4533D,
	0x3FD50E56,0x04189375, 0x3FD5D9A0,0xA1AD79E4,
	0x3FD51EB8,0x51EB851F, 0x3FD5EBED,0x6C06ED90,
	0x3FD52F1A,0x9FBE76C9, 0x3FD5FE3D,0x6C3E25CC,
	0x3FD53F7C,0xED916873, 0x3FD61090,0xA59294DA,
	0x3FD54FDF,0x3B645A1D, 0x3FD622E7,0x1B45AA3A,
	0x3FD56041,0x89374BC7, 0x3FD63540,0xD09AD524,
	0x3FD570A3,0xD70A3D71, 0x3FD6479D,0xC8D78716,
	0x3FD58106,0x24DD2F1B, 0x3FD659FE,0x07433658,
	0x3FD59168,0x72B020C5, 0x3FD66C61,0x8F276088,
	0x3FD5A1CA,0xC083126F, 0x3FD67EC8,0x63CF8D26,
	0x3FD5B22D,0x0E560419, 0x3FD69132,0x88895028,
	0x3FD5C28F,0x5C28F5C3, 0x3FD6A3A0,0x00A44C8C,
	0x3FD5D2F1,0xA9FBE76D, 0x3FD6B610,0xCF7236EE,
	0x3FD5E353,0xF7CED917, 0x3FD6C884,0xF846D822,
	0x3FD5F3B6,0x45A1CAC1, 0x3FD6DAFC,0x7E780FCE,
	0x3FD60418,0x9374BC6A, 0x3FD6ED77,0x655DD70D,
	0x3FD6147A,0xE147AE14, 0x3FD6FFF5,0xB0524310,
	0x3FD624DD,0x2F1A9FBE, 0x3FD71277,0x62B187BF,
	0x3FD6353F,0x7CED9168, 0x3FD724FC,0x7FD9FA64,
	0x3FD645A1,0xCAC08312, 0x3FD73785,0x0B2C1459,
	0x3FD65604,0x189374BC, 0x3FD74A11,0x080A75AF,
	0x3FD66666,0x66666666, 0x3FD75CA0,0x79D9E7E4,
	0x3FD676C8,0xB4395810, 0x3FD76F33,0x64016095,
	0x3FD6872B,0x020C49BA, 0x3FD781C9,0xC9EA0438,
	0x3FD6978D,0x4FDF3B64, 0x3FD79463,0xAEFF28CF,
	0x3FD6A7EF,0x9DB22D0E, 0x3FD7A701,0x16AE58AE,
	0x3FD6B851,0xEB851EB8, 0x3FD7B9A2,0x04675536,
	0x3FD6C8B4,0x39581062, 0x3FD7CC46,0x7B9C1998,
	0x3FD6D916,0x872B020C, 0x3FD7DEEE,0x7FC0DD9E,
	0x3FD6E978,0xD4FDF3B6, 0x3FD7F19A,0x144C1876,
	0x3FD6F9DB,0x22D0E560, 0x3FD80449,0x3CB68379,
	0x3FD70A3D,0x70A3D70A, 0x3FD816FB,0xFC7B1D03,
	0x3FD71A9F,0xBE76C8B4, 0x3FD829B2,0x57172B3E,
	0x3FD72B02,0x0C49BA5E, 0x3FD83C6C,0x500A3F02,
	0x3FD73B64,0x5A1CAC08, 0x3FD84F29,0xEAD636A7,
	0x3FD74BC6,0xA7EF9DB2, 0x3FD861EB,0x2AFF40E4,
	0x3FD75C28,0xF5C28F5C, 0x3FD874B0,0x140BDFB4,
	0x3FD76C8B,0x43958106, 0x3FD88778,0xA984EB35,
	0x3FD77CED,0x916872B0, 0x3FD89A44,0xEEF5948F,
	0x3FD78D4F,0xDF3B645A, 0x3FD8AD14,0xE7EB68E4,
	0x3FD79DB2,0x2D0E5604, 0x3FD8BFE8,0x97F65436,
	0x3FD7AE14,0x7AE147AE, 0x3FD8D2C0,0x02A8A461,
	0x3FD7BE76,0xC8B43958, 0x3FD8E59B,0x2B970C08,
	0x3FD7CED9,0x16872B02, 0x3FD8F87A,0x1658A591,
	0x3FD7DF3B,0x645A1CAC, 0x3FD90B5C,0xC686F624,
	0x3FD7EF9D,0xB22D0E56, 0x3FD91E43,0x3FBDF0A2,
	0x3FD80000,0x00000000, 0x3FD9312D,0x859BF8B0,
	0x3FD81062,0x4DD2F1AA, 0x3FD9441B,0x9BC1E5B7,
	0x3FD820C4,0x9BA5E354, 0x3FD9570D,0x85D305F4,
	0x3FD83126,0xE978D4FE, 0x3FD96A03,0x47752180,
	0x3FD84189,0x374BC6A8, 0x3FD97CFC,0xE4507D62,
	0x3FD851EB,0x851EB852, 0x3FD98FFA,0x600FDEA8,
	0x3FD8624D,0xD2F1A9FC, 0x3FD9A2FB,0xBE608D7B,
	0x3FD872B0,0x20C49BA6, 0x3FD9B601,0x02F2583B,
	0x3FD88312,0x6E978D50, 0x3FD9C90A,0x317796A1,
	0x3FD89374,0xBC6A7EFA, 0x3FD9DC17,0x4DA52CE3,
	0x3FD8A3D7,0x0A3D70A4, 0x3FD9EF28,0x5B328ED9,
	0x3FD8B439,0x5810624E, 0x3FDA023D,0x5DD9C326,
	0x3FD8C49B,0xA5E353F8, 0x3FDA1556,0x5957666E,
	0x3FD8D4FD,0xF3B645A2, 0x3FDA2873,0x516AAE80,
	0x3FD8E560,0x4189374C, 0x3FDA3B94,0x49D56D94,
	0x3FD8F5C2,0x8F5C28F6, 0x3FDA4EB9,0x465C1580,
	0x3FD90624,0xDD2F1AA0, 0x3FDA61E2,0x4AC5BAF7,
	0x3FD91687,0x2B020C4A, 0x3FDA750F,0x5ADC18CD,
	0x3FD926E9,0x78D4FDF4, 0x3FDA8840,0x7A6B933E,
	0x3FD9374B,0xC6A7EF9E, 0x3FDA9B75,0xAD433B34,
	0x3FD947AE,0x147AE148, 0x3FDAAEAE,0xF734D197,
	0x3FD95810,0x624DD2F2, 0x3FDAC1EC,0x5C14CA9F,
	0x3FD96872,0xB020C49C, 0x3FDAD52D,0xDFBA512B,
	0x3FD978D4,0xFDF3B646, 0x3FDAE873,0x85FF4A1B,
	0x3FD98937,0x4BC6A7F0, 0x3FDAFBBD,0x52C057AB,
	0x3FD99999,0x9999999A, 0x3FDB0F0B,0x49DCDCD8,
	0x3FD9A9FB,0xE76C8B44, 0x3FDB225D,0x6F3700C8,
	0x3FD9BA5E,0x353F7CEE, 0x3FDB35B3,0xC6B3B231,
	0x3FD9CAC0,0x83126E98, 0x3FDB490E,0x543AAAC9,
	0x3FD9DB22,0xD0E56042, 0x3FDB5C6D,0x1BB672BB,
	0x3FD9EB85,0x1EB851EC, 0x3FDB6FD0,0x2114641A,
	0x3FD9FBE7,0x6C8B4396, 0x3FDB8337,0x6844AE63,
	0x3FDA0C49,0xBA5E353F, 0x3FDB96A2,0xF53A59F3,
	0x3FDA1CAC,0x083126E9, 0x3FDBAA12,0xCBEB4B98,
	0x3FDA2D0E,0x56041893, 0x3FDBBD86,0xF050480E,
	0x3FDA3D70,0xA3D70A3D, 0x3FDBD0FF,0x6664F790,
	0x3FDA4DD2,0xF1A9FBE7, 0x3FDBE47C,0x3227E96C,
	0x3FDA5E35,0x3F7CED91, 0x3FDBF7FD,0x579A9793,
	0x3FDA6E97,0x8D4FDF3B, 0x3FDC0B82,0xDAC16A3A,
	0x3FDA7EF9,0xDB22D0E5, 0x3FDC1F0C,0xBFA3BB73,
	0x3FDA8F5C,0x28F5C28F, 0x3FDC329B,0x0A4BDAD1,
	0x3FDA9FBE,0x76C8B439, 0x3FDC462D,0xBEC71112,
	0x3FDAB020,0xC49BA5E3, 0x3FDC59C4,0xE125A3CA,
	0x3FDAC083,0x126E978D, 0x3FDC6D60,0x757AD914,
	0x3FDAD0E5,0x60418937, 0x3FDC8100,0x7FDCFB47,
	0x3FDAE147,0xAE147AE1, 0x3FDC94A5,0x04655CB0,
	0x3FDAF1A9,0xFBE76C8B, 0x3FDCA84E,0x07305B52,
	0x3FDB020C,0x49BA5E35, 0x3FDCBBFB,0x8C5D64A9,
	0x3FDB126E,0x978D4FDF, 0x3FDCCFAD,0x980EF971,
	0x3FDB22D0,0xE5604189, 0x3FDCE364,0x2E6AB175,
	0x3FDB3333,0x33333333, 0x3FDCF71F,0x53993F60,
	0x3FDB4395,0x810624DD, 0x3FDD0ADF,0x0BC67495,
	0x3FDB53F7,0xCED91687, 0x3FDD1EA3,0x5B214507,
	0x3FDB645A,0x1CAC0831, 0x3FDD326C,0x45DBCB1D,
	0x3FDB74BC,0x6A7EF9DB, 0x3FDD4639,0xD02B4B97,
	0x3FDB851E,0xB851EB85, 0x3FDD5A0B,0xFE483977,
	0x3FDB9581,0x0624DD2F, 0x3FDD6DE2,0xD46E39F2,
	0x3FDBA5E3,0x53F7CED9, 0x3FDD81BE,0x56DC2861,
	0x3FDBB645,0xA1CAC083, 0x3FDD959E,0x89D41A41,
	0x3FDBC6A7,0xEF9DB22D, 0x3FDDA983,0x719B6329,
	0x3FDBD70A,0x3D70A3D7, 0x3FDDBD6D,0x127A98D6,
	0x3FDBE76C,0x8B439581, 0x3FDDD15B,0x70BD972D,
	0x3FDBF7CE,0xD916872B, 0x3FDDE54E,0x90B3844F,
	0x3FDC0831,0x26E978D5, 0x3FDDF946,0x76AED4A6,
	0x3FDC1893,0x74BC6A7F, 0x3FDE0D43,0x27054F04,
	0x3FDC28F5,0xC28F5C29, 0x3FDE2144,0xA61010BB,
	0x3FDC3958,0x10624DD3, 0x3FDE354A,0xF82B91C4,
	0x3FDC49BA,0x5E353F7D, 0x3FDE4956,0x21B7A8E6,
	0x3FDC5A1C,0xAC083127, 0x3FDE5D66,0x27178FE3,
	0x3FDC6A7E,0xF9DB22D1, 0x3FDE717B,0x0CB1E7AD,
	0x3FDC7AE1,0x47AE147B, 0x3FDE8594,0xD6F0BC9D,
	0x3FDC8B43,0x95810625, 0x3FDE99B3,0x8A418AB5,
	0x3FDC9BA5,0xE353F7CF, 0x3FDEADD7,0x2B1541DC,
	0x3FDCAC08,0x3126E979, 0x3FDEC1FF,0xBDE04A31,
	0x3FDCBC6A,0x7EF9DB23, 0x3FDED62D,0x471A8851,
	0x3FDCCCCC,0xCCCCCCCD, 0x3FDEEA5F,0xCB3F61B4,
	0x3FDCDD2F,0x1A9FBE77, 0x3FDEFE97,0x4ECDC0FE,
	0x3FDCED91,0x6872B021, 0x3FDF12D3,0xD6481A68,
	0x3FDCFDF3,0xB645A1CB, 0x3FDF2715,0x6634701F,
	0x3FDD0E56,0x04189375, 0x3FDF3B5C,0x031C56B2,
	0x3FDD1EB8,0x51EB851F, 0x3FDF4FA7,0xB18CF984,
	0x3FDD2F1A,0x9FBE76C9, 0x3FDF63F8,0x76171F43,
	0x3FDD3F7C,0xED916873, 0x3FDF784E,0x554F2E61,
	0x3FDD4FDF,0x3B645A1D, 0x3FDF8CA9,0x53CD319E,
	0x3FDD6041,0x89374BC7, 0x3FDFA109,0x762CDC8B,
	0x3FDD70A3,0xD70A3D71, 0x3FDFB56E,0xC10D901B,
	0x3FDD8106,0x24DD2F1B, 0x3FDFC9D9,0x39125F39,
	0x3FDD9168,0x72B020C5, 0x3FDFDE48,0xE2E21362,
	0x3FDDA1CA,0xC083126F, 0x3FDFF2BD,0xC3273145,
	0x3FDDB22D,0x0E560419, 0x3FE0039B,0xEF47FEB7,
	0x3FDDC28F,0x5C28F5C3, 0x3FE00DDB,0x9CE74077,
	0x3FDDD2F1,0xA9FBE76D, 0x3FE0181D,0xECCC470A,
	0x3FDDE353,0xF7CED917, 0x3FE02262,0xE153E292,
	0x3FDDF3B6,0x45A1CAC1, 0x3FE02CAA,0x7CDCCC8D,
	0x3FDE0418,0x9374BC6A, 0x3FE036F4,0xC1C7AA37,
	0x3FDE147A,0xE147AE14, 0x3FE04141,0xB2770EF2,
	0x3FDE24DD,0x2F1A9FBE, 0x3FE04B91,0x514F7EAD,
	0x3FDE353F,0x7CED9168, 0x3FE055E3,0xA0B77055,
	0x3FDE45A1,0xCAC08312, 0x3FE06038,0xA3175044,
	0x3FDE5604,0x189374BC, 0x3FE06A90,0x5AD982B1,
	0x3FDE6666,0x66666666, 0x3FE074EA,0xCA6A662C,
	0x3FDE76C8,0xB4395810, 0x3FE07F47,0xF4385618,
	0x3FDE872B,0x020C49BA, 0x3FE089A7,0xDAB3AD23,
	0x3FDE978D,0x4FDF3B64, 0x3FE0940A,0x804EC7CD,
	0x3FDEA7EF,0x9DB22D0E, 0x3FE09E6F,0xE77E06EA,
	0x3FDEB851,0xEB851EB8, 0x3FE0A8D8,0x12B7D22A,
	0x3FDEC8B4,0x39581062, 0x3FE0B343,0x04749AA5,
	0x3FDED916,0x872B020C, 0x3FE0BDB0,0xBF2EDD67,
	0x3FDEE978,0xD4FDF3B6, 0x3FE0C821,0x45632605,
	0x3FDEF9DB,0x22D0E560, 0x3FE0D294,0x99901134,
	0x3FDF0A3D,0x70A3D70A, 0x3FE0DD0A,0xBE364F5E,
	0x3FDF1A9F,0xBE76C8B4, 0x3FE0E783,0xB5D8A740,
	0x3FDF2B02,0x0C49BA5E, 0x3FE0F1FF,0x82FBF88E,
	0x3FDF3B64,0x5A1CAC08, 0x3FE0FC7E,0x28273E93,
	0x3FDF4BC6,0xA7EF9DB2, 0x3FE106FF,0xA7E392D9,
	0x3FDF5C28,0xF5C28F5C, 0x3FE11184,0x04BC2FD6,
	0x3FDF6C8B,0x43958106, 0x3FE11C0B,0x413E739C,
	0x3FDF7CED,0x916872B0, 0x3FE12695,0x5FF9E286,
	0x3FDF8D4F,0xDF3B645A, 0x3FE13122,0x638029F4,
	0x3FDF9DB2,0x2D0E5604, 0x3FE13BB2,0x4E652305,
	0x3FDFAE14,0x7AE147AE, 0x3FE14645,0x233ED550,
	0x3FDFBE76,0xC8B43958, 0x3FE150DA,0xE4A579AB,
	0x3FDFCED9,0x16872B02, 0x3FE15B73,0x95337CED,
	0x3FDFDF3B,0x645A1CAC, 0x3FE1660F,0x378582BA,
	0x3FDFEF9D,0xB22D0E56, 0x3FE170AD,0xCE3A684C,
	0x3FE00000,0x00000000, 0x3FE17B4F,0x5BF3474A,
	0x3FE00831,0x26E978D5, 0x3FE185F3,0xE353789A,
	0x3FE01062,0x4DD2F1AA, 0x3FE1909B,0x67009737,
	0x3FE01893,0x74BC6A7F, 0x3FE19B45,0xE9A28315,
	0x3FE020C4,0x9BA5E354, 0x3FE1A5F3,0x6DE363FB,
	0x3FE028F5,0xC28F5C29, 0x3FE1B0A3,0xF66FAC6C,
	0x3FE03126,0xE978D4FE, 0x3FE1BB57,0x85F61C90,
	0x3FE03958,0x10624DD3, 0x3FE1C60E,0x1F27C51F,
	0x3FE04189,0x374BC6A8, 0x3FE1D0C7,0xC4B80A54,
	0x3FE049BA,0x5E353F7D, 0x3FE1DB84,0x795CA6E2,
	0x3FE051EB,0x851EB852, 0x3FE1E644,0x3FCDAEED,
	0x3FE05A1C,0xAC083127, 0x3FE1F107,0x1AC5930A,
	0x3FE0624D,0xD2F1A9FC, 0x3FE1FBCD,0x0D01233D,
	0x3FE06A7E,0xF9DB22D1, 0x3FE20696,0x193F9203,
	0x3FE072B0,0x20C49BA6, 0x3FE21162,0x4242775C,
	0x3FE07AE1,0x47AE147B, 0x3FE21C31,0x8ACDD3D6,
	0x3FE08312,0x6E978D50, 0x3FE22703,0xF5A813A5,
	0x3FE08B43,0x95810625, 0x3FE231D9,0x859A11BA,
	0x3FE09374,0xBC6A7EFA, 0x3FE23CB2,0x3D6F1ADC,
	0x3FE09BA5,0xE353F7CF, 0x3FE2478E,0x1FF4F0C9,
	0x3FE0A3D7,0x0A3D70A4, 0x3FE2526D,0x2FFBCD5E,
	0x3FE0AC08,0x3126E979, 0x3FE25D4F,0x705665BE,
	0x3FE0B439,0x5810624E, 0x3FE26834,0xE3D9ED7D,
	0x3FE0BC6A,0x7EF9DB23, 0x3FE2731D,0x8D5E19DA,
	0x3FE0C49B,0xA5E353F8, 0x3FE27E09,0x6FBD24ED,
	0x3FE0CCCC,0xCCCCCCCD, 0x3FE288F8,0x8DD3D0EA,
	0x3FE0D4FD,0xF3B645A2, 0x3FE293EA,0xEA816B5D,
	0x3FE0DD2F,0x1A9FBE77, 0x3FE29EE0,0x88A7D070,
	0x3FE0E560,0x4189374C, 0x3FE2A9D9,0x6B2B6E34,
	0x3FE0ED91,0x6872B021, 0x3FE2B4D5,0x94F347F1,
	0x3FE0F5C2,0x8F5C28F6, 0x3FE2BFD5,0x08E8F977,
	0x3FE0FDF3,0xB645A1CB, 0x3FE2CAD7,0xC9F8BA79,
	0x3FE10624,0xDD2F1AA0, 0x3FE2D5DD,0xDB1161E4,
	0x3FE10E56,0x04189375, 0x3FE2E0E7,0x3F246948,
	0x3FE11687,0x2B020C4A, 0x3FE2EBF3,0xF925F038,
	0x3FE11EB8,0x51EB851F, 0x3FE2F704,0x0C0CBFBA,
	0x3FE126E9,0x78D4FDF4, 0x3FE30217,0x7AD24DB4,
	0x3FE12F1A,0x9FBE76C9, 0x3FE30D2E,0x4872C063,
	0x3FE1374B,0xC6A7EF9E, 0x3FE31848,0x77ECF1D8,
	0x3FE13F7C,0xED916873, 0x3FE32366,0x0C427371,
	0x3FE147AE,0x147AE148, 0x3FE32E87,0x08779164,
	0x3FE14FDF,0x3B645A1D, 0x3FE339AB,0x6F935645,
	0x3FE15810,0x624DD2F2, 0x3FE344D3,0x449F8E97,
	0x3FE16041,0x89374BC7, 0x3FE34FFE,0x8AA8CC5F,
	0x3FE16872,0xB020C49C, 0x3FE35B2D,0x44BE6ABD,
	0x3FE170A3,0xD70A3D71, 0x3FE3665F,0x75F2918C,
	0x3FE178D4,0xFDF3B646, 0x3FE37195,0x215A3904,
	0x3FE18106,0x24DD2F1B, 0x3FE37CCE,0x4A0D2D66,
	0x3FE18937,0x4BC6A7F0, 0x3FE3880A,0xF32612A9,
	0x3FE19168,0x72B020C5, 0x3FE3934B,0x1FC2682D,
	0x3FE19999,0x9999999A, 0x3FE39E8E,0xD3028C79,
	0x3FE1A1CA,0xC083126F, 0x3FE3A9D6,0x1009C0F3,
	0x3FE1A9FB,0xE76C8B44, 0x3FE3B520,0xD9FE2DAD,
	0x3FE1B22D,0x0E560419, 0x3FE3C06F,0x3408E528,
	0x3FE1BA5E,0x353F7CEE, 0x3FE3CBC1,0x2155E829,
	0x3FE1C28F,0x5C28F5C3, 0x3FE3D716,0xA514298B,
	0x3FE1CAC0,0x83126E98, 0x3FE3E26F,0xC275921C,
	0x3FE1D2F1,0xA9FBE76D, 0x3FE3EDCC,0x7CAF047E,
	0x3FE1DB22,0xD0E56042, 0x3FE3F92C,0xD6F8610E,
	0x3FE1E353,0xF7CED917, 0x3FE40490,0xD48C89CE,
	0x3FE1EB85,0x1EB851EC, 0x3FE40FF8,0x78A9665B,
	0x3FE1F3B6,0x45A1CAC1, 0x3FE41B63,0xC68FE7E4,
	0x3FE1FBE7,0x6C8B4396, 0x3FE426D2,0xC1840D26,
	0x3FE20418,0x9374BC6A, 0x3FE43245,0x6CCCE673,
	0x3FE20C49,0xBA5E353F, 0x3FE43DBB,0xCBB499BE,
	0x3FE2147A,0xE147AE14, 0x3FE44935,0xE18866A6,
	0x3FE21CAC,0x083126E9, 0x3FE454B3,0xB198AA90,
	0x3FE224DD,0x2F1A9FBE, 0x3FE46035,0x3F38E4C2,
	0x3FE22D0E,0x56041893, 0x3FE46BBA,0x8DBFBA87,
	0x3FE2353F,0x7CED9168, 0x3FE47743,0xA086FB5A,
	0x3FE23D70,0xA3D70A3D, 0x3FE482D0,0x7AEBA510,
	0x3FE245A1,0xCAC08312, 0x3FE48E61,0x204DE812,
	0x3FE24DD2,0xF1A9FBE7, 0x3FE499F5,0x94112B97,
	0x3FE25604,0x189374BC, 0x3FE4A58D,0xD99C11E9,
	0x3FE25E35,0x3F7CED91, 0x3FE4B129,0xF4587CA9,
	0x3FE26666,0x66666666, 0x3FE4BCC9,0xE7B39125,
	0x3FE26E97,0x8D4FDF3B, 0x3FE4C86D,0xB71DBCA8,
	0x3FE276C8,0xB4395810, 0x3FE4D415,0x660AB8D9,
	0x3FE27EF9,0xDB22D0E5, 0x3FE4DFC0,0xF7F1901F,
	0x3FE2872B,0x020C49BA, 0x3FE4EB70,0x704CA20A,
	0x3FE28F5C,0x28F5C28F, 0x3FE4F723,0xD299A7C4,
	0x3FE2978D,0x4FDF3B64, 0x3FE502DB,0x2259B888,
	0x3FE29FBE,0x76C8B439, 0x3FE50E96,0x63114E21,
	0x3FE2A7EF,0x9DB22D0E, 0x3FE51A55,0x9848496E,
	0x3FE2B020,0xC49BA5E3, 0x3FE52618,0xC589F6EE,
	0x3FE2B851,0xEB851EB8, 0x3FE531DF,0xEE651356,
	0x3FE2C083,0x126E978D, 0x3FE53DAB,0x166BD028,
	0x3FE2C8B4,0x39581062, 0x3FE5497A,0x4133D856,
	0x3FE2D0E5,0x60418937, 0x3FE5554D,0x725654E8,
	0x3FE2D916,0x872B020C, 0x3FE56124,0xAD6FF1AF,
	0x3FE2E147,0xAE147AE1, 0x3FE56CFF,0xF620E1FA,
	0x3FE2E978,0xD4FDF3B6, 0x3FE578DF,0x500CE553,
	0x3FE2F1A9,0xFBE76C8B, 0x3FE584C2,0xBEDB4C46,
	0x3FE2F9DB,0x22D0E560, 0x3FE590AA,0x4636FD2D,
	0x3FE3020C,0x49BA5E35, 0x3FE59C95,0xE9CE7907,
	0x3FE30A3D,0x70A3D70A, 0x3FE5A885,0xAD53E04E,
	0x3FE3126E,0x978D4FDF, 0x3FE5B479,0x947CF7E0,
	0x3FE31A9F,0xBE76C8B4, 0x3FE5C071,0xA3032DE9,
	0x3FE322D0,0xE5604189, 0x3FE5CC6D,0xDCA39ED1,
	0x3FE32B02,0x0C49BA5E, 0x3FE5D86E,0x451F1A3D,
	0x3FE33333,0x33333333, 0x3FE5E472,0xE03A280C,
	0x3FE33B64,0x5A1CAC08, 0x3FE5F07B,0xB1BD0D64,
	0x3FE34395,0x810624DD, 0x3FE5FC88,0xBD73D1C3,
	0x3FE34BC6,0xA7EF9DB2, 0x3FE6089A,0x072E4418,
	0x3FE353F7,0xCED91687, 0x3FE614AF,0x92BFFFE6,
	0x3FE35C28,0xF5C28F5C, 0x3FE620C9,0x6400726E,
	0x3FE3645A,0x1CAC0831, 0x3FE62CE7,0x7ECADFDE,
	0x3FE36C8B,0x43958106, 0x3FE63909,0xE6FE6891,
	0x3FE374BC,0x6A7EF9DB, 0x3FE64530,0xA07E0E4D,
	0x3FE37CED,0x916872B0, 0x3FE6515B,0xAF30B98E,
	0x3FE3851E,0xB851EB85, 0x3FE65D8B,0x17013EDB,
	0x3FE38D4F,0xDF3B645A, 0x3FE669BE,0xDBDE6420,
	0x3FE39581,0x0624DD2F, 0x3FE675F7,0x01BAE614,
	0x3FE39DB2,0x2D0E5604, 0x3FE68233,0x8C8D7DA3,
	0x3FE3A5E3,0x53F7CED9, 0x3FE68E74,0x8050E566,
	0x3FE3AE14,0x7AE147AE, 0x3FE69AB9,0xE103DF1F,
	0x3FE3B645,0xA1CAC083, 0x3FE6A703,0xB2A9393F,
	0x3FE3BE76,0xC8B43958, 0x3FE6B351,0xF947D479,
	0x3FE3C6A7,0xEF9DB22D, 0x3FE6BFA4,0xB8EAA955,
	0x3FE3CED9,0x16872B02, 0x3FE6CBFB,0xF5A0CDD7,
	0x3FE3D70A,0x3D70A3D7, 0x3FE6D857,0xB37D7B26,
	0x3FE3DF3B,0x645A1CAC, 0x3FE6E4B7,0xF698133F,
	0x3FE3E76C,0x8B439581, 0x3FE6F11C,0xC30C26B2,
	0x3FE3EF9D,0xB22D0E56, 0x3FE6FD86,0x1CF97A6A,
	0x3FE3F7CE,0xD916872B, 0x3FE709F4,0x08840D78,
	0x3FE40000,0x00000000, 0x3FE71666,0x89D41EF0,
	0x3FE40831,0x26E978D5, 0x3FE722DD,0xA51633C4,
	0x3FE41062,0x4DD2F1AA, 0x3FE72F59,0x5E7B1CB8,
	0x3FE41893,0x74BC6A7F, 0x3FE73BD9,0xBA37FC4F,
	0x3FE420C4,0x9BA5E354, 0x3FE7485E,0xBC864CCE,
	0x3FE428F5,0xC28F5C29, 0x3FE754E8,0x69A3E641,
	0x3FE43126,0xE978D4FE, 0x3FE76176,0xC5D30490,
	0x3FE43958,0x10624DD3, 0x3FE76E09,0xD55A4D98,
	0x3FE44189,0x374BC6A8, 0x3FE77AA1,0x9C84D752,
	0x3FE449BA,0x5E353F7D, 0x3FE7873E,0x1FA22E03,
	0x3FE451EB,0x851EB852, 0x3FE793DF,0x63065A74,
	0x3FE45A1C,0xAC083127, 0x3FE7A085,0x6B09E838,
	0x3FE4624D,0xD2F1A9FC, 0x3FE7AD30,0x3C09EBF7,
	0x3FE46A7E,0xF9DB22D1, 0x3FE7B9DF,0xDA6809CB,
	0x3FE472B0,0x20C49BA6, 0x3FE7C694,0x4A8A7B9C,
	0x3FE47AE1,0x47AE147B, 0x3FE7D34D,0x90DC1794,
	0x3FE48312,0x6E978D50, 0x3FE7E00B,0xB1CC5692,
	0x3FE48B43,0x95810625, 0x3FE7ECCE,0xB1CF5AB0,
	0x3FE49374,0xBC6A7EFA, 0x3FE7F996,0x955DF5CC,
	0x3FE49BA5,0xE353F7CF, 0x3FE80663,0x60F5B022,
	0x3FE4A3D7,0x0A3D70A4, 0x3FE81335,0x1918CEEE,
	0x3FE4AC08,0x3126E979, 0x3FE8200B,0xC24E5B1B,
	0x3FE4B439,0x5810624E, 0x3FE82CE7,0x612227F9,
	0x3FE4BC6A,0x7EF9DB23, 0x3FE839C7,0xFA24DA03,
	0x3FE4C49B,0xA5E353F8, 0x3FE846AD,0x91EBEDAB,
	0x3FE4CCCC,0xCCCCCCCD, 0x3FE85398,0x2D11BE39,
	0x3FE4D4FD,0xF3B645A2, 0x3FE86087,0xD0358CA9,
	0x3FE4DD2F,0x1A9FBE77, 0x3FE86D7C,0x7FFB86A5,
	0x3FE4E560,0x4189374C, 0x3FE87A76,0x410CCD79,
	0x3FE4ED91,0x6872B021, 0x3FE88775,0x18177D20,
	0x3FE4F5C2,0x8F5C28F6, 0x3FE89479,0x09CEB357,
	0x3FE4FDF3,0xB645A1CB, 0x3FE8A182,0x1AEA96BC,
	0x3FE50624,0xDD2F1AA0, 0x3FE8AE90,0x50285DF9,
	0x3FE50E56,0x04189375, 0x3FE8BBA3,0xAE4A56FB,
	0x3FE51687,0x2B020C4A, 0x3FE8C8BC,0x3A17EE38,
	0x3FE51EB8,0x51EB851F, 0x3FE8D5D9,0xF85DB5FD,
	0x3FE526E9,0x78D4FDF4, 0x3FE8E2FC,0xEDED6DC9,
	0x3FE52F1A,0x9FBE76C9, 0x3FE8F025,0x1F9E09B8,
	0x3FE5374B,0xC6A7EF9E, 0x3FE8FD52,0x924BB9F3,
	0x3FE53F7C,0xED916873, 0x3FE90A85,0x4AD7F238,
	0x3FE547AE,0x147AE148, 0x3FE917BD,0x4E297162,
	0x3FE54FDF,0x3B645A1D, 0x3FE924FA,0xA12C4906,
	0x3FE55810,0x624DD2F2, 0x3FE9323D,0x48D1E51B,
	0x3FE56041,0x89374BC7, 0x3FE93F85,0x4A1113AE,
	0x3FE56872,0xB020C49C, 0x3FE94CD2,0xA9E60CA2,
	0x3FE570A3,0xD70A3D71, 0x3FE95A25,0x6D527983,
	0x3FE578D4,0xFDF3B646, 0x3FE9677D,0x995D7D5B,
	0x3FE58106,0x24DD2F1B, 0x3FE974DB,0x3313BCA1,
	0x3FE58937,0x4BC6A7F0, 0x3FE9823E,0x3F87652F,
	0x3FE59168,0x72B020C5, 0x3FE98FA6,0xC3D03643,
	0x3FE59999,0x9999999A, 0x3FE99D14,0xC50B8893,
	0x3FE5A1CA,0xC083126F, 0x3FE9AA88,0x485C566E,
	0x3FE5A9FB,0xE76C8B44, 0x3FE9B801,0x52EB43E6,
	0x3FE5B22D,0x0E560419, 0x3FE9C57F,0xE9E6A710,
	0x3FE5BA5E,0x353F7CEE, 0x3FE9D304,0x1282904A,
	0x3FE5C28F,0x5C28F5C3, 0x3FE9E08D,0xD1F8D294,
	0x3FE5CAC0,0x83126E98, 0x3FE9EE1D,0x2D890BF7,
	0x3FE5D2F1,0xA9FBE76D, 0x3FE9FBB2,0x2A78ADF7,
	0x3FE5DB22,0xD0E56042, 0x3FEA094C,0xCE13061B,
	0x3FE5E353,0xF7CED917, 0x3FEA16ED,0x1DA9467A,
	0x3FE5EB85,0x1EB851EC, 0x3FEA2493,0x1E928E5D,
	0x3FE5F3B6,0x45A1CAC1, 0x3FEA323E,0xD62BF2F1,
	0x3FE5FBE7,0x6C8B4396, 0x3FEA3FF0,0x49D88802,
	0x3FE60418,0x9374BC6A, 0x3FEA4DA7,0x7F0168C8,
	0x3FE60C49,0xBA5E353F, 0x3FEA5B64,0x7B15C0CC,
	0x3FE6147A,0xE147AE14, 0x3FEA6927,0x438AD4C9,
	0x3FE61CAC,0x083126E9, 0x3FEA76EF,0xDDDC0BB0,
	0x3FE624DD,0x2F1A9FBE, 0x3FEA84BE,0x4F8AF7AD,
	0x3FE62D0E,0x56041893, 0x3FEA9292,0x9E1F5F49,
	0x3FE6353F,0x7CED9168, 0x3FEAA06C,0xCF274691,
	0x3FE63D70,0xA3D70A3D, 0x3FEAAE4C,0xE836F850,
	0x3FE645A1,0xCAC08312, 0x3FEABC32,0xEEE90F5D,
	0x3FE64DD2,0xF1A9FBE7, 0x3FEACA1E,0xE8DE7FF5,
	0x3FE65604,0x189374BC, 0x3FEAD810,0xDBBEA128,
	0x3FE65E35,0x3F7CED91, 0x3FEAE608,0xCD373653,
	0x3FE66666,0x66666666, 0x3FEAF406,0xC2FC78AE,
	0x3FE66E97,0x8D4FDF3B, 0x3FEB020A,0xC2C920EB,
	0x3FE676C8,0xB4395810, 0x3FEB1014,0xD25E70E4,
	0x3FE67EF9,0xDB22D0E5, 0x3FEB1E24,0xF7843D5A,
	0x3FE6872B,0x020C49BA, 0x3FEB2C3B,0x3808F7C5,
	0x3FE68F5C,0x28F5C28F, 0x3FEB3A57,0x99C1B83B,
	0x3FE6978D,0x4FDF3B64, 0x3FEB487A,0x228A475E,
	0x3FE69FBE,0x76C8B439, 0x3FEB56A2,0xD8452863,
	0x3FE6A7EF,0x9DB22D0E, 0x3FEB64D1,0xC0DBA32D,
	0x3FE6B020,0xC49BA5E3, 0x3FEB7306,0xE23DCE72,
	0x3FE6B851,0xEB851EB8, 0x3FEB8142,0x426299F4,
	0x3FE6C083,0x126E978D, 0x3FEB8F83,0xE747D8D7,
	0x3FE6C8B4,0x39581062, 0x3FEB9DCB,0xD6F24BF6,
	0x3FE6D0E5,0x60418937, 0x3FEBAC1A,0x176DAC5E,
	0x3FE6D916,0x872B020C, 0x3FEBBA6E,0xAECCB5CC,
	0x3FE6E147,0xAE147AE1, 0x3FEBC8C9,0xA329314A,
	0x3FE6E978,0xD4FDF3B6, 0x3FEBD72A,0xFAA3FFD7,
	0x3FE6F1A9,0xFBE76C8B, 0x3FEBE592,0xBB652523,
	0x3FE6F9DB,0x22D0E560, 0x3FEBF400,0xEB9BD264,
	0x3FE7020C,0x49BA5E35, 0x3FEC0275,0x917E7138,
	0x3FE70A3D,0x70A3D70A, 0x3FEC10F0,0xB34AAE9D,
	0x3FE7126E,0x978D4FDF, 0x3FEC1F72,0x574585FB,
	0x3FE71A9F,0xBE76C8B4, 0x3FEC2DFA,0x83BB4C49,
	0x3FE722D0,0xE5604189, 0x3FEC3C89,0x3EFFBB3B,
	0x3FE72B02,0x0C49BA5E, 0x3FEC4B1E,0x8F6DFC8D,
	0x3FE73333,0x33333333, 0x3FEC59BA,0x7B68B55E,
	0x3FE73B64,0x5A1CAC08, 0x3FEC685D,0x095A11A4,
	0x3FE74395,0x810624DD, 0x3FEC7706,0x3FB3CFAB,
	0x3FE74BC6,0xA7EF9DB2, 0x3FEC85B6,0x24EF4BB8,
	0x3FE753F7,0xCED91687, 0x3FEC946C,0xBF8D8BB3,
	0x3FE75C28,0xF5C28F5C, 0x3FECA32A,0x16174AEE,
	0x3FE7645A,0x1CAC0831, 0x3FECB1EE,0x2F1D05FE,
	0x3FE76C8B,0x43958106, 0x3FECC0B9,0x113706AD,
	0x3FE774BC,0x6A7EF9DB, 0x3FECCF8A,0xC3057001,
	0x3FE77CED,0x916872B0, 0x3FECDE63,0x4B304A52,
	0x3FE7851E,0xB851EB85, 0x3FECED42,0xB0678F85,
	0x3FE78D4F,0xDF3B645A, 0x3FECFC28,0xF963374B,
	0x3FE79581,0x0624DD2F, 0x3FED0B16,0x2CE34388,
	0x3FE79DB2,0x2D0E5604, 0x3FED1A0A,0x51AFCCC3,
	0x3FE7A5E3,0x53F7CED9, 0x3FED2905,0x6E990EB7,
	0x3FE7AE14,0x7AE147AE, 0x3FED3807,0x8A7774F3,
	0x3FE7B645,0xA1CAC083, 0x3FED4710,0xAC2BA799,
	0x3FE7BE76,0xC8B43958, 0x3FED5620,0xDA9E982C,
	0x3FE7C6A7,0xEF9DB22D, 0x3FED6538,0x1CC18E80,
	0x3FE7CED9,0x16872B02, 0x3FED7456,0x798E35B7,
	0x3FE7D70A,0x3D70A3D7, 0x3FED837B,0xF806A960,
	0x3FE7DF3B,0x645A1CAC, 0x3FED92A8,0x9F3582A4,
	0x3FE7E76C,0x8B439581, 0x3FEDA1DC,0x762DE599,
	0x3FE7EF9D,0xB22D0E56, 0x3FEDB117,0x840B8EA0,
	0x3FE7F7CE,0xD916872B, 0x3FEDC059,0xCFF2DFE2,
	0x3FE80000,0x00000000, 0x3FEDCFA3,0x6110EEEC,
	0x3FE80831,0x26E978D5, 0x3FEDDEF4,0x3E9B9257,
	0x3FE81062,0x4DD2F1AA, 0x3FEDEE4C,0x6FD16F97,
	0x3FE81893,0x74BC6A7F, 0x3FEDFDAB,0xFBFA08DB,
	0x3FE820C4,0x9BA5E354, 0x3FEE0D12,0xEA65CB0C,
	0x3FE828F5,0xC28F5C29, 0x3FEE1C81,0x426E1BE0,
	0x3FE83126,0xE978D4FE, 0x3FEE2BF7,0x0B756811,
	0x3FE83958,0x10624DD3, 0x3FEE3B74,0x4CE731A9,
	0x3FE84189,0x374BC6A8, 0x3FEE4AF9,0x0E381E65,
	0x3FE849BA,0x5E353F7D, 0x3FEE5A85,0x56E6063B,
	0x3FE851EB,0x851EB852, 0x3FEE6A19,0x2E7801FA,
	0x3FE85A1C,0xAC083127, 0x3FEE79B4,0x9C7E79FD,
	0x3FE8624D,0xD2F1A9FC, 0x3FEE8957,0xA8933509,
	0x3FE86A7E,0xF9DB22D1, 0x3FEE9902,0x5A596739,
	0x3FE872B0,0x20C49BA6, 0x3FEEA8B4,0xB97DC10D,
	0x3FE87AE1,0x47AE147B, 0x3FEEB86E,0xCDB67E96,
	0x3FE88312,0x6E978D50, 0x3FEEC830,0x9EC376BE,
	0x3FE88B43,0x95810625, 0x3FEED7FA,0x346E2AAB,
	0x3FE89374,0xBC6A7EFA, 0x3FEEE7CB,0x9689D542,
	0x3FE89BA5,0xE353F7CF, 0x3FEEF7A4,0xCCF37AC9,
	0x3FE8A3D7,0x0A3D70A4, 0x3FEF0785,0xDF91F8A0,
	0x3FE8AC08,0x3126E979, 0x3FEF176E,0xD6561520,
	0x3FE8B439,0x5810624E, 0x3FEF275F,0xB93A8F96,
	0x3FE8BC6A,0x7EF9DB23, 0x3FEF3758,0x9044305A,
	0x3FE8C49B,0xA5E353F8, 0x3FEF4759,0x6381D906,
	0x3FE8CCCC,0xCCCCCCCD, 0x3FEF5762,0x3B0C94D1,
	0x3FE8D4FD,0xF3B645A2, 0x3FEF6773,0x1F07A904,
	0x3FE8DD2F,0x1A9FBE77, 0x3FEF778C,0x17A0A58D,
	0x3FE8E560,0x4189374C, 0x3FEF87AD,0x2D0F75BC,
	0x3FE8ED91,0x6872B021, 0x3FEF97D6,0x67967113,
	0x3FE8F5C2,0x8F5C28F6, 0x3FEFA807,0xCF826C45,
	0x3FE8FDF3,0xB645A1CB, 0x3FEFB841,0x6D2ACA46,
	0x3FE90624,0xDD2F1AA0, 0x3FEFC883,0x48F18D8C,
	0x3FE90E56,0x04189375, 0x3FEFD8CD,0x6B436967,
	0x3FE91687,0x2B020C4A, 0x3FEFE91F,0xDC97D37E,
	0x3FE91EB8,0x51EB851F, 0x3FEFF97A,0xA571156E,
	0x3FE926E9,0x78D4FDF4, 0x3FF004EE,0xE72E2F47,
	0x3FE92F1A,0x9FBE76C9, 0x3FF00D24,0xAFF8EAE6,
	0x3FE9374B,0xC6A7EF9E, 0x3FF0155E,0xB16A55E2,
	0x3FE93F7C,0xED916873, 0x3FF01D9C,0xEFD9966A,
	0x3FE947AE,0x147AE148, 0x3FF025DF,0x6FA369BF,
	0x3FE94FDF,0x3B645A1D, 0x3FF02E26,0x352A2D6A,
	0x3FE95810,0x624DD2F2, 0x3FF03671,0x44D5E886,
	0x3FE96041,0x89374BC7, 0x3FF03EC0,0xA314551D,
	0x3FE96872,0xB020C49C, 0x3FF04714,0x5458E99B,
	0x3FE970A3,0xD70A3D71, 0x3FF04F6C,0x5D1CE251,
	0x3FE978D4,0xFDF3B646, 0x3FF057C8,0xC1DF4B06,
	0x3FE98106,0x24DD2F1B, 0x3FF06029,0x872508A5,
	0x3FE98937,0x4BC6A7F0, 0x3FF0688E,0xB178E2F5,
	0x3FE99168,0x72B020C5, 0x3FF070F8,0x456B8E6B,
	0x3FE99999,0x9999999A, 0x3FF07966,0x4793B60B,
	0x3FE9A1CA,0xC083126F, 0x3FF081D8,0xBC8E055D,
	0x3FE9A9FB,0xE76C8B44, 0x3FF08A4F,0xA8FD327A,
	0x3FE9B22D,0x0E560419, 0x3FF092CB,0x118A0829,
	0x3FE9BA5E,0x353F7CEE, 0x3FF09B4A,0xFAE37011,
	0x3FE9C28F,0x5C28F5C3, 0x3FF0A3CF,0x69BE7D01,
	0x3FE9CAC0,0x83126E98, 0x3FF0AC58,0x62D67549,
	0x3FE9D2F1,0xA9FBE76D, 0x3FF0B4E5,0xEAECDD2E,
	0x3FE9DB22,0xD0E56042, 0x3FF0BD78,0x06C9816D,
	0x3FE9E353,0xF7CED917, 0x3FF0C60E,0xBB3A81D5,
	0x3FE9EB85,0x1EB851EC, 0x3FF0CEAA,0x0D145BF9,
	0x3FE9F3B6,0x45A1CAC1, 0x3FF0D74A,0x0131F5F4,
	0x3FE9FBE7,0x6C8B4396, 0x3FF0DFEE,0x9C74A944,
	0x3FEA0418,0x9374BC6A, 0x3FF0E897,0xE3C44DB9,
	0x3FEA0C49,0xBA5E353F, 0x3FF0F145,0xDC0F4484,
	0x3FEA147A,0xE147AE14, 0x3FF0F9F8,0x8A4A834B,
	0x3FEA1CAC,0x083126E9, 0x3FF102AF,0xF3719F65,
	0x3FEA24DD,0x2F1A9FBE, 0x3FF10B6C,0x1C86D920,
	0x3FEA2D0E,0x56041893, 0x3FF1142D,0x0A932724,
	0x3FEA353F,0x7CED9168, 0x3FF11CF2,0xC2A641F1,
	0x3FEA3D70,0xA3D70A3D, 0x3FF125BD,0x49D6AF6A,
	0x3FEA45A1,0xCAC08312, 0x3FF12E8C,0xA541CE7E,
	0x3FEA4DD2,0xF1A9FBE7, 0x3FF13760,0xDA0BE2EE,
	0x3FEA5604,0x189374BC, 0x3FF14039,0xED60211D,
	0x3FEA5E35,0x3F7CED91, 0x3FF14917,0xE470BA09,
	0x3FEA6666,0x66666666, 0x3FF151FA,0xC476E74D,
	0x3FEA6E97,0x8D4FDF3B, 0x3FF15AE2,0x92B2F74A,
	0x3FEA76C8,0xB4395810, 0x3FF163CF,0x546C595C,
	0x3FEA7EF9,0xDB22D0E5, 0x3FF16CC1,0x0EF1AA33,
	0x3FEA872B,0x020C49BA, 0x3FF175B7,0xC798C03D,
	0x3FEA8F5C,0x28F5C28F, 0x3FF17EB3,0x83BEB831,
	0x3FEA978D,0x4FDF3B64, 0x3FF187B4,0x48C801B0,
	0x3FEA9FBE,0x76C8B439, 0x3FF190BA,0x1C206BFF,
	0x3FEAA7EF,0x9DB22D0E, 0x3FF199C5,0x033B32DE,
	0x3FEAB020,0xC49BA5E3, 0x3FF1A2D5,0x03930B7A,
	0x3FEAB851,0xEB851EB8, 0x3FF1ABEA,0x22AA317A,
	0x3FEAC083,0x126E978D, 0x3FF1B504,0x660A7423,
	0x3FEAC8B4,0x39581062, 0x3FF1BE23,0xD345439D,
	0x3FEAD0E5,0x60418937, 0x3FF1C748,0x6FF3BE53,
	0x3FEAD916,0x872B020C, 0x3FF1D072,0x41B6BE68,
	0x3FEAE147,0xAE147AE1, 0x3FF1D9A1,0x4E36E755,
	0x3FEAE978,0xD4FDF3B6, 0x3FF1E2D5,0x9B24B399,
	0x3FEAF1A9,0xFBE76C8B, 0x3FF1EC0F,0x2E388287,
	0x3FEAF9DB,0x22D0E560, 0x3FF1F54E,0x0D32A638,
	0x3FEB020C,0x49BA5E35, 0x3FF1FE92,0x3DDB7193,
	0x3FEB0A3D,0x70A3D70A, 0x3FF207DB,0xC6034677,
	0x3FEB126E,0x978D4FDF, 0x3FF2112A,0xAB82A3FF,
	0x3FEB1A9F,0xBE76C8B4, 0x3FF21A7E,0xF43A34EA,
	0x3FEB22D0,0xE5604189, 0x3FF223D8,0xA612DE1C,
	0x3FEB2B02,0x0C49BA5E, 0x3FF22D37,0xC6FDCD41,
	0x3FEB3333,0x33333333, 0x3FF2369C,0x5CF4878D,
	0x3FEB3B64,0x5A1CAC08, 0x3FF24006,0x6DF8F8A1,
	0x3FEB4395,0x810624DD, 0x3FF24976,0x00158186,
	0x3FEB4BC6,0xA7EF9DB2, 0x3FF252EB,0x195D07D1,
	0x3FEB53F7,0xCED91687, 0x3FF25C65,0xBFEB04E2,
	0x3FEB5C28,0xF5C28F5C, 0x3FF265E5,0xF9E39549,
	0x3FEB645A,0x1CAC0831, 0x3FF26F6B,0xCD738845,
	0x3FEB6C8B,0x43958106, 0x3FF278F7,0x40D06F6A,
	0x3FEB74BC,0x6A7EF9DB, 0x3FF28288,0x5A38AE65,
	0x3FEB7CED,0x916872B0, 0x3FF28C1F,0x1FF38AE8,
	0x3FEB851E,0xB851EB85, 0x3FF295BB,0x98513CAD,
	0x3FEB8D4F,0xDF3B645A, 0x3FF29F5D,0xC9AAFDAC,
	0x3FEB9581,0x0624DD2F, 0x3FF2A905,0xBA631A61,
	0x3FEB9DB2,0x2D0E5604, 0x3FF2B2B3,0x70E50246,
	0x3FEBA5E3,0x53F7CED9, 0x3FF2BC66,0xF3A55868,
	0x3FEBAE14,0x7AE147AE, 0x3FF2C620,0x49220420,
	0x3FEBB645,0xA1CAC083, 0x3FF2CFDF,0x77E241F7,
	0x3FEBBE76,0xC8B43958, 0x3FF2D9A4,0x8676B4A3,
	0x3FEBC6A7,0xEF9DB22D, 0x3FF2E36F,0x7B797639,
	0x3FEBCED9,0x16872B02, 0x3FF2ED40,0x5D8E2973,
	0x3FEBD70A,0x3D70A3D7, 0x3FF2F717,0x33620B2C,
	0x3FEBDF3B,0x645A1CAC, 0x3FF300F4,0x03AC03F8,
	0x3FEBE76C,0x8B439581, 0x3FF30AD6,0xD52CB9E5,
	0x3FEBEF9D,0xB22D0E56, 0x3FF314BF,0xAEAEA264,
	0x3FEBF7CE,0xD916872B, 0x3FF31EAE,0x9706145C,
	0x3FEC0000,0x00000000, 0x3FF328A3,0x95115A5E,
	0x3FEC0831,0x26E978D5, 0x3FF3329E,0xAFB8C508,
	0x3FEC1062,0x4DD2F1AA, 0x3FF33C9F,0xEDEEBD8E,
	0x3FEC1893,0x74BC6A7F, 0x3FF346A7,0x56AFD869,
	0x3FEC20C4,0x9BA5E354, 0x3FF350B4,0xF102E838,
	0x3FEC28F5,0xC28F5C29, 0x3FF35AC8,0xC3F910BF,
	0x3FEC3126,0xE978D4FE, 0x3FF364E2,0xD6ADDA1D,
	0x3FEC3958,0x10624DD3, 0x3FF36F03,0x30474420,
	0x3FEC4189,0x374BC6A8, 0x3FF37929,0xD7F5D9D1,
	0x3FEC49BA,0x5E353F7D, 0x3FF38356,0xD4F4C522,
	0x3FEC51EB,0x851EB852, 0x3FF38D8A,0x2E89E2C9,
	0x3FEC5A1C,0xAC083127, 0x3FF397C3,0xEC05D651,
	0x3FEC624D,0xD2F1A9FC, 0x3FF3A204,0x14C41E4A,
	0x3FEC6A7E,0xF9DB22D1, 0x3FF3AC4A,0xB02B28B1,
	0x3FEC72B0,0x20C49BA6, 0x3FF3B697,0xC5AC6780,
	0x3FEC7AE1,0x47AE147B, 0x3FF3C0EB,0x5CC46571,
	0x3FEC8312,0x6E978D50, 0x3FF3CB45,0x7CFADAED,
	0x3FEC8B43,0x95810625, 0x3FF3D5A6,0x2DE2C329,
	0x3FEC9374,0xBC6A7EFA, 0x3FF3E00D,0x771A7177,
	0x3FEC9BA5,0xE353F7CF, 0x3FF3EA7B,0x604BA6C3,
	0x3FECA3D7,0x0A3D70A4, 0x3FF3F4EF,0xF12BA744,
	0x3FECAC08,0x3126E979, 0x3FF3FF6B,0x317B505E,
	0x3FECB439,0x5810624E, 0x3FF409ED,0x29072EB4,
	0x3FECBC6A,0x7EF9DB23, 0x3FF41475,0xDFA7946B,
	0x3FECC49B,0xA5E353F8, 0x3FF41F05,0x5D40AFA9,
	0x3FECCCCC,0xCCCCCCCD, 0x3FF4299B,0xA9C2A138,
	0x3FECD4FD,0xF3B645A2, 0x3FF43438,0xCD29936D,
	0x3FECDD2F,0x1A9FBE77, 0x3FF43EDC,0xCF7DD138,
	0x3FECE560,0x4189374C, 0x3FF44987,0xB8D3DD6F,
	0x3FECED91,0x6872B021, 0x3FF45439,0x914C8A4D,
	0x3FECF5C2,0x8F5C28F6, 0x3FF45EF2,0x61151124,
	0x3FECFDF3,0xB645A1CB, 0x3FF469B2,0x30672A4F,
	0x3FED0624,0xDD2F1AA0, 0x3FF47479,0x0789254D,
	0x3FED0E56,0x04189375, 0x3FF47F46,0xEECE0123,
	0x3FED1687,0x2B020C4A, 0x3FF48A1B,0xEE9584EB,
	0x3FED1EB8,0x51EB851F, 0x3FF494F8,0x0F4C58A5,
	0x3FED26E9,0x78D4FDF4, 0x3FF49FDB,0x596C1E38,
	0x3FED2F1A,0x9FBE76C9, 0x3FF4AAC5,0xD57B8AB6,
	0x3FED374B,0xC6A7EF9E, 0x3FF4B5B7,0x8C0E7FD6,
	0x3FED3F7C,0xED916873, 0x3FF4C0B0,0x85C625AE,
	0x3FED47AE,0x147AE148, 0x3FF4CBB0,0xCB5104A3,
	0x3FED4FDF,0x3B645A1D, 0x3FF4D6B8,0x656B1F99,
	0x3FED5810,0x624DD2F2, 0x3FF4E1C7,0x5CDE0E65,
	0x3FED6041,0x89374BC7, 0x3FF4ECDD,0xBA811873,
	0x3FED6872,0xB020C49C, 0x3FF4F7FB,0x87394FB5,
	0x3FED70A3,0xD70A3D71, 0x3FF50320,0xCBF9ABCC,
	0x3FED78D4,0xFDF3B646, 0x3FF50E4D,0x91C32570,
	0x3FED8106,0x24DD2F1B, 0x3FF51981,0xE1A4D220,
	0x3FED8937,0x4BC6A7F0, 0x3FF524BD,0xC4BC000B,
	0x3FED9168,0x72B020C5, 0x3FF53001,0x4434523D,
	0x3FED9999,0x9999999A, 0x3FF53B4C,0x6947DD19,
	0x3FEDA1CA,0xC083126F, 0x3FF5469F,0x3D3F4306,
	0x3FEDA9FB,0xE76C8B44, 0x3FF551F9,0xC971D170,
	0x3FEDB22D,0x0E560419, 0x3FF55D5C,0x17459E02,
	0x3FEDBA5E,0x353F7CEE, 0x3FF568C6,0x302FA431,
	0x3FEDC28F,0x5C28F5C3, 0x3FF57438,0x1DB3E303,
	0x3FEDCAC0,0x83126E98, 0x3FF57FB1,0xE9657B27,
	0x3FEDD2F1,0xA9FBE76D, 0x3FF58B33,0x9CE6CD4D,
	0x3FEDDB22,0xD0E56042, 0x3FF596BD,0x41E998CF,
	0x3FEDE353,0xF7CED917, 0x3FF5A24E,0xE22F1A9E,
	0x3FEDEB85,0x1EB851EC, 0x3FF5ADE8,0x87882C79,
	0x3FEDF3B6,0x45A1CAC1, 0x3FF5B98A,0x3BD5647A,
	0x3FEDFBE7,0x6C8B4396, 0x3FF5C534,0x090734DD,
	0x3FEE0418,0x9374BC6A, 0x3FF5D0E5,0xF91E0C29,
	0x3FEE0C49,0xBA5E353F, 0x3FF5DCA0,0x162A7597,
	0x3FEE147A,0xE147AE14, 0x3FF5E862,0x6A4D39CE,
	0x3FEE1CAC,0x083126E9, 0x3FF5F42C,0xFFB77FEF,
	0x3FEE24DD,0x2F1A9FBE, 0x3FF5FFFF,0xE0AAEEF5,
	0x3FEE2D0E,0x56041893, 0x3FF60BDB,0x1779CF5C,
	0x3FEE353F,0x7CED9168, 0x3FF617BE,0xAE872D27,
	0x3FEE3D70,0xA3D70A3D, 0x3FF623AA,0xB046FA33,
	0x3FEE45A1,0xCAC08312, 0x3FF62F9F,0x273E30DA,
	0x3FEE4DD2,0xF1A9FBE7, 0x3FF63B9C,0x1E02F6F9,
	0x3FEE5604,0x189374BC, 0x3FF647A1,0x9F3CC13D,
	0x3FEE5E35,0x3F7CED91, 0x3FF653AF,0xB5A476D1,
	0x3FEE6666,0x66666666, 0x3FF65FC6,0x6C04955F,
	0x3FEE6E97,0x8D4FDF3B, 0x3FF66BE5,0xCD39556F,
	0x3FEE76C8,0xB4395810, 0x3FF6780D,0xE430CF1D,
	0x3FEE7EF9,0xDB22D0E5, 0x3FF6843E,0xBBEB1F29,
	0x3FEE872B,0x020C49BA, 0x3FF69078,0x5F7A8C68,
	0x3FEE8F5C,0x28F5C28F, 0x3FF69CBA,0xDA03AD8D,
	0x3FEE978D,0x4FDF3B64, 0x3FF6A906,0x36BD8F54,
	0x3FEE9FBE,0x76C8B439, 0x3FF6B55A,0x80F1DB0C,
	0x3FEEA7EF,0x9DB22D0E, 0x3FF6C1B7,0xC3FCFD81,
	0x3FEEB020,0xC49BA5E3, 0x3FF6CE1E,0x0B4E4E46,
	0x3FEEB851,0xEB851EB8, 0x3FF6DA8D,0x62683765,
	0x3FEEC083,0x126E978D, 0x3FF6E705,0xD4E05D6F,
	0x3FEEC8B4,0x39581062, 0x3FF6F387,0x6E5FC7F9,
	0x3FEED0E5,0x60418937, 0x3FF70012,0x3AA30A73,
	0x3FEED916,0x872B020C, 0x3FF70CA6,0x457A6D70,
	0x3FEEE147,0xAE147AE1, 0x3FF71943,0x9ACA1855,
	0x3FEEE978,0xD4FDF3B6, 0x3FF725EA,0x468A3B70,
	0x3FEEF1A9,0xFBE76C8B, 0x3FF7329A,0x54C73A77,
	0x3FEEF9DB,0x22D0E560, 0x3FF73F53,0xD1A1D77C,
	0x3FEF020C,0x49BA5E35, 0x3FF74C16,0xC94F5E46,
	0x3FEF0A3D,0x70A3D70A, 0x3FF758E3,0x4819D01E,
	0x3FEF126E,0x978D4FDF, 0x3FF765B9,0x5A601009,
	0x3FEF1A9F,0xBE76C8B4, 0x3FF77299,0x0C960F77,
	0x3FEF22D0,0xE5604189, 0x3FF77F82,0x6B44FB5F,
	0x3FEF2B02,0x0C49BA5E, 0x3FF78C75,0x830B69D7,
	0x3FEF3333,0x33333333, 0x3FF79972,0x609D881A,
	0x3FEF3B64,0x5A1CAC08, 0x3FF7A679,0x10C54907,
	0x3FEF4395,0x810624DD, 0x3FF7B389,0xA0629420,
	0x3FEF4BC6,0xA7EF9DB2, 0x3FF7C0A4,0x1C6B74F2,
	0x3FEF53F7,0xCED91687, 0x3FF7CDC8,0x91EC4B0A,
	0x3FEF5C28,0xF5C28F5C, 0x3FF7DAF7,0x0E07FA5D,
	0x3FEF645A,0x1CAC0831, 0x3FF7E82F,0x9DF81C2B,
	0x3FEF6C8B,0x43958106, 0x3FF7F572,0x4F0D306E,
	0x3FEF74BC,0x6A7EF9DB, 0x3FF802BF,0x2EAECFBA,
	0x3FEF7CED,0x916872B0, 0x3FF81016,0x4A5BDDAF,
	0x3FEF851E,0xB851EB85, 0x3FF81D77,0xAFAABBE4,
	0x3FEF8D4F,0xDF3B645A, 0x3FF82AE3,0x6C497D5E,
	0x3FEF9581,0x0624DD2F, 0x3FF83859,0x8DFE1A8A,
	0x3FEF9DB2,0x2D0E5604, 0x3FF845DA,0x22A6A5C3,
	0x3FEFA5E3,0x53F7CED9, 0x3FF85365,0x38398065,
	0x3FEFAE14,0x7AE147AE, 0x3FF860FA,0xDCC59064,
	0x3FEFB645,0xA1CAC083, 0x3FF86E9B,0x1E727679,
	0x3FEFBE76,0xC8B43958, 0x3FF87C46,0x0B80C4DB,
	0x3FEFC6A7,0xEF9DB22D, 0x3FF889FB,0xB24A368C,
	0x3FEFCED9,0x16872B02, 0x3FF897BC,0x2141E735,
	0x3FEFD70A,0x3D70A3D7, 0x3FF8A587,0x66F48B9B,
	0x3FEFDF3B,0x645A1CAC, 0x3FF8B35D,0x9208AAA9,
	0x3FEFE76C,0x8B439581, 0x3FF8C13E,0xB13ED714,
	0x3FEFEF9D,0xB22D0E56, 0x3FF8CF2A,0xD371E995,
	0x3FEFF7CE,0xD916872B, 0x3FF8DD22,0x07973BCA,
	0x3FF00000,0x00000000, 0x3FF8EB24,0x5CBEE3A6,
	0x3FF00418,0x9374BC6A, 0x3FF8F931,0xE213EF8D,
	0x3FF00831,0x26E978D5, 0x3FF9074A,0xA6DCA317,
	0x3FF00C49,0xBA5E353F, 0x3FF9156E,0xBA7AB45C,
	0x3FF01062,0x4DD2F1AA, 0x3FF9239E,0x2C6B8A10,
	0x3FF0147A,0xE147AE14, 0x3FF931D9,0x0C487A1C,
	0x3FF01893,0x74BC6A7F, 0x3FF9401F,0x69C70909,
	0x3FF01CAC,0x083126E9, 0x3FF94E71,0x54B929F1,
	0x3FF020C4,0x9BA5E354, 0x3FF95CCE,0xDD0D7F4C,
	0x3FF024DD,0x2F1A9FBE, 0x3FF96B38,0x12CF9C33,
	0x3FF028F5,0xC28F5C29, 0x3FF979AD,0x0628469C,
	0x3FF02D0E,0x56041893, 0x3FF9882D,0xC75DBA05,
	0x3FF03126,0xE978D4FE, 0x3FF996BA,0x66D3EB15,
	0x3FF0353F,0x7CED9168, 0x3FF9A552,0xF50CCBC0,
	0x3FF03958,0x10624DD3, 0x3FF9B3F7,0x82A8905D,
	0x3FF03D70,0xA3D70A3D, 0x3FF9C2A8,0x2065F540,
	0x3FF04189,0x374BC6A8, 0x3FF9D164,0xDF228554,
	0x3FF045A1,0xCAC08312, 0x3FF9E02D,0xCFDAE13D,
	0x3FF049BA,0x5E353F7D, 0x3FF9EF03,0x03AB0771,
	0x3FF04DD2,0xF1A9FBE7, 0x3FF9FDE4,0x8BCE9CF0,
	0x3FF051EB,0x851EB852, 0x3FFA0CD2,0x79A136F0,
	0x3FF05604,0x189374BC, 0x3FFA1BCC,0xDE9EA52B,
	0x3FF05A1C,0xAC083127, 0x3FFA2AD3,0xCC633D2C,
	0x3FF05E35,0x3F7CED91, 0x3FFA39E7,0x54AC263A,
	0x3FF0624D,0xD2F1A9FC, 0x3FFA4907,0x8957A654,
	0x3FF06666,0x66666666, 0x3FFA5834,0x7C656FC7,
	0x3FF06A7E,0xF9DB22D1, 0x3FFA676E,0x3FF6EFDF,
	0x3FF06E97,0x8D4FDF3B, 0x3FFA76B4,0xE64F9E32,
	0x3FF072B0,0x20C49BA6, 0x3FFA8608,0x81D54D12,
	0x3FF076C8,0xB4395810, 0x3FFA9569,0x25107A9E,
	0x3FF07AE1,0x47AE147B, 0x3FFAA4D6,0xE2ACA2FD,
	0x3FF07EF9,0xDB22D0E5, 0x3FFAB451,0xCD78933E,
	0x3FF08312,0x6E978D50, 0x3FFAC3D9,0xF866BD6A,
	0x3FF0872B,0x020C49BA, 0x3FFAD36F,0x768D8D41,
	0x3FF08B43,0x95810625, 0x3FFAE312,0x5B27BE2F,
	0x3FF08F5C,0x28F5C28F, 0x3FFAF2C2,0xB994B1EF,
	0x3FF09374,0xBC6A7EFA, 0x3FFB0280,0xA558C872,
	0x3FF0978D,0x4FDF3B64, 0x3FFB124C,0x321DB876,
	0x3FF09BA5,0xE353F7CF, 0x3FFB2225,0x73B2E96B,
	0x3FF09FBE,0x76C8B439, 0x3FFB320C,0x7E0DCE0C,
	0x3FF0A3D7,0x0A3D70A4, 0x3FFB4201,0x654A404D,
	0x3FF0A7EF,0x9DB22D0E, 0x3FFB5204,0x3DAADE06,
	0x3FF0AC08,0x3126E979, 0x3FFB6215,0x1B9966F8,
	0x3FF0B020,0xC49BA5E3, 0x3FFB7234,0x13A71B98,
	0x3FF0B439,0x5810624E, 0x3FFB8261,0x3A8D1D37,
	0x3FF0B851,0xEB851EB8, 0x3FFB929C,0xA52CCEFB,
	0x3FF0BC6A,0x7EF9DB23, 0x3FFBA2E6,0x68903840,
	0x3FF0C083,0x126E978D, 0x3FFBB33E,0x99EA67C9,
	0x3FF0C49B,0xA5E353F8, 0x3FFBC3A5,0x4E97D862,
	0x3FF0C8B4,0x39581062, 0x3FFBD41A,0x9C1ED667,
	0x3FF0CCCC,0xCCCCCCCD, 0x3FFBE49E,0x982FE6AF,
	0x3FF0D0E5,0x60418937, 0x3FFBF531,0x58A62E72,
	0x3FF0D4FD,0xF3B645A2, 0x3FFC05D2,0xF387DC99,
	0x3FF0D916,0x872B020C, 0x3FFC1683,0x7F069411,
	0x3FF0DD2F,0x1A9FBE77, 0x3FFC2743,0x117FD78D,
	0x3FF0E147,0xAE147AE1, 0x3FFC3811,0xC17D7652,
	0x3FF0E560,0x4189374C, 0x3FFC48EF,0xA5B5FA8A,
	0x3FF0E978,0xD4FDF3B6, 0x3FFC59DC,0xD50D1894,
	0x3FF0ED91,0x6872B021, 0x3FFC6AD9,0x66941FEF,
	0x3FF0F1A9,0xFBE76C8B, 0x3FFC7BE5,0x718A6D2F,
	0x3FF0F5C2,0x8F5C28F6, 0x3FFC8D01,0x0D5DDD90,
	0x3FF0F9DB,0x22D0E560, 0x3FFC9E2C,0x51AB439E,
	0x3FF0FDF3,0xB645A1CB, 0x3FFCAF67,0x563EDD7E,
	0x3FF1020C,0x49BA5E35, 0x3FFCC0B2,0x3314CC67,
	0x3FF10624,0xDD2F1AA0, 0x3FFCD20D,0x00598DB4,
	0x3FF10A3D,0x70A3D70A, 0x3FFCE377,0xD66A7535,
	0x3FF10E56,0x04189375, 0x3FFCF4F2,0xCDD6292B,
	0x3FF1126E,0x978D4FDF, 0x3FFD067D,0xFF5D1F81,
	0x3FF11687,0x2B020C4A, 0x3FFD1819,0x83F21CC6,
	0x3FF11A9F,0xBE76C8B4, 0x3FFD29C5,0x74BAB466,
	0x3FF11EB8,0x51EB851F, 0x3FFD3B81,0xEB0FCAB1,
	0x3FF122D0,0xE5604189, 0x3FFD4D4F,0x007E182F,
	0x3FF126E9,0x78D4FDF4, 0x3FFD5F2C,0xCEC6AEC9,
	0x3FF12B02,0x0C49BA5E, 0x3FFD711B,0x6FDF804E,
	0x3FF12F1A,0x9FBE76C9, 0x3FFD831A,0xFDF3E6DA,
	0x3FF13333,0x33333333, 0x3FFD952B,0x93652E99,
	0x3FF1374B,0xC6A7EF9E, 0x3FFDA74D,0x4ACB2185,
	0x3FF13B64,0x5A1CAC08, 0x3FFDB980,0x3EF49488,
	0x3FF13F7C,0xED916873, 0x3FFDCBC4,0x8AE7F6A5,
	0x3FF14395,0x810624DD, 0x3FFDDE1A,0x49E3E18E,
	0x3FF147AE,0x147AE148, 0x3FFDF081,0x975FAC51,
	0x3FF14BC6,0xA7EF9DB2, 0x3FFE02FA,0x8F0BFF84,
	0x3FF14FDF,0x3B645A1D, 0x3FFE1585,0x4CD36B87,
	0x3FF153F7,0xCED91687, 0x3FFE2821,0xECDB005E,
	0x3FF15810,0x624DD2F2, 0x3FFE3AD0,0x8B82E7B1,
	0x3FF15C28,0xF5C28F5C, 0x3FFE4D91,0x45670063,
	0x3FF16041,0x89374BC7, 0x3FFE6064,0x375F7C69,
	0x3FF1645A,0x1CAC0831, 0x3FFE7349,0x7E818049,
	0x3FF16872,0xB020C49C, 0x3FFE8641,0x381FC4D8,
	0x3FF16C8B,0x43958106, 0x3FFE994B,0x81CB3ABD,
	0x3FF170A3,0xD70A3D71, 0x3FFEAC68,0x7953B03F,
	0x3FF174BC,0x6A7EF9DB, 0x3FFEBF98,0x3CC878DF,
	0x3FF178D4,0xFDF3B646, 0x3FFED2DA,0xEA791759,
	0x3FF17CED,0x916872B0, 0x3FFEE630,0xA0F5E974,
	0x3FF18106,0x24DD2F1B, 0x3FFEF999,0x7F10D655,
	0x3FF1851E,0xB851EB85, 0x3FFF0D15,0xA3DDFEA9,
	0x3FF18937,0x4BC6A7F0, 0x3FFF20A5,0x2EB46F5F,
	0x3FF18D4F,0xDF3B645A, 0x3FFF3448,0x3F2ED658,
	0x3FF19168,0x72B020C5, 0x3FFF47FE,0xF52C39AB,
	0x3FF19581,0x0624DD2F, 0x3FFF5BC9,0x70D0B0F5,
	0x3FF19999,0x9999999A, 0x3FFF6FA7,0xD286214E,
	0x3FF19DB2,0x2D0E5604, 0x3FFF839A,0x3AFCFB5D,
	0x3FF1A1CA,0xC083126F, 0x3FFF97A0,0xCB2CFC21,
	0x3FF1A5E3,0x53F7CED9, 0x3FFFABBB,0xA455EFEE,
	0x3FF1A9FB,0xE76C8B44, 0x3FFFBFEA,0xE800782E,
	0x3FF1AE14,0x7AE147AE, 0x3FFFD42E,0xB7FED370,
	0x3FF1B22D,0x0E560419, 0x3FFFE887,0x366DA849,
	0x3FF1B645,0xA1CAC083, 0x3FFFFCF4,0x85B4D293,
	0x3FF1BA5E,0x353F7CEE, 0x400008BB,0x644419CE,
	0x3FF1BE76,0xC8B43958, 0x40001307,0x10F44261,
	0x3FF1C28F,0x5C28F5C3, 0x40001D5D,0x5A92168C,
	0x3FF1C6A7,0xEF9DB22D, 0x400027BE,0x52EC0CBF,
	0x3FF1CAC0,0x83126E98, 0x4000322A,0x0BF84BF6,
	0x3FF1CED9,0x16872B02, 0x40003CA0,0x97D51AA2,
	0x3FF1D2F1,0xA9FBE76D, 0x40004722,0x08C94F2B,
	0x3FF1D70A,0x3D70A3D7, 0x400051AE,0x7144C1CC,
	0x3FF1DB22,0xD0E56042, 0x40005C45,0xE3E0C018,
	0x3FF1DF3B,0x645A1CAC, 0x400066E8,0x736081D4,
	0x3FF1E353,0xF7CED917, 0x40007196,0x32B19F91,
	0x3FF1E76C,0x8B439581, 0x40007C4F,0x34EC8AA9,
	0x3FF1EB85,0x1EB851EC, 0x40008713,0x8D550704,
	0x3FF1EF9D,0xB22D0E56, 0x400091E3,0x4F5AA64E,
	0x3FF1F3B6,0x45A1CAC1, 0x40009CBE,0x8E9944FF,
	0x3FF1F7CE,0xD916872B, 0x4000A7A5,0x5ED988E5,
	0x3FF1FBE7,0x6C8B4396, 0x4000B297,0xD411618C,
	0x3FF20000,0x00000000, 0x4000BD96,0x02648A36,
	0x3FF20418,0x9374BC6A, 0x4000C89F,0xFE250DBC,
	0x3FF20831,0x26E978D5, 0x4000D3B5,0xDBD3CC1A,
	0x3FF20C49,0xBA5E353F, 0x4000DED7,0xB02101CD,
	0x3FF21062,0x4DD2F1AA, 0x4000EA05,0x8FECD124,
	0x3FF2147A,0xE147AE14, 0x4000F53F,0x9047CD42,
	0x3FF21893,0x74BC6A7F, 0x40010085,0xC6738737,
	0x3FF21CAC,0x083126E9, 0x40010BD8,0x47E31CD3,
	0x3FF220C4,0x9BA5E354, 0x40011737,0x2A3BC9A4,
	0x3FF224DD,0x2F1A9FBE, 0x400122A2,0x835579BD,
	0x3FF228F5,0xC28F5C29, 0x40012E1A,0x693B5EB6,
	0x3FF22D0E,0x56041893, 0x4001399E,0xF22C8685,
	0x3FF23126,0xE978D4FE, 0x40014530,0x349C74A5,
	0x3FF2353F,0x7CED9168, 0x400150CE,0x4733BD25,
	0x3FF23958,0x10624DD3, 0x40015C79,0x40D0A212,
	0x3FF23D70,0xA3D70A3D, 0x40016831,0x3887B2E3,
	0x3FF24189,0x374BC6A8, 0x400173F6,0x45A46E4E,
	0x3FF245A1,0xCAC08312, 0x40017FC8,0x7FA9E62D,
	0x3FF249BA,0x5E353F7D, 0x40018BA7,0xFE5365E8,
	0x3FF24DD2,0xF1A9FBE7, 0x40019794,0xD9951AFD,
	0x3FF251EB,0x851EB852, 0x4001A38F,0x299CC01A,
	0x3FF25604,0x189374BC, 0x4001AF97,0x06D24A7A,
	0x3FF25A1C,0xAC083127, 0x4001BBAC,0x89D899D9,
	0x3FF25E35,0x3F7CED91, 0x4001C7CF,0xCB8E2AC1,
	0x3FF2624D,0xD2F1A9FC, 0x4001D400,0xE50DCB8B,
	0x3FF26666,0x66666666, 0x4001E03F,0xEFAF53C9,
	0x3FF26A7E,0xF9DB22D1, 0x4001EC8D,0x05085E7D,
	0x3FF26E97,0x8D4FDF3B, 0x4001F8E8,0x3EED06C9,
	0x3FF272B0,0x20C49BA6, 0x40020551,0xB770A787,
	0x3FF276C8,0xB4395810, 0x400211C9,0x88E69D73,
	0x3FF27AE1,0x47AE147B, 0x40021E4F,0xCDE30C53,
	0x3FF27EF9,0xDB22D0E5, 0x40022AE4,0xA13BA6C4,
	0x3FF28312,0x6E978D50, 0x40023788,0x1E087927,
	0x3FF2872B,0x020C49BA, 0x4002443A,0x5FA4B744,
	0x3FF28B43,0x95810625, 0x400250FB,0x81AF8D26,
	0x3FF28F5C,0x28F5C28F, 0x40025DCB,0xA00CF2D0,
	0x3FF29374,0xBC6A7EFA, 0x40026AAA,0xD6E6833D,
	0x3FF2978D,0x4FDF3B64, 0x40027799,0x42AC5654,
	0x3FF29BA5,0xE353F7CF, 0x40028497,0x0015DE48,
	0x3FF29FBE,0x76C8B439, 0x400291A4,0x2C22C803,
	0x3FF2A3D7,0x0A3D70A4, 0x40029EC0,0xE41BDF1C,
	0x3FF2A7EF,0x9DB22D0E, 0x4002ABED,0x4593F4F3,
	0x3FF2AC08,0x3126E979, 0x4002B929,0x6E68CB7A,
	0x3FF2B020,0xC49BA5E3, 0x4002C675,0x7CC4033E,
	0x3FF2B439,0x5810624E, 0x4002D3D1,0x8F1C0D3A,
	0x3FF2B851,0xEB851EB8, 0x4002E13D,0xC4352012,
	0x3FF2BC6A,0x7EF9DB23, 0x4002EEBA,0x3B223132,
	0x3FF2C083,0x126E978D, 0x4002FC47,0x1345F173,
	0x3FF2C49B,0xA5E353F8, 0x400309E4,0x6C53CDC9,
	0x3FF2C8B4,0x39581062, 0x40031792,0x6650F39F,
	0x3FF2CCCC,0xCCCCCCCD, 0x40032551,0x21955956,
	0x3FF2D0E5,0x60418937, 0x40033320,0xBECCCA94,
	0x3FF2D4FD,0xF3B645A2, 0x40034101,0x5EF7F8E5,
	0x3FF2D916,0x872B020C, 0x40034EF3,0x236D9048,
	0x3FF2DD2F,0x1A9FBE77, 0x40035CF6,0x2DDB5033,
	0x3FF2E147,0xAE147AE1, 0x40036B0A,0xA04728B4,
	0x3FF2E560,0x4189374C, 0x40037930,0x9D105C24,
	0x3FF2E978,0xD4FDF3B6, 0x40038768,0x46F0A521,
	0x3FF2ED91,0x6872B021, 0x400395B1,0xC0FD614D,
	0x3FF2F1A9,0xFBE76C8B, 0x4003A40D,0x2EA8C076,
	0x3FF2F5C2,0x8F5C28F6, 0x4003B27A,0xB3C2F8A9,
	0x3FF2F9DB,0x22D0E560, 0x4003C0FA,0x747B7EDE,
	0x3FF2FDF3,0xB645A1CB, 0x4003CF8C,0x956244C4,
	0x3FF3020C,0x49BA5E35, 0x4003DE31,0x3B68FB49,
	0x3FF30624,0xDD2F1AA0, 0x4003ECE8,0x8BE45A6D,
	0x3FF30A3D,0x70A3D70A, 0x4003FBB2,0xAC8D6E08,
	0x3FF30E56,0x04189375, 0x40040A8F,0xC382E810,
	0x3FF3126E,0x978D4FDF, 0x4004197F,0xF74A77F5,
	0x3FF31687,0x2B020C4A, 0x40042883,0x6ED227B6,
	0x3FF31A9F,0xBE76C8B4, 0x4004379A,0x5171BE48,
	0x3FF31EB8,0x51EB851F, 0x400446C4,0xC6EC27DB,
	0x3FF322D0,0xE5604189, 0x40045602,0xF770E3B0,
	0x3FF326E9,0x78D4FDF4, 0x40046555,0x0B9D7803,
	0x3FF32B02,0x0C49BA5E, 0x400474BB,0x2C7EEBBB,
	0x3FF32F1A,0x9FBE76C9, 0x40048435,0x8393466A,
	0x3FF33333,0x33333333, 0x400493C4,0x3ACB164D,
	0x3FF3374B,0xC6A7EF9E, 0x4004A367,0x7C8AFCD3,
	0x3FF33B64,0x5A1CAC08, 0x4004B31F,0x73AD4166,
	0x3FF33F7C,0xED916873, 0x4004C2EC,0x4B836AFA,
	0x3FF34395,0x810624DD, 0x4004D2CE,0x2FD7E01A,
	0x3FF347AE,0x147AE148, 0x4004E2C5,0x4CEF8DFA,
	0x3FF34BC6,0xA7EF9DB2, 0x4004F2D1,0xCF8B964F,
	0x3FF34FDF,0x3B645A1D, 0x400502F3,0xE4EB046D,
	0x3FF353F7,0xCED91687, 0x4005132B,0xBACC8971,
	0x3FF35810,0x624DD2F2, 0x40052379,0x7F703FF9,
	0x3FF35C28,0xF5C28F5C, 0x400533DD,0x61997726,
	0x3FF36041,0x89374BC7, 0x40054457,0x9090858A,
	0x3FF3645A,0x1CAC0831, 0x400554E8,0x3C24A39D,
	0x3FF36872,0xB020C49C, 0x4005658F,0x94ADCE68,
	0x3FF36C8B,0x43958106, 0x4005764D,0xCB0EB214,
	0x3FF370A3,0xD70A3D71, 0x40058723,0x10B69CF9,
	0x3FF374BC,0x6A7EF9DB, 0x4005980F,0x97A37ADE,
	0x3FF378D4,0xFDF3B646, 0x4005A913,0x9263D914,
	0x3FF37CED,0x916872B0, 0x4005BA2F,0x3418F31D,
	0x3FF38106,0x24DD2F1B, 0x4005CB62,0xB078C87A,
	0x3FF3851E,0xB851EB85, 0x4005DCAE,0x3BD03B67,
	0x3FF38937,0x4BC6A7F0, 0x4005EE12,0x0B053920,
	0x3FF38D4F,0xDF3B645A, 0x4005FF8E,0x5398EB60,
	0x3FF39168,0x72B020C5, 0x40061123,0x4BA9F3E2,
	0x3FF39581,0x0624DD2F, 0x400622D1,0x29F6B16E,
	0x3FF39999,0x9999999A, 0x40063498,0x25DF8F4F,
	0x3FF39DB2,0x2D0E5604, 0x40064678,0x77695EC4,
	0x3FF3A1CA,0xC083126F, 0x40065872,0x573FBB41,
	0x3FF3A5E3,0x53F7CED9, 0x40066A85,0xFEB77915,
	0x3FF3A9FB,0xE76C8B44, 0x40067CB3,0xA7D11F49,
	0x3FF3AE14,0x7AE147AE, 0x40068EFB,0x8D3B6C6B,
	0x3FF3B22D,0x0E560419, 0x4006A15D,0xEA55E6F0,
	0x3FF3B645,0xA1CAC083, 0x4006B3DA,0xFB337900,
	0x3FF3BA5E,0x353F7CEE, 0x4006C672,0xFC9D1859,
	0x3FF3BE76,0xC8B43958, 0x4006D926,0x2C147A13,
	0x3FF3C28F,0x5C28F5C3, 0x4006EBF4,0xC7D6D2FC,
	0x3FF3C6A7,0xEF9DB22D, 0x4006FEDF,0x0EDFA455,
	0x3FF3CAC0,0x83126E98, 0x400711E5,0x40EB95B4,
	0x3FF3CED9,0x16872B02, 0x40072507,0x9E7B5BC7,
	0x3FF3D2F1,0xA9FBE76D, 0x40073846,0x68D6ACD2,
	0x3FF3D70A,0x3D70A3D7, 0x40074BA1,0xE20F4298,
	0x3FF3DB22,0xD0E56042, 0x40075F1A,0x4D03EA90,
	0x3FF3DF3B,0x645A1CAC, 0x400772AF,0xED63A422,
	0x3FF3E353,0xF7CED917, 0x40078663,0x07B0CDC9,
	0x3FF3E76C,0x8B439581, 0x40079A33,0xE14460D8,
	0x3FF3EB85,0x1EB851EC, 0x4007AE22,0xC0513CC9,
	0x3FF3EF9D,0xB22D0E56, 0x4007C22F,0xEBE781D4,
	0x3FF3F3B6,0x45A1CAC1, 0x4007D65B,0xABF7FBBF,
	0x3FF3F7CE,0xD916872B, 0x4007EAA6,0x49579C9B,
	0x3FF3FBE7,0x6C8B4396, 0x4007FF10,0x0DC30874,
	0x3FF40000,0x00000000, 0x40081399,0x43E231A8,
	0x3FF40418,0x9374BC6A, 0x40082842,0x374C06DE,
	0x3FF40831,0x26E978D5, 0x40083D0B,0x348A3289,
	0x3FF40C49,0xBA5E353F, 0x400851F4,0x891CEC8B,
	0x3FF41062,0x4DD2F1AA, 0x400866FE,0x837EDE83,
	0x3FF4147A,0xE147AE14, 0x40087C29,0x73291ACF,
	0x3FF41893,0x74BC6A7F, 0x40089175,0xA8972725,
	0x3FF41CAC,0x083126E9, 0x4008A6E3,0x754B1AB1,
	0x3FF420C4,0x9BA5E354, 0x4008BC73,0x2BD1D0B6,
	0x3FF424DD,0x2F1A9FBE, 0x4008D225,0x1FC72F8A,
	0x3FF428F5,0xC28F5C29, 0x4008E7F9,0xA5DA8510,
	0x3FF42D0E,0x56041893, 0x4008FDF1,0x13D2F873,
	0x3FF43126,0xE978D4FE, 0x4009140B,0xC094125B,
	0x3FF4353F,0x7CED9168, 0x40092A4A,0x04225B61,
	0x3FF43958,0x10624DD3, 0x400940AC,0x37A81204,
	0x3FF43D70,0xA3D70A3D, 0x40095732,0xB579F7E5,
	0x3FF44189,0x374BC6A8, 0x40096DDD,0xD91C3795,
	0x3FF445A1,0xCAC08312, 0x400984AD,0xFF4762CE,
	0x3FF449BA,0x5E353F7D, 0x40099BA3,0x85ED8A53,
	0x3FF44DD2,0xF1A9FBE7, 0x4009B2BE,0xCC3F6F68,
	0x3FF451EB,0x851EB852, 0x4009CA00,0x32B1D025,
	0x3FF45604,0x189374BC, 0x4009E168,0x1B02CE9D,
	0x3FF45A1C,0xAC083127, 0x4009F8F6,0xE83F7414,
	0x3FF45E35,0x3F7CED91, 0x400A10AC,0xFEC9505D,
	0x3FF4624D,0xD2F1A9FC, 0x400A288A,0xC45C369E,
	0x3FF46666,0x66666666, 0x400A4090,0xA0141789,
	0x3FF46A7E,0xF9DB22D1, 0x400A58BE,0xFA72FA71,
	0x3FF46E97,0x8D4FDF3B, 0x400A7116,0x3D671537,
	0x3FF472B0,0x20C49BA6, 0x400A8996,0xD4510492,
	0x3FF476C8,0xB4395810, 0x400AA241,0x2C0A24B2,
	0x3FF47AE1,0x47AE147B, 0x400ABB15,0xB2EB0BC6,
	0x3FF47EF9,0xDB22D0E5, 0x400AD414,0xD8D22683,
	0x3FF48312,0x6E978D50, 0x400AED3F,0x0F2A7825,
	0x3FF4872B,0x020C49BA, 0x400B0694,0xC8F27E26,
	0x3FF48B43,0x95810625, 0x400B2016,0x7AC33932,
	0x3FF48F5C,0x28F5C28F, 0x400B39C4,0x9AD75B88,
	0x3FF49374,0xBC6A7EFA, 0x400B539F,0xA1129E82,
	0x3FF4978D,0x4FDF3B64, 0x400B6DA8,0x07093F60,
	0x3FF49BA5,0xE353F7CF, 0x400B87DE,0x4807A52B,
	0x3FF49FBE,0x76C8B439, 0x400BA242,0xE11A2FDA,
	0x3FF4A3D7,0x0A3D70A4, 0x400BBCD6,0x511532A0,
	0x3FF4A7EF,0x9DB22D0E, 0x400BD799,0x189D1996,
	0x3FF4AC08,0x3126E979, 0x400BF28B,0xBA2EBCAE,
	0x3FF4B020,0xC49BA5E3, 0x400C0DAE,0xBA27E04F,
	0x3FF4B439,0x5810624E, 0x400C2902,0x9ECFE57D,
	0x3FF4B851,0xEB851EB8, 0x400C4487,0xF060AA00,
	0x3FF4BC6A,0x7EF9DB23, 0x400C603F,0x390F9A90,
	0x3FF4C083,0x126E978D, 0x400C7C29,0x0516F77B,
	0x3FF4C49B,0xA5E353F8, 0x400C9845,0xE2BF4DE6,
	0x3FF4C8B4,0x39581062, 0x400CB496,0x62692628,
	0x3FF4CCCC,0xCCCCCCCD, 0x400CD11B,0x1696E97E,
	0x3FF4D0E5,0x60418937, 0x400CEDD4,0x93F6FFAE,
	0x3FF4D4FD,0xF3B645A2, 0x400D0AC3,0x716E26E0,
	0x3FF4D916,0x872B020C, 0x400D27E8,0x4822065B,
	0x3FF4DD2F,0x1A9FBE77, 0x400D4543,0xB383FE9C,
	0x3FF4E147,0xAE147AE1, 0x400D62D6,0x515C3767,
	0x3FF4E560,0x4189374C, 0x400D80A0,0xC1D4EE7D,
	0x3FF4E978,0xD4FDF3B6, 0x400D9EA3,0xA78607A6,
	0x3FF4ED91,0x6872B021, 0x400DBCDF,0xA780E0CC,
	0x3FF4F1A9,0xFBE76C8B, 0x400DDB55,0x695C6B08,
	0x3FF4F5C2,0x8F5C28F6, 0x400DFA05,0x97418B64,
	0x3FF4F9DB,0x22D0E560, 0x400E18F0,0xDDF7C44F,
	0x3FF4FDF3,0xB645A1CB, 0x400E3817,0xECF22ABC,
	0x3FF5020C,0x49BA5E35, 0x400E577B,0x765CA7F1,
	0x3FF50624,0xDD2F1AA0, 0x400E771C,0x2F298B1D,
	0x3FF50A3D,0x70A3D70A, 0x400E96FA,0xCF1F6BF5,
	0x3FF50E56,0x04189375, 0x400EB718,0x10E7617A,
	0x3FF5126E,0x978D4FDF, 0x400ED774,0xB21B8E48,
	0x3FF51687,0x2B020C4A, 0x400EF811,0x735605CC,
	0x3FF51A9F,0xBE76C8B4, 0x400F18EF,0x18400BD9,
	0x3FF51EB8,0x51EB851F, 0x400F3A0E,0x67A1B218,
	0x3FF522D0,0xE5604189, 0x400F5B70,0x2B71D507,
	0x3FF526E9,0x78D4FDF4, 0x400F7D15,0x30E67C26,
	0x3FF52B02,0x0C49BA5E, 0x400F9EFE,0x48859F26,
	0x3FF52F1A,0x9FBE76C9, 0x400FC12C,0x463653FE,
	0x3FF53333,0x33333333, 0x400FE3A0,0x015267D0,
	0x3FF5374B,0xC6A7EF9E, 0x4010032D,0x2A5C3365,
	0x3FF53B64,0x5A1CAC08, 0x401014AE,0x0F6F0A85,
	0x3FF53F7C,0xED916873, 0x40102653,0x20F1AE7C,
	0x3FF54395,0x810624DD, 0x4010381C,0xD1D2DAA4,
	0x3FF547AE,0x147AE148, 0x40104A0B,0x96EA01A9,
	0x3FF54BC6,0xA7EF9DB2, 0x40105C1F,0xE7017E18,
	0x3FF54FDF,0x3B645A1D, 0x40106E5A,0x3AE104C6,
	0x3FF553F7,0xCED91687, 0x401080BB,0x0D585A62,
	0x3FF55810,0x624DD2F2, 0x40109342,0xDB4A4ED0,
	0x3FF55C28,0xF5C28F5C, 0x4010A5F2,0x23B7FFC0,
	0x3FF56041,0x89374BC7, 0x4010B8C9,0x67CC6532,
	0x3FF5645A,0x1CAC0831, 0x4010CBC9,0x2AE8299D,
	0x3FF56872,0xB020C49C, 0x4010DEF1,0xF2ADD07B,
	0x3FF56C8B,0x43958106, 0x4010F244,0x470E2D14,
	0x3FF570A3,0xD70A3D71, 0x401105C0,0xB2552C86,
	0x3FF574BC,0x6A7EF9DB, 0x40111967,0xC136F4FD,
	0x3FF578D4,0xFDF3B646, 0x40112D3A,0x02DD5D51,
	0x3FF57CED,0x916872B0, 0x40114138,0x08F5BF25,
	0x3FF58106,0x24DD2F1B, 0x40115562,0x67BF26EC,
	0x3FF5851E,0xB851EB85, 0x401169B9,0xB618E425,
	0x3FF58937,0x4BC6A7F0, 0x40117E3E,0x8D917D68,
	0x3FF58D4F,0xDF3B645A, 0x401192F1,0x8A760AC4,
	0x3FF59168,0x72B020C5, 0x4011A7D3,0x4BE1FA47,
	0x3FF59581,0x0624DD2F, 0x4011BCE4,0x73CF4167,
	0x3FF59999,0x9999999A, 0x4011D225,0xA726FF61,
	0x3FF59DB2,0x2D0E5604, 0x4011E797,0x8DD29388,
	0x3FF5A1CA,0xC083126F, 0x4011FD3A,0xD2CD2BD7,
	0x3FF5A5E3,0x53F7CED9, 0x40121310,0x2435CF05,
	0x3FF5A9FB,0xE76C8B44, 0x40122918,0x3361E6B9,
	0x3FF5AE14,0x7AE147AE, 0x40123F53,0xB4F04D66,
	0x3FF5B22D,0x0E560419, 0x401255C3,0x60DCE4B2,
	0x3FF5B645,0xA1CAC083, 0x40126C67,0xF294B850,
	0x3FF5BA5E,0x353F7CEE, 0x40128342,0x290AB27C,
	0x3FF5BE76,0xC8B43958, 0x40129A52,0xC6CCE64E,
	0x3FF5C28F,0x5C28F5C3, 0x4012B19A,0x921A7586,
	0x3FF5C6A7,0xEF9DB22D, 0x4012C91A,0x54FA1658,
	0x3FF5CAC0,0x83126E98, 0x4012E0D2,0xDD513F32,
	0x3FF5CED9,0x16872B02, 0x4012F8C4,0xFCFBFD80,
	0x3FF5D2F1,0xA9FBE76D, 0x401310F1,0x89E57DD2,
	0x3FF5D70A,0x3D70A3D7, 0x40132959,0x5E214ABF,
	0x3FF5DB22,0xD0E56042, 0x401341FD,0x58054982,
	0x3FF5DF3B,0x645A1CAC, 0x40135ADE,0x5A447A11,
	0x3FF5E353,0xF7CED917, 0x401373FD,0x4C0A8235,
	0x3FF5E76C,0x8B439581, 0x40138D5B,0x191809DE,
	0x3FF5EB85,0x1EB851EC, 0x4013A6F8,0xB1DFF0D6,
	0x3FF5EF9D,0xB22D0E56, 0x4013C0D7,0x0BA5649C,
	0x3FF5F3B6,0x45A1CAC1, 0x4013DAF7,0x209ADF11,
	0x3FF5F7CE,0xD916872B, 0x4013F559,0xF002157C,
	0x3FF5FBE7,0x6C8B4396, 0x40141000,0x7E4CE12E,
	0x3FF60000,0x00000000, 0x40142AEB,0xD53F29E4,
	0x3FF60418,0x9374BC6A, 0x4014461D,0x0411DBFE,
	0x3FF60831,0x26E978D5, 0x40146195,0x1F96F391,
	0x3FF60C49,0xBA5E353F, 0x40147D55,0x425EA69B,
	0x3FF61062,0x4DD2F1AA, 0x4014995E,0x8CDDB91C,
	0x3FF6147A,0xE147AE14, 0x4014B5B2,0x2595055E,
	0x3FF61893,0x74BC6A7F, 0x4014D251,0x393A4498,
	0x3FF61CAC,0x083126E9, 0x4014EF3C,0xFAE222ED,
	0x3FF620C4,0x9BA5E354, 0x40150C76,0xA42BAC08,
	0x3FF624DD,0x2F1A9FBE, 0x401529FF,0x756D1C53,
	0x3FF628F5,0xC28F5C29, 0x401547D8,0xB5E22530,
	0x3FF62D0E,0x56041893, 0x40156603,0xB3DBB13B,
	0x3FF63126,0xE978D4FE, 0x40158481,0xC4F13842,
	0x3FF6353F,0x7CED9168, 0x4015A354,0x4633B13C,
	0x3FF63958,0x10624DD3, 0x4015C27C,0x9C62332A,
	0x3FF63D70,0xA3D70A3D, 0x4015E1FC,0x3420549C,
	0x3FF64189,0x374BC6A8, 0x401601D4,0x822E5C34,
	0x3FF645A1,0xCAC08312, 0x40162207,0x03A35366,
	0x3FF649BA,0x5E353F7D, 0x40164295,0x3E290F61,
	0x3FF64DD2,0xF1A9FBE7, 0x40166380,0xC03A4314,
	0x3FF651EB,0x851EB852, 0x401684CB,0x2162B00A,
	0x3FF65604,0x189374BC, 0x4016A676,0x02818ACE,
	0x3FF65A1C,0xAC083127, 0x4016C883,0x0E0E2A9E,
	0x3FF65E35,0x3F7CED91, 0x4016EAF3,0xF85F1B27,
	0x3FF6624D,0xD2F1A9FC, 0x40170DCA,0x7FF3AA2E,
	0x3FF66666,0x66666666, 0x40173108,0x6DC00A35,
	0x3FF66A7E,0xF9DB22D1, 0x401754AF,0x957C2654,
	0x3FF66E97,0x8D4FDF3B, 0x401778C1,0xD5F542E9,
	0x3FF672B0,0x20C49BA6, 0x40179D41,0x196289FF,
	0x3FF676C8,0xB4395810, 0x4017C22F,0x55BCA1C1,
	0x3FF67AE1,0x47AE147B, 0x4017E78E,0x8D186EF6,
	0x3FF67EF9,0xDB22D0E5, 0x40180D60,0xCE0524CC,
	0x3FF68312,0x6E978D50, 0x401833A8,0x33EDC75A,
	0x3FF6872B,0x020C49BA, 0x40185A66,0xE77E457D,
	0x3FF68B43,0x95810625, 0x4018819F,0x1F0C5326,
	0x3FF68F5C,0x28F5C28F, 0x4018A953,0x1F042CA2,
	0x3FF69374,0xBC6A7EFA, 0x4018D185,0x3A596FF2,
	0x3FF6978D,0x4FDF3B64, 0x4018FA37,0xD2FC391A,
	0x3FF69BA5,0xE353F7CF, 0x4019236D,0x5A52B2FB,
	0x3FF69FBE,0x76C8B439, 0x40194D28,0x51B74E7B,
	0x3FF6A3D7,0x0A3D70A4, 0x4019776B,0x4AFBD6A0,
	0x3FF6A7EF,0x9DB22D0E, 0x4019A238,0xE8F198B5,
	0x3FF6AC08,0x3126E979, 0x4019CD93,0xDFF6DCE6,
	0x3FF6B020,0xC49BA5E3, 0x4019F97E,0xF689EC5D,
	0x3FF6B439,0x5810624E, 0x401A25FD,0x05E1E7BF,
	0x3FF6B851,0xEB851EB8, 0x401A5310,0xFA8DB1C8,
	0x3FF6BC6A,0x7EF9DB23, 0x401A80BD,0xD5193815,
	0x3FF6C083,0x126E978D, 0x401AAF06,0xAAB96578,
	0x3FF6C49B,0xA5E353F8, 0x401ADDEE,0xA5FF0FFB,
	0x3FF6C8B4,0x39581062, 0x401B0D79,0x07913660,
	0x3FF6CCCC,0xCCCCCCCD, 0x401B3DA9,0x26EEE877,
	0x3FF6D0E5,0x60418937, 0x401B6E82,0x733937B1,
	0x3FF6D4FD,0xF3B645A2, 0x401BA008,0x74059580,
	0x3FF6D916,0x872B020C, 0x401BD23E,0xCA3907D4,
	0x3FF6DD2F,0x1A9FBE77, 0x401C0529,0x30ECA4DD,
	0x3FF6E147,0xAE147AE1, 0x401C38CB,0x7E5BCAA8,
	0x3FF6E560,0x4189374C, 0x401C6D29,0xA4DC90E3,
	0x3FF6E978,0xD4FDF3B6, 0x401CA247,0xB3E2F74E,
	0x3FF6ED91,0x6872B021, 0x401CD829,0xD90F5DFE,
	0x3FF6F1A9,0xFBE76C8B, 0x401D0ED4,0x6148D9C4,
	0x3FF6F5C2,0x8F5C28F6, 0x401D464B,0xB9E402E1,
	0x3FF6F9DB,0x22D0E560, 0x401D7E94,0x71D6E229,
	0x3FF6FDF3,0xB645A1CB, 0x401DB7B3,0x3AFAAE13,
	0x3FF7020C,0x49BA5E35, 0x401DF1AC,0xEB5C1051,
	0x3FF70624,0xDD2F1AA0, 0x401E2C86,0x7E9ABB51,
	0x3FF70A3D,0x70A3D70A, 0x401E6845,0x17591FAE,
	0x3FF70E56,0x04189375, 0x401EA4EE,0x00BD21EC,
	0x3FF7126E,0x978D4FDF, 0x401EE286,0xB002BB55,
	0x3FF71687,0x2B020C4A, 0x401F2114,0xC62182EE,
	0x3FF71A9F,0xBE76C8B4, 0x401F609E,0x118627FD,
	0x3FF71EB8,0x51EB851F, 0x401FA128,0x8FE0FC01,
	0x3FF722D0,0xE5604189, 0x401FE2BA,0x700AB8B3,
	0x3FF726E9,0x78D4FDF4, 0x402012AD,0x0A0062E4,
	0x3FF72B02,0x0C49BA5E, 0x40203487,0x097D29BD,
	0x3FF72F1A,0x9FBE76C9, 0x402056EE,0x9DCBDC90,
	0x3FF73333,0x33333333, 0x402079E7,0x4B16CDC3,
	0x3FF7374B,0xC6A7EF9E, 0x40209D74,0xB396BE46,
	0x3FF73B64,0x5A1CAC08, 0x4020C19A,0x98D6B6DE,
	0x3FF73F7C,0xED916873, 0x4020E65C,0xDD0860BB,
	0x3FF74395,0x810624DD, 0x40210BBF,0x8469D982,
	0x3FF747AE,0x147AE148, 0x402131C6,0xB6BE124A,
	0x3FF74BC6,0xA7EF9DB2, 0x40215876,0xC0D8DA07,
	0x3FF74FDF,0x3B645A1D, 0x40217FD4,0x163FCA28,
	0x3FF753F7,0xCED91687, 0x4021A7E3,0x52E16021,
	0x3FF75810,0x624DD2F2, 0x4021D0A9,0x3CE3A865,
	0x3FF75C28,0xF5C28F5C, 0x4021FA2A,0xC68BF6EF,
	0x3FF76041,0x89374BC7, 0x4022246D,0x10414757,
	0x3FF7645A,0x1CAC0831, 0x40224F75,0x6AAAFA55,
	0x3FF76872,0xB020C49C, 0x40227B49,0x58EDC96E,
	0x3FF76C8B,0x43958106, 0x4022A7EE,0x9308EA7D,
	0x3FF770A3,0xD70A3D71, 0x4022D56B,0x08558594,
	0x3FF774BC,0x6A7EF9DB, 0x402303C4,0xE22AC6C2,
	0x3FF778D4,0xFDF3B646, 0x40233302,0x86A90528,
	0x3FF77CED,0x916872B0, 0x4023632A,0x9BAEA747,
	0x3FF78106,0x24DD2F1B, 0x40239444,0x09F9A4BE,
	0x3FF7851E,0xB851EB85, 0x4023C656,0x0078BD2B,
	0x3FF78937,0x4BC6A7F0, 0x4023F967,0xF7CFBE5B,
	0x3FF78D4F,0xDF3B645A, 0x40242D81,0xB6127661,
	0x3FF79168,0x72B020C5, 0x402462AB,0x52BA3CFC,
	0x3FF79581,0x0624DD2F, 0x402498ED,0x3ADA4F51,
	0x3FF79999,0x9999999A, 0x4024D050,0x359796D5,
	0x3FF79DB2,0x2D0E5604, 0x402508DD,0x68E8D431,
	0x3FF7A1CA,0xC083126F, 0x4025429E,0x5EA496D3,
	0x3FF7A5E3,0x53F7CED9, 0x40257D9D,0x09E2DDE0,
	0x3FF7A9FB,0xE76C8B44, 0x4025B9E3,0xCCB8C57B,
	0x3FF7AE14,0x7AE147AE, 0x4025F77D,0x7E552FCC,
	0x3FF7B22D,0x0E560419, 0x40263675,0x7185FB0F,
	0x3FF7B645,0xA1CAC083, 0x402676D7,0x7BAE00BA,
	0x3FF7BA5E,0x353F7CEE, 0x4026B8AF,0xFC34DDB8,
	0x3FF7BE76,0xC8B43958, 0x4026FC0B,0xE47A5416,
	0x3FF7C28F,0x5C28F5C3, 0x402740F8,0xC05804E9,
	0x3FF7C6A7,0xEF9DB22D, 0x40278784,0xBF3D406E,
	0x3FF7CAC0,0x83126E98, 0x4027CFBE,0xBDF1CDC7,
	0x3FF7CED9,0x16872B02, 0x402819B6,0x510DC5D5,
	0x3FF7D2F1,0xA9FBE76D, 0x4028657B,0xD0360274,
	0x3FF7D70A,0x3D70A3D7, 0x4028B320,0x622E27CE,
	0x3FF7DB22,0xD0E56042, 0x402902B6,0x09D306F7,
	0x3FF7DF3B,0x645A1CAC, 0x4029544F,0xB411FB8E,
	0x3FF7E353,0xF7CED917, 0x4029A801,0x46F40A2C,
	0x3FF7E76C,0x8B439581, 0x4029FDDF,0xB1D5DF96,
	0x3FF7EB85,0x1EB851EC, 0x402A5600,0xFEE87CC2,
	0x3FF7EF9D,0xB22D0E56, 0x402AB07C,0x66194F9A,
	0x3FF7F3B6,0x45A1CAC1, 0x402B0D6A,0x6183D30F,
	0x3FF7F7CE,0xD916872B, 0x402B6CE4,0xC3928B1A,
	0x3FF7FBE7,0x6C8B4396, 0x402BCF06,0xCEF96E07,
	0x3FF80000,0x00000000, 0x402C33ED,0x50B88777,
	0x3FF80418,0x9374BC6A, 0x402C9BB6,0xBC5B04B9,
	0x3FF80831,0x26E978D5, 0x402D0683,0x4AACE61B,
	0x3FF80C49,0xBA5E353F, 0x402D7475,0x1B28737E,
	0x3FF81062,0x4DD2F1AA, 0x402DE5B0,0x58645F01,
	0x3FF8147A,0xE147AE14, 0x402E5A5B,0x5FD45A8A,
	0x3FF81893,0x74BC6A7F, 0x402ED29E,0xED38037E,
	0x3FF81CAC,0x083126E9, 0x402F4EA6,0x4A1F86AC,
	0x3FF820C4,0x9BA5E354, 0x402FCE9F,0x81FA9192,
	0x3FF824DD,0x2F1A9FBE, 0x4030295D,0xCD9A9B13,
	0x3FF828F5,0xC28F5C29, 0x40306D97,0x6AFBE05E,
	0x3FF82D0E,0x56041893, 0x4030B418,0x7899336B,
	0x3FF83126,0xE978D4FE, 0x4030FCFE,0xBB5A5C79,
	0x3FF8353F,0x7CED9168, 0x4031486A,0x0795A4CD,
	0x3FF83958,0x10624DD3, 0x4031967C,0x6F7E64B2,
	0x3FF83D70,0xA3D70A3D, 0x4031E75A,0x7691C5A3,
	0x3FF84189,0x374BC6A8, 0x40323B2B,0x4AA50407,
	0x3FF845A1,0xCAC08312, 0x40329219,0x0350BF75,
	0x3FF849BA,0x5E353F7D, 0x4032EC50,0xE8915934,
	0x3FF84DD2,0xF1A9FBE7, 0x40334A03,0xC195B7AC,
	0x3FF851EB,0x851EB852, 0x4033AB66,0x2CDD1001,
	0x3FF85604,0x189374BC, 0x403410B1,0x02F2AFC1,
	0x3FF85A1C,0xAC083127, 0x40347A21,0xC54DB1CD,
	0x3FF85E35,0x3F7CED91, 0x4034E7FB,0x1B1BC6AF,
	0x3FF8624D,0xD2F1A9FC, 0x40355A85,0x5E0C0EAF,
	0x3FF86666,0x66666666, 0x4035D20F,0x398C1887,
	0x3FF86A7E,0xF9DB22D1, 0x40364EEE,0x5F58ED6F,
	0x3FF86E97,0x8D4FDF3B, 0x4036D180,0x54CCD600,
	0x3FF872B0,0x20C49BA6, 0x40375A2B,0x5CF5AC4F,
	0x3FF876C8,0xB4395810, 0x4037E95F,0x8445CAB8,
	0x3FF87AE1,0x47AE147B, 0x40387F97,0xD3A3ADE9,
	0x3FF87EF9,0xDB22D0E5, 0x40391D5B,0xB1C5123A,
	0x3FF88312,0x6E978D50, 0x4039C340,0x7B2FEC60,
	0x3FF8872B,0x020C49BA, 0x403A71EB,0x5B002FB7,
	0x3FF88B43,0x95810625, 0x403B2A13,0x70C4AD0A,
	0x3FF88F5C,0x28F5C28F, 0x403BEC84,0x52863AFE,
	0x3FF89374,0xBC6A7EFA, 0x403CBA20,0xFD83A86E,
	0x3FF8978D,0x4FDF3B64, 0x403D93E7,0x4C907AB9,
	0x3FF89BA5,0xE353F7CF, 0x403E7AF4,0x109C659E,
	0x3FF89FBE,0x76C8B439, 0x403F7087,0xEF168952,
	0x3FF8A3D7,0x0A3D70A4, 0x40403B06,0x9992D105,
	0x3FF8A7EF,0x9DB22D0E, 0x4040C68F,0x6560B76D,
	0x3FF8AC08,0x3126E979, 0x40415BC8,0x5C49746A,
	0x3FF8B020,0xC49BA5E3, 0x4041FBBD,0x2C3DE2D8,
	0x3FF8B439,0x5810624E, 0x4042A7A1,0x7856581D,
	0x3FF8B851,0xEB851EB8, 0x404360D8,0x977FD248,
	0x3FF8BC6A,0x7EF9DB23, 0x404428FF,0x32E960E5,
	0x3FF8C083,0x126E978D, 0x404501F7,0x5151C17F,
	0x3FF8C49B,0xA5E353F8, 0x4045EDF7,0x8DDBBBDF,
	0x3FF8C8B4,0x39581062, 0x4046EF9E,0x7F0969A7,
	0x3FF8CCCC,0xCCCCCCCD, 0x40480A0B,0xB6C0C707,
	0x3FF8D0E5,0x60418937, 0x40494100,0x561299FA,
	0x3FF8D4FD,0xF3B645A2, 0x404A990A,0x07280BDB,
	0x3FF8D916,0x872B020C, 0x404C17BC,0x74780F7A,
	0x3FF8DD2F,0x1A9FBE77, 0x404DC3FF,0x4723BB31,
	0x3FF8E147,0xAE147AE1, 0x404FA679,0xC53F8565,
	0x3FF8E560,0x4189374C, 0x4050E515,0x09F5A46E,
	0x3FF8E978,0xD4FDF3B6, 0x40521E9F,0x20CB9352,
	0x3FF8ED91,0x6872B021, 0x40538929,0x8A49520B,
	0x3FF8F1A9,0xFBE76C8B, 0x4055312A,0x80BABBCC,
	0x3FF8F5C2,0x8F5C28F6, 0x405727B6,0x362EE236,
	0x3FF8F9DB,0x22D0E560, 0x405984DA,0x19D34704,
	0x3FF8FDF3,0xB645A1CB, 0x405C6B93,0x9B7A3844,
	0x3FF9020C,0x49BA5E35, 0x40600869,0xF1D75740,
	0x3FF90624,0xDD2F1AA0, 0x4062645A,0x6E205DA5,
	0x3FF90A3D,0x70A3D70A, 0x406590AD,0x07938A7E,
	0x3FF90E56,0x04189375, 0x406A0FB8,0x9921391A,
	0x3FF9126E,0x978D4FDF, 0x40707694,0x7D81C7BF,
	0x3FF91687,0x2B020C4A, 0x407659C6,0xE87561F1,
	0x3FF91A9F,0xBE76C8B4, 0x40816587,0x20AEECD5,
	0x3FF91EB8,0x51EB851F, 0x40939F0F,0xF737E7F3,
	0x3FF922D0,0xE5604189, 0xC0B32DD3,0x70F4C17F,
	0x3FF926E9,0x78D4FDF4, 0xC089F651,0xAC5B68ED,
	0x3FF92B02,0x0C49BA5E, 0xC07C5C97,0xCA7AE7B0,
	0x3FF92F1A,0x9FBE76C9, 0xC0738240,0x074B6B17,
	0x3FF93333,0x33333333, 0xC06DBC58,0x5E7C6259,
	0x3FF9374B,0xC6A7EF9E, 0xC0680572,0x5CC5B468,
	0x3FF93B64,0x5A1CAC08, 0xC064262B,0x0B50C86F,
	0x3FF93F7C,0xED916873, 0xC0615A19,0xF21D0FA4,
	0x3FF94395,0x810624DD, 0xC05E7935,0x593189CB,
	0x3FF947AE,0x147AE148, 0xC05B298C,0x8D46CFC5,
	0x3FF94BC6,0xA7EF9DB2, 0xC0588008,0x8B1BA75E,
	0x3FF94FDF,0x3B645A1D, 0xC056502C,0x58DA5128,
	0x3FF953F7,0xCED91687, 0xC0547C0F,0xF41BCFAF,
	0x3FF95810,0x624DD2F2, 0xC052EEDA,0xB5F98D4F,
	0x3FF95C28,0xF5C28F5C, 0xC0519992,0xDC47E516,
	0x3FF96041,0x89374BC7, 0xC050712F,0x48B6624D,
	0x3FF9645A,0x1CAC0831, 0xC04EDAC0,0x87B87325,
	0x3FF96872,0xB020C49C, 0xC04D0F89,0x993D2403,
	0x3FF96C8B,0x43958106, 0xC04B76C5,0x6C89F0F0,
	0x3FF970A3,0xD70A3D71, 0xC04A0892,0x76263F1D,
	0x3FF974BC,0x6A7EF9DB, 0xC048BE9E,0x9B8B207B,
	0x3FF978D4,0xFDF3B646, 0xC04793C9,0x021CB2DB,
	0x3FF97CED,0x916872B0, 0xC04683DD,0x52183947,
	0x3FF98106,0x24DD2F1B, 0xC0458B60,0xBFC12676,
	0x3FF9851E,0xB851EB85, 0xC044A76B,0xB6D06F42,
	0x3FF98937,0x4BC6A7F0, 0xC043D58C,0xA5DFE44C,
	0x3FF98D4F,0xDF3B645A, 0xC04313B1,0x79C9CA32,
	0x3FF99168,0x72B020C5, 0xC0426016,0x107854F3,
	0x3FF99581,0x0624DD2F, 0xC041B936,0x6794B439,
	0x3FF99999,0x9999999A, 0xC0411DC3,0xA1F73BEA,
	0x3FF9C28F,0x5C28F5C3, 0xC0397EA7,0x960E5A09,
	0x3FF9EB85,0x1EB851EC, 0xC0344EAA,0x092D3149,
	0x3FFA147A,0xE147AE14, 0xC030DF00,0xB784AFBC,
	0x3FFA3D70,0xA3D70A3D, 0xC02CDAA2,0xFD8020CA,
	0x3FFA6666,0x66666666, 0xC02932D2,0xD5A0CCB7,
	0x3FFA8F5C,0x28F5C28F, 0xC0265C71,0x18986042,
	0x3FFAB851,0xEB851EB8, 0xC0241828,0x47401DE0,
	0x3FFAE147,0xAE147AE1, 0xC0223DD5,0xB025AC2B,
	0x3FFB0A3D,0x70A3D70A, 0xC020B2CE,0x67522C38,
	0x3FFB3333,0x33333333, 0xC01EC952,0x123D33F2,
	0x3FFB5C28,0xF5C28F5C, 0xC01C8C8D,0x2706C27A,
	0x3FFB851E,0xB851EB85, 0xC01A9C19,0x0EC19308,
	0x3FFBAE14,0x7AE147AE, 0xC018E994,0x2E7A9555,
	0x3FFBD70A,0x3D70A3D7, 0xC0176A03,0x3F52E80D,
	0x3FFC0000,0x00000000, 0xC01614DE,0x7972B0BB,
	0x3FFC28F5,0xC28F5C29, 0xC014E36B,0xC0AD26C4,
	0x3FFC51EB,0x851EB852, 0xC013D04A,0xC375EFA4,
	0x3FFC7AE1,0x47AE147B, 0xC012D722,0x55D37577,
	0x3FFCA3D7,0x0A3D70A4, 0xC011F464,0x6B624FDA,
	0x3FFCCCCC,0xCCCCCCCD, 0xC0112521,0xC7CA80BD,
	0x3FFCF5C2,0x8F5C28F6, 0xC01066E8,0xCC881F7F,
	0x3FFD1EB8,0x51EB851F, 0xC00F6F58,0x89958315,
	0x3FFD47AE,0x147AE148, 0xC00E2B60,0x0DB74600,
	0x3FFD70A3,0xD70A3D71, 0xC00CFEF3,0xCD5EE04E,
	0x3FFD9999,0x9999999A, 0xC00BE78B,0xC91E1650,
	0x3FFDC28F,0x5C28F5C3, 0xC00AE2F9,0x9ED055CC,
	0x3FFDEB85,0x1EB851EC, 0xC009EF59,0x8FDC25B9,
	0x3FFE147A,0xE147AE14, 0xC0090B06,0x6F617168,
	0x3FFE3D70,0xA3D70A3D, 0xC008348F,0xD530F01A,
	0x3FFE6666,0x66666666, 0xC0076AB2,0x1A0DF38B,
	0x3FFE8F5C,0x28F5C28F, 0xC006AC4F,0xBEDC1F14,
	0x3FFEB851,0xEB851EB8, 0xC005F86B,0xF5F91262,
	0x3FFEE147,0xAE147AE1, 0xC0054E26,0x1635E74B,
	0x3FFF0A3D,0x70A3D70A, 0xC004ACB5,0xCB251BE2,
	0x3FFF3333,0x33333333, 0xC0041367,0xDFC9C347,
	0x3FFF5C28,0xF5C28F5C, 0xC003819B,0x87E3E8DF,
	0x3FFF851E,0xB851EB85, 0xC002F6C0,0x11A68542,
	0x3FFFAE14,0x7AE147AE, 0xC0027252,0xEDFA8CC6,
	0x3FFFD70A,0x3D70A3D7, 0xC001F3DE,0x00DB394C,
	0x40000000,0x00000000, 0xC0017AF6,0x2E0950F8,
	0x4000147A,0xE147AE14, 0xC001073A,0x18777A95,
	0x400028F5,0xC28F5C29, 0xC0009851,0x0C882451,
	0x40003D70,0xA3D70A3D, 0xC0002DEA,0x0E9606EB,
	0x400051EB,0x851EB852, 0xBFFF8F76,0x10BA6B13,
	0x40006666,0x66666666, 0xBFFECB00,0x21842076,
	0x40007AE1,0x47AE147B, 0xBFFE0DF5,0x946081BC,
	0x40008F5C,0x28F5C28F, 0xBFFD57E3,0xA8CD66A0,
	0x4000A3D7,0x0A3D70A4, 0xBFFCA860,0x9E09CA5B,
	0x4000B851,0xEB851EB8, 0xBFFBFF0A,0xD52E814F,
	0x4000CCCC,0xCCCCCCCD, 0xBFFB5B88,0x0C6F419E,
	0x4000E147,0xAE147AE1, 0xBFFABD84,0xB03FE6A3,
	0x4000F5C2,0x8F5C28F6, 0xBFFA24B3,0x3F939F84,
	0x40010A3D,0x70A3D70A, 0xBFF990CB,0xC0D1EB78,
	0x40011EB8,0x51EB851F, 0xBFF9018B,0x45734C5E,
	0x40013333,0x33333333, 0xBFF876B3,0x7A80440D,
	0x400147AE,0x147AE148, 0xBFF7F00A,0x446ABF38,
	0x40015C28,0xF5C28F5C, 0xBFF76D59,0x64EE63D0,
	0x400170A3,0xD70A3D71, 0xBFF6EE6E,0x29D0CD96,
	0x4001851E,0xB851EB85, 0xBFF67319,0x2380E0BE,
	0x40019999,0x9999999A, 0xBFF5FB2D,0xE2B500EB,
	0x4001AE14,0x7AE147AE, 0xBFF58682,0xBC440B6B,
	0x4001C28F,0x5C28F5C3, 0xBFF514F0,0x928D1D1F,
	0x4001D70A,0x3D70A3D7, 0xBFF4A652,0xA3D70C9D,
	0x4001EB85,0x1EB851EC, 0xBFF43A86,0x5D228F65,
	0x40020000,0x00000000, 0xBFF3D16B,0x30F9ADCF,
	0x4002147A,0xE147AE14, 0xBFF36AE2,0x71D4C753,
	0x400228F5,0xC28F5C29, 0xBFF306CF,0x2FB9489E,
	0x40023D70,0xA3D70A3D, 0xBFF2A516,0x18C090EC,
	0x400251EB,0x851EB852, 0xBFF2459D,0x5C3E9543,
	0x40026666,0x66666666, 0xBFF1E84C,0x9047C337,
	0x40027AE1,0x47AE147B, 0xBFF18D0C,0x995C9E9A,
	0x40028F5C,0x28F5C28F, 0xBFF133C7,0x9407BAC9,
	0x4002A3D7,0x0A3D70A4, 0xBFF0DC68,0xC04018F0,
	0x4002B851,0xEB851EB8, 0xBFF086DC,0x6E66BD32,
	0x4002CCCC,0xCCCCCCCD, 0xBFF0330F,0xEDBA860A,
	0x4002E147,0xAE147AE1, 0xBFEFC1E2,0xF84221F4,
	0x4002F5C2,0x8F5C28F6, 0xBFEF20E0,0x6E4D9304,
	0x40030A3D,0x70A3D70A, 0xBFEE82F8,0x1C366935,
	0x40031EB8,0x51EB851F, 0xBFEDE80B,0x6A625622,
	0x40033333,0x33333333, 0xBFED4FFD,0x331A1C6C,
	0x400347AE,0x147AE148, 0xBFECBAB1,0xAC5A320E,
	0x40035C28,0xF5C28F5C, 0xBFEC280E,0x53339FE0,
	0x400370A3,0xD70A3D71, 0xBFEB97F9,0xD89C7A0F,
	0x4003851E,0xB851EB85, 0xBFEB0A5C,0x0F924FE5,
	0x40039999,0x9999999A, 0xBFEA7F1D,0xDC73A18D,
	0x4003AE14,0x7AE147AE, 0xBFE9F629,0x2577D856,
	0x4003C28F,0x5C28F5C3, 0xBFE96F68,0xC42F6A54,
	0x4003D70A,0x3D70A3D7, 0xBFE8EAC8,0x77F7CAEA,
	0x4003EB85,0x1EB851EC, 0xBFE86834,0xD9508D7E,
	0x40040000,0x00000000, 0xBFE7E79B,0x4E00BB15,
	0x4004147A,0xE147AE14, 0xBFE768E9,0xFDFCCC3A,
	0x400428F5,0xC28F5C29, 0xBFE6EC0F,0xC8FF094F,
	0x40043D70,0xA3D70A3D, 0xBFE670FC,0x3CC5423D,
	0x400451EB,0x851EB852, 0xBFE5F79F,0x8BE7E214,
	0x40046666,0x66666666, 0xBFE57FEA,0x853F5E3C,
	0x40047AE1,0x47AE147B, 0xBFE509CE,0x8BCDE2E4,
	0x40048F5C,0x28F5C28F, 0xBFE4953D,0x8F23EECD,
	0x4004A3D7,0x0A3D70A4, 0xBFE4222A,0x04374B8F,
	0x4004B851,0xEB851EB8, 0xBFE3B086,0xDEA47CAD,
	0x4004CCCC,0xCCCCCCCD, 0xBFE34047,0x8A535B2B,
	0x4004E147,0xAE147AE1, 0xBFE2D15F,0xE57823E1,
	0x4004F5C2,0x8F5C28F6, 0xBFE263C4,0x3AEAC051,
	0x40050A3D,0x70A3D70A, 0xBFE1F769,0x3CCE8ACA,
	0x40051EB8,0x51EB851F, 0xBFE18C43,0xFF853AF4,
	0x40053333,0x33333333, 0xBFE12249,0xF4E80DBB,
	0x400547AE,0x147AE148, 0xBFE0B970,0xE7C29638,
	0x40055C28,0xF5C28F5C, 0xBFE051AE,0xF78AFB49,
	0x400570A3,0xD70A3D71, 0xBFDFD5F5,0x28A7639E,
	0x4005851E,0xB851EB85, 0xBFDF0A94,0xF5E6187B,
	0x40059999,0x9999999A, 0xBFDE412B,0x62BA7143,
	0x4005AE14,0x7AE147AE, 0xBFDD79A7,0x065B07EC,
	0x4005C28F,0x5C28F5C3, 0xBFDCB3F6,0xFCB7E02F,
	0x4005D70A,0x3D70A3D7, 0xBFDBF00A,0xE038BC8B,
	0x4005EB85,0x1EB851EC, 0xBFDB2DD2,0xC3C97C79,
	0x40060000,0x00000000, 0xBFDA6D3F,0x2D2FBDDF,
	0x4006147A,0xE147AE14, 0xBFD9AE41,0x0FA54A23,
	0x400628F5,0xC28F5C29, 0xBFD8F0C9,0xC6B32406,
	0x40063D70,0xA3D70A3D, 0xBFD834CB,0x11494F1D,
	0x400651EB,0x851EB852, 0xBFD77A37,0x0D0FA9A0,
	0x40066666,0x66666666, 0xBFD6C100,0x31EC6D8F,
	0x40067AE1,0x47AE147B, 0xBFD60919,0x4DBD22FB,
	0x40068F5C,0x28F5C28F, 0xBFD55275,0x803F0213,
	0x4006A3D7,0x0A3D70A4, 0xBFD49D08,0x3723F05E,
	0x4006B851,0xEB851EB8, 0xBFD3E8C5,0x2A51724F,
	0x4006CCCC,0xCCCCCCCD, 0xBFD335A0,0x58471083,
	0x4006E147,0xAE147AE1, 0xBFD2838E,0x02A9D7B2,
	0x4006F5C2,0x8F5C28F6, 0xBFD1D282,0xAAF2BADC,
	0x40070A3D,0x70A3D70A, 0xBFD12273,0x0F3DC1BE,
	0x40071EB8,0x51EB851F, 0xBFD07354,0x27380945,
	0x40073333,0x33333333, 0xBFCF8A36,0x4255739F,
	0x400747AE,0x147AE148, 0xBFCE2F7A,0xBE425D06,
	0x40075C28,0xF5C28F5C, 0xBFCCD660,0xE8514668,
	0x400770A3,0xD70A3D71, 0xBFCB7ED4,0x434FA4BA,
	0x4007851E,0xB851EB85, 0xBFCA28C0,0xA99A06CD,
	0x40079999,0x9999999A, 0xBFC8D412,0x482234DD,
	0x4007AE14,0x7AE147AE, 0xBFC780B5,0x999C9D3F,
	0x4007C28F,0x5C28F5C3, 0xBFC62E97,0x61D274B1,
	0x4007D70A,0x3D70A3D7, 0xBFC4DDA4,0xA9161384,
	0x4007EB85,0x1EB851EC, 0xBFC38DCA,0xB7D7307D,
	0x40080000,0x00000000, 0xBFC23EF7,0x1254B86F,
	0x4008147A,0xE147AE14, 0xBFC0F117,0x746A1536,
	0x400828F5,0xC28F5C29, 0xBFBF4833,0x9AEBA09F,
	0x40083D70,0xA3D70A3D, 0xBFBCAFD8,0x78AF1E09,
	0x400851EB,0x851EB852, 0xBFBA18FA,0x1706F131,
	0x40086666,0x66666666, 0xBFB78375,0x5A525376,
	0x40087AE1,0x47AE147B, 0xBFB4EF27,0x6ED8C87F,
	0x40088F5C,0x28F5C28F, 0xBFB25BED,0xC15B774D,
	0x4008A3D7,0x0A3D70A4, 0xBFAF934B,0xEF861D63,
	0x4008B851,0xEB851EB8, 0xBFAA705B,0xD3CDC956,
	0x4008CCCC,0xCCCCCCCD, 0xBFA54EC7,0x34D41690,
	0x4008E147,0xAE147AE1, 0xBFA02E4A,0x5F565CE2,
	0x4008F5C2,0x8F5C28F6, 0xBF961D43,0xB310503E,
	0x40090A3D,0x70A3D70A, 0xBF87BE29,0x54AD5EB0,
	0x40091EB8,0x51EB851F, 0xBF5A1814,0x37675567,
	0x40093333,0x33333333, 0x3F8137F9,0x856D6E41,
	0x400947AE,0x147AE148, 0x3F92D9EB,0xA4F62313,
	0x40095C28,0xF5C28F5C, 0x3F9D18D1,0xB72C1B1B,
	0x400970A3,0xD70A3D71, 0x3FA3AC9A,0xBFF3086B,
	0x4009851E,0xB851EB85, 0x3FA8CDCE,0xE9FD6569,
	0x40099999,0x9999999A, 0x3FADF048,0xF9266060,
	0x4009AE14,0x7AE147AE, 0x3FB18A26,0x67EEAFBE,
	0x4009C28F,0x5C28F5C3, 0x3FB41D0F,0x50D2CBD6,
	0x4009D70A,0x3D70A3D7, 0x3FB6B101,0x80A79C58,
	0x4009EB85,0x1EB851EC, 0x3FB9461F,0x77AD405C,
	0x400A0000,0x00000000, 0x3FBBDC8B,0xF445936C,
	0x400A147A,0xE147AE14, 0x3FBE7469,0xFA596046,
	0x400A28F5,0xC28F5C29, 0x3FC086EE,0x6D6E387C,
	0x400A3D70,0xA3D70A3D, 0x3FC1D484,0x1DB9FC33,
	0x400A51EB,0x851EB852, 0x3FC32308,0x0F2175C4,
	0x400A6666,0x66666666, 0x3FC4728C,0x74EFFCF3,
	0x400A7AE1,0x47AE147B, 0x3FC5C323,0xB8BC7E0F,
	0x400A8F5C,0x28F5C28F, 0x3FC714E0,0x7E93E585,
	0x400AA3D7,0x0A3D70A4, 0x3FC867D5,0xA93E50A7,
	0x400AB851,0xEB851EB8, 0x3FC9BC16,0x5EA125B4,
	0x400ACCCC,0xCCCCCCCD, 0x3FCB11B6,0x0C40508C,
	0x400AE147,0xAE147AE1, 0x3FCC68C8,0x6BE0F671,
	0x400AF5C2,0x8F5C28F6, 0x3FCDC161,0x885012CC,
	0x400B0A3D,0x70A3D70A, 0x3FCF1B95,0xC24F8827,
	0x400B1EB8,0x51EB851F, 0x3FD03BBC,0xEAD62A78,
	0x400B3333,0x33333333, 0x3FD0EA91,0x6F405CD1,
	0x400B47AE,0x147AE148, 0x3FD19A53,0x2F52A3EA,
	0x400B5C28,0xF5C28F5C, 0x3FD24B0D,0x21A9FA95,
	0x400B70A3,0xD70A3D71, 0x3FD2FCCA,0x75803EAD,
	0x400B851E,0xB851EB85, 0x3FD3AF96,0x95B4C42B,
	0x400B9999,0x9999999A, 0x3FD4637D,0x2BF3206B,
	0x400BAE14,0x7AE147AE, 0x3FD5188A,0x23FA1C89,
	0x400BC28F,0x5C28F5C3, 0x3FD5CEC9,0xAF04DD47,
	0x400BD70A,0x3D70A3D7, 0x3FD68648,0x47586C2C,
	0x400BEB85,0x1EB851EC, 0x3FD73F12,0xB3F7F1AE,
	0x400C0000,0x00000000, 0x3FD7F936,0x0C8212A7,
	0x400C147A,0xE147AE14, 0x3FD8B4BF,0xBD3A0CE3,
	0x400C28F5,0xC28F5C29, 0x3FD971BD,0x8B3F572C,
	0x400C3D70,0xA3D70A3D, 0x3FDA303D,0x98F6B846,
	0x400C51EB,0x851EB852, 0x3FDAF04E,0x6AA7F9CC,
	0x400C6666,0x66666666, 0x3FDBB1FE,0xEB539007,
	0x400C7AE1,0x47AE147B, 0x3FDC755E,0x71C3CB76,
	0x400C8F5C,0x28F5C28F, 0x3FDD3A7C,0xC5DD64C3,
	0x400CA3D7,0x0A3D70A4, 0x3FDE016A,0x2633799A,
	0x400CB851,0xEB851EB8, 0x3FDECA37,0x4DE35722,
	0x400CCCCC,0xCCCCCCCD, 0x3FDF94F5,0x7ABCC018,
	0x400CE147,0xAE147AE1, 0x3FE030DB,0x39DDD7B5,
	0x400CF5C2,0x8F5C28F6, 0x3FE09846,0x47EC7B6E,
	0x400D0A3D,0x70A3D70A, 0x3FE100C5,0x5E9BBD7C,
	0x400D1EB8,0x51EB851F, 0x3FE16A62,0x445A1E5C,
	0x400D3333,0x33333333, 0x3FE1D527,0x12EFEA2B,
	0x400D47AE,0x147AE148, 0x3FE2411E,0x3BB441CA,
	0x400D5C28,0xF5C28F5C, 0x3FE2AE52,0x8BFE46FB,
	0x400D70A3,0xD70A3D71, 0x3FE31CCF,0x31D68FC4,
	0x400D851E,0xB851EB85, 0x3FE38C9F,0xC0ED5649,
	0x400D9999,0x9999999A, 0x3FE3FDD0,0x37DA3554,
	0x400DAE14,0x7AE147AE, 0x3FE4706D,0x05AAA22E,
	0x400DC28F,0x5C28F5C3, 0x3FE4E483,0x0FC4C04C,
	0x400DD70A,0x3D70A3D7, 0x3FE55A1F,0xB8249E6D,
	0x400DEB85,0x1EB851EC, 0x3FE5D150,0xE3FA6D5E,
	0x400E0000,0x00000000, 0x3FE64A25,0x02B0CA3B,
	0x400E147A,0xE147AE14, 0x3FE6C4AB,0x1562CFC7,
	0x400E28F5,0xC28F5C29, 0x3FE740F2,0xB6CA47FE,
	0x400E3D70,0xA3D70A3D, 0x3FE7BF0C,0x23AF0ED3,
	0x400E51EB,0x851EB852, 0x3FE83F08,0x43E17FCE,
	0x400E6666,0x66666666, 0x3FE8C0F8,0xB3CAA42E,
	0x400E7AE1,0x47AE147B, 0x3FE944EF,0xCE9DCB31,
	0x400E8F5C,0x28F5C28F, 0x3FE9CB00,0xB9383FC0,
	0x400EA3D7,0x0A3D70A4, 0x3FEA533F,0x6DBCF6E1,
	0x400EB851,0xEB851EB8, 0x3FEADDC0,0xC7FB5569,
	0x400ECCCC,0xCCCCCCCD, 0x3FEB6A9A,0x92B193F9,
	0x400EE147,0xAE147AE1, 0x3FEBF9E3,0x95BCD327,
	0x400EF5C2,0x8F5C28F6, 0x3FEC8BB3,0xA54AAA88,
	0x400F0A3D,0x70A3D70A, 0x3FED2023,0xB221E225,
	0x400F1EB8,0x51EB851F, 0x3FEDB74D,0xDB1A2351,
	0x400F3333,0x33333333, 0x3FEE514D,0x7FDCC3DA,
	0x400F47AE,0x147AE148, 0x3FEEEE3F,0x550B6B09,
	0x400F5C28,0xF5C28F5C, 0x3FEF8E41,0x79EC34DB,
	0x400F70A3,0xD70A3D71, 0x3FF018B9,0xC7DF1AD3,
	0x400F851E,0xB851EB85, 0x3FF06BFB,0x696E6D99,
	0x400F9999,0x9999999A, 0x3FF0C0F7,0x1AEE59E4,
	0x400FAE14,0x7AE147AE, 0x3FF117BF,0x3F6853A1,
	0x400FC28F,0x5C28F5C3, 0x3FF17067,0x3375E0EE,
	0x400FD70A,0x3D70A3D7, 0x3FF1CB03,0x5E5CAFC7,
	0x400FEB85,0x1EB851EC, 0x3FF227A9,0x4495F7D8,
	0x40100000,0x00000000, 0x3FF2866F,0x9BE4DE13,
	0x40100A3D,0x70A3D70A, 0x3FF2E76E,0x6123A1FA,
	0x4010147A,0xE147AE14, 0x3FF34ABE,0xEFF3F3ED,
	0x40101EB8,0x51EB851F, 0x3FF3B07C,0x1C84085B,
	0x401028F5,0xC28F5C29, 0x3FF418C2,0x4F9FE0DA,
	0x40103333,0x33333333, 0x3FF483AF,0xA54CF833,
	0x40103D70,0xA3D70A3D, 0x3FF4F164,0x0E361CC1,
	0x401047AE,0x147AE148, 0x3FF56201,0x7435F6EE,
	0x401051EB,0x851EB852, 0x3FF5D5AB,0xE258A65E,
	0x40105C28,0xF5C28F5C, 0x3FF64C89,0xB0B83EB8,
	0x40106666,0x66666666, 0x3FF6C6C3,0xB4A4F47E,
	0x401070A3,0xD70A3D71, 0x3FF74485,0x7598C740,
	0x40107AE1,0x47AE147B, 0x3FF7C5FD,0x6787B78C,
	0x4010851E,0xB851EB85, 0x3FF84B5D,0x2B318524,
	0x40108F5C,0x28F5C28F, 0x3FF8D4D9,0xD530FF49,
	0x40109999,0x9999999A, 0x3FF962AC,0x3C9FB267,
	0x4010A3D7,0x0A3D70A4, 0x3FF9F511,0x5243D841,
	0x4010AE14,0x7AE147AE, 0x3FFA8C4A,0x8162B618,
	0x4010B851,0xEB851EB8, 0x3FFB289E,0x1B7BF881,
	0x4010C28F,0x5C28F5C3, 0x3FFBCA57,0xD0645308,
	0x4010CCCC,0xCCCCCCCD, 0x3FFC71C9,0x34701778,
	0x4010D70A,0x3D70A3D7, 0x3FFD1F4A,0x56A3619E,
	0x4010E147,0xAE147AE1, 0x3FFDD33A,0x692EF174,
	0x4010EB85,0x1EB851EC, 0x3FFE8E00,0x7EE183CE,
	0x4010F5C2,0x8F5C28F6, 0x3FFF500C,0x60A89856,
	0x40110000,0x00000000, 0x40000CEB,0xBF628F31,
	0x40110A3D,0x70A3D70A, 0x400075F3,0x00FEB2B6,
	0x4011147A,0xE147AE14, 0x4000E364,0x00EE10ED,
	0x40111EB8,0x51EB851F, 0x4001558D,0x72FE0A92,
	0x401128F5,0xC28F5C29, 0x4001CCC5,0x7CC15EC5,
	0x40113333,0x33333333, 0x4002496A,0x9CA760A9,
	0x40113D70,0xA3D70A3D, 0x4002CBE4,0xB388298E,
	0x401147AE,0x147AE148, 0x400354A6,0x36CB66E9,
	0x401151EB,0x851EB852, 0x4003E42D,0x929899F0,
	0x40115C28,0xF5C28F5C, 0x40047B06,0xC51868FC,
	0x40116666,0x66666666, 0x400519CD,0x3DCCEF9A,
	0x401170A3,0xD70A3D71, 0x4005C12E,0x0E879FEB,
	0x40117AE1,0x47AE147B, 0x400671EA,0x7EAC4FD2,
	0x4011851E,0xB851EB85, 0x40072CDB,0x1575275A,
	0x40118F5C,0x28F5C28F, 0x4007F2F3,0x350E3F18,
	0x40119999,0x9999999A, 0x4008C545,0x66FDBDEC,
	0x4011A3D7,0x0A3D70A4, 0x4009A508,0x82E370F9,
	0x4011AE14,0x7AE147AE, 0x400A939D,0xE3D5A677,
	0x4011B851,0xEB851EB8, 0x400B9298,0xEF70163E,
	0x4011C28F,0x5C28F5C3, 0x400CA3C8,0x455D4218,
	0x4011CCCC,0xCCCCCCCD, 0x400DC941,0x089849E0,
	0x4011D70A,0x3D70A3D7, 0x400F056C,0xD78A2EDB,
	0x4011E147,0xAE147AE1, 0x40102D8D,0x9CAF3190,
	0x4011EB85,0x1EB851EC, 0x4010E6CB,0xC599C19C,
	0x4011F5C2,0x8F5C28F6, 0x4011B062,0x6BDC4851,
	0x40120000,0x00000000, 0x40128CA0,0xC62BF595,
	0x40120A3D,0x70A3D70A, 0x40137E4A,0xE22E6BDD,
	0x4012147A,0xE147AE14, 0x401488B8,0x020BC6EA,
	0x40121EB8,0x51EB851F, 0x4015AFFA,0xF7407ABD,
	0x401228F5,0xC28F5C29, 0x4016F918,0x89139216,
	0x40123333,0x33333333, 0x40186A51,0xF4A4BCE8,
	0x40123D70,0xA3D70A3D, 0x401A0B8C,0xC23408C5,
	0x401247AE,0x147AE148, 0x401BE6E6,0x5B418FD1,
	0x401251EB,0x851EB852, 0x401E098A,0x83E8B7AB,
	0x40125C28,0xF5C28F5C, 0x40204279,0x7C85C3DD,
	0x40126666,0x66666666, 0x4021B868,0xD80B4C11,
	0x401270A3,0xD70A3D71, 0x4023770D,0x3005D2D4,
	0x40127AE1,0x47AE147B, 0x40259602,0x7F4B226B,
	0x4012851E,0xB851EB85, 0x4028385B,0x1B77EDE6,
	0x40128F5C,0x28F5C28F, 0x402B948A,0x80D7055A,
	0x40129999,0x9999999A, 0x403001F6,0xA713EF1D,
	0x4012A3D7,0x0A3D70A4, 0x4033120D,0x6E567C5F,
	0x4012AE14,0x7AE147AE, 0x403793B0,0x14CFE6DD,
	0x4012B851,0xEB851EB8, 0x403EDD28,0xA291F23C,
	0x4012C28F,0x5C28F5C3, 0x40465424,0x9701608D,
	0x4012CCCC,0xCCCCCCCD, 0x40542D9D,0xE890C6A9,
	0x4012D70A,0x3D70A3D7, 0x407A2967,0xB8BA248E,
	0x4012E147,0xAE147AE1, 0xC0606C59,0x52D96EAC,
	0x4012EB85,0x1EB851EC, 0xC04C636C,0xD62A6257,
	0x4012F5C2,0x8F5C28F6, 0xC0421AA6,0xF169ED66,
	0x40130000,0x00000000, 0xC03A934E,0x58D7CC85,
	0x40130A3D,0x70A3D70A, 0xC034FCD7,0xD2DC29C4,
	0x4013147A,0xE147AE14, 0xC03156AD,0x56671A8A,
	0x40131EB8,0x51EB851F, 0xC02D8930,0x0597B53B,
	0x401328F5,0xC28F5C29, 0xC029B7C0,0x1A22AC84,
	0x40133333,0x33333333, 0xC026C50D,0xC43253B3,
	0x40133D70,0xA3D70A3D, 0xC0246CA3,0xCECE8128,
	0x401347AE,0x147AE148, 0xC022837F,0x4AE886B8,
	0x401351EB,0x851EB852, 0xC020ED3E,0x254228AF,
	0x40135C28,0xF5C28F5C, 0xC01F2CC7,0xB61F8BFB,
	0x40136666,0x66666666, 0xC01CE23B,0xE0FADD61,
	0x401370A3,0xD70A3D71, 0xC01AE6B1,0x8CE5AA9C,
	0x40137AE1,0x47AE147B, 0xC0192B1E,0xD5C27D9D,
	0x4013851E,0xB851EB85, 0xC017A410,0x99DC50C6,
	0x40138F5C,0x28F5C28F, 0xC01648A7,0xD51B1884,
	0x40139999,0x9999999A, 0xC01511E9,0xB3C687CB,
	0x4013A3D7,0x0A3D70A4, 0xC013FA45,0x0FCBE1B5,
	0x4013AE14,0x7AE147AE, 0xC012FD3B,0x55E7BA64,
	0x4013B851,0xEB851EB8, 0xC0121721,0x6F136D8C,
	0x4013C28F,0x5C28F5C3, 0xC01144F1,0x4B5C7084,
	0x4013CCCC,0xCCCCCCCD, 0xC0108427,0x27EA8A1F,
	0x4013D70A,0x3D70A3D7, 0xC00FA54E,0x7E67A867,
	0x4013E147,0xAE147AE1, 0xC00E5D53,0x340A0A6A,
	0x4013EB85,0x1EB851EC, 0xC00D2D54,0xCE016933,
	0x4013F5C2,0x8F5C28F6, 0xC00C12BB,0x68F3A9E7,
	0x40140000,0x00000000, 0xC00B0B4B,0x739BBB07,
	0x40140A3D,0x70A3D70A, 0xC00A1516,0x2C226A73,
	0x4014147A,0xE147AE14, 0xC0092E6D,0x23F265CB,
	0x40141EB8,0x51EB851F, 0xC00855D8,0x1F563A3F,
	0x401428F5,0xC28F5C29, 0xC0078A0C,0xCFDDA8E4,
	0x40143333,0x33333333, 0xC006C9E8,0x07199B18,
	0x40143D70,0xA3D70A3D, 0xC0061468,0x15E5C4AB,
	0x401447AE,0x147AE148, 0xC00568A8,0x1D6B1E39,
	0x401451EB,0x851EB852, 0xC004C5DC,0x23D3F339,
	0x40145C28,0xF5C28F5C, 0xC0042B4D,0xC86A9F1B,
	0x40146666,0x66666666, 0xC0039859,0x7A58D5D2,
	0x401470A3,0xD70A3D71, 0xC0030C6C,0x1B083445,
	0x40147AE1,0x47AE147B, 0xC0028700,0xF9A84E4C,
	0x4014851E,0xB851EB85, 0xC00207A0,0x18E8E15E,
	0x40148F5C,0x28F5C28F, 0xC0018DDC,0xB2C28011,
	0x40149999,0x9999999A, 0xC0011953,0xF06083E8,
	0x4014A3D7,0x0A3D70A4, 0xC000A9AB,0xCE054241,
	0x4014AE14,0x7AE147AE, 0xC0003E92,0x242E5A61,
	0x4014B851,0xEB851EB8, 0xBFFFAF77,0xA0CB2BDF,
	0x4014C28F,0x5C28F5C3, 0xBFFEE9C7,0xF233E017,
	0x4014CCCC,0xCCCCCCCD, 0xBFFE2B96,0xD13EA593,
	0x4014D70A,0x3D70A3D7, 0xBFFD746F,0xF826A0D3,
	0x4014E147,0xAE147AE1, 0xBFFCC3E8,0x46D108A5,
	0x4014EB85,0x1EB851EC, 0xBFFC199C,0xE08DA66F,
	0x4014F5C2,0x8F5C28F6, 0xBFFB7532,0x63919678,
	0x40150000,0x00000000, 0xBFFAD654,0x36D2B404,
	0x40150A3D,0x70A3D70A, 0xBFFA3CB3,0xEB67679B,
	0x4015147A,0xE147AE14, 0xBFF9A808,0xAEF79B2F,
	0x40151EB8,0x51EB851F, 0xBFF9180E,0xCD24004B,
	0x401528F5,0xC28F5C29, 0xBFF88C87,0x3E13753C,
	0x40153333,0x33333333, 0xBFF80537,0x409587B1,
	0x40153D70,0xA3D70A3D, 0xBFF781E7,0xFE7EC38B,
	0x401547AE,0x147AE148, 0xBFF70266,0x3A11352C,
	0x401551EB,0x851EB852, 0xBFF68682,0x036A98E0,
	0x40155C28,0xF5C28F5C, 0xBFF60E0E,0x75132642,
	0x40156666,0x66666666, 0xBFF598E1,0x76E4A597,
	0x401570A3,0xD70A3D71, 0xBFF526D3,0x869A3A55,
	0x40157AE1,0x47AE147B, 0xBFF4B7BF,0x856EAB69,
	0x4015851E,0xB851EB85, 0xBFF44B82,0x8A416B2B,
	0x40158F5C,0x28F5C28F, 0xBFF3E1FB,0xB7CAA946,
	0x40159999,0x9999999A, 0xBFF37B0C,0x1674A47B,
	0x4015A3D7,0x0A3D70A4, 0xBFF31696,0x717C9515,
	0x4015AE14,0x7AE147AE, 0xBFF2B47F,0x37081E28,
	0x4015B851,0xEB851EB8, 0xBFF254AC,0x5AE577BD,
	0x4015C28F,0x5C28F5C3, 0xBFF1F705,0x3BB4A007,
	0x4015CCCC,0xCCCCCCCD, 0xBFF19B72,0x8A3F0291,
	0x4015D70A,0x3D70A3D7, 0xBFF141DE,0x32C947CD,
	0x4015E147,0xAE147AE1, 0xBFF0EA33,0x4830863E,
	0x4015EB85,0x1EB851EC, 0xBFF0945D,0xF0A8ED4E,
	0x4015F5C2,0x8F5C28F6, 0xBFF0404B,0x53F8523F,
	0x40160000,0x00000000, 0xBFEFDBD3,0x1615B07A,
	0x40160A3D,0x70A3D70A, 0xBFEF3A4F,0x2186A1B7,
	0x4016147A,0xE147AE14, 0xBFEE9BEA,0x67D7E721,
	0x40161EB8,0x51EB851F, 0xBFEE0086,0x145D7263,
	0x401628F5,0xC28F5C29, 0xBFED6804,0xC7FE16EE,
	0x40163333,0x33333333, 0xBFECD24A,0x82C132C9,
	0x40163D70,0xA3D70A3D, 0xBFEC3F3C,0x8EF2141B,
	0x401647AE,0x147AE148, 0xBFEBAEC1,0x6DB7F4D2,
	0x401651EB,0x851EB852, 0xBFEB20C0,0xC50475AA,
	0x40165C28,0xF5C28F5C, 0xBFEA9523,0x4EBD3E38,
	0x40166666,0x66666666, 0xBFEA0BD2,0xC907E03E,
	0x401670A3,0xD70A3D71, 0xBFE984B9,0xE7A1523E,
	0x40167AE1,0x47AE147B, 0xBFE8FFC4,0x462C55D1,
	0x4016851E,0xB851EB85, 0xBFE87CDE,0x5B63EA04,
	0x40168F5C,0x28F5C28F, 0xBFE7FBF5,0x6D208C16,
	0x40169999,0x9999999A, 0xBFE77CF7,0x85207F68,
	0x4016A3D7,0x0A3D70A4, 0xBFE6FFD3,0x6684AB8F,
	0x4016AE14,0x7AE147AE, 0xBFE68478,0x83F4D287,
	0x4016B851,0xEB851EB8, 0xBFE60AD6,0xF65EFAB5,
	0x4016C28F,0x5C28F5C3, 0xBFE592DF,0x7446E4A5,
	0x4016CCCC,0xCCCCCCCD, 0xBFE51C83,0x499B4CC8,
	0x4016D70A,0x3D70A3D7, 0xBFE4A7B4,0x50078A21,
	0x4016E147,0xAE147AE1, 0xBFE43464,0xE7B8DBC0,
	0x4016EB85,0x1EB851EC, 0xBFE3C287,0xF08F63B2,
	0x4016F5C2,0x8F5C28F6, 0xBFE35210,0xC3B36E38,
	0x40170000,0x00000000, 0xBFE2E2F3,0x2D88343E,
	0x40170A3D,0x70A3D70A, 0xBFE27523,0x67F5CE4C,
	0x4017147A,0xE147AE14, 0xBFE20896,0x15048503,
	0x40171EB8,0x51EB851F, 0xBFE19D40,0x39C41C69,
	0x401728F5,0xC28F5C29, 0xBFE13317,0x397A1CF1,
	0x40173333,0x33333333, 0xBFE0CA10,0xD11279EF,
	0x40173D70,0xA3D70A3D, 0xBFE06223,0x12CE4C3B,
	0x401747AE,0x147AE148, 0xBFDFF688,0xC4594A0F,
	0x401751EB,0x851EB852, 0xBFDF2AD6,0xE0138D02,
	0x40175C28,0xF5C28F5C, 0xBFDE611E,0x6DE2A27D,
	0x40176666,0x66666666, 0xBFDD994D,0xEF40685C,
	0x401770A3,0xD70A3D71, 0xBFDCD354,0x6B66C789,
	0x40177AE1,0x47AE147B, 0xBFDC0F21,0x69012494,
	0x4017851E,0xB851EB85, 0xBFDB4CA4,0xE82CA40C,
	0x40178F5C,0x28F5C28F, 0xBFDA8BCF,0x5CC26F7F,
	0x40179999,0x9999999A, 0xBFD9CC91,0xA8E776FC,
	0x4017A3D7,0x0A3D70A4, 0xBFD90EDD,0x17DD78C2,
	0x4017AE14,0x7AE147AE, 0xBFD852A3,0x59115C7C,
	0x4017B851,0xEB851EB8, 0xBFD797D6,0x7B6332C0,
	0x4017C28F,0x5C28F5C3, 0xBFD6DE68,0xE8A4629E,
	0x4017CCCC,0xCCCCCCCD, 0xBFD6264D,0x6148C8A4,
	0x4017D70A,0x3D70A3D7, 0xBFD56F76,0xF847BBD0,
	0x4017E147,0xAE147AE1, 0xBFD4B9D9,0x0F2A1F35,
	0x4017EB85,0x1EB851EC, 0xBFD40567,0x5242D07B,
	0x4017F5C2,0x8F5C28F6, 0xBFD35215,0xB50EEE4E,
	0x40180000,0x00000000, 0xBFD29FD8,0x6EBB95BE,
	0x40180A3D,0x70A3D70A, 0xBFD1EEA3,0xF6CEDB3D,
	0x4018147A,0xE147AE14, 0xBFD13E6D,0x01F1E224,
	0x40181EB8,0x51EB851F, 0xBFD08F28,0x7EDA1559,
	0x401828F5,0xC28F5C29, 0xBFCFC197,0x269F3F77,
	0x40183333,0x33333333, 0xBFCE6697,0x329EB7B0,
	0x40183D70,0xA3D70A3D, 0xBFCD0D3C,0x388D19B7,
	0x401847AE,0x147AE148, 0xBFCBB571,0xACCD8DC5,
	0x401851EB,0x851EB852, 0xBFCA5F23,0x5C2106DA,
	0x40185C28,0xF5C28F5C, 0xBFC90A3D,0x66A5E076,
	0x40186666,0x66666666, 0xBFC7B6AC,0x3AFF3643,
	0x401870A3,0xD70A3D71, 0xBFC6645C,0x91A15744,
	0x40187AE1,0x47AE147B, 0xBFC5133B,0x6840D861,
	0x4018851E,0xB851EB85, 0xBFC3C335,0xFD61E310,
	0x40188F5C,0x28F5C28F, 0xBFC27439,0xCC057B7F,
	0x40189999,0x9999999A, 0xBFC12634,0x87728D50,
	0x4018A3D7,0x0A3D70A4, 0xBFBFB228,0x2E314F16,
	0x4018AE14,0x7AE147AE, 0xBFBD198D,0x2514C2E4,
	0x4018B851,0xEB851EB8, 0xBFBA8274,0x7B1AF1B0,
	0x4018C28F,0x5C28F5C3, 0xBFB7ECBB,0x087D8E67,
	0x4018CCCC,0xCCCCCCCD, 0xBFB5583D,0xEE907AF9,
	0x4018D70A,0x3D70A3D7, 0xBFB2C4DA,0x904E42B0,
	0x4018E147,0xAE147AE1, 0xBFB0326E,0x8B01AE21,
	0x4018EB85,0x1EB851EC, 0xBFAB41AF,0x5E1229DA,
	0x4018F5C2,0x8F5C28F6, 0xBFA61FE7,0xF160582C,
	0x40190000,0x00000000, 0xBFA0FF43,0x123A338E,
	0x40190A3D,0x70A3D70A, 0xBF97BEFA,0x7D36BBC6,
	0x4019147A,0xE147AE14, 0xBF8B014C,0x890D5442,
	0x40191EB8,0x51EB851F, 0xBF6A1818,0x8DDF1E5A,
	0x401928F5,0xC28F5C29, 0x3F7BE9D5,0x7E31634E,
	0x40193333,0x33333333, 0x3F913849,0x4AF2A746,
	};

LOCAL_D const TUint32 ExpTest[] =
	{
	0xC0000000,0x00000000, 0x3FC152AA,0xA3BF81CC,
	0xBFFFD70A,0x3D70A3D7, 0x3FC17F3C,0x56E69205,
	0xBFFFAE14,0x7AE147AE, 0x3FC1AC40,0xB56ABECC,
	0xBFFF851E,0xB851EB85, 0x3FC1D9B8,0xE652C462,
	0xBFFF5C28,0xF5C28F5C, 0x3FC207A6,0x139C6D76,
	0xBFFF3333,0x33333333, 0x3FC23609,0x6A44340F,
	0xBFFF0A3D,0x70A3D70A, 0x3FC264E4,0x1A4CF61B,
	0xBFFEE147,0xAE147AE1, 0x3FC29437,0x56C7BDD5,
	0xBFFEB851,0xEB851EB8, 0x3FC2C404,0x55DB9E2B,
	0xBFFE8F5C,0x28F5C28F, 0x3FC2F44C,0x50CDA35E,
	0xBFFE6666,0x66666666, 0x3FC32510,0x8408D817,
	0xBFFE3D70,0xA3D70A3D, 0x3FC35652,0x2F265F15,
	0xBFFE147A,0xE147AE14, 0x3FC38812,0x94F5A1B7,
	0xBFFDEB85,0x1EB851EC, 0x3FC3BA52,0xFB849391,
	0xBFFDC28F,0x5C28F5C3, 0x3FC3ED14,0xAC280B4D,
	0xBFFD9999,0x9999999A, 0x3FC42058,0xF38430F0,
	0xBFFD70A3,0xD70A3D71, 0x3FC45421,0x219501EA,
	0xBFFD47AE,0x147AE148, 0x3FC4886E,0x89B6EAFE,
	0xBFFD1EB8,0x51EB851F, 0x3FC4BD42,0x82AF7851,
	0xBFFCF5C2,0x8F5C28F6, 0x3FC4F29E,0x66B61BD1,
	0xBFFCCCCC,0xCCCCCCCD, 0x3FC52883,0x937D0A33,
	0xBFFCA3D7,0x0A3D70A4, 0x3FC55EF3,0x6A3A2EBA,
	0xBFFC7AE1,0x47AE147B, 0x3FC595EF,0x4FB0360C,
	0xBFFC51EB,0x851EB852, 0x3FC5CD78,0xAC37B046,
	0xBFFC28F5,0xC28F5C29, 0x3FC60590,0xEBC84A91,
	0xBFFC0000,0x00000000, 0x3FC63E39,0x7E022073,
	0xBFFBD70A,0x3D70A3D7, 0x3FC67773,0xD637251A,
	0xBFFBAE14,0x7AE147AE, 0x3FC6B141,0x6B74A4E0,
	0xBFFB851E,0xB851EB85, 0x3FC6EBA3,0xB88CDF38,
	0xBFFB5C28,0xF5C28F5C, 0x3FC7269C,0x3C20B964,
	0xBFFB3333,0x33333333, 0x3FC7622C,0x78A98A07,
	0xBFFB0A3D,0x70A3D70A, 0x3FC79E55,0xF482FDFE,
	0xBFFAE147,0xAE147AE1, 0x3FC7DB1A,0x39F516A4,
	0xBFFAB851,0xEB851EB8, 0x3FC8187A,0xD73E41CB,
	0xBFFA8F5C,0x28F5C28F, 0x3FC85679,0x5E9D8BB1,
	0xBFFA6666,0x66666666, 0x3FC89517,0x665CEB31,
	0xBFFA3D70,0xA3D70A3D, 0x3FC8D456,0x88DBA86F,
	0xBFFA147A,0xE147AE14, 0x3FC91438,0x6498DE48,
	0xBFF9EB85,0x1EB851EC, 0x3FC954BE,0x9C3E16C7,
	0xBFF9C28F,0x5C28F5C3, 0x3FC995EA,0xD6AA02F2,
	0xBFF99999,0x9999999A, 0x3FC9D7BE,0xBEFB4E15,
	0xBFF970A3,0xD70A3D71, 0x3FCA1A3C,0x049B8D00,
	0xBFF947AE,0x147AE148, 0x3FCA5D64,0x5B4A4953,
	0xBFF91EB8,0x51EB851F, 0x3FCAA139,0x7B282942,
	0xBFF8F5C2,0x8F5C28F6, 0x3FCAE5BD,0x20C23400,
	0xBFF8CCCC,0xCCCCCCCD, 0x3FCB2AF1,0x0D1D3336,
	0xBFF8A3D7,0x0A3D70A4, 0x3FCB70D7,0x05C131B3,
	0xBFF87AE1,0x47AE147B, 0x3FCBB770,0xD4C517B9,
	0xBFF851EB,0x851EB852, 0x3FCBFEC0,0x48DA6523,
	0xBFF828F5,0xC28F5C29, 0x3FCC46C7,0x355909C1,
	0xBFF80000,0x00000000, 0x3FCC8F87,0x724B5C1D,
	0xBFF7D70A,0x3D70A3D7, 0x3FCCD902,0xDC7A2F1B,
	0xBFF7AE14,0x7AE147AE, 0x3FCD233B,0x557906A1,
	0xBFF7851E,0xB851EB85, 0x3FCD6E32,0xC3B26BB0,
	0xBFF75C28,0xF5C28F5C, 0x3FCDB9EB,0x12746030,
	0xBFF73333,0x33333333, 0x3FCE0666,0x31FCF2C8,
	0xBFF70A3D,0x70A3D70A, 0x3FCE53A6,0x1786F313,
	0xBFF6E147,0xAE147AE1, 0x3FCEA1AC,0xBD56C680,
	0xBFF6B851,0xEB851EB8, 0x3FCEF07C,0x22C75E39,
	0xBFF68F5C,0x28F5C28F, 0x3FCF4016,0x4C574E67,
	0xBFF66666,0x66666666, 0x3FCF907D,0x43B60715,
	0xBFF63D70,0xA3D70A3D, 0x3FCFE1B3,0x17D12F2E,
	0xBFF6147A,0xE147AE14, 0x3FD019DC,0xEE7110E0,
	0xBFF5EB85,0x1EB851EC, 0x3FD04349,0xD63DC704,
	0xBFF5C28F,0x5C28F5C3, 0x3FD06D21,0x52CB9D41,
	0xBFF59999,0x9999999A, 0x3FD09764,0x7651F5AD,
	0xBFF570A3,0xD70A3D71, 0x3FD0C214,0x55C9B65A,
	0xBFF547AE,0x147AE148, 0x3FD0ED32,0x08F46082,
	0xBFF51EB8,0x51EB851F, 0x3FD118BE,0xAA6339F2,
	0xBFF4F5C2,0x8F5C28F6, 0x3FD144BB,0x577E88E7,
	0xBFF4CCCC,0xCCCCCCCD, 0x3FD17129,0x308CE281,
	0xBFF4A3D7,0x0A3D70A4, 0x3FD19E09,0x58BA8C05,
	0xBFF47AE1,0x47AE147B, 0x3FD1CB5C,0xF620EF1F,
	0xBFF451EB,0x851EB852, 0x3FD1F925,0x31CE214D,
	0xBFF428F5,0xC28F5C29, 0x3FD22763,0x37CC7EAB,
	0xBFF40000,0x00000000, 0x3FD25618,0x372A584F,
	0xBFF3D70A,0x3D70A3D7, 0x3FD28545,0x6201B66B,
	0xBFF3AE14,0x7AE147AE, 0x3FD2B4EB,0xED802E61,
	0xBFF3851E,0xB851EB85, 0x3FD2E50D,0x11EECCFF,
	0xBFF35C28,0xF5C28F5C, 0x3FD315AA,0x0ABA1522,
	0xBFF33333,0x33333333, 0x3FD346C4,0x167A12DF,
	0xBFF30A3D,0x70A3D70A, 0x3FD3785C,0x76FA8377,
	0xBFF2E147,0xAE147AE1, 0x3FD3AA74,0x7143124B,
	0xBFF2B851,0xEB851EB8, 0x3FD3DD0D,0x4D9FAAFC,
	0xBFF28F5C,0x28F5C28F, 0x3FD41028,0x57A8E0F5,
	0xBFF26666,0x66666666, 0x3FD443C6,0xDE4C6C98,
	0xBFF23D70,0xA3D70A3D, 0x3FD477EA,0x33D5BE3C,
	0xBFF2147A,0xE147AE14, 0x3FD4AC93,0xADF6A741,
	0xBFF1EB85,0x1EB851EC, 0x3FD4E1C4,0xA5D0196A,
	0xBFF1C28F,0x5C28F5C3, 0x3FD5177E,0x77FAFCB5,
	0xBFF19999,0x9999999A, 0x3FD54DC2,0x84911BF1,
	0xBFF170A3,0xD70A3D71, 0x3FD58492,0x2F36284C,
	0xBFF147AE,0x147AE148, 0x3FD5BBEE,0xDF20D40E,
	0xBFF11EB8,0x51EB851F, 0x3FD5F3D9,0xFF2404C6,
	0xBFF0F5C2,0x8F5C28F6, 0x3FD62C54,0xFDB81D17,
	0xBFF0CCCC,0xCCCCCCCD, 0x3FD66561,0x4D045E75,
	0xBFF0A3D7,0x0A3D70A4, 0x3FD69F00,0x62E862FE,
	0xBFF07AE1,0x47AE147B, 0x3FD6D933,0xB905AFB6,
	0xBFF051EB,0x851EB852, 0x3FD713FC,0xCCC95F67,
	0xBFF028F5,0xC28F5C29, 0x3FD74F5D,0x1F75E65B,
	0xBFF00000,0x00000000, 0x3FD78B56,0x362CEF38,
	0xBFEFAE14,0x7AE147AE, 0x3FD7C7E9,0x99F9513C,
	0xBFEF5C28,0xF5C28F5C, 0x3FD80518,0xD7D9201A,
	0xBFEF0A3D,0x70A3D70A, 0x3FD842E5,0x80C7D5BA,
	0xBFEEB851,0xEB851EB8, 0x3FD88151,0x29C89622,
	0xBFEE6666,0x66666666, 0x3FD8C05D,0x6BF08DC0,
	0xBFEE147A,0xE147AE14, 0x3FD9000B,0xE4716A6D,
	0xBFEDC28F,0x5C28F5C3, 0x3FD9405E,0x34A3EF55,
	0xBFED70A3,0xD70A3D71, 0x3FD98156,0x0212A425,
	0xBFED1EB8,0x51EB851F, 0x3FD9C2F4,0xF6849FA4,
	0xBFECCCCC,0xCCCCCCCD, 0x3FDA053C,0xC0086E1E,
	0xBFEC7AE1,0x47AE147B, 0x3FDA482F,0x10FF13D7,
	0xBFEC28F5,0xC28F5C29, 0x3FDA8BCD,0xA0272BCD,
	0xBFEBD70A,0x3D70A3D7, 0x3FDAD01A,0x28A8231C,
	0xBFEB851E,0xB851EB85, 0x3FDB1516,0x6A1D9143,
	0xBFEB3333,0x33333333, 0x3FDB5AC4,0x28A2AD9E,
	0xBFEAE147,0xAE147AE1, 0x3FDBA125,0x2CDDE255,
	0xBFEA8F5C,0x28F5C28F, 0x3FDBE83B,0x440C7D1A,
	0xBFEA3D70,0xA3D70A3D, 0x3FDC3008,0x400E7DF6,
	0xBFE9EB85,0x1EB851EC, 0x3FDC788D,0xF7728474,
	0xBFE99999,0x9999999A, 0x3FDCC1CE,0x4581DB88,
	0xBFE947AE,0x147AE148, 0x3FDD0BCB,0x0A4CA463,
	0xBFE8F5C2,0x8F5C28F6, 0x3FDD5686,0x2AB620A0,
	0xBFE8A3D7,0x0A3D70A4, 0x3FDDA201,0x90811C13,
	0xBFE851EB,0x851EB852, 0x3FDDEE3F,0x2A5C767A,
	0xBFE80000,0x00000000, 0x3FDE3B40,0xEBEFCD7E,
	0xBFE7AE14,0x7AE147AE, 0x3FDE8908,0xCDE84743,
	0xBFE75C28,0xF5C28F5C, 0x3FDED798,0xCE057DDF,
	0xBFE70A3D,0x70A3D70A, 0x3FDF26F2,0xEF268C13,
	0xBFE6B851,0xEB851EB8, 0x3FDF7719,0x39573B94,
	0xBFE66666,0x66666666, 0x3FDFC80D,0xB9DD5542,
	0xBFE6147A,0xE147AE14, 0x3FE00CE9,0x41A309CC,
	0xBFE5C28F,0x5C28F5C3, 0x3FE03634,0xD6B9DBDD,
	0xBFE570A3,0xD70A3D71, 0x3FE05FEA,0xAAD5A0BE,
	0xBFE51EB8,0x51EB851F, 0x3FE08A0B,0xCF512550,
	0xBFE4CCCC,0xCCCCCCCD, 0x3FE0B499,0x584682EA,
	0xBFE47AE1,0x47AE147B, 0x3FE0DF94,0x5C9630CE,
	0xBFE428F5,0xC28F5C29, 0x3FE10AFD,0xF5EE27D7,
	0xBFE3D70A,0x3D70A3D7, 0x3FE136D7,0x40D1187E,
	0xBFE3851E,0xB851EB85, 0x3FE16321,0x5C9DB371,
	0xBFE33333,0x33333333, 0x3FE18FDD,0x6B9604E3,
	0xBFE2E147,0xAE147AE1, 0x3FE1BD0C,0x92E6E2D2,
	0xBFE28F5C,0x28F5C28F, 0x3FE1EAAF,0xFAAF6E5C,
	0xBFE23D70,0xA3D70A3D, 0x3FE218C8,0xCE08A877,
	0xBFE1EB85,0x1EB851EC, 0x3FE24758,0x3B0D1A19,
	0xBFE19999,0x9999999A, 0x3FE2765F,0x72E0901C,
	0xBFE147AE,0x147AE148, 0x3FE2A5DF,0xA9B7EB07,
	0xBFE0F5C2,0x8F5C28F6, 0x3FE2D5DA,0x16E102ED,
	0xBFE0A3D7,0x0A3D70A4, 0x3FE3064F,0xF4CA9F9D,
	0xBFE051EB,0x851EB852, 0x3FE33742,0x810C854E,
	0xBFE00000,0x00000000, 0x3FE368B2,0xFC6F960A,
	0xBFDF5C28,0xF5C28F5C, 0x3FE39AA2,0xAAF607F6,
	0xBFDEB851,0xEB851EB8, 0x3FE3CD12,0xD3E3B0C7,
	0xBFDE147A,0xE147AE14, 0x3FE40004,0xC1C6668C,
	0xBFDD70A3,0xD70A3D71, 0x3FE43379,0xC27E7600,
	0xBFDCCCCC,0xCCCCCCCD, 0x3FE46773,0x27472EA9,
	0xBFDC28F5,0xC28F5C29, 0x3FE49BF2,0x44BF84EF,
	0xBFDB851E,0xB851EB85, 0x3FE4D0F8,0x72F2CA6E,
	0xBFDAE147,0xAE147AE1, 0x3FE50687,0x0D617CB6,
	0xBFDA3D70,0xA3D70A3D, 0x3FE53C9F,0x730A2AB1,
	0xBFD99999,0x9999999A, 0x3FE57343,0x067270EE,
	0xBFD8F5C2,0x8F5C28F6, 0x3FE5AA73,0x2DB00D0E,
	0xBFD851EB,0x851EB852, 0x3FE5E231,0x52720888,
	0xBFD7AE14,0x7AE147AE, 0x3FE61A7E,0xE209FAFF,
	0xBFD70A3D,0x70A3D70A, 0x3FE6535D,0x4D756470,
	0xBFD66666,0x66666666, 0x3FE68CCE,0x09671F71,
	0xBFD5C28F,0x5C28F5C3, 0x3FE6C6D2,0x8E50EBB5,
	0xBFD51EB8,0x51EB851F, 0x3FE7016C,0x586D1129,
	0xBFD47AE1,0x47AE147B, 0x3FE73C9C,0xE7C81BCE,
	0xBFD3D70A,0x3D70A3D7, 0x3FE77865,0xC04AB0AB,
	0xBFD33333,0x33333333, 0x3FE7B4C8,0x69C37C05,
	0xBFD28F5C,0x28F5C28F, 0x3FE7F1C6,0x6FF13921,
	0xBFD1EB85,0x1EB851EC, 0x3FE82F61,0x628CD3D9,
	0xBFD147AE,0x147AE148, 0x3FE86D9A,0xD553A443,
	0xBFD0A3D7,0x0A3D70A4, 0x3FE8AC74,0x6011C4A6,
	0xBFD00000,0x00000000, 0x3FE8EBEF,0x9EAC820B,
	0xBFCEB851,0xEB851EB8, 0x3FE92C0E,0x312CE7A9,
	0xBFCD70A3,0xD70A3D71, 0x3FE96CD1,0xBBCA6572,
	0xBFCC28F5,0xC28F5C29, 0x3FE9AE3B,0xE6F59209,
	0xBFCAE147,0xAE147AE1, 0x3FE9F04E,0x5F630862,
	0xBFC99999,0x9999999A, 0x3FEA330A,0xD6166159,
	0xBFC851EB,0x851EB852, 0x3FEA7673,0x006D4985,
	0xBFC70A3D,0x70A3D70A, 0x3FEABA88,0x982AB390,
	0xBFC5C28F,0x5C28F5C3, 0x3FEAFF4D,0x5B82275F,
	0xBFC47AE1,0x47AE147B, 0x3FEB44C3,0x0D232E50,
	0xBFC33333,0x33333333, 0x3FEB8AEB,0x7444DCE0,
	0xBFC1EB85,0x1EB851EC, 0x3FEBD1C8,0x5CB179FC,
	0xBFC0A3D7,0x0A3D70A4, 0x3FEC195B,0x96D2444E,
	0xBFBEB851,0xEB851EB8, 0x3FEC61A6,0xF7BB55D8,
	0xBFBC28F5,0xC28F5C29, 0x3FECAAAC,0x5937A61E,
	0xBFB99999,0x9999999A, 0x3FECF46D,0x99D52B3A,
	0xBFB70A3D,0x70A3D70A, 0x3FED3EEC,0x9CF11A26,
	0xBFB47AE1,0x47AE147B, 0x3FED8A2B,0x4AC44685,
	0xBFB1EB85,0x1EB851EC, 0x3FEDD62B,0x906FA24C,
	0xBFAEB851,0xEB851EB8, 0x3FEE22EF,0x6008DD87,
	0xBFA99999,0x9999999A, 0x3FEE7078,0xB0A726A6,
	0xBFA47AE1,0x47AE147B, 0x3FEEBEC9,0x7E700B8D,
	0xBF9EB851,0xEB851EB8, 0x3FEF0DE3,0xCAA47BCF,
	0xBF947AE1,0x47AE147B, 0x3FEF5DC9,0x9BADEC5B,
	0xBF847AE1,0x47AE147B, 0x3FEFAE7C,0xFD2B9CFE,
	0x00000000,0x00000000, 0x3FF00000,0x00000000,
	0x3F847AE1,0x47AE147B, 0x3FF0292A,0x5D2F2226,
	0x3F947AE1,0x47AE147B, 0x3FF052BE,0xA3EC0132,
	0x3F9EB851,0xEB851EB8, 0x3FF07CBD,0xE4B58641,
	0x3FA47AE1,0x47AE147B, 0x3FF0A729,0x32C7B125,
	0x3FA99999,0x9999999A, 0x3FF0D201,0xA422A433,
	0x3FAEB851,0xEB851EB8, 0x3FF0FD48,0x5191C228,
	0x3FB1EB85,0x1EB851EC, 0x3FF128FE,0x56B2DE6A,
	0x3FB47AE1,0x47AE147B, 0x3FF15524,0xD1FD7FBD,
	0x3FB70A3D,0x70A3D70A, 0x3FF181BC,0xE4CA35AD,
	0x3FB99999,0x9999999A, 0x3FF1AEC7,0xB35A00D4,
	0x3FBC28F5,0xC28F5C29, 0x3FF1DC46,0x64DDCE2D,
	0x3FBEB851,0xEB851EB8, 0x3FF20A3A,0x237E05AC,
	0x3FC0A3D7,0x0A3D70A4, 0x3FF238A4,0x1C622C3F,
	0x3FC1EB85,0x1EB851EC, 0x3FF26785,0x7FB8997E,
	0x3FC33333,0x33333333, 0x3FF296DF,0x80BE4122,
	0x3FC47AE1,0x47AE147B, 0x3FF2C6B3,0x55C69097,
	0x3FC5C28F,0x5C28F5C3, 0x3FF2F702,0x384360B7,
	0x3FC70A3D,0x70A3D70A, 0x3FF327CD,0x64CCFC08,
	0x3FC851EB,0x851EB852, 0x3FF35916,0x1B2A3990,
	0x3FC99999,0x9999999A, 0x3FF38ADD,0x9E58AC8D,
	0x3FCAE147,0xAE147AE1, 0x3FF3BD25,0x3494E939,
	0x3FCC28F5,0xC28F5C29, 0x3FF3EFEE,0x2762DED6,
	0x3FCD70A3,0xD70A3D71, 0x3FF42339,0xC3964733,
	0x3FCEB851,0xEB851EB8, 0x3FF45709,0x595B2BEA,
	0x3FD00000,0x00000000, 0x3FF48B5E,0x3C3E8186,
	0x3FD0A3D7,0x0A3D70A4, 0x3FF4C039,0xC336D8D3,
	0x3FD147AE,0x147AE148, 0x3FF4F59D,0x48AD2681,
	0x3FD1EB85,0x1EB851EC, 0x3FF52B8A,0x2A85A16B,
	0x3FD28F5C,0x28F5C28F, 0x3FF56201,0xCA28B7A4,
	0x3FD33333,0x33333333, 0x3FF59905,0x8C8C1A96,
	0x3FD3D70A,0x3D70A3D7, 0x3FF5D096,0xDA3BE264,
	0x3FD47AE1,0x47AE147B, 0x3FF608B7,0x1F63C8D5,
	0x3FD51EB8,0x51EB851F, 0x3FF64167,0xCBD87BF5,
	0x3FD5C28F,0x5C28F5C3, 0x3FF67AAA,0x532108BD,
	0x3FD66666,0x66666666, 0x3FF6B480,0x2C805DEC,
	0x3FD70A3D,0x70A3D70A, 0x3FF6EEEA,0xD2FEE75F,
	0x3FD7AE14,0x7AE147AE, 0x3FF729EB,0xC574421D,
	0x3FD851EB,0x851EB852, 0x3FF76584,0x86910958,
	0x3FD8F5C2,0x8F5C28F6, 0x3FF7A1B6,0x9CE8BCB1,
	0x3FD99999,0x9999999A, 0x3FF7DE83,0x92FBBFE0,
	0x3FDA3D70,0xA3D70A3D, 0x3FF81BEC,0xF741742B,
	0x3FDAE147,0xAE147AE1, 0x3FF859F4,0x5C326BCB,
	0x3FDB851E,0xB851EB85, 0x3FF8989B,0x5852B794,
	0x3FDC28F5,0xC28F5C29, 0x3FF8D7E3,0x863C4F1C,
	0x3FDCCCCC,0xCCCCCCCD, 0x3FF917CE,0x84A993B5,
	0x3FDD70A3,0xD70A3D71, 0x3FF9585D,0xF67FEE5D,
	0x3FDE147A,0xE147AE14, 0x3FF99993,0x82DA8915,
	0x3FDEB851,0xEB851EB8, 0x3FF9DB70,0xD51523C0,
	0x3FDF5C28,0xF5C28F5C, 0x3FFA1DF7,0x9CD704E5,
	0x3FE00000,0x00000000, 0x3FFA6129,0x8E1E069C,
	0x3FE051EB,0x851EB852, 0x3FFAA508,0x6149BFDE,
	0x3FE0A3D7,0x0A3D70A4, 0x3FFAE995,0xD326CA98,
	0x3FE0F5C2,0x8F5C28F6, 0x3FFB2ED3,0xA4FA26B9,
	0x3FE147AE,0x147AE148, 0x3FFB74C3,0x9C8CBA8F,
	0x3FE19999,0x9999999A, 0x3FFBBB67,0x8436F0B5,
	0x3FE1EB85,0x1EB851EC, 0x3FFC02C1,0x2AEC73F0,
	0x3FE23D70,0xA3D70A3D, 0x3FFC4AD2,0x6448092F,
	0x3FE28F5C,0x28F5C28F, 0x3FFC939D,0x08978818,
	0x3FE2E147,0xAE147AE1, 0x3FFCDD22,0xF4E7F250,
	0x3FE33333,0x33333333, 0x3FFD2766,0x0B11A9EF,
	0x3FE3851E,0xB851EB85, 0x3FFD7268,0x31C4C757,
	0x3FE3D70A,0x3D70A3D7, 0x3FFDBE2B,0x54958EC8,
	0x3FE428F5,0xC28F5C29, 0x3FFE0AB1,0x64090605,
	0x3FE47AE1,0x47AE147B, 0x3FFE57FC,0x55A1AA5A,
	0x3FE4CCCC,0xCCCCCCCD, 0x3FFEA60E,0x23EC4752,
	0x3FE51EB8,0x51EB851F, 0x3FFEF4E8,0xCE8CEE7A,
	0x3FE570A3,0xD70A3D71, 0x3FFF448E,0x5A4C107E,
	0x3FE5C28F,0x5C28F5C3, 0x3FFF9500,0xD123B7FC,
	0x3FE6147A,0xE147AE14, 0x3FFFE642,0x424CE65B,
	0x3FE66666,0x66666666, 0x40001C2A,0x61268987,
	0x3FE6B851,0xEB851EB8, 0x4000459D,0x3581E6C0,
	0x3FE70A3D,0x70A3D70A, 0x40006F7A,0xADDC4114,
	0x3FE75C28,0xF5C28F5C, 0x400099C3,0xDC94317C,
	0x3FE7AE14,0x7AE147AE, 0x4000C479,0xD6CA39D0,
	0x3FE80000,0x00000000, 0x4000EF9D,0xB467DCF8,
	0x3FE851EB,0x851EB852, 0x40011B30,0x9026C95C,
	0x3FE8A3D7,0x0A3D70A4, 0x40014733,0x879815CE,
	0x3FE8F5C2,0x8F5C28F6, 0x400173A7,0xBB2B9101,
	0x3FE947AE,0x147AE148, 0x4001A08E,0x4E3723E4,
	0x3FE99999,0x9999999A, 0x4001CDE8,0x66FE46E9,
	0x3FE9EB85,0x1EB851EC, 0x4001FBB7,0x2EB98A8C,
	0x3FEA3D70,0xA3D70A3D, 0x400229FB,0xD19E3331,
	0x3FEA8F5C,0x28F5C28F, 0x400258B7,0x7EE5E89E,
	0x3FEAE147,0xAE147AE1, 0x400287EB,0x68D67933,
	0x3FEB3333,0x33333333, 0x4002B798,0xC4C9B11F,
	0x3FEB851E,0xB851EB85, 0x4002E7C0,0xCB3545C2,
	0x3FEBD70A,0x3D70A3D7, 0x40031864,0xB7B2D56E,
	0x3FEC28F5,0xC28F5C29, 0x40034985,0xC907FBBC,
	0x3FEC7AE1,0x47AE147B, 0x40037B25,0x412E7AAA,
	0x3FECCCCC,0xCCCCCCCD, 0x4003AD44,0x655C78BC,
	0x3FED1EB8,0x51EB851F, 0x4003DFE4,0x7E0CD449,
	0x3FED70A3,0xD70A3D71, 0x40041306,0xD7078C43,
	0x3FEDC28F,0x5C28F5C3, 0x400446AC,0xBF6A3E8D,
	0x3FEE147A,0xE147AE14, 0x40047AD7,0x89B0BC3E,
	0x3FEE6666,0x66666666, 0x4004AF88,0x8BBDB3F0,
	0x3FEEB851,0xEB851EB8, 0x4004E4C1,0x1EE37254,
	0x3FEF0A3D,0x70A3D70A, 0x40051A82,0x9FECB951,
	0x3FEF5C28,0xF5C28F5C, 0x400550CE,0x6F25ADE5,
	0x3FEFAE14,0x7AE147AE, 0x400587A5,0xF064DCF9,
	0x3FF00000,0x00000000, 0x4005BF0A,0x8B145769,
	0x3FF028F5,0xC28F5C29, 0x4005F6FD,0xAA3AE580,
	0x3FF051EB,0x851EB852, 0x40062F80,0xBC85521F,
	0x3FF07AE1,0x47AE147B, 0x40066895,0x344FCDCC,
	0x3FF0A3D7,0x0A3D70A4, 0x4006A23C,0x87AF69E8,
	0x3FF0CCCC,0xCCCCCCCD, 0x4006DC78,0x307BAC49,
	0x3FF0F5C2,0x8F5C28F6, 0x40071749,0xAC583B7E,
	0x3FF11EB8,0x51EB851F, 0x400752B2,0x7CBEA3E9,
	0x3FF147AE,0x147AE148, 0x40078EB4,0x2708360B,
	0x3FF170A3,0xD70A3D71, 0x4007CB50,0x3477FE27,
	0x3FF19999,0x9999999A, 0x40080888,0x3244D593,
	0x3FF1C28F,0x5C28F5C3, 0x4008465D,0xB1A38DEB,
	0x3FF1EB85,0x1EB851EC, 0x400884D2,0x47D13670,
	0x3FF2147A,0xE147AE14, 0x4008C3E7,0x8E1D7BCF,
	0x3FF23D70,0xA3D70A3D, 0x4009039F,0x21F522A8,
	0x3FF26666,0x66666666, 0x400943FA,0xA4EC9CF1,
	0x3FF28F5C,0x28F5C28F, 0x400984FB,0xBCCABAAD,
	0x3FF2B851,0xEB851EB8, 0x4009C6A4,0x13937614,
	0x3FF2E147,0xAE147AE1, 0x400A08F5,0x5792DB8E,
	0x3FF30A3D,0x70A3D70A, 0x400A4BF1,0x3B680DB1,
	0x3FF33333,0x33333333, 0x400A8F99,0x761065A4,
	0x3FF35C28,0xF5C28F5C, 0x400AD3EF,0xC2F2B016,
	0x3FF3851E,0xB851EB85, 0x400B18F5,0xE1EA8727,
	0x3FF3AE14,0x7AE147AE, 0x400B5EAD,0x9753C982,
	0x3FF3D70A,0x3D70A3D7, 0x400BA518,0xAC162EFB,
	0x3FF40000,0x00000000, 0x400BEC38,0xEDB0FAF0,
	0x3FF428F5,0xC28F5C29, 0x400C3410,0x2E46CCCA,
	0x3FF451EB,0x851EB852, 0x400C7CA0,0x44A98EDF,
	0x3FF47AE1,0x47AE147B, 0x400CC5EB,0x0C66840E,
	0x3FF4A3D7,0x0A3D70A4, 0x400D0FF2,0x65D27452,
	0x3FF4CCCC,0xCCCCCCCD, 0x400D5AB8,0x3615F8B4,
	0x3FF4F5C2,0x8F5C28F6, 0x400DA63E,0x6739E6DA,
	0x3FF51EB8,0x51EB851F, 0x400DF286,0xE833DC89,
	0x3FF547AE,0x147AE148, 0x400E3F93,0xACF2EB74,
	0x3FF570A3,0xD70A3D71, 0x400E8D66,0xAE6C659C,
	0x3FF59999,0x9999999A, 0x400EDC01,0xEAA8CAA6,
	0x3FF5C28F,0x5C28F5C3, 0x400F2B67,0x64D0D670,
	0x3FF5EB85,0x1EB851EC, 0x400F7B99,0x253AB13B,
	0x3FF6147A,0xE147AE14, 0x400FCC99,0x397741C6,
	0x3FF63D70,0xA3D70A3D, 0x40100F34,0xDA2FD0DB,
	0x3FF66666,0x66666666, 0x40103886,0x57115A47,
	0x3FF68F5C,0x28F5C28F, 0x40106242,0x222970CF,
	0x3FF6B851,0xEB851EB8, 0x40108C69,0x4CF9F8AE,
	0x3FF6E147,0xAE147AE1, 0x4010B6FC,0xEBC48723,
	0x3FF70A3D,0x70A3D70A, 0x4010E1FE,0x159174EF,
	0x3FF73333,0x33333333, 0x40110D6D,0xE4370309,
	0x3FF75C28,0xF5C28F5C, 0x4011394D,0x746091A9,
	0x3FF7851E,0xB851EB85, 0x4011659D,0xE595E9E7,
	0x3FF7AE14,0x7AE147AE, 0x40119260,0x5A429A20,
	0x3FF7D70A,0x3D70A3D7, 0x4011BF95,0xF7BD6542,
	0x3FF80000,0x00000000, 0x4011ED3F,0xE64FC541,
	0x3FF828F5,0xC28F5C29, 0x40121B5F,0x513D80D6,
	0x3FF851EB,0x851EB852, 0x401249F5,0x66CC54C7,
	0x3FF87AE1,0x47AE147B, 0x40127903,0x584BB0E9,
	0x3FF8A3D7,0x0A3D70A4, 0x4012A88A,0x5A1C88FD,
	0x3FF8CCCC,0xCCCCCCCD, 0x4012D88B,0xA3B939BD,
	0x3FF8F5C2,0x8F5C28F6, 0x40130908,0x6FBD8222,
	0x3FF91EB8,0x51EB851F, 0x40133A01,0xFBEE9144,
	0x3FF947AE,0x147AE148, 0x40136B79,0x894328E3,
	0x3FF970A3,0xD70A3D71, 0x40139D70,0x5BEBD4E2,
	0x3FF99999,0x9999999A, 0x4013CFE7,0xBB5B37EC,
	0x3FF9C28F,0x5C28F5C3, 0x401402E0,0xF24E6D6E,
	0x3FF9EB85,0x1EB851EC, 0x4014365D,0x4ED58120,
	0x3FFA147A,0xE147AE14, 0x40146A5E,0x225BFC5B,
	0x3FFA3D70,0xA3D70A3D, 0x40149EE4,0xC1B18972,
	0x3FFA6666,0x66666666, 0x4014D3F2,0x8512AD3E,
	0x3FFA8F5C,0x28F5C28F, 0x40150988,0xC831971D,
	0x3FFAB851,0xEB851EB8, 0x40153FA8,0xEA3F07A7,
	0x3FFAE147,0xAE147AE1, 0x40157654,0x4DF34E3C,
	0x3FFB0A3D,0x70A3D70A, 0x4015AD8C,0x59975DBF,
	0x3FFB3333,0x33333333, 0x4015E552,0x770DF8A7,
	0x3FFB5C28,0xF5C28F5C, 0x40161DA8,0x13DCF4AB,
	0x3FFB851E,0xB851EB85, 0x4016568E,0xA1369647,
	0x3FFBAE14,0x7AE147AE, 0x40169007,0x94030451,
	0x3FFBD70A,0x3D70A3D7, 0x4016CA14,0x64E9D3DF,
	0x3FFC0000,0x00000000, 0x401704B6,0x905BACBF,
	0x3FFC28F5,0xC28F5C29, 0x40173FEF,0x969C06BB,
	0x3FFC51EB,0x851EB852, 0x40177BC0,0xFBCAFFF1,
	0x3FFC7AE1,0x47AE147B, 0x4017B82C,0x47EF4C73,
	0x3FFCA3D7,0x0A3D70A4, 0x4017F533,0x07003F80,
	0x3FFCCCCC,0xCCCCCCCD, 0x401832D6,0xC8EFEE85,
	0x3FFCF5C2,0x8F5C28F6, 0x40187119,0x21B56E3B,
	0x3FFD1EB8,0x51EB851F, 0x4018AFFB,0xA9572A1B,
	0x3FFD47AE,0x147AE148, 0x4018EF7F,0xFBF55668,
	0x3FFD70A3,0xD70A3D71, 0x40192FA7,0xB9D47D23,
	0x3FFD9999,0x9999999A, 0x40197074,0x87682618,
	0x3FFDC28F,0x5C28F5C3, 0x4019B1E8,0x0D5D9A61,
	0x3FFDEB85,0x1EB851EC, 0x4019F403,0xF8A6C392,
	0x3FFE147A,0xE147AE14, 0x401A36C9,0xFA8526E1,
	0x3FFE3D70,0xA3D70A3D, 0x401A7A3B,0xC894FC97,
	0x3FFE6666,0x66666666, 0x401ABE5B,0x1CD863F6,
	0x3FFE8F5C,0x28F5C28F, 0x401B0329,0xB5C2B407,
	0x3FFEB851,0xEB851EB8, 0x401B48A9,0x5643E976,
	0x3FFEE147,0xAE147AE1, 0x401B8EDB,0xC5D431E1,
	0x3FFF0A3D,0x70A3D70A, 0x401BD5C2,0xD07F94D4,
	0x3FFF3333,0x33333333, 0x401C1D60,0x46F1BAC1,
	0x3FFF5C28,0xF5C28F5C, 0x401C65B5,0xFE81D254,
	0x3FFF851E,0xB851EB85, 0x401CAEC5,0xD13E944E,
	0x3FFFAE14,0x7AE147AE, 0x401CF891,0x9DFA665C,
	0x3FFFD70A,0x3D70A3D7, 0x401D431B,0x48579D1C,
	0x40000000,0x00000000, 0x401D8E64,0xB8D4DDAE,
	0x4000147A,0xE147AE14, 0x401DDA6F,0xDCD99F23,
	0x400028F5,0xC28F5C29, 0x401E273E,0xA6C2CC1C,
	0x40003D70,0xA3D70A3D, 0x401E74D3,0x0DEF84D2,
	0x400051EB,0x851EB852, 0x401EC32F,0x0ECE021B,
	0x40006666,0x66666666, 0x401F1254,0xAAE89965,
	0x40007AE1,0x47AE147B, 0x401F6245,0xE8F2E25E,
	0x40008F5C,0x28F5C28F, 0x401FB304,0xD4D6FE42,
	0x4000A3D7,0x0A3D70A4, 0x40200249,0xBFE180C0,
	0x4000B851,0xEB851EB8, 0x40202B7A,0x001B3FD8,
	0x4000CCCC,0xCCCCCCCD, 0x40205514,0x39081D4F,
	0x4000E147,0xAE147AE1, 0x40207F19,0x7B4DFA21,
	0x4000F5C2,0x8F5C28F6, 0x4020A98A,0xDA50324D,
	0x40010A3D,0x70A3D70A, 0x4020D469,0x6C36A98D,
	0x40011EB8,0x51EB851F, 0x4020FFB6,0x49F4EA56,
	0x40013333,0x33333333, 0x40212B72,0x8F51570E,
	0x400147AE,0x147AE148, 0x4021579F,0x5AEC6DDB,
	0x40015C28,0xF5C28F5C, 0x4021843D,0xCE481F09,
	0x400170A3,0xD70A3D71, 0x4021B14F,0x0DCF366E,
	0x4001851E,0xB851EB85, 0x4021DED4,0x40DCD7C4,
	0x40019999,0x9999999A, 0x40220CCE,0x91C40E5F,
	0x4001AE14,0x7AE147AE, 0x40223B3F,0x2DD7703A,
	0x4001C28F,0x5C28F5C3, 0x40226A27,0x4570D4CE,
	0x4001D70A,0x3D70A3D7, 0x40229988,0x0BF91F9C,
	0x4001EB85,0x1EB851EC, 0x4022C962,0xB7F01EE4,
	0x40020000,0x00000000, 0x4022F9B8,0x82F47E81,
	0x4002147A,0xE147AE14, 0x40232A8A,0xA9CBCF4D,
	0x400228F5,0xC28F5C29, 0x40235BDA,0x6C6AA323,
	0x40023D70,0xA3D70A3D, 0x40238DA9,0x0DFCBDB6,
	0x400251EB,0x851EB852, 0x4023BFF7,0xD4ED5A92,
	0x40026666,0x66666666, 0x4023F2C8,0x0AEF884D,
	0x40027AE1,0x47AE147B, 0x4024261A,0xFD069950,
	0x40028F5C,0x28F5C28F, 0x402459F1,0xFB8EAA38,
	0x4002A3D7,0x0A3D70A4, 0x40248E4E,0x5A453E51,
	0x4002B851,0xEB851EB8, 0x4024C331,0x7051F208,
	0x4002CCCC,0xCCCCCCCD, 0x4024F89C,0x984F43EC,
	0x4002E147,0xAE147AE1, 0x40252E91,0x3053741D,
	0x4002F5C2,0x8F5C28F6, 0x40256510,0x99F97ABC,
	0x40030A3D,0x70A3D70A, 0x40259C1C,0x3A6A153E,
	0x40031EB8,0x51EB851F, 0x4025D3B5,0x7A64EB33,
	0x40033333,0x33333333, 0x40260BDD,0xC649CA68,
	0x400347AE,0x147AE148, 0x40264496,0x8E21FAFC,
	0x40035C28,0xF5C28F5C, 0x40267DE1,0x45A9AB42,
	0x400370A3,0xD70A3D71, 0x4026B7BF,0x64597414,
	0x4003851E,0xB851EB85, 0x4026F232,0x656FF56E,
	0x40039999,0x9999999A, 0x40272D3B,0xC7FB8BF6,
	0x4003AE14,0x7AE147AE, 0x402768DD,0x0EE41F51,
	0x4003C28F,0x5C28F5C3, 0x4027A517,0xC0F509E1,
	0x4003D70A,0x3D70A3D7, 0x4027E1ED,0x68E719CB,
	0x4003EB85,0x1EB851EC, 0x40281F5F,0x956AABF2,
	0x40040000,0x00000000, 0x40285D6F,0xD931E0BB,
	0x4004147A,0xE147AE14, 0x40289C1F,0xCAFAEB45,
	0x400428F5,0xC28F5C29, 0x4028DB71,0x059A7B04,
	0x40043D70,0xA3D70A3D, 0x40291B65,0x2806402E,
	0x400451EB,0x851EB852, 0x40295BFD,0xD55F8B4D,
	0x40046666,0x66666666, 0x40299D3C,0xB4FE07FD,
	0x40047AE1,0x47AE147B, 0x4029DF23,0x727A9378,
	0x40048F5C,0x28F5C28F, 0x402A21B3,0xBDBA2ECC,
	0x4004A3D7,0x0A3D70A4, 0x402A64EF,0x4AF90D74,
	0x4004B851,0xEB851EB8, 0x402AA8D7,0xD2D5C02B,
	0x4004CCCC,0xCCCCCCCD, 0x402AED6F,0x125C7CB5,
	0x4004E147,0xAE147AE1, 0x402B32B6,0xCB128270,
	0x4004F5C2,0x8F5C28F6, 0x402B78B0,0xC3019C73,
	0x40050A3D,0x70A3D70A, 0x402BBF5E,0xC4C3C10E,
	0x40051EB8,0x51EB851F, 0x402C06C2,0x9F8ECF68,
	0x40053333,0x33333333, 0x402C4EDE,0x27406B1D,
	0x400547AE,0x147AE148, 0x402C97B3,0x3469F697,
	0x40055C28,0xF5C28F5C, 0x402CE143,0xA45CABFA,
	0x400570A3,0xD70A3D71, 0x402D2B91,0x5935D56E,
	0x4005851E,0xB851EB85, 0x402D769E,0x39EB24A0,
	0x40059999,0x9999999A, 0x402DC26C,0x32572A3E,
	0x4005AE14,0x7AE147AE, 0x402E0EFD,0x3345ED44,
	0x4005C28F,0x5C28F5C3, 0x402E5C53,0x3281A2F8,
	0x4005D70A,0x3D70A3D7, 0x402EAA70,0x2ADF8753,
	0x4005EB85,0x1EB851EC, 0x402EF956,0x1C4CD6C1,
	0x40060000,0x00000000, 0x402F4907,0x0BDBE8FD,
	0x4006147A,0xE147AE14, 0x402F9985,0x03D16DE2,
	0x400628F5,0xC28F5C29, 0x402FEAD2,0x13B1CC22,
	0x40063D70,0xA3D70A3D, 0x40301E78,0x28275135,
	0x400651EB,0x851EB852, 0x403047F0,0xE9EA35AF,
	0x40066666,0x66666666, 0x403071D4,0x5EEC2242,
	0x40067AE1,0x47AE147B, 0x40309C23,0x99B2EC67,
	0x40068F5C,0x28F5C28F, 0x4030C6DF,0xAF86B764,
	0x4006A3D7,0x0A3D70A4, 0x4030F209,0xB8790D89,
	0x4006B851,0xEB851EB8, 0x40311DA2,0xCF6C0BA0,
	0x4006CCCC,0xCCCCCCCD, 0x403149AC,0x12199EE6,
	0x4006E147,0xAE147AE1, 0x40317626,0xA11AD589,
	0x4006F5C2,0x8F5C28F6, 0x4031A313,0x9FEF4212,
	0x40070A3D,0x70A3D70A, 0x4031D074,0x350471BF,
	0x40071EB8,0x51EB851F, 0x4031FE49,0x89BD761F,
	0x40073333,0x33333333, 0x40322C94,0xCA7A81FE,
	0x400747AE,0x147AE148, 0x40325B57,0x26A09A06,
	0x40075C28,0xF5C28F5C, 0x40328A91,0xD0A15904,
	0x400770A3,0xD70A3D71, 0x4032BA45,0xFE02C84D,
	0x4007851E,0xB851EB85, 0x4032EA74,0xE7674C2F,
	0x40079999,0x9999999A, 0x40331B1F,0xC895A4EB,
	0x4007AE14,0x7AE147AE, 0x40334C47,0xE081041C,
	0x4007C28F,0x5C28F5C3, 0x40337DEE,0x71513717,
	0x4007D70A,0x3D70A3D7, 0x4033B014,0xC06AE622,
	0x4007EB85,0x1EB851EC, 0x4033E2BC,0x1677E90A,
	0x40080000,0x00000000, 0x403415E5,0xBF6FB106,
	0x4008147A,0xE147AE14, 0x40344993,0x0A9FC85A,
	0x400828F5,0xC28F5C29, 0x40347DC5,0x4AB467CB,
	0x40083D70,0xA3D70A3D, 0x4034B27D,0xD5C12220,
	0x400851EB,0x851EB852, 0x4034E7BE,0x0549A60D,
	0x40086666,0x66666666, 0x40351D87,0x364A9682,
	0x40087AE1,0x47AE147B, 0x403553DA,0xC94279E3,
	0x40088F5C,0x28F5C28F, 0x40358ABA,0x223AC012,
	0x4008A3D7,0x0A3D70A4, 0x4035C226,0xA8D0DFDF,
	0x4008B851,0xEB851EB8, 0x4035FA21,0xC83F8BB7,
	0x4008CCCC,0xCCCCCCCD, 0x403632AC,0xEF67FE3D,
	0x4008E147,0xAE147AE1, 0x40366BC9,0x90DB5E95,
	0x4008F5C2,0x8F5C28F6, 0x4036A579,0x22E43D0D,
	0x40090A3D,0x70A3D70A, 0x4036DFBD,0x1F902804,
	0x40091EB8,0x51EB851F, 0x40371A97,0x04B9599C,
	0x40093333,0x33333333, 0x40375608,0x54107E2E,
	0x400947AE,0x147AE148, 0x40379212,0x9326940E,
	0x40095C28,0xF5C28F5C, 0x4037CEB7,0x4B76E48B,
	0x400970A3,0xD70A3D71, 0x40380BF8,0x0A7116BF,
	0x4009851E,0xB851EB85, 0x403849D6,0x61835C2A,
	0x40099999,0x9999999A, 0x40388853,0xE624B794,
	0x4009AE14,0x7AE147AE, 0x4038C772,0x31DF5E46,
	0x4009C28F,0x5C28F5C3, 0x40390732,0xE25B3419,
	0x4009D70A,0x3D70A3D7, 0x40394797,0x99686251,
	0x4009EB85,0x1EB851EC, 0x403988A1,0xFD0A09EE,
	0x400A0000,0x00000000, 0x4039CA53,0xB781114B,
	0x400A147A,0xE147AE14, 0x403A0CAE,0x77570DB5,
	0x400A28F5,0xC28F5C29, 0x403A4FB3,0xEF6948FE,
	0x400A3D70,0xA3D70A3D, 0x403A9365,0xD6F3E365,
	0x400A51EB,0x851EB852, 0x403AD7C5,0xE99D1243,
	0x400A6666,0x66666666, 0x403B1CD5,0xE7807B7B,
	0x400A7AE1,0x47AE147B, 0x403B6297,0x953AAE4F,
	0x400A8F5C,0x28F5C28F, 0x403BA90C,0xBBF4B98A,
	0x400AA3D7,0x0A3D70A4, 0x403BF037,0x296FDFAD,
	0x400AB851,0xEB851EB8, 0x403C3818,0xB0116903,
	0x400ACCCC,0xCCCCCCCD, 0x403C80B3,0x26EE9453,
	0x400AE147,0xAE147AE1, 0x403CCA08,0x69D8A616,
	0x400AF5C2,0x8F5C28F6, 0x403D141A,0x596916ED,
	0x400B0A3D,0x70A3D70A, 0x403D5EEA,0xDB0DE12F,
	0x400B1EB8,0x51EB851F, 0x403DAA7B,0xD915EE62,
	0x400B3333,0x33333333, 0x403DF6CF,0x42BDA468,
	0x400B47AE,0x147AE148, 0x403E43E7,0x0C3B933A,
	0x400B5C28,0xF5C28F5C, 0x403E91C5,0x2ECD4305,
	0x400B70A3,0xD70A3D71, 0x403EE06B,0xA8C42370,
	0x400B851E,0xB851EB85, 0x403F2FDC,0x7D929BF4,
	0x400B9999,0x9999999A, 0x403F8019,0xB5D93E09,
	0x400BAE14,0x7AE147AE, 0x403FD125,0x5F741909,
	0x400BC28F,0x5C28F5C3, 0x40401180,0xC6C4184F,
	0x400BD70A,0x3D70A3D7, 0x40403AD8,0x2C488AC8,
	0x400BEB85,0x1EB851EC, 0x40406499,0xEF3750EC,
	0x400C0000,0x00000000, 0x40408EC7,0x21396BDB,
	0x400C147A,0xE147AE14, 0x4040B960,0xD6B7F267,
	0x400C28F5,0xC28F5C29, 0x4040E468,0x26E32487,
	0x400C3D70,0xA3D70A3D, 0x40410FDE,0x2BB99109,
	0x400C51EB,0x851EB852, 0x40413BC4,0x020F4DBB,
	0x400C6666,0x66666666, 0x4041681A,0xC99541FD,
	0x400C7AE1,0x47AE147B, 0x404194E3,0xA4E08449,
	0x400C8F5C,0x28F5C28F, 0x4041C21F,0xB971CA7A,
	0x400CA3D7,0x0A3D70A4, 0x4041EFD0,0x2FBCED67,
	0x400CB851,0xEB851EB8, 0x40421DF6,0x33307FA8,
	0x400CCCCC,0xCCCCCCCD, 0x40424C92,0xF23D7807,
	0x400CE147,0xAE147AE1, 0x40427BA7,0x9E5EEF8A,
	0x400CF5C2,0x8F5C28F6, 0x4042AB35,0x6C21F382,
	0x400D0A3D,0x70A3D70A, 0x4042DB3D,0x932D6BA4,
	0x400D1EB8,0x51EB851F, 0x40430BC1,0x4E4A148C,
	0x400D3333,0x33333333, 0x40433CC1,0xDB6A8EA8,
	0x400D47AE,0x147AE148, 0x40436E40,0x7BB38202,
	0x400D5C28,0xF5C28F5C, 0x4043A03E,0x7383D6DB,
	0x400D70A3,0xD70A3D71, 0x4043D2BD,0x0A7D0388,
	0x400D851E,0xB851EB85, 0x404405BD,0x8B8B6F8F,
	0x400D9999,0x9999999A, 0x40443941,0x44EEEC81,
	0x400DAE14,0x7AE147AE, 0x40446D49,0x8843446C,
	0x400DC28F,0x5C28F5C3, 0x4044A1D7,0xAA88DE86,
	0x400DD70A,0x3D70A3D7, 0x4044D6ED,0x042D79E9,
	0x400DEB85,0x1EB851EC, 0x40450C8A,0xF114FEE5,
	0x400E0000,0x00000000, 0x404542B2,0xD0A266E7,
	0x400E147A,0xE147AE14, 0x40457966,0x05C0BB62,
	0x400E28F5,0xC28F5C29, 0x4045B0A5,0xF6EC2BD1,
	0x400E3D70,0xA3D70A3D, 0x4045E874,0x0E3B3B0A,
	0x400E51EB,0x851EB852, 0x404620D1,0xB9680458,
	0x400E6666,0x66666666, 0x404659C0,0x69D9983C,
	0x400E7AE1,0x47AE147B, 0x40469341,0x94AD7170,
	0x400E8F5C,0x28F5C28F, 0x4046CD56,0xB2C10218,
	0x400EA3D7,0x0A3D70A4, 0x40470801,0x40BB59B3,
	0x400EB851,0xEB851EB8, 0x40474342,0xBF16E3A7,
	0x400ECCCC,0xCCCCCCCD, 0x40477F1C,0xB22B3F1E,
	0x400EE147,0xAE147AE1, 0x4047BB90,0xA2372FF6,
	0x400EF5C2,0x8F5C28F6, 0x4047F8A0,0x1B6AA983,
	0x400F0A3D,0x70A3D70A, 0x4048364C,0xADF0F2EC,
	0x400F1EB8,0x51EB851F, 0x40487497,0xEDFAE5D6,
	0x400F3333,0x33333333, 0x4048B383,0x73C9473C,
	0x400F47AE,0x147AE148, 0x4048F310,0xDBB73B11,
	0x400F5C28,0xF5C28F5C, 0x40493341,0xC644D297,
	0x400F70A3,0xD70A3D71, 0x40497417,0xD821B614,
	0x400F851E,0xB851EB85, 0x4049B594,0xBA37E9C0,
	0x400F9999,0x9999999A, 0x4049F7BA,0x19B6AE9A,
	0x400FAE14,0x7AE147AE, 0x404A3A89,0xA81D7F0D,
	0x400FC28F,0x5C28F5C3, 0x404A7E05,0x1B472802,
	0x400FD70A,0x3D70A3D7, 0x404AC22E,0x2D74FE5B,
	0x400FEB85,0x1EB851EC, 0x404B0706,0x9D5A3169,
	0x40100000,0x00000000, 0x404B4C90,0x2E273A58,
	0x40100A3D,0x70A3D70A, 0x404B92CC,0xA795693B,
	0x4010147A,0xE147AE14, 0x404BD9BD,0xD5F28FA1,
	0x40101EB8,0x51EB851F, 0x404C2165,0x8A2CC94E,
	0x401028F5,0xC28F5C29, 0x404C69C5,0x99DE631E,
	0x40103333,0x33333333, 0x404CB2DF,0xDF59E0CA,
	0x40103D70,0xA3D70A3D, 0x404CFCB6,0x39B62159,
	0x401047AE,0x147AE148, 0x404D474A,0x8CDAA2F8,
	0x401051EB,0x851EB852, 0x404D929E,0xC18BE631,
	0x40105C28,0xF5C28F5C, 0x404DDEB4,0xC577F152,
	0x40106666,0x66666666, 0x404E2B8E,0x8B42F3B6,
	0x401070A3,0xD70A3D71, 0x404E792E,0x0A9409BD,
	0x40107AE1,0x47AE147B, 0x404EC795,0x40222178,
	0x4010851E,0xB851EB85, 0x404F16C6,0x2DC100C3,
	0x40108F5C,0x28F5C28F, 0x404F66C2,0xDA6E6C99,
	0x40109999,0x9999999A, 0x404FB78D,0x525F726F,
	0x4010A3D7,0x0A3D70A4, 0x40500493,0xD386E9C7,
	0x4010AE14,0x7AE147AE, 0x40502DC9,0xF7A2C99F,
	0x4010B851,0xEB851EB8, 0x4050576A,0x239953C7,
	0x4010C28F,0x5C28F5C3, 0x40508175,0x683766BB,
	0x4010CCCC,0xCCCCCCCD, 0x4050ABEC,0xD907C034,
	0x4010D70A,0x3D70A3D7, 0x4050D6D1,0x8C5A0B0E,
	0x4010E147,0xAE147AE1, 0x40510224,0x9B49FF2F,
	0x4010EB85,0x1EB851EC, 0x40512DE7,0x21C693D2,
	0x4010F5C2,0x8F5C28F6, 0x40515A1A,0x3E99444B,
	0x40110000,0x00000000, 0x405186BF,0x136D679D,
	0x40110A3D,0x70A3D70A, 0x4051B3D6,0xC4D79ACF,
	0x4011147A,0xE147AE14, 0x4051E162,0x7A5D3E69,
	0x40111EB8,0x51EB851F, 0x40520F63,0x5E7C0733,
	0x401128F5,0xC28F5C29, 0x40523DDA,0x9EB1A260,
	0x40113333,0x33333333, 0x40526CC9,0x6B836D7D,
	0x40113D70,0xA3D70A3D, 0x40529C30,0xF8864221,
	0x401147AE,0x147AE148, 0x4052CC12,0x7C6655BC,
	0x401151EB,0x851EB852, 0x4052FC6F,0x30EF2D8B,
	0x40115C28,0xF5C28F5C, 0x40532D48,0x5313A73C,
	0x40116666,0x66666666, 0x40535E9F,0x22F61600,
	0x401170A3,0xD70A3D71, 0x40539074,0xE3F074A9,
	0x40117AE1,0x47AE147B, 0x4053C2CA,0xDC9CACB0,
	0x4011851E,0xB851EB85, 0x4053F5A2,0x56DCF2C8,
	0x40118F5C,0x28F5C28F, 0x405428FC,0x9FE438B9,
	0x40119999,0x9999999A, 0x40545CDB,0x083EB514,
	0x4011A3D7,0x0A3D70A4, 0x4054913E,0xE3DA80C1,
	0x4011AE14,0x7AE147AE, 0x4054C629,0x8A104AE3,
	0x4011B851,0xEB851EB8, 0x4054FB9C,0x55AC22F0,
	0x4011C28F,0x5C28F5C3, 0x40553198,0xA4F65988,
	0x4011CCCC,0xCCCCCCCD, 0x4055681F,0xD9BC77FE,
	0x4011D70A,0x3D70A3D7, 0x40559F33,0x595A4F2F,
	0x4011E147,0xAE147AE1, 0x4055D6D4,0x8CC31D6A,
	0x4011EB85,0x1EB851EC, 0x40560F04,0xE08ACC09,
	0x4011F5C2,0x8F5C28F6, 0x405647C5,0xC4EF44AC,
	0x40120000,0x00000000, 0x40568118,0xADE1DEAA,
	0x40120A3D,0x70A3D70A, 0x4056BAFF,0x1310E498,
	0x4012147A,0xE147AE14, 0x4056F57A,0x6FF1325D,
	0x40121EB8,0x51EB851F, 0x4057308C,0x43C7EC0F,
	0x401228F5,0xC28F5C29, 0x40576C36,0x11B44DAC,
	0x40123333,0x33333333, 0x4057A879,0x60B9944F,
	0x40123D70,0xA3D70A3D, 0x4057E557,0xBBC900A6,
	0x401247AE,0x147AE148, 0x405822D2,0xB1CBF352,
	0x401251EB,0x851EB852, 0x405860EB,0xD5AE2320,
	0x40125C28,0xF5C28F5C, 0x40589FA4,0xBE67EDC9,
	0x40126666,0x66666666, 0x4058DEFF,0x0708C2FF,
	0x401270A3,0xD70A3D71, 0x40591EFC,0x4EC1AA6A,
	0x40127AE1,0x47AE147B, 0x40595F9E,0x38EFE497,
	0x4012851E,0xB851EB85, 0x4059A0E6,0x6D27A779,
	0x40128F5C,0x28F5C28F, 0x4059E2D6,0x973EF64F,
	0x40129999,0x9999999A, 0x405A2570,0x67589596,
	0x4012A3D7,0x0A3D70A4, 0x405A68B5,0x91EF1AFE,
	0x4012AE14,0x7AE147AE, 0x405AACA7,0xCFE01A19,
	0x4012B851,0xEB851EB8, 0x405AF148,0xDE776D8B,
	0x4012C28F,0x5C28F5C3, 0x405B369A,0x7F7A9D67,
	0x4012CCCC,0xCCCCCCCD, 0x405B7C9E,0x793462BB,
	0x4012D70A,0x3D70A3D7, 0x405BC356,0x968048FC,
	0x4012E147,0xAE147AE1, 0x405C0AC4,0xA6D66D21,
	0x4012EB85,0x1EB851EC, 0x405C52EA,0x7E575B17,
	0x4012F5C2,0x8F5C28F6, 0x405C9BC9,0xF5D80998,
	0x40130000,0x00000000, 0x405CE564,0xEAEDF51C,
	0x40130A3D,0x70A3D70A, 0x405D2FBD,0x3FFB59AA,
	0x4013147A,0xE147AE14, 0x405D7AD4,0xDC3B8C3D,
	0x40131EB8,0x51EB851F, 0x405DC6AD,0xABCF73F4,
	0x401328F5,0xC28F5C29, 0x405E1349,0x9FCA232E,
	0x40133333,0x33333333, 0x405E60AA,0xAE3D9163,
	0x40133D70,0xA3D70A3D, 0x405EAED2,0xD2477568,
	0x401347AE,0x147AE148, 0x405EFDC4,0x0C1E40F5,
	0x401351EB,0x851EB852, 0x405F4D80,0x611E3D66,
	0x40135C28,0xF5C28F5C, 0x405F9E09,0xDBD6CA7E,
	0x40136666,0x66666666, 0x405FEF62,0x8C17BEFD,
	0x401370A3,0xD70A3D71, 0x406020C6,0x437F75E2,
	0x40137AE1,0x47AE147B, 0x40604A44,0xF382E0C9,
	0x4013851E,0xB851EB85, 0x4060742E,0x66078D17,
	0x40138F5C,0x28F5C28F, 0x40609E83,0xADBA925B,
	0x40139999,0x9999999A, 0x4060C945,0xE00BBAFC,
	0x4013A3D7,0x0A3D70A4, 0x4060F476,0x15349E61,
	0x4013AE14,0x7AE147AE, 0x40612015,0x683FCD86,
	0x4013B851,0xEB851EB8, 0x40614C24,0xF71011E5,
	0x4013C28F,0x5C28F5C3, 0x406178A5,0xE267BF15,
	0x4013CCCC,0xCCCCCCCD, 0x4061A599,0x4DF01723,
	0x4013D70A,0x3D70A3D7, 0x4061D300,0x6040C226,
	0x4013E147,0xAE147AE1, 0x406200DC,0x42E758CC,
	0x4013EB85,0x1EB851EC, 0x40622F2E,0x226F027B,
	0x4013F5C2,0x8F5C28F6, 0x40625DF7,0x2E6826E3,
	0x40140000,0x00000000, 0x40628D38,0x9970338F,
	0x3FE00000,0x00000000, 0x3FFA6129,0x8E1E069C,
	0x3FF00000,0x00000000, 0x4005BF0A,0x8B145769,
	0x3FF80000,0x00000000, 0x4011ED3F,0xE64FC541,
	0x40000000,0x00000000, 0x401D8E64,0xB8D4DDAE,
	0x40040000,0x00000000, 0x40285D6F,0xD931E0BB,
	0x40080000,0x00000000, 0x403415E5,0xBF6FB106,
	0x400C0000,0x00000000, 0x40408EC7,0x21396BDB,
	0x40100000,0x00000000, 0x404B4C90,0x2E273A58,
	0x40120000,0x00000000, 0x40568118,0xADE1DEAA,
	0x40140000,0x00000000, 0x40628D38,0x9970338F,
	0x40160000,0x00000000, 0x406E9624,0x4F21BBF6,
	0x40180000,0x00000000, 0x407936DC,0x5690C08F,
	0x401A0000,0x00000000, 0x4084C922,0x10816C89,
	0x401C0000,0x00000000, 0x40912288,0x5AAEDDAA,
	0x401E0000,0x00000000, 0x409C402B,0x6EB1F6AD,
	0x40200000,0x00000000, 0x40A749EA,0x7D470C6E,
	0x40210000,0x00000000, 0x40B332C4,0xD2B7C4A1,
	0x40220000,0x00000000, 0x40BFA715,0x7C470F82,
	0x40230000,0x00000000, 0x40CA17DD,0x08C11DC1,
	0x40240000,0x00000000, 0x40D5829D,0xCF950560,
	0x40250000,0x00000000, 0x40E1BB70,0x15E84D3B,
	0x40260000,0x00000000, 0x40ED3C44,0x88EE4F7F,
	0x40270000,0x00000000, 0x40F819BC,0x560F6113,
	0x40280000,0x00000000, 0x4103DE16,0x54D37C9A,
	0x40290000,0x00000000, 0x411060C5,0x2565BA66,
	0x402A0000,0x00000000, 0x411B00B5,0x916AC955,
	0x402B0000,0x00000000, 0x41264290,0xBD5CAD8B,
	0x402C0000,0x00000000, 0x413259AC,0x48BF05D7,
	0x402D0000,0x00000000, 0x413E4127,0x437732B7,
	0x402E0000,0x00000000, 0x4148F0CC,0xAFAD2A87,
	0x402F0000,0x00000000, 0x41548F60,0x9E7B6BBE,
	0x40300000,0x00000000, 0x4160F2EB,0xD0A80020,
	0x40308000,0x00000000, 0x416BF1AB,0xEDB9FCBA,
	0x40310000,0x00000000, 0x41770934,0x8C0EA4F9,
	0x40318000,0x00000000, 0x4182FD6C,0x832E3C72,
	0x40320000,0x00000000, 0x418F4F22,0x091940BD,
	0x40328000,0x00000000, 0x4199CF5C,0x2F003C7E,
	0x40330000,0x00000000, 0x41A546D8,0xF9ED26E1,
	0x40338000,0x00000000, 0x41B18A2A,0xAE0AA052,
	0x40340000,0x00000000, 0x41BCEB08,0x8B68E804,
	0x40348000,0x00000000, 0x41C7D6C4,0xF0BCDD5C,
	0x40350000,0x00000000, 0x41D3A6E1,0xFD9EECFD,
	0x40358000,0x00000000, 0x41E03343,0x00327298,
	0x40360000,0x00000000, 0x41EAB5AD,0xB9C43600,
	0x40368000,0x00000000, 0x41F604B6,0x8CF05F66,
	0x40370000,0x00000000, 0x420226AF,0x33B1FDC1,
	0x40378000,0x00000000, 0x420DED16,0x5E84FAD6,
	0x40380000,0x00000000, 0x4218AB7F,0xB5475FB7,
	0x40388000,0x00000000, 0x4224563F,0xA7B34AF7,
	0x40390000,0x00000000, 0x4230C3D3,0x920962C9,
	0x40398000,0x00000000, 0x423BA406,0x8AAC2B6E,
	0x403A0000,0x00000000, 0x4246C932,0x696A6B5D,
	0x403A8000,0x00000000, 0x4252C8A8,0x6D70C9E9,
	0x403B0000,0x00000000, 0x425EF822,0xF7F6731D,
	0x403B8000,0x00000000, 0x426987A4,0xCAEED87A,
	0x403C0000,0x00000000, 0x42750BBA,0x3796379A,
	0x403C8000,0x00000000, 0x4281596E,0x2E20ED6C,
	0x403D0000,0x00000000, 0x428C9AAE,0x4631C056,
	0x403D8000,0x00000000, 0x42979487,0x9E85B948,
	0x403E0000,0x00000000, 0x42A37047,0x0AEC28ED,
	0x403E8000,0x00000000, 0x42B0063F,0x4E687BA2,
	0x403F0000,0x00000000, 0x42BA6B76,0x5D8CDF6D,
	0x403F8000,0x00000000, 0x42C5C788,0x39D357DD,
	0x40400000,0x00000000, 0x42D1F43F,0xCC4B662C,
	0x40404000,0x00000000, 0x42DD99EF,0x101DF23C,
	0x40408000,0x00000000, 0x42E866F3,0x4A725782,
	0x4040C000,0x00000000, 0x42F41DBD,0x6E3E063E,
	0x40410000,0x00000000, 0x4300953E,0x2F3A1EF7,
	0x40414000,0x00000000, 0x430B5738,0xE777C243,
	0x40418000,0x00000000, 0x431689E2,0x21BC8D5B,
	0x4041C000,0x00000000, 0x43229476,0xF5A23301,
	0x40420000,0x00000000, 0x432EA215,0xA1D20D76,
	0x40424000,0x00000000, 0x433940B4,0xACC4E544,
	0x40428000,0x00000000, 0x4344D13F,0xBB1A001A,
	0x4042C000,0x00000000, 0x43512939,0x19C201E5,
	0x40430000,0x00000000, 0x435C4B33,0x4617CC67,
	0x40434000,0x00000000, 0x43675302,0x5A61BFE5,
	0x40438000,0x00000000, 0x43733A43,0xD282A519,
	0x4043C000,0x00000000, 0x437FB371,0x61577EDD,
	0x40440000,0x00000000, 0x438A220D,0x397972EB,
	0x40444000,0x00000000, 0x43958B03,0xE6797728,
	0x40448000,0x00000000, 0x43A1C25C,0x88DF6862,
	0x4044C000,0x00000000, 0x43AD47AE,0xCF343BC7,
	0x40450000,0x00000000, 0x43B82325,0x58201159,
	0x40454000,0x00000000, 0x43C3E5D8,0x3907A3DC,
	0x40458000,0x00000000, 0x43D0672A,0x3C9EB871,
	0x4045C000,0x00000000, 0x43DB0B40,0xACA0085D,
	0x40460000,0x00000000, 0x43E64B41,0xC6D37832,
	0x40464000,0x00000000, 0x43F260D6,0x845DA877,
	0x40468000,0x00000000, 0x43FE4CF7,0x66FE49BE,
	0x4046C000,0x00000000, 0x4408FA89,0xAACDC2F3,
	0x40470000,0x00000000, 0x44149767,0xBC0483E3,
	0x40474000,0x00000000, 0x4420F989,0xF8A5B043,
	0x40478000,0x00000000, 0x442BFC95,0x1EB8BB76,
	0x4047C000,0x00000000, 0x44371233,0x24E55FF0,
	0x40480000,0x00000000, 0x444304D6,0xAECA254B,
	0x40484000,0x00000000, 0x444F5B5B,0x96E0E83F,
	0x40488000,0x00000000, 0x4459D970,0x10884251,
	0x4048C000,0x00000000, 0x44654F27,0xBA858A92,
	0x40490000,0x00000000, 0x44719103,0xE4080B45,
	0x40494000,0x00000000, 0x447CF653,0x19C5751A,
	0x40498000,0x00000000, 0x4487E013,0xCD114461,
	0x4049C000,0x00000000, 0x4493AE8E,0x53C5C183,
	0x404A0000,0x00000000, 0x44A03996,0x528E074C,
	0x404A4000,0x00000000, 0x44AAC01B,0x892A053E,
	0x404A8000,0x00000000, 0x44B60D4F,0x6FDAC731,
	0x404AC000,0x00000000, 0x44C22DC5,0x86AA59DC,
	0x404B0000,0x00000000, 0x44CDF8C5,0xAF17BA3B,
	0x404B4000,0x00000000, 0x44D8B521,0xA1575C36,
	0x404B8000,0x00000000, 0x44E45E30,0x76D61699,
	0x404BC000,0x00000000, 0x44F0CA5F,0x56995724,
	0x404C0000,0x00000000, 0x44FBAED1,0x6A6E0DA7,
	0x404C4000,0x00000000, 0x4506D218,0x043213F2,
	0x404C8000,0x00000000, 0x4512CFFD,0xFEBDE1A1,
	0x404CC000,0x00000000, 0x451F043A,0x8DE1068B,
	0x404D0000,0x00000000, 0x4529919C,0xABEFCB69,
	0x404D4000,0x00000000, 0x453513F1,0xE2BAE577,
	0x404D8000,0x00000000, 0x45416034,0x5C9953E3,
	0x404DC000,0x00000000, 0x454CA5D9,0x74C7236B,
	0x404E0000,0x00000000, 0x45579DBC,0x9DC53C66,
	0x404E4000,0x00000000, 0x456377DE,0x0EEA46D4,
	0x404E8000,0x00000000, 0x45700C81,0x0D464097,
	0x404EC000,0x00000000, 0x457A75C7,0x328A6C4A,
	0x404F0000,0x00000000, 0x4585D009,0x394C5C27,
	0x404F4000,0x00000000, 0x4591FB42,0x6DEF2C39,
	0x404F8000,0x00000000, 0x459DA57D,0xE8F107A8,
	0x404FC000,0x00000000, 0x45A8707A,0x72A1734B,
	0x40500000,0x00000000, 0x45B42598,0x2CF597CD,
	0x40502000,0x00000000, 0x45C09BB7,0xC3748815,
	0x40504000,0x00000000, 0x45CB61E5,0xCA3A5E31,
	0x40506000,0x00000000, 0x45D692AF,0x03E6F5B0,
	0x40508000,0x00000000, 0x45E29BB8,0x25DFCF87,
	0x4050A000,0x00000000, 0x45EEAE0B,0x9E421D1C,
	0x4050C000,0x00000000, 0x45F94A90,0xDB0D6FE2,
	0x4050E000,0x00000000, 0x4604D960,0x90EF2239,
	0x40510000,0x00000000, 0x46112FEC,0x759586FD,
	0x40512000,0x00000000, 0x461C563F,0x6C1356B4,
	0x40514000,0x00000000, 0x46275C1D,0xC469E3AF,
	0x40516000,0x00000000, 0x463341C5,0xBF963CE7,
	0x40518000,0x00000000, 0x463FBFD2,0x19C43B04,
	0x4051A000,0x00000000, 0x464A2C41,0x6493BA80,
	0x4051C000,0x00000000, 0x4655936D,0x44E1A146,
	0x4051E000,0x00000000, 0x4661C94B,0xAFE692C7,
	0x40520000,0x00000000, 0x466D531D,0x8A7EE79C,
	0x40522000,0x00000000, 0x46782C92,0x06CD1D60,
	0x40524000,0x00000000, 0x4683ED9D,0x24A2D51B,
	0x40526000,0x00000000, 0x46906D91,0xD30DCDE0,
	0x40528000,0x00000000, 0x469B15CF,0xE5B6E17B,
	0x4052A000,0x00000000, 0x46A653F6,0x35117C78,
	0x4052C000,0x00000000, 0x46B26803,0x8C2C0E00,
	0x4052E000,0x00000000, 0x46BE58CC,0x27502323,
	0x40530000,0x00000000, 0x46C9044A,0x73545D48,
	0x40532000,0x00000000, 0x46D49F71,0xFBFC0AD9,
	0x40534000,0x00000000, 0x46E1002A,0xB6218B38,
	0x40536000,0x00000000, 0x46EC0782,0x925582B3,
	0x40538000,0x00000000, 0x46F71B35,0x40CBF921,
	0x4053A000,0x00000000, 0x47030C43,0xBF8CCA52,
	0x4053C000,0x00000000, 0x470F6799,0xEA9C414A,
	0x4053E000,0x00000000, 0x4719E387,0xE16485E8,
	0x40540000,0x00000000, 0x47255779,0xB984F3EB,
	0x40542000,0x00000000, 0x473197DF,0xC6928977,
	0x40544000,0x00000000, 0x473D01A2,0x10C44AA4,
	0x40546000,0x00000000, 0x4747E966,0x4BCC6BD3,
	0x40548000,0x00000000, 0x4753B63D,0xA8E91210,
	0x4054A000,0x00000000, 0x47603FEC,0x1D2F9220,
	0x4054C000,0x00000000, 0x476ACA8D,0x6B0116B8,
	0x4054E000,0x00000000, 0x477615EB,0xAE1E65D3,
	0x40550000,0x00000000, 0x478234DE,0x9E0C74E9,
	0x40552000,0x00000000, 0x478E0479,0x8FA440E0,
	0x40554000,0x00000000, 0x4798BEC7,0x503CA477,
	0x40556000,0x00000000, 0x47A46624,0x5FB1A8AC,
	0x40558000,0x00000000, 0x47B0D0ED,0xA9796B90,
	0x4055A000,0x00000000, 0x47BBB9A0,0x80F78D1D,
	0x4055C000,0x00000000, 0x47C6DB01,0x18477245,
	0x4055E000,0x00000000, 0x47D2D756,0x6D26536B,
	0x40560000,0x00000000, 0x47DF1056,0xDC7BF22D,
	0x40562000,0x00000000, 0x47E99B98,0x7155FE28,
	0x40564000,0x00000000, 0x47F51C2C,0xC3433801,
	0x40566000,0x00000000, 0x480166FD,0x3030B0D9,
	0x40568000,0x00000000, 0x480CB108,0xFFBEC164,
	0x4056A000,0x00000000, 0x4817A6F5,0x355242DC,
	0x4056C000,0x00000000, 0x48237F78,0x0991B584,
	0x4056E000,0x00000000, 0x483012C5,0x3D8D219E,
	0x40570000,0x00000000, 0x483A801C,0x0EA8AC4D,
	0x40572000,0x00000000, 0x4845D88D,0x8ACAC826,
	0x40574000,0x00000000, 0x48520247,0xCC4C46C1,
	0x40576000,0x00000000, 0x485DB111,0x451085D5,
	0x40578000,0x00000000, 0x48687A05,0x53328015,
	0x4057A000,0x00000000, 0x48742D75,0xFCC87AD2,
	0x4057C000,0x00000000, 0x4880A233,0xDEE4F9BB,
	0x4057E000,0x00000000, 0x488B6C96,0xD80F107F,
	0x40580000,0x00000000, 0x48969B7F,0x55B808BA,
	0x40582000,0x00000000, 0x48A2A2FC,0x2B43BE44,
	0x40584000,0x00000000, 0x48AEBA06,0x4644060A,
	0x40586000,0x00000000, 0x48B95470,0xE2EA9DB8,
	0x40588000,0x00000000, 0x48C4E184,0x933D9364,
	0x4058A000,0x00000000, 0x48D136A2,0x6F2E8B18,
	0x4058C000,0x00000000, 0x48DC614F,0xE2531841,
	0x4058E000,0x00000000, 0x48E7653C,0xBCC25D25,
	0x40590000,0x00000000, 0x48F3494A,0x9B171BF5,
	0x40592000,0x00000000, 0x48FFCC37,0xA76F9E76,
	0x40594000,0x00000000, 0x490A3679,0x8B9D969B,
	0x40596000,0x00000000, 0x49159BD9,0xEC154EC8,
	0x40598000,0x00000000, 0x4921D03D,0x8C0C04AF,
	0x4059A000,0x00000000, 0x492D5E90,0xBC8BD761,
	0x4059C000,0x00000000, 0x49383602,0x6385C974,
	0x4059E000,0x00000000, 0x4943F565,0x18D3D2F8,
	0x405A0000,0x00000000, 0x495073FB,0xE9AC901D,
	0x405A2000,0x00000000, 0x495B2063,0x3E4AD321,
	0x405A4000,0x00000000, 0x49665CAE,0x0969F286,
	0x405A6000,0x00000000, 0x49726F33,0x6141DA0F,
	0x405A8000,0x00000000, 0x497E64A5,0x8639CAE8,
	0x405AA000,0x00000000, 0x49890E0F,0x0ABD0B2B,
	0x405AC000,0x00000000, 0x4994A77F,0x5F9B50F9,
	0x405AE000,0x00000000, 0x49A106CE,0x0A1DD99B,
	0x405B0000,0x00000000, 0x49AC1274,0x4A3A28E3,
	0x405B2000,0x00000000, 0x49B7243A,0xE1217BC2,
	0x405B4000,0x00000000, 0x49C313B3,0xB6978E85,
	0x405B6000,0x00000000, 0x49CF73DD,0x06286A13,
	0x405B8000,0x00000000, 0x49D9EDA3,0xA31E587E,
	0x405BA000,0x00000000, 0x49E55FCE,0xF82F9F2A,
	0x405BC000,0x00000000, 0x49F19EBE,0x56B56453,
	0x405BE000,0x00000000, 0x49FD0CF5,0x721E1715,
	0x405C0000,0x00000000, 0x4A07F2BC,0x6E599B7E,
	0x405C2000,0x00000000, 0x4A13BDEF,0xFE345805,
	0x405C4000,0x00000000, 0x4A204644,0x610DF2FF,
	0x405C6000,0x00000000, 0x4A2AD503,0x60E07179,
	0x405C8000,0x00000000, 0x4A361E8B,0x490AC4E6,
	0x405CA000,0x00000000, 0x4A423BFA,0x7AECE97D,
	0x405CC000,0x00000000, 0x4A4E1032,0x01F299B3,
	0x405CE000,0x00000000, 0x4A58C870,0xC36F2A0F,
	0x405D0000,0x00000000, 0x4A646E1B,0x637BEAF5,
	0x405D2000,0x00000000, 0x4A70D77E,0x8BA91AFA,
	0x405D4000,0x00000000, 0x4A7BC473,0xCFEDE104,
	0x405D6000,0x00000000, 0x4A86E3ED,0xA705C221,
	0x405D8000,0x00000000, 0x4A92DEB1,0xB9C85E2D,
	0x405DA000,0x00000000, 0x4A9F1C77,0xE59F267F,
	0x405DC000,0x00000000, 0x4AA9A598,0x1CA67D10,
	0x405DE000,0x00000000, 0x4AB5246A,0xDA6FE687,
	0x405E0000,0x00000000, 0x4AC16DC8,0xA9EF670B,
	0x405E2000,0x00000000, 0x4ACCBC3C,0xE8CC8037,
	0x405E4000,0x00000000, 0x4AD7B031,0x66942309,
	0x405E6000,0x00000000, 0x4AE38714,0xFC0AAE39,
	0x405E8000,0x00000000, 0x4AF0190B,0xE03150A7,
	0x405EA000,0x00000000, 0x4AFA8A74,0xF37A3B89,
	0x405EC000,0x00000000, 0x4B05E115,0x2F9A8119,
	0x405EE000,0x00000000, 0x4B12094F,0xE8744FC6,
	0x405F0000,0x00000000, 0x4B1DBCA9,0x263F8487,
	0x405F2000,0x00000000, 0x4B288393,0xED995AD5,
	0x405F4000,0x00000000, 0x4B343556,0xDEE93BEE,
	0x405F6000,0x00000000, 0x4B40A8B2,0x828828F5,
	0x405F8000,0x00000000, 0x4B4B774C,0x12967DFA,
	0x405FA000,0x00000000, 0x4B56A453,0x18873D6F,
	0x405FC000,0x00000000, 0x4B62AA43,0x06E922C2,
	0x405FE000,0x00000000, 0x4B6EC605,0x9BAA9964,
	0x40600000,0x00000000, 0x4B795E54,0xC5DD4217,
	0x40601000,0x00000000, 0x4B84E9AB,0xC3428FC2,
	0x40602000,0x00000000, 0x4B913D5B,0x07929253,
	0x40603000,0x00000000, 0x4B9C6C64,0xAA863BD3,
	0x40604000,0x00000000, 0x4BA76E5F,0x44CE9C2F,
	0x40605000,0x00000000, 0x4BB350D2,0x662A4469,
	0x40606000,0x00000000, 0x4BBFD8A2,0x0C3CC006,
	0x40607000,0x00000000, 0x4BCA40B5,0xB025449B,
	0x40608000,0x00000000, 0x4BD5A449,0xDD5CCAB9,
	0x40609000,0x00000000, 0x4BE1D732,0x1E5E5FE0,
	0x4060A000,0x00000000, 0x4BED6A08,0x67193D6C,
	0x4060B000,0x00000000, 0x4BF83F76,0x6FB9E947,
	0x4060C000,0x00000000, 0x4C03FD30,0x16C9D64C,
	0x4060D000,0x00000000, 0x4C107A68,0x8174F605,
	0x4060E000,0x00000000, 0x4C1B2AFA,0xB7F7FC66,
	0x4060F000,0x00000000, 0x4C266569,0x453096F6,
	0x40610000,0x00000000, 0x4C327666,0x04B71D6D,
	0x40611000,0x00000000, 0x4C3E7083,0x85890112,
	0x40612000,0x00000000, 0x4C4917D7,0x728472A7,
	0x40613000,0x00000000, 0x4C54AF8F,0xE81C20F2,
	0x40614000,0x00000000, 0x4C610D73,0xF59D48DF,
	0x40615000,0x00000000, 0x4C6C1D6A,0x48112ABF,
	0x40616000,0x00000000, 0x4C772D44,0x07457C1D,
	0x40617000,0x00000000, 0x4C831B26,0x950C45E2,
	0x40618000,0x00000000, 0x4C8F8024,0xEB633B1D,
	0x40619000,0x00000000, 0x4C99F7C3,0x573FA4E3,
	0x4061A000,0x00000000, 0x4CA56827,0x77CA4725,
	0x4061B000,0x00000000, 0x4CB1A59F,0x957C4DA5,
	0x4061C000,0x00000000, 0x4CBD184D,0x3F8C34F5,
	0x4061D000,0x00000000, 0x4CC7FC16,0x3624A908,
	0x4061E000,0x00000000, 0x4CD3C5A5,0x54D381AF,
	0x4061F000,0x00000000, 0x4CE04C9F,0x1F206A37,
	0x40620000,0x00000000, 0x4CEADF7D,0x6C5FBB7A,
	0x40621000,0x00000000, 0x4CF6272E,0x41EFF102,
	0x40622000,0x00000000, 0x4D024319,0x1E60BE32,
	0x40623000,0x00000000, 0x4D0E1BEF,0x07CB81B3,
	0x40624000,0x00000000, 0x4D18D21D,0xFC67715A,
	0x40625000,0x00000000, 0x4D247615,0x836B4039,
	0x40626000,0x00000000, 0x4D30DE11,0xFE284410,
	0x40627000,0x00000000, 0x4D3BCF4B,0x58F6E506,
	0x40628000,0x00000000, 0x4D46ECDD,0xB1C8C6E7,
	0x40629000,0x00000000, 0x4D52E60F,0xE5C2B091,
	0x4062A000,0x00000000, 0x4D5F289D,0xAB234C40,
	0x4062B000,0x00000000, 0x4D69AF9B,0xAF66EC63,
	0x4062C000,0x00000000, 0x4D752CAC,0x29822593,
	0x4062D000,0x00000000, 0x4D817496,0xCADE4071,
	0x4062E000,0x00000000, 0x4D8CC775,0x31A4F011,
	0x4062F000,0x00000000, 0x4D97B971,0x32F2BF9C,
	0x40630000,0x00000000, 0x4DA38EB4,0xE77DDDDD,
	0x40631000,0x00000000, 0x4DB01F54,0xF6275EFD,
	0x40632000,0x00000000, 0x4DBA94D1,0xE2925340,
	0x40633000,0x00000000, 0x4DC5E9A0,0x2907EDDB,
	0x40634000,0x00000000, 0x4DD2105A,0xC3794C20,
	0x40635000,0x00000000, 0x4DDDC845,0x8E41CB9F,
	0x40636000,0x00000000, 0x4DE88D26,0x434A71B6,
	0x40637000,0x00000000, 0x4DF43D3A,0xD48ADF74,
	0x40638000,0x00000000, 0x4E00AF33,0xAF5B2D7A,
	0x40639000,0x00000000, 0x4E0B8205,0x7B71EE1D,
	0x4063A000,0x00000000, 0x4E16AD2A,0x4DAC90E3,
	0x4063B000,0x00000000, 0x4E22B18C,0xB9EB8F14,
	0x4063C000,0x00000000, 0x4E2ED209,0xA0495E91,
	0x4063D000,0x00000000, 0x4E39683C,0x8566C699,
	0x4063E000,0x00000000, 0x4E44F1D6,0x223BCF5A,
	0x4063F000,0x00000000, 0x4E514416,0x3FC786E6,
	0x40640000,0x00000000, 0x4E5C777D,0xC65C9488,
	0x40641000,0x00000000, 0x4E677785,0x5DF29B7F,
	0x40642000,0x00000000, 0x4E73585D,0x21F52AD4,
	0x40643000,0x00000000, 0x4E7FE511,0x4A0F7329,
	0x40644000,0x00000000, 0x4E8A4AF5,0xD3B99D59,
	0x40645000,0x00000000, 0x4E95ACBD,0x1A00E054,
	0x40646000,0x00000000, 0x4EA1DE29,0x67ECAFCC,
	0x40647000,0x00000000, 0x4EAD7584,0x8BE5FA4C,
	0x40648000,0x00000000, 0x4EB848EE,0x2CD9E02A,
	0x40649000,0x00000000, 0x4EC404FE,0x1FB48E53,
	0x4064A000,0x00000000, 0x4ED080D7,0x9B61580F,
	0x4064B000,0x00000000, 0x4EDB3596,0x545B1D51,
	0x4064C000,0x00000000, 0x4EE66E27,0xE9B9AB09,
	0x4064D000,0x00000000, 0x4EF27D9B,0x77A45640,
	0x4064E000,0x00000000, 0x4EFE7C66,0x270C39F4,
	0x4064F000,0x00000000, 0x4F0921A3,0xAC27CE67,
	0x40650000,0x00000000, 0x4F14B7A3,0x96B8BFF6,
	0x40651000,0x00000000, 0x4F21141C,0x79A2EB78,
	0x40652000,0x00000000, 0x4F2C2864,0x8D85AB83,
	0x40653000,0x00000000, 0x4F373650,0xB49817C0,
	0x40654000,0x00000000, 0x4F43229C,0x5C0D358F,
	0x40655000,0x00000000, 0x4F4F8C71,0x9C2B477D,
	0x40656000,0x00000000, 0x4F5A01E6,0xFF52EFB1,
	0x40657000,0x00000000, 0x4F657083,0x399A257D,
	0x40658000,0x00000000, 0x4F71AC83,0x83F35FBD,
	0x40659000,0x00000000, 0x4F7D23A9,0x7AC8AB1E,
	0x4065A000,0x00000000, 0x4F880573,0xA499F824,
	0x4065B000,0x00000000, 0x4F93CD5D,0xADF2F278,
	0x4065C000,0x00000000, 0x4FA052FC,0x585E98A2,
	0x4065D000,0x00000000, 0x4FAAE9FB,0x8F1739DF,
	0x4065E000,0x00000000, 0x4FB62FD4,0x9A1E79F8,
	0x4065F000,0x00000000, 0x4FC24A3A,0x897D65CA,
	0x40660000,0x00000000, 0x4FCE27B0,0xA2F86833,
	0x40661000,0x00000000, 0x4FD8DBCE,0xFC9E91B7,
	0x40662000,0x00000000, 0x4FE47E12,0xC0B6846F,
	0x40663000,0x00000000, 0x4FF0E4A8,0x01F72969,
	0x40664000,0x00000000, 0x4FFBDA27,0x1DB91986,
	0x40665000,0x00000000, 0x5006F5D1,0x39ECCBC1,
	0x40666000,0x00000000, 0x5012ED70,0xF2346931,
	0x40667000,0x00000000, 0x501F34C8,0x2EE1C4BE,
	0x40668000,0x00000000, 0x5029B9A3,0x2B1D8885,
	0x40669000,0x00000000, 0x503534F0,0xB1BBA718,
	0x4066A000,0x00000000, 0x50417B67,0x94066E66,
	0x4066B000,0x00000000, 0x504CD2B1,0xDBFD4B90,
	0x4066C000,0x00000000, 0x5057C2B4,0x9BD687CA,
	0x4066D000,0x00000000, 0x50639657,0xCD14652F,
	0x4066E000,0x00000000, 0x507025A0,0x80643D67,
	0x4066F000,0x00000000, 0x507A9F32,0xDD84CA29,
	0x40670000,0x00000000, 0x5085F22E,0x785FF70E,
	0x40671000,0x00000000, 0x50921768,0x5E6DABA5,
	0x40672000,0x00000000, 0x509DD3E6,0x7EDBD369,
	0x40673000,0x00000000, 0x50A896BC,0x55BAC44C,
	0x40674000,0x00000000, 0x50B44521,0xDEE0E199,
	0x40675000,0x00000000, 0x50C0B5B7,0x665B81D4,
	0x40676000,0x00000000, 0x50CB8CC3,0x14434B52,
	0x40677000,0x00000000, 0x50D6B604,0xF6808676,
	0x40678000,0x00000000, 0x50E2B8D9,0x45670408,
	0x40679000,0x00000000, 0x50EEDE12,0x55F49388,
	0x4067A000,0x00000000, 0x50F97228,0x23092B4D,
	0x4067B000,0x00000000, 0x5104FA03,0xB1678640,
	0x4067C000,0x00000000, 0x51114AD4,0x18D3B94C,
	0x4067D000,0x00000000, 0x511C829B,0x37869E1B,
	0x4067E000,0x00000000, 0x512780AF,0x0992E0C5,
	0x4067F000,0x00000000, 0x51335FEA,0xCF9DB657,
	0x40680000,0x00000000, 0x513FF185,0x62CC483E,
	0x40681000,0x00000000, 0x514A5539,0xF7EA156F,
	0x40682000,0x00000000, 0x5155B533,0xA34ADB32,
	0x40683000,0x00000000, 0x5161E523,0x69C669BA,
	0x40684000,0x00000000, 0x516D8105,0x2CB19D0C,
	0x40685000,0x00000000, 0x51785269,0x9C56A145,
	0x40686000,0x00000000, 0x51840CCF,0x34C420DE,
	0x40687000,0x00000000, 0x51908749,0x386C7074,
	0x40688000,0x00000000, 0x519B4036,0x1511970E,
	0x40689000,0x00000000, 0x51A676E9,0xF859F4DC,
	0x4068A000,0x00000000, 0x51B284D3,0xBB227032,
	0x4068B000,0x00000000, 0x51BE884D,0x6C929E71,
	0x4068C000,0x00000000, 0x51C92B73,0xB924EDF1,
	0x4068D000,0x00000000, 0x51D4BFBA,0x6CABEDF1,
	0x4068E000,0x00000000, 0x51E11AC7,0x97323903,
	0x4068F000,0x00000000, 0x51EC3363,0x1C437534,
	0x40690000,0x00000000, 0x51F73F60,0xEA79F5B9,
	0x40691000,0x00000000, 0x52032A15,0x0CBD140C,
	0x40692000,0x00000000, 0x520F98C3,0x1A5FDD25,
	0x40693000,0x00000000, 0x521A0C0E,0x9CE35791,
	0x40694000,0x00000000, 0x522578E2,0x3EE4F2D2,
	0x40695000,0x00000000, 0x5231B36A,0x23271D9A,
	0x40696000,0x00000000, 0x523D2F0A,0x258E2D01,
	0x40697000,0x00000000, 0x52480ED4,0xBB267ACE,
	0x40698000,0x00000000, 0x5253D519,0x0ABF8313,
	0x40699000,0x00000000, 0x5260595C,0x0DC07FCA,
	0x4069A000,0x00000000, 0x526AF47D,0xCA9FD133,
	0x4069B000,0x00000000, 0x5276387E,0x52E77303,
	0x4069C000,0x00000000, 0x5282515E,0xBD58BF5C,
	0x4069D000,0x00000000, 0x528E3376,0xD5436F25,
	0x4069E000,0x00000000, 0x5298E583,0xC58E35C4,
	0x4069F000,0x00000000, 0x52A48613,0x1C950CED,
	0x406A0000,0x00000000, 0x52B0EB40,0x981671AC,
	0x406A1000,0x00000000, 0x52BBE507,0x1FDBA3DE,
	0x406A2000,0x00000000, 0x52C6FEC8,0x40CEA3D5,
	0x406A3000,0x00000000, 0x52D2F4D4,0xE03D16C2,
	0x406A4000,0x00000000, 0x52DF40F7,0x72B4AA1B,
	0x406A5000,0x00000000, 0x52E9C3AE,0x9151263B,
	0x406A6000,0x00000000, 0x52F53D38,0x745E9AA6,
	0x406A7000,0x00000000, 0x5301823B,0x067189D1,
	0x406A8000,0x00000000, 0x530CDDF2,0xE98B780D,
	0x406A9000,0x00000000, 0x5317CBFB,0xA2A87780,
	0x406AA000,0x00000000, 0x53239DFD,0xADF7D8F2,
	0x406AB000,0x00000000, 0x53302BEE,0x7FDD3C52,
	0x406AC000,0x00000000, 0x533AA997,0xE5E614A7,
	0x406AD000,0x00000000, 0x5345FAC0,0x1EF00751,
	0x406AE000,0x00000000, 0x53521E78,0xBA644953,
	0x406AF000,0x00000000, 0x535DDF8B,0xF9D2C4D9,
	0x406B0000,0x00000000, 0x5368A056,0x265FE3CE,
	0x406B1000,0x00000000, 0x53744D0B,0xFF1F369E,
	0x406B2000,0x00000000, 0x5380BC3D,0xA8870386,
	0x406B3000,0x00000000, 0x538B9784,0xDEAD232E,
	0x406B4000,0x00000000, 0x5396BEE3,0x145C2812,
	0x406B5000,0x00000000, 0x53A2C028,0xAA77F150,
	0x406B6000,0x00000000, 0x53AEEA1F,0xBE812D0F,
	0x406B7000,0x00000000, 0x53B97C17,0xA0470700,
	0x406B8000,0x00000000, 0x53C50234,0x720464C9,
	0x406B9000,0x00000000, 0x53D15194,0x93BDE06C,
	0x406BA000,0x00000000, 0x53DC8DBC,0xFFB57D24,
	0x406BB000,0x00000000, 0x53E789DC,0x49147CE7,
	0x406BC000,0x00000000, 0x53F3677B,0x704A40D8,
	0x406BD000,0x00000000, 0x53FFFDFE,0x58588CD5,
	0x406BE000,0x00000000, 0x540A5F82,0x1E46BD6C,
	0x406BF000,0x00000000, 0x5415BDAD,0x7A848783,
	0x406C0000,0x00000000, 0x5421EC20,0x24FB6CEF,
	0x406C1000,0x00000000, 0x542D8C8A,0x4B3C6378,
	0x406C2000,0x00000000, 0x54385BE8,0xBFA1AFCE,
	0x406C3000,0x00000000, 0x544414A3,0x57292A80,
	0x406C4000,0x00000000, 0x54508DBD,0x59915B4F,
	0x406C5000,0x00000000, 0x545B4AD9,0xFBB96C33,
	0x406C6000,0x00000000, 0x54667FAF,0x7266BF9B,
	0x406C7000,0x00000000, 0x54728C0E,0xD04AC49C,
	0x406C8000,0x00000000, 0x547E9439,0x57EC0C43,
	0x406C9000,0x00000000, 0x54893547,0x9AFA35DE,
	0x406CA000,0x00000000, 0x5494C7D4,0x6B30E5B0,
	0x406CB000,0x00000000, 0x54A12175,0x4F4F0E6B,
	0x406CC000,0x00000000, 0x54AC3E65,0xF5F6F8E0,
	0x406CD000,0x00000000, 0x54B74874,0xAA4C46C5,
	0x406CE000,0x00000000, 0x54C33190,0xA83F0958,
	0x406CF000,0x00000000, 0x54CFA519,0x67E1052B,
	0x406D0000,0x00000000, 0x54DA163A,0x317C9571,
	0x406D1000,0x00000000, 0x54E58144,0x88F0E6EE,
	0x406D2000,0x00000000, 0x54F1BA53,0x74247313,
	0x406D3000,0x00000000, 0x54FD3A6F,0x41981AEB,
	0x406D4000,0x00000000, 0x55081839,0x7B37B180,
	0x406D5000,0x00000000, 0x5513DCD7,0x6C6681AC,
	0x406D6000,0x00000000, 0x55205FBE,0x403E820D,
	0x406D7000,0x00000000, 0x552AFF04,0x209305AC,
	0x406D8000,0x00000000, 0x5536412B,0x6D9C72F9,
	0x406D9000,0x00000000, 0x55425885,0xBB09167F,
	0x406DA000,0x00000000, 0x554E3F41,0xA0776B59,
	0x406DB000,0x00000000, 0x5558EF3C,0x58B09B93,
	0x406DC000,0x00000000, 0x55648E16,0x983EA89A,
	0x406DD000,0x00000000, 0x5570F1DB,0xC18727B4,
	0x406DE000,0x00000000, 0x557BEFEB,0x61064EA1,
	0x406DF000,0x00000000, 0x558707C2,0xC7CBAA81,
	0x406E0000,0x00000000, 0x5592FC3B,0xB0FCB841,
	0x406E1000,0x00000000, 0x559F4D2B,0x7876CF99,
	0x406E2000,0x00000000, 0x55A9CDBD,0xE38932E0,
	0x406E3000,0x00000000, 0x55B54583,0x72ADAD98,
	0x406E4000,0x00000000, 0x55C18911,0x2329934D,
	0x406E5000,0x00000000, 0x55CCE938,0x5C0605DB,
	0x406E6000,0x00000000, 0x55D7D546,0x48D217A1,
	0x406E7000,0x00000000, 0x55E3A5A6,0x8B524219,
	0x406E8000,0x00000000, 0x55F0323E,0xF5880BF3,
	0x406E9000,0x00000000, 0x55FAB400,0xFD4B4509,
	0x406EA000,0x00000000, 0x56060355,0x1E060B72,
	0x406EB000,0x00000000, 0x5612258B,0xD8706B78,
	0x406EC000,0x00000000, 0x561DEB36,0x00EC79D4,
	0x406ED000,0x00000000, 0x5628A9F3,0xB6AFF351,
	0x406EE000,0x00000000, 0x563454F9,0x367A4B04,
	0x406EF000,0x00000000, 0x5640C2C6,0x76DBF332,
	0x406F0000,0x00000000, 0x564BA24A,0xDC52A6B6,
	0x406F1000,0x00000000, 0x5656C7C4,0xA8990654,
	0x406F2000,0x00000000, 0x5662C77A,0xEA3B35AC,
	0x406F3000,0x00000000, 0x566EF631,0xDBC4D70C,
	0x406F4000,0x00000000, 0x5679860A,0xFEA3876D,
	0x406F5000,0x00000000, 0x56850A68,0x655197B6,
	0x406F6000,0x00000000, 0x56915857,0xB18D19C4,
	0x406F7000,0x00000000, 0x569C98E3,0x209AFF5B,
	0x406F8000,0x00000000, 0x56A7930D,0x1DDD0C34,
	0x406F9000,0x00000000, 0x56B36F0F,0x0521972A,
	0x406FA000,0x00000000, 0x56C0053E,0x164D25FF,
	0x406FB000,0x00000000, 0x56CA69CE,0x48604213,
	0x406FC000,0x00000000, 0x56D5C62A,0xA0F8323A,
	0x406FD000,0x00000000, 0x56E1F31F,0x9A9C02D7,
	0x406FE000,0x00000000, 0x56ED9813,0xE9473A60,
	0x406FF000,0x00000000, 0x56F8656B,0x982D1F44,
	0x40700000,0x00000000, 0x57041C7A,0x8814BEBA,
	0x40700800,0x00000000, 0x57109433,0xFFCB96CA,
	0x40701000,0x00000000, 0x571B5582,0x09F140FD,
	0x40701800,0x00000000, 0x57268878,0x5935DBB2,
	0x40702000,0x00000000, 0x5732934C,0xB8371AB4,
	0x40702800,0x00000000, 0x573EA029,0xEAE91642,
	0x40703000,0x00000000, 0x57493F1F,0x5326A019,
	0x40703800,0x00000000, 0x5754CFF1,0x93835D18,
	0x40704000,0x00000000, 0x57612825,0xA2FDAE13,
	0x40704800,0x00000000, 0x576C496D,0x1C4D4EDC,
	0x40705000,0x00000000, 0x5777518B,0xF570C588,
	0x40705800,0x00000000, 0x5783390F,0x2FB6AF23,
	0x40706000,0x00000000, 0x578FB174,0x868F8418,
	0x40706800,0x00000000, 0x579A2069,0xBEAAFCC1,
	0x40707000,0x00000000, 0x57A589AA,0x1904B8FD,
	0x40707800,0x00000000, 0x57B1C13F,0x77F8B4FD,
	0x40708000,0x00000000, 0x57BD45D8,0xD0A28247,
	0x40708800,0x00000000, 0x57C821A1,0xE63BAB6A,
	0x40709000,0x00000000, 0x57D3E498,0xD415B213,
	0x40709800,0x00000000, 0x57E06622,0xF0D162C7,
	0x4070A000,0x00000000, 0x57EB098E,0x928AFB64,
	0x4070A800,0x00000000, 0x57F649DB,0xEB8F9483,
	0x4070B000,0x00000000, 0x58025FAF,0x83A52372,
	0x4070B800,0x00000000, 0x580E4B11,0x065FE4C8,
	0x4070C000,0x00000000, 0x5818F8F8,0xB78094E9,
	0x4070C800,0x00000000, 0x5824961D,0x34EBA01D,
	0x4070D000,0x00000000, 0x5830F879,0x7F4ABAB9,
	0x4070D800,0x00000000, 0x583BFAD3,0xE2E189D8,
	0x4070E000,0x00000000, 0x584710C0,0xD041C387,
	0x4070E800,0x00000000, 0x585303A5,0x6593BD1F,
	0x4070F000,0x00000000, 0x585F5964,0x4203C1DE,
	0x4070F800,0x00000000, 0x5869D7D1,0x234DB4A9,
	0x40710000,0x00000000, 0x58754DD1,0xADEC0B48,
	0x40710800,0x00000000, 0x58818FE9,0xEB38F352,
	0x40711000,0x00000000, 0x588CF482,0x35243089,
	0x40711800,0x00000000, 0x5897DE94,0x8FBD7E39,
	0x40712000,0x00000000, 0x58A3AD52,0x664E1DF7,
	0x40712800,0x00000000, 0x58B03891,0xE25ABC6B,
	0x40713000,0x00000000, 0x58BABE6E,0x254A0BCA,
	0x40713800,0x00000000, 0x58C60BED,0x76F072A2,
	0x40714000,0x00000000, 0x58D22CA1,0xB9A5C3DF,
	0x40714800,0x00000000, 0x58DDF6E4,0x95EF7D77,
	0x40715000,0x00000000, 0x58E8B395,0x0821A800,
	0x40715800,0x00000000, 0x58F45CE9,0x862703BA,
	0x40716000,0x00000000, 0x5900C951,0xD258F4BF,
	0x40716800,0x00000000, 0x590BAD15,0x0ED7AA99,
	0x40717000,0x00000000, 0x5916D0A9,0xB49138CB,
	0x40717800,0x00000000, 0x5922CED0,0x05CE1F1A,
	0x40718000,0x00000000, 0x592F0248,0xAF95F4C5,
	0x40718800,0x00000000, 0x59399002,0x3FA2717D,
	0x40719000,0x00000000, 0x5945129F,0x8C8EC869,
	0x40719800,0x00000000, 0x59515F1D,0x7348E98B,
	0x4071A000,0x00000000, 0x595CA40D,0x9BE99BD8,
	0x4071A800,0x00000000, 0x59679C41,0x8952B69E,
	0x4071B000,0x00000000, 0x597376A5,0x8F4AF93B,
	0x4071B800,0x00000000, 0x59800B7F,0x70BC2748,
	0x4071C000,0x00000000, 0x598A741E,0x77C7EC9D,
	0x4071C800,0x00000000, 0x5995CEAB,0x17F0A943,
	0x4071D000,0x00000000, 0x59A1FA21,0xCBB8DF30,
	0x4071D800,0x00000000, 0x59ADA3A2,0x0893BDDD,
	0x4071E000,0x00000000, 0x59B86EF2,0x276B93A5,
	0x4071E800,0x00000000, 0x59C42454,0xC8B8682D,
	0x4071F000,0x00000000, 0x59D09AAD,0x2C170340,
	0x4071F800,0x00000000, 0x59DB602E,0x41585B8E,
	0x40720000,0x00000000, 0x59E69144,0xAE1D9F07,
	0x40720800,0x00000000, 0x59F29A8D,0x7401A7B4,
	0x40721000,0x00000000, 0x59FEAC1F,0x275B04AF,
	0x40721800,0x00000000, 0x5A0948FA,0xE329BC12,
	0x40722000,0x00000000, 0x5A14D811,0xE6DF8552,
	0x40722800,0x00000000, 0x5A212ED8,0x9342BFFD,
	0x40723000,0x00000000, 0x5A2C5478,0x90F4370C,
	0x40723800,0x00000000, 0x5A375AA6,0xCD49B6C7,
	0x40724000,0x00000000, 0x5A434090,0xA44810F8,
	0x40724800,0x00000000, 0x5A4FBDD4,0x784CDA28,
	0x40725000,0x00000000, 0x5A5A2A9D,0x45FB7BB3,
	0x40725800,0x00000000, 0x5A659212,0xF0679FBC,
	0x40726000,0x00000000, 0x5A71C82E,0x2FB1A15B,
	0x40726800,0x00000000, 0x5A7D5146,0xD46A1DE3,
	0x40727000,0x00000000, 0x5A882B0D,0xFDA106AA,
	0x40727800,0x00000000, 0x5A93EC5D,0x42FB4DED,
	0x40728000,0x00000000, 0x5AA06C8A,0x20724675,
	0x40728800,0x00000000, 0x5AAB141D,0x22227699,
	0x40729000,0x00000000, 0x5AB6528F,0xCE13764B,
	0x40729800,0x00000000, 0x5AC266DC,0x18440B4A,
	0x4072A000,0x00000000, 0x5ACE56E5,0x08C916D8,
	0x4072A800,0x00000000, 0x5AD902B8,0xE3798770,
	0x4072B000,0x00000000, 0x5AE49E26,0xF3D4B60A,
	0x4072B800,0x00000000, 0x5AF0FF19,0xD262FE79,
	0x4072C000,0x00000000, 0x5AFC05C0,0xA7166B4A,
	0x4072C800,0x00000000, 0x5B0719C2,0x5B8F5B4A,
	0x4072D000,0x00000000, 0x5B130B11,0xFF23056A,
	0x4072D800,0x00000000, 0x5B1F65A1,0xD137C73F,
	0x4072E000,0x00000000, 0x5B29E1E8,0x52274ADB,
	0x4072E800,0x00000000, 0x5B355623,0x275D5D3E,
	0x4072F000,0x00000000, 0x5B4196C5,0x5FAA7A5C,
	0x4072F800,0x00000000, 0x5B4CFFD0,0x769DDF27,
	0x40730000,0x00000000, 0x5B57E7E6,0x78D54EB5,
	0x40730800,0x00000000, 0x5B63B501,0x40165E6B,
	0x40731000,0x00000000, 0x5B703EE7,0x474BBDF2,
	0x40731800,0x00000000, 0x5B7AC8DF,0x5F78B7CA,
	0x40732000,0x00000000, 0x5B861489,0x2AFE2EA5,
	0x40732800,0x00000000, 0x5B9233BA,0x5F186FF8,
	0x40733000,0x00000000, 0x5B9E0297,0xBAA30C57,
	0x40733800,0x00000000, 0x5BA8BD3A,0x1C2C4952,
	0x40734000,0x00000000, 0x5BB464DC,0xEF5ABE49,
	0x40734800,0x00000000, 0x5BC0CFDF,0xBBFD0F84,
	0x40735000,0x00000000, 0x5BCBB7E3,0x77E0A776,
	0x40735800,0x00000000, 0x5BD6D992,0x399F5E26,
	0x40736000,0x00000000, 0x5BE2D627,0xFE4E6AF9,
	0x40736800,0x00000000, 0x5BEF0E64,0x3BCBA12A,
	0x40737000,0x00000000, 0x5BF999FD,0x64C82181,
	0x40737800,0x00000000, 0x5C051AD9,0xE8FC1D15,
	0x40738000,0x00000000, 0x5C1165E5,0xD9F93ADE,
	0x40738800,0x00000000, 0x5C1CAF3C,0x7354735A,
	0x40739000,0x00000000, 0x5C27A579,0x8CDC2FF0,
	0x40739800,0x00000000, 0x5C337E3F,0x0FEE1A43,
	0x4073A000,0x00000000, 0x5C4011C3,0x3C6D0DB8,
	0x4073A800,0x00000000, 0x5C4A7E72,0xAE0FA2EF,
	0x4073B000,0x00000000, 0x5C55D72E,0xE0B93BB4,
	0x4073B800,0x00000000, 0x5C620126,0xB9632031,
	0x4073C000,0x00000000, 0x5C6DAF34,0xAAE43996,
	0x4073C800,0x00000000, 0x5C78787C,0x6ED041A6,
	0x4073D000,0x00000000, 0x5C842C32,0x1A4628C7,
	0x4073D800,0x00000000, 0x5C90A128,0xDF6FE365,
	0x4073E000,0x00000000, 0x5C9B6ADE,0xA38EA430,
	0x4073E800,0x00000000, 0x5CA69A14,0x7274E527,
	0x4073F000,0x00000000, 0x5CB2A1D1,0x04C50F06,
	0x4073F800,0x00000000, 0x5CBEB819,0x0F13D572,
	0x40740000,0x00000000, 0x5CC952DA,0x4C83AF00,
	0x40740800,0x00000000, 0x5CD4E035,0x66820AFE,
	0x40741000,0x00000000, 0x5CE1358E,0x212351EF,
	0x40741800,0x00000000, 0x5CEC5F88,0x559A191C,
	0x40742000,0x00000000, 0x5CF763C5,0x3339E998,
	0x40742800,0x00000000, 0x5D034815,0x0717AC6A,
	0x40743000,0x00000000, 0x5D0FCA39,0x3EFB439C,
	0x40743800,0x00000000, 0x5D1A34D4,0xC8FB9B73,
	0x40744000,0x00000000, 0x5D259A7F,0x106151AC,
	0x40744800,0x00000000, 0x5D31CF1F,0x9C5D5F7E,
	0x40745000,0x00000000, 0x5D3D5CB9,0x4EAC5631,
	0x40745800,0x00000000, 0x5D48347D,0xC2D6F085,
	0x40746000,0x00000000, 0x5D53F424,0xBA4604DF,
	0x40746800,0x00000000, 0x5D6072F3,0xD01AB2DA,
	0x40747000,0x00000000, 0x5D6B1EAF,0xD0F4DBEE,
	0x40747800,0x00000000, 0x5D765B47,0x167B3B33,
	0x40748000,0x00000000, 0x5D826E0B,0x79FD6017,
	0x40748800,0x00000000, 0x5D8E62BD,0xA97FF0A3,
	0x40749000,0x00000000, 0x5D990C7C,0xDE176CFA,
	0x40749800,0x00000000, 0x5DA4A633,0xD6332716,
	0x4074A000,0x00000000, 0x5DB105BC,0xBBD22B5D,
	0x4074A800,0x00000000, 0x5DBC10B1,0xAF4EAEB5,
	0x4074B000,0x00000000, 0x5DC722C7,0x6B1366FE,
	0x4074B800,0x00000000, 0x5DD31281,0x7ECBE1FD,
	0x4074C000,0x00000000, 0x5DDF71E4,0x27EFE008,
	0x4074C800,0x00000000, 0x5DE9EC03,0x719F2E06,
	0x4074D000,0x00000000, 0x5DF55E77,0xE045CB62,
	0x4074D800,0x00000000, 0x5E019DA3,0x81896117,
	0x4074E000,0x00000000, 0x5E0D0B23,0x222BA489,
	0x4074E800,0x00000000, 0x5E17F13C,0x0584BA1A,
	0x4074F000,0x00000000, 0x5E23BCB3,0x19D66A0E,
	0x4074F800,0x00000000, 0x5E30453F,0x2551E0F6,
	0x40750000,0x00000000, 0x5E3AD354,0xAD6E368F,
	0x40750800,0x00000000, 0x5E461D28,0x3B7EB40A,
	0x40751000,0x00000000, 0x5E523AD5,0xC9DCF903,
	0x40751800,0x00000000, 0x5E5E0E4F,0x70CF14C8,
	0x40752000,0x00000000, 0x5E68C6E2,0xF447B147,
	0x40752800,0x00000000, 0x5E746CD3,0x734B5106,
	0x40753000,0x00000000, 0x5E80D670,0x34C7AE68,
	0x40753800,0x00000000, 0x5E8BC2B6,0x1912BA16,
	0x40754000,0x00000000, 0x5E96E27E,0x391E9C6C,
	0x40754800,0x00000000, 0x5EA2DD82,0xD4DA463E,
	0x40755000,0x00000000, 0x5EAF1A84,0x823DAF20,
	0x40755800,0x00000000, 0x5EB9A3FC,0x6F998B6E,
	0x40756000,0x00000000, 0x5EC52317,0x7BDA38EC,
	0x40756800,0x00000000, 0x5ED16CB0,0xE6A65FE5,
	0x40757000,0x00000000, 0x5EDCBA6F,0xA88F5082,
	0x40757800,0x00000000, 0x5EE7AEB5,0x29E0B800,
	0x40758000,0x00000000, 0x5EF385DB,0x883320EE,
	0x40758800,0x00000000, 0x5F001809,0x7A53FBF1,
	0x40759000,0x00000000, 0x5F0A88CA,0xECC9E7DB,
	0x40759800,0x00000000, 0x5F15DFB5,0xFC9DB9FF,
	0x4075A000,0x00000000, 0x5F22082E,0x64AC4EB5,
	0x4075A800,0x00000000, 0x5F2DBACB,0xD1FBA904,
	0x4075B000,0x00000000, 0x5F38820A,0x6FCEEEED,
	0x4075B800,0x00000000, 0x5F443412,0x7DF079F0,
	0x4075C000,0x00000000, 0x5F50A7A7,0x1AD2DC6D,
	0x4075C800,0x00000000, 0x5F5B7593,0x3234A58E,
	0x4075D000,0x00000000, 0x5F66A2E7,0xA7930F81,
	0x4075D800,0x00000000, 0x5F72A917,0x6B9C6272,
	0x4075E000,0x00000000, 0x5F7EC417,0xA3E63C6A,
	0x4075E800,0x00000000, 0x5F895CBD,0x90B53415,
	0x4075F000,0x00000000, 0x5F94E85C,0x13A81660,
	0x4075F800,0x00000000, 0x5FA13C46,0x4DA4D7A0,
	0x40760000,0x00000000, 0x5FAC6A9C,0x6BEE04C8,
	0x40760800,0x00000000, 0x5FB76CE7,0x28A4B79A,
	0x40761000,0x00000000, 0x5FC34F9C,0x594A7140,
	0x40761800,0x00000000, 0x5FCFD6A2,0xDC7DB8FE,
	0x40762000,0x00000000, 0x5FDA3F10,0x49398066,
	0x40762800,0x00000000, 0x5FE5A2EE,0x7A3A0542,
	0x40763000,0x00000000, 0x5FF1D613,0xBF0A8036,
	0x40763800,0x00000000, 0x5FFD6830,0x4127418E,
	0x40764000,0x00000000, 0x60083DF1,0x374D259D,
	0x40764800,0x00000000, 0x6013FBEF,0x3B24FCBE,
	0x40765000,0x00000000, 0x60207960,0x00C48F27,
	0x40765800,0x00000000, 0x602B2946,0xA09E30A3,
	0x40766000,0x00000000, 0x60366401,0xC61A8A8A,
	0x40766800,0x00000000, 0x6042753D,0xA9E92116,
	0x40767000,0x00000000, 0x604E6E9A,0xEA52153A,
	0x40767800,0x00000000, 0x60591644,0xA8D6D3B2,
	0x40768000,0x00000000, 0x6064AE43,0xDD40AA42,
	0x40768800,0x00000000, 0x60710C62,0x3C9ADE9F,
	0x40769000,0x00000000, 0x607C1BA6,0xFD34B612,
	0x40769800,0x00000000, 0x60872BD0,0x002D64E0,
	0x4076A000,0x00000000, 0x609319F3,0xE5B014A7,
	0x4076A800,0x00000000, 0x609F7E2B,0x4809C6C3,
	0x4076B000,0x00000000, 0x60A9F622,0x833F3047,
	0x4076B800,0x00000000, 0x60B566CF,0xD9E9FC30,
	0x4076C000,0x00000000, 0x60C1A484,0x51E14885,
	0x4076C800,0x00000000, 0x60CD167A,0x3986BF89,
	0x4076D000,0x00000000, 0x60D7FA95,0x37377F3C,
	0x4076D800,0x00000000, 0x60E3C467,0xF4BA1C5E,
	0x4076E000,0x00000000, 0x60F04B99,0x7D645645,
	0x4076E800,0x00000000, 0x60FADDCE,0x10C21481,
	0x4076F000,0x00000000, 0x610625CA,0xA9C1FA57,
	0x4076F800,0x00000000, 0x611241F3,0xFB085438,
	0x40770000,0x00000000, 0x611E1A0B,0xBA3C3728,
	0x40770800,0x00000000, 0x6128D08F,0x91EC4CA1,
	0x40771000,0x00000000, 0x613474CD,0x132F0B40,
	0x40771800,0x00000000, 0x6140DD03,0x3DB8A011,
	0x40772000,0x00000000, 0x614BCD8C,0xF413A3B1,
	0x40772800,0x00000000, 0x6156EB6D,0xB46AA12E,
	0x40773000,0x00000000, 0x6162E4E0,0x8A904D9A,
	0x40773800,0x00000000, 0x616F26A9,0x84C4A9C3,
	0x40774000,0x00000000, 0x6179ADFF,0x619C3B18,
	0x40774800,0x00000000, 0x61852B58,0x466A3C55,
	0x40775000,0x00000000, 0x6191737E,0x9A5911FE,
	0x40775800,0x00000000, 0x619CC5A7,0x3D4EA81B,
	0x40776000,0x00000000, 0x61A7B7F4,0x61C81AEE,
	0x40776800,0x00000000, 0x61B38D7A,0xF942A789,
	0x40777000,0x00000000, 0x61C01E52,0x2B6573E7,
	0x40777800,0x00000000, 0x61CA9327,0x3589DB5E,
	0x40778000,0x00000000, 0x61D5E840,0x6CEA7625,
	0x40778800,0x00000000, 0x61E20F38,0xCEA65E67,
	0x40779000,0x00000000, 0x61EDC667,0x7F9DB7B8,
	0x40779800,0x00000000, 0x61F88B9C,0x2BDBF24A,
	0x4077A000,0x00000000, 0x62043BF5,0xF4EA4CBB,
	0x4077A800,0x00000000, 0x6210AE27,0xDF3CF630,
	0x4077B000,0x00000000, 0x621B804B,0xEEEB8CFA,
	0x4077B800,0x00000000, 0x6226ABBE,0x4ED00596,
	0x4077C000,0x00000000, 0x6232B060,0xA9A32244,
	0x4077C800,0x00000000, 0x623ED01A,0xE7A5A3AF,
	0x4077D000,0x00000000, 0x624966A4,0xB13F9CBC,
	0x4077D800,0x00000000, 0x6254F085,0xEF8F4B92,
	0x4077E000,0x00000000, 0x62614301,0x19CD2ADB,
	0x4077E800,0x00000000, 0x626C75B4,0xD59FB21D,
	0x4077F000,0x00000000, 0x6277760C,0xAEEE052E,
	0x4077F800,0x00000000, 0x62835726,0x9C05C1A3,
	0x40780000,0x00000000, 0x628FE311,0x52B7EF6B,
	0x40780800,0x00000000, 0x629A494F,0xC843EA66,
	0x40781000,0x00000000, 0x62A5AB61,0x2F3A7119,
	0x40781800,0x00000000, 0x62B1DD0A,0x98C7FDF5,
	0x40782000,0x00000000, 0x62BD73AB,0xAD99A482,
	0x40782800,0x00000000, 0x62C84768,0x5C73F22A,
	0x40783000,0x00000000, 0x62D403BC,0xC6C7D1BC,
	0x40783800,0x00000000, 0x62E07FCE,0xB36A2422,
	0x40784000,0x00000000, 0x62EB33E1,0x92BB1ADE,
	0x40784800,0x00000000, 0x62F66CBF,0xDE45903B,
	0x40785000,0x00000000, 0x63027C72,0xA91FBAD6,
	0x40785800,0x00000000, 0x630E7A7C,0xCD0DDBF0,
	0x40786000,0x00000000, 0x63192010,0x4534DE5E,
	0x40786800,0x00000000, 0x6324B657,0x0A37710D,
	0x40787000,0x00000000, 0x6331130A,0x55C01A76,
	0x40787800,0x00000000, 0x633C26A0,0x927389D6,
	0x40788000,0x00000000, 0x634734DC,0x1C3D5C6C,
	0x40788800,0x00000000, 0x63532169,0x34F1D05D,
	0x40789000,0x00000000, 0x635F8A77,0x3363F085,
	0x40789800,0x00000000, 0x636A0045,0x8891BD7C,
	0x4078A000,0x00000000, 0x63756F2B,0x158F14E4,
	0x4078A800,0x00000000, 0x6381AB67,0xD1BE3A25,
	0x4078B000,0x00000000, 0x638D21D5,0xBE691B49,
	0x4078B800,0x00000000, 0x639803F2,0x0F59EAF6,
	0x4078C000,0x00000000, 0x63A3CC1F,0xD1EDC5F0,
	0x4078C800,0x00000000, 0x63B051F6,0x507AAF34,
	0x4078D000,0x00000000, 0x63BAE84B,0x8B0C7D2A,
	0x4078D800,0x00000000, 0x63C62E70,0x77187C44,
	0x4078E000,0x00000000, 0x63D24914,0xF3AFE2F6,
	0x4078E800,0x00000000, 0x63DE25CC,0x98B3C61A,
	0x4078F000,0x00000000, 0x63E8DA3F,0xF6931B1B,
	0x4078F800,0x00000000, 0x63F47CC9,0xD03CB571,
	0x40790000,0x00000000, 0x6400E398,0xD7D01704,
	0x40790800,0x00000000, 0x640BD868,0x0A89CA2B,
	0x40791000,0x00000000, 0x6416F460,0xACDFA1C0,
	0x40791800,0x00000000, 0x6422EC41,0x208F8DA4,
	0x40792000,0x00000000, 0x642F32D3,0x4539D4B2,
	0x40792800,0x00000000, 0x6439B806,0x3C56546A,
	0x40793000,0x00000000, 0x6445339C,0x49EDC516,
	0x40793800,0x00000000, 0x64517A4E,0xF61A71E3,
	0x40794000,0x00000000, 0x645CD0E3,0x3347995C,
	0x40794800,0x00000000, 0x6467C137,0x35FAB153,
	0x40795000,0x00000000, 0x6473951D,0x6445BC31,
	0x40795800,0x00000000, 0x6480249D,0x50965708,
	0x40796000,0x00000000, 0x648A9D87,0x89E33ADB,
	0x40796800,0x00000000, 0x6495F0CE,0x32EC43E9,
	0x40797000,0x00000000, 0x64A21645,0xF863ADE5,
	0x40797800,0x00000000, 0x64ADD207,0xB58EC19A,
	0x40798000,0x00000000, 0x64B89531,0xA46C33ED,
	0x40798800,0x00000000, 0x64C443DC,0x80670A14,
	0x40799000,0x00000000, 0x64D0B4AB,0x2DAB9B53,
	0x40799800,0x00000000, 0x64DB8B08,0xDB552AA9,
	0x4079A000,0x00000000, 0x64E6B498,0x6984352D,
	0x4079A800,0x00000000, 0x64F2B7AC,0xBFF53D7B,
	0x4079B000,0x00000000, 0x64FEDC22,0xDC262BD7,
	0x4079B800,0x00000000, 0x6509708F,0xAFA4D0D6,
	0x4079C000,0x00000000, 0x6514F8B2,0xFB75CAB5,
	0x4079C800,0x00000000, 0x652149BE,0x86A28BA9,
	0x4079D000,0x00000000, 0x652C80D1,0x945F81B6,
	0x4079D800,0x00000000, 0x65377F35,0xC77A41A9,
	0x4079E000,0x00000000, 0x65435EB3,0xD06F7247,
	0x4079E800,0x00000000, 0x654FEF84,0xA38E58E1,
	0x4079F000,0x00000000, 0x655A5393,0x47AA34FD,
	0x4079F800,0x00000000, 0x6565B3D7,0x30ABCC28,
	0x407A0000,0x00000000, 0x6571E404,0x2AA53CFD,
	0x407A0800,0x00000000, 0x657D7F2B,0x95C2F20A,
	0x407A1000,0x00000000, 0x658850E3,0x33BC3230,
	0x407A1800,0x00000000, 0x65940B8D,0x5E5E9699,
	0x407A2000,0x00000000, 0x65A0863F,0xE9061C49,
	0x407A2800,0x00000000, 0x65AB3E80,0xA8E8E1E0,
	0x407A3000,0x00000000, 0x65B67581,0x6050FD04,
	0x407A3800,0x00000000, 0x65C283AA,0x78BA0762,
	0x407A4000,0x00000000, 0x65CE8663,0x5382509D,
	0x407A4800,0x00000000, 0x65D929DF,0xB4AF4491,
	0x407A5000,0x00000000, 0x65E4BE6D,0x5E5227A4,
	0x407A5800,0x00000000, 0x65F119B5,0x08454638,
	0x407A6000,0x00000000, 0x65FC319E,0x70B6D934,
	0x407A6800,0x00000000, 0x66073DEB,0xC0A3DE92,
	0x407A7000,0x00000000, 0x661328E1,0x6DB3B964,
	0x407A7800,0x00000000, 0x661F96C7,0xEBDD8D31,
	0x407A8000,0x00000000, 0x662A0A6C,0x8321DB88,
	0x407A8800,0x00000000, 0x66357789,0x947AB9AF,
	0x407A9000,0x00000000, 0x6641B24E,0x022CA821,
	0x407A9800,0x00000000, 0x664D2D35,0xB28D4F79,
	0x407AA000,0x00000000, 0x66580D52,0x8F58D861,
	0x407AA800,0x00000000, 0x6663D3DA,0xB29E2C9A,
	0x407AB000,0x00000000, 0x66705855,0x9F8CDDBD,
	0x407AB800,0x00000000, 0x667AF2CD,0x1DE63B75,
	0x407AC000,0x00000000, 0x66863719,0xA4D337E8,
	0x407AC800,0x00000000, 0x66925038,0xB4E972E6,
	0x407AD000,0x00000000, 0x669E3192,0x0DFFC6D5,
	0x407AD800,0x00000000, 0x66A8E3F4,0x23B5AFA3,
	0x407AE000,0x00000000, 0x66B484C9,0xABAB9169,
	0x407AE800,0x00000000, 0x66C0EA31,0x040EA9CE,
	0x407AF000,0x00000000, 0x66CBE347,0x5E1C3855,
	0x407AF800,0x00000000, 0x66D6FD57,0x23DA5B6B,
	0x407B0000,0x00000000, 0x66E2F3A4,0x97F7830C,
	0x407B0800,0x00000000, 0x66EF3F01,0xC5772C56,
	0x407B1000,0x00000000, 0x66F9C211,0x014E93A7,
	0x407B1800,0x00000000, 0x67053BE3,0x87A6EE8B,
	0x407B2000,0x00000000, 0x67118121,0xFAF407D4,
	0x407B2800,0x00000000, 0x671CDC23,0x8C2FEE27,
	0x407B3000,0x00000000, 0x6727CA7D,0xA7E1607C,
	0x407B3800,0x00000000, 0x67339CC2,0xCA65E103,
	0x407B4000,0x00000000, 0x67402AEA,0xEADBE65C,
	0x407B4800,0x00000000, 0x674AA7EB,0xEB6A6159,
	0x407B5000,0x00000000, 0x6755F95F,0x4FF07902,
	0x407B5800,0x00000000, 0x67621D55,0xE2F706F3,
	0x407B6000,0x00000000, 0x676DDDAC,0x7593D338,
	0x407B6800,0x00000000, 0x67789ECA,0xDAF52DA2,
	0x407B7000,0x00000000, 0x67844BC6,0x219A92EF,
	0x407B7800,0x00000000, 0x6790BB31,0x071C996E,
	0x407B8000,0x00000000, 0x679B95C9,0xF913F1F2,
	0x407B8800,0x00000000, 0x67A6BD75,0xF908928D,
	0x407B9000,0x00000000, 0x67B2BEFB,0xAFAF11F3,
	0x407B9800,0x00000000, 0x67BEE82F,0x833CAC46,
	0x407BA000,0x00000000, 0x67C97A7E,0x8D674EEE,
	0x407BA800,0x00000000, 0x67D500E3,0x389A3022,
	0x407BB000,0x00000000, 0x67E1507E,0x952BA07A,
	0x407BB800,0x00000000, 0x67EC8BF2,0xA9DE7D02,
	0x407BC000,0x00000000, 0x67F78862,0x73AE678C,
	0x407BC800,0x00000000, 0x68036643,0xF7ADCA9D,
	0x407BD000,0x00000000, 0x680FFBFC,0xD0E62482,
	0x407BD800,0x00000000, 0x681A5DDA,0xC8FC57A6,
	0x407BE000,0x00000000, 0x6825BC50,0x7FD7CDEF,
	0x407BE800,0x00000000, 0x6831EB00,0x75B20B87,
	0x407BF000,0x00000000, 0x683D8AAF,0xFB634BD5,
	0x407BF800,0x00000000, 0x68485A61,0xBE9751BD,
	0x407C0000,0x00000000, 0x68541361,0x0319D4CC,
	0x407C0800,0x00000000, 0x68608CB3,0xA29383FA,
	0x407C1000,0x00000000, 0x686B4923,0xE4C56E4A,
	0x407C1800,0x00000000, 0x68767E46,0x4D9206AA,
	0x407C2000,0x00000000, 0x68828AE5,0x19D14E71,
	0x407C2800,0x00000000, 0x688E924E,0x7F7F33E7,
	0x407C3000,0x00000000, 0x689933B2,0xF8C452EC,
	0x407C3800,0x00000000, 0x68A4C686,0xDACBF512,
	0x407C4000,0x00000000, 0x68B12062,0x552E2E87,
	0x407C4800,0x00000000, 0x68BC3CA0,0x99AAFA5B,
	0x407C5000,0x00000000, 0x68C746FE,0xEEC205E9,
	0x407C5800,0x00000000, 0x68D3305C,0x9118E579,
	0x407C6000,0x00000000, 0x68DFA31D,0x735687C6,
	0x407C6800,0x00000000, 0x68EA1497,0x747B2A87,
	0x407C7000,0x00000000, 0x68F57FEB,0x57F30DEA,
	0x407C7800,0x00000000, 0x6901B936,0xE4396D73,
	0x407C8000,0x00000000, 0x690D389A,0x17AEA099,
	0x407C8800,0x00000000, 0x691816B6,0xB8A1B10D,
	0x407C9000,0x00000000, 0x6923DB98,0x97F88BA3,
	0x407C9800,0x00000000, 0x69305EB7,0x6B9334AD,
	0x407CA000,0x00000000, 0x693AFD52,0xCAE8B9E7,
	0x407CA800,0x00000000, 0x69463FC6,0x3443AEEF,
	0x407CB000,0x00000000, 0x6952575F,0x3FCB3E2D,
	0x407CB800,0x00000000, 0x695E3D5C,0x1BEAF167,
	0x407CC000,0x00000000, 0x6968EDAC,0x1ACE3095,
	0x407CC800,0x00000000, 0x69748CCC,0xA6B35A83,
	0x407CD000,0x00000000, 0x6980F0CB,0xC375532D,
	0x407CD800,0x00000000, 0x698BEE2A,0xF0729E31,
	0x407CE000,0x00000000, 0x69970651,0x1AB813A2,
	0x407CE800,0x00000000, 0x69A2FB0A,0xF1E81ABF,
	0x407CF000,0x00000000, 0x69AF4B35,0x0757662A,
	0x407CF800,0x00000000, 0x69B9CC1F,0xB20C4DA0,
	0x407D0000,0x00000000, 0x69C5442E,0x00D851D5,
	0x407D0800,0x00000000, 0x69D187F7,0xA9EFC3BE,
	0x407D1000,0x00000000, 0x69DCE768,0x49BE1B4F,
	0x407D1800,0x00000000, 0x69E7D3C7,0xB8E59AA0,
	0x407D2000,0x00000000, 0x69F3A46B,0x2CCD0C40,
	0x407D2800,0x00000000, 0x6A00313A,0xFB2BC2B2,
	0x407D3000,0x00000000, 0x6A0AB254,0x5BB447C1,
	0x407D3800,0x00000000, 0x6A1601F3,0xC544ED4F,
	0x407D4000,0x00000000, 0x6A222468,0x8F739E9B,
	0x407D4800,0x00000000, 0x6A2DE955,0xC172AA02,
	0x407D5000,0x00000000, 0x6A38A867,0xD0ECEB08,
	0x407D5800,0x00000000, 0x6A4453B2,0xD9B94076,
	0x407D6000,0x00000000, 0x6A50C1B9,0x6C8E2131,
	0x407D6800,0x00000000, 0x6A5BA08F,0x49CAF990,
	0x407D7000,0x00000000, 0x6A66C656,0xFEB698A8,
	0x407D7800,0x00000000, 0x6A72C64D,0x79ED6C91,
	0x407D8000,0x00000000, 0x6A7EF440,0xDEBEB36B,
	0x407D8800,0x00000000, 0x6A898471,0x4C0A2C79,
	0x407D9000,0x00000000, 0x6A950916,0xA83B9497,
	0x407D9800,0x00000000, 0x6AA15741,0x466F7649,
	0x407DA000,0x00000000, 0x6AAC9718,0x17CE5687,
	0x407DA800,0x00000000, 0x6AB79192,0xB4EFFCBC,
	0x407DB000,0x00000000, 0x6AC36DD7,0x12E784FD,
	0x407DB800,0x00000000, 0x6AD0043C,0xEE529F72,
	0x407DC000,0x00000000, 0x6ADA6826,0x4DCAE606,
	0x407DC800,0x00000000, 0x6AE5C4CD,0x1E08AEAC,
	0x407DD000,0x00000000, 0x6AF1F1FF,0x7AFEA1EC,
	0x407DD800,0x00000000, 0x6AFD9638,0xE03B828E,
	0x407DE000,0x00000000, 0x6B0863E3,0xFE774D18,
	0x407DE800,0x00000000, 0x6B141B37,0xB62A8CB7,
	0x407DF000,0x00000000, 0x6B209329,0xE10DC999,
	0x407DF800,0x00000000, 0x6B2B53CB,0x47EF4A57,
	0x407E0000,0x00000000, 0x6B36870E,0xA75E682D,
	0x407E0800,0x00000000, 0x6B429222,0x8D7F458D,
	0x407E1000,0x00000000, 0x6B4E9E3E,0x52D4FB85,
	0x407E1800,0x00000000, 0x6B593D8A,0x12F2EB54,
	0x407E2000,0x00000000, 0x6B64CEA3,0x80E07B71,
	0x407E2800,0x00000000, 0x6B712712,0x3D7F0572,
	0x407E3000,0x00000000, 0x6B7C47A7,0x0EFCEABA,
	0x407E3800,0x00000000, 0x6B875015,0xA7F976E9,
	0x407E4000,0x00000000, 0x6B9337DA,0xA044DC04,
	0x407E4800,0x00000000, 0x6B9FAF77,0xCBAF86A5,
	0x407E5000,0x00000000, 0x6BAA1EC6,0x5E29E512,
	0x407E5800,0x00000000, 0x6BB58850,0x613EB443,
	0x407E6000,0x00000000, 0x6BC1C022,0x78F1CE0F,
	0x407E6800,0x00000000, 0x6BCD4402,0xEF89003C,
	0x407E7000,0x00000000, 0x6BD8201E,0x8CA26D36,
	0x407E7800,0x00000000, 0x6BE3E359,0x832A93EF,
	0x407E8000,0x00000000, 0x6BF0651B,0xB58667C7,
	0x407E8800,0x00000000, 0x6BFB07DC,0x93AE02E5,
	0x407E9000,0x00000000, 0x6C064876,0x26BBE6CD,
	0x407E9800,0x00000000, 0x6C125E88,0x956BEB90,
	0x407EA000,0x00000000, 0x6C1E492A,0xC440B0F6,
	0x407EA800,0x00000000, 0x6C28F767,0xDD5757F4,
	0x407EB000,0x00000000, 0x6C3494D2,0xC28C45D0,
	0x407EB800,0x00000000, 0x6C40F769,0x17057235,
	0x407EC000,0x00000000, 0x6C4BF912,0xC335512C,
	0x407EC800,0x00000000, 0x6C570F4E,0x92D69839,
	0x407ED000,0x00000000, 0x6C630274,0x2F81B217,
	0x407ED800,0x00000000, 0x6C6F576D,0x0CB5F103,
	0x407EE000,0x00000000, 0x6C79D632,0x50176FF6,
	0x407EE800,0x00000000, 0x6C854C7B,0xB6C5060A,
	0x407EF000,0x00000000, 0x6C918ED0,0x0417FD64,
	0x407EF800,0x00000000, 0x6C9CF2B1,0x6DA940DA,
	0x407F0000,0x00000000, 0x6CA7DD15,0x6A715F16,
	0x407F0800,0x00000000, 0x6CB3AC16,0x8CA5A886,
	0x407F1000,0x00000000, 0x6CC0378D,0x827BECBD,
	0x407F1800,0x00000000, 0x6CCABCC0,0xDC56851E,
	0x407F2000,0x00000000, 0x6CD60A8B,0x9437FB07,
	0x407F2800,0x00000000, 0x6CE22B7D,0xFEED1560,
	0x407F3000,0x00000000, 0x6CEDF503,0x9AF1B491,
	0x407F3800,0x00000000, 0x6CF8B208,0x87CA09CA,
	0x407F4000,0x00000000, 0x6D045BA2,0xA9F7E439,
	0x407F4800,0x00000000, 0x6D10C844,0x5EFEC68E,
	0x407F5000,0x00000000, 0x6D1BAB58,0xCF1DFBE2,
	0x407F5800,0x00000000, 0x6D26CF3B,0x7BE8495B,
	0x407F6000,0x00000000, 0x6D32CDA2,0x1FCD896D,
	0x407F6800,0x00000000, 0x6D3F0056,0xF082870F,
	0x407F7000,0x00000000, 0x6D498E67,0xED111611,
	0x407F7800,0x00000000, 0x6D55114D,0x4B998D6B,
	0x407F8000,0x00000000, 0x6D615E06,0x9B7580CA,
	0x407F8800,0x00000000, 0x6D6CA241,0xDFE16A1F,
	0x407F9000,0x00000000, 0x6D779AC6,0x8CA512B5,
	0x407F9800,0x00000000, 0x6D83756D,0x2343CED1,
	0x407FA000,0x00000000, 0x6D900A7D,0xE459292B,
	0x407FA800,0x00000000, 0x6D9A7275,0xD7A7102B,
	0x407FB000,0x00000000, 0x6DA5CD4D,0x0C89278C,
	0x407FB800,0x00000000, 0x6DB1F901,0x3B9BA2D2,
	0x407FC000,0x00000000, 0x6DBDA1C6,0x460D161E,
	0x407FC800,0x00000000, 0x6DC86D69,0xF4CEB104,
	0x407FD000,0x00000000, 0x6DD42311,0x78C235D2,
	0x407FD800,0x00000000, 0x6DE099A2,0xA570BDB7,
	0x407FE000,0x00000000, 0x6DEB5E76,0xD405A221,
	0x407FE800,0x00000000, 0x6DF68FDA,0x6F0C61F9,
	0x407FF000,0x00000000, 0x6E029962,0xD4DE103D,
	0x407FF800,0x00000000, 0x6E0EAA32,0xCF54D288,
	0x40800000,0x00000000, 0x6E194765,0x04BA852E,
	0x40800400,0x00000000, 0x6E24D6C3,0x51CBD815,
	0x40800800,0x00000000, 0x6E312DC4,0xC23C62A5,
	0x40800C00,0x00000000, 0x6E3C52B1,0xD25A4F42,
	0x40801000,0x00000000, 0x6E47592F,0xEDAC601F,
	0x40801400,0x00000000, 0x6E533F5B,0x9C5B963F,
	0x40801800,0x00000000, 0x6E5FBBD6,0xF6C9EBDB,
	0x40801C00,0x00000000, 0x6E6A28F9,0x41BAE076,
	0x40802000,0x00000000, 0x6E7590B8,0xB1A4CEF4,
	0x40802400,0x00000000, 0x6E81C710,0xC163770A,
	0x40802800,0x00000000, 0x6E8D4F70,0x3BD90D4D,
	0x40802C00,0x00000000, 0x6E98298A,0x0CC993FD,
	0x40803000,0x00000000, 0x6EA3EB1D,0x75626C30,
	0x40803400,0x00000000, 0x6EB06B82,0x7E5F8BE7,
	0x40803800,0x00000000, 0x6EBB126A,0x79D0C0EA,
	0x40803C00,0x00000000, 0x6EC65129,0x7D8E68F2,
	0x40804000,0x00000000, 0x6ED265B4,0xB6E28EA1,
	0x40804400,0x00000000, 0x6EDE54FE,0x08CD240F,
	0x40804800,0x00000000, 0x6EE90127,0x6CCC73A1,
	0x40804C00,0x00000000, 0x6EF49CDC,0x006F0249,
	0x40805000,0x00000000, 0x6F00FE08,0xFFC0CA7A,
	0x40805400,0x00000000, 0x6F0C03FE,0xD80D4C64,
	0x40805800,0x00000000, 0x6F17184F,0x8D943F98,
	0x40805C00,0x00000000, 0x6F2309E0,0x51E51706,
	0x40806000,0x00000000, 0x6F2F63A9,0xD76EF559,
	0x40806400,0x00000000, 0x6F39E048,0xDCF8814D,
	0x40806800,0x00000000, 0x6F4554CC,0xAAB0A066,
	0x40806C00,0x00000000, 0x6F5195AB,0x0A777488,
	0x40807000,0x00000000, 0x6F5CFDFE,0xF9A92A43,
	0x40807400,0x00000000, 0x6F67E666,0xBDEF3A8F,
	0x40807800,0x00000000, 0x6F73B3C4,0xEB1A94F3,
	0x40807C00,0x00000000, 0x6F803DE2,0x81C2C541,
	0x40808000,0x00000000, 0x6F8AC731,0x6EE74ED5,
	0x40808400,0x00000000, 0x6F961326,0xBE187EEF,
	0x40808800,0x00000000, 0x6FA23296,0x32777761,
	0x40808C00,0x00000000, 0x6FAE00B6,0x03D812F2,
	0x40809000,0x00000000, 0x6FB8BBAD,0x0103B9D8,
	0x40809400,0x00000000, 0x6FC46395,0x938BC85A,
	0x40809800,0x00000000, 0x6FD0CED1,0xDF6D80DD,
	0x40809C00,0x00000000, 0x6FDBB626,0x8AB15726,
	0x4080A000,0x00000000, 0x6FE6D823,0x71F82D97,
	0x4080A400,0x00000000, 0x6FF2D4F9,0xA26D13FE,
	0x4080A800,0x00000000, 0x6FFF0C71,0xBA5F2499,
	0x4080AC00,0x00000000, 0x70099862,0x72004FAD,
	0x4080B000,0x00000000, 0x70151987,0x23F42CBE,
	0x4080B400,0x00000000, 0x702164CE,0x95459A8C,
	0x4080B800,0x00000000, 0x702CAD70,0x03CABD3E,
	0x4080BC00,0x00000000, 0x7037A3FD,0xFC3446C2,
	0x4080C000,0x00000000, 0x70437D06,0x29EA48C6,
	0x4080C400,0x00000000, 0x705010C1,0x4B7A6398,
	0x4080C800,0x00000000, 0x705A7CC9,0x6822A2C7,
	0x4080CC00,0x00000000, 0x7065D5D0,0x4CA472DF,
	0x4080D000,0x00000000, 0x70720005,0xB89A1B4E,
	0x4080D400,0x00000000, 0x707DAD58,0x2E9A35EF,
	0x4080D800,0x00000000, 0x708876F3,0xA3109AEE,
	0x4080DC00,0x00000000, 0x70942AEE,0x4C12BEDA,
	0x4080E000,0x00000000, 0x70A0A01D,0xF0B89337,
	0x4080E400,0x00000000, 0x70AB6926,0x8AA843DD,
	0x4080E800,0x00000000, 0x70B698A9,0xA5F2BA1D,
	0x4080EC00,0x00000000, 0x70C2A0A5,0xF1084035,
	0x4080F000,0x00000000, 0x70CEB62B,0xF6D099A4,
	0x4080F400,0x00000000, 0x70D95143,0xCF9B2D9B,
	0x4080F800,0x00000000, 0x70E4DEE6,0x4ECAA3C2,
	0x4080FC00,0x00000000, 0x70F13479,0xE46B4387,
	0x40810000,0x00000000, 0x70FC5DC0,0xE57174A2,
	0x40810400,0x00000000, 0x7107624D,0xC13D7A61,
	0x40810800,0x00000000, 0x711346DF,0x86817F67,
	0x40810C00,0x00000000, 0x711FC83A,0xF687D56B,
	0x40811000,0x00000000, 0x712A3330,0x20BB8CF2,
	0x40811400,0x00000000, 0x71359924,0x4A6CFFEF,
	0x40811800,0x00000000, 0x7141CE01,0xBE9C7EC8,
	0x40811C00,0x00000000, 0x714D5AE1,0xFE5C1450,
	0x40812000,0x00000000, 0x715832F9,0x3A863BA1,
	0x40812400,0x00000000, 0x7163F2E4,0x6FCEB111,
	0x40812800,0x00000000, 0x717071EB,0xC718172C,
	0x40812C00,0x00000000, 0x717B1CFC,0x7EEC3ECE,
	0x40813000,0x00000000, 0x718659E0,0x3A0E42FE,
	0x40813400,0x00000000, 0x71926CE3,0xA546A7ED,
	0x40813800,0x00000000, 0x719E60D5,0xEB5D1CE2,
	0x40813C00,0x00000000, 0x71A90AEA,0xCAA96599,
	0x40814000,0x00000000, 0x71B4A4E8,0x6194B8FD,
	0x40814400,0x00000000, 0x71C104AB,0x7EA98433,
	0x40814800,0x00000000, 0x71CC0EEF,0x30A430E4,
	0x40814C00,0x00000000, 0x71D72154,0x0C4FE8F3,
	0x40815000,0x00000000, 0x71E3114F,0x5A338843,
	0x40815400,0x00000000, 0x71EF6FEB,0x695F5590,
	0x40815800,0x00000000, 0x71F9EA63,0x5A38A191,
	0x40815C00,0x00000000, 0x72055D20,0xDDDF347F,
	0x40816000,0x00000000, 0x72119C88,0xBE195116,
	0x40816400,0x00000000, 0x721D0950,0xEF764EBD,
	0x40816800,0x00000000, 0x7227EFBB,0xB4CA4749,
	0x40816C00,0x00000000, 0x7233BB76,0x4957255B,
	0x40817000,0x00000000, 0x72404439,0xF9F70D32,
	0x40817400,0x00000000, 0x724AD1A6,0x14FD78EA,
	0x40817800,0x00000000, 0x72561BC5,0x4435D88C,
	0x40817C00,0x00000000, 0x726239B1,0x2B273C87,
	0x40818000,0x00000000, 0x726E0C6C,0xFDED96E2,
	0x40818400,0x00000000, 0x7278C555,0x3E11BDA3,
	0x40818800,0x00000000, 0x72846B8B,0x97AAAFC3,
	0x40818C00,0x00000000, 0x7290D561,0xEED9AB01,
	0x40819000,0x00000000, 0x729BC0F8,0x7E2A0DC0,
	0x40819400,0x00000000, 0x72A6E10E,0xE24155A0,
	0x40819800,0x00000000, 0x72B2DC54,0x02EA2744,
	0x40819C00,0x00000000, 0x72BF1891,0x3E2C4157,
	0x4081A000,0x00000000, 0x72C9A260,0xDC5CB4DD,
	0x4081A400,0x00000000, 0x72D521C4,0x328C01A7,
	0x4081A800,0x00000000, 0x72E16B99,0x34E80525,
	0x4081AC00,0x00000000, 0x72ECB8A2,0x853DFF35,
	0x4081B000,0x00000000, 0x72F7AD39,0x0504C236,
	0x4081B400,0x00000000, 0x730384A2,0x280306F7,
	0x4081B800,0x00000000, 0x73101707,0x24AA620B,
	0x4081BC00,0x00000000, 0x731A8721,0x00D00771,
	0x4081C000,0x00000000, 0x7325DE56,0xDFA64C4A,
	0x4081C400,0x00000000, 0x7332070C,0xF30B8316,
	0x4081C800,0x00000000, 0x733DB8EE,0x9BA5C134,
	0x4081CC00,0x00000000, 0x73488081,0x0AB0B92E,
	0x4081D000,0x00000000, 0x735432CE,0x314E8E01,
	0x4081D400,0x00000000, 0x7360A69B,0xC3E1DF74,
	0x4081D800,0x00000000, 0x736B73DA,0x6D77A018,
	0x4081DC00,0x00000000, 0x7376A17C,0x4D68BC80,
	0x4081E000,0x00000000, 0x7382A7EB,0xE318D57A,
	0x4081E400,0x00000000, 0x738EC229,0xCB1AE773,
	0x4081E800,0x00000000, 0x73995B26,0x751587AC,
	0x4081EC00,0x00000000, 0x73A4E70C,0x7919F2DB,
	0x4081F000,0x00000000, 0x73B13B31,0xA5110B69,
	0x4081F400,0x00000000, 0x73BC68D4,0x49F14F90,
	0x4081F800,0x00000000, 0x73C76B6F,0x24100909,
	0x4081FC00,0x00000000, 0x73D34E66,0x5FDB74E5,
	0x40820000,0x00000000, 0x73DFD4A3,0xCCCC1D98,
	0x40820400,0x00000000, 0x73EA3D6A,0xFCB9F5F4,
	0x40820800,0x00000000, 0x73F5A193,0x2CDF6917,
	0x40820C00,0x00000000, 0x7401D4F5,0x71AB6520,
	0x40821000,0x00000000, 0x740D6658,0x38D00FAB,
	0x40821400,0x00000000, 0x74183C6C,0x174809B6,
	0x40821800,0x00000000, 0x7423FAAE,0x739E7564,
	0x40821C00,0x00000000, 0x74307857,0x90A9E11D,
	0x40822000,0x00000000, 0x743B2792,0xA49C67FC,
	0x40822400,0x00000000, 0x7446629A,0x5D8F06F0,
	0x40822800,0x00000000, 0x74527415,0x61B0251F,
	0x40822C00,0x00000000, 0x745E6CB2,0x6DBE2191,
	0x40823000,0x00000000, 0x746914B1,0xF86AA42E,
	0x40823400,0x00000000, 0x7474ACF7,0xE7370D42,
	0x40823800,0x00000000, 0x74810B50,0x94C22C64,
	0x40823C00,0x00000000, 0x748C19E3,0xCEA445EB,
	0x40824000,0x00000000, 0x74972A5C,0x1068FC7E,
	0x40824400,0x00000000, 0x74A318C1,0x498EB572,
	0x40824800,0x00000000, 0x74AF7C31,0xC464AE3D,
	0x40824C00,0x00000000, 0x74B9F481,0xC9618A2A,
	0x40825000,0x00000000, 0x74C56578,0x51955475,
	0x40825400,0x00000000, 0x74D1A369,0x20092344,
	0x40825800,0x00000000, 0x74DD14A7,0x50C9D177,
	0x40825C00,0x00000000, 0x74E7F914,0x506E2D4B,
	0x40826000,0x00000000, 0x74F3C32A,0xA887226F,
	0x40826400,0x00000000, 0x75004A93,0xEC0FE5E0,
	0x40826800,0x00000000, 0x750ADC1E,0xD0307635,
	0x40826C00,0x00000000, 0x75162467,0x27DFEA55,
	0x40827000,0x00000000, 0x752240CE,0xEA1148AE,
	0x40827400,0x00000000, 0x752E1828,0x8AFAC41B,
	0x40827800,0x00000000, 0x7538CF01,0x406C6A50,
	0x40827C00,0x00000000, 0x75447384,0xB78AD64D,
	0x40828000,0x00000000, 0x7550DBF4,0x8E430396,
	0x40828400,0x00000000, 0x755BCBCE,0xAB2DC675,
	0x40828800,0x00000000, 0x7566E9FD,0xCE1F593A,
	0x40828C00,0x00000000, 0x7572E3B1,0x42634DFA,
	0x40829000,0x00000000, 0x757F24B5,0x7DC24AC4,
	0x40829400,0x00000000, 0x7589AC63,0x2DABB909,
	0x40829800,0x00000000, 0x75952A04,0x78A2186A,
	0x40829C00,0x00000000, 0x75A17266,0x7B65695A,
	0x4082A000,0x00000000, 0x75ACC3D9,0x65EF8971,
	0x4082A400,0x00000000, 0x75B7B677,0xA87E3AA0,
	0x4082A800,0x00000000, 0x75C38C41,0x1EB69117,
	0x4082AC00,0x00000000, 0x75D01D4F,0x70DD9723,
	0x4082B000,0x00000000, 0x75DA917C,0xA34244DC,
	0x4082B400,0x00000000, 0x75E5E6E0,0xC6DAF0F6,
	0x4082B800,0x00000000, 0x75F20E16,0xEC01BCA6,
	0x4082BC00,0x00000000, 0x75FDC489,0x8EF34728,
	0x4082C000,0x00000000, 0x76088A12,0x2D234B39,
	0x4082C400,0x00000000, 0x76143AB1,0x29A8811A,
	0x4082C800,0x00000000, 0x7620AD1C,0x1FE99A69,
	0x4082CC00,0x00000000, 0x762B7E92,0x7E14C9FD,
	0x4082D000,0x00000000, 0x7636AA52,0x66C63B13,
	0x4082D400,0x00000000, 0x7642AF34,0xAC2B3E94,
	0x4082D800,0x00000000, 0x764ECE2C,0x4E0708BD,
	0x4082DC00,0x00000000, 0x7659650C,0xF6AACCA5,
	0x4082E000,0x00000000, 0x7664EF35,0xD1F7558F,
	0x4082E400,0x00000000, 0x767141EC,0x053383AD,
	0x4082E800,0x00000000, 0x767C73EC,0x01897D05,
	0x4082EC00,0x00000000, 0x76877494,0x1787DA24,
	0x4082F000,0x00000000, 0x769355F0,0x298EC67C,
	0x4082F400,0x00000000, 0x769FE111,0x7B7A5B2A,
	0x4082F800,0x00000000, 0x76AA47A9,0xD744C255,
	0x4082FC00,0x00000000, 0x76B5AA05,0x5A44AC6A,
	0x40830000,0x00000000, 0x76C1DBEB,0xDB9F1388,
	0x40830400,0x00000000, 0x76CD71D2,0xECF3A7E2,
	0x40830800,0x00000000, 0x76D845E2,0xA47F335B,
	0x40830C00,0x00000000, 0x76E4027B,0x82014252,
	0x40831000,0x00000000, 0x76F07EC5,0xDC0F22CC,
	0x40831400,0x00000000, 0x76FB322C,0xEC7DC8B9,
	0x40831800,0x00000000, 0x77066B57,0xE964CB61,
	0x40831C00,0x00000000, 0x77127B49,0xED376130,
	0x40832000,0x00000000, 0x771E7893,0x91BE6C6F,
	0x40832400,0x00000000, 0x77291E7C,0xF78D3A3B,
	0x40832800,0x00000000, 0x7734B50A,0x92901CE5,
	0x40832C00,0x00000000, 0x774111F8,0x430DB506,
	0x40833000,0x00000000, 0x774C24DC,0xB3B87927,
	0x40833400,0x00000000, 0x77573367,0x9B3F6BA0,
	0x40833800,0x00000000, 0x77632036,0x2118BF56,
	0x40833C00,0x00000000, 0x776F887C,0xEA5D5675,
	0x40834000,0x00000000, 0x7779FEA4,0x2BFD8E3D,
	0x40834400,0x00000000, 0x77856DD3,0x07181121,
	0x40834800,0x00000000, 0x7791AA4C,0x3152E3C8,
	0x40834C00,0x00000000, 0x779D2002,0x1F5D81DE,
	0x40835000,0x00000000, 0x77A80270,0x92472297,
	0x40835400,0x00000000, 0x77B3CAE2,0x09D6C9EF,
	0x40835800,0x00000000, 0x77C050F0,0x5904D117,
	0x40835C00,0x00000000, 0x77CAE69B,0xA21858AB,
	0x40836000,0x00000000, 0x77D62D0C,0x6A6719E7,
	0x40836400,0x00000000, 0x77E247EF,0x704AEBCE,
	0x40836800,0x00000000, 0x77EE23E8,0xACC8D097,
	0x40836C00,0x00000000, 0x77F8D8B1,0x098CA7F7,
	0x40837000,0x00000000, 0x78047B80,0xF462F0F4,
	0x40837400,0x00000000, 0x7810E289,0xBEA9AD0F,
	0x40837800,0x00000000, 0x781BD6A9,0x1362CCAD,
	0x40837C00,0x00000000, 0x7826F2F0,0x36EE57E4,
	0x40838000,0x00000000, 0x7832EB11,0x61F782B7,
	0x40838400,0x00000000, 0x783F30DE,0x7AFA66D3,
	0x40838800,0x00000000, 0x7849B669,0x677367A7,
	0x40838C00,0x00000000, 0x78553247,0xF777FAA3,
	0x40839000,0x00000000, 0x78617936,0x69C6D744,
	0x40839400,0x00000000, 0x786CCF14,0xA7945FBE,
	0x40839800,0x00000000, 0x7877BFB9,0xE808F200,
	0x40839C00,0x00000000, 0x788393E3,0x0F2DE2A5,
	0x4083A000,0x00000000, 0x7890239A,0x3108D4F3,
	0x4083A400,0x00000000, 0x789A9BDC,0x510CFF1B,
	0x4083A800,0x00000000, 0x78A5EF6E,0x038F1FC9,
	0x4083AC00,0x00000000, 0x78B21523,0xA48F156A,
	0x4083B000,0x00000000, 0x78BDD029,0x0A47075C,
	0x4083B400,0x00000000, 0x78C893A7,0x0BDD21E0,
	0x4083B800,0x00000000, 0x78D44297,0x3653EDCD,
	0x4083BC00,0x00000000, 0x78E0B39F,0x05CD1ED9,
	0x4083C000,0x00000000, 0x78EB894E,0xBE21778C,
	0x4083C400,0x00000000, 0x78F6B32B,0xF3638E04,
	0x4083C800,0x00000000, 0x7902B680,0x4D5B58B3,
	0x4083CC00,0x00000000, 0x790EDA33,0x816900C0,
	0x4083D000,0x00000000, 0x79196EF7,0x55DCCC33,
	0x4083D400,0x00000000, 0x7924F762,0x5AA0D80D,
	0x4083D800,0x00000000, 0x793148A9,0x05D8DBEA,
	0x4083DC00,0x00000000, 0x793C7F08,0x0DEA4282,
	0x4083E000,0x00000000, 0x79477DBC,0x9D0946AF,
	0x4083E400,0x00000000, 0x79535D7C,0xE4C13674,
	0x4083E800,0x00000000, 0x795FED84,0x0476E1BE,
	0x4083EC00,0x00000000, 0x796A51EC,0xB1EB3496,
	0x4083F000,0x00000000, 0x7975B27A,0xD3E5EC3A,
	0x4083F400,0x00000000, 0x7981E2E4,0xFD86DD3C,
	0x4083F800,0x00000000, 0x798D7D52,0x1C8633E3,
	0x4083FC00,0x00000000, 0x79984F5C,0xE39C7D74,
	0x40840000,0x00000000, 0x79A40A4B,0x9C27178A,
	0x40840400,0x00000000, 0x79B08536,0xAA427701,
	0x40840800,0x00000000, 0x79BB3CCB,0x582D8E5D,
	0x40840C00,0x00000000, 0x79C67418,0xDEE42BB3,
	0x40841000,0x00000000, 0x79D28281,0x48F52492,
	0x40841400,0x00000000, 0x79DE8479,0x592CEC4E,
	0x40841800,0x00000000, 0x79E9284B,0xC98EC768,
	0x40841C00,0x00000000, 0x79F4BD20,0x64DA8058,
	0x40842000,0x00000000, 0x7A0118A2,0x8A8F752B,
	0x40842400,0x00000000, 0x7A0C2FD9,0xE18C5EF9,
	0x40842800,0x00000000, 0x7A173C76,0xAE33B12E,
	0x40842C00,0x00000000, 0x7A2327AD,0xE1F437F9,
	0x40843000,0x00000000, 0x7A2F94CC,0xDD28600F,
	0x40843400,0x00000000, 0x7A3A08CA,0x83979AE6,
	0x40843800,0x00000000, 0x7A457630,0xFFACFA49,
	0x40843C00,0x00000000, 0x7A51B131,0xF302F3F3,
	0x40844000,0x00000000, 0x7A5D2B61,0x5CEBDBE2,
	0x40844400,0x00000000, 0x7A680BD0,0x7BC1EB66,
	0x40844800,0x00000000, 0x7A73D29C,0x6E72CED5,
	0x40844C00,0x00000000, 0x7A80574F,0x41CDB148,
	0x40845000,0x00000000, 0x7A8AF11C,0x8C4DD193,
	0x40845400,0x00000000, 0x7A9635B5,0x0D1C5038,
	0x40845800,0x00000000, 0x7AA24F12,0xBEE9E227,
	0x40845C00,0x00000000, 0x7AAE2FAD,0x6521A4D3,
	0x40846000,0x00000000, 0x7AB8E264,0x9AEBF1DA,
	0x40846400,0x00000000, 0x7AC48380,0x4F6A2E06,
	0x40846800,0x00000000, 0x7AD0E921,0x810E2DE5,
	0x40846C00,0x00000000, 0x7ADBE187,0xB87010B4,
	0x40847000,0x00000000, 0x7AE6FBE6,0x1E0AF908,
	0x40847400,0x00000000, 0x7AF2F274,0x62C63023,
	0x40847800,0x00000000, 0x7AFF3D0C,0x37AE7434,
	0x40847C00,0x00000000, 0x7B09C073,0x8B3A6478,
	0x40848000,0x00000000, 0x7B153A8E,0xB04FAF7C,
	0x40848400,0x00000000, 0x7B218009,0x0115C67D,
	0x40848800,0x00000000, 0x7B2CDA54,0x4BE2308C,
	0x40848C00,0x00000000, 0x7B37C8FF,0xC50DB704,
	0x40849000,0x00000000, 0x7B439B87,0xFA926B13,
	0x40849400,0x00000000, 0x7B5029E7,0x66214D24,
	0x40849800,0x00000000, 0x7B5AA640,0x0BC477DC,
	0x40849C00,0x00000000, 0x7B65F7FE,0x97101993,
	0x4084A000,0x00000000, 0x7B721C33,0x1DC645E8,
	0x4084A400,0x00000000, 0x7B7DDBCD,0x0F65F1F0,
	0x4084A800,0x00000000, 0x7B889D3F,0xA8539F82,
	0x4084AC00,0x00000000, 0x7B944A80,0x5884A1BD,
	0x4084B000,0x00000000, 0x7BA0BA24,0x768A2A6F,
	0x4084B400,0x00000000, 0x7BAB940F,0x2F4001E1,
	0x4084B800,0x00000000, 0x7BB6BC08,0xF49993F9,
	0x4084BC00,0x00000000, 0x7BC2BDCE,0xC7C56FDF,
	0x4084C000,0x00000000, 0x7BCEE63F,0x67158979,
	0x4084C400,0x00000000, 0x7BD978E5,0x942DECA5,
	0x4084C800,0x00000000, 0x7BE4FF92,0x145502B2,
	0x4084CC00,0x00000000, 0x7BF14F68,0xA807AA17,
	0x4084D000,0x00000000, 0x7BFC8A28,0x70C48E4E,
	0x4084D400,0x00000000, 0x7C0786E8,0xB5F932C9,
	0x4084D800,0x00000000, 0x7C13650C,0x9298F9CA,
	0x4084DC00,0x00000000, 0x7C1FF9FB,0x69A6C20B,
	0x4084E000,0x00000000, 0x7C2A5C33,0x8E3D2B1E,
	0x4084E400,0x00000000, 0x7C35BAF3,0x9B0CCB5A,
	0x4084E800,0x00000000, 0x7C41E9E0,0xD8727F6B,
	0x4084EC00,0x00000000, 0x7C4D88D5,0xC947B945,
	0x4084F000,0x00000000, 0x7C5858DA,0xD6113CE5,
	0x4084F400,0x00000000, 0x7C64121E,0xC3406B6B,
	0x4084F800,0x00000000, 0x7C708BA9,0xFC3EDA5B,
	0x4084FC00,0x00000000, 0x7C7B476D,0xE9498794,
	0x40850000,0x00000000, 0x7C867CDD,0x3F624846,
	0x40850400,0x00000000, 0x7C9289BB,0x7602A557,
	0x40850800,0x00000000, 0x7C9E9063,0xC5D944BE,
	0x40850C00,0x00000000, 0x7CA9321E,0x6FED805D,
	0x40851000,0x00000000, 0x7CB4C539,0x5F514AE2,
	0x40851400,0x00000000, 0x7CC11F4F,0x6C4B292A,
	0x40851800,0x00000000, 0x7CCC3ADB,0x59CC32B6,
	0x40851C00,0x00000000, 0x7CD74589,0x4AA6D19C,
	0x40852000,0x00000000, 0x7CE32F28,0x8D4422DA,
	0x40852400,0x00000000, 0x7CEFA121,0x9EA597F3,
	0x40852800,0x00000000, 0x7CFA12F4,0xD1BB3776,
	0x40852C00,0x00000000, 0x7D057E92,0x3C9A1ED2,
	0x40853000,0x00000000, 0x7D11B81A,0x66261DE4,
	0x40853400,0x00000000, 0x7D1D36C5,0x0B300837,
	0x40853800,0x00000000, 0x7D281534,0x0E4BDA5E,
	0x40853C00,0x00000000, 0x7D33DA59,0xD7885985,
	0x40854000,0x00000000, 0x7D405DB0,0xA762C9AC,
	0x40854400,0x00000000, 0x7D4AFBA1,0x906A31C7,
	0x40854800,0x00000000, 0x7D563E61,0x1150F9CC,
	0x40854C00,0x00000000, 0x7D625638,0xD704546A,
	0x40855000,0x00000000, 0x7D6E3B76,0xB5CFDC19,
	0x40855400,0x00000000, 0x7D78EC1B,0xF604569E,
	0x40855800,0x00000000, 0x7D848B82,0xC9D83550,
	0x40855C00,0x00000000, 0x7D90EFBB,0xD67170B8,
	0x40856000,0x00000000, 0x7D9BEC6A,0x9BFD27F8,
	0x40856400,0x00000000, 0x7DA704DF,0x84D26C33,
	0x40856800,0x00000000, 0x7DB2F9DA,0x45EF311F,
	0x40856C00,0x00000000, 0x7DBF493E,0xB5B90A9E,
	0x40857000,0x00000000, 0x7DC9CA81,0x9A87EBC5,
	0x40857400,0x00000000, 0x7DD542D8,0xA46BBBDB,
	0x40857800,0x00000000, 0x7DE186DE,0x425C1646,
	0x40857C00,0x00000000, 0x7DECE598,0x548F5530,
	0x40858000,0x00000000, 0x7DF7D249,0x40F5E537,
	0x40858400,0x00000000, 0x7E03A32F,0xE20E0DF7,
	0x40858800,0x00000000, 0x7E103037,0x111C911B,
	0x40858C00,0x00000000, 0x7E1AB0A7,0xD4FD8EA4,
	0x40859000,0x00000000, 0x7E260092,0x82ABA144,
	0x40859400,0x00000000, 0x7E322345,0x58BA71EC,
	0x40859800,0x00000000, 0x7E3DE775,0xA015A7E4,
	0x40859C00,0x00000000, 0x7E48A6DC,0x03FCB84B,
	0x4085A000,0x00000000, 0x7E54526C,0x916EE2BF,
	0x4085A400,0x00000000, 0x7E60C0AC,0x731EDDEE,
	0x4085A800,0x00000000, 0x7E6B9ED3,0xD3136570,
	0x4085AC00,0x00000000, 0x7E76C4E9,0x6BC1B23B,
	0x4085B000,0x00000000, 0x7E82C520,0x1C863F21,
	0x4085B400,0x00000000, 0x7E8EF250,0x00E213E6,
	0x4085B800,0x00000000, 0x7E9982D7,0xB3212B2C,
	0x4085BC00,0x00000000, 0x7EA507C5,0x0052DA3B,
	0x4085C000,0x00000000, 0x7EB1562A,0xECC6EAB2,
	0x4085C400,0x00000000, 0x7EBC954D,0x2BC9F7BC,
	0x4085C800,0x00000000, 0x7EC79018,0x63BD0DEC,
	0x4085CC00,0x00000000, 0x7ED36C9F,0x343CB85C,
	0x4085D000,0x00000000, 0x7EE0033B,0xD677E517,
	0x4085D400,0x00000000, 0x7EEA667E,0x6DCB2072,
	0x4085D800,0x00000000, 0x7EF5C36F,0xB1036D55,
	0x4085DC00,0x00000000, 0x7F01F0DF,0x6D72215E,
	0x4085E000,0x00000000, 0x7F0D945D,0xF4F8EC8E,
	0x4085E400,0x00000000, 0x7F18625C,0x7D4F56C2,
	0x4085E800,0x00000000, 0x7F2419F4,0xF87E2B37,
	0x4085EC00,0x00000000, 0x7F30921F,0xD2FFAB7C,
	0x4085F000,0x00000000, 0x7F3B5214,0xA170249D,
	0x4085F400,0x00000000, 0x7F4685A5,0x0C34C6AA,
	0x4085F800,0x00000000, 0x7F5290F8,0x75798760,
	0x4085FC00,0x00000000, 0x7F5E9C52,0xD993CE57,
	0x40860000,0x00000000, 0x7F693BF4,0xEC282EFB,
	0x40860400,0x00000000, 0x7F74CD55,0x83300AD2,
	0x40860800,0x00000000, 0x7F8125FE,0xE944F2C3,
	0x40860C00,0x00000000, 0x7F8C45E1,0x1E24D6E6,
	0x40861000,0x00000000, 0x7F974E9F,0x71FA5B35,
	0x40861400,0x00000000, 0x7FA336A6,0x242BF518,
	0x40861800,0x00000000, 0x7FAFAD7B,0x30B5865E,
	0x40861C00,0x00000000, 0x7FBA1D23,0x17F485AA,
	0x40862000,0x00000000, 0x7FC586F6,0xBF260CF1,
	0x40862400,0x00000000, 0x7FD1BF05,0x8BC994AD,
	0x40862800,0x00000000, 0x7FDD422D,0x2BE5DC9B,
	0xBFE00000,0x00000000, 0x3FE368B2,0xFC6F960A,
	0xBFF00000,0x00000000, 0x3FD78B56,0x362CEF38,
	0xBFF80000,0x00000000, 0x3FCC8F87,0x724B5C1D,
	0xC0000000,0x00000000, 0x3FC152AA,0xA3BF81CC,
	0xC0040000,0x00000000, 0x3FB50385,0xC094F425,
	0xC0080000,0x00000000, 0x3FA97DB0,0xCCCEB0AF,
	0xC00C0000,0x00000000, 0x3F9EEC10,0x18E4FF66,
	0xC0100000,0x00000000, 0x3F92C155,0xB8213CF4,
	0xC0120000,0x00000000, 0x3F86C050,0x4695C417,
	0xC0140000,0x00000000, 0x3F7B993F,0xE00D5376,
	0xC0160000,0x00000000, 0x3F70BD4A,0x5ACA7728,
	0xC0180000,0x00000000, 0x3F644E51,0xF113D4D6,
	0xC01A0000,0x00000000, 0x3F58A1E1,0x8A954FFA,
	0xC01C0000,0x00000000, 0x3F4DE16B,0x9C24A98F,
	0xC01E0000,0x00000000, 0x3F421F9B,0xA40F31D5,
	0xC0200000,0x00000000, 0x3F35FC21,0x041027AD,
	0xC0210000,0x00000000, 0x3F2AAB43,0xFB3940A1,
	0xC0220000,0x00000000, 0x3F202CF2,0x2526545A,
	0xC0230000,0x00000000, 0x3F139F38,0xA5498FE2,
	0xC0240000,0x00000000, 0x3F07CD79,0xB5647C9B,
	0xC0250000,0x00000000, 0x3EFCDFC2,0x63F6A0BA,
	0xC0260000,0x00000000, 0x3EF18354,0x238F6764,
	0xC0270000,0x00000000, 0x3EE53E8D,0x76780B04,
	0xC0280000,0x00000000, 0x3ED9C54C,0x3B43BC8B,
	0xC0290000,0x00000000, 0x3ECF42ED,0x3F68E690,
	0xC02A0000,0x00000000, 0x3EC2F605,0x3B981D98,
	0xC02B0000,0x00000000, 0x3EB70039,0x74E945DF,
	0xC02C0000,0x00000000, 0x3EABE6C6,0xFDB01612,
	0xC02D0000,0x00000000, 0x3EA0EC50,0x3D2696E8,
	0xC02E0000,0x00000000, 0x3E94875C,0xA227EC38,
	0xC02F0000,0x00000000, 0x3E88E713,0x8077168D,
	0xC0300000,0x00000000, 0x3E7E355B,0xBAEE85CB,
	0xC0308000,0x00000000, 0x3E725284,0xD838EF8C,
	0xC0310000,0x00000000, 0x3E6639E3,0x175A689D,
	0xC0318000,0x00000000, 0x3E5AF62E,0x927C4664,
	0xC0320000,0x00000000, 0x3E505A62,0x8C699FA1,
	0xC0328000,0x00000000, 0x3E43D657,0x76D812BC,
	0xC0330000,0x00000000, 0x3E381056,0xFF2C5772,
	0xC0338000,0x00000000, 0x3E2D30DE,0xB5F04C13,
	0xC0340000,0x00000000, 0x3E21B486,0x55F37267,
	0xC0348000,0x00000000, 0x3E157A3A,0xFEED00AB,
	0xC0350000,0x00000000, 0x3E0A0DB0,0xD0DDB3EC,
	0xC0358000,0x00000000, 0x3DFF9ABE,0x68B14E81,
	0xC0360000,0x00000000, 0x3DF32B48,0xBF117DA2,
	0xC0368000,0x00000000, 0x3DE740D6,0x2BB76E50,
	0xC0370000,0x00000000, 0x3DDC3527,0xE433FAB1,
	0xC0378000,0x00000000, 0x3DD11BDA,0x375761F2,
	0xC0380000,0x00000000, 0x3DC4C107,0x8FE9228A,
	0xC0388000,0x00000000, 0x3DB92D07,0xD6F15A44,
	0xC0390000,0x00000000, 0x3DAE8A37,0xA45FC32E,
	0xC0398000,0x00000000, 0x3DA285FD,0x102F8A43,
	0xC03A0000,0x00000000, 0x3D967852,0xA7007E42,
	0xC03A8000,0x00000000, 0x3D8B41EB,0x9CA96642,
	0xC03B0000,0x00000000, 0x3D808852,0x98767E9A,
	0xC03B8000,0x00000000, 0x3D740E11,0x1F58FA5B,
	0xC03C0000,0x00000000, 0x3D6853F0,0x1D6D53BA,
	0xC03C8000,0x00000000, 0x3D5D82DE,0xE15411B1,
	0xC03D0000,0x00000000, 0x3D51E642,0xBAEB84A0,
	0xC03D8000,0x00000000, 0x3D45B690,0x2BC47821,
	0xC03E0000,0x00000000, 0x3D3A56E0,0xC2AC7F75,
	0xC03E8000,0x00000000, 0x3D2FF386,0x4232B407,
	0xC03F0000,0x00000000, 0x3D236121,0xE24D3BBA,
	0xC03F8000,0x00000000, 0x3D178228,0x63549FCE,
	0xC0400000,0x00000000, 0x3D0C8464,0xF7616468,
	0xC0404000,0x00000000, 0x3D014BE9,0xBC6D7C42,
	0xC0408000,0x00000000, 0x3CF4FB54,0x7C775DA8,
	0xC040C000,0x00000000, 0x3CE973C0,0xB00B76CB,
	0xC0410000,0x00000000, 0x3CDEE001,0xEED62AA0,
	0xC0414000,0x00000000, 0x3CD2BA05,0xDDB1DAE4,
	0xC0418000,0x00000000, 0x3CC6B771,0x9A59F0E0,
	0xC041C000,0x00000000, 0x3CBB8E7D,0x68ED96BA,
	0xC0420000,0x00000000, 0x3CB0B6C3,0xAFDDE064,
	0xC0424000,0x00000000, 0x3CA44667,0x51C2BBE8,
	0xC0428000,0x00000000, 0x3C989847,0x1FCA6055,
	0xC042C000,0x00000000, 0x3C8DD5C5,0x66301EC8,
	0xC0430000,0x00000000, 0x3C82188A,0xD6AE3303,
	0xC0434000,0x00000000, 0x3C75F38E,0xD3EB9BDB,
	0xC0438000,0x00000000, 0x3C6AA0DE,0x4BF35B38,
	0xC043C000,0x00000000, 0x3C6026A3,0xC0738CFF,
	0xC0440000,0x00000000, 0x3C539792,0x499B1A24,
	0xC0444000,0x00000000, 0x3C47C432,0x199DF55A,
	0xC0448000,0x00000000, 0x3C3CD480,0xA1B74820,
	0xC044C000,0x00000000, 0x3C317C80,0x438BE74E,
	0xC0450000,0x00000000, 0x3C253645,0x2EE2F75C,
	0xC0454000,0x00000000, 0x3C19BB40,0x33CAA3AE,
	0xC0458000,0x00000000, 0x3C0F36BD,0x37F42F3E,
	0xC045C000,0x00000000, 0x3C02EEA0,0xD6E74738,
	0xC0460000,0x00000000, 0x3BF6F741,0xDE1748EC,
	0xC0464000,0x00000000, 0x3BEBDBE6,0x4CF27CD4,
	0xC0468000,0x00000000, 0x3BE0E5B7,0x3D1FF53D,
	0xC046C000,0x00000000, 0x3BD47F5B,0xC5D1A914,
	0xC0470000,0x00000000, 0x3BC8DD5E,0x1BB09D7E,
	0xC0474000,0x00000000, 0x3BBE2994,0xCB989E2F,
	0xC0478000,0x00000000, 0x3BB24B60,0x31B49BDA,
	0xC047C000,0x00000000, 0x3BA63138,0xD37A798A,
	0xC0480000,0x00000000, 0x3B9AEBAB,0xAE3A41B5,
	0xC0484000,0x00000000, 0x3B905402,0x70B1952E,
	0xC0488000,0x00000000, 0x3B83CE9B,0x9DE78F85,
	0xC048C000,0x00000000, 0x3B7806F5,0x5208CE4F,
	0xC0490000,0x00000000, 0x3B6D257D,0x547E083F,
	0xC0494000,0x00000000, 0x3B61AD9F,0x47F3722A,
	0xC0498000,0x00000000, 0x3B5571DB,0x733A9D61,
	0xC049C000,0x00000000, 0x3B4A0388,0x9042C921,
	0xC04A0000,0x00000000, 0x3B3F8E6C,0x24B5592E,
	0xC04A4000,0x00000000, 0x3B3323CF,0x966C2424,
	0xC04A8000,0x00000000, 0x3B2737C5,0x645114B5,
	0xC04AC000,0x00000000, 0x3B1C2A28,0xA4F0A533,
	0xC04B0000,0x00000000, 0x3B11152E,0xAEB73C08,
	0xC04B4000,0x00000000, 0x3B04B8F0,0x3815586B,
	0xC04B8000,0x00000000, 0x3AF92337,0x2C67A074,
	0xC04BC000,0x00000000, 0x3AEE7E4F,0x9FBB7321,
	0xC04C0000,0x00000000, 0x3AE27EC4,0x58C65E3C,
	0xC04C4000,0x00000000, 0x3AD66F90,0x0BC28643,
	0xC04C8000,0x00000000, 0x3ACB374B,0x315F87C1,
	0xC04CC000,0x00000000, 0x3AC081E0,0x93F5C945,
	0xC04D0000,0x00000000, 0x3AB4063F,0x8CC8BB98,
	0xC04D4000,0x00000000, 0x3AA84A74,0x15B285CB,
	0xC04D8000,0x00000000, 0x3A9D775D,0x87DA854D,
	0xC04DC000,0x00000000, 0x3A91DF48,0x490E49C9,
	0xC04E0000,0x00000000, 0x3A85AE19,0x1A99585A,
	0xC04E4000,0x00000000, 0x3A7A4C9B,0xF9A78412,
	0xC04E8000,0x00000000, 0x3A6FE711,0x6182E9CC,
	0xC04EC000,0x00000000, 0x3A635993,0xBB5E3AAB,
	0xC04F0000,0x00000000, 0x3A5778FE,0x2497184C,
	0xC04F4000,0x00000000, 0x3A4C7946,0xD3C1F04A,
	0xC04F8000,0x00000000, 0x3A41452B,0x7723AED2,
	0xC04FC000,0x00000000, 0x3A34F326,0x69FE335C,
	0xC0500000,0x00000000, 0x3A2969D4,0x7321E4CC,
	0xC0502000,0x00000000, 0x3A1ED3F8,0x77F42B71,
	0xC0504000,0x00000000, 0x3A12B2B8,0xDD05B318,
	0xC0506000,0x00000000, 0x3A06AE96,0x635D4B6B,
	0xC0508000,0x00000000, 0x39FB83BF,0x23A9A9EB,
	0xC050A000,0x00000000, 0x39F0B03F,0x90454DE5,
	0xC050C000,0x00000000, 0x39E43E7F,0xC88B8056,
	0xC050E000,0x00000000, 0x39D88EB0,0x7370563C,
	0xC0510000,0x00000000, 0x39CDCA23,0xBAE16424,
	0xC0512000,0x00000000, 0x39C2117C,0xCA7BA9B9,
	0xC0514000,0x00000000, 0x39B5EAFF,0xFB34BA31,
	0xC0516000,0x00000000, 0x39AA967C,0xAA5D5A0C,
	0xC0518000,0x00000000, 0x39A02057,0xD1245CEB,
	0xC051A000,0x00000000, 0x39938FEE,0xE9697020,
	0xC051C000,0x00000000, 0x3987BAEE,0x1BFFA80B,
	0xC051E000,0x00000000, 0x397CC943,0x42F43262,
	0xC0520000,0x00000000, 0x397175AF,0x0CF60EC5,
	0xC0522000,0x00000000, 0x39652E00,0x21EB2A50,
	0xC0524000,0x00000000, 0x3959B138,0x170D6BFE,
	0xC0526000,0x00000000, 0x394F2A91,0xF0E029BF,
	0xC0528000,0x00000000, 0x3942E73F,0x53FBA844,
	0xC052A000,0x00000000, 0x3936EE4D,0xC63B3CDC,
	0xC052C000,0x00000000, 0x392BD109,0xD9D94BDA,
	0xC052E000,0x00000000, 0x3920DF20,0xCF930023,
	0xC0530000,0x00000000, 0x3914775E,0x0840BFDD,
	0xC0532000,0x00000000, 0x3908D3AC,0x7FDF6990,
	0xC0534000,0x00000000, 0x38FE1DD2,0x73AA8A4A,
	0xC0536000,0x00000000, 0x38F2443E,0x541BADB8,
	0xC0538000,0x00000000, 0x38E62891,0xF06B3450,
	0xC053A000,0x00000000, 0x38DAE12C,0xE30B1D65,
	0xC053C000,0x00000000, 0x38D04DA4,0xD1452919,
	0xC053E000,0x00000000, 0x38C3C6E2,0xC8D491E3,
	0xC0540000,0x00000000, 0x38B7FD97,0x4D372E45,
	0xC0542000,0x00000000, 0x38AD1A20,0x62DC07E6,
	0xC0544000,0x00000000, 0x38A1A6BA,0xEADB4FD1,
	0xC0546000,0x00000000, 0x3895697F,0x2B378F40,
	0xC0548000,0x00000000, 0x3889F964,0x45648B9F,
	0xC054A000,0x00000000, 0x387F821E,0xAE730856,
	0xC054C000,0x00000000, 0x38731C59,0x57A47DE2,
	0xC054E000,0x00000000, 0x38672EB8,0x25B2B8BA,
	0xC0550000,0x00000000, 0x385C1F2D,0xAF3B6A46,
	0xC0552000,0x00000000, 0x38510E85,0xBFCA7EB3,
	0xC0554000,0x00000000, 0x3844B0DC,0x07CABF98,
	0xC0556000,0x00000000, 0x3839196A,0x5575168A,
	0xC0558000,0x00000000, 0x382E726C,0x3F64D0FE,
	0xC055A000,0x00000000, 0x3822778E,0x721B447B,
	0xC055C000,0x00000000, 0x381666D0,0xDAD2961D,
	0xC055E000,0x00000000, 0x380B2CAE,0xEAAB824A,
	0xC0560000,0x00000000, 0x38007B71,0x12BC1FFE,
	0xC0562000,0x00000000, 0x37F3FE71,0x068E4512,
	0xC0564000,0x00000000, 0x37E840FB,0xC08FDC8A,
	0xC0566000,0x00000000, 0x37DD6BE0,0xAAA7DE99,
	0xC0568000,0x00000000, 0x37D1D850,0x8FA8246A,
	0xC056A000,0x00000000, 0x37C5A5A5,0x56491736,
	0xC056C000,0x00000000, 0x37BA425B,0x317EEACD,
	0xC056E000,0x00000000, 0x37AFDAA1,0x5C0B3550,
	0xC0570000,0x00000000, 0x37A35208,0x867C2683,
	0xC0572000,0x00000000, 0x37976FD7,0x788F3169,
	0xC0574000,0x00000000, 0x378C6E2D,0x05BBC000,
	0xC0576000,0x00000000, 0x37813E6F,0xD2DB521B,
	0xC0578000,0x00000000, 0x3774EAFB,0x87EAB0F2,
	0xC057A000,0x00000000, 0x37695FEC,0x148F4BA7,
	0xC057C000,0x00000000, 0x375EC7F3,0xB269EFA8,
	0xC057E000,0x00000000, 0x3752AB6E,0xB5004409,
	0xC0580000,0x00000000, 0x3746A5BE,0xA046B42E,
	0xC0582000,0x00000000, 0x373B7905,0x0E9EE533,
	0xC0584000,0x00000000, 0x3730A9BD,0xFB02D240,
	0xC0586000,0x00000000, 0x3724369B,0x543A1A8B,
	0xC0588000,0x00000000, 0x3718851D,0x84118908,
	0xC058A000,0x00000000, 0x370DBE86,0x98733444,
	0xC058C000,0x00000000, 0x37020A71,0x7E64A9BD,
	0xC058E000,0x00000000, 0x36F5E274,0x789E0327,
	0xC0590000,0x00000000, 0x36EA8C1F,0x14E2AF5D,
	0xC0592000,0x00000000, 0x36E01A0E,0x5643644F,
	0xC0594000,0x00000000, 0x36D3884E,0x838AEA68,
	0xC0596000,0x00000000, 0x36C7B1AD,0xBB20821C,
	0xC0598000,0x00000000, 0x36BCBE0A,0x45F75EB1,
	0xC059A000,0x00000000, 0x36B16EE0,0x7EC4343B,
	0xC059C000,0x00000000, 0x36A525BE,0x4E4E601D,
	0xC059E000,0x00000000, 0x3699A733,0xE3852834,
	0xC05A0000,0x00000000, 0x368F1E6B,0x68529E33,
	0xC05A2000,0x00000000, 0x3682DFE0,0xB1B59FFF,
	0xC05A4000,0x00000000, 0x3676E55D,0x2BF838A7,
	0xC05A6000,0x00000000, 0x366BC631,0xA2BD4340,
	0xC05A8000,0x00000000, 0x3660D88C,0xF37F00DD,
	0xC05AA000,0x00000000, 0x36546F63,0x683DC7B6,
	0xC05AC000,0x00000000, 0x3648C9FE,0xAB89B876,
	0xC05AE000,0x00000000, 0x363E1214,0xB15A0B71,
	0xC05B0000,0x00000000, 0x36323D1F,0x3E5834A0,
	0xC05B2000,0x00000000, 0x36261FEE,0x6CDB7090,
	0xC05B4000,0x00000000, 0x361AD6B2,0x2F55DB42,
	0xC05B6000,0x00000000, 0x36104749,0xAD2C4A4B,
	0xC05B8000,0x00000000, 0x3603BF2C,0xF6722E46,
	0xC05BA000,0x00000000, 0x35F7F43C,0xEF4A6E74,
	0xC05BC000,0x00000000, 0x35ED0EC7,0xDF4F7BD4,
	0xC05BE000,0x00000000, 0x35E19FD9,0x3D9E7785,
	0xC05C0000,0x00000000, 0x35D56126,0x259E093C,
	0xC05C2000,0x00000000, 0x35C9EF43,0xEEB7C3F7,
	0xC05C4000,0x00000000, 0x35BF75D6,0x040AEFF6,
	0xC05C6000,0x00000000, 0x35B314E6,0x0197C223,
	0xC05C8000,0x00000000, 0x35A725AE,0x6E7B9D35,
	0xC05CA000,0x00000000, 0x359C1437,0x01686511,
	0xC05CC000,0x00000000, 0x359107DF,0x698DA211,
	0xC05CE000,0x00000000, 0x3584A8CA,0xFDCE846A,
	0xC05D0000,0x00000000, 0x35790FA1,0x509BD50D,
	0xC05D2000,0x00000000, 0x356E668D,0x818C96D5,
	0xC05D4000,0x00000000, 0x3562705B,0x5B153FB8,
	0xC05D6000,0x00000000, 0x35565E15,0x12DBD252,
	0xC05D8000,0x00000000, 0x354B2216,0xC6EFDAC1,
	0xC05DA000,0x00000000, 0x35407504,0x13CEB8D6,
	0xC05DC000,0x00000000, 0x3533F6A5,0x8B795DE3,
	0xC05DE000,0x00000000, 0x35283787,0x1C944DAC,
	0xC05E0000,0x00000000, 0x351D6068,0x47FC727A,
	0xC05E2000,0x00000000, 0x3511D15B,0x8DA98E36,
	0xC05E4000,0x00000000, 0x35059D34,0xDD8A5473,
	0xC05E6000,0x00000000, 0x34FA381E,0x68A32600,
	0xC05E8000,0x00000000, 0x34EFCE36,0x2FE6E7D0,
	0xC05EA000,0x00000000, 0x34E34A80,0x428105AF,
	0xC05EC000,0x00000000, 0x34D766B4,0x5DD84F18,
	0xC05EE000,0x00000000, 0x34CC6317,0x8B9E3CB0,
	0xC05F0000,0x00000000, 0x34C137B6,0xCE8E052C,
	0xC05F2000,0x00000000, 0x34B4E2D3,0xD4FE8E61,
	0xC05F4000,0x00000000, 0x34A95607,0x92D19314,
	0xC05F6000,0x00000000, 0x349EBBF3,0x9C631BF2,
	0xC05F8000,0x00000000, 0x3492A427,0x64857B19,
	0xC05FA000,0x00000000, 0x34869CEA,0x4FBD922A,
	0xC05FC000,0x00000000, 0x347B6E4F,0x282B43F4,
	0xC05FE000,0x00000000, 0x3470A33E,0xEF18E303,
	0xC0600000,0x00000000, 0x34642EB9,0xF39AFB0B,
	0xC0601000,0x00000000, 0x34587B8E,0x5038E1C3,
	0xC0602000,0x00000000, 0x344DB2ED,0xFD20FA7C,
	0xC0603000,0x00000000, 0x34420368,0xF156B202,
	0xC0604000,0x00000000, 0x3435D9EC,0x4ADA7938,
	0xC0605000,0x00000000, 0x342A81C5,0x89EF6B20,
	0xC0606000,0x00000000, 0x342013C7,0x4EDBA307,
	0xC0607000,0x00000000, 0x341380B1,0x16D6559C,
	0xC0608000,0x00000000, 0x3407A870,0xF597FDBD,
	0xC0609000,0x00000000, 0x33FCB2D5,0xA90B7702,
	0xC060A000,0x00000000, 0x33F16814,0x97ED15B3,
	0xC060B000,0x00000000, 0x33E51D7F,0xB2CAD2A2,
	0xC060C000,0x00000000, 0x33D99D33,0x97AB8371,
	0xC060D000,0x00000000, 0x33CF1249,0x9C720D9D,
	0xC060E000,0x00000000, 0x33C2D884,0xEEF5FDCB,
	0xC060F000,0x00000000, 0x33B6DC70,0x0DF1DB4B,
	0xC0610000,0x00000000, 0x33ABBB5D,0xA5F7C823,
	0xC0611000,0x00000000, 0x33A0D1FB,0xA7E3A4C0,
	0xC0612000,0x00000000, 0x3394676B,0xE491D129,
	0xC0613000,0x00000000, 0x3388C054,0x9D365B29,
	0xC0614000,0x00000000, 0x337E065B,0x82DD95A0,
	0xC0615000,0x00000000, 0x33723602,0xEF54AC69,
	0xC0616000,0x00000000, 0x3366174E,0x477A895F,
	0xC0617000,0x00000000, 0x335ACC3B,0x91821C8E,
	0xC0618000,0x00000000, 0x335040F1,0x036F4863,
	0xC0619000,0x00000000, 0x3343B77A,0x2593EE6B,
	0xC061A000,0x00000000, 0x3337EAE6,0x36D6144E,
	0xC061B000,0x00000000, 0x332D0373,0xC81E4174,
	0xC061C000,0x00000000, 0x332198FA,0x3F30BE25,
	0xC061D000,0x00000000, 0x331558D0,0x6128BD4E,
	0xC061E000,0x00000000, 0x3309E527,0x8AB1D4CF,
	0xC061F000,0x00000000, 0x32FF6992,0x239E5EF6,
	0xC0620000,0x00000000, 0x32F30D75,0x9323998C,
	0xC0621000,0x00000000, 0x32E71CA8,0x3D4B8E80,
	0xC0622000,0x00000000, 0x32DC0944,0x99CC578E,
	0xC0623000,0x00000000, 0x32D1013B,0xAAFD836F,
	0xC0624000,0x00000000, 0x32C4A0BD,0x18E64DF7,
	0xC0625000,0x00000000, 0x32B905DC,0x1C5E896B,
	0xC0626000,0x00000000, 0x32AE5AB3,0x64643354,
	0xC0627000,0x00000000, 0x32A2692B,0x129BC035,
	0xC0628000,0x00000000, 0x3296555C,0xB289E44B,
	0xC0629000,0x00000000, 0x328B1782,0xC48FB740,
	0xC062A000,0x00000000, 0x32806E99,0x96332BA1,
	0xC062B000,0x00000000, 0x3273EEDD,0x1A5A43C3,
	0xC062C000,0x00000000, 0x32682E16,0x284F5EC5,
	0xC062D000,0x00000000, 0x325D54F4,0x5E194458,
	0xC062E000,0x00000000, 0x3251CA69,0x42036ABB,
	0xC062F000,0x00000000, 0x324594C7,0xAF143039,
	0xC0630000,0x00000000, 0x323A2DE5,0x9D8543CC,
	0xC0631000,0x00000000, 0x322FC1CF,0xDB320F7E,
	0xC0632000,0x00000000, 0x322342FA,0xEE475139,
	0xC0633000,0x00000000, 0x32175D94,0xD30E6053,
	0xC0634000,0x00000000, 0x320C5806,0x63B97826,
	0xC0635000,0x00000000, 0x32013100,0x6935CD61,
	0xC0636000,0x00000000, 0x31F4DAAF,0x4FFBFFB3,
	0xC0637000,0x00000000, 0x31E94C26,0xEC673952,
	0xC0638000,0x00000000, 0x31DEAFF8,0x340C0B95,
	0xC0639000,0x00000000, 0x31D29CE2,0xEA79B46A,
	0xC063A000,0x00000000, 0x31C69419,0x7069D2BB,
	0xC063B000,0x00000000, 0x31BB639D,0x6EAD6486,
	0xC063C000,0x00000000, 0x31B09CC2,0x6B8A5898,
	0xC063D000,0x00000000, 0x31A426DB,0xA57B0A42,
	0xC063E000,0x00000000, 0x31987202,0xD671DAE5,
	0xC063F000,0x00000000, 0x318DA759,0xE726D293,
	0xC0640000,0x00000000, 0x3181FC63,0x223FAC81,
	0xC0641000,0x00000000, 0x3175D167,0x709DA0B4,
	0xC0642000,0x00000000, 0x316A7770,0x07F03AC8,
	0xC0643000,0x00000000, 0x31600D82,0xB9F87871,
	0xC0644000,0x00000000, 0x31537916,0xA222F236,
	0xC0645000,0x00000000, 0x31479F37,0xC9FE21AD,
	0xC0646000,0x00000000, 0x313CA7A5,0x6A7BCFC8,
	0xC0647000,0x00000000, 0x3131614B,0x5767D89A,
	0xC0648000,0x00000000, 0x31251544,0x4E1F3930,
	0xC0649000,0x00000000, 0x31199337,0x31FAC105,
	0xC064A000,0x00000000, 0x310F062C,0x8B65B198,
	0xC064B000,0x00000000, 0x3102D12C,0x0A9E0104,
	0xC064C000,0x00000000, 0x30F6D386,0x6ACC4B97,
	0xC064D000,0x00000000, 0x30EBB08D,0xE1E2E463,
	0xC064E000,0x00000000, 0x30E0CB6C,0xEBC0FD13,
	0xC064F000,0x00000000, 0x30D45F77,0x7C0665F8,
	0xC0650000,0x00000000, 0x30C8B6AE,0x536CB5AF,
	0xC0651000,0x00000000, 0x30BDFAA6,0xE66C4F31,
	0xC0652000,0x00000000, 0x30B22EE9,0x65FBFD1B,
	0xC0653000,0x00000000, 0x30A60EB1,0x7EF85D0D,
	0xC0654000,0x00000000, 0x309AC1C9,0x07F821BE,
	0xC0655000,0x00000000, 0x30903A9A,0xD316D390,
	0xC0656000,0x00000000, 0x3083AFCA,0x550DD136,
	0xC0657000,0x00000000, 0x3077E193,0x226E335D,
	0xC0658000,0x00000000, 0x306CF824,0x1B8EE293,
	0xC0659000,0x00000000, 0x3061921D,0xEE86611D,
	0xC065A000,0x00000000, 0x3055507D,0xDC92DC42,
	0xC065B000,0x00000000, 0x3049DB0F,0x17C8BAA3,
	0xC065C000,0x00000000, 0x303F5D53,0x0B4F5EDD,
	0xC065D000,0x00000000, 0x30330608,0x0B261DF1,
	0xC065E000,0x00000000, 0x302713A5,0x90C2E245,
	0xC065F000,0x00000000, 0x301BFE56,0x76BCAA44,
	0xC0660000,0x00000000, 0x3010FA9A,0x8317651F,
	0xC0661000,0x00000000, 0x300498B2,0x57D83DE3,
	0xC0662000,0x00000000, 0x2FF8FC1A,0xB74075B7,
	0xC0663000,0x00000000, 0x2FEE4EDD,0xE61DC97E,
	0xC0664000,0x00000000, 0x2FE261FD,0x9796A399,
	0xC0665000,0x00000000, 0x2FD64CA7,0xB888FA1D,
	0xC0666000,0x00000000, 0x2FCB0CF2,0xE1EEDED3,
	0xC0667000,0x00000000, 0x2FC06831,0x98EF71D5,
	0xC0668000,0x00000000, 0x2FB3E717,0xB201AAD5,
	0xC0669000,0x00000000, 0x2FA824A8,0xE2512510,
	0xC066A000,0x00000000, 0x2F9D4984,0xEB4005E2,
	0xC066B000,0x00000000, 0x2F91C379,0xABA70739,
	0xC066C000,0x00000000, 0x2F858C5D,0xC99E4AE4,
	0xC066D000,0x00000000, 0x2F7A23B0,0xCE96EDDA,
	0xC066E000,0x00000000, 0x2F6FB56E,0x5C09773B,
	0xC066F000,0x00000000, 0x2F633B78,0x88A9F49B,
	0xC0670000,0x00000000, 0x2F575478,0xD6CDDEE7,
	0xC0671000,0x00000000, 0x2F4C4CF9,0x8C5E2C92,
	0xC0672000,0x00000000, 0x2F412A4C,0xA1CD1638,
	0xC0673000,0x00000000, 0x2F34D28D,0xF7A5B4DC,
	0xC0674000,0x00000000, 0x2F29424A,0x1FCF52E8,
	0xC0675000,0x00000000, 0x2F1EA401,0x7791D026,
	0xC0676000,0x00000000, 0x2F1295A1,0x45C1BAB3,
	0xC0677000,0x00000000, 0x2F068B4C,0x00F3E95D,
	0xC0678000,0x00000000, 0x2EFB58EF,0xE08487FC,
	0xC0679000,0x00000000, 0x2EF09648,0x6F5A6E1A,
	0xC067A000,0x00000000, 0x2EE41F00,0x68A7A854,
	0xC067B000,0x00000000, 0x2ED8687B,0x15488026,
	0xC067C000,0x00000000, 0x2ECD9BCA,0x54C1887C,
	0xC067D000,0x00000000, 0x2EC1F560,0x100DEE0F,
	0xC067E000,0x00000000, 0x2EB5C8E5,0xE89B7F87,
	0xC067F000,0x00000000, 0x2EAA6D1E,0x8D526902,
	0xC0680000,0x00000000, 0x2EA00740,0x96A5A34C,
	0xC0681000,0x00000000, 0x2E93717F,0x24487465,
	0xC0682000,0x00000000, 0x2E879602,0x36EB8104,
	0xC0683000,0x00000000, 0x2E7C9C79,0x889467B5,
	0xC0684000,0x00000000, 0x2E715A84,0xBC2C099D,
	0xC0685000,0x00000000, 0x2E650D0C,0x1F0AC85B,
	0xC0686000,0x00000000, 0x2E59893E,0xB0EDBC2F,
	0xC0687000,0x00000000, 0x2E4EFA14,0x33557C10,
	0xC0688000,0x00000000, 0x2E42C9D6,0x038F58D1,
	0xC0689000,0x00000000, 0x2E36CAA0,0x412C37F9,
	0xC068A000,0x00000000, 0x2E2BA5C2,0x54D94663,
	0xC068B000,0x00000000, 0x2E20C4E0,0xBE177EE0,
	0xC068C000,0x00000000, 0x2E145786,0x2D6588F1,
	0xC068D000,0x00000000, 0x2E08AD0B,0xCCB4BEE1,
	0xC068E000,0x00000000, 0x2DFDEEF6,0xDA3E109F,
	0xC068F000,0x00000000, 0x2DF227D2,0xA1397AC6,
	0xC0690000,0x00000000, 0x2DE60618,0x12054CFA,
	0xC0691000,0x00000000, 0x2DDAB75A,0x9120CA42,
	0xC0692000,0x00000000, 0x2DD03447,0x1B2BFC6C,
	0xC0693000,0x00000000, 0x2DC3A81D,0x83B44A7F,
	0xC0694000,0x00000000, 0x2DB7D843,0xB0A76D0D,
	0xC0695000,0x00000000, 0x2DACECD8,0xD7E89519,
	0xC0696000,0x00000000, 0x2DA18B44,0x4A94063D,
	0xC0697000,0x00000000, 0x2D95482E,0x96981584,
	0xC0698000,0x00000000, 0x2D89D0FA,0x94730B8E,
	0xC0699000,0x00000000, 0x2D7F5118,0xB940B387,
	0xC069A000,0x00000000, 0x2D72FE9D,0x687DDA2E,
	0xC069B000,0x00000000, 0x2D670AA6,0x6782774A,
	0xC069C000,0x00000000, 0x2D5BF36C,0x968F6C0E,
	0xC069D000,0x00000000, 0x2D50F3FB,0xF0D8EE55,
	0xC069E000,0x00000000, 0x2D4490AA,0xB96AF02F,
	0xC069F000,0x00000000, 0x2D38F25D,0x1FC57078,
	0xC06A0000,0x00000000, 0x2D2E430D,0x04EC3068,
	0xC06A1000,0x00000000, 0x2D225AD2,0xE8EE34BD,
	0xC06A2000,0x00000000, 0x2D1643F6,0x2385C65C,
	0xC06A3000,0x00000000, 0x2D0B0267,0x1D71B93D,
	0xC06A4000,0x00000000, 0x2D0061CC,0x1B09E660,
	0xC06A5000,0x00000000, 0x2CF3DF55,0x5140BD7A,
	0xC06A6000,0x00000000, 0x2CE81B3F,0x492A453B,
	0xC06A7000,0x00000000, 0x2CDD3E19,0xEDB316C4,
	0xC06A8000,0x00000000, 0x2CD1BC8C,0xC9861A79,
	0xC06A9000,0x00000000, 0x2CC583F7,0x2BE0C4D9,
	0xC06AA000,0x00000000, 0x2CBA197F,0xFA4A691E,
	0xC06AB000,0x00000000, 0x2CAFA911,0xB08AA648,
	0xC06AC000,0x00000000, 0x2CA333F9,0x10844D90,
	0xC06AD000,0x00000000, 0x2C974B60,0x67B3CF3B,
	0xC06AE000,0x00000000, 0x2C8C41F1,0x03DDBC48,
	0xC06AF000,0x00000000, 0x2C81239B,0x774EB129,
	0xC06B0000,0x00000000, 0x2C74CA6F,0xCABED982,
	0xC06B1000,0x00000000, 0x2C693871,0x2B898A72,
	0xC06B2000,0x00000000, 0x2C5E980F,0x65223146,
	0xC06B3000,0x00000000, 0x2C528E62,0x7542C714,
	0xC06B4000,0x00000000, 0x2C468282,0x0004CF81,
	0xC06B5000,0x00000000, 0x2C3B4E46,0x7C1091DF,
	0xC06B6000,0x00000000, 0x2C308FD0,0xF98CC130,
	0xC06B7000,0x00000000, 0x2C241728,0x3BEEACF1,
	0xC06B8000,0x00000000, 0x2C185EF7,0x0B496E3E,
	0xC06B9000,0x00000000, 0x2C0D903F,0x442E9815,
	0xC06BA000,0x00000000, 0x2C01EE5F,0xB9B0362F,
	0xC06BB000,0x00000000, 0x2BF5C067,0xB1889D0C,
	0xC06BC000,0x00000000, 0x2BEA62D1,0x1883DD7F,
	0xC06BD000,0x00000000, 0x2BE00100,0xE3EF418F,
	0xC06BE000,0x00000000, 0x2BD369EA,0x9C1F03D9,
	0xC06BF000,0x00000000, 0x2BC78CD0,0x3AF93AF7,
	0xC06C0000,0x00000000, 0x2BBC9152,0x01A1E776,
	0xC06C1000,0x00000000, 0x2BB153C0,0xC5319C86,
	0xC06C2000,0x00000000, 0x2BA504D7,0x244D31C8,
	0xC06C3000,0x00000000, 0x2B997F4A,0x12FFE7E6,
	0xC06C4000,0x00000000, 0x2B8EEE00,0x926A16FA,
	0xC06C5000,0x00000000, 0x2B82C282,0xD8AC23F6,
	0xC06C6000,0x00000000, 0x2B76C1BD,0x8FB6D644,
	0xC06C7000,0x00000000, 0x2B6B9AFA,0xFD3640C5,
	0xC06C8000,0x00000000, 0x2B60BE57,0x1DE802D5,
	0xC06C9000,0x00000000, 0x2B544F97,0xF779B5BB,
	0xC06CA000,0x00000000, 0x2B48A36D,0x07970034,
	0xC06CB000,0x00000000, 0x2B3DE34B,0x5C8B6436,
	0xC06CC000,0x00000000, 0x2B3220BE,0x9FF8E556,
	0xC06CD000,0x00000000, 0x2B25FD81,0xFF523D5A,
	0xC06CE000,0x00000000, 0x2B1AACF0,0x2B65943F,
	0xC06CF000,0x00000000, 0x2B102DF5,0xDAB833D6,
	0xC06D0000,0x00000000, 0x2B03A073,0xB05C42E7,
	0xC06D1000,0x00000000, 0x2AF7CEF7,0xE016F071,
	0xC06D2000,0x00000000, 0x2AECE191,0xFB733AC4,
	0xC06D3000,0x00000000, 0x2AE1846D,0x524EBB8E,
	0xC06D4000,0x00000000, 0x2AD53FE2,0x8DF496F2,
	0xC06D5000,0x00000000, 0x2AC9C6E9,0xFF27F70A,
	0xC06D6000,0x00000000, 0x2ABF44E3,0x2B95DAE1,
	0xC06D7000,0x00000000, 0x2AB2F735,0xAA09C9F6,
	0xC06D8000,0x00000000, 0x2AA701AA,0xC02BB536,
	0xC06D9000,0x00000000, 0x2A9BE886,0xF79B51D1,
	0xC06DA000,0x00000000, 0x2A90ED5F,0xF3402AFB,
	0xC06DB000,0x00000000, 0x2A8488A6,0x3C657B08,
	0xC06DC000,0x00000000, 0x2A78E8A3,0x5471E469,
	0xC06DD000,0x00000000, 0x2A6E3740,0xBF02F2F0,
	0xC06DE000,0x00000000, 0x2A6253AB,0x058B2B8A,
	0xC06DF000,0x00000000, 0x2A563B47,0xF22D7FE0,
	0xC06E0000,0x00000000, 0x2A4AF7DF,0x757D4EB7,
	0xC06E1000,0x00000000, 0x2A405B69,0x1B894584,
	0xC06E2000,0x00000000, 0x2A33D795,0xF6E91C26,
	0xC06E3000,0x00000000, 0x2A2811D9,0x5B6BF328,
	0xC06E4000,0x00000000, 0x2A1D32B3,0x63B58467,
	0xC06E5000,0x00000000, 0x2A11B5A2,0x9A92C4A3,
	0xC06E6000,0x00000000, 0x2A057B93,0xD4943E4D,
	0xC06E7000,0x00000000, 0x29FA0F53,0x1F12959C,
	0xC06E8000,0x00000000, 0x29EF9CB9,0xD6D3DFFE,
	0xC06E9000,0x00000000, 0x29E32C7C,0x84B22BEA,
	0xC06EA000,0x00000000, 0x29D7424B,0x845DC019,
	0xC06EB000,0x00000000, 0x29CC36EC,0xC88A317E,
	0xC06EC000,0x00000000, 0x29C11CEC,0xE8B5D57F,
	0xC06ED000,0x00000000, 0x29B4C254,0xC80B14D0,
	0xC06EE000,0x00000000, 0x29A92E9C,0x0E16205F,
	0xC06EF000,0x00000000, 0x299E8C21,0xFAEBAC57,
	0xC06F0000,0x00000000, 0x29928726,0x77E280EB,
	0xC06F1000,0x00000000, 0x298679BB,0x6C46044F,
	0xC06F2000,0x00000000, 0x297B43A1,0x3FB207F5,
	0xC06F3000,0x00000000, 0x2970895C,0x092551E4,
	0xC06F4000,0x00000000, 0x29640F53,0x1E1E6723,
	0xC06F5000,0x00000000, 0x29585576,0xB701D2B1,
	0xC06F6000,0x00000000, 0x294D84B8,0xB3AC2CDB,
	0xC06F7000,0x00000000, 0x2941E762,0x1E15AEF0,
	0xC06F8000,0x00000000, 0x2935B7EC,0xCA1A01D7,
	0xC06F9000,0x00000000, 0x292A5887,0xA7F31CB0,
	0xC06FA000,0x00000000, 0x291FF587,0x41C3A08D,
	0xC06FB000,0x00000000, 0x29136259,0x087F3B99,
	0xC06FC000,0x00000000, 0x290783A1,0xD4C0FAA7,
	0xC06FD000,0x00000000, 0x28FC862E,0xD3F1A170,
	0xC06FE000,0x00000000, 0x28F14CFF,0x7170EC0D,
	0xC06FF000,0x00000000, 0x28E4FCA5,0x5CA6A3F9,
	0xC0700000,0x00000000, 0x28D97559,0x56AD4E9C,
	0xC0700800,0x00000000, 0x28CEE1F1,0xA6CCE40D,
	0xC0701000,0x00000000, 0x28C2BB32,0x88D6F0AD,
	0xC0701800,0x00000000, 0x28B6B8DE,0x5511E382,
	0xC0702000,0x00000000, 0x28AB9037,0xD955CA2E,
	0xC0702800,0x00000000, 0x28A0B7D0,0x0A33C517,
	0xC0703000,0x00000000, 0x289447AC,0xD90DE0A6,
	0xC0703800,0x00000000, 0x288899D2,0x029C957A,
	0xC0704000,0x00000000, 0x287DD7A4,0x6B8D85D6,
	0xC0704800,0x00000000, 0x287219AD,0x6126686B,
	0xC0705000,0x00000000, 0x2865F4EF,0x4590950A,
	0xC0705800,0x00000000, 0x285AA289,0xD5309C57,
	0xC0706000,0x00000000, 0x285027A7,0x10C54ACD,
	0xC0706800,0x00000000, 0x284398CC,0xD9DB17AA,
	0xC0707000,0x00000000, 0x2837C5AF,0xAF527A12,
	0xC0707800,0x00000000, 0x282CD64F,0x847760ED,
	0xC0708000,0x00000000, 0x28217D99,0x04ABF72C,
	0xC0708800,0x00000000, 0x28153799,0xC1650CA8,
	0xC0709000,0x00000000, 0x2809BCDD,0x565F45B5,
	0xC0709800,0x00000000, 0x27FF38B2,0x60730C9A,
	0xC070A000,0x00000000, 0x27F2EFD0,0xCEA959AA,
	0xC070A800,0x00000000, 0x27E6F8B2,0x99608C61,
	0xC070B000,0x00000000, 0x27DBDDA5,0x9837B646,
	0xC070B800,0x00000000, 0x27D0E6C6,0x894B8B8D,
	0xC070C000,0x00000000, 0x27C480A4,0xDF8F6E9C,
	0xC070C800,0x00000000, 0x27B8DEED,0x53CAD040,
	0xC070D000,0x00000000, 0x27AE2B79,0x12964F75,
	0xC070D800,0x00000000, 0x27A24C85,0xEC56ACC8,
	0xC070E000,0x00000000, 0x2796329D,0x232DE199,
	0xC070E800,0x00000000, 0x278AED5B,0xE87747B3,
	0xC070F000,0x00000000, 0x27805508,0x9974ACB1,
	0xC070F800,0x00000000, 0x2773CFD9,0xA1CCDD2B,
	0xC0710000,0x00000000, 0x27680877,0x17A7F1BB,
	0xC0710800,0x00000000, 0x275D2751,0x4B8B09AA,
	0xC0711000,0x00000000, 0x2751AEBB,0x1DBF8F18,
	0xC0711800,0x00000000, 0x27457333,0xC271D71A,
	0xC0712000,0x00000000, 0x273A052A,0x3B62EE2A,
	0xC0712800,0x00000000, 0x272F9066,0xCD042388,
	0xC0713000,0x00000000, 0x27232502,0xE40FD165,
	0xC0713800,0x00000000, 0x2717393A,0x2B69CA7C,
	0xC0714000,0x00000000, 0x270C2BEC,0xD8B63E07,
	0xC0714800,0x00000000, 0x27011640,0xF4FE2032,
	0xC0715000,0x00000000, 0x26F4BA3C,0xEE4E8949,
	0xC0715800,0x00000000, 0x26E924CA,0xC5F5EABB,
	0xC0716000,0x00000000, 0x26DE8039,0x371D7439,
	0xC0716800,0x00000000, 0x26D27FED,0x4C86FDAB,
	0xC0717000,0x00000000, 0x26C670F8,0x44618C78,
	0xC0717800,0x00000000, 0x26BB3900,0x29CA11FD,
	0xC0718000,0x00000000, 0x26B082E9,0x9D288282,
	0xC0718800,0x00000000, 0x26A40781,0x0E059D23,
	0xC0719000,0x00000000, 0x26984BFA,0x16FF6B94,
	0xC0719800,0x00000000, 0x268D7936,0xA17921AD,
	0xC071A000,0x00000000, 0x2681E067,0x3C2DECBD,
	0xC071A800,0x00000000, 0x2675AF75,0x31053785,
	0xC071B000,0x00000000, 0x266A4E42,0x3A0F478C,
	0xC071B800,0x00000000, 0x265FE911,0x991456DD,
	0xC071C000,0x00000000, 0x26535ACA,0x684229D8,
	0xC071C800,0x00000000, 0x26477A77,0x02DCF6E6,
	0xC071D000,0x00000000, 0x263C7B0F,0xFDD19182,
	0xC071D800,0x00000000, 0x26314640,0xBFE2B9B4,
	0xC071E000,0x00000000, 0x2624F476,0xC6D7CA23,
	0xC071E800,0x00000000, 0x26196B6C,0x7A729201,
	0xC071F000,0x00000000, 0x260ED5E7,0x6EA7FC79,
	0xC071F800,0x00000000, 0x2602B3E5,0x12F2BC7A,
	0xC0720000,0x00000000, 0x25F6B002,0x8FE3A3B8,
	0xC0720800,0x00000000, 0x25EB8578,0xE7947D03,
	0xC0721000,0x00000000, 0x25E0B14B,0x81FC651F,
	0xC0721800,0x00000000, 0x25D43FC4,0xD0ED7682,
	0xC0722000,0x00000000, 0x25C8903A,0xBC4F2CB1,
	0xC0722800,0x00000000, 0x25BDCC02,0x057E62AB,
	0xC0723000,0x00000000, 0x25B2129E,0xE3AE9B2D,
	0xC0723800,0x00000000, 0x25A5EC5F,0xE3723D57,
	0xC0724000,0x00000000, 0x259A9827,0x8CEC9D6A,
	0xC0724800,0x00000000, 0x2590215A,0xBC5D724B,
	0xC0725000,0x00000000, 0x25839128,0xFF069A6E,
	0xC0725800,0x00000000, 0x2577BC6B,0x1CF053B3,
	0xC0726000,0x00000000, 0x256CCB11,0x713E403A,
	0xC0726800,0x00000000, 0x256176C7,0x60A1971F,
	0xC0727000,0x00000000, 0x25552F54,0x2FA6A0CE,
	0xC0727800,0x00000000, 0x2549B2D4,0x98915917,
	0xC0728000,0x00000000, 0x253F2C86,0x55FD39E2,
	0xC0728800,0x00000000, 0x2532E86E,0xD53C662C,
	0xC0729000,0x00000000, 0x2526EFBD,0xF1C3759B,
	0xC0729800,0x00000000, 0x251BD2C8,0x76BC99AE,
	0xC072A000,0x00000000, 0x2510E02F,0xB1F9E4EF,
	0xC072A800,0x00000000, 0x250478A6,0xA1B0D4E6,
	0xC072B000,0x00000000, 0x24F8D53B,0x1C55C677,
	0xC072B800,0x00000000, 0x24EE1FB5,0xFDDB3799,
	0xC072C000,0x00000000, 0x24E24563,0x9C3A49F7,
	0xC072C800,0x00000000, 0x24D629F5,0xB5352A54,
	0xC072D000,0x00000000, 0x24CAE2DC,0x74C5EC9D,
	0xC072D800,0x00000000, 0x24C04EAA,0x93D39A5F,
	0xC072E000,0x00000000, 0x24B3C820,0x50BE8C92,
	0xC072E800,0x00000000, 0x24A7FF18,0x7C70929F,
	0xC072F000,0x00000000, 0x249D1BF3,0xA3780EA3,
	0xC072F800,0x00000000, 0x2491A7D6,0x51FF6C45,
	0xC0730000,0x00000000, 0x24856AD6,0xF4332E86,
	0xC0730800,0x00000000, 0x2479FB05,0x4DAF8837,
	0xC0731000,0x00000000, 0x246F8418,0x913B2B95,
	0xC0731800,0x00000000, 0x24631D8C,0x2D79F179,
	0xC0732000,0x00000000, 0x2457302C,0x5B769158,
	0xC0732800,0x00000000, 0x244C20F1,0x32B53B17,
	0xC0733000,0x00000000, 0x24410F97,0x9B2393BD,
	0xC0733800,0x00000000, 0x2434B228,0x3C4DD490,
	0xC0734000,0x00000000, 0x24291AFD,0x51AA54F3,
	0xC0734800,0x00000000, 0x241E7455,0x17E77100,
	0xC0735000,0x00000000, 0x241278B6,0xF216C0AD,
	0xC0735800,0x00000000, 0x24066838,0x8701F200,
	0xC0736000,0x00000000, 0x23FB2E63,0x38BA7970,
	0xC0736800,0x00000000, 0x23F07C79,0xB49B176B,
	0xC0737000,0x00000000, 0x23E3FFB2,0x0A738C27,
	0xC0737800,0x00000000, 0x23D84281,0x29D08755,
	0xC0738000,0x00000000, 0x23CD6DB9,0x0BD50085,
	0xC0738800,0x00000000, 0x23C1D96F,0x12E8EE34,
	0xC0739000,0x00000000, 0x23B5A700,0xE5004888,
	0xC0739800,0x00000000, 0x23AA4400,0xCD481B54,
	0xC073A000,0x00000000, 0x239FDCA0,0xCBEB1B9C,
	0xC073A800,0x00000000, 0x2393533E,0xBA414FC2,
	0xC073B000,0x00000000, 0x2387714F,0xC3E7F204,
	0xC073B800,0x00000000, 0x237C6FF5,0x7D905CBB,
	0xC073C000,0x00000000, 0x23713F84,0xAF802D9D,
	0xC073C800,0x00000000, 0x2364EC4B,0x61A1CBF8,
	0xC073D000,0x00000000, 0x23596183,0x7CCCEACD,
	0xC073D800,0x00000000, 0x234EC9E1,0xE82630A2,
	0xC073E000,0x00000000, 0x2342AC9A,0x75E2F3FA,
	0xC073E800,0x00000000, 0x2336A72A,0x3ED2E1B6,
	0xC073F000,0x00000000, 0x232B7ABE,0x264F972D,
	0xC073F800,0x00000000, 0x2320AAC9,0x8443E592,
	0xC0740000,0x00000000, 0x231437DF,0xDDE45C6A,
	0xC0740800,0x00000000, 0x230886A7,0x333905C3,
	0xC0741000,0x00000000, 0x22FDC064,0x289898E4,
	0xC0741800,0x00000000, 0x22F20B93,0x267E8023,
	0xC0742000,0x00000000, 0x22E5E3D3,0xD7A9A1CD,
	0xC0742800,0x00000000, 0x22DA8DC9,0x5104F056,
	0xC0743000,0x00000000, 0x22D01B10,0xDC8B3B1D,
	0xC0743800,0x00000000, 0x22C38988,0x1EB5111E,
	0xC0744000,0x00000000, 0x22B7B32A,0x2787541B,
	0xC0744800,0x00000000, 0x22ACBFD7,0xC011BC66,
	0xC0745000,0x00000000, 0x22A16FF8,0x6525E12C,
	0xC0745800,0x00000000, 0x22952711,0xD776FB6B,
	0xC0746000,0x00000000, 0x2289A8CF,0xC4372B65,
	0xC0746800,0x00000000, 0x227F205F,0x0A5A0D1B,
	0xC0747000,0x00000000, 0x2272E10F,0xBCA33CB4,
	0xC0747800,0x00000000, 0x2266E6CC,0xC7F771FA,
	0xC0748000,0x00000000, 0x225BC7EF,0x9182A19B,
	0xC0748800,0x00000000, 0x2250D99B,0x6C4A704B,
	0xC0749000,0x00000000, 0x224470AB,0x81923181,
	0xC0749800,0x00000000, 0x2238CB8C,0xAC98ED11,
	0xC074A000,0x00000000, 0x222E13F7,0x7F074FF1,
	0xC074A800,0x00000000, 0x22223E44,0x14200125,
	0xC074B000,0x00000000, 0x22162151,0xA6F21C90,
	0xC074B800,0x00000000, 0x220AD861,0x18D0259C,
	0xC074C000,0x00000000, 0x2200484F,0x09ADEDE8,
	0xC074C800,0x00000000, 0x21F3C06A,0x02912BE9,
	0xC074D000,0x00000000, 0x21E7F5BD,0x8858B612,
	0xC074D800,0x00000000, 0x21DD109A,0x69C1A855,
	0xC074E000,0x00000000, 0x21D1A0F4,0x3645B77A,
	0xC074E800,0x00000000, 0x21C5627D,0x68926316,
	0xC074F000,0x00000000, 0x21B9F0E4,0x546D1388,
	0xC074F800,0x00000000, 0x21AF77CF,0x21996E13,
	0xC0750000,0x00000000, 0x21A31618,0x5FCDB131,
	0xC0750800,0x00000000, 0x21972722,0x13234163,
	0xC0751000,0x00000000, 0x218C15F9,0xD4DB28FE,
	0xC0751800,0x00000000, 0x218108F0,0xDA2297F6,
	0xC0752000,0x00000000, 0x2174AA16,0xB0CE0F41,
	0xC0752800,0x00000000, 0x21691133,0xAFB55F9B,
	0xC0753000,0x00000000, 0x215E6875,0x9B7A3FAE,
	0xC0753800,0x00000000, 0x21527183,0x6778BB0A,
	0xC0754000,0x00000000, 0x21465F7C,0x32D2440B,
	0xC0754800,0x00000000, 0x213B23CA,0x6AE5A946,
	0xC0755000,0x00000000, 0x2130760C,0x4E8236F6,
	0xC0755800,0x00000000, 0x2123F7E6,0x1237E838,
	0xC0756000,0x00000000, 0x2118390B,0xEE040482,
	0xC0756800,0x00000000, 0x210D623F,0xF1000232,
	0xC0757000,0x00000000, 0x2101D279,0xA1371C02,
	0xC0757800,0x00000000, 0x20F59E8F,0xE4C1BFF5,
	0xC0758000,0x00000000, 0x20EA39C3,0x600DF153,
	0xC0758800,0x00000000, 0x20DFD034,0xD86321A1,
	0xC0759000,0x00000000, 0x20D34BB5,0xFD56A155,
	0xC0759800,0x00000000, 0x20C7682C,0x167D3998,
	0xC075A000,0x00000000, 0x20BC64DF,0x517D5120,
	0xC075A800,0x00000000, 0x20B138CB,0x3F42D666,
	0xC075B000,0x00000000, 0x20A4E423,0x2BC64D77,
	0xC075B800,0x00000000, 0x2099579E,0x5C3A2881,
	0xC075C000,0x00000000, 0x208EBDE1,0x117307D4,
	0xC075C800,0x00000000, 0x2082A552,0xB08B72C1,
	0xC075D000,0x00000000, 0x20769E55,0x6086EEE2,
	0xC075D800,0x00000000, 0x206B7007,0x93E4F9D5,
	0xC075E000,0x00000000, 0x2060A44A,0x100CAC19,
	0xC075E800,0x00000000, 0x20542FFD,0xFEBEEF96,
	0xC075F000,0x00000000, 0x20487D17,0x65E4F251,
	0xC075F800,0x00000000, 0x203DB4CA,0xD3177775,
	0xC0760000,0x00000000, 0x2032048A,0x2883850B,
	0xC0760800,0x00000000, 0x2025DB4B,0x20E9B007,
	0xC0761000,0x00000000, 0x201A836F,0x1FE58BBE,
	0xC0761800,0x00000000, 0x201014C9,0x705995C1,
	0xC0762000,0x00000000, 0x200381EA,0x37BD35B3,
	0xC0762800,0x00000000, 0x1FF7A9EC,0xCDAEDEDF,
	0xC0763000,0x00000000, 0x1FECB4A2,0x6F3C63F6,
	0xC0763800,0x00000000, 0x1FE1692C,0x112F82B6,
	0xC0764000,0x00000000, 0x1FD51ED2,0xB794422F,
	0xC0764800,0x00000000, 0x1FC99ECE,0xD7CA4F47,
	0xC0765000,0x00000000, 0x1FBF143C,0x7BAFE995,
	0xC0765800,0x00000000, 0x1FB2D9B3,0x83BE9AA2,
	0xC0766000,0x00000000, 0x1FA6DDDF,0x1AA00AA3,
	0xC0766800,0x00000000, 0x1F9BBD1A,0xE6E318A9,
	0xC0767000,0x00000000, 0x1F90D309,0xB73CCAE2,
	0xC0767800,0x00000000, 0x1F8468B3,0x7DFC8176,
	0xC0768000,0x00000000, 0x1F78C1E2,0x031AFD5F,
	0xC0768800,0x00000000, 0x1F6E083D,0x9450EFC6,
	0xC0769000,0x00000000, 0x1F623727,0x52F23CC1,
	0xC0769800,0x00000000, 0x1F5618B0,0xF713FE42,
	0xC076A000,0x00000000, 0x1F4ACDE9,0xD2FD7A56,
	0xC076A800,0x00000000, 0x1F4041F5,0xFA0BE761,
	0xC076B000,0x00000000, 0x1F33B8B6,0xB6183219,
	0xC076B800,0x00000000, 0x1F27EC66,0x39F3CAA8,
	0xC076C000,0x00000000, 0x1F1D0545,0x9CAD9872,
	0xC076C800,0x00000000, 0x1F119A14,0xC98634C6,
	0xC076D000,0x00000000, 0x1F055A27,0x1E4A125D,
	0xC076D800,0x00000000, 0x1EF9E6C7,0x4E10DA04,
	0xC076E000,0x00000000, 0x1EEF6B8A,0x7C401BE2,
	0xC076E800,0x00000000, 0x1EE30EA7,0x79E8A6FA,
	0xC076F000,0x00000000, 0x1ED71E1B,0x510F90E2,
	0xC076F800,0x00000000, 0x1ECC0B06,0xBD7CAEEA,
	0xC0770000,0x00000000, 0x1EC1024C,0xB0F7F9E9,
	0xC0770800,0x00000000, 0x1EB4A208,0x4A94CCBB,
	0xC0771000,0x00000000, 0x1EA9076D,0xDE99A035,
	0xC0771800,0x00000000, 0x1E9E5C9A,0xC00731EE,
	0xC0772000,0x00000000, 0x1E926A52,0xAB944B6C,
	0xC0772800,0x00000000, 0x1E8656C3,0x467E16A9,
	0xC0773000,0x00000000, 0x1E7B1935,0xBEAEADB3,
	0xC0773800,0x00000000, 0x1E706FA1,0x69E36941,
	0xC0774000,0x00000000, 0x1E63F01D,0x2422DC00,
	0xC0774800,0x00000000, 0x1E582F9A,0x62295194,
	0xC0775000,0x00000000, 0x1E4D56CB,0x4F3B0E14,
	0xC0775800,0x00000000, 0x1E41CB86,0xE60948B4,
	0xC0776000,0x00000000, 0x1E359622,0x2F00A953,
	0xC0776800,0x00000000, 0x1E2A2F89,0xF0D1BEA5,
	0xC0777000,0x00000000, 0x1E1FC3CD,0xBC9858C5,
	0xC0777800,0x00000000, 0x1E134430,0x305C8533,
	0xC0778000,0x00000000, 0x1E075F0B,0xF938A647,
	0xC0778800,0x00000000, 0x1DFC59CD,0x77E86566,
	0xC0779000,0x00000000, 0x1DF13214,0x6E24A8F9,
	0xC0779800,0x00000000, 0x1DE4DBFE,0x24076EBF,
	0xC077A000,0x00000000, 0x1DD94DBD,0x1738B12B,
	0xC077A800,0x00000000, 0x1DCEB1E4,0xE8BAC000,
	0xC077B000,0x00000000, 0x1DC29E0D,0xC1D08325,
	0xC077B800,0x00000000, 0x1DB69583,0xF3A7A302,
	0xC077C000,0x00000000, 0x1DAB6555,0x2EB32927,
	0xC077C800,0x00000000, 0x1DA09DCD,0x2459813C,
	0xC077D000,0x00000000, 0x1D94281F,0x324A0531,
	0xC077D800,0x00000000, 0x1D88738B,0x52DE5579,
	0xC077E000,0x00000000, 0x1D7DA936,0x0336FDCE,
	0xC077E800,0x00000000, 0x1D71FD83,0xE8AB82AC,
	0xC077F000,0x00000000, 0x1D65D2C5,0xBDE5D77A,
	0xC077F800,0x00000000, 0x1D5A7918,0xF7FB03C7,
	0xC0780000,0x00000000, 0x1D500E84,0x76D3D23E,
	0xC0780800,0x00000000, 0x1D437A4F,0x48F6360D,
	0xC0781000,0x00000000, 0x1D37A0B3,0x0DFEE42C,
	0xC0781800,0x00000000, 0x1D2CA971,0x7D096FFB,
	0xC0782000,0x00000000, 0x1D216262,0x63B5908B,
	0xC0782800,0x00000000, 0x1D151696,0xCEBD1847,
	0xC0783000,0x00000000, 0x1D0994D1,0xD1C4EF99,
	0xC0783800,0x00000000, 0x1CFF081E,0xA825EB44,
	0xC0784000,0x00000000, 0x1CF2D25A,0x296FAD56,
	0xC0784800,0x00000000, 0x1CE6D4F4,0xE8615096,
	0xC0785000,0x00000000, 0x1CDBB24A,0x7537EE42,
	0xC0785800,0x00000000, 0x1CD0CC7A,0x91D0F5EE,
	0xC0786000,0x00000000, 0x1CC460BE,0x95B93B11,
	0xC0786800,0x00000000, 0x1CB8B83B,0x1E6343C8,
	0xC0787000,0x00000000, 0x1CADFC88,0x3BEF20CE,
	0xC0787800,0x00000000, 0x1CA2300D,0x579BD371,
	0xC0788000,0x00000000, 0x1C961013,0xA44A98A8,
	0xC0788800,0x00000000, 0x1C8AC376,0xA1B611AE,
	0xC0789000,0x00000000, 0x1C803B9F,0x63F62777,
	0xC0789800,0x00000000, 0x1C73B106,0x6A278B32,
	0xC078A000,0x00000000, 0x1C67E312,0x8FD5CD18,
	0xC078A800,0x00000000, 0x1C5CF9F5,0x3A824D16,
	0xC078B000,0x00000000, 0x1C519338,0x0AB510C9,
	0xC078B800,0x00000000, 0x1C4551D4,0x141558C6,
	0xC078C000,0x00000000, 0x1C39DCAE,0x3910BF72,
	0xC078C800,0x00000000, 0x1C2F5F4A,0x9F51208F,
	0xC078D000,0x00000000, 0x1C230739,0x7AA8DA7C,
	0xC078D800,0x00000000, 0x1C171518,0x13DBBF70,
	0xC078E000,0x00000000, 0x1C0C0017,0xEAEF1AA2,
	0xC078E800,0x00000000, 0x1C00FBAB,0x1EA0EBAF,
	0xC078F000,0x00000000, 0x1BF499FD,0x08681AF2,
	0xC078F800,0x00000000, 0x1BE8FDAB,0xDCDA40F4,
	0xC0790000,0x00000000, 0x1BDE50C4,0x83C04DCD,
	0xC0790800,0x00000000, 0x1BD26324,0xBD513DE8,
	0xC0791000,0x00000000, 0x1BC64E0D,0xC0B1829F,
	0xC0791800,0x00000000, 0x1BBB0EA5,0x327933E8,
	0xC0792000,0x00000000, 0x1BB06939,0x05C49814,
	0xC0792800,0x00000000, 0x1BA3E857,0x3F05089B,
	0xC0793000,0x00000000, 0x1B98262C,0x84D06CB5,
	0xC0793800,0x00000000, 0x1B8D4B5B,0x24C7B9DD,
	0xC0794000,0x00000000, 0x1B81C496,0xE050B08F,
	0xC0794800,0x00000000, 0x1B758DB7,0xC2749068,
	0xC0795000,0x00000000, 0x1B6A2554,0x7E0513F7,
	0xC0795800,0x00000000, 0x1B5FB76B,0x76A76D99,
	0xC0796000,0x00000000, 0x1B533CAD,0x522DD473,
	0xC0796800,0x00000000, 0x1B4755EF,0x6AB69B91,
	0xC0797000,0x00000000, 0x1B3C4EBF,0xEF2238B1,
	0xC0797800,0x00000000, 0x1B312B60,0x3B20006F,
	0xC0798000,0x00000000, 0x1B24D3DC,0x4927CBDA,
	0xC0798800,0x00000000, 0x1B1943DF,0xAC478133,
	0xC0799000,0x00000000, 0x1B0EA5ED,0x6C2A4D75,
	0xC0799800,0x00000000, 0x1B0296CB,0xA896DE1B,
	0xC079A000,0x00000000, 0x1AF68CB5,0xF6DD5C08,
	0xC079A800,0x00000000, 0x1AEB5AA6,0xF5194C12,
	0xC079B000,0x00000000, 0x1AE09752,0xC02D903D,
	0xC079B800,0x00000000, 0x1AD42043,0x7752EA23,
	0xC079C000,0x00000000, 0x1AC86A02,0xF8B1239C,
	0xC079C800,0x00000000, 0x1ABD9DA5,0xB733DB96,
	0xC079D000,0x00000000, 0x1AB1F680,0x65E4BCB1,
	0xC079D800,0x00000000, 0x1AA5CA43,0xAD52093F,
	0xC079E000,0x00000000, 0x1A9A6EC6,0xD7B289DD,
	0xC079E800,0x00000000, 0x1A900841,0xEF05A000,
	0xC079F000,0x00000000, 0x1A8372B7,0x5137B3C5,
	0xC079F800,0x00000000, 0x1A77977C,0xE70FE08C,
	0xC07A0000,0x00000000, 0x1A6C9E44,0xE7C4C3CF,
	0xC07A0800,0x00000000, 0x1A615B9B,0x5BAF86C5,
	0xC07A1000,0x00000000, 0x1A550E5E,0x1BB09E26,
	0xC07A1800,0x00000000, 0x1A498AD8,0xB0A1CF33,
	0xC07A2000,0x00000000, 0x1A3EFC05,0x8DE3E67A,
	0xC07A2800,0x00000000, 0x1A32CB03,0xAC981201,
	0xC07A3000,0x00000000, 0x1A26CC0E,0x2FDFDC75,
	0xC07A3800,0x00000000, 0x1A1BA77E,0x3ADBB65A,
	0xC07A4000,0x00000000, 0x1A10C5ED,0xFB075673,
	0xC07A4800,0x00000000, 0x1A0458CC,0xC7924DAB,
	0xC07A5000,0x00000000, 0x19F8AE97,0xFCF99F91,
	0xC07A5800,0x00000000, 0x19EDF0D7,0x74199EE5,
	0xC07A6000,0x00000000, 0x19E228F6,0x210807EB,
	0xC07A6800,0x00000000, 0x19D60779,0xAD463813,
	0xC07A7000,0x00000000, 0x19CAB907,0x8362B189,
	0xC07A7800,0x00000000, 0x19C0354B,0x4675AF48,
	0xC07A8000,0x00000000, 0x19B3A959,0x1D939844,
	0xC07A8800,0x00000000, 0x19A7D9C2,0x88934804,
	0xC07A9000,0x00000000, 0x199CEEA9,0x4186E084,
	0xC07A9800,0x00000000, 0x19918C5D,0xF8C6E08D,
	0xC07AA000,0x00000000, 0x19854984,0x48AFD169,
	0xC07AA800,0x00000000, 0x1979D299,0x13E3413F,
	0xC07AB000,0x00000000, 0x196F530F,0x88EF2209,
	0xC07AB800,0x00000000, 0x1962FFCE,0x60ECC469,
	0xC07AC000,0x00000000, 0x19570C18,0x5A2895CC,
	0xC07AC800,0x00000000, 0x194BF52D,0x5B886049,
	0xC07AD000,0x00000000, 0x1940F50C,0x221B0447,
	0xC07AD800,0x00000000, 0x193491F4,0xE90E823E,
	0xC07AE000,0x00000000, 0x1928F3ED,0xA8FB0088,
	0xC07AE800,0x00000000, 0x191E44F2,0xE4D84D72,
	0xC07AF000,0x00000000, 0x19125BF9,0x9B97CBCC,
	0xC07AF800,0x00000000, 0x1906455B,0xA0192538,
	0xC07B0000,0x00000000, 0x18FB0418,0xC4A989D9,
	0xC07B0800,0x00000000, 0x18F062D3,0x212C0EB6,
	0xC07B1000,0x00000000, 0x18E3E094,0x61AF856E,
	0xC07B1800,0x00000000, 0x18D81CC2,0x5489E384,
	0xC07B2000,0x00000000, 0x18CD3FEF,0x6FE84946,
	0xC07B2800,0x00000000, 0x18C1BDA9,0x8EFEF969,
	0xC07B3000,0x00000000, 0x18B58550,0x9DD58108,
	0xC07B3800,0x00000000, 0x18AA1B23,0x061A1D4C,
	0xC07B4000,0x00000000, 0x189FAB0E,0x04ADC91C,
	0xC07B4800,0x00000000, 0x1893352D,0x61A5DA76,
	0xC07B5000,0x00000000, 0x18874CD6,0x69940799,
	0xC07B5800,0x00000000, 0x187C43B6,0xB57C1253,
	0xC07B6000,0x00000000, 0x187124AE,0xA52F9DDC,
	0xC07B6800,0x00000000, 0x1864CBBD,0x99EA7C91,
	0xC07B7000,0x00000000, 0x18593A06,0x19E62B15,
	0xC07B7800,0x00000000, 0x184E99FA,0x99EF5A94,
	0xC07B8000,0x00000000, 0x18428F8C,0x63C3AB07,
	0xC07B8800,0x00000000, 0x183683EB,0x68D0FDDF,
	0xC07B9000,0x00000000, 0x182B4FFC,0xE5772C07,
	0xC07B9800,0x00000000, 0x182090DA,0xE28C66EE,
	0xC07BA000,0x00000000, 0x1814186A,0xCCA762E8,
	0xC07BA800,0x00000000, 0x1808607E,0x55E9E22B,
	0xC07BB000,0x00000000, 0x17FD9219,0xED4B7068,
	0xC07BB800,0x00000000, 0x17F1EF7F,0x9F1DE17B,
	0xC07BC000,0x00000000, 0x17E5C1C4,0xEDE2B7E9,
	0xC07BC800,0x00000000, 0x17DA6478,0xBD79EC79,
	0xC07BD000,0x00000000, 0x17D00201,0xD7FB0DB5,
	0xC07BD800,0x00000000, 0x17C36B22,0x4F59C3FC,
	0xC07BE000,0x00000000, 0x17B78E4A,0x577ADCB4,
	0xC07BE800,0x00000000, 0x17AC931C,0xADBAECD1,
	0xC07BF000,0x00000000, 0x17A154D6,0xF815489C,
	0xC07BF800,0x00000000, 0x17950628,0x9D2E715B,
	0xC07C0000,0x00000000, 0x178980E3,0x72DC48AD,
	0xC07C0800,0x00000000, 0x177EEFF1,0x2B12679C,
	0xC07C1000,0x00000000, 0x1772C3B0,0x0C19D57A,
	0xC07C1800,0x00000000, 0x1766C32A,0xEFC0CE56,
	0xC07C2000,0x00000000, 0x175B9CB6,0x3629A932,
	0xC07C2800,0x00000000, 0x1750BF63,0xF1E0B51D,
	0xC07C3000,0x00000000, 0x174450DE,0x12522184,
	0xC07C3800,0x00000000, 0x1738A4F8,0x9D6682A0,
	0xC07C4000,0x00000000, 0x172DE52B,0x3B08D7C9,
	0xC07C4800,0x00000000, 0x172221E1,0xAE2288C8,
	0xC07C5000,0x00000000, 0x1715FEE3,0x10B7ABB4,
	0xC07C5800,0x00000000, 0x170AAE9C,0x766CBE8F,
	0xC07C6000,0x00000000, 0x17002EF9,0xA093E03C,
	0xC07C6800,0x00000000, 0x16F3A1AE,0xCF312F2D,
	0xC07C7000,0x00000000, 0x16E7D076,0x22C153BF,
	0xC07C7800,0x00000000, 0x16DCE361,0xB00318E2,
	0xC07C8000,0x00000000, 0x16D18586,0x92B0A160,
	0xC07C8800,0x00000000, 0x16C54137,0xBAD595D3,
	0xC07C9000,0x00000000, 0x16B9C887,0xDCFF7642,
	0xC07C9800,0x00000000, 0x16AF46D9,0x373D8059,
	0xC07CA000,0x00000000, 0x16A2F866,0x2B934E56,
	0xC07CA800,0x00000000, 0x1697031C,0x229765A2,
	0xC07CB000,0x00000000, 0x168BEA47,0x0D9F1A19,
	0xC07CB800,0x00000000, 0x1680EE6F,0xBA643F6D,
	0xC07CC000,0x00000000, 0x167489EF,0xEB4F052E,
	0xC07CC800,0x00000000, 0x1668EA33,0x418031DC,
	0xC07CD000,0x00000000, 0x165E3925,0xE1829EDA,
	0xC07CD800,0x00000000, 0x165254D1,0x45509B7D,
	0xC07CE000,0x00000000, 0x16463CAC,0xE362200E,
	0xC07CE800,0x00000000, 0x163AF990,0x73A49DF8,
	0xC07CF000,0x00000000, 0x16305C6F,0xBB2079C6,
	0xC07CF800,0x00000000, 0x1623D8D4,0x8AF3DFF3,
	0xC07D0000,0x00000000, 0x1618135B,0xCFE6D2E6,
	0xC07D0800,0x00000000, 0x160D3488,0x2EDFADD0,
	0xC07D1000,0x00000000, 0x1601B6BE,0xF106327D,
	0xC07D1800,0x00000000, 0x15F57CEC,0xBFDC06DF,
	0xC07D2000,0x00000000, 0x15EA10F5,0x8783A1BE,
	0xC07D2800,0x00000000, 0x15DF9EB5,0x64C99073,
	0xC07D3000,0x00000000, 0x15D32DB0,0x5DA054BB,
	0xC07D3800,0x00000000, 0x15C743C0,0xF46E62F0,
	0xC07D4000,0x00000000, 0x15BC38B1,0xC947E18A,
	0xC07D4800,0x00000000, 0x15B11DFF,0xAB4EA833,
	0xC07D5000,0x00000000, 0x15A4C3A2,0x15131439,
	0xC07D5800,0x00000000, 0x15993030,0x5E94D732,
	0xC07D6000,0x00000000, 0x158E8E0C,0x7038478F,
	0xC07D6800,0x00000000, 0x1582884F,0xF23C7F91,
	0xC07D7000,0x00000000, 0x15767B24,0x482BF236,
	0xC07D7800,0x00000000, 0x156B4556,0xFE2D34BC,
	0xC07D8000,0x00000000, 0x15608A65,0x8A79F58B,
	0xC07D8800,0x00000000, 0x15541095,0x3115AB5F,
	0xC07D9000,0x00000000, 0x154856FD,0x6915A764,
	0xC07D9800,0x00000000, 0x153D8692,0xA3BBCB8C,
	0xC07DA000,0x00000000, 0x1531E881,0x934609FB,
	0xC07DA800,0x00000000, 0x1525B949,0x7E4CD748,
	0xC07DB000,0x00000000, 0x151A5A2E,0xA7BF96DD,
	0xC07DB800,0x00000000, 0x150FF788,0x61811243,
	0xC07DC000,0x00000000, 0x15036390,0x4234EF34,
	0xC07DC800,0x00000000, 0x14F7851B,0x5DD96D4B,
	0xC07DD000,0x00000000, 0x14EC87F8,0xCD392224,
	0xC07DD800,0x00000000, 0x14E14E15,0x37DF2040,
	0xC07DE000,0x00000000, 0x14D4FDF6,0x51F6AC5A,
	0xC07DE800,0x00000000, 0x14C976F2,0x16F04E25,
	0xC07DF000,0x00000000, 0x14BEE3E1,0x7DDAB2DD,
	0xC07DF800,0x00000000, 0x14B2BC5F,0x46D77414,
	0xC07E0000,0x00000000, 0x14A6BA4B,0x26A9CD8A,
	0xC07E0800,0x00000000, 0x149B91F2,0x657DA318,
	0xC07E1000,0x00000000, 0x1490B8DC,0x755E3E18,
	0xC07E1800,0x00000000, 0x148448F2,0x74C3978A,
	0xC07E2000,0x00000000, 0x14789B5C,0xFE32F146,
	0xC07E2800,0x00000000, 0x146DD983,0x8EF5EAD3,
	0xC07E3000,0x00000000, 0x14621ACF,0xFDD7705B,
	0xC07E3800,0x00000000, 0x1455F64F,0xCD50456B,
	0xC07E4000,0x00000000, 0x144AA435,0x793E3BEE,
	0xC07E4800,0x00000000, 0x144028AA,0x715A7BE0,
	0xC07E5000,0x00000000, 0x14339A07,0x7DD59A6E,
	0xC07E5800,0x00000000, 0x1427C72D,0x5CF59618,
	0xC07E6000,0x00000000, 0x141CD81E,0x843F67F6,
	0xC07E6800,0x00000000, 0x14117EB1,0xD767B8A6,
	0xC07E7000,0x00000000, 0x140538EE,0x69433DD8,
	0xC07E7800,0x00000000, 0x13F9BE7A,0x92DD0E81,
	0xC07E8000,0x00000000, 0x13EF3AA7,0xA8605559,
	0xC07E8800,0x00000000, 0x13E2F100,0xD97BD28A,
	0xC07E9000,0x00000000, 0x13D6FA23,0x6BCA0954,
	0xC07E9800,0x00000000, 0x13CBDF64,0xFF8A8827,
	0xC07EA000,0x00000000, 0x13C0E7D5,0xE67AFD77,
	0xC07EA800,0x00000000, 0x13B481EE,0x0DF12057,
	0xC07EB000,0x00000000, 0x13A8E07C,0xA4EEBBE2,
	0xC07EB800,0x00000000, 0x139E2D5D,0x77F36390,
	0xC07EC000,0x00000000, 0x13924DAB,0xB964C046,
	0xC07EC800,0x00000000, 0x13863401,0x893A18D9,
	0xC07ED000,0x00000000, 0x137AEF0C,0x3DCFFEFB,
	0xC07ED800,0x00000000, 0x1370560E,0xD2A8E719,
	0xC07EE000,0x00000000, 0x1363D117,0xB9A41B90,
	0xC07EE800,0x00000000, 0x135809F8,0xF578E6C5,
	0xC07EF000,0x00000000, 0x134D2925,0x5FF1867D,
	0xC07EF800,0x00000000, 0x1341AFD7,0x0558D446,
	0xC07F0000,0x00000000, 0x1335748C,0x27412D46,
	0xC07F0800,0x00000000, 0x132A06CC,0x00B50348,
	0xC07F1000,0x00000000, 0x131F9261,0x9519A49B,
	0xC07F1800,0x00000000, 0x13132636,0x44F972B2,
	0xC07F2000,0x00000000, 0x13073AAF,0x09E3B05D,
	0xC07F2800,0x00000000, 0x12FC2DB1,0x28D83D3D,
	0xC07F3000,0x00000000, 0x12F11753,0x4C78AC15,
	0xC07F3800,0x00000000, 0x12E4BB89,0xB965A182,
	0xC07F4000,0x00000000, 0x12D9265E,0x78D4438D,
	0xC07F4800,0x00000000, 0x12CE8222,0xED342A1E,
	0xC07F5000,0x00000000, 0x12C28116,0x52E75F7D,
	0xC07F5800,0x00000000, 0x12B67260,0x9398284A,
	0xC07F6000,0x00000000, 0x12AB3AB5,0x3D9C73EB,
	0xC07F6800,0x00000000, 0x12A083F2,0xB6FA8E98,
	0xC07F7000,0x00000000, 0x129408C2,0xA36C769C,
	0xC07F7800,0x00000000, 0x12884D80,0x30C21A26,
	0xC07F8000,0x00000000, 0x127D7B0F,0xD8C3ABB6,
	0xC07F8800,0x00000000, 0x1271E186,0x414CB986,
	0xC07F9000,0x00000000, 0x1265B0D1,0x5D45DC40,
	0xC07F9800,0x00000000, 0x125A4FE8,0x94F290DE,
	0xC07FA000,0x00000000, 0x124FEB11,0xF0C5BE05,
	0xC07FA800,0x00000000, 0x12435C01,0x28A2311F,
	0xC07FB000,0x00000000, 0x12377BEF,0xF8C5B2B3,
	0xC07FB800,0x00000000, 0x122C7CD9,0x448D446D,
	0xC07FC000,0x00000000, 0x12214756,0x1A05BEB0,
	0xC07FC800,0x00000000, 0x1214F5C7,0x38C9E64F,
	0xC07FD000,0x00000000, 0x12096D04,0x9B5A68FF,
	0xC07FD800,0x00000000, 0x11FED7D6,0x8466C3F4,
	0xC07FE000,0x00000000, 0x11F2B511,0x5BB3D972,
	0xC07FE800,0x00000000, 0x11E6B16E,0xD3410867,
	0xC07FF000,0x00000000, 0x11DB8732,0xC7342422,
	0xC07FF800,0x00000000, 0x11D0B257,0x848180E7,
	0xC0800000,0x00000000, 0x11C44109,0xEDB20931,
	0xC0800400,0x00000000, 0x11B891C5,0x1DE88206,
	0xC0800800,0x00000000, 0x11ADCDE0,0x6E1AA8B3,
	0xC0800C00,0x00000000, 0x11A213C1,0x0F134487,
	0xC0801000,0x00000000, 0x1195EDBF,0xE1C1D991,
	0xC0801400,0x00000000, 0x118A99D2,0x8A41CB19,
	0xC0801800,0x00000000, 0x1180225D,0xB7D3A3C5,
	0xC0801C00,0x00000000, 0x11739263,0x285698FB,
	0xC0802000,0x00000000, 0x1167BDE8,0x35C64224,
	0xC0802400,0x00000000, 0x115CCCDF,0xBC84EAE3,
	0xC0802800,0x00000000, 0x115177DF,0xC5E1F3B3,
	0xC0802C00,0x00000000, 0x114530A8,0x52B5DF63,
	0xC0803000,0x00000000, 0x1139B471,0x33F452F4,
	0xC0803400,0x00000000, 0x112F2E7A,0xDA7C746B,
	0xC0803800,0x00000000, 0x1122E99E,0x69861BD4,
	0xC0803C00,0x00000000, 0x1116F12E,0x3462E3C8,
	0xC0804000,0x00000000, 0x110BD487,0x2FA2901F,
	0xC0804400,0x00000000, 0x1100E13E,0xA55E0328,
	0xC0804800,0x00000000, 0x10F479EF,0x4FBCCA24,
	0xC0804C00,0x00000000, 0x10E8D6C9,0xD1CC1958,
	0xC0805000,0x00000000, 0x10DE2199,0xA65F706A,
	0xC0805400,0x00000000, 0x10D24688,0xF6BDBA31,
	0xC0805800,0x00000000, 0x10C62B59,0x904F3938,
	0xC0805C00,0x00000000, 0x10BAE48C,0x2191DB9B,
	0xC0806000,0x00000000, 0x10B04FB0,0x66CCC58F,
	0xC0806400,0x00000000, 0x10A3C95D,0xEC92B164,
	0xC0806800,0x00000000, 0x10980099,0xC3D259DE,
	0xC0806C00,0x00000000, 0x108D1DC7,0x01621F8F,
	0xC0807000,0x00000000, 0x1081A8F1,0xCAE9C04F,
	0xC0807400,0x00000000, 0x10756C2E,0xD2BE7F0D,
	0xC0807800,0x00000000, 0x1069FCA6,0x70223E80,
	0xC0807C00,0x00000000, 0x105F8612,0x93BDA225,
	0xC0808000,0x00000000, 0x10531EBF,0x168DD58E,
	0xC0808400,0x00000000, 0x104731A0,0xA8927CAC,
	0xC0808800,0x00000000, 0x103C22B4,0xD28063BD,
	0xC0808C00,0x00000000, 0x103110A9,0x87A99BAF,
	0xC0809000,0x00000000, 0x1024B374,0x85A6AE4A,
	0xC0809400,0x00000000, 0x10191C90,0x6725C394,
	0xC0809800,0x00000000, 0x100E763E,0x0F12CD39,
	0xC0809C00,0x00000000, 0x100279DF,0x84AABC7F,
	0xC080A000,0x00000000, 0x0FF669A0,0x49C014B6,
	0xC080A400,0x00000000, 0x0FEB3017,0xA2269916,
	0xC080A800,0x00000000, 0x0FE07D82,0x6712E6B6,
	0xC080AC00,0x00000000, 0x0FD400F3,0x227AEEB9,
	0xC080B000,0x00000000, 0x0FC84406,0xAB7D71AE,
	0xC080B400,0x00000000, 0x0FBD6F91,0x8AA27EBD,
	0xC080B800,0x00000000, 0x0FB1DA8D,0xA821DDAD,
	0xC080BC00,0x00000000, 0x0FA5A85C,0x8983BC92,
	0xC080C000,0x00000000, 0x0F9A45A6,0x83827EA0,
	0xC080C400,0x00000000, 0x0F8FDEA0,0x5BDE75C9,
	0xC080C800,0x00000000, 0x0F835475,0x017AF871,
	0xC080CC00,0x00000000, 0x0F7772C8,0x26DA58D4,
	0xC080D000,0x00000000, 0x0F6C71BE,0x1205DD8D,
	0xC080D400,0x00000000, 0x0F614099,0x9D823B94,
	0xC080D800,0x00000000, 0x0F54ED9B,0x506932EF,
	0xC080DC00,0x00000000, 0x0F49631A,0xFE97B9B1,
	0xC080E000,0x00000000, 0x0F3ECBD0,0x3CE14DD8,
	0xC080E400,0x00000000, 0x0F32ADC6,0x49926059,
	0xC080E800,0x00000000, 0x0F26A895,0xF42D3418,
	0xC080EC00,0x00000000, 0x0F1B7C77,0x59AA4FF6,
	0xC080F000,0x00000000, 0x0F10ABD5,0x1E4C7042,
	0xC080F400,0x00000000, 0x0F043924,0x7BE94843,
	0xC080F800,0x00000000, 0x0EF88830,0xFB115D59,
	0xC080FC00,0x00000000, 0x0EEDC241,0xD6B1932C,
	0xC0810000,0x00000000, 0x0EE20CB4,0xE0C2F693,
	0xC0810400,0x00000000, 0x0ED5E533,0x4CBEBEC8,
	0xC0810800,0x00000000, 0x0ECA8F73,0xA7E2AB8F,
	0xC0810C00,0x00000000, 0x0EC01C13,0x7309D953,
	0xC0811000,0x00000000, 0x0EB38AC1,0xCD8A5E11,
	0xC0811400,0x00000000, 0x0EA7B4A6,0xABCA1802,
	0xC0811800,0x00000000, 0x0E9CC1A5,0x571D69E9,
	0xC0811C00,0x00000000, 0x0E917110,0x5D1587A6,
	0xC0812000,0x00000000, 0x0E852865,0x75EB0E41,
	0xC0812400,0x00000000, 0x0E79AA6B,0xBEBE254A,
	0xC0812800,0x00000000, 0x0E6F2252,0xCBB76A33,
	0xC0812C00,0x00000000, 0x0E62E23E,0xDA926562,
	0xC0813000,0x00000000, 0x0E56E83C,0x7B04E02F,
	0xC0813400,0x00000000, 0x0E4BC9AD,0x9C3FBD04,
	0xC0813800,0x00000000, 0x0E40DAA9,0xF60C798E,
	0xC0813C00,0x00000000, 0x0E3471F3,0xAF7A72A4,
	0xC0814000,0x00000000, 0x0E28CD1A,0xC69E588E,
	0xC0814400,0x00000000, 0x0E1E15DA,0x6AFC4D3E,
	0xC0814800,0x00000000, 0x0E123F68,0xFC4575DB,
	0xC0814C00,0x00000000, 0x0E0622B4,0xF7502E83,
	0xC0815000,0x00000000, 0x0DFADA10,0x1D510258,
	0xC0815400,0x00000000, 0x0DF04954,0x7693E4F4,
	0xC0815800,0x00000000, 0x0DE3C1A7,0x2292901E,
	0xC0815C00,0x00000000, 0x0DD7F73E,0x3985F587,
	0xC0816000,0x00000000, 0x0DCD126D,0x11767245,
	0xC0816400,0x00000000, 0x0DC1A20F,0x40AC4112,
	0xC0816800,0x00000000, 0x0DB563D4,0xC10E0648,
	0xC0816C00,0x00000000, 0x0DA9F284,0xD43FEA64,
	0xC0817000,0x00000000, 0x0D9F79C8,0x5ED5E0EC,
	0xC0817400,0x00000000, 0x0D93174A,0xD13A901B,
	0xC0817800,0x00000000, 0x0D872895,0xCF19DE71,
	0xC0817C00,0x00000000, 0x0D7C17BC,0xC4943A84,
	0xC0818000,0x00000000, 0x0D710A02,0x5BDDCE90,
	0xC0818400,0x00000000, 0x0D64AB62,0x789B3F6D,
	0xC0818800,0x00000000, 0x0D5912C6,0x280B3FE7,
	0xC0818C00,0x00000000, 0x0D4E6A5D,0xD404B0D4,
	0xC0819000,0x00000000, 0x0D4272AB,0x866D760E,
	0xC0819400,0x00000000, 0x0D3660E3,0x694EB13B,
	0xC0819800,0x00000000, 0x0D2B257E,0x2A2DF540,
	0xC0819C00,0x00000000, 0x0D207714,0x99C8147D,
	0xC081A000,0x00000000, 0x0D13F926,0xAD10B4A7,
	0xC081A400,0x00000000, 0x0D083A90,0xD7D67565,
	0xC081A800,0x00000000, 0x0CFD6417,0xB798615D,
	0xC081AC00,0x00000000, 0x0CF1D397,0xC6B5CE12,
	0xC081B000,0x00000000, 0x0CE59FEB,0x01BCEEA9,
	0xC081B400,0x00000000, 0x0CDA3B68,0x71DFA060,
	0xC081B800,0x00000000, 0x0CCFD233,0xA0E64E00,
	0xC081BC00,0x00000000, 0x0CC34CEB,0xCB9926B8,
	0xC081C000,0x00000000, 0x0CB769A3,0xE6B296E5,
	0xC081C400,0x00000000, 0x0CAC66A7,0x33F22068,
	0xC081C800,0x00000000, 0x0CA139DF,0xC14E1511,
	0xC081CC00,0x00000000, 0x0C94E572,0x97962240,
	0xC081D000,0x00000000, 0x0C895935,0x3F25F783,
	0xC081D400,0x00000000, 0x0C7EBFCE,0xA575BA73,
	0xC081D800,0x00000000, 0x0C72A67E,0x0F56D28A,
	0xC081DC00,0x00000000, 0x0C669FC0,0x88158C63,
	0xC081E000,0x00000000, 0x0C5B71C0,0x1B3DED84,
	0xC081E400,0x00000000, 0x0C50A555,0x41C161E9,
	0xC081E800,0x00000000, 0x0C443142,0x1E359EAD,
	0xC081EC00,0x00000000, 0x0C387EA0,0x94383D7A,
	0xC081F000,0x00000000, 0x0C2DB6A7,0xC6F5DCCD,
	0xC081F400,0x00000000, 0x0C2205AB,0x71D3E305,
	0xC081F800,0x00000000, 0x0C15DCAA,0x0CF9CDC5,
	0xC081FC00,0x00000000, 0x0C0A8518,0xD08CBA9A,
	0xC0820000,0x00000000, 0x0C0015CB,0xA207FDA9,
	0xC0820400,0x00000000, 0x0BF38323,0x6C479105,
	0xC0820800,0x00000000, 0x0BE7AB68,0xBD9864AA,
	0xC0820C00,0x00000000, 0x0BDCB66F,0x5253581E,
	0xC0821000,0x00000000, 0x0BD16A43,0x9BF9113A,
	0xC0821400,0x00000000, 0x0BC52025,0xD1A0DBF5,
	0xC0821800,0x00000000, 0x0BB9A06A,0x31B3FFAD,
	0xC0821C00,0x00000000, 0x0BAF162F,0x7A377C4D,
	0xC0822000,0x00000000, 0x0BA2DAE2,0x2B815A8F,
	0xC0822400,0x00000000, 0x0B96DF4E,0x3E5371D4,
	0xC0822800,0x00000000, 0x0B8BBED8,0x43BB3EF0,
	0xC0822C00,0x00000000, 0x0B80D417,0xD785EDD7,
	0xC0823000,0x00000000, 0x0B7469FB,0x2BF30362,
	0xC0823400,0x00000000, 0x0B68C36F,0x81EC1B2B,
	0xC0823800,0x00000000, 0x0B5E0A1F,0xC40034A2,
	0xC0823C00,0x00000000, 0x0B52384B,0xC8E64C4B,
	0xC0824000,0x00000000, 0x0B461A13,0xBCEC2990,
	0xC0824400,0x00000000, 0x0B3ACF98,0x2F74E138,
	0xC0824800,0x00000000, 0x0B3042FB,0x010675D2,
	0xC0824C00,0x00000000, 0x0B23B9F3,0x5A771BCB,
	0xC0825000,0x00000000, 0x0B17EDE6,0x55271177,
	0xC0825400,0x00000000, 0x0B0D0717,0x8E742492,
	0xC0825800,0x00000000, 0x0B019B2F,0x659409CA,
	0xC0825C00,0x00000000, 0x0AF55B7D,0xF0EA4C20,
	0xC0826000,0x00000000, 0x0AE9E867,0x2B833817,
	0xC0826400,0x00000000, 0x0ADF6D82,0xF48373C8,
	0xC0826800,0x00000000, 0x0AD30FD9,0x73DD2691,
	0xC0826C00,0x00000000, 0x0AC71F8E,0x7C1975D9,
	0xC0827000,0x00000000, 0x0ABC0CC8,0xFD684DF1,
	0xC0827400,0x00000000, 0x0AB1035D,0xC8120182,
	0xC0827800,0x00000000, 0x0AA4A353,0x9108D490,
	0xC0827C00,0x00000000, 0x0A9908FF,0xBA07361B,
	0xC0828000,0x00000000, 0x0A8E5E82,0x3A3B0994,
	0xC0828400,0x00000000, 0x0A826B7A,0x5716D93A,
	0xC0828800,0x00000000, 0x0A765829,0xF0EF7C8F,
	0xC0828C00,0x00000000, 0x0A6B1AE8,0xD4157ABA,
	0xC0829000,0x00000000, 0x0A6070A9,0x4E1F9059,
	0xC0829400,0x00000000, 0x0A53F15D,0x41FDE003,
	0xC0829800,0x00000000, 0x0A48311E,0xB45C7CA5,
	0xC0829C00,0x00000000, 0x0A3D58A2,0x5DE61EED,
	0xC082A000,0x00000000, 0x0A31CCA4,0x9BF94C40,
	0xC082A400,0x00000000, 0x0A25977C,0xC4A8696A,
	0xC082A800,0x00000000, 0x0A1A312E,0x5E7AD231,
	0xC082AC00,0x00000000, 0x0A0FC5CB,0xBDF91826,
	0xC082B000,0x00000000, 0x0A034565,0x85D7102A,
	0xC082B400,0x00000000, 0x09F76083,0x36EA2F37,
	0xC082B800,0x00000000, 0x09EC5B94,0xA8A1E898,
	0xC082BC00,0x00000000, 0x09E13328,0x84632FA5,
	0xC082C000,0x00000000, 0x09D4DD4D,0x0D12C071,
	0xC082C400,0x00000000, 0x09C94F53,0x5B837056,
	0xC082C800,0x00000000, 0x09BEB3D1,0xBC502A62,
	0xC082CC00,0x00000000, 0x09B29F38,0xABE56891,
	0xC082D000,0x00000000, 0x09A696EE,0x8DA1D378,
	0xC082D400,0x00000000, 0x099B670D,0x0A4D66C9,
	0xC082D800,0x00000000, 0x09909ED7,0xEDE30E86,
	0xC082DC00,0x00000000, 0x09842962,0xD363CE53,
	0xC082E000,0x00000000, 0x09787513,0xE7E86E26,
	0xC082E400,0x00000000, 0x096DAB12,0x3D2368AB,
	0xC082E800,0x00000000, 0x0961FEA4,0xC133D172,
	0xC082EC00,0x00000000, 0x0955D424,0x21266122,
	0xC082F000,0x00000000, 0x094A7AC2,0x02AC7312,
	0xC082F400,0x00000000, 0x09400F86,0x43D95176,
	0xC082F800,0x00000000, 0x09337B88,0x03654D1B,
	0xC082FC00,0x00000000, 0x0927A22E,0x69C901B3,
	0xC0830000,0x00000000, 0x091CAB3D,0xAC71D32F,
	0xC0830400,0x00000000, 0x09116379,0x818394A3,
	0xC0830800,0x00000000, 0x090517E9,0x6495D782,
	0xC0830C00,0x00000000, 0x08F9966C,0x8B4FF487,
	0xC0831000,0x00000000, 0x08EF0A10,0xE423A904,
	0xC0831400,0x00000000, 0x08E2D388,0x5B3416BE,
	0xC0831800,0x00000000, 0x08D6D663,0x7CF293E3,
	0xC0831C00,0x00000000, 0x08CBB407,0x246EEAD3,
	0xC0832000,0x00000000, 0x08C0CD88,0x48CA512E,
	0xC0832400,0x00000000, 0x08B46205,0xC3EFDF2E,
	0xC0832800,0x00000000, 0x08A8B9C8,0x023C95F8,
	0xC0832C00,0x00000000, 0x089DFE69,0xAFA213A3,
	0xC0833000,0x00000000, 0x08923131,0x5B8B02C6,
	0xC0833400,0x00000000, 0x08861175,0xDFD2DE88,
	0xC0833800,0x00000000, 0x087AC524,0x5665858A,
	0xC0833C00,0x00000000, 0x08703CA4,0x052D0954,
	0xC0834000,0x00000000, 0x0863B242,0x93142DAB,
	0xC0834400,0x00000000, 0x0857E492,0x15499393,
	0xC0834800,0x00000000, 0x084CFBC6,0x76A188E2,
	0xC0834C00,0x00000000, 0x08419452,0x3895364A,
	0xC0835000,0x00000000, 0x0835532A,0x610E58A3,
	0xC0835400,0x00000000, 0x0829DE4D,0x7461F2A9,
	0xC0835800,0x00000000, 0x081F6142,0x52E8284B,
	0xC0835C00,0x00000000, 0x0813086A,0xFD538E67,
	0xC0836000,0x00000000, 0x0807168A,0xAE316C71,
	0xC0836400,0x00000000, 0x07FC01D9,0x7B51D108,
	0xC0836800,0x00000000, 0x07F0FCBB,0xCB435662,
	0xC0836C00,0x00000000, 0x07E49B47,0xCDB567F7,
	0xC0837000,0x00000000, 0x07D8FF3D,0x1B9CB882,
	0xC0837400,0x00000000, 0x07CE52AB,0x3FE7C08D,
	0xC0837800,0x00000000, 0x07C2644B,0xF58EA085,
	0xC0837C00,0x00000000, 0x07B64F73,0xDF4E7A26,
	0xC0838000,0x00000000, 0x07AB1057,0x9E40BCD8,
	0xC0838400,0x00000000, 0x07A06A40,0x831F3461,
	0xC0838800,0x00000000, 0x0793E996,0xE012FEE2,
	0xC0838C00,0x00000000, 0x078827B0,0x3F9F6E83,
	0xC0839000,0x00000000, 0x077D4D31,0x7BCD311C,
	0xC0839400,0x00000000, 0x0771C5B4,0x26DD8383,
	0xC0839800,0x00000000, 0x07658F11,0xD0FDA401,
	0xC0839C00,0x00000000, 0x075A26F8,0x47C58BC3,
	0xC083A000,0x00000000, 0x074FB968,0xB133627C,
	0xC083A400,0x00000000, 0x07433DE2,0x2F0F7B7D,
	0xC083A800,0x00000000, 0x07375766,0x161D6EFA,
	0xC083AC00,0x00000000, 0x072C5086,0x6E65BA35,
	0xC083B000,0x00000000, 0x07212C73,0xE5BBD5FC,
	0xC083B400,0x00000000, 0x0714D52A,0xAFA195A6,
	0xC083B800,0x00000000, 0x07094575,0x522F0869,
	0xC083BC00,0x00000000, 0x06FEA7D9,0x7F9D74A6,
	0xC083C000,0x00000000, 0x06F297F6,0x1E22C99D,
	0xC083C400,0x00000000, 0x06E68E20,0x037A51BF,
	0xC083C800,0x00000000, 0x06DB5C5E,0x2537C88E,
	0xC083CC00,0x00000000, 0x06D0985D,0x21B4917C,
	0xC083D000,0x00000000, 0x06C42186,0x9A4110E5,
	0xC083D400,0x00000000, 0x06B86B8A,0xF4ADCC6C,
	0xC083D800,0x00000000, 0x06AD9F81,0x3776CA1F,
	0xC083DC00,0x00000000, 0x06A1F7A0,0xCDD0F45A,
	0xC083E000,0x00000000, 0x0695CBA1,0x87F85526,
	0xC083E400,0x00000000, 0x068A706F,0x3CAEED22,
	0xC083E800,0x00000000, 0x06800943,0x578974D3,
	0xC083EC00,0x00000000, 0x067373EF,0x91BB2152,
	0xC083F000,0x00000000, 0x066798F7,0xAEF4551C,
	0xC083F400,0x00000000, 0x065CA010,0x63C4A31B,
	0xC083F800,0x00000000, 0x06515CB2,0x0CAC7D62,
	0xC083FC00,0x00000000, 0x06450FB0,0x2D890D3D,
	0xC0840000,0x00000000, 0x06398C72,0xCA0CAE46,
	0xC0840400,0x00000000, 0x062EFDF7,0x07A3A70D,
	0xC0840800,0x00000000, 0x0622CC31,0x688C252A,
	0xC0840C00,0x00000000, 0x0616CD7C,0x3586C936,
	0xC0841000,0x00000000, 0x060BA93A,0x3CB53A35,
	0xC0841400,0x00000000, 0x0600C6FB,0x48D9F88F,
	0xC0841800,0x00000000, 0x05F45A13,0x763AE1F1,
	0xC0841C00,0x00000000, 0x05E8B024,0x461790A0,
	0xC0842000,0x00000000, 0x05DDF2B8,0x2C19897E,
	0xC0842400,0x00000000, 0x05D22A19,0xB31ECAA5,
	0xC0842800,0x00000000, 0x05C608DB,0x5EB484AD,
	0xC0842C00,0x00000000, 0x05BABAB4,0x908B9BAB,
	0xC0843000,0x00000000, 0x05B0364F,0x82109118,
	0xC0843400,0x00000000, 0x05A3AA94,0xCB3E1403,
	0xC0843800,0x00000000, 0x0597DB41,0x7881EFAD,
	0xC0843C00,0x00000000, 0x058CF079,0xC8459DD0,
	0xC0844000,0x00000000, 0x05818D77,0xB8A44AD7,
	0xC0844400,0x00000000, 0x05754ADA,0x1035B28E,
	0xC0844800,0x00000000, 0x0569D437,0xAD527EDA,
	0xC0844C00,0x00000000, 0x055F5506,0x78268673,
	0xC0845000,0x00000000, 0x055300FF,0x6C7C2E28,
	0xC0845400,0x00000000, 0x05470D8A,0x640274EF,
	0xC0845800,0x00000000, 0x053BF6EE,0x3CA69D34,
	0xC0845C00,0x00000000, 0x0530F61C,0x646F53FB,
	0xC0846000,0x00000000, 0x0524933F,0x2D676E53,
	0xC0846400,0x00000000, 0x0518F57E,0x4B4F6DF1,
	0xC0846800,0x00000000, 0x050E46D8,0xE33D72F8,
	0xC0846C00,0x00000000, 0x05025D20,0x60BCF3B2,
	0xC0847000,0x00000000, 0x04F646C1,0x33183202,
	0xC0847400,0x00000000, 0x04EB05CA,0x8713EFBB,
	0xC0847800,0x00000000, 0x04E063DA,0x37CD3C33,
	0xC0847C00,0x00000000, 0x04D3E1D3,0x862115AA,
	0xC0848000,0x00000000, 0x04C81E45,0x782FC195,
	0xC0848400,0x00000000, 0x04BD41C5,0x0F8FBFB0,
	0xC0848800,0x00000000, 0x04B1BEC6,0x665408BB,
	0xC0848C00,0x00000000, 0x04A586AA,0x257495B1,
	0xC0849000,0x00000000, 0x049A1CC6,0x2C31E026,
	0xC0849400,0x00000000, 0x048FAD0A,0x78B277BE,
	0xC0849800,0x00000000, 0x04833661,0xC61DA1B7,
	0xC0849C00,0x00000000, 0x04774E4C,0x82E92E0E,
	0xC084A000,0x00000000, 0x046C457C,0x838EC18B,
	0xC084A400,0x00000000, 0x046125C1,0xE452B8CC,
	0xC084A800,0x00000000, 0x0454CD0B,0x7E05A5C6,
	0xC084AC00,0x00000000, 0x04493B9B,0x21A83A1F,
	0xC084B000,0x00000000, 0x043E9BE5,0xED8B2664,
	0xC084B400,0x00000000, 0x043290B6,0x64F40B56,
	0xC084B800,0x00000000, 0x04268554,0xE847D59B,
	0xC084BC00,0x00000000, 0x041B51B3,0x6A5CC22B,
	0xC084C000,0x00000000, 0x041091E4,0xDC3968C8,
	0xC084C400,0x00000000, 0x040419AD,0x719B17A8,
	0xC084C800,0x00000000, 0x03F86205,0xB914C66C,
	0xC084CC00,0x00000000, 0x03ED93F4,0xB42D4482,
	0xC084D000,0x00000000, 0x03E1F09F,0x9699E8FA,
	0xC084D400,0x00000000, 0x03D5C322,0x40240796,
	0xC084D800,0x00000000, 0x03CA6620,0x7D01DE07,
	0xC084DC00,0x00000000, 0x03C00302,0xDC246720,
	0xC084E000,0x00000000, 0x03B36C5A,0x1621103F,
	0xC084E400,0x00000000, 0x03A78FC4,0x8BB35116,
	0xC084E800,0x00000000, 0x039C94E7,0x769839F2,
	0xC084EC00,0x00000000, 0x039155ED,0x3C6B9E1E,
	0xC084F000,0x00000000, 0x0385077A,0x2B3A069B,
	0xC084F400,0x00000000, 0x0379827C,0xEC656F24,
	0xC084F800,0x00000000, 0x036EF1E1,0xE2DFE53B,
	0xC084FC00,0x00000000, 0x0362C4DD,0x526B80BB,
	0xC0850000,0x00000000, 0x0356C498,0x66B51C22,
	0xC0850400,0x00000000, 0x034B9E71,0x8AE94AF2,
	0xC0850800,0x00000000, 0x0340C070,0xD6B59CA4,
	0xC0850C00,0x00000000, 0x03345224,0x419E607D,
	0xC0851000,0x00000000, 0x0328A684,0x4C05657D,
	0xC0851400,0x00000000, 0x031DE70B,0x379EE75F,
	0xC0851800,0x00000000, 0x03122304,0xCE8D412E,
	0xC0851C00,0x00000000, 0x03060044,0x3841D62C,
	0xC0852000,0x00000000, 0x02FAB048,0xDC506EC0,
	0xC0852400,0x00000000, 0x02F02FFD,0x76BA5F10,
	0xC0852800,0x00000000, 0x02E3A2EA,0x01C991EE,
	0xC0852C00,0x00000000, 0x02D7D1F4,0x7D652759,
	0xC0853000,0x00000000, 0x02CCE531,0x81A80DE5,
	0xC0853400,0x00000000, 0x02C1869F,0xE4B63400,
	0xC0853800,0x00000000, 0x02B5428C,0xFD1C5F1E,
	0xC0853C00,0x00000000, 0x02A9CA25,0xD4CBDADB,
	0xC0854000,0x00000000, 0x029F48CF,0x6261D064,
	0xC0854400,0x00000000, 0x0292F996,0xC035DD46,
	0xC0854800,0x00000000, 0x0287048D,0x9C2DCB01,
	0xC0854C00,0x00000000, 0x027BEC07,0x3FBD3202,
	0xC0855000,0x00000000, 0x0270EF7F,0x9293E5DA,
	0xC0855400,0x00000000, 0x02648B39,0xAEE5D690,
	0xC0855800,0x00000000, 0x0258EBC3,0x47A39184,
	0xC0855C00,0x00000000, 0x024E3B0B,0x226F71EF,
	0xC0856000,0x00000000, 0x024255F7,0x978A67A0,
	0xC0856400,0x00000000, 0x02363E11,0xEAF9B07D,
	0xC0856800,0x00000000, 0x022AFB41,0x8CF3E80F,
	0xC0856C00,0x00000000, 0x02205D76,0x6B3044CB,
	0xC0857000,0x00000000, 0x0213DA13,0x32F99EDE,
	0xC0857400,0x00000000, 0x020814DE,0x5C9E7BBA,
	0xC0857800,0x00000000, 0x01FD365D,0x1770A040,
	0xC0857C00,0x00000000, 0x01F1B7DB,0x594EDA35,
	0xC0858000,0x00000000, 0x01E57E45,0xC0C5B59D,
	0xC0858400,0x00000000, 0x01DA1298,0x0A327D8C,
	0xC0858800,0x00000000, 0x01CFA0B1,0x12945ED6,
	0xC0858C00,0x00000000, 0x01C32EE4,0x49DD2E00,
	0xC0859000,0x00000000, 0x01B74536,0x7BEACEC7,
	0xC0859400,0x00000000, 0x01AC3A76,0xE66ED2E1,
	0xC0859800,0x00000000, 0x01A11F12,0x7F22EEA9,
	0xC0859C00,0x00000000, 0x0194C4EF,0x7702704E,
	0xC085A000,0x00000000, 0x018931C4,0xC86F15C5,
	0xC085A400,0x00000000, 0x017E8FF7,0x04478297,
	0xC085A800,0x00000000, 0x01728979,0x7F3EB1AF,
	0xC085AC00,0x00000000, 0x01667C8D,0x3AB3B33F,
	0xC085B000,0x00000000, 0x015B470C,0xD81CA546,
	0xC085B400,0x00000000, 0x01508B6F,0x1C7574DA,
	0xC085B800,0x00000000, 0x014411D7,0x58400B4D,
	0xC085BC00,0x00000000, 0x01385884,0x33AA5B26,
	0xC085C000,0x00000000, 0x012D886C,0xB184CAE4,
	0xC085C400,0x00000000, 0x0121E9A1,0x1A7DB725,
	0xC085C800,0x00000000, 0x0115BAA6,0x485E5782,
	0xC085CC00,0x00000000, 0x010A5BD5,0xC21397D5,
	0xC085D000,0x00000000, 0x00FFF989,0xA16D0DBB,
	0xC085D400,0x00000000, 0x00F364C7,0x8F6F8FDB,
	0xC085D800,0x00000000, 0x00E78694,0xFE9F73CC,
	0xC085DC00,0x00000000, 0x00DC89C2,0xE339B392,
	0xC085E000,0x00000000, 0x00D14F2B,0x0FB9307F,
	0xC085E400,0x00000000, 0x00C4FF47,0x5C68CA02,
	0xC085E800,0x00000000, 0x00B9788A,0xF0D610E6,
	0xC085EC00,0x00000000, 0x00AEE5D1,0x74018A3B,
	0xC085F000,0x00000000, 0x00A2BD8C,0x17B493DC,
	0xC085F400,0x00000000, 0x0096BBB8,0x0F231E3D,
	0xC085F800,0x00000000, 0x008B93AD,0x0D66DEFD,
	0xC085FC00,0x00000000, 0x0080B9E8,0xF15E599E,
	0xC0860000,0x00000000, 0x00744A38,0x24E5285F,
	0xC0860400,0x00000000, 0x00689CE8,0x128F015B,
	0xC0860800,0x00000000, 0x005DDB62,0xD06B3019,
	0xC0860C00,0x00000000, 0x00521BF2,0xACC26F65,
	0xC0861000,0x00000000, 0x0045F7B0,0x6B2C0FE5,
	0xC0861400,0x00000000, 0x003AA5E1,0x381DE881,
	0xC0861800,0x00000000, 0x003029AD,0xE2342558,
	0xC0861C00,0x00000000, 0x00239B42,0x358BDF31,
	0xC0862000,0x00000000, 0x0017C8AB,0x2288C9AB,
	};

LOCAL_D const TUint32 LnTest[] =
	{
	0x3FD00000,0x00000000, 0xBFF62E42,0xFEFA39EF,
	0x3FD01062,0x4DD2F1AA, 0xBFF61DE9,0x0EED76F7,
	0x3FD020C4,0x9BA5E354, 0xBFF60D9F,0xC3B96425,
	0x3FD03126,0xE978D4FE, 0xBFF5FD66,0xFB9E280A,
	0x3FD04189,0x374BC6A8, 0xBFF5ED3E,0x95422881,
	0x3FD051EB,0x851EB852, 0xBFF5DD26,0x6FB06F4F,
	0x3FD0624D,0xD2F1A9FC, 0xBFF5CD1E,0x6A5716C4,
	0x3FD072B0,0x20C49BA6, 0xBFF5BD26,0x6505BE3E,
	0x3FD08312,0x6E978D50, 0xBFF5AD3E,0x3FEC065D,
	0x3FD09374,0xBC6A7EFA, 0xBFF59D65,0xDB9814AF,
	0x3FD0A3D7,0x0A3D70A4, 0xBFF58D9D,0x18F51EBC,
	0x3FD0B439,0x5810624E, 0xBFF57DE3,0xD949FC2E,
	0x3FD0C49B,0xA5E353F8, 0xBFF56E39,0xFE37C000,
	0x3FD0D4FD,0xF3B645A2, 0xBFF55E9F,0x69B8587E,
	0x3FD0E560,0x4189374C, 0xBFF54F13,0xFE1D35F8,
	0x3FD0F5C2,0x8F5C28F6, 0xBFF53F97,0x9E0DF7F8,
	0x3FD10624,0xDD2F1AA0, 0xBFF5302A,0x2C8720D9,
	0x3FD11687,0x2B020C4A, 0xBFF520CB,0x8CD8CF9D,
	0x3FD126E9,0x78D4FDF4, 0xBFF5117B,0xA2A57FDC,
	0x3FD1374B,0xC6A7EF9E, 0xBFF5023A,0x51E0CFA5,
	0x3FD147AE,0x147AE148, 0xBFF4F307,0x7ECE4B36,
	0x3FD15810,0x624DD2F2, 0xBFF4E3E3,0x0E003E69,
	0x3FD16872,0xB020C49C, 0xBFF4D4CC,0xE4568BAF,
	0x3FD178D4,0xFDF3B646, 0xBFF4C5C4,0xE6FD887D,
	0x3FD18937,0x4BC6A7F0, 0xBFF4B6CA,0xFB6CDF16,
	0x3FD19999,0x9999999A, 0xBFF4A7DF,0x07667582,
	0x3FD1A9FB,0xE76C8B44, 0xBFF49900,0xF0F559A7,
	0x3FD1BA5E,0x353F7CEE, 0xBFF48A30,0x9E6CB255,
	0x3FD1CAC0,0x83126E98, 0xBFF47B6D,0xF666B540,
	0x3FD1DB22,0xD0E56042, 0xBFF46CB8,0xDFC3A1B8,
	0x3FD1EB85,0x1EB851EC, 0xBFF45E11,0x41A8C00F,
	0x3FD1FBE7,0x6C8B4396, 0xBFF44F77,0x037F6597,
	0x3FD20C49,0xBA5E353F, 0xBFF440EA,0x0CF3FD13,
	0x3FD21CAC,0x083126E9, 0xBFF4326A,0x45F5138A,
	0x3FD22D0E,0x56041893, 0xBFF423F7,0x96B2696E,
	0x3FD23D70,0xA3D70A3D, 0xBFF41591,0xE79C07EB,
	0x3FD24DD2,0xF1A9FBE7, 0xBFF40739,0x21615A50,
	0x3FD25E35,0x3F7CED91, 0xBFF3F8ED,0x2CF04B8F,
	0x3FD26E97,0x8D4FDF3B, 0xBFF3EAAD,0xF3746796,
	0x3FD27EF9,0xDB22D0E5, 0xBFF3DC7B,0x5E56009A,
	0x3FD28F5C,0x28F5C28F, 0xBFF3CE55,0x57395819,
	0x3FD29FBE,0x76C8B439, 0xBFF3C03B,0xC7FDCB97,
	0x3FD2B020,0xC49BA5E3, 0xBFF3B22E,0x9ABD04F9,
	0x3FD2C083,0x126E978D, 0xBFF3A42D,0xB9CA2E6F,
	0x3FD2D0E5,0x60418937, 0xBFF39639,0x0FB129D0,
	0x3FD2E147,0xAE147AE1, 0xBFF38850,0x8735CB6B,
	0x3FD2F1A9,0xFBE76C8B, 0xBFF37A74,0x0B531820,
	0x3FD3020C,0x49BA5E35, 0xBFF36CA3,0x873A86CA,
	0x3FD3126E,0x978D4FDF, 0xBFF35EDE,0xE65344D6,
	0x3FD322D0,0xE5604189, 0xBFF35126,0x14397DFF,
	0x3FD33333,0x33333333, 0xBFF34378,0xFCBDA721,
	0x3FD34395,0x810624DD, 0xBFF335D7,0x8BE3CC08,
	0x3FD353F7,0xCED91687, 0xBFF32841,0xADE2E03D,
	0x3FD3645A,0x1CAC0831, 0xBFF31AB7,0x4F2412B4,
	0x3FD374BC,0x6A7EF9DB, 0xBFF30D38,0x5C42244A,
	0x3FD3851E,0xB851EB85, 0xBFF2FFC4,0xC208C11A,
	0x3FD39581,0x0624DD2F, 0xBFF2F25C,0x6D73DC81,
	0x3FD3A5E3,0x53F7CED9, 0xBFF2E4FF,0x4BAF0FD0,
	0x3FD3B645,0xA1CAC083, 0xBFF2D7AD,0x4A14FBA3,
	0x3FD3C6A7,0xEF9DB22D, 0xBFF2CA66,0x562EABC7,
	0x3FD3D70A,0x3D70A3D7, 0xBFF2BD2A,0x5DB2FDA2,
	0x3FD3E76C,0x8B439581, 0xBFF2AFF9,0x4E86091C,
	0x3FD3F7CE,0xD916872B, 0xBFF2A2D3,0x16B88BEE,
	0x3FD40831,0x26E978D5, 0xBFF295B7,0xA4875754,
	0x3FD41893,0x74BC6A7F, 0xBFF288A6,0xE65AC018,
	0x3FD428F5,0xC28F5C29, 0xBFF27BA0,0xCAC610E1,
	0x3FD43958,0x10624DD3, 0xBFF26EA5,0x4086FEC6,
	0x3FD449BA,0x5E353F7D, 0xBFF261B4,0x36852010,
	0x3FD45A1C,0xAC083127, 0xBFF254CD,0x9BD16529,
	0x3FD46A7E,0xF9DB22D1, 0xBFF247F1,0x5FA593AC,
	0x3FD47AE1,0x47AE147B, 0xBFF23B1F,0x7163C380,
	0x3FD48B43,0x95810625, 0xBFF22E57,0xC095DE09,
	0x3FD49BA5,0xE353F7CF, 0xBFF2219A,0x3CED1F52,
	0x3FD4AC08,0x3126E979, 0xBFF214E6,0xD6419934,
	0x3FD4BC6A,0x7EF9DB23, 0xBFF2083D,0x7C91B867,
	0x3FD4CCCC,0xCCCCCCCD, 0xBFF1FB9E,0x2001CB78,
	0x3FD4DD2F,0x1A9FBE77, 0xBFF1EF08,0xB0DB8B9D,
	0x3FD4ED91,0x6872B021, 0xBFF1E27D,0x1F8DA75D,
	0x3FD4FDF3,0xB645A1CB, 0xBFF1D5FB,0x5CAB4EFF,
	0x3FD50E56,0x04189375, 0xBFF1C983,0x58EBC2BD,
	0x3FD51EB8,0x51EB851F, 0xBFF1BD15,0x0529E2B4,
	0x3FD52F1A,0x9FBE76C9, 0xBFF1B0B0,0x5263C081,
	0x3FD53F7C,0xED916873, 0xBFF1A455,0x31BA328B,
	0x3FD54FDF,0x3B645A1D, 0xBFF19803,0x947068F1,
	0x3FD56041,0x89374BC7, 0xBFF18BBB,0x6BEB840F,
	0x3FD570A3,0xD70A3D71, 0xBFF17F7C,0xA9B22C98,
	0x3FD58106,0x24DD2F1B, 0xBFF17347,0x3F6C2D40,
	0x3FD59168,0x72B020C5, 0xBFF1671B,0x1EE20DE8,
	0x3FD5A1CA,0xC083126F, 0xBFF15AF8,0x39FCB045,
	0x3FD5B22D,0x0E560419, 0xBFF14EDE,0x82C4EE07,
	0x3FD5C28F,0x5C28F5C3, 0xBFF142CD,0xEB63386A,
	0x3FD5D2F1,0xA9FBE76D, 0xBFF136C6,0x661F3935,
	0x3FD5E353,0xF7CED917, 0xBFF12AC7,0xE55F751B,
	0x3FD5F3B6,0x45A1CAC1, 0xBFF11ED2,0x5BA8EF7B,
	0x3FD60418,0x9374BC6A, 0xBFF112E5,0xBB9ECF78,
	0x3FD6147A,0xE147AE14, 0xBFF10701,0xF8020663,
	0x3FD624DD,0x2F1A9FBE, 0xBFF0FB27,0x03B0F76F,
	0x3FD6353F,0x7CED9168, 0xBFF0EF54,0xD1A720AE,
	0x3FD645A1,0xCAC08312, 0xBFF0E38B,0x54FCC54A,
	0x3FD65604,0x189374BC, 0xBFF0D7CA,0x80E69901,
	0x3FD66666,0x66666666, 0xBFF0CC12,0x48B56CCC,
	0x3FD676C8,0xB4395810, 0xBFF0C062,0x9FD5DCC0,
	0x3FD6872B,0x020C49BA, 0xBFF0B4BB,0x79CFFF14,
	0x3FD6978D,0x4FDF3B64, 0xBFF0A91C,0xCA471450,
	0x3FD6A7EF,0x9DB22D0E, 0xBFF09D86,0x84F9389C,
	0x3FD6B851,0xEB851EB8, 0xBFF091F8,0x9DBF162A,
	0x3FD6C8B4,0x39581062, 0xBFF08673,0x088B98B9,
	0x3FD6D916,0x872B020C, 0xBFF07AF5,0xB96BA22C,
	0x3FD6E978,0xD4FDF3B6, 0xBFF06F80,0xA485C029,
	0x3FD6F9DB,0x22D0E560, 0xBFF06413,0xBE19E2CC,
	0x3FD70A3D,0x70A3D70A, 0xBFF058AE,0xFA811452,
	0x3FD71A9F,0xBE76C8B4, 0xBFF04D52,0x4E2D31CF,
	0x3FD72B02,0x0C49BA5E, 0xBFF041FD,0xADA8A4DF,
	0x3FD73B64,0x5A1CAC08, 0xBFF036B1,0x0D961E48,
	0x3FD74BC6,0xA7EF9DB2, 0xBFF02B6C,0x62B05199,
	0x3FD75C28,0xF5C28F5C, 0xBFF0202F,0xA1C9B1B5,
	0x3FD76C8B,0x43958106, 0xBFF014FA,0xBFCC2E4B,
	0x3FD77CED,0x916872B0, 0xBFF009CD,0xB1B8F237,
	0x3FD78D4F,0xDF3B645A, 0xBFEFFD50,0xD9504585,
	0x3FD79DB2,0x2D0E5604, 0xBFEFE715,0xCB913FA1,
	0x3FD7AE14,0x7AE147AE, 0xBFEFD0EA,0x24BF89B7,
	0x3FD7BE76,0xC8B43958, 0xBFEFBACD,0xCF9255A9,
	0x3FD7CED9,0x16872B02, 0xBFEFA4C0,0xB6ECD5A7,
	0x3FD7DF3B,0x645A1CAC, 0xBFEF8EC2,0xC5DDC33E,
	0x3FD7EF9D,0xB22D0E56, 0xBFEF78D3,0xE79EE7FD,
	0x3FD80000,0x00000000, 0xBFEF62F4,0x0794A7B8,
	0x3FD81062,0x4DD2F1AA, 0xBFEF4D23,0x114D8C5B,
	0x3FD820C4,0x9BA5E354, 0xBFEF3760,0xF081D343,
	0x3FD83126,0xE978D4FE, 0xBFEF21AD,0x9112FC25,
	0x3FD84189,0x374BC6A8, 0xBFEF0C08,0xDF0B596A,
	0x3FD851EB,0x851EB852, 0xBFEEF672,0xC69DA20B,
	0x3FD8624D,0xD2F1A9FC, 0xBFEEE0EB,0x342484DC,
	0x3FD872B0,0x20C49BA6, 0xBFEECB72,0x14223D43,
	0x3FD88312,0x6E978D50, 0xBFEEB607,0x53402957,
	0x3FD89374,0xBC6A7EFA, 0xBFEEA0AA,0xDE4E6162,
	0x3FD8A3D7,0x0A3D70A4, 0xBFEE8B5C,0xA24350BE,
	0x3FD8B439,0x5810624E, 0xBFEE761C,0x8C3B5003,
	0x3FD8C49B,0xA5E353F8, 0xBFEE60EA,0x89784093,
	0x3FD8D4FD,0xF3B645A2, 0xBFEE4BC6,0x87612963,
	0x3FD8E560,0x4189374C, 0xBFEE36B0,0x7381D516,
	0x3FD8F5C2,0x8F5C28F6, 0xBFEE21A8,0x3B8A7153,
	0x3FD90624,0xDD2F1AA0, 0xBFEE0CAD,0xCD4F2F5A,
	0x3FD91687,0x2B020C4A, 0xBFEDF7C1,0x16C7E5D7,
	0x3FD926E9,0x78D4FDF4, 0xBFEDE2E2,0x060FB3D9,
	0x3FD9374B,0xC6A7EF9E, 0xBFEDCE10,0x8964A50A,
	0x3FD947AE,0x147AE148, 0xBFEDB94C,0x8F275703,
	0x3FD95810,0x624DD2F2, 0xBFEDA496,0x05DA9FCA,
	0x3FD96872,0xB020C49C, 0xBFED8FEC,0xDC233575,
	0x3FD978D4,0xFDF3B646, 0xBFED7B51,0x00C756E1,
	0x3FD98937,0x4BC6A7F0, 0xBFED66C2,0x62AE758C,
	0x3FD99999,0x9999999A, 0xBFED5240,0xF0E0E077,
	0x3FD9A9FB,0xE76C8B44, 0xBFED3DCC,0x9A877023,
	0x3FD9BA5E,0x353F7CEE, 0xBFED2965,0x4EEB3392,
	0x3FD9CAC0,0x83126E98, 0xBFED150A,0xFD751E56,
	0x3FD9DB22,0xD0E56042, 0xBFED00BD,0x95ADB79D,
	0x3FD9EB85,0x1EB851EC, 0xBFECEC7D,0x073CCA46,
	0x3FD9FBE7,0x6C8B4396, 0xBFECD849,0x41E915E9,
	0x3FDA0C49,0xBA5E353F, 0xBFECC422,0x359800DF,
	0x3FDA1CAC,0x083126E9, 0xBFECB007,0xD24D4B39,
	0x3FDA2D0E,0x56041893, 0xBFEC9BFA,0x082AC2AE,
	0x3FDA3D70,0xA3D70A3D, 0xBFEC87F8,0xC76FF776,
	0x3FDA4DD2,0xF1A9FBE7, 0xBFEC7404,0x0079F207,
	0x3FDA5E35,0x3F7CED91, 0xBFEC601B,0xA3C2E9C5,
	0x3FDA6E97,0x8D4FDF3B, 0xBFEC4C3F,0xA1E1FC8E,
	0x3FDA7EF9,0xDB22D0E5, 0xBFEC386F,0xEB8AE729,
	0x3FDA8F5C,0x28F5C28F, 0xBFEC24AC,0x718DBE8F,
	0x3FDA9FBE,0x76C8B439, 0xBFEC10F5,0x24D6AA13,
	0x3FDAB020,0xC49BA5E3, 0xBFEBFD49,0xF66D9E5B,
	0x3FDAC083,0x126E978D, 0xBFEBE9AA,0xD7761933,
	0x3FDAD0E5,0x60418937, 0xBFEBD617,0xB92EDE28,
	0x3FDAE147,0xAE147AE1, 0xBFEBC290,0x8CF1B3F9,
	0x3FDAF1A9,0xFBE76C8B, 0xBFEBAF15,0x443322D0,
	0x3FDB020C,0x49BA5E35, 0xBFEB9BA5,0xD082333D,
	0x3FDB126E,0x978D4FDF, 0xBFEB8842,0x23882DFF,
	0x3FDB22D0,0xE5604189, 0xBFEB74EA,0x2F085C8A,
	0x3FDB3333,0x33333333, 0xBFEB619D,0xE4DFCA4D,
	0x3FDB4395,0x810624DD, 0xBFEB4E5D,0x370506B6,
	0x3FDB53F7,0xCED91687, 0xBFEB3B28,0x1787E7ED,
	0x3FDB645A,0x1CAC0831, 0xBFEB27FE,0x78914E48,
	0x3FDB74BC,0x6A7EF9DB, 0xBFEB14E0,0x4C62E87A,
	0x3FDB851E,0xB851EB85, 0xBFEB01CD,0x8556F868,
	0x3FDB9581,0x0624DD2F, 0xBFEAEEC6,0x15E018B7,
	0x3FDBA5E3,0x53F7CED9, 0xBFEADBC9,0xF0890306,
	0x3FDBB645,0xA1CAC083, 0xBFEAC8D9,0x07F456D1,
	0x3FDBC6A7,0xEF9DB22D, 0xBFEAB5F3,0x4EDC60FD,
	0x3FDBD70A,0x3D70A3D7, 0xBFEAA318,0xB812E40B,
	0x3FDBE76C,0x8B439581, 0xBFEA9049,0x3680E0F1,
	0x3FDBF7CE,0xD916872B, 0xBFEA7D84,0xBD266090,
	0x3FDC0831,0x26E978D5, 0xBFEA6ACB,0x3F1A3DCC,
	0x3FDC1893,0x74BC6A7F, 0xBFEA581C,0xAF89F043,
	0x3FDC28F5,0xC28F5C29, 0xBFEA4579,0x01B9579F,
	0x3FDC3958,0x10624DD3, 0xBFEA32E0,0x2902877A,
	0x3FDC49BA,0x5E353F7D, 0xBFEA2052,0x18D593E8,
	0x3FDC5A1C,0xAC083127, 0xBFEA0DCE,0xC4B85E82,
	0x3FDC6A7E,0xF9DB22D1, 0xBFE9FB56,0x2046641A,
	0x3FDC7AE1,0x47AE147B, 0xBFE9E8E8,0x1F308AE9,
	0x3FDC8B43,0x95810625, 0xBFE9D684,0xB53CF164,
	0x3FDC9BA5,0xE353F7CF, 0xBFE9C42B,0xD646BD85,
	0x3FDCAC08,0x3126E979, 0xBFE9B1DD,0x763DECB8,
	0x3FDCBC6A,0x7EF9DB23, 0xBFE99F99,0x8927243C,
	0x3FDCCCCC,0xCCCCCCCD, 0xBFE98D60,0x031B821B,
	0x3FDCDD2F,0x1A9FBE77, 0xBFE97B30,0xD8486E9C,
	0x3FDCED91,0x6872B021, 0xBFE9690B,0xFCEF6E46,
	0x3FDCFDF3,0xB645A1CB, 0xBFE956F1,0x6565F454,
	0x3FDD0E56,0x04189375, 0xBFE944E1,0x061535BD,
	0x3FDD1EB8,0x51EB851F, 0xBFE932DA,0xD379FCA8,
	0x3FDD2F1A,0x9FBE76C9, 0xBFE920DE,0xC2247C6D,
	0x3FDD3F7C,0xED916873, 0xBFE90EEC,0xC6B82605,
	0x3FDD4FDF,0x3B645A1D, 0xBFE8FD04,0xD5EB7CFD,
	0x3FDD6041,0x89374BC7, 0xBFE8EB26,0xE487ECDB,
	0x3FDD70A3,0xD70A3D71, 0xBFE8D952,0xE7699EFC,
	0x3FDD8106,0x24DD2F1B, 0xBFE8C788,0xD37F50EA,
	0x3FDD9168,0x72B020C5, 0xBFE8B5C8,0x9DCA2B20,
	0x3FDDA1CA,0xC083126F, 0xBFE8A412,0x3B5D9842,
	0x3FDDB22D,0x0E560419, 0xBFE89265,0xA15F1CCA,
	0x3FDDC28F,0x5C28F5C3, 0xBFE880C2,0xC5062F1E,
	0x3FDDD2F1,0xA9FBE76D, 0xBFE86F29,0x9B9C1017,
	0x3FDDE353,0xF7CED917, 0xBFE85D9A,0x1A7BA3F3,
	0x3FDDF3B6,0x45A1CAC1, 0xBFE84C14,0x37114BB5,
	0x3FDE0418,0x9374BC6A, 0xBFE83A97,0xE6DABEE9,
	0x3FDE147A,0xE147AE14, 0xBFE82925,0x1F66E5D3,
	0x3FDE24DD,0x2F1A9FBE, 0xBFE817BB,0xD655B40A,
	0x3FDE353F,0x7CED9168, 0xBFE8065C,0x0158036F,
	0x3FDE45A1,0xCAC08312, 0xBFE7F505,0x962F6F8F,
	0x3FDE5604,0x189374BC, 0xBFE7E3B8,0x8AAE3166,
	0x3FDE6666,0x66666666, 0xBFE7D274,0xD4B6FB83,
	0x3FDE76C8,0xB4395810, 0xBFE7C13A,0x6A3CD68E,
	0x3FDE872B,0x020C49BA, 0xBFE7B009,0x4142FE2D,
	0x3FDE978D,0x4FDF3B64, 0xBFE79EE1,0x4FDCBE46,
	0x3FDEA7EF,0x9DB22D0E, 0xBFE78DC2,0x8C2D50A0,
	0x3FDEB851,0xEB851EB8, 0xBFE77CAC,0xEC67BADA,
	0x3FDEC8B4,0x39581062, 0xBFE76BA0,0x66CEACCA,
	0x3FDED916,0x872B020C, 0xBFE75A9C,0xF1B45F21,
	0x3FDEE978,0xD4FDF3B6, 0xBFE749A2,0x837A727E,
	0x3FDEF9DB,0x22D0E560, 0xBFE738B1,0x1291CEC6,
	0x3FDF0A3D,0x70A3D70A, 0xBFE727C8,0x957A82DC,
	0x3FDF1A9F,0xBE76C8B4, 0xBFE716E9,0x02C3A4A9,
	0x3FDF2B02,0x0C49BA5E, 0xBFE70612,0x510B3181,
	0x3FDF3B64,0x5A1CAC08, 0xBFE6F544,0x76FDEECE,
	0x3FDF4BC6,0xA7EF9DB2, 0xBFE6E47F,0x6B574B15,
	0x3FDF5C28,0xF5C28F5C, 0xBFE6D3C3,0x24E13F4F,
	0x3FDF6C8B,0x43958106, 0xBFE6C30F,0x9A743088,
	0x3FDF7CED,0x916872B0, 0xBFE6B264,0xC2F6D1D8,
	0x3FDF8D4F,0xDF3B645A, 0xBFE6A1C2,0x955E06A0,
	0x3FDF9DB2,0x2D0E5604, 0xBFE69129,0x08ACC51D,
	0x3FDFAE14,0x7AE147AE, 0xBFE68098,0x13F3F942,
	0x3FDFBE76,0xC8B43958, 0xBFE6700F,0xAE5267DE,
	0x3FDFCED9,0x16872B02, 0xBFE65F8F,0xCEF4920C,
	0x3FDFDF3B,0x645A1CAC, 0xBFE64F18,0x6D1498F1,
	0x3FDFEF9D,0xB22D0E56, 0xBFE63EA9,0x7FFA21BB,
	0x3FE00000,0x00000000, 0xBFE62E42,0xFEFA39EF,
	0x3FE00831,0x26E978D5, 0xBFE61DE4,0xE1773BF8,
	0x3FE01062,0x4DD2F1AA, 0xBFE60D8F,0x1EE0B3FF,
	0x3FE01893,0x74BC6A7F, 0xBFE5FD41,0xAEB3450A,
	0x3FE020C4,0x9BA5E354, 0xBFE5ECFC,0x88788E5B,
	0x3FE028F5,0xC28F5C29, 0xBFE5DCBF,0xA3C71115,
	0x3FE03126,0xE978D4FE, 0xBFE5CC8A,0xF8421624,
	0x3FE03958,0x10624DD3, 0xBFE5BC5E,0x7D999465,
	0x3FE04189,0x374BC6A8, 0xBFE5AC3A,0x2B8A1713,
	0x3FE049BA,0x5E353F7D, 0xBFE59C1D,0xF9DCA470,
	0x3FE051EB,0x851EB852, 0xBFE58C09,0xE066A4B0,
	0x3FE05A1C,0xAC083127, 0xBFE57BFD,0xD709C922,
	0x3FE0624D,0xD2F1A9FC, 0xBFE56BF9,0xD5B3F399,
	0x3FE06A7E,0xF9DB22D1, 0xBFE55BFD,0xD45F1E11,
	0x3FE072B0,0x20C49BA6, 0xBFE54C09,0xCB11428D,
	0x3FE07AE1,0x47AE147B, 0xBFE53C1D,0xB1DC433C,
	0x3FE08312,0x6E978D50, 0xBFE52C39,0x80DDD2CA,
	0x3FE08B43,0x95810625, 0xBFE51C5D,0x303F5CFA,
	0x3FE09374,0xBC6A7EFA, 0xBFE50C88,0xB835EF6F,
	0x3FE09BA5,0xE353F7CF, 0xBFE4FCBC,0x110222B8,
	0x3FE0A3D7,0x0A3D70A4, 0xBFE4ECF7,0x32F00389,
	0x3FE0AC08,0x3126E979, 0xBFE4DD3A,0x1656FC3A,
	0x3FE0B439,0x5810624E, 0xBFE4CD84,0xB399BE6D,
	0x3FE0BC6A,0x7EF9DB23, 0xBFE4BDD7,0x03262CFD,
	0x3FE0C49B,0xA5E353F8, 0xBFE4AE30,0xFD754610,
	0x3FE0CCCC,0xCCCCCCCD, 0xBFE49E92,0x9B0B0D70,
	0x3FE0D4FD,0xF3B645A2, 0xBFE48EFB,0xD476770C,
	0x3FE0DD2F,0x1A9FBE77, 0xBFE47F6C,0xA25151B3,
	0x3FE0E560,0x4189374C, 0xBFE46FE4,0xFD403201,
	0x3FE0ED91,0x6872B021, 0xBFE46064,0xDDF25D81,
	0x3FE0F5C2,0x8F5C28F6, 0xBFE450EC,0x3D21B601,
	0x3FE0FDF3,0xB645A1CB, 0xBFE4417B,0x1392A512,
	0x3FE10624,0xDD2F1AA0, 0xBFE43211,0x5A1407C3,
	0x3FE10E56,0x04189375, 0xBFE422AF,0x097F1A87,
	0x3FE11687,0x2B020C4A, 0xBFE41354,0x1AB7654B,
	0x3FE11EB8,0x51EB851F, 0xBFE40400,0x86AAA7BF,
	0x3FE126E9,0x78D4FDF4, 0xBFE3F4B4,0x4650C5C9,
	0x3FE12F1A,0x9FBE76C9, 0xBFE3E56F,0x52ABB42C,
	0x3FE1374B,0xC6A7EF9E, 0xBFE3D631,0xA4C7655A,
	0x3FE13F7C,0xED916873, 0xBFE3C6FB,0x35B9B675,
	0x3FE147AE,0x147AE148, 0xBFE3B7CB,0xFEA25C7D,
	0x3FE14FDF,0x3B645A1D, 0xBFE3A8A3,0xF8AAD1A6,
	0x3FE15810,0x624DD2F2, 0xBFE39983,0x1D0642E4,
	0x3FE16041,0x89374BC7, 0xBFE38A69,0x64F17D97,
	0x3FE16872,0xB020C49C, 0xBFE37B56,0xC9B2DD6E,
	0x3FE170A3,0xD70A3D71, 0xBFE36C4B,0x449A3A68,
	0x3FE178D4,0xFDF3B646, 0xBFE35D46,0xCF00D70A,
	0x3FE18106,0x24DD2F1B, 0xBFE34E49,0x62494EB9,
	0x3FE18937,0x4BC6A7F0, 0xBFE33F52,0xF7DF843C,
	0x3FE19168,0x72B020C5, 0xBFE33063,0x89389070,
	0x3FE19999,0x9999999A, 0xBFE3217B,0x0FD2B116,
	0x3FE1A1CA,0xC083126F, 0xBFE31299,0x853537D5,
	0x3FE1A9FB,0xE76C8B44, 0xBFE303BE,0xE2F0795E,
	0x3FE1B22D,0x0E560419, 0xBFE2F4EB,0x229DBCBB,
	0x3FE1BA5E,0x353F7CEE, 0xBFE2E61E,0x3DDF2ABA,
	0x3FE1C28F,0x5C28F5C3, 0xBFE2D758,0x2E5FBD90,
	0x3FE1CAC0,0x83126E98, 0xBFE2C898,0xEDD33091,
	0x3FE1D2F1,0xA9FBE76D, 0xBFE2B9E0,0x75F5F013,
	0x3FE1DB22,0xD0E56042, 0xBFE2AB2E,0xC08D0980,
	0x3FE1E353,0xF7CED917, 0xBFE29C83,0xC7661B79,
	0x3FE1EB85,0x1EB851EC, 0xBFE28DDF,0x8457462F,
	0x3FE1F3B6,0x45A1CAC1, 0xBFE27F41,0xF13F1BD6,
	0x3FE1FBE7,0x6C8B4396, 0xBFE270AB,0x0804913F,
	0x3FE20418,0x9374BC6A, 0xBFE2621A,0xC296EE95,
	0x3FE20C49,0xBA5E353F, 0xBFE25391,0x1AEDC036,
	0x3FE2147A,0xE147AE14, 0xBFE2450E,0x0B08C7BE,
	0x3FE21CAC,0x083126E9, 0xBFE23691,0x8CEFED24,
	0x3FE224DD,0x2F1A9FBE, 0xBFE2281B,0x9AB33000,
	0x3FE22D0E,0x56041893, 0xBFE219AC,0x2E6A98EE,
	0x3FE2353F,0x7CED9168, 0xBFE20B43,0x42362B1A,
	0x3FE23D70,0xA3D70A3D, 0xBFE1FCE0,0xD03DD5E6,
	0x3FE245A1,0xCAC08312, 0xBFE1EE84,0xD2B166AD,
	0x3FE24DD2,0xF1A9FBE7, 0xBFE1E02F,0x43C87AB2,
	0x3FE25604,0x189374BC, 0xBFE1D1E0,0x1DC2711E,
	0x3FE25E35,0x3F7CED91, 0xBFE1C397,0x5AE65D2E,
	0x3FE26666,0x66666666, 0xBFE1B554,0xF582F875,
	0x3FE26E97,0x8D4FDF3B, 0xBFE1A718,0xE7EE953D,
	0x3FE276C8,0xB4395810, 0xBFE198E3,0x2C87110D,
	0x3FE27EF9,0xDB22D0E5, 0xBFE18AB3,0xBDB1C745,
	0x3FE2872B,0x020C49BA, 0xBFE17C8A,0x95DB83DE,
	0x3FE28F5C,0x28F5C28F, 0xBFE16E67,0xAF787643,
	0x3FE2978D,0x4FDF3B64, 0xBFE1604B,0x05042447,
	0x3FE29FBE,0x76C8B439, 0xBFE15234,0x91015D3E,
	0x3FE2A7EF,0x9DB22D0E, 0xBFE14424,0x4DFA2D29,
	0x3FE2B020,0xC49BA5E3, 0xBFE1361A,0x367FD003,
	0x3FE2B851,0xEB851EB8, 0xBFE12816,0x452AA52E,
	0x3FE2C083,0x126E978D, 0xBFE11A18,0x749A22EF,
	0x3FE2C8B4,0x39581062, 0xBFE10C20,0xBF74CA16,
	0x3FE2D0E5,0x60418937, 0xBFE0FE2F,0x206819B2,
	0x3FE2D916,0x872B020C, 0xBFE0F043,0x922882E9,
	0x3FE2E147,0xAE147AE1, 0xBFE0E25E,0x0F715CE7,
	0x3FE2E978,0xD4FDF3B6, 0xBFE0D47E,0x9304D8E5,
	0x3FE2F1A9,0xFBE76C8B, 0xBFE0C6A5,0x17ABF651,
	0x3FE2F9DB,0x22D0E560, 0xBFE0B8D1,0x98367706,
	0x3FE3020C,0x49BA5E35, 0xBFE0AB04,0x0F7AD3A5,
	0x3FE30A3D,0x70A3D70A, 0xBFE09D3C,0x78563006,
	0x3FE3126E,0x978D4FDF, 0xBFE08F7A,0xCDAC4FBD,
	0x3FE31A9F,0xBE76C8B4, 0xBFE081BF,0x0A678ABC,
	0x3FE322D0,0xE5604189, 0xBFE07409,0x2978C20F,
	0x3FE32B02,0x0C49BA5E, 0xBFE06659,0x25D754AA,
	0x3FE33333,0x33333333, 0xBFE058AE,0xFA811452,
	0x3FE33B64,0x5A1CAC08, 0xBFE04B0A,0xA27A3AA2,
	0x3FE34395,0x810624DD, 0xBFE03D6C,0x18CD5E20,
	0x3FE34BC6,0xA7EF9DB2, 0xBFE02FD3,0x588B676D,
	0x3FE353F7,0xCED91687, 0xBFE02240,0x5CCB868C,
	0x3FE35C28,0xF5C28F5C, 0xBFE014B3,0x20AB283E,
	0x3FE3645A,0x1CAC0831, 0xBFE0072B,0x9F4DEB78,
	0x3FE36C8B,0x43958106, 0xBFDFF353,0xA7BB2DD6,
	0x3FE374BC,0x6A7EF9DB, 0xBFDFD85B,0x73141D49,
	0x3FE37CED,0x916872B0, 0xBFDFBD6E,0x97129387,
	0x3FE3851E,0xB851EB85, 0xBFDFA28D,0x0A2E908A,
	0x3FE38D4F,0xDF3B645A, 0xBFDF87B6,0xC2EC11CA,
	0x3FE39581,0x0624DD2F, 0xBFDF6CEB,0xB7DAFE25,
	0x3FE39DB2,0x2D0E5604, 0xBFDF522B,0xDF9711F8,
	0x3FE3A5E3,0x53F7CED9, 0xBFDF3777,0x30C7CB60,
	0x3FE3AE14,0x7AE147AE, 0xBFDF1CCD,0xA220569F,
	0x3FE3B645,0xA1CAC083, 0xBFDF022F,0x2A5F7AAE,
	0x3FE3BE76,0xC8B43958, 0xBFDEE79B,0xC04F85F9,
	0x3FE3C6A7,0xEF9DB22D, 0xBFDECD13,0x5AC63B3D,
	0x3FE3CED9,0x16872B02, 0xBFDEB295,0xF0A4BE96,
	0x3FE3D70A,0x3D70A3D7, 0xBFDE9823,0x78D782AA,
	0x3FE3DF3B,0x645A1CAC, 0xBFDE7DBB,0xEA563605,
	0x3FE3E76C,0x8B439581, 0xBFDE635F,0x3C23B092,
	0x3FE3EF9D,0xB22D0E56, 0xBFDE490D,0x654DE143,
	0x3FE3F7CE,0xD916872B, 0xBFDE2EC6,0x5CEDBBD8,
	0x3FE40000,0x00000000, 0xBFDE148A,0x1A2726CE,
	0x3FE40831,0x26E978D5, 0xBFDDFA58,0x9428E971,
	0x3FE41062,0x4DD2F1AA, 0xBFDDE031,0xC22C9A19,
	0x3FE41893,0x74BC6A7F, 0xBFDDC615,0x9B768C81,
	0x3FE420C4,0x9BA5E354, 0xBFDDAC04,0x1755C04C,
	0x3FE428F5,0xC28F5C29, 0xBFDD91FD,0x2D23CFA6,
	0x3FE43126,0xE978D4FE, 0xBFDD7800,0xD444DE0D,
	0x3FE43958,0x10624DD3, 0xBFDD5E0F,0x04278739,
	0x3FE44189,0x374BC6A8, 0xBFDD4427,0xB444CE2C,
	0x3FE449BA,0x5E353F7D, 0xBFDD2A4A,0xDC200C60,
	0x3FE451EB,0x851EB852, 0xBFDD1078,0x7346E115,
	0x3FE45A1C,0xAC083127, 0xBFDCF6B0,0x715120C7,
	0x3FE4624D,0xD2F1A9FC, 0xBFDCDCF2,0xCDE0C4C1,
	0x3FE46A7E,0xF9DB22D1, 0xBFDCC33F,0x80A1DAD2,
	0x3FE472B0,0x20C49BA6, 0xBFDCA996,0x814A7520,
	0x3FE47AE1,0x47AE147B, 0xBFDC8FF7,0xC79A9A21,
	0x3FE48312,0x6E978D50, 0xBFDC7663,0x4B5C34B1,
	0x3FE48B43,0x95810625, 0xBFDC5CD9,0x04630444,
	0x3FE49374,0xBC6A7EFA, 0xBFDC4358,0xEA8C8D3F,
	0x3FE49BA5,0xE353F7CF, 0xBFDC29E2,0xF5C00969,
	0x3FE4A3D7,0x0A3D70A4, 0xBFDC1077,0x1DEE5883,
	0x3FE4AC08,0x3126E979, 0xBFDBF715,0x5B11F0F3,
	0x3FE4B439,0x5810624E, 0xBFDBDDBD,0xA52ED09A,
	0x3FE4BC6A,0x7EF9DB23, 0xBFDBC46F,0xF4526DBF,
	0x3FE4C49B,0xA5E353F8, 0xBFDBAB2C,0x4093A81B,
	0x3FE4CCCC,0xCCCCCCCD, 0xBFDB91F2,0x8212BA02,
	0x3FE4D4FD,0xF3B645A2, 0xBFDB78C2,0xB0F929AC,
	0x3FE4DD2F,0x1A9FBE77, 0xBFDB5F9C,0xC579BA97,
	0x3FE4E560,0x4189374C, 0xBFDB4680,0xB7D05F03,
	0x3FE4ED91,0x6872B021, 0xBFDB2D6E,0x80422996,
	0x3FE4F5C2,0x8F5C28F6, 0xBFDB1466,0x171D3F0F,
	0x3FE4FDF3,0xB645A1CB, 0xBFDAFB67,0x74B8C81C,
	0x3FE50624,0xDD2F1AA0, 0xBFDAE272,0x9174E34C,
	0x3FE50E56,0x04189375, 0xBFDAC987,0x65BA9715,
	0x3FE51687,0x2B020C4A, 0xBFDAB0A5,0xE9FBC402,
	0x3FE51EB8,0x51EB851F, 0xBFDA97CE,0x16B316F1,
	0x3FE526E9,0x78D4FDF4, 0xBFDA7EFF,0xE463FB6C,
	0x3FE52F1A,0x9FBE76C9, 0xBFDA663B,0x4B9A8E25,
	0x3FE5374B,0xC6A7EF9E, 0xBFDA4D80,0x44EB8F83,
	0x3FE53F7C,0xED916873, 0xBFDA34CE,0xC8F4564E,
	0x3FE547AE,0x147AE148, 0xBFDA1C26,0xD05AC275,
	0x3FE54FDF,0x3B645A1D, 0xBFDA0388,0x53CD2FE6,
	0x3FE55810,0x624DD2F2, 0xBFD9EAF3,0x4C02698D,
	0x3FE56041,0x89374BC7, 0xBFD9D267,0xB1B99C5C,
	0x3FE56872,0xB020C49C, 0xBFD9B9E5,0x7DBA4A7A,
	0x3FE570A3,0xD70A3D71, 0xBFD9A16C,0xA8D43E81,
	0x3FE578D4,0xFDF3B646, 0xBFD988FD,0x2BDF7ED7,
	0x3FE58106,0x24DD2F1B, 0xBFD97096,0xFFBC4123,
	0x3FE58937,0x4BC6A7F0, 0xBFD9583A,0x1D52DDD4,
	0x3FE59168,0x72B020C5, 0xBFD93FE6,0x7D93C3C2,
	0x3FE59999,0x9999999A, 0xBFD9279C,0x19776BE9,
	0x3FE5A1CA,0xC083126F, 0xBFD90F5A,0xE9FE4D36,
	0x3FE5A9FB,0xE76C8B44, 0xBFD8F722,0xE830D073,
	0x3FE5B22D,0x0E560419, 0xBFD8DEF4,0x0D1F443F,
	0x3FE5BA5E,0x353F7CEE, 0xBFD8C6CE,0x51E1D126,
	0x3FE5C28F,0x5C28F5C3, 0xBFD8AEB1,0xAF986DCC,
	0x3FE5CAC0,0x83126E98, 0xBFD8969E,0x1F6AD32D,
	0x3FE5D2F1,0xA9FBE76D, 0xBFD87E93,0x9A8870F7,
	0x3FE5DB22,0xD0E56042, 0xBFD86692,0x1A2861F4,
	0x3FE5E353,0xF7CED917, 0xBFD84E99,0x9789608E,
	0x3FE5EB85,0x1EB851EC, 0xBFD836AA,0x0BF1BB68,
	0x3FE5F3B6,0x45A1CAC1, 0xBFD81EC3,0x70AF4A0C,
	0x3FE5FBE7,0x6C8B4396, 0xBFD806E5,0xBF1761AE,
	0x3FE60418,0x9374BC6A, 0xBFD7EF10,0xF086CA03,
	0x3FE60C49,0xBA5E353F, 0xBFD7D744,0xFE61B228,
	0x3FE6147A,0xE147AE14, 0xBFD7BF81,0xE213A5AF,
	0x3FE61CAC,0x083126E9, 0xBFD7A7C7,0x950F81AC,
	0x3FE624DD,0x2F1A9FBE, 0xBFD79016,0x10CF69DF,
	0x3FE62D0E,0x56041893, 0xBFD7786D,0x4ED4BDF6,
	0x3FE6353F,0x7CED9168, 0xBFD760CD,0x48A80ED9,
	0x3FE63D70,0xA3D70A3D, 0xBFD74935,0xF7D91413,
	0x3FE645A1,0xCAC08312, 0xBFD731A7,0x55FEA14A,
	0x3FE64DD2,0xF1A9FBE7, 0xBFD71A21,0x5CB69BCA,
	0x3FE65604,0x189374BC, 0xBFD702A4,0x05A5F024,
	0x3FE65E35,0x3F7CED91, 0xBFD6EB2F,0x4A7887E4,
	0x3FE66666,0x66666666, 0xBFD6D3C3,0x24E13F50,
	0x3FE66E97,0x8D4FDF3B, 0xBFD6BC5F,0x8E99DB45,
	0x3FE676C8,0xB4395810, 0xBFD6A504,0x8162FF20,
	0x3FE67EF9,0xDB22D0E5, 0xBFD68DB1,0xF70422B8,
	0x3FE6872B,0x020C49BA, 0xBFD67667,0xE94B8871,
	0x3FE68F5C,0x28F5C28F, 0xBFD65F26,0x520E335A,
	0x3FE6978D,0x4FDF3B64, 0xBFD647ED,0x2B27DD63,
	0x3FE69FBE,0x76C8B439, 0xBFD630BC,0x6E7AED9C,
	0x3FE6A7EF,0x9DB22D0E, 0xBFD61994,0x15F06E93,
	0x3FE6B020,0xC49BA5E3, 0xBFD60274,0x1B7804B4,
	0x3FE6B851,0xEB851EB8, 0xBFD5EB5C,0x7907E4CA,
	0x3FE6C083,0x126E978D, 0xBFD5D44D,0x289CCA80,
	0x3FE6C8B4,0x39581062, 0xBFD5BD46,0x2439EF06,
	0x3FE6D0E5,0x60418937, 0xBFD5A647,0x65E8FFB5,
	0x3FE6D916,0x872B020C, 0xBFD58F50,0xE7BA14D1,
	0x3FE6E147,0xAE147AE1, 0xBFD57862,0xA3C3A852,
	0x3FE6E978,0xD4FDF3B6, 0xBFD5617C,0x94228CC7,
	0x3FE6F1A9,0xFBE76C8B, 0xBFD54A9E,0xB2F9E441,
	0x3FE6F9DB,0x22D0E560, 0xBFD533C8,0xFA731752,
	0x3FE7020C,0x49BA5E35, 0xBFD51CFB,0x64BDCC1A,
	0x3FE70A3D,0x70A3D70A, 0xBFD50635,0xEC0FDD69,
	0x3FE7126E,0x978D4FDF, 0xBFD4EF78,0x8AA551E9,
	0x3FE71A9F,0xBE76C8B4, 0xBFD4D8C3,0x3AC0535F,
	0x3FE722D0,0xE5604189, 0xBFD4C215,0xF6A925F7,
	0x3FE72B02,0x0C49BA5E, 0xBFD4AB70,0xB8AE1F9E,
	0x3FE73333,0x33333333, 0xBFD494D3,0x7B239F74,
	0x3FE73B64,0x5A1CAC08, 0xBFD47E3E,0x38640541,
	0x3FE74395,0x810624DD, 0xBFD467B0,0xEACFA902,
	0x3FE74BC6,0xA7EF9DB2, 0xBFD4512B,0x8CCCD284,
	0x3FE753F7,0xCED91687, 0xBFD43AAE,0x18C7B107,
	0x3FE75C28,0xF5C28F5C, 0xBFD42438,0x893252F5,
	0x3FE7645A,0x1CAC0831, 0xBFD40DCA,0xD8849DAE,
	0x3FE76C8B,0x43958106, 0xBFD3F765,0x013C454F,
	0x3FE774BC,0x6A7EF9DB, 0xBFD3E106,0xFDDCC4A1,
	0x3FE77CED,0x916872B0, 0xBFD3CAB0,0xC8EF54FD,
	0x3FE7851E,0xB851EB85, 0xBFD3B462,0x5D02E652,
	0x3FE78D4F,0xDF3B645A, 0xBFD39E1B,0xB4AC172C,
	0x3FE79581,0x0624DD2F, 0xBFD387DC,0xCA852CD1,
	0x3FE79DB2,0x2D0E5604, 0xBFD371A5,0x992E0B64,
	0x3FE7A5E3,0x53F7CED9, 0xBFD35B76,0x1B4C2E1F,
	0x3FE7AE14,0x7AE147AE, 0xBFD3454E,0x4B8A9F90,
	0x3FE7B645,0xA1CAC083, 0xBFD32F2E,0x2499F1EF,
	0x3FE7BE76,0xC8B43958, 0xBFD31915,0xA1303773,
	0x3FE7C6A7,0xEF9DB22D, 0xBFD30304,0xBC08FAC5,
	0x3FE7CED9,0x16872B02, 0xBFD2ECFB,0x6FE5376F,
	0x3FE7D70A,0x3D70A3D7, 0xBFD2D6F9,0xB78B5268,
	0x3FE7DF3B,0x645A1CAC, 0xBFD2C0FF,0x8DC7129D,
	0x3FE7E76C,0x8B439581, 0xBFD2AB0C,0xED699996,
	0x3FE7EF9D,0xB22D0E56, 0xBFD29521,0xD1495C1B,
	0x3FE7F7CE,0xD916872B, 0xBFD27F3E,0x34421AF0,
	0x3FE80000,0x00000000, 0xBFD26962,0x1134DB92,
	0x3FE80831,0x26E978D5, 0xBFD2538D,0x6307E10F,
	0x3FE81062,0x4DD2F1AA, 0xBFD23DC0,0x24A6A4D8,
	0x3FE81893,0x74BC6A7F, 0xBFD227FA,0x5101CFB3,
	0x3FE820C4,0x9BA5E354, 0xBFD2123B,0xE30F32A8,
	0x3FE828F5,0xC28F5C29, 0xBFD1FC84,0xD5C9C006,
	0x3FE83126,0xE978D4FE, 0xBFD1E6D5,0x2431846B,
	0x3FE83958,0x10624DD3, 0xBFD1D12C,0xC94B9FDF,
	0x3FE84189,0x374BC6A8, 0xBFD1BB8B,0xC0223EF5,
	0x3FE849BA,0x5E353F7D, 0xBFD1A5F2,0x03C493FC,
	0x3FE851EB,0x851EB852, 0xBFD1905F,0x8F46D038,
	0x3FE85A1C,0xAC083127, 0xBFD17AD4,0x5DC21D28,
	0x3FE8624D,0xD2F1A9FC, 0xBFD16550,0x6A5495DA,
	0x3FE86A7E,0xF9DB22D1, 0xBFD14FD3,0xB0214042,
	0x3FE872B0,0x20C49BA6, 0xBFD13A5E,0x2A5006A7,
	0x3FE87AE1,0x47AE147B, 0xBFD124EF,0xD40DB113,
	0x3FE88312,0x6E978D50, 0xBFD10F88,0xA88BDED0,
	0x3FE88B43,0x95810625, 0xBFD0FA28,0xA300FFF1,
	0x3FE89374,0xBC6A7EFA, 0xBFD0E4CF,0xBEA84EE6,
	0x3FE89BA5,0xE353F7CF, 0xBFD0CF7D,0xF6C1CA1B,
	0x3FE8A3D7,0x0A3D70A4, 0xBFD0BA33,0x46922D9D,
	0x3FE8AC08,0x3126E979, 0xBFD0A4EF,0xA962ECCF,
	0x3FE8B439,0x5810624E, 0xBFD08FB3,0x1A822C28,
	0x3FE8BC6A,0x7EF9DB23, 0xBFD07A7D,0x9542BAFB,
	0x3FE8C49B,0xA5E353F8, 0xBFD0654F,0x14FC0D48,
	0x3FE8CCCC,0xCCCCCCCD, 0xBFD05027,0x950A3599,
	0x3FE8D4FD,0xF3B645A2, 0xBFD03B07,0x10CDDEE8,
	0x3FE8DD2F,0x1A9FBE77, 0xBFD025ED,0x83AC4692,
	0x3FE8E560,0x4189374C, 0xBFD010DA,0xE90F364E,
	0x3FE8ED91,0x6872B021, 0xBFCFF79E,0x78C9FC65,
	0x3FE8F5C2,0x8F5C28F6, 0xBFCFCD94,0xF240DD8E,
	0x3FE8FDF3,0xB645A1CB, 0xBFCFA399,0x3571A62D,
	0x3FE90624,0xDD2F1AA0, 0xBFCF79AB,0x3953D5AD,
	0x3FE90E56,0x04189375, 0xBFCF4FCA,0xF4E7C91D,
	0x3FE91687,0x2B020C4A, 0xBFCF25F8,0x5F36AF9F,
	0x3FE91EB8,0x51EB851F, 0xBFCEFC33,0x6F527EDF,
	0x3FE926E9,0x78D4FDF4, 0xBFCED27C,0x1C55E7A8,
	0x3FE92F1A,0x9FBE76C9, 0xBFCEA8D2,0x5D644A84,
	0x3FE9374B,0xC6A7EF9E, 0xBFCE7F36,0x29A9AC6D,
	0x3FE93F7C,0xED916873, 0xBFCE55A7,0x785AAB99,
	0x3FE947AE,0x147AE148, 0xBFCE2C26,0x40B4744F,
	0x3FE94FDF,0x3B645A1D, 0xBFCE02B2,0x79FCB5D5,
	0x3FE95810,0x624DD2F2, 0xBFCDD94C,0x1B81976B,
	0x3FE96041,0x89374BC7, 0xBFCDAFF3,0x1C99AD5B,
	0x3FE96872,0xB020C49C, 0xBFCD86A7,0x74A3EE16,
	0x3FE970A3,0xD70A3D71, 0xBFCD5D69,0x1B07A76B,
	0x3FE978D4,0xFDF3B646, 0xBFCD3438,0x073473C8,
	0x3FE98106,0x24DD2F1B, 0xBFCD0B14,0x30A22F8D,
	0x3FE98937,0x4BC6A7F0, 0xBFCCE1FD,0x8ED0EE73,
	0x3FE99168,0x72B020C5, 0xBFCCB8F4,0x1948F104,
	0x3FE99999,0x9999999A, 0xBFCC8FF7,0xC79A9A20,
	0x3FE9A1CA,0xC083126F, 0xBFCC6708,0x915E6496,
	0x3FE9A9FB,0xE76C8B44, 0xBFCC3E26,0x6E34D8CF,
	0x3FE9B22D,0x0E560419, 0xBFCC1551,0x55C68285,
	0x3FE9BA5E,0x353F7CEE, 0xBFCBEC89,0x3FC3E68C,
	0x3FE9C28F,0x5C28F5C3, 0xBFCBC3CE,0x23E578B0,
	0x3FE9CAC0,0x83126E98, 0xBFCB9B1F,0xF9EB919B,
	0x3FE9D2F1,0xA9FBE76D, 0xBFCB727E,0xB99E64D0,
	0x3FE9DB22,0xD0E56042, 0xBFCB49EA,0x5ACDF6B8,
	0x3FE9E353,0xF7CED917, 0xBFCB2162,0xD55212B8,
	0x3FE9EB85,0x1EB851EC, 0xBFCAF8E8,0x210A415B,
	0x3FE9F3B6,0x45A1CAC1, 0xBFCAD07A,0x35DDBE8E,
	0x3FE9FBE7,0x6C8B4396, 0xBFCAA819,0x0BBB6FE6,
	0x3FEA0418,0x9374BC6A, 0xBFCA7FC4,0x9A99DAFB,
	0x3FEA0C49,0xBA5E353F, 0xBFCA577C,0xDA771BBF,
	0x3FEA147A,0xE147AE14, 0xBFCA2F41,0xC358DB0F,
	0x3FEA1CAC,0x083126E9, 0xBFCA0713,0x4D4C4526,
	0x3FEA24DD,0x2F1A9FBE, 0xBFC9DEF1,0x70660032,
	0x3FEA2D0E,0x56041893, 0xBFC9B6DC,0x24C222FD,
	0x3FEA353F,0x7CED9168, 0xBFC98ED3,0x62842B97,
	0x3FEA3D70,0xA3D70A3D, 0xBFC966D7,0x21D6F61B,
	0x3FEA45A1,0xCAC08312, 0xBFC93EE7,0x5AECB37C,
	0x3FEA4DD2,0xF1A9FBE7, 0xBFC91704,0x05FEE05F,
	0x3FEA5604,0x189374BC, 0xBFC8EF2D,0x1B4E3C09,
	0x3FEA5E35,0x3F7CED91, 0xBFC8C762,0x9322BF57,
	0x3FEA6666,0x66666666, 0xBFC89FA4,0x65CB93C4,
	0x3FEA6E97,0x8D4FDF3B, 0xBFC877F2,0x8B9F0A7C,
	0x3FEA76C8,0xB4395810, 0xBFC8504C,0xFCFA9385,
	0x3FEA7EF9,0xDB22D0E5, 0xBFC828B3,0xB242B4E7,
	0x3FEA872B,0x020C49BA, 0xBFC80126,0xA3E301F0,
	0x3FEA8F5C,0x28F5C28F, 0xBFC7D9A5,0xCA4E127E,
	0x3FEA978D,0x4FDF3B64, 0xBFC7B231,0x1DFD7A57,
	0x3FEA9FBE,0x76C8B439, 0xBFC78AC8,0x9771C08D,
	0x3FEAA7EF,0x9DB22D0E, 0xBFC7636C,0x2F3256F8,
	0x3FEAB020,0xC49BA5E3, 0xBFC73C1B,0xDDCD91AF,
	0x3FEAB851,0xEB851EB8, 0xBFC714D7,0x9BD89E9B,
	0x3FEAC083,0x126E978D, 0xBFC6ED9F,0x61EF7D0E,
	0x3FEAC8B4,0x39581062, 0xBFC6C673,0x28B4F56D,
	0x3FEAD0E5,0x60418937, 0xBFC69F52,0xE8D290E2,
	0x3FEAD916,0x872B020C, 0xBFC6783E,0x9AF8911F,
	0x3FEAE147,0xAE147AE1, 0xBFC65136,0x37DDE829,
	0x3FEAE978,0xD4FDF3B6, 0xBFC62A39,0xB8403032,
	0x3FEAF1A9,0xFBE76C8B, 0xBFC60349,0x14E3A383,
	0x3FEAF9DB,0x22D0E560, 0xBFC5DC64,0x46931468,
	0x3FEB020C,0x49BA5E35, 0xBFC5B58B,0x461FE536,
	0x3FEB0A3D,0x70A3D70A, 0xBFC58EBE,0x0C62004F,
	0x3FEB126E,0x978D4FDF, 0xBFC567FC,0x9237D03E,
	0x3FEB1A9F,0xBE76C8B4, 0xBFC54146,0xD08637D8,
	0x3FEB22D0,0xE5604189, 0xBFC51A9C,0xC0388A6B,
	0x3FEB2B02,0x0C49BA5E, 0xBFC4F3FE,0x5A4083F8,
	0x3FEB3333,0x33333333, 0xBFC4CD6B,0x97964179,
	0x3FEB3B64,0x5A1CAC08, 0xBFC4A6E4,0x71383935,
	0x3FEB4395,0x810624DD, 0xBFC48068,0xE02B331C,
	0x3FEB4BC6,0xA7EF9DB2, 0xBFC459F8,0xDD7A412F,
	0x3FEB53F7,0xCED91687, 0xBFC43394,0x6236B7F6,
	0x3FEB5C28,0xF5C28F5C, 0xBFC40D3B,0x677826FD,
	0x3FEB645A,0x1CAC0831, 0xBFC3E6ED,0xE65C5165,
	0x3FEB6C8B,0x43958106, 0xBFC3C0AB,0xD8072670,
	0x3FEB74BC,0x6A7EF9DB, 0xBFC39A75,0x35A2BA2C,
	0x3FEB7CED,0x916872B0, 0xBFC37449,0xF85F3E1A,
	0x3FEB851E,0xB851EB85, 0xBFC34E2A,0x1972F9E3,
	0x3FEB8D4F,0xDF3B645A, 0xBFC32815,0x921A441F,
	0x3FEB9581,0x0624DD2F, 0xBFC3020C,0x5B977B1E,
	0x3FEB9DB2,0x2D0E5604, 0xBFC2DC0E,0x6F32FDC2,
	0x3FEBA5E3,0x53F7CED9, 0xBFC2B61B,0xC63B245B,
	0x3FEBAE14,0x7AE147AE, 0xBFC29034,0x5A04399A,
	0x3FEBB645,0xA1CAC083, 0xBFC26A58,0x23E87386,
	0x3FEBBE76,0xC8B43958, 0xBFC24487,0x1D47EC7A,
	0x3FEBC6A7,0xEF9DB22D, 0xBFC21EC1,0x3F889C35,
	0x3FEBCED9,0x16872B02, 0xBFC1F906,0x841650ED,
	0x3FEBD70A,0x3D70A3D7, 0xBFC1D356,0xE462A870,
	0x3FEBDF3B,0x645A1CAC, 0xBFC1ADB2,0x59E5094D,
	0x3FEBE76C,0x8B439581, 0xBFC18818,0xDE1A9C09,
	0x3FEBEF9D,0xB22D0E56, 0xBFC1628A,0x6A86445F,
	0x3FEBF7CE,0xD916872B, 0xBFC13D06,0xF8B09A84,
	0x3FEC0000,0x00000000, 0xBFC1178E,0x8227E47C,
	0x3FEC0831,0x26E978D5, 0xBFC0F221,0x00800F74,
	0x3FEC1062,0x4DD2F1AA, 0xBFC0CCBE,0x6D52A928,
	0x3FEC1893,0x74BC6A7F, 0xBFC0A766,0xC23ED951,
	0x3FEC20C4,0x9BA5E354, 0xBFC08219,0xF8E95B21,
	0x3FEC28F5,0xC28F5C29, 0xBFC05CD8,0x0AFC76BE,
	0x3FEC3126,0xE978D4FE, 0xBFC037A0,0xF227FAD6,
	0x3FEC3958,0x10624DD3, 0xBFC01274,0xA821362D,
	0x3FEC4189,0x374BC6A8, 0xBFBFDAA6,0x4D45E27B,
	0x3FEC49BA,0x5E353F7D, 0xBFBF9078,0xCEDACFC3,
	0x3FEC51EB,0x851EB852, 0xBFBF4660,0xC88C8603,
	0x3FEC5A1C,0xAC083127, 0xBFBEFC5E,0x2DF12499,
	0x3FEC624D,0xD2F1A9FC, 0xBFBEB270,0xF2A98BFD,
	0x3FEC6A7E,0xF9DB22D1, 0xBFBE6899,0x0A615153,
	0x3FEC72B0,0x20C49BA6, 0xBFBE1ED6,0x68CEB215,
	0x3FEC7AE1,0x47AE147B, 0xBFBDD529,0x01B287D1,
	0x3FEC8312,0x6E978D50, 0xBFBD8B90,0xC8D83BF3,
	0x3FEC8B43,0x95810625, 0xBFBD420D,0xB215BBA3,
	0x3FEC9374,0xBC6A7EFA, 0xBFBCF89F,0xB14B6BB6,
	0x3FEC9BA5,0xE353F7CF, 0xBFBCAF46,0xBA641CB0,
	0x3FECA3D7,0x0A3D70A4, 0xBFBC6602,0xC154FED4,
	0x3FECAC08,0x3126E979, 0xBFBC1CD3,0xBA1D9647,
	0x3FECB439,0x5810624E, 0xBFBBD3B9,0x98C7AF45,
	0x3FECBC6A,0x7EF9DB23, 0xBFBB8AB4,0x51675268,
	0x3FECC49B,0xA5E353F8, 0xBFBB41C3,0xD81AB8FA,
	0x3FECCCCC,0xCCCCCCCD, 0xBFBAF8E8,0x210A415C,
	0x3FECD4FD,0xF3B645A2, 0xBFBAB021,0x2068637F,
	0x3FECDD2F,0x1A9FBE77, 0xBFBA676E,0xCA71A569,
	0x3FECE560,0x4189374C, 0xBFBA1ED1,0x136C8FCE,
	0x3FECED91,0x6872B021, 0xBFB9D647,0xEFA9A2B4,
	0x3FECF5C2,0x8F5C28F6, 0xBFB98DD3,0x53834A30,
	0x3FECFDF3,0xB645A1CB, 0xBFB94573,0x335DD329,
	0x3FED0624,0xDD2F1AA0, 0xBFB8FD27,0x83A76031,
	0x3FED0E56,0x04189375, 0xBFB8B4F0,0x38D7DE6E,
	0x3FED1687,0x2B020C4A, 0xBFB86CCD,0x4770FA8C,
	0x3FED1EB8,0x51EB851F, 0xBFB824BE,0xA3FE15C9,
	0x3FED26E9,0x78D4FDF4, 0xBFB7DCC4,0x43143B07,
	0x3FED2F1A,0x9FBE76C9, 0xBFB794DE,0x195213F0,
	0x3FED374B,0xC6A7EF9E, 0xBFB74D0C,0x1B5FDE30,
	0x3FED3F7C,0xED916873, 0xBFB7054E,0x3DEF60B2,
	0x3FED47AE,0x147AE148, 0xBFB6BDA4,0x75BBE0F6,
	0x3FED4FDF,0x3B645A1D, 0xBFB6760E,0xB78A1871,
	0x3FED5810,0x624DD2F2, 0xBFB62E8C,0xF82829FF,
	0x3FED6041,0x89374BC7, 0xBFB5E71F,0x2C6D975E,
	0x3FED6872,0xB020C49C, 0xBFB59FC5,0x493B36C2,
	0x3FED70A3,0xD70A3D71, 0xBFB5587F,0x437B2869,
	0x3FED78D4,0xFDF3B646, 0xBFB5114D,0x1020CC4D,
	0x3FED8106,0x24DD2F1B, 0xBFB4CA2E,0xA428B7D9,
	0x3FED8937,0x4BC6A7F0, 0xBFB48323,0xF498ABB1,
	0x3FED9168,0x72B020C5, 0xBFB43C2C,0xF67F8985,
	0x3FED9999,0x9999999A, 0xBFB3F549,0x9EF549F9,
	0x3FEDA1CA,0xC083126F, 0xBFB3AE79,0xE31AF295,
	0x3FEDA9FB,0xE76C8B44, 0xBFB367BD,0xB81A8BC1,
	0x3FEDB22D,0x0E560419, 0xBFB32115,0x132716D5,
	0x3FEDBA5E,0x353F7CEE, 0xBFB2DA7F,0xE97C8435,
	0x3FEDC28F,0x5C28F5C3, 0xBFB293FE,0x305FA975,
	0x3FEDCAC0,0x83126E98, 0xBFB24D8F,0xDD1E3794,
	0x3FEDD2F1,0xA9FBE76D, 0xBFB20734,0xE50EB13D,
	0x3FEDDB22,0xD0E56042, 0xBFB1C0ED,0x3D906115,
	0x3FEDE353,0xF7CED917, 0xBFB17AB8,0xDC0B5020,
	0x3FEDEB85,0x1EB851EC, 0xBFB13497,0xB5F03C25,
	0x3FEDF3B6,0x45A1CAC1, 0xBFB0EE89,0xC0B88E2D,
	0x3FEDFBE7,0x6C8B4396, 0xBFB0A88E,0xF1E65102,
	0x3FEE0418,0x9374BC6A, 0xBFB062A7,0x3F0427CE,
	0x3FEE0C49,0xBA5E353F, 0xBFB01CD2,0x9DA54498,
	0x3FEE147A,0xE147AE14, 0xBFAFAE22,0x06CABE40,
	0x3FEE1CAC,0x083126E9, 0xBFAF22C4,0xCBD156F4,
	0x3FEE24DD,0x2F1A9FBE, 0xBFAE978D,0x75B7A1B0,
	0x3FEE2D0E,0x56041893, 0xBFAE0C7B,0xEFE7C0BD,
	0x3FEE353F,0x7CED9168, 0xBFAD8190,0x25DC9801,
	0x3FEE3D70,0xA3D70A3D, 0xBFACF6CA,0x0321BAD9,
	0x3FEE45A1,0xCAC08312, 0xBFAC6C29,0x73535A03,
	0x3FEE4DD2,0xF1A9FBE7, 0xBFABE1AE,0x621E31A5,
	0x3FEE5604,0x189374BC, 0xBFAB5758,0xBB3F7770,
	0x3FEE5E35,0x3F7CED91, 0xBFAACD28,0x6A84C8D0,
	0x3FEE6666,0x66666666, 0xBFAA431D,0x5BCC193E,
	0x3FEE6E97,0x8D4FDF3B, 0xBFA9B937,0x7B03A0A9,
	0x3FEE76C8,0xB4395810, 0xBFA92F76,0xB429C9F0,
	0x3FEE7EF9,0xDB22D0E5, 0xBFA8A5DA,0xF34D217A,
	0x3FEE872B,0x020C49BA, 0xBFA81C64,0x248C43E2,
	0x3FEE8F5C,0x28F5C28F, 0xBFA79312,0x3415CCBD,
	0x3FEE978D,0x4FDF3B64, 0xBFA709E5,0x0E284574,
	0x3FEE9FBE,0x76C8B439, 0xBFA680DC,0x9F121438,
	0x3FEEA7EF,0x9DB22D0E, 0xBFA5F7F8,0xD3316B08,
	0x3FEEB020,0xC49BA5E3, 0xBFA56F39,0x96F436D4,
	0x3FEEB851,0xEB851EB8, 0xBFA4E69E,0xD6D80EB3,
	0x3FEEC083,0x126E978D, 0xBFA45E28,0x7F6A232F,
	0x3FEEC8B4,0x39581062, 0xBFA3D5D6,0x7D472DA6,
	0x3FEED0E5,0x60418937, 0xBFA34DA8,0xBD1B5FC8,
	0x3FEED916,0x872B020C, 0xBFA2C59F,0x2BA25321,
	0x3FEEE147,0xAE147AE1, 0xBFA23DB9,0xB5A6F8C1,
	0x3FEEE978,0xD4FDF3B6, 0xBFA1B5F8,0x480388F4,
	0x3FEEF1A9,0xFBE76C8B, 0xBFA12E5A,0xCFA17314,
	0x3FEEF9DB,0x22D0E560, 0xBFA0A6E1,0x39794D70,
	0x3FEF020C,0x49BA5E35, 0xBFA01F8B,0x7292C543,
	0x3FEF0A3D,0x70A3D70A, 0xBF9F30B2,0xD0091D8A,
	0x3FEF126E,0x978D4FDF, 0xBF9E2296,0x0DE8AAA3,
	0x3FEF1A9F,0xBE76C8B4, 0xBF9D14C0,0x792D5741,
	0x3FEF22D0,0xE5604189, 0xBF9C0731,0xEC5DF82A,
	0x3FEF2B02,0x0C49BA5E, 0xBF9AF9EA,0x421EF240,
	0x3FEF3333,0x33333333, 0xBF99ECE9,0x55321B70,
	0x3FEF3B64,0x5A1CAC08, 0xBF98E02F,0x00769BCE,
	0x3FEF4395,0x810624DD, 0xBF97D3BB,0x1EE8CED0,
	0x3FEF4BC6,0xA7EF9DB2, 0xBF96C78D,0x8BA224BC,
	0x3FEF53F7,0xCED91687, 0xBF95BBA6,0x21D90435,
	0x3FEF5C28,0xF5C28F5C, 0xBF94B004,0xBCE0ABF7,
	0x3FEF645A,0x1CAC0831, 0xBF93A4A9,0x382914B6,
	0x3FEF6C8B,0x43958106, 0xBF929993,0x6F3ED324,
	0x3FEF74BC,0x6A7EF9DB, 0xBF918EC3,0x3DCAFA23,
	0x3FEF7CED,0x916872B0, 0xBF908438,0x7F92FD19,
	0x3FEF851E,0xB851EB85, 0xBF8EF3E6,0x20F124D2,
	0x3FEF8D4F,0xDF3B645A, 0xBF8CDFE5,0x98F32C36,
	0x3FEF9581,0x0624DD2F, 0xBF8ACC6F,0x1F5FD940,
	0x3FEF9DB2,0x2D0E5604, 0xBF88B982,0x6CA2CB84,
	0x3FEFA5E3,0x53F7CED9, 0xBF86A71F,0x395F3F6F,
	0x3FEFAE14,0x7AE147AE, 0xBF849545,0x3E6FD4BC,
	0x3FEFB645,0xA1CAC083, 0xBF8283F4,0x34E6552E,
	0x3FEFBE76,0xC8B43958, 0xBF80732B,0xD60B7B99,
	0x3FEFC6A7,0xEF9DB22D, 0xBF7CC5D7,0xB6BD7664,
	0x3FEFCED9,0x16872B02, 0xBF78A667,0xFD2C0E51,
	0x3FEFD70A,0x3D70A3D7, 0xBF748807,0xF33B3513,
	0x3FEFDF3B,0x645A1CAC, 0xBF706AB7,0x0D2F80D0,
	0x3FEFE76C,0x8B439581, 0xBF689CE9,0x7F727142,
	0x3FEFEF9D,0xB22D0E56, 0xBF606680,0xFFE7CC09,
	0x3FEFF7CE,0xD916872B, 0xBF506467,0x0D979B73,
	0x3FF00000,0x00000000, 0x80000000,0x00000000,
	0x3FF00418,0x9374BC6A, 0x3F506035,0x4F8C3CC4,
	0x3FF00831,0x26E978D5, 0x3F605E1D,0x82FDF749,
	0x3FF00C49,0xBA5E353F, 0x3F688A09,0xA34CA9D6,
	0x3FF01062,0x4DD2F1AA, 0x3F7059F0,0x0CC2F7FC,
	0x3FF0147A,0xE147AE14, 0x3F746DD0,0xFAD671FA,
	0x3FF01893,0x74BC6A7F, 0x3F7880A8,0x237A7261,
	0x3FF01CAC,0x083126E9, 0x3F7C9276,0x0DE12CC4,
	0x3FF020C4,0x9BA5E354, 0x3F80519D,0xA06AE4F3,
	0x3FF024DD,0x2F1A9FBE, 0x3F82597C,0x215E6436,
	0x3FF028F5,0xC28F5C29, 0x3F8460D6,0xCCCA367C,
	0x3FF02D0E,0x56041893, 0x3F8667AD,0xE57A90E1,
	0x3FF03126,0xE978D4FE, 0x3F886E01,0xAE08F2D9,
	0x3FF0353F,0x7CED9168, 0x3F8A73D2,0x68DC557E,
	0x3FF03958,0x10624DD3, 0x3F8C7920,0x58296295,
	0x3FF03D70,0xA3D70A3D, 0x3F8E7DEB,0xBDF2A35D,
	0x3FF04189,0x374BC6A8, 0x3F90411A,0x6E045B8A,
	0x3FF045A1,0xCAC08312, 0x3F9142FD,0xFA0540A5,
	0x3FF049BA,0x5E353F7D, 0x3F9244A0,0xA3B2AFEE,
	0x3FF04DD2,0xF1A9FBE7, 0x3F934602,0x8BAAAC6B,
	0x3FF051EB,0x851EB852, 0x3F944723,0xD272A7F6,
	0x3FF05604,0x189374BC, 0x3F954804,0x987799EC,
	0x3FF05A1C,0xAC083127, 0x3F9648A4,0xFE0E19B0,
	0x3FF05E35,0x3F7CED91, 0x3F974905,0x2372751C,
	0x3FF0624D,0xD2F1A9FC, 0x3F984925,0x28C8CAC5,
	0x3FF06666,0x66666666, 0x3F994905,0x2E1D202E,
	0x3FF06A7E,0xF9DB22D1, 0x3F9A48A5,0x53637BD3,
	0x3FF06E97,0x8D4FDF3B, 0x3F9B4805,0xB877FB21,
	0x3FF072B0,0x20C49BA6, 0x3F9C4726,0x7D1EEC3E,
	0x3FF076C8,0xB4395810, 0x3F9D4607,0xC104E3C9,
	0x3FF07AE1,0x47AE147B, 0x3F9E44A9,0xA3BED66B,
	0x3FF07EF9,0xDB22D0E5, 0x3F9F430C,0x44CA2E59,
	0x3FF08312,0x6E978D50, 0x3FA02097,0xE1C67254,
	0x3FF0872B,0x020C49BA, 0x3FA09F8A,0x1FAACB4D,
	0x3FF08B43,0x95810625, 0x3FA11E5C,0xEBADCF5A,
	0x3FF08F5C,0x28F5C28F, 0x3FA19D10,0x555F94E8,
	0x3FF09374,0xBC6A7EFA, 0x3FA21BA4,0x6C44A801,
	0x3FF0978D,0x4FDF3B64, 0x3FA29A19,0x3FD614B8,
	0x3FF09BA5,0xE353F7CF, 0x3FA3186E,0xDF817377,
	0x3FF09FBE,0x76C8B439, 0x3FA396A5,0x5AA8F35A,
	0x3FF0A3D7,0x0A3D70A4, 0x3FA414BC,0xC0A3665D,
	0x3FF0A7EF,0x9DB22D0E, 0x3FA492B5,0x20BC4B99,
	0x3FF0AC08,0x3126E979, 0x3FA5108E,0x8A33DB58,
	0x3FF0B020,0xC49BA5E3, 0x3FA58E49,0x0C3F1137,
	0x3FF0B439,0x5810624E, 0x3FA60BE4,0xB607B81F,
	0x3FF0B851,0xEB851EB8, 0x3FA68961,0x96AC744C,
	0x3FF0BC6A,0x7EF9DB23, 0x3FA706BF,0xBD40CF29,
	0x3FF0C083,0x126E978D, 0x3FA783FF,0x38CD413E,
	0x3FF0C49B,0xA5E353F8, 0x3FA80120,0x184F3DF2,
	0x3FF0C8B4,0x39581062, 0x3FA87E22,0x6AB93D5D,
	0x3FF0CCCC,0xCCCCCCCD, 0x3FA8FB06,0x3EF2C7F0,
	0x3FF0D0E5,0x60418937, 0x3FA977CB,0xA3D8802B,
	0x3FF0D4FD,0xF3B645A2, 0x3FA9F472,0xA83C2E32,
	0x3FF0D916,0x872B020C, 0x3FAA70FB,0x5AE4C960,
	0x3FF0DD2F,0x1A9FBE77, 0x3FAAED65,0xCA8E83C8,
	0x3FF0E147,0xAE147AE1, 0x3FAB69B2,0x05EAD3AD,
	0x3FF0E560,0x4189374C, 0x3FABE5E0,0x1BA07EE6,
	0x3FF0E978,0xD4FDF3B6, 0x3FAC61F0,0x1A4BA446,
	0x3FF0ED91,0x6872B021, 0x3FACDDE2,0x107DC6DD,
	0x3FF0F1A9,0xFBE76C8B, 0x3FAD59B6,0x0CBDD74A,
	0x3FF0F5C2,0x8F5C28F6, 0x3FADD56C,0x1D883EE6,
	0x3FF0F9DB,0x22D0E560, 0x3FAE5104,0x514EE8FD,
	0x3FF0FDF3,0xB645A1CB, 0x3FAECC7E,0xB6794DDA,
	0x3FF1020C,0x49BA5E35, 0x3FAF47DB,0x5B647BEF,
	0x3FF10624,0xDD2F1AA0, 0x3FAFC31A,0x4E6322C7,
	0x3FF10A3D,0x70A3D70A, 0x3FB01F1D,0xCEDECE09,
	0x3FF10E56,0x04189375, 0x3FB05C9F,0xABD8FB42,
	0x3FF1126E,0x978D4FDF, 0x3FB09A12,0xC539FF63,
	0x3FF11687,0x2B020C4A, 0x3FB0D777,0x2216A51E,
	0x3FF11A9F,0xBE76C8B4, 0x3FB114CC,0xC97E9FF2,
	0x3FF11EB8,0x51EB851F, 0x3FB15213,0xC27C9180,
	0x3FF122D0,0xE5604189, 0x3FB18F4C,0x14160DEE,
	0x3FF126E9,0x78D4FDF4, 0x3FB1CC75,0xC54BA132,
	0x3FF12B02,0x0C49BA5E, 0x3FB20990,0xDD18D36A,
	0x3FF12F1A,0x9FBE76C9, 0x3FB2469D,0x62742E1B,
	0x3FF13333,0x33333333, 0x3FB2839B,0x5C4F407C,
	0x3FF1374B,0xC6A7EF9E, 0x3FB2C08A,0xD196A4AA,
	0x3FF13B64,0x5A1CAC08, 0x3FB2FD6B,0xC93203E9,
	0x3FF13F7C,0xED916873, 0x3FB33A3E,0x4A041BCF,
	0x3FF14395,0x810624DD, 0x3FB37702,0x5AEAC274,
	0x3FF147AE,0x147AE148, 0x3FB3B3B8,0x02BEEB94,
	0x3FF14BC6,0xA7EF9DB2, 0x3FB3F05F,0x4854ACB9,
	0x3FF14FDF,0x3B645A1D, 0x3FB42CF8,0x327B424B,
	0x3FF153F7,0xCED91687, 0x3FB46982,0xC7FD13B2,
	0x3FF15810,0x624DD2F2, 0x3FB4A5FF,0x0F9FB85E,
	0x3FF15C28,0xF5C28F5C, 0x3FB4E26D,0x1023FBD7,
	0x3FF16041,0x89374BC7, 0x3FB51ECC,0xD045E2C0,
	0x3FF1645A,0x1CAC0831, 0x3FB55B1E,0x56BCAEDD,
	0x3FF16872,0xB020C49C, 0x3FB59761,0xAA3AE408,
	0x3FF16C8B,0x43958106, 0x3FB5D396,0xD16E4C2E,
	0x3FF170A3,0xD70A3D71, 0x3FB60FBD,0xD2FFFC37,
	0x3FF174BC,0x6A7EF9DB, 0x3FB64BD6,0xB59457FC,
	0x3FF178D4,0xFDF3B646, 0x3FB687E1,0x7FCB1726,
	0x3FF17CED,0x916872B0, 0x3FB6C3DE,0x383F4915,
	0x3FF18106,0x24DD2F1B, 0x3FB6FFCC,0xE58759B3,
	0x3FF1851E,0xB851EB85, 0x3FB73BAD,0x8E35155A,
	0x3FF18937,0x4BC6A7F0, 0x3FB77780,0x38D5AD96,
	0x3FF18D4F,0xDF3B645A, 0x3FB7B344,0xEBF1BD00,
	0x3FF19168,0x72B020C5, 0x3FB7EEFB,0xAE0D4BFA,
	0x3FF19581,0x0624DD2F, 0x3FB82AA4,0x85A7D47D,
	0x3FF19999,0x9999999A, 0x3FB8663F,0x793C46CC,
	0x3FF19DB2,0x2D0E5604, 0x3FB8A1CC,0x8F410D3C,
	0x3FF1A1CA,0xC083126F, 0x3FB8DD4B,0xCE2810D4,
	0x3FF1A5E3,0x53F7CED9, 0x3FB918BD,0x3C5EBD13,
	0x3FF1A9FB,0xE76C8B44, 0x3FB95420,0xE04E0486,
	0x3FF1AE14,0x7AE147AE, 0x3FB98F76,0xC05A647E,
	0x3FF1B22D,0x0E560419, 0x3FB9CABE,0xE2E3E9A4,
	0x3FF1B645,0xA1CAC083, 0x3FBA05F9,0x4E4633A0,
	0x3FF1BA5E,0x353F7CEE, 0x3FBA4126,0x08D879A6,
	0x3FF1BE76,0xC8B43958, 0x3FBA7C45,0x18ED8E15,
	0x3FF1C28F,0x5C28F5C3, 0x3FBAB756,0x84D3E2F6,
	0x3FF1C6A7,0xEF9DB22D, 0x3FBAF25A,0x52D58D95,
	0x3FF1CAC0,0x83126E98, 0x3FBB2D50,0x89384AF5,
	0x3FF1CED9,0x16872B02, 0x3FBB6839,0x2E3D8364,
	0x3FF1D2F1,0xA9FBE76D, 0x3FBBA314,0x48224EDE,
	0x3FF1D70A,0x3D70A3D7, 0x3FBBDDE1,0xDD1F789F,
	0x3FF1DB22,0xD0E56042, 0x3FBC18A1,0xF369837A,
	0x3FF1DF3B,0x645A1CAC, 0x3FBC5354,0x9130AD5F,
	0x3FF1E353,0xF7CED917, 0x3FBC8DF9,0xBCA0F3B2,
	0x3FF1E76C,0x8B439581, 0x3FBCC891,0x7BE216BC,
	0x3FF1EB85,0x1EB851EC, 0x3FBD031B,0xD5179E02,
	0x3FF1EF9D,0xB22D0E56, 0x3FBD3D98,0xCE60DBAB,
	0x3FF1F3B6,0x45A1CAC1, 0x3FBD7808,0x6DD8F0CA,
	0x3FF1F7CE,0xD916872B, 0x3FBDB26A,0xB996D0C2,
	0x3FF1FBE7,0x6C8B4396, 0x3FBDECBF,0xB7AD4583,
	0x3FF20000,0x00000000, 0x3FBE2707,0x6E2AF2E6,
	0x3FF20418,0x9374BC6A, 0x3FBE6141,0xE31A5AD3,
	0x3FF20831,0x26E978D5, 0x3FBE9B6F,0x1C81E0DB,
	0x3FF20C49,0xBA5E353F, 0x3FBED58F,0x2063CDCA,
	0x3FF21062,0x4DD2F1AA, 0x3FBF0FA1,0xF4BE53C3,
	0x3FF2147A,0xE147AE14, 0x3FBF49A7,0x9F8B9187,
	0x3FF21893,0x74BC6A7F, 0x3FBF83A0,0x26C19690,
	0x3FF21CAC,0x083126E9, 0x3FBFBD8B,0x90526656,
	0x3FF220C4,0x9BA5E354, 0x3FBFF769,0xE22BFC60,
	0x3FF224DD,0x2F1A9FBE, 0x3FC0189D,0x911C27BF,
	0x3FF228F5,0xC28F5C29, 0x3FC0357F,0xAB2EAAEA,
	0x3FF22D0E,0x56041893, 0x3FC0525B,0x423E8406,
	0x3FF23126,0xE978D4FE, 0x3FC06F30,0x593AB2AE,
	0x3FF2353F,0x7CED9168, 0x3FC08BFE,0xF3103B54,
	0x3FF23958,0x10624DD3, 0x3FC0A8C7,0x12AA2941,
	0x3FF23D70,0xA3D70A3D, 0x3FC0C588,0xBAF19025,
	0x3FF24189,0x374BC6A8, 0x3FC0E243,0xEECD8E13,
	0x3FF245A1,0xCAC08312, 0x3FC0FEF8,0xB1234D07,
	0x3FF249BA,0x5E353F7D, 0x3FC11BA7,0x04D604E4,
	0x3FF24DD2,0xF1A9FBE7, 0x3FC1384E,0xECC6FCF6,
	0x3FF251EB,0x851EB852, 0x3FC154F0,0x6BD58DE8,
	0x3FF25604,0x189374BC, 0x3FC1718B,0x84DF2346,
	0x3FF25A1C,0xAC083127, 0x3FC18E20,0x3ABF3D6B,
	0x3FF25E35,0x3F7CED91, 0x3FC1AAAE,0x904F7304,
	0x3FF2624D,0xD2F1A9FC, 0x3FC1C736,0x886772F9,
	0x3FF26666,0x66666666, 0x3FC1E3B8,0x25DD05E9,
	0x3FF26A7E,0xF9DB22D1, 0x3FC20033,0x6B841012,
	0x3FF26E97,0x8D4FDF3B, 0x3FC21CA8,0x5C2E92C8,
	0x3FF272B0,0x20C49BA6, 0x3FC23916,0xFAACAE5B,
	0x3FF276C8,0xB4395810, 0x3FC2557F,0x49CCA389,
	0x3FF27AE1,0x47AE147B, 0x3FC271E1,0x4C5AD55E,
	0x3FF27EF9,0xDB22D0E5, 0x3FC28E3D,0x0521CAA8,
	0x3FF28312,0x6E978D50, 0x3FC2AA92,0x76EA2FCF,
	0x3FF2872B,0x020C49BA, 0x3FC2C6E1,0xA47AD845,
	0x3FF28B43,0x95810625, 0x3FC2E32A,0x9098C05C,
	0x3FF28F5C,0x28F5C28F, 0x3FC2FF6D,0x3E070EB3,
	0x3FF29374,0xBC6A7EFA, 0x3FC31BA9,0xAF871608,
	0x3FF2978D,0x4FDF3B64, 0x3FC337DF,0xE7D856A0,
	0x3FF29BA5,0xE353F7CF, 0x3FC3540F,0xE9B88018,
	0x3FF29FBE,0x76C8B439, 0x3FC37039,0xB7E372C4,
	0x3FF2A3D7,0x0A3D70A4, 0x3FC38C5D,0x55134183,
	0x3FF2A7EF,0x9DB22D0E, 0x3FC3A87A,0xC4003319,
	0x3FF2AC08,0x3126E979, 0x3FC3C492,0x0760C3FC,
	0x3FF2B020,0xC49BA5E3, 0x3FC3E0A3,0x21E9A7AF,
	0x3FF2B439,0x5810624E, 0x3FC3FCAE,0x164DCA87,
	0x3FF2B851,0xEB851EB8, 0x3FC418B2,0xE73E5307,
	0x3FF2BC6A,0x7EF9DB23, 0x3FC434B1,0x976AA39E,
	0x3FF2C083,0x126E978D, 0x3FC450AA,0x29805C02,
	0x3FF2C49B,0xA5E353F8, 0x3FC46C9C,0xA02B5AEB,
	0x3FF2C8B4,0x39581062, 0x3FC48888,0xFE15BF67,
	0x3FF2CCCC,0xCCCCCCCD, 0x3FC4A46F,0x45E7EA95,
	0x3FF2D0E5,0x60418937, 0x3FC4C04F,0x7A4880F6,
	0x3FF2D4FD,0xF3B645A2, 0x3FC4DC29,0x9DDC6C23,
	0x3FF2D916,0x872B020C, 0x3FC4F7FD,0xB346DC19,
	0x3FF2DD2F,0x1A9FBE77, 0x3FC513CB,0xBD2948F0,
	0x3FF2E147,0xAE147AE1, 0x3FC52F93,0xBE237421,
	0x3FF2E560,0x4189374C, 0x3FC54B55,0xB8D36A3C,
	0x3FF2E978,0xD4FDF3B6, 0x3FC56711,0xAFD58428,
	0x3FF2ED91,0x6872B021, 0x3FC582C7,0xA5C468D3,
	0x3FF2F1A9,0xFBE76C8B, 0x3FC59E77,0x9D390E79,
	0x3FF2F5C2,0x8F5C28F6, 0x3FC5BA21,0x98CABC49,
	0x3FF2F9DB,0x22D0E560, 0x3FC5D5C5,0x9B0F0BA7,
	0x3FF2FDF3,0xB645A1CB, 0x3FC5F163,0xA699E9D3,
	0x3FF3020C,0x49BA5E35, 0x3FC60CFB,0xBDFD9929,
	0x3FF30624,0xDD2F1AA0, 0x3FC6288D,0xE3CAB2C0,
	0x3FF30A3D,0x70A3D70A, 0x3FC6441A,0x1A9027A6,
	0x3FF30E56,0x04189375, 0x3FC65FA0,0x64DB4282,
	0x3FF3126E,0x978D4FDF, 0x3FC67B20,0xC537A8CA,
	0x3FF31687,0x2B020C4A, 0x3FC6969B,0x3E2F5C62,
	0x3FF31A9F,0xBE76C8B4, 0x3FC6B20F,0xD24ABCCC,
	0x3FF31EB8,0x51EB851F, 0x3FC6CD7E,0x841088C8,
	0x3FF322D0,0xE5604189, 0x3FC6E8E7,0x5605DF80,
	0x3FF326E9,0x78D4FDF4, 0x3FC7044A,0x4AAE4225,
	0x3FF32B02,0x0C49BA5E, 0x3FC71FA7,0x648B9516,
	0x3FF32F1A,0x9FBE76C9, 0x3FC73AFE,0xA61E217E,
	0x3FF33333,0x33333333, 0x3FC75650,0x11E49675,
	0x3FF3374B,0xC6A7EF9E, 0x3FC7719B,0xAA5C0A99,
	0x3FF33B64,0x5A1CAC08, 0x3FC78CE1,0x71FFFD34,
	0x3FF33F7C,0xED916873, 0x3FC7A821,0x6B4A57C9,
	0x3FF34395,0x810624DD, 0x3FC7C35B,0x98B36F3C,
	0x3FF347AE,0x147AE148, 0x3FC7DE8F,0xFCB2055D,
	0x3FF34BC6,0xA7EF9DB2, 0x3FC7F9BE,0x99BB4A09,
	0x3FF34FDF,0x3B645A1D, 0x3FC814E7,0x7242DCB5,
	0x3FF353F7,0xCED91687, 0x3FC8300A,0x88BACD8E,
	0x3FF35810,0x624DD2F2, 0x3FC84B27,0xDF939EFD,
	0x3FF35C28,0xF5C28F5C, 0x3FC8663F,0x793C46C6,
	0x3FF36041,0x89374BC7, 0x3FC88151,0x58222F88,
	0x3FF3645A,0x1CAC0831, 0x3FC89C5D,0x7EB139DD,
	0x3FF36872,0xB020C49C, 0x3FC8B763,0xEF53BDD5,
	0x3FF36C8B,0x43958106, 0x3FC8D264,0xAC728C10,
	0x3FF370A3,0xD70A3D71, 0x3FC8ED5F,0xB874EF3D,
	0x3FF374BC,0x6A7EF9DB, 0x3FC90855,0x15C0AD2B,
	0x3FF378D4,0xFDF3B646, 0x3FC92344,0xC6BA0847,
	0x3FF37CED,0x916872B0, 0x3FC93E2E,0xCDC3C0AF,
	0x3FF38106,0x24DD2F1B, 0x3FC95913,0x2D3F15A6,
	0x3FF3851E,0xB851EB85, 0x3FC973F1,0xE78BC6A8,
	0x3FF38937,0x4BC6A7F0, 0x3FC98ECA,0xFF0814DE,
	0x3FF38D4F,0xDF3B645A, 0x3FC9A99E,0x7610C429,
	0x3FF39168,0x72B020C5, 0x3FC9C46C,0x4F011C99,
	0x3FF39581,0x0624DD2F, 0x3FC9DF34,0x8C32EB74,
	0x3FF39999,0x9999999A, 0x3FC9F9F7,0x2FFE84A6,
	0x3FF39DB2,0x2D0E5604, 0x3FCA14B4,0x3CBAC3CC,
	0x3FF3A1CA,0xC083126F, 0x3FCA2F6B,0xB4BD0DA0,
	0x3FF3A5E3,0x53F7CED9, 0x3FCA4A1D,0x9A5950FC,
	0x3FF3A9FB,0xE76C8B44, 0x3FCA64C9,0xEFE20849,
	0x3FF3AE14,0x7AE147AE, 0x3FCA7F70,0xB7A83A7F,
	0x3FF3B22D,0x0E560419, 0x3FCA9A11,0xF3FB7C8E,
	0x3FF3B645,0xA1CAC083, 0x3FCAB4AD,0xA729F260,
	0x3FF3BA5E,0x353F7CEE, 0x3FCACF43,0xD380503E,
	0x3FF3BE76,0xC8B43958, 0x3FCAE9D4,0x7B49DBCB,
	0x3FF3C28F,0x5C28F5C3, 0x3FCB045F,0xA0D06D6D,
	0x3FF3C6A7,0xEF9DB22D, 0x3FCB1EE5,0x465C7142,
	0x3FF3CAC0,0x83126E98, 0x3FCB3965,0x6E34E888,
	0x3FF3CED9,0x16872B02, 0x3FCB53E0,0x1A9F6A91,
	0x3FF3D2F1,0xA9FBE76D, 0x3FCB6E55,0x4DE02621,
	0x3FF3D70A,0x3D70A3D7, 0x3FCB88C5,0x0A39E268,
	0x3FF3DB22,0xD0E56042, 0x3FCBA32F,0x51EE005E,
	0x3FF3DF3B,0x645A1CAC, 0x3FCBBD94,0x273C7BB3,
	0x3FF3E353,0xF7CED917, 0x3FCBD7F3,0x8C63EC2D,
	0x3FF3E76C,0x8B439581, 0x3FCBF24D,0x83A18698,
	0x3FF3EB85,0x1EB851EC, 0x3FCC0CA2,0x0F311E1E,
	0x3FF3EF9D,0xB22D0E56, 0x3FCC26F1,0x314D2536,
	0x3FF3F3B6,0x45A1CAC1, 0x3FCC413A,0xEC2EAEF8,
	0x3FF3F7CE,0xD916872B, 0x3FCC5B7F,0x420D700C,
	0x3FF3FBE7,0x6C8B4396, 0x3FCC75BE,0x351FBFFD,
	0x3FF40000,0x00000000, 0x3FCC8FF7,0xC79A9A22,
	0x3FF40418,0x9374BC6A, 0x3FCCAA2B,0xFBB19EE7,
	0x3FF40831,0x26E978D5, 0x3FCCC45A,0xD39714DB,
	0x3FF40C49,0xBA5E353F, 0x3FCCDE84,0x517BE9B1,
	0x3FF41062,0x4DD2F1AA, 0x3FCCF8A8,0x778FB38C,
	0x3FF4147A,0xE147AE14, 0x3FCD12C7,0x4800B1DE,
	0x3FF41893,0x74BC6A7F, 0x3FCD2CE0,0xC4FBCEBB,
	0x3FF41CAC,0x083126E9, 0x3FCD46F4,0xF0AC9FB4,
	0x3FF420C4,0x9BA5E354, 0x3FCD6103,0xCD3D6725,
	0x3FF424DD,0x2F1A9FBE, 0x3FCD7B0D,0x5CD71512,
	0x3FF428F5,0xC28F5C29, 0x3FCD9511,0xA1A14871,
	0x3FF42D0E,0x56041893, 0x3FCDAF10,0x9DC25005,
	0x3FF43126,0xE978D4FE, 0x3FCDC90A,0x535F2BA4,
	0x3FF4353F,0x7CED9168, 0x3FCDE2FE,0xC49B8D14,
	0x3FF43958,0x10624DD3, 0x3FCDFCED,0xF399D94B,
	0x3FF43D70,0xA3D70A3D, 0x3FCE16D7,0xE27B294C,
	0x3FF44189,0x374BC6A8, 0x3FCE30BC,0x935F4B64,
	0x3FF445A1,0xCAC08312, 0x3FCE4A9C,0x0864C404,
	0x3FF449BA,0x5E353F7D, 0x3FCE6476,0x43A8CEFD,
	0x3FF44DD2,0xF1A9FBE7, 0x3FCE7E4B,0x47476059,
	0x3FF451EB,0x851EB852, 0x3FCE981B,0x155B2593,
	0x3FF45604,0x189374BC, 0x3FCEB1E5,0xAFFD866F,
	0x3FF45A1C,0xAC083127, 0x3FCECBAB,0x1946A62F,
	0x3FF45E35,0x3F7CED91, 0x3FCEE56B,0x534D6468,
	0x3FF4624D,0xD2F1A9FC, 0x3FCEFF26,0x60275E3A,
	0x3FF46666,0x66666666, 0x3FCF18DC,0x41E8EF1D,
	0x3FF46A7E,0xF9DB22D1, 0x3FCF328C,0xFAA53219,
	0x3FF46E97,0x8D4FDF3B, 0x3FCF4C38,0x8C6E0292,
	0x3FF472B0,0x20C49BA6, 0x3FCF65DE,0xF953FD7D,
	0x3FF476C8,0xB4395810, 0x3FCF7F80,0x4366822B,
	0x3FF47AE1,0x47AE147B, 0x3FCF991C,0x6CB3B37A,
	0x3FF47EF9,0xDB22D0E5, 0x3FCFB2B3,0x774878A1,
	0x3FF48312,0x6E978D50, 0x3FCFCC45,0x65307E5B,
	0x3FF4872B,0x020C49BA, 0x3FCFE5D2,0x387637B5,
	0x3FF48B43,0x95810625, 0x3FCFFF59,0xF322DF35,
	0x3FF48F5C,0x28F5C28F, 0x3FD00C6E,0x4B9F3BD3,
	0x3FF49374,0xBC6A7EFA, 0x3FD0192D,0x1367E6A0,
	0x3FF4978D,0x4FDF3B64, 0x3FD025E9,0x51EE3B35,
	0x3FF49BA5,0xE353F7CF, 0x3FD032A3,0x08346A75,
	0x3FF49FBE,0x76C8B439, 0x3FD03F5A,0x373C0B51,
	0x3FF4A3D7,0x0A3D70A4, 0x3FD04C0E,0xE0061B5B,
	0x3FF4A7EF,0x9DB22D0E, 0x3FD058C1,0x0392FF2B,
	0x3FF4AC08,0x3126E979, 0x3FD06570,0xA2E282EB,
	0x3FF4B020,0xC49BA5E3, 0x3FD0721D,0xBEF3DABC,
	0x3FF4B439,0x5810624E, 0x3FD07EC8,0x58C5A344,
	0x3FF4B851,0xEB851EB8, 0x3FD08B70,0x7155E20F,
	0x3FF4BC6A,0x7EF9DB23, 0x3FD09816,0x09A2061F,
	0x3FF4C083,0x126E978D, 0x3FD0A4B9,0x22A6E849,
	0x3FF4C49B,0xA5E353F8, 0x3FD0B159,0xBD60CBC4,
	0x3FF4C8B4,0x39581062, 0x3FD0BDF7,0xDACB5E88,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FD0CA93,0x7BE1B9DC,
	0x3FF4D0E5,0x60418937, 0x3FD0D72C,0xA19E62B2,
	0x3FF4D4FD,0xF3B645A2, 0x3FD0E3C3,0x4CFB4A32,
	0x3FF4D916,0x872B020C, 0x3FD0F057,0x7EF1CE1A,
	0x3FF4DD2F,0x1A9FBE77, 0x3FD0FCE9,0x387AB948,
	0x3FF4E147,0xAE147AE1, 0x3FD10978,0x7A8E4413,
	0x3FF4E560,0x4189374C, 0x3FD11605,0x462414DB,
	0x3FF4E978,0xD4FDF3B6, 0x3FD1228F,0x9C33405F,
	0x3FF4ED91,0x6872B021, 0x3FD12F17,0x7DB24A48,
	0x3FF4F1A9,0xFBE76C8B, 0x3FD13B9C,0xEB972584,
	0x3FF4F5C2,0x8F5C28F6, 0x3FD1481F,0xE6D734CF,
	0x3FF4F9DB,0x22D0E560, 0x3FD154A0,0x70674B09,
	0x3FF4FDF3,0xB645A1CB, 0x3FD1611E,0x893BABC2,
	0x3FF5020C,0x49BA5E35, 0x3FD16D9A,0x32480B8F,
	0x3FF50624,0xDD2F1AA0, 0x3FD17A13,0x6C7F9093,
	0x3FF50A3D,0x70A3D70A, 0x3FD1868A,0x38D4D2D6,
	0x3FF50E56,0x04189375, 0x3FD192FE,0x9839DCC9,
	0x3FF5126E,0x978D4FDF, 0x3FD19F70,0x8BA02BA3,
	0x3FF51687,0x2B020C4A, 0x3FD1ABE0,0x13F8AFDC,
	0x3FF51A9F,0xBE76C8B4, 0x3FD1B84D,0x3233CD8D,
	0x3FF51EB8,0x51EB851F, 0x3FD1C4B7,0xE7415CEE,
	0x3FF522D0,0xE5604189, 0x3FD1D120,0x3410AAAD,
	0x3FF526E9,0x78D4FDF4, 0x3FD1DD86,0x19907873,
	0x3FF52B02,0x0C49BA5E, 0x3FD1E9E9,0x98AEFD35,
	0x3FF52F1A,0x9FBE76C9, 0x3FD1F64A,0xB259E5BA,
	0x3FF53333,0x33333333, 0x3FD202A9,0x677E54EC,
	0x3FF5374B,0xC6A7EF9E, 0x3FD20F05,0xB908E45C,
	0x3FF53B64,0x5A1CAC08, 0x3FD21B5F,0xA7E5A492,
	0x3FF53F7C,0xED916873, 0x3FD227B7,0x35001D90,
	0x3FF54395,0x810624DD, 0x3FD2340C,0x61434F25,
	0x3FF547AE,0x147AE148, 0x3FD2405F,0x2D99B16A,
	0x3FF54BC6,0xA7EF9DB2, 0x3FD24CAF,0x9AED3514,
	0x3FF54FDF,0x3B645A1D, 0x3FD258FD,0xAA2743F8,
	0x3FF553F7,0xCED91687, 0x3FD26549,0x5C30C153,
	0x3FF55810,0x624DD2F2, 0x3FD27192,0xB1F20A51,
	0x3FF55C28,0xF5C28F5C, 0x3FD27DD9,0xAC52F657,
	0x3FF56041,0x89374BC7, 0x3FD28A1E,0x4C3AD782,
	0x3FF5645A,0x1CAC0831, 0x3FD29660,0x92907AF8,
	0x3FF56872,0xB020C49C, 0x3FD2A2A0,0x803A2964,
	0x3FF56C8B,0x43958106, 0x3FD2AEDE,0x161DA742,
	0x3FF570A3,0xD70A3D71, 0x3FD2BB19,0x5520355D,
	0x3FF574BC,0x6A7EF9DB, 0x3FD2C752,0x3E26911F,
	0x3FF578D4,0xFDF3B646, 0x3FD2D388,0xD214F507,
	0x3FF57CED,0x916872B0, 0x3FD2DFBD,0x11CF18FA,
	0x3FF58106,0x24DD2F1B, 0x3FD2EBEE,0xFE3832BB,
	0x3FF5851E,0xB851EB85, 0x3FD2F81E,0x9832F63A,
	0x3FF58937,0x4BC6A7F0, 0x3FD3044B,0xE0A1960A,
	0x3FF58D4F,0xDF3B645A, 0x3FD31076,0xD865C3B1,
	0x3FF59168,0x72B020C5, 0x3FD31C9F,0x8060B01C,
	0x3FF59581,0x0624DD2F, 0x3FD328C5,0xD9730BEE,
	0x3FF59999,0x9999999A, 0x3FD334E9,0xE47D07F6,
	0x3FF59DB2,0x2D0E5604, 0x3FD3410B,0xA25E5578,
	0x3FF5A1CA,0xC083126F, 0x3FD34D2B,0x13F626A8,
	0x3FF5A5E3,0x53F7CED9, 0x3FD35948,0x3A232EF1,
	0x3FF5A9FB,0xE76C8B44, 0x3FD36563,0x15C3A36B,
	0x3FF5AE14,0x7AE147AE, 0x3FD3717B,0xA7B53B27,
	0x3FF5B22D,0x0E560419, 0x3FD37D91,0xF0D52FA0,
	0x3FF5B645,0xA1CAC083, 0x3FD389A5,0xF2003D07,
	0x3FF5BA5E,0x353F7CEE, 0x3FD395B7,0xAC12A2B9,
	0x3FF5BE76,0xC8B43958, 0x3FD3A1C7,0x1FE82381,
	0x3FF5C28F,0x5C28F5C3, 0x3FD3ADD4,0x4E5C0613,
	0x3FF5C6A7,0xEF9DB22D, 0x3FD3B9DF,0x3849154E,
	0x3FF5CAC0,0x83126E98, 0x3FD3C5E7,0xDE89A0B1,
	0x3FF5CED9,0x16872B02, 0x3FD3D1EE,0x41F77CA4,
	0x3FF5D2F1,0xA9FBE76D, 0x3FD3DDF2,0x636C02E7,
	0x3FF5D70A,0x3D70A3D7, 0x3FD3E9F4,0x43C012D9,
	0x3FF5DB22,0xD0E56042, 0x3FD3F5F3,0xE3CC11EB,
	0x3FF5DF3B,0x645A1CAC, 0x3FD401F1,0x4467EBE3,
	0x3FF5E353,0xF7CED917, 0x3FD40DEC,0x666B1351,
	0x3FF5E76C,0x8B439581, 0x3FD419E5,0x4AAC81CF,
	0x3FF5EB85,0x1EB851EC, 0x3FD425DB,0xF202B876,
	0x3FF5EF9D,0xB22D0E56, 0x3FD431D0,0x5D43C01F,
	0x3FF5F3B6,0x45A1CAC1, 0x3FD43DC2,0x8D4529D2,
	0x3FF5F7CE,0xD916872B, 0x3FD449B2,0x82DC0F0D,
	0x3FF5FBE7,0x6C8B4396, 0x3FD455A0,0x3EDD1230,
	0x3FF60000,0x00000000, 0x3FD4618B,0xC21C5EC2,
	0x3FF60418,0x9374BC6A, 0x3FD46D75,0x0D6DA9DB,
	0x3FF60831,0x26E978D5, 0x3FD4795C,0x21A43274,
	0x3FF60C49,0xBA5E353F, 0x3FD48540,0xFF92C1B6,
	0x3FF61062,0x4DD2F1AA, 0x3FD49123,0xA80BAB69,
	0x3FF6147A,0xE147AE14, 0x3FD49D04,0x1BE0CE2F,
	0x3FF61893,0x74BC6A7F, 0x3FD4A8E2,0x5BE393F6,
	0x3FF61CAC,0x083126E9, 0x3FD4B4BE,0x68E4F233,
	0x3FF620C4,0x9BA5E354, 0x3FD4C098,0x43B56A55,
	0x3FF624DD,0x2F1A9FBE, 0x3FD4CC6F,0xED2509FF,
	0x3FF628F5,0xC28F5C29, 0x3FD4D845,0x66036B79,
	0x3FF62D0E,0x56041893, 0x3FD4E418,0xAF1FB5E9,
	0x3FF63126,0xE978D4FE, 0x3FD4EFE9,0xC9489DC3,
	0x3FF6353F,0x7CED9168, 0x3FD4FBB8,0xB54C6506,
	0x3FF63958,0x10624DD3, 0x3FD50785,0x73F8DBA6,
	0x3FF63D70,0xA3D70A3D, 0x3FD51350,0x061B5FCB,
	0x3FF64189,0x374BC6A8, 0x3FD51F18,0x6C80DE3B,
	0x3FF645A1,0xCAC08312, 0x3FD52ADE,0xA7F5D294,
	0x3FF649BA,0x5E353F7D, 0x3FD536A2,0xB94647BC,
	0x3FF64DD2,0xF1A9FBE7, 0x3FD54264,0xA13DD815,
	0x3FF651EB,0x851EB852, 0x3FD54E24,0x60A7ADEE,
	0x3FF65604,0x189374BC, 0x3FD559E1,0xF84E83BA,
	0x3FF65A1C,0xAC083127, 0x3FD5659D,0x68FCA47B,
	0x3FF65E35,0x3F7CED91, 0x3FD57156,0xB37BEBFB,
	0x3FF6624D,0xD2F1A9FC, 0x3FD57D0D,0xD895C734,
	0x3FF66666,0x66666666, 0x3FD588C2,0xD913348F,
	0x3FF66A7E,0xF9DB22D1, 0x3FD59475,0xB5BCC443,
	0x3FF66E97,0x8D4FDF3B, 0x3FD5A026,0x6F5A9899,
	0x3FF672B0,0x20C49BA6, 0x3FD5ABD5,0x06B4664A,
	0x3FF676C8,0xB4395810, 0x3FD5B781,0x7C9174BF,
	0x3FF67AE1,0x47AE147B, 0x3FD5C32B,0xD1B89E70,
	0x3FF67EF9,0xDB22D0E5, 0x3FD5CED4,0x06F05126,
	0x3FF68312,0x6E978D50, 0x3FD5DA7A,0x1CFE8E5A,
	0x3FF6872B,0x020C49BA, 0x3FD5E61E,0x14A8EB6D,
	0x3FF68B43,0x95810625, 0x3FD5F1BF,0xEEB49213,
	0x3FF68F5C,0x28F5C28F, 0x3FD5FD5F,0xABE64084,
	0x3FF69374,0xBC6A7EFA, 0x3FD608FD,0x4D0249E4,
	0x3FF6978D,0x4FDF3B64, 0x3FD61498,0xD2CC967C,
	0x3FF69BA5,0xE353F7CF, 0x3FD62032,0x3E08A417,
	0x3FF69FBE,0x76C8B439, 0x3FD62BC9,0x8F798642,
	0x3FF6A3D7,0x0A3D70A4, 0x3FD6375E,0xC7E1E6A8,
	0x3FF6A7EF,0x9DB22D0E, 0x3FD642F1,0xE804054C,
	0x3FF6AC08,0x3126E979, 0x3FD64E82,0xF0A1B8E9,
	0x3FF6B020,0xC49BA5E3, 0x3FD65A11,0xE27C6F2A,
	0x3FF6B439,0x5810624E, 0x3FD6659E,0xBE552D0D,
	0x3FF6B851,0xEB851EB8, 0x3FD67129,0x84EC8F15,
	0x3FF6BC6A,0x7EF9DB23, 0x3FD67CB2,0x3702C9AD,
	0x3FF6C083,0x126E978D, 0x3FD68838,0xD557A95E,
	0x3FF6C49B,0xA5E353F8, 0x3FD693BD,0x60AA932F,
	0x3FF6C8B4,0x39581062, 0x3FD69F3F,0xD9BA84D8,
	0x3FF6CCCC,0xCCCCCCCD, 0x3FD6AAC0,0x41461526,
	0x3FF6D0E5,0x60418937, 0x3FD6B63E,0x980B7429,
	0x3FF6D4FD,0xF3B645A2, 0x3FD6C1BA,0xDEC86B9B,
	0x3FF6D916,0x872B020C, 0x3FD6CD35,0x163A5F0E,
	0x3FF6DD2F,0x1A9FBE77, 0x3FD6D8AD,0x3F1E4C4C,
	0x3FF6E147,0xAE147AE1, 0x3FD6E423,0x5A30CB8D,
	0x3FF6E560,0x4189374C, 0x3FD6EF97,0x682E0FD1,
	0x3FF6E978,0xD4FDF3B6, 0x3FD6FB09,0x69D1E717,
	0x3FF6ED91,0x6872B021, 0x3FD70679,0x5FD7BAB9,
	0x3FF6F1A9,0xFBE76C8B, 0x3FD711E7,0x4AFA8F9D,
	0x3FF6F5C2,0x8F5C28F6, 0x3FD71D53,0x2BF50695,
	0x3FF6F9DB,0x22D0E560, 0x3FD728BD,0x03815C8D,
	0x3FF6FDF3,0xB645A1CB, 0x3FD73424,0xD2596AEC,
	0x3FF7020C,0x49BA5E35, 0x3FD73F8A,0x9936A7C4,
	0x3FF70624,0xDD2F1AA0, 0x3FD74AEE,0x58D2262D,
	0x3FF70A3D,0x70A3D70A, 0x3FD75650,0x11E49676,
	0x3FF70E56,0x04189375, 0x3FD761AF,0xC5264681,
	0x3FF7126E,0x978D4FDF, 0x3FD76D0D,0x734F21F5,
	0x3FF71687,0x2B020C4A, 0x3FD77869,0x1D16B299,
	0x3FF71A9F,0xBE76C8B4, 0x3FD783C2,0xC334207F,
	0x3FF71EB8,0x51EB851F, 0x3FD78F1A,0x665E3267,
	0x3FF722D0,0xE5604189, 0x3FD79A70,0x074B4DE8,
	0x3FF726E9,0x78D4FDF4, 0x3FD7A5C3,0xA6B177CC,
	0x3FF72B02,0x0C49BA5E, 0x3FD7B115,0x45465441,
	0x3FF72F1A,0x9FBE76C9, 0x3FD7BC64,0xE3BF272F,
	0x3FF73333,0x33333333, 0x3FD7C7B2,0x82D0D46B,
	0x3FF7374B,0xC6A7EF9E, 0x3FD7D2FE,0x232FE00D,
	0x3FF73B64,0x5A1CAC08, 0x3FD7DE47,0xC5906E9E,
	0x3FF73F7C,0xED916873, 0x3FD7E98F,0x6AA64574,
	0x3FF74395,0x810624DD, 0x3FD7F4D5,0x1324CADC,
	0x3FF747AE,0x147AE148, 0x3FD80018,0xBFBF0675,
	0x3FF74BC6,0xA7EF9DB2, 0x3FD80B5A,0x7127A15A,
	0x3FF74FDF,0x3B645A1D, 0x3FD8169A,0x2810E67F,
	0x3FF753F7,0xCED91687, 0x3FD821D7,0xE52CC2D8,
	0x3FF75810,0x624DD2F2, 0x3FD82D13,0xA92CC5B4,
	0x3FF75C28,0xF5C28F5C, 0x3FD8384D,0x74C220E9,
	0x3FF76041,0x89374BC7, 0x3FD84385,0x489DA929,
	0x3FF7645A,0x1CAC0831, 0x3FD84EBB,0x256FD631,
	0x3FF76872,0xB020C49C, 0x3FD859EF,0x0BE8C31B,
	0x3FF76C8B,0x43958106, 0x3FD86520,0xFCB82E8F,
	0x3FF770A3,0xD70A3D71, 0x3FD87050,0xF88D7B14,
	0x3FF774BC,0x6A7EF9DB, 0x3FD87B7F,0x0017AF3E,
	0x3FF778D4,0xFDF3B646, 0x3FD886AB,0x14057602,
	0x3FF77CED,0x916872B0, 0x3FD891D5,0x35051EE1,
	0x3FF78106,0x24DD2F1B, 0x3FD89CFD,0x63C49E40,
	0x3FF7851E,0xB851EB85, 0x3FD8A823,0xA0F18D8C,
	0x3FF78937,0x4BC6A7F0, 0x3FD8B347,0xED392B95,
	0x3FF78D4F,0xDF3B645A, 0x3FD8BE6A,0x49485CB2,
	0x3FF79168,0x72B020C5, 0x3FD8C98A,0xB5CBAB1B,
	0x3FF79581,0x0624DD2F, 0x3FD8D4A9,0x336F470E,
	0x3FF79999,0x9999999A, 0x3FD8DFC5,0xC2DF0724,
	0x3FF79DB2,0x2D0E5604, 0x3FD8EAE0,0x64C6687A,
	0x3FF7A1CA,0xC083126F, 0x3FD8F5F9,0x19D08F07,
	0x3FF7A5E3,0x53F7CED9, 0x3FD9010F,0xE2A845C0,
	0x3FF7A9FB,0xE76C8B44, 0x3FD90C24,0xBFF7FEEC,
	0x3FF7AE14,0x7AE147AE, 0x3FD91737,0xB269D44E,
	0x3FF7B22D,0x0E560419, 0x3FD92248,0xBAA78778,
	0x3FF7B645,0xA1CAC083, 0x3FD92D57,0xD95A81F0,
	0x3FF7BA5E,0x353F7CEE, 0x3FD93865,0x0F2BD582,
	0x3FF7BE76,0xC8B43958, 0x3FD94370,0x5CC43C6B,
	0x3FF7C28F,0x5C28F5C3, 0x3FD94E79,0xC2CC19A7,
	0x3FF7C6A7,0xEF9DB22D, 0x3FD95981,0x41EB791A,
	0x3FF7CAC0,0x83126E98, 0x3FD96486,0xDACA0FDE,
	0x3FF7CED9,0x16872B02, 0x3FD96F8A,0x8E0F3C6F,
	0x3FF7D2F1,0xA9FBE76D, 0x3FD97A8C,0x5C6206F7,
	0x3FF7D70A,0x3D70A3D7, 0x3FD9858C,0x46692177,
	0x3FF7DB22,0xD0E56042, 0x3FD9908A,0x4CCAE814,
	0x3FF7DF3B,0x645A1CAC, 0x3FD99B86,0x702D6142,
	0x3FF7E353,0xF7CED917, 0x3FD9A680,0xB1363E0E,
	0x3FF7E76C,0x8B439581, 0x3FD9B179,0x108ADA49,
	0x3FF7EB85,0x1EB851EC, 0x3FD9BC6F,0x8ED03CD3,
	0x3FF7EF9D,0xB22D0E56, 0x3FD9C764,0x2CAB17C3,
	0x3FF7F3B6,0x45A1CAC1, 0x3FD9D256,0xEABFC8B5,
	0x3FF7F7CE,0xD916872B, 0x3FD9DD47,0xC9B258EF,
	0x3FF7FBE7,0x6C8B4396, 0x3FD9E836,0xCA267DAD,
	0x3FF80000,0x00000000, 0x3FD9F323,0xECBF984C,
	0x3FF80418,0x9374BC6A, 0x3FD9FE0F,0x3220B68E,
	0x3FF80831,0x26E978D5, 0x3FDA08F8,0x9AEC92D0,
	0x3FF80C49,0xBA5E353F, 0x3FDA13E0,0x27C59439,
	0x3FF81062,0x4DD2F1AA, 0x3FDA1EC5,0xD94DCF07,
	0x3FF8147A,0xE147AE14, 0x3FDA29A9,0xB02704AE,
	0x3FF81893,0x74BC6A7F, 0x3FDA348B,0xACF2A42C,
	0x3FF81CAC,0x083126E9, 0x3FDA3F6B,0xD051CA25,
	0x3FF820C4,0x9BA5E354, 0x3FDA4A4A,0x1AE54137,
	0x3FF824DD,0x2F1A9FBE, 0x3FDA5526,0x8D4D8214,
	0x3FF828F5,0xC28F5C29, 0x3FDA6001,0x282AB3D9,
	0x3FF82D0E,0x56041893, 0x3FDA6AD9,0xEC1CAC26,
	0x3FF83126,0xE978D4FE, 0x3FDA75B0,0xD9C2EF74,
	0x3FF8353F,0x7CED9168, 0x3FDA8085,0xF1BCB12D,
	0x3FF83958,0x10624DD3, 0x3FDA8B59,0x34A8D400,
	0x3FF83D70,0xA3D70A3D, 0x3FDA962A,0xA325E9FE,
	0x3FF84189,0x374BC6A8, 0x3FDAA0FA,0x3DD234EA,
	0x3FF845A1,0xCAC08312, 0x3FDAABC8,0x054BA652,
	0x3FF849BA,0x5E353F7D, 0x3FDAB693,0xFA2FDFE3,
	0x3FF84DD2,0xF1A9FBE7, 0x3FDAC15E,0x1D1C3385,
	0x3FF851EB,0x851EB852, 0x3FDACC26,0x6EADA3A7,
	0x3FF85604,0x189374BC, 0x3FDAD6EC,0xEF80E35F,
	0x3FF85A1C,0xAC083127, 0x3FDAE1B1,0xA03256B6,
	0x3FF85E35,0x3F7CED91, 0x3FDAEC74,0x815E12C6,
	0x3FF8624D,0xD2F1A9FC, 0x3FDAF735,0x939FDE05,
	0x3FF86666,0x66666666, 0x3FDB01F4,0xD7933064,
	0x3FF86A7E,0xF9DB22D1, 0x3FDB0CB2,0x4DD3339C,
	0x3FF86E97,0x8D4FDF3B, 0x3FDB176D,0xF6FAC34A,
	0x3FF872B0,0x20C49BA6, 0x3FDB2227,0xD3A46D37,
	0x3FF876C8,0xB4395810, 0x3FDB2CDF,0xE46A717D,
	0x3FF87AE1,0x47AE147B, 0x3FDB3796,0x29E6C2CB,
	0x3FF87EF9,0xDB22D0E5, 0x3FDB424A,0xA4B30686,
	0x3FF88312,0x6E978D50, 0x3FDB4CFD,0x5568950F,
	0x3FF8872B,0x020C49BA, 0x3FDB57AE,0x3CA079E6,
	0x3FF88B43,0x95810625, 0x3FDB625D,0x5AF373EE,
	0x3FF88F5C,0x28F5C28F, 0x3FDB6D0A,0xB0F9F58E,
	0x3FF89374,0xBC6A7EFA, 0x3FDB77B6,0x3F4C24F8,
	0x3FF8978D,0x4FDF3B64, 0x3FDB8260,0x0681DC46,
	0x3FF89BA5,0xE353F7CF, 0x3FDB8D08,0x0732A9C3,
	0x3FF89FBE,0x76C8B439, 0x3FDB97AE,0x41F5D008,
	0x3FF8A3D7,0x0A3D70A4, 0x3FDBA252,0xB7624642,
	0x3FF8A7EF,0x9DB22D0E, 0x3FDBACF5,0x680EB851,
	0x3FF8AC08,0x3126E979, 0x3FDBB796,0x54918710,
	0x3FF8B020,0xC49BA5E3, 0x3FDBC235,0x7D80C86D,
	0x3FF8B439,0x5810624E, 0x3FDBCCD2,0xE37247B7,
	0x3FF8B851,0xEB851EB8, 0x3FDBD76E,0x86FB85B1,
	0x3FF8BC6A,0x7EF9DB23, 0x3FDBE208,0x68B1B8E3,
	0x3FF8C083,0x126E978D, 0x3FDBECA0,0x8929CDAF,
	0x3FF8C49B,0xA5E353F8, 0x3FDBF736,0xE8F86696,
	0x3FF8C8B4,0x39581062, 0x3FDC01CB,0x88B1DC5C,
	0x3FF8CCCC,0xCCCCCCCD, 0x3FDC0C5E,0x68EA3E46,
	0x3FF8D0E5,0x60418937, 0x3FDC16EF,0x8A355236,
	0x3FF8D4FD,0xF3B645A2, 0x3FDC217E,0xED2694F6,
	0x3FF8D916,0x872B020C, 0x3FDC2C0C,0x92513A4E,
	0x3FF8DD2F,0x1A9FBE77, 0x3FDC3698,0x7A482D4C,
	0x3FF8E147,0xAE147AE1, 0x3FDC4122,0xA59E105C,
	0x3FF8E560,0x4189374C, 0x3FDC4BAB,0x14E53D91,
	0x3FF8E978,0xD4FDF3B6, 0x3FDC5631,0xC8AFC6BA,
	0x3FF8ED91,0x6872B021, 0x3FDC60B6,0xC18F75AC,
	0x3FF8F1A9,0xFBE76C8B, 0x3FDC6B3A,0x0015CC5A,
	0x3FF8F5C2,0x8F5C28F6, 0x3FDC75BB,0x84D40518,
	0x3FF8F9DB,0x22D0E560, 0x3FDC803B,0x505B12B7,
	0x3FF8FDF3,0xB645A1CB, 0x3FDC8AB9,0x633BA0C8,
	0x3FF9020C,0x49BA5E35, 0x3FDC9535,0xBE0613B6,
	0x3FF90624,0xDD2F1AA0, 0x3FDC9FB0,0x614A8908,
	0x3FF90A3D,0x70A3D70A, 0x3FDCAA29,0x4D98D77E,
	0x3FF90E56,0x04189375, 0x3FDCB4A0,0x83808F50,
	0x3FF9126E,0x978D4FDF, 0x3FDCBF16,0x0390FA4A,
	0x3FF91687,0x2B020C4A, 0x3FDCC989,0xCE591C0F,
	0x3FF91A9F,0xBE76C8B4, 0x3FDCD3FB,0xE467B230,
	0x3FF91EB8,0x51EB851F, 0x3FDCDE6C,0x464B346F,
	0x3FF922D0,0xE5604189, 0x3FDCE8DA,0xF491D4DA,
	0x3FF926E9,0x78D4FDF4, 0x3FDCF347,0xEFC9800A,
	0x3FF92B02,0x0C49BA5E, 0x3FDCFDB3,0x387FDD3F,
	0x3FF92F1A,0x9FBE76C9, 0x3FDD081C,0xCF424E9D,
	0x3FF93333,0x33333333, 0x3FDD1284,0xB49DF149,
	0x3FF9374B,0xC6A7EF9E, 0x3FDD1CEA,0xE91F9DA8,
	0x3FF93B64,0x5A1CAC08, 0x3FDD274F,0x6D53E779,
	0x3FF93F7C,0xED916873, 0x3FDD31B2,0x41C71E12,
	0x3FF94395,0x810624DD, 0x3FDD3C13,0x67054C7E,
	0x3FF947AE,0x147AE148, 0x3FDD4672,0xDD9A39B7,
	0x3FF94BC6,0xA7EF9DB2, 0x3FDD50D0,0xA61168C4,
	0x3FF94FDF,0x3B645A1D, 0x3FDD5B2C,0xC0F618F4,
	0x3FF953F7,0xCED91687, 0x3FDD6587,0x2ED345FA,
	0x3FF95810,0x624DD2F2, 0x3FDD6FDF,0xF033A829,
	0x3FF95C28,0xF5C28F5C, 0x3FDD7A37,0x05A1B48F,
	0x3FF96041,0x89374BC7, 0x3FDD848C,0x6FA79D31,
	0x3FF9645A,0x1CAC0831, 0x3FDD8EE0,0x2ECF5126,
	0x3FF96872,0xB020C49C, 0x3FDD9932,0x43A27CD3,
	0x3FF96C8B,0x43958106, 0x3FDDA382,0xAEAA8A04,
	0x3FF970A3,0xD70A3D71, 0x3FDDADD1,0x7070A029,
	0x3FF974BC,0x6A7EF9DB, 0x3FDDB81E,0x897DA46E,
	0x3FF978D4,0xFDF3B646, 0x3FDDC269,0xFA5A39FA,
	0x3FF97CED,0x916872B0, 0x3FDDCCB3,0xC38EC206,
	0x3FF98106,0x24DD2F1B, 0x3FDDD6FB,0xE5A35C18,
	0x3FF9851E,0xB851EB85, 0x3FDDE142,0x611FE61D,
	0x3FF98937,0x4BC6A7F0, 0x3FDDEB87,0x368BFCA5,
	0x3FF98D4F,0xDF3B645A, 0x3FDDF5CA,0x666EFAFA,
	0x3FF99168,0x72B020C5, 0x3FDE000B,0xF14FFB5C,
	0x3FF99581,0x0624DD2F, 0x3FDE0A4B,0xD7B5D71B,
	0x3FF99999,0x9999999A, 0x3FDE148A,0x1A2726CF,
	0x3FF99DB2,0x2D0E5604, 0x3FDE1EC6,0xB92A426F,
	0x3FF9A1CA,0xC083126F, 0x3FDE2901,0xB5454193,
	0x3FF9A5E3,0x53F7CED9, 0x3FDE333B,0x0EFDFB83,
	0x3FF9A9FB,0xE76C8B44, 0x3FDE3D72,0xC6DA0777,
	0x3FF9AE14,0x7AE147AE, 0x3FDE47A8,0xDD5EBCAB,
	0x3FF9B22D,0x0E560419, 0x3FDE51DD,0x5311329C,
	0x3FF9B645,0xA1CAC083, 0x3FDE5C10,0x2876411F,
	0x3FF9BA5E,0x353F7CEE, 0x3FDE6641,0x5E128098,
	0x3FF9BE76,0xC8B43958, 0x3FDE7070,0xF46A4A16,
	0x3FF9C28F,0x5C28F5C3, 0x3FDE7A9E,0xEC01B787,
	0x3FF9C6A7,0xEF9DB22D, 0x3FDE84CB,0x455CA3D2,
	0x3FF9CAC0,0x83126E98, 0x3FDE8EF6,0x00FEAB11,
	0x3FF9CED9,0x16872B02, 0x3FDE991F,0x1F6B2AA7,
	0x3FF9D2F1,0xA9FBE76D, 0x3FDEA346,0xA1254176,
	0x3FF9D70A,0x3D70A3D7, 0x3FDEAD6C,0x86AFCFFB,
	0x3FF9DB22,0xD0E56042, 0x3FDEB790,0xD08D7882,
	0x3FF9DF3B,0x645A1CAC, 0x3FDEC1B3,0x7F409F3E,
	0x3FF9E353,0xF7CED917, 0x3FDECBD4,0x934B6A83,
	0x3FF9E76C,0x8B439581, 0x3FDED5F4,0x0D2FC2D7,
	0x3FF9EB85,0x1EB851EC, 0x3FDEE011,0xED6F5331,
	0x3FF9EF9D,0xB22D0E56, 0x3FDEEA2E,0x348B890A,
	0x3FF9F3B6,0x45A1CAC1, 0x3FDEF448,0xE3059497,
	0x3FF9F7CE,0xD916872B, 0x3FDEFE61,0xF95E68DD,
	0x3FF9FBE7,0x6C8B4396, 0x3FDF0879,0x7816BBEB,
	0x3FFA0000,0x00000000, 0x3FDF128F,0x5FAF06ED,
	0x3FFA0418,0x9374BC6A, 0x3FDF1CA3,0xB0A78661,
	0x3FFA0831,0x26E978D5, 0x3FDF26B6,0x6B803A3B,
	0x3FFA0C49,0xBA5E353F, 0x3FDF30C7,0x90B8E5FF,
	0x3FFA1062,0x4DD2F1AA, 0x3FDF3AD7,0x20D110FB,
	0x3FFA147A,0xE147AE14, 0x3FDF44E5,0x1C480657,
	0x3FFA1893,0x74BC6A7F, 0x3FDF4EF1,0x839CD550,
	0x3FFA1CAC,0x083126E9, 0x3FDF58FC,0x574E514B,
	0x3FFA20C4,0x9BA5E354, 0x3FDF6305,0x97DB120B,
	0x3FFA24DD,0x2F1A9FBE, 0x3FDF6D0D,0x45C173C5,
	0x3FFA28F5,0xC28F5C29, 0x3FDF7713,0x617F9758,
	0x3FFA2D0E,0x56041893, 0x3FDF8117,0xEB936260,
	0x3FFA3126,0xE978D4FE, 0x3FDF8B1A,0xE47A7F6C,
	0x3FFA353F,0x7CED9168, 0x3FDF951C,0x4CB25E13,
	0x3FFA3958,0x10624DD3, 0x3FDF9F1C,0x24B83329,
	0x3FFA3D70,0xA3D70A3D, 0x3FDFA91A,0x6D08F8D1,
	0x3FFA4189,0x374BC6A8, 0x3FDFB317,0x26216EB8,
	0x3FFA45A1,0xCAC08312, 0x3FDFBD12,0x507E1A21,
	0x3FFA49BA,0x5E353F7D, 0x3FDFC70B,0xEC9B4621,
	0x3FFA4DD2,0xF1A9FBE7, 0x3FDFD103,0xFAF503AF,
	0x3FFA51EB,0x851EB852, 0x3FDFDAFA,0x7C0729DA,
	0x3FFA5604,0x189374BC, 0x3FDFE4EF,0x704D55DA,
	0x3FFA5A1C,0xAC083127, 0x3FDFEEE2,0xD842EB49,
	0x3FFA5E35,0x3F7CED91, 0x3FDFF8D4,0xB4631433,
	0x3FFA624D,0xD2F1A9FC, 0x3FE00162,0x829460A5,
	0x3FFA6666,0x66666666, 0x3FE00659,0xE58754FE,
	0x3FFA6A7E,0xF9DB22D1, 0x3FE00B50,0x8347A653,
	0x3FFA6E97,0x8D4FDF3B, 0x3FE01046,0x5C127750,
	0x3FFA72B0,0x20C49BA6, 0x3FE0153B,0x7024CE40,
	0x3FFA76C8,0xB4395810, 0x3FE01A2F,0xBFBB950E,
	0x3FFA7AE1,0x47AE147B, 0x3FE01F23,0x4B139965,
	0x3FFA7EF9,0xDB22D0E5, 0x3FE02416,0x12698CB6,
	0x3FFA8312,0x6E978D50, 0x3FE02908,0x15FA0451,
	0x3FFA872B,0x020C49BA, 0x3FE02DF9,0x56017973,
	0x3FFA8B43,0x95810625, 0x3FE032E9,0xD2BC495A,
	0x3FFA8F5C,0x28F5C28F, 0x3FE037D9,0x8C66B550,
	0x3FFA9374,0xBC6A7EFA, 0x3FE03CC8,0x833CE2C5,
	0x3FFA978D,0x4FDF3B64, 0x3FE041B6,0xB77ADB5A,
	0x3FFA9BA5,0xE353F7CF, 0x3FE046A4,0x295C8CF4,
	0x3FFA9FBE,0x76C8B439, 0x3FE04B90,0xD91DC9CC,
	0x3FFAA3D7,0x0A3D70A4, 0x3FE0507C,0xC6FA4884,
	0x3FFAA7EF,0x9DB22D0E, 0x3FE05567,0xF32DA431,
	0x3FFAAC08,0x3126E979, 0x3FE05A52,0x5DF35C75,
	0x3FFAB020,0xC49BA5E3, 0x3FE05F3C,0x0786D583,
	0x3FFAB439,0x5810624E, 0x3FE06424,0xF0235842,
	0x3FFAB851,0xEB851EB8, 0x3FE0690D,0x18041249,
	0x3FFABC6A,0x7EF9DB23, 0x3FE06DF4,0x7F641601,
	0x3FFAC083,0x126E978D, 0x3FE072DB,0x267E5AAC,
	0x3FFAC49B,0xA5E353F8, 0x3FE077C1,0x0D8DBC7A,
	0x3FFAC8B4,0x39581062, 0x3FE07CA6,0x34CCFC94,
	0x3FFACCCC,0xCCCCCCCD, 0x3FE0818A,0x9C76C137,
	0x3FFAD0E5,0x60418937, 0x3FE0866E,0x44C595B7,
	0x3FFAD4FD,0xF3B645A2, 0x3FE08B51,0x2DF3EA9C,
	0x3FFAD916,0x872B020C, 0x3FE09033,0x583C15A7,
	0x3FFADD2F,0x1A9FBE77, 0x3FE09514,0xC3D851F0,
	0x3FFAE147,0xAE147AE1, 0x3FE099F5,0x7102BFE5,
	0x3FFAE560,0x4189374C, 0x3FE09ED5,0x5FF5656B,
	0x3FFAE978,0xD4FDF3B6, 0x3FE0A3B4,0x90EA2DE3,
	0x3FFAED91,0x6872B021, 0x3FE0A893,0x041AEA3F,
	0x3FFAF1A9,0xFBE76C8B, 0x3FE0AD70,0xB9C1510F,
	0x3FFAF5C2,0x8F5C28F6, 0x3FE0B24D,0xB216FE96,
	0x3FFAF9DB,0x22D0E560, 0x3FE0B729,0xED5574D5,
	0x3FFAFDF3,0xB645A1CB, 0x3FE0BC05,0x6BB61B9F,
	0x3FFB020C,0x49BA5E35, 0x3FE0C0E0,0x2D7240A2,
	0x3FFB0624,0xDD2F1AA0, 0x3FE0C5BA,0x32C31782,
	0x3FFB0A3D,0x70A3D70A, 0x3FE0CA93,0x7BE1B9DC,
	0x3FFB0E56,0x04189375, 0x3FE0CF6C,0x09072762,
	0x3FFB126E,0x978D4FDF, 0x3FE0D443,0xDA6C45E0,
	0x3FFB1687,0x2B020C4A, 0x3FE0D91A,0xF049E155,
	0x3FFB1A9F,0xBE76C8B4, 0x3FE0DDF1,0x4AD8ABF9,
	0x3FFB1EB8,0x51EB851F, 0x3FE0E2C6,0xEA513E58,
	0x3FFB22D0,0xE5604189, 0x3FE0E79B,0xCEEC1754,
	0x3FFB26E9,0x78D4FDF4, 0x3FE0EC6F,0xF8E19C44,
	0x3FFB2B02,0x0C49BA5E, 0x3FE0F143,0x686A18F1,
	0x3FFB2F1A,0x9FBE76C9, 0x3FE0F616,0x1DBDBFBA,
	0x3FFB3333,0x33333333, 0x3FE0FAE8,0x1914A991,
	0x3FFB374B,0xC6A7EF9E, 0x3FE0FFB9,0x5AA6D617,
	0x3FFB3B64,0x5A1CAC08, 0x3FE10489,0xE2AC2BA2,
	0x3FFB3F7C,0xED916873, 0x3FE10959,0xB15C7756,
	0x3FFB4395,0x810624DD, 0x3FE10E28,0xC6EF6D28,
	0x3FFB47AE,0x147AE148, 0x3FE112F7,0x239CA7FC,
	0x3FFB4BC6,0xA7EF9DB2, 0x3FE117C4,0xC79BA9A3,
	0x3FFB4FDF,0x3B645A1D, 0x3FE11C91,0xB323DAFC,
	0x3FFB53F7,0xCED91687, 0x3FE1215D,0xE66C8BF2,
	0x3FFB5810,0x624DD2F2, 0x3FE12629,0x61ACF398,
	0x3FFB5C28,0xF5C28F5C, 0x3FE12AF4,0x251C3030,
	0x3FFB6041,0x89374BC7, 0x3FE12FBE,0x30F1473F,
	0x3FFB645A,0x1CAC0831, 0x3FE13487,0x85632596,
	0x3FFB6872,0xB020C49C, 0x3FE13950,0x22A89F69,
	0x3FFB6C8B,0x43958106, 0x3FE13E18,0x08F87053,
	0x3FFB70A3,0xD70A3D71, 0x3FE142DF,0x38893B71,
	0x3FFB74BC,0x6A7EF9DB, 0x3FE147A5,0xB1918B64,
	0x3FFB78D4,0xFDF3B646, 0x3FE14C6B,0x7447D26B,
	0x3FFB7CED,0x916872B0, 0x3FE15130,0x80E26A69,
	0x3FFB8106,0x24DD2F1B, 0x3FE155F4,0xD79794F9,
	0x3FFB851E,0xB851EB85, 0x3FE15AB8,0x789D7B77,
	0x3FFB8937,0x4BC6A7F0, 0x3FE15F7B,0x642A2F16,
	0x3FFB8D4F,0xDF3B645A, 0x3FE1643D,0x9A73A8E7,
	0x3FFB9168,0x72B020C5, 0x3FE168FF,0x1BAFC9EE,
	0x3FFB9581,0x0624DD2F, 0x3FE16DBF,0xE8145B28,
	0x3FFB9999,0x9999999A, 0x3FE1727F,0xFFD70DA1,
	0x3FFB9DB2,0x2D0E5604, 0x3FE1773F,0x632D7A7F,
	0x3FFBA1CA,0xC083126F, 0x3FE17BFE,0x124D2310,
	0x3FFBA5E3,0x53F7CED9, 0x3FE180BC,0x0D6B70D9,
	0x3FFBA9FB,0xE76C8B44, 0x3FE18579,0x54BDB5A3,
	0x3FFBAE14,0x7AE147AE, 0x3FE18A35,0xE8792B89,
	0x3FFBB22D,0x0E560419, 0x3FE18EF1,0xC8D2F509,
	0x3FFBB645,0xA1CAC083, 0x3FE193AC,0xF6001D0E,
	0x3FFBBA5E,0x353F7CEE, 0x3FE19867,0x70359700,
	0x3FFBBE76,0xC8B43958, 0x3FE19D21,0x37A83ED1,
	0x3FFBC28F,0x5C28F5C3, 0x3FE1A1DA,0x4C8CD90C,
	0x3FFBC6A7,0xEF9DB22D, 0x3FE1A692,0xAF1812E2,
	0x3FFBCAC0,0x83126E98, 0x3FE1AB4A,0x5F7E8238,
	0x3FFBCED9,0x16872B02, 0x3FE1B001,0x5DF4A5B4,
	0x3FFBD2F1,0xA9FBE76D, 0x3FE1B4B7,0xAAAEE4CD,
	0x3FFBD70A,0x3D70A3D7, 0x3FE1B96D,0x45E18FD3,
	0x3FFBDB22,0xD0E56042, 0x3FE1BE22,0x2FC0E007,
	0x3FFBDF3B,0x645A1CAC, 0x3FE1C2D6,0x6880F79C,
	0x3FFBE353,0xF7CED917, 0x3FE1C789,0xF055E1CF,
	0x3FFBE76C,0x8B439581, 0x3FE1CC3C,0xC77392ED,
	0x3FFBEB85,0x1EB851EC, 0x3FE1D0EE,0xEE0DE867,
	0x3FFBEF9D,0xB22D0E56, 0x3FE1D5A0,0x6458A8D7,
	0x3FFBF3B6,0x45A1CAC1, 0x3FE1DA51,0x2A87841A,
	0x3FFBF7CE,0xD916872B, 0x3FE1DF01,0x40CE134E,
	0x3FFBFBE7,0x6C8B4396, 0x3FE1E3B0,0xA75FD8ED,
	0x3FFC0000,0x00000000, 0x3FE1E85F,0x5E7040D0,
	0x3FFC0418,0x9374BC6A, 0x3FE1ED0D,0x6632A044,
	0x3FFC0831,0x26E978D5, 0x3FE1F1BA,0xBEDA3612,
	0x3FFC0C49,0xBA5E353F, 0x3FE1F667,0x689A2A8E,
	0x3FFC1062,0x4DD2F1AA, 0x3FE1FB13,0x63A58FA5,
	0x3FFC147A,0xE147AE14, 0x3FE1FFBE,0xB02F60E8,
	0x3FFC1893,0x74BC6A7F, 0x3FE20469,0x4E6A839B,
	0x3FFC1CAC,0x083126E9, 0x3FE20913,0x3E89C6C0,
	0x3FFC20C4,0x9BA5E354, 0x3FE20DBC,0x80BFE327,
	0x3FFC24DD,0x2F1A9FBE, 0x3FE21265,0x153F7B77,
	0x3FFC28F5,0xC28F5C29, 0x3FE2170C,0xFC3B1C40,
	0x3FFC2D0E,0x56041893, 0x3FE21BB4,0x35E53C00,
	0x3FFC3126,0xE978D4FE, 0x3FE2205A,0xC2703B3A,
	0x3FFC353F,0x7CED9168, 0x3FE22500,0xA20E6478,
	0x3FFC3958,0x10624DD3, 0x3FE229A5,0xD4F1EC64,
	0x3FFC3D70,0xA3D70A3D, 0x3FE22E4A,0x5B4CF1C6,
	0x3FFC4189,0x374BC6A8, 0x3FE232EE,0x35517DA0,
	0x3FFC45A1,0xCAC08312, 0x3FE23791,0x6331832C,
	0x3FFC49BA,0x5E353F7D, 0x3FE23C33,0xE51EDFF7,
	0x3FFC4DD2,0xF1A9FBE7, 0x3FE240D5,0xBB4B5BDF,
	0x3FFC51EB,0x851EB852, 0x3FE24576,0xE5E8A92F,
	0x3FFC5604,0x189374BC, 0x3FE24A17,0x6528649B,
	0x3FFC5A1C,0xAC083127, 0x3FE24EB7,0x393C155C,
	0x3FFC5E35,0x3F7CED91, 0x3FE25356,0x62552D30,
	0x3FFC624D,0xD2F1A9FC, 0x3FE257F4,0xE0A50870,
	0x3FFC6666,0x66666666, 0x3FE25C92,0xB45CEE13,
	0x3FFC6A7E,0xF9DB22D1, 0x3FE2612F,0xDDAE0FC5,
	0x3FFC6E97,0x8D4FDF3B, 0x3FE265CC,0x5CC989E8,
	0x3FFC72B0,0x20C49BA6, 0x3FE26A68,0x31E063AD,
	0x3FFC76C8,0xB4395810, 0x3FE26F03,0x5D238F10,
	0x3FFC7AE1,0x47AE147B, 0x3FE2739D,0xDEC3E8F5,
	0x3FFC7EF9,0xDB22D0E5, 0x3FE27837,0xB6F23928,
	0x3FFC8312,0x6E978D50, 0x3FE27CD0,0xE5DF3271,
	0x3FFC872B,0x020C49BA, 0x3FE28169,0x6BBB7298,
	0x3FFC8B43,0x95810625, 0x3FE28601,0x48B7827B,
	0x3FFC8F5C,0x28F5C28F, 0x3FE28A98,0x7D03D60F,
	0x3FFC9374,0xBC6A7EFA, 0x3FE28F2F,0x08D0CC78,
	0x3FFC978D,0x4FDF3B64, 0x3FE293C4,0xEC4EB009,
	0x3FFC9BA5,0xE353F7CF, 0x3FE2985A,0x27ADB659,
	0x3FFC9FBE,0x76C8B439, 0x3FE29CEE,0xBB1E0049,
	0x3FFCA3D7,0x0A3D70A4, 0x3FE2A182,0xA6CF9A15,
	0x3FFCA7EF,0x9DB22D0E, 0x3FE2A615,0xEAF27B59,
	0x3FFCAC08,0x3126E979, 0x3FE2AAA8,0x87B68726,
	0x3FFCB020,0xC49BA5E3, 0x3FE2AF3A,0x7D4B8C04,
	0x3FFCB439,0x5810624E, 0x3FE2B3CB,0xCBE14407,
	0x3FFCB851,0xEB851EB8, 0x3FE2B85C,0x73A754CF,
	0x3FFCBC6A,0x7EF9DB23, 0x3FE2BCEC,0x74CD4FA2,
	0x3FFCC083,0x126E978D, 0x3FE2C17B,0xCF82B16C,
	0x3FFCC49B,0xA5E353F8, 0x3FE2C60A,0x83F6E2D0,
	0x3FFCC8B4,0x39581062, 0x3FE2CA98,0x92593832,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FE2CF25,0xFAD8F1C4,
	0x3FFCD0E5,0x60418937, 0x3FE2D3B2,0xBDA53B8E,
	0x3FFCD4FD,0xF3B645A2, 0x3FE2D83E,0xDAED2D7F,
	0x3FFCD916,0x872B020C, 0x3FE2DCCA,0x52DFCB73,
	0x3FFCDD2F,0x1A9FBE77, 0x3FE2E155,0x25AC0542,
	0x3FFCE147,0xAE147AE1, 0x3FE2E5DF,0x5380B6C8,
	0x3FFCE560,0x4189374C, 0x3FE2EA68,0xDC8CA7F6,
	0x3FFCE978,0xD4FDF3B6, 0x3FE2EEF1,0xC0FE8CD4,
	0x3FFCED91,0x6872B021, 0x3FE2F37A,0x01050599,
	0x3FFCF1A9,0xFBE76C8B, 0x3FE2F801,0x9CCE9EA8,
	0x3FFCF5C2,0x8F5C28F6, 0x3FE2FC88,0x9489D0A9,
	0x3FFCF9DB,0x22D0E560, 0x3FE3010E,0xE8650088,
	0x3FFCFDF3,0xB645A1CB, 0x3FE30594,0x988E7F8A,
	0x3FFD020C,0x49BA5E35, 0x3FE30A19,0xA5348B50,
	0x3FFD0624,0xDD2F1AA0, 0x3FE30E9E,0x0E854DE9,
	0x3FFD0A3D,0x70A3D70A, 0x3FE31321,0xD4AEDDD7,
	0x3FFD0E56,0x04189375, 0x3FE317A4,0xF7DF3E21,
	0x3FFD126E,0x978D4FDF, 0x3FE31C27,0x78445E56,
	0x3FFD1687,0x2B020C4A, 0x3FE320A9,0x560C1A9E,
	0x3FFD1A9F,0xBE76C8B4, 0x3FE3252A,0x91643BC0,
	0x3FFD1EB8,0x51EB851F, 0x3FE329AB,0x2A7A7736,
	0x3FFD22D0,0xE5604189, 0x3FE32E2B,0x217C6F2A,
	0x3FFD26E9,0x78D4FDF4, 0x3FE332AA,0x7697B28E,
	0x3FFD2B02,0x0C49BA5E, 0x3FE33729,0x29F9BD1E,
	0x3FFD2F1A,0x9FBE76C9, 0x3FE33BA7,0x3BCFF771,
	0x3FFD3333,0x33333333, 0x3FE34024,0xAC47B6FD,
	0x3FFD374B,0xC6A7EF9E, 0x3FE344A1,0x7B8E3E29,
	0x3FFD3B64,0x5A1CAC08, 0x3FE3491D,0xA9D0BC52,
	0x3FFD3F7C,0xED916873, 0x3FE34D99,0x373C4DD9,
	0x3FFD4395,0x810624DD, 0x3FE35214,0x23FDFC2B,
	0x3FFD47AE,0x147AE148, 0x3FE3568E,0x7042BDD0,
	0x3FFD4BC6,0xA7EF9DB2, 0x3FE35B08,0x1C377670,
	0x3FFD4FDF,0x3B645A1D, 0x3FE35F81,0x2808F6E1,
	0x3FFD53F7,0xCED91687, 0x3FE363F9,0x93E3FD30,
	0x3FFD5810,0x624DD2F2, 0x3FE36871,0x5FF534AF,
	0x3FFD5C28,0xF5C28F5C, 0x3FE36CE8,0x8C6935F9,
	0x3FFD6041,0x89374BC7, 0x3FE3715F,0x196C8703,
	0x3FFD645A,0x1CAC0831, 0x3FE375D5,0x072B9B22,
	0x3FFD6872,0xB020C49C, 0x3FE37A4A,0x55D2D317,
	0x3FFD6C8B,0x43958106, 0x3FE37EBF,0x058E7D19,
	0x3FFD70A3,0xD70A3D71, 0x3FE38333,0x168AD4E2,
	0x3FFD74BC,0x6A7EF9DB, 0x3FE387A6,0x88F403B3,
	0x3FFD78D4,0xFDF3B646, 0x3FE38C19,0x5CF62066,
	0x3FFD7CED,0x916872B0, 0x3FE3908B,0x92BD2F70,
	0x3FFD8106,0x24DD2F1B, 0x3FE394FD,0x2A7522F4,
	0x3FFD851E,0xB851EB85, 0x3FE3996E,0x2449DAC6,
	0x3FFD8937,0x4BC6A7F0, 0x3FE39DDE,0x80672479,
	0x3FFD8D4F,0xDF3B645A, 0x3FE3A24E,0x3EF8BB67,
	0x3FFD9168,0x72B020C5, 0x3FE3A6BD,0x602A48BF,
	0x3FFD9581,0x0624DD2F, 0x3FE3AB2B,0xE4276386,
	0x3FFD9999,0x9999999A, 0x3FE3AF99,0xCB1B90B0,
	0x3FFD9DB2,0x2D0E5604, 0x3FE3B407,0x15324319,
	0x3FFDA1CA,0xC083126F, 0x3FE3B873,0xC296DB9D,
	0x3FFDA5E3,0x53F7CED9, 0x3FE3BCDF,0xD374A917,
	0x3FFDA9FB,0xE76C8B44, 0x3FE3C14B,0x47F6E877,
	0x3FFDAE14,0x7AE147AE, 0x3FE3C5B6,0x2048C4BE,
	0x3FFDB22D,0x0E560419, 0x3FE3CA20,0x5C955715,
	0x3FFDB645,0xA1CAC083, 0x3FE3CE89,0xFD07A6CA,
	0x3FFDBA5E,0x353F7CEE, 0x3FE3D2F3,0x01CAA969,
	0x3FFDBE76,0xC8B43958, 0x3FE3D75B,0x6B0942B5,
	0x3FFDC28F,0x5C28F5C3, 0x3FE3DBC3,0x38EE44C1,
	0x3FFDC6A7,0xEF9DB22D, 0x3FE3E02A,0x6BA46FED,
	0x3FFDCAC0,0x83126E98, 0x3FE3E491,0x035672FD,
	0x3FFDCED9,0x16872B02, 0x3FE3E8F7,0x002EEB13,
	0x3FFDD2F1,0xA9FBE76D, 0x3FE3ED5C,0x625863C8,
	0x3FFDD70A,0x3D70A3D7, 0x3FE3F1C1,0x29FD5729,
	0x3FFDDB22,0xD0E56042, 0x3FE3F625,0x57482DCD,
	0x3FFDDF3B,0x645A1CAC, 0x3FE3FA88,0xEA633ED0,
	0x3FFDE353,0xF7CED917, 0x3FE3FEEB,0xE378CFEB,
	0x3FFDE76C,0x8B439581, 0x3FE4034E,0x42B31573,
	0x3FFDEB85,0x1EB851EC, 0x3FE407B0,0x083C326B,
	0x3FFDEF9D,0xB22D0E56, 0x3FE40C11,0x343E3881,
	0x3FFDF3B6,0x45A1CAC1, 0x3FE41071,0xC6E3282A,
	0x3FFDF7CE,0xD916872B, 0x3FE414D1,0xC054F096,
	0x3FFDFBE7,0x6C8B4396, 0x3FE41931,0x20BD6FCF,
	0x3FFE0000,0x00000000, 0x3FE41D8F,0xE84672AE,
	0x3FFE0418,0x9374BC6A, 0x3FE421EE,0x1719B4F5,
	0x3FFE0831,0x26E978D5, 0x3FE4264B,0xAD60E150,
	0x3FFE0C49,0xBA5E353F, 0x3FE42AA8,0xAB45915C,
	0x3FFE1062,0x4DD2F1AA, 0x3FE42F05,0x10F14DBA,
	0x3FFE147A,0xE147AE14, 0x3FE43360,0xDE8D8E0B,
	0x3FFE1893,0x74BC6A7F, 0x3FE437BC,0x1443B909,
	0x3FFE1CAC,0x083126E9, 0x3FE43C16,0xB23D2480,
	0x3FFE20C4,0x9BA5E354, 0x3FE44070,0xB8A31565,
	0x3FFE24DD,0x2F1A9FBE, 0x3FE444CA,0x279EBFD4,
	0x3FFE28F5,0xC28F5C29, 0x3FE44922,0xFF594724,
	0x3FFE2D0E,0x56041893, 0x3FE44D7B,0x3FFBBDE3,
	0x3FFE3126,0xE978D4FE, 0x3FE451D2,0xE9AF25EF,
	0x3FFE353F,0x7CED9168, 0x3FE45629,0xFC9C706F,
	0x3FFE3958,0x10624DD3, 0x3FE45A80,0x78EC7DE9,
	0x3FFE3D70,0xA3D70A3D, 0x3FE45ED6,0x5EC81E42,
	0x3FFE4189,0x374BC6A8, 0x3FE4632B,0xAE5810CD,
	0x3FFE45A1,0xCAC08312, 0x3FE46780,0x67C5044F,
	0x3FFE49BA,0x5E353F7D, 0x3FE46BD4,0x8B37970F,
	0x3FFE4DD2,0xF1A9FBE7, 0x3FE47028,0x18D856D5,
	0x3FFE51EB,0x851EB852, 0x3FE4747B,0x10CFC0FD,
	0x3FFE5604,0x189374BC, 0x3FE478CD,0x73464278,
	0x3FFE5A1C,0xAC083127, 0x3FE47D1F,0x406437DB,
	0x3FFE5E35,0x3F7CED91, 0x3FE48170,0x7851ED62,
	0x3FFE624D,0xD2F1A9FC, 0x3FE485C1,0x1B379EFF,
	0x3FFE6666,0x66666666, 0x3FE48A11,0x293D785B,
	0x3FFE6A7E,0xF9DB22D1, 0x3FE48E60,0xA28B94EA,
	0x3FFE6E97,0x8D4FDF3B, 0x3FE492AF,0x8749FFE5,
	0x3FFE72B0,0x20C49BA6, 0x3FE496FD,0xD7A0B462,
	0x3FFE76C8,0xB4395810, 0x3FE49B4B,0x93B79D50,
	0x3FFE7AE1,0x47AE147B, 0x3FE49F98,0xBBB6958B,
	0x3FFE7EF9,0xDB22D0E5, 0x3FE4A3E5,0x4FC567D8,
	0x3FFE8312,0x6E978D50, 0x3FE4A831,0x500BCEFA,
	0x3FFE872B,0x020C49BA, 0x3FE4AC7C,0xBCB175B1,
	0x3FFE8B43,0x95810625, 0x3FE4B0C7,0x95DDF6CB,
	0x3FFE8F5C,0x28F5C28F, 0x3FE4B511,0xDBB8DD23,
	0x3FFE9374,0xBC6A7EFA, 0x3FE4B95B,0x8E69A3B4,
	0x3FFE978D,0x4FDF3B64, 0x3FE4BDA4,0xAE17B598,
	0x3FFE9BA5,0xE353F7CF, 0x3FE4C1ED,0x3AEA6E17,
	0x3FFE9FBE,0x76C8B439, 0x3FE4C635,0x350918AC,
	0x3FFEA3D7,0x0A3D70A4, 0x3FE4CA7C,0x9C9AF110,
	0x3FFEA7EF,0x9DB22D0E, 0x3FE4CEC3,0x71C7233F,
	0x3FFEAC08,0x3126E979, 0x3FE4D309,0xB4B4CB85,
	0x3FFEB020,0xC49BA5E3, 0x3FE4D74F,0x658AF682,
	0x3FFEB439,0x5810624E, 0x3FE4DB94,0x8470A136,
	0x3FFEB851,0xEB851EB8, 0x3FE4DFD9,0x118CB904,
	0x3FFEBC6A,0x7EF9DB23, 0x3FE4E41D,0x0D061BC3,
	0x3FFEC083,0x126E978D, 0x3FE4E860,0x770397BC,
	0x3FFEC49B,0xA5E353F8, 0x3FE4ECA3,0x4FABEBBD,
	0x3FFEC8B4,0x39581062, 0x3FE4F0E5,0x9725C715,
	0x3FFECCCC,0xCCCCCCCD, 0x3FE4F527,0x4D97C9A9,
	0x3FFED0E5,0x60418937, 0x3FE4F968,0x732883F3,
	0x3FFED4FD,0xF3B645A2, 0x3FE4FDA9,0x07FE770E,
	0x3FFED916,0x872B020C, 0x3FE501E9,0x0C4014BD,
	0x3FFEDD2F,0x1A9FBE77, 0x3FE50628,0x8013BF76,
	0x3FFEE147,0xAE147AE1, 0x3FE50A67,0x639FCA63,
	0x3FFEE560,0x4189374C, 0x3FE50EA5,0xB70A7975,
	0x3FFEE978,0xD4FDF3B6, 0x3FE512E3,0x7A7A0160,
	0x3FFEED91,0x6872B021, 0x3FE51720,0xAE1487AE,
	0x3FFEF1A9,0xFBE76C8B, 0x3FE51B5D,0x520022BE,
	0x3FFEF5C2,0x8F5C28F6, 0x3FE51F99,0x6662D9D4,
	0x3FFEF9DB,0x22D0E560, 0x3FE523D4,0xEB62A518,
	0x3FFEFDF3,0xB645A1CB, 0x3FE5280F,0xE1256DAA,
	0x3FFF020C,0x49BA5E35, 0x3FE52C4A,0x47D10D9B,
	0x3FFF0624,0xDD2F1AA0, 0x3FE53084,0x1F8B5004,
	0x3FFF0A3D,0x70A3D70A, 0x3FE534BD,0x6879F103,
	0x3FFF0E56,0x04189375, 0x3FE538F6,0x22C29DC8,
	0x3FFF126E,0x978D4FDF, 0x3FE53D2E,0x4E8AF49A,
	0x3FFF1687,0x2B020C4A, 0x3FE54165,0xEBF884E4,
	0x3FFF1A9F,0xBE76C8B4, 0x3FE5459C,0xFB30CF35,
	0x3FFF1EB8,0x51EB851F, 0x3FE549D3,0x7C594551,
	0x3FFF22D0,0xE5604189, 0x3FE54E09,0x6F974A2E,
	0x3FFF26E9,0x78D4FDF4, 0x3FE5523E,0xD5103208,
	0x3FFF2B02,0x0C49BA5E, 0x3FE55673,0xACE9425D,
	0x3FFF2F1A,0x9FBE76C9, 0x3FE55AA7,0xF747B200,
	0x3FFF3333,0x33333333, 0x3FE55EDB,0xB450A914,
	0x3FFF374B,0xC6A7EF9E, 0x3FE5630E,0xE4294121,
	0x3FFF3B64,0x5A1CAC08, 0x3FE56741,0x86F68511,
	0x3FFF3F7C,0xED916873, 0x3FE56B73,0x9CDD713F,
	0x3FFF4395,0x810624DD, 0x3FE56FA5,0x2602F379,
	0x3FFF47AE,0x147AE148, 0x3FE573D6,0x228BEB0C,
	0x3FFF4BC6,0xA7EF9DB2, 0x3FE57806,0x929D28C9,
	0x3FFF4FDF,0x3B645A1D, 0x3FE57C36,0x765B6F0F,
	0x3FFF53F7,0xCED91687, 0x3FE58065,0xCDEB71CE,
	0x3FFF5810,0x624DD2F2, 0x3FE58494,0x9971D694,
	0x3FFF5C28,0xF5C28F5C, 0x3FE588C2,0xD913348F,
	0x3FFF6041,0x89374BC7, 0x3FE58CF0,0x8CF4149E,
	0x3FFF645A,0x1CAC0831, 0x3FE5911D,0xB538F14A,
	0x3FFF6872,0xB020C49C, 0x3FE5954A,0x520636DB,
	0x3FFF6C8B,0x43958106, 0x3FE59976,0x63804356,
	0x3FFF70A3,0xD70A3D71, 0x3FE59DA1,0xE9CB668E,
	0x3FFF74BC,0x6A7EF9DB, 0x3FE5A1CC,0xE50BE21E,
	0x3FFF78D4,0xFDF3B646, 0x3FE5A5F7,0x5565E980,
	0x3FFF7CED,0x916872B0, 0x3FE5AA21,0x3AFDA206,
	0x3FFF8106,0x24DD2F1B, 0x3FE5AE4A,0x95F722EE,
	0x3FFF851E,0xB851EB85, 0x3FE5B273,0x6676755C,
	0x3FFF8937,0x4BC6A7F0, 0x3FE5B69B,0xAC9F946F,
	0x3FFF8D4F,0xDF3B645A, 0x3FE5BAC3,0x68966D3E,
	0x3FFF9168,0x72B020C5, 0x3FE5BEEA,0x9A7EDEE6,
	0x3FFF9581,0x0624DD2F, 0x3FE5C311,0x427CBA8A,
	0x3FFF9999,0x9999999A, 0x3FE5C737,0x60B3C364,
	0x3FFF9DB2,0x2D0E5604, 0x3FE5CB5C,0xF547AEC1,
	0x3FFFA1CA,0xC083126F, 0x3FE5CF82,0x005C2414,
	0x3FFFA5E3,0x53F7CED9, 0x3FE5D3A6,0x8214BCF1,
	0x3FFFA9FB,0xE76C8B44, 0x3FE5D7CA,0x7A950521,
	0x3FFFAE14,0x7AE147AE, 0x3FE5DBED,0xEA007A9C,
	0x3FFFB22D,0x0E560419, 0x3FE5E010,0xD07A8D9C,
	0x3FFFB645,0xA1CAC083, 0x3FE5E433,0x2E26A09A,
	0x3FFFBA5E,0x353F7CEE, 0x3FE5E855,0x0328085F,
	0x3FFFBE76,0xC8B43958, 0x3FE5EC76,0x4FA20C01,
	0x3FFFC28F,0x5C28F5C3, 0x3FE5F097,0x13B7E4F2,
	0x3FFFC6A7,0xEF9DB22D, 0x3FE5F4B7,0x4F8CBF02,
	0x3FFFCAC0,0x83126E98, 0x3FE5F8D7,0x0343B86C,
	0x3FFFCED9,0x16872B02, 0x3FE5FCF6,0x2EFFE1D3,
	0x3FFFD2F1,0xA9FBE76D, 0x3FE60114,0xD2E43E54,
	0x3FFFD70A,0x3D70A3D7, 0x3FE60532,0xEF13C385,
	0x3FFFDB22,0xD0E56042, 0x3FE60950,0x83B15982,
	0x3FFFDF3B,0x645A1CAC, 0x3FE60D6D,0x90DFDAEE,
	0x3FFFE353,0xF7CED917, 0x3FE6118A,0x16C214FE,
	0x3FFFE76C,0x8B439581, 0x3FE615A6,0x157AC77E,
	0x3FFFEB85,0x1EB851EC, 0x3FE619C1,0x8D2CA4DB,
	0x3FFFEF9D,0xB22D0E56, 0x3FE61DDC,0x7DFA5223,
	0x3FFFF3B6,0x45A1CAC1, 0x3FE621F6,0xE8066716,
	0x3FFFF7CE,0xD916872B, 0x3FE62610,0xCB736E21,
	0x3FFFFBE7,0x6C8B4396, 0x3FE62A2A,0x2863E472,
	0x40000000,0x00000000, 0x3FE62E42,0xFEFA39EF,
	0x4000020C,0x49BA5E35, 0x3FE6325B,0x4F58D14E,
	0x40000418,0x9374BC6A, 0x3FE63673,0x19A2000E,
	0x40000624,0xDD2F1AA0, 0x3FE63A8A,0x5DF80E87,
	0x40000831,0x26E978D5, 0x3FE63EA1,0x1C7D37E6,
	0x40000A3D,0x70A3D70A, 0x3FE642B7,0x5553AA43,
	0x40000C49,0xBA5E353F, 0x3FE646CD,0x089D8699,
	0x40000E56,0x04189375, 0x3FE64AE2,0x367CE0D8,
	0x40001062,0x4DD2F1AA, 0x3FE64EF6,0xDF13BFDF,
	0x4000126E,0x978D4FDF, 0x3FE6530B,0x02841D91,
	0x4000147A,0xE147AE14, 0x3FE6571E,0xA0EFE6D3,
	0x40001687,0x2B020C4A, 0x3FE65B31,0xBA78FB95,
	0x40001893,0x74BC6A7F, 0x3FE65F44,0x4F412ED4,
	0x40001A9F,0xBE76C8B4, 0x3FE66356,0x5F6A46A9,
	0x40001CAC,0x083126E9, 0x3FE66767,0xEB15FC49,
	0x40001EB8,0x51EB851F, 0x3FE66B78,0xF265FC11,
	0x400020C4,0x9BA5E354, 0x3FE66F89,0x757BE583,
	0x400022D0,0xE5604189, 0x3FE67399,0x74794B58,
	0x400024DD,0x2F1A9FBE, 0x3FE677A8,0xEF7FB380,
	0x400026E9,0x78D4FDF4, 0x3FE67BB7,0xE6B0972B,
	0x400028F5,0xC28F5C29, 0x3FE67FC6,0x5A2D62C9,
	0x40002B02,0x0C49BA5E, 0x3FE683D4,0x4A17761B,
	0x40002D0E,0x56041893, 0x3FE687E1,0xB6902433,
	0x40002F1A,0x9FBE76C9, 0x3FE68BEE,0x9FB8B37C,
	0x40003126,0xE978D4FE, 0x3FE68FFB,0x05B25DBB,
	0x40003333,0x33333333, 0x3FE69406,0xE89E5020,
	0x4000353F,0x7CED9168, 0x3FE69812,0x489DAB45,
	0x4000374B,0xC6A7EF9E, 0x3FE69C1D,0x25D18338,
	0x40003958,0x10624DD3, 0x3FE6A027,0x805ADF7A,
	0x40003B64,0x5A1CAC08, 0x3FE6A431,0x585ABB0E,
	0x40003D70,0xA3D70A3D, 0x3FE6A83A,0xADF2047D,
	0x40003F7C,0xED916873, 0x3FE6AC43,0x81419DDC,
	0x40004189,0x374BC6A8, 0x3FE6B04B,0xD26A5CCC,
	0x40004395,0x810624DD, 0x3FE6B453,0xA18D0A8B,
	0x400045A1,0xCAC08312, 0x3FE6B85A,0xEECA63F4,
	0x400047AE,0x147AE148, 0x3FE6BC61,0xBA431989,
	0x400049BA,0x5E353F7D, 0x3FE6C068,0x0417CF6F,
	0x40004BC6,0xA7EF9DB2, 0x3FE6C46D,0xCC691D81,
	0x40004DD2,0xF1A9FBE7, 0x3FE6C873,0x13578F53,
	0x40004FDF,0x3B645A1D, 0x3FE6CC77,0xD903A433,
	0x400051EB,0x851EB852, 0x3FE6D07C,0x1D8DCF2F,
	0x400053F7,0xCED91687, 0x3FE6D47F,0xE1167725,
	0x40005604,0x189374BC, 0x3FE6D883,0x23BDF6BF,
	0x40005810,0x624DD2F2, 0x3FE6DC85,0xE5A49C7F,
	0x40005A1C,0xAC083127, 0x3FE6E088,0x26EAAABD,
	0x40005C28,0xF5C28F5C, 0x3FE6E489,0xE7B057B9,
	0x40005E35,0x3F7CED91, 0x3FE6E88B,0x2815CD98,
	0x40006041,0x89374BC7, 0x3FE6EC8B,0xE83B2A70,
	0x4000624D,0xD2F1A9FC, 0x3FE6F08C,0x28408045,
	0x4000645A,0x1CAC0831, 0x3FE6F48B,0xE845D51A,
	0x40006666,0x66666666, 0x3FE6F88B,0x286B22F1,
	0x40006872,0xB020C49C, 0x3FE6FC89,0xE8D057D2,
	0x40006A7E,0xF9DB22D1, 0x3FE70088,0x299555CE,
	0x40006C8B,0x43958106, 0x3FE70485,0xEAD9F30B,
	0x40006E97,0x8D4FDF3B, 0x3FE70883,0x2CBDF9C8,
	0x400070A3,0xD70A3D71, 0x3FE70C7F,0xEF612861,
	0x400072B0,0x20C49BA6, 0x3FE7107C,0x32E33151,
	0x400074BC,0x6A7EF9DB, 0x3FE71477,0xF763BB43,
	0x400076C8,0xB4395810, 0x3FE71873,0x3D02610D,
	0x400078D4,0xFDF3B646, 0x3FE71C6E,0x03DEB1C1,
	0x40007AE1,0x47AE147B, 0x3FE72068,0x4C1830A3,
	0x40007CED,0x916872B0, 0x3FE72462,0x15CE553D,
	0x40007EF9,0xDB22D0E5, 0x3FE7285B,0x61208B62,
	0x40008106,0x24DD2F1B, 0x3FE72C54,0x2E2E3330,
	0x40008312,0x6E978D50, 0x3FE7304C,0x7D16A114,
	0x4000851E,0xB851EB85, 0x3FE73444,0x4DF91DD9,
	0x4000872B,0x020C49BA, 0x3FE7383B,0xA0F4E6A4,
	0x40008937,0x4BC6A7F0, 0x3FE73C32,0x76292D03,
	0x40008B43,0x95810625, 0x3FE74028,0xCDB516E5,
	0x40008D4F,0xDF3B645A, 0x3FE7441E,0xA7B7BEB0,
	0x40008F5C,0x28F5C28F, 0x3FE74814,0x0450333E,
	0x40009168,0x72B020C5, 0x3FE74C08,0xE39D77E3,
	0x40009374,0xBC6A7EFA, 0x3FE74FFD,0x45BE846F,
	0x40009581,0x0624DD2F, 0x3FE753F1,0x2AD24540,
	0x4000978D,0x4FDF3B64, 0x3FE757E4,0x92F79B3B,
	0x40009999,0x9999999A, 0x3FE75BD7,0x7E4D5BD9,
	0x40009BA5,0xE353F7CF, 0x3FE75FC9,0xECF25127,
	0x40009DB2,0x2D0E5604, 0x3FE763BB,0xDF0539D0,
	0x40009FBE,0x76C8B439, 0x3FE767AD,0x54A4C925,
	0x4000A1CA,0xC083126F, 0x3FE76B9E,0x4DEFA71C,
	0x4000A3D7,0x0A3D70A4, 0x3FE76F8E,0xCB047055,
	0x4000A5E3,0x53F7CED9, 0x3FE7737E,0xCC01B62A,
	0x4000A7EF,0x9DB22D0E, 0x3FE7776E,0x5105FEA9,
	0x4000A9FB,0xE76C8B44, 0x3FE77B5D,0x5A2FC4A3,
	0x4000AC08,0x3126E979, 0x3FE77F4B,0xE79D77A5,
	0x4000AE14,0x7AE147AE, 0x3FE78339,0xF96D7C0C,
	0x4000B020,0xC49BA5E3, 0x3FE78727,0x8FBE2B03,
	0x4000B22D,0x0E560419, 0x3FE78B14,0xAAADD288,
	0x4000B439,0x5810624E, 0x3FE78F01,0x4A5AB571,
	0x4000B645,0xA1CAC083, 0x3FE792ED,0x6EE30B76,
	0x4000B851,0xEB851EB8, 0x3FE796D9,0x18650134,
	0x4000BA5E,0x353F7CEE, 0x3FE79AC4,0x46FEB832,
	0x4000BC6A,0x7EF9DB23, 0x3FE79EAE,0xFACE46E2,
	0x4000BE76,0xC8B43958, 0x3FE7A299,0x33F1B8B1,
	0x4000C083,0x126E978D, 0x3FE7A682,0xF2870E03,
	0x4000C28F,0x5C28F5C3, 0x3FE7AA6C,0x36AC3C40,
	0x4000C49B,0xA5E353F8, 0x3FE7AE55,0x007F2DCE,
	0x4000C6A7,0xEF9DB22D, 0x3FE7B23D,0x501DC224,
	0x4000C8B4,0x39581062, 0x3FE7B625,0x25A5CDC5,
	0x4000CAC0,0x83126E98, 0x3FE7BA0C,0x81351A4E,
	0x4000CCCC,0xCCCCCCCD, 0x3FE7BDF3,0x62E9666E,
	0x4000CED9,0x16872B02, 0x3FE7C1D9,0xCAE065FD,
	0x4000D0E5,0x60418937, 0x3FE7C5BF,0xB937C1F2,
	0x4000D2F1,0xA9FBE76D, 0x3FE7C9A5,0x2E0D1874,
	0x4000D4FD,0xF3B645A2, 0x3FE7CD8A,0x297DFCD2,
	0x4000D70A,0x3D70A3D7, 0x3FE7D16E,0xABA7F797,
	0x4000D916,0x872B020C, 0x3FE7D552,0xB4A88685,
	0x4000DB22,0xD0E56042, 0x3FE7D936,0x449D1CA0,
	0x4000DD2F,0x1A9FBE77, 0x3FE7DD19,0x5BA3222C,
	0x4000DF3B,0x645A1CAC, 0x3FE7E0FB,0xF9D7F4BA,
	0x4000E147,0xAE147AE1, 0x3FE7E4DE,0x1F58E72A,
	0x4000E353,0xF7CED917, 0x3FE7E8BF,0xCC4341B3,
	0x4000E560,0x4189374C, 0x3FE7ECA1,0x00B441DE,
	0x4000E76C,0x8B439581, 0x3FE7F081,0xBCC91A99,
	0x4000E978,0xD4FDF3B6, 0x3FE7F462,0x009EF434,
	0x4000EB85,0x1EB851EC, 0x3FE7F841,0xCC52EC69,
	0x4000ED91,0x6872B021, 0x3FE7FC21,0x2002165D,
	0x4000EF9D,0xB22D0E56, 0x3FE7FFFF,0xFBC97AAA,
	0x4000F1A9,0xFBE76C8B, 0x3FE803DE,0x5FC61764,
	0x4000F3B6,0x45A1CAC1, 0x3FE807BC,0x4C14E01B,
	0x4000F5C2,0x8F5C28F6, 0x3FE80B99,0xC0D2BDDE,
	0x4000F7CE,0xD916872B, 0x3FE80F76,0xBE1C8F48,
	0x4000F9DB,0x22D0E560, 0x3FE81353,0x440F287F,
	0x4000FBE7,0x6C8B4396, 0x3FE8172F,0x52C7533D,
	0x4000FDF3,0xB645A1CB, 0x3FE81B0A,0xEA61CECD,
	0x40010000,0x00000000, 0x3FE81EE6,0x0AFB501A,
	0x4001020C,0x49BA5E35, 0x3FE822C0,0xB4B081AE,
	0x40010418,0x9374BC6A, 0x3FE8269A,0xE79E03BB,
	0x40010624,0xDD2F1AA0, 0x3FE82A74,0xA3E06C1C,
	0x40010831,0x26E978D5, 0x3FE82E4D,0xE9944658,
	0x40010A3D,0x70A3D70A, 0x3FE83226,0xB8D613B0,
	0x40010C49,0xBA5E353F, 0x3FE835FF,0x11C24B1D,
	0x40010E56,0x04189375, 0x3FE839D6,0xF4755957,
	0x40011062,0x4DD2F1AA, 0x3FE83DAE,0x610BA0D5,
	0x4001126E,0x978D4FDF, 0x3FE84185,0x57A179DC,
	0x4001147A,0xE147AE14, 0x3FE8455B,0xD853327A,
	0x40011687,0x2B020C4A, 0x3FE84931,0xE33D0E93,
	0x40011893,0x74BC6A7F, 0x3FE84D07,0x787B47DD,
	0x40011A9F,0xBE76C8B4, 0x3FE850DC,0x982A0DED,
	0x40011CAC,0x083126E9, 0x3FE854B1,0x4265863A,
	0x40011EB8,0x51EB851F, 0x3FE85885,0x7749CC1F,
	0x400120C4,0x9BA5E354, 0x3FE85C59,0x36F2F0DE,
	0x400122D0,0xE5604189, 0x3FE8602C,0x817CFBAD,
	0x400124DD,0x2F1A9FBE, 0x3FE863FF,0x5703E9B4,
	0x400126E9,0x78D4FDF4, 0x3FE867D1,0xB7A3AE15,
	0x400128F5,0xC28F5C29, 0x3FE86BA3,0xA37831ED,
	0x40012B02,0x0C49BA5E, 0x3FE86F75,0x1A9D545D,
	0x40012D0E,0x56041893, 0x3FE87346,0x1D2EEA8D,
	0x40012F1A,0x9FBE76C9, 0x3FE87716,0xAB48BFB3,
	0x40013126,0xE978D4FE, 0x3FE87AE6,0xC506950F,
	0x40013333,0x33333333, 0x3FE87EB6,0x6A8421FF,
	0x4001353F,0x7CED9168, 0x3FE88285,0x9BDD13F4,
	0x4001374B,0xC6A7EF9E, 0x3FE88654,0x592D0E84,
	0x40013958,0x10624DD3, 0x3FE88A22,0xA28FAB62,
	0x40013B64,0x5A1CAC08, 0x3FE88DF0,0x78207A6C,
	0x40013D70,0xA3D70A3D, 0x3FE891BD,0xD9FB01AF,
	0x40013F7C,0xED916873, 0x3FE8958A,0xC83ABD69,
	0x40014189,0x374BC6A8, 0x3FE89957,0x42FB2009,
	0x40014395,0x810624DD, 0x3FE89D23,0x4A57923E,
	0x400145A1,0xCAC08312, 0x3FE8A0EE,0xDE6B72F5,
	0x400147AE,0x147AE148, 0x3FE8A4B9,0xFF521762,
	0x400149BA,0x5E353F7D, 0x3FE8A884,0xAD26CAFA,
	0x40014BC6,0xA7EF9DB2, 0x3FE8AC4E,0xE804CF86,
	0x40014DD2,0xF1A9FBE7, 0x3FE8B018,0xB0075D20,
	0x40014FDF,0x3B645A1D, 0x3FE8B3E2,0x0549A239,
	0x400151EB,0x851EB852, 0x3FE8B7AA,0xE7E6C396,
	0x400153F7,0xCED91687, 0x3FE8BB73,0x57F9DC66,
	0x40015604,0x189374BC, 0x3FE8BF3B,0x559DFE34,
	0x40015810,0x624DD2F2, 0x3FE8C302,0xE0EE30FB,
	0x40015A1C,0xAC083127, 0x3FE8C6C9,0xFA05731A,
	0x40015C28,0xF5C28F5C, 0x3FE8CA90,0xA0FEB96A,
	0x40015E35,0x3F7CED91, 0x3FE8CE56,0xD5F4EF36,
	0x40016041,0x89374BC7, 0x3FE8D21C,0x9902F647,
	0x4001624D,0xD2F1A9FC, 0x3FE8D5E1,0xEA43A6E0,
	0x4001645A,0x1CAC0831, 0x3FE8D9A6,0xC9D1CFCB,
	0x40016666,0x66666666, 0x3FE8DD6B,0x37C8365B,
	0x40016872,0xB020C49C, 0x3FE8E12F,0x34419670,
	0x40016A7E,0xF9DB22D1, 0x3FE8E4F2,0xBF58A277,
	0x40016C8B,0x43958106, 0x3FE8E8B5,0xD9280375,
	0x40016E97,0x8D4FDF3B, 0x3FE8EC78,0x81CA590A,
	0x400170A3,0xD70A3D71, 0x3FE8F03A,0xB95A3976,
	0x400172B0,0x20C49BA6, 0x3FE8F3FC,0x7FF23194,
	0x400174BC,0x6A7EF9DB, 0x3FE8F7BD,0xD5ACC4EF,
	0x400176C8,0xB4395810, 0x3FE8FB7E,0xBAA46DB8,
	0x400178D4,0xFDF3B646, 0x3FE8FF3F,0x2EF39CD4,
	0x40017AE1,0x47AE147B, 0x3FE902FF,0x32B4B9D7,
	0x40017CED,0x916872B0, 0x3FE906BE,0xC6022312,
	0x40017EF9,0xDB22D0E5, 0x3FE90A7D,0xE8F62D91,
	0x40018106,0x24DD2F1B, 0x3FE90E3C,0x9BAB2526,
	0x40018312,0x6E978D50, 0x3FE911FA,0xDE3B4C5E,
	0x4001851E,0xB851EB85, 0x3FE915B8,0xB0C0DC9A,
	0x4001872B,0x020C49BA, 0x3FE91976,0x13560606,
	0x40018937,0x4BC6A7F0, 0x3FE91D33,0x0614EFA2,
	0x40018B43,0x95810625, 0x3FE920EF,0x8917B73F,
	0x40018D4F,0xDF3B645A, 0x3FE924AB,0x9C78718F,
	0x40018F5C,0x28F5C28F, 0x3FE92867,0x40512A23,
	0x40019168,0x72B020C5, 0x3FE92C22,0x74BBE36E,
	0x40019374,0xBC6A7EFA, 0x3FE92FDD,0x39D296CA,
	0x40019581,0x0624DD2F, 0x3FE93397,0x8FAF347F,
	0x4001978D,0x4FDF3B64, 0x3FE93751,0x766BA3C4,
	0x40019999,0x9999999A, 0x3FE93B0A,0xEE21C2C9,
	0x40019BA5,0xE353F7CF, 0x3FE93EC3,0xF6EB66AE,
	0x40019DB2,0x2D0E5604, 0x3FE9427C,0x90E25B97,
	0x40019FBE,0x76C8B439, 0x3FE94634,0xBC2064A7,
	0x4001A1CA,0xC083126F, 0x3FE949EC,0x78BF3C0A,
	0x4001A3D7,0x0A3D70A4, 0x3FE94DA3,0xC6D892ED,
	0x4001A5E3,0x53F7CED9, 0x3FE9515A,0xA6861192,
	0x4001A7EF,0x9DB22D0E, 0x3FE95511,0x17E1574A,
	0x4001A9FB,0xE76C8B44, 0x3FE958C7,0x1B03FA80,
	0x4001AC08,0x3126E979, 0x3FE95C7C,0xB00788B1,
	0x4001AE14,0x7AE147AE, 0x3FE96031,0xD705867F,
	0x4001B020,0xC49BA5E3, 0x3FE963E6,0x90176FAC,
	0x4001B22D,0x0E560419, 0x3FE9679A,0xDB56B724,
	0x4001B439,0x5810624E, 0x3FE96B4E,0xB8DCC6F5,
	0x4001B645,0xA1CAC083, 0x3FE96F02,0x28C30063,
	0x4001B851,0xEB851EB8, 0x3FE972B5,0x2B22BBE4,
	0x4001BA5E,0x353F7CEE, 0x3FE97667,0xC0154924,
	0x4001BC6A,0x7EF9DB23, 0x3FE97A19,0xE7B3EF06,
	0x4001BE76,0xC8B43958, 0x3FE97DCB,0xA217EBB2,
	0x4001C083,0x126E978D, 0x3FE9817C,0xEF5A748F,
	0x4001C28F,0x5C28F5C3, 0x3FE9852D,0xCF94B64E,
	0x4001C49B,0xA5E353F8, 0x3FE988DE,0x42DFD4E6,
	0x4001C6A7,0xEF9DB22D, 0x3FE98C8E,0x4954EBA2,
	0x4001C8B4,0x39581062, 0x3FE9903D,0xE30D0D1D,
	0x4001CAC0,0x83126E98, 0x3FE993ED,0x1021434E,
	0x4001CCCC,0xCCCCCCCD, 0x3FE9979B,0xD0AA8F7E,
	0x4001CED9,0x16872B02, 0x3FE99B4A,0x24C1EA5C,
	0x4001D0E5,0x60418937, 0x3FE99EF8,0x0C8043F8,
	0x4001D2F1,0xA9FBE76D, 0x3FE9A2A5,0x87FE83CB,
	0x4001D4FD,0xF3B645A2, 0x3FE9A652,0x975588B3,
	0x4001D70A,0x3D70A3D7, 0x3FE9A9FF,0x3A9E2903,
	0x4001D916,0x872B020C, 0x3FE9ADAB,0x71F1327E,
	0x4001DB22,0xD0E56042, 0x3FE9B157,0x3D676A5E,
	0x4001DD2F,0x1A9FBE77, 0x3FE9B502,0x9D198D57,
	0x4001DF3B,0x645A1CAC, 0x3FE9B8AD,0x91204F9B,
	0x4001E147,0xAE147AE1, 0x3FE9BC58,0x19945CE1,
	0x4001E353,0xF7CED917, 0x3FE9C002,0x368E5865,
	0x4001E560,0x4189374C, 0x3FE9C3AB,0xE826DCEB,
	0x4001E76C,0x8B439581, 0x3FE9C755,0x2E767CC7,
	0x4001E978,0xD4FDF3B6, 0x3FE9CAFE,0x0995C1DF,
	0x4001EB85,0x1EB851EC, 0x3FE9CEA6,0x799D2DAF,
	0x4001ED91,0x6872B021, 0x3FE9D24E,0x7EA5394B,
	0x4001EF9D,0xB22D0E56, 0x3FE9D5F6,0x18C65565,
	0x4001F1A9,0xFBE76C8B, 0x3FE9D99D,0x4818EA50,
	0x4001F3B6,0x45A1CAC1, 0x3FE9DD44,0x0CB55808,
	0x4001F5C2,0x8F5C28F6, 0x3FE9E0EA,0x66B3F62B,
	0x4001F7CE,0xD916872B, 0x3FE9E490,0x562D1407,
	0x4001F9DB,0x22D0E560, 0x3FE9E835,0xDB38F89D,
	0x4001FBE7,0x6C8B4396, 0x3FE9EBDA,0xF5EFE2A0,
	0x4001FDF3,0xB645A1CB, 0x3FE9EF7F,0xA66A0877,
	0x40020000,0x00000000, 0x3FE9F323,0xECBF984C,
	0x4002020C,0x49BA5E35, 0x3FE9F6C7,0xC908B804,
	0x40020418,0x9374BC6A, 0x3FE9FA6B,0x3B5D854A,
	0x40020624,0xDD2F1AA0, 0x3FE9FE0E,0x43D6158E,
	0x40020831,0x26E978D5, 0x3FEA01B0,0xE28A760B,
	0x40020A3D,0x70A3D70A, 0x3FEA0553,0x1792ABCA,
	0x40020C49,0xBA5E353F, 0x3FEA08F4,0xE306B3A8,
	0x40020E56,0x04189375, 0x3FEA0C96,0x44FE825A,
	0x40021062,0x4DD2F1AA, 0x3FEA1037,0x3D920468,
	0x4002126E,0x978D4FDF, 0x3FEA13D7,0xCCD91E3B,
	0x4002147A,0xE147AE14, 0x3FEA1777,0xF2EBAC20,
	0x40021687,0x2B020C4A, 0x3FEA1B17,0xAFE18246,
	0x40021893,0x74BC6A7F, 0x3FEA1EB7,0x03D26CC1,
	0x40021A9F,0xBE76C8B4, 0x3FEA2255,0xEED62F97,
	0x40021CAC,0x083126E9, 0x3FEA25F4,0x710486BA,
	0x40021EB8,0x51EB851F, 0x3FEA2992,0x8A752613,
	0x400220C4,0x9BA5E354, 0x3FEA2D30,0x3B3FB97B,
	0x400222D0,0xE5604189, 0x3FEA30CD,0x837BE4CD,
	0x400224DD,0x2F1A9FBE, 0x3FEA346A,0x634143DF,
	0x400226E9,0x78D4FDF4, 0x3FEA3806,0xDAA76A8A,
	0x400228F5,0xC28F5C29, 0x3FEA3BA2,0xE9C5E4AA,
	0x40022B02,0x0C49BA5E, 0x3FEA3F3E,0x90B43625,
	0x40022D0E,0x56041893, 0x3FEA42D9,0xCF89DAF1,
	0x40022F1A,0x9FBE76C9, 0x3FEA4674,0xA65E4711,
	0x40023126,0xE978D4FE, 0x3FEA4A0F,0x1548E69B,
	0x40023333,0x33333333, 0x3FEA4DA9,0x1C611DBE,
	0x4002353F,0x7CED9168, 0x3FEA5142,0xBBBE48C4,
	0x4002374B,0xC6A7EF9E, 0x3FEA54DB,0xF377BC18,
	0x40023958,0x10624DD3, 0x3FEA5874,0xC3A4C43F,
	0x40023B64,0x5A1CAC08, 0x3FEA5C0D,0x2C5CA5ED,
	0x40023D70,0xA3D70A3D, 0x3FEA5FA5,0x2DB69DF9,
	0x40023F7C,0xED916873, 0x3FEA633C,0xC7C9E16A,
	0x40024189,0x374BC6A8, 0x3FEA66D3,0xFAAD9D74,
	0x40024395,0x810624DD, 0x3FEA6A6A,0xC678F781,
	0x400245A1,0xCAC08312, 0x3FEA6E01,0x2B430D31,
	0x400247AE,0x147AE148, 0x3FEA7197,0x2922F462,
	0x400249BA,0x5E353F7D, 0x3FEA752C,0xC02FBB28,
	0x40024BC6,0xA7EF9DB2, 0x3FEA78C1,0xF08067E1,
	0x40024DD2,0xF1A9FBE7, 0x3FEA7C56,0xBA2BF92D,
	0x40024FDF,0x3B645A1D, 0x3FEA7FEB,0x1D4965F5,
	0x400251EB,0x851EB852, 0x3FEA837F,0x19EF9D69,
	0x400253F7,0xCED91687, 0x3FEA8712,0xB0358710,
	0x40025604,0x189374BC, 0x3FEA8AA5,0xE03202C1,
	0x40025810,0x624DD2F2, 0x3FEA8E38,0xA9FBE8A8,
	0x40025A1C,0xAC083127, 0x3FEA91CB,0x0DAA094A,
	0x40025C28,0xF5C28F5C, 0x3FEA955D,0x0B532D8B,
	0x40025E35,0x3F7CED91, 0x3FEA98EE,0xA30E16B0,
	0x40026041,0x89374BC7, 0x3FEA9C7F,0xD4F17E62,
	0x4002624D,0xD2F1A9FC, 0x3FEAA010,0xA11416AD,
	0x4002645A,0x1CAC0831, 0x3FEAA3A1,0x078C8A0D,
	0x40026666,0x66666666, 0x3FEAA731,0x08717B69,
	0x40026872,0xB020C49C, 0x3FEAAAC0,0xA3D9861D,
	0x40026A7E,0xF9DB22D1, 0x3FEAAE4F,0xD9DB3DF4,
	0x40026C8B,0x43958106, 0x3FEAB1DE,0xAA8D2F34,
	0x40026E97,0x8D4FDF3B, 0x3FEAB56D,0x1605DEA1,
	0x400270A3,0xD70A3D71, 0x3FEAB8FB,0x1C5BC97D,
	0x400272B0,0x20C49BA6, 0x3FEABC88,0xBDA56586,
	0x400274BC,0x6A7EF9DB, 0x3FEAC015,0xF9F92107,
	0x400276C8,0xB4395810, 0x3FEAC3A2,0xD16D62D1,
	0x400278D4,0xFDF3B646, 0x3FEAC72F,0x44188A44,
	0x40027AE1,0x47AE147B, 0x3FEACABB,0x5210EF47,
	0x40027CED,0x916872B0, 0x3FEACE46,0xFB6CE25C,
	0x40027EF9,0xDB22D0E5, 0x3FEAD1D2,0x4042AC99,
	0x40028106,0x24DD2F1B, 0x3FEAD55D,0x20A88FAE,
	0x40028312,0x6E978D50, 0x3FEAD8E7,0x9CB4C5E3,
	0x4002851E,0xB851EB85, 0x3FEADC71,0xB47D8224,
	0x4002872B,0x020C49BA, 0x3FEADFFB,0x6818F000,
	0x40028937,0x4BC6A7F0, 0x3FEAE384,0xB79D33AD,
	0x40028B43,0x95810625, 0x3FEAE70D,0xA3206A06,
	0x40028D4F,0xDF3B645A, 0x3FEAEA96,0x2AB8A897,
	0x40028F5C,0x28F5C28F, 0x3FEAEE1E,0x4E7BFD9C,
	0x40029168,0x72B020C5, 0x3FEAF1A6,0x0E807004,
	0x40029374,0xBC6A7EFA, 0x3FEAF52D,0x6ADBFF71,
	0x40029581,0x0624DD2F, 0x3FEAF8B4,0x63A4A444,
	0x4002978D,0x4FDF3B64, 0x3FEAFC3A,0xF8F04F97,
	0x40029999,0x9999999A, 0x3FEAFFC1,0x2AD4EB49,
	0x40029BA5,0xE353F7CF, 0x3FEB0346,0xF96859F5,
	0x40029DB2,0x2D0E5604, 0x3FEB06CC,0x64C07702,
	0x40029FBE,0x76C8B439, 0x3FEB0A51,0x6CF316A0,
	0x4002A1CA,0xC083126F, 0x3FEB0DD6,0x121605CC,
	0x4002A3D7,0x0A3D70A4, 0x3FEB115A,0x543F0A50,
	0x4002A5E3,0x53F7CED9, 0x3FEB14DE,0x3383E2CC,
	0x4002A7EF,0x9DB22D0E, 0x3FEB1861,0xAFFA46B5,
	0x4002A9FB,0xE76C8B44, 0x3FEB1BE4,0xC9B7E65E,
	0x4002AC08,0x3126E979, 0x3FEB1F67,0x80D26AEE,
	0x4002AE14,0x7AE147AE, 0x3FEB22E9,0xD55F7673,
	0x4002B020,0xC49BA5E3, 0x3FEB266B,0xC774A3DB,
	0x4002B22D,0x0E560419, 0x3FEB29ED,0x572786FC,
	0x4002B439,0x5810624E, 0x3FEB2D6E,0x848DAC91,
	0x4002B645,0xA1CAC083, 0x3FEB30EF,0x4FBC9A45,
	0x4002B851,0xEB851EB8, 0x3FEB346F,0xB8C9CEB1,
	0x4002BA5E,0x353F7CEE, 0x3FEB37EF,0xBFCAC162,
	0x4002BC6A,0x7EF9DB23, 0x3FEB3B6F,0x64D4E2D7,
	0x4002BE76,0xC8B43958, 0x3FEB3EEE,0xA7FD9C89,
	0x4002C083,0x126E978D, 0x3FEB426D,0x895A50F0,
	0x4002C28F,0x5C28F5C3, 0x3FEB45EC,0x09005B7F,
	0x4002C49B,0xA5E353F8, 0x3FEB496A,0x270510AA,
	0x4002C6A7,0xEF9DB22D, 0x3FEB4CE7,0xE37DBDEC,
	0x4002C8B4,0x39581062, 0x3FEB5065,0x3E7FA9C9,
	0x4002CAC0,0x83126E98, 0x3FEB53E2,0x382013CE,
	0x4002CCCC,0xCCCCCCCD, 0x3FEB575E,0xD0743494,
	0x4002CED9,0x16872B02, 0x3FEB5ADB,0x07913DC9,
	0x4002D0E5,0x60418937, 0x3FEB5E56,0xDD8C5A2D,
	0x4002D2F1,0xA9FBE76D, 0x3FEB61D2,0x527AAD98,
	0x4002D4FD,0xF3B645A2, 0x3FEB654D,0x667154F8,
	0x4002D70A,0x3D70A3D7, 0x3FEB68C8,0x1985665D,
	0x4002D916,0x872B020C, 0x3FEB6C42,0x6BCBF0F5,
	0x4002DB22,0xD0E56042, 0x3FEB6FBC,0x5D59FD13,
	0x4002DD2F,0x1A9FBE77, 0x3FEB7335,0xEE448C2B,
	0x4002DF3B,0x645A1CAC, 0x3FEB76AF,0x1EA098DE,
	0x4002E147,0xAE147AE1, 0x3FEB7A27,0xEE8316F8,
	0x4002E353,0xF7CED917, 0x3FEB7DA0,0x5E00F375,
	0x4002E560,0x4189374C, 0x3FEB8118,0x6D2F147E,
	0x4002E76C,0x8B439581, 0x3FEB8490,0x1C225977,
	0x4002E978,0xD4FDF3B6, 0x3FEB8807,0x6AEF9AF9,
	0x4002EB85,0x1EB851EC, 0x3FEB8B7E,0x59ABAAD9,
	0x4002ED91,0x6872B021, 0x3FEB8EF4,0xE86B5424,
	0x4002EF9D,0xB22D0E56, 0x3FEB926B,0x17435B2F,
	0x4002F1A9,0xFBE76C8B, 0x3FEB95E0,0xE6487D8E,
	0x4002F3B6,0x45A1CAC1, 0x3FEB9956,0x558F721E,
	0x4002F5C2,0x8F5C28F6, 0x3FEB9CCB,0x652CE901,
	0x4002F7CE,0xD916872B, 0x3FEBA040,0x15358BAA,
	0x4002F9DB,0x22D0E560, 0x3FEBA3B4,0x65BDFCD9,
	0x4002FBE7,0x6C8B4396, 0x3FEBA728,0x56DAD8A0,
	0x4002FDF3,0xB645A1CB, 0x3FEBAA9B,0xE8A0B464,
	0x40030000,0x00000000, 0x3FEBAE0F,0x1B241EE4,
	0x4003020C,0x49BA5E35, 0x3FEBB181,0xEE79A039,
	0x40030418,0x9374BC6A, 0x3FEBB4F4,0x62B5B9DA,
	0x40030624,0xDD2F1AA0, 0x3FEBB866,0x77ECE69F,
	0x40030831,0x26E978D5, 0x3FEBBBD8,0x2E339ABE,
	0x40030A3D,0x70A3D70A, 0x3FEBBF49,0x859E43D9,
	0x40030C49,0xBA5E353F, 0x3FEBC2BA,0x7E4148F7,
	0x40030E56,0x04189375, 0x3FEBC62B,0x18310A90,
	0x40031062,0x4DD2F1AA, 0x3FEBC99B,0x5381E281,
	0x4003126E,0x978D4FDF, 0x3FEBCD0B,0x30482422,
	0x4003147A,0xE147AE14, 0x3FEBD07A,0xAE981C39,
	0x40031687,0x2B020C4A, 0x3FEBD3E9,0xCE861108,
	0x40031893,0x74BC6A7F, 0x3FEBD758,0x90264243,
	0x40031A9F,0xBE76C8B4, 0x3FEBDAC6,0xF38CE922,
	0x40031CAC,0x083126E9, 0x3FEBDE34,0xF8CE385A,
	0x40031EB8,0x51EB851F, 0x3FEBE1A2,0x9FFE5C21,
	0x400320C4,0x9BA5E354, 0x3FEBE50F,0xE9317A31,
	0x400322D0,0xE5604189, 0x3FEBE87C,0xD47BB1CF,
	0x400324DD,0x2F1A9FBE, 0x3FEBEBE9,0x61F11BC8,
	0x400326E9,0x78D4FDF4, 0x3FEBEF55,0x91A5CA78,
	0x400328F5,0xC28F5C29, 0x3FEBF2C1,0x63ADC9C8,
	0x40032B02,0x0C49BA5E, 0x3FEBF62C,0xD81D1F35,
	0x40032D0E,0x56041893, 0x3FEBF997,0xEF07C9D3,
	0x40032F1A,0x9FBE76C9, 0x3FEBFD02,0xA881C24F,
	0x40033126,0xE978D4FE, 0x3FEC006D,0x049EFAEB,
	0x40033333,0x33333333, 0x3FEC03D7,0x03735F8C,
	0x4003353F,0x7CED9168, 0x3FEC0740,0xA512D5B8,
	0x4003374B,0xC6A7EF9E, 0x3FEC0AA9,0xE9913C96,
	0x40033958,0x10624DD3, 0x3FEC0E12,0xD1026CEF,
	0x40033B64,0x5A1CAC08, 0x3FEC117B,0x5B7A393C,
	0x40033D70,0xA3D70A3D, 0x3FEC14E3,0x890C6D9D,
	0x40033F7C,0xED916873, 0x3FEC184B,0x59CCCFE1,
	0x40034189,0x374BC6A8, 0x3FEC1BB2,0xCDCF1F86,
	0x40034395,0x810624DD, 0x3FEC1F19,0xE52715BE,
	0x400345A1,0xCAC08312, 0x3FEC2280,0x9FE86573,
	0x400347AE,0x147AE148, 0x3FEC25E6,0xFE26BB46,
	0x400349BA,0x5E353F7D, 0x3FEC294C,0xFFF5BD92,
	0x40034BC6,0xA7EF9DB2, 0x3FEC2CB2,0xA5690C71,
	0x40034DD2,0xF1A9FBE7, 0x3FEC3017,0xEE9441C0,
	0x40034FDF,0x3B645A1D, 0x3FEC337C,0xDB8AF11D,
	0x400351EB,0x851EB852, 0x3FEC36E1,0x6C60A7E9,
	0x400353F7,0xCED91687, 0x3FEC3A45,0xA128ED53,
	0x40035604,0x189374BC, 0x3FEC3DA9,0x79F74252,
	0x40035810,0x624DD2F2, 0x3FEC410C,0xF6DF21AF,
	0x40035A1C,0xAC083127, 0x3FEC4470,0x17F3FFFA,
	0x40035C28,0xF5C28F5C, 0x3FEC47D2,0xDD494BA1,
	0x40035E35,0x3F7CED91, 0x3FEC4B35,0x46F26CE0,
	0x40036041,0x89374BC7, 0x3FEC4E97,0x5502C5D1,
	0x4003624D,0xD2F1A9FC, 0x3FEC51F9,0x078DB263,
	0x4003645A,0x1CAC0831, 0x3FEC555A,0x5EA68866,
	0x40036666,0x66666666, 0x3FEC58BB,0x5A60978B,
	0x40036872,0xB020C49C, 0x3FEC5C1B,0xFACF2964,
	0x40036A7E,0xF9DB22D1, 0x3FEC5F7C,0x40058167,
	0x40036C8B,0x43958106, 0x3FEC62DC,0x2A16DCF3,
	0x40036E97,0x8D4FDF3B, 0x3FEC663B,0xB9167353,
	0x400370A3,0xD70A3D71, 0x3FEC699A,0xED1775BE,
	0x400372B0,0x20C49BA6, 0x3FEC6CF9,0xC62D0F58,
	0x400374BC,0x6A7EF9DB, 0x3FEC7058,0x446A653A,
	0x400376C8,0xB4395810, 0x3FEC73B6,0x67E29670,
	0x400378D4,0xFDF3B646, 0x3FEC7714,0x30A8BC01,
	0x40037AE1,0x47AE147B, 0x3FEC7A71,0x9ECFE8E6,
	0x40037CED,0x916872B0, 0x3FEC7DCE,0xB26B2A1B,
	0x40037EF9,0xDB22D0E5, 0x3FEC812B,0x6B8D8698,
	0x40038106,0x24DD2F1B, 0x3FEC8487,0xCA49FF59,
	0x40038312,0x6E978D50, 0x3FEC87E3,0xCEB38F57,
	0x4003851E,0xB851EB85, 0x3FEC8B3F,0x78DD2B99,
	0x4003872B,0x020C49BA, 0x3FEC8E9A,0xC8D9C32B,
	0x40038937,0x4BC6A7F0, 0x3FEC91F5,0xBEBC3F27,
	0x40038B43,0x95810625, 0x3FEC9550,0x5A9782AE,
	0x40038D4F,0xDF3B645A, 0x3FEC98AA,0x9C7E6AF9,
	0x40038F5C,0x28F5C28F, 0x3FEC9C04,0x8483CF51,
	0x40039168,0x72B020C5, 0x3FEC9F5E,0x12BA8116,
	0x40039374,0xBC6A7EFA, 0x3FECA2B7,0x47354BB9,
	0x40039581,0x0624DD2F, 0x3FECA610,0x2206F4CC,
	0x4003978D,0x4FDF3B64, 0x3FECA968,0xA3423BFD,
	0x40039999,0x9999999A, 0x3FECACC0,0xCAF9DB19,
	0x40039BA5,0xE353F7CF, 0x3FECB018,0x99408609,
	0x40039DB2,0x2D0E5604, 0x3FECB370,0x0E28EAE2,
	0x40039FBE,0x76C8B439, 0x3FECB6C7,0x29C5B1DB,
	0x4003A1CA,0xC083126F, 0x3FECBA1D,0xEC297D57,
	0x4003A3D7,0x0A3D70A4, 0x3FECBD74,0x5566E9DF,
	0x4003A5E3,0x53F7CED9, 0x3FECC0CA,0x65908E2E,
	0x4003A7EF,0x9DB22D0E, 0x3FECC420,0x1CB8FB30,
	0x4003A9FB,0xE76C8B44, 0x3FECC775,0x7AF2BC01,
	0x4003AC08,0x3126E979, 0x3FECCACA,0x805055F3,
	0x4003AE14,0x7AE147AE, 0x3FECCE1F,0x2CE4488F,
	0x4003B020,0xC49BA5E3, 0x3FECD173,0x80C10D99,
	0x4003B22D,0x0E560419, 0x3FECD4C7,0x7BF91913,
	0x4003B439,0x5810624E, 0x3FECD81B,0x1E9ED937,
	0x4003B645,0xA1CAC083, 0x3FECDB6E,0x68C4B687,
	0x4003B851,0xEB851EB8, 0x3FECDEC1,0x5A7D13C6,
	0x4003BA5E,0x353F7CEE, 0x3FECE213,0xF3DA4DFF,
	0x4003BC6A,0x7EF9DB23, 0x3FECE566,0x34EEBC7E,
	0x4003BE76,0xC8B43958, 0x3FECE8B8,0x1DCCB0E2,
	0x4003C083,0x126E978D, 0x3FECEC09,0xAE867713,
	0x4003C28F,0x5C28F5C3, 0x3FECEF5A,0xE72E554A,
	0x4003C49B,0xA5E353F8, 0x3FECF2AB,0xC7D68C0F,
	0x4003C6A7,0xEF9DB22D, 0x3FECF5FC,0x50915640,
	0x4003C8B4,0x39581062, 0x3FECF94C,0x8170E911,
	0x4003CAC0,0x83126E98, 0x3FECFC9C,0x5A877411,
	0x4003CCCC,0xCCCCCCCD, 0x3FECFFEB,0xDBE72125,
	0x4003CED9,0x16872B02, 0x3FED033B,0x05A21493,
	0x4003D0E5,0x60418937, 0x3FED0689,0xD7CA6D01,
	0x4003D2F1,0xA9FBE76D, 0x3FED09D8,0x52724377,
	0x4003D4FD,0xF3B645A2, 0x3FED0D26,0x75ABAB5E,
	0x4003D70A,0x3D70A3D7, 0x3FED1074,0x4188B289,
	0x4003D916,0x872B020C, 0x3FED13C1,0xB61B6134,
	0x4003DB22,0xD0E56042, 0x3FED170E,0xD375BA07,
	0x4003DD2F,0x1A9FBE77, 0x3FED1A5B,0x99A9BA12,
	0x4003DF3B,0x645A1CAC, 0x3FED1DA8,0x08C958DC,
	0x4003E147,0xAE147AE1, 0x3FED20F4,0x20E6885B,
	0x4003E353,0xF7CED917, 0x3FED243F,0xE21334FA,
	0x4003E560,0x4189374C, 0x3FED278B,0x4C61459A,
	0x4003E76C,0x8B439581, 0x3FED2AD6,0x5FE29B95,
	0x4003E978,0xD4FDF3B6, 0x3FED2E21,0x1CA912C3,
	0x4003EB85,0x1EB851EC, 0x3FED316B,0x82C68177,
	0x4003ED91,0x6872B021, 0x3FED34B5,0x924CB882,
	0x4003EF9D,0xB22D0E56, 0x3FED37FF,0x4B4D833D,
	0x4003F1A9,0xFBE76C8B, 0x3FED3B48,0xADDAA780,
	0x4003F3B6,0x45A1CAC1, 0x3FED3E91,0xBA05E5AD,
	0x4003F5C2,0x8F5C28F6, 0x3FED41DA,0x6FE0F8AC,
	0x4003F7CE,0xD916872B, 0x3FED4522,0xCF7D95F2,
	0x4003F9DB,0x22D0E560, 0x3FED486A,0xD8ED6D82,
	0x4003FBE7,0x6C8B4396, 0x3FED4BB2,0x8C4229EF,
	0x4003FDF3,0xB645A1CB, 0x3FED4EF9,0xE98D7058,
	0x40040000,0x00000000, 0x3FED5240,0xF0E0E078,
	0x4004020C,0x49BA5E35, 0x3FED5587,0xA24E149B,
	0x40040418,0x9374BC6A, 0x3FED58CD,0xFDE6A1A9,
	0x40040624,0xDD2F1AA0, 0x3FED5C14,0x03BC1724,
	0x40040831,0x26E978D5, 0x3FED5F59,0xB3DFFF26,
	0x40040A3D,0x70A3D70A, 0x3FED629F,0x0E63DE6F,
	0x40040C49,0xBA5E353F, 0x3FED65E4,0x1359345C,
	0x40040E56,0x04189375, 0x3FED6928,0xC2D17AF1,
	0x40041062,0x4DD2F1AA, 0x3FED6C6D,0x1CDE26D2,
	0x4004126E,0x978D4FDF, 0x3FED6FB1,0x2190A751,
	0x4004147A,0xE147AE14, 0x3FED72F4,0xD0FA6667,
	0x40041687,0x2B020C4A, 0x3FED7638,0x2B2CC8BB,
	0x40041893,0x74BC6A7F, 0x3FED797B,0x30392D9E,
	0x40041A9F,0xBE76C8B4, 0x3FED7CBD,0xE030EF17,
	0x40041CAC,0x083126E9, 0x3FED8000,0x3B2561DC,
	0x40041EB8,0x51EB851F, 0x3FED8342,0x4127D55D,
	0x400420C4,0x9BA5E354, 0x3FED8683,0xF24993B8,
	0x400422D0,0xE5604189, 0x3FED89C5,0x4E9BE1CD,
	0x400424DD,0x2F1A9FBE, 0x3FED8D06,0x562FFF34,
	0x400426E9,0x78D4FDF4, 0x3FED9047,0x09172642,
	0x400428F5,0xC28F5C29, 0x3FED9387,0x67628C0B,
	0x40042B02,0x0C49BA5E, 0x3FED96C7,0x71236067,
	0x40042D0E,0x56041893, 0x3FED9A07,0x266ACDF0,
	0x40042F1A,0x9FBE76C9, 0x3FED9D46,0x8749FA09,
	0x40043126,0xE978D4FE, 0x3FEDA085,0x93D204D8,
	0x40043333,0x33333333, 0x3FEDA3C4,0x4C140951,
	0x4004353F,0x7CED9168, 0x3FEDA702,0xB0211D34,
	0x4004374B,0xC6A7EF9E, 0x3FEDAA40,0xC00A5111,
	0x40043958,0x10624DD3, 0x3FEDAD7E,0x7BE0B042,
	0x40043B64,0x5A1CAC08, 0x3FEDB0BB,0xE3B540FB,
	0x40043D70,0xA3D70A3D, 0x3FEDB3F8,0xF7990442,
	0x40043F7C,0xED916873, 0x3FEDB735,0xB79CF5F6,
	0x40044189,0x374BC6A8, 0x3FEDBA72,0x23D20CC8,
	0x40044395,0x810624DD, 0x3FEDBDAE,0x3C493A4C,
	0x400445A1,0xCAC08312, 0x3FEDC0EA,0x01136AF0,
	0x400447AE,0x147AE148, 0x3FEDC425,0x72418602,
	0x400449BA,0x5E353F7D, 0x3FEDC760,0x8FE46DAE,
	0x40044BC6,0xA7EF9DB2, 0x3FEDCA9B,0x5A0CFF08,
	0x40044DD2,0xF1A9FBE7, 0x3FEDCDD5,0xD0CC1205,
	0x40044FDF,0x3B645A1D, 0x3FEDD10F,0xF4327988,
	0x400451EB,0x851EB852, 0x3FEDD449,0xC4510354,
	0x400453F7,0xCED91687, 0x3FEDD783,0x4138781F,
	0x40045604,0x189374BC, 0x3FEDDABC,0x6AF99B8B,
	0x40045810,0x624DD2F2, 0x3FEDDDF5,0x41A52C2A,
	0x40045A1C,0xAC083127, 0x3FEDE12D,0xC54BE37B,
	0x40045C28,0xF5C28F5C, 0x3FEDE465,0xF5FE75F7,
	0x40045E35,0x3F7CED91, 0x3FEDE79D,0xD3CD9309,
	0x40046041,0x89374BC7, 0x3FEDEAD5,0x5EC9E518,
	0x4004624D,0xD2F1A9FC, 0x3FEDEE0C,0x9704117E,
	0x4004645A,0x1CAC0831, 0x3FEDF143,0x7C8CB895,
	0x40046666,0x66666666, 0x3FEDF47A,0x0F7475B7,
	0x40046872,0xB020C49C, 0x3FEDF7B0,0x4FCBDF3A,
	0x40046A7E,0xF9DB22D1, 0x3FEDFAE6,0x3DA38675,
	0x40046C8B,0x43958106, 0x3FEDFE1B,0xD90BF7C8,
	0x40046E97,0x8D4FDF3B, 0x3FEE0151,0x2215BA94,
	0x400470A3,0xD70A3D71, 0x3FEE0486,0x18D15146,
	0x400472B0,0x20C49BA6, 0x3FEE07BA,0xBD4F394F,
	0x400474BC,0x6A7EF9DB, 0x3FEE0AEF,0x0F9FEB31,
	0x400476C8,0xB4395810, 0x3FEE0E23,0x0FD3DA7A,
	0x400478D4,0xFDF3B646, 0x3FEE1156,0xBDFB75CA,
	0x40047AE1,0x47AE147B, 0x3FEE148A,0x1A2726CE,
	0x40047CED,0x916872B0, 0x3FEE17BD,0x2467524A,
	0x40047EF9,0xDB22D0E5, 0x3FEE1AEF,0xDCCC5817,
	0x40048106,0x24DD2F1B, 0x3FEE1E22,0x43669329,
	0x40048312,0x6E978D50, 0x3FEE2154,0x58465986,
	0x4004851E,0xB851EB85, 0x3FEE2486,0x1B7BFC56,
	0x4004872B,0x020C49BA, 0x3FEE27B7,0x8D17C7DC,
	0x40048937,0x4BC6A7F0, 0x3FEE2AE8,0xAD2A037E,
	0x40048B43,0x95810625, 0x3FEE2E19,0x7BC2F1BC,
	0x40048D4F,0xDF3B645A, 0x3FEE3149,0xF8F2D041,
	0x40048F5C,0x28F5C28F, 0x3FEE347A,0x24C9D7D9,
	0x40049168,0x72B020C5, 0x3FEE37A9,0xFF583C7A,
	0x40049374,0xBC6A7EFA, 0x3FEE3AD9,0x88AE2D3F,
	0x40049581,0x0624DD2F, 0x3FEE3E08,0xC0DBD472,
	0x4004978D,0x4FDF3B64, 0x3FEE4137,0xA7F1578A,
	0x40049999,0x9999999A, 0x3FEE4466,0x3DFED72B,
	0x40049BA5,0xE353F7CF, 0x3FEE4794,0x83146F2A,
	0x40049DB2,0x2D0E5604, 0x3FEE4AC2,0x7742368F,
	0x40049FBE,0x76C8B439, 0x3FEE4DF0,0x1A983F98,
	0x4004A1CA,0xC083126F, 0x3FEE511D,0x6D2697B9,
	0x4004A3D7,0x0A3D70A4, 0x3FEE544A,0x6EFD479D,
	0x4004A5E3,0x53F7CED9, 0x3FEE5777,0x202C532A,
	0x4004A7EF,0x9DB22D0E, 0x3FEE5AA3,0x80C3B985,
	0x4004A9FB,0xE76C8B44, 0x3FEE5DCF,0x90D3750E,
	0x4004AC08,0x3126E979, 0x3FEE60FB,0x506B7B65,
	0x4004AE14,0x7AE147AE, 0x3FEE6426,0xBF9BBD6D,
	0x4004B020,0xC49BA5E3, 0x3FEE6751,0xDE74274D,
	0x4004B22D,0x0E560419, 0x3FEE6A7C,0xAD04A074,
	0x4004B439,0x5810624E, 0x3FEE6DA7,0x2B5D0B91,
	0x4004B645,0xA1CAC083, 0x3FEE70D1,0x598D46A5,
	0x4004B851,0xEB851EB8, 0x3FEE73FB,0x37A52AF7,
	0x4004BA5E,0x353F7CEE, 0x3FEE7724,0xC5B48D1F,
	0x4004BC6A,0x7EF9DB23, 0x3FEE7A4E,0x03CB3CFF,
	0x4004BE76,0xC8B43958, 0x3FEE7D76,0xF1F905CE,
	0x4004C083,0x126E978D, 0x3FEE809F,0x904DAE14,
	0x4004C28F,0x5C28F5C3, 0x3FEE83C7,0xDED8F7AF,
	0x4004C49B,0xA5E353F8, 0x3FEE86EF,0xDDAA9FD1,
	0x4004C6A7,0xEF9DB22D, 0x3FEE8A17,0x8CD25F06,
	0x4004C8B4,0x39581062, 0x3FEE8D3E,0xEC5FE933,
	0x4004CAC0,0x83126E98, 0x3FEE9065,0xFC62ED9C,
	0x4004CCCC,0xCCCCCCCD, 0x3FEE938C,0xBCEB16DD,
	0x4004CED9,0x16872B02, 0x3FEE96B3,0x2E080AF7,
	0x4004D0E5,0x60418937, 0x3FEE99D9,0x4FC96B48,
	0x4004D2F1,0xA9FBE76D, 0x3FEE9CFF,0x223ED497,
	0x4004D4FD,0xF3B645A2, 0x3FEEA024,0xA577DF08,
	0x4004D70A,0x3D70A3D7, 0x3FEEA349,0xD9841E2D,
	0x4004D916,0x872B020C, 0x3FEEA66E,0xBE7320FC,
	0x4004DB22,0xD0E56042, 0x3FEEA993,0x545471DB,
	0x4004DD2F,0x1A9FBE77, 0x3FEEACB7,0x9B379693,
	0x4004DF3B,0x645A1CAC, 0x3FEEAFDB,0x932C1064,
	0x4004E147,0xAE147AE1, 0x3FEEB2FF,0x3C415BF9,
	0x4004E353,0xF7CED917, 0x3FEEB622,0x9686F172,
	0x4004E560,0x4189374C, 0x3FEEB945,0xA20C445D,
	0x4004E76C,0x8B439581, 0x3FEEBC68,0x5EE0C3C2,
	0x4004E978,0xD4FDF3B6, 0x3FEEBF8A,0xCD13DA1F,
	0x4004EB85,0x1EB851EC, 0x3FEEC2AC,0xECB4ED6B,
	0x4004ED91,0x6872B021, 0x3FEEC5CE,0xBDD35F13,
	0x4004EF9D,0xB22D0E56, 0x3FEEC8F0,0x407E8C07,
	0x4004F1A9,0xFBE76C8B, 0x3FEECC11,0x74C5CCB1,
	0x4004F3B6,0x45A1CAC1, 0x3FEECF32,0x5AB874FE,
	0x4004F5C2,0x8F5C28F6, 0x3FEED252,0xF265D457,
	0x4004F7CE,0xD916872B, 0x3FEED573,0x3BDD35AC,
	0x4004F9DB,0x22D0E560, 0x3FEED893,0x372DDF74,
	0x4004FBE7,0x6C8B4396, 0x3FEEDBB2,0xE46713AA,
	0x4004FDF3,0xB645A1CB, 0x3FEEDED2,0x43980FD0,
	0x40050000,0x00000000, 0x3FEEE1F1,0x54D00CF6,
	0x4005020C,0x49BA5E35, 0x3FEEE510,0x181E3FB7,
	0x40050418,0x9374BC6A, 0x3FEEE82E,0x8D91D83A,
	0x40050624,0xDD2F1AA0, 0x3FEEEB4C,0xB53A0239,
	0x40050831,0x26E978D5, 0x3FEEEE6A,0x8F25E4FA,
	0x40050A3D,0x70A3D70A, 0x3FEEF188,0x1B64A35A,
	0x40050C49,0xBA5E353F, 0x3FEEF4A5,0x5A055BCB,
	0x40050E56,0x04189375, 0x3FEEF7C2,0x4B172854,
	0x40051062,0x4DD2F1AA, 0x3FEEFADE,0xEEA91E92,
	0x4005126E,0x978D4FDF, 0x3FEEFDFB,0x44CA4FC1,
	0x4005147A,0xE147AE14, 0x3FEF0117,0x4D89C8B3,
	0x40051687,0x2B020C4A, 0x3FEF0433,0x08F691DD,
	0x40051893,0x74BC6A7F, 0x3FEF074E,0x771FAF4D,
	0x40051A9F,0xBE76C8B4, 0x3FEF0A69,0x981420B6,
	0x40051CAC,0x083126E9, 0x3FEF0D84,0x6BE2E16B,
	0x40051EB8,0x51EB851F, 0x3FEF109E,0xF29AE866,
	0x400520C4,0x9BA5E354, 0x3FEF13B9,0x2C4B2842,
	0x400522D0,0xE5604189, 0x3FEF16D3,0x19028F46,
	0x400524DD,0x2F1A9FBE, 0x3FEF19EC,0xB8D0075F,
	0x400526E9,0x78D4FDF4, 0x3FEF1D06,0x0BC27629,
	0x400528F5,0xC28F5C29, 0x3FEF201F,0x11E8BCE5,
	0x40052B02,0x0C49BA5E, 0x3FEF2337,0xCB51B88A,
	0x40052D0E,0x56041893, 0x3FEF2650,0x380C41BA,
	0x40052F1A,0x9FBE76C9, 0x3FEF2968,0x58272CCC,
	0x40053126,0xE978D4FE, 0x3FEF2C80,0x2BB149C6,
	0x40053333,0x33333333, 0x3FEF2F97,0xB2B96465,
	0x4005353F,0x7CED9168, 0x3FEF32AE,0xED4E441E,
	0x4005374B,0xC6A7EF9E, 0x3FEF35C5,0xDB7EAC1D,
	0x40053958,0x10624DD3, 0x3FEF38DC,0x7D595B45,
	0x40053B64,0x5A1CAC08, 0x3FEF3BF2,0xD2ED0C38,
	0x40053D70,0xA3D70A3D, 0x3FEF3F08,0xDC487554,
	0x40053F7C,0xED916873, 0x3FEF421E,0x997A48B7,
	0x40054189,0x374BC6A8, 0x3FEF4534,0x0A91343C,
	0x40054395,0x810624DD, 0x3FEF4849,0x2F9BE182,
	0x400545A1,0xCAC08312, 0x3FEF4B5E,0x08A8F5EC,
	0x400547AE,0x147AE148, 0x3FEF4E72,0x95C712A4,
	0x400549BA,0x5E353F7D, 0x3FEF5186,0xD704D496,
	0x40054BC6,0xA7EF9DB2, 0x3FEF549A,0xCC70D479,
	0x40054DD2,0xF1A9FBE7, 0x3FEF57AE,0x7619A6D1,
	0x40054FDF,0x3B645A1D, 0x3FEF5AC1,0xD40DDBEB,
	0x400551EB,0x851EB852, 0x3FEF5DD4,0xE65BFFDF,
	0x400553F7,0xCED91687, 0x3FEF60E7,0xAD129A99,
	0x40055604,0x189374BC, 0x3FEF63FA,0x28402FD2,
	0x40055810,0x624DD2F2, 0x3FEF670C,0x57F33F18,
	0x40055A1C,0xAC083127, 0x3FEF6A1E,0x3C3A43C8,
	0x40055C28,0xF5C28F5C, 0x3FEF6D2F,0xD523B51B,
	0x40055E35,0x3F7CED91, 0x3FEF7041,0x22BE061B,
	0x40056041,0x89374BC7, 0x3FEF7352,0x2517A5B0,
	0x4005624D,0xD2F1A9FC, 0x3FEF7662,0xDC3EFE97,
	0x4005645A,0x1CAC0831, 0x3FEF7973,0x4842776B,
	0x40056666,0x66666666, 0x3FEF7C83,0x693072A6,
	0x40056872,0xB020C49C, 0x3FEF7F93,0x3F174EA1,
	0x40056A7E,0xF9DB22D1, 0x3FEF82A2,0xCA056590,
	0x40056C8B,0x43958106, 0x3FEF85B2,0x0A090D90,
	0x40056E97,0x8D4FDF3B, 0x3FEF88C0,0xFF30989E,
	0x400570A3,0xD70A3D71, 0x3FEF8BCF,0xA98A549E,
	0x400572B0,0x20C49BA6, 0x3FEF8EDE,0x09248B58,
	0x400574BC,0x6A7EF9DB, 0x3FEF91EC,0x1E0D827F,
	0x400576C8,0xB4395810, 0x3FEF94F9,0xE8537BAF,
	0x400578D4,0xFDF3B646, 0x3FEF9807,0x6804B473,
	0x40057AE1,0x47AE147B, 0x3FEF9B14,0x9D2F663B,
	0x40057CED,0x916872B0, 0x3FEF9E21,0x87E1C66C,
	0x40057EF9,0xDB22D0E5, 0x3FEFA12E,0x282A065B,
	0x40058106,0x24DD2F1B, 0x3FEFA43A,0x7E16534D,
	0x40058312,0x6E978D50, 0x3FEFA746,0x89B4D678,
	0x4005851E,0xB851EB85, 0x3FEFAA52,0x4B13B50C,
	0x4005872B,0x020C49BA, 0x3FEFAD5D,0xC241102C,
	0x40058937,0x4BC6A7F0, 0x3FEFB068,0xEF4B04F4,
	0x40058B43,0x95810625, 0x3FEFB373,0xD23FAC78,
	0x40058D4F,0xDF3B645A, 0x3FEFB67E,0x6B2D1BC8,
	0x40058F5C,0x28F5C28F, 0x3FEFB988,0xBA2163F0,
	0x40059168,0x72B020C5, 0x3FEFBC92,0xBF2A91FD,
	0x40059374,0xBC6A7EFA, 0x3FEFBF9C,0x7A56AEF6,
	0x40059581,0x0624DD2F, 0x3FEFC2A5,0xEBB3BFE6,
	0x4005978D,0x4FDF3B64, 0x3FEFC5AF,0x134FC5DC,
	0x40059999,0x9999999A, 0x3FEFC8B7,0xF138BDEA,
	0x40059BA5,0xE353F7CF, 0x3FEFCBC0,0x857CA125,
	0x40059DB2,0x2D0E5604, 0x3FEFCEC8,0xD02964AB,
	0x40059FBE,0x76C8B439, 0x3FEFD1D0,0xD14CF9A5,
	0x4005A1CA,0xC083126F, 0x3FEFD4D8,0x88F54D43,
	0x4005A3D7,0x0A3D70A4, 0x3FEFD7DF,0xF73048C1,
	0x4005A5E3,0x53F7CED9, 0x3FEFDAE7,0x1C0BD168,
	0x4005A7EF,0x9DB22D0E, 0x3FEFDDED,0xF795C891,
	0x4005A9FB,0xE76C8B44, 0x3FEFE0F4,0x89DC0BA5,
	0x4005AC08,0x3126E979, 0x3FEFE3FA,0xD2EC741B,
	0x4005AE14,0x7AE147AE, 0x3FEFE700,0xD2D4D783,
	0x4005B020,0xC49BA5E3, 0x3FEFEA06,0x89A3077C,
	0x4005B22D,0x0E560419, 0x3FEFED0B,0xF764D1BF,
	0x4005B439,0x5810624E, 0x3FEFF011,0x1C280019,
	0x4005B645,0xA1CAC083, 0x3FEFF315,0xF7FA5873,
	0x4005B851,0xEB851EB8, 0x3FEFF61A,0x8AE99CCE,
	0x4005BA5E,0x353F7CEE, 0x3FEFF91E,0xD5038B4C,
	0x4005BC6A,0x7EF9DB23, 0x3FEFFC22,0xD655DE23,
	0x4005BE76,0xC8B43958, 0x3FEFFF26,0x8EEE4BB0,
	0x4005C083,0x126E978D, 0x3FF00114,0xFF6D4337,
	0x4005C28F,0x5C28F5C3, 0x3FF00296,0x93141E7C,
	0x4005C49B,0xA5E353F8, 0x3FF00418,0x02728D08,
	0x4005C6A7,0xEF9DB22D, 0x3FF00599,0x4D8F624B,
	0x4005C8B4,0x39581062, 0x3FF0071A,0x74716FCC,
	0x4005CAC0,0x83126E98, 0x3FF0089B,0x771F8524,
	0x4005CCCC,0xCCCCCCCD, 0x3FF00A1C,0x55A06FFF,
	0x4005CED9,0x16872B02, 0x3FF00B9D,0x0FFAFC21,
	0x4005D0E5,0x60418937, 0x3FF00D1D,0xA635F361,
	0x4005D2F1,0xA9FBE76D, 0x3FF00E9E,0x18581DB1,
	0x4005D4FD,0xF3B645A2, 0x3FF0101E,0x66684116,
	0x4005D70A,0x3D70A3D7, 0x3FF0119E,0x906D21AE,
	0x4005D916,0x872B020C, 0x3FF0131E,0x966D81B1,
	0x4005DB22,0xD0E56042, 0x3FF0149E,0x78702172,
	0x4005DD2F,0x1A9FBE77, 0x3FF0161E,0x367BBF5A,
	0x4005DF3B,0x645A1CAC, 0x3FF0179D,0xD09717F0,
	0x4005E147,0xAE147AE1, 0x3FF0191D,0x46C8E5D6,
	0x4005E353,0xF7CED917, 0x3FF01A9C,0x9917E1CC,
	0x4005E560,0x4189374C, 0x3FF01C1B,0xC78AC2AA,
	0x4005E76C,0x8B439581, 0x3FF01D9A,0xD2283D6B,
	0x4005E978,0xD4FDF3B6, 0x3FF01F19,0xB8F70527,
	0x4005EB85,0x1EB851EC, 0x3FF02098,0x7BFDCB15,
	0x4005ED91,0x6872B021, 0x3FF02217,0x1B433E8B,
	0x4005EF9D,0xB22D0E56, 0x3FF02395,0x96CE0CFF,
	0x4005F1A9,0xFBE76C8B, 0x3FF02513,0xEEA4E20C,
	0x4005F3B6,0x45A1CAC1, 0x3FF02692,0x22CE676C,
	0x4005F5C2,0x8F5C28F6, 0x3FF02810,0x335144FB,
	0x4005F7CE,0xD916872B, 0x3FF0298E,0x203420BB,
	0x4005F9DB,0x22D0E560, 0x3FF02B0B,0xE97D9ED0,
	0x4005FBE7,0x6C8B4396, 0x3FF02C89,0x8F346184,
	0x4005FDF3,0xB645A1CB, 0x3FF02E07,0x115F0945,
	0x40060000,0x00000000, 0x3FF02F84,0x700434A8,
	0x4006020C,0x49BA5E35, 0x3FF03101,0xAB2A806A,
	0x40060418,0x9374BC6A, 0x3FF0327E,0xC2D8876E,
	0x40060624,0xDD2F1AA0, 0x3FF033FB,0xB714E2C1,
	0x40060831,0x26E978D5, 0x3FF03578,0x87E62995,
	0x40060A3D,0x70A3D70A, 0x3FF036F5,0x3552F149,
	0x40060C49,0xBA5E353F, 0x3FF03871,0xBF61CD65,
	0x40060E56,0x04189375, 0x3FF039EE,0x26194F9E,
	0x40061062,0x4DD2F1AA, 0x3FF03B6A,0x698007D2,
	0x4006126E,0x978D4FDF, 0x3FF03CE6,0x899C840C,
	0x4006147A,0xE147AE14, 0x3FF03E62,0x86755083,
	0x40061687,0x2B020C4A, 0x3FF03FDE,0x6010F7A0,
	0x40061893,0x74BC6A7F, 0x3FF0415A,0x167601F5,
	0x40061A9F,0xBE76C8B4, 0x3FF042D5,0xA9AAF645,
	0x40061CAC,0x083126E9, 0x3FF04451,0x19B65984,
	0x40061EB8,0x51EB851F, 0x3FF045CC,0x669EAED6,
	0x400620C4,0x9BA5E354, 0x3FF04747,0x906A778D,
	0x400622D0,0xE5604189, 0x3FF048C2,0x97203330,
	0x400624DD,0x2F1A9FBE, 0x3FF04A3D,0x7AC65F77,
	0x400626E9,0x78D4FDF4, 0x3FF04BB8,0x3B637850,
	0x400628F5,0xC28F5C29, 0x3FF04D32,0xD8FDF7D6,
	0x40062B02,0x0C49BA5E, 0x3FF04EAD,0x539C565E,
	0x40062D0E,0x56041893, 0x3FF05027,0xAB450A72,
	0x40062F1A,0x9FBE76C9, 0x3FF051A1,0xDFFE88CF,
	0x40063126,0xE978D4FE, 0x3FF0531B,0xF1CF4468,
	0x40063333,0x33333333, 0x3FF05495,0xE0BDAE6B,
	0x4006353F,0x7CED9168, 0x3FF0560F,0xACD03639,
	0x4006374B,0xC6A7EF9E, 0x3FF05789,0x560D496F,
	0x40063958,0x10624DD3, 0x3FF05902,0xDC7B53E1,
	0x40063B64,0x5A1CAC08, 0x3FF05A7C,0x4020BF9D,
	0x40063D70,0xA3D70A3D, 0x3FF05BF5,0x8103F4EA,
	0x40063F7C,0xED916873, 0x3FF05D6E,0x9F2B5A4F,
	0x40064189,0x374BC6A8, 0x3FF05EE7,0x9A9D5486,
	0x40064395,0x810624DD, 0x3FF06060,0x7360468E,
	0x400645A1,0xCAC08312, 0x3FF061D9,0x297A919D,
	0x400647AE,0x147AE148, 0x3FF06351,0xBCF2952A,
	0x400649BA,0x5E353F7D, 0x3FF064CA,0x2DCEAEE7,
	0x40064BC6,0xA7EF9DB2, 0x3FF06642,0x7C153AC7,
	0x40064DD2,0xF1A9FBE7, 0x3FF067BA,0xA7CC92FD,
	0x40064FDF,0x3B645A1D, 0x3FF06932,0xB0FB0FFB,
	0x400651EB,0x851EB852, 0x3FF06AAA,0x97A70873,
	0x400653F7,0xCED91687, 0x3FF06C22,0x5BD6D15A,
	0x40065604,0x189374BC, 0x3FF06D99,0xFD90BDE6,
	0x40065810,0x624DD2F2, 0x3FF06F11,0x7CDB1F91,
	0x40065A1C,0xAC083127, 0x3FF07088,0xD9BC4616,
	0x40065C28,0xF5C28F5C, 0x3FF07200,0x143A7F76,
	0x40065E35,0x3F7CED91, 0x3FF07377,0x2C5C17F6,
	0x40066041,0x89374BC7, 0x3FF074EE,0x22275A21,
	0x4006624D,0xD2F1A9FC, 0x3FF07664,0xF5A28EC5,
	0x4006645A,0x1CAC0831, 0x3FF077DB,0xA6D3FCF9,
	0x40066666,0x66666666, 0x3FF07952,0x35C1EA1B,
	0x40066872,0xB020C49C, 0x3FF07AC8,0xA27299D2,
	0x40066A7E,0xF9DB22D1, 0x3FF07C3E,0xECEC4E08,
	0x40066C8B,0x43958106, 0x3FF07DB5,0x153546F7,
	0x40066E97,0x8D4FDF3B, 0x3FF07F2B,0x1B53C31E,
	0x400670A3,0xD70A3D71, 0x3FF080A0,0xFF4DFF48,
	0x400672B0,0x20C49BA6, 0x3FF08216,0xC12A368A,
	0x400674BC,0x6A7EF9DB, 0x3FF0838C,0x60EEA245,
	0x400676C8,0xB4395810, 0x3FF08501,0xDEA17A27,
	0x400678D4,0xFDF3B646, 0x3FF08677,0x3A48F42A,
	0x40067AE1,0x47AE147B, 0x3FF087EC,0x73EB4494,
	0x40067CED,0x916872B0, 0x3FF08961,0x8B8E9DFA,
	0x40067EF9,0xDB22D0E5, 0x3FF08AD6,0x81393141,
	0x40068106,0x24DD2F1B, 0x3FF08C4B,0x54F12D9D,
	0x40068312,0x6E978D50, 0x3FF08DC0,0x06BCC08E,
	0x4006851E,0xB851EB85, 0x3FF08F34,0x96A215E9,
	0x4006872B,0x020C49BA, 0x3FF090A9,0x04A757D3,
	0x40068937,0x4BC6A7F0, 0x3FF0921D,0x50D2AEC2,
	0x40068B43,0x95810625, 0x3FF09391,0x7B2A417C,
	0x40068D4F,0xDF3B645A, 0x3FF09505,0x83B4351F,
	0x40068F5C,0x28F5C28F, 0x3FF09679,0x6A76AD19,
	0x40069168,0x72B020C5, 0x3FF097ED,0x2F77CB2C,
	0x40069374,0xBC6A7EFA, 0x3FF09960,0xD2BDAF71,
	0x40069581,0x0624DD2F, 0x3FF09AD4,0x544E7853,
	0x4006978D,0x4FDF3B64, 0x3FF09C47,0xB4304297,
	0x40069999,0x9999999A, 0x3FF09DBA,0xF2692955,
	0x40069BA5,0xE353F7CF, 0x3FF09F2E,0x0EFF45FD,
	0x40069DB2,0x2D0E5604, 0x3FF0A0A1,0x09F8B059,
	0x40069FBE,0x76C8B439, 0x3FF0A213,0xE35B7E88,
	0x4006A1CA,0xC083126F, 0x3FF0A386,0x9B2DC505,
	0x4006A3D7,0x0A3D70A4, 0x3FF0A4F9,0x317596A2,
	0x4006A5E3,0x53F7CED9, 0x3FF0A66B,0xA639048C,
	0x4006A7EF,0x9DB22D0E, 0x3FF0A7DD,0xF97E1E4B,
	0x4006A9FB,0xE76C8B44, 0x3FF0A950,0x2B4AF1C3,
	0x4006AC08,0x3126E979, 0x3FF0AAC2,0x3BA58B32,
	0x4006AE14,0x7AE147AE, 0x3FF0AC34,0x2A93F534,
	0x4006B020,0xC49BA5E3, 0x3FF0ADA5,0xF81C38C2,
	0x4006B22D,0x0E560419, 0x3FF0AF17,0xA4445D33,
	0x4006B439,0x5810624E, 0x3FF0B089,0x2F12683B,
	0x4006B645,0xA1CAC083, 0x3FF0B1FA,0x988C5DED,
	0x4006B851,0xEB851EB8, 0x3FF0B36B,0xE0B840BD,
	0x4006BA5E,0x353F7CEE, 0x3FF0B4DD,0x079C117E,
	0x4006BC6A,0x7EF9DB23, 0x3FF0B64E,0x0D3DCF63,
	0x4006BE76,0xC8B43958, 0x3FF0B7BE,0xF1A37801,
	0x4006C083,0x126E978D, 0x3FF0B92F,0xB4D3074F,
	0x4006C28F,0x5C28F5C3, 0x3FF0BAA0,0x56D277A7,
	0x4006C49B,0xA5E353F8, 0x3FF0BC10,0xD7A7C1C3,
	0x4006C6A7,0xEF9DB22D, 0x3FF0BD81,0x3758DCC4,
	0x4006C8B4,0x39581062, 0x3FF0BEF1,0x75EBBE2E,
	0x4006CAC0,0x83126E98, 0x3FF0C061,0x936659E8,
	0x4006CCCC,0xCCCCCCCD, 0x3FF0C1D1,0x8FCEA241,
	0x4006CED9,0x16872B02, 0x3FF0C341,0x6B2A87EB,
	0x4006D0E5,0x60418937, 0x3FF0C4B1,0x257FFA02,
	0x4006D2F1,0xA9FBE76D, 0x3FF0C620,0xBED4E606,
	0x4006D4FD,0xF3B645A2, 0x3FF0C790,0x372F37DE,
	0x4006D70A,0x3D70A3D7, 0x3FF0C8FF,0x8E94D9DD,
	0x4006D916,0x872B020C, 0x3FF0CA6E,0xC50BB4BB,
	0x4006DB22,0xD0E56042, 0x3FF0CBDD,0xDA99AF9C,
	0x4006DD2F,0x1A9FBE77, 0x3FF0CD4C,0xCF44B00B,
	0x4006DF3B,0x645A1CAC, 0x3FF0CEBB,0xA31299FF,
	0x4006E147,0xAE147AE1, 0x3FF0D02A,0x56094FDB,
	0x4006E353,0xF7CED917, 0x3FF0D198,0xE82EB26C,
	0x4006E560,0x4189374C, 0x3FF0D307,0x5988A0EC,
	0x4006E76C,0x8B439581, 0x3FF0D475,0xAA1CF900,
	0x4006E978,0xD4FDF3B6, 0x3FF0D5E3,0xD9F196BD,
	0x4006EB85,0x1EB851EC, 0x3FF0D751,0xE90C54A5,
	0x4006ED91,0x6872B021, 0x3FF0D8BF,0xD7730BA6,
	0x4006EF9D,0xB22D0E56, 0x3FF0DA2D,0xA52B931F,
	0x4006F1A9,0xFBE76C8B, 0x3FF0DB9B,0x523BC0DF,
	0x4006F3B6,0x45A1CAC1, 0x3FF0DD08,0xDEA96924,
	0x4006F5C2,0x8F5C28F6, 0x3FF0DE76,0x4A7A5E9D,
	0x4006F7CE,0xD916872B, 0x3FF0DFE3,0x95B47269,
	0x4006F9DB,0x22D0E560, 0x3FF0E150,0xC05D741B,
	0x4006FBE7,0x6C8B4396, 0x3FF0E2BD,0xCA7B31B7,
	0x4006FDF3,0xB645A1CB, 0x3FF0E42A,0xB41377B3,
	0x40070000,0x00000000, 0x3FF0E597,0x7D2C10F9,
	0x4007020C,0x49BA5E35, 0x3FF0E704,0x25CAC6E9,
	0x40070418,0x9374BC6A, 0x3FF0E870,0xADF56154,
	0x40070624,0xDD2F1AA0, 0x3FF0E9DD,0x15B1A683,
	0x40070831,0x26E978D5, 0x3FF0EB49,0x5D055B32,
	0x40070A3D,0x70A3D70A, 0x3FF0ECB5,0x83F64295,
	0x40070C49,0xBA5E353F, 0x3FF0EE21,0x8A8A1E56,
	0x40070E56,0x04189375, 0x3FF0EF8D,0x70C6AE98,
	0x40071062,0x4DD2F1AA, 0x3FF0F0F9,0x36B1B1F1,
	0x4007126E,0x978D4FDF, 0x3FF0F264,0xDC50E575,
	0x4007147A,0xE147AE14, 0x3FF0F3D0,0x61AA04AD,
	0x40071687,0x2B020C4A, 0x3FF0F53B,0xC6C2C99E,
	0x40071893,0x74BC6A7F, 0x3FF0F6A7,0x0BA0ECC4,
	0x40071A9F,0xBE76C8B4, 0x3FF0F812,0x304A2517,
	0x40071CAC,0x083126E9, 0x3FF0F97D,0x34C4280C,
	0x40071EB8,0x51EB851F, 0x3FF0FAE8,0x1914A991,
	0x400720C4,0x9BA5E354, 0x3FF0FC52,0xDD415C10,
	0x400722D0,0xE5604189, 0x3FF0FDBD,0x814FF072,
	0x400724DD,0x2F1A9FBE, 0x3FF0FF28,0x05461619,
	0x400726E9,0x78D4FDF4, 0x3FF10092,0x69297AEB,
	0x400728F5,0xC28F5C29, 0x3FF101FC,0xACFFCB45,
	0x40072B02,0x0C49BA5E, 0x3FF10366,0xD0CEB208,
	0x40072D0E,0x56041893, 0x3FF104D0,0xD49BD892,
	0x40072F1A,0x9FBE76C9, 0x3FF1063A,0xB86CE6C3,
	0x40073126,0xE978D4FE, 0x3FF107A4,0x7C4782F9,
	0x40073333,0x33333333, 0x3FF1090E,0x20315212,
	0x4007353F,0x7CED9168, 0x3FF10A77,0xA42FF772,
	0x4007374B,0xC6A7EF9E, 0x3FF10BE1,0x084914FB,
	0x40073958,0x10624DD3, 0x3FF10D4A,0x4C824B11,
	0x40073B64,0x5A1CAC08, 0x3FF10EB3,0x70E1389F,
	0x40073D70,0xA3D70A3D, 0x3FF1101C,0x756B7B10,
	0x40073F7C,0xED916873, 0x3FF11185,0x5A26AE55,
	0x40074189,0x374BC6A8, 0x3FF112EE,0x1F186CE1,
	0x40074395,0x810624DD, 0x3FF11456,0xC4464FAF,
	0x400745A1,0xCAC08312, 0x3FF115BF,0x49B5EE3E,
	0x400747AE,0x147AE148, 0x3FF11727,0xAF6CDE95,
	0x400749BA,0x5E353F7D, 0x3FF1188F,0xF570B53E,
	0x40074BC6,0xA7EF9DB2, 0x3FF119F8,0x1BC7054E,
	0x40074DD2,0xF1A9FBE7, 0x3FF11B60,0x22756060,
	0x40074FDF,0x3B645A1D, 0x3FF11CC8,0x09815697,
	0x400751EB,0x851EB852, 0x3FF11E2F,0xD0F0769F,
	0x400753F7,0xCED91687, 0x3FF11F97,0x78C84DAE,
	0x40075604,0x189374BC, 0x3FF120FF,0x010E6781,
	0x40075810,0x624DD2F2, 0x3FF12266,0x69C84E65,
	0x40075A1C,0xAC083127, 0x3FF123CD,0xB2FB8B2A,
	0x40075C28,0xF5C28F5C, 0x3FF12534,0xDCADA532,
	0x40075E35,0x3F7CED91, 0x3FF1269B,0xE6E42267,
	0x40076041,0x89374BC7, 0x3FF12802,0xD1A48742,
	0x4007624D,0xD2F1A9FC, 0x3FF12969,0x9CF456C5,
	0x4007645A,0x1CAC0831, 0x3FF12AD0,0x48D91284,
	0x40076666,0x66666666, 0x3FF12C36,0xD5583A9D,
	0x40076872,0xB020C49C, 0x3FF12D9D,0x42774DBE,
	0x40076A7E,0xF9DB22D1, 0x3FF12F03,0x903BC924,
	0x40076C8B,0x43958106, 0x3FF13069,0xBEAB289B,
	0x40076E97,0x8D4FDF3B, 0x3FF131CF,0xCDCAE67F,
	0x400770A3,0xD70A3D71, 0x3FF13335,0xBDA07BBD,
	0x400772B0,0x20C49BA6, 0x3FF1349B,0x8E315FD0,
	0x400774BC,0x6A7EF9DB, 0x3FF13601,0x3F8308C7,
	0x400776C8,0xB4395810, 0x3FF13766,0xD19AEB43,
	0x400778D4,0xFDF3B646, 0x3FF138CC,0x447E7A78,
	0x40077AE1,0x47AE147B, 0x3FF13A31,0x98332829,
	0x40077CED,0x916872B0, 0x3FF13B96,0xCCBE64B0,
	0x40077EF9,0xDB22D0E5, 0x3FF13CFB,0xE2259EFA,
	0x40078106,0x24DD2F1B, 0x3FF13E60,0xD86E4488,
	0x40078312,0x6E978D50, 0x3FF13FC5,0xAF9DC16F,
	0x4007851E,0xB851EB85, 0x3FF1412A,0x67B9805B,
	0x4007872B,0x020C49BA, 0x3FF1428F,0x00C6EA8D,
	0x40078937,0x4BC6A7F0, 0x3FF143F3,0x7ACB67DD,
	0x40078B43,0x95810625, 0x3FF14557,0xD5CC5EB8,
	0x40078D4F,0xDF3B645A, 0x3FF146BC,0x11CF3424,
	0x40078F5C,0x28F5C28F, 0x3FF14820,0x2ED94BBF,
	0x40079168,0x72B020C5, 0x3FF14984,0x2CF007BE,
	0x40079374,0xBC6A7EFA, 0x3FF14AE8,0x0C18C8F0,
	0x40079581,0x0624DD2F, 0x3FF14C4B,0xCC58EEBB,
	0x4007978D,0x4FDF3B64, 0x3FF14DAF,0x6DB5D722,
	0x40079999,0x9999999A, 0x3FF14F12,0xF034DEC0,
	0x40079BA5,0xE353F7CF, 0x3FF15076,0x53DB60CC,
	0x40079DB2,0x2D0E5604, 0x3FF151D9,0x98AEB716,
	0x40079FBE,0x76C8B439, 0x3FF1533C,0xBEB43A0D,
	0x4007A1CA,0xC083126F, 0x3FF1549F,0xC5F140B9,
	0x4007A3D7,0x0A3D70A4, 0x3FF15602,0xAE6B20C1,
	0x4007A5E3,0x53F7CED9, 0x3FF15765,0x78272E68,
	0x4007A7EF,0x9DB22D0E, 0x3FF158C8,0x232ABC8D,
	0x4007A9FB,0xE76C8B44, 0x3FF15A2A,0xAF7B1CB3,
	0x4007AC08,0x3126E979, 0x3FF15B8D,0x1D1D9EF3,
	0x4007AE14,0x7AE147AE, 0x3FF15CEF,0x6C17920B,
	0x4007B020,0xC49BA5E3, 0x3FF15E51,0x9C6E4358,
	0x4007B22D,0x0E560419, 0x3FF15FB3,0xAE26FED6,
	0x4007B439,0x5810624E, 0x3FF16115,0xA1470F20,
	0x4007B645,0xA1CAC083, 0x3FF16277,0x75D3BD74,
	0x4007B851,0xEB851EB8, 0x3FF163D9,0x2BD251B1,
	0x4007BA5E,0x353F7CEE, 0x3FF1653A,0xC3481258,
	0x4007BC6A,0x7EF9DB23, 0x3FF1669C,0x3C3A448C,
	0x4007BE76,0xC8B43958, 0x3FF167FD,0x96AE2C12,
	0x4007C083,0x126E978D, 0x3FF1695E,0xD2A90B55,
	0x4007C28F,0x5C28F5C3, 0x3FF16ABF,0xF0302361,
	0x4007C49B,0xA5E353F8, 0x3FF16C20,0xEF48B3E8,
	0x4007C6A7,0xEF9DB22D, 0x3FF16D81,0xCFF7FB3E,
	0x4007C8B4,0x39581062, 0x3FF16EE2,0x92433660,
	0x4007CAC0,0x83126E98, 0x3FF17043,0x362FA0EF,
	0x4007CCCC,0xCCCCCCCD, 0x3FF171A3,0xBBC27531,
	0x4007CED9,0x16872B02, 0x3FF17304,0x2300EC13,
	0x4007D0E5,0x60418937, 0x3FF17464,0x6BF03D2B,
	0x4007D2F1,0xA9FBE76D, 0x3FF175C4,0x96959EB5,
	0x4007D4FD,0xF3B645A2, 0x3FF17724,0xA2F64594,
	0x4007D70A,0x3D70A3D7, 0x3FF17884,0x91176555,
	0x4007D916,0x872B020C, 0x3FF179E4,0x60FE302E,
	0x4007DB22,0xD0E56042, 0x3FF17B44,0x12AFD6FD,
	0x4007DD2F,0x1A9FBE77, 0x3FF17CA3,0xA631894A,
	0x4007DF3B,0x645A1CAC, 0x3FF17E03,0x1B887548,
	0x4007E147,0xAE147AE1, 0x3FF17F62,0x72B9C7D5,
	0x4007E353,0xF7CED917, 0x3FF180C1,0xABCAAC7B,
	0x4007E560,0x4189374C, 0x3FF18220,0xC6C04D6C,
	0x4007E76C,0x8B439581, 0x3FF1837F,0xC39FD38A,
	0x4007E978,0xD4FDF3B6, 0x3FF184DE,0xA26E6661,
	0x4007EB85,0x1EB851EC, 0x3FF1863D,0x63312C2C,
	0x4007ED91,0x6872B021, 0x3FF1879C,0x05ED49D2,
	0x4007EF9D,0xB22D0E56, 0x3FF188FA,0x8AA7E2E8,
	0x4007F1A9,0xFBE76C8B, 0x3FF18A58,0xF16619B3,
	0x4007F3B6,0x45A1CAC1, 0x3FF18BB7,0x3A2D0F25,
	0x4007F5C2,0x8F5C28F6, 0x3FF18D15,0x6501E2DF,
	0x4007F7CE,0xD916872B, 0x3FF18E73,0x71E9B333,
	0x4007F9DB,0x22D0E560, 0x3FF18FD1,0x60E99D24,
	0x4007FBE7,0x6C8B4396, 0x3FF1912F,0x3206BC63,
	0x4007FDF3,0xB645A1CB, 0x3FF1928C,0xE5462B53,
	0x40080000,0x00000000, 0x3FF193EA,0x7AAD030B,
	0x4008020C,0x49BA5E35, 0x3FF19547,0xF2405B4F,
	0x40080418,0x9374BC6A, 0x3FF196A5,0x4C054A9B,
	0x40080624,0xDD2F1AA0, 0x3FF19802,0x8800E61A,
	0x40080831,0x26E978D5, 0x3FF1995F,0xA63841AC,
	0x40080A3D,0x70A3D70A, 0x3FF19ABC,0xA6B06FE2,
	0x40080C49,0xBA5E353F, 0x3FF19C19,0x896E8206,
	0x40080E56,0x04189375, 0x3FF19D76,0x4E778813,
	0x40081062,0x4DD2F1AA, 0x3FF19ED2,0xF5D090B9,
	0x4008126E,0x978D4FDF, 0x3FF1A02F,0x7F7EA960,
	0x4008147A,0xE147AE14, 0x3FF1A18B,0xEB86DE23,
	0x40081687,0x2B020C4A, 0x3FF1A2E8,0x39EE39D7,
	0x40081893,0x74BC6A7F, 0x3FF1A444,0x6AB9C603,
	0x40081A9F,0xBE76C8B4, 0x3FF1A5A0,0x7DEE8AE9,
	0x40081CAC,0x083126E9, 0x3FF1A6FC,0x73918F81,
	0x40081EB8,0x51EB851F, 0x3FF1A858,0x4BA7D97D,
	0x400820C4,0x9BA5E354, 0x3FF1A9B4,0x06366D45,
	0x400822D0,0xE5604189, 0x3FF1AB0F,0xA3424DFC,
	0x400824DD,0x2F1A9FBE, 0x3FF1AC6B,0x22D07D7D,
	0x400826E9,0x78D4FDF4, 0x3FF1ADC6,0x84E5FC5E,
	0x400828F5,0xC28F5C29, 0x3FF1AF21,0xC987C9EE,
	0x40082B02,0x0C49BA5E, 0x3FF1B07C,0xF0BAE438,
	0x40082D0E,0x56041893, 0x3FF1B1D7,0xFA844801,
	0x40082F1A,0x9FBE76C9, 0x3FF1B332,0xE6E8F0CC,
	0x40083126,0xE978D4FE, 0x3FF1B48D,0xB5EDD8D4,
	0x40083333,0x33333333, 0x3FF1B5E8,0x6797F915,
	0x4008353F,0x7CED9168, 0x3FF1B742,0xFBEC4943,
	0x4008374B,0xC6A7EF9E, 0x3FF1B89D,0x72EFBFD4,
	0x40083958,0x10624DD3, 0x3FF1B9F7,0xCCA751F8,
	0x40083B64,0x5A1CAC08, 0x3FF1BB52,0x0917F39F,
	0x40083D70,0xA3D70A3D, 0x3FF1BCAC,0x28469777,
	0x40083F7C,0xED916873, 0x3FF1BE06,0x2A382EEF,
	0x40084189,0x374BC6A8, 0x3FF1BF60,0x0EF1AA32,
	0x40084395,0x810624DD, 0x3FF1C0B9,0xD677F82D,
	0x400845A1,0xCAC08312, 0x3FF1C213,0x80D0068C,
	0x400847AE,0x147AE148, 0x3FF1C36D,0x0DFEC1BE,
	0x400849BA,0x5E353F7D, 0x3FF1C4C6,0x7E0914F0,
	0x40084BC6,0xA7EF9DB2, 0x3FF1C61F,0xD0F3EA13,
	0x40084DD2,0xF1A9FBE7, 0x3FF1C779,0x06C429D9,
	0x40084FDF,0x3B645A1D, 0x3FF1C8D2,0x1F7EBBB6,
	0x400851EB,0x851EB852, 0x3FF1CA2B,0x1B2885E1,
	0x400853F7,0xCED91687, 0x3FF1CB83,0xF9C66D55,
	0x40085604,0x189374BC, 0x3FF1CCDC,0xBB5D55CF,
	0x40085810,0x624DD2F2, 0x3FF1CE35,0x5FF221D3,
	0x40085A1C,0xAC083127, 0x3FF1CF8D,0xE789B2A5,
	0x40085C28,0xF5C28F5C, 0x3FF1D0E6,0x5228E852,
	0x40085E35,0x3F7CED91, 0x3FF1D23E,0x9FD4A1A9,
	0x40086041,0x89374BC7, 0x3FF1D396,0xD091BC42,
	0x4008624D,0xD2F1A9FC, 0x3FF1D4EE,0xE4651479,
	0x4008645A,0x1CAC0831, 0x3FF1D646,0xDB538570,
	0x40086666,0x66666666, 0x3FF1D79E,0xB561E911,
	0x40086872,0xB020C49C, 0x3FF1D8F6,0x7295180E,
	0x40086A7E,0xF9DB22D1, 0x3FF1DA4E,0x12F1E9DF,
	0x40086C8B,0x43958106, 0x3FF1DBA5,0x967D34C5,
	0x40086E97,0x8D4FDF3B, 0x3FF1DCFC,0xFD3BCDCA,
	0x400870A3,0xD70A3D71, 0x3FF1DE54,0x473288C1,
	0x400872B0,0x20C49BA6, 0x3FF1DFAB,0x74663845,
	0x400874BC,0x6A7EF9DB, 0x3FF1E102,0x84DBADBD,
	0x400876C8,0xB4395810, 0x3FF1E259,0x7897B957,
	0x400878D4,0xFDF3B646, 0x3FF1E3B0,0x4F9F2A0F,
	0x40087AE1,0x47AE147B, 0x3FF1E507,0x09F6CDAA,
	0x40087CED,0x916872B0, 0x3FF1E65D,0xA7A370B9,
	0x40087EF9,0xDB22D0E5, 0x3FF1E7B4,0x28A9DE99,
	0x40088106,0x24DD2F1B, 0x3FF1E90A,0x8D0EE173,
	0x40088312,0x6E978D50, 0x3FF1EA60,0xD4D7423B,
	0x4008851E,0xB851EB85, 0x3FF1EBB7,0x0007C8B5,
	0x4008872B,0x020C49BA, 0x3FF1ED0D,0x0EA53B71,
	0x40088937,0x4BC6A7F0, 0x3FF1EE63,0x00B45FCD,
	0x40088B43,0x95810625, 0x3FF1EFB8,0xD639F9F3,
	0x40088D4F,0xDF3B645A, 0x3FF1F10E,0x8F3ACCDF,
	0x40088F5C,0x28F5C28F, 0x3FF1F264,0x2BBB9A5B,
	0x40089168,0x72B020C5, 0x3FF1F3B9,0xABC12300,
	0x40089374,0xBC6A7EFA, 0x3FF1F50F,0x0F502636,
	0x40089581,0x0624DD2F, 0x3FF1F664,0x566D6236,
	0x4008978D,0x4FDF3B64, 0x3FF1F7B9,0x811D9409,
	0x40089999,0x9999999A, 0x3FF1F90E,0x8F65778C,
	0x40089BA5,0xE353F7CF, 0x3FF1FA63,0x8149C768,
	0x40089DB2,0x2D0E5604, 0x3FF1FBB8,0x56CF3D1D,
	0x40089FBE,0x76C8B439, 0x3FF1FD0D,0x0FFA90FA,
	0x4008A1CA,0xC083126F, 0x3FF1FE61,0xACD07A21,
	0x4008A3D7,0x0A3D70A4, 0x3FF1FFB6,0x2D55AE88,
	0x4008A5E3,0x53F7CED9, 0x3FF2010A,0x918EE2F7,
	0x4008A7EF,0x9DB22D0E, 0x3FF2025E,0xD980CB0C,
	0x4008A9FB,0xE76C8B44, 0x3FF203B3,0x05301937,
	0x4008AC08,0x3126E979, 0x3FF20507,0x14A17EBC,
	0x4008AE14,0x7AE147AE, 0x3FF2065B,0x07D9ABB5,
	0x4008B020,0xC49BA5E3, 0x3FF207AE,0xDEDD4F13,
	0x4008B22D,0x0E560419, 0x3FF20902,0x99B1169A,
	0x4008B439,0x5810624E, 0x3FF20A56,0x3859AEE5,
	0x4008B645,0xA1CAC083, 0x3FF20BA9,0xBADBC366,
	0x4008B851,0xEB851EB8, 0x3FF20CFD,0x213BFE64,
	0x4008BA5E,0x353F7CEE, 0x3FF20E50,0x6B7F0900,
	0x4008BC6A,0x7EF9DB23, 0x3FF20FA3,0x99A98B30,
	0x4008BE76,0xC8B43958, 0x3FF210F6,0xABC02BC4,
	0x4008C083,0x126E978D, 0x3FF21249,0xA1C79063,
	0x4008C28F,0x5C28F5C3, 0x3FF2139C,0x7BC45D8E,
	0x4008C49B,0xA5E353F8, 0x3FF214EF,0x39BB369D,
	0x4008C6A7,0xEF9DB22D, 0x3FF21641,0xDBB0BDC4,
	0x4008C8B4,0x39581062, 0x3FF21794,0x61A9940F,
	0x4008CAC0,0x83126E98, 0x3FF218E6,0xCBAA5966,
	0x4008CCCC,0xCCCCCCCD, 0x3FF21A39,0x19B7AC89,
	0x4008CED9,0x16872B02, 0x3FF21B8B,0x4BD62B16,
	0x4008D0E5,0x60418937, 0x3FF21CDD,0x620A7185,
	0x4008D2F1,0xA9FBE76D, 0x3FF21E2F,0x5C591B2A,
	0x4008D4FD,0xF3B645A2, 0x3FF21F81,0x3AC6C235,
	0x4008D70A,0x3D70A3D7, 0x3FF220D2,0xFD57FFB2,
	0x4008D916,0x872B020C, 0x3FF22224,0xA4116B8B,
	0x4008DB22,0xD0E56042, 0x3FF22376,0x2EF79C88,
	0x4008DD2F,0x1A9FBE77, 0x3FF224C7,0x9E0F284B,
	0x4008DF3B,0x645A1CAC, 0x3FF22618,0xF15CA357,
	0x4008E147,0xAE147AE1, 0x3FF2276A,0x28E4A10F,
	0x4008E353,0xF7CED917, 0x3FF228BB,0x44ABB3B1,
	0x4008E560,0x4189374C, 0x3FF22A0C,0x44B66C5C,
	0x4008E76C,0x8B439581, 0x3FF22B5D,0x29095B0E,
	0x4008E978,0xD4FDF3B6, 0x3FF22CAD,0xF1A90EA6,
	0x4008EB85,0x1EB851EC, 0x3FF22DFE,0x9E9A14E3,
	0x4008ED91,0x6872B021, 0x3FF22F4F,0x2FE0FA63,
	0x4008EF9D,0xB22D0E56, 0x3FF2309F,0xA5824AA6,
	0x4008F1A9,0xFBE76C8B, 0x3FF231EF,0xFF82900E,
	0x4008F3B6,0x45A1CAC1, 0x3FF23340,0x3DE653DF,
	0x4008F5C2,0x8F5C28F6, 0x3FF23490,0x60B21E3E,
	0x4008F7CE,0xD916872B, 0x3FF235E0,0x67EA7631,
	0x4008F9DB,0x22D0E560, 0x3FF23730,0x5393E1A5,
	0x4008FBE7,0x6C8B4396, 0x3FF23880,0x23B2E568,
	0x4008FDF3,0xB645A1CB, 0x3FF239CF,0xD84C052A,
	0x40090000,0x00000000, 0x3FF23B1F,0x7163C380,
	0x4009020C,0x49BA5E35, 0x3FF23C6E,0xEEFEA1E5,
	0x40090418,0x9374BC6A, 0x3FF23DBE,0x512120B7,
	0x40090624,0xDD2F1AA0, 0x3FF23F0D,0x97CFBF3A,
	0x40090831,0x26E978D5, 0x3FF2405C,0xC30EFB95,
	0x40090A3D,0x70A3D70A, 0x3FF241AB,0xD2E352D7,
	0x40090C49,0xBA5E353F, 0x3FF242FA,0xC75140F5,
	0x40090E56,0x04189375, 0x3FF24449,0xA05D40CC,
	0x40091062,0x4DD2F1AA, 0x3FF24598,0x5E0BCC1A,
	0x4009126E,0x978D4FDF, 0x3FF246E7,0x00615B8A,
	0x4009147A,0xE147AE14, 0x3FF24835,0x876266AD,
	0x40091687,0x2B020C4A, 0x3FF24983,0xF31363FB,
	0x40091893,0x74BC6A7F, 0x3FF24AD2,0x4378C8D5,
	0x40091A9F,0xBE76C8B4, 0x3FF24C20,0x78970984,
	0x40091CAC,0x083126E9, 0x3FF24D6E,0x9272993A,
	0x40091EB8,0x51EB851F, 0x3FF24EBC,0x910FEA13,
	0x400920C4,0x9BA5E354, 0x3FF2500A,0x74736D15,
	0x400922D0,0xE5604189, 0x3FF25158,0x3CA1922E,
	0x400924DD,0x2F1A9FBE, 0x3FF252A5,0xE99EC839,
	0x400926E9,0x78D4FDF4, 0x3FF253F3,0x7B6F7CFA,
	0x400928F5,0xC28F5C29, 0x3FF25540,0xF2181D20,
	0x40092B02,0x0C49BA5E, 0x3FF2568E,0x4D9D1447,
	0x40092D0E,0x56041893, 0x3FF257DB,0x8E02CCF5,
	0x40092F1A,0x9FBE76C9, 0x3FF25928,0xB34DB09F,
	0x40093126,0xE978D4FE, 0x3FF25A75,0xBD8227A1,
	0x40093333,0x33333333, 0x3FF25BC2,0xACA4994A,
	0x4009353F,0x7CED9168, 0x3FF25D0F,0x80B96BD2,
	0x4009374B,0xC6A7EF9E, 0x3FF25E5C,0x39C50462,
	0x40093958,0x10624DD3, 0x3FF25FA8,0xD7CBC70C,
	0x40093B64,0x5A1CAC08, 0x3FF260F5,0x5AD216D6,
	0x40093D70,0xA3D70A3D, 0x3FF26241,0xC2DC55B0,
	0x40093F7C,0xED916873, 0x3FF2638E,0x0FEEE47C,
	0x40094189,0x374BC6A8, 0x3FF264DA,0x420E2309,
	0x40094395,0x810624DD, 0x3FF26626,0x593E7017,
	0x400945A1,0xCAC08312, 0x3FF26772,0x55842956,
	0x400947AE,0x147AE148, 0x3FF268BE,0x36E3AB65,
	0x400949BA,0x5E353F7D, 0x3FF26A09,0xFD6151D6,
	0x40094BC6,0xA7EF9DB2, 0x3FF26B55,0xA9017729,
	0x40094DD2,0xF1A9FBE7, 0x3FF26CA1,0x39C874D1,
	0x40094FDF,0x3B645A1D, 0x3FF26DEC,0xAFBAA335,
	0x400951EB,0x851EB852, 0x3FF26F38,0x0ADC59A8,
	0x400953F7,0xCED91687, 0x3FF27083,0x4B31EE76,
	0x40095604,0x189374BC, 0x3FF271CE,0x70BFB6D9,
	0x40095810,0x624DD2F2, 0x3FF27319,0x7B8A0702,
	0x40095A1C,0xAC083127, 0x3FF27464,0x6B953210,
	0x40095C28,0xF5C28F5C, 0x3FF275AF,0x40E58A1B,
	0x40095E35,0x3F7CED91, 0x3FF276F9,0xFB7F602D,
	0x40096041,0x89374BC7, 0x3FF27844,0x9B670444,
	0x4009624D,0xD2F1A9FC, 0x3FF2798F,0x20A0C552,
	0x4009645A,0x1CAC0831, 0x3FF27AD9,0x8B30F141,
	0x40096666,0x66666666, 0x3FF27C23,0xDB1BD4EE,
	0x40096872,0xB020C49C, 0x3FF27D6E,0x1065BC2C,
	0x40096A7E,0xF9DB22D1, 0x3FF27EB8,0x2B12F1C5,
	0x40096C8B,0x43958106, 0x3FF28002,0x2B27BF79,
	0x40096E97,0x8D4FDF3B, 0x3FF2814C,0x10A86DFD,
	0x400970A3,0xD70A3D71, 0x3FF28295,0xDB994502,
	0x400972B0,0x20C49BA6, 0x3FF283DF,0x8BFE8B2A,
	0x400974BC,0x6A7EF9DB, 0x3FF28529,0x21DC8613,
	0x400976C8,0xB4395810, 0x3FF28672,0x9D377A52,
	0x400978D4,0xFDF3B646, 0x3FF287BB,0xFE13AB76,
	0x40097AE1,0x47AE147B, 0x3FF28905,0x44755C03,
	0x40097CED,0x916872B0, 0x3FF28A4E,0x7060CD79,
	0x40097EF9,0xDB22D0E5, 0x3FF28B97,0x81DA4051,
	0x40098106,0x24DD2F1B, 0x3FF28CE0,0x78E5F3FE,
	0x40098312,0x6E978D50, 0x3FF28E29,0x558826EA,
	0x4009851E,0xB851EB85, 0x3FF28F72,0x17C5167F,
	0x4009872B,0x020C49BA, 0x3FF290BA,0xBFA0FF1D,
	0x40098937,0x4BC6A7F0, 0x3FF29203,0x4D201C21,
	0x40098B43,0x95810625, 0x3FF2934B,0xC046A7E2,
	0x40098D4F,0xDF3B645A, 0x3FF29494,0x1918DBB6,
	0x40098F5C,0x28F5C28F, 0x3FF295DC,0x579AEFEB,
	0x40099168,0x72B020C5, 0x3FF29724,0x7BD11BCF,
	0x40099374,0xBC6A7EFA, 0x3FF2986C,0x85BF95A8,
	0x40099581,0x0624DD2F, 0x3FF299B4,0x756A92BE,
	0x4009978D,0x4FDF3B64, 0x3FF29AFC,0x4AD64754,
	0x40099999,0x9999999A, 0x3FF29C44,0x0606E6AB,
	0x40099BA5,0xE353F7CF, 0x3FF29D8B,0xA700A301,
	0x40099DB2,0x2D0E5604, 0x3FF29ED3,0x2DC7AD93,
	0x40099FBE,0x76C8B439, 0x3FF2A01A,0x9A60369E,
	0x4009A1CA,0xC083126F, 0x3FF2A161,0xECCE6D5C,
	0x4009A3D7,0x0A3D70A4, 0x3FF2A2A9,0x25168007,
	0x4009A5E3,0x53F7CED9, 0x3FF2A3F0,0x433C9BD8,
	0x4009A7EF,0x9DB22D0E, 0x3FF2A537,0x4744ED0A,
	0x4009A9FB,0xE76C8B44, 0x3FF2A67E,0x31339ED5,
	0x4009AC08,0x3126E979, 0x3FF2A7C5,0x010CDB74,
	0x4009AE14,0x7AE147AE, 0x3FF2A90B,0xB6D4CC22,
	0x4009B020,0xC49BA5E3, 0x3FF2AA52,0x528F991C,
	0x4009B22D,0x0E560419, 0x3FF2AB98,0xD441699F,
	0x4009B439,0x5810624E, 0x3FF2ACDF,0x3BEE63EA,
	0x4009B645,0xA1CAC083, 0x3FF2AE25,0x899AAD3F,
	0x4009B851,0xEB851EB8, 0x3FF2AF6B,0xBD4A69E3,
	0x4009BA5E,0x353F7CEE, 0x3FF2B0B1,0xD701BD1E,
	0x4009BC6A,0x7EF9DB23, 0x3FF2B1F7,0xD6C4C937,
	0x4009BE76,0xC8B43958, 0x3FF2B33D,0xBC97AF7D,
	0x4009C083,0x126E978D, 0x3FF2B483,0x887E9041,
	0x4009C28F,0x5C28F5C3, 0x3FF2B5C9,0x3A7D8AD9,
	0x4009C49B,0xA5E353F8, 0x3FF2B70E,0xD298BD9D,
	0x4009C6A7,0xEF9DB22D, 0x3FF2B854,0x50D445EC,
	0x4009C8B4,0x39581062, 0x3FF2B999,0xB5344029,
	0x4009CAC0,0x83126E98, 0x3FF2BADE,0xFFBCC7BC,
	0x4009CCCC,0xCCCCCCCD, 0x3FF2BC24,0x3071F713,
	0x4009CED9,0x16872B02, 0x3FF2BD69,0x4757E7A1,
	0x4009D0E5,0x60418937, 0x3FF2BEAE,0x4472B1E2,
	0x4009D2F1,0xA9FBE76D, 0x3FF2BFF3,0x27C66D55,
	0x4009D4FD,0xF3B645A2, 0x3FF2C137,0xF1573082,
	0x4009D70A,0x3D70A3D7, 0x3FF2C27C,0xA12910F6,
	0x4009D916,0x872B020C, 0x3FF2C3C1,0x37402349,
	0x4009DB22,0xD0E56042, 0x3FF2C505,0xB3A07B18,
	0x4009DD2F,0x1A9FBE77, 0x3FF2C64A,0x164E2B08,
	0x4009DF3B,0x645A1CAC, 0x3FF2C78E,0x5F4D44C7,
	0x4009E147,0xAE147AE1, 0x3FF2C8D2,0x8EA1D90D,
	0x4009E353,0xF7CED917, 0x3FF2CA16,0xA44FF798,
	0x4009E560,0x4189374C, 0x3FF2CB5A,0xA05BAF32,
	0x4009E76C,0x8B439581, 0x3FF2CC9E,0x82C90DAD,
	0x4009E978,0xD4FDF3B6, 0x3FF2CDE2,0x4B9C1FE6,
	0x4009EB85,0x1EB851EC, 0x3FF2CF25,0xFAD8F1C4,
	0x4009ED91,0x6872B021, 0x3FF2D069,0x90838E36,
	0x4009EF9D,0xB22D0E56, 0x3FF2D1AD,0x0C9FFF3A,
	0x4009F1A9,0xFBE76C8B, 0x3FF2D2F0,0x6F324DD6,
	0x4009F3B6,0x45A1CAC1, 0x3FF2D433,0xB83E821D,
	0x4009F5C2,0x8F5C28F6, 0x3FF2D576,0xE7C8A32D,
	0x4009F7CE,0xD916872B, 0x3FF2D6B9,0xFDD4B72F,
	0x4009F9DB,0x22D0E560, 0x3FF2D7FC,0xFA66C35A,
	0x4009FBE7,0x6C8B4396, 0x3FF2D93F,0xDD82CBF2,
	0x4009FDF3,0xB645A1CB, 0x3FF2DA82,0xA72CD446,
	0x400A0000,0x00000000, 0x3FF2DBC5,0x5768DEB3,
	0x400A020C,0x49BA5E35, 0x3FF2DD07,0xEE3AECA3,
	0x400A0418,0x9374BC6A, 0x3FF2DE4A,0x6BA6FE90,
	0x400A0624,0xDD2F1AA0, 0x3FF2DF8C,0xCFB11400,
	0x400A0831,0x26E978D5, 0x3FF2E0CF,0x1A5D2B86,
	0x400A0A3D,0x70A3D70A, 0x3FF2E211,0x4BAF42C8,
	0x400A0C49,0xBA5E353F, 0x3FF2E353,0x63AB5677,
	0x400A0E56,0x04189375, 0x3FF2E495,0x62556257,
	0x400A1062,0x4DD2F1AA, 0x3FF2E5D7,0x47B16136,
	0x400A126E,0x978D4FDF, 0x3FF2E719,0x13C34CF8,
	0x400A147A,0xE147AE14, 0x3FF2E85A,0xC68F1E8D,
	0x400A1687,0x2B020C4A, 0x3FF2E99C,0x6018CDF9,
	0x400A1893,0x74BC6A7F, 0x3FF2EADD,0xE064524C,
	0x400A1A9F,0xBE76C8B4, 0x3FF2EC1F,0x4775A1AB,
	0x400A1CAC,0x083126E9, 0x3FF2ED60,0x9550B14A,
	0x400A1EB8,0x51EB851F, 0x3FF2EEA1,0xC9F97573,
	0x400A20C4,0x9BA5E354, 0x3FF2EFE2,0xE573E17A,
	0x400A22D0,0xE5604189, 0x3FF2F123,0xE7C3E7CD,
	0x400A24DD,0x2F1A9FBE, 0x3FF2F264,0xD0ED79E9,
	0x400A26E9,0x78D4FDF4, 0x3FF2F3A5,0xA0F4885E,
	0x400A28F5,0xC28F5C29, 0x3FF2F4E6,0x57DD02CE,
	0x400A2B02,0x0C49BA5E, 0x3FF2F626,0xF5AAD7F0,
	0x400A2D0E,0x56041893, 0x3FF2F767,0x7A61F590,
	0x400A2F1A,0x9FBE76C9, 0x3FF2F8A7,0xE606488B,
	0x400A3126,0xE978D4FE, 0x3FF2F9E8,0x389BBCD3,
	0x400A3333,0x33333333, 0x3FF2FB28,0x72263D6F,
	0x400A353F,0x7CED9168, 0x3FF2FC68,0x92A9B47C,
	0x400A374B,0xC6A7EF9E, 0x3FF2FDA8,0x9A2A0B2B,
	0x400A3958,0x10624DD3, 0x3FF2FEE8,0x88AB29C2,
	0x400A3B64,0x5A1CAC08, 0x3FF30028,0x5E30F79C,
	0x400A3D70,0xA3D70A3D, 0x3FF30168,0x1ABF5B2C,
	0x400A3F7C,0xED916873, 0x3FF302A7,0xBE5A39FB,
	0x400A4189,0x374BC6A8, 0x3FF303E7,0x490578A5,
	0x400A4395,0x810624DD, 0x3FF30526,0xBAC4FAE3,
	0x400A45A1,0xCAC08312, 0x3FF30666,0x139CA380,
	0x400A47AE,0x147AE148, 0x3FF307A5,0x53905461,
	0x400A49BA,0x5E353F7D, 0x3FF308E4,0x7AA3EE80,
	0x400A4BC6,0xA7EF9DB2, 0x3FF30A23,0x88DB51F2,
	0x400A4DD2,0xF1A9FBE7, 0x3FF30B62,0x7E3A5DE3,
	0x400A4FDF,0x3B645A1D, 0x3FF30CA1,0x5AC4F099,
	0x400A51EB,0x851EB852, 0x3FF30DE0,0x1E7EE76E,
	0x400A53F7,0xCED91687, 0x3FF30F1E,0xC96C1EDB,
	0x400A5604,0x189374BC, 0x3FF3105D,0x5B90726E,
	0x400A5810,0x624DD2F2, 0x3FF3119B,0xD4EFBCD2,
	0x400A5A1C,0xAC083127, 0x3FF312DA,0x358DD7CA,
	0x400A5C28,0xF5C28F5C, 0x3FF31418,0x7D6E9C33,
	0x400A5E35,0x3F7CED91, 0x3FF31556,0xAC95E204,
	0x400A6041,0x89374BC7, 0x3FF31694,0xC3078053,
	0x400A624D,0xD2F1A9FC, 0x3FF317D2,0xC0C74D4A,
	0x400A645A,0x1CAC0831, 0x3FF31910,0xA5D91E35,
	0x400A6666,0x66666666, 0x3FF31A4E,0x7240C777,
	0x400A6872,0xB020C49C, 0x3FF31B8C,0x26021C92,
	0x400A6A7E,0xF9DB22D1, 0x3FF31CC9,0xC120F021,
	0x400A6C8B,0x43958106, 0x3FF31E07,0x43A113DE,
	0x400A6E97,0x8D4FDF3B, 0x3FF31F44,0xAD8658A0,
	0x400A70A3,0xD70A3D71, 0x3FF32081,0xFED48E58,
	0x400A72B0,0x20C49BA6, 0x3FF321BF,0x378F8418,
	0x400A74BC,0x6A7EF9DB, 0x3FF322FC,0x57BB080B,
	0x400A76C8,0xB4395810, 0x3FF32439,0x5F5AE77F,
	0x400A78D4,0xFDF3B646, 0x3FF32576,0x4E72EEDC,
	0x400A7AE1,0x47AE147B, 0x3FF326B3,0x2506E9AA,
	0x400A7CED,0x916872B0, 0x3FF327EF,0xE31AA290,
	0x400A7EF9,0xDB22D0E5, 0x3FF3292C,0x88B1E352,
	0x400A8106,0x24DD2F1B, 0x3FF32A69,0x15D074D7,
	0x400A8312,0x6E978D50, 0x3FF32BA5,0x8A7A1F20,
	0x400A851E,0xB851EB85, 0x3FF32CE1,0xE6B2A952,
	0x400A872B,0x020C49BA, 0x3FF32E1E,0x2A7DD9B1,
	0x400A8937,0x4BC6A7F0, 0x3FF32F5A,0x55DF75A1,
	0x400A8B43,0x95810625, 0x3FF33096,0x68DB41A5,
	0x400A8D4F,0xDF3B645A, 0x3FF331D2,0x63750162,
	0x400A8F5C,0x28F5C28F, 0x3FF3330E,0x45B0779F,
	0x400A9168,0x72B020C5, 0x3FF3344A,0x0F916645,
	0x400A9374,0xBC6A7EFA, 0x3FF33585,0xC11B8E5A,
	0x400A9581,0x0624DD2F, 0x3FF336C1,0x5A52B00B,
	0x400A978D,0x4FDF3B64, 0x3FF337FC,0xDB3A8AA4,
	0x400A9999,0x9999999A, 0x3FF33938,0x43D6DC96,
	0x400A9BA5,0xE353F7CF, 0x3FF33A73,0x942B6372,
	0x400A9DB2,0x2D0E5604, 0x3FF33BAE,0xCC3BDBEC,
	0x400A9FBE,0x76C8B439, 0x3FF33CE9,0xEC0C01DE,
	0x400AA1CA,0xC083126F, 0x3FF33E24,0xF39F9043,
	0x400AA3D7,0x0A3D70A4, 0x3FF33F5F,0xE2FA413A,
	0x400AA5E3,0x53F7CED9, 0x3FF3409A,0xBA1FCE06,
	0x400AA7EF,0x9DB22D0E, 0x3FF341D5,0x7913EF10,
	0x400AA9FB,0xE76C8B44, 0x3FF34310,0x1FDA5BE4,
	0x400AAC08,0x3126E979, 0x3FF3444A,0xAE76CB32,
	0x400AAE14,0x7AE147AE, 0x3FF34585,0x24ECF2D0,
	0x400AB020,0xC49BA5E3, 0x3FF346BF,0x834087B9,
	0x400AB22D,0x0E560419, 0x3FF347F9,0xC9753E10,
	0x400AB439,0x5810624E, 0x3FF34933,0xF78EC918,
	0x400AB645,0xA1CAC083, 0x3FF34A6E,0x0D90DB41,
	0x400AB851,0xEB851EB8, 0x3FF34BA8,0x0B7F261C,
	0x400ABA5E,0x353F7CEE, 0x3FF34CE1,0xF15D5A64,
	0x400ABC6A,0x7EF9DB23, 0x3FF34E1B,0xBF2F27F8,
	0x400ABE76,0xC8B43958, 0x3FF34F55,0x74F83DE1,
	0x400AC083,0x126E978D, 0x3FF3508F,0x12BC4A4D,
	0x400AC28F,0x5C28F5C3, 0x3FF351C8,0x987EFA95,
	0x400AC49B,0xA5E353F8, 0x3FF35302,0x0643FB34,
	0x400AC6A7,0xEF9DB22D, 0x3FF3543B,0x5C0EF7D4,
	0x400AC8B4,0x39581062, 0x3FF35574,0x99E39B42,
	0x400ACAC0,0x83126E98, 0x3FF356AD,0xBFC58F77,
	0x400ACCCC,0xCCCCCCCD, 0x3FF357E6,0xCDB87D93,
	0x400ACED9,0x16872B02, 0x3FF3591F,0xC3C00DE1,
	0x400AD0E5,0x60418937, 0x3FF35A58,0xA1DFE7D3,
	0x400AD2F1,0xA9FBE76D, 0x3FF35B91,0x681BB208,
	0x400AD4FD,0xF3B645A2, 0x3FF35CCA,0x16771245,
	0x400AD70A,0x3D70A3D7, 0x3FF35E02,0xACF5AD7D,
	0x400AD916,0x872B020C, 0x3FF35F3B,0x2B9B27CB,
	0x400ADB22,0xD0E56042, 0x3FF36073,0x926B2477,
	0x400ADD2F,0x1A9FBE77, 0x3FF361AB,0xE16945F0,
	0x400ADF3B,0x645A1CAC, 0x3FF362E4,0x18992DD3,
	0x400AE147,0xAE147AE1, 0x3FF3641C,0x37FE7CEA,
	0x400AE353,0xF7CED917, 0x3FF36554,0x3F9CD329,
	0x400AE560,0x4189374C, 0x3FF3668C,0x2F77CFAD,
	0x400AE76C,0x8B439581, 0x3FF367C4,0x079310C5,
	0x400AE978,0xD4FDF3B6, 0x3FF368FB,0xC7F233E9,
	0x400AEB85,0x1EB851EC, 0x3FF36A33,0x7098D5BE,
	0x400AED91,0x6872B021, 0x3FF36B6B,0x018A9217,
	0x400AEF9D,0xB22D0E56, 0x3FF36CA2,0x7ACB03F3,
	0x400AF1A9,0xFBE76C8B, 0x3FF36DD9,0xDC5DC57F,
	0x400AF3B6,0x45A1CAC1, 0x3FF36F11,0x26467017,
	0x400AF5C2,0x8F5C28F6, 0x3FF37048,0x58889C43,
	0x400AF7CE,0xD916872B, 0x3FF3717F,0x7327E1BA,
	0x400AF9DB,0x22D0E560, 0x3FF372B6,0x7627D762,
	0x400AFBE7,0x6C8B4396, 0x3FF373ED,0x618C1350,
	0x400AFDF3,0xB645A1CB, 0x3FF37524,0x35582AC7,
	0x400B0000,0x00000000, 0x3FF3765A,0xF18FB239,
	0x400B020C,0x49BA5E35, 0x3FF37791,0x96363D49,
	0x400B0418,0x9374BC6A, 0x3FF378C8,0x234F5EC8,
	0x400B0624,0xDD2F1AA0, 0x3FF379FE,0x98DEA8B8,
	0x400B0831,0x26E978D5, 0x3FF37B34,0xF6E7AC4C,
	0x400B0A3D,0x70A3D70A, 0x3FF37C6B,0x3D6DF9E5,
	0x400B0C49,0xBA5E353F, 0x3FF37DA1,0x6C752118,
	0x400B0E56,0x04189375, 0x3FF37ED7,0x8400B0A8,
	0x400B1062,0x4DD2F1AA, 0x3FF3800D,0x8414368B,
	0x400B126E,0x978D4FDF, 0x3FF38143,0x6CB33FE7,
	0x400B147A,0xE147AE14, 0x3FF38279,0x3DE15916,
	0x400B1687,0x2B020C4A, 0x3FF383AE,0xF7A20DA2,
	0x400B1893,0x74BC6A7F, 0x3FF384E4,0x99F8E847,
	0x400B1A9F,0xBE76C8B4, 0x3FF3861A,0x24E972F4,
	0x400B1CAC,0x083126E9, 0x3FF3874F,0x987736CC,
	0x400B1EB8,0x51EB851F, 0x3FF38884,0xF4A5BC24,
	0x400B20C4,0x9BA5E354, 0x3FF389BA,0x39788A82,
	0x400B22D0,0xE5604189, 0x3FF38AEF,0x66F328A2,
	0x400B24DD,0x2F1A9FBE, 0x3FF38C24,0x7D191C73,
	0x400B26E9,0x78D4FDF4, 0x3FF38D59,0x7BEDEB19,
	0x400B28F5,0xC28F5C29, 0x3FF38E8E,0x637518EA,
	0x400B2B02,0x0C49BA5E, 0x3FF38FC3,0x33B22970,
	0x400B2D0E,0x56041893, 0x3FF390F7,0xECA89F6D,
	0x400B2F1A,0x9FBE76C9, 0x3FF3922C,0x8E5BFCD5,
	0x400B3126,0xE978D4FE, 0x3FF39361,0x18CFC2D1,
	0x400B3333,0x33333333, 0x3FF39495,0x8C0771C0,
	0x400B353F,0x7CED9168, 0x3FF395C9,0xE8068938,
	0x400B374B,0xC6A7EF9E, 0x3FF396FE,0x2CD08803,
	0x400B3958,0x10624DD3, 0x3FF39832,0x5A68EC21,
	0x400B3B64,0x5A1CAC08, 0x3FF39966,0x70D332C9,
	0x400B3D70,0xA3D70A3D, 0x3FF39A9A,0x7012D868,
	0x400B3F7C,0xED916873, 0x3FF39BCE,0x582B58A2,
	0x400B4189,0x374BC6A8, 0x3FF39D02,0x29202E53,
	0x400B4395,0x810624DD, 0x3FF39E35,0xE2F4D38C,
	0x400B45A1,0xCAC08312, 0x3FF39F69,0x85ACC197,
	0x400B47AE,0x147AE148, 0x3FF3A09D,0x114B70F5,
	0x400B49BA,0x5E353F7D, 0x3FF3A1D0,0x85D45960,
	0x400B4BC6,0xA7EF9DB2, 0x3FF3A303,0xE34AF1C9,
	0x400B4DD2,0xF1A9FBE7, 0x3FF3A437,0x29B2B05A,
	0x400B4FDF,0x3B645A1D, 0x3FF3A56A,0x590F0A76,
	0x400B51EB,0x851EB852, 0x3FF3A69D,0x716374B6,
	0x400B53F7,0xCED91687, 0x3FF3A7D0,0x72B362F1,
	0x400B5604,0x189374BC, 0x3FF3A903,0x5D024832,
	0x400B5810,0x624DD2F2, 0x3FF3AA36,0x305396C4,
	0x400B5A1C,0xAC083127, 0x3FF3AB68,0xECAAC024,
	0x400B5C28,0xF5C28F5C, 0x3FF3AC9B,0x920B3510,
	0x400B5E35,0x3F7CED91, 0x3FF3ADCE,0x2078657B,
	0x400B6041,0x89374BC7, 0x3FF3AF00,0x97F5C097,
	0x400B624D,0xD2F1A9FC, 0x3FF3B032,0xF886B4CD,
	0x400B645A,0x1CAC0831, 0x3FF3B165,0x422EAFC3,
	0x400B6666,0x66666666, 0x3FF3B297,0x74F11E59,
	0x400B6872,0xB020C49C, 0x3FF3B3C9,0x90D16CAC,
	0x400B6A7E,0xF9DB22D1, 0x3FF3B4FB,0x95D30613,
	0x400B6C8B,0x43958106, 0x3FF3B62D,0x83F95521,
	0x400B6E97,0x8D4FDF3B, 0x3FF3B75F,0x5B47C3A7,
	0x400B70A3,0xD70A3D71, 0x3FF3B891,0x1BC1BAB0,
	0x400B72B0,0x20C49BA6, 0x3FF3B9C2,0xC56AA284,
	0x400B74BC,0x6A7EF9DB, 0x3FF3BAF4,0x5845E2AA,
	0x400B76C8,0xB4395810, 0x3FF3BC25,0xD456E1E2,
	0x400B78D4,0xFDF3B646, 0x3FF3BD57,0x39A1062D,
	0x400B7AE1,0x47AE147B, 0x3FF3BE88,0x8827B4C8,
	0x400B7CED,0x916872B0, 0x3FF3BFB9,0xBFEE522C,
	0x400B7EF9,0xDB22D0E5, 0x3FF3C0EA,0xE0F84213,
	0x400B8106,0x24DD2F1B, 0x3FF3C21B,0xEB48E774,
	0x400B8312,0x6E978D50, 0x3FF3C34C,0xDEE3A482,
	0x400B851E,0xB851EB85, 0x3FF3C47D,0xBBCBDAB3,
	0x400B872B,0x020C49BA, 0x3FF3C5AE,0x8204EAB8,
	0x400B8937,0x4BC6A7F0, 0x3FF3C6DF,0x31923483,
	0x400B8B43,0x95810625, 0x3FF3C80F,0xCA771744,
	0x400B8D4F,0xDF3B645A, 0x3FF3C940,0x4CB6F16B,
	0x400B8F5C,0x28F5C28F, 0x3FF3CA70,0xB85520AA,
	0x400B9168,0x72B020C5, 0x3FF3CBA1,0x0D5501EF,
	0x400B9374,0xBC6A7EFA, 0x3FF3CCD1,0x4BB9F16A,
	0x400B9581,0x0624DD2F, 0x3FF3CE01,0x73874A8B,
	0x400B978D,0x4FDF3B64, 0x3FF3CF31,0x84C06805,
	0x400B9999,0x9999999A, 0x3FF3D061,0x7F68A3C8,
	0x400B9BA5,0xE353F7CF, 0x3FF3D191,0x63835707,
	0x400B9DB2,0x2D0E5604, 0x3FF3D2C1,0x3113DA37,
	0x400B9FBE,0x76C8B439, 0x3FF3D3F0,0xE81D850D,
	0x400BA1CA,0xC083126F, 0x3FF3D520,0x88A3AE80,
	0x400BA3D7,0x0A3D70A4, 0x3FF3D650,0x12A9ACC9,
	0x400BA5E3,0x53F7CED9, 0x3FF3D77F,0x8632D564,
	0x400BA7EF,0x9DB22D0E, 0x3FF3D8AE,0xE3427D0E,
	0x400BA9FB,0xE76C8B44, 0x3FF3D9DE,0x29DBF7C9,
	0x400BAC08,0x3126E979, 0x3FF3DB0D,0x5A0298D6,
	0x400BAE14,0x7AE147AE, 0x3FF3DC3C,0x73B9B2BC,
	0x400BB020,0xC49BA5E3, 0x3FF3DD6B,0x77049744,
	0x400BB22D,0x0E560419, 0x3FF3DE9A,0x63E6977C,
	0x400BB439,0x5810624E, 0x3FF3DFC9,0x3A6303B3,
	0x400BB645,0xA1CAC083, 0x3FF3E0F7,0xFA7D2B7E,
	0x400BB851,0xEB851EB8, 0x3FF3E226,0xA4385DB6,
	0x400BBA5E,0x353F7CEE, 0x3FF3E355,0x3797E878,
	0x400BBC6A,0x7EF9DB23, 0x3FF3E483,0xB49F1923,
	0x400BBE76,0xC8B43958, 0x3FF3E5B2,0x1B513C60,
	0x400BC083,0x126E978D, 0x3FF3E6E0,0x6BB19E18,
	0x400BC28F,0x5C28F5C3, 0x3FF3E80E,0xA5C3897E,
	0x400BC49B,0xA5E353F8, 0x3FF3E93C,0xC98A4905,
	0x400BC6A7,0xEF9DB22D, 0x3FF3EA6A,0xD7092669,
	0x400BC8B4,0x39581062, 0x3FF3EB98,0xCE436AAB,
	0x400BCAC0,0x83126E98, 0x3FF3ECC6,0xAF3C5E14,
	0x400BCCCC,0xCCCCCCCD, 0x3FF3EDF4,0x79F7482F,
	0x400BCED9,0x16872B02, 0x3FF3EF22,0x2E776FD2,
	0x400BD0E5,0x60418937, 0x3FF3F04F,0xCCC01B16,
	0x400BD2F1,0xA9FBE76D, 0x3FF3F17D,0x54D48F5E,
	0x400BD4FD,0xF3B645A2, 0x3FF3F2AA,0xC6B81152,
	0x400BD70A,0x3D70A3D7, 0x3FF3F3D8,0x226DE4E1,
	0x400BD916,0x872B020C, 0x3FF3F505,0x67F94D44,
	0x400BDB22,0xD0E56042, 0x3FF3F632,0x975D8CFB,
	0x400BDD2F,0x1A9FBE77, 0x3FF3F75F,0xB09DE5CC,
	0x400BDF3B,0x645A1CAC, 0x3FF3F88C,0xB3BD98C6,
	0x400BE147,0xAE147AE1, 0x3FF3F9B9,0xA0BFE641,
	0x400BE353,0xF7CED917, 0x3FF3FAE6,0x77A80DDF,
	0x400BE560,0x4189374C, 0x3FF3FC13,0x38794E88,
	0x400BE76C,0x8B439581, 0x3FF3FD3F,0xE336E66E,
	0x400BE978,0xD4FDF3B6, 0x3FF3FE6C,0x77E4130D,
	0x400BEB85,0x1EB851EC, 0x3FF3FF98,0xF684112B,
	0x400BED91,0x6872B021, 0x3FF400C5,0x5F1A1CD5,
	0x400BEF9D,0xB22D0E56, 0x3FF401F1,0xB1A97163,
	0x400BF1A9,0xFBE76C8B, 0x3FF4031D,0xEE35497A,
	0x400BF3B6,0x45A1CAC1, 0x3FF4044A,0x14C0DF05,
	0x400BF5C2,0x8F5C28F6, 0x3FF40576,0x254F6B3B,
	0x400BF7CE,0xD916872B, 0x3FF406A2,0x1FE4269F,
	0x400BF9DB,0x22D0E560, 0x3FF407CE,0x048248FD,
	0x400BFBE7,0x6C8B4396, 0x3FF408F9,0xD32D096E,
	0x400BFDF3,0xB645A1CB, 0x3FF40A25,0x8BE79E55,
	0x400C0000,0x00000000, 0x3FF40B51,0x2EB53D60,
	0x400C020C,0x49BA5E35, 0x3FF40C7C,0xBB991B8A,
	0x400C0418,0x9374BC6A, 0x3FF40DA8,0x32966D19,
	0x400C0624,0xDD2F1AA0, 0x3FF40ED3,0x93B065A2,
	0x400C0831,0x26E978D5, 0x3FF40FFE,0xDEEA3801,
	0x400C0A3D,0x70A3D70A, 0x3FF4112A,0x14471662,
	0x400C0C49,0xBA5E353F, 0x3FF41255,0x33CA323F,
	0x400C0E56,0x04189375, 0x3FF41380,0x3D76BC5C,
	0x400C1062,0x4DD2F1AA, 0x3FF414AB,0x314FE4CA,
	0x400C126E,0x978D4FDF, 0x3FF415D6,0x0F58DAEB,
	0x400C147A,0xE147AE14, 0x3FF41700,0xD794CD6B,
	0x400C1687,0x2B020C4A, 0x3FF4182B,0x8A06EA47,
	0x400C1893,0x74BC6A7F, 0x3FF41956,0x26B25EC5,
	0x400C1A9F,0xBE76C8B4, 0x3FF41A80,0xAD9A577E,
	0x400C1CAC,0x083126E9, 0x3FF41BAB,0x1EC20057,
	0x400C1EB8,0x51EB851F, 0x3FF41CD5,0x7A2C8486,
	0x400C20C4,0x9BA5E354, 0x3FF41DFF,0xBFDD0E8B,
	0x400C22D0,0xE5604189, 0x3FF41F29,0xEFD6C83A,
	0x400C24DD,0x2F1A9FBE, 0x3FF42054,0x0A1CDAB3,
	0x400C26E9,0x78D4FDF4, 0x3FF4217E,0x0EB26E68,
	0x400C28F5,0xC28F5C29, 0x3FF422A7,0xFD9AAB17,
	0x400C2B02,0x0C49BA5E, 0x3FF423D1,0xD6D8B7D2,
	0x400C2D0E,0x56041893, 0x3FF424FB,0x9A6FBAF7,
	0x400C2F1A,0x9FBE76C9, 0x3FF42625,0x4862DA38,
	0x400C3126,0xE978D4FE, 0x3FF4274E,0xE0B53A94,
	0x400C3333,0x33333333, 0x3FF42878,0x636A005D,
	0x400C353F,0x7CED9168, 0x3FF429A1,0xD0844F34,
	0x400C374B,0xC6A7EF9E, 0x3FF42ACB,0x28074A0C,
	0x400C3958,0x10624DD3, 0x3FF42BF4,0x69F6132A,
	0x400C3B64,0x5A1CAC08, 0x3FF42D1D,0x9653CC21,
	0x400C3D70,0xA3D70A3D, 0x3FF42E46,0xAD2395DB,
	0x400C3F7C,0xED916873, 0x3FF42F6F,0xAE68908F,
	0x400C4189,0x374BC6A8, 0x3FF43098,0x9A25DBC8,
	0x400C4395,0x810624DD, 0x3FF431C1,0x705E9662,
	0x400C45A1,0xCAC08312, 0x3FF432EA,0x3115DE8E,
	0x400C47AE,0x147AE148, 0x3FF43412,0xDC4ED1CD,
	0x400C49BA,0x5E353F7D, 0x3FF4353B,0x720C8CF3,
	0x400C4BC6,0xA7EF9DB2, 0x3FF43663,0xF2522C28,
	0x400C4DD2,0xF1A9FBE7, 0x3FF4378C,0x5D22CAE7,
	0x400C4FDF,0x3B645A1D, 0x3FF438B4,0xB28183FF,
	0x400C51EB,0x851EB852, 0x3FF439DC,0xF271718F,
	0x400C53F7,0xCED91687, 0x3FF43B05,0x1CF5AD0E,
	0x400C5604,0x189374BC, 0x3FF43C2D,0x32114F45,
	0x400C5810,0x624DD2F2, 0x3FF43D55,0x31C77052,
	0x400C5A1C,0xAC083127, 0x3FF43E7D,0x1C1B27A6,
	0x400C5C28,0xF5C28F5C, 0x3FF43FA4,0xF10F8C06,
	0x400C5E35,0x3F7CED91, 0x3FF440CC,0xB0A7B390,
	0x400C6041,0x89374BC7, 0x3FF441F4,0x5AE6B3B1,
	0x400C624D,0xD2F1A9FC, 0x3FF4431B,0xEFCFA12F,
	0x400C645A,0x1CAC0831, 0x3FF44443,0x6F659025,
	0x400C6666,0x66666666, 0x3FF4456A,0xD9AB9401,
	0x400C6872,0xB020C49C, 0x3FF44692,0x2EA4BF8A,
	0x400C6A7E,0xF9DB22D1, 0x3FF447B9,0x6E5424DA,
	0x400C6C8B,0x43958106, 0x3FF448E0,0x98BCD563,
	0x400C6E97,0x8D4FDF3B, 0x3FF44A07,0xADE1E1EC,
	0x400C70A3,0xD70A3D71, 0x3FF44B2E,0xADC65A94,
	0x400C72B0,0x20C49BA6, 0x3FF44C55,0x986D4ECE,
	0x400C74BC,0x6A7EF9DB, 0x3FF44D7C,0x6DD9CD66,
	0x400C76C8,0xB4395810, 0x3FF44EA3,0x2E0EE47F,
	0x400C78D4,0xFDF3B646, 0x3FF44FC9,0xD90FA193,
	0x400C7AE1,0x47AE147B, 0x3FF450F0,0x6EDF1172,
	0x400C7CED,0x916872B0, 0x3FF45216,0xEF804045,
	0x400C7EF9,0xDB22D0E5, 0x3FF4533D,0x5AF6398C,
	0x400C8106,0x24DD2F1B, 0x3FF45463,0xB1440820,
	0x400C8312,0x6E978D50, 0x3FF45589,0xF26CB630,
	0x400C851E,0xB851EB85, 0x3FF456B0,0x1E734D46,
	0x400C872B,0x020C49BA, 0x3FF457D6,0x355AD644,
	0x400C8937,0x4BC6A7F0, 0x3FF458FC,0x37265963,
	0x400C8B43,0x95810625, 0x3FF45A22,0x23D8DE35,
	0x400C8D4F,0xDF3B645A, 0x3FF45B47,0xFB756BA8,
	0x400C8F5C,0x28F5C28F, 0x3FF45C6D,0xBDFF07FF,
	0x400C9168,0x72B020C5, 0x3FF45D93,0x6B78B8DC,
	0x400C9374,0xBC6A7EFA, 0x3FF45EB9,0x03E58334,
	0x400C9581,0x0624DD2F, 0x3FF45FDE,0x87486B5B,
	0x400C978D,0x4FDF3B64, 0x3FF46103,0xF5A474FC,
	0x400C9999,0x9999999A, 0x3FF46229,0x4EFCA31F,
	0x400C9BA5,0xE353F7CF, 0x3FF4634E,0x9353F824,
	0x400C9DB2,0x2D0E5604, 0x3FF46473,0xC2AD75C6,
	0x400C9FBE,0x76C8B439, 0x3FF46598,0xDD0C1D1C,
	0x400CA1CA,0xC083126F, 0x3FF466BD,0xE272EE97,
	0x400CA3D7,0x0A3D70A4, 0x3FF467E2,0xD2E4EA02,
	0x400CA5E3,0x53F7CED9, 0x3FF46907,0xAE650E85,
	0x400CA7EF,0x9DB22D0E, 0x3FF46A2C,0x74F65AA4,
	0x400CA9FB,0xE76C8B44, 0x3FF46B51,0x269BCC3D,
	0x400CAC08,0x3126E979, 0x3FF46C75,0xC358608B,
	0x400CAE14,0x7AE147AE, 0x3FF46D9A,0x4B2F1423,
	0x400CB020,0xC49BA5E3, 0x3FF46EBE,0xBE22E2FA,
	0x400CB22D,0x0E560419, 0x3FF46FE3,0x1C36C85E,
	0x400CB439,0x5810624E, 0x3FF47107,0x656DBEFB,
	0x400CB645,0xA1CAC083, 0x3FF4722B,0x99CAC0D9,
	0x400CB851,0xEB851EB8, 0x3FF4734F,0xB950C75F,
	0x400CBA5E,0x353F7CEE, 0x3FF47473,0xC402CB4F,
	0x400CBC6A,0x7EF9DB23, 0x3FF47597,0xB9E3C4C9,
	0x400CBE76,0xC8B43958, 0x3FF476BB,0x9AF6AB4A,
	0x400CC083,0x126E978D, 0x3FF477DF,0x673E75AD,
	0x400CC28F,0x5C28F5C3, 0x3FF47903,0x1EBE1A2D,
	0x400CC49B,0xA5E353F8, 0x3FF47A26,0xC1788E60,
	0x400CC6A7,0xEF9DB22D, 0x3FF47B4A,0x4F70C73A,
	0x400CC8B4,0x39581062, 0x3FF47C6D,0xC8A9B910,
	0x400CCAC0,0x83126E98, 0x3FF47D91,0x2D265796,
	0x400CCCCC,0xCCCCCCCD, 0x3FF47EB4,0x7CE995D9,
	0x400CCED9,0x16872B02, 0x3FF47FD7,0xB7F6664D,
	0x400CD0E5,0x60418937, 0x3FF480FA,0xDE4FBABE,
	0x400CD2F1,0xA9FBE76D, 0x3FF4821D,0xEFF8845E,
	0x400CD4FD,0xF3B645A2, 0x3FF48340,0xECF3B3B7,
	0x400CD70A,0x3D70A3D7, 0x3FF48463,0xD54438B9,
	0x400CD916,0x872B020C, 0x3FF48586,0xA8ED02B1,
	0x400CDB22,0xD0E56042, 0x3FF486A9,0x67F1004D,
	0x400CDD2F,0x1A9FBE77, 0x3FF487CC,0x12531F99,
	0x400CDF3B,0x645A1CAC, 0x3FF488EE,0xA8164E03,
	0x400CE147,0xAE147AE1, 0x3FF48A11,0x293D785C,
	0x400CE353,0xF7CED917, 0x3FF48B33,0x95CB8AD1,
	0x400CE560,0x4189374C, 0x3FF48C55,0xEDC370F2,
	0x400CE76C,0x8B439581, 0x3FF48D78,0x312815B2,
	0x400CE978,0xD4FDF3B6, 0x3FF48E9A,0x5FFC6362,
	0x400CEB85,0x1EB851EC, 0x3FF48FBC,0x7A4343B6,
	0x400CED91,0x6872B021, 0x3FF490DE,0x7FFF9FC4,
	0x400CEF9D,0xB22D0E56, 0x3FF49200,0x71346003,
	0x400CF1A9,0xFBE76C8B, 0x3FF49322,0x4DE46C4C,
	0x400CF3B6,0x45A1CAC1, 0x3FF49444,0x1612ABDB,
	0x400CF5C2,0x8F5C28F6, 0x3FF49565,0xC9C2054C,
	0x400CF7CE,0xD916872B, 0x3FF49687,0x68F55EA1,
	0x400CF9DB,0x22D0E560, 0x3FF497A8,0xF3AF9D3C,
	0x400CFBE7,0x6C8B4396, 0x3FF498CA,0x69F3A5E2,
	0x400CFDF3,0xB645A1CB, 0x3FF499EB,0xCBC45CBD,
	0x400D0000,0x00000000, 0x3FF49B0D,0x1924A557,
	0x400D020C,0x49BA5E35, 0x3FF49C2E,0x5217629F,
	0x400D0418,0x9374BC6A, 0x3FF49D4F,0x769F76EA,
	0x400D0624,0xDD2F1AA0, 0x3FF49E70,0x86BFC3EC,
	0x400D0831,0x26E978D5, 0x3FF49F91,0x827B2AC0,
	0x400D0A3D,0x70A3D70A, 0x3FF4A0B2,0x69D48BE3,
	0x400D0C49,0xBA5E353F, 0x3FF4A1D3,0x3CCEC739,
	0x400D0E56,0x04189375, 0x3FF4A2F3,0xFB6CBC08,
	0x400D1062,0x4DD2F1AA, 0x3FF4A414,0xA5B148FB,
	0x400D126E,0x978D4FDF, 0x3FF4A535,0x3B9F4C22,
	0x400D147A,0xE147AE14, 0x3FF4A655,0xBD39A2F3,
	0x400D1687,0x2B020C4A, 0x3FF4A776,0x2A832A46,
	0x400D1893,0x74BC6A7F, 0x3FF4A896,0x837EBE5C,
	0x400D1A9F,0xBE76C8B4, 0x3FF4A9B6,0xC82F3AD8,
	0x400D1CAC,0x083126E9, 0x3FF4AAD6,0xF8977AC5,
	0x400D1EB8,0x51EB851F, 0x3FF4ABF7,0x14BA5893,
	0x400D20C4,0x9BA5E354, 0x3FF4AD17,0x1C9AAE16,
	0x400D22D0,0xE5604189, 0x3FF4AE37,0x103B548D,
	0x400D24DD,0x2F1A9FBE, 0x3FF4AF56,0xEF9F2497,
	0x400D26E9,0x78D4FDF4, 0x3FF4B076,0xBAC8F63F,
	0x400D28F5,0xC28F5C29, 0x3FF4B196,0x71BBA0F2,
	0x400D2B02,0x0C49BA5E, 0x3FF4B2B6,0x1479FB87,
	0x400D2D0E,0x56041893, 0x3FF4B3D5,0xA306DC3A,
	0x400D2F1A,0x9FBE76C9, 0x3FF4B4F5,0x1D6518B0,
	0x400D3126,0xE978D4FE, 0x3FF4B614,0x839785F3,
	0x400D3333,0x33333333, 0x3FF4B733,0xD5A0F876,
	0x400D353F,0x7CED9168, 0x3FF4B853,0x13844413,
	0x400D374B,0xC6A7EF9E, 0x3FF4B972,0x3D443C0C,
	0x400D3958,0x10624DD3, 0x3FF4BA91,0x52E3B30B,
	0x400D3B64,0x5A1CAC08, 0x3FF4BBB0,0x54657B20,
	0x400D3D70,0xA3D70A3D, 0x3FF4BCCF,0x41CC65C8,
	0x400D3F7C,0xED916873, 0x3FF4BDEE,0x1B1B43E4,
	0x400D4189,0x374BC6A8, 0x3FF4BF0C,0xE054E5BF,
	0x400D4395,0x810624DD, 0x3FF4C02B,0x917C1B0D,
	0x400D45A1,0xCAC08312, 0x3FF4C14A,0x2E93B2EB,
	0x400D47AE,0x147AE148, 0x3FF4C268,0xB79E7BE0,
	0x400D49BA,0x5E353F7D, 0x3FF4C387,0x2C9F43D9,
	0x400D4BC6,0xA7EF9DB2, 0x3FF4C4A5,0x8D98D82F,
	0x400D4DD2,0xF1A9FBE7, 0x3FF4C5C3,0xDA8E05A6,
	0x400D4FDF,0x3B645A1D, 0x3FF4C6E2,0x13819868,
	0x400D51EB,0x851EB852, 0x3FF4C800,0x38765C0B,
	0x400D53F7,0xCED91687, 0x3FF4C91E,0x496F1B90,
	0x400D5604,0x189374BC, 0x3FF4CA3C,0x466EA15F,
	0x400D5810,0x624DD2F2, 0x3FF4CB5A,0x2F77B74F,
	0x400D5A1C,0xAC083127, 0x3FF4CC78,0x048D269D,
	0x400D5C28,0xF5C28F5C, 0x3FF4CD95,0xC5B1B7F4,
	0x400D5E35,0x3F7CED91, 0x3FF4CEB3,0x72E83368,
	0x400D6041,0x89374BC7, 0x3FF4CFD1,0x0C336079,
	0x400D624D,0xD2F1A9FC, 0x3FF4D0EE,0x91960612,
	0x400D645A,0x1CAC0831, 0x3FF4D20C,0x0312EA88,
	0x400D6666,0x66666666, 0x3FF4D329,0x60ACD39F,
	0x400D6872,0xB020C49C, 0x3FF4D446,0xAA668683,
	0x400D6A7E,0xF9DB22D1, 0x3FF4D563,0xE042C7CE,
	0x400D6C8B,0x43958106, 0x3FF4D681,0x02445B84,
	0x400D6E97,0x8D4FDF3B, 0x3FF4D79E,0x106E0518,
	0x400D70A3,0xD70A3D71, 0x3FF4D8BB,0x0AC28769,
	0x400D72B0,0x20C49BA6, 0x3FF4D9D7,0xF144A4BE,
	0x400D74BC,0x6A7EF9DB, 0x3FF4DAF4,0xC3F71ED1,
	0x400D76C8,0xB4395810, 0x3FF4DC11,0x82DCB6C5,
	0x400D78D4,0xFDF3B646, 0x3FF4DD2E,0x2DF82D2A,
	0x400D7AE1,0x47AE147B, 0x3FF4DE4A,0xC54C41FF,
	0x400D7CED,0x916872B0, 0x3FF4DF67,0x48DBB4AF,
	0x400D7EF9,0xDB22D0E5, 0x3FF4E083,0xB8A94413,
	0x400D8106,0x24DD2F1B, 0x3FF4E1A0,0x14B7AE72,
	0x400D8312,0x6E978D50, 0x3FF4E2BC,0x5D09B17E,
	0x400D851E,0xB851EB85, 0x3FF4E3D8,0x91A20A5A,
	0x400D872B,0x020C49BA, 0x3FF4E4F4,0xB2837598,
	0x400D8937,0x4BC6A7F0, 0x3FF4E610,0xBFB0AF34,
	0x400D8B43,0x95810625, 0x3FF4E72C,0xB92C729C,
	0x400D8D4F,0xDF3B645A, 0x3FF4E848,0x9EF97AAB,
	0x400D8F5C,0x28F5C28F, 0x3FF4E964,0x711A81AC,
	0x400D9168,0x72B020C5, 0x3FF4EA80,0x2F924157,
	0x400D9374,0xBC6A7EFA, 0x3FF4EB9B,0xDA6372D4,
	0x400D9581,0x0624DD2F, 0x3FF4ECB7,0x7190CEBB,
	0x400D978D,0x4FDF3B64, 0x3FF4EDD2,0xF51D0D12,
	0x400D9999,0x9999999A, 0x3FF4EEEE,0x650AE550,
	0x400D9BA5,0xE353F7CF, 0x3FF4F009,0xC15D0E59,
	0x400D9DB2,0x2D0E5604, 0x3FF4F125,0x0A163E84,
	0x400D9FBE,0x76C8B439, 0x3FF4F240,0x3F392B96,
	0x400DA1CA,0xC083126F, 0x3FF4F35B,0x60C88AC6,
	0x400DA3D7,0x0A3D70A4, 0x3FF4F476,0x6EC710B8,
	0x400DA5E3,0x53F7CED9, 0x3FF4F591,0x69377183,
	0x400DA7EF,0x9DB22D0E, 0x3FF4F6AC,0x501C60AF,
	0x400DA9FB,0xE76C8B44, 0x3FF4F7C7,0x23789133,
	0x400DAC08,0x3126E979, 0x3FF4F8E1,0xE34EB578,
	0x400DAE14,0x7AE147AE, 0x3FF4F9FC,0x8FA17F57,
	0x400DB020,0xC49BA5E3, 0x3FF4FB17,0x2873A01B,
	0x400DB22D,0x0E560419, 0x3FF4FC31,0xADC7C882,
	0x400DB439,0x5810624E, 0x3FF4FD4C,0x1FA0A8B8,
	0x400DB645,0xA1CAC083, 0x3FF4FE66,0x7E00F05D,
	0x400DB851,0xEB851EB8, 0x3FF4FF80,0xC8EB4E82,
	0x400DBA5E,0x353F7CEE, 0x3FF5009B,0x006271AC,
	0x400DBC6A,0x7EF9DB23, 0x3FF501B5,0x246907CE,
	0x400DBE76,0xC8B43958, 0x3FF502CF,0x3501BE52,
	0x400DC083,0x126E978D, 0x3FF503E9,0x322F4211,
	0x400DC28F,0x5C28F5C3, 0x3FF50503,0x1BF43F58,
	0x400DC49B,0xA5E353F8, 0x3FF5061C,0xF25361E6,
	0x400DC6A7,0xEF9DB22D, 0x3FF50736,0xB54F54EE,
	0x400DC8B4,0x39581062, 0x3FF50850,0x64EAC316,
	0x400DCAC0,0x83126E98, 0x3FF5096A,0x01285676,
	0x400DCCCC,0xCCCCCCCD, 0x3FF50A83,0x8A0AB89A,
	0x400DCED9,0x16872B02, 0x3FF50B9C,0xFF949281,
	0x400DD0E5,0x60418937, 0x3FF50CB6,0x61C88C9F,
	0x400DD2F1,0xA9FBE76D, 0x3FF50DCF,0xB0A94EDB,
	0x400DD4FD,0xF3B645A2, 0x3FF50EE8,0xEC398090,
	0x400DD70A,0x3D70A3D7, 0x3FF51002,0x147BC88C,
	0x400DD916,0x872B020C, 0x3FF5111B,0x2972CD13,
	0x400DDB22,0xD0E56042, 0x3FF51234,0x2B2133DE,
	0x400DDD2F,0x1A9FBE77, 0x3FF5134D,0x1989A217,
	0x400DDF3B,0x645A1CAC, 0x3FF51465,0xF4AEBC5F,
	0x400DE147,0xAE147AE1, 0x3FF5157E,0xBC9326CE,
	0x400DE353,0xF7CED917, 0x3FF51697,0x713984ED,
	0x400DE560,0x4189374C, 0x3FF517B0,0x12A479BC,
	0x400DE76C,0x8B439581, 0x3FF518C8,0xA0D6A7B1,
	0x400DE978,0xD4FDF3B6, 0x3FF519E1,0x1BD2B0B7,
	0x400DEB85,0x1EB851EC, 0x3FF51AF9,0x839B362D,
	0x400DED91,0x6872B021, 0x3FF51C11,0xD832D8E9,
	0x400DEF9D,0xB22D0E56, 0x3FF51D2A,0x199C3938,
	0x400DF1A9,0xFBE76C8B, 0x3FF51E42,0x47D9F6DC,
	0x400DF3B6,0x45A1CAC1, 0x3FF51F5A,0x62EEB10C,
	0x400DF5C2,0x8F5C28F6, 0x3FF52072,0x6ADD0678,
	0x400DF7CE,0xD916872B, 0x3FF5218A,0x5FA79543,
	0x400DF9DB,0x22D0E560, 0x3FF522A2,0x4150FB0A,
	0x400DFBE7,0x6C8B4396, 0x3FF523BA,0x0FDBD4DF,
	0x400DFDF3,0xB645A1CB, 0x3FF524D1,0xCB4ABF4B,
	0x400E0000,0x00000000, 0x3FF525E9,0x73A0564F,
	0x400E020C,0x49BA5E35, 0x3FF52701,0x08DF3562,
	0x400E0418,0x9374BC6A, 0x3FF52818,0x8B09F772,
	0x400E0624,0xDD2F1AA0, 0x3FF5292F,0xFA2336E8,
	0x400E0831,0x26E978D5, 0x3FF52A47,0x562D8DA0,
	0x400E0A3D,0x70A3D70A, 0x3FF52B5E,0x9F2B94F0,
	0x400E0C49,0xBA5E353F, 0x3FF52C75,0xD51FE5A6,
	0x400E0E56,0x04189375, 0x3FF52D8C,0xF80D1808,
	0x400E1062,0x4DD2F1AA, 0x3FF52EA4,0x07F5C3D4,
	0x400E126E,0x978D4FDF, 0x3FF52FBB,0x04DC8041,
	0x400E147A,0xE147AE14, 0x3FF530D1,0xEEC3E3FD,
	0x400E1687,0x2B020C4A, 0x3FF531E8,0xC5AE8531,
	0x400E1893,0x74BC6A7F, 0x3FF532FF,0x899EF97C,
	0x400E1A9F,0xBE76C8B4, 0x3FF53416,0x3A97D5F8,
	0x400E1CAC,0x083126E9, 0x3FF5352C,0xD89BAF38,
	0x400E1EB8,0x51EB851F, 0x3FF53643,0x63AD1947,
	0x400E20C4,0x9BA5E354, 0x3FF53759,0xDBCEA7AA,
	0x400E22D0,0xE5604189, 0x3FF53870,0x4102ED60,
	0x400E24DD,0x2F1A9FBE, 0x3FF53986,0x934C7CE2,
	0x400E26E9,0x78D4FDF4, 0x3FF53A9C,0xD2ADE821,
	0x400E28F5,0xC28F5C29, 0x3FF53BB2,0xFF29C089,
	0x400E2B02,0x0C49BA5E, 0x3FF53CC9,0x18C29701,
	0x400E2D0E,0x56041893, 0x3FF53DDF,0x1F7AFBE9,
	0x400E2F1A,0x9FBE76C9, 0x3FF53EF5,0x13557F1D,
	0x400E3126,0xE978D4FE, 0x3FF5400A,0xF454AFEF,
	0x400E3333,0x33333333, 0x3FF54120,0xC27B1D32,
	0x400E353F,0x7CED9168, 0x3FF54236,0x7DCB552F,
	0x400E374B,0xC6A7EF9E, 0x3FF5434C,0x2647E5AD,
	0x400E3958,0x10624DD3, 0x3FF54461,0xBBF35BEC,
	0x400E3B64,0x5A1CAC08, 0x3FF54577,0x3ED044A8,
	0x400E3D70,0xA3D70A3D, 0x3FF5468C,0xAEE12C18,
	0x400E3F7C,0xED916873, 0x3FF547A2,0x0C289DF1,
	0x400E4189,0x374BC6A8, 0x3FF548B7,0x56A9255E,
	0x400E4395,0x810624DD, 0x3FF549CC,0x8E654D0B,
	0x400E45A1,0xCAC08312, 0x3FF54AE1,0xB35F9F1F,
	0x400E47AE,0x147AE148, 0x3FF54BF6,0xC59AA53C,
	0x400E49BA,0x5E353F7D, 0x3FF54D0B,0xC518E87F,
	0x400E4BC6,0xA7EF9DB2, 0x3FF54E20,0xB1DCF184,
	0x400E4DD2,0xF1A9FBE7, 0x3FF54F35,0x8BE94862,
	0x400E4FDF,0x3B645A1D, 0x3FF5504A,0x534074AE,
	0x400E51EB,0x851EB852, 0x3FF5515F,0x07E4FD76,
	0x400E53F7,0xCED91687, 0x3FF55273,0xA9D9694A,
	0x400E5604,0x189374BC, 0x3FF55388,0x39203E34,
	0x400E5810,0x624DD2F2, 0x3FF5549C,0xB5BC01BB,
	0x400E5A1C,0xAC083127, 0x3FF555B1,0x1FAF38E5,
	0x400E5C28,0xF5C28F5C, 0x3FF556C5,0x76FC6834,
	0x400E5E35,0x3F7CED91, 0x3FF557D9,0xBBA613A9,
	0x400E6041,0x89374BC7, 0x3FF558ED,0xEDAEBEC1,
	0x400E624D,0xD2F1A9FC, 0x3FF55A02,0x0D18EC77,
	0x400E645A,0x1CAC0831, 0x3FF55B16,0x19E71F46,
	0x400E6666,0x66666666, 0x3FF55C2A,0x141BD925,
	0x400E6872,0xB020C49C, 0x3FF55D3D,0xFBB99B8C,
	0x400E6A7E,0xF9DB22D1, 0x3FF55E51,0xD0C2E76C,
	0x400E6C8B,0x43958106, 0x3FF55F65,0x933A3D3B,
	0x400E6E97,0x8D4FDF3B, 0x3FF56079,0x43221CEA,
	0x400E70A3,0xD70A3D71, 0x3FF5618C,0xE07D05EA,
	0x400E72B0,0x20C49BA6, 0x3FF562A0,0x6B4D7728,
	0x400E74BC,0x6A7EF9DB, 0x3FF563B3,0xE395EF16,
	0x400E76C8,0xB4395810, 0x3FF564C7,0x4958EBA0,
	0x400E78D4,0xFDF3B646, 0x3FF565DA,0x9C98EA34,
	0x400E7AE1,0x47AE147B, 0x3FF566ED,0xDD5867BD,
	0x400E7CED,0x916872B0, 0x3FF56801,0x0B99E0A9,
	0x400E7EF9,0xDB22D0E5, 0x3FF56914,0x275FD0E3,
	0x400E8106,0x24DD2F1B, 0x3FF56A27,0x30ACB3D9,
	0x400E8312,0x6E978D50, 0x3FF56B3A,0x27830474,
	0x400E851E,0xB851EB85, 0x3FF56C4D,0x0BE53D23,
	0x400E872B,0x020C49BA, 0x3FF56D5F,0xDDD5D7D0,
	0x400E8937,0x4BC6A7F0, 0x3FF56E72,0x9D574DEA,
	0x400E8B43,0x95810625, 0x3FF56F85,0x4A6C185D,
	0x400E8D4F,0xDF3B645A, 0x3FF57097,0xE516AF98,
	0x400E8F5C,0x28F5C28F, 0x3FF571AA,0x6D598B89,
	0x400E9168,0x72B020C5, 0x3FF572BC,0xE33723A2,
	0x400E9374,0xBC6A7EFA, 0x3FF573CF,0x46B1EED2,
	0x400E9581,0x0624DD2F, 0x3FF574E1,0x97CC638C,
	0x400E978D,0x4FDF3B64, 0x3FF575F3,0xD688F7C4,
	0x400E9999,0x9999999A, 0x3FF57706,0x02EA20EF,
	0x400E9BA5,0xE353F7CF, 0x3FF57818,0x1CF25403,
	0x400E9DB2,0x2D0E5604, 0x3FF5792A,0x24A4057A,
	0x400E9FBE,0x76C8B439, 0x3FF57A3C,0x1A01A94D,
	0x400EA1CA,0xC083126F, 0x3FF57B4D,0xFD0DB2FB,
	0x400EA3D7,0x0A3D70A4, 0x3FF57C5F,0xCDCA9580,
	0x400EA5E3,0x53F7CED9, 0x3FF57D71,0x8C3AC35D,
	0x400EA7EF,0x9DB22D0E, 0x3FF57E83,0x3860AE97,
	0x400EA9FB,0xE76C8B44, 0x3FF57F94,0xD23EC8B3,
	0x400EAC08,0x3126E979, 0x3FF580A6,0x59D782BA,
	0x400EAE14,0x7AE147AE, 0x3FF581B7,0xCF2D4D37,
	0x400EB020,0xC49BA5E3, 0x3FF582C9,0x32429839,
	0x400EB22D,0x0E560419, 0x3FF583DA,0x8319D351,
	0x400EB439,0x5810624E, 0x3FF584EB,0xC1B56D92,
	0x400EB645,0xA1CAC083, 0x3FF585FC,0xEE17D597,
	0x400EB851,0xEB851EB8, 0x3FF5870E,0x0843797A,
	0x400EBA5E,0x353F7CEE, 0x3FF5881F,0x103AC6DA,
	0x400EBC6A,0x7EF9DB23, 0x3FF58930,0x06002AD9,
	0x400EBE76,0xC8B43958, 0x3FF58A40,0xE996121F,
	0x400EC083,0x126E978D, 0x3FF58B51,0xBAFEE8D6,
	0x400EC28F,0x5C28F5C3, 0x3FF58C62,0x7A3D1AAD,
	0x400EC49B,0xA5E353F8, 0x3FF58D73,0x275312D6,
	0x400EC6A7,0xEF9DB22D, 0x3FF58E83,0xC2433C09,
	0x400EC8B4,0x39581062, 0x3FF58F94,0x4B100082,
	0x400ECAC0,0x83126E98, 0x3FF590A4,0xC1BBCA02,
	0x400ECCCC,0xCCCCCCCD, 0x3FF591B5,0x264901CC,
	0x400ECED9,0x16872B02, 0x3FF592C5,0x78BA10AC,
	0x400ED0E5,0x60418937, 0x3FF593D5,0xB9115EF1,
	0x400ED2F1,0xA9FBE76D, 0x3FF594E5,0xE751546F,
	0x400ED4FD,0xF3B645A2, 0x3FF595F6,0x037C587F,
	0x400ED70A,0x3D70A3D7, 0x3FF59706,0x0D94D200,
	0x400ED916,0x872B020C, 0x3FF59816,0x059D2756,
	0x400EDB22,0xD0E56042, 0x3FF59925,0xEB97BE6D,
	0x400EDD2F,0x1A9FBE77, 0x3FF59A35,0xBF86FCB3,
	0x400EDF3B,0x645A1CAC, 0x3FF59B45,0x816D471D,
	0x400EE147,0xAE147AE1, 0x3FF59C55,0x314D0229,
	0x400EE353,0xF7CED917, 0x3FF59D64,0xCF2891D8,
	0x400EE560,0x4189374C, 0x3FF59E74,0x5B0259B2,
	0x400EE76C,0x8B439581, 0x3FF59F83,0xD4DCBCC5,
	0x400EE978,0xD4FDF3B6, 0x3FF5A093,0x3CBA1DA8,
	0x400EEB85,0x1EB851EC, 0x3FF5A1A2,0x929CDE75,
	0x400EED91,0x6872B021, 0x3FF5A2B1,0xD68760CF,
	0x400EEF9D,0xB22D0E56, 0x3FF5A3C1,0x087C05DF,
	0x400EF1A9,0xFBE76C8B, 0x3FF5A4D0,0x287D2E57,
	0x400EF3B6,0x45A1CAC1, 0x3FF5A5DF,0x368D3A6D,
	0x400EF5C2,0x8F5C28F6, 0x3FF5A6EE,0x32AE89E1,
	0x400EF7CE,0xD916872B, 0x3FF5A7FD,0x1CE37BFA,
	0x400EF9DB,0x22D0E560, 0x3FF5A90B,0xF52E6F84,
	0x400EFBE7,0x6C8B4396, 0x3FF5AA1A,0xBB91C2D6,
	0x400EFDF3,0xB645A1CB, 0x3FF5AB29,0x700FD3CC,
	0x400F0000,0x00000000, 0x3FF5AC38,0x12AAFFCD,
	0x400F020C,0x49BA5E35, 0x3FF5AD46,0xA365A3C5,
	0x400F0418,0x9374BC6A, 0x3FF5AE55,0x22421C2A,
	0x400F0624,0xDD2F1AA0, 0x3FF5AF63,0x8F42C4FA,
	0x400F0831,0x26E978D5, 0x3FF5B071,0xEA69F9BA,
	0x400F0A3D,0x70A3D70A, 0x3FF5B180,0x33BA1579,
	0x400F0C49,0xBA5E353F, 0x3FF5B28E,0x6B3572CF,
	0x400F0E56,0x04189375, 0x3FF5B39C,0x90DE6BDC,
	0x400F1062,0x4DD2F1AA, 0x3FF5B4AA,0xA4B75A47,
	0x400F126E,0x978D4FDF, 0x3FF5B5B8,0xA6C29745,
	0x400F147A,0xE147AE14, 0x3FF5B6C6,0x97027B8E,
	0x400F1687,0x2B020C4A, 0x3FF5B7D4,0x75795F6A,
	0x400F1893,0x74BC6A7F, 0x3FF5B8E2,0x42299AA3,
	0x400F1A9F,0xBE76C8B4, 0x3FF5B9EF,0xFD158492,
	0x400F1CAC,0x083126E9, 0x3FF5BAFD,0xA63F7418,
	0x400F1EB8,0x51EB851F, 0x3FF5BC0B,0x3DA9BFA0,
	0x400F20C4,0x9BA5E354, 0x3FF5BD18,0xC356BD1D,
	0x400F22D0,0xE5604189, 0x3FF5BE26,0x3748C20F,
	0x400F24DD,0x2F1A9FBE, 0x3FF5BF33,0x9982237D,
	0x400F26E9,0x78D4FDF4, 0x3FF5C040,0xEA0535FC,
	0x400F28F5,0xC28F5C29, 0x3FF5C14E,0x28D44DA7,
	0x400F2B02,0x0C49BA5E, 0x3FF5C25B,0x55F1BE26,
	0x400F2D0E,0x56041893, 0x3FF5C368,0x715FDAAD,
	0x400F2F1A,0x9FBE76C9, 0x3FF5C475,0x7B20F5F7,
	0x400F3126,0xE978D4FE, 0x3FF5C582,0x7337624D,
	0x400F3333,0x33333333, 0x3FF5C68F,0x59A57181,
	0x400F353F,0x7CED9168, 0x3FF5C79C,0x2E6D74F2,
	0x400F374B,0xC6A7EF9E, 0x3FF5C8A8,0xF191BD88,
	0x400F3958,0x10624DD3, 0x3FF5C9B5,0xA3149BB7,
	0x400F3B64,0x5A1CAC08, 0x3FF5CAC2,0x42F85F80,
	0x400F3D70,0xA3D70A3D, 0x3FF5CBCE,0xD13F586D,
	0x400F3F7C,0xED916873, 0x3FF5CCDB,0x4DEBD597,
	0x400F4189,0x374BC6A8, 0x3FF5CDE7,0xB900259F,
	0x400F4395,0x810624DD, 0x3FF5CEF4,0x127E96B4,
	0x400F45A1,0xCAC08312, 0x3FF5D000,0x5A697691,
	0x400F47AE,0x147AE148, 0x3FF5D10C,0x90C3127E,
	0x400F49BA,0x5E353F7D, 0x3FF5D218,0xB58DB74C,
	0x400F4BC6,0xA7EF9DB2, 0x3FF5D324,0xC8CBB15C,
	0x400F4DD2,0xF1A9FBE7, 0x3FF5D430,0xCA7F4C9A,
	0x400F4FDF,0x3B645A1D, 0x3FF5D53C,0xBAAAD47F,
	0x400F51EB,0x851EB852, 0x3FF5D648,0x99509410,
	0x400F53F7,0xCED91687, 0x3FF5D754,0x6672D5DE,
	0x400F5604,0x189374BC, 0x3FF5D860,0x2213E40B,
	0x400F5810,0x624DD2F2, 0x3FF5D96B,0xCC360841,
	0x400F5A1C,0xAC083127, 0x3FF5DA77,0x64DB8BBB,
	0x400F5C28,0xF5C28F5C, 0x3FF5DB82,0xEC06B73F,
	0x400F5E35,0x3F7CED91, 0x3FF5DC8E,0x61B9D322,
	0x400F6041,0x89374BC7, 0x3FF5DD99,0xC5F72747,
	0x400F624D,0xD2F1A9FC, 0x3FF5DEA5,0x18C0FB1B,
	0x400F645A,0x1CAC0831, 0x3FF5DFB0,0x5A19959C,
	0x400F6666,0x66666666, 0x3FF5E0BB,0x8A033D57,
	0x400F6872,0xB020C49C, 0x3FF5E1C6,0xA8803865,
	0x400F6A7E,0xF9DB22D1, 0x3FF5E2D1,0xB592CC6C,
	0x400F6C8B,0x43958106, 0x3FF5E3DC,0xB13D3EA3,
	0x400F6E97,0x8D4FDF3B, 0x3FF5E4E7,0x9B81D3CD,
	0x400F70A3,0xD70A3D71, 0x3FF5E5F2,0x7462D03E,
	0x400F72B0,0x20C49BA6, 0x3FF5E6FD,0x3BE277D7,
	0x400F74BC,0x6A7EF9DB, 0x3FF5E807,0xF2030E07,
	0x400F76C8,0xB4395810, 0x3FF5E912,0x96C6D5CD,
	0x400F78D4,0xFDF3B646, 0x3FF5EA1D,0x2A3011B8,
	0x400F7AE1,0x47AE147B, 0x3FF5EB27,0xAC4103E3,
	0x400F7CED,0x916872B0, 0x3FF5EC32,0x1CFBEDFB,
	0x400F7EF9,0xDB22D0E5, 0x3FF5ED3C,0x7C63113B,
	0x400F8106,0x24DD2F1B, 0x3FF5EE46,0xCA78AE6E,
	0x400F8312,0x6E978D50, 0x3FF5EF51,0x073F05EF,
	0x400F851E,0xB851EB85, 0x3FF5F05B,0x32B857A6,
	0x400F872B,0x020C49BA, 0x3FF5F165,0x4CE6E30D,
	0x400F8937,0x4BC6A7F0, 0x3FF5F26F,0x55CCE72F,
	0x400F8B43,0x95810625, 0x3FF5F379,0x4D6CA2A4,
	0x400F8D4F,0xDF3B645A, 0x3FF5F483,0x33C85397,
	0x400F8F5C,0x28F5C28F, 0x3FF5F58D,0x08E237C0,
	0x400F9168,0x72B020C5, 0x3FF5F696,0xCCBC8C6B,
	0x400F9374,0xBC6A7EFA, 0x3FF5F7A0,0x7F598E70,
	0x400F9581,0x0624DD2F, 0x3FF5F8AA,0x20BB7A3D,
	0x400F978D,0x4FDF3B64, 0x3FF5F9B3,0xB0E48BCB,
	0x400F9999,0x9999999A, 0x3FF5FABD,0x2FD6FEAA,
	0x400F9BA5,0xE353F7CF, 0x3FF5FBC6,0x9D950DF4,
	0x400F9DB2,0x2D0E5604, 0x3FF5FCCF,0xFA20F458,
	0x400F9FBE,0x76C8B439, 0x3FF5FDD9,0x457CEC17,
	0x400FA1CA,0xC083126F, 0x3FF5FEE2,0x7FAB2F02,
	0x400FA3D7,0x0A3D70A4, 0x3FF5FFEB,0xA8ADF679,
	0x400FA5E3,0x53F7CED9, 0x3FF600F4,0xC0877B70,
	0x400FA7EF,0x9DB22D0E, 0x3FF601FD,0xC739F66E,
	0x400FA9FB,0xE76C8B44, 0x3FF60306,0xBCC79F88,
	0x400FAC08,0x3126E979, 0x3FF6040F,0xA132AE67,
	0x400FAE14,0x7AE147AE, 0x3FF60518,0x747D5A46,
	0x400FB020,0xC49BA5E3, 0x3FF60621,0x36A9D9F0,
	0x400FB22D,0x0E560419, 0x3FF60729,0xE7BA63C6,
	0x400FB439,0x5810624E, 0x3FF60832,0x87B12DB6,
	0x400FB645,0xA1CAC083, 0x3FF6093B,0x16906D45,
	0x400FB851,0xEB851EB8, 0x3FF60A43,0x945A5788,
	0x400FBA5E,0x353F7CEE, 0x3FF60B4C,0x01112127,
	0x400FBC6A,0x7EF9DB23, 0x3FF60C54,0x5CB6FE5D,
	0x400FBE76,0xC8B43958, 0x3FF60D5C,0xA74E22F8,
	0x400FC083,0x126E978D, 0x3FF60E64,0xE0D8C258,
	0x400FC28F,0x5C28F5C3, 0x3FF60F6D,0x09590F71,
	0x400FC49B,0xA5E353F8, 0x3FF61075,0x20D13CC8,
	0x400FC6A7,0xEF9DB22D, 0x3FF6117D,0x27437C79,
	0x400FC8B4,0x39581062, 0x3FF61285,0x1CB20030,
	0x400FCAC0,0x83126E98, 0x3FF6138D,0x011EF92E,
	0x400FCCCC,0xCCCCCCCD, 0x3FF61494,0xD48C9846,
	0x400FCED9,0x16872B02, 0x3FF6159C,0x96FD0DE1,
	0x400FD0E5,0x60418937, 0x3FF616A4,0x487289FA,
	0x400FD2F1,0xA9FBE76D, 0x3FF617AB,0xE8EF3C22,
	0x400FD4FD,0xF3B645A2, 0x3FF618B3,0x7875537A,
	0x400FD70A,0x3D70A3D7, 0x3FF619BA,0xF706FEBA,
	0x400FD916,0x872B020C, 0x3FF61AC2,0x64A66C2F,
	0x400FDB22,0xD0E56042, 0x3FF61BC9,0xC155C9B9,
	0x400FDD2F,0x1A9FBE77, 0x3FF61CD1,0x0D1744CB,
	0x400FDF3B,0x645A1CAC, 0x3FF61DD8,0x47ED0A6E,
	0x400FE147,0xAE147AE1, 0x3FF61EDF,0x71D94741,
	0x400FE353,0xF7CED917, 0x3FF61FE6,0x8ADE2777,
	0x400FE560,0x4189374C, 0x3FF620ED,0x92FDD6D4,
	0x400FE76C,0x8B439581, 0x3FF621F4,0x8A3A80B7,
	0x400FE978,0xD4FDF3B6, 0x3FF622FB,0x7096500F,
	0x400FEB85,0x1EB851EC, 0x3FF62402,0x46136F65,
	0x400FED91,0x6872B021, 0x3FF62509,0x0AB408D2,
	0x400FEF9D,0xB22D0E56, 0x3FF6260F,0xBE7A4609,
	0x400FF1A9,0xFBE76C8B, 0x3FF62716,0x61685050,
	0x400FF3B6,0x45A1CAC1, 0x3FF6281C,0xF3805083,
	0x400FF5C2,0x8F5C28F6, 0x3FF62923,0x74C46F13,
	0x400FF7CE,0xD916872B, 0x3FF62A29,0xE536D408,
	0x400FF9DB,0x22D0E560, 0x3FF62B30,0x44D9A701,
	0x400FFBE7,0x6C8B4396, 0x3FF62C36,0x93AF0F30,
	0x400FFDF3,0xB645A1CB, 0x3FF62D3C,0xD1B93360,
	0x40100000,0x00000000, 0x3FF62E42,0xFEFA39EF,
	};


LOCAL_D const TUint32 SqrtTest[] =
	{
	0x3FE00000,0x00000000, 0x3FE6A09E,0x667F3BCD,
	0x3FE051EB,0x851EB852, 0x3FE6DA42,0x17576971,
	0x3FE0A3D7,0x0A3D70A4, 0x3FE71355,0xD04DE190,
	0x3FE0F5C2,0x8F5C28F6, 0x3FE74BDD,0xB3926321,
	0x3FE147AE,0x147AE148, 0x3FE783DD,0xB1A48E38,
	0x3FE19999,0x9999999A, 0x3FE7BB59,0x8C88B4AD,
	0x3FE1EB85,0x1EB851EC, 0x3FE7F254,0xDAB9CC3B,
	0x3FE23D70,0xA3D70A3D, 0x3FE828D3,0x09DF0C49,
	0x3FE28F5C,0x28F5C28F, 0x3FE85ED7,0x614B038C,
	0x3FE2E147,0xAE147AE1, 0x3FE89465,0x04494BE3,
	0x3FE33333,0x33333333, 0x3FE8C97E,0xF43F7248,
	0x3FE3851E,0xB851EB85, 0x3FE8FE28,0x12A529ED,
	0x3FE3D70A,0x3D70A3D7, 0x3FE93263,0x22D77275,
	0x3FE428F5,0xC28F5C29, 0x3FE96632,0xCBC9F77F,
	0x3FE47AE1,0x47AE147B, 0x3FE99999,0x9999999A,
	0x3FE4CCCC,0xCCCCCCCD, 0x3FE9CC99,0xFF02C481,
	0x3FE51EB8,0x51EB851F, 0x3FE9FF36,0x56BDF346,
	0x3FE570A3,0xD70A3D71, 0x3FEA3170,0xE4C48745,
	0x3FE5C28F,0x5C28F5C3, 0x3FEA634B,0xD77FE1A5,
	0x3FE6147A,0xE147AE14, 0x3FEA94C9,0x48E4800E,
	0x3FE66666,0x66666666, 0x3FEAC5EB,0x3F7AB2F8,
	0x3FE6B851,0xEB851EB8, 0x3FEAF6B3,0xAF565E6F,
	0x3FE70A3D,0x70A3D70A, 0x3FEB2724,0x7AFF148F,
	0x3FE75C28,0xF5C28F5C, 0x3FEB573F,0x7449BA9F,
	0x3FE7AE14,0x7AE147AE, 0x3FEB8706,0x5D24CEE3,
	0x3FE80000,0x00000000, 0x3FEBB67A,0xE8584CAA,
	0x3FE851EB,0x851EB852, 0x3FEBE59E,0xBA3A165A,
	0x3FE8A3D7,0x0A3D70A4, 0x3FEC1473,0x6957B96B,
	0x3FE8F5C2,0x8F5C28F6, 0x3FEC42FA,0x7F164E6C,
	0x3FE947AE,0x147AE148, 0x3FEC7135,0x7849271A,
	0x3FE99999,0x9999999A, 0x3FEC9F25,0xC5BFEDD9,
	0x3FE9EB85,0x1EB851EC, 0x3FECCCCC,0xCCCCCCCD,
	0x3FEA3D70,0xA3D70A3D, 0x3FECFA2B,0xE7C3269F,
	0x3FEA8F5C,0x28F5C28F, 0x3FED2744,0x666F6040,
	0x3FEAE147,0xAE147AE1, 0x3FED5417,0x8E8830D5,
	0x3FEB3333,0x33333333, 0x3FED80A6,0x9C19E42A,
	0x3FEB851E,0xB851EB85, 0x3FEDACF2,0xC1EBF386,
	0x3FEBD70A,0x3D70A3D7, 0x3FEDD8FD,0x29E1516F,
	0x3FEC28F5,0xC28F5C29, 0x3FEE04C6,0xF553BDD8,
	0x3FEC7AE1,0x47AE147B, 0x3FEE3051,0x3D6A7202,
	0x3FECCCCC,0xCCCCCCCD, 0x3FEE5B9D,0x136C6D96,
	0x3FED1EB8,0x51EB851F, 0x3FEE86AB,0x810EA912,
	0x3FED70A3,0xD70A3D71, 0x3FEEB17D,0x88BE6CF1,
	0x3FEDC28F,0x5C28F5C3, 0x3FEEDC14,0x25E80867,
	0x3FEE147A,0xE147AE14, 0x3FEF0670,0x4D3A1E6F,
	0x3FEE6666,0x66666666, 0x3FEF3092,0xECE5BC35,
	0x3FEEB851,0xEB851EB8, 0x3FEF5A7C,0xECDB684A,
	0x3FEF0A3D,0x70A3D70A, 0x3FEF842F,0x2F055704,
	0x3FEF5C28,0xF5C28F5C, 0x3FEFADAA,0x8F7EED52,
	0x3FEFAE14,0x7AE147AE, 0x3FEFD6EF,0xE4C9B8A5,
	0x3FF00000,0x00000000, 0x3FF00000,0x00000000,
	0x3FF028F5,0xC28F5C29, 0x3FF0146D,0xD68287F3,
	0x3FF051EB,0x851EB852, 0x3FF028C1,0xD959B062,
	0x3FF07AE1,0x47AE147B, 0x3FF03CFC,0x69845AA9,
	0x3FF0A3D7,0x0A3D70A4, 0x3FF0511D,0xE5A8265F,
	0x3FF0CCCC,0xCCCCCCCD, 0x3FF06526,0xAA25A13B,
	0x3FF0F5C2,0x8F5C28F6, 0x3FF07917,0x112B9A06,
	0x3FF11EB8,0x51EB851F, 0x3FF08CEF,0x72C9A206,
	0x3FF147AE,0x147AE148, 0x3FF0A0B0,0x2501C79A,
	0x3FF170A3,0xD70A3D71, 0x3FF0B459,0x7BD9942C,
	0x3FF19999,0x9999999A, 0x3FF0C7EB,0xC96A56F6,
	0x3FF1C28F,0x5C28F5C3, 0x3FF0DB67,0x5DF0C580,
	0x3FF1EB85,0x1EB851EC, 0x3FF0EECC,0x87DBFA55,
	0x3FF2147A,0xE147AE14, 0x3FF1021B,0x93DBD9C4,
	0x3FF23D70,0xA3D70A3D, 0x3FF11554,0xCCEEE448,
	0x3FF26666,0x66666666, 0x3FF12878,0x7C6F7D7A,
	0x3FF28F5C,0x28F5C28F, 0x3FF13B86,0xEA20AE5C,
	0x3FF2B851,0xEB851EB8, 0x3FF14E80,0x5C3A692B,
	0x3FF2E147,0xAE147AE1, 0x3FF16165,0x177554AE,
	0x3FF30A3D,0x70A3D70A, 0x3FF17435,0x5F16249E,
	0x3FF33333,0x33333333, 0x3FF186F1,0x74F88472,
	0x3FF35C28,0xF5C28F5C, 0x3FF19999,0x9999999A,
	0x3FF3851E,0xB851EB85, 0x3FF1AC2E,0x0C2221D3,
	0x3FF3AE14,0x7AE147AE, 0x3FF1BEAF,0x0A703231,
	0x3FF3D70A,0x3D70A3D7, 0x3FF1D11C,0xD1209B03,
	0x3FF40000,0x00000000, 0x3FF1E377,0x9B97F4A8,
	0x3FF428F5,0xC28F5C29, 0x3FF1F5BF,0xA40B592C,
	0x3FF451EB,0x851EB852, 0x3FF207F5,0x2388CE40,
	0x3FF47AE1,0x47AE147B, 0x3FF21A18,0x51FF630A,
	0x3FF4A3D7,0x0A3D70A4, 0x3FF22C29,0x66470506,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FF23E28,0x96280F23,
	0x3FF4F5C2,0x8F5C28F6, 0x3FF25016,0x166295F7,
	0x3FF51EB8,0x51EB851F, 0x3FF261F2,0x1AB573F3,
	0x3FF547AE,0x147AE148, 0x3FF273BC,0xD5E51828,
	0x3FF570A3,0xD70A3D71, 0x3FF28576,0x79C21A32,
	0x3FF59999,0x9999999A, 0x3FF2971F,0x372F95B6,
	0x3FF5C28F,0x5C28F5C3, 0x3FF2A8B7,0x3E294FB5,
	0x3FF5EB85,0x1EB851EC, 0x3FF2BA3E,0xBDC9A7E6,
	0x3FF6147A,0xE147AE14, 0x3FF2CBB5,0xE44F5836,
	0x3FF63D70,0xA3D70A3D, 0x3FF2DD1C,0xDF230457,
	0x3FF66666,0x66666666, 0x3FF2EE73,0xDADC9B57,
	0x3FF68F5C,0x28F5C28F, 0x3FF2FFBB,0x03488D00,
	0x3FF6B851,0xEB851EB8, 0x3FF310F2,0x836CD4BA,
	0x3FF6E147,0xAE147AE1, 0x3FF3221A,0x858DDB9D,
	0x3FF70A3D,0x70A3D70A, 0x3FF33333,0x33333333,
	0x3FF73333,0x33333333, 0x3FF3443C,0xB52C2A85,
	0x3FF75C28,0xF5C28F5C, 0x3FF35537,0x33943EBD,
	0x3FF7851E,0xB851EB85, 0x3FF36622,0xD5D768DE,
	0x3FF7AE14,0x7AE147AE, 0x3FF376FF,0xC2B649C7,
	0x3FF7D70A,0x3D70A3D7, 0x3FF387CE,0x204A35D2,
	0x3FF80000,0x00000000, 0x3FF3988E,0x1409212E,
	0x3FF828F5,0xC28F5C29, 0x3FF3A93F,0xC2C96E34,
	0x3FF851EB,0x851EB852, 0x3FF3B9E3,0x50C59EAE,
	0x3FF87AE1,0x47AE147B, 0x3FF3CA78,0xE19FE93C,
	0x3FF8A3D7,0x0A3D70A4, 0x3FF3DB00,0x9865B3BD,
	0x3FF8CCCC,0xCCCCCCCD, 0x3FF3EB7A,0x9792F3C6,
	0x3FF8F5C2,0x8F5C28F6, 0x3FF3FBE7,0x01157608,
	0x3FF91EB8,0x51EB851F, 0x3FF40C45,0xF6500D83,
	0x3FF947AE,0x147AE148, 0x3FF41C97,0x981DAB71,
	0x3FF970A3,0xD70A3D71, 0x3FF42CDC,0x06D4609E,
	0x3FF99999,0x9999999A, 0x3FF43D13,0x6248490F,
	0x3FF9C28F,0x5C28F5C3, 0x3FF44D3D,0xC9CE62A3,
	0x3FF9EB85,0x1EB851EC, 0x3FF45D5B,0x5C3F4F6B,
	0x3FFA147A,0xE147AE14, 0x3FF46D6C,0x37FA0475,
	0x3FFA3D70,0xA3D70A3D, 0x3FF47D70,0x7AE6659A,
	0x3FFA6666,0x66666666, 0x3FF48D68,0x4277CF0B,
	0x3FFA8F5C,0x28F5C28F, 0x3FF49D53,0xABAF8D2C,
	0x3FFAB851,0xEB851EB8, 0x3FF4AD32,0xD31F434E,
	0x3FFAE147,0xAE147AE1, 0x3FF4BD05,0xD4EB41E9,
	0x3FFB0A3D,0x70A3D70A, 0x3FF4CCCC,0xCCCCCCCD,
	0x3FFB3333,0x33333333, 0x3FF4DC87,0xD61451DA,
	0x3FFB5C28,0xF5C28F5C, 0x3FF4EC37,0x0BAB90C4,
	0x3FFB851E,0xB851EB85, 0x3FF4FBDA,0x8817B44D,
	0x3FFBAE14,0x7AE147AE, 0x3FF50B72,0x657B5D7E,
	0x3FFBD70A,0x3D70A3D7, 0x3FF51AFE,0xBD98A145,
	0x3FFC0000,0x00000000, 0x3FF52A7F,0xA9D2F8EA,
	0x3FFC28F5,0xC28F5C29, 0x3FF539F5,0x433125C3,
	0x3FFC51EB,0x851EB852, 0x3FF5495F,0xA25F0897,
	0x3FFC7AE1,0x47AE147B, 0x3FF558BE,0xDFAF6CF9,
	0x3FFCA3D7,0x0A3D70A4, 0x3FF56813,0x131DC91E,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FF5775C,0x544FF263,
	0x3FFCF5C2,0x8F5C28F6, 0x3FF5869A,0xBA97C6F7,
	0x3FFD1EB8,0x51EB851F, 0x3FF595CE,0x5CF4CCF2,
	0x3FFD47AE,0x147AE148, 0x3FF5A4F7,0x5215C72B,
	0x3FFD70A3,0xD70A3D71, 0x3FF5B415,0xB05A401C,
	0x3FFD9999,0x9999999A, 0x3FF5C329,0x8DD40B25,
	0x3FFDC28F,0x5C28F5C3, 0x3FF5D233,0x0048BC6E,
	0x3FFDEB85,0x1EB851EC, 0x3FF5E132,0x1D3317B6,
	0x3FFE147A,0xE147AE14, 0x3FF5F026,0xF9C47652,
	0x3FFE3D70,0xA3D70A3D, 0x3FF5FF11,0xAAE624A0,
	0x3FFE6666,0x66666666, 0x3FF60DF2,0x453AB723,
	0x3FFE8F5C,0x28F5C28F, 0x3FF61CC8,0xDD1F5796,
	0x3FFEB851,0xEB851EB8, 0x3FF62B95,0x86AD0A22,
	0x3FFEE147,0xAE147AE1, 0x3FF63A58,0x55B9EAFB,
	0x3FFF0A3D,0x70A3D70A, 0x3FF64911,0x5DDA6496,
	0x3FFF3333,0x33333333, 0x3FF657C0,0xB2625EB4,
	0x3FFF5C28,0xF5C28F5C, 0x3FF66666,0x66666666,
	0x3FFF851E,0xB851EB85, 0x3FF67502,0x8CBCCF54,
	0x3FFFAE14,0x7AE147AE, 0x3FF68395,0x37FECE62,
	0x3FFFD70A,0x3D70A3D7, 0x3FF6921E,0x7A898DED,
	0x40000000,0x00000000, 0x3FF6A09E,0x667F3BCD,
	0x4000147A,0xE147AE14, 0x3FF6AF15,0x0DC81142,
	0x400028F5,0xC28F5C29, 0x3FF6BD82,0x821354FF,
	0x40003D70,0xA3D70A3D, 0x3FF6CBE6,0xD4D85770,
	0x400051EB,0x851EB852, 0x3FF6DA42,0x17576971,
	0x40006666,0x66666666, 0x3FF6E894,0x5A9ACD92,
	0x40007AE1,0x47AE147B, 0x3FF6F6DD,0xAF77A413,
	0x40008F5C,0x28F5C28F, 0x3FF7051E,0x268ED1B4,
	0x4000A3D7,0x0A3D70A4, 0x3FF71355,0xD04DE190,
	0x4000B851,0xEB851EB8, 0x3FF72184,0xBCEFE200,
	0x4000CCCC,0xCCCCCCCD, 0x3FF72FAA,0xFC7E3CD7,
	0x4000E147,0xAE147AE1, 0x3FF73DC8,0x9ED18AEA,
	0x4000F5C2,0x8F5C28F6, 0x3FF74BDD,0xB3926321,
	0x40010A3D,0x70A3D70A, 0x3FF759EA,0x4A3A251F,
	0x40011EB8,0x51EB851F, 0x3FF767EE,0x7213BFA8,
	0x40013333,0x33333333, 0x3FF775EA,0x3A3C72D2,
	0x400147AE,0x147AE148, 0x3FF783DD,0xB1A48E38,
	0x40015C28,0xF5C28F5C, 0x3FF791C8,0xE7102B26,
	0x400170A3,0xD70A3D71, 0x3FF79FAB,0xE917E2F5,
	0x4001851E,0xB851EB85, 0x3FF7AD86,0xC629819F,
	0x40019999,0x9999999A, 0x3FF7BB59,0x8C88B4AD,
	0x4001AE14,0x7AE147AE, 0x3FF7C924,0x4A4FB68C,
	0x4001C28F,0x5C28F5C3, 0x3FF7D6E7,0x0D6FF66D,
	0x4001D70A,0x3D70A3D7, 0x3FF7E4A1,0xE3B2BCBA,
	0x4001EB85,0x1EB851EC, 0x3FF7F254,0xDAB9CC3B,
	0x40020000,0x00000000, 0x3FF80000,0x00000000,
	0x4002147A,0xE147AE14, 0x3FF80DA3,0x60D9E625,
	0x400228F5,0xC28F5C29, 0x3FF81B3F,0x0A765780,
	0x40023D70,0xA3D70A3D, 0x3FF828D3,0x09DF0C49,
	0x400251EB,0x851EB852, 0x3FF8365F,0x6BF92DE2,
	0x40026666,0x66666666, 0x3FF843E4,0x3D85E5B1,
	0x40027AE1,0x47AE147B, 0x3FF85161,0x8B22E93E,
	0x40028F5C,0x28F5C28F, 0x3FF85ED7,0x614B038C,
	0x4002A3D7,0x0A3D70A4, 0x3FF86C45,0xCC569BD1,
	0x4002B851,0xEB851EB8, 0x3FF879AC,0xD87C398E,
	0x4002CCCC,0xCCCCCCCD, 0x3FF8870C,0x91D10623,
	0x4002E147,0xAE147AE1, 0x3FF89465,0x04494BE3,
	0x4002F5C2,0x8F5C28F6, 0x3FF8A1B6,0x3BB8F2C3,
	0x40030A3D,0x70A3D70A, 0x3FF8AF00,0x43D3FAA3,
	0x40031EB8,0x51EB851F, 0x3FF8BC43,0x282EF353,
	0x40033333,0x33333333, 0x3FF8C97E,0xF43F7248,
	0x400347AE,0x147AE148, 0x3FF8D6B3,0xB35C8629,
	0x40035C28,0xF5C28F5C, 0x3FF8E3E1,0x70BF282E,
	0x400370A3,0xD70A3D71, 0x3FF8F108,0x3782AB66,
	0x4003851E,0xB851EB85, 0x3FF8FE28,0x12A529ED,
	0x40039999,0x9999999A, 0x3FF90B41,0x0D07F01E,
	0x4003AE14,0x7AE147AE, 0x3FF91853,0x316FE5D0,
	0x4003C28F,0x5C28F5C3, 0x3FF9255E,0x8A85F5A4,
	0x4003D70A,0x3D70A3D7, 0x3FF93263,0x22D77275,
	0x4003EB85,0x1EB851EC, 0x3FF93F61,0x04D67AED,
	0x40040000,0x00000000, 0x3FF94C58,0x3ADA5B53,
	0x4004147A,0xE147AE14, 0x3FF95948,0xCF1FED8E,
	0x400428F5,0xC28F5C29, 0x3FF96632,0xCBC9F77F,
	0x40043D70,0xA3D70A3D, 0x3FF97316,0x3AE18797,
	0x400451EB,0x851EB852, 0x3FF97FF3,0x26564FDE,
	0x40046666,0x66666666, 0x3FF98CC9,0x97FEFF4C,
	0x40047AE1,0x47AE147B, 0x3FF99999,0x9999999A,
	0x40048F5C,0x28F5C28F, 0x3FF9A663,0x34CBCD7F,
	0x4004A3D7,0x0A3D70A4, 0x3FF9B326,0x73234978,
	0x4004B851,0xEB851EB8, 0x3FF9BFE3,0x5E160F05,
	0x4004CCCC,0xCCCCCCCD, 0x3FF9CC99,0xFF02C481,
	0x4004E147,0xAE147AE1, 0x3FF9D94A,0x5F31058A,
	0x4004F5C2,0x8F5C28F6, 0x3FF9E5F4,0x87D1B20C,
	0x40050A3D,0x70A3D70A, 0x3FF9F298,0x81FF3BE6,
	0x40051EB8,0x51EB851F, 0x3FF9FF36,0x56BDF346,
	0x40053333,0x33333333, 0x3FFA0BCE,0x0EFC51B3,
	0x400547AE,0x147AE148, 0x3FFA185F,0xB39343D4,
	0x40055C28,0xF5C28F5C, 0x3FFA24EB,0x4D4671F0,
	0x400570A3,0xD70A3D71, 0x3FFA3170,0xE4C48745,
	0x4005851E,0xB851EB85, 0x3FFA3DF0,0x82A77817,
	0x40059999,0x9999999A, 0x3FFA4A6A,0x2F74C6AC,
	0x4005AE14,0x7AE147AE, 0x3FFA56DD,0xF39DC709,
	0x4005C28F,0x5C28F5C3, 0x3FFA634B,0xD77FE1A5,
	0x4005D70A,0x3D70A3D7, 0x3FFA6FB3,0xE364D4F2,
	0x4005EB85,0x1EB851EC, 0x3FFA7C16,0x1F82F5DD,
	0x40060000,0x00000000, 0x3FFA8872,0x93FD6F34,
	0x4006147A,0xE147AE14, 0x3FFA94C9,0x48E4800E,
	0x400628F5,0xC28F5C29, 0x3FFAA11A,0x4635B928,
	0x40063D70,0xA3D70A3D, 0x3FFAAD65,0x93DC3940,
	0x400651EB,0x851EB852, 0x3FFAB9AB,0x39B0E884,
	0x40066666,0x66666666, 0x3FFAC5EB,0x3F7AB2F8,
	0x40067AE1,0x47AE147B, 0x3FFAD225,0xACEEC1FC,
	0x40068F5C,0x28F5C28F, 0x3FFADE5A,0x89B0B4E2,
	0x4006A3D7,0x0A3D70A4, 0x3FFAEA89,0xDD52D896,
	0x4006B851,0xEB851EB8, 0x3FFAF6B3,0xAF565E6F,
	0x4006CCCC,0xCCCCCCCD, 0x3FFB02D8,0x072B921B,
	0x4006E147,0xAE147AE1, 0x3FFB0EF6,0xEC320EAD,
	0x4006F5C2,0x8F5C28F6, 0x3FFB1B10,0x65B8F2E3,
	0x40070A3D,0x70A3D70A, 0x3FFB2724,0x7AFF148F,
	0x40071EB8,0x51EB851F, 0x3FFB3333,0x33333333,
	0x40073333,0x33333333, 0x3FFB3F3C,0x957429DA,
	0x400747AE,0x147AE148, 0x3FFB4B40,0xA8D12027,
	0x40075C28,0xF5C28F5C, 0x3FFB573F,0x7449BA9F,
	0x400770A3,0xD70A3D71, 0x3FFB6338,0xFECE4A3D,
	0x4007851E,0xB851EB85, 0x3FFB6F2D,0x4F3FFB41,
	0x40079999,0x9999999A, 0x3FFB7B1C,0x6C710352,
	0x4007AE14,0x7AE147AE, 0x3FFB8706,0x5D24CEE3,
	0x4007C28F,0x5C28F5C3, 0x3FFB92EB,0x28102DED,
	0x4007D70A,0x3D70A3D7, 0x3FFB9ECA,0xD3D97FF8,
	0x4007EB85,0x1EB851EC, 0x3FFBAAA5,0x6718DF80,
	0x40080000,0x00000000, 0x3FFBB67A,0xE8584CAA,
	0x4008147A,0xE147AE14, 0x3FFBC24B,0x5E13D75E,
	0x400828F5,0xC28F5C29, 0x3FFBCE16,0xCEB9C8BA,
	0x40083D70,0xA3D70A3D, 0x3FFBD9DD,0x40AACBE7,
	0x400851EB,0x851EB852, 0x3FFBE59E,0xBA3A165A,
	0x40086666,0x66666666, 0x3FFBF15B,0x41AD8F74,
	0x40087AE1,0x47AE147B, 0x3FFBFD12,0xDD3DF78F,
	0x40088F5C,0x28F5C28F, 0x3FFC08C5,0x93170E7B,
	0x4008A3D7,0x0A3D70A4, 0x3FFC1473,0x6957B96B,
	0x4008B851,0xEB851EB8, 0x3FFC201C,0x6612284A,
	0x4008CCCC,0xCCCCCCCD, 0x3FFC2BC0,0x8F4BFA98,
	0x4008E147,0xAE147AE1, 0x3FFC375F,0xEAFE63A8,
	0x4008F5C2,0x8F5C28F6, 0x3FFC42FA,0x7F164E6C,
	0x40090A3D,0x70A3D70A, 0x3FFC4E90,0x517480AD,
	0x40091EB8,0x51EB851F, 0x3FFC5A21,0x67EDBDCD,
	0x40093333,0x33333333, 0x3FFC65AD,0xC84AE903,
	0x400947AE,0x147AE148, 0x3FFC7135,0x7849271A,
	0x40095C28,0xF5C28F5C, 0x3FFC7CB8,0x7D99FFBA,
	0x400970A3,0xD70A3D71, 0x3FFC8836,0xDDE37E36,
	0x4009851E,0xB851EB85, 0x3FFC93B0,0x9EC051DA,
	0x40099999,0x9999999A, 0x3FFC9F25,0xC5BFEDD9,
	0x4009AE14,0x7AE147AE, 0x3FFCAA96,0x5866A8B2,
	0x4009C28F,0x5C28F5C3, 0x3FFCB602,0x5C2DDB31,
	0x4009D70A,0x3D70A3D7, 0x3FFCC169,0xD683FF02,
	0x4009EB85,0x1EB851EC, 0x3FFCCCCC,0xCCCCCCCD,
	0x400A0000,0x00000000, 0x3FFCD82B,0x446159F3,
	0x400A147A,0xE147AE14, 0x3FFCE385,0x429035DB,
	0x400A28F5,0xC28F5C29, 0x3FFCEEDA,0xCC9D86D5,
	0x400A3D70,0xA3D70A3D, 0x3FFCFA2B,0xE7C3269F,
	0x400A51EB,0x851EB852, 0x3FFD0578,0x9930BE82,
	0x400A6666,0x66666666, 0x3FFD10C0,0xE60BE308,
	0x400A7AE1,0x47AE147B, 0x3FFD1C04,0xD3702F5C,
	0x400A8F5C,0x28F5C28F, 0x3FFD2744,0x666F6040,
	0x400AA3D7,0x0A3D70A4, 0x3FFD327F,0xA4116EAB,
	0x400AB851,0xEB851EB8, 0x3FFD3DB6,0x9154AA0E,
	0x400ACCCC,0xCCCCCCCD, 0x3FFD48E9,0x332DD234,
	0x400AE147,0xAE147AE1, 0x3FFD5417,0x8E8830D5,
	0x400AF5C2,0x8F5C28F6, 0x3FFD5F41,0xA845B2CB,
	0x400B0A3D,0x70A3D70A, 0x3FFD6A67,0x853F00F0,
	0x400B1EB8,0x51EB851F, 0x3FFD7589,0x2A4398AC,
	0x400B3333,0x33333333, 0x3FFD80A6,0x9C19E42A,
	0x400B47AE,0x147AE148, 0x3FFD8BBF,0xDF7F5240,
	0x400B5C28,0xF5C28F5C, 0x3FFD96D4,0xF9286E05,
	0x400B70A3,0xD70A3D71, 0x3FFDA1E5,0xEDC0F614,
	0x400B851E,0xB851EB85, 0x3FFDACF2,0xC1EBF386,
	0x400B9999,0x9999999A, 0x3FFDB7FB,0x7A43D09D,
	0x400BAE14,0x7AE147AE, 0x3FFDC300,0x1B5A6F21,
	0x400BC28F,0x5C28F5C3, 0x3FFDCE00,0xA9B93E79,
	0x400BD70A,0x3D70A3D7, 0x3FFDD8FD,0x29E1516F,
	0x400BEB85,0x1EB851EC, 0x3FFDE3F5,0xA04B73C0,
	0x400C0000,0x00000000, 0x3FFDEEEA,0x11683F49,
	0x400C147A,0xE147AE14, 0x3FFDF9DA,0x81A0310C,
	0x400C28F5,0xC28F5C29, 0x3FFE04C6,0xF553BDD8,
	0x400C3D70,0xA3D70A3D, 0x3FFE0FAF,0x70DB66BB,
	0x400C51EB,0x851EB852, 0x3FFE1A93,0xF887CD30,
	0x400C6666,0x66666666, 0x3FFE2574,0x90A1C704,
	0x400C7AE1,0x47AE147B, 0x3FFE3051,0x3D6A7202,
	0x400C8F5C,0x28F5C28F, 0x3FFE3B2A,0x031B475E,
	0x400CA3D7,0x0A3D70A4, 0x3FFE45FE,0xE5E62EDE,
	0x400CB851,0xEB851EB8, 0x3FFE50CF,0xE9F591C8,
	0x400CCCCC,0xCCCCCCCD, 0x3FFE5B9D,0x136C6D96,
	0x400CE147,0xAE147AE1, 0x3FFE6666,0x66666666,
	0x400CF5C2,0x8F5C28F6, 0x3FFE712B,0xE6F7D939,
	0x400D0A3D,0x70A3D70A, 0x3FFE7BED,0x992DEDEF,
	0x400D1EB8,0x51EB851F, 0x3FFE86AB,0x810EA912,
	0x400D3333,0x33333333, 0x3FFE9165,0xA298FD64,
	0x400D47AE,0x147AE148, 0x3FFE9C1C,0x01C4DD35,
	0x400D5C28,0xF5C28F5C, 0x3FFEA6CE,0xA2834B85,
	0x400D70A3,0xD70A3D71, 0x3FFEB17D,0x88BE6CF1,
	0x400D851E,0xB851EB85, 0x3FFEBC28,0xB8599867,
	0x400D9999,0x9999999A, 0x3FFEC6D0,0x353167A9,
	0x400DAE14,0x7AE147AE, 0x3FFED174,0x031BC79C,
	0x400DC28F,0x5C28F5C3, 0x3FFEDC14,0x25E80867,
	0x400DD70A,0x3D70A3D7, 0x3FFEE6B0,0xA15EED56,
	0x400DEB85,0x1EB851EC, 0x3FFEF149,0x7942BC9D,
	0x400E0000,0x00000000, 0x3FFEFBDE,0xB14F4EDA,
	0x400E147A,0xE147AE14, 0x3FFF0670,0x4D3A1E6F,
	0x400E28F5,0xC28F5C29, 0x3FFF10FE,0x50B256B1,
	0x400E3D70,0xA3D70A3D, 0x3FFF1B88,0xBF60E2DE,
	0x400E51EB,0x851EB852, 0x3FFF260F,0x9CE87CEE,
	0x400E6666,0x66666666, 0x3FFF3092,0xECE5BC35,
	0x400E7AE1,0x47AE147B, 0x3FFF3B12,0xB2EF23D7,
	0x400E8F5C,0x28F5C28F, 0x3FFF458E,0xF2953111,
	0x400EA3D7,0x0A3D70A4, 0x3FFF5007,0xAF626957,
	0x400EB851,0xEB851EB8, 0x3FFF5A7C,0xECDB684A,
	0x400ECCCC,0xCCCCCCCD, 0x3FFF64EE,0xAE7EED81,
	0x400EE147,0xAE147AE1, 0x3FFF6F5C,0xF7C5EA25,
	0x400EF5C2,0x8F5C28F6, 0x3FFF79C7,0xCC238E74,
	0x400F0A3D,0x70A3D70A, 0x3FFF842F,0x2F055704,
	0x400F1EB8,0x51EB851F, 0x3FFF8E93,0x23D319F6,
	0x400F3333,0x33333333, 0x3FFF98F3,0xADEF13F2,
	0x400F47AE,0x147AE148, 0x3FFFA350,0xD0B5F505,
	0x400F5C28,0xF5C28F5C, 0x3FFFADAA,0x8F7EED52,
	0x400F70A3,0xD70A3D71, 0x3FFFB800,0xED9BB9A8,
	0x400F851E,0xB851EB85, 0x3FFFC253,0xEE58AFEA,
	0x400F9999,0x9999999A, 0x3FFFCCA3,0x94FCCB55,
	0x400FAE14,0x7AE147AE, 0x3FFFD6EF,0xE4C9B8A5,
	0x400FC28F,0x5C28F5C3, 0x3FFFE138,0xE0FBE215,
	0x400FD70A,0x3D70A3D7, 0x3FFFEB7E,0x8CCA7B39,
	0x400FEB85,0x1EB851EC, 0x3FFFF5C0,0xEB678CBF,
	0x40100000,0x00000000, 0x40000000,0x00000000,
	0x40100A3D,0x70A3D70A, 0x4000051D,0xE6DDD53F,
	0x4010147A,0xE147AE14, 0x40000A3A,0x2BDEAC9B,
	0x40101EB8,0x51EB851F, 0x40000F54,0xD0916DEE,
	0x401028F5,0xC28F5C29, 0x4000146D,0xD68287F3,
	0x40103333,0x33333333, 0x40001985,0x3F3BF5CA,
	0x40103D70,0xA3D70A3D, 0x40001E9B,0x0C45445B,
	0x401047AE,0x147AE148, 0x400023AF,0x3F2397B6,
	0x401051EB,0x851EB852, 0x400028C1,0xD959B062,
	0x40105C28,0xF5C28F5C, 0x40002DD2,0xDC67F097,
	0x40106666,0x66666666, 0x400032E2,0x49CC6171,
	0x401070A3,0xD70A3D71, 0x400037F0,0x2302B811,
	0x40107AE1,0x47AE147B, 0x40003CFC,0x69845AA9,
	0x4010851E,0xB851EB85, 0x40004207,0x1EC8658A,
	0x40108F5C,0x28F5C28F, 0x40004710,0x4443B015,
	0x40109999,0x9999999A, 0x40004C17,0xDB68D1A2,
	0x4010A3D7,0x0A3D70A4, 0x4000511D,0xE5A8265F,
	0x4010AE14,0x7AE147AE, 0x40005622,0x646FD41A,
	0x4010B851,0xEB851EB8, 0x40005B25,0x592BCF05,
	0x4010C28F,0x5C28F5C3, 0x40006026,0xC545DE65,
	0x4010CCCC,0xCCCCCCCD, 0x40006526,0xAA25A13B,
	0x4010D70A,0x3D70A3D7, 0x40006A25,0x093092DC,
	0x4010E147,0xAE147AE1, 0x40006F21,0xE3CA0F7F,
	0x4010EB85,0x1EB851EC, 0x4000741D,0x3B5358BE,
	0x4010F5C2,0x8F5C28F6, 0x40007917,0x112B9A06,
	0x40110000,0x00000000, 0x40007E0F,0x66AFED07,
	0x40110A3D,0x70A3D70A, 0x40008306,0x3D3B5E08,
	0x4011147A,0xE147AE14, 0x400087FB,0x9626F03C,
	0x40111EB8,0x51EB851F, 0x40008CEF,0x72C9A206,
	0x401128F5,0xC28F5C29, 0x400091E1,0xD4787132,
	0x40113333,0x33333333, 0x400096D2,0xBC865F23,
	0x40113D70,0xA3D70A3D, 0x40009BC2,0x2C4474F6,
	0x401147AE,0x147AE148, 0x4000A0B0,0x2501C79A,
	0x401151EB,0x851EB852, 0x4000A59C,0xA80B7BD9,
	0x40115C28,0xF5C28F5C, 0x4000AA87,0xB6ACCA63,
	0x40116666,0x66666666, 0x4000AF71,0x522F03BB,
	0x401170A3,0xD70A3D71, 0x4000B459,0x7BD9942C,
	0x40117AE1,0x47AE147B, 0x4000B940,0x34F207A5,
	0x4011851E,0xB851EB85, 0x4000BE25,0x7EBC0D98,
	0x40118F5C,0x28F5C28F, 0x4000C309,0x5A797CC3,
	0x40119999,0x9999999A, 0x4000C7EB,0xC96A56F6,
	0x4011A3D7,0x0A3D70A4, 0x4000CCCC,0xCCCCCCCD,
	0x4011AE14,0x7AE147AE, 0x4000D1AC,0x65DD4162,
	0x4011B851,0xEB851EB8, 0x4000D68A,0x95D64DF3,
	0x4011C28F,0x5C28F5C3, 0x4000DB67,0x5DF0C580,
	0x4011CCCC,0xCCCCCCCD, 0x4000E042,0xBF63B85D,
	0x4011D70A,0x3D70A3D7, 0x4000E51C,0xBB6477C0,
	0x4011E147,0xAE147AE1, 0x4000E9F5,0x53269942,
	0x4011EB85,0x1EB851EC, 0x4000EECC,0x87DBFA55,
	0x4011F5C2,0x8F5C28F6, 0x4000F3A2,0x5AB4C3B7,
	0x40120000,0x00000000, 0x4000F876,0xCCDF6CD9,
	0x40120A3D,0x70A3D70A, 0x4000FD49,0xDF88BF3C,
	0x4012147A,0xE147AE14, 0x4001021B,0x93DBD9C4,
	0x40121EB8,0x51EB851F, 0x400106EB,0xEB02340D,
	0x401228F5,0xC28F5C29, 0x40010BBA,0xE623A1A6,
	0x40123333,0x33333333, 0x40011088,0x86665555,
	0x40123D70,0xA3D70A3D, 0x40011554,0xCCEEE448,
	0x401247AE,0x147AE148, 0x40011A1F,0xBAE04943,
	0x401251EB,0x851EB852, 0x40011EE9,0x515BE7C1,
	0x40125C28,0xF5C28F5C, 0x400123B1,0x91818F15,
	0x40126666,0x66666666, 0x40012878,0x7C6F7D7A,
	0x401270A3,0xD70A3D71, 0x40012D3E,0x13426323,
	0x40127AE1,0x47AE147B, 0x40013202,0x5715653E,
	0x4012851E,0xB851EB85, 0x400136C5,0x490220F3,
	0x40128F5C,0x28F5C28F, 0x40013B86,0xEA20AE5C,
	0x40129999,0x9999999A, 0x40014047,0x3B87A370,
	0x4012A3D7,0x0A3D70A4, 0x40014506,0x3E4C16EB,
	0x4012AE14,0x7AE147AE, 0x400149C3,0xF381A332,
	0x4012B851,0xEB851EB8, 0x40014E80,0x5C3A692B,
	0x4012C28F,0x5C28F5C3, 0x4001533B,0x7987130E,
	0x4012CCCC,0xCCCCCCCD, 0x400157F5,0x4C76D72F,
	0x4012D70A,0x3D70A3D7, 0x40015CAD,0xD6177AC7,
	0x4012E147,0xAE147AE1, 0x40016165,0x177554AE,
	0x4012EB85,0x1EB851EC, 0x4001661B,0x119B5016,
	0x4012F5C2,0x8F5C28F6, 0x40016ACF,0xC592EF36,
	0x40130000,0x00000000, 0x40016F83,0x34644DF9,
	0x40130A3D,0x70A3D70A, 0x40017435,0x5F16249E,
	0x4013147A,0xE147AE14, 0x400178E6,0x46ADCA59,
	0x40131EB8,0x51EB851F, 0x40017D95,0xEC2F37E6,
	0x401328F5,0xC28F5C29, 0x40018244,0x509D0A1A,
	0x40133333,0x33333333, 0x400186F1,0x74F88472,
	0x40133D70,0xA3D70A3D, 0x40018B9D,0x5A419391,
	0x401347AE,0x147AE148, 0x40019048,0x0176CFC3,
	0x401351EB,0x851EB852, 0x400194F1,0x6B957F72,
	0x40135C28,0xF5C28F5C, 0x40019999,0x9999999A,
	0x40136666,0x66666666, 0x40019E40,0x8C7DC837,
	0x401370A3,0xD70A3D71, 0x4001A2E6,0x453B6AAA,
	0x40137AE1,0x47AE147B, 0x4001A78A,0xC4CA981B,
	0x4013851E,0xB851EB85, 0x4001AC2E,0x0C2221D3,
	0x40138F5C,0x28F5C28F, 0x4001B0D0,0x1C379595,
	0x40139999,0x9999999A, 0x4001B570,0xF5FF3FED,
	0x4013A3D7,0x0A3D70A4, 0x4001BA10,0x9A6C2E79,
	0x4013AE14,0x7AE147AE, 0x4001BEAF,0x0A703231,
	0x4013B851,0xEB851EB8, 0x4001C34C,0x46FBE1A9,
	0x4013C28F,0x5C28F5C3, 0x4001C7E8,0x50FE9B49,
	0x4013CCCC,0xCCCCCCCD, 0x4001CC83,0x29668782,
	0x4013D70A,0x3D70A3D7, 0x4001D11C,0xD1209B03,
	0x4013E147,0xAE147AE1, 0x4001D5B5,0x491898E2,
	0x4013EB85,0x1EB851EC, 0x4001DA4C,0x923914C4,
	0x4013F5C2,0x8F5C28F6, 0x4001DEE2,0xAD6B74FB,
	0x40140000,0x00000000, 0x4001E377,0x9B97F4A8,
	0x40140A3D,0x70A3D70A, 0x4001E80B,0x5DA5A5D0,
	0x4014147A,0xE147AE14, 0x4001EC9D,0xF47A736F,
	0x40141EB8,0x51EB851F, 0x4001F12F,0x60FB2388,
	0x401428F5,0xC28F5C29, 0x4001F5BF,0xA40B592C,
	0x40143333,0x33333333, 0x4001FA4E,0xBE8D9681,
	0x40143D70,0xA3D70A3D, 0x4001FEDC,0xB1633EC2,
	0x401447AE,0x147AE148, 0x40020369,0x7D6C983C,
	0x401451EB,0x851EB852, 0x400207F5,0x2388CE40,
	0x40145C28,0xF5C28F5C, 0x40020C7F,0xA495F31F,
	0x40146666,0x66666666, 0x40021109,0x0171020F,
	0x401470A3,0xD70A3D71, 0x40021591,0x3AF5E11D,
	0x40147AE1,0x47AE147B, 0x40021A18,0x51FF630A,
	0x4014851E,0xB851EB85, 0x40021E9E,0x47674937,
	0x40148F5C,0x28F5C28F, 0x40022323,0x1C06457A,
	0x40149999,0x9999999A, 0x400227A6,0xD0B3FBFB,
	0x4014A3D7,0x0A3D70A4, 0x40022C29,0x66470506,
	0x4014AE14,0x7AE147AE, 0x400230AA,0xDD94EEE1,
	0x4014B851,0xEB851EB8, 0x4002352B,0x37723F94,
	0x4014C28F,0x5C28F5C3, 0x400239AA,0x74B276B3,
	0x4014CCCC,0xCCCCCCCD, 0x40023E28,0x96280F23,
	0x4014D70A,0x3D70A3D7, 0x400242A5,0x9CA480DD,
	0x4014E147,0xAE147AE1, 0x40024721,0x88F842A9,
	0x4014EB85,0x1EB851EC, 0x40024B9C,0x5BF2CBD8,
	0x4014F5C2,0x8F5C28F6, 0x40025016,0x166295F7,
	0x40150000,0x00000000, 0x4002548E,0xB9151E85,
	0x40150A3D,0x70A3D70A, 0x40025906,0x44D6E89F,
	0x4015147A,0xE147AE14, 0x40025D7C,0xBA737EA7,
	0x40151EB8,0x51EB851F, 0x400261F2,0x1AB573F3,
	0x401528F5,0xC28F5C29, 0x40026666,0x66666666,
	0x40153333,0x33333333, 0x40026AD9,0x9E4F0017,
	0x40153D70,0xA3D70A3D, 0x40026F4B,0xC336F8EA,
	0x401547AE,0x147AE148, 0x400273BC,0xD5E51828,
	0x401551EB,0x851EB852, 0x4002782C,0xD71F3615,
	0x40155C28,0xF5C28F5C, 0x40027C9B,0xC7AA3D82,
	0x40156666,0x66666666, 0x40028109,0xA84A2D5B,
	0x401570A3,0xD70A3D71, 0x40028576,0x79C21A32,
	0x40157AE1,0x47AE147B, 0x400289E2,0x3CD42FC3,
	0x4015851E,0xB851EB85, 0x40028E4C,0xF241B280,
	0x40158F5C,0x28F5C28F, 0x400292B6,0x9ACB010B,
	0x40159999,0x9999999A, 0x4002971F,0x372F95B6,
	0x4015A3D7,0x0A3D70A4, 0x40029B86,0xC82E07FF,
	0x4015AE14,0x7AE147AE, 0x40029FED,0x4E840E06,
	0x4015B851,0xEB851EB8, 0x4002A452,0xCAEE7E03,
	0x4015C28F,0x5C28F5C3, 0x4002A8B7,0x3E294FB5,
	0x4015CCCC,0xCCCCCCCD, 0x4002AD1A,0xA8EF9DD1,
	0x4015D70A,0x3D70A3D7, 0x4002B17D,0x0BFBA76F,
	0x4015E147,0xAE147AE1, 0x4002B5DE,0x6806D170,
	0x4015EB85,0x1EB851EC, 0x4002BA3E,0xBDC9A7E6,
	0x4015F5C2,0x8F5C28F6, 0x4002BE9E,0x0DFBDF72,
	0x40160000,0x00000000, 0x4002C2FC,0x595456A7,
	0x40160A3D,0x70A3D70A, 0x4002C759,0xA0891765,
	0x4016147A,0xE147AE14, 0x4002CBB5,0xE44F5836,
	0x40161EB8,0x51EB851F, 0x4002D011,0x255B7D9E,
	0x401628F5,0xC28F5C29, 0x4002D46B,0x64611B76,
	0x40163333,0x33333333, 0x4002D8C4,0xA212F639,
	0x40163D70,0xA3D70A3D, 0x4002DD1C,0xDF230457,
	0x401647AE,0x147AE148, 0x4002E174,0x1C426F7A,
	0x401651EB,0x851EB852, 0x4002E5CA,0x5A2195D8,
	0x40165C28,0xF5C28F5C, 0x4002EA1F,0x99700B70,
	0x40166666,0x66666666, 0x4002EE73,0xDADC9B57,
	0x401670A3,0xD70A3D71, 0x4002F2C7,0x1F1548F4,
	0x40167AE1,0x47AE147B, 0x4002F719,0x66C7513E,
	0x4016851E,0xB851EB85, 0x4002FB6A,0xB29F2BFD,
	0x40168F5C,0x28F5C28F, 0x4002FFBB,0x03488D00,
	0x40169999,0x9999999A, 0x4003040A,0x596E6555,
	0x4016A3D7,0x0A3D70A4, 0x40030858,0xB5BAE47C,
	0x4016AE14,0x7AE147AE, 0x40030CA6,0x18D7799F,
	0x4016B851,0xEB851EB8, 0x400310F2,0x836CD4BA,
	0x4016C28F,0x5C28F5C3, 0x4003153D,0xF622E7D0,
	0x4016CCCC,0xCCCCCCCD, 0x40031988,0x71A0E80E,
	0x4016D70A,0x3D70A3D7, 0x40031DD1,0xF68D4EFC,
	0x4016E147,0xAE147AE1, 0x4003221A,0x858DDB9D,
	0x4016EB85,0x1EB851EC, 0x40032662,0x1F479396,
	0x4016F5C2,0x8F5C28F6, 0x40032AA8,0xC45EC450,
	0x40170000,0x00000000, 0x40032EEE,0x75770416,
	0x40170A3D,0x70A3D70A, 0x40033333,0x33333333,
	0x4017147A,0xE147AE14, 0x40033776,0xFE357D0C,
	0x40171EB8,0x51EB851F, 0x40033BB9,0xD71F593B,
	0x401728F5,0xC28F5C29, 0x40033FFB,0xBE918CA2,
	0x40173333,0x33333333, 0x4003443C,0xB52C2A85,
	0x40173D70,0xA3D70A3D, 0x4003487C,0xBB8E9595,
	0x401747AE,0x147AE148, 0x40034CBB,0xD2578108,
	0x401751EB,0x851EB852, 0x400350F9,0xFA24F1A0,
	0x40175C28,0xF5C28F5C, 0x40035537,0x33943EBD,
	0x40176666,0x66666666, 0x40035973,0x7F421360,
	0x401770A3,0xD70A3D71, 0x40035DAE,0xDDCA6F3C,
	0x40177AE1,0x47AE147B, 0x400361E9,0x4FC8A7B2,
	0x4017851E,0xB851EB85, 0x40036622,0xD5D768DE,
	0x40178F5C,0x28F5C28F, 0x40036A5B,0x7090B690,
	0x40179999,0x9999999A, 0x40036E93,0x208DED54,
	0x4017A3D7,0x0A3D70A4, 0x400372C9,0xE667C36B,
	0x4017AE14,0x7AE147AE, 0x400376FF,0xC2B649C7,
	0x4017B851,0xEB851EB8, 0x40037B34,0xB610ED09,
	0x4017C28F,0x5C28F5C3, 0x40037F68,0xC10E7675,
	0x4017CCCC,0xCCCCCCCD, 0x4003839B,0xE4450CE8,
	0x4017D70A,0x3D70A3D7, 0x400387CE,0x204A35D2,
	0x4017E147,0xAE147AE1, 0x40038BFF,0x75B2D623,
	0x4017EB85,0x1EB851EC, 0x4003902F,0xE513333D,
	0x4017F5C2,0x8F5C28F6, 0x4003945F,0x6EFEF3E5,
	0x40180000,0x00000000, 0x4003988E,0x1409212E,
	0x40180A3D,0x70A3D70A, 0x40039CBB,0xD4C42766,
	0x4018147A,0xE147AE14, 0x4003A0E8,0xB1C1D6FE,
	0x40181EB8,0x51EB851F, 0x4003A514,0xAB936573,
	0x401828F5,0xC28F5C29, 0x4003A93F,0xC2C96E34,
	0x40183333,0x33333333, 0x4003AD69,0xF7F3F385,
	0x40183D70,0xA3D70A3D, 0x4003B193,0x4BA25F66,
	0x401847AE,0x147AE148, 0x4003B5BB,0xBE63846E,
	0x401851EB,0x851EB852, 0x4003B9E3,0x50C59EAE,
	0x40185C28,0xF5C28F5C, 0x4003BE0A,0x03565490,
	0x40186666,0x66666666, 0x4003C22F,0xD6A2B7B1,
	0x401870A3,0xD70A3D71, 0x4003C654,0xCB3745BA,
	0x40187AE1,0x47AE147B, 0x4003CA78,0xE19FE93C,
	0x4018851E,0xB851EB85, 0x4003CE9C,0x1A67FA85,
	0x40188F5C,0x28F5C28F, 0x4003D2BE,0x761A4077,
	0x40189999,0x9999999A, 0x4003D6DF,0xF540F15E,
	0x4018A3D7,0x0A3D70A4, 0x4003DB00,0x9865B3BD,
	0x4018AE14,0x7AE147AE, 0x4003DF20,0x60119F23,
	0x4018B851,0xEB851EB8, 0x4003E33F,0x4CCD3CFB,
	0x4018C28F,0x5C28F5C3, 0x4003E75D,0x5F20895A,
	0x4018CCCC,0xCCCCCCCD, 0x4003EB7A,0x9792F3C6,
	0x4018D70A,0x3D70A3D7, 0x4003EF96,0xF6AB600B,
	0x4018E147,0xAE147AE1, 0x4003F3B2,0x7CF026FA,
	0x4018EB85,0x1EB851EC, 0x4003F7CD,0x2AE7173A,
	0x4018F5C2,0x8F5C28F6, 0x4003FBE7,0x01157608,
	0x40190000,0x00000000, 0x40040000,0x00000000,
	0x40190A3D,0x70A3D70A, 0x40040418,0x282AE9E0,
	0x4019147A,0xE147AE14, 0x4004082F,0x7A19E149,
	0x40191EB8,0x51EB851F, 0x40040C45,0xF6500D83,
	0x401928F5,0xC28F5C29, 0x4004105B,0x9D501039,
	0x40193333,0x33333333, 0x40041470,0x6F9C063A,
	0x40193D70,0xA3D70A3D, 0x40041884,0x6DB58834,
	0x401947AE,0x147AE148, 0x40041C97,0x981DAB71,
	0x401951EB,0x851EB852, 0x400420A9,0xEF550290,
	0x40195C28,0xF5C28F5C, 0x400424BB,0x73DB9E40,
	0x40196666,0x66666666, 0x400428CC,0x26310DF4,
	0x401970A3,0xD70A3D71, 0x40042CDC,0x06D4609E,
	0x40197AE1,0x47AE147B, 0x400430EB,0x1644255E,
	0x4019851E,0xB851EB85, 0x400434F9,0x54FE6C3B,
	0x40198F5C,0x28F5C28F, 0x40043906,0xC380C6D4,
	0x40199999,0x9999999A, 0x40043D13,0x6248490F,
	0x4019A3D7,0x0A3D70A4, 0x4004411F,0x31D189CC,
	0x4019AE14,0x7AE147AE, 0x4004452A,0x3298A391,
	0x4019B851,0xEB851EB8, 0x40044934,0x65193539,
	0x4019C28F,0x5C28F5C3, 0x40044D3D,0xC9CE62A3,
	0x4019CCCC,0xCCCCCCCD, 0x40045146,0x6132D554,
	0x4019D70A,0x3D70A3D7, 0x4004554E,0x2BC0BD2C,
	0x4019E147,0xAE147AE1, 0x40045955,0x29F1D108,
	0x4019EB85,0x1EB851EC, 0x40045D5B,0x5C3F4F6B,
	0x4019F5C2,0x8F5C28F6, 0x40046160,0xC321FF25,
	0x401A0000,0x00000000, 0x40046565,0x5F122FF6,
	0x401A0A3D,0x70A3D70A, 0x40046969,0x3087BB36,
	0x401A147A,0xE147AE14, 0x40046D6C,0x37FA0475,
	0x401A1EB8,0x51EB851F, 0x4004716E,0x75DFFA1C,
	0x401A28F5,0xC28F5C29, 0x4004756F,0xEAB01610,
	0x401A3333,0x33333333, 0x40047970,0x96E05E52,
	0x401A3D70,0xA3D70A3D, 0x40047D70,0x7AE6659A,
	0x401A47AE,0x147AE148, 0x4004816F,0x97374BF7,
	0x401A51EB,0x851EB852, 0x4004856D,0xEC47BF6D,
	0x401A5C28,0xF5C28F5C, 0x4004896B,0x7A8BFC8B,
	0x401A6666,0x66666666, 0x40048D68,0x4277CF0B,
	0x401A70A3,0xD70A3D71, 0x40049164,0x447E9266,
	0x401A7AE1,0x47AE147B, 0x4004955F,0x81133271,
	0x401A851E,0xB851EB85, 0x40049959,0xF8A82BEF,
	0x401A8F5C,0x28F5C28F, 0x40049D53,0xABAF8D2C,
	0x401A9999,0x9999999A, 0x4004A14C,0x9A9AF68E,
	0x401AA3D7,0x0A3D70A4, 0x4004A544,0xC5DB9B2B,
	0x401AAE14,0x7AE147AE, 0x4004A93C,0x2DE2415C,
	0x401AB851,0xEB851EB8, 0x4004AD32,0xD31F434E,
	0x401AC28F,0x5C28F5C3, 0x4004B128,0xB6028F96,
	0x401ACCCC,0xCCCCCCCD, 0x4004B51D,0xD6FBA9BB,
	0x401AD70A,0x3D70A3D7, 0x4004B912,0x3679AACC,
	0x401AE147,0xAE147AE1, 0x4004BD05,0xD4EB41E9,
	0x401AEB85,0x1EB851EC, 0x4004C0F8,0xB2BEB4D5,
	0x401AF5C2,0x8F5C28F6, 0x4004C4EA,0xD061E07A,
	0x401B0000,0x00000000, 0x4004C8DC,0x2E423980,
	0x401B0A3D,0x70A3D70A, 0x4004CCCC,0xCCCCCCCD,
	0x401B147A,0xE147AE14, 0x4004D0BC,0xAC6E4014,
	0x401B1EB8,0x51EB851F, 0x4004D4AB,0xCD92D25C,
	0x401B28F5,0xC28F5C29, 0x4004D89A,0x30A65C87,
	0x401B3333,0x33333333, 0x4004DC87,0xD61451DA,
	0x401B3D70,0xA3D70A3D, 0x4004E074,0xBE47C083,
	0x401B47AE,0x147AE148, 0x4004E460,0xE9AB521D,
	0x401B51EB,0x851EB852, 0x4004E84C,0x58A94C32,
	0x401B5C28,0xF5C28F5C, 0x4004EC37,0x0BAB90C4,
	0x401B6666,0x66666666, 0x4004F021,0x031B9ECA,
	0x401B70A3,0xD70A3D71, 0x4004F40A,0x3F6292B3,
	0x401B7AE1,0x47AE147B, 0x4004F7F2,0xC0E926E9,
	0x401B851E,0xB851EB85, 0x4004FBDA,0x8817B44D,
	0x401B8F5C,0x28F5C28F, 0x4004FFC1,0x955632B8,
	0x401B9999,0x9999999A, 0x400503A7,0xE90C397B,
	0x401BA3D7,0x0A3D70A4, 0x4005078D,0x83A0FFD7,
	0x401BAE14,0x7AE147AE, 0x40050B72,0x657B5D7E,
	0x401BB851,0xEB851EB8, 0x40050F56,0x8F01CB10,
	0x401BC28F,0x5C28F5C3, 0x4005133A,0x009A6290,
	0x401BCCCC,0xCCCCCCCD, 0x4005171C,0xBAAADFE2,
	0x401BD70A,0x3D70A3D7, 0x40051AFE,0xBD98A145,
	0x401BE147,0xAE147AE1, 0x40051EE0,0x09C8A7CA,
	0x401BEB85,0x1EB851EC, 0x400522C0,0x9F9F97CC,
	0x401BF5C2,0x8F5C28F6, 0x400526A0,0x7F81B966,
	0x401C0000,0x00000000, 0x40052A7F,0xA9D2F8EA,
	0x401C0A3D,0x70A3D70A, 0x40052E5E,0x1EF6E758,
	0x401C147A,0xE147AE14, 0x4005323B,0xDF50BAD1,
	0x401C1EB8,0x51EB851F, 0x40053618,0xEB434F0B,
	0x401C28F5,0xC28F5C29, 0x400539F5,0x433125C3,
	0x401C3333,0x33333333, 0x40053DD0,0xE77C6734,
	0x401C3D70,0xA3D70A3D, 0x400541AB,0xD886E283,
	0x401C47AE,0x147AE148, 0x40054586,0x16B20E33,
	0x401C51EB,0x851EB852, 0x4005495F,0xA25F0897,
	0x401C5C28,0xF5C28F5C, 0x40054D38,0x7BEE983C,
	0x401C6666,0x66666666, 0x40055110,0xA3C12C5E,
	0x401C70A3,0xD70A3D71, 0x400554E8,0x1A36DD53,
	0x401C7AE1,0x47AE147B, 0x400558BE,0xDFAF6CF9,
	0x401C851E,0xB851EB85, 0x40055C94,0xF48A4723,
	0x401C8F5C,0x28F5C28F, 0x4005606A,0x59268203,
	0x401C9999,0x9999999A, 0x4005643F,0x0DE2DE9A,
	0x401CA3D7,0x0A3D70A4, 0x40056813,0x131DC91E,
	0x401CAE14,0x7AE147AE, 0x40056BE6,0x69355968,
	0x401CB851,0xEB851EB8, 0x40056FB9,0x10875359,
	0x401CC28F,0x5C28F5C3, 0x4005738B,0x09712747,
	0x401CCCCC,0xCCCCCCCD, 0x4005775C,0x544FF263,
	0x401CD70A,0x3D70A3D7, 0x40057B2C,0xF1807F20,
	0x401CE147,0xAE147AE1, 0x40057EFC,0xE15F459C,
	0x401CEB85,0x1EB851EC, 0x400582CC,0x24486C03,
	0x401CF5C2,0x8F5C28F6, 0x4005869A,0xBA97C6F7,
	0x401D0000,0x00000000, 0x40058A68,0xA4A8D9F3,
	0x401D0A3D,0x70A3D70A, 0x40058E35,0xE2D6D7B3,
	0x401D147A,0xE147AE14, 0x40059202,0x757CA292,
	0x401D1EB8,0x51EB851F, 0x400595CE,0x5CF4CCF2,
	0x401D28F5,0xC28F5C29, 0x40059999,0x9999999A,
	0x401D3333,0x33333333, 0x40059D64,0x2BC4FC1C,
	0x401D3D70,0xA3D70A3D, 0x4005A12E,0x13D09934,
	0x401D47AE,0x147AE148, 0x4005A4F7,0x5215C72B,
	0x401D51EB,0x851EB852, 0x4005A8BF,0xE6ED8E2F,
	0x401D5C28,0xF5C28F5C, 0x4005AC87,0xD2B0A8BF,
	0x401D6666,0x66666666, 0x4005B04F,0x15B783FF,
	0x401D70A3,0xD70A3D71, 0x4005B415,0xB05A401C,
	0x401D7AE1,0x47AE147B, 0x4005B7DB,0xA2F0B0A8,
	0x401D851E,0xB851EB85, 0x4005BBA0,0xEDD25CF8,
	0x401D8F5C,0x28F5C28F, 0x4005BF65,0x9156807D,
	0x401D9999,0x9999999A, 0x4005C329,0x8DD40B25,
	0x401DA3D7,0x0A3D70A4, 0x4005C6EC,0xE3A1A1B5,
	0x401DAE14,0x7AE147AE, 0x4005CAAF,0x93159E20,
	0x401DB851,0xEB851EB8, 0x4005CE71,0x9C860FE7,
	0x401DC28F,0x5C28F5C3, 0x4005D233,0x0048BC6E,
	0x401DCCCC,0xCCCCCCCD, 0x4005D5F3,0xBEB31F59,
	0x401DD70A,0x3D70A3D7, 0x4005D9B3,0xD81A6AE1,
	0x401DE147,0xAE147AE1, 0x4005DD73,0x4CD38830,
	0x401DEB85,0x1EB851EC, 0x4005E132,0x1D3317B6,
	0x401DF5C2,0x8F5C28F6, 0x4005E4F0,0x498D717F,
	0x401E0000,0x00000000, 0x4005E8AD,0xD236A58F,
	0x401E0A3D,0x70A3D70A, 0x4005EC6A,0xB7827C31,
	0x401E147A,0xE147AE14, 0x4005F026,0xF9C47652,
	0x401E1EB8,0x51EB851F, 0x4005F3E2,0x994FCDD2,
	0x401E28F5,0xC28F5C29, 0x4005F79D,0x967775DC,
	0x401E3333,0x33333333, 0x4005FB57,0xF18E1B39,
	0x401E3D70,0xA3D70A3D, 0x4005FF11,0xAAE624A0,
	0x401E47AE,0x147AE148, 0x400602CA,0xC2D1B30F,
	0x401E51EB,0x851EB852, 0x40060683,0x39A2A218,
	0x401E5C28,0xF5C28F5C, 0x40060A3B,0x0FAA8838,
	0x401E6666,0x66666666, 0x40060DF2,0x453AB723,
	0x401E70A3,0xD70A3D71, 0x400611A8,0xDAA43C1C,
	0x401E7AE1,0x47AE147B, 0x4006155E,0xD037E03D,
	0x401E851E,0xB851EB85, 0x40061914,0x264628CF,
	0x401E8F5C,0x28F5C28F, 0x40061CC8,0xDD1F5796,
	0x401E9999,0x9999999A, 0x4006207C,0xF5136B20,
	0x401EA3D7,0x0A3D70A4, 0x40062430,0x6E721F12,
	0x401EAE14,0x7AE147AE, 0x400627E3,0x498AEC7C,
	0x401EB851,0xEB851EB8, 0x40062B95,0x86AD0A22,
	0x401EC28F,0x5C28F5C3, 0x40062F47,0x26276CCA,
	0x401ECCCC,0xCCCCCCCD, 0x400632F8,0x2848C789,
	0x401ED70A,0x3D70A3D7, 0x400636A8,0x8D5F8C11,
	0x401EE147,0xAE147AE1, 0x40063A58,0x55B9EAFB,
	0x401EEB85,0x1EB851EC, 0x40063E07,0x81A5D413,
	0x401EF5C2,0x8F5C28F6, 0x400641B6,0x1170F6A5,
	0x401F0000,0x00000000, 0x40064564,0x0568C1C3,
	0x401F0A3D,0x70A3D70A, 0x40064911,0x5DDA6496,
	0x401F147A,0xE147AE14, 0x40064CBE,0x1B12CEA2,
	0x401F1EB8,0x51EB851F, 0x4006506A,0x3D5EB010,
	0x401F28F5,0xC28F5C29, 0x40065415,0xC50A79FB,
	0x401F3333,0x33333333, 0x400657C0,0xB2625EB4,
	0x401F3D70,0xA3D70A3D, 0x40065B6B,0x05B2520D,
	0x401F47AE,0x147AE148, 0x40065F14,0xBF4609A0,
	0x401F51EB,0x851EB852, 0x400662BD,0xDF68FD14,
	0x401F5C28,0xF5C28F5C, 0x40066666,0x66666666,
	0x401F6666,0x66666666, 0x40066A0E,0x54894232,
	0x401F70A3,0xD70A3D71, 0x40066DB5,0xAA1C4FF4,
	0x401F7AE1,0x47AE147B, 0x4006715C,0x676A124F,
	0x401F851E,0xB851EB85, 0x40067502,0x8CBCCF54,
	0x401F8F5C,0x28F5C28F, 0x400678A8,0x1A5E90C8,
	0x401F9999,0x9999999A, 0x40067C4D,0x10992464,
	0x401FA3D7,0x0A3D70A4, 0x40067FF1,0x6FB61C1C,
	0x401FAE14,0x7AE147AE, 0x40068395,0x37FECE62,
	0x401FB851,0xEB851EB8, 0x40068738,0x69BC566A,
	0x401FC28F,0x5C28F5C3, 0x40068ADB,0x0537946E,
	0x401FCCCC,0xCCCCCCCD, 0x40068E7D,0x0AB92DEC,
	0x401FD70A,0x3D70A3D7, 0x4006921E,0x7A898DED,
	0x401FE147,0xAE147AE1, 0x400695BF,0x54F0E543,
	0x401FEB85,0x1EB851EC, 0x4006995F,0x9A372AD0,
	0x401FF5C2,0x8F5C28F6, 0x40069CFF,0x4AA41BBF,
	};
/*
LOCAL_D const TUint32 ArctanTest[] =
	{
	0x00000000,0x00000000, 0x00000000,0x00000000,
	0x3F847AE1,0x47AE147B, 0x3F847AB4,0x8B1EFB5D,
	0x3F947AE1,0x47AE147B, 0x3F947A2E,0x5DAFFF07,
	0x3F9EB851,0xEB851EB8, 0x3F9EB5F6,0x44234B83,
	0x3FA47AE1,0x47AE147B, 0x3FA47816,0x23768D56,
	0x3FA99999,0x9999999A, 0x3FA99425,0x97929F27,
	0x3FAEB851,0xEB851EB8, 0x3FAEAEE7,0x34B5DD23,
	0x3FB1EB85,0x1EB851EC, 0x3FB1E40C,0x8B780FDE,
	0x3FB47AE1,0x47AE147B, 0x3FB46FBC,0xE9DFCC00,
	0x3FB70A3D,0x70A3D70A, 0x3FB6FA64,0x46B1CB54,
	0x3FB99999,0x9999999A, 0x3FB983E2,0x82E2CC4D,
	0x3FBC28F5,0xC28F5C29, 0x3FBC0C17,0xD875967A,
	0x3FBEB851,0xEB851EB8, 0x3FBE92E4,0xE371F679,
	0x3FC0A3D7,0x0A3D70A4, 0x3FC08C15,0x5549DC84,
	0x3FC1EB85,0x1EB851EC, 0x3FC1CDE5,0x53D5FE66,
	0x3FC33333,0x33333333, 0x3FC30ED3,0x67D7CD04,
	0x3FC47AE1,0x47AE147B, 0x3FC44ED0,0xCD36E62E,
	0x3FC5C28F,0x5C28F5C3, 0x3FC58DCF,0x04F55E58,
	0x3FC70A3D,0x70A3D70A, 0x3FC6CBBF,0xD8ACFF50,
	0x3FC851EB,0x851EB852, 0x3FC80895,0x5DDAC693,
	0x3FC99999,0x9999999A, 0x3FC94441,0xF8F7260C,
	0x3FCAE147,0xAE147AE1, 0x3FCA7EB8,0x6059C7DA,
	0x3FCC28F5,0xC28F5C29, 0x3FCBB7EB,0x9EE7D317,
	0x3FCD70A3,0xD70A3D71, 0x3FCCEFCF,0x168BED03,
	0x3FCEB851,0xEB851EB8, 0x3FCE2656,0x82776E76,
	0x3FD00000,0x00000000, 0x3FCF5B75,0xF92C80DD,
	0x3FD0A3D7,0x0A3D70A4, 0x3FD04790,0xF72887D4,
	0x3FD147AE,0x147AE148, 0x3FD0E0A7,0x9A2559AF,
	0x3FD1EB85,0x1EB851EC, 0x3FD178F9,0x7ED1F891,
	0x3FD28F5C,0x28F5C28F, 0x3FD21081,0x6F1DAE81,
	0x3FD33333,0x33333333, 0x3FD2A73A,0x661EAF06,
	0x3FD3D70A,0x3D70A3D7, 0x3FD33D1F,0x9074C099,
	0x3FD47AE1,0x47AE147B, 0x3FD3D22C,0x4C92395D,
	0x3FD51EB8,0x51EB851F, 0x3FD4665C,0x2AEBEED4,
	0x3FD5C28F,0x5C28F5C3, 0x3FD4F9AA,0xEE10CA82,
	0x3FD66666,0x66666666, 0x3FD58C14,0x8AA9C5D6,
	0x3FD70A3D,0x70A3D70A, 0x3FD61D95,0x27631EA9,
	0x3FD7AE14,0x7AE147AE, 0x3FD6AE29,0x1CBFA274,
	0x3FD851EB,0x851EB852, 0x3FD73DCC,0xF4D6FA15,
	0x3FD8F5C2,0x8F5C28F6, 0x3FD7CC7D,0x6AFFE959,
	0x3FD99999,0x9999999A, 0x3FD85A37,0x6B677DC0,
	0x3FDA3D70,0xA3D70A3D, 0x3FD8E6F8,0x12962E4E,
	0x3FDAE147,0xAE147AE1, 0x3FD972BC,0xACE3F311,
	0x3FDB851E,0xB851EB85, 0x3FD9FD82,0xB5DC5E5F,
	0x3FDC28F5,0xC28F5C29, 0x3FDA8747,0xD793C3DC,
	0x3FDCCCCC,0xCCCCCCCD, 0x3FDB1009,0xE9EE79BC,
	0x3FDD70A3,0xD70A3D71, 0x3FDB97C6,0xF1DB4032,
	0x3FDE147A,0xE147AE14, 0x3FDC1E7D,0x2081D8E2,
	0x3FDEB851,0xEB851EB8, 0x3FDCA42A,0xD266D56F,
	0x3FDF5C28,0xF5C28F5C, 0x3FDD28CE,0x8E859FEF,
	0x3FE00000,0x00000000, 0x3FDDAC67,0x0561BB4F,
	0x3FE051EB,0x851EB852, 0x3FDE2EF3,0x101033DF,
	0x3FE0A3D7,0x0A3D70A4, 0x3FDEB071,0xAF3A3191,
	0x3FE0F5C2,0x8F5C28F6, 0x3FDF30E2,0x0A199675,
	0x3FE147AE,0x147AE148, 0x3FDFB043,0x6D708C0A,
	0x3FE19999,0x9999999A, 0x3FE0174A,0xA53E6CE4,
	0x3FE1EB85,0x1EB851EC, 0x3FE055EB,0x9AF3EB4B,
	0x3FE23D70,0xA3D70A3D, 0x3FE09404,0x7359DEEB,
	0x3FE28F5C,0x28F5C28F, 0x3FE0D195,0x1A9393B7,
	0x3FE2E147,0xAE147AE1, 0x3FE10E9D,0x8CDBAC48,
	0x3FE33333,0x33333333, 0x3FE14B1D,0xD5F90CE1,
	0x3FE3851E,0xB851EB85, 0x3FE18716,0x10B3DA41,
	0x3FE3D70A,0x3D70A3D7, 0x3FE1C286,0x664AD8C9,
	0x3FE428F5,0xC28F5C29, 0x3FE1FD6F,0x0DE97388,
	0x3FE47AE1,0x47AE147B, 0x3FE237D0,0x4C1EAE02,
	0x3FE4CCCC,0xCCCCCCCD, 0x3FE271AA,0x72553ED5,
	0x3FE51EB8,0x51EB851F, 0x3FE2AAFD,0xDE4D0C9F,
	0x3FF80000,0x00000000, 0x3FEF730B,0xD281F69B,
	0x3FF828F5,0xC28F5C29, 0x3FEF8C22,0xEEB07043,
	0x3FF851EB,0x851EB852, 0x3FEFA4FF,0x2D0F34B7,
	0x3FF87AE1,0x47AE147B, 0x3FEFBDA1,0x3E3D8F55,
	0x3FF8A3D7,0x0A3D70A4, 0x3FEFD609,0xD0B7BEFF,
	0x3FF8CCCC,0xCCCCCCCD, 0x3FEFEE39,0x90DAD712,
	0x3FF8F5C2,0x8F5C28F6, 0x3FF00318,0x947462A0,
	0x3FF91EB8,0x51EB851F, 0x3FF00EF8,0xA0863CC4,
	0x3FF947AE,0x147AE148, 0x3FF01ABD,0x3FAF16B2,
	0x3FF970A3,0xD70A3D71, 0x3FF02666,0xC3F3E3E9,
	0x3FF99999,0x9999999A, 0x3FF031F5,0x7E54ADBE,
	0x3FF9C28F,0x5C28F5C3, 0x3FF03D69,0xBECEDE6D,
	0x3FF9EB85,0x1EB851EC, 0x3FF048C3,0xD45F96F8,
	0x3FFA147A,0xE147AE14, 0x3FF05404,0x0D060ED1,
	0x3FFA3D70,0xA3D70A3D, 0x3FF05F2A,0xB5C5FC40,
	0x3FFA6666,0x66666666, 0x3FF06A38,0x1AAA0497,
	0x3FFA8F5C,0x28F5C28F, 0x3FF0752C,0x86C63350,
	0x3FFAB851,0xEB851EB8, 0x3FF08008,0x443A7731,
	0x3FFAE147,0xAE147AE1, 0x3FF08ACB,0x9C3524A3,
	0x3FFB0A3D,0x70A3D70A, 0x3FF09576,0xD6F57C81,
	0x3FFB3333,0x33333333, 0x3FF0A00A,0x3BCE369F,
	0x3FFB5C28,0xF5C28F5C, 0x3FF0AA86,0x11280F54,
	0x3FFB851E,0xB851EB85, 0x3FF0B4EA,0x9C845764,
	0x3FFBAE14,0x7AE147AE, 0x3FF0BF38,0x227F85AD,
	0x3FFBD70A,0x3D70A3D7, 0x3FF0C96E,0xE6D3CA01,
	0x3FFC0000,0x00000000, 0x3FF0D38F,0x2C5BA09F,
	0x3FFC28F5,0xC28F5C29, 0x3FF0DD99,0x351465C6,
	0x3FFC51EB,0x851EB852, 0x3FF0E78D,0x4220E8EF,
	0x3FFC7AE1,0x47AE147B, 0x3FF0F16B,0x93CBFF2A,
	0x3FFCA3D7,0x0A3D70A4, 0x3FF0FB34,0x698B1438,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FF104E8,0x0200BA00,
	0x3FFCF5C2,0x8F5C28F6, 0x3FF10E86,0x9AFF35F2,
	0x3FFD1EB8,0x51EB851F, 0x3FF11810,0x718B0C06,
	0x3FFD47AE,0x147AE148, 0x3FF12185,0xC1DD8701,
	0x3FFD70A3,0xD70A3D71, 0x3FF12AE6,0xC7673DAB,
	0x3FFD9999,0x9999999A, 0x3FF13433,0xBCD294B5,
	0x3FFDC28F,0x5C28F5C3, 0x3FF13D6C,0xDC063D05,
	0x3FFDEB85,0x1EB851EC, 0x3FF14692,0x5E27AE23,
	0x3FFE147A,0xE147AE14, 0x3FF14FA4,0x7B9D9C95,
	0x3FFE3D70,0xA3D70A3D, 0x3FF158A3,0x6C126BF2,
	0x3FFE6666,0x66666666, 0x3FF1618F,0x66769C69,
	0x3FFE8F5C,0x28F5C28F, 0x3FF16A68,0xA10333A9,
	0x3FFEB851,0xEB851EB8, 0x3FF1732F,0x513C20E4,
	0x3FFEE147,0xAE147AE1, 0x3FF17BE3,0xABF29BCE,
	0x3FFF0A3D,0x70A3D70A, 0x3FF18485,0xE5477E85,
	0x3FFF3333,0x33333333, 0x3FF18D16,0x30AD9A1A,
	0x3FFF5C28,0xF5C28F5C, 0x3FF19594,0xC0EC05CA,
	0x3FFF851E,0xB851EB85, 0x3FF19E01,0xC82068A8,
	0x3FFFAE14,0x7AE147AE, 0x3FF1A65D,0x77C13DAE,
	0x3FFFD70A,0x3D70A3D7, 0x3FF1AEA8,0x00A01226,
	0x40000000,0x00000000, 0x3FF1B6E1,0x92EBBE44,
	0x4000147A,0xE147AE14, 0x3FF1BF0A,0x5E3297F5,
	0x400028F5,0xC28F5C29, 0x3FF1C722,0x91649FC2,
	0x40003D70,0xA3D70A3D, 0x3FF1CF2A,0x5AD5A7C5,
	0x400051EB,0x851EB852, 0x3FF1D721,0xE83F74A2,
	0x40006666,0x66666666, 0x3FF1DF09,0x66C3D878,
	0x40007AE1,0x47AE147B, 0x3FF1E6E1,0x02EEC7CB,
	0x40008F5C,0x28F5C28F, 0x3FF1EEA8,0xE8B8684D,
	0x4000A3D7,0x0A3D70A4, 0x3FF1F661,0x438719A2,
	0x4000B851,0xEB851EB8, 0x3FF1FE0A,0x3E3177FA,
	0x4000CCCC,0xCCCCCCCD, 0x3FF205A4,0x03005899,
	0x4000E147,0xAE147AE1, 0x3FF20D2E,0xBBB0C03D,
	0x4000F5C2,0x8F5C28F6, 0x3FF214AA,0x9175D36D,
	0x40010A3D,0x70A3D70A, 0x3FF21C17,0xACFAC0AB,
	0x40011EB8,0x51EB851F, 0x3FF22376,0x3664A496,
	0x40013333,0x33333333, 0x3FF22AC6,0x555467F6,
	0x400147AE,0x147AE148, 0x3FF23208,0x30E897BB,
	0x40015C28,0xF5C28F5C, 0x3FF2393B,0xEFBF36F9,
	0x400170A3,0xD70A3D71, 0x3FF24061,0xB7F78AE4,
	0x4001851E,0xB851EB85, 0x3FF24779,0xAF33E0D0,
	0x40019999,0x9999999A, 0x3FF24E83,0xFA9B4E48,
	0x4001AE14,0x7AE147AE, 0x3FF25580,0xBEDB6B38,
	0x4001C28F,0x5C28F5C3, 0x3FF25C70,0x202A063E,
	0x4001D70A,0x3D70A3D7, 0x3FF26352,0x4246D324,
	0x4001EB85,0x1EB851EC, 0x3FF26A27,0x487D139A,
	0x40020000,0x00000000, 0x3FF270EF,0x55A53A25,
	0x4002147A,0xE147AE14, 0x3FF277AA,0x8C26876B,
	0x400228F5,0xC28F5C29, 0x3FF27E59,0x0DF8A1D2,
	0x40023D70,0xA3D70A3D, 0x3FF284FA,0xFCA52783,
	0x400251EB,0x851EB852, 0x3FF28B90,0x79493AE7,
	0x40026666,0x66666666, 0x3FF29219,0xA49709A1,
	0x40027AE1,0x47AE147B, 0x3FF29896,0x9ED74E17,
	0x40028F5C,0x28F5C28F, 0x3FF29F07,0x87EACB94,
	0x4002A3D7,0x0A3D70A4, 0x3FF2A56C,0x7F4BC517,
	0x4002B851,0xEB851EB8, 0x3FF2ABC5,0xA40F6ED6,
	0x4002CCCC,0xCCCCCCCD, 0x3FF2B213,0x14E75A87,
	0x4002E147,0xAE147AE1, 0x3FF2B854,0xF022DE7D,
	0x4002F5C2,0x8F5C28F6, 0x3FF2BE8B,0x53B077A8,
	0x40030A3D,0x70A3D70A, 0x3FF2C4B6,0x5D1F2682,
	0x40031EB8,0x51EB851F, 0x3FF2CAD6,0x299FC702,
	0x40033333,0x33333333, 0x3FF2D0EA,0xD6066395,
	0x400347AE,0x147AE148, 0x3FF2D6F4,0x7ECB833A,
	0x40035C28,0xF5C28F5C, 0x3FF2DCF3,0x400D72C6,
	0x400370A3,0xD70A3D71, 0x3FF2E2E7,0x35918965,
	0x4003851E,0xB851EB85, 0x3FF2E8D0,0x7AC56862,
	0x40039999,0x9999999A, 0x3FF2EEAF,0x2AC0364C,
	0x4003AE14,0x7AE147AE, 0x3FF2F483,0x6043D57D,
	0x4003C28F,0x5C28F5C3, 0x3FF2FA4D,0x35BE1618,
	0x4003D70A,0x3D70A3D7, 0x3FF3000C,0xC549E391,
	0x4003EB85,0x1EB851EC, 0x3FF305C2,0x28B06DC2,
	0x40040000,0x00000000, 0x3FF30B6D,0x796A4DA8,
	0x4004147A,0xE147AE14, 0x3FF3110E,0xD0A0A5D0,
	0x400428F5,0xC28F5C29, 0x3FF316A6,0x472E3E7F,
	0x40043D70,0xA3D70A3D, 0x3FF31C33,0xF5A09DB2,
	0x400451EB,0x851EB852, 0x3FF321B7,0xF4391AF3,
	0x40046666,0x66666666, 0x3FF32732,0x5AEDEF1D,
	0x40047AE1,0x47AE147B, 0x3FF32CA3,0x416B401A,
	0x40048F5C,0x28F5C28F, 0x3FF3320A,0xBF1428A7,
	0x4004A3D7,0x0A3D70A4, 0x3FF33768,0xEB03BC31,
	0x4004B851,0xEB851EB8, 0x3FF33CBD,0xDC0E06D0,
	0x4004CCCC,0xCCCCCCCD, 0x3FF34209,0xA8C10980,
	0x4004E147,0xAE147AE1, 0x3FF3474C,0x6765B28B,
	0x4004F5C2,0x8F5C28F6, 0x3FF34C86,0x2E00D24E,
	0x40050A3D,0x70A3D70A, 0x3FF351B7,0x12540C4D,
	0x40051EB8,0x51EB851F, 0x3FF356DF,0x29DEC4B8,
	0x40053333,0x33333333, 0x3FF35BFE,0x89DF0A64,
	0x400547AE,0x147AE148, 0x3FF36115,0x47527D45,
	0x40055C28,0xF5C28F5C, 0x3FF36623,0x76F73175,
	0x400570A3,0xD70A3D71, 0x3FF36B29,0x2D4C8EE0,
	0x4005851E,0xB851EB85, 0x3FF37026,0x7E942D93,
	0x40059999,0x9999999A, 0x3FF3751B,0x7ED2AEC1,
	0x4005AE14,0x7AE147AE, 0x3FF37A08,0x41D0928E,
	0x4005C28F,0x5C28F5C3, 0x3FF37EEC,0xDB1B0AA9,
	0x4005D70A,0x3D70A3D7, 0x3FF383C9,0x5E04C9B9,
	0x4005EB85,0x1EB851EC, 0x3FF3889D,0xDDA6CFBC,
	0x40060000,0x00000000, 0x3FF38D6A,0x6CE13353,
	0x4006147A,0xE147AE14, 0x3FF3922F,0x1E5BE80C,
	0x400628F5,0xC28F5C29, 0x3FF396EC,0x048781BA,
	0x40063D70,0xA3D70A3D, 0x3FF39BA1,0x319DF4DD,
	0x400651EB,0x851EB852, 0x3FF3A04E,0xB7A35432,
	0x40066666,0x66666666, 0x3FF3A4F4,0xA8668B69,
	0x40067AE1,0x47AE147B, 0x3FF3A993,0x15821717,
	0x40068F5C,0x28F5C28F, 0x3FF3AE2A,0x105CB9E3,
	0x4006A3D7,0x0A3D70A4, 0x3FF3B2B9,0xAA2A2F0B,
	0x4006B851,0xEB851EB8, 0x3FF3B741,0xF3EBDA34,
	0x4006CCCC,0xCCCCCCCD, 0x3FF3BBC2,0xFE7174A3,
	0x4006E147,0xAE147AE1, 0x3FF3C03C,0xDA59B7E2,
	0x4006F5C2,0x8F5C28F6, 0x3FF3C4AF,0x981305D8,
	0x40070A3D,0x70A3D70A, 0x3FF3C91B,0x47DC0E63,
	0x40071EB8,0x51EB851F, 0x3FF3CD7F,0xF9C4727D,
	0x40073333,0x33333333, 0x3FF3D1DD,0xBDAD64F0,
	0x400747AE,0x147AE148, 0x3FF3D634,0xA34A48B1,
	0x40075C28,0xF5C28F5C, 0x3FF3DA84,0xBA214CD5,
	0x400770A3,0xD70A3D71, 0x3FF3DECE,0x118C0645,
	0x4007851E,0xB851EB85, 0x3FF3E310,0xB8B8071A,
	0x40079999,0x9999999A, 0x3FF3E74C,0xBEA773CD,
	0x4007AE14,0x7AE147AE, 0x3FF3EB82,0x32319624,
	0x4007C28F,0x5C28F5C3, 0x3FF3EFB1,0x22036DFF,
	0x4007D70A,0x3D70A3D7, 0x3FF3F3D9,0x9CA03FF5,
	0x4007EB85,0x1EB851EC, 0x3FF3F7FB,0xB06221E3,
	0x40080000,0x00000000, 0x3FF3FC17,0x6B7A8560,
	0x4008147A,0xE147AE14, 0x3FF4002C,0xDBF2C02B,
	0x400828F5,0xC28F5C29, 0x3FF4043C,0x0FAC9294,
	0x40083D70,0xA3D70A3D, 0x3FF40845,0x1462ABEF,
	0x400851EB,0x851EB852, 0x3FF40C47,0xF7A92D14,
	0x40086666,0x66666666, 0x3FF41044,0xC6EE28EF,
	0x40087AE1,0x47AE147B, 0x3FF4143B,0x8F7A2339,
	0x40088F5C,0x28F5C28F, 0x3FF4182C,0x5E708D48,
	0x4008A3D7,0x0A3D70A4, 0x3FF41C17,0x40D0411B,
	0x4008B851,0xEB851EB8, 0x3FF41FFC,0x4373FA89,
	0x4008CCCC,0xCCCCCCCD, 0x3FF423DB,0x7312CEBC,
	0x4008E147,0xAE147AE1, 0x3FF427B4,0xDC40A1DF,
	0x4008F5C2,0x8F5C28F6, 0x3FF42B88,0x8B6E9B1D,
	0x40090A3D,0x70A3D70A, 0x3FF42F56,0x8CEB96F3,
	0x40091EB8,0x51EB851F, 0x3FF4331E,0xECE497CD,
	0x40093333,0x33333333, 0x3FF436E1,0xB765350D,
	0x400947AE,0x147AE148, 0x3FF43A9E,0xF8580870,
	0x40095C28,0xF5C28F5C, 0x3FF43E56,0xBB8719D9,
	0x400970A3,0xD70A3D71, 0x3FF44209,0x0C9C4997,
	0x4009851E,0xB851EB85, 0x3FF445B5,0xF721B91A,
	0x40099999,0x9999999A, 0x3FF4495D,0x86823225,
	0x4009AE14,0x7AE147AE, 0x3FF44CFF,0xC6098C8B,
	0x4009C28F,0x5C28F5C3, 0x3FF4509C,0xC0E51269,
	0x4009D70A,0x3D70A3D7, 0x3FF45434,0x8223E2FA,
	0x4009EB85,0x1EB851EC, 0x3FF457C7,0x14B753F9,
	0x400A0000,0x00000000, 0x3FF45B54,0x837351A0,
	0x400A147A,0xE147AE14, 0x3FF45EDC,0xD90EBD46,
	0x400A28F5,0xC28F5C29, 0x3FF46260,0x2023CAA2,
	0x400A3D70,0xA3D70A3D, 0x3FF465DE,0x63305BBC,
	0x400A51EB,0x851EB852, 0x3FF46957,0xAC965B89,
	0x400A6666,0x66666666, 0x3FF46CCC,0x069C173F,
	0x400A7AE1,0x47AE147B, 0x3FF4703B,0x7B6C9666,
	0x400A8F5C,0x28F5C28F, 0x3FF473A6,0x1517F1A2,
	0x400AA3D7,0x0A3D70A4, 0x3FF4770B,0xDD93A84C,
	0x400AB851,0xEB851EB8, 0x3FF47A6C,0xDEBAF4C4,
	0x400ACCCC,0xCCCCCCCD, 0x3FF47DC9,0x224F1FA8,
	0x400AE147,0xAE147AE1, 0x3FF48120,0xB1F7D1C5,
	0x400AF5C2,0x8F5C28F6, 0x3FF48473,0x974364F3,
	0x400B0A3D,0x70A3D70A, 0x3FF487C1,0xDBA733C7,
	0x400B1EB8,0x51EB851F, 0x3FF48B0B,0x887FE81E,
	0x400B3333,0x33333333, 0x3FF48E50,0xA711C89D,
	0x400B47AE,0x147AE148, 0x3FF49191,0x4089050A,
	0x400B5C28,0xF5C28F5C, 0x3FF494CD,0x5DFA01A1,
	0x400B70A3,0xD70A3D71, 0x3FF49805,0x0861A150,
	0x400B851E,0xB851EB85, 0x3FF49B38,0x48A58EF0,
	0x400B9999,0x9999999A, 0x3FF49E67,0x27948576,
	0x400BAE14,0x7AE147AE, 0x3FF4A191,0xADE69723,
	0x400BC28F,0x5C28F5C3, 0x3FF4A4B7,0xE43D73B8,
	0x400BD70A,0x3D70A3D7, 0x3FF4A7D9,0xD324ADA9,
	0x400BEB85,0x1EB851EC, 0x3FF4AAF7,0x8311FE65,
	0x400C0000,0x00000000, 0x3FF4AE10,0xFC6589A5,
	0x400C147A,0xE147AE14, 0x3FF4B126,0x476A1FCA,
	0x400C28F5,0xC28F5C29, 0x3FF4B437,0x6C557F5A,
	0x400C3D70,0xA3D70A3D, 0x3FF4B744,0x7348958C,
	0x400C51EB,0x851EB852, 0x3FF4BA4D,0x644FBDF4,
	0x400C6666,0x66666666, 0x3FF4BD52,0x47630152,
	0x400C7AE1,0x47AE147B, 0x3FF4C053,0x2466537E,
	0x400C8F5C,0x28F5C28F, 0x3FF4C350,0x0329D080,
	0x400CA3D7,0x0A3D70A4, 0x3FF4C648,0xEB69F8CE,
	0x400CB851,0xEB851EB8, 0x3FF4C93D,0xE4CFECBA,
	0x400CCCCC,0xCCCCCCCD, 0x3FF4CC2E,0xF6F1A710,
	0x400CE147,0xAE147AE1, 0x3FF4CF1C,0x295236E4,
	0x400CF5C2,0x8F5C28F6, 0x3FF4D205,0x8361F89C,
	0x400D0A3D,0x70A3D70A, 0x3FF4D4EB,0x0C7ECE2F,
	0x400D1EB8,0x51EB851F, 0x3FF4D7CC,0xCBF456A3,
	0x400D3333,0x33333333, 0x3FF4DAAA,0xC8FC24CC,
	0x400D47AE,0x147AE148, 0x3FF4DD85,0x0ABDF549,
	0x400D5C28,0xF5C28F5C, 0x3FF4E05B,0x984FE3C9,
	0x400D70A3,0xD70A3D71, 0x3FF4E32E,0x78B69F9C,
	0x400D851E,0xB851EB85, 0x3FF4E5FD,0xB2E59F85,
	0x400D9999,0x9999999A, 0x3FF4E8C9,0x4DBF54E5,
	0x400DAE14,0x7AE147AE, 0x3FF4EB91,0x50155E2D,
	0x400DC28F,0x5C28F5C3, 0x3FF4EE55,0xC0A8B8AA,
	0x400DD70A,0x3D70A3D7, 0x3FF4F116,0xA629F1A2,
	0x400DEB85,0x1EB851EC, 0x3FF4F3D4,0x073956CA,
	0x400E0000,0x00000000, 0x3FF4F68D,0xEA672617,
	0x400E147A,0xE147AE14, 0x3FF4F944,0x5633BCEF,
	0x400E28F5,0xC28F5C29, 0x3FF4FBF7,0x510FC6B2,
	0x400E3D70,0xA3D70A3D, 0x3FF4FEA6,0xE15C6AAC,
	0x400E51EB,0x851EB852, 0x3FF50153,0x0D6B7969,
	0x400E6666,0x66666666, 0x3FF503FB,0xDB7F996E,
	0x400E7AE1,0x47AE147B, 0x3FF506A1,0x51CC735C,
	0x400E8F5C,0x28F5C28F, 0x3FF50943,0x7676DD80,
	0x400EA3D7,0x0A3D70A4, 0x3FF50BE2,0x4F9506CB,
	0x400EB851,0xEB851EB8, 0x3FF50E7D,0xE32EA13C,
	0x400ECCCC,0xCCCCCCCD, 0x3FF51116,0x373D0BC2,
	0x400EE147,0xAE147AE1, 0x3FF513AB,0x51AB7B85,
	0x400EF5C2,0x8F5C28F6, 0x3FF5163D,0x385724AE,
	0x400F0A3D,0x70A3D70A, 0x3FF518CB,0xF10F62A5,
	0x400F1EB8,0x51EB851F, 0x3FF51B57,0x8195DFC6,
	0x400F3333,0x33333333, 0x3FF51DDF,0xEF9EBC94,
	0x400F47AE,0x147AE148, 0x3FF52065,0x40D0B66B,
	0x400F5C28,0xF5C28F5C, 0x3FF522E7,0x7AC54DAA,
	0x400F70A3,0xD70A3D71, 0x3FF52566,0xA308EB6C,
	0x400F851E,0xB851EB85, 0x3FF527E2,0xBF1B06B3,
	0x400F9999,0x9999999A, 0x3FF52A5B,0xD46E492A,
	0x400FAE14,0x7AE147AE, 0x3FF52CD1,0xE868B35E,
	0x400FC28F,0x5C28F5C3, 0x3FF52F45,0x0063C08A,
	0x400FD70A,0x3D70A3D7, 0x3FF531B5,0x21AC89EA,
	0x400FEB85,0x1EB851EC, 0x3FF53422,0x5183E999,
	0x40100000,0x00000000, 0x3FF5368C,0x951E9CFD,
	};

LOCAL_D const TUint32 ArcsinTest[] =
	{
	0x00000000,0x00000000, 0x00000000,0x00000000,
	0x3F747AE1,0x47AE147B, 0x3F747AE6,0xDF5A1444,
	0x3F847AE1,0x47AE147B, 0x3F847AF7,0xA68F8EEF,
	0x3F8EB851,0xEB851EB8, 0x3F8EB89D,0x6CD47A22,
	0x3F947AE1,0x47AE147B, 0x3F947B3A,0xC64BE09A,
	0x3F999999,0x9999999A, 0x3F999A48,0x696E25A4,
	0x3F9EB851,0xEB851EB8, 0x3F9EB980,0x08422806,
	0x3FA1EB85,0x1EB851EC, 0x3FA1EC75,0x06D2956A,
	0x3FA47AE1,0x47AE147B, 0x3FA47C47,0x73AEBD59,
	0x3FA70A3D,0x70A3D70A, 0x3FA70C3B,0x834BE3FC,
	0x3FA99999,0x9999999A, 0x3FA99C55,0x70328659,
	0x3FAC28F5,0xC28F5C29, 0x3FAC2C99,0x771C898D,
	0x3FAEB851,0xEB851EB8, 0x3FAEBD0B,0xD734D8A7,
	0x3FB0A3D7,0x0A3D70A4, 0x3FB0A6D8,0x692BB3BD,
	0x3FB1EB85,0x1EB851EC, 0x3FB1EF46,0x56A8D28C,
	0x3FB33333,0x33333333, 0x3FB337D1,0xD811B44C,
	0x3FB47AE1,0x47AE147B, 0x3FB4807D,0x1320318C,
	0x3FB5C28F,0x5C28F5C3, 0x3FB5C94A,0x2F6910FA,
	0x3FB70A3D,0x70A3D70A, 0x3FB7123B,0x567D5638,
	0x3FB851EB,0x851EB852, 0x3FB85B52,0xB40BE42D,
	0x3FB99999,0x9999999A, 0x3FB9A492,0x76037884,
	0x3FBAE147,0xAE147AE1, 0x3FBAEDFC,0xCCB50667,
	0x3FBC28F5,0xC28F5C29, 0x3FBC3793,0xEAF67675,
	0x3FBD70A3,0xD70A3D71, 0x3FBD815A,0x0645D212,
	0x3FBEB851,0xEB851EB8, 0x3FBECB51,0x56ECE085,
	0x3FC00000,0x00000000, 0x3FC00ABE,0x0C129E1E,
	0x3FC0A3D7,0x0A3D70A4, 0x3FC0AFEE,0x441E736F,
	0x3FC147AE,0x147AE148, 0x3FC1553A,0x745DB182,
	0x3FC1EB85,0x1EB851EC, 0x3FC1FAA3,0xBF43AD3B,
	0x3FC28F5C,0x28F5C28F, 0x3FC2A02B,0x49066C16,
	0x3FC33333,0x33333333, 0x3FC345D2,0x37B20EB3,
	0x3FC3D70A,0x3D70A3D7, 0x3FC3EB99,0xB33C8CA7,
	0x3FC47AE1,0x47AE147B, 0x3FC49182,0xE599C592,
	0x3FC51EB8,0x51EB851F, 0x3FC5378E,0xFACFEB5F,
	0x3FC5C28F,0x5C28F5C3, 0x3FC5DDBF,0x210C49E2,
	0x3FC66666,0x66666666, 0x3FC68414,0x88B8700C,
	0x3FC70A3D,0x70A3D70A, 0x3FC72A90,0x648FBF25,
	0x3FC7AE14,0x7AE147AE, 0x3FC7D133,0xE9B56483,
	0x3FC851EB,0x851EB852, 0x3FC87800,0x4FCAC282,
	0x3FC8F5C2,0x8F5C28F6, 0x3FC91EF6,0xD1064D8C,
	0x3FC99999,0x9999999A, 0x3FC9C618,0xAA4AE23D,
	0x3FCA3D70,0xA3D70A3D, 0x3FCA6D67,0x1B3F99C4,
	0x3FCAE147,0xAE147AE1, 0x3FCB14E3,0x666821F8,
	0x3FCB851E,0xB851EB85, 0x3FCBBC8E,0xD13D9EA5,
	0x3FCC28F5,0xC28F5C29, 0x3FCC646A,0xA44819DA,
	0x3FCCCCCC,0xCCCCCCCD, 0x3FCD0C78,0x2B38893C,
	0x3FCD70A3,0xD70A3D71, 0x3FCDB4B8,0xB5036E9A,
	0x3FCE147A,0xE147AE14, 0x3FCE5D2D,0x93FC1A2B,
	0x3FCEB851,0xEB851EB8, 0x3FCF05D8,0x1DF0953F,
	0x3FCF5C28,0xF5C28F5C, 0x3FCFAEB9,0xAC463C49,
	0x3FD00000,0x00000000, 0x3FD02BE9,0xCE0B87CD,
	0x3FD051EB,0x851EB852, 0x3FD08093,0xA727E129,
	0x3FD0A3D7,0x0A3D70A4, 0x3FD0D55B,0x13E747AE,
	0x3FD0F5C2,0x8F5C28F6, 0x3FD12A40,0xC8C16E57,
	0x3FD147AE,0x147AE148, 0x3FD17F45,0x7C46DAAB,
	0x3FD19999,0x9999999A, 0x3FD1D469,0xE731919C,
	0x3FD1EB85,0x1EB851EC, 0x3FD229AE,0xC47638DD,
	0x3FD23D70,0xA3D70A3D, 0x3FD27F14,0xD155B18A,
	0x3FD28F5C,0x28F5C28F, 0x3FD2D49C,0xCD6F3133,
	0x3FD2E147,0xAE147AE1, 0x3FD32A47,0x7AD2DE7F,
	0x3FD33333,0x33333333, 0x3FD38015,0x9E14F6FF,
	0x3FD3851E,0xB851EB85, 0x3FD3D607,0xFE6183DC,
	0x3FD3D70A,0x3D70A3D7, 0x3FD42C1F,0x6590A37D,
	0x3FD428F5,0xC28F5C29, 0x3FD4825C,0xA03B6E54,
	0x3FD47AE1,0x47AE147B, 0x3FD4D8C0,0x7DD17D7D,
	0x3FD4CCCC,0xCCCCCCCD, 0x3FD52F4B,0xD0AF1A0B,
	0x3FD51EB8,0x51EB851F, 0x3FD585FF,0x6E341C3E,
	0x3FD570A3,0xD70A3D71, 0x3FD5DCDC,0x2EDB8227,
	0x3FD5C28F,0x5C28F5C3, 0x3FD633E2,0xEE53C5B9,
	0x3FD6147A,0xE147AE14, 0x3FD68B14,0x8B97FA84,
	0x3FD66666,0x66666666, 0x3FD6E271,0xE909BBE4,
	0x3FD6B851,0xEB851EB8, 0x3FD739FB,0xEC8BF4B2,
	0x3FD70A3D,0x70A3D70A, 0x3FD791B3,0x7F9E8A25,
	0x3FD75C28,0xF5C28F5C, 0x3FD7E999,0x8F7AF3F6,
	0x3FD7AE14,0x7AE147AE, 0x3FD841AF,0x0D31CC53,
	0x3FD80000,0x00000000, 0x3FD899F4,0xEDC962D3,
	0x3FD851EB,0x851EB852, 0x3FD8F26C,0x2A5D5E1D,
	0x3FD8A3D7,0x0A3D70A4, 0x3FD94B15,0xC03F7890,
	0x3FD8F5C2,0x8F5C28F6, 0x3FD9A3F2,0xB11964EC,
	0x3FD947AE,0x147AE148, 0x3FD9FD04,0x030FE8A3,
	0x3FD99999,0x9999999A, 0x3FDA564A,0xC0E73A34,
	0x3FD9EB85,0x1EB851EC, 0x3FDAAFC7,0xFA28B2BE,
	0x3FDA3D70,0xA3D70A3D, 0x3FDB097C,0xC349E2C6,
	0x3FDA8F5C,0x28F5C28F, 0x3FDB636A,0x35D51B17,
	0x3FDAE147,0xAE147AE1, 0x3FDBBD91,0x70937B7F,
	0x3FDB3333,0x33333333, 0x3FDC17F3,0x97B89A42,
	0x3FDB851E,0xB851EB85, 0x3FDC7291,0xD50FD81E,
	0x3FDBD70A,0x3D70A3D7, 0x3FDCCD6D,0x582B75E4,
	0x3FDC28F5,0xC28F5C29, 0x3FDD2887,0x569581CA,
	0x3FDC7AE1,0x47AE147B, 0x3FDD83E1,0x0C02B412,
	0x3FDCCCCC,0xCCCCCCCD, 0x3FDDDF7B,0xBA8753CD,
	0x3FDD1EB8,0x51EB851F, 0x3FDE3B58,0xAACE3E1C,
	0x3FDD70A3,0xD70A3D71, 0x3FDE9779,0x2C522BE1,
	0x3FDDC28F,0x5C28F5C3, 0x3FDEF3DE,0x95995367,
	0x3FDE147A,0xE147AE14, 0x3FDF508A,0x4473857E,
	0x3FDE6666,0x66666666, 0x3FDFAD7D,0x9E3AE753,
	0x3FDEB851,0xEB851EB8, 0x3FE0055D,0x080BB634,
	0x3FDF0A3D,0x70A3D70A, 0x3FE03420,0x87A29B28,
	0x3FDF5C28,0xF5C28F5C, 0x3FE0630A,0x0CAF011A,
	0x3FDFAE14,0x7AE147AE, 0x3FE0921A,0x5A52E74D,
	0x3FE00000,0x00000000, 0x3FE0C152,0x382D7366,
	};
*/
LOCAL_D const TUint32 ArctanTest[] =
	{
	0x00000000,0x00000000, 0x00000000,0x00000000,
	0x3F747AE1,0x47AE147B, 0x3F747AD6,0x186952B5,
	0x3F847AE1,0x47AE147B, 0x3F847AB4,0x8B1EFB5D,
	0x3F8EB851,0xEB851EB8, 0x3F8EB7BA,0xF2082977,
	0x3F947AE1,0x47AE147B, 0x3F947A2E,0x5DAFFF07,
	0x3F999999,0x9999999A, 0x3F99983C,0x34A774D2,
	0x3F9EB851,0xEB851EB8, 0x3F9EB5F6,0x44234B83,
	0x3FA1EB85,0x1EB851EC, 0x3FA1E9A5,0xEC6421B1,
	0x3FA47AE1,0x47AE147B, 0x3FA47816,0x23768D56,
	0x3FA70A3D,0x70A3D70A, 0x3FA70643,0x75EF93F7,
	0x3FA99999,0x9999999A, 0x3FA99425,0x97929F27,
	0x3FAC28F5,0xC28F5C29, 0x3FAC21B4,0x41E04F61,
	0x3FAEB851,0xEB851EB8, 0x3FAEAEE7,0x34B5DD23,
	0x3FB0A3D7,0x0A3D70A4, 0x3FB09DDB,0x1B75A262,
	0x3FB1EB85,0x1EB851EC, 0x3FB1E40C,0x8B780FDE,
	0x3FB33333,0x33333333, 0x3FB32A03,0xD5B3875B,
	0x3FB47AE1,0x47AE147B, 0x3FB46FBC,0xE9DFCC00,
	0x3FB5C28F,0x5C28F5C3, 0x3FB5B533,0xBC672F49,
	0x3FB70A3D,0x70A3D70A, 0x3FB6FA64,0x46B1CB54,
	0x3FB851EB,0x851EB852, 0x3FB83F4A,0x876FCEA2,
	0x3FB99999,0x9999999A, 0x3FB983E2,0x82E2CC4D,
	0x3FBAE147,0xAE147AE1, 0x3FBAC828,0x43260428,
	0x3FBC28F5,0xC28F5C29, 0x3FBC0C17,0xD875967A,
	0x3FBD70A3,0xD70A3D71, 0x3FBD4FAD,0x59749764,
	0x3FBEB851,0xEB851EB8, 0x3FBE92E4,0xE371F679,
	0x3FC00000,0x00000000, 0x3FBFD5BA,0x9AAC2F6E,
	0x3FC0A3D7,0x0A3D70A4, 0x3FC08C15,0x5549DC84,
	0x3FC147AE,0x147AE148, 0x3FC12D18,0xA3061410,
	0x3FC1EB85,0x1EB851EC, 0x3FC1CDE5,0x53D5FE66,
	0x3FC28F5C,0x28F5C28F, 0x3FC26E79,0x88FD8817,
	0x3FC33333,0x33333333, 0x3FC30ED3,0x67D7CD04,
	0x3FC3D70A,0x3D70A3D7, 0x3FC3AEF1,0x19F4E2B1,
	0x3FC47AE1,0x47AE147B, 0x3FC44ED0,0xCD36E62E,
	0x3FC51EB8,0x51EB851F, 0x3FC4EE70,0xB3EE49B0,
	0x3FC5C28F,0x5C28F5C3, 0x3FC58DCF,0x04F55E58,
	0x3FC66666,0x66666666, 0x3FC62CE9,0xFBCB16C0,
	0x3FC70A3D,0x70A3D70A, 0x3FC6CBBF,0xD8ACFF50,
	0x3FC7AE14,0x7AE147AE, 0x3FC76A4E,0xE0B0695E,
	0x3FC851EB,0x851EB852, 0x3FC80895,0x5DDAC693,
	0x3FC8F5C2,0x8F5C28F6, 0x3FC8A691,0x9F393230,
	0x3FC99999,0x9999999A, 0x3FC94441,0xF8F7260C,
	0x3FCA3D70,0xA3D70A3D, 0x3FC9E1A4,0xC4745962,
	0x3FCAE147,0xAE147AE1, 0x3FCA7EB8,0x6059C7DA,
	0x3FCB851E,0xB851EB85, 0x3FCB1B7B,0x30ADDF4B,
	0x3FCC28F5,0xC28F5C29, 0x3FCBB7EB,0x9EE7D317,
	0x3FCCCCCC,0xCCCCCCCD, 0x3FCC5408,0x1A021430,
	0x3FCD70A3,0xD70A3D71, 0x3FCCEFCF,0x168BED03,
	0x3FCE147A,0xE147AE14, 0x3FCD8B3F,0x0EBA40DA,
	0x3FCEB851,0xEB851EB8, 0x3FCE2656,0x82776E76,
	0x3FCF5C28,0xF5C28F5C, 0x3FCEC113,0xF77255BF,
	0x3FD00000,0x00000000, 0x3FCF5B75,0xF92C80DD,
	0x3FD051EB,0x851EB852, 0x3FCFF57B,0x19077106,
	0x3FD0A3D7,0x0A3D70A4, 0x3FD04790,0xF72887D4,
	0x3FD0F5C2,0x8F5C28F6, 0x3FD09434,0x8B27A260,
	0x3FD147AE,0x147AE148, 0x3FD0E0A7,0x9A2559AF,
	0x3FD19999,0x9999999A, 0x3FD12CE9,0x78CC4EC9,
	0x3FD1EB85,0x1EB851EC, 0x3FD178F9,0x7ED1F891,
	0x3FD23D70,0xA3D70A3D, 0x3FD1C4D7,0x06FABF59,
	0x3FD28F5C,0x28F5C28F, 0x3FD21081,0x6F1DAE81,
	0x3FD2E147,0xAE147AE1, 0x3FD25BF8,0x1827BD2A,
	0x3FD33333,0x33333333, 0x3FD2A73A,0x661EAF06,
	0x3FD3851E,0xB851EB85, 0x3FD2F247,0xC0238E5E,
	0x3FD3D70A,0x3D70A3D7, 0x3FD33D1F,0x9074C099,
	0x3FD428F5,0xC28F5C29, 0x3FD387C1,0x446FB673,
	0x3FD47AE1,0x47AE147B, 0x3FD3D22C,0x4C92395D,
	0x3FD4CCCC,0xCCCCCCCD, 0x3FD41C60,0x1C7B5755,
	0x3FD51EB8,0x51EB851F, 0x3FD4665C,0x2AEBEED4,
	0x3FD570A3,0xD70A3D71, 0x3FD4B01F,0xF1C6DC3C,
	0x3FD5C28F,0x5C28F5C3, 0x3FD4F9AA,0xEE10CA82,
	0x3FD6147A,0xE147AE14, 0x3FD542FC,0x9FEFA8A9,
	0x3FD66666,0x66666666, 0x3FD58C14,0x8AA9C5D6,
	0x3FD6B851,0xEB851EB8, 0x3FD5D4F2,0x34A495A3,
	0x3FD70A3D,0x70A3D70A, 0x3FD61D95,0x27631EA9,
	0x3FD75C28,0xF5C28F5C, 0x3FD665FC,0xEF8414F8,
	0x3FD7AE14,0x7AE147AE, 0x3FD6AE29,0x1CBFA274,
	0x3FD80000,0x00000000, 0x3FD6F619,0x41E4DEF1,
	0x3FD851EB,0x851EB852, 0x3FD73DCC,0xF4D6FA15,
	0x3FD8A3D7,0x0A3D70A4, 0x3FD78543,0xCE8A18F4,
	0x3FD8F5C2,0x8F5C28F6, 0x3FD7CC7D,0x6AFFE959,
	0x3FD947AE,0x147AE148, 0x3FD81379,0x6943ECDC,
	0x3FD99999,0x9999999A, 0x3FD85A37,0x6B677DC0,
	0x3FD9EB85,0x1EB851EC, 0x3FD8A0B7,0x167D8FAB,
	0x3FDA3D70,0xA3D70A3D, 0x3FD8E6F8,0x12962E4E,
	0x3FDA8F5C,0x28F5C28F, 0x3FD92CFA,0x0AB9BC1D,
	0x3FDAE147,0xAE147AE1, 0x3FD972BC,0xACE3F311,
	0x3FDB3333,0x33333333, 0x3FD9B83F,0xA9FEA9AF,
	0x3FDB851E,0xB851EB85, 0x3FD9FD82,0xB5DC5E5F,
	0x3FDBD70A,0x3D70A3D7, 0x3FDA4285,0x87328B23,
	0x3FDC28F5,0xC28F5C29, 0x3FDA8747,0xD793C3DC,
	0x3FDC7AE1,0x47AE147B, 0x3FDACBC9,0x6369A11D,
	0x3FDCCCCC,0xCCCCCCCD, 0x3FDB1009,0xE9EE79BC,
	0x3FDD1EB8,0x51EB851F, 0x3FDB5409,0x2D26ED16,
	0x3FDD70A3,0xD70A3D71, 0x3FDB97C6,0xF1DB4032,
	0x3FDDC28F,0x5C28F5C3, 0x3FDBDB42,0xFF908FB9,
	0x3FDE147A,0xE147AE14, 0x3FDC1E7D,0x2081D8E2,
	0x3FDE6666,0x66666666, 0x3FDC6175,0x2198DB3D,
	0x3FDEB851,0xEB851EB8, 0x3FDCA42A,0xD266D56F,
	0x3FDF0A3D,0x70A3D70A, 0x3FDCE69E,0x051D1ED4,
	0x3FDF5C28,0xF5C28F5C, 0x3FDD28CE,0x8E859FEF,
	0x3FDFAE14,0x7AE147AE, 0x3FDD6ABC,0x45FB2BAE,
	0x3FE00000,0x00000000, 0x3FDDAC67,0x0561BB4F,
	0x3FE028F5,0xC28F5C29, 0x3FDDEDCE,0xA91E8ED4,
	0x3FE051EB,0x851EB852, 0x3FDE2EF3,0x101033DF,
	0x3FE07AE1,0x47AE147B, 0x3FDE6FD4,0x1B8674C2,
	0x3FE0A3D7,0x0A3D70A4, 0x3FDEB071,0xAF3A3191,
	0x3FE0CCCC,0xCCCCCCCD, 0x3FDEF0CB,0xB14524F4,
	0x3FE0F5C2,0x8F5C28F6, 0x3FDF30E2,0x0A199675,
	0x3FE11EB8,0x51EB851F, 0x3FDF70B4,0xA479FBF9,
	0x3FE147AE,0x147AE148, 0x3FDFB043,0x6D708C0A,
	0x3FE170A3,0xD70A3D71, 0x3FDFEF8E,0x5446C29A,
	0x3FE19999,0x9999999A, 0x3FE0174A,0xA53E6CE4,
	0x3FE1C28F,0x5C28F5C3, 0x3FE036AC,0x21E09C1D,
	0x3FE1EB85,0x1EB851EC, 0x3FE055EB,0x9AF3EB4B,
	0x3FE2147A,0xE147AE14, 0x3FE07509,0x0C70CEC4,
	0x3FE23D70,0xA3D70A3D, 0x3FE09404,0x7359DEEB,
	0x3FE26666,0x66666666, 0x3FE0B2DD,0xCDB781E3,
	0x3FE28F5C,0x28F5C28F, 0x3FE0D195,0x1A9393B7,
	0x3FE2B851,0xEB851EB8, 0x3FE0F02A,0x59F50D7F,
	0x3FE2E147,0xAE147AE1, 0x3FE10E9D,0x8CDBAC48,
	0x3FE30A3D,0x70A3D70A, 0x3FE12CEE,0xB53B9841,
	0x3FE33333,0x33333333, 0x3FE14B1D,0xD5F90CE1,
	0x3FE35C28,0xF5C28F5C, 0x3FE1692A,0xF2E40288,
	0x3FE3851E,0xB851EB85, 0x3FE18716,0x10B3DA41,
	0x3FE3AE14,0x7AE147AE, 0x3FE1A4DF,0x35030C1F,
	0x3FE3D70A,0x3D70A3D7, 0x3FE1C286,0x664AD8C9,
	0x3FE40000,0x00000000, 0x3FE1E00B,0xABDEFEB4,
	0x3FE428F5,0xC28F5C29, 0x3FE1FD6F,0x0DE97388,
	0x3FE451EB,0x851EB852, 0x3FE21AB0,0x95662230,
	0x3FE47AE1,0x47AE147B, 0x3FE237D0,0x4C1EAE02,
	0x3FE4A3D7,0x0A3D70A4, 0x3FE254CE,0x3CA63B76,
	0x3FE4CCCC,0xCCCCCCCD, 0x3FE271AA,0x72553ED5,
	0x3FE4F5C2,0x8F5C28F6, 0x3FE28E64,0xF9455145,
	0x3FE51EB8,0x51EB851F, 0x3FE2AAFD,0xDE4D0C9F,
	0x3FE547AE,0x147AE148, 0x3FE2C775,0x2EFBEE61,
	0x3FE570A3,0xD70A3D71, 0x3FE2E3CA,0xF996421E,
	0x3FE59999,0x9999999A, 0x3FE2FFFF,0x4D1113C2,
	0x3FE5C28F,0x5C28F5C3, 0x3FE31C12,0x390E29FA,
	0x3FE5EB85,0x1EB851EC, 0x3FE33803,0xCDD8090A,
	0x3FE6147A,0xE147AE14, 0x3FE353D4,0x1C5DFE67,
	0x3FE63D70,0xA3D70A3D, 0x3FE36F83,0x36303552,
	0x3FE66666,0x66666666, 0x3FE38B11,0x2D7BD4AD,
	0x3FE68F5C,0x28F5C28F, 0x3FE3A67E,0x15072661,
	0x3FE6B851,0xEB851EB8, 0x3FE3C1CA,0x002DC877,
	0x3FE6E147,0xAE147AE1, 0x3FE3DCF5,0x02DCE82B,
	0x3FE70A3D,0x70A3D70A, 0x3FE3F7FF,0x318F8723,
	0x3FE73333,0x33333333, 0x3FE412E8,0xA14ACAFF,
	0x3FE75C28,0xF5C28F5C, 0x3FE42DB1,0x679A576F,
	0x3FE7851E,0xB851EB85, 0x3FE44859,0x9A8CB2EF,
	0x3FE7AE14,0x7AE147AE, 0x3FE462E1,0x50AFB65F,
	0x3FE7D70A,0x3D70A3D7, 0x3FE47D48,0xA10D0791,
	0x3FE80000,0x00000000, 0x3FE4978F,0xA3269EE1,
	0x3FE828F5,0xC28F5C29, 0x3FE4B1B6,0x6EF35814,
	0x3FE851EB,0x851EB852, 0x3FE4CBBD,0x1CDB8E70,
	0x3FE87AE1,0x47AE147B, 0x3FE4E5A3,0xC5B5C44A,
	0x3FE8A3D7,0x0A3D70A4, 0x3FE4FF6A,0x82C35600,
	0x3FE8CCCC,0xCCCCCCCD, 0x3FE51911,0x6DAD3886,
	0x3FE8F5C2,0x8F5C28F6, 0x3FE53298,0xA080C38D,
	0x3FE91EB8,0x51EB851F, 0x3FE54C00,0x35AC874B,
	0x3FE947AE,0x147AE148, 0x3FE56548,0x47FD2E00,
	0x3FE970A3,0xD70A3D71, 0x3FE57E70,0xF29A692E,
	0x3FE99999,0x9999999A, 0x3FE5977A,0x5103EA93,
	0x3FE9C28F,0x5C28F5C3, 0x3FE5B064,0x7F0E68E9,
	0x3FE9EB85,0x1EB851EC, 0x3FE5C92F,0x98E0B072,
	0x3FEA147A,0xE147AE14, 0x3FE5E1DB,0xBAF0BF3E,
	0x3FEA3D70,0xA3D70A3D, 0x3FE5FA69,0x0200ED45,
	0x3FEA6666,0x66666666, 0x3FE612D7,0x8B1D2038,
	0x3FEA8F5C,0x28F5C28F, 0x3FE62B27,0x73980B11,
	0x3FEAB851,0xEB851EB8, 0x3FE64358,0xD908795A,
	0x3FEAE147,0xAE147AE1, 0x3FE65B6B,0xD946A61B,
	0x3FEB0A3D,0x70A3D70A, 0x3FE67360,0x92699E72,
	0x3FEB3333,0x33333333, 0x3FE68B37,0x22C4AFB4,
	0x3FEB5C28,0xF5C28F5C, 0x3FE6A2EF,0xA8E4E126,
	0x3FEB851E,0xB851EB85, 0x3FE6BA8A,0x438E7926,
	0x3FEBAE14,0x7AE147AE, 0x3FE6D207,0x11BA8DBD,
	0x3FEBD70A,0x3D70A3D7, 0x3FE6E966,0x3294A097,
	0x3FEC0000,0x00000000, 0x3FE700A7,0xC5784634,
	0x3FEC28F5,0xC28F5C29, 0x3FE717CB,0xE9EED853,
	0x3FEC51EB,0x851EB852, 0x3FE72ED2,0xBFAD3382,
	0x3FEC7AE1,0x47AE147B, 0x3FE745BC,0x66917FB0,
	0x3FECA3D7,0x0A3D70A4, 0x3FE75C88,0xFEA103B5,
	0x3FECCCCC,0xCCCCCCCD, 0x3FE77338,0xA80603BE,
	0x3FECF5C2,0x8F5C28F6, 0x3FE789CB,0x830DAA79,
	0x3FED1EB8,0x51EB851F, 0x3FE7A041,0xB025FCE9,
	0x3FED47AE,0x147AE148, 0x3FE7B69B,0x4FDBD8D9,
	0x3FED70A3,0xD70A3D71, 0x3FE7CCD8,0x82D8FDBE,
	0x3FED9999,0x9999999A, 0x3FE7E2F9,0x69E21FFF,
	0x3FEDC28F,0x5C28F5C3, 0x3FE7F8FE,0x25D5067B,
	0x3FEDEB85,0x1EB851EC, 0x3FE80EE6,0xD7A6B236,
	0x3FEE147A,0xE147AE14, 0x3FE824B3,0xA0619019,
	0x3FEE3D70,0xA3D70A3D, 0x3FE83A64,0xA123B499,
	0x3FEE6666,0x66666666, 0x3FE84FF9,0xFB1D212E,
	0x3FEE8F5C,0x28F5C28F, 0x3FE86573,0xCF8E1386,
	0x3FEEB851,0xEB851EB8, 0x3FE87AD2,0x3FC55E47,
	0x3FEEE147,0xAE147AE1, 0x3FE89015,0x6D1ECB48,
	0x3FEF0A3D,0x70A3D70A, 0x3FE8A53D,0x7901872A,
	0x3FEF3333,0x33333333, 0x3FE8BA4A,0x84DE9622,
	0x3FEF5C28,0xF5C28F5C, 0x3FE8CF3C,0xB22F51E5,
	0x3FEF851E,0xB851EB85, 0x3FE8E414,0x2273F090,
	0x3FEFAE14,0x7AE147AE, 0x3FE8F8D0,0xF7321467,
	0x3FEFD70A,0x3D70A3D7, 0x3FE90D73,0x51F36458,
	0x3FF00000,0x00000000, 0x3FE921FB,0x54442D18,
	0x3FF0147A,0xE147AE14, 0x3FE93669,0x1FB20AC2,
	0x3FF028F5,0xC28F5C29, 0x3FE94ABC,0xD5CA9ACF,
	0x3FF03D70,0xA3D70A3D, 0x3FE95EF6,0x981A3654,
	0x3FF051EB,0x851EB852, 0x3FE97316,0x882AB45A,
	0x3FF06666,0x66666666, 0x3FE9871C,0xC7823436,
	0x3FF07AE1,0x47AE147B, 0x3FE99B09,0x77A1EFC7,
	0x3FF08F5C,0x28F5C28F, 0x3FE9AEDC,0xBA05156C,
	0x3FF0A3D7,0x0A3D70A4, 0x3FE9C296,0xB01FA9A5,
	0x3FF0B851,0xEB851EB8, 0x3FE9D637,0x7B5D702A,
	0x3FF0CCCC,0xCCCCCCCD, 0x3FE9E9BF,0x3D20DC71,
	0x3FF0E147,0xAE147AE1, 0x3FE9FD2E,0x16C2096D,
	0x3FF0F5C2,0x8F5C28F6, 0x3FEA1084,0x298DB87B,
	0x3FF10A3D,0x70A3D70A, 0x3FEA23C1,0x96C4574A,
	0x3FF11EB8,0x51EB851F, 0x3FEA36E6,0x7F990CB6,
	0x3FF13333,0x33333333, 0x3FEA49F3,0x0530CC61,
	0x3FF147AE,0x147AE148, 0x3FEA5CE7,0x48A170FE,
	0x3FF15C28,0xF5C28F5C, 0x3FEA6FC3,0x6AF0DD25,
	0x3FF170A3,0xD70A3D71, 0x3FEA8287,0x8D142297,
	0x3FF1851E,0xB851EB85, 0x3FEA9533,0xCFEEAFCE,
	0x3FF19999,0x9999999A, 0x3FEAA7C8,0x545183CD,
	0x3FF1AE14,0x7AE147AE, 0x3FEABA45,0x3AFA67F7,
	0x3FF1C28F,0x5C28F5C3, 0x3FEACCAA,0xA4932FEE,
	0x3FF1D70A,0x3D70A3D7, 0x3FEADEF8,0xB1B0FF43,
	0x3FF1EB85,0x1EB851EC, 0x3FEAF12F,0x82D394F6,
	0x3FF20000,0x00000000, 0x3FEB034F,0x38649C88,
	0x3FF2147A,0xE147AE14, 0x3FEB1557,0xF2B704A8,
	0x3FF228F5,0xC28F5C29, 0x3FEB2749,0xD2065B46,
	0x3FF23D70,0xA3D70A3D, 0x3FEB3924,0xF6762EF7,
	0x3FF251EB,0x851EB852, 0x3FEB4AE9,0x80117598,
	0x3FF26666,0x66666666, 0x3FEB5C97,0x8EC9F805,
	0x3FF27AE1,0x47AE147B, 0x3FEB6E2F,0x4277C2E2,
	0x3FF28F5C,0x28F5C28F, 0x3FEB7FB0,0xBAD89C3A,
	0x3FF2A3D7,0x0A3D70A4, 0x3FEB911C,0x178F7E06,
	0x3FF2B851,0xEB851EB8, 0x3FEBA271,0x78241551,
	0x3FF2CCCC,0xCCCCCCCD, 0x3FEBB3B0,0xFC024612,
	0x3FF2E147,0xAE147AE1, 0x3FEBC4DA,0xC279B378,
	0x3FF2F5C2,0x8F5C28F6, 0x3FEBD5EE,0xEABD4CB5,
	0x3FF30A3D,0x70A3D70A, 0x3FEBE6ED,0x93E2DE0A,
	0x3FF31EB8,0x51EB851F, 0x3FEBF7D6,0xDCE2A629,
	0x3FF33333,0x33333333, 0x3FEC08AA,0xE496EFA6,
	0x3FF347AE,0x147AE148, 0x3FEC1969,0xC9BBAE89,
	0x3FF35C28,0xF5C28F5C, 0x3FEC2A13,0xAAEE21CF,
	0x3FF370A3,0xD70A3D71, 0x3FEC3AA8,0xA6AC78D4,
	0x3FF3851E,0xB851EB85, 0x3FEC4B28,0xDB557C83,
	0x3FF39999,0x9999999A, 0x3FEC5B94,0x67283C49,
	0x3FF3AE14,0x7AE147AE, 0x3FEC6BEB,0x6843BE9A,
	0x3FF3C28F,0x5C28F5C3, 0x3FEC7C2D,0xFCA6B514,
	0x3FF3D70A,0x3D70A3D7, 0x3FEC8C5C,0x422F340D,
	0x3FF3EB85,0x1EB851EC, 0x3FEC9C76,0x569A6D90,
	0x3FF40000,0x00000000, 0x3FECAC7C,0x57846F9E,
	0x3FF4147A,0xE147AE14, 0x3FECBC6E,0x6267E5BD,
	0x3FF428F5,0xC28F5C29, 0x3FECCC4C,0x949DDD9E,
	0x3FF43D70,0xA3D70A3D, 0x3FECDC17,0x0B5D8EE8,
	0x3FF451EB,0x851EB852, 0x3FECEBCD,0xE3BC25FE,
	0x3FF46666,0x66666666, 0x3FECFB71,0x3AAC91BD,
	0x3FF47AE1,0x47AE147B, 0x3FED0B01,0x2CFF5412,
	0x3FF48F5C,0x28F5C28F, 0x3FED1A7D,0xD7625566,
	0x3FF4A3D7,0x0A3D70A4, 0x3FED29E7,0x5660BAC1,
	0x3FF4B851,0xEB851EB8, 0x3FED393D,0xC662BE9A,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FED4881,0x43AD8C44,
	0x3FF4E147,0xAE147AE1, 0x3FED57B1,0xEA631DDB,
	0x3FF4F5C2,0x8F5C28F6, 0x3FED66CF,0xD6821CBE,
	0x3FF50A3D,0x70A3D70A, 0x3FED75DB,0x23E5C45D,
	0x3FF51EB8,0x51EB851F, 0x3FED84D3,0xEE45C771,
	0x3FF53333,0x33333333, 0x3FED93BA,0x5136377A,
	0x3FF547AE,0x147AE148, 0x3FEDA28E,0x68276E77,
	0x3FF55C28,0xF5C28F5C, 0x3FEDB150,0x4E65FACD,
	0x3FF570A3,0xD70A3D71, 0x3FEDC000,0x1F1A8D4F,
	0x3FF5851E,0xB851EB85, 0x3FEDCE9D,0xF549E952,
	0x3FF59999,0x9999999A, 0x3FEDDD29,0xEBD4D6C8,
	0x3FF5AE14,0x7AE147AE, 0x3FEDEBA4,0x1D78164E,
	0x3FF5C28F,0x5C28F5C3, 0x3FEDFA0C,0xA4CC5721,
	0x3FF5D70A,0x3D70A3D7, 0x3FEE0863,0x9C462EED,
	0x3FF5EB85,0x1EB851EC, 0x3FEE16A9,0x1E36136F,
	0x3FF60000,0x00000000, 0x3FEE24DD,0x44C855D1,
	0x3FF6147A,0xE147AE14, 0x3FEE3300,0x2A051FBE,
	0x3FF628F5,0xC28F5C29, 0x3FEE4111,0xE7D0721F,
	0x3FF63D70,0xA3D70A3D, 0x3FEE4F12,0x97EA2570,
	0x3FF651EB,0x851EB852, 0x3FEE5D02,0x53EDEBB1,
	0x3FF66666,0x66666666, 0x3FEE6AE1,0x355353CF,
	0x3FF67AE1,0x47AE147B, 0x3FEE78AF,0x556DCE94,
	0x3FF68F5C,0x28F5C28F, 0x3FEE866C,0xCD6CB4F8,
	0x3FF6A3D7,0x0A3D70A4, 0x3FEE9419,0xB65B4FE9,
	0x3FF6B851,0xEB851EB8, 0x3FEEA1B6,0x2920E15D,
	0x3FF6CCCC,0xCCCCCCCD, 0x3FEEAF42,0x3E80AEC0,
	0x3FF6E147,0xAE147AE1, 0x3FEEBCBE,0x0F1A0C9F,
	0x3FF6F5C2,0x8F5C28F6, 0x3FEECA29,0xB3686B95,
	0x3FF70A3D,0x70A3D70A, 0x3FEED785,0x43C3666B,
	0x3FF71EB8,0x51EB851F, 0x3FEEE4D0,0xD85ED15D,
	0x3FF73333,0x33333333, 0x3FEEF20C,0x894ACA81,
	0x3FF747AE,0x147AE148, 0x3FEEFF38,0x6E73CB49,
	0x3FF75C28,0xF5C28F5C, 0x3FEF0C54,0x9FA2BB0B,
	0x3FF770A3,0xD70A3D71, 0x3FEF1961,0x347D0299,
	0x3FF7851E,0xB851EB85, 0x3FEF265E,0x4484A0CC,
	0x3FF79999,0x9999999A, 0x3FEF334B,0xE718400A,
	0x3FF7AE14,0x7AE147AE, 0x3FEF402A,0x33734CB8,
	0x3FF7C28F,0x5C28F5C3, 0x3FEF4CF9,0x40AE0C93,
	0x3FF7D70A,0x3D70A3D7, 0x3FEF59B9,0x25BDB6DF,
	0x3FF7EB85,0x1EB851EC, 0x3FEF6669,0xF9748D76,
	0x3FF80000,0x00000000, 0x3FEF730B,0xD281F69B,
	0x3FF8147A,0xE147AE14, 0x3FEF7F9E,0xC77297A0,
	0x3FF828F5,0xC28F5C29, 0x3FEF8C22,0xEEB07043,
	0x3FF83D70,0xA3D70A3D, 0x3FEF9898,0x5E82F6C3,
	0x3FF851EB,0x851EB852, 0x3FEFA4FF,0x2D0F34B7,
	0x3FF86666,0x66666666, 0x3FEFB157,0x7057E47A,
	0x3FF87AE1,0x47AE147B, 0x3FEFBDA1,0x3E3D8F55,
	0x3FF88F5C,0x28F5C28F, 0x3FEFC9DC,0xAC7EAC33,
	0x3FF8A3D7,0x0A3D70A4, 0x3FEFD609,0xD0B7BEFF,
	0x3FF8B851,0xEB851EB8, 0x3FEFE228,0xC063788D,
	0x3FF8CCCC,0xCCCCCCCD, 0x3FEFEE39,0x90DAD712,
	0x3FF8E147,0xAE147AE1, 0x3FEFFA3C,0x57554724,
	0x3FF8F5C2,0x8F5C28F6, 0x3FF00318,0x947462A0,
	0x3FF90A3D,0x70A3D70A, 0x3FF0090C,0x0D44FFE6,
	0x3FF91EB8,0x51EB851F, 0x3FF00EF8,0xA0863CC4,
	0x3FF93333,0x33333333, 0x3FF014DE,0x58915640,
	0x3FF947AE,0x147AE148, 0x3FF01ABD,0x3FAF16B2,
	0x3FF95C28,0xF5C28F5C, 0x3FF02095,0x6017E7A5,
	0x3FF970A3,0xD70A3D71, 0x3FF02666,0xC3F3E3E9,
	0x3FF9851E,0xB851EB85, 0x3FF02C31,0x755AE9D6,
	0x3FF99999,0x9999999A, 0x3FF031F5,0x7E54ADBE,
	0x3FF9AE14,0x7AE147AE, 0x3FF037B2,0xE8D8CC86,
	0x3FF9C28F,0x5C28F5C3, 0x3FF03D69,0xBECEDE6D,
	0x3FF9D70A,0x3D70A3D7, 0x3FF0431A,0x0A0E89F5,
	0x3FF9EB85,0x1EB851EC, 0x3FF048C3,0xD45F96F8,
	0x3FFA0000,0x00000000, 0x3FF04E67,0x277A01D7,
	0x3FFA147A,0xE147AE14, 0x3FF05404,0x0D060ED1,
	0x3FFA28F5,0xC28F5C29, 0x3FF0599A,0x8E9C5D78,
	0x3FFA3D70,0xA3D70A3D, 0x3FF05F2A,0xB5C5FC40,
	0x3FFA51EB,0x851EB852, 0x3FF064B4,0x8BFC7C2C,
	0x3FFA6666,0x66666666, 0x3FF06A38,0x1AAA0497,
	0x3FFA7AE1,0x47AE147B, 0x3FF06FB5,0x6B296710,
	0x3FFA8F5C,0x28F5C28F, 0x3FF0752C,0x86C63350,
	0x3FFAA3D7,0x0A3D70A4, 0x3FF07A9D,0x76BCCB47,
	0x3FFAB851,0xEB851EB8, 0x3FF08008,0x443A7731,
	0x3FFACCCC,0xCCCCCCCD, 0x3FF0856C,0xF85D79D0,
	0x3FFAE147,0xAE147AE1, 0x3FF08ACB,0x9C3524A3,
	0x3FFAF5C2,0x8F5C28F6, 0x3FF09024,0x38C1EC36,
	0x3FFB0A3D,0x70A3D70A, 0x3FF09576,0xD6F57C81,
	0x3FFB1EB8,0x51EB851F, 0x3FF09AC3,0x7FB2CD4B,
	0x3FFB3333,0x33333333, 0x3FF0A00A,0x3BCE369F,
	0x3FFB47AE,0x147AE148, 0x3FF0A54B,0x140D8548,
	0x3FFB5C28,0xF5C28F5C, 0x3FF0AA86,0x11280F54,
	0x3FFB70A3,0xD70A3D71, 0x3FF0AFBB,0x3BC6C89F,
	0x3FFB851E,0xB851EB85, 0x3FF0B4EA,0x9C845764,
	0x3FFB9999,0x9999999A, 0x3FF0BA14,0x3BED28D4,
	0x3FFBAE14,0x7AE147AE, 0x3FF0BF38,0x227F85AD,
	0x3FFBC28F,0x5C28F5C3, 0x3FF0C456,0x58ABA6D7,
	0x3FFBD70A,0x3D70A3D7, 0x3FF0C96E,0xE6D3CA01,
	0x3FFBEB85,0x1EB851EC, 0x3FF0CE81,0xD54C463D,
	0x3FFC0000,0x00000000, 0x3FF0D38F,0x2C5BA09F,
	0x3FFC147A,0xE147AE14, 0x3FF0D896,0xF43AA0D5,
	0x3FFC28F5,0xC28F5C29, 0x3FF0DD99,0x351465C6,
	0x3FFC3D70,0xA3D70A3D, 0x3FF0E295,0xF7067A20,
	0x3FFC51EB,0x851EB852, 0x3FF0E78D,0x4220E8EF,
	0x3FFC6666,0x66666666, 0x3FF0EC7F,0x1E665227,
	0x3FFC7AE1,0x47AE147B, 0x3FF0F16B,0x93CBFF2A,
	0x3FFC8F5C,0x28F5C28F, 0x3FF0F652,0xAA39F748,
	0x3FFCA3D7,0x0A3D70A4, 0x3FF0FB34,0x698B1438,
	0x3FFCB851,0xEB851EB8, 0x3FF10010,0xD98D1687,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FF104E8,0x0200BA00,
	0x3FFCE147,0xAE147AE1, 0x3FF109B9,0xEA99CA07,
	0x3FFCF5C2,0x8F5C28F6, 0x3FF10E86,0x9AFF35F2,
	0x3FFD0A3D,0x70A3D70A, 0x3FF1134E,0x1ACB2548,
	0x3FFD1EB8,0x51EB851F, 0x3FF11810,0x718B0C06,
	0x3FFD3333,0x33333333, 0x3FF11CCD,0xA6BFBECC,
	0x3FFD47AE,0x147AE148, 0x3FF12185,0xC1DD8701,
	0x3FFD5C28,0xF5C28F5C, 0x3FF12638,0xCA4C36E7,
	0x3FFD70A3,0xD70A3D71, 0x3FF12AE6,0xC7673DAB,
	0x3FFD851E,0xB851EB85, 0x3FF12F8F,0xC07DBB53,
	0x3FFD9999,0x9999999A, 0x3FF13433,0xBCD294B5,
	0x3FFDAE14,0x7AE147AE, 0x3FF138D2,0xC39C874C,
	0x3FFDC28F,0x5C28F5C3, 0x3FF13D6C,0xDC063D05,
	0x3FFDD70A,0x3D70A3D7, 0x3FF14202,0x0D2E5FFB,
	0x3FFDEB85,0x1EB851EC, 0x3FF14692,0x5E27AE23,
	0x3FFE0000,0x00000000, 0x3FF14B1D,0xD5F90CE1,
	0x3FFE147A,0xE147AE14, 0x3FF14FA4,0x7B9D9C95,
	0x3FFE28F5,0xC28F5C29, 0x3FF15426,0x5604CC0F,
	0x3FFE3D70,0xA3D70A3D, 0x3FF158A3,0x6C126BF2,
	0x3FFE51EB,0x851EB852, 0x3FF15D1B,0xC49EC202,
	0x3FFE6666,0x66666666, 0x3FF1618F,0x66769C69,
	0x3FFE7AE1,0x47AE147B, 0x3FF165FE,0x585B64DA,
	0x3FFE8F5C,0x28F5C28F, 0x3FF16A68,0xA10333A9,
	0x3FFEA3D7,0x0A3D70A4, 0x3FF16ECE,0x4718E2D3,
	0x3FFEB851,0xEB851EB8, 0x3FF1732F,0x513C20E4,
	0x3FFECCCC,0xCCCCCCCD, 0x3FF1778B,0xC60183D4,
	0x3FFEE147,0xAE147AE1, 0x3FF17BE3,0xABF29BCE,
	0x3FFEF5C2,0x8F5C28F6, 0x3FF18037,0x098E05DD,
	0x3FFF0A3D,0x70A3D70A, 0x3FF18485,0xE5477E85,
	0x3FFF1EB8,0x51EB851F, 0x3FF188D0,0x4587F449,
	0x3FFF3333,0x33333333, 0x3FF18D16,0x30AD9A1A,
	0x3FFF47AE,0x147AE148, 0x3FF19157,0xAD0BF9B0,
	0x3FFF5C28,0xF5C28F5C, 0x3FF19594,0xC0EC05CA,
	0x3FFF70A3,0xD70A3D71, 0x3FF199CD,0x728C2C5E,
	0x3FFF851E,0xB851EB85, 0x3FF19E01,0xC82068A8,
	0x3FFF9999,0x9999999A, 0x3FF1A231,0xC7D25530,
	0x3FFFAE14,0x7AE147AE, 0x3FF1A65D,0x77C13DAE,
	0x3FFFC28F,0x5C28F5C3, 0x3FF1AA84,0xDE0230DA,
	0x3FFFD70A,0x3D70A3D7, 0x3FF1AEA8,0x00A01226,
	0x3FFFEB85,0x1EB851EC, 0x3FF1B2C6,0xE59BAB62,
	0x40000000,0x00000000, 0x3FF1B6E1,0x92EBBE44,
	0x40000A3D,0x70A3D70A, 0x3FF1BAF8,0x0E7D15DE,
	0x4000147A,0xE147AE14, 0x3FF1BF0A,0x5E3297F5,
	0x40001EB8,0x51EB851F, 0x3FF1C318,0x87E5564B,
	0x400028F5,0xC28F5C29, 0x3FF1C722,0x91649FC2,
	0x40003333,0x33333333, 0x3FF1CB28,0x8076117A,
	0x40003D70,0xA3D70A3D, 0x3FF1CF2A,0x5AD5A7C5,
	0x400047AE,0x147AE148, 0x3FF1D328,0x2635CF0D,
	0x400051EB,0x851EB852, 0x3FF1D721,0xE83F74A2,
	0x40005C28,0xF5C28F5C, 0x3FF1DB17,0xA6921768,
	0x40006666,0x66666666, 0x3FF1DF09,0x66C3D878,
	0x400070A3,0xD70A3D71, 0x3FF1E2F7,0x2E618BA0,
	0x40007AE1,0x47AE147B, 0x3FF1E6E1,0x02EEC7CB,
	0x4000851E,0xB851EB85, 0x3FF1EAC6,0xE9E5F756,
	0x40008F5C,0x28F5C28F, 0x3FF1EEA8,0xE8B8684D,
	0x40009999,0x9999999A, 0x3FF1F287,0x04CE5C82,
	0x4000A3D7,0x0A3D70A4, 0x3FF1F661,0x438719A2,
	0x4000AE14,0x7AE147AE, 0x3FF1FA37,0xAA38F91A,
	0x4000B851,0xEB851EB8, 0x3FF1FE0A,0x3E3177FA,
	0x4000C28F,0x5C28F5C3, 0x3FF201D9,0x04B546AA,
	0x4000CCCC,0xCCCCCCCD, 0x3FF205A4,0x03005899,
	0x4000D70A,0x3D70A3D7, 0x3FF2096B,0x3E45F3C7,
	0x4000E147,0xAE147AE1, 0x3FF20D2E,0xBBB0C03D,
	0x4000EB85,0x1EB851EC, 0x3FF210EE,0x8062D76B,
	0x4000F5C2,0x8F5C28F6, 0x3FF214AA,0x9175D36D,
	0x40010000,0x00000000, 0x3FF21862,0xF3FADE36,
	0x40010A3D,0x70A3D70A, 0x3FF21C17,0xACFAC0AB,
	0x4001147A,0xE147AE14, 0x3FF21FC8,0xC175F197,
	0x40011EB8,0x51EB851F, 0x3FF22376,0x3664A496,
	0x400128F5,0xC28F5C29, 0x3FF22720,0x10B6D8DF,
	0x40013333,0x33333333, 0x3FF22AC6,0x555467F6,
	0x40013D70,0xA3D70A3D, 0x3FF22E69,0x091D144B,
	0x400147AE,0x147AE148, 0x3FF23208,0x30E897BB,
	0x400151EB,0x851EB852, 0x3FF235A3,0xD186B1FE,
	0x40015C28,0xF5C28F5C, 0x3FF2393B,0xEFBF36F9,
	0x40016666,0x66666666, 0x3FF23CD0,0x90521CFC,
	0x400170A3,0xD70A3D71, 0x3FF24061,0xB7F78AE4,
	0x40017AE1,0x47AE147B, 0x3FF243EF,0x6B5FE628,
	0x4001851E,0xB851EB85, 0x3FF24779,0xAF33E0D0,
	0x40018F5C,0x28F5C28F, 0x3FF24B00,0x8814874E,
	0x40019999,0x9999999A, 0x3FF24E83,0xFA9B4E48,
	0x4001A3D7,0x0A3D70A4, 0x3FF25204,0x0B5A2042,
	0x4001AE14,0x7AE147AE, 0x3FF25580,0xBEDB6B38,
	0x4001B851,0xEB851EB8, 0x3FF258FA,0x19A22E1C,
	0x4001C28F,0x5C28F5C3, 0x3FF25C70,0x202A063E,
	0x4001CCCC,0xCCCCCCCD, 0x3FF25FE2,0xD6E73C9E,
	0x4001D70A,0x3D70A3D7, 0x3FF26352,0x4246D324,
	0x4001E147,0xAE147AE1, 0x3FF266BE,0x66AE91C9,
	0x4001EB85,0x1EB851EC, 0x3FF26A27,0x487D139A,
	0x4001F5C2,0x8F5C28F6, 0x3FF26D8C,0xEC09D3B5,
	0x40020000,0x00000000, 0x3FF270EF,0x55A53A25,
	0x40020A3D,0x70A3D70A, 0x3FF2744E,0x8998A8AA,
	0x4002147A,0xE147AE14, 0x3FF277AA,0x8C26876B,
	0x40021EB8,0x51EB851F, 0x3FF27B03,0x618A5193,
	0x400228F5,0xC28F5C29, 0x3FF27E59,0x0DF8A1D2,
	0x40023333,0x33333333, 0x3FF281AB,0x959F3ED0,
	0x40023D70,0xA3D70A3D, 0x3FF284FA,0xFCA52783,
	0x400247AE,0x147AE148, 0x3FF28847,0x472A9F73,
	0x400251EB,0x851EB852, 0x3FF28B90,0x79493AE7,
	0x40025C28,0xF5C28F5C, 0x3FF28ED6,0x9713EAFA,
	0x40026666,0x66666666, 0x3FF29219,0xA49709A1,
	0x400270A3,0xD70A3D71, 0x3FF29559,0xA5D86590,
	0x40027AE1,0x47AE147B, 0x3FF29896,0x9ED74E17,
	0x4002851E,0xB851EB85, 0x3FF29BD0,0x938C9EDE,
	0x40028F5C,0x28F5C28F, 0x3FF29F07,0x87EACB94,
	0x40029999,0x9999999A, 0x3FF2A23B,0x7FDDEB84,
	0x4002A3D7,0x0A3D70A4, 0x3FF2A56C,0x7F4BC517,
	0x4002AE14,0x7AE147AE, 0x3FF2A89A,0x8A13D940,
	0x4002B851,0xEB851EB8, 0x3FF2ABC5,0xA40F6ED6,
	0x4002C28F,0x5C28F5C3, 0x3FF2AEED,0xD1119DD3,
	0x4002CCCC,0xCCCCCCCD, 0x3FF2B213,0x14E75A87,
	0x4002D70A,0x3D70A3D7, 0x3FF2B535,0x735780AF,
	0x4002E147,0xAE147AE1, 0x3FF2B854,0xF022DE7D,
	0x4002EB85,0x1EB851EC, 0x3FF2BB71,0x8F043F87,
	0x4002F5C2,0x8F5C28F6, 0x3FF2BE8B,0x53B077A8,
	0x40030000,0x00000000, 0x3FF2C1A2,0x41D66DC3,
	0x40030A3D,0x70A3D70A, 0x3FF2C4B6,0x5D1F2682,
	0x4003147A,0xE147AE14, 0x3FF2C7C7,0xA92DCEEE,
	0x40031EB8,0x51EB851F, 0x3FF2CAD6,0x299FC702,
	0x400328F5,0xC28F5C29, 0x3FF2CDE1,0xE20CAC27,
	0x40033333,0x33333333, 0x3FF2D0EA,0xD6066395,
	0x40033D70,0xA3D70A3D, 0x3FF2D3F1,0x091924AF,
	0x400347AE,0x147AE148, 0x3FF2D6F4,0x7ECB833A,
	0x400351EB,0x851EB852, 0x3FF2D9F5,0x3A9E7994,
	0x40035C28,0xF5C28F5C, 0x3FF2DCF3,0x400D72C6,
	0x40036666,0x66666666, 0x3FF2DFEE,0x928E5492,
	0x400370A3,0xD70A3D71, 0x3FF2E2E7,0x35918965,
	0x40037AE1,0x47AE147B, 0x3FF2E5DD,0x2C820A37,
	0x4003851E,0xB851EB85, 0x3FF2E8D0,0x7AC56862,
	0x40038F5C,0x28F5C28F, 0x3FF2EBC1,0x23BBD756,
	0x40039999,0x9999999A, 0x3FF2EEAF,0x2AC0364C,
	0x4003A3D7,0x0A3D70A4, 0x3FF2F19A,0x932819DA,
	0x4003AE14,0x7AE147AE, 0x3FF2F483,0x6043D57D,
	0x4003B851,0xEB851EB8, 0x3FF2F769,0x955E850A,
	0x4003C28F,0x5C28F5C3, 0x3FF2FA4D,0x35BE1618,
	0x4003CCCC,0xCCCCCCCD, 0x3FF2FD2E,0x44A35149,
	0x4003D70A,0x3D70A3D7, 0x3FF3000C,0xC549E391,
	0x4003E147,0xAE147AE1, 0x3FF302E8,0xBAE86760,
	0x4003EB85,0x1EB851EC, 0x3FF305C2,0x28B06DC2,
	0x4003F5C2,0x8F5C28F6, 0x3FF30899,0x11CE8769,
	0x40040000,0x00000000, 0x3FF30B6D,0x796A4DA8,
	0x40040A3D,0x70A3D70A, 0x3FF30E3F,0x62A66B5F,
	0x4004147A,0xE147AE14, 0x3FF3110E,0xD0A0A5D0,
	0x40041EB8,0x51EB851F, 0x3FF313DB,0xC671E56A,
	0x400428F5,0xC28F5C29, 0x3FF316A6,0x472E3E7F,
	0x40043333,0x33333333, 0x3FF3196E,0x55E4F9ED,
	0x40043D70,0xA3D70A3D, 0x3FF31C33,0xF5A09DB2,
	0x400447AE,0x147AE148, 0x3FF31EF7,0x2966F573,
	0x400451EB,0x851EB852, 0x3FF321B7,0xF4391AF3,
	0x40045C28,0xF5C28F5C, 0x3FF32476,0x59137E77,
	0x40046666,0x66666666, 0x3FF32732,0x5AEDEF1D,
	0x400470A3,0xD70A3D71, 0x3FF329EB,0xFCBBA323,
	0x40047AE1,0x47AE147B, 0x3FF32CA3,0x416B401A,
	0x4004851E,0xB851EB85, 0x3FF32F58,0x2BE6E311,
	0x40048F5C,0x28F5C28F, 0x3FF3320A,0xBF1428A7,
	0x40049999,0x9999999A, 0x3FF334BA,0xFDD43518,
	0x4004A3D7,0x0A3D70A4, 0x3FF33768,0xEB03BC31,
	0x4004AE14,0x7AE147AE, 0x3FF33A14,0x897B0939,
	0x4004B851,0xEB851EB8, 0x3FF33CBD,0xDC0E06D0,
	0x4004C28F,0x5C28F5C3, 0x3FF33F64,0xE58C46B4,
	0x4004CCCC,0xCCCCCCCD, 0x3FF34209,0xA8C10980,
	0x4004D70A,0x3D70A3D7, 0x3FF344AC,0x28734659,
	0x4004E147,0xAE147AE1, 0x3FF3474C,0x6765B28B,
	0x4004EB85,0x1EB851EC, 0x3FF349EA,0x6856C91E,
	0x4004F5C2,0x8F5C28F6, 0x3FF34C86,0x2E00D24E,
	0x40050000,0x00000000, 0x3FF34F1F,0xBB19EB09,
	0x40050A3D,0x70A3D70A, 0x3FF351B7,0x12540C4D,
	0x4005147A,0xE147AE14, 0x3FF3544C,0x365D127F,
	0x40051EB8,0x51EB851F, 0x3FF356DF,0x29DEC4B8,
	0x400528F5,0xC28F5C29, 0x3FF3596F,0xEF7EDBFB,
	0x40053333,0x33333333, 0x3FF35BFE,0x89DF0A64,
	0x40053D70,0xA3D70A3D, 0x3FF35E8A,0xFB9D0248,
	0x400547AE,0x147AE148, 0x3FF36115,0x47527D45,
	0x400551EB,0x851EB852, 0x3FF3639D,0x6F954344,
	0x40055C28,0xF5C28F5C, 0x3FF36623,0x76F73175,
	0x40056666,0x66666666, 0x3FF368A7,0x60064132,
	0x400570A3,0xD70A3D71, 0x3FF36B29,0x2D4C8EE0,
	0x40057AE1,0x47AE147B, 0x3FF36DA8,0xE15060B9,
	0x4005851E,0xB851EB85, 0x3FF37026,0x7E942D93,
	0x40058F5C,0x28F5C28F, 0x3FF372A2,0x0796A38D,
	0x40059999,0x9999999A, 0x3FF3751B,0x7ED2AEC1,
	0x4005A3D7,0x0A3D70A4, 0x3FF37792,0xE6BF7FD4,
	0x4005AE14,0x7AE147AE, 0x3FF37A08,0x41D0928E,
	0x4005B851,0xEB851EB8, 0x3FF37C7B,0x9275B456,
	0x4005C28F,0x5C28F5C3, 0x3FF37EEC,0xDB1B0AA9,
	0x4005CCCC,0xCCCCCCCD, 0x3FF3815C,0x1E291982,
	0x4005D70A,0x3D70A3D7, 0x3FF383C9,0x5E04C9B9,
	0x4005E147,0xAE147AE1, 0x3FF38634,0x9D0F6F50,
	0x4005EB85,0x1EB851EC, 0x3FF3889D,0xDDA6CFBC,
	0x4005F5C2,0x8F5C28F6, 0x3FF38B05,0x22252817,
	0x40060000,0x00000000, 0x3FF38D6A,0x6CE13353,
	0x40060A3D,0x70A3D70A, 0x3FF38FCD,0xC02E3054,
	0x4006147A,0xE147AE14, 0x3FF3922F,0x1E5BE80C,
	0x40061EB8,0x51EB851F, 0x3FF3948E,0x89B6B37D,
	0x400628F5,0xC28F5C29, 0x3FF396EC,0x048781BA,
	0x40063333,0x33333333, 0x3FF39947,0x9113DDDA,
	0x40063D70,0xA3D70A3D, 0x3FF39BA1,0x319DF4DD,
	0x400647AE,0x147AE148, 0x3FF39DF8,0xE8649B87,
	0x400651EB,0x851EB852, 0x3FF3A04E,0xB7A35432,
	0x40065C28,0xF5C28F5C, 0x3FF3A2A2,0xA1925490,
	0x40066666,0x66666666, 0x3FF3A4F4,0xA8668B69,
	0x400670A3,0xD70A3D71, 0x3FF3A744,0xCE51A646,
	0x40067AE1,0x47AE147B, 0x3FF3A993,0x15821717,
	0x4006851E,0xB851EB85, 0x3FF3ABDF,0x802319CC,
	0x40068F5C,0x28F5C28F, 0x3FF3AE2A,0x105CB9E3,
	0x40069999,0x9999999A, 0x3FF3B072,0xC853D7EF,
	0x4006A3D7,0x0A3D70A4, 0x3FF3B2B9,0xAA2A2F0B,
	0x4006AE14,0x7AE147AE, 0x3FF3B4FE,0xB7FE5A50,
	0x4006B851,0xEB851EB8, 0x3FF3B741,0xF3EBDA34,
	0x4006C28F,0x5C28F5C3, 0x3FF3B983,0x600B19E7,
	0x4006CCCC,0xCCCCCCCD, 0x3FF3BBC2,0xFE7174A3,
	0x4006D70A,0x3D70A3D7, 0x3FF3BE00,0xD1313AF0,
	0x4006E147,0xAE147AE1, 0x3FF3C03C,0xDA59B7E2,
	0x4006EB85,0x1EB851EC, 0x3FF3C277,0x1BF73649,
	0x4006F5C2,0x8F5C28F6, 0x3FF3C4AF,0x981305D8,
	0x40070000,0x00000000, 0x3FF3C6E6,0x50B38047,
	0x40070A3D,0x70A3D70A, 0x3FF3C91B,0x47DC0E63,
	0x4007147A,0xE147AE14, 0x3FF3CB4E,0x7F8D2D1A,
	0x40071EB8,0x51EB851F, 0x3FF3CD7F,0xF9C4727D,
	0x400728F5,0xC28F5C29, 0x3FF3CFAF,0xB87C92B4,
	0x40073333,0x33333333, 0x3FF3D1DD,0xBDAD64F0,
	0x40073D70,0xA3D70A3D, 0x3FF3D40A,0x0B4BE84E,
	0x400747AE,0x147AE148, 0x3FF3D634,0xA34A48B1,
	0x400751EB,0x851EB852, 0x3FF3D85D,0x8797E394,
	0x40075C28,0xF5C28F5C, 0x3FF3DA84,0xBA214CD5,
	0x40076666,0x66666666, 0x3FF3DCAA,0x3CD05374,
	0x400770A3,0xD70A3D71, 0x3FF3DECE,0x118C0645,
	0x40077AE1,0x47AE147B, 0x3FF3E0F0,0x3A38B8A5,
	0x4007851E,0xB851EB85, 0x3FF3E310,0xB8B8071A,
	0x40078F5C,0x28F5C28F, 0x3FF3E52F,0x8EE8DBF0,
	0x40079999,0x9999999A, 0x3FF3E74C,0xBEA773CD,
	0x4007A3D7,0x0A3D70A4, 0x3FF3E968,0x49CD6239,
	0x4007AE14,0x7AE147AE, 0x3FF3EB82,0x32319624,
	0x4007B851,0xEB851EB8, 0x3FF3ED9A,0x79A85E5C,
	0x4007C28F,0x5C28F5C3, 0x3FF3EFB1,0x22036DFF,
	0x4007CCCC,0xCCCCCCCD, 0x3FF3F1C6,0x2D11E0E2,
	0x4007D70A,0x3D70A3D7, 0x3FF3F3D9,0x9CA03FF5,
	0x4007E147,0xAE147AE1, 0x3FF3F5EB,0x72788596,
	0x4007EB85,0x1EB851EC, 0x3FF3F7FB,0xB06221E3,
	0x4007F5C2,0x8F5C28F6, 0x3FF3FA0A,0x5821FF02,
	0x40080000,0x00000000, 0x3FF3FC17,0x6B7A8560,
	0x40080A3D,0x70A3D70A, 0x3FF3FE22,0xEC2B9FE6,
	0x4008147A,0xE147AE14, 0x3FF4002C,0xDBF2C02B,
	0x40081EB8,0x51EB851F, 0x3FF40235,0x3C8AE29A,
	0x400828F5,0xC28F5C29, 0x3FF4043C,0x0FAC9294,
	0x40083333,0x33333333, 0x3FF40641,0x570DEE83,
	0x40083D70,0xA3D70A3D, 0x3FF40845,0x1462ABEF,
	0x400847AE,0x147AE148, 0x3FF40A47,0x495C1B85,
	0x400851EB,0x851EB852, 0x3FF40C47,0xF7A92D14,
	0x40085C28,0xF5C28F5C, 0x3FF40E47,0x20F6738D,
	0x40086666,0x66666666, 0x3FF41044,0xC6EE28EF,
	0x400870A3,0xD70A3D71, 0x3FF41240,0xEB383236,
	0x40087AE1,0x47AE147B, 0x3FF4143B,0x8F7A2339,
	0x4008851E,0xB851EB85, 0x3FF41634,0xB5574289,
	0x40088F5C,0x28F5C28F, 0x3FF4182C,0x5E708D48,
	0x40089999,0x9999999A, 0x3FF41A22,0x8C64BAEF,
	0x4008A3D7,0x0A3D70A4, 0x3FF41C17,0x40D0411B,
	0x4008AE14,0x7AE147AE, 0x3FF41E0A,0x7D4D5747,
	0x4008B851,0xEB851EB8, 0x3FF41FFC,0x4373FA89,
	0x4008C28F,0x5C28F5C3, 0x3FF421EC,0x94D9F140,
	0x4008CCCC,0xCCCCCCCD, 0x3FF423DB,0x7312CEBC,
	0x4008D70A,0x3D70A3D7, 0x3FF425C8,0xDFAFF6E8,
	0x4008E147,0xAE147AE1, 0x3FF427B4,0xDC40A1DF,
	0x4008EB85,0x1EB851EC, 0x3FF4299F,0x6A51DF87,
	0x4008F5C2,0x8F5C28F6, 0x3FF42B88,0x8B6E9B1D,
	0x40090000,0x00000000, 0x3FF42D70,0x411F9EC1,
	0x40090A3D,0x70A3D70A, 0x3FF42F56,0x8CEB96F3,
	0x4009147A,0xE147AE14, 0x3FF4313B,0x70571611,
	0x40091EB8,0x51EB851F, 0x3FF4331E,0xECE497CD,
	0x400928F5,0xC28F5C29, 0x3FF43501,0x04148498,
	0x40093333,0x33333333, 0x3FF436E1,0xB765350D,
	0x40093D70,0xA3D70A3D, 0x3FF438C1,0x0852F552,
	0x400947AE,0x147AE148, 0x3FF43A9E,0xF8580870,
	0x400951EB,0x851EB852, 0x3FF43C7B,0x88ECABAD,
	0x40095C28,0xF5C28F5C, 0x3FF43E56,0xBB8719D9,
	0x40096666,0x66666666, 0x3FF44030,0x919B8E94,
	0x400970A3,0xD70A3D71, 0x3FF44209,0x0C9C4997,
	0x40097AE1,0x47AE147B, 0x3FF443E0,0x2DF991E9,
	0x4009851E,0xB851EB85, 0x3FF445B5,0xF721B91A,
	0x40098F5C,0x28F5C28F, 0x3FF4478A,0x69811E74,
	0x40099999,0x9999999A, 0x3FF4495D,0x86823225,
	0x4009A3D7,0x0A3D70A4, 0x3FF44B2F,0x4F8D7863,
	0x4009AE14,0x7AE147AE, 0x3FF44CFF,0xC6098C8B,
	0x4009B851,0xEB851EB8, 0x3FF44ECE,0xEB5B243C,
	0x4009C28F,0x5C28F5C3, 0x3FF4509C,0xC0E51269,
	0x4009CCCC,0xCCCCCCCD, 0x3FF45269,0x48084A68,
	0x4009D70A,0x3D70A3D7, 0x3FF45434,0x8223E2FA,
	0x4009E147,0xAE147AE1, 0x3FF455FE,0x7095194D,
	0x4009EB85,0x1EB851EC, 0x3FF457C7,0x14B753F9,
	0x4009F5C2,0x8F5C28F6, 0x3FF4598E,0x6FE425FA,
	0x400A0000,0x00000000, 0x3FF45B54,0x837351A0,
	0x400A0A3D,0x70A3D70A, 0x3FF45D19,0x50BACB7B,
	0x400A147A,0xE147AE14, 0x3FF45EDC,0xD90EBD46,
	0x400A1EB8,0x51EB851F, 0x3FF4609F,0x1DC188C4,
	0x400A28F5,0xC28F5C29, 0x3FF46260,0x2023CAA2,
	0x400A3333,0x33333333, 0x3FF4641F,0xE1845D4B,
	0x400A3D70,0xA3D70A3D, 0x3FF465DE,0x63305BBC,
	0x400A47AE,0x147AE148, 0x3FF4679B,0xA6732450,
	0x400A51EB,0x851EB852, 0x3FF46957,0xAC965B89,
	0x400A5C28,0xF5C28F5C, 0x3FF46B12,0x76E1EED2,
	0x400A6666,0x66666666, 0x3FF46CCC,0x069C173F,
	0x400A70A3,0xD70A3D71, 0x3FF46E84,0x5D095C43,
	0x400A7AE1,0x47AE147B, 0x3FF4703B,0x7B6C9666,
	0x400A851E,0xB851EB85, 0x3FF471F1,0x6306F1F3,
	0x400A8F5C,0x28F5C28F, 0x3FF473A6,0x1517F1A2,
	0x400A9999,0x9999999A, 0x3FF47559,0x92DD7141,
	0x400AA3D7,0x0A3D70A4, 0x3FF4770B,0xDD93A84C,
	0x400AAE14,0x7AE147AE, 0x3FF478BC,0xF6752C91,
	0x400AB851,0xEB851EB8, 0x3FF47A6C,0xDEBAF4C4,
	0x400AC28F,0x5C28F5C3, 0x3FF47C1B,0x979C5B11,
	0x400ACCCC,0xCCCCCCCD, 0x3FF47DC9,0x224F1FA8,
	0x400AD70A,0x3D70A3D7, 0x3FF47F75,0x80076B48,
	0x400AE147,0xAE147AE1, 0x3FF48120,0xB1F7D1C5,
	0x400AEB85,0x1EB851EC, 0x3FF482CA,0xB9515482,
	0x400AF5C2,0x8F5C28F6, 0x3FF48473,0x974364F3,
	0x400B0000,0x00000000, 0x3FF4861B,0x4CFBE710,
	0x400B0A3D,0x70A3D70A, 0x3FF487C1,0xDBA733C7,
	0x400B147A,0xE147AE14, 0x3FF48967,0x44701B6B,
	0x400B1EB8,0x51EB851F, 0x3FF48B0B,0x887FE81E,
	0x400B28F5,0xC28F5C29, 0x3FF48CAE,0xA8FE6036,
	0x400B3333,0x33333333, 0x3FF48E50,0xA711C89D,
	0x400B3D70,0xA3D70A3D, 0x3FF48FF1,0x83DEE72D,
	0x400B47AE,0x147AE148, 0x3FF49191,0x4089050A,
	0x400B51EB,0x851EB852, 0x3FF4932F,0xDE31F0F7,
	0x400B5C28,0xF5C28F5C, 0x3FF494CD,0x5DFA01A1,
	0x400B6666,0x66666666, 0x3FF49669,0xC10017F1,
	0x400B70A3,0xD70A3D71, 0x3FF49805,0x0861A150,
	0x400B7AE1,0x47AE147B, 0x3FF4999F,0x353A99EA,
	0x400B851E,0xB851EB85, 0x3FF49B38,0x48A58EF0,
	0x400B8F5C,0x28F5C28F, 0x3FF49CD0,0x43BBA0D1,
	0x400B9999,0x9999999A, 0x3FF49E67,0x27948576,
	0x400BA3D7,0x0A3D70A4, 0x3FF49FFC,0xF5468A6D,
	0x400BAE14,0x7AE147AE, 0x3FF4A191,0xADE69723,
	0x400BB851,0xEB851EB8, 0x3FF4A325,0x52882F07,
	0x400BC28F,0x5C28F5C3, 0x3FF4A4B7,0xE43D73B8,
	0x400BCCCC,0xCCCCCCCD, 0x3FF4A649,0x64172723,
	0x400BD70A,0x3D70A3D7, 0x3FF4A7D9,0xD324ADA9,
	0x400BE147,0xAE147AE1, 0x3FF4A969,0x32741038,
	0x400BEB85,0x1EB851EC, 0x3FF4AAF7,0x8311FE65,
	0x400BF5C2,0x8F5C28F6, 0x3FF4AC84,0xC609D080,
	0x400C0000,0x00000000, 0x3FF4AE10,0xFC6589A5,
	0x400C0A3D,0x70A3D70A, 0x3FF4AF9C,0x272DD9CA,
	0x400C147A,0xE147AE14, 0x3FF4B126,0x476A1FCA,
	0x400C1EB8,0x51EB851F, 0x3FF4B2AF,0x5E206B6A,
	0x400C28F5,0xC28F5C29, 0x3FF4B437,0x6C557F5A,
	0x400C3333,0x33333333, 0x3FF4B5BE,0x730CD339,
	0x400C3D70,0xA3D70A3D, 0x3FF4B744,0x7348958C,
	0x400C47AE,0x147AE148, 0x3FF4B8C9,0x6E09ADB7,
	0x400C51EB,0x851EB852, 0x3FF4BA4D,0x644FBDF4,
	0x400C5C28,0xF5C28F5C, 0x3FF4BBD0,0x57192542,
	0x400C6666,0x66666666, 0x3FF4BD52,0x47630152,
	0x400C70A3,0xD70A3D71, 0x3FF4BED3,0x36293075,
	0x400C7AE1,0x47AE147B, 0x3FF4C053,0x2466537E,
	0x400C851E,0xB851EB85, 0x3FF4C1D2,0x1313CFAB,
	0x400C8F5C,0x28F5C28F, 0x3FF4C350,0x0329D080,
	0x400C9999,0x9999999A, 0x3FF4C4CC,0xF59F49A8,
	0x400CA3D7,0x0A3D70A4, 0x3FF4C648,0xEB69F8CE,
	0x400CAE14,0x7AE147AE, 0x3FF4C7C3,0xE57E6771,
	0x400CB851,0xEB851EB8, 0x3FF4C93D,0xE4CFECBA,
	0x400CC28F,0x5C28F5C3, 0x3FF4CAB6,0xEA50AF4C,
	0x400CCCCC,0xCCCCCCCD, 0x3FF4CC2E,0xF6F1A710,
	0x400CD70A,0x3D70A3D7, 0x3FF4CDA6,0x0BA29EFD,
	0x400CE147,0xAE147AE1, 0x3FF4CF1C,0x295236E4,
	0x400CEB85,0x1EB851EC, 0x3FF4D091,0x50EDE52D,
	0x400CF5C2,0x8F5C28F6, 0x3FF4D205,0x8361F89C,
	0x400D0000,0x00000000, 0x3FF4D378,0xC1999A0D,
	0x400D0A3D,0x70A3D70A, 0x3FF4D4EB,0x0C7ECE2F,
	0x400D147A,0xE147AE14, 0x3FF4D65C,0x64FA7739,
	0x400D1EB8,0x51EB851F, 0x3FF4D7CC,0xCBF456A3,
	0x400D28F5,0xC28F5C29, 0x3FF4D93C,0x42530ED3,
	0x400D3333,0x33333333, 0x3FF4DAAA,0xC8FC24CC,
	0x400D3D70,0xA3D70A3D, 0x3FF4DC18,0x60D401DE,
	0x400D47AE,0x147AE148, 0x3FF4DD85,0x0ABDF549,
	0x400D51EB,0x851EB852, 0x3FF4DEF0,0xC79C35E6,
	0x400D5C28,0xF5C28F5C, 0x3FF4E05B,0x984FE3C9,
	0x400D6666,0x66666666, 0x3FF4E1C5,0x7DB909E3,
	0x400D70A3,0xD70A3D71, 0x3FF4E32E,0x78B69F9C,
	0x400D7AE1,0x47AE147B, 0x3FF4E496,0x8A268A70,
	0x400D851E,0xB851EB85, 0x3FF4E5FD,0xB2E59F85,
	0x400D8F5C,0x28F5C28F, 0x3FF4E763,0xF3CFA543,
	0x400D9999,0x9999999A, 0x3FF4E8C9,0x4DBF54E5,
	0x400DA3D7,0x0A3D70A4, 0x3FF4EA2D,0xC18E5C04,
	0x400DAE14,0x7AE147AE, 0x3FF4EB91,0x50155E2D,
	0x400DB851,0xEB851EB8, 0x3FF4ECF3,0xFA2BF662,
	0x400DC28F,0x5C28F5C3, 0x3FF4EE55,0xC0A8B8AA,
	0x400DCCCC,0xCCCCCCCD, 0x3FF4EFB6,0xA461338E,
	0x400DD70A,0x3D70A3D7, 0x3FF4F116,0xA629F1A2,
	0x400DE147,0xAE147AE1, 0x3FF4F275,0xC6D67B00,
	0x400DEB85,0x1EB851EC, 0x3FF4F3D4,0x073956CA,
	0x400DF5C2,0x8F5C28F6, 0x3FF4F531,0x68240C9F,
	0x400E0000,0x00000000, 0x3FF4F68D,0xEA672617,
	0x400E0A3D,0x70A3D70A, 0x3FF4F7E9,0x8ED2303A,
	0x400E147A,0xE147AE14, 0x3FF4F944,0x5633BCEF,
	0x400E1EB8,0x51EB851F, 0x3FF4FA9E,0x4159646F,
	0x400E28F5,0xC28F5C29, 0x3FF4FBF7,0x510FC6B2,
	0x400E3333,0x33333333, 0x3FF4FD4F,0x86228CDD,
	0x400E3D70,0xA3D70A3D, 0x3FF4FEA6,0xE15C6AAC,
	0x400E47AE,0x147AE148, 0x3FF4FFFD,0x63871FD3,
	0x400E51EB,0x851EB852, 0x3FF50153,0x0D6B7969,
	0x400E5C28,0xF5C28F5C, 0x3FF502A7,0xDFD15348,
	0x400E6666,0x66666666, 0x3FF503FB,0xDB7F996E,
	0x400E70A3,0xD70A3D71, 0x3FF5054F,0x013C4957,
	0x400E7AE1,0x47AE147B, 0x3FF506A1,0x51CC735C,
	0x400E851E,0xB851EB85, 0x3FF507F2,0xCDF43C0C,
	0x400E8F5C,0x28F5C28F, 0x3FF50943,0x7676DD80,
	0x400E9999,0x9999999A, 0x3FF50A93,0x4C16A8B1,
	0x400EA3D7,0x0A3D70A4, 0x3FF50BE2,0x4F9506CB,
	0x400EAE14,0x7AE147AE, 0x3FF50D30,0x81B27A7A,
	0x400EB851,0xEB851EB8, 0x3FF50E7D,0xE32EA13C,
	0x400EC28F,0x5C28F5C3, 0x3FF50FCA,0x74C834AA,
	0x400ECCCC,0xCCCCCCCD, 0x3FF51116,0x373D0BC2,
	0x400ED70A,0x3D70A3D7, 0x3FF51261,0x2B4A1C2D,
	0x400EE147,0xAE147AE1, 0x3FF513AB,0x51AB7B85,
	0x400EEB85,0x1EB851EC, 0x3FF514F4,0xAB1C6099,
	0x400EF5C2,0x8F5C28F6, 0x3FF5163D,0x385724AE,
	0x400F0000,0x00000000, 0x3FF51784,0xFA1544BA,
	0x400F0A3D,0x70A3D70A, 0x3FF518CB,0xF10F62A5,
	0x400F147A,0xE147AE14, 0x3FF51A12,0x1DFD4681,
	0x400F1EB8,0x51EB851F, 0x3FF51B57,0x8195DFC6,
	0x400F28F5,0xC28F5C29, 0x3FF51C9C,0x1C8F4682,
	0x400F3333,0x33333333, 0x3FF51DDF,0xEF9EBC94,
	0x400F3D70,0xA3D70A3D, 0x3FF51F22,0xFB78AEDC,
	0x400F47AE,0x147AE148, 0x3FF52065,0x40D0B66B,
	0x400F51EB,0x851EB852, 0x3FF521A6,0xC05999B0,
	0x400F5C28,0xF5C28F5C, 0x3FF522E7,0x7AC54DAA,
	0x400F6666,0x66666666, 0x3FF52427,0x70C4F70D,
	0x400F70A3,0xD70A3D71, 0x3FF52566,0xA308EB6C,
	0x400F7AE1,0x47AE147B, 0x3FF526A5,0x1240B261,
	0x400F851E,0xB851EB85, 0x3FF527E2,0xBF1B06B3,
	0x400F8F5C,0x28F5C28F, 0x3FF5291F,0xAA45D775,
	0x400F9999,0x9999999A, 0x3FF52A5B,0xD46E492A,
	0x400FA3D7,0x0A3D70A4, 0x3FF52B97,0x3E40B6E3,
	0x400FAE14,0x7AE147AE, 0x3FF52CD1,0xE868B35E,
	0x400FB851,0xEB851EB8, 0x3FF52E0B,0xD3910A1E,
	0x400FC28F,0x5C28F5C3, 0x3FF52F45,0x0063C08A,
	0x400FCCCC,0xCCCCCCCD, 0x3FF5307D,0x6F8A16FF,
	0x400FD70A,0x3D70A3D7, 0x3FF531B5,0x21AC89EA,
	0x400FE147,0xAE147AE1, 0x3FF532EC,0x1772D2DC,
	0x400FEB85,0x1EB851EC, 0x3FF53422,0x5183E999,
	0x400FF5C2,0x8F5C28F6, 0x3FF53557,0xD086052E,
	0x40100000,0x00000000, 0x3FF5368C,0x951E9CFD,
	};

LOCAL_D const TUint32 ArcsinTest[] =
	{
	0x00000000,0x00000000, 0x00000000,0x00000000,
	0x3F50624D,0xD2F1A9FC, 0x3F50624E,0x00C1CB16,
	0x3F60624D,0xD2F1A9FC, 0x3F60624E,0x8A323E9C,
	0x3F689374,0xBC6A7EFA, 0x3F689377,0x26E4CFC8,
	0x3F70624D,0xD2F1A9FC, 0x3F706250,0xAFF4FFE4,
	0x3F747AE1,0x47AE147B, 0x3F747AE6,0xDF5A1444,
	0x3F789374,0xBC6A7EFA, 0x3F78937E,0x665B741E,
	0x3F7CAC08,0x3126E979, 0x3F7CAC17,0x89B3B93C,
	0x3F80624D,0xD2F1A9FC, 0x3F806259,0x470F3852,
	0x3F826E97,0x8D4FDF3B, 0x3F826EA7,0xDC2C2190,
	0x3F847AE1,0x47AE147B, 0x3F847AF7,0xA68F8EEF,
	0x3F86872B,0x020C49BA, 0x3F868748,0xC8992D73,
	0x3F889374,0xBC6A7EFA, 0x3F88939B,0x64A974E9,
	0x3F8A9FBE,0x76C8B439, 0x3F8A9FEF,0x9D21BC1F,
	0x3F8CAC08,0x3126E979, 0x3F8CAC45,0x94644D43,
	0x3F8EB851,0xEB851EB8, 0x3F8EB89D,0x6CD47A22,
	0x3F90624D,0xD2F1A9FC, 0x3F90627B,0xA46B5841,
	0x3F916872,0xB020C49C, 0x3F9168A9,0xA5684739,
	0x3F926E97,0x8D4FDF3B, 0x3F926ED8,0xCA947B4B,
	0x3F9374BC,0x6A7EF9DB, 0x3F937509,0x25241246,
	0x3F947AE1,0x47AE147B, 0x3F947B3A,0xC64BE09A,
	0x3F958106,0x24DD2F1B, 0x3F95816D,0xBF417B8B,
	0x3F96872B,0x020C49BA, 0x3F9687A2,0x213B435B,
	0x3F978D4F,0xDF3B645A, 0x3F978DD7,0xFD706D7E,
	0x3F989374,0xBC6A7EFA, 0x3F98940F,0x65190EC9,
	0x3F999999,0x9999999A, 0x3F999A48,0x696E25A4,
	0x3F9A9FBE,0x76C8B439, 0x3F9AA083,0x1BA9A43C,
	0x3F9BA5E3,0x53F7CED9, 0x3F9BA6BF,0x8D067AC2,
	0x3F9CAC08,0x3126E979, 0x3F9CACFD,0xCEC0A195,
	0x3F9DB22D,0x0E560419, 0x3F9DB33D,0xF2152385,
	0x3F9EB851,0xEB851EB8, 0x3F9EB980,0x08422806,
	0x3F9FBE76,0xC8B43958, 0x3F9FBFC4,0x2286FD78,
	0x3FA0624D,0xD2F1A9FC, 0x3FA06305,0x291211AB,
	0x3FA0E560,0x4189374C, 0x3FA0E629,0x542DAA42,
	0x3FA16872,0xB020C49C, 0x3FA1694E,0x9B37C8C4,
	0x3FA1EB85,0x1EB851EC, 0x3FA1EC75,0x06D2956A,
	0x3FA26E97,0x8D4FDF3B, 0x3FA26F9C,0x9FA0E585,
	0x3FA2F1A9,0xFBE76C8B, 0x3FA2F2C5,0x6E4640A5,
	0x3FA374BC,0x6A7EF9DB, 0x3FA375EF,0x7B66E5B9,
	0x3FA3F7CE,0xD916872B, 0x3FA3F91A,0xCFA7D03C,
	0x3FA47AE1,0x47AE147B, 0x3FA47C47,0x73AEBD59,
	0x3FA4FDF3,0xB645A1CB, 0x3FA4FF75,0x70223116,
	0x3FA58106,0x24DD2F1B, 0x3FA582A4,0xCDA97B7C,
	0x3FA60418,0x9374BC6A, 0x3FA605D5,0x94ECBDC6,
	0x3FA6872B,0x020C49BA, 0x3FA68907,0xCE94EF8F,
	0x3FA70A3D,0x70A3D70A, 0x3FA70C3B,0x834BE3FC,
	0x3FA78D4F,0xDF3B645A, 0x3FA78F70,0xBBBC4EEF,
	0x3FA81062,0x4DD2F1AA, 0x3FA812A7,0x8091CA38,
	0x3FA89374,0xBC6A7EFA, 0x3FA895DF,0xDA78DAC7,
	0x3FA91687,0x2B020C4A, 0x3FA91919,0xD21EF5E2,
	0x3FA99999,0x9999999A, 0x3FA99C55,0x70328659,
	0x3FAA1CAC,0x083126E9, 0x3FAA1F92,0xBD62F1C0,
	0x3FAA9FBE,0x76C8B439, 0x3FAAA2D1,0xC2609DA6,
	0x3FAB22D0,0xE5604189, 0x3FAB2612,0x87DCF4D2,
	0x3FABA5E3,0x53F7CED9, 0x3FABA955,0x168A6C7B,
	0x3FAC28F5,0xC28F5C29, 0x3FAC2C99,0x771C898D,
	0x3FACAC08,0x3126E979, 0x3FACAFDF,0xB247E5E4,
	0x3FAD2F1A,0x9FBE76C9, 0x3FAD3327,0xD0C2358D,
	0x3FADB22D,0x0E560419, 0x3FADB671,0xDB424C0E,
	0x3FAE353F,0x7CED9168, 0x3FAE39BD,0xDA8021AA,
	0x3FAEB851,0xEB851EB8, 0x3FAEBD0B,0xD734D8A7,
	0x3FAF3B64,0x5A1CAC08, 0x3FAF405B,0xDA1AC296,
	0x3FAFBE76,0xC8B43958, 0x3FAFC3AD,0xEBED65A4,
	0x3FB020C4,0x9BA5E354, 0x3FB02381,0x0AB4C0F0,
	0x3FB0624D,0xD2F1A9FC, 0x3FB0652C,0x2FA68B47,
	0x3FB0A3D7,0x0A3D70A4, 0x3FB0A6D8,0x692BB3BD,
	0x3FB0E560,0x4189374C, 0x3FB0E885,0xBBA48126,
	0x3FB126E9,0x78D4FDF4, 0x3FB12A34,0x2B71E1EA,
	0x3FB16872,0xB020C49C, 0x3FB16BE3,0xBCF56EB9,
	0x3FB1A9FB,0xE76C8B44, 0x3FB1AD94,0x74916D30,
	0x3FB1EB85,0x1EB851EC, 0x3FB1EF46,0x56A8D28C,
	0x3FB22D0E,0x56041893, 0x3FB230F9,0x679F465A,
	0x3FB26E97,0x8D4FDF3B, 0x3FB272AD,0xABD92523,
	0x3FB2B020,0xC49BA5E3, 0x3FB2B463,0x27BB8322,
	0x3FB2F1A9,0xFBE76C8B, 0x3FB2F619,0xDFAC2EF4,
	0x3FB33333,0x33333333, 0x3FB337D1,0xD811B44C,
	0x3FB374BC,0x6A7EF9DB, 0x3FB3798B,0x15535EAC,
	0x3FB3B645,0xA1CAC083, 0x3FB3BB45,0x9BD93C18,
	0x3FB3F7CE,0xD916872B, 0x3FB3FD01,0x700C1FCD,
	0x3FB43958,0x10624DD3, 0x3FB43EBE,0x9655A4FE,
	0x3FB47AE1,0x47AE147B, 0x3FB4807D,0x1320318C,
	0x3FB4BC6A,0x7EF9DB23, 0x3FB4C23C,0xEAD6F8C2,
	0x3FB4FDF3,0xB645A1CB, 0x3FB503FE,0x21E5FE10,
	0x3FB53F7C,0xED916873, 0x3FB545C0,0xBCBA17CF,
	0x3FB58106,0x24DD2F1B, 0x3FB58784,0xBFC0F1FC,
	0x3FB5C28F,0x5C28F5C3, 0x3FB5C94A,0x2F6910FA,
	0x3FB60418,0x9374BC6A, 0x3FB60B11,0x1021D455,
	0x3FB645A1,0xCAC08312, 0x3FB64CD9,0x665B798B,
	0x3FB6872B,0x020C49BA, 0x3FB68EA3,0x36871EC7,
	0x3FB6C8B4,0x39581062, 0x3FB6D06E,0x8516C5B3,
	0x3FB70A3D,0x70A3D70A, 0x3FB7123B,0x567D5638,
	0x3FB74BC6,0xA7EF9DB2, 0x3FB75409,0xAF2EA14F,
	0x3FB78D4F,0xDF3B645A, 0x3FB795D9,0x939F63C8,
	0x3FB7CED9,0x16872B02, 0x3FB7D7AB,0x08454918,
	0x3FB81062,0x4DD2F1AA, 0x3FB8197E,0x1196EE2A,
	0x3FB851EB,0x851EB852, 0x3FB85B52,0xB40BE42D,
	0x3FB89374,0xBC6A7EFA, 0x3FB89D28,0xF41CB367,
	0x3FB8D4FD,0xF3B645A2, 0x3FB8DF00,0xD642DE09,
	0x3FB91687,0x2B020C4A, 0x3FB920DA,0x5EF8E302,
	0x3FB95810,0x624DD2F2, 0x3FB962B5,0x92BA40D9,
	0x3FB99999,0x9999999A, 0x3FB9A492,0x76037884,
	0x3FB9DB22,0xD0E56042, 0x3FB9E671,0x0D521043,
	0x3FBA1CAC,0x083126E9, 0x3FBA2851,0x5D24967A,
	0x3FBA5E35,0x3F7CED91, 0x3FBA6A33,0x69FAA495,
	0x3FBA9FBE,0x76C8B439, 0x3FBAAC17,0x3854E1DE,
	0x3FBAE147,0xAE147AE1, 0x3FBAEDFC,0xCCB50667,
	0x3FBB22D0,0xE5604189, 0x3FBB2FE4,0x2B9DDDEA,
	0x3FBB645A,0x1CAC0831, 0x3FBB71CD,0x59934AAC,
	0x3FBBA5E3,0x53F7CED9, 0x3FBBB3B8,0x5B1A4868,
	0x3FBBE76C,0x8B439581, 0x3FBBF5A5,0x34B8EF36,
	0x3FBC28F5,0xC28F5C29, 0x3FBC3793,0xEAF67675,
	0x3FBC6A7E,0xF9DB22D1, 0x3FBC7984,0x825B37B8,
	0x3FBCAC08,0x3126E979, 0x3FBCBB76,0xFF70B1B6,
	0x3FBCED91,0x6872B021, 0x3FBCFD6B,0x66C18B3B,
	0x3FBD2F1A,0x9FBE76C9, 0x3FBD3F61,0xBCD99615,
	0x3FBD70A3,0xD70A3D71, 0x3FBD815A,0x0645D212,
	0x3FBDB22D,0x0E560419, 0x3FBDC354,0x47946FEE,
	0x3FBDF3B6,0x45A1CAC1, 0x3FBE0550,0x8554D451,
	0x3FBE353F,0x7CED9168, 0x3FBE474E,0xC4179AC6,
	0x3FBE76C8,0xB4395810, 0x3FBE894F,0x086E98BD,
	0x3FBEB851,0xEB851EB8, 0x3FBECB51,0x56ECE085,
	0x3FBEF9DB,0x22D0E560, 0x3FBF0D55,0xB426C44F,
	0x3FBF3B64,0x5A1CAC08, 0x3FBF4F5C,0x24B1D931,
	0x3FBF7CED,0x916872B0, 0x3FBF9164,0xAD24FA2C,
	0x3FBFBE76,0xC8B43958, 0x3FBFD36F,0x52184B35,
	0x3FC00000,0x00000000, 0x3FC00ABE,0x0C129E1E,
	0x3FC020C4,0x9BA5E354, 0x3FC02BC5,0x81F3461D,
	0x3FC04189,0x374BC6A8, 0x3FC04CCE,0x0CFC261F,
	0x3FC0624D,0xD2F1A9FC, 0x3FC06DD7,0xAF7BF140,
	0x3FC08312,0x6E978D50, 0x3FC08EE2,0x6BC206BA,
	0x3FC0A3D7,0x0A3D70A4, 0x3FC0AFEE,0x441E736F,
	0x3FC0C49B,0xA5E353F8, 0x3FC0D0FB,0x3AE1F374,
	0x3FC0E560,0x4189374C, 0x3FC0F209,0x525DF3A1,
	0x3FC10624,0xDD2F1AA0, 0x3FC11318,0x8CE4931C,
	0x3FC126E9,0x78D4FDF4, 0x3FC13428,0xECC8A4EA,
	0x3FC147AE,0x147AE148, 0x3FC1553A,0x745DB182,
	0x3FC16872,0xB020C49C, 0x3FC1764D,0x25F7F85B,
	0x3FC18937,0x4BC6A7F0, 0x3FC19761,0x03EC7181,
	0x3FC1A9FB,0xE76C8B44, 0x3FC1B876,0x1090CF2B,
	0x3FC1CAC0,0x83126E98, 0x3FC1D98C,0x4E3B7F50,
	0x3FC1EB85,0x1EB851EC, 0x3FC1FAA3,0xBF43AD3B,
	0x3FC20C49,0xBA5E353F, 0x3FC21BBC,0x66014327,
	0x3FC22D0E,0x56041893, 0x3FC23CD6,0x44CCEBDB,
	0x3FC24DD2,0xF1A9FBE7, 0x3FC25DF1,0x5E00143F,
	0x3FC26E97,0x8D4FDF3B, 0x3FC27F0D,0xB3F4ECFB,
	0x3FC28F5C,0x28F5C28F, 0x3FC2A02B,0x49066C16,
	0x3FC2B020,0xC49BA5E3, 0x3FC2C14A,0x1F904E95,
	0x3FC2D0E5,0x60418937, 0x3FC2E26A,0x39EF1A1A,
	0x3FC2F1A9,0xFBE76C8B, 0x3FC3038B,0x9A801E86,
	0x3FC3126E,0x978D4FDF, 0x3FC324AE,0x43A177A0,
	0x3FC33333,0x33333333, 0x3FC345D2,0x37B20EB3,
	0x3FC353F7,0xCED91687, 0x3FC366F7,0x79119C3B,
	0x3FC374BC,0x6A7EF9DB, 0x3FC3881E,0x0A20A988,
	0x3FC39581,0x0624DD2F, 0x3FC3A945,0xED40926B,
	0x3FC3B645,0xA1CAC083, 0x3FC3CA6F,0x24D386DB,
	0x3FC3D70A,0x3D70A3D7, 0x3FC3EB99,0xB33C8CA7,
	0x3FC3F7CE,0xD916872B, 0x3FC40CC5,0x9ADF8122,
	0x3FC41893,0x74BC6A7F, 0x3FC42DF2,0xDE211ACD,
	0x3FC43958,0x10624DD3, 0x3FC44F21,0x7F66EB10,
	0x3FC45A1C,0xAC083127, 0x3FC47051,0x81175FE6,
	0x3FC47AE1,0x47AE147B, 0x3FC49182,0xE599C592,
	0x3FC49BA5,0xE353F7CF, 0x3FC4B2B5,0xAF564857,
	0x3FC4BC6A,0x7EF9DB23, 0x3FC4D3E9,0xE0B5F62A,
	0x3FC4DD2F,0x1A9FBE77, 0x3FC4F51F,0x7C22C06F,
	0x3FC4FDF3,0xB645A1CB, 0x3FC51656,0x84077DB1,
	0x3FC51EB8,0x51EB851F, 0x3FC5378E,0xFACFEB5F,
	0x3FC53F7C,0xED916873, 0x3FC558C8,0xE2E8AF86,
	0x3FC56041,0x89374BC7, 0x3FC57A04,0x3EBF5A94,
	0x3FC58106,0x24DD2F1B, 0x3FC59B41,0x10C26917,
	0x3FC5A1CA,0xC083126F, 0x3FC5BC7F,0x5B61457F,
	0x3FC5C28F,0x5C28F5C3, 0x3FC5DDBF,0x210C49E2,
	0x3FC5E353,0xF7CED917, 0x3FC5FF00,0x6434C1C3,
	0x3FC60418,0x9374BC6A, 0x3FC62043,0x274CEBD8,
	0x3FC624DD,0x2F1A9FBE, 0x3FC64187,0x6CC7FBD5,
	0x3FC645A1,0xCAC08312, 0x3FC662CD,0x371A1C37,
	0x3FC66666,0x66666666, 0x3FC68414,0x88B8700C,
	0x3FC6872B,0x020C49BA, 0x3FC6A55D,0x641914C8,
	0x3FC6A7EF,0x9DB22D0E, 0x3FC6C6A7,0xCBB32413,
	0x3FC6C8B4,0x39581062, 0x3FC6E7F3,0xC1FEB599,
	0x3FC6E978,0xD4FDF3B6, 0x3FC70941,0x4974E0E2,
	0x3FC70A3D,0x70A3D70A, 0x3FC72A90,0x648FBF25,
	0x3FC72B02,0x0C49BA5E, 0x3FC74BE1,0x15CA6D21,
	0x3FC74BC6,0xA7EF9DB2, 0x3FC76D33,0x5FA10CF4,
	0x3FC76C8B,0x43958106, 0x3FC78E87,0x4490C7FD,
	0x3FC78D4F,0xDF3B645A, 0x3FC7AFDC,0xC717D0B2,
	0x3FC7AE14,0x7AE147AE, 0x3FC7D133,0xE9B56483,
	0x3FC7CED9,0x16872B02, 0x3FC7F28C,0xAEE9CDBD,
	0x3FC7EF9D,0xB22D0E56, 0x3FC813E7,0x19366568,
	0x3FC81062,0x4DD2F1AA, 0x3FC83543,0x2B1D9534,
	0x3FC83126,0xE978D4FE, 0x3FC856A0,0xE722D958,
	0x3FC851EB,0x851EB852, 0x3FC87800,0x4FCAC282,
	0x3FC872B0,0x20C49BA6, 0x3FC89961,0x679AF7BD,
	0x3FC89374,0xBC6A7EFA, 0x3FC8BAC4,0x311A3863,
	0x3FC8B439,0x5810624E, 0x3FC8DC28,0xAED05E0A,
	0x3FC8D4FD,0xF3B645A2, 0x3FC8FD8E,0xE3465E76,
	0x3FC8F5C2,0x8F5C28F6, 0x3FC91EF6,0xD1064D8C,
	0x3FC91687,0x2B020C4A, 0x3FC94060,0x7A9B5F4A,
	0x3FC9374B,0xC6A7EF9E, 0x3FC961CB,0xE291E9BC,
	0x3FC95810,0x624DD2F2, 0x3FC98339,0x0B7766F7,
	0x3FC978D4,0xFDF3B646, 0x3FC9A4A7,0xF7DA7718,
	0x3FC99999,0x9999999A, 0x3FC9C618,0xAA4AE23D,
	0x3FC9BA5E,0x353F7CEE, 0x3FC9E78B,0x25599A8C,
	0x3FC9DB22,0xD0E56042, 0x3FCA08FF,0x6B98BE30,
	0x3FC9FBE7,0x6C8B4396, 0x3FCA2A75,0x7F9B9963,
	0x3FCA1CAC,0x083126E9, 0x3FCA4BED,0x63F6A86F,
	0x3FCA3D70,0xA3D70A3D, 0x3FCA6D67,0x1B3F99C4,
	0x3FCA5E35,0x3F7CED91, 0x3FCA8EE2,0xA80D4FF3,
	0x3FCA7EF9,0xDB22D0E5, 0x3FCAB060,0x0CF7E3CA,
	0x3FCA9FBE,0x76C8B439, 0x3FCAD1DF,0x4C98A65F,
	0x3FCAC083,0x126E978D, 0x3FCAF360,0x698A2323,
	0x3FCAE147,0xAE147AE1, 0x3FCB14E3,0x666821F8,
	0x3FCB020C,0x49BA5E35, 0x3FCB3668,0x45CFA94C,
	0x3FCB22D0,0xE5604189, 0x3FCB57EF,0x0A5F002C,
	0x3FCB4395,0x810624DD, 0x3FCB7977,0xB6B5B067,
	0x3FCB645A,0x1CAC0831, 0x3FCB9B02,0x4D7488AA,
	0x3FCB851E,0xB851EB85, 0x3FCBBC8E,0xD13D9EA5,
	0x3FCBA5E3,0x53F7CED9, 0x3FCBDE1D,0x44B4512A,
	0x3FCBC6A7,0xEF9DB22D, 0x3FCBFFAD,0xAA7D4A58,
	0x3FCBE76C,0x8B439581, 0x3FCC2140,0x053E81C0,
	0x3FCC0831,0x26E978D5, 0x3FCC42D4,0x579F3E95,
	0x3FCC28F5,0xC28F5C29, 0x3FCC646A,0xA44819DA,
	0x3FCC49BA,0x5E353F7D, 0x3FCC8602,0xEDE3008D,
	0x3FCC6A7E,0xF9DB22D1, 0x3FCCA79D,0x371B35E4,
	0x3FCC8B43,0x95810625, 0x3FCCC939,0x829D557A,
	0x3FCCAC08,0x3126E979, 0x3FCCEAD7,0xD317558E,
	0x3FCCCCCC,0xCCCCCCCD, 0x3FCD0C78,0x2B38893C,
	0x3FCCED91,0x6872B021, 0x3FCD2E1A,0x8DB1A2BB,
	0x3FCD0E56,0x04189375, 0x3FCD4FBE,0xFD34B5A2,
	0x3FCD2F1A,0x9FBE76C9, 0x3FCD7165,0x7C753923,
	0x3FCD4FDF,0x3B645A1D, 0x3FCD930E,0x0E280A5D,
	0x3FCD70A3,0xD70A3D71, 0x3FCDB4B8,0xB5036E9A,
	0x3FCD9168,0x72B020C5, 0x3FCDD665,0x73BF15A5,
	0x3FCDB22D,0x0E560419, 0x3FCDF814,0x4D141C12,
	0x3FCDD2F1,0xA9FBE76D, 0x3FCE19C5,0x43BD0D92,
	0x3FCDF3B6,0x45A1CAC1, 0x3FCE3B78,0x5A75E74C,
	0x3FCE147A,0xE147AE14, 0x3FCE5D2D,0x93FC1A2B,
	0x3FCE353F,0x7CED9168, 0x3FCE7EE4,0xF30E8D46,
	0x3FCE5604,0x189374BC, 0x3FCEA09E,0x7A6DA030,
	0x3FCE76C8,0xB4395810, 0x3FCEC25A,0x2CDB2D60,
	0x3FCE978D,0x4FDF3B64, 0x3FCEE418,0x0D1A8C97,
	0x3FCEB851,0xEB851EB8, 0x3FCF05D8,0x1DF0953F,
	0x3FCED916,0x872B020C, 0x3FCF279A,0x6223A0DB,
	0x3FCEF9DB,0x22D0E560, 0x3FCF495E,0xDC7B8D71,
	0x3FCF1A9F,0xBE76C8B4, 0x3FCF6B25,0x8FC1BFFB,
	0x3FCF3B64,0x5A1CAC08, 0x3FCF8CEE,0x7EC126D9,
	0x3FCF5C28,0xF5C28F5C, 0x3FCFAEB9,0xAC463C49,
	0x3FCF7CED,0x916872B0, 0x3FCFD087,0x1B1F08DD,
	0x3FCF9DB2,0x2D0E5604, 0x3FCFF256,0xCE1B25FE,
	0x3FCFBE76,0xC8B43958, 0x3FD00A14,0x6405E032,
	0x3FCFDF3B,0x645A1CAC, 0x3FD01AFE,0x85E1CD4F,
	0x3FD00000,0x00000000, 0x3FD02BE9,0xCE0B87CD,
	0x3FD01062,0x4DD2F1AA, 0x3FD03CD6,0x3DEE0A95,
	0x3FD020C4,0x9BA5E354, 0x3FD04DC3,0xD6F51F49,
	0x3FD03126,0xE978D4FE, 0x3FD05EB2,0x9A8D5F8F,
	0x3FD04189,0x374BC6A8, 0x3FD06FA2,0x8A243657,
	0x3FD051EB,0x851EB852, 0x3FD08093,0xA727E129,
	0x3FD0624D,0xD2F1A9FC, 0x3FD09185,0xF3077174,
	0x3FD072B0,0x20C49BA6, 0x3FD0A279,0x6F32CDD9,
	0x3FD08312,0x6E978D50, 0x3FD0B36E,0x1D1AB37E,
	0x3FD09374,0xBC6A7EFA, 0x3FD0C463,0xFE30B761,
	0x3FD0A3D7,0x0A3D70A4, 0x3FD0D55B,0x13E747AE,
	0x3FD0B439,0x5810624E, 0x3FD0E653,0x5FB1AD12,
	0x3FD0C49B,0xA5E353F8, 0x3FD0F74C,0xE3040C13,
	0x3FD0D4FD,0xF3B645A2, 0x3FD10847,0x9F53666F,
	0x3FD0E560,0x4189374C, 0x3FD11943,0x96159C73,
	0x3FD0F5C2,0x8F5C28F6, 0x3FD12A40,0xC8C16E57,
	0x3FD10624,0xDD2F1AA0, 0x3FD13B3F,0x38CE7DA4,
	0x3FD11687,0x2B020C4A, 0x3FD14C3E,0xE7B54E92,
	0x3FD126E9,0x78D4FDF4, 0x3FD15D3F,0xD6EF4967,
	0x3FD1374B,0xC6A7EF9E, 0x3FD16E42,0x07F6BBE6,
	0x3FD147AE,0x147AE148, 0x3FD17F45,0x7C46DAAB,
	0x3FD15810,0x624DD2F2, 0x3FD1904A,0x355BC29E,
	0x3FD16872,0xB020C49C, 0x3FD1A150,0x34B27A57,
	0x3FD178D4,0xFDF3B646, 0x3FD1B257,0x7BC8F38F,
	0x3FD18937,0x4BC6A7F0, 0x3FD1C360,0x0C1E0C8F,
	0x3FD19999,0x9999999A, 0x3FD1D469,0xE731919C,
	0x3FD1A9FB,0xE76C8B44, 0x3FD1E575,0x0E843E73,
	0x3FD1BA5E,0x353F7CEE, 0x3FD1F681,0x8397BFB6,
	0x3FD1CAC0,0x83126E98, 0x3FD2078F,0x47EEB468,
	0x3FD1DB22,0xD0E56042, 0x3FD2189E,0x5D0CAF65,
	0x3FD1EB85,0x1EB851EC, 0x3FD229AE,0xC47638DD,
	0x3FD1FBE7,0x6C8B4396, 0x3FD23AC0,0x7FB0CFD1,
	0x3FD20C49,0xBA5E353F, 0x3FD24BD3,0x9042EB95,
	0x3FD21CAC,0x083126E9, 0x3FD25CE7,0xF7B3FD52,
	0x3FD22D0E,0x56041893, 0x3FD26DFD,0xB78C7184,
	0x3FD23D70,0xA3D70A3D, 0x3FD27F14,0xD155B18A,
	0x3FD24DD2,0xF1A9FBE7, 0x3FD2902D,0x469A2525,
	0x3FD25E35,0x3F7CED91, 0x3FD2A147,0x18E5340A,
	0x3FD26E97,0x8D4FDF3B, 0x3FD2B262,0x49C3476A,
	0x3FD27EF9,0xDB22D0E5, 0x3FD2C37E,0xDAC1CB83,
	0x3FD28F5C,0x28F5C28F, 0x3FD2D49C,0xCD6F3133,
	0x3FD29FBE,0x76C8B439, 0x3FD2E5BC,0x235AEF89,
	0x3FD2B020,0xC49BA5E3, 0x3FD2F6DC,0xDE15855C,
	0x3FD2C083,0x126E978D, 0x3FD307FE,0xFF307AE5,
	0x3FD2D0E5,0x60418937, 0x3FD31922,0x883E6357,
	0x3FD2E147,0xAE147AE1, 0x3FD32A47,0x7AD2DE7F,
	0x3FD2F1A9,0xFBE76C8B, 0x3FD33B6D,0xD8829A63,
	0x3FD3020C,0x49BA5E35, 0x3FD34C95,0xA2E354DF,
	0x3FD3126E,0x978D4FDF, 0x3FD35DBE,0xDB8BDD54,
	0x3FD322D0,0xE5604189, 0x3FD36EE9,0x84141643,
	0x3FD33333,0x33333333, 0x3FD38015,0x9E14F6FF,
	0x3FD34395,0x810624DD, 0x3FD39143,0x2B288D54,
	0x3FD353F7,0xCED91687, 0x3FD3A272,0x2CE9FF38,
	0x3FD3645A,0x1CAC0831, 0x3FD3B3A2,0xA4F58C7C,
	0x3FD374BC,0x6A7EF9DB, 0x3FD3C4D4,0x94E8907D,
	0x3FD3851E,0xB851EB85, 0x3FD3D607,0xFE6183DC,
	0x3FD39581,0x0624DD2F, 0x3FD3E73C,0xE2FFFE36,
	0x3FD3A5E3,0x53F7CED9, 0x3FD3F873,0x4464B7E1,
	0x3FD3B645,0xA1CAC083, 0x3FD409AB,0x24318BA6,
	0x3FD3C6A7,0xEF9DB22D, 0x3FD41AE4,0x84097887,
	0x3FD3D70A,0x3D70A3D7, 0x3FD42C1F,0x6590A37D,
	0x3FD3E76C,0x8B439581, 0x3FD43D5B,0xCA6C5942,
	0x3FD3F7CE,0xD916872B, 0x3FD44E99,0xB4431018,
	0x3FD40831,0x26E978D5, 0x3FD45FD9,0x24BC6995,
	0x3FD41893,0x74BC6A7F, 0x3FD4711A,0x1D813470,
	0x3FD428F5,0xC28F5C29, 0x3FD4825C,0xA03B6E54,
	0x3FD43958,0x10624DD3, 0x3FD493A0,0xAE9645B3,
	0x3FD449BA,0x5E353F7D, 0x3FD4A4E6,0x4A3E1B9F,
	0x3FD45A1C,0xAC083127, 0x3FD4B62D,0x74E0859E,
	0x3FD46A7E,0xF9DB22D1, 0x3FD4C776,0x302C4F8D,
	0x3FD47AE1,0x47AE147B, 0x3FD4D8C0,0x7DD17D7D,
	0x3FD48B43,0x95810625, 0x3FD4EA0C,0x5F814D93,
	0x3FD49BA5,0xE353F7CF, 0x3FD4FB59,0xD6EE39F3,
	0x3FD4AC08,0x3126E979, 0x3FD50CA8,0xE5CBFAA3,
	0x3FD4BC6A,0x7EF9DB23, 0x3FD51DF9,0x8DCF8779,
	0x3FD4CCCC,0xCCCCCCCD, 0x3FD52F4B,0xD0AF1A0B,
	0x3FD4DD2F,0x1A9FBE77, 0x3FD5409F,0xB0222F9E,
	0x3FD4ED91,0x6872B021, 0x3FD551F5,0x2DE18B1A,
	0x3FD4FDF3,0xB645A1CB, 0x3FD5634C,0x4BA73707,
	0x3FD50E56,0x04189375, 0x3FD574A5,0x0B2E8781,
	0x3FD51EB8,0x51EB851F, 0x3FD585FF,0x6E341C3E,
	0x3FD52F1A,0x9FBE76C9, 0x3FD5975B,0x7675E288,
	0x3FD53F7C,0xED916873, 0x3FD5A8B9,0x25B31747,
	0x3FD54FDF,0x3B645A1D, 0x3FD5BA18,0x7DAC4905,
	0x3FD56041,0x89374BC7, 0x3FD5CB79,0x802359FD,
	0x3FD570A3,0xD70A3D71, 0x3FD5DCDC,0x2EDB8227,
	0x3FD58106,0x24DD2F1B, 0x3FD5EE40,0x8B99514C,
	0x3FD59168,0x72B020C5, 0x3FD5FFA6,0x9822B118,
	0x3FD5A1CA,0xC083126F, 0x3FD6110E,0x563EE737,
	0x3FD5B22D,0x0E560419, 0x3FD62277,0xC7B6976D,
	0x3FD5C28F,0x5C28F5C3, 0x3FD633E2,0xEE53C5B9,
	0x3FD5D2F1,0xA9FBE76D, 0x3FD6454F,0xCBE1D876,
	0x3FD5E353,0xF7CED917, 0x3FD656BE,0x622D9A83,
	0x3FD5F3B6,0x45A1CAC1, 0x3FD6682E,0xB3053D6D,
	0x3FD60418,0x9374BC6A, 0x3FD679A0,0xC0385B9B,
	0x3FD6147A,0xE147AE14, 0x3FD68B14,0x8B97FA84,
	0x3FD624DD,0x2F1A9FBE, 0x3FD69C8A,0x16F68CDE,
	0x3FD6353F,0x7CED9168, 0x3FD6AE01,0x6427F4DB,
	0x3FD645A1,0xCAC08312, 0x3FD6BF7A,0x75018666,
	0x3FD65604,0x189374BC, 0x3FD6D0F5,0x4B5A095F,
	0x3FD66666,0x66666666, 0x3FD6E271,0xE909BBE4,
	0x3FD676C8,0xB4395810, 0x3FD6F3F0,0x4FEA5496,
	0x3FD6872B,0x020C49BA, 0x3FD70570,0x81D704E5,
	0x3FD6978D,0x4FDF3B64, 0x3FD716F2,0x80AC7B61,
	0x3FD6A7EF,0x9DB22D0E, 0x3FD72876,0x4E48E60C,
	0x3FD6B851,0xEB851EB8, 0x3FD739FB,0xEC8BF4B2,
	0x3FD6C8B4,0x39581062, 0x3FD74B83,0x5D56DB44,
	0x3FD6D916,0x872B020C, 0x3FD75D0C,0xA28C543A,
	0x3FD6E978,0xD4FDF3B6, 0x3FD76E97,0xBE10A2F2,
	0x3FD6F9DB,0x22D0E560, 0x3FD78024,0xB1C9961C,
	0x3FD70A3D,0x70A3D70A, 0x3FD791B3,0x7F9E8A25,
	0x3FD71A9F,0xBE76C8B4, 0x3FD7A344,0x29786BA4,
	0x3FD72B02,0x0C49BA5E, 0x3FD7B4D6,0xB141B9D0,
	0x3FD73B64,0x5A1CAC08, 0x3FD7C66B,0x18E688FA,
	0x3FD74BC6,0xA7EF9DB2, 0x3FD7D801,0x62548508,
	0x3FD75C28,0xF5C28F5C, 0x3FD7E999,0x8F7AF3F6,
	0x3FD76C8B,0x43958106, 0x3FD7FB33,0xA24AB85B,
	0x3FD77CED,0x916872B0, 0x3FD80CCF,0x9CB653F5,
	0x3FD78D4F,0xDF3B645A, 0x3FD81E6D,0x80B1EA32,
	0x3FD79DB2,0x2D0E5604, 0x3FD8300D,0x503342CB,
	0x3FD7AE14,0x7AE147AE, 0x3FD841AF,0x0D31CC53,
	0x3FD7BE76,0xC8B43958, 0x3FD85352,0xB9A69ED6,
	0x3FD7CED9,0x16872B02, 0x3FD864F8,0x578C7E7A,
	0x3FD7DF3B,0x645A1CAC, 0x3FD8769F,0xE8DFDE25,
	0x3FD7EF9D,0xB22D0E56, 0x3FD88849,0x6F9EE222,
	0x3FD80000,0x00000000, 0x3FD899F4,0xEDC962D3,
	0x3FD81062,0x4DD2F1AA, 0x3FD8ABA2,0x6560EF64,
	0x3FD820C4,0x9BA5E354, 0x3FD8BD51,0xD868D083,
	0x3FD83126,0xE978D4FE, 0x3FD8CF03,0x48E60B19,
	0x3FD84189,0x374BC6A8, 0x3FD8E0B6,0xB8DF6312,
	0x3FD851EB,0x851EB852, 0x3FD8F26C,0x2A5D5E1D,
	0x3FD8624D,0xD2F1A9FC, 0x3FD90423,0x9F6A467D,
	0x3FD872B0,0x20C49BA6, 0x3FD915DD,0x1A122DD6,
	0x3FD88312,0x6E978D50, 0x3FD92798,0x9C62F005,
	0x3FD89374,0xBC6A7EFA, 0x3FD93956,0x286C35F7,
	0x3FD8A3D7,0x0A3D70A4, 0x3FD94B15,0xC03F7890,
	0x3FD8B439,0x5810624E, 0x3FD95CD7,0x65F00387,
	0x3FD8C49B,0xA5E353F8, 0x3FD96E9B,0x1B92F859,
	0x3FD8D4FD,0xF3B645A2, 0x3FD98060,0xE33F5132,
	0x3FD8E560,0x4189374C, 0x3FD99228,0xBF0DE3E7,
	0x3FD8F5C2,0x8F5C28F6, 0x3FD9A3F2,0xB11964EC,
	0x3FD90624,0xDD2F1AA0, 0x3FD9B5BE,0xBB7E6A58,
	0x3FD91687,0x2B020C4A, 0x3FD9C78C,0xE05B6EE7,
	0x3FD926E9,0x78D4FDF4, 0x3FD9D95D,0x21D0D50A,
	0x3FD9374B,0xC6A7EF9E, 0x3FD9EB2F,0x8200E9F0,
	0x3FD947AE,0x147AE148, 0x3FD9FD04,0x030FE8A3,
	0x3FD95810,0x624DD2F2, 0x3FDA0EDA,0xA723FD20,
	0x3FD96872,0xB020C49C, 0x3FDA20B3,0x7065477A,
	0x3FD978D4,0xFDF3B646, 0x3FDA328E,0x60FDDF04,
	0x3FD98937,0x4BC6A7F0, 0x3FDA446B,0x7B19D579,
	0x3FD99999,0x9999999A, 0x3FDA564A,0xC0E73A34,
	0x3FD9A9FB,0xE76C8B44, 0x3FDA682C,0x34961D66,
	0x3FD9BA5E,0x353F7CEE, 0x3FDA7A0F,0xD8589358,
	0x3FD9CAC0,0x83126E98, 0x3FDA8BF5,0xAE62B7B0,
	0x3FD9DB22,0xD0E56042, 0x3FDA9DDD,0xB8EAB0BA,
	0x3FD9EB85,0x1EB851EC, 0x3FDAAFC7,0xFA28B2BE,
	0x3FD9FBE7,0x6C8B4396, 0x3FDAC1B4,0x74570353,
	0x3FDA0C49,0xBA5E353F, 0x3FDAD3A3,0x29B1FCC2,
	0x3FDA1CAC,0x083126E9, 0x3FDAE594,0x1C781169,
	0x3FDA2D0E,0x56041893, 0x3FDAF787,0x4EE9CF25,
	0x3FDA3D70,0xA3D70A3D, 0x3FDB097C,0xC349E2C6,
	0x3FDA4DD2,0xF1A9FBE7, 0x3FDB1B74,0x7BDD1B84,
	0x3FDA5E35,0x3F7CED91, 0x3FDB2D6E,0x7AEA6E81,
	0x3FDA6E97,0x8D4FDF3B, 0x3FDB3F6A,0xC2BAFA4F,
	0x3FDA7EF9,0xDB22D0E5, 0x3FDB5169,0x559A0A79,
	0x3FDA8F5C,0x28F5C28F, 0x3FDB636A,0x35D51B17,
	0x3FDA9FBE,0x76C8B439, 0x3FDB756D,0x65BBDC6D,
	0x3FDAB020,0xC49BA5E3, 0x3FDB8772,0xE7A03684,
	0x3FDAC083,0x126E978D, 0x3FDB997A,0xBDD64CD8,
	0x3FDAD0E5,0x60418937, 0x3FDBAB84,0xEAB48206,
	0x3FDAE147,0xAE147AE1, 0x3FDBBD91,0x70937B7F,
	0x3FDAF1A9,0xFBE76C8B, 0x3FDBCFA0,0x51CE254B,
	0x3FDB020C,0x49BA5E35, 0x3FDBE1B1,0x90C1B5C7,
	0x3FDB126E,0x978D4FDF, 0x3FDBF3C5,0x2FCDB179,
	0x3FDB22D0,0xE5604189, 0x3FDC05DB,0x3153EEDD,
	0x3FDB3333,0x33333333, 0x3FDC17F3,0x97B89A42,
	0x3FDB4395,0x810624DD, 0x3FDC2A0E,0x656239AE,
	0x3FDB53F7,0xCED91687, 0x3FDC3C2B,0x9CB9B0C8,
	0x3FDB645A,0x1CAC0831, 0x3FDC4E4B,0x402A44C8,
	0x3FDB74BC,0x6A7EF9DB, 0x3FDC606D,0x5221A074,
	0x3FDB851E,0xB851EB85, 0x3FDC7291,0xD50FD81E,
	0x3FDB9581,0x0624DD2F, 0x3FDC84B8,0xCB676DB1,
	0x3FDBA5E3,0x53F7CED9, 0x3FDC96E2,0x379D54C1,
	0x3FDBB645,0xA1CAC083, 0x3FDCA90E,0x1C28F6A5,
	0x3FDBC6A7,0xEF9DB22D, 0x3FDCBB3C,0x7B843697,
	0x3FDBD70A,0x3D70A3D7, 0x3FDCCD6D,0x582B75E4,
	0x3FDBE76C,0x8B439581, 0x3FDCDFA0,0xB49D9818,
	0x3FDBF7CE,0xD916872B, 0x3FDCF1D6,0x935C073C,
	0x3FDC0831,0x26E978D5, 0x3FDD040E,0xF6EAB81C,
	0x3FDC1893,0x74BC6A7F, 0x3FDD1649,0xE1D02E8E,
	0x3FDC28F5,0xC28F5C29, 0x3FDD2887,0x569581CA,
	0x3FDC3958,0x10624DD3, 0x3FDD3AC7,0x57C660C6,
	0x3FDC49BA,0x5E353F7D, 0x3FDD4D09,0xE7F116A0,
	0x3FDC5A1C,0xAC083127, 0x3FDD5F4F,0x09A68F0A,
	0x3FDC6A7E,0xF9DB22D1, 0x3FDD7196,0xBF7A5AC0,
	0x3FDC7AE1,0x47AE147B, 0x3FDD83E1,0x0C02B412,
	0x3FDC8B43,0x95810625, 0x3FDD962D,0xF1D88366,
	0x3FDC9BA5,0xE353F7CF, 0x3FDDA87D,0x739763D1,
	0x3FDCAC08,0x3126E979, 0x3FDDBACF,0x93DDA7B4,
	0x3FDCBC6A,0x7EF9DB23, 0x3FDDCD24,0x554C5D61,
	0x3FDCCCCC,0xCCCCCCCD, 0x3FDDDF7B,0xBA8753CD,
	0x3FDCDD2F,0x1A9FBE77, 0x3FDDF1D5,0xC6351F4B,
	0x3FDCED91,0x6872B021, 0x3FDE0432,0x7AFF1E4E,
	0x3FDCFDF3,0xB645A1CB, 0x3FDE1691,0xDB917E3A,
	0x3FDD0E56,0x04189375, 0x3FDE28F3,0xEA9B4038,
	0x3FDD1EB8,0x51EB851F, 0x3FDE3B58,0xAACE3E1C,
	0x3FDD2F1A,0x9FBE76C9, 0x3FDE4DC0,0x1EDF2F50,
	0x3FDD3F7C,0xED916873, 0x3FDE602A,0x4985ADC6,
	0x3FDD4FDF,0x3B645A1D, 0x3FDE7297,0x2D7C3B02,
	0x3FDD6041,0x89374BC7, 0x3FDE8506,0xCD80451E,
	0x3FDD70A3,0xD70A3D71, 0x3FDE9779,0x2C522BE1,
	0x3FDD8106,0x24DD2F1B, 0x3FDEA9EE,0x4CB545E5,
	0x3FDD9168,0x72B020C5, 0x3FDEBC66,0x316FE5BB,
	0x3FDDA1CA,0xC083126F, 0x3FDECEE0,0xDD4B5F29,
	0x3FDDB22D,0x0E560419, 0x3FDEE15E,0x53140C65,
	0x3FDDC28F,0x5C28F5C3, 0x3FDEF3DE,0x95995367,
	0x3FDDD2F1,0xA9FBE76D, 0x3FDF0661,0xA7ADAB3F,
	0x3FDDE353,0xF7CED917, 0x3FDF18E7,0x8C26A177,
	0x3FDDF3B6,0x45A1CAC1, 0x3FDF2B70,0x45DCDF86,
	0x3FDE0418,0x9374BC6A, 0x3FDF3DFB,0xD7AC3045,
	0x3FDE147A,0xE147AE14, 0x3FDF508A,0x4473857E,
	0x3FDE24DD,0x2F1A9FBE, 0x3FDF631B,0x8F14FD74,
	0x3FDE353F,0x7CED9168, 0x3FDF75AF,0xBA75E889,
	0x3FDE45A1,0xCAC08312, 0x3FDF8846,0xC97ECEE6,
	0x3FDE5604,0x189374BC, 0x3FDF9AE0,0xBF1B7632,
	0x3FDE6666,0x66666666, 0x3FDFAD7D,0x9E3AE753,
	0x3FDE76C8,0xB4395810, 0x3FDFC01D,0x69CF7443,
	0x3FDE872B,0x020C49BA, 0x3FDFD2C0,0x24CEBDE8,
	0x3FDE978D,0x4FDF3B64, 0x3FDFE565,0xD231B9FC,
	0x3FDEA7EF,0x9DB22D0E, 0x3FDFF80E,0x74F4B90A,
	0x3FDEB851,0xEB851EB8, 0x3FE0055D,0x080BB634,
	0x3FDEC8B4,0x39581062, 0x3FE00EB4,0x534E7628,
	0x3FDED916,0x872B020C, 0x3FE0180D,0x1DC5DEFB,
	0x3FDEE978,0xD4FDF3B6, 0x3FE02167,0x68F6ECDE,
	0x3FDEF9DB,0x22D0E560, 0x3FE02AC3,0x366858B1,
	0x3FDF0A3D,0x70A3D70A, 0x3FE03420,0x87A29B28,
	0x3FDF1A9F,0xBE76C8B4, 0x3FE03D7F,0x5E2FEFF9,
	0x3FDF2B02,0x0C49BA5E, 0x3FE046DF,0xBB9C5905,
	0x3FDF3B64,0x5A1CAC08, 0x3FE05041,0xA175A199,
	0x3FDF4BC6,0xA7EF9DB2, 0x3FE059A5,0x114B61AA,
	0x3FDF5C28,0xF5C28F5C, 0x3FE0630A,0x0CAF011A,
	0x3FDF6C8B,0x43958106, 0x3FE06C70,0x9533BB0B,
	0x3FDF7CED,0x916872B0, 0x3FE075D8,0xAC6EA12F,
	0x3FDF8D4F,0xDF3B645A, 0x3FE07F42,0x53F69F2A,
	0x3FDF9DB2,0x2D0E5604, 0x3FE088AD,0x8D647DF6,
	0x3FDFAE14,0x7AE147AE, 0x3FE0921A,0x5A52E74D,
	0x3FDFBE76,0xC8B43958, 0x3FE09B88,0xBC5E691F,
	0x3FDFCED9,0x16872B02, 0x3FE0A4F8,0xB525790F,
	0x3FDFDF3B,0x645A1CAC, 0x3FE0AE6A,0x464877F6,
	0x3FDFEF9D,0xB22D0E56, 0x3FE0B7DD,0x7169B56D,
	0x3FE00000,0x00000000, 0x3FE0C152,0x382D7366,
	0x3FE00831,0x26E978D5, 0x3FE0CAC8,0x9C39E9C3,
	0x3FE01062,0x4DD2F1AA, 0x3FE0D440,0x9F374A01,
	0x3FE01893,0x74BC6A7F, 0x3FE0DDBA,0x42CFC2DD,
	0x3FE020C4,0x9BA5E354, 0x3FE0E735,0x88AF8411,
	0x3FE028F5,0xC28F5C29, 0x3FE0F0B2,0x7284C20E,
	0x3FE03126,0xE978D4FE, 0x3FE0FA31,0x01FFB9C4,
	0x3FE03958,0x10624DD3, 0x3FE103B1,0x38D2B46F,
	0x3FE04189,0x374BC6A8, 0x3FE10D33,0x18B20B76,
	0x3FE049BA,0x5E353F7D, 0x3FE116B6,0xA3542C44,
	0x3FE051EB,0x851EB852, 0x3FE1203B,0xDA719C39,
	0x3FE05A1C,0xAC083127, 0x3FE129C2,0xBFC4FC99,
	0x3FE0624D,0xD2F1A9FC, 0x3FE1334B,0x550B0E8D,
	0x3FE06A7E,0xF9DB22D1, 0x3FE13CD5,0x9C02B724,
	0x3FE072B0,0x20C49BA6, 0x3FE14661,0x966D0369,
	0x3FE07AE1,0x47AE147B, 0x3FE14FEF,0x460D2C77,
	0x3FE08312,0x6E978D50, 0x3FE1597E,0xACA89B9D,
	0x3FE08B43,0x95810625, 0x3FE1630F,0xCC06EE90,
	0x3FE09374,0xBC6A7EFA, 0x3FE16CA2,0xA5F1FB98,
	0x3FE09BA5,0xE353F7CF, 0x3FE17637,0x3C35D5DB,
	0x3FE0A3D7,0x0A3D70A4, 0x3FE17FCD,0x90A0D19F,
	0x3FE0AC08,0x3126E979, 0x3FE18965,0xA50388A6,
	0x3FE0B439,0x5810624E, 0x3FE192FF,0x7B30DE8A,
	0x3FE0BC6A,0x7EF9DB23, 0x3FE19C9B,0x14FE0527,
	0x3FE0C49B,0xA5E353F8, 0x3FE1A638,0x74428112,
	0x3FE0CCCC,0xCCCCCCCD, 0x3FE1AFD7,0x9AD82E15,
	0x3FE0D4FD,0xF3B645A2, 0x3FE1B978,0x8A9B43BC,
	0x3FE0DD2F,0x1A9FBE77, 0x3FE1C31B,0x456A59EB,
	0x3FE0E560,0x4189374C, 0x3FE1CCBF,0xCD266D7A,
	0x3FE0ED91,0x6872B021, 0x3FE1D666,0x23B2E4E6,
	0x3FE0F5C2,0x8F5C28F6, 0x3FE1E00E,0x4AF59504,
	0x3FE0FDF3,0xB645A1CB, 0x3FE1E9B8,0x44D6C5C5,
	0x3FE10624,0xDD2F1AA0, 0x3FE1F364,0x13413706,
	0x3FE10E56,0x04189375, 0x3FE1FD11,0xB8222568,
	0x3FE11687,0x2B020C4A, 0x3FE206C1,0x35694F36,
	0x3FE11EB8,0x51EB851F, 0x3FE21072,0x8D08F957,
	0x3FE126E9,0x78D4FDF4, 0x3FE21A25,0xC0F5F44E,
	0x3FE12F1A,0x9FBE76C9, 0x3FE223DA,0xD327A144,
	0x3FE1374B,0xC6A7EF9E, 0x3FE22D91,0xC597F71C,
	0x3FE13F7C,0xED916873, 0x3FE2374A,0x9A43879E,
	0x3FE147AE,0x147AE148, 0x3FE24105,0x5329849F,
	0x3FE14FDF,0x3B645A1D, 0x3FE24AC1,0xF24BC545,
	0x3FE15810,0x624DD2F2, 0x3FE25480,0x79AECB4F,
	0x3FE16041,0x89374BC7, 0x3FE25E40,0xEB59C86E,
	0x3FE16872,0xB020C49C, 0x3FE26803,0x4956A3AB,
	0x3FE170A3,0xD70A3D71, 0x3FE271C7,0x95B1FED8,
	0x3FE178D4,0xFDF3B646, 0x3FE27B8D,0xD27B3C12,
	0x3FE18106,0x24DD2F1B, 0x3FE28556,0x01C48353,
	0x3FE18937,0x4BC6A7F0, 0x3FE28F20,0x25A2C808,
	0x3FE19168,0x72B020C5, 0x3FE298EC,0x402DCEC3,
	0x3FE19999,0x9999999A, 0x3FE2A2BA,0x538032F0,
	0x3FE1A1CA,0xC083126F, 0x3FE2AC8A,0x61B76CA2,
	0x3FE1A9FB,0xE76C8B44, 0x3FE2B65C,0x6CF3D665,
	0x3FE1B22D,0x0E560419, 0x3FE2C030,0x7758B327,
	0x3FE1BA5E,0x353F7CEE, 0x3FE2CA06,0x830C342F,
	0x3FE1C28F,0x5C28F5C3, 0x3FE2D3DE,0x92377F1C,
	0x3FE1CAC0,0x83126E98, 0x3FE2DDB8,0xA706B400,
	0x3FE1D2F1,0xA9FBE76D, 0x3FE2E794,0xC3A8F37F,
	0x3FE1DB22,0xD0E56042, 0x3FE2F172,0xEA506507,
	0x3FE1E353,0xF7CED917, 0x3FE2FB53,0x1D323D10,
	0x3FE1EB85,0x1EB851EC, 0x3FE30535,0x5E86C374,
	0x3FE1F3B6,0x45A1CAC1, 0x3FE30F19,0xB08959D2,
	0x3FE1FBE7,0x6C8B4396, 0x3FE31900,0x15788205,
	0x3FE20418,0x9374BC6A, 0x3FE322E8,0x8F95E4A8,
	0x3FE20C49,0xBA5E353F, 0x3FE32CD3,0x212657B5,
	0x3FE2147A,0xE147AE14, 0x3FE336BF,0xCC71E526,
	0x3FE21CAC,0x083126E9, 0x3FE340AE,0x93C3D1B5,
	0x3FE224DD,0x2F1A9FBE, 0x3FE34A9F,0x796AA3A7,
	0x3FE22D0E,0x56041893, 0x3FE35492,0x7FB829AD,
	0x3FE2353F,0x7CED9168, 0x3FE35E87,0xA90181D3,
	0x3FE23D70,0xA3D70A3D, 0x3FE3687E,0xF79F2084,
	0x3FE245A1,0xCAC08312, 0x3FE37278,0x6DECD7A5,
	0x3FE24DD2,0xF1A9FBE7, 0x3FE37C74,0x0E49DDB7,
	0x3FE25604,0x189374BC, 0x3FE38671,0xDB18D51C,
	0x3FE25E35,0x3F7CED91, 0x3FE39071,0xD6BFD362,
	0x3FE26666,0x66666666, 0x3FE39A74,0x03A868A8,
	0x3FE26E97,0x8D4FDF3B, 0x3FE3A478,0x643FA71A,
	0x3FE276C8,0xB4395810, 0x3FE3AE7E,0xFAF62A78,
	0x3FE27EF9,0xDB22D0E5, 0x3FE3B887,0xCA401FBC,
	0x3FE2872B,0x020C49BA, 0x3FE3C292,0xD4954CCF,
	0x3FE28F5C,0x28F5C28F, 0x3FE3CCA0,0x1C711851,
	0x3FE2978D,0x4FDF3B64, 0x3FE3D6AF,0xA452917E,
	0x3FE29FBE,0x76C8B439, 0x3FE3E0C1,0x6EBC781F,
	0x3FE2A7EF,0x9DB22D0E, 0x3FE3EAD5,0x7E35449C,
	0x3FE2B020,0xC49BA5E3, 0x3FE3F4EB,0xD547301B,
	0x3FE2B851,0xEB851EB8, 0x3FE3FF04,0x76803CB7,
	0x3FE2C083,0x126E978D, 0x3FE4091F,0x64723DD4,
	0x3FE2C8B4,0x39581062, 0x3FE4133C,0xA1B2E084,
	0x3FE2D0E5,0x60418937, 0x3FE41D5C,0x30DBB404,
	0x3FE2D916,0x872B020C, 0x3FE4277E,0x148A3254,
	0x3FE2E147,0xAE147AE1, 0x3FE431A2,0x4F5FC8E4,
	0x3FE2E978,0xD4FDF3B6, 0x3FE43BC8,0xE401E15B,
	0x3FE2F1A9,0xFBE76C8B, 0x3FE445F1,0xD519EA76,
	0x3FE2F9DB,0x22D0E560, 0x3FE4501D,0x25556101,
	0x3FE3020C,0x49BA5E35, 0x3FE45A4A,0xD765D8E8,
	0x3FE30A3D,0x70A3D70A, 0x3FE4647A,0xEE010664,
	0x3FE3126E,0x978D4FDF, 0x3FE46EAD,0x6BE0C73D,
	0x3FE31A9F,0xBE76C8B4, 0x3FE478E2,0x53C32C2F,
	0x3FE322D0,0xE5604189, 0x3FE48319,0xA86A8260,
	0x3FE32B02,0x0C49BA5E, 0x3FE48D53,0x6C9D5CFC,
	0x3FE33333,0x33333333, 0x3FE4978F,0xA3269EE1,
	0x3FE33B64,0x5A1CAC08, 0x3FE4A1CE,0x4ED5846E,
	0x3FE34395,0x810624DD, 0x3FE4AC0F,0x727DAD70,
	0x3FE34BC6,0xA7EF9DB2, 0x3FE4B653,0x10F72725,
	0x3FE353F7,0xCED91687, 0x3FE4C099,0x2D1E7661,
	0x3FE35C28,0xF5C28F5C, 0x3FE4CAE1,0xC9D4A1D2,
	0x3FE3645A,0x1CAC0831, 0x3FE4D52C,0xE9FF3C59,
	0x3FE36C8B,0x43958106, 0x3FE4DF7A,0x90886F8F,
	0x3FE374BC,0x6A7EF9DB, 0x3FE4E9CA,0xC05F065D,
	0x3FE37CED,0x916872B0, 0x3FE4F41D,0x7C7677B7,
	0x3FE3851E,0xB851EB85, 0x3FE4FE72,0xC7C6F17A,
	0x3FE38D4F,0xDF3B645A, 0x3FE508CA,0xA54D6367,
	0x3FE39581,0x0624DD2F, 0x3FE51325,0x180B8A3C,
	0x3FE39DB2,0x2D0E5604, 0x3FE51D82,0x2307FAF7,
	0x3FE3A5E3,0x53F7CED9, 0x3FE527E1,0xC94E2E2C,
	0x3FE3AE14,0x7AE147AE, 0x3FE53244,0x0DEE8B8E,
	0x3FE3B645,0xA1CAC083, 0x3FE53CA8,0xF3FE758E,
	0x3FE3BE76,0xC8B43958, 0x3FE54710,0x7E98551D,
	0x3FE3C6A7,0xEF9DB22D, 0x3FE5517A,0xB0DBA59F,
	0x3FE3CED9,0x16872B02, 0x3FE55BE7,0x8DED00F0,
	0x3FE3D70A,0x3D70A3D7, 0x3FE56657,0x18F62B97,
	0x3FE3DF3B,0x645A1CAC, 0x3FE570C9,0x55262123,
	0x3FE3E76C,0x8B439581, 0x3FE57B3E,0x45B1209E,
	0x3FE3EF9D,0xB22D0E56, 0x3FE585B5,0xEDD0B938,
	0x3FE3F7CE,0xD916872B, 0x3FE59030,0x50C3D70B,
	0x3FE40000,0x00000000, 0x3FE59AAD,0x71CED00F,
	0x3FE40831,0x26E978D5, 0x3FE5A52D,0x543B712E,
	0x3FE41062,0x4DD2F1AA, 0x3FE5AFAF,0xFB590B87,
	0x3FE41893,0x74BC6A7F, 0x3FE5BA35,0x6A7C81DB,
	0x3FE420C4,0x9BA5E354, 0x3FE5C4BD,0xA500561A,
	0x3FE428F5,0xC28F5C29, 0x3FE5CF48,0xAE44B724,
	0x3FE43126,0xE978D4FE, 0x3FE5D9D6,0x89AF8EB3,
	0x3FE43958,0x10624DD3, 0x3FE5E467,0x3AAC8F68,
	0x3FE44189,0x374BC6A8, 0x3FE5EEFA,0xC4AD4315,
	0x3FE449BA,0x5E353F7D, 0x3FE5F991,0x2B291922,
	0x3FE451EB,0x851EB852, 0x3FE6042A,0x719D752A,
	0x3FE45A1C,0xAC083127, 0x3FE60EC6,0x9B8DBDC2,
	0x3FE4624D,0xD2F1A9FC, 0x3FE61965,0xAC836B74,
	0x3FE46A7E,0xF9DB22D1, 0x3FE62407,0xA80E17E3,
	0x3FE472B0,0x20C49BA6, 0x3FE62EAC,0x91C38D21,
	0x3FE47AE1,0x47AE147B, 0x3FE63954,0x6D3FD53B,
	0x3FE48312,0x6E978D50, 0x3FE643FF,0x3E2549F0,
	0x3FE48B43,0x95810625, 0x3FE64EAD,0x081CA49F,
	0x3FE49374,0xBC6A7EFA, 0x3FE6595D,0xCED50E67,
	0x3FE49BA5,0xE353F7CF, 0x3FE66411,0x9604307C,
	0x3FE4A3D7,0x0A3D70A4, 0x3FE66EC8,0x616644AC,
	0x3FE4AC08,0x3126E979, 0x3FE67982,0x34BE2623,
	0x3FE4B439,0x5810624E, 0x3FE6843F,0x13D5625F,
	0x3FE4BC6A,0x7EF9DB23, 0x3FE68EFF,0x027C4A59,
	0x3FE4C49B,0xA5E353F8, 0x3FE699C2,0x048A03F0,
	0x3FE4CCCC,0xCCCCCCCD, 0x3FE6A488,0x1DDC9B84,
	0x3FE4D4FD,0xF3B645A2, 0x3FE6AF51,0x525915CE,
	0x3FE4DD2F,0x1A9FBE77, 0x3FE6BA1D,0xA5EB81F9,
	0x3FE4E560,0x4189374C, 0x3FE6C4ED,0x1C870BE7,
	0x3FE4ED91,0x6872B021, 0x3FE6CFBF,0xBA260ECA,
	0x3FE4F5C2,0x8F5C28F6, 0x3FE6DA95,0x82CA27E4,
	0x3FE4FDF3,0xB645A1CB, 0x3FE6E56E,0x7A7C4996,
	0x3FE50624,0xDD2F1AA0, 0x3FE6F04A,0xA54CCEA8,
	0x3FE50E56,0x04189375, 0x3FE6FB2A,0x07538DD3,
	0x3FE51687,0x2B020C4A, 0x3FE7060C,0xA4AFED8A,
	0x3FE51EB8,0x51EB851F, 0x3FE710F2,0x8188F80D,
	0x3FE526E9,0x78D4FDF4, 0x3FE71BDB,0xA20D6FBC,
	0x3FE52F1A,0x9FBE76C9, 0x3FE726C8,0x0A73E3AC,
	0x3FE5374B,0xC6A7EF9E, 0x3FE731B7,0xBEFAC489,
	0x3FE53F7C,0xED916873, 0x3FE73CAA,0xC3E879B9,
	0x3FE547AE,0x147AE148, 0x3FE747A1,0x1D8B76D0,
	0x3FE54FDF,0x3B645A1D, 0x3FE7529A,0xD03A5143,
	0x3FE55810,0x624DD2F2, 0x3FE75D97,0xE053D66E,
	0x3FE56041,0x89374BC7, 0x3FE76898,0x523F21E6,
	0x3FE56872,0xB020C49C, 0x3FE7739C,0x2A6BB415,
	0x3FE570A3,0xD70A3D71, 0x3FE77EA3,0x6D518926,
	0x3FE578D4,0xFDF3B646, 0x3FE789AE,0x1F713044,
	0x3FE58106,0x24DD2F1B, 0x3FE794BC,0x4553E327,
	0x3FE58937,0x4BC6A7F0, 0x3FE79FCD,0xE38B9DF4,
	0x3FE59168,0x72B020C5, 0x3FE7AAE2,0xFEB33776,
	0x3FE59999,0x9999999A, 0x3FE7B5FB,0x9B6E79A7,
	0x3FE5A1CA,0xC083126F, 0x3FE7C117,0xBE6A3A94,
	0x3FE5A9FB,0xE76C8B44, 0x3FE7CC37,0x6C5C7597,
	0x3FE5B22D,0x0E560419, 0x3FE7D75A,0xAA0464ED,
	0x3FE5BA5E,0x353F7CEE, 0x3FE7E281,0x7C2A9BA9,
	0x3FE5C28F,0x5C28F5C3, 0x3FE7EDAB,0xE7A11FFE,
	0x3FE5CAC0,0x83126E98, 0x3FE7F8D9,0xF14385F3,
	0x3FE5D2F1,0xA9FBE76D, 0x3FE8040B,0x9DF70A6C,
	0x3FE5DB22,0xD0E56042, 0x3FE80F40,0xF2AAAE9E,
	0x3FE5E353,0xF7CED917, 0x3FE81A79,0xF45753DE,
	0x3FE5EB85,0x1EB851EC, 0x3FE825B6,0xA7FFD7E1,
	0x3FE5F3B6,0x45A1CAC1, 0x3FE830F7,0x12B1315B,
	0x3FE5FBE7,0x6C8B4396, 0x3FE83C3B,0x39828D0A,
	0x3FE60418,0x9374BC6A, 0x3FE84783,0x21956B28,
	0x3FE60C49,0xBA5E353F, 0x3FE852CE,0xD015BD5A,
	0x3FE6147A,0xE147AE14, 0x3FE85E1E,0x4A3A04F1,
	0x3FE61CAC,0x083126E9, 0x3FE86971,0x954371BB,
	0x3FE624DD,0x2F1A9FBE, 0x3FE874C8,0xB67E0131,
	0x3FE62D0E,0x56041893, 0x3FE88023,0xB3409E26,
	0x3FE6353F,0x7CED9168, 0x3FE88B82,0x90ED40E7,
	0x3FE63D70,0xA3D70A3D, 0x3FE896E5,0x54F10FD7,
	0x3FE645A1,0xCAC08312, 0x3FE8A24C,0x04C48085,
	0x3FE64DD2,0xF1A9FBE7, 0x3FE8ADB6,0xA5EB7943,
	0x3FE65604,0x189374BC, 0x3FE8B925,0x3DF57336,
	0x3FE65E35,0x3F7CED91, 0x3FE8C497,0xD27D9CF4,
	0x3FE66666,0x66666666, 0x3FE8D00E,0x692AFD95,
	0x3FE66E97,0x8D4FDF3B, 0x3FE8DB89,0x07B09862,
	0x3FE676C8,0xB4395810, 0x3FE8E707,0xB3CD90F6,
	0x3FE67EF9,0xDB22D0E5, 0x3FE8F28A,0x734D4FFE,
	0x3FE6872B,0x020C49BA, 0x3FE8FE11,0x4C07A87F,
	0x3FE68F5C,0x28F5C28F, 0x3FE9099C,0x43E0FDAC,
	0x3FE6978D,0x4FDF3B64, 0x3FE9152B,0x60CA6955,
	0x3FE69FBE,0x76C8B439, 0x3FE920BE,0xA8C1E2EC,
	0x3FE6A7EF,0x9DB22D0E, 0x3FE92C56,0x21D2671E,
	0x3FE6B020,0xC49BA5E3, 0x3FE937F1,0xD2142015,
	0x3FE6B851,0xEB851EB8, 0x3FE94391,0xBFAC8E4B,
	0x3FE6C083,0x126E978D, 0x3FE94F35,0xF0CEB20B,
	0x3FE6C8B4,0x39581062, 0x3FE95ADE,0x6BBB3591,
	0x3FE6D0E5,0x60418937, 0x3FE9668B,0x36C097D6,
	0x3FE6D916,0x872B020C, 0x3FE9723C,0x583B580B,
	0x3FE6E147,0xAE147AE1, 0x3FE97DF1,0xD69621BC,
	0x3FE6E978,0xD4FDF3B6, 0x3FE989AB,0xB849F9AC,
	0x3FE6F1A9,0xFBE76C8B, 0x3FE9956A,0x03DE6B66,
	0x3FE6F9DB,0x22D0E560, 0x3FE9A12C,0xBFE9B786,
	0x3FE7020C,0x49BA5E35, 0x3FE9ACF3,0xF31102C5,
	0x3FE70A3D,0x70A3D70A, 0x3FE9B8BF,0xA40885BD,
	0x3FE7126E,0x978D4FDF, 0x3FE9C48F,0xD993BD7C,
	0x3FE71A9F,0xBE76C8B4, 0x3FE9D064,0x9A859CDB,
	0x3FE722D0,0xE5604189, 0x3FE9DC3D,0xEDC0BEA1,
	0x3FE72B02,0x0C49BA5E, 0x3FE9E81B,0xDA379879,
	0x3FE73333,0x33333333, 0x3FE9F3FE,0x66ECAEC0,
	0x3FE73B64,0x5A1CAC08, 0x3FE9FFE5,0x9AF2C925,
	0x3FE74395,0x810624DD, 0x3FEA0BD1,0x7D6D282F,
	0x3FE74BC6,0xA7EF9DB2, 0x3FEA17C2,0x158FBB9F,
	0x3FE753F7,0xCED91687, 0x3FEA23B7,0x6A9F59C1,
	0x3FE75C28,0xF5C28F5C, 0x3FEA2FB1,0x83F1F79C,
	0x3FE7645A,0x1CAC0831, 0x3FEA3BB0,0x68EEE221,
	0x3FE76C8B,0x43958106, 0x3FEA47B4,0x210EF844,
	0x3FE774BC,0x6A7EF9DB, 0x3FEA53BC,0xB3DCE615,
	0x3FE77CED,0x916872B0, 0x3FEA5FCA,0x28F560D9,
	0x3FE7851E,0xB851EB85, 0x3FEA6BDC,0x88076426,
	0x3FE78D4F,0xDF3B645A, 0x3FEA77F3,0xD8D47006,
	0x3FE79581,0x0624DD2F, 0x3FEA8410,0x2330C836,
	0x3FE79DB2,0x2D0E5604, 0x3FEA9031,0x6F03B46A,
	0x3FE7A5E3,0x53F7CED9, 0x3FEA9C57,0xC447C1B9,
	0x3FE7AE14,0x7AE147AE, 0x3FEAA883,0x2B0B0525,
	0x3FE7B645,0xA1CAC083, 0x3FEAB4B3,0xAB6F5F4F,
	0x3FE7BE76,0xC8B43958, 0x3FEAC0E9,0x4DAAC152,
	0x3FE7C6A7,0xEF9DB22D, 0x3FEACD24,0x1A0772D6,
	0x3FE7CED9,0x16872B02, 0x3FEAD964,0x18E45962,
	0x3FE7D70A,0x3D70A3D7, 0x3FEAE5A9,0x52B540E9,
	0x3FE7DF3B,0x645A1CAC, 0x3FEAF1F3,0xD00325A3,
	0x3FE7E76C,0x8B439581, 0x3FEAFE43,0x996C7F33,
	0x3FE7EF9D,0xB22D0E56, 0x3FEB0A98,0xB7A58D2D,
	0x3FE7F7CE,0xD916872B, 0x3FEB16F3,0x3378A4EC,
	0x3FE80000,0x00000000, 0x3FEB2353,0x15C680DC,
	0x3FE80831,0x26E978D5, 0x3FEB2FB8,0x6786912B,
	0x3FE81062,0x4DD2F1AA, 0x3FEB3C23,0x31C74DF2,
	0x3FE81893,0x74BC6A7F, 0x3FEB4893,0x7DAE8ADB,
	0x3FE820C4,0x9BA5E354, 0x3FEB5509,0x5479CC55,
	0x3FE828F5,0xC28F5C29, 0x3FEB6184,0xBF7E9E4C,
	0x3FE83126,0xE978D4FE, 0x3FEB6E05,0xC82AEC86,
	0x3FE83958,0x10624DD3, 0x3FEB7A8C,0x78055C9B,
	0x3FE84189,0x374BC6A8, 0x3FEB8718,0xD8ADA99C,
	0x3FE849BA,0x5E353F7D, 0x3FEB93AA,0xF3DD016B,
	0x3FE851EB,0x851EB852, 0x3FEBA042,0xD36663DB,
	0x3FE85A1C,0xAC083127, 0x3FEBACE0,0x81370390,
	0x3FE8624D,0xD2F1A9FC, 0x3FEBB984,0x0756A8B8,
	0x3FE86A7E,0xF9DB22D1, 0x3FEBC62D,0x6FE815A6,
	0x3FE872B0,0x20C49BA6, 0x3FEBD2DC,0xC5296D51,
	0x3FE87AE1,0x47AE147B, 0x3FEBDF92,0x11749BCD,
	0x3FE88312,0x6E978D50, 0x3FEBEC4D,0x5F3FC0C3,
	0x3FE88B43,0x95810625, 0x3FEBF90E,0xB91D9BFB,
	0x3FE89374,0xBC6A7EFA, 0x3FEC05D6,0x29BDFBF9,
	0x3FE89BA5,0xE353F7CF, 0x3FEC12A3,0xBBEE2EC8,
	0x3FE8A3D7,0x0A3D70A4, 0x3FEC1F77,0x7A9974F2,
	0x3FE8AC08,0x3126E979, 0x3FEC2C51,0x70C976C4,
	0x3FE8B439,0x5810624E, 0x3FEC3931,0xA9A6BBD0,
	0x3FE8BC6A,0x7EF9DB23, 0x3FEC4618,0x307924E2,
	0x3FE8C49B,0xA5E353F8, 0x3FEC5305,0x10A86850,
	0x3FE8CCCC,0xCCCCCCCD, 0x3FEC5FF8,0x55BC90CC,
	0x3FE8D4FD,0xF3B645A2, 0x3FEC6CF2,0x0B5E7EC5,
	0x3FE8DD2F,0x1A9FBE77, 0x3FEC79F2,0x3D586C5C,
	0x3FE8E560,0x4189374C, 0x3FEC86F8,0xF796740A,
	0x3FE8ED91,0x6872B021, 0x3FEC9406,0x462719FE,
	0x3FE8F5C2,0x8F5C28F6, 0x3FECA11A,0x353BD84C,
	0x3FE8FDF3,0xB645A1CB, 0x3FECAE34,0xD129ADFF,
	0x3FE90624,0xDD2F1AA0, 0x3FECBB56,0x2669B114,
	0x3FE90E56,0x04189375, 0x3FECC87E,0x4199A384,
	0x3FE91687,0x2B020C4A, 0x3FECD5AD,0x2F7C8B65,
	0x3FE91EB8,0x51EB851F, 0x3FECE2E2,0xFCFB4E35,
	0x3FE926E9,0x78D4FDF4, 0x3FECF01F,0xB7254F6B,
	0x3FE92F1A,0x9FBE76C9, 0x3FECFD63,0x6B31125D,
	0x3FE9374B,0xC6A7EF9E, 0x3FED0AAE,0x267CDF99,
	0x3FE93F7C,0xED916873, 0x3FED17FF,0xF68F6DBC,
	0x3FE947AE,0x147AE148, 0x3FED2558,0xE9188DEC,
	0x3FE94FDF,0x3B645A1D, 0x3FED32B9,0x0BF1DC00,
	0x3FE95810,0x624DD2F2, 0x3FED4020,0x6D1F727F,
	0x3FE96041,0x89374BC7, 0x3FED4D8F,0x1AD0A279,
	0x3FE96872,0xB020C49C, 0x3FED5B05,0x2360AF70,
	0x3FE970A3,0xD70A3D71, 0x3FED6882,0x95578F57,
	0x3FE978D4,0xFDF3B646, 0x3FED7607,0x7F6AAECB,
	0x3FE98106,0x24DD2F1B, 0x3FED8393,0xF07DB9A5,
	0x3FE98937,0x4BC6A7F0, 0x3FED9127,0xF7A36800,
	0x3FE99168,0x72B020C5, 0x3FED9EC3,0xA41E4FD7,
	0x3FE99999,0x9999999A, 0x3FEDAC67,0x0561BB50,
	0x3FE9A1CA,0xC083126F, 0x3FEDBA12,0x2B1283E7,
	0x3FE9A9FB,0xE76C8B44, 0x3FEDC7C5,0x2507F286,
	0x3FE9B22D,0x0E560419, 0x3FEDD580,0x034CA4C3,
	0x3FE9BA5E,0x353F7CEE, 0x3FEDE342,0xD61F7756,
	0x3FE9C28F,0x5C28F5C3, 0x3FEDF10D,0xADF475F8,
	0x3FE9CAC0,0x83126E98, 0x3FEDFEE0,0x9B75D0D2,
	0x3FE9D2F1,0xA9FBE76D, 0x3FEE0CBB,0xAF84D79A,
	0x3FE9DB22,0xD0E56042, 0x3FEE1A9E,0xFB3AFA98,
	0x3FE9E353,0xF7CED917, 0x3FEE288A,0x8FEAD1AD,
	0x3FE9EB85,0x1EB851EC, 0x3FEE367E,0x7F212996,
	0x3FE9F3B6,0x45A1CAC1, 0x3FEE447A,0xDAA61791,
	0x3FE9FBE7,0x6C8B4396, 0x3FEE527F,0xB47E139A,
	0x3FEA0418,0x9374BC6A, 0x3FEE608D,0x1EEB196B,
	0x3FEA0C49,0xBA5E353F, 0x3FEE6EA3,0x2C6DD07B,
	0x3FEA147A,0xE147AE14, 0x3FEE7CC1,0xEFC6BB1E,
	0x3FEA1CAC,0x083126E9, 0x3FEE8AE9,0x7BF76D19,
	0x3FEA24DD,0x2F1A9FBE, 0x3FEE9919,0xE443C9CC,
	0x3FEA2D0E,0x56041893, 0x3FEEA753,0x3C334A37,
	0x3FEA353F,0x7CED9168, 0x3FEEB595,0x97924B0F,
	0x3FEA3D70,0xA3D70A3D, 0x3FEEC3E1,0x0A736331,
	0x3FEA45A1,0xCAC08312, 0x3FEED235,0xA930C2A0,
	0x3FEA4DD2,0xF1A9FBE7, 0x3FEEE093,0x886D9A62,
	0x3FEA5604,0x189374BC, 0x3FEEEEFA,0xBD178D7E,
	0x3FEA5E35,0x3F7CED91, 0x3FEEFD6B,0x5C682B5D,
	0x3FEA6666,0x66666666, 0x3FEF0BE5,0x7BE673E1,
	0x3FEA6E97,0x8D4FDF3B, 0x3FEF1A69,0x3168657F,
	0x3FEA76C8,0xB4395810, 0x3FEF28F6,0x931495AB,
	0x3FEA7EF9,0xDB22D0E5, 0x3FEF378D,0xB763D3E9,
	0x3FEA872B,0x020C49BA, 0x3FEF462E,0xB522D7E2,
	0x3FEA8F5C,0x28F5C28F, 0x3FEF54D9,0xA373FACC,
	0x3FEA978D,0x4FDF3B64, 0x3FEF638E,0x99D0FC8C,
	0x3FEA9FBE,0x76C8B439, 0x3FEF724D,0xB00CD4F5,
	0x3FEAA7EF,0x9DB22D0E, 0x3FEF8116,0xFE55917F,
	0x3FEAB020,0xC49BA5E3, 0x3FEF8FEA,0x9D363FF0,
	0x3FEAB851,0xEB851EB8, 0x3FEF9EC8,0xA598E64F,
	0x3FEAC083,0x126E978D, 0x3FEFADB1,0x30C888AA,
	0x3FEAC8B4,0x39581062, 0x3FEFBCA4,0x58733D1A,
	0x3FEAD0E5,0x60418937, 0x3FEFCBA2,0x36AC4E78,
	0x3FEAD916,0x872B020C, 0x3FEFDAAA,0xE5EE6E5B,
	0x3FEAE147,0xAE147AE1, 0x3FEFE9BE,0x811DF6CA,
	0x3FEAE978,0xD4FDF3B6, 0x3FEFF8DD,0x238B3C40,
	0x3FEAF1A9,0xFBE76C8B, 0x3FF00403,0x747A7845,
	0x3FEAF9DB,0x22D0E560, 0x3FF00B9D,0xF6C54B8A,
	0x3FEB020C,0x49BA5E35, 0x3FF0133E,0x26F785A8,
	0x3FEB0A3D,0x70A3D70A, 0x3FF01AE4,0x139D8CE0,
	0x3FEB126E,0x978D4FDF, 0x3FF0228F,0xCB801635,
	0x3FEB1A9F,0xBE76C8B4, 0x3FF02A41,0x5DA585AB,
	0x3FEB22D0,0xE5604189, 0x3FF031F8,0xD95358E8,
	0x3FEB2B02,0x0C49BA5E, 0x3FF039B6,0x4E0F9C9B,
	0x3FEB3333,0x33333333, 0x3FF04179,0xCBA26D0E,
	0x3FEB3B64,0x5A1CAC08, 0x3FF04943,0x62178243,
	0x3FEB4395,0x810624DD, 0x3FF05113,0x21BFC818,
	0x3FEB4BC6,0xA7EF9DB2, 0x3FF058E9,0x1B3302D9,
	0x3FEB53F7,0xCED91687, 0x3FF060C5,0x5F5180BA,
	0x3FEB5C28,0xF5C28F5C, 0x3FF068A7,0xFF45D8BD,
	0x3FEB645A,0x1CAC0831, 0x3FF07091,0x0C86B77A,
	0x3FEB6C8B,0x43958106, 0x3FF07880,0x98D8BA59,
	0x3FEB74BC,0x6A7EF9DB, 0x3FF08076,0xB65059D2,
	0x3FEB7CED,0x916872B0, 0x3FF08873,0x7753E337,
	0x3FEB851E,0xB851EB85, 0x3FF09076,0xEE9D82BB,
	0x3FEB8D4F,0xDF3B645A, 0x3FF09881,0x2F3D5E3E,
	0x3FEB9581,0x0624DD2F, 0x3FF0A092,0x4C9BC1A8,
	0x3FEB9DB2,0x2D0E5604, 0x3FF0A8AA,0x5A7B5D67,
	0x3FEBA5E3,0x53F7CED9, 0x3FF0B0C9,0x6CFB97E2,
	0x3FEBAE14,0x7AE147AE, 0x3FF0B8EF,0x989AF2A0,
	0x3FEBB645,0xA1CAC083, 0x3FF0C11C,0xF23983E3,
	0x3FEBBE76,0xC8B43958, 0x3FF0C951,0x8F1B85AA,
	0x3FEBC6A7,0xEF9DB22D, 0x3FF0D18D,0x84EBFADD,
	0x3FEBCED9,0x16872B02, 0x3FF0D9D0,0xE9BF6BAF,
	0x3FEBD70A,0x3D70A3D7, 0x3FF0E21B,0xD416BA16,
	0x3FEBDF3B,0x645A1CAC, 0x3FF0EA6E,0x5AE20F71,
	0x3FEBE76C,0x8B439581, 0x3FF0F2C8,0x9583E464,
	0x3FEBEF9D,0xB22D0E56, 0x3FF0FB2A,0x9BD42415,
	0x3FEBF7CE,0xD916872B, 0x3FF10394,0x86236BEE,
	0x3FEC0000,0x00000000, 0x3FF10C06,0x6D3E6932,
	0x3FEC0831,0x26E978D5, 0x3FF11480,0x6A7155A6,
	0x3FEC1062,0x4DD2F1AA, 0x3FF11D02,0x978B94C1,
	0x3FEC1893,0x74BC6A7F, 0x3FF1258D,0x0EE372CB,
	0x3FEC20C4,0x9BA5E354, 0x3FF12E1F,0xEB5A0775,
	0x3FEC28F5,0xC28F5C29, 0x3FF136BB,0x485F3D91,
	0x3FEC3126,0xE978D4FE, 0x3FF13F5F,0x41F6019A,
	0x3FEC3958,0x10624DD3, 0x3FF1480B,0xF4B898CD,
	0x3FEC4189,0x374BC6A8, 0x3FF150C1,0x7DDD22D2,
	0x3FEC49BA,0x5E353F7D, 0x3FF1597F,0xFB3A47D9,
	0x3FEC51EB,0x851EB852, 0x3FF16247,0x8B4C155F,
	0x3FEC5A1C,0xAC083127, 0x3FF16B18,0x4D390BD2,
	0x3FEC624D,0xD2F1A9FC, 0x3FF173F2,0x60D75F64,
	0x3FEC6A7E,0xF9DB22D1, 0x3FF17CD5,0xE6B26EA0,
	0x3FEC72B0,0x20C49BA6, 0x3FF185C3,0x0010715C,
	0x3FEC7AE1,0x47AE147B, 0x3FF18EB9,0xCEF862D9,
	0x3FEC8312,0x6E978D50, 0x3FF197BA,0x76382A00,
	0x3FEC8B43,0x95810625, 0x3FF1A0C5,0x196B02EE,
	0x3FEC9374,0xBC6A7EFA, 0x3FF1A9D9,0xDD002D20,
	0x3FEC9BA5,0xE353F7CF, 0x3FF1B2F8,0xE641E1BF,
	0x3FECA3D7,0x0A3D70A4, 0x3FF1BC22,0x5B5C95DA,
	0x3FECAC08,0x3126E979, 0x3FF1C556,0x63668C8A,
	0x3FECB439,0x5810624E, 0x3FF1CE95,0x2667BD32,
	0x3FECBC6A,0x7EF9DB23, 0x3FF1D7DE,0xCD621268,
	0x3FECC49B,0xA5E353F8, 0x3FF1E133,0x825A064D,
	0x3FECCCCC,0xCCCCCCCD, 0x3FF1EA93,0x705FA172,
	0x3FECD4FD,0xF3B645A2, 0x3FF1F3FE,0xC397E1B5,
	0x3FECDD2F,0x1A9FBE77, 0x3FF1FD75,0xA9468EE4,
	0x3FECE560,0x4189374C, 0x3FF206F8,0x4FD88358,
	0x3FECED91,0x6872B021, 0x3FF21086,0xE6EE6F18,
	0x3FECF5C2,0x8F5C28F6, 0x3FF21A21,0x9F681C97,
	0x3FECFDF3,0xB645A1CB, 0x3FF223C8,0xAB703E8F,
	0x3FED0624,0xDD2F1AA0, 0x3FF22D7C,0x3E88CF08,
	0x3FED0E56,0x04189375, 0x3FF2373C,0x8D980826,
	0x3FED1687,0x2B020C4A, 0x3FF24109,0xCEF5FFFF,
	0x3FED1EB8,0x51EB851F, 0x3FF24AE4,0x3A7AF149,
	0x3FED26E9,0x78D4FDF4, 0x3FF254CC,0x098E3B91,
	0x3FED2F1A,0x9FBE76C9, 0x3FF25EC1,0x7736264B,
	0x3FED374B,0xC6A7EF9E, 0x3FF268C4,0xC02872FD,
	0x3FED3F7C,0xED916873, 0x3FF272D6,0x22DBCB9F,
	0x3FED47AE,0x147AE148, 0x3FF27CF5,0xDF9A1B5D,
	0x3FED4FDF,0x3B645A1D, 0x3FF28724,0x3893E0EA,
	0x3FED5810,0x624DD2F2, 0x3FF29161,0x71F48ACB,
	0x3FED6041,0x89374BC7, 0x3FF29BAD,0xD1F7EF57,
	0x3FED6872,0xB020C49C, 0x3FF2A609,0xA100F36A,
	0x3FED70A3,0xD70A3D71, 0x3FF2B075,0x29B1748A,
	0x3FED78D4,0xFDF3B646, 0x3FF2BAF0,0xB9038CBB,
	0x3FED8106,0x24DD2F1B, 0x3FF2C57C,0x9E644835,
	0x3FED8937,0x4BC6A7F0, 0x3FF2D019,0x2BCFE71F,
	0x3FED9168,0x72B020C5, 0x3FF2DAC6,0xB5EFC7C3,
	0x3FED9999,0x9999999A, 0x3FF2E585,0x943A1802,
	0x3FEDA1CA,0xC083126F, 0x3FF2F056,0x21136F98,
	0x3FEDA9FB,0xE76C8B44, 0x3FF2FB38,0xB9F277A0,
	0x3FEDB22D,0x0E560419, 0x3FF3062D,0xBF85C717,
	0x3FEDBA5E,0x353F7CEE, 0x3FF31135,0x95DC1FB8,
	0x3FEDC28F,0x5C28F5C3, 0x3FF31C50,0xA48F3A76,
	0x3FEDCAC0,0x83126E98, 0x3FF3277F,0x56F1575A,
	0x3FEDD2F1,0xA9FBE76D, 0x3FF332C2,0x1C3DC95E,
	0x3FEDDB22,0xD0E56042, 0x3FF33E19,0x67CCBC54,
	0x3FEDE353,0xF7CED917, 0x3FF34985,0xB14A78F0,
	0x3FEDEB85,0x1EB851EC, 0x3FF35507,0x74F271D1,
	0x3FEDF3B6,0x45A1CAC1, 0x3FF3609F,0x33CE6BE0,
	0x3FEDFBE7,0x6C8B4396, 0x3FF36C4D,0x73FA1CBD,
	0x3FEE0418,0x9374BC6A, 0x3FF37812,0xC0EBA374,
	0x3FEE0C49,0xBA5E353F, 0x3FF383EF,0xABC14A22,
	0x3FEE147A,0xE147AE14, 0x3FF38FE4,0xCB950B11,
	0x3FEE1CAC,0x083126E9, 0x3FF39BF2,0xBDD66144,
	0x3FEE24DD,0x2F1A9FBE, 0x3FF3A81A,0x26AAFB55,
	0x3FEE2D0E,0x56041893, 0x3FF3B45B,0xB156F898,
	0x3FEE353F,0x7CED9168, 0x3FF3C0B8,0x10AD6BA6,
	0x3FEE3D70,0xA3D70A3D, 0x3FF3CD2F,0xFF89F36A,
	0x3FEE45A1,0xCAC08312, 0x3FF3D9C4,0x4154546E,
	0x3FEE4DD2,0xF1A9FBE7, 0x3FF3E675,0xA28F1896,
	0x3FEE5604,0x189374BC, 0x3FF3F344,0xF9725BBD,
	0x3FEE5E35,0x3F7CED91, 0x3FF40033,0x2694109F,
	0x3FEE6666,0x66666666, 0x3FF40D41,0x159F3409,
	0x3FEE6E97,0x8D4FDF3B, 0x3FF41A6F,0xBE1B950E,
	0x3FEE76C8,0xB4395810, 0x3FF427C0,0x24481188,
	0x3FEE7EF9,0xDB22D0E5, 0x3FF43533,0x5A096758,
	0x3FEE872B,0x020C49BA, 0x3FF442CA,0x7FF006A1,
	0x3FEE8F5C,0x28F5C28F, 0x3FF45086,0xC657A96B,
	0x3FEE978D,0x4FDF3B64, 0x3FF45E69,0x6EA3DC00,
	0x3FEE9FBE,0x76C8B439, 0x3FF46C73,0xCC9D1A16,
	0x3FEEA7EF,0x9DB22D0E, 0x3FF47AA7,0x47F2B272,
	0x3FEEB020,0xC49BA5E3, 0x3FF48905,0x5DE64A33,
	0x3FEEB851,0xEB851EB8, 0x3FF4978F,0xA3269EE1,
	0x3FEEC083,0x126E978D, 0x3FF4A647,0xC5E011EA,
	0x3FEEC8B4,0x39581062, 0x3FF4B52F,0x900AA16E,
	0x3FEED0E5,0x60418937, 0x3FF4C448,0xE9FE4311,
	0x3FEED916,0x872B020C, 0x3FF4D395,0xDD582B8A,
	0x3FEEE147,0xAE147AE1, 0x3FF4E318,0x983D78B1,
	0x3FEEE978,0xD4FDF3B6, 0x3FF4F2D3,0x710A08DC,
	0x3FEEF1A9,0xFBE76C8B, 0x3FF502C8,0xEA7D247E,
	0x3FEEF9DB,0x22D0E560, 0x3FF512FB,0xB8792022,
	0x3FEF020C,0x49BA5E35, 0x3FF5236E,0xC56F7284,
	0x3FEF0A3D,0x70A3D70A, 0x3FF53425,0x38981EC8,
	0x3FEF126E,0x978D4FDF, 0x3FF54522,0x7D1A13CF,
	0x3FEF1A9F,0xBE76C8B4, 0x3FF5566A,0x4A52A5E6,
	0x3FEF22D0,0xE5604189, 0x3FF56800,0xAD751A8A,
	0x3FEF2B02,0x0C49BA5E, 0x3FF579EA,0x14C91A41,
	0x3FEF3333,0x33333333, 0x3FF58C2B,0x5CE0C3E5,
	0x3FEF3B64,0x5A1CAC08, 0x3FF59EC9,0xE036730A,
	0x3FEF4395,0x810624DD, 0x3FF5B1CB,0x89C1039F,
	0x3FEF4BC6,0xA7EF9DB2, 0x3FF5C536,0xEB363A94,
	0x3FEF53F7,0xCED91687, 0x3FF5D913,0x57E9F7E9,
	0x3FEF5C28,0xF5C28F5C, 0x3FF5ED69,0x0583BE07,
	0x3FEF645A,0x1CAC0831, 0x3FF60241,0x342B8535,
	0x3FEF6C8B,0x43958106, 0x3FF617A6,0x605FB64A,
	0x3FEF74BC,0x6A7EF9DB, 0x3FF62DA4,0x81747299,
	0x3FEF7CED,0x916872B0, 0x3FF64449,0x58E74417,
	0x3FEF851E,0xB851EB85, 0x3FF65BA4,0xD86C24C5,
	0x3FEF8D4F,0xDF3B645A, 0x3FF673C9,0xA7343103,
	0x3FEF9581,0x0624DD2F, 0x3FF68CCD,0xD2F76F29,
	0x3FEF9DB2,0x2D0E5604, 0x3FF6A6CB,0xBFB70F7C,
	0x3FEFA5E3,0x53F7CED9, 0x3FF6C1E3,0x73B93370,
	0x3FEFAE14,0x7AE147AE, 0x3FF6DE3C,0x6F33D51D,
	0x3FEFB645,0xA1CAC083, 0x3FF6FC08,0x5EFE9A01,
	0x3FEFBE76,0xC8B43958, 0x3FF71B87,0x352143E2,
	0x3FEFC6A7,0xEF9DB22D, 0x3FF73D0D,0xA7DF830D,
	0x3FEFCED9,0x16872B02, 0x3FF76110,0x12AB625F,
	0x3FEFD70A,0x3D70A3D7, 0x3FF78835,0xFD4104B3,
	0x3FEFDF3B,0x645A1CAC, 0x3FF7B380,0x8CC4B16A,
	0x3FEFE76C,0x8B439581, 0x3FF7E4A0,0xA9830084,
	0x3FEFEF9D,0xB22D0E56, 0x3FF81EE2,0x80851D99,
	0x3FEFF7CE,0xD916872B, 0x3FF86AC9,0xAD18F803,
	0x3FF00000,0x00000000, 0x3FF921FB,0x54442D18,
	};

LOCAL_D const TUint32 PowerTest[] =
	{
	0x3FE00000,0x00000000, 0x3FB99999,0x9999999A, 0x3FEDDB68,0x0117AB12,
	0x3FE00000,0x00000000, 0x3FC99999,0x9999999A, 0x3FEBDB8C,0xDADBE120,
	0x3FE00000,0x00000000, 0x3FD33333,0x33333333, 0x3FE9FDF8,0xBCCE533E,
	0x3FE00000,0x00000000, 0x3FD99999,0x9999999A, 0x3FE84060,0x03B2AE5C,
	0x3FE00000,0x00000000, 0x3FE00000,0x00000000, 0x3FE6A09E,0x667F3BCD,
	0x3FE00000,0x00000000, 0x3FE33333,0x33333333, 0x3FE51CB4,0x53B9536C,
	0x3FE00000,0x00000000, 0x3FE66666,0x66666666, 0x3FE3B2C4,0x7BFF8329,
	0x3FE00000,0x00000000, 0x3FE99999,0x9999999A, 0x3FE26111,0x86BAE674,
	0x3FE00000,0x00000000, 0x3FECCCCC,0xCCCCCCCD, 0x3FE125FB,0xEE250664,
	0x3FE00000,0x00000000, 0x3FF00000,0x00000000, 0x3FE00000,0x00000000,
	0x3FE00000,0x00000000, 0x3FF19999,0x9999999A, 0x3FDDDB68,0x0117AB12,
	0x3FE00000,0x00000000, 0x3FF33333,0x33333333, 0x3FDBDB8C,0xDADBE120,
	0x3FE00000,0x00000000, 0x3FF4CCCC,0xCCCCCCCD, 0x3FD9FDF8,0xBCCE533D,
	0x3FE00000,0x00000000, 0x3FF66666,0x66666666, 0x3FD84060,0x03B2AE5D,
	0x3FE00000,0x00000000, 0x3FF80000,0x00000000, 0x3FD6A09E,0x667F3BCD,
	0x3FE00000,0x00000000, 0x3FF99999,0x9999999A, 0x3FD51CB4,0x53B9536C,
	0x3FE00000,0x00000000, 0x3FFB3333,0x33333333, 0x3FD3B2C4,0x7BFF8329,
	0x3FE00000,0x00000000, 0x3FFCCCCC,0xCCCCCCCD, 0x3FD26111,0x86BAE674,
	0x3FE00000,0x00000000, 0x3FFE6666,0x66666666, 0x3FD125FB,0xEE250664,
	0x3FE00000,0x00000000, 0x40000000,0x00000000, 0x3FD00000,0x00000000,
	0x3FE33333,0x33333333, 0x3FB99999,0x9999999A, 0x3FEE680A,0x48D16872,
	0x3FE33333,0x33333333, 0x3FC99999,0x9999999A, 0x3FECE465,0x8B654324,
	0x3FE33333,0x33333333, 0x3FD33333,0x33333333, 0x3FEB740E,0xC5D2AA1A,
	0x3FE33333,0x33333333, 0x3FD99999,0x9999999A, 0x3FEA160F,0xDC35D2CB,
	0x3FE33333,0x33333333, 0x3FE00000,0x00000000, 0x3FE8C97E,0xF43F7248,
	0x3FE33333,0x33333333, 0x3FE33333,0x33333333, 0x3FE78D7D,0xD8F4883C,
	0x3FE33333,0x33333333, 0x3FE66666,0x66666666, 0x3FE66139,0x66362A65,
	0x3FE33333,0x33333333, 0x3FE99999,0x9999999A, 0x3FE543E8,0xFBAE1CEA,
	0x3FE33333,0x33333333, 0x3FECCCCC,0xCCCCCCCD, 0x3FE434CD,0xF6C1F4C8,
	0x3FE33333,0x33333333, 0x3FF00000,0x00000000, 0x3FE33333,0x33333333,
	0x3FE33333,0x33333333, 0x3FF19999,0x9999999A, 0x3FE23E6C,0x92173EAA,
	0x3FE33333,0x33333333, 0x3FF33333,0x33333333, 0x3FE155D6,0x86D65B7C,
	0x3FE33333,0x33333333, 0x3FF4CCCC,0xCCCCCCCD, 0x3FE078D5,0xA9E4CC76,
	0x3FE33333,0x33333333, 0x3FF66666,0x66666666, 0x3FDF4DAC,0xA1DA3027,
	0x3FE33333,0x33333333, 0x3FF80000,0x00000000, 0x3FDDBE98,0x584C22BC,
	0x3FE33333,0x33333333, 0x3FF99999,0x9999999A, 0x3FDC4363,0xD1257047,
	0x3FE33333,0x33333333, 0x3FFB3333,0x33333333, 0x3FDADB11,0xADDA9946,
	0x3FE33333,0x33333333, 0x3FFCCCCC,0xCCCCCCCD, 0x3FD984B1,0x2E0422B2,
	0x3FE33333,0x33333333, 0x3FFE6666,0x66666666, 0x3FD83F5D,0x8E8258F0,
	0x3FE33333,0x33333333, 0x40000000,0x00000000, 0x3FD70A3D,0x70A3D70A,
	0x3FE66666,0x66666666, 0x3FB99999,0x9999999A, 0x3FEEE0F6,0x172E7679,
	0x3FE66666,0x66666666, 0x3FC99999,0x9999999A, 0x3FEDCBFA,0xE8202D18,
	0x3FE66666,0x66666666, 0x3FD33333,0x33333333, 0x3FECC0B4,0x3BA5C3D9,
	0x3FE66666,0x66666666, 0x3FD99999,0x9999999A, 0x3FEBBECB,0x03CABB82,
	0x3FE66666,0x66666666, 0x3FE00000,0x00000000, 0x3FEAC5EB,0x3F7AB2F8,
	0x3FE66666,0x66666666, 0x3FE33333,0x33333333, 0x3FE9D5C3,0xDF24FB63,
	0x3FE66666,0x66666666, 0x3FE66666,0x66666666, 0x3FE8EE06,0xAA5599B0,
	0x3FE66666,0x66666666, 0x3FE99999,0x9999999A, 0x3FE80E68,0x263B1BFB,
	0x3FE66666,0x66666666, 0x3FECCCCC,0xCCCCCCCD, 0x3FE7369F,0x7D10F686,
	0x3FE66666,0x66666666, 0x3FF00000,0x00000000, 0x3FE66666,0x66666666,
	0x3FE66666,0x66666666, 0x3FF19999,0x9999999A, 0x3FE59D79,0x103A1FBA,
	0x3FE66666,0x66666666, 0x3FF33333,0x33333333, 0x3FE4DB96,0x08E352C4,
	0x3FE66666,0x66666666, 0x3FF4CCCC,0xCCCCCCCD, 0x3FE4207E,0x29C0D5E5,
	0x3FE66666,0x66666666, 0x3FF66666,0x66666666, 0x3FE36BF4,0x82A78341,
	0x3FE66666,0x66666666, 0x3FF80000,0x00000000, 0x3FE2BDBE,0x460916E0,
	0x3FE66666,0x66666666, 0x3FF99999,0x9999999A, 0x3FE215A2,0xB5CD165E,
	0x3FE66666,0x66666666, 0x3FFB3333,0x33333333, 0x3FE1736B,0x10D5852E,
	0x3FE66666,0x66666666, 0x3FFCCCCC,0xCCCCCCCD, 0x3FE0D6E2,0x81296062,
	0x3FE66666,0x66666666, 0x3FFE6666,0x66666666, 0x3FE03FD6,0x0ABF12F7,
	0x3FE66666,0x66666666, 0x40000000,0x00000000, 0x3FDF5C28,0xF5C28F5B,
	0x3FE99999,0x9999999A, 0x3FB99999,0x9999999A, 0x3FEF4B39,0xA9528405,
	0x3FE99999,0x9999999A, 0x3FC99999,0x9999999A, 0x3FEE9A70,0x8EC1794A,
	0x3FE99999,0x9999999A, 0x3FD33333,0x33333333, 0x3FEDED8E,0x27210DB1,
	0x3FE99999,0x9999999A, 0x3FD99999,0x9999999A, 0x3FED447C,0x6894B361,
	0x3FE99999,0x9999999A, 0x3FE00000,0x00000000, 0x3FEC9F25,0xC5BFEDD9,
	0x3FE99999,0x9999999A, 0x3FE33333,0x33333333, 0x3FEBFD75,0x2B06FDE0,
	0x3FE99999,0x9999999A, 0x3FE66666,0x66666666, 0x3FEB5F55,0xFBDF12BA,
	0x3FE99999,0x9999999A, 0x3FE99999,0x9999999A, 0x3FEAC4B4,0x102DA8F1,
	0x3FE99999,0x9999999A, 0x3FECCCCC,0xCCCCCCCD, 0x3FEA2D7B,0xB1B6C0F1,
	0x3FE99999,0x9999999A, 0x3FF00000,0x00000000, 0x3FE99999,0x9999999A,
	0x3FE99999,0x9999999A, 0x3FF19999,0x9999999A, 0x3FE908FA,0xEDDB9CD1,
	0x3FE99999,0x9999999A, 0x3FF33333,0x33333333, 0x3FE87B8D,0x3F012DD5,
	0x3FE99999,0x9999999A, 0x3FF4CCCC,0xCCCCCCCD, 0x3FE7F13E,0x85B40AF4,
	0x3FE99999,0x9999999A, 0x3FF66666,0x66666666, 0x3FE769FD,0x2076F5E8,
	0x3FE99999,0x9999999A, 0x3FF80000,0x00000000, 0x3FE6E5B7,0xD16657E2,
	0x3FE99999,0x9999999A, 0x3FF99999,0x9999999A, 0x3FE6645D,0xBC0597E7,
	0x3FE99999,0x9999999A, 0x3FFB3333,0x33333333, 0x3FE5E5DE,0x6318DBC8,
	0x3FE99999,0x9999999A, 0x3FFCCCCC,0xCCCCCCCD, 0x3FE56A29,0xA68AED8E,
	0x3FE99999,0x9999999A, 0x3FFE6666,0x66666666, 0x3FE4F12F,0xC15F00C1,
	0x3FE99999,0x9999999A, 0x40000000,0x00000000, 0x3FE47AE1,0x47AE147C,
	0x3FECCCCC,0xCCCCCCCD, 0x3FB99999,0x9999999A, 0x3FEFAA24,0x4A98407A,
	0x3FECCCCC,0xCCCCCCCD, 0x3FC99999,0x9999999A, 0x3FEF552E,0xF248B71D,
	0x3FECCCCC,0xCCCCCCCD, 0x3FD33333,0x33333333, 0x3FEF011D,0x8CFC7493,
	0x3FECCCCC,0xCCCCCCCD, 0x3FD99999,0x9999999A, 0x3FEEADED,0xB718E4D0,
	0x3FECCCCC,0xCCCCCCCD, 0x3FE00000,0x00000000, 0x3FEE5B9D,0x136C6D96,
	0x3FECCCCC,0xCCCCCCCD, 0x3FE33333,0x33333333, 0x3FEE0A29,0x4B1D3B9B,
	0x3FECCCCC,0xCCCCCCCD, 0x3FE66666,0x66666666, 0x3FEDB990,0x0D983DD4,
	0x3FECCCCC,0xCCCCCCCD, 0x3FE99999,0x9999999A, 0x3FED69CF,0x10804E69,
	0x3FECCCCC,0xCCCCCCCD, 0x3FECCCCC,0xCCCCCCCD, 0x3FED1AE4,0x0F9D88D8,
	0x3FECCCCC,0xCCCCCCCD, 0x3FF00000,0x00000000, 0x3FECCCCC,0xCCCCCCCD,
	0x3FECCCCC,0xCCCCCCCD, 0x3FF19999,0x9999999A, 0x3FEC7F87,0x0FEF6D3A,
	0x3FECCCCC,0xCCCCCCCD, 0x3FF33333,0x33333333, 0x3FEC3310,0xA6DB0B34,
	0x3FECCCCC,0xCCCCCCCD, 0x3FF4CCCC,0xCCCCCCCD, 0x3FEBE767,0x65499C1E,
	0x3FECCCCC,0xCCCCCCCD, 0x3FF66666,0x66666666, 0x3FEB9C89,0x24C99ABC,
	0x3FECCCCC,0xCCCCCCCD, 0x3FF80000,0x00000000, 0x3FEB5273,0xC4AE62A1,
	0x3FECCCCC,0xCCCCCCCD, 0x3FF99999,0x9999999A, 0x3FEB0925,0x2A00B5A6,
	0x3FECCCCC,0xCCCCCCCD, 0x3FFB3333,0x33333333, 0x3FEAC09B,0x3F6F6AD9,
	0x3FECCCCC,0xCCCCCCCD, 0x3FFCCCCC,0xCCCCCCCD, 0x3FEA78D3,0xF5404692,
	0x3FECCCCC,0xCCCCCCCD, 0x3FFE6666,0x66666666, 0x3FEA31CD,0x4140FB29,
	0x3FECCCCC,0xCCCCCCCD, 0x40000000,0x00000000, 0x3FE9EB85,0x1EB851EC,
	0x3FF00000,0x00000000, 0x3FB99999,0x9999999A, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FC99999,0x9999999A, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FD33333,0x33333333, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FD99999,0x9999999A, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FE00000,0x00000000, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FE33333,0x33333333, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FE66666,0x66666666, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FE99999,0x9999999A, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FECCCCC,0xCCCCCCCD, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FF00000,0x00000000, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FF19999,0x9999999A, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FF33333,0x33333333, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FF4CCCC,0xCCCCCCCD, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FF66666,0x66666666, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FF80000,0x00000000, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FF99999,0x9999999A, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FFB3333,0x33333333, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FFCCCCC,0xCCCCCCCD, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x3FFE6666,0x66666666, 0x3FF00000,0x00000000,
	0x3FF00000,0x00000000, 0x40000000,0x00000000, 0x3FF00000,0x00000000,
	0x3FF19999,0x9999999A, 0x3FB99999,0x9999999A, 0x3FF02739,0xC65D58BF,
	0x3FF19999,0x9999999A, 0x3FC99999,0x9999999A, 0x3FF04ED3,0xB7325783,
	0x3FF19999,0x9999999A, 0x3FD33333,0x33333333, 0x3FF076CE,0xBE41BF7A,
	0x3FF19999,0x9999999A, 0x3FD99999,0x9999999A, 0x3FF09F2B,0xC99051DD,
	0x3FF19999,0x9999999A, 0x3FE00000,0x00000000, 0x3FF0C7EB,0xC96A56F6,
	0x3FF19999,0x9999999A, 0x3FE33333,0x33333333, 0x3FF0F10F,0xB06934B0,
	0x3FF19999,0x9999999A, 0x3FE66666,0x66666666, 0x3FF11A98,0x737912E1,
	0x3FF19999,0x9999999A, 0x3FE99999,0x9999999A, 0x3FF14487,0x09DE8D69,
	0x3FF19999,0x9999999A, 0x3FECCCCC,0xCCCCCCCD, 0x3FF16EDC,0x6D3C743C,
	0x3FF19999,0x9999999A, 0x3FF00000,0x00000000, 0x3FF19999,0x9999999A,
	0x3FF19999,0x9999999A, 0x3FF19999,0x9999999A, 0x3FF1C4BF,0x8D66AE6C,
	0x3FF19999,0x9999999A, 0x3FF33333,0x33333333, 0x3FF1F04F,0x49842D11,
	0x3FF19999,0x9999999A, 0x3FF4CCCC,0xCCCCCCCD, 0x3FF21C49,0xD14852A0,
	0x3FF19999,0x9999999A, 0x3FF66666,0x66666666, 0x3FF248B0,0x2A8526DA,
	0x3FF19999,0x9999999A, 0x3FF80000,0x00000000, 0x3FF27583,0x5D8E92DC,
	0x3FF19999,0x9999999A, 0x3FF99999,0x9999999A, 0x3FF2A2C4,0x754086C2,
	0x3FF19999,0x9999999A, 0x3FFB3333,0x33333333, 0x3FF2D074,0x7F052E5F,
	0x3FF19999,0x9999999A, 0x3FFCCCCC,0xCCCCCCCD, 0x3FF2FE94,0x8ADB3527,
	0x3FF19999,0x9999999A, 0x3FFE6666,0x66666666, 0x3FF32D25,0xAB5C1976,
	0x3FF19999,0x9999999A, 0x40000000,0x00000000, 0x3FF35C28,0xF5C28F5D,
	0x3FF33333,0x33333333, 0x3FB99999,0x9999999A, 0x3FF04B5D,0x24ED17A4,
	0x3FF33333,0x33333333, 0x3FC99999,0x9999999A, 0x3FF0981D,0x45329B9F,
	0x3FF33333,0x33333333, 0x3FD33333,0x33333333, 0x3FF0E646,0xE8DD42A0,
	0x3FF33333,0x33333333, 0x3FD99999,0x9999999A, 0x3FF135E0,0xB6BD84CD,
	0x3FF33333,0x33333333, 0x3FE00000,0x00000000, 0x3FF186F1,0x74F88472,
	0x3FF33333,0x33333333, 0x3FE33333,0x33333333, 0x3FF1D980,0x099BA149,
	0x3FF33333,0x33333333, 0x3FE66666,0x66666666, 0x3FF22D93,0x7B32C2D3,
	0x3FF33333,0x33333333, 0x3FE99999,0x9999999A, 0x3FF28332,0xF16166A5,
	0x3FF33333,0x33333333, 0x3FECCCCC,0xCCCCCCCD, 0x3FF2DA65,0xB57E7F98,
	0x3FF33333,0x33333333, 0x3FF00000,0x00000000, 0x3FF33333,0x33333333,
	0x3FF33333,0x33333333, 0x3FF19999,0x9999999A, 0x3FF38DA2,0xF91C82C4,
	0x3FF33333,0x33333333, 0x3FF33333,0x33333333, 0x3FF3E9BC,0xB96FEDF1,
	0x3FF33333,0x33333333, 0x3FF4CCCC,0xCCCCCCCD, 0x3FF44788,0x4AA31CC0,
	0x3FF33333,0x33333333, 0x3FF66666,0x66666666, 0x3FF4A70D,0xA8169F5C,
	0x3FF33333,0x33333333, 0x3FF80000,0x00000000, 0x3FF50854,0xF2C3D222,
	0x3FF33333,0x33333333, 0x3FF99999,0x9999999A, 0x3FF56B66,0x71EDF4BE,
	0x3FF33333,0x33333333, 0x3FFB3333,0x33333333, 0x3FF5D04A,0x93D68363,
	0x3FF33333,0x33333333, 0x3FFCCCCC,0xCCCCCCCD, 0x3FF63709,0xEE74E192,
	0x3FF33333,0x33333333, 0x3FFE6666,0x66666666, 0x3FF69FAD,0x403165E9,
	0x3FF33333,0x33333333, 0x40000000,0x00000000, 0x3FF70A3D,0x70A3D70A,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FB99999,0x9999999A, 0x3FF06CE2,0xF530F836,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FC99999,0x9999999A, 0x3FF0DCAA,0xEEE362D8,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FD33333,0x33333333, 0x3FF14F6B,0xA004E4FF,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FD99999,0x9999999A, 0x3FF1C539,0x4192551C,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FE00000,0x00000000, 0x3FF23E28,0x96280F23,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FE33333,0x33333333, 0x3FF2BA4E,0xEDAA8975,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FE66666,0x66666666, 0x3FF339C2,0x2907CFA9,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FE99999,0x9999999A, 0x3FF3BC98,0xBE128C8C,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FECCCCC,0xCCCCCCCD, 0x3FF442E9,0xBB77515D,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FF00000,0x00000000, 0x3FF4CCCC,0xCCCCCCCD,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FF19999,0x9999999A, 0x3FF55A5A,0x3EBFA913,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FF33333,0x33333333, 0x3FF5EBAB,0x035ACD4C,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FF4CCCC,0xCCCCCCCD, 0x3FF680D8,0xB66CC34C,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FF66666,0x66666666, 0x3FF719FD,0xA20B083F,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FF80000,0x00000000, 0x3FF7B734,0xC33413AD,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FF99999,0x9999999A, 0x3FF85899,0xCE90E5E5,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FFB3333,0x33333333, 0x3FF8FE49,0x3556F45B,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FFCCCCC,0xCCCCCCCD, 0x3FF9A860,0x2A4B5050,
	0x3FF4CCCC,0xCCCCCCCD, 0x3FFE6666,0x66666666, 0x3FFA56FC,0xA6E7E9C6,
	0x3FF4CCCC,0xCCCCCCCD, 0x40000000,0x00000000, 0x3FFB0A3D,0x70A3D70B,
	0x3FF66666,0x66666666, 0x3FB99999,0x9999999A, 0x3FF08C29,0xF332A311,
	0x3FF66666,0x66666666, 0x3FC99999,0x9999999A, 0x3FF11D1F,0xC4F3391C,
	0x3FF66666,0x66666666, 0x3FD33333,0x33333333, 0x3FF1B30B,0x79B06DED,
	0x3FF66666,0x66666666, 0x3FD99999,0x9999999A, 0x3FF24E18,0x85EDDFB2,
	0x3FF66666,0x66666666, 0x3FE00000,0x00000000, 0x3FF2EE73,0xDADC9B57,
	0x3FF66666,0x66666666, 0x3FE33333,0x33333333, 0x3FF3944B,0xF361F023,
	0x3FF66666,0x66666666, 0x3FE66666,0x66666666, 0x3FF43FD0,0xE190613D,
	0x3FF66666,0x66666666, 0x3FE99999,0x9999999A, 0x3FF4F134,0x5C969CC0,
	0x3FF66666,0x66666666, 0x3FECCCCC,0xCCCCCCCD, 0x3FF5A8A9,0xCF288250,
	0x3FF66666,0x66666666, 0x3FF00000,0x00000000, 0x3FF66666,0x66666666,
	0x3FF66666,0x66666666, 0x3FF19999,0x9999999A, 0x3FF72AA1,0x2146E44B,
	0x3FF66666,0x66666666, 0x3FF33333,0x33333333, 0x3FF7F592,0xE087B65A,
	0x3FF66666,0x66666666, 0x3FF4CCCC,0xCCCCCCCD, 0x3FF8C776,0x772A337F,
	0x3FF66666,0x66666666, 0x3FF66666,0x66666666, 0x3FF9A088,0xBB80392C,
	0x3FF66666,0x66666666, 0x3FF80000,0x00000000, 0x3FFA8108,0x98CE7313,
	0x3FF66666,0x66666666, 0x3FF99999,0x9999999A, 0x3FFB6937,0x21891CFE,
	0x3FF66666,0x66666666, 0x3FFB3333,0x33333333, 0x3FFC5957,0xA2308822,
	0x3FF66666,0x66666666, 0x3FFCCCCC,0xCCCCCCCD, 0x3FFD51AF,0xB4D2DB73,
	0x3FF66666,0x66666666, 0x3FFE6666,0x66666666, 0x3FFE5287,0x5538B66E,
	0x3FF66666,0x66666666, 0x40000000,0x00000000, 0x3FFF5C28,0xF5C28F5B,
	0x3FF80000,0x00000000, 0x3FB99999,0x9999999A, 0x3FF0A97D,0xCE72A0CB,
	0x3FF80000,0x00000000, 0x3FC99999,0x9999999A, 0x3FF159FF,0x126BAB41,
	0x3FF80000,0x00000000, 0x3FD33333,0x33333333, 0x3FF211CE,0x179A0012,
	0x3FF80000,0x00000000, 0x3FD99999,0x9999999A, 0x3FF2D138,0x3CB414F9,
	0x3FF80000,0x00000000, 0x3FE00000,0x00000000, 0x3FF3988E,0x1409212E,
	0x3FF80000,0x00000000, 0x3FE33333,0x33333333, 0x3FF46823,0x856B4748,
	0x3FF80000,0x00000000, 0x3FE66666,0x66666666, 0x3FF5404F,0xF1810326,
	0x3FF80000,0x00000000, 0x3FE99999,0x9999999A, 0x3FF6216E,0x568CB9A7,
	0x3FF80000,0x00000000, 0x3FECCCCC,0xCCCCCCCD, 0x3FF70BDD,0x76B9E56F,
	0x3FF80000,0x00000000, 0x3FF00000,0x00000000, 0x3FF80000,0x00000000,
	0x3FF80000,0x00000000, 0x3FF19999,0x9999999A, 0x3FF8FE3C,0xB5ABF131,
	0x3FF80000,0x00000000, 0x3FF33333,0x33333333, 0x3FFA06FE,0x9BA180E2,
	0x3FF80000,0x00000000, 0x3FF4CCCC,0xCCCCCCCD, 0x3FFB1AB5,0x2367001B,
	0x3FF80000,0x00000000, 0x3FF66666,0x66666666, 0x3FFC39D4,0x5B0E1F75,
	0x3FF80000,0x00000000, 0x3FF80000,0x00000000, 0x3FFD64D5,0x1E0DB1C6,
	0x3FF80000,0x00000000, 0x3FF99999,0x9999999A, 0x3FFE9C35,0x4820EAED,
	0x3FF80000,0x00000000, 0x3FFB3333,0x33333333, 0x3FFFE077,0xEA4184BA,
	0x3FF80000,0x00000000, 0x3FFCCCCC,0xCCCCCCCD, 0x40009912,0xC0E98B3D,
	0x3FF80000,0x00000000, 0x3FFE6666,0x66666666, 0x400148E6,0x190B6C13,
	0x3FF80000,0x00000000, 0x40000000,0x00000000, 0x40020000,0x00000000,
	0x3FF99999,0x9999999A, 0x3FB99999,0x9999999A, 0x3FF0C51B,0xFB8F97C0,
	0x3FF99999,0x9999999A, 0x3FC99999,0x9999999A, 0x3FF193B4,0x3862CFF2,
	0x3FF99999,0x9999999A, 0x3FD33333,0x33333333, 0x3FF26C3D,0x90F409BD,
	0x3FF99999,0x9999999A, 0x3FD99999,0x9999999A, 0x3FF34F32,0x7F4C0704,
	0x3FF99999,0x9999999A, 0x3FE00000,0x00000000, 0x3FF43D13,0x6248490F,
	0x3FF99999,0x9999999A, 0x3FE33333,0x33333333, 0x3FF53666,0xC636DAD3,
	0x3FF99999,0x9999999A, 0x3FE66666,0x66666666, 0x3FF63BB9,0xB0F09863,
	0x3FF99999,0x9999999A, 0x3FE99999,0x9999999A, 0x3FF74D9F,0xF19CFF00,
	0x3FF99999,0x9999999A, 0x3FECCCCC,0xCCCCCCCD, 0x3FF86CB4,0x744CA3A5,
	0x3FF99999,0x9999999A, 0x3FF00000,0x00000000, 0x3FF99999,0x9999999A,
	0x3FF99999,0x9999999A, 0x3FF19999,0x9999999A, 0x3FFAD4F9,0x927F5935,
	0x3FF99999,0x9999999A, 0x3FF33333,0x33333333, 0x3FFC1F86,0xC09E1983,
	0x3FF99999,0x9999999A, 0x3FF4CCCC,0xCCCCCCCD, 0x3FFD79FC,0x1B200F96,
	0x3FF99999,0x9999999A, 0x3FF66666,0x66666666, 0x3FFEE51D,0x9879A4D4,
	0x3FF99999,0x9999999A, 0x3FF80000,0x00000000, 0x400030DC,0x4EA03A73,
	0x3FF99999,0x9999999A, 0x3FF99999,0x9999999A, 0x4000F852,0x382BE243,
	0x3FF99999,0x9999999A, 0x3FFB3333,0x33333333, 0x4001C961,0x5A5A1382,
	0x3FF99999,0x9999999A, 0x3FFCCCCC,0xCCCCCCCD, 0x4002A47F,0xF47D98CD,
	0x3FF99999,0x9999999A, 0x3FFE6666,0x66666666, 0x40038A29,0xF6A3B61E,
	0x3FF99999,0x9999999A, 0x40000000,0x00000000, 0x40047AE1,0x47AE147C,
	0x3FFB3333,0x33333333, 0x3FB99999,0x9999999A, 0x3FF0DF37,0x1594856C,
	0x3FFB3333,0x33333333, 0x3FC99999,0x9999999A, 0x3FF1CA98,0x3B603B59,
	0x3FFB3333,0x33333333, 0x3FD33333,0x33333333, 0x3FF2C2CD,0x258622DA,
	0x3FFB3333,0x33333333, 0x3FD99999,0x9999999A, 0x3FF3C888,0xC7B024F9,
	0x3FFB3333,0x33333333, 0x3FE00000,0x00000000, 0x3FF4DC87,0xD61451DA,
	0x3FFB3333,0x33333333, 0x3FE33333,0x33333333, 0x3FF5FF91,0x4D82151C,
	0x3FFB3333,0x33333333, 0x3FE66666,0x66666666, 0x3FF73277,0x02D976B8,
	0x3FFB3333,0x33333333, 0x3FE99999,0x9999999A, 0x3FF87616,0x3A53D7DB,
	0x3FFB3333,0x33333333, 0x3FECCCCC,0xCCCCCCCD, 0x3FF9CB58,0x470B3E61,
	0x3FFB3333,0x33333333, 0x3FF00000,0x00000000, 0x3FFB3333,0x33333333,
	0x3FFB3333,0x33333333, 0x3FF19999,0x9999999A, 0x3FFCAEAA,0x717C7C6B,
	0x3FFB3333,0x33333333, 0x3FF33333,0x33333333, 0x3FFE3ECF,0x98239818,
	0x3FFB3333,0x33333333, 0x3FF4CCCC,0xCCCCCCCD, 0x3FFFE4C3,0x2630D4D8,
	0x3FFB3333,0x33333333, 0x3FF66666,0x66666666, 0x4000D0DA,0xA9BC1F6D,
	0x3FFB3333,0x33333333, 0x3FF80000,0x00000000, 0x4001BB73,0x75F7ABF9,
	0x3FFB3333,0x33333333, 0x3FF99999,0x9999999A, 0x4002B2D5,0x1B7B5EBE,
	0x3FFB3333,0x33333333, 0x3FFB3333,0x33333333, 0x4003B7B1,0xF59F3E83,
	0x3FFB3333,0x33333333, 0x3FFCCCCC,0xCCCCCCCD, 0x4004CAC6,0x17FA777A,
	0x3FFB3333,0x33333333, 0x3FFE6666,0x66666666, 0x4005ECD7,0xD5FCC1D2,
	0x3FFB3333,0x33333333, 0x40000000,0x00000000, 0x40071EB8,0x51EB851E,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FB99999,0x9999999A, 0x3FF0F7F9,0x4BC9DC5D,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FC99999,0x9999999A, 0x3FF1FEF5,0xC7C3F980,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FD33333,0x33333333, 0x3FF315DE,0x1F0EFA98,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FD99999,0x9999999A, 0x3FF43DA9,0x12C67FF1,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FE00000,0x00000000, 0x3FF5775C,0x544FF263,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FE33333,0x33333333, 0x3FF6C40D,0x6CE0B896,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FE66666,0x66666666, 0x3FF824E2,0xB308AB84,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FE99999,0x9999999A, 0x3FF99B14,0x4F1A0622,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FECCCCC,0xCCCCCCCD, 0x3FFB27ED,0x4F5532F1,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FF00000,0x00000000, 0x3FFCCCCC,0xCCCCCCCD,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FF19999,0x9999999A, 0x3FFE8B27,0x2204F30F,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FF33333,0x33333333, 0x40003243,0x9A30608D,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FF4CCCC,0xCCCCCCCD, 0x40012D47,0xE8C0AE56,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FF66666,0x66666666, 0x4002377E,0x90E5D98C,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FF80000,0x00000000, 0x400351D3,0x18AE5A26,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FF99999,0x9999999A, 0x40047D3F,0x4863D954,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FFB3333,0x33333333, 0x4005BACC,0x0787CD91,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FFCCCCC,0xCCCCCCCD, 0x40070B92,0x47310585,
	0x3FFCCCCC,0xCCCCCCCD, 0x3FFE6666,0x66666666, 0x400870BB,0xFA997AA5,
	0x3FFCCCCC,0xCCCCCCCD, 0x40000000,0x00000000, 0x4009EB85,0x1EB851EC,
	0x3FFE6666,0x66666666, 0x3FB99999,0x9999999A, 0x3FF10F86,0x2A137171,
	0x3FFE6666,0x66666666, 0x3FC99999,0x9999999A, 0x3FF2310C,0x295D36BA,
	0x3FFE6666,0x66666666, 0x3FD33333,0x33333333, 0x3FF365C3,0x71F6871C,
	0x3FFE6666,0x66666666, 0x3FD99999,0x9999999A, 0x3FF4AEF1,0xB7985489,
	0x3FFE6666,0x66666666, 0x3FE00000,0x00000000, 0x3FF60DF2,0x453AB723,
	0x3FFE6666,0x66666666, 0x3FE33333,0x33333333, 0x3FF78437,0x6B7BB651,
	0x3FFE6666,0x66666666, 0x3FE66666,0x66666666, 0x3FF9134C,0x074FFF15,
	0x3FFE6666,0x66666666, 0x3FE99999,0x9999999A, 0x3FFABCD5,0x2299B78C,
	0x3FFE6666,0x66666666, 0x3FECCCCC,0xCCCCCCCD, 0x3FFC8293,0xB05CF233,
	0x3FFE6666,0x66666666, 0x3FF00000,0x00000000, 0x3FFE6666,0x66666666,
	0x3FFE6666,0x66666666, 0x3FF19999,0x9999999A, 0x40003525,0xDB2C122C,
	0x3FFE6666,0x66666666, 0x3FF33333,0x33333333, 0x40014831,0xF4188D97,
	0x3FFE6666,0x66666666, 0x3FF4CCCC,0xCCCCCCCD, 0x40026D79,0xAC43CD27,
	0x3FFE6666,0x66666666, 0x3FF66666,0x66666666, 0x4003A632,0x6E6A504E,
	0x3FFE6666,0x66666666, 0x3FF80000,0x00000000, 0x4004F3A6,0x282AFAC8,
	0x3FFE6666,0x66666666, 0x3FF99999,0x9999999A, 0x40065734,0xA61BED33,
	0x3FFE6666,0x66666666, 0x3FFB3333,0x33333333, 0x4007D255,0x06F26587,
	0x3FFE6666,0x66666666, 0x3FFCCCCC,0xCCCCCCCD, 0x40096697,0x47453B2B,
	0x3FFE6666,0x66666666, 0x3FFE6666,0x66666666, 0x400B15A5,0xE78B7FAF,
	0x3FFE6666,0x66666666, 0x40000000,0x00000000, 0x400CE147,0xAE147AE1,
	0x40000000,0x00000000, 0x3FB99999,0x9999999A, 0x3FF125FB,0xEE250664,
	0x40000000,0x00000000, 0x3FC99999,0x9999999A, 0x3FF26111,0x86BAE675,
	0x40000000,0x00000000, 0x3FD33333,0x33333333, 0x3FF3B2C4,0x7BFF8329,
	0x40000000,0x00000000, 0x3FD99999,0x9999999A, 0x3FF51CB4,0x53B9536C,
	0x40000000,0x00000000, 0x3FE00000,0x00000000, 0x3FF6A09E,0x667F3BCD,
	0x40000000,0x00000000, 0x3FE33333,0x33333333, 0x3FF84060,0x03B2AE5C,
	0x40000000,0x00000000, 0x3FE66666,0x66666666, 0x3FF9FDF8,0xBCCE533D,
	0x40000000,0x00000000, 0x3FE99999,0x9999999A, 0x3FFBDB8C,0xDADBE120,
	0x40000000,0x00000000, 0x3FECCCCC,0xCCCCCCCD, 0x3FFDDB68,0x0117AB12,
	0x40000000,0x00000000, 0x3FF00000,0x00000000, 0x40000000,0x00000000,
	0x40000000,0x00000000, 0x3FF19999,0x9999999A, 0x400125FB,0xEE250664,
	0x40000000,0x00000000, 0x3FF33333,0x33333333, 0x40026111,0x86BAE674,
	0x40000000,0x00000000, 0x3FF4CCCC,0xCCCCCCCD, 0x4003B2C4,0x7BFF8329,
	0x40000000,0x00000000, 0x3FF66666,0x66666666, 0x40051CB4,0x53B9536C,
	0x40000000,0x00000000, 0x3FF80000,0x00000000, 0x4006A09E,0x667F3BCD,
	0x40000000,0x00000000, 0x3FF99999,0x9999999A, 0x40084060,0x03B2AE5D,
	0x40000000,0x00000000, 0x3FFB3333,0x33333333, 0x4009FDF8,0xBCCE533D,
	0x40000000,0x00000000, 0x3FFCCCCC,0xCCCCCCCD, 0x400BDB8C,0xDADBE120,
	0x40000000,0x00000000, 0x3FFE6666,0x66666666, 0x400DDB68,0x0117AB12,
	0x40000000,0x00000000, 0x40000000,0x00000000, 0x40100000,0x00000000,
	0x4000CCCC,0xCCCCCCCD, 0x3FB99999,0x9999999A, 0x3FF13B74,0x8AD64EF9,
	0x4000CCCC,0xCCCCCCCD, 0x3FC99999,0x9999999A, 0x3FF28F34,0x95D8362F,
	0x4000CCCC,0xCCCCCCCD, 0x3FD33333,0x33333333, 0x3FF3FD1F,0x206741C0,
	0x4000CCCC,0xCCCCCCCD, 0x3FD99999,0x9999999A, 0x3FF58738,0x0DC9C62C,
	0x4000CCCC,0xCCCCCCCD, 0x3FE00000,0x00000000, 0x3FF72FAA,0xFC7E3CD7,
	0x4000CCCC,0xCCCCCCCD, 0x3FE33333,0x33333333, 0x3FF8F8CE,0x55928B79,
	0x4000CCCC,0xCCCCCCCD, 0x3FE66666,0x66666666, 0x3FFAE526,0x984F9BA5,
	0x4000CCCC,0xCCCCCCCD, 0x3FE99999,0x9999999A, 0x3FFCF769,0xE6DEB5B4,
	0x4000CCCC,0xCCCCCCCD, 0x3FECCCCC,0xCCCCCCCD, 0x3FFF3283,0xD8E9ADA4,
	0x4000CCCC,0xCCCCCCCD, 0x3FF00000,0x00000000, 0x4000CCCC,0xCCCCCCCD,
	0x4000CCCC,0xCCCCCCCD, 0x3FF19999,0x9999999A, 0x40021807,0x2B61061F,
	0x4000CCCC,0xCCCCCCCD, 0x3FF33333,0x33333333, 0x40037CC4,0x03BC9F4B,
	0x4000CCCC,0xCCCCCCCD, 0x3FF4CCCC,0xCCCCCCCD, 0x4004FCFA,0x486C6B71,
	0x4000CCCC,0xCCCCCCCD, 0x3FF66666,0x66666666, 0x40069AC7,0xA813DCE1,
	0x4000CCCC,0xCCCCCCCD, 0x3FF80000,0x00000000, 0x40085873,0x891E2648,
	0x4000CCCC,0xCCCCCCCD, 0x3FF99999,0x9999999A, 0x400A3872,0x404045A7,
	0x4000CCCC,0xCCCCCCCD, 0x3FFB3333,0x33333333, 0x400C3D68,0x865396A0,
	0x4000CCCC,0xCCCCCCCD, 0x3FFCCCCC,0xCCCCCCCD, 0x400E6A2F,0x3269D863,
	0x4000CCCC,0xCCCCCCCD, 0x3FFE6666,0x66666666, 0x401060EB,0x9EADE18F,
	0x4000CCCC,0xCCCCCCCD, 0x40000000,0x00000000, 0x4011A3D7,0x0A3D70A4,
	0x40019999,0x9999999A, 0x3FB99999,0x9999999A, 0x3FF15006,0x70251A91,
	0x40019999,0x9999999A, 0x3FC99999,0x9999999A, 0x3FF2BB9D,0xEEB2E2AB,
	0x40019999,0x9999999A, 0x3FD33333,0x33333333, 0x3FF44509,0x6CEF8B45,
	0x40019999,0x9999999A, 0x3FD99999,0x9999999A, 0x3FF5EEBB,0x5AD4FDD3,
	0x40019999,0x9999999A, 0x3FE00000,0x00000000, 0x3FF7BB59,0x8C88B4AD,
	0x40019999,0x9999999A, 0x3FE33333,0x33333333, 0x3FF9ADC1,0x71A7FBB0,
	0x40019999,0x9999999A, 0x3FE66666,0x66666666, 0x3FFBC90C,0xA51F2482,
	0x40019999,0x9999999A, 0x3FE99999,0x9999999A, 0x3FFE1095,0xDCCF3801,
	0x40019999,0x9999999A, 0x3FECCCCC,0xCCCCCCCD, 0x400043FF,0x206F1DDB,
	0x40019999,0x9999999A, 0x3FF00000,0x00000000, 0x40019999,0x9999999A,
	0x40019999,0x9999999A, 0x3FF19999,0x9999999A, 0x40030B3A,0x4828D06D,
	0x40019999,0x9999999A, 0x3FF33333,0x33333333, 0x40049B2D,0xB9C4C623,
	0x40019999,0x9999999A, 0x3FF4CCCC,0xCCCCCCCD, 0x40064BF0,0xC4A11933,
	0x40019999,0x9999999A, 0x3FF66666,0x66666666, 0x40082034,0x7D83E402,
	0x40019999,0x9999999A, 0x3FF80000,0x00000000, 0x400A1AE2,0x80FCC6BF,
	0x40019999,0x9999999A, 0x3FF99999,0x9999999A, 0x400C3F21,0x969F2E77,
	0x40019999,0x9999999A, 0x3FFB3333,0x33333333, 0x400E905A,0xB5A241C3,
	0x40019999,0x9999999A, 0x3FFCCCCC,0xCCCCCCCD, 0x4010891F,0x3971F867,
	0x40019999,0x9999999A, 0x3FFE6666,0x66666666, 0x4011E465,0x707A3A71,
	0x40019999,0x9999999A, 0x40000000,0x00000000, 0x40135C28,0xF5C28F5D,
	0x40026666,0x66666666, 0x3FB99999,0x9999999A, 0x3FF163C5,0x27826636,
	0x40026666,0x66666666, 0x3FC99999,0x9999999A, 0x3FF2E671,0x153B6431,
	0x40026666,0x66666666, 0x3FD33333,0x33333333, 0x3FF48AB2,0xE63E8C13,
	0x40026666,0x66666666, 0x3FD99999,0x9999999A, 0x3FF65375,0x660748F3,
	0x40026666,0x66666666, 0x3FE00000,0x00000000, 0x3FF843E4,0x3D85E5B1,
	0x40026666,0x66666666, 0x3FE33333,0x33333333, 0x3FFA5F71,0x95706502,
	0x40026666,0x66666666, 0x3FE66666,0x66666666, 0x3FFCA9DC,0x35DA278C,
	0x40026666,0x66666666, 0x3FE99999,0x9999999A, 0x3FFF2736,0x2DF3FAE5,
	0x40026666,0x66666666, 0x3FECCCCC,0xCCCCCCCD, 0x4000EDF6,0x07E40FD6,
	0x40026666,0x66666666, 0x3FF00000,0x00000000, 0x40026666,0x66666666,
	0x40026666,0x66666666, 0x3FF19999,0x9999999A, 0x4003FF89,0x20A2C258,
	0x40026666,0x66666666, 0x3FF33333,0x33333333, 0x4005BC35,0x3ED1199E,
	0x40026666,0x66666666, 0x3FF4CCCC,0xCCCCCCCD, 0x40079F80,0xEF2E5449,
	0x40026666,0x66666666, 0x3FF66666,0x66666666, 0x4009ACC7,0x0221FA49,
	0x40026666,0x66666666, 0x3FF80000,0x00000000, 0x400BE7AC,0xE059FB58,
	0x40026666,0x66666666, 0x3FF99999,0x9999999A, 0x400E5429,0x05747429,
	0x40026666,0x66666666, 0x3FFB3333,0x33333333, 0x40107B45,0x055D7057,
	0x40026666,0x66666666, 0x3FFCCCCC,0xCCCCCCCD, 0x4011E9BF,0x273916AA,
	0x40026666,0x66666666, 0x3FFE6666,0x66666666, 0x4013780E,0x22ACABCF,
	0x40026666,0x66666666, 0x40000000,0x00000000, 0x401528F5,0xC28F5C28,
	0x40033333,0x33333333, 0x3FB99999,0x9999999A, 0x3FF176C1,0xCF6D3EFB,
	0x40033333,0x33333333, 0x3FC99999,0x9999999A, 0x3FF30FCD,0x4CA757E3,
	0x40033333,0x33333333, 0x3FD33333,0x33333333, 0x3FF4CE45,0x914222EB,
	0x40033333,0x33333333, 0x3FD99999,0x9999999A, 0x3FF6B597,0x31476830,
	0x40033333,0x33333333, 0x3FE00000,0x00000000, 0x3FF8C97E,0xF43F7248,
	0x40033333,0x33333333, 0x3FE33333,0x33333333, 0x3FFB0E11,0x2BB0384F,
	0x40033333,0x33333333, 0x3FE66666,0x66666666, 0x3FFD87C1,0xB57B46E9,
	0x40033333,0x33333333, 0x3FE99999,0x9999999A, 0x40001DB6,0x5CEA006A,
	0x40033333,0x33333333, 0x3FECCCCC,0xCCCCCCCD, 0x40019730,0x1AFC1026,
	0x40033333,0x33333333, 0x3FF00000,0x00000000, 0x40033333,0x33333333,
	0x40033333,0x33333333, 0x3FF19999,0x9999999A, 0x4004F4E8,0x92831861,
	0x40033333,0x33333333, 0x3FF33333,0x33333333, 0x4006DFC3,0x28C8CFDD,
	0x40033333,0x33333333, 0x3FF4CCCC,0xCCCCCCCD, 0x4008F786,0xAE4F5D1A,
	0x40033333,0x33333333, 0x3FF66666,0x66666666, 0x400B404F,0x07EF49D2,
	0x40033333,0x33333333, 0x3FF80000,0x00000000, 0x400DBE98,0x584C22BC,
	0x40033333,0x33333333, 0x3FF99999,0x9999999A, 0x40103BA3,0xE70354FC,
	0x40033333,0x33333333, 0x3FFB3333,0x33333333, 0x4011B7DA,0xA016C425,
	0x40033333,0x33333333, 0x3FFCCCCC,0xCCCCCCCD, 0x401356DA,0xD5E59A18,
	0x40033333,0x33333333, 0x3FFE6666,0x66666666, 0x40151BD3,0x5394E02D,
	0x40033333,0x33333333, 0x40000000,0x00000000, 0x40170A3D,0x70A3D70A,
	0x40040000,0x00000000, 0x3FB99999,0x9999999A, 0x3FF1890B,0x7E41B4EE,
	0x40040000,0x00000000, 0x3FC99999,0x9999999A, 0x3FF337CE,0x41260734,
	0x40040000,0x00000000, 0x3FD33333,0x33333333, 0x3FF50FE6,0xC94A6E58,
	0x40040000,0x00000000, 0x3FD99999,0x9999999A, 0x3FF7154C,0x7F1D0529,
	0x40040000,0x00000000, 0x3FE00000,0x00000000, 0x3FF94C58,0x3ADA5B53,
	0x40040000,0x00000000, 0x3FE33333,0x33333333, 0x3FFBB9CD,0x9E1DB235,
	0x40040000,0x00000000, 0x3FE66666,0x66666666, 0x3FFE62E5,0x531FD7EB,
	0x40040000,0x00000000, 0x3FE99999,0x9999999A, 0x4000A6AC,0x23D76B44,
	0x40040000,0x00000000, 0x3FECCCCC,0xCCCCCCCD, 0x40023FB5,0xFE030C24,
	0x40040000,0x00000000, 0x3FF00000,0x00000000, 0x40040000,0x00000000,
	0x40040000,0x00000000, 0x3FF19999,0x9999999A, 0x4005EB4E,0x5DD2222A,
	0x40040000,0x00000000, 0x3FF33333,0x33333333, 0x400805C1,0xD16F8900,
	0x40040000,0x00000000, 0x3FF4CCCC,0xCCCCCCCD, 0x400A53E0,0x7B9D09EE,
	0x40040000,0x00000000, 0x3FF66666,0x66666666, 0x400CDA9F,0x9EE44672,
	0x40040000,0x00000000, 0x3FF80000,0x00000000, 0x400F9F6E,0x4990F227,
	0x40040000,0x00000000, 0x3FF99999,0x9999999A, 0x40115420,0x82D28F62,
	0x40040000,0x00000000, 0x3FFB3333,0x33333333, 0x4012FDCF,0x53F3E6F3,
	0x40040000,0x00000000, 0x3FFCCCCC,0xCCCCCCCD, 0x4014D057,0x2CCD4615,
	0x40040000,0x00000000, 0x3FFE6666,0x66666666, 0x4016CFA3,0x7D83CF2C,
	0x40040000,0x00000000, 0x40000000,0x00000000, 0x40190000,0x00000000,
	0x4004CCCC,0xCCCCCCCD, 0x3FB99999,0x9999999A, 0x3FF19AAF,0x91FD21C3,
	0x4004CCCC,0xCCCCCCCD, 0x3FC99999,0x9999999A, 0x3FF35E8C,0x917ABF3E,
	0x4004CCCC,0xCCCCCCCD, 0x3FD33333,0x33333333, 0x3FF54FB7,0xEE6769A6,
	0x4004CCCC,0xCCCCCCCD, 0x3FD99999,0x9999999A, 0x3FF772BC,0x9203DF8A,
	0x4004CCCC,0xCCCCCCCD, 0x3FE00000,0x00000000, 0x3FF9CC99,0xFF02C481,
	0x4004CCCC,0xCCCCCCCD, 0x3FE33333,0x33333333, 0x3FFC62D0,0x02641DE5,
	0x4004CCCC,0xCCCCCCCD, 0x3FE66666,0x66666666, 0x3FFF3B6B,0x906510FF,
	0x4004CCCC,0xCCCCCCCD, 0x3FE99999,0x9999999A, 0x40012E8A,0x75CD2337,
	0x4004CCCC,0xCCCCCCCD, 0x3FECCCCC,0xCCCCCCCD, 0x4002E78F,0x9BA7CF4C,
	0x4004CCCC,0xCCCCCCCD, 0x3FF00000,0x00000000, 0x4004CCCC,0xCCCCCCCD,
	0x4004CCCC,0xCCCCCCCD, 0x3FF19999,0x9999999A, 0x4006E2B1,0x0A95DF18,
	0x4004CCCC,0xCCCCCCCD, 0x3FF33333,0x33333333, 0x40092E1D,0x2385F89E,
	0x4004CCCC,0xCCCCCCCD, 0x3FF4CCCC,0xCCCCCCCD, 0x400BB46F,0x1C533C8C,
	0x4004CCCC,0xCCCCCCCD, 0x3FF66666,0x66666666, 0x400E7B8E,0xBDD1D5CD,
	0x4004CCCC,0xCCCCCCCD, 0x3FF80000,0x00000000, 0x4010C4FD,0xB28E9954,
	0x4004CCCC,0xCCCCCCCD, 0x3FF99999,0x9999999A, 0x4012736D,0x9B2779D6,
	0x4004CCCC,0xCCCCCCCD, 0x3FFB3333,0x33333333, 0x40144D05,0xEAA817D9,
	0x4004CCCC,0xCCCCCCCD, 0x3FFCCCCC,0xCCCCCCCD, 0x4016561A,0x65F1142E,
	0x4004CCCC,0xCCCCCCCD, 0x3FFE6666,0x66666666, 0x4018936D,0xE3F3C0AF,
	0x4004CCCC,0xCCCCCCCD, 0x40000000,0x00000000, 0x401B0A3D,0x70A3D70B,
	0x40059999,0x9999999A, 0x3FB99999,0x9999999A, 0x3FF1ABB9,0xF1383BA5,
	0x40059999,0x9999999A, 0x3FC99999,0x9999999A, 0x3FF3841E,0x3F8C7922,
	0x40059999,0x9999999A, 0x3FD33333,0x33333333, 0x3FF58DD6,0xF4A4CB92,
	0x40059999,0x9999999A, 0x3FD99999,0x9999999A, 0x3FF7CE0A,0xCA3F5CCA,
	0x40059999,0x9999999A, 0x3FE00000,0x00000000, 0x3FFA4A6A,0x2F74C6AC,
	0x40059999,0x9999999A, 0x3FE33333,0x33333333, 0x3FFD093D,0xAA104DB7,
	0x40059999,0x9999999A, 0x3FE66666,0x66666666, 0x400008BA,0xDC2A8E4A,
	0x40059999,0x9999999A, 0x3FE99999,0x9999999A, 0x4001B55E,0x2DAAA893,
	0x40059999,0x9999999A, 0x3FECCCCC,0xCCCCCCCD, 0x40038EC4,0x3B186A68,
	0x40059999,0x9999999A, 0x3FF00000,0x00000000, 0x40059999,0x9999999A,
	0x40059999,0x9999999A, 0x3FF19999,0x9999999A, 0x4007DB07,0xD2725086,
	0x40059999,0x9999999A, 0x3FF33333,0x33333333, 0x400A58C2,0x6F6409EE,
	0x40059999,0x9999999A, 0x3FF4CCCC,0xCCCCCCCD, 0x400D1915,0x63DE7939,
	0x40059999,0x9999999A, 0x3FF66666,0x66666666, 0x4010117A,0x7BB791D5,
	0x40059999,0x9999999A, 0x3FF80000,0x00000000, 0x4011BF07,0xACD5394E,
	0x40059999,0x9999999A, 0x3FF99999,0x9999999A, 0x40139970,0x05FE3476,
	0x40059999,0x9999999A, 0x3FFB3333,0x33333333, 0x4015A562,0xA939734B,
	0x40059999,0x9999999A, 0x3FFCCCCC,0xCCCCCCCD, 0x4017E80B,0xF0D996C7,
	0x40059999,0x9999999A, 0x3FFE6666,0x66666666, 0x401A6722,0x82FA8FA5,
	0x40059999,0x9999999A, 0x40000000,0x00000000, 0x401D28F5,0xC28F5C2A,
	0x40066666,0x66666666, 0x3FB99999,0x9999999A, 0x3FF1BC35,0x40858445,
	0x40066666,0x66666666, 0x3FC99999,0x9999999A, 0x3FF3A897,0x0D39372F,
	0x40066666,0x66666666, 0x3FD33333,0x33333333, 0x3FF5CA5E,0xDAA2EED7,
	0x40066666,0x66666666, 0x3FD99999,0x9999999A, 0x3FF82757,0x290F9E39,
	0x40066666,0x66666666, 0x3FE00000,0x00000000, 0x3FFAC5EB,0x3F7AB2F8,
	0x40066666,0x66666666, 0x3FE33333,0x33333333, 0x3FFDAD38,0x9B2E99A9,
	0x40066666,0x66666666, 0x3FE66666,0x66666666, 0x40007291,0x21BC7841,
	0x40066666,0x66666666, 0x3FE99999,0x9999999A, 0x40023B33,0x1AF8EAE0,
	0x40066666,0x66666666, 0x3FECCCCC,0xCCCCCCCD, 0x4004355A,0x92C39EEA,
	0x40066666,0x66666666, 0x3FF00000,0x00000000, 0x40066666,0x66666666,
	0x40066666,0x66666666, 0x3FF19999,0x9999999A, 0x4008D44A,0x8D87B92D,
	0x40066666,0x66666666, 0x3FF33333,0x33333333, 0x400B85A0,0x45B68074,
	0x40066666,0x66666666, 0x3FF4CCCC,0xCCCCCCCD, 0x400E81B7,0xFEE41B2D,
	0x40066666,0x66666666, 0x3FF66666,0x66666666, 0x4010E856,0x9CBE21F4,
	0x40066666,0x66666666, 0x3FF80000,0x00000000, 0x4012BDBE,0x460916E0,
	0x40066666,0x66666666, 0x3FF99999,0x9999999A, 0x4014C60E,0x063A385D,
	0x40066666,0x66666666, 0x3FFB3333,0x33333333, 0x401706CB,0x2F3B0EC2,
	0x40066666,0x66666666, 0x3FFCCCCC,0xCCCCCCCD, 0x40198614,0x58F615A0,
	0x40066666,0x66666666, 0x3FFE6666,0x66666666, 0x401C4AB2,0x00AB7812,
	0x40066666,0x66666666, 0x40000000,0x00000000, 0x401F5C28,0xF5C28F5B,
	0x40073333,0x33333333, 0x3FB99999,0x9999999A, 0x3FF1CC2B,0x0E9CE1D1,
	0x40073333,0x33333333, 0x3FC99999,0x9999999A, 0x3FF3CC08,0xC975DEF2,
	0x40073333,0x33333333, 0x3FD33333,0x33333333, 0x3FF60568,0x0C821D96,
	0x40073333,0x33333333, 0x3FD99999,0x9999999A, 0x3FF87EBE,0xBE8E0293,
	0x40073333,0x33333333, 0x3FE00000,0x00000000, 0x3FFB3F3C,0x957429DA,
	0x40073333,0x33333333, 0x3FE33333,0x33333333, 0x3FFE4EDF,0xF6124554,
	0x40073333,0x33333333, 0x3FE66666,0x66666666, 0x4000DB46,0x964E7456,
	0x40073333,0x33333333, 0x3FE99999,0x9999999A, 0x4002C014,0x20629D76,
	0x40073333,0x33333333, 0x3FECCCCC,0xCCCCCCCD, 0x4004DB58,0xD85BB2AF,
	0x40073333,0x33333333, 0x3FF00000,0x00000000, 0x40073333,0x33333333,
	0x40073333,0x33333333, 0x3FF19999,0x9999999A, 0x4009CE71,0xA1FD143C,
	0x40073333,0x33333333, 0x3FF33333,0x33333333, 0x400CB4A6,0x57515012,
	0x40073333,0x33333333, 0x3FF4CCCC,0xCCCCCCCD, 0x400FEE3D,0x45564480,
	0x40073333,0x33333333, 0x3FF66666,0x66666666, 0x4011C24A,0x4A26F510,
	0x40073333,0x33333333, 0x3FF80000,0x00000000, 0x4013C10B,0xEC5A9E58,
	0x40073333,0x33333333, 0x3FF99999,0x9999999A, 0x4015F92F,0x2C007244,
	0x40073333,0x33333333, 0x3FFB3333,0x33333333, 0x40187126,0x59F1C24A,
	0x40073333,0x33333333, 0x3FFCCCCC,0xCCCCCCCD, 0x401B301D,0x2EF56451,
	0x40073333,0x33333333, 0x3FFE6666,0x66666666, 0x401E3E0D,0xA01E8FE4,
	0x40073333,0x33333333, 0x40000000,0x00000000, 0x4020D1EB,0x851EB852,
	0x40080000,0x00000000, 0x3FB99999,0x9999999A, 0x3FF1DBA3,0xF92C888B,
	0x40080000,0x00000000, 0x3FC99999,0x9999999A, 0x3FF3EE83,0x90D43956,
	0x40080000,0x00000000, 0x3FD33333,0x33333333, 0x3FF63F08,0xB6F382AE,
	0x40080000,0x00000000, 0x3FD99999,0x9999999A, 0x3FF8D45C,0x06468A88,
	0x40080000,0x00000000, 0x3FE00000,0x00000000, 0x3FFBB67A,0xE8584CAA,
	0x40080000,0x00000000, 0x3FE33333,0x33333333, 0x3FFEEE50,0x4BC32424,
	0x40080000,0x00000000, 0x3FE66666,0x66666666, 0x400142E8,0x1C889914,
	0x40080000,0x00000000, 0x3FE99999,0x9999999A, 0x4003440B,0x4DC59A8E,
	0x40080000,0x00000000, 0x3FECCCCC,0xCCCCCCCD, 0x400580C4,0xCE962CAA,
	0x40080000,0x00000000, 0x3FF00000,0x00000000, 0x40080000,0x00000000,
	0x40080000,0x00000000, 0x3FF19999,0x9999999A, 0x400AC975,0xF5C2CCD2,
	0x40080000,0x00000000, 0x3FF33333,0x33333333, 0x400DE5C5,0x593E5600,
	0x40080000,0x00000000, 0x3FF4CCCC,0xCCCCCCCD, 0x4010AF46,0x8936A203,
	0x40080000,0x00000000, 0x3FF66666,0x66666666, 0x40129F45,0x04B4E7E5,
	0x40080000,0x00000000, 0x3FF80000,0x00000000, 0x4014C8DC,0x2E423980,
	0x40080000,0x00000000, 0x3FF99999,0x9999999A, 0x401732BC,0x38D25B1C,
	0x40080000,0x00000000, 0x3FFB3333,0x33333333, 0x4019E45C,0x2ACCE59E,
	0x40080000,0x00000000, 0x3FFCCCCC,0xCCCCCCCD, 0x401CE610,0xF4A867D4,
	0x40080000,0x00000000, 0x3FFE6666,0x66666666, 0x40202093,0x9AF0A17F,
	0x40080000,0x00000000, 0x40000000,0x00000000, 0x40220000,0x00000000,
	0x4008CCCC,0xCCCCCCCD, 0x3FB99999,0x9999999A, 0x3FF1EAA7,0xCBBC4617,
	0x4008CCCC,0xCCCCCCCD, 0x3FC99999,0x9999999A, 0x3FF41016,0x03D70F0F,
	0x4008CCCC,0xCCCCCCCD, 0x3FD33333,0x33333333, 0x3FF67755,0x0D6A9D87,
	0x4008CCCC,0xCCCCCCCD, 0x3FD99999,0x9999999A, 0x3FF92847,0x35BF9E55,
	0x4008CCCC,0xCCCCCCCD, 0x3FE00000,0x00000000, 0x3FFC2BC0,0x8F4BFA98,
	0x4008CCCC,0xCCCCCCCD, 0x3FE33333,0x33333333, 0x3FFF8BA3,0xE7D0E1B4,
	0x4008CCCC,0xCCCCCCCD, 0x3FE66666,0x66666666, 0x4001A981,0x9B4CF265,
	0x4008CCCC,0xCCCCCCCD, 0x3FE99999,0x9999999A, 0x4003C721,0xF6A03D4D,
	0x4008CCCC,0xCCCCCCCD, 0x3FECCCCC,0xCCCCCCCD, 0x400625A3,0xD10AE026,
	0x4008CCCC,0xCCCCCCCD, 0x3FF00000,0x00000000, 0x4008CCCC,0xCCCCCCCD,
	0x4008CCCC,0xCCCCCCCD, 0x3FF19999,0x9999999A, 0x400BC550,0xE2309FD8,
	0x4008CCCC,0xCCCCCCCD, 0x3FF33333,0x33333333, 0x400F18EE,0xEC5A2424,
	0x4008CCCC,0xCCCCCCCD, 0x3FF4CCCC,0xCCCCCCCD, 0x40116948,0x50CC3A16,
	0x4008CCCC,0xCCCCCCCD, 0x3FF66666,0x66666666, 0x40137F37,0x300E1AB4,
	0x4008CCCC,0xCCCCCCCD, 0x3FF80000,0x00000000, 0x4015D51B,0xA241489C,
	0x4008CCCC,0xCCCCCCCD, 0x3FF99999,0x9999999A, 0x4018729F,0x06DB7BB9,
	0x4008CCCC,0xCCCCCCCD, 0x3FFB3333,0x33333333, 0x401B6055,0xB0B74484,
	0x4008CCCC,0xCCCCCCCD, 0x3FFCCCCC,0xCCCCCCCD, 0x401EA7DB,0x0B11F89D,
	0x4008CCCC,0xCCCCCCCD, 0x3FFE6666,0x66666666, 0x402129F8,0x8ECED41D,
	0x4008CCCC,0xCCCCCCCD, 0x40000000,0x00000000, 0x40233851,0xEB851EB9,
	0x40099999,0x9999999A, 0x3FB99999,0x9999999A, 0x3FF1F93D,0x99C0166A,
	0x40099999,0x9999999A, 0x3FC99999,0x9999999A, 0x3FF430CD,0x74F6D478,
	0x40099999,0x9999999A, 0x3FD33333,0x33333333, 0x3FF6AE5F,0x85C6E38F,
	0x40099999,0x9999999A, 0x3FD99999,0x9999999A, 0x3FF97A96,0x7F7524B3,
	0x40099999,0x9999999A, 0x3FE00000,0x00000000, 0x3FFC9F25,0xC5BFEDD9,
	0x40099999,0x9999999A, 0x3FE33333,0x33333333, 0x40001379,0x87DD704C,
	0x40099999,0x9999999A, 0x3FE66666,0x66666666, 0x40020F1E,0x18683DCB,
	0x40099999,0x9999999A, 0x3FE99999,0x9999999A, 0x40044960,0xC576B376,
	0x40099999,0x9999999A, 0x3FECCCCC,0xCCCCCCCD, 0x4006C9FA,0xDE81511F,
	0x40099999,0x9999999A, 0x3FF00000,0x00000000, 0x40099999,0x9999999A,
	0x40099999,0x9999999A, 0x3FF19999,0x9999999A, 0x400CC1FC,0x29335711,
	0x40099999,0x9999999A, 0x3FF33333,0x33333333, 0x4010270A,0xC3F8A9FA,
	0x40099999,0x9999999A, 0x3FF4CCCC,0xCCCCCCCD, 0x40122519,0x37D24FA7,
	0x40099999,0x9999999A, 0x3FF66666,0x66666666, 0x40146211,0xFF90EA29,
	0x40099999,0x9999999A, 0x3FF80000,0x00000000, 0x4016E5B7,0xD16657E2,
	0x40099999,0x9999999A, 0x3FF99999,0x9999999A, 0x4019B8C2,0x72FBE6E1,
	0x40099999,0x9999999A, 0x3FFB3333,0x33333333, 0x401CE4FC,0xF3D9FC78,
	0x40099999,0x9999999A, 0x3FFCCCCC,0xCCCCCCCD, 0x40203AB3,0xD12BC2C5,
	0x40099999,0x9999999A, 0x3FFE6666,0x66666666, 0x40223B2F,0x18677418,
	0x40099999,0x9999999A, 0x40000000,0x00000000, 0x40247AE1,0x47AE147C,
	0x400A6666,0x66666666, 0x3FB99999,0x9999999A, 0x3FF2076B,0xD4BA49A9,
	0x400A6666,0x66666666, 0x3FC99999,0x9999999A, 0x3FF450B6,0x0FD40104,
	0x400A6666,0x66666666, 0x3FD33333,0x33333333, 0x3FF6E439,0x0B50EBDB,
	0x400A6666,0x66666666, 0x3FD99999,0x9999999A, 0x3FF9CB5E,0x4C47F2BB,
	0x400A6666,0x66666666, 0x3FE00000,0x00000000, 0x3FFD10C0,0xE60BE308,
	0x400A6666,0x66666666, 0x3FE33333,0x33333333, 0x4000602A,0x1CD635C3,
	0x400A6666,0x66666666, 0x3FE66666,0x66666666, 0x400273C7,0xCFB01256,
	0x400A6666,0x66666666, 0x3FE99999,0x9999999A, 0x4004CACF,0xCCAE1CF8,
	0x400A6666,0x66666666, 0x3FECCCCC,0xCCCCCCCD, 0x40076DCE,0xA1EC6C50,
	0x400A6666,0x66666666, 0x3FF00000,0x00000000, 0x400A6666,0x66666666,
	0x400A6666,0x66666666, 0x3FF19999,0x9999999A, 0x400DBF71,0xEBCCF98A,
	0x400A6666,0x66666666, 0x3FF33333,0x33333333, 0x4010C296,0x33754DA3,
	0x400A6666,0x66666666, 0x3FF4CCCC,0xCCCCCCCD, 0x4012E2AF,0x0FBC5C2E,
	0x400A6666,0x66666666, 0x3FF66666,0x66666666, 0x401547C7,0x6554F50C,
	0x400A6666,0x66666666, 0x3FF80000,0x00000000, 0x4017FA9F,0x243034E6,
	0x400A6666,0x66666666, 0x3FF99999,0x9999999A, 0x401B0512,0x492E3F1B,
	0x400A6666,0x66666666, 0x3FFB3333,0x33333333, 0x401E723C,0xE37C1E40,
	0x400A6666,0x66666666, 0x3FFCCCCC,0xCCCCCCCD, 0x40212751,0xD5A93E4C,
	0x400A6666,0x66666666, 0x3FFE6666,0x66666666, 0x40235430,0xDF2FD95B,
	0x400A6666,0x66666666, 0x40000000,0x00000000, 0x4025C7AE,0x147AE147,
	0x400B3333,0x33333333, 0x3FB99999,0x9999999A, 0x3FF21538,0x5F1F360F,
	0x400B3333,0x33333333, 0x3FC99999,0x9999999A, 0x3FF46FDA,0xFAC687A0,
	0x400B3333,0x33333333, 0x3FD33333,0x33333333, 0x3FF718F1,0x2A86ECD2,
	0x400B3333,0x33333333, 0x3FD99999,0x9999999A, 0x3FFA1AB1,0x6CFCD6A5,
	0x400B3333,0x33333333, 0x3FE00000,0x00000000, 0x3FFD80A6,0x9C19E42A,
	0x400B3333,0x33333333, 0x3FE33333,0x33333333, 0x4000ABEE,0x1DFB479A,
	0x400B3333,0x33333333, 0x3FE66666,0x66666666, 0x4002D788,0x4720CE8E,
	0x400B3333,0x33333333, 0x3FE99999,0x9999999A, 0x40054B76,0x9543B6CA,
	0x400B3333,0x33333333, 0x3FECCCCC,0xCCCCCCCD, 0x40081123,0x7A48BB2E,
	0x400B3333,0x33333333, 0x3FF00000,0x00000000, 0x400B3333,0x33333333,
	0x400B3333,0x33333333, 0x3FF19999,0x9999999A, 0x400EBDAC,0xA1B50F1A,
	0x400B3333,0x33333333, 0x3FF33333,0x33333333, 0x40115F13,0xBB8F267A,
	0x400B3333,0x33333333, 0x3FF4CCCC,0xCCCCCCCD, 0x4013A200,0x30F2AFB3,
	0x400B3333,0x33333333, 0x3FF66666,0x66666666, 0x4016304A,0x030A1CD8,
	0x400B3333,0x33333333, 0x3FF80000,0x00000000, 0x401913C0,0xD17C6856,
	0x400B3333,0x33333333, 0x3FF99999,0x9999999A, 0x401C577B,0x32F7F9BA,
	0x400B3333,0x33333333, 0x3FFB3333,0x33333333, 0x40200400,0xA2DBE2C5,
	0x400B3333,0x33333333, 0x3FFCCCCC,0xCCCCCCCD, 0x402219BE,0x65465B5E,
	0x400B3333,0x33333333, 0x3FFE6666,0x66666666, 0x402474F7,0xC18A9F19,
	0x400B3333,0x33333333, 0x40000000,0x00000000, 0x40271EB8,0x51EB851E,
	0x400C0000,0x00000000, 0x3FB99999,0x9999999A, 0x3FF222A8,0x9C88C4EE,
	0x400C0000,0x00000000, 0x3FC99999,0x9999999A, 0x3FF48E46,0x73BDDD91,
	0x400C0000,0x00000000, 0x3FD33333,0x33333333, 0x3FF74C96,0x36EA3144,
	0x400C0000,0x00000000, 0x3FD99999,0x9999999A, 0x3FFA68A1,0x45174C0A,
	0x400C0000,0x00000000, 0x3FE00000,0x00000000, 0x3FFDEEEA,0x11683F49,
	0x400C0000,0x00000000, 0x3FE33333,0x33333333, 0x4000F6CF,0x3B36A26E,
	0x400C0000,0x00000000, 0x3FE66666,0x66666666, 0x40033A68,0x60729FC1,
	0x400C0000,0x00000000, 0x3FE99999,0x9999999A, 0x4005CB5C,0x2BB3B2CE,
	0x400C0000,0x00000000, 0x3FECCCCC,0xCCCCCCCD, 0x4008B3FD,0x8187E15C,
	0x400C0000,0x00000000, 0x3FF00000,0x00000000, 0x400C0000,0x00000000,
	0x400C0000,0x00000000, 0x3FF19999,0x9999999A, 0x400FBCA7,0x11EF58A2,
	0x400C0000,0x00000000, 0x3FF33333,0x33333333, 0x4011FC7D,0xA54621DF,
	0x400C0000,0x00000000, 0x3FF4CCCC,0xCCCCCCCD, 0x40146303,0x700CEB1C,
	0x400C0000,0x00000000, 0x3FF66666,0x66666666, 0x40171B8D,0x1C746288,
	0x400C0000,0x00000000, 0x3FF80000,0x00000000, 0x401A310C,0xCF3B3760,
	0x400C0000,0x00000000, 0x3FF99999,0x9999999A, 0x401DAFEA,0xA79F9C41,
	0x400C0000,0x00000000, 0x3FFB3333,0x33333333, 0x4020D31B,0x54644BC9,
	0x400C0000,0x00000000, 0x3FFCCCCC,0xCCCCCCCD, 0x402311F0,0xA63D3C75,
	0x400C0000,0x00000000, 0x3FFE6666,0x66666666, 0x40259D7D,0xD156E530,
	0x400C0000,0x00000000, 0x40000000,0x00000000, 0x40288000,0x00000000,
	0x400CCCCC,0xCCCCCCCD, 0x3FB99999,0x9999999A, 0x3FF22FC1,0x7FAC725E,
	0x400CCCCC,0xCCCCCCCD, 0x3FC99999,0x9999999A, 0x3FF4AC01,0xE936328F,
	0x400CCCCC,0xCCCCCCCD, 0x3FD33333,0x33333333, 0x3FF77F35,0x6BC53136,
	0x400CCCCC,0xCCCCCCCD, 0x3FD99999,0x9999999A, 0x3FFAB53D,0xF01DC613,
	0x400CCCCC,0xCCCCCCCD, 0x3FE00000,0x00000000, 0x3FFE5B9D,0x136C6D96,
	0x400CCCCC,0xCCCCCCCD, 0x3FE33333,0x33333333, 0x400140D6,0x7B4C125D,
	0x400CCCCC,0xCCCCCCCD, 0x3FE66666,0x66666666, 0x40039C70,0x68878E2B,
	0x400CCCCC,0xCCCCCCCD, 0x3FE99999,0x9999999A, 0x40064A87,0x2B54952B,
	0x400CCCCC,0xCCCCCCCD, 0x3FECCCCC,0xCCCCCCCD, 0x40095660,0x92ACBC5E,
	0x400CCCCC,0xCCCCCCCD, 0x3FF00000,0x00000000, 0x400CCCCC,0xCCCCCCCD,
	0x400CCCCC,0xCCCCCCCD, 0x3FF19999,0x9999999A, 0x40105E2E,0x261B33BC,
	0x400CCCCC,0xCCCCCCCD, 0x3FF33333,0x33333333, 0x40129ACE,0x85172D81,
	0x400CCCCC,0xCCCCCCCD, 0x3FF4CCCC,0xCCCCCCCD, 0x401525B0,0x14317918,
	0x400CCCCC,0xCCCCCCCD, 0x3FF66666,0x66666666, 0x40180984,0x8B4DFF10,
	0x400CCCCC,0xCCCCCCCD, 0x3FF80000,0x00000000, 0x401B5273,0xC4AE62A1,
	0x400CCCCC,0xCCCCCCCD, 0x3FF99999,0x9999999A, 0x401F0E4E,0xDDEF5442,
	0x400CCCCC,0xCCCCCCCD, 0x3FFB3333,0x33333333, 0x4021A665,0x2AE0665A,
	0x400CCCCC,0xCCCCCCCD, 0x3FFCCCCC,0xCCCCCCCD, 0x40240FE0,0x0D65B973,
	0x400CCCCC,0xCCCCCCCD, 0x3FFE6666,0x66666666, 0x4026CDBD,0x50CEA987,
	0x400CCCCC,0xCCCCCCCD, 0x40000000,0x00000000, 0x4029EB85,0x1EB851EC,
	0x400D9999,0x9999999A, 0x3FB99999,0x9999999A, 0x3FF23C87,0x9670A28C,
	0x400D9999,0x9999999A, 0x3FC99999,0x9999999A, 0x3FF4C916,0x0FE2BAB0,
	0x400D9999,0x9999999A, 0x3FD33333,0x33333333, 0x3FF7B0DB,0x08B44BE4,
	0x400D9999,0x9999999A, 0x3FD99999,0x9999999A, 0x3FFB0096,0x62245F0A,
	0x400D9999,0x9999999A, 0x3FE00000,0x00000000, 0x3FFEC6D0,0x353167A9,
	0x400D9999,0x9999999A, 0x3FE33333,0x33333333, 0x40018A0C,0x4BBE2B80,
	0x400D9999,0x9999999A, 0x3FE66666,0x66666666, 0x4003FDA8,0x250364F3,
	0x400D9999,0x9999999A, 0x3FE99999,0x9999999A, 0x4006C8FD,0xC86019A3,
	0x400D9999,0x9999999A, 0x3FECCCCC,0xCCCCCCCD, 0x4009F850,0x4F358183,
	0x400D9999,0x9999999A, 0x3FF00000,0x00000000, 0x400D9999,0x9999999A,
	0x400D9999,0x9999999A, 0x3FF19999,0x9999999A, 0x4010DE63,0xD18E965B,
	0x400D9999,0x9999999A, 0x3FF33333,0x33333333, 0x40133A01,0x35181FE3,
	0x400D9999,0x9999999A, 0x3FF4CCCC,0xCCCCCCCD, 0x4015E9FD,0xCE739300,
	0x400D9999,0x9999999A, 0x3FF66666,0x66666666, 0x4018FA24,0xB461A4B6,
	0x400D9999,0x9999999A, 0x3FF80000,0x00000000, 0x401C77E6,0xFE00E649,
	0x400D9999,0x9999999A, 0x3FF99999,0x9999999A, 0x4020394B,0x5FA981D8,
	0x400D9999,0x9999999A, 0x3FFB3333,0x33333333, 0x40227DD5,0x223CBD61,
	0x400D9999,0x9999999A, 0x3FFCCCCC,0xCCCCCCCD, 0x40251384,0x5958E484,
	0x400D9999,0x9999999A, 0x3FFE6666,0x66666666, 0x402805B0,0xAFAB17CC,
	0x400D9999,0x9999999A, 0x40000000,0x00000000, 0x402B6147,0xAE147AE2,
	0x400E6666,0x66666666, 0x3FB99999,0x9999999A, 0x3FF248FF,0x146D0FF9,
	0x400E6666,0x66666666, 0x3FC99999,0x9999999A, 0x3FF4E58A,0xF58FD4AE,
	0x400E6666,0x66666666, 0x3FD33333,0x33333333, 0x3FF7E192,0x6A96DE76,
	0x400E6666,0x66666666, 0x3FD99999,0x9999999A, 0x3FFB4AB8,0x8453A384,
	0x400E6666,0x66666666, 0x3FE00000,0x00000000, 0x3FFF3092,0xECE5BC35,
	0x400E6666,0x66666666, 0x3FE33333,0x33333333, 0x4001D278,0x8ED1B766,
	0x400E6666,0x66666666, 0x3FE66666,0x66666666, 0x40045E16,0xE050948C,
	0x400E6666,0x66666666, 0x3FE99999,0x9999999A, 0x400746C5,0xD8D91AA8,
	0x400E6666,0x66666666, 0x3FECCCCC,0xCCCCCCCD, 0x400A99D0,0x23EC5FA7,
	0x400E6666,0x66666666, 0x3FF00000,0x00000000, 0x400E6666,0x66666666,
	0x400E6666,0x66666666, 0x3FF19999,0x9999999A, 0x40115EF2,0x53679BF9,
	0x400E6666,0x66666666, 0x3FF33333,0x33333333, 0x4013DA10,0xCFAF0A0B,
	0x400E6666,0x66666666, 0x3FF4CCCC,0xCCCCCCCD, 0x4016AFE4,0xB20F5357,
	0x400E6666,0x66666666, 0x3FF66666,0x66666666, 0x4019ED62,0x7DB5DB55,
	0x400E6666,0x66666666, 0x3FF80000,0x00000000, 0x401DA158,0x610D72CC,
	0x400E6666,0x66666666, 0x3FF99999,0x9999999A, 0x4020EE58,0xEE1407D4,
	0x400E6666,0x66666666, 0x3FFB3333,0x33333333, 0x40235962,0x884C8D1E,
	0x400E6666,0x66666666, 0x3FFCCCCC,0xCCCCCCCD, 0x40261CD5,0x8E0172EC,
	0x400E6666,0x66666666, 0x3FFE6666,0x66666666, 0x40294552,0x8886F477,
	0x400E6666,0x66666666, 0x40000000,0x00000000, 0x402CE147,0xAE147AE1,
	0x400F3333,0x33333333, 0x3FB99999,0x9999999A, 0x3FF2552B,0xDC147B86,
	0x400F3333,0x33333333, 0x3FC99999,0x9999999A, 0x3FF50168,0x11A8AA50,
	0x400F3333,0x33333333, 0x3FD33333,0x33333333, 0x3FF81166,0x217179F7,
	0x400F3333,0x33333333, 0x3FD99999,0x9999999A, 0x3FFB93B1,0x4E01D9CA,
	0x400F3333,0x33333333, 0x3FE00000,0x00000000, 0x3FFF98F3,0xADEF13F2,
	0x400F3333,0x33333333, 0x3FE33333,0x33333333, 0x40021A22,0xA7F3B4DB,
	0x400F3333,0x33333333, 0x3FE66666,0x66666666, 0x4004BDC3,0x744A1677,
	0x400F3333,0x33333333, 0x3FE99999,0x9999999A, 0x4007C3E4,0xDC763839,
	0x400F3333,0x33333333, 0x3FECCCCC,0xCCCCCCCD, 0x400B3AE3,0x4D333AF7,
	0x400F3333,0x33333333, 0x3FF00000,0x00000000, 0x400F3333,0x33333333,
	0x400F3333,0x33333333, 0x3FF19999,0x9999999A, 0x4011DFD7,0x902D920A,
	0x400F3333,0x33333333, 0x3FF33333,0x33333333, 0x40147AF8,0xAAD13FA7,
	0x400F3333,0x33333333, 0x3FF4CCCC,0xCCCCCCCD, 0x4017775D,0x2D683D51,
	0x400F3333,0x33333333, 0x3FF66666,0x66666666, 0x401AE333,0x45A83457,
	0x400F3333,0x33333333, 0x3FF80000,0x00000000, 0x401ECEBA,0x632F803F,
	0x400F3333,0x33333333, 0x3FF99999,0x9999999A, 0x4021A648,0x308D9D23,
	0x400F3333,0x33333333, 0x3FFB3333,0x33333333, 0x40243904,0xF7C83C4D,
	0x400F3333,0x33333333, 0x3FFCCCCC,0xCCCCCCCD, 0x40272BCB,0xF08CDD37,
	0x400F3333,0x33333333, 0x3FFE6666,0x66666666, 0x402A8C9D,0x9E78597C,
	0x400F3333,0x33333333, 0x40000000,0x00000000, 0x402E6B85,0x1EB851EB,
	0x40100000,0x00000000, 0x3FB99999,0x9999999A, 0x3FF26111,0x86BAE675,
	0x40100000,0x00000000, 0x3FC99999,0x9999999A, 0x3FF51CB4,0x53B9536C,
	0x40100000,0x00000000, 0x3FD33333,0x33333333, 0x3FF84060,0x03B2AE5C,
	0x40100000,0x00000000, 0x3FD99999,0x9999999A, 0x3FFBDB8C,0xDADBE120,
	0x40100000,0x00000000, 0x3FE00000,0x00000000, 0x40000000,0x00000000,
	0x40100000,0x00000000, 0x3FE33333,0x33333333, 0x40026111,0x86BAE674,
	0x40100000,0x00000000, 0x3FE66666,0x66666666, 0x40051CB4,0x53B9536C,
	0x40100000,0x00000000, 0x3FE99999,0x9999999A, 0x40084060,0x03B2AE5D,
	0x40100000,0x00000000, 0x3FECCCCC,0xCCCCCCCD, 0x400BDB8C,0xDADBE120,
	0x40100000,0x00000000, 0x3FF00000,0x00000000, 0x40100000,0x00000000,
	0x40100000,0x00000000, 0x3FF19999,0x9999999A, 0x40126111,0x86BAE675,
	0x40100000,0x00000000, 0x3FF33333,0x33333333, 0x40151CB4,0x53B9536C,
	0x40100000,0x00000000, 0x3FF4CCCC,0xCCCCCCCD, 0x40184060,0x03B2AE5D,
	0x40100000,0x00000000, 0x3FF66666,0x66666666, 0x401BDB8C,0xDADBE11F,
	0x40100000,0x00000000, 0x3FF80000,0x00000000, 0x40200000,0x00000000,
	0x40100000,0x00000000, 0x3FF99999,0x9999999A, 0x40226111,0x86BAE675,
	0x40100000,0x00000000, 0x3FFB3333,0x33333333, 0x40251CB4,0x53B9536C,
	0x40100000,0x00000000, 0x3FFCCCCC,0xCCCCCCCD, 0x40284060,0x03B2AE5D,
	0x40100000,0x00000000, 0x3FFE6666,0x66666666, 0x402BDB8C,0xDADBE11F,
	0x40100000,0x00000000, 0x40000000,0x00000000, 0x40300000,0x00000000,
	};

LOCAL_D const TUint32 PowerTest2[] =
	{
	0x40000000,0x00000000, 2, 0x40100000,0x00000000,
	0x40000000,0x00000000, 3, 0x40200000,0x00000000,
	0x40000000,0x00000000, 4, 0x40300000,0x00000000,
	0x40000000,0x00000000, 5, 0x40400000,0x00000000,
	0x40000000,0x00000000, 6, 0x40500000,0x00000000,
	0x40000000,0x00000000, 7, 0x40600000,0x00000000,
	0x40000000,0x00000000, 8, 0x40700000,0x00000000,
	0x40000000,0x00000000, 9, 0x40800000,0x00000000,
	0x40000000,0x00000000, 10, 0x40900000,0x00000000,
	0x40000000,0x00000000, 11, 0x40A00000,0x00000000,
	0x40000000,0x00000000, 12, 0x40B00000,0x00000000,
	0x40000000,0x00000000, 13, 0x40C00000,0x00000000,
	0x40000000,0x00000000, 14, 0x40D00000,0x00000000,
	0x40000000,0x00000000, 15, 0x40E00000,0x00000000,
	0x40000000,0x00000000, 16, 0x40F00000,0x00000000,
	0x40000000,0x00000000, 17, 0x41000000,0x00000000,
	0x40000000,0x00000000, 18, 0x41100000,0x00000000,
	0x40000000,0x00000000, 19, 0x41200000,0x00000000,
	0x40000000,0x00000000, 20, 0x41300000,0x00000000,
	0x40000000,0x00000000, 21, 0x41400000,0x00000000,
	0x40000000,0x00000000, 22, 0x41500000,0x00000000,
	0x40000000,0x00000000, 23, 0x41600000,0x00000000,
	0x40000000,0x00000000, 24, 0x41700000,0x00000000,
	0x40000000,0x00000000, 25, 0x41800000,0x00000000,
	0x40000000,0x00000000, 26, 0x41900000,0x00000000,
	0x40000000,0x00000000, 27, 0x41A00000,0x00000000,
	0x40000000,0x00000000, 28, 0x41B00000,0x00000000,
	0x40000000,0x00000000, 29, 0x41C00000,0x00000000,
	0x40000000,0x00000000, 30, 0x41D00000,0x00000000,
	0x40000000,0x00000000, 31, 0x41E00000,0x00000000,
	0x40000000,0x00000000, 32, 0x41F00000,0x00000000,
	0x40000000,0x00000000, 33, 0x42000000,0x00000000,
	0x40000000,0x00000000, 34, 0x42100000,0x00000000,
	0x40000000,0x00000000, 35, 0x42200000,0x00000000,
	0x40000000,0x00000000, 36, 0x42300000,0x00000000,
	0x40000000,0x00000000, 37, 0x42400000,0x00000000,
	0x40000000,0x00000000, 38, 0x42500000,0x00000000,
	0x40000000,0x00000000, 39, 0x42600000,0x00000000,
	0x40000000,0x00000000, 40, 0x42700000,0x00000000,
	0x40000000,0x00000000, 41, 0x42800000,0x00000000,
	0x40000000,0x00000000, 42, 0x42900000,0x00000000,
	0x40000000,0x00000000, 43, 0x42A00000,0x00000000,
	0x40000000,0x00000000, 44, 0x42B00000,0x00000000,
	0x40000000,0x00000000, 45, 0x42C00000,0x00000000,
	0x40000000,0x00000000, 46, 0x42D00000,0x00000000,
	0x40000000,0x00000000, 47, 0x42E00000,0x00000000,
	0x40000000,0x00000000, 48, 0x42F00000,0x00000000,
	0x40000000,0x00000000, 49, 0x43000000,0x00000000,
	0x40000000,0x00000000, 50, 0x43100000,0x00000000,
	0x40000000,0x00000000, 51, 0x43200000,0x00000000,
	0x40000000,0x00000000, 52, 0x43300000,0x00000000,
	0x40000000,0x00000000, 53, 0x43400000,0x00000000,
	0x40000000,0x00000000, 54, 0x43500000,0x00000000,
	0x40000000,0x00000000, 55, 0x43600000,0x00000000,
	0x40000000,0x00000000, 56, 0x43700000,0x00000000,
	0x40000000,0x00000000, 57, 0x43800000,0x00000000,
	0x40000000,0x00000000, 58, 0x43900000,0x00000000,
	0x40000000,0x00000000, 59, 0x43A00000,0x00000000,
	0x40000000,0x00000000, 60, 0x43B00000,0x00000000,
	0x40000000,0x00000000, 61, 0x43C00000,0x00000000,
	0x40000000,0x00000000, 62, 0x43D00000,0x00000000,
	0x40000000,0x00000000, 63, 0x43E00000,0x00000000,
	0x40000000,0x00000000, 64, 0x43F00000,0x00000000,
	0x40000000,0x00000000, 65, 0x44000000,0x00000000,
	0x40000000,0x00000000, 66, 0x44100000,0x00000000,
	0x40000000,0x00000000, 67, 0x44200000,0x00000000,
	0x40000000,0x00000000, 68, 0x44300000,0x00000000,
	0x40000000,0x00000000, 69, 0x44400000,0x00000000,
	0x40000000,0x00000000, 70, 0x44500000,0x00000000,
	0x40000000,0x00000000, 71, 0x44600000,0x00000000,
	0x40000000,0x00000000, 72, 0x44700000,0x00000000,
	0x40000000,0x00000000, 73, 0x44800000,0x00000000,
	0x40000000,0x00000000, 74, 0x44900000,0x00000000,
	0x40000000,0x00000000, 75, 0x44A00000,0x00000000,
	0x40000000,0x00000000, 76, 0x44B00000,0x00000000,
	0x40000000,0x00000000, 77, 0x44C00000,0x00000000,
	0x40000000,0x00000000, 78, 0x44D00000,0x00000000,
	0x40000000,0x00000000, 79, 0x44E00000,0x00000000,
	0x40000000,0x00000000, 80, 0x44F00000,0x00000000,
	0x40000000,0x00000000, 81, 0x45000000,0x00000000,
	0x40000000,0x00000000, 82, 0x45100000,0x00000000,
	0x40000000,0x00000000, 83, 0x45200000,0x00000000,
	0x40000000,0x00000000, 84, 0x45300000,0x00000000,
	0x40000000,0x00000000, 85, 0x45400000,0x00000000,
	0x40000000,0x00000000, 86, 0x45500000,0x00000000,
	0x40000000,0x00000000, 87, 0x45600000,0x00000000,
	0x40000000,0x00000000, 88, 0x45700000,0x00000000,
	0x40000000,0x00000000, 89, 0x45800000,0x00000000,
	0x40000000,0x00000000, 90, 0x45900000,0x00000000,
	0x40000000,0x00000000, 91, 0x45A00000,0x00000000,
	0x40000000,0x00000000, 92, 0x45B00000,0x00000000,
	0x40000000,0x00000000, 93, 0x45C00000,0x00000000,
	0x40000000,0x00000000, 94, 0x45D00000,0x00000000,
	0x40000000,0x00000000, 95, 0x45E00000,0x00000000,
	0x40000000,0x00000000, 96, 0x45F00000,0x00000000,
	0x40000000,0x00000000, 97, 0x46000000,0x00000000,
	0x40000000,0x00000000, 98, 0x46100000,0x00000000,
	0x40000000,0x00000000, 99, 0x46200000,0x00000000,
	0x40000000,0x00000000, 100, 0x46300000,0x00000000,
	0x40000000,0x00000000, 101, 0x46400000,0x00000000,
	0x40000000,0x00000000, 102, 0x46500000,0x00000000,
	0x40000000,0x00000000, 103, 0x46600000,0x00000000,
	0x40000000,0x00000000, 104, 0x46700000,0x00000000,
	0x40000000,0x00000000, 105, 0x46800000,0x00000000,
	0x40000000,0x00000000, 106, 0x46900000,0x00000000,
	0x40000000,0x00000000, 107, 0x46A00000,0x00000000,
	0x40000000,0x00000000, 108, 0x46B00000,0x00000000,
	0x40000000,0x00000000, 109, 0x46C00000,0x00000000,
	0x40000000,0x00000000, 110, 0x46D00000,0x00000000,
	0x40000000,0x00000000, 111, 0x46E00000,0x00000000,
	0x40000000,0x00000000, 112, 0x46F00000,0x00000000,
	0x40000000,0x00000000, 113, 0x47000000,0x00000000,
	0x40000000,0x00000000, 114, 0x47100000,0x00000000,
	0x40000000,0x00000000, 115, 0x47200000,0x00000000,
	0x40000000,0x00000000, 116, 0x47300000,0x00000000,
	0x40000000,0x00000000, 117, 0x47400000,0x00000000,
	0x40000000,0x00000000, 118, 0x47500000,0x00000000,
	0x40000000,0x00000000, 119, 0x47600000,0x00000000,
	0x40000000,0x00000000, 120, 0x47700000,0x00000000,
	0x40000000,0x00000000, 121, 0x47800000,0x00000000,
	0x40000000,0x00000000, 122, 0x47900000,0x00000000,
	0x40000000,0x00000000, 123, 0x47A00000,0x00000000,
	0x40000000,0x00000000, 124, 0x47B00000,0x00000000,
	0x40000000,0x00000000, 125, 0x47C00000,0x00000000,
	0x40000000,0x00000000, 126, 0x47D00000,0x00000000,
	0x40000000,0x00000000, 127, 0x47E00000,0x00000000,
	0x40000000,0x00000000, 128, 0x47F00000,0x00000000,
	0x40000000,0x00000000, 129, 0x48000000,0x00000000,
	0x40000000,0x00000000, 130, 0x48100000,0x00000000,
	0x40000000,0x00000000, 131, 0x48200000,0x00000000,
	0x40000000,0x00000000, 132, 0x48300000,0x00000000,
	0x40000000,0x00000000, 133, 0x48400000,0x00000000,
	0x40000000,0x00000000, 134, 0x48500000,0x00000000,
	0x40000000,0x00000000, 135, 0x48600000,0x00000000,
	0x40000000,0x00000000, 136, 0x48700000,0x00000000,
	0x40000000,0x00000000, 137, 0x48800000,0x00000000,
	0x40000000,0x00000000, 138, 0x48900000,0x00000000,
	0x40000000,0x00000000, 139, 0x48A00000,0x00000000,
	0x40000000,0x00000000, 140, 0x48B00000,0x00000000,
	0x40000000,0x00000000, 141, 0x48C00000,0x00000000,
	0x40000000,0x00000000, 142, 0x48D00000,0x00000000,
	0x40000000,0x00000000, 143, 0x48E00000,0x00000000,
	0x40000000,0x00000000, 144, 0x48F00000,0x00000000,
	0x40000000,0x00000000, 145, 0x49000000,0x00000000,
	0x40000000,0x00000000, 146, 0x49100000,0x00000000,
	0x40000000,0x00000000, 147, 0x49200000,0x00000000,
	0x40000000,0x00000000, 148, 0x49300000,0x00000000,
	0x40000000,0x00000000, 149, 0x49400000,0x00000000,
	0x40000000,0x00000000, 150, 0x49500000,0x00000000,
	0x40000000,0x00000000, 151, 0x49600000,0x00000000,
	0x40000000,0x00000000, 152, 0x49700000,0x00000000,
	0x40000000,0x00000000, 153, 0x49800000,0x00000000,
	0x40000000,0x00000000, 154, 0x49900000,0x00000000,
	0x40000000,0x00000000, 155, 0x49A00000,0x00000000,
	0x40000000,0x00000000, 156, 0x49B00000,0x00000000,
	0x40000000,0x00000000, 157, 0x49C00000,0x00000000,
	0x40000000,0x00000000, 158, 0x49D00000,0x00000000,
	0x40000000,0x00000000, 159, 0x49E00000,0x00000000,
	0x40000000,0x00000000, 160, 0x49F00000,0x00000000,
	0x40000000,0x00000000, 161, 0x4A000000,0x00000000,
	0x40000000,0x00000000, 162, 0x4A100000,0x00000000,
	0x40000000,0x00000000, 163, 0x4A200000,0x00000000,
	0x40000000,0x00000000, 164, 0x4A300000,0x00000000,
	0x40000000,0x00000000, 165, 0x4A400000,0x00000000,
	0x40000000,0x00000000, 166, 0x4A500000,0x00000000,
	0x40000000,0x00000000, 167, 0x4A600000,0x00000000,
	0x40000000,0x00000000, 168, 0x4A700000,0x00000000,
	0x40000000,0x00000000, 169, 0x4A800000,0x00000000,
	0x40000000,0x00000000, 170, 0x4A900000,0x00000000,
	0x40000000,0x00000000, 171, 0x4AA00000,0x00000000,
	0x40000000,0x00000000, 172, 0x4AB00000,0x00000000,
	0x40000000,0x00000000, 173, 0x4AC00000,0x00000000,
	0x40000000,0x00000000, 174, 0x4AD00000,0x00000000,
	0x40000000,0x00000000, 175, 0x4AE00000,0x00000000,
	0x40000000,0x00000000, 176, 0x4AF00000,0x00000000,
	0x40000000,0x00000000, 177, 0x4B000000,0x00000000,
	0x40000000,0x00000000, 178, 0x4B100000,0x00000000,
	0x40000000,0x00000000, 179, 0x4B200000,0x00000000,
	0x40000000,0x00000000, 180, 0x4B300000,0x00000000,
	0x40000000,0x00000000, 181, 0x4B400000,0x00000000,
	0x40000000,0x00000000, 182, 0x4B500000,0x00000000,
	0x40000000,0x00000000, 183, 0x4B600000,0x00000000,
	0x40000000,0x00000000, 184, 0x4B700000,0x00000000,
	0x40000000,0x00000000, 185, 0x4B800000,0x00000000,
	0x40000000,0x00000000, 186, 0x4B900000,0x00000000,
	0x40000000,0x00000000, 187, 0x4BA00000,0x00000000,
	0x40000000,0x00000000, 188, 0x4BB00000,0x00000000,
	0x40000000,0x00000000, 189, 0x4BC00000,0x00000000,
	0x40000000,0x00000000, 190, 0x4BD00000,0x00000000,
	0x40000000,0x00000000, 191, 0x4BE00000,0x00000000,
	0x40000000,0x00000000, 192, 0x4BF00000,0x00000000,
	0x40000000,0x00000000, 193, 0x4C000000,0x00000000,
	0x40000000,0x00000000, 194, 0x4C100000,0x00000000,
	0x40000000,0x00000000, 195, 0x4C200000,0x00000000,
	0x40000000,0x00000000, 196, 0x4C300000,0x00000000,
	0x40000000,0x00000000, 197, 0x4C400000,0x00000000,
	0x40000000,0x00000000, 198, 0x4C500000,0x00000000,
	0x40000000,0x00000000, 199, 0x4C600000,0x00000000,
	0x40000000,0x00000000, 200, 0x4C700000,0x00000000,
	0x40000000,0x00000000, 201, 0x4C800000,0x00000000,
	0x40000000,0x00000000, 202, 0x4C900000,0x00000000,
	0x40000000,0x00000000, 203, 0x4CA00000,0x00000000,
	0x40000000,0x00000000, 204, 0x4CB00000,0x00000000,
	0x40000000,0x00000000, 205, 0x4CC00000,0x00000000,
	0x40000000,0x00000000, 206, 0x4CD00000,0x00000000,
	0x40000000,0x00000000, 207, 0x4CE00000,0x00000000,
	0x40000000,0x00000000, 208, 0x4CF00000,0x00000000,
	0x40000000,0x00000000, 209, 0x4D000000,0x00000000,
	0x40000000,0x00000000, 210, 0x4D100000,0x00000000,
	0x40000000,0x00000000, 211, 0x4D200000,0x00000000,
	0x40000000,0x00000000, 212, 0x4D300000,0x00000000,
	0x40000000,0x00000000, 213, 0x4D400000,0x00000000,
	0x40000000,0x00000000, 214, 0x4D500000,0x00000000,
	0x40000000,0x00000000, 215, 0x4D600000,0x00000000,
	0x40000000,0x00000000, 216, 0x4D700000,0x00000000,
	0x40000000,0x00000000, 217, 0x4D800000,0x00000000,
	0x40000000,0x00000000, 218, 0x4D900000,0x00000000,
	0x40000000,0x00000000, 219, 0x4DA00000,0x00000000,
	0x40000000,0x00000000, 220, 0x4DB00000,0x00000000,
	0x40000000,0x00000000, 221, 0x4DC00000,0x00000000,
	0x40000000,0x00000000, 222, 0x4DD00000,0x00000000,
	0x40000000,0x00000000, 223, 0x4DE00000,0x00000000,
	0x40000000,0x00000000, 224, 0x4DF00000,0x00000000,
	0x40000000,0x00000000, 225, 0x4E000000,0x00000000,
	0x40000000,0x00000000, 226, 0x4E100000,0x00000000,
	0x40000000,0x00000000, 227, 0x4E200000,0x00000000,
	0x40000000,0x00000000, 228, 0x4E300000,0x00000000,
	0x40000000,0x00000000, 229, 0x4E400000,0x00000000,
	0x40000000,0x00000000, 230, 0x4E500000,0x00000000,
	0x40000000,0x00000000, 231, 0x4E600000,0x00000000,
	0x40000000,0x00000000, 232, 0x4E700000,0x00000000,
	0x40000000,0x00000000, 233, 0x4E800000,0x00000000,
	0x40000000,0x00000000, 234, 0x4E900000,0x00000000,
	0x40000000,0x00000000, 235, 0x4EA00000,0x00000000,
	0x40000000,0x00000000, 236, 0x4EB00000,0x00000000,
	0x40000000,0x00000000, 237, 0x4EC00000,0x00000000,
	0x40000000,0x00000000, 238, 0x4ED00000,0x00000000,
	0x40000000,0x00000000, 239, 0x4EE00000,0x00000000,
	0x40000000,0x00000000, 240, 0x4EF00000,0x00000000,
	0x40000000,0x00000000, 241, 0x4F000000,0x00000000,
	0x40000000,0x00000000, 242, 0x4F100000,0x00000000,
	0x40000000,0x00000000, 243, 0x4F200000,0x00000000,
	0x40000000,0x00000000, 244, 0x4F300000,0x00000000,
	0x40000000,0x00000000, 245, 0x4F400000,0x00000000,
	0x40000000,0x00000000, 246, 0x4F500000,0x00000000,
	0x40000000,0x00000000, 247, 0x4F600000,0x00000000,
	0x40000000,0x00000000, 248, 0x4F700000,0x00000000,
	0x40000000,0x00000000, 249, 0x4F800000,0x00000000,
	0x40000000,0x00000000, 250, 0x4F900000,0x00000000,
	0x40000000,0x00000000, 251, 0x4FA00000,0x00000000,
	0x40000000,0x00000000, 252, 0x4FB00000,0x00000000,
	0x40000000,0x00000000, 253, 0x4FC00000,0x00000000,
	0x40000000,0x00000000, 254, 0x4FD00000,0x00000000,
	0x40000000,0x00000000, 255, 0x4FE00000,0x00000000,
	0x40000000,0x00000000, 256, 0x4FF00000,0x00000000,
	0x40000000,0x00000000, 257, 0x50000000,0x00000000,
	0x40000000,0x00000000, 258, 0x50100000,0x00000000,
	0x40000000,0x00000000, 259, 0x50200000,0x00000000,
	0x40000000,0x00000000, 260, 0x50300000,0x00000000,
	0x40000000,0x00000000, 261, 0x50400000,0x00000000,
	0x40000000,0x00000000, 262, 0x50500000,0x00000000,
	0x40000000,0x00000000, 263, 0x50600000,0x00000000,
	0x40000000,0x00000000, 264, 0x50700000,0x00000000,
	0x40000000,0x00000000, 265, 0x50800000,0x00000000,
	0x40000000,0x00000000, 266, 0x50900000,0x00000000,
	0x40000000,0x00000000, 267, 0x50A00000,0x00000000,
	0x40000000,0x00000000, 268, 0x50B00000,0x00000000,
	0x40000000,0x00000000, 269, 0x50C00000,0x00000000,
	0x40000000,0x00000000, 270, 0x50D00000,0x00000000,
	0x40000000,0x00000000, 271, 0x50E00000,0x00000000,
	0x40000000,0x00000000, 272, 0x50F00000,0x00000000,
	0x40000000,0x00000000, 273, 0x51000000,0x00000000,
	0x40000000,0x00000000, 274, 0x51100000,0x00000000,
	0x40000000,0x00000000, 275, 0x51200000,0x00000000,
	0x40000000,0x00000000, 276, 0x51300000,0x00000000,
	0x40000000,0x00000000, 277, 0x51400000,0x00000000,
	0x40000000,0x00000000, 278, 0x51500000,0x00000000,
	0x40000000,0x00000000, 279, 0x51600000,0x00000000,
	0x40000000,0x00000000, 280, 0x51700000,0x00000000,
	0x40000000,0x00000000, 281, 0x51800000,0x00000000,
	0x40000000,0x00000000, 282, 0x51900000,0x00000000,
	0x40000000,0x00000000, 283, 0x51A00000,0x00000000,
	0x40000000,0x00000000, 284, 0x51B00000,0x00000000,
	0x40000000,0x00000000, 285, 0x51C00000,0x00000000,
	0x40000000,0x00000000, 286, 0x51D00000,0x00000000,
	0x40000000,0x00000000, 287, 0x51E00000,0x00000000,
	0x40000000,0x00000000, 288, 0x51F00000,0x00000000,
	0x40000000,0x00000000, 289, 0x52000000,0x00000000,
	0x40000000,0x00000000, 290, 0x52100000,0x00000000,
	0x40000000,0x00000000, 291, 0x52200000,0x00000000,
	0x40000000,0x00000000, 292, 0x52300000,0x00000000,
	0x40000000,0x00000000, 293, 0x52400000,0x00000000,
	0x40000000,0x00000000, 294, 0x52500000,0x00000000,
	0x40000000,0x00000000, 295, 0x52600000,0x00000000,
	0x40000000,0x00000000, 296, 0x52700000,0x00000000,
	0x40000000,0x00000000, 297, 0x52800000,0x00000000,
	0x40000000,0x00000000, 298, 0x52900000,0x00000000,
	0x40000000,0x00000000, 299, 0x52A00000,0x00000000,
	0x40000000,0x00000000, 300, 0x52B00000,0x00000000,
	0x40080000,0x00000000, 2, 0x40220000,0x00000000,
	0x40080000,0x00000000, 3, 0x403B0000,0x00000000,
	0x40080000,0x00000000, 4, 0x40544000,0x00000000,
	0x40080000,0x00000000, 5, 0x406E6000,0x00000000,
	0x40080000,0x00000000, 6, 0x4086C800,0x00000000,
	0x40080000,0x00000000, 7, 0x40A11600,0x00000000,
	0x40080000,0x00000000, 8, 0x40B9A100,0x00000000,
	0x40080000,0x00000000, 9, 0x40D338C0,0x00000000,
	0x40080000,0x00000000, 10, 0x40ECD520,0x00000000,
	0x40080000,0x00000000, 11, 0x41059FD8,0x00000000,
	0x40080000,0x00000000, 12, 0x412037E2,0x00000000,
	0x40080000,0x00000000, 13, 0x413853D3,0x00000000,
	0x40080000,0x00000000, 14, 0x41523EDE,0x40000000,
	0x40080000,0x00000000, 15, 0x416B5E4D,0x60000000,
	0x40080000,0x00000000, 16, 0x418486BA,0x08000000,
	0x40080000,0x00000000, 17, 0x419ECA17,0x0C000000,
	0x40080000,0x00000000, 18, 0x41B71791,0x49000000,
	0x40080000,0x00000000, 19, 0x41D151AC,0xF6C00000,
	0x40080000,0x00000000, 20, 0x41E9FA83,0x72200000,
	0x40080000,0x00000000, 21, 0x42037BE2,0x95980000,
	0x40080000,0x00000000, 22, 0x421D39D3,0xE0640000,
	0x40080000,0x00000000, 23, 0x4235EB5E,0xE84B0000,
	0x40080000,0x00000000, 24, 0x42507087,0x2E384000,
	0x40080000,0x00000000, 25, 0x4268A8CA,0xC5546000,
	0x40080000,0x00000000, 26, 0x42827E98,0x13FF4800,
	0x40080000,0x00000000, 27, 0x429BBDE4,0x1DFEEC00,
	0x40080000,0x00000000, 28, 0x42B4CE6B,0x167F3100,
	0x40080000,0x00000000, 29, 0x42CF35A0,0xA1BEC980,
	0x40080000,0x00000000, 30, 0x42E76838,0x794F1720,
	0x40080000,0x00000000, 31, 0x43018E2A,0x5AFB5158,
	0x40080000,0x00000000, 32, 0x431A553F,0x8878FA04,
	0x40080000,0x00000000, 33, 0x4333BFEF,0xA65ABB83,
	0x40080000,0x00000000, 34, 0x434D9FE7,0x79881944,
	0x40080000,0x00000000, 35, 0x436637ED,0x9B2612F3,
	0x40080000,0x00000000, 36, 0x4380A9F2,0x345C8E37,
	0x40080000,0x00000000, 37, 0x4398FEEB,0x4E8AD552,
	0x40080000,0x00000000, 38, 0x43B2BF30,0x7AE81FFD,
	0x40080000,0x00000000, 39, 0x43CC1EC8,0xB85C2FFC,
	0x40080000,0x00000000, 40, 0x43E51716,0x8A4523FD,
	0x40080000,0x00000000, 41, 0x43FFA2A1,0xCF67B5FC,
	0x40080000,0x00000000, 42, 0x4417B9F9,0x5B8DC87D,
	0x40080000,0x00000000, 43, 0x4431CB7B,0x04AA565D,
	0x40080000,0x00000000, 44, 0x444AB138,0x86FF818C,
	0x40080000,0x00000000, 45, 0x446404EA,0x653FA129,
	0x40080000,0x00000000, 46, 0x447E075F,0x97DF71BE,
	0x40080000,0x00000000, 47, 0x44968587,0xB1E7954E,
	0x40080000,0x00000000, 48, 0x44B0E425,0xC56DAFFB,
	0x40080000,0x00000000, 49, 0x44C95638,0xA82487F8,
	0x40080000,0x00000000, 50, 0x44E300AA,0x7E1B65FA,
	0x40080000,0x00000000, 51, 0x44FC80FF,0xBD2918F7,
	0x40080000,0x00000000, 52, 0x451560BF,0xCDDED2B9,
	0x40080000,0x00000000, 53, 0x4530088F,0xDA671E0B,
	0x40080000,0x00000000, 54, 0x45480CD7,0xC79AAD11,
	0x40080000,0x00000000, 55, 0x456209A1,0xD5B401CC,
	0x40080000,0x00000000, 56, 0x457B0E72,0xC08E02B3,
	0x40080000,0x00000000, 57, 0x45944AD6,0x106A8206,
	0x40080000,0x00000000, 58, 0x45AE7041,0x189FC309,
	0x40080000,0x00000000, 59, 0x45C6D430,0xD277D247,
	0x40080000,0x00000000, 60, 0x45E11F24,0x9DD9DDB5,
	0x40080000,0x00000000, 61, 0x45F9AEB6,0xECC6CC8F,
	0x40080000,0x00000000, 62, 0x46134309,0x3195196C,
	0x40080000,0x00000000, 63, 0x462CE48D,0xCA5FA621,
	0x40080000,0x00000000, 64, 0x4645AB6A,0x57C7BC99,
	0x40080000,0x00000000, 65, 0x4660408F,0xC1D5CD73,
	0x40080000,0x00000000, 66, 0x467860D7,0xA2C0B42C,
	0x40080000,0x00000000, 67, 0x469248A1,0xBA108721,
	0x40080000,0x00000000, 68, 0x46AB6CF2,0x9718CAB2,
	0x40080000,0x00000000, 69, 0x46C491B5,0xF1529805,
	0x40080000,0x00000000, 70, 0x46DEDA90,0xE9FBE408,
	0x40080000,0x00000000, 71, 0x46F723EC,0xAF7CEB06,
	0x40080000,0x00000000, 72, 0x47115AF1,0x839DB044,
	0x40080000,0x00000000, 73, 0x472A086A,0x456C8867,
	0x40080000,0x00000000, 74, 0x4743864F,0xB411664D,
	0x40080000,0x00000000, 75, 0x475D4977,0x8E1A1974,
	0x40080000,0x00000000, 76, 0x4775F719,0xAA939317,
	0x40080000,0x00000000, 77, 0x47907953,0x3FEEAE51,
	0x40080000,0x00000000, 78, 0x47A8B5FC,0xDFE60579,
	0x40080000,0x00000000, 79, 0x47C2887D,0xA7EC841B,
	0x40080000,0x00000000, 80, 0x47DBCCBC,0x7BE2C629,
	0x40080000,0x00000000, 81, 0x47F4D98D,0x5CEA149F,
	0x40080000,0x00000000, 82, 0x480F4654,0x0B5F1EEE,
	0x40080000,0x00000000, 83, 0x482774BF,0x08875732,
	0x40080000,0x00000000, 84, 0x4841978F,0x46658166,
	0x40080000,0x00000000, 85, 0x485A6356,0xE9984219,
	0x40080000,0x00000000, 86, 0x4873CA81,0x2F323192,
	0x40080000,0x00000000, 87, 0x488DAFC1,0xC6CB4A5C,
	0x40080000,0x00000000, 88, 0x48A643D1,0x551877C5,
	0x40080000,0x00000000, 89, 0x48C0B2DC,0xFFD259D4,
	0x40080000,0x00000000, 90, 0x48D90C4B,0x7FBB86BD,
	0x40080000,0x00000000, 91, 0x48F2C938,0x9FCCA50E,
	0x40080000,0x00000000, 92, 0x490C2DD4,0xEFB2F795,
	0x40080000,0x00000000, 93, 0x4925225F,0xB3C639B0,
	0x40080000,0x00000000, 94, 0x493FB38F,0x8DA95688,
	0x40080000,0x00000000, 95, 0x4957C6AB,0xAA3F00E6,
	0x40080000,0x00000000, 96, 0x4971D500,0xBFAF40AC,
	0x40080000,0x00000000, 97, 0x498ABF81,0x1F86E102,
	0x40080000,0x00000000, 98, 0x49A40FA0,0xD7A528C2,
	0x40080000,0x00000000, 99, 0x49BE1771,0x4377BD23,
	0x40080000,0x00000000, 100, 0x49D69194,0xF299CDDA,
	0x40080000,0x00000000, 101, 0x49F0ED2F,0xB5F35A64,
	0x40080000,0x00000000, 102, 0x4A0963C7,0x90ED0795,
	0x40080000,0x00000000, 103, 0x4A230AD5,0xACB1C5B0,
	0x40080000,0x00000000, 104, 0x4A3C9040,0x830AA888,
	0x40080000,0x00000000, 105, 0x4A556C30,0x6247FE66,
	0x40080000,0x00000000, 106, 0x4A701124,0x49B5FECD,
	0x40080000,0x00000000, 107, 0x4A8819B6,0x6E90FE33,
	0x40080000,0x00000000, 108, 0x4AA21348,0xD2ECBEA6,
	0x40080000,0x00000000, 109, 0x4ABB1CED,0x3C631DF9,
	0x40080000,0x00000000, 110, 0x4AD455B1,0xED4A567B,
	0x40080000,0x00000000, 111, 0x4AEE808A,0xE3EF81B8,
	0x40080000,0x00000000, 112, 0x4B06E068,0x2AF3A14A,
	0x40080000,0x00000000, 113, 0x4B21284E,0x2036B8F8,
	0x40080000,0x00000000, 114, 0x4B39BC75,0x30521573,
	0x40080000,0x00000000, 115, 0x4B534D57,0xE43D9017,
	0x40080000,0x00000000, 116, 0x4B6CF403,0xD65C5822,
	0x40080000,0x00000000, 117, 0x4B85B702,0xE0C54219,
	0x40080000,0x00000000, 118, 0x4BA04942,0x2893F193,
	0x40080000,0x00000000, 119, 0x4BB86DE3,0x3CDDEA5D,
	0x40080000,0x00000000, 120, 0x4BD2526A,0x6DA66FC5,
	0x40080000,0x00000000, 121, 0x4BEB7B9F,0xA479A7A8,
	0x40080000,0x00000000, 122, 0x4C049CB7,0xBB5B3DBE,
	0x40080000,0x00000000, 123, 0x4C1EEB13,0x9908DC9D,
	0x40080000,0x00000000, 124, 0x4C37304E,0xB2C6A576,
	0x40080000,0x00000000, 125, 0x4C51643B,0x0614FC18,
	0x40080000,0x00000000, 126, 0x4C6A1658,0x891F7A25,
	0x40080000,0x00000000, 127, 0x4C8390C2,0x66D79B9B,
	0x40080000,0x00000000, 128, 0x4C9D5923,0x9A436969,
	0x40080000,0x00000000, 129, 0x4CB602DA,0xB3B28F0F,
	0x40080000,0x00000000, 130, 0x4CD08224,0x06C5EB4B,
	0x40080000,0x00000000, 131, 0x4CE8C336,0x0A28E0F1,
	0x40080000,0x00000000, 132, 0x4D029268,0x879EA8B5,
	0x40080000,0x00000000, 133, 0x4D1BDB9C,0xCB6DFD0F,
	0x40080000,0x00000000, 134, 0x4D34E4B5,0x98927DCB,
	0x40080000,0x00000000, 135, 0x4D4F5710,0x64DBBCB1,
	0x40080000,0x00000000, 136, 0x4D67814C,0x4BA4CD85,
	0x40080000,0x00000000, 137, 0x4D81A0F9,0x38BB9A23,
	0x40080000,0x00000000, 138, 0x4D9A7175,0xD5196735,
	0x40080000,0x00000000, 139, 0x4DB3D518,0x5FD30D68,
	0x40080000,0x00000000, 140, 0x4DCDBFA4,0x8FBC941C,
	0x40080000,0x00000000, 141, 0x4DE64FBB,0x6BCD6F15,
	0x40080000,0x00000000, 142, 0x4E00BBCC,0x90DA1350,
	0x40080000,0x00000000, 143, 0x4E1919B2,0xD9471CF7,
	0x40080000,0x00000000, 144, 0x4E32D346,0x22F555BA,
	0x40080000,0x00000000, 145, 0x4E4C3CE9,0x34700096,
	0x40080000,0x00000000, 146, 0x4E652DAE,0xE7540071,
	0x40080000,0x00000000, 147, 0x4E7FC486,0x5AFE00A9,
	0x40080000,0x00000000, 148, 0x4E97D364,0xC43E807F,
	0x40080000,0x00000000, 149, 0x4EB1DE8B,0x932EE05F,
	0x40080000,0x00000000, 150, 0x4ECACDD1,0x5CC6508F,
	0x40080000,0x00000000, 151, 0x4EE41A5D,0x0594BC6B,
	0x40080000,0x00000000, 152, 0x4EFE278B,0x885F1AA1,
	0x40080000,0x00000000, 153, 0x4F169DA8,0xA64753F8,
	0x40080000,0x00000000, 154, 0x4F30F63E,0x7CB57EFA,
	0x40080000,0x00000000, 155, 0x4F49715D,0xBB103E77,
	0x40080000,0x00000000, 156, 0x4F631506,0x4C4C2EDA,
	0x40080000,0x00000000, 157, 0x4F7C9F89,0x72724646,
	0x40080000,0x00000000, 158, 0x4F9577A7,0x15D5B4B5,
	0x40080000,0x00000000, 159, 0x4FB019BD,0x50604788,
	0x40080000,0x00000000, 160, 0x4FC8269B,0xF8906B4B,
	0x40080000,0x00000000, 161, 0x4FE21CF4,0xFA6C5079,
	0x40080000,0x00000000, 162, 0x4FFB2B6F,0x77A278B5,
	0x40080000,0x00000000, 163, 0x50146093,0x99B9DA88,
	0x40080000,0x00000000, 164, 0x502E90DD,0x6696C7CB,
	0x40080000,0x00000000, 165, 0x5046ECA6,0x0CF115D9,
	0x40080000,0x00000000, 166, 0x5061317C,0x89B4D062,
	0x40080000,0x00000000, 167, 0x5079CA3A,0xCE8F3894,
	0x40080000,0x00000000, 168, 0x509357AC,0x1AEB6A6F,
	0x40080000,0x00000000, 169, 0x50AD0382,0x28611FA6,
	0x40080000,0x00000000, 170, 0x50C5C2A1,0x9E48D7BD,
	0x40080000,0x00000000, 171, 0x50E051F9,0x36B6A1CD,
	0x40080000,0x00000000, 172, 0x50F87AF5,0xD211F2B4,
	0x40080000,0x00000000, 173, 0x51125C38,0x5D8D7607,
	0x40080000,0x00000000, 174, 0x512B8A54,0x8C54310B,
	0x40080000,0x00000000, 175, 0x5144A7BF,0x693F24C8,
	0x40080000,0x00000000, 176, 0x515EFB9F,0x1DDEB72C,
	0x40080000,0x00000000, 177, 0x51773CB7,0x56670961,
	0x40080000,0x00000000, 178, 0x51916D89,0x80CD4709,
	0x40080000,0x00000000, 179, 0x51AA244E,0x4133EA8D,
	0x40080000,0x00000000, 180, 0x51C39B3A,0xB0E6EFEA,
	0x40080000,0x00000000, 181, 0x51DD68D8,0x095A67DF,
	0x40080000,0x00000000, 182, 0x51F60EA2,0x0703CDE7,
	0x40080000,0x00000000, 183, 0x52108AF9,0x8542DA6D,
	0x40080000,0x00000000, 184, 0x5228D076,0x47E447A4,
	0x40080000,0x00000000, 185, 0x52429C58,0xB5EB35BB,
	0x40080000,0x00000000, 186, 0x525BEA85,0x10E0D098,
	0x40080000,0x00000000, 187, 0x5274EFE3,0xCCA89C72,
	0x40080000,0x00000000, 188, 0x528F67D5,0xB2FCEAAB,
	0x40080000,0x00000000, 189, 0x52A78DE0,0x463DB001,
	0x40080000,0x00000000, 190, 0x52C1AA68,0x34AE4400,
	0x40080000,0x00000000, 191, 0x52DA7F9C,0x4F056601,
	0x40080000,0x00000000, 192, 0x52F3DFB5,0x3B440C81,
	0x40080000,0x00000000, 193, 0x530DCF8F,0xD8E612C1,
	0x40080000,0x00000000, 194, 0x53265BAB,0xE2AC8E11,
	0x40080000,0x00000000, 195, 0x5340C4C0,0xEA016A8C,
	0x40080000,0x00000000, 196, 0x53592721,0x5F021FD3,
	0x40080000,0x00000000, 197, 0x5372DD59,0x074197DE,
	0x40080000,0x00000000, 198, 0x538C4C05,0x8AE263CD,
	0x40080000,0x00000000, 199, 0x53A53904,0x2829CADA,
	0x40080000,0x00000000, 200, 0x53BFD586,0x3C3EB047,
	0x40080000,0x00000000, 201, 0x53D7E024,0xAD2F0435,
	0x40080000,0x00000000, 202, 0x53F1E81B,0x81E34328,
	0x40080000,0x00000000, 203, 0x540ADC29,0x42D4E4BC,
	0x40080000,0x00000000, 204, 0x5424251E,0xF21FAB8D,
	0x40080000,0x00000000, 205, 0x543E37AE,0x6B2F8153,
	0x40080000,0x00000000, 206, 0x5456A9C2,0xD063A0FE,
	0x40080000,0x00000000, 207, 0x5470FF52,0x1C4AB8BF,
	0x40080000,0x00000000, 208, 0x54897EFB,0x2A70151E,
	0x40080000,0x00000000, 209, 0x54A31F3C,0x5FD40FD7,
	0x40080000,0x00000000, 210, 0x54BCAEDA,0x8FBE17C2,
	0x40080000,0x00000000, 211, 0x54D58323,0xEBCE91D1,
	0x40080000,0x00000000, 212, 0x54F0225A,0xF0DAED5D,
	0x40080000,0x00000000, 213, 0x55083388,0x6948640C,
	0x40080000,0x00000000, 214, 0x552226A6,0x4EF64B09,
	0x40080000,0x00000000, 215, 0x553B39F9,0x7671708D,
	0x40080000,0x00000000, 216, 0x55546B7B,0x18D5146A,
	0x40080000,0x00000000, 217, 0x556EA138,0xA53F9E9F,
	0x40080000,0x00000000, 218, 0x5586F8EA,0x7BEFB6F7,
	0x40080000,0x00000000, 219, 0x55A13AAF,0xDCF3C939,
	0x40080000,0x00000000, 220, 0x55B9D807,0xCB6DADD6,
	0x40080000,0x00000000, 221, 0x55D36205,0xD8924260,
	0x40080000,0x00000000, 222, 0x55ED1308,0xC4DB6391,
	0x40080000,0x00000000, 223, 0x5605CE46,0x93A48AAC,
	0x40080000,0x00000000, 224, 0x56205AB4,0xEEBB6801,
	0x40080000,0x00000000, 225, 0x5638880F,0x66191C02,
	0x40080000,0x00000000, 226, 0x5652660B,0x8C92D501,
	0x40080000,0x00000000, 227, 0x566B9911,0x52DC3F82,
	0x40080000,0x00000000, 228, 0x5684B2CC,0xFE252FA2,
	0x40080000,0x00000000, 229, 0x569F0C33,0x7D37C772,
	0x40080000,0x00000000, 230, 0x56B74926,0x9DE9D596,
	0x40080000,0x00000000, 231, 0x56D176DC,0xF66F6030,
	0x40080000,0x00000000, 232, 0x56EA324B,0x71A71049,
	0x40080000,0x00000000, 233, 0x5703A5B8,0x953D4C36,
	0x40080000,0x00000000, 234, 0x571D7894,0xDFDBF252,
	0x40080000,0x00000000, 235, 0x57361A6F,0xA7E4F5BD,
	0x40080000,0x00000000, 236, 0x575093D3,0xBDEBB84E,
	0x40080000,0x00000000, 237, 0x5768DDBD,0x9CE19475,
	0x40080000,0x00000000, 238, 0x5782A64E,0x35A92F58,
	0x40080000,0x00000000, 239, 0x579BF975,0x507DC704,
	0x40080000,0x00000000, 240, 0x57B4FB17,0xFC5E5543,
	0x40080000,0x00000000, 241, 0x57CF78A3,0xFA8D7FE4,
	0x40080000,0x00000000, 242, 0x57E79A7A,0xFBEA1FEB,
	0x40080000,0x00000000, 243, 0x5801B3DC,0x3CEF97F0,
	0x40080000,0x00000000, 244, 0x581A8DCA,0x5B6763E8,
	0x40080000,0x00000000, 245, 0x5833EA57,0xC48D8AEE,
	0x40080000,0x00000000, 246, 0x584DDF83,0xA6D45065,
	0x40080000,0x00000000, 247, 0x586667A2,0xBD1F3C4C,
	0x40080000,0x00000000, 248, 0x5880CDBA,0x0DD76D39,
	0x40080000,0x00000000, 249, 0x58993497,0x14C323D6,
	0x40080000,0x00000000, 250, 0x58B2E771,0x4F925AE0,
	0x40080000,0x00000000, 251, 0x58CC5B29,0xF75B8850,
	0x40080000,0x00000000, 252, 0x58E5445F,0x7984A63C,
	0x40080000,0x00000000, 253, 0x58FFE68F,0x3646F95A,
	0x40080000,0x00000000, 254, 0x5917ECEB,0x68B53B04,
	0x40080000,0x00000000, 255, 0x5931F1B0,0x8E87EC43,
	0x40080000,0x00000000, 256, 0x594AEA88,0xD5CBE264,
	0x40080000,0x00000000, 257, 0x59642FE6,0xA058E9CB,
	0x40080000,0x00000000, 258, 0x597E47D9,0xF0855EB1,
	0x40080000,0x00000000, 259, 0x5996B5E3,0x74640705,
	0x40080000,0x00000000, 260, 0x59B1086A,0x974B0543,
	0x40080000,0x00000000, 261, 0x59C98C9F,0xE2F087E5,
	0x40080000,0x00000000, 262, 0x59E32977,0xEA3465EC,
	0x40080000,0x00000000, 263, 0x59FCBE33,0xDF4E98E2,
	0x40080000,0x00000000, 264, 0x5A158EA6,0xE77AF2A9,
	0x40080000,0x00000000, 265, 0x5A302AFD,0x2D9C35FF,
	0x40080000,0x00000000, 266, 0x5A48407B,0xC46A50FE,
	0x40080000,0x00000000, 267, 0x5A62305C,0xD34FBCBF,
	0x40080000,0x00000000, 268, 0x5A7B488B,0x3CF79B1E,
	0x40080000,0x00000000, 269, 0x5A947668,0x6DB9B457,
	0x40080000,0x00000000, 270, 0x5AAEB19C,0xA4968E82,
	0x40080000,0x00000000, 271, 0x5AC70535,0x7B70EAE2,
	0x40080000,0x00000000, 272, 0x5AE143E8,0x1C94B029,
	0x40080000,0x00000000, 273, 0x5AF9E5DC,0x2ADF083E,
	0x40080000,0x00000000, 274, 0x5B136C65,0x2027462E,
	0x40080000,0x00000000, 275, 0x5B2D2297,0xB03AE945,
	0x40080000,0x00000000, 276, 0x5B45D9F1,0xC42C2EF4,
	0x40080000,0x00000000, 277, 0x5B606375,0x53212337,
	0x40080000,0x00000000, 278, 0x5B78952F,0xFCB1B4D3,
	0x40080000,0x00000000, 279, 0x5B926FE3,0xFD85479E,
	0x40080000,0x00000000, 280, 0x5BABA7D5,0xFC47EB6D,
	0x40080000,0x00000000, 281, 0x5BC4BDE0,0x7D35F092,
	0x40080000,0x00000000, 282, 0x5BDF1CD0,0xBBD0E8DB,
	0x40080000,0x00000000, 283, 0x5BF7559C,0x8CDCAEA4,
	0x40080000,0x00000000, 284, 0x5C118035,0x69A582FB,
	0x40080000,0x00000000, 285, 0x5C2A4050,0x1E784478,
	0x40080000,0x00000000, 286, 0x5C43B03C,0x16DA335A,
	0x40080000,0x00000000, 287, 0x5C5D885A,0x22474D07,
	0x40080000,0x00000000, 288, 0x5C762643,0x99B579C6,
	0x40080000,0x00000000, 289, 0x5C909CB2,0xB3481B54,
	0x40080000,0x00000000, 290, 0x5CA8EB0C,0x0CEC28FE,
	0x40080000,0x00000000, 291, 0x5CC2B049,0x09B11EBF,
	0x40080000,0x00000000, 292, 0x5CDC086D,0x8E89AE1E,
	0x40080000,0x00000000, 293, 0x5CF50652,0x2AE74297,
	0x40080000,0x00000000, 294, 0x5D0F897B,0x405AE3E2,
	0x40080000,0x00000000, 295, 0x5D27A71C,0x70442AE9,
	0x40080000,0x00000000, 296, 0x5D41BD55,0x5433202F,
	0x40080000,0x00000000, 297, 0x5D5A9BFF,0xFE4CB047,
	0x40080000,0x00000000, 298, 0x5D73F4FF,0xFEB98435,
	0x40080000,0x00000000, 299, 0x5D8DEF7F,0xFE16464F,
	0x40080000,0x00000000, 300, 0x5DA6739F,0xFE90B4BB,
	0x40100000,0x00000000, 2, 0x40300000,0x00000000,
	0x40100000,0x00000000, 3, 0x40500000,0x00000000,
	0x40100000,0x00000000, 4, 0x40700000,0x00000000,
	0x40100000,0x00000000, 5, 0x40900000,0x00000000,
	0x40100000,0x00000000, 6, 0x40B00000,0x00000000,
	0x40100000,0x00000000, 7, 0x40D00000,0x00000000,
	0x40100000,0x00000000, 8, 0x40F00000,0x00000000,
	0x40100000,0x00000000, 9, 0x41100000,0x00000000,
	0x40100000,0x00000000, 10, 0x41300000,0x00000000,
	0x40100000,0x00000000, 11, 0x41500000,0x00000000,
	0x40100000,0x00000000, 12, 0x41700000,0x00000000,
	0x40100000,0x00000000, 13, 0x41900000,0x00000000,
	0x40100000,0x00000000, 14, 0x41B00000,0x00000000,
	0x40100000,0x00000000, 15, 0x41D00000,0x00000000,
	0x40100000,0x00000000, 16, 0x41F00000,0x00000000,
	0x40100000,0x00000000, 17, 0x42100000,0x00000000,
	0x40100000,0x00000000, 18, 0x42300000,0x00000000,
	0x40100000,0x00000000, 19, 0x42500000,0x00000000,
	0x40100000,0x00000000, 20, 0x42700000,0x00000000,
	0x40100000,0x00000000, 21, 0x42900000,0x00000000,
	0x40100000,0x00000000, 22, 0x42B00000,0x00000000,
	0x40100000,0x00000000, 23, 0x42D00000,0x00000000,
	0x40100000,0x00000000, 24, 0x42F00000,0x00000000,
	0x40100000,0x00000000, 25, 0x43100000,0x00000000,
	0x40100000,0x00000000, 26, 0x43300000,0x00000000,
	0x40100000,0x00000000, 27, 0x43500000,0x00000000,
	0x40100000,0x00000000, 28, 0x43700000,0x00000000,
	0x40100000,0x00000000, 29, 0x43900000,0x00000000,
	0x40100000,0x00000000, 30, 0x43B00000,0x00000000,
	0x40100000,0x00000000, 31, 0x43D00000,0x00000000,
	0x40100000,0x00000000, 32, 0x43F00000,0x00000000,
	0x40100000,0x00000000, 33, 0x44100000,0x00000000,
	0x40100000,0x00000000, 34, 0x44300000,0x00000000,
	0x40100000,0x00000000, 35, 0x44500000,0x00000000,
	0x40100000,0x00000000, 36, 0x44700000,0x00000000,
	0x40100000,0x00000000, 37, 0x44900000,0x00000000,
	0x40100000,0x00000000, 38, 0x44B00000,0x00000000,
	0x40100000,0x00000000, 39, 0x44D00000,0x00000000,
	0x40100000,0x00000000, 40, 0x44F00000,0x00000000,
	0x40100000,0x00000000, 41, 0x45100000,0x00000000,
	0x40100000,0x00000000, 42, 0x45300000,0x00000000,
	0x40100000,0x00000000, 43, 0x45500000,0x00000000,
	0x40100000,0x00000000, 44, 0x45700000,0x00000000,
	0x40100000,0x00000000, 45, 0x45900000,0x00000000,
	0x40100000,0x00000000, 46, 0x45B00000,0x00000000,
	0x40100000,0x00000000, 47, 0x45D00000,0x00000000,
	0x40100000,0x00000000, 48, 0x45F00000,0x00000000,
	0x40100000,0x00000000, 49, 0x46100000,0x00000000,
	0x40100000,0x00000000, 50, 0x46300000,0x00000000,
	0x40100000,0x00000000, 51, 0x46500000,0x00000000,
	0x40100000,0x00000000, 52, 0x46700000,0x00000000,
	0x40100000,0x00000000, 53, 0x46900000,0x00000000,
	0x40100000,0x00000000, 54, 0x46B00000,0x00000000,
	0x40100000,0x00000000, 55, 0x46D00000,0x00000000,
	0x40100000,0x00000000, 56, 0x46F00000,0x00000000,
	0x40100000,0x00000000, 57, 0x47100000,0x00000000,
	0x40100000,0x00000000, 58, 0x47300000,0x00000000,
	0x40100000,0x00000000, 59, 0x47500000,0x00000000,
	0x40100000,0x00000000, 60, 0x47700000,0x00000000,
	0x40100000,0x00000000, 61, 0x47900000,0x00000000,
	0x40100000,0x00000000, 62, 0x47B00000,0x00000000,
	0x40100000,0x00000000, 63, 0x47D00000,0x00000000,
	0x40100000,0x00000000, 64, 0x47F00000,0x00000000,
	0x40100000,0x00000000, 65, 0x48100000,0x00000000,
	0x40100000,0x00000000, 66, 0x48300000,0x00000000,
	0x40100000,0x00000000, 67, 0x48500000,0x00000000,
	0x40100000,0x00000000, 68, 0x48700000,0x00000000,
	0x40100000,0x00000000, 69, 0x48900000,0x00000000,
	0x40100000,0x00000000, 70, 0x48B00000,0x00000000,
	0x40100000,0x00000000, 71, 0x48D00000,0x00000000,
	0x40100000,0x00000000, 72, 0x48F00000,0x00000000,
	0x40100000,0x00000000, 73, 0x49100000,0x00000000,
	0x40100000,0x00000000, 74, 0x49300000,0x00000000,
	0x40100000,0x00000000, 75, 0x49500000,0x00000000,
	0x40100000,0x00000000, 76, 0x49700000,0x00000000,
	0x40100000,0x00000000, 77, 0x49900000,0x00000000,
	0x40100000,0x00000000, 78, 0x49B00000,0x00000000,
	0x40100000,0x00000000, 79, 0x49D00000,0x00000000,
	0x40100000,0x00000000, 80, 0x49F00000,0x00000000,
	0x40100000,0x00000000, 81, 0x4A100000,0x00000000,
	0x40100000,0x00000000, 82, 0x4A300000,0x00000000,
	0x40100000,0x00000000, 83, 0x4A500000,0x00000000,
	0x40100000,0x00000000, 84, 0x4A700000,0x00000000,
	0x40100000,0x00000000, 85, 0x4A900000,0x00000000,
	0x40100000,0x00000000, 86, 0x4AB00000,0x00000000,
	0x40100000,0x00000000, 87, 0x4AD00000,0x00000000,
	0x40100000,0x00000000, 88, 0x4AF00000,0x00000000,
	0x40100000,0x00000000, 89, 0x4B100000,0x00000000,
	0x40100000,0x00000000, 90, 0x4B300000,0x00000000,
	0x40100000,0x00000000, 91, 0x4B500000,0x00000000,
	0x40100000,0x00000000, 92, 0x4B700000,0x00000000,
	0x40100000,0x00000000, 93, 0x4B900000,0x00000000,
	0x40100000,0x00000000, 94, 0x4BB00000,0x00000000,
	0x40100000,0x00000000, 95, 0x4BD00000,0x00000000,
	0x40100000,0x00000000, 96, 0x4BF00000,0x00000000,
	0x40100000,0x00000000, 97, 0x4C100000,0x00000000,
	0x40100000,0x00000000, 98, 0x4C300000,0x00000000,
	0x40100000,0x00000000, 99, 0x4C500000,0x00000000,
	0x40100000,0x00000000, 100, 0x4C700000,0x00000000,
	0x40100000,0x00000000, 101, 0x4C900000,0x00000000,
	0x40100000,0x00000000, 102, 0x4CB00000,0x00000000,
	0x40100000,0x00000000, 103, 0x4CD00000,0x00000000,
	0x40100000,0x00000000, 104, 0x4CF00000,0x00000000,
	0x40100000,0x00000000, 105, 0x4D100000,0x00000000,
	0x40100000,0x00000000, 106, 0x4D300000,0x00000000,
	0x40100000,0x00000000, 107, 0x4D500000,0x00000000,
	0x40100000,0x00000000, 108, 0x4D700000,0x00000000,
	0x40100000,0x00000000, 109, 0x4D900000,0x00000000,
	0x40100000,0x00000000, 110, 0x4DB00000,0x00000000,
	0x40100000,0x00000000, 111, 0x4DD00000,0x00000000,
	0x40100000,0x00000000, 112, 0x4DF00000,0x00000000,
	0x40100000,0x00000000, 113, 0x4E100000,0x00000000,
	0x40100000,0x00000000, 114, 0x4E300000,0x00000000,
	0x40100000,0x00000000, 115, 0x4E500000,0x00000000,
	0x40100000,0x00000000, 116, 0x4E700000,0x00000000,
	0x40100000,0x00000000, 117, 0x4E900000,0x00000000,
	0x40100000,0x00000000, 118, 0x4EB00000,0x00000000,
	0x40100000,0x00000000, 119, 0x4ED00000,0x00000000,
	0x40100000,0x00000000, 120, 0x4EF00000,0x00000000,
	0x40100000,0x00000000, 121, 0x4F100000,0x00000000,
	0x40100000,0x00000000, 122, 0x4F300000,0x00000000,
	0x40100000,0x00000000, 123, 0x4F500000,0x00000000,
	0x40100000,0x00000000, 124, 0x4F700000,0x00000000,
	0x40100000,0x00000000, 125, 0x4F900000,0x00000000,
	0x40100000,0x00000000, 126, 0x4FB00000,0x00000000,
	0x40100000,0x00000000, 127, 0x4FD00000,0x00000000,
	0x40100000,0x00000000, 128, 0x4FF00000,0x00000000,
	0x40100000,0x00000000, 129, 0x50100000,0x00000000,
	0x40100000,0x00000000, 130, 0x50300000,0x00000000,
	0x40100000,0x00000000, 131, 0x50500000,0x00000000,
	0x40100000,0x00000000, 132, 0x50700000,0x00000000,
	0x40100000,0x00000000, 133, 0x50900000,0x00000000,
	0x40100000,0x00000000, 134, 0x50B00000,0x00000000,
	0x40100000,0x00000000, 135, 0x50D00000,0x00000000,
	0x40100000,0x00000000, 136, 0x50F00000,0x00000000,
	0x40100000,0x00000000, 137, 0x51100000,0x00000000,
	0x40100000,0x00000000, 138, 0x51300000,0x00000000,
	0x40100000,0x00000000, 139, 0x51500000,0x00000000,
	0x40100000,0x00000000, 140, 0x51700000,0x00000000,
	0x40100000,0x00000000, 141, 0x51900000,0x00000000,
	0x40100000,0x00000000, 142, 0x51B00000,0x00000000,
	0x40100000,0x00000000, 143, 0x51D00000,0x00000000,
	0x40100000,0x00000000, 144, 0x51F00000,0x00000000,
	0x40100000,0x00000000, 145, 0x52100000,0x00000000,
	0x40100000,0x00000000, 146, 0x52300000,0x00000000,
	0x40100000,0x00000000, 147, 0x52500000,0x00000000,
	0x40100000,0x00000000, 148, 0x52700000,0x00000000,
	0x40100000,0x00000000, 149, 0x52900000,0x00000000,
	0x40100000,0x00000000, 150, 0x52B00000,0x00000000,
	0x40100000,0x00000000, 151, 0x52D00000,0x00000000,
	0x40100000,0x00000000, 152, 0x52F00000,0x00000000,
	0x40100000,0x00000000, 153, 0x53100000,0x00000000,
	0x40100000,0x00000000, 154, 0x53300000,0x00000000,
	0x40100000,0x00000000, 155, 0x53500000,0x00000000,
	0x40100000,0x00000000, 156, 0x53700000,0x00000000,
	0x40100000,0x00000000, 157, 0x53900000,0x00000000,
	0x40100000,0x00000000, 158, 0x53B00000,0x00000000,
	0x40100000,0x00000000, 159, 0x53D00000,0x00000000,
	0x40100000,0x00000000, 160, 0x53F00000,0x00000000,
	0x40100000,0x00000000, 161, 0x54100000,0x00000000,
	0x40100000,0x00000000, 162, 0x54300000,0x00000000,
	0x40100000,0x00000000, 163, 0x54500000,0x00000000,
	0x40100000,0x00000000, 164, 0x54700000,0x00000000,
	0x40100000,0x00000000, 165, 0x54900000,0x00000000,
	0x40100000,0x00000000, 166, 0x54B00000,0x00000000,
	0x40100000,0x00000000, 167, 0x54D00000,0x00000000,
	0x40100000,0x00000000, 168, 0x54F00000,0x00000000,
	0x40100000,0x00000000, 169, 0x55100000,0x00000000,
	0x40100000,0x00000000, 170, 0x55300000,0x00000000,
	0x40100000,0x00000000, 171, 0x55500000,0x00000000,
	0x40100000,0x00000000, 172, 0x55700000,0x00000000,
	0x40100000,0x00000000, 173, 0x55900000,0x00000000,
	0x40100000,0x00000000, 174, 0x55B00000,0x00000000,
	0x40100000,0x00000000, 175, 0x55D00000,0x00000000,
	0x40100000,0x00000000, 176, 0x55F00000,0x00000000,
	0x40100000,0x00000000, 177, 0x56100000,0x00000000,
	0x40100000,0x00000000, 178, 0x56300000,0x00000000,
	0x40100000,0x00000000, 179, 0x56500000,0x00000000,
	0x40100000,0x00000000, 180, 0x56700000,0x00000000,
	0x40100000,0x00000000, 181, 0x56900000,0x00000000,
	0x40100000,0x00000000, 182, 0x56B00000,0x00000000,
	0x40100000,0x00000000, 183, 0x56D00000,0x00000000,
	0x40100000,0x00000000, 184, 0x56F00000,0x00000000,
	0x40100000,0x00000000, 185, 0x57100000,0x00000000,
	0x40100000,0x00000000, 186, 0x57300000,0x00000000,
	0x40100000,0x00000000, 187, 0x57500000,0x00000000,
	0x40100000,0x00000000, 188, 0x57700000,0x00000000,
	0x40100000,0x00000000, 189, 0x57900000,0x00000000,
	0x40100000,0x00000000, 190, 0x57B00000,0x00000000,
	0x40100000,0x00000000, 191, 0x57D00000,0x00000000,
	0x40100000,0x00000000, 192, 0x57F00000,0x00000000,
	0x40100000,0x00000000, 193, 0x58100000,0x00000000,
	0x40100000,0x00000000, 194, 0x58300000,0x00000000,
	0x40100000,0x00000000, 195, 0x58500000,0x00000000,
	0x40100000,0x00000000, 196, 0x58700000,0x00000000,
	0x40100000,0x00000000, 197, 0x58900000,0x00000000,
	0x40100000,0x00000000, 198, 0x58B00000,0x00000000,
	0x40100000,0x00000000, 199, 0x58D00000,0x00000000,
	0x40100000,0x00000000, 200, 0x58F00000,0x00000000,
	0x40100000,0x00000000, 201, 0x59100000,0x00000000,
	0x40100000,0x00000000, 202, 0x59300000,0x00000000,
	0x40100000,0x00000000, 203, 0x59500000,0x00000000,
	0x40100000,0x00000000, 204, 0x59700000,0x00000000,
	0x40100000,0x00000000, 205, 0x59900000,0x00000000,
	0x40100000,0x00000000, 206, 0x59B00000,0x00000000,
	0x40100000,0x00000000, 207, 0x59D00000,0x00000000,
	0x40100000,0x00000000, 208, 0x59F00000,0x00000000,
	0x40100000,0x00000000, 209, 0x5A100000,0x00000000,
	0x40100000,0x00000000, 210, 0x5A300000,0x00000000,
	0x40100000,0x00000000, 211, 0x5A500000,0x00000000,
	0x40100000,0x00000000, 212, 0x5A700000,0x00000000,
	0x40100000,0x00000000, 213, 0x5A900000,0x00000000,
	0x40100000,0x00000000, 214, 0x5AB00000,0x00000000,
	0x40100000,0x00000000, 215, 0x5AD00000,0x00000000,
	0x40100000,0x00000000, 216, 0x5AF00000,0x00000000,
	0x40100000,0x00000000, 217, 0x5B100000,0x00000000,
	0x40100000,0x00000000, 218, 0x5B300000,0x00000000,
	0x40100000,0x00000000, 219, 0x5B500000,0x00000000,
	0x40100000,0x00000000, 220, 0x5B700000,0x00000000,
	0x40100000,0x00000000, 221, 0x5B900000,0x00000000,
	0x40100000,0x00000000, 222, 0x5BB00000,0x00000000,
	0x40100000,0x00000000, 223, 0x5BD00000,0x00000000,
	0x40100000,0x00000000, 224, 0x5BF00000,0x00000000,
	0x40100000,0x00000000, 225, 0x5C100000,0x00000000,
	0x40100000,0x00000000, 226, 0x5C300000,0x00000000,
	0x40100000,0x00000000, 227, 0x5C500000,0x00000000,
	0x40100000,0x00000000, 228, 0x5C700000,0x00000000,
	0x40100000,0x00000000, 229, 0x5C900000,0x00000000,
	0x40100000,0x00000000, 230, 0x5CB00000,0x00000000,
	0x40100000,0x00000000, 231, 0x5CD00000,0x00000000,
	0x40100000,0x00000000, 232, 0x5CF00000,0x00000000,
	0x40100000,0x00000000, 233, 0x5D100000,0x00000000,
	0x40100000,0x00000000, 234, 0x5D300000,0x00000000,
	0x40100000,0x00000000, 235, 0x5D500000,0x00000000,
	0x40100000,0x00000000, 236, 0x5D700000,0x00000000,
	0x40100000,0x00000000, 237, 0x5D900000,0x00000000,
	0x40100000,0x00000000, 238, 0x5DB00000,0x00000000,
	0x40100000,0x00000000, 239, 0x5DD00000,0x00000000,
	0x40100000,0x00000000, 240, 0x5DF00000,0x00000000,
	0x40100000,0x00000000, 241, 0x5E100000,0x00000000,
	0x40100000,0x00000000, 242, 0x5E300000,0x00000000,
	0x40100000,0x00000000, 243, 0x5E500000,0x00000000,
	0x40100000,0x00000000, 244, 0x5E700000,0x00000000,
	0x40100000,0x00000000, 245, 0x5E900000,0x00000000,
	0x40100000,0x00000000, 246, 0x5EB00000,0x00000000,
	0x40100000,0x00000000, 247, 0x5ED00000,0x00000000,
	0x40100000,0x00000000, 248, 0x5EF00000,0x00000000,
	0x40100000,0x00000000, 249, 0x5F100000,0x00000000,
	0x40100000,0x00000000, 250, 0x5F300000,0x00000000,
	0x40100000,0x00000000, 251, 0x5F500000,0x00000000,
	0x40100000,0x00000000, 252, 0x5F700000,0x00000000,
	0x40100000,0x00000000, 253, 0x5F900000,0x00000000,
	0x40100000,0x00000000, 254, 0x5FB00000,0x00000000,
	0x40100000,0x00000000, 255, 0x5FD00000,0x00000000,
	0x40100000,0x00000000, 256, 0x5FF00000,0x00000000,
	0x40100000,0x00000000, 257, 0x60100000,0x00000000,
	0x40100000,0x00000000, 258, 0x60300000,0x00000000,
	0x40100000,0x00000000, 259, 0x60500000,0x00000000,
	0x40100000,0x00000000, 260, 0x60700000,0x00000000,
	0x40100000,0x00000000, 261, 0x60900000,0x00000000,
	0x40100000,0x00000000, 262, 0x60B00000,0x00000000,
	0x40100000,0x00000000, 263, 0x60D00000,0x00000000,
	0x40100000,0x00000000, 264, 0x60F00000,0x00000000,
	0x40100000,0x00000000, 265, 0x61100000,0x00000000,
	0x40100000,0x00000000, 266, 0x61300000,0x00000000,
	0x40100000,0x00000000, 267, 0x61500000,0x00000000,
	0x40100000,0x00000000, 268, 0x61700000,0x00000000,
	0x40100000,0x00000000, 269, 0x61900000,0x00000000,
	0x40100000,0x00000000, 270, 0x61B00000,0x00000000,
	0x40100000,0x00000000, 271, 0x61D00000,0x00000000,
	0x40100000,0x00000000, 272, 0x61F00000,0x00000000,
	0x40100000,0x00000000, 273, 0x62100000,0x00000000,
	0x40100000,0x00000000, 274, 0x62300000,0x00000000,
	0x40100000,0x00000000, 275, 0x62500000,0x00000000,
	0x40100000,0x00000000, 276, 0x62700000,0x00000000,
	0x40100000,0x00000000, 277, 0x62900000,0x00000000,
	0x40100000,0x00000000, 278, 0x62B00000,0x00000000,
	0x40100000,0x00000000, 279, 0x62D00000,0x00000000,
	0x40100000,0x00000000, 280, 0x62F00000,0x00000000,
	0x40100000,0x00000000, 281, 0x63100000,0x00000000,
	0x40100000,0x00000000, 282, 0x63300000,0x00000000,
	0x40100000,0x00000000, 283, 0x63500000,0x00000000,
	0x40100000,0x00000000, 284, 0x63700000,0x00000000,
	0x40100000,0x00000000, 285, 0x63900000,0x00000000,
	0x40100000,0x00000000, 286, 0x63B00000,0x00000000,
	0x40100000,0x00000000, 287, 0x63D00000,0x00000000,
	0x40100000,0x00000000, 288, 0x63F00000,0x00000000,
	0x40100000,0x00000000, 289, 0x64100000,0x00000000,
	0x40100000,0x00000000, 290, 0x64300000,0x00000000,
	0x40100000,0x00000000, 291, 0x64500000,0x00000000,
	0x40100000,0x00000000, 292, 0x64700000,0x00000000,
	0x40100000,0x00000000, 293, 0x64900000,0x00000000,
	0x40100000,0x00000000, 294, 0x64B00000,0x00000000,
	0x40100000,0x00000000, 295, 0x64D00000,0x00000000,
	0x40100000,0x00000000, 296, 0x64F00000,0x00000000,
	0x40100000,0x00000000, 297, 0x65100000,0x00000000,
	0x40100000,0x00000000, 298, 0x65300000,0x00000000,
	0x40100000,0x00000000, 299, 0x65500000,0x00000000,
	0x40100000,0x00000000, 300, 0x65700000,0x00000000,
	0x40140000,0x00000000, 2, 0x40390000,0x00000000,
	0x40140000,0x00000000, 3, 0x405F4000,0x00000000,
	0x40140000,0x00000000, 4, 0x40838800,0x00000000,
	0x40140000,0x00000000, 5, 0x40A86A00,0x00000000,
	0x40140000,0x00000000, 6, 0x40CE8480,0x00000000,
	0x40140000,0x00000000, 7, 0x40F312D0,0x00000000,
	0x40140000,0x00000000, 8, 0x4117D784,0x00000000,
	0x40140000,0x00000000, 9, 0x413DCD65,0x00000000,
	0x40140000,0x00000000, 10, 0x4162A05F,0x20000000,
	0x40140000,0x00000000, 11, 0x41874876,0xE8000000,
	0x40140000,0x00000000, 12, 0x41AD1A94,0xA2000000,
	0x40140000,0x00000000, 13, 0x41D2309C,0xE5400000,
	0x40140000,0x00000000, 14, 0x41F6BCC4,0x1E900000,
	0x40140000,0x00000000, 15, 0x421C6BF5,0x26340000,
	0x40140000,0x00000000, 16, 0x4241C379,0x37E08000,
	0x40140000,0x00000000, 17, 0x42663457,0x85D8A000,
	0x40140000,0x00000000, 18, 0x428BC16D,0x674EC800,
	0x40140000,0x00000000, 19, 0x42B158E4,0x60913D00,
	0x40140000,0x00000000, 20, 0x42D5AF1D,0x78B58C40,
	0x40140000,0x00000000, 21, 0x42FB1AE4,0xD6E2EF50,
	0x40140000,0x00000000, 22, 0x4320F0CF,0x064DD592,
	0x40140000,0x00000000, 23, 0x43452D02,0xC7E14AF6,
	0x40140000,0x00000000, 24, 0x436A7843,0x79D99DB4,
	0x40140000,0x00000000, 25, 0x43908B2A,0x2C280291,
	0x40140000,0x00000000, 26, 0x43B4ADF4,0xB7320335,
	0x40140000,0x00000000, 27, 0x43D9D971,0xE4FE8402,
	0x40140000,0x00000000, 28, 0x440027E7,0x2F1F1281,
	0x40140000,0x00000000, 29, 0x442431E0,0xFAE6D721,
	0x40140000,0x00000000, 30, 0x44493E59,0x39A08CEA,
	0x40140000,0x00000000, 31, 0x446F8DEF,0x8808B024,
	0x40140000,0x00000000, 32, 0x4493B8B5,0xB5056E17,
	0x40140000,0x00000000, 33, 0x44B8A6E3,0x2246C99C,
	0x40140000,0x00000000, 34, 0x44DED09B,0xEAD87C03,
	0x40140000,0x00000000, 35, 0x45034261,0x72C74D82,
	0x40140000,0x00000000, 36, 0x452812F9,0xCF7920E3,
	0x40140000,0x00000000, 37, 0x454E17B8,0x4357691B,
	0x40140000,0x00000000, 38, 0x4572CED3,0x2A16A1B1,
	0x40140000,0x00000000, 39, 0x45978287,0xF49C4A1D,
	0x40140000,0x00000000, 40, 0x45BD6329,0xF1C35CA5,
	0x40140000,0x00000000, 41, 0x45E25DFA,0x371A19E7,
	0x40140000,0x00000000, 42, 0x4606F578,0xC4E0A061,
	0x40140000,0x00000000, 43, 0x462CB2D6,0xF618C879,
	0x40140000,0x00000000, 44, 0x4651EFC6,0x59CF7D4C,
	0x40140000,0x00000000, 45, 0x46766BB7,0xF0435C9E,
	0x40140000,0x00000000, 46, 0x469C06A5,0xEC5433C6,
	0x40140000,0x00000000, 47, 0x46C18427,0xB3B4A05C,
	0x40140000,0x00000000, 48, 0x46E5E531,0xA0A1C873,
	0x40140000,0x00000000, 49, 0x470B5E7E,0x08CA3A8F,
	0x40140000,0x00000000, 50, 0x47311B0E,0xC57E649A,
	0x40140000,0x00000000, 51, 0x475561D2,0x76DDFDC0,
	0x40140000,0x00000000, 52, 0x477ABA47,0x14957D30,
	0x40140000,0x00000000, 53, 0x47A0B46C,0x6CDD6E3E,
	0x40140000,0x00000000, 54, 0x47C4E187,0x8814C9CE,
	0x40140000,0x00000000, 55, 0x47EA19E9,0x6A19FC41,
	0x40140000,0x00000000, 56, 0x48105031,0xE2503DA9,
	0x40140000,0x00000000, 57, 0x4834643E,0x5AE44D13,
	0x40140000,0x00000000, 58, 0x48597D4D,0xF19D6057,
	0x40140000,0x00000000, 59, 0x487FDCA1,0x6E04B86D,
	0x40140000,0x00000000, 60, 0x48A3E9E4,0xE4C2F344,
	0x40140000,0x00000000, 61, 0x48C8E45E,0x1DF3B015,
	0x40140000,0x00000000, 62, 0x48EF1D75,0xA5709C1B,
	0x40140000,0x00000000, 63, 0x49137269,0x87666191,
	0x40140000,0x00000000, 64, 0x49384F03,0xE93FF9F5,
	0x40140000,0x00000000, 65, 0x495E62C4,0xE38FF872,
	0x40140000,0x00000000, 66, 0x4982FDBB,0x0E39FB47,
	0x40140000,0x00000000, 67, 0x49A7BD29,0xD1C87A19,
	0x40140000,0x00000000, 68, 0x49CDAC74,0x463A989F,
	0x40140000,0x00000000, 69, 0x49F28BC8,0xABE49F64,
	0x40140000,0x00000000, 70, 0x4A172EBA,0xD6DDC73D,
	0x40140000,0x00000000, 71, 0x4A3CFA69,0x8C95390C,
	0x40140000,0x00000000, 72, 0x4A621C81,0xF7DD43A7,
	0x40140000,0x00000000, 73, 0x4A86A3A2,0x75D49491,
	0x40140000,0x00000000, 74, 0x4AAC4C8B,0x1349B9B5,
	0x40140000,0x00000000, 75, 0x4AD1AFD6,0xEC0E1411,
	0x40140000,0x00000000, 76, 0x4AF61BCC,0xA7119916,
	0x40140000,0x00000000, 77, 0x4B1BA2BF,0xD0D5FF5B,
	0x40140000,0x00000000, 78, 0x4B4145B7,0xE285BF99,
	0x40140000,0x00000000, 79, 0x4B659725,0xDB272F7F,
	0x40140000,0x00000000, 80, 0x4B8AFCEF,0x51F0FB5F,
	0x40140000,0x00000000, 81, 0x4BB0DE15,0x93369D1B,
	0x40140000,0x00000000, 82, 0x4BD5159A,0xF8044462,
	0x40140000,0x00000000, 83, 0x4BFA5B01,0xB605557B,
	0x40140000,0x00000000, 84, 0x4C2078E1,0x11C3556D,
	0x40140000,0x00000000, 85, 0x4C449719,0x56342AC8,
	0x40140000,0x00000000, 86, 0x4C69BCDF,0xABC1357A,
	0x40140000,0x00000000, 87, 0x4C90160B,0xCB58C16C,
	0x40140000,0x00000000, 88, 0x4CB41B8E,0xBE2EF1C7,
	0x40140000,0x00000000, 89, 0x4CD92272,0x6DBAAE39,
	0x40140000,0x00000000, 90, 0x4CFF6B0F,0x092959C7,
	0x40140000,0x00000000, 91, 0x4D23A2E9,0x65B9D81D,
	0x40140000,0x00000000, 92, 0x4D488BA3,0xBF284E24,
	0x40140000,0x00000000, 93, 0x4D6EAE8C,0xAEF261AD,
	0x40140000,0x00000000, 94, 0x4D932D17,0xED577D0C,
	0x40140000,0x00000000, 95, 0x4DB7F85D,0xE8AD5C4F,
	0x40140000,0x00000000, 96, 0x4DDDF675,0x62D8B363,
	0x40140000,0x00000000, 97, 0x4E02BA09,0x5DC7701E,
	0x40140000,0x00000000, 98, 0x4E27688B,0xB5394C25,
	0x40140000,0x00000000, 99, 0x4E4D42AE,0xA2879F2E,
	0x40140000,0x00000000, 100, 0x4E7249AD,0x2594C37D,
	0x40140000,0x00000000, 101, 0x4E96DC18,0x6EF9F45C,
	0x40140000,0x00000000, 102, 0x4EBC931E,0x8AB87173,
	0x40140000,0x00000000, 103, 0x4EE1DBF3,0x16B346E8,
	0x40140000,0x00000000, 104, 0x4F0652EF,0xDC6018A2,
	0x40140000,0x00000000, 105, 0x4F2BE7AB,0xD3781ECA,
	0x40140000,0x00000000, 106, 0x4F5170CB,0x642B133F,
	0x40140000,0x00000000, 107, 0x4F75CCFE,0x3D35D80E,
	0x40140000,0x00000000, 108, 0x4F9B403D,0xCC834E12,
	0x40140000,0x00000000, 109, 0x4FC10826,0x9FD210CB,
	0x40140000,0x00000000, 110, 0x4FE54A30,0x47C694FE,
	0x40140000,0x00000000, 111, 0x500A9CBC,0x59B83A3D,
	0x40140000,0x00000000, 112, 0x5030A1F5,0xB8132466,
	0x40140000,0x00000000, 113, 0x5054CA73,0x2617ED80,
	0x40140000,0x00000000, 114, 0x5079FD0F,0xEF9DE8E0,
	0x40140000,0x00000000, 115, 0x50A03E29,0xF5C2B18C,
	0x40140000,0x00000000, 116, 0x50C44DB4,0x73335DEF,
	0x40140000,0x00000000, 117, 0x50E96121,0x9000356B,
	0x40140000,0x00000000, 118, 0x510FB969,0xF40042C5,
	0x40140000,0x00000000, 119, 0x5133D3E2,0x388029BB,
	0x40140000,0x00000000, 120, 0x5158C8DA,0xC6A0342A,
	0x40140000,0x00000000, 121, 0x517EFB11,0x78484135,
	0x40140000,0x00000000, 122, 0x51A35CEA,0xEB2D28C1,
	0x40140000,0x00000000, 123, 0x51C83425,0xA5F872F1,
	0x40140000,0x00000000, 124, 0x51EE412F,0x0F768FAD,
	0x40140000,0x00000000, 125, 0x5212E8BD,0x69AA19CC,
	0x40140000,0x00000000, 126, 0x5237A2EC,0xC414A03F,
	0x40140000,0x00000000, 127, 0x525D8BA7,0xF519C84F,
	0x40140000,0x00000000, 128, 0x52827748,0xF9301D32,
	0x40140000,0x00000000, 129, 0x52A7151B,0x377C247E,
	0x40140000,0x00000000, 130, 0x52CCDA62,0x055B2D9E,
	0x40140000,0x00000000, 131, 0x52F2087D,0x4358FC82,
	0x40140000,0x00000000, 132, 0x53168A9C,0x942F3BA3,
	0x40140000,0x00000000, 133, 0x533C2D43,0xB93B0A8C,
	0x40140000,0x00000000, 134, 0x53619C4A,0x53C4E697,
	0x40140000,0x00000000, 135, 0x5386035C,0xE8B6203D,
	0x40140000,0x00000000, 136, 0x53AB8434,0x22E3A84D,
	0x40140000,0x00000000, 137, 0x53D132A0,0x95CE4930,
	0x40140000,0x00000000, 138, 0x53F57F48,0xBB41DB7C,
	0x40140000,0x00000000, 139, 0x541ADF1A,0xEA12525B,
	0x40140000,0x00000000, 140, 0x5440CB70,0xD24B7379,
	0x40140000,0x00000000, 141, 0x5464FE4D,0x06DE5057,
	0x40140000,0x00000000, 142, 0x548A3DE0,0x4895E46D,
	0x40140000,0x00000000, 143, 0x54B066AC,0x2D5DAEC4,
	0x40140000,0x00000000, 144, 0x54D48057,0x38B51A75,
	0x40140000,0x00000000, 145, 0x54F9A06D,0x06E26112,
	0x40140000,0x00000000, 146, 0x55200444,0x244D7CAB,
	0x40140000,0x00000000, 147, 0x55440555,0x2D60DBD6,
	0x40140000,0x00000000, 148, 0x556906AA,0x78B912CC,
	0x40140000,0x00000000, 149, 0x558F4855,0x16E7577F,
	0x40140000,0x00000000, 150, 0x55B38D35,0x2E5096AF,
	0x40140000,0x00000000, 151, 0x55D87082,0x79E4BC5B,
	0x40140000,0x00000000, 152, 0x55FE8CA3,0x185DEB72,
	0x40140000,0x00000000, 153, 0x562317E5,0xEF3AB327,
	0x40140000,0x00000000, 154, 0x5647DDDF,0x6B095FF1,
	0x40140000,0x00000000, 155, 0x566DD557,0x45CBB7ED,
	0x40140000,0x00000000, 156, 0x5692A556,0x8B9F52F4,
	0x40140000,0x00000000, 157, 0x56B74EAC,0x2E8727B1,
	0x40140000,0x00000000, 158, 0x56DD2257,0x3A28F19D,
	0x40140000,0x00000000, 159, 0x57023576,0x84599702,
	0x40140000,0x00000000, 160, 0x5726C2D4,0x256FFCC3,
	0x40140000,0x00000000, 161, 0x574C7389,0x2ECBFBF4,
	0x40140000,0x00000000, 162, 0x5771C835,0xBD3F7D78,
	0x40140000,0x00000000, 163, 0x57963A43,0x2C8F5CD6,
	0x40140000,0x00000000, 164, 0x57BBC8D3,0xF7B3340C,
	0x40140000,0x00000000, 165, 0x57E15D84,0x7AD00087,
	0x40140000,0x00000000, 166, 0x5805B4E5,0x998400A9,
	0x40140000,0x00000000, 167, 0x582B221E,0xFFE500D4,
	0x40140000,0x00000000, 168, 0x5850F553,0x5FEF2084,
	0x40140000,0x00000000, 169, 0x587532A8,0x37EAE8A5,
	0x40140000,0x00000000, 170, 0x589A7F52,0x45E5A2CF,
	0x40140000,0x00000000, 171, 0x58C08F93,0x6BAF85C1,
	0x40140000,0x00000000, 172, 0x58E4B378,0x469B6732,
	0x40140000,0x00000000, 173, 0x5909E056,0x584240FE,
	0x40140000,0x00000000, 174, 0x59302C35,0xF729689F,
	0x40140000,0x00000000, 175, 0x59543743,0x74F3C2C6,
	0x40140000,0x00000000, 176, 0x59794514,0x5230B378,
	0x40140000,0x00000000, 177, 0x599F9659,0x66BCE056,
	0x40140000,0x00000000, 178, 0x59C3BDF7,0xE0360C36,
	0x40140000,0x00000000, 179, 0x59E8AD75,0xD8438F43,
	0x40140000,0x00000000, 180, 0x5A0ED8D3,0x4E547314,
	0x40140000,0x00000000, 181, 0x5A334784,0x10F4C7EC,
	0x40140000,0x00000000, 182, 0x5A581965,0x1531F9E8,
	0x40140000,0x00000000, 183, 0x5A7E1FBE,0x5A7E7861,
	0x40140000,0x00000000, 184, 0x5AA2D3D6,0xF88F0B3D,
	0x40140000,0x00000000, 185, 0x5AC788CC,0xB6B2CE0C,
	0x40140000,0x00000000, 186, 0x5AED6AFF,0xE45F818F,
	0x40140000,0x00000000, 187, 0x5B1262DF,0xEEBBB0F9,
	0x40140000,0x00000000, 188, 0x5B36FB97,0xEA6A9D38,
	0x40140000,0x00000000, 189, 0x5B5CBA7D,0xE5054486,
	0x40140000,0x00000000, 190, 0x5B81F48E,0xAF234AD4,
	0x40140000,0x00000000, 191, 0x5BA671B2,0x5AEC1D89,
	0x40140000,0x00000000, 192, 0x5BCC0E1E,0xF1A724EB,
	0x40140000,0x00000000, 193, 0x5BF188D3,0x57087713,
	0x40140000,0x00000000, 194, 0x5C15EB08,0x2CCA94D7,
	0x40140000,0x00000000, 195, 0x5C3B65CA,0x37FD3A0D,
	0x40140000,0x00000000, 196, 0x5C611F9E,0x62FE4448,
	0x40140000,0x00000000, 197, 0x5C856785,0xFBBDD55A,
	0x40140000,0x00000000, 198, 0x5CAAC167,0x7AAD4AB1,
	0x40140000,0x00000000, 199, 0x5CD0B8E0,0xACAC4EAF,
	0x40140000,0x00000000, 200, 0x5CF4E718,0xD7D7625A,
	0x40140000,0x00000000, 201, 0x5D1A20DF,0x0DCD3AF1,
	0x40140000,0x00000000, 202, 0x5D40548B,0x68A044D6,
	0x40140000,0x00000000, 203, 0x5D6469AE,0x42C8560C,
	0x40140000,0x00000000, 204, 0x5D898419,0xD37A6B8F,
	0x40140000,0x00000000, 205, 0x5DAFE520,0x48590673,
	0x40140000,0x00000000, 206, 0x5DD3EF34,0x2D37A408,
	0x40140000,0x00000000, 207, 0x5DF8EB01,0x38858D0A,
	0x40140000,0x00000000, 208, 0x5E1F25C1,0x86A6F04C,
	0x40140000,0x00000000, 209, 0x5E437798,0xF4285630,
	0x40140000,0x00000000, 210, 0x5E68557F,0x31326BBB,
	0x40140000,0x00000000, 211, 0x5E8E6ADE,0xFD7F06AA,
	0x40140000,0x00000000, 212, 0x5EB302CB,0x5E6F642A,
	0x40140000,0x00000000, 213, 0x5ED7C37E,0x360B3D35,
	0x40140000,0x00000000, 214, 0x5EFDB45D,0xC38E0C82,
	0x40140000,0x00000000, 215, 0x5F2290BA,0x9A38C7D1,
	0x40140000,0x00000000, 216, 0x5F4734E9,0x40C6F9C6,
	0x40140000,0x00000000, 217, 0x5F6D0223,0x90F8B837,
	0x40140000,0x00000000, 218, 0x5F922156,0x3A9B7323,
	0x40140000,0x00000000, 219, 0x5FB6A9AB,0xC9424FEB,
	0x40140000,0x00000000, 220, 0x5FDC5416,0xBB92E3E6,
	0x40140000,0x00000000, 221, 0x6001B48E,0x353BCE70,
	0x40140000,0x00000000, 222, 0x602621B1,0xC28AC20C,
	0x40140000,0x00000000, 223, 0x604BAA1E,0x332D728F,
	0x40140000,0x00000000, 224, 0x60714A52,0xDFFC6799,
	0x40140000,0x00000000, 225, 0x60959CE7,0x97FB817F,
	0x40140000,0x00000000, 226, 0x60BB0421,0x7DFA61DF,
	0x40140000,0x00000000, 227, 0x60E0E294,0xEEBC7D2C,
	0x40140000,0x00000000, 228, 0x61051B3A,0x2A6B9C76,
	0x40140000,0x00000000, 229, 0x612A6208,0xB5068394,
	0x40140000,0x00000000, 230, 0x61507D45,0x7124123D,
	0x40140000,0x00000000, 231, 0x61749C96,0xCD6D16CC,
	0x40140000,0x00000000, 232, 0x6199C3BC,0x80C85C7F,
	0x40140000,0x00000000, 233, 0x61C01A55,0xD07D39CF,
	0x40140000,0x00000000, 234, 0x61E420EB,0x449C8843,
	0x40140000,0x00000000, 235, 0x62092926,0x15C3AA54,
	0x40140000,0x00000000, 236, 0x622F736F,0x9B3494E9,
	0x40140000,0x00000000, 237, 0x6253A825,0xC100DD11,
	0x40140000,0x00000000, 238, 0x6278922F,0x31411456,
	0x40140000,0x00000000, 239, 0x629EB6BA,0xFD91596B,
	0x40140000,0x00000000, 240, 0x62C33234,0xDE7AD7E3,
	0x40140000,0x00000000, 241, 0x62E7FEC2,0x16198DDC,
	0x40140000,0x00000000, 242, 0x630DFE72,0x9B9FF153,
	0x40140000,0x00000000, 243, 0x6332BF07,0xA143F6D4,
	0x40140000,0x00000000, 244, 0x63576EC9,0x8994F489,
	0x40140000,0x00000000, 245, 0x637D4A7B,0xEBFA31AB,
	0x40140000,0x00000000, 246, 0x63A24E8D,0x737C5F0B,
	0x40140000,0x00000000, 247, 0x63C6E230,0xD05B76CD,
	0x40140000,0x00000000, 248, 0x63EC9ABD,0x04725481,
	0x40140000,0x00000000, 249, 0x6411E0B6,0x22C774D0,
	0x40140000,0x00000000, 250, 0x643658E3,0xAB795204,
	0x40140000,0x00000000, 251, 0x645BEF1C,0x9657A686,
	0x40140000,0x00000000, 252, 0x64817571,0xDDF6C814,
	0x40140000,0x00000000, 253, 0x64A5D2CE,0x55747A18,
	0x40140000,0x00000000, 254, 0x64CB4781,0xEAD1989E,
	0x40140000,0x00000000, 255, 0x64F10CB1,0x32C2FF63,
	0x40140000,0x00000000, 256, 0x65154FDD,0x7F73BF3C,
	0x40140000,0x00000000, 257, 0x653AA3D4,0xDF50AF0B,
	0x40140000,0x00000000, 258, 0x6560A665,0x0B926D67,
	0x40140000,0x00000000, 259, 0x6584CFFE,0x4E7708C0,
	0x40140000,0x00000000, 260, 0x65AA03FD,0xE214CAF1,
	0x40140000,0x00000000, 261, 0x65D0427E,0xAD4CFED6,
	0x40140000,0x00000000, 262, 0x65F4531E,0x58A03E8C,
	0x40140000,0x00000000, 263, 0x661967E5,0xEEC84E2F,
	0x40140000,0x00000000, 264, 0x663FC1DF,0x6A7A61BB,
	0x40140000,0x00000000, 265, 0x6663D92B,0xA28C7D15,
	0x40140000,0x00000000, 266, 0x6688CF76,0x8B2F9C5A,
	0x40140000,0x00000000, 267, 0x66AF0354,0x2DFB8370,
	0x40140000,0x00000000, 268, 0x66D36214,0x9CBD3226,
	0x40140000,0x00000000, 269, 0x66F83A99,0xC3EC7EB0,
	0x40140000,0x00000000, 270, 0x671E4940,0x34E79E5C,
	0x40140000,0x00000000, 271, 0x6742EDC8,0x2110C2F9,
	0x40140000,0x00000000, 272, 0x6767A93A,0x2954F3B8,
	0x40140000,0x00000000, 273, 0x678D9388,0xB3AA30A5,
	0x40140000,0x00000000, 274, 0x67B27C35,0x704A5E67,
	0x40140000,0x00000000, 275, 0x67D71B42,0xCC5CF601,
	0x40140000,0x00000000, 276, 0x67FCE213,0x7F743382,
	0x40140000,0x00000000, 277, 0x68220D4C,0x2FA8A031,
	0x40140000,0x00000000, 278, 0x6846909F,0x3B92C83D,
	0x40140000,0x00000000, 279, 0x686C34C7,0x0A777A4D,
	0x40140000,0x00000000, 280, 0x6891A0FC,0x668AAC70,
	0x40140000,0x00000000, 281, 0x68B6093B,0x802D578C,
	0x40140000,0x00000000, 282, 0x68DB8B8A,0x6038AD6F,
	0x40140000,0x00000000, 283, 0x69013736,0x7C236C65,
	0x40140000,0x00000000, 284, 0x69258504,0x1B2C477F,
	0x40140000,0x00000000, 285, 0x694AE645,0x21F7595E,
	0x40140000,0x00000000, 286, 0x6970CFEB,0x353A97DB,
	0x40140000,0x00000000, 287, 0x699503E6,0x02893DD2,
	0x40140000,0x00000000, 288, 0x69BA44DF,0x832B8D46,
	0x40140000,0x00000000, 289, 0x69E06B0B,0xB1FB384C,
	0x40140000,0x00000000, 290, 0x6A0485CE,0x9E7A065F,
	0x40140000,0x00000000, 291, 0x6A29A742,0x461887F6,
	0x40140000,0x00000000, 292, 0x6A500889,0x6BCF54FA,
	0x40140000,0x00000000, 293, 0x6A740AAB,0xC6C32A38,
	0x40140000,0x00000000, 294, 0x6A990D56,0xB873F4C7,
	0x40140000,0x00000000, 295, 0x6ABF50AC,0x6690F1F8,
	0x40140000,0x00000000, 296, 0x6AE3926B,0xC01A973B,
	0x40140000,0x00000000, 297, 0x6B087706,0xB0213D0A,
	0x40140000,0x00000000, 298, 0x6B2E94C8,0x5C298C4C,
	0x40140000,0x00000000, 299, 0x6B531CFD,0x3999F7B0,
	0x40140000,0x00000000, 300, 0x6B77E43C,0x8800759C,
	0x40180000,0x00000000, 2, 0x40420000,0x00000000,
	0x40180000,0x00000000, 3, 0x406B0000,0x00000000,
	0x40180000,0x00000000, 4, 0x40944000,0x00000000,
	0x40180000,0x00000000, 5, 0x40BE6000,0x00000000,
	0x40180000,0x00000000, 6, 0x40E6C800,0x00000000,
	0x40180000,0x00000000, 7, 0x41111600,0x00000000,
	0x40180000,0x00000000, 8, 0x4139A100,0x00000000,
	0x40180000,0x00000000, 9, 0x416338C0,0x00000000,
	0x40180000,0x00000000, 10, 0x418CD520,0x00000000,
	0x40180000,0x00000000, 11, 0x41B59FD8,0x00000000,
	0x40180000,0x00000000, 12, 0x41E037E2,0x00000000,
	0x40180000,0x0