// Copyright (c) 2001-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Symbian Foundation License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Fold and decomposition tables.
// These tables are linked in the following way:
// KUnicodeToIndexHash is a hash table using double hashing for
// conflict resolution. The functions DecompositionHashStart and
// DecompositionHashStep give the start and step values for accessing
// the table. The first probe is at DecompositionHashStart and each
// subsequent probe is offset by DecompositionHashStep. Probes
// continue until either 0 is found (indicating that the Unicode value
// sought has no decompostion (i.e. decomposes to itself) or a value
// is found that has the sought Unicode value in its lower 20 bits.
// In this latter case, the upper 12 bits contain an index into
// one of the following tables, according to the following rules:
// If the Index is less than the length of KNonSingletonFolds / 2,
// it is an index into KNonSingletonFolds or
// KNonSingletonDecompositions (depending on whether you want to
// fold or not -- both tables are indexed the same). If the Index is
// greater than the length of KNonSingletonFolds / 2, then it is an
// index into KSingletonFolds or KSingletonDecompositions (depending
// on whether you want to fold or not). Now, KSingletonDecompositions
// is shorter than KSingletonFolds, so if you have an Index greater than
// the length of KSingletonDecompositions plus half the length of
// KNonSingletonFolds, you have a character that has a fold but no
// decomposition.
// In summary:
// Let Knsf be the length of KNonSingletonFolds / 2,
// let Ksd be the length of KSingletonDecompositions and
// let Ksf be the length of KSingletonFolds.
// Now if you want to fold a character and you have found
// its index 'i' from the KUnicodeToIndexHash, then;
// if (i < Knsf) then look up
// KNonSingletonFolds[i * 2] and KNonSingletonFolds[i * 2 + 1]
// else look up KSingletonFolds[i - Knsf]
// Or if you want to decompose the same character, then;
// if (i < Knsf) then look up KNonSingletonDecompositions[i * 2]
// and tKNonSingletonDecompositions[i * 2 + 1]
// else if (Knsf <= i < Knsf + Ksd) look up KSingletonDecompositions[i - Knsf]
// else there is no decomposition for this character.
// Your index into KSingletonDecompositions or KSingletonFolds
// yields a single value which is the decomposition or fold.
// The KNonSingletonFolds and KNonSingletonDecomposition
// tables are made up of pairs of values. Each pair is either a pair
// of Unicode values that constitute the fold or decomposition, or
// the first value is KLongD and the second has its top 4 bits as the
// length of the decomposition (or folded decomposition) minus 3,
// and its bottom 12 bits as the index into KLongDecompositions
// of where you can find this decomposition.
// KLongDecompositions simply contains UTF-16 (Unicode) for
// all the decomposed and folded sequences longer than 4 bytes long.
// 
//

// Hash table mapping unicode values to indices into the other tables
const unsigned long KUnicodeToIndexHash[4096] =
	{
	0x3f702000, 0x3f802001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33f01026, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x51f00041, 0x52000042, 0x52100043, 0x52200044, 0x52300045, 0x52400046, 0x52500047,
	0x52600048, 0x52700049, 0x5280004a, 0x5290004b, 0x3700304c, 0x52a0004c, 0x3710304e, 0x52b0004d,
	0x37203050, 0x52c0004e, 0x37303052, 0x52d0004f, 0x37403054, 0x52e00050, 0x37503056, 0x52f00051,
	0x37603058, 0x53000052, 0x3770305a, 0x53100053, 0x3780305c, 0x53200054, 0x3790305e, 0x53300055,
	0x37a03060, 0x53400056, 0x37b03062, 0x53500057, 0x53600058, 0x37c03065, 0x53700059, 0x37d03067,
	0x5380005a, 0x37e03069, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x37f03070, 0x38003071, 0x00000000, 0x38103073, 0x38203074, 0x00000000, 0x38303076, 0x38403077,
	0x00000000, 0x38503079, 0x3860307a, 0x00000000, 0x3870307c, 0x3880307d, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x36f03094, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3890309e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x38b030ac, 0x00000000, 0x38c030ae, 0x00000000,
	0x38d030b0, 0x00000000, 0x38e030b2, 0x00000000, 0x38f030b4, 0x539000b5, 0x390030b6, 0x00000000,
	0x391030b8, 0x00000000, 0x392030ba, 0x00000000, 0x393030bc, 0x00000000, 0x394030be, 0x00000000,
	0x003000c0, 0x004000c1, 0x005000c2, 0x00a000c3, 0x013000c4, 0x016000c5, 0x53a000c6, 0x028000c7,
	0x030000c8, 0x031000c9, 0x032000ca, 0x03d000cb, 0x058000cc, 0x059000cd, 0x05a000ce, 0x05f000cf,
	0x39a030d0, 0x07a000d1, 0x081000d2, 0x082000d3, 0x083000d4, 0x088000d5, 0x092000d6, 0x39f030d7,
	0x53b000d0, 0x0bf000d9, 0x0c0000da, 0x0c1000db, 0x0c7000dc, 0x0e8000dd, 0x53c000d8, 0x53d000de,
	0x0f6000e0, 0x0f7000e1, 0x0f8000e2, 0x0fd000e3, 0x106000e4, 0x109000e5, 0x00000000, 0x11a000e7,
	0x122000e8, 0x123000e9, 0x124000ea, 0x12f000eb, 0x14b000ec, 0x14c000ed, 0x14d000ee, 0x151000ef,
	0x00000000, 0x16d000f1, 0x174000f2, 0x175000f3, 0x176000f4, 0x17b000f5, 0x185000f6, 0x3a4030f7,
	0x3a5030f8, 0x1b3000f9, 0x1b4000fa, 0x1b5000fb, 0x1bb000fc, 0x1dd000fd, 0x3a8030fe, 0x1e2000ff,
	0x00b00100, 0x0fe00101, 0x00c00102, 0x0ff00103, 0x02000104, 0x11200105, 0x02400106, 0x11600107,
	0x02500108, 0x11700109, 0x0260010a, 0x1180010b, 0x0270010c, 0x1190010d, 0x02b0010e, 0x11d0010f,
	0x53e00110, 0x00000000, 0x03800112, 0x12a00113, 0x03b00114, 0x12d00115, 0x03c00116, 0x12e00117,
	0x04600118, 0x13800119, 0x03f0011a, 0x1310011b, 0x04b0011c, 0x13d0011d, 0x04d0011e, 0x13f0011f,
	0x04e00120, 0x14000121, 0x05000122, 0x14200123, 0x05100124, 0x14300125, 0x3f902126, 0x53f00126,
	0x05b00128, 0x14e00129, 0x05c0012a, 0x0170212b, 0x05d0012c, 0x14f0012b, 0x0660012e, 0x1500012d,
	0x05e00130, 0x1580012f, 0x54000131, 0x54100132, 0x06800134, 0x15a00135, 0x06c00136, 0x15f00137,
	0x00000000, 0x06e00139, 0x1610013a, 0x0720013b, 0x1650013c, 0x06f0013d, 0x1620013e, 0x5420013f,
	0x00000000, 0x54300141, 0x00000000, 0x07900143, 0x16c00144, 0x07e00145, 0x17100146, 0x07c00147,
	0x16f00148, 0x00000000, 0x5440014a, 0x00000000, 0x08c0014c, 0x17f0014d, 0x08f0014e, 0x1820014f,
	0x09500150, 0x18800151, 0x54500152, 0x00000000, 0x0a500154, 0x19800155, 0x0ac00156, 0x19f00157,
	0x0a700158, 0x19a00159, 0x0ae0015a, 0x1a10015b, 0x0b00015c, 0x1a30015d, 0x0b70015e, 0x1aa0015f,
	0x0b200160, 0x1a500161, 0x0bc00162, 0x1b000163, 0x0b900164, 0x1ad00165, 0x54600166, 0x62a02167,
	0x0c200168, 0x1b600169, 0x0c40016a, 0x1b80016b, 0x0c60016c, 0x1ba0016d, 0x0cd0016e, 0x1c10016f,
	0x0ce00170, 0x1c200171, 0x0da00172, 0x1ce00173, 0x0e100174, 0x1d500175, 0x0e900176, 0x1de00177,
	0x0ed00178, 0x0f000179, 0x1e60017a, 0x0f20017b, 0x1e80017c, 0x0f30017d, 0x1e90017e, 0x5470017f,
	0x00000000, 0x54800181, 0x54900182, 0x00000000, 0x54a00184, 0x00000000, 0x54b00186, 0x54c00187,
	0x00000000, 0x54d00189, 0x54e0018a, 0x54f0018b, 0x00000000, 0x00000000, 0x5500018e, 0x5510018f,
	0x55200190, 0x55300191, 0x00000000, 0x55400193, 0x55500194, 0x00000000, 0x55600196, 0x55700197,
	0x55800198, 0x00000000, 0x3460219a, 0x3470219b, 0x5590019c, 0x55a0019d, 0x00000000, 0x55b0019f,
	0x099001a0, 0x18c001a1, 0x55c001a2, 0x00000000, 0x55d001a4, 0x4d90f9dc, 0x55e001a6, 0x55f001a7,
	0x00000000, 0x4550f958, 0x560001a9, 0x00000000, 0x561001ac, 0x00000000, 0x348021ae, 0x0d2001af,
	0x1c6001b0, 0x562001ae, 0x563001b1, 0x564001b2, 0x565001b3, 0x566001b5, 0x00000000, 0x567001b7,
	0x568001b8, 0x00000000, 0x00000000, 0x00000000, 0x569001bc, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4da0f9dd, 0x56a001c4, 0x56b001c5, 0x56c001c7,
	0x4560f959, 0x56d001c8, 0x56e001ca, 0x56f001cb, 0x00000000, 0x019001cd, 0x10b001ce, 0x062001cf,
	0x154001d0, 0x096001d1, 0x189001d2, 0x0cf001d3, 0x1c3001d4, 0x0ca001d5, 0x1be001d6, 0x0c9001d7,
	0x1bd001d8, 0x0cb001d9, 0x1bf001da, 0x0c8001db, 0x1bc001dc, 0x00000000, 0x014001de, 0x107001df,
	0x012001e0, 0x105001e1, 0x1f2001e2, 0x1f5001e3, 0x570001e4, 0x00000000, 0x04f001e6, 0x141001e7,
	0x06a001e8, 0x15d001e9, 0x0a1001ea, 0x194001eb, 0x0a2001ec, 0x195001ed, 0x1f8001ee, 0x1f9001ef,
	0x15b001f0, 0x571001f1, 0x572001f2, 0x00000000, 0x04a001f4, 0x13c001f5, 0x573001f6, 0x574001f7,
	0x078001f8, 0x16b001f9, 0x018001fa, 0x10a001fb, 0x1f1001fc, 0x1f4001fd, 0x1f3001fe, 0x1f6001ff,
	0x01a00200, 0x10c00201, 0x01b00202, 0x10d00203, 0x04000204, 0x13200205, 0x04100206, 0x13300207,
	0x06300208, 0x15500209, 0x0640020a, 0x1560020b, 0x0970020c, 0x18a0020d, 0x0980020e, 0x18b0020f,
	0x0a800210, 0x19b00211, 0x0a900212, 0x19c00213, 0x0d000214, 0x1c400215, 0x0d100216, 0x1c500217,
	0x0b600218, 0x1a900219, 0x0bb0021a, 0x1af0021b, 0x5750021c, 0x00000000, 0x0540021e, 0x1460021f,
	0x00000000, 0x00000000, 0x57600222, 0x00000000, 0x34f02224, 0x4590f95c, 0x01100226, 0x10400227,
	0x04400228, 0x13600229, 0x0930022a, 0x1860022b, 0x08a0022c, 0x17d0022d, 0x0900022e, 0x1830022f,
	0x09100230, 0x18400231, 0x0eb00232, 0x1e000233, 0x57700224, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x35102241, 0x00000000, 0x00000000, 0x35202244, 0x00000000, 0x00000000, 0x35302247,
	0x00000000, 0x35402249, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00102260, 0x00000000, 0x35602262, 0x45b0f95e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3550226d, 0x0000226e, 0x0020226f,
	0x35702270, 0x35802271, 0x00000000, 0x00000000, 0x35902274, 0x35a02275, 0x00000000, 0x00000000,
	0x35b02278, 0x35c02279, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x35d02280, 0x35e02281, 0x45c0f95f, 0x00000000, 0x36102284, 0x36202285, 0x00000000, 0x00000000,
	0x36302288, 0x36402289, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x367022ac, 0x368022ad, 0x369022ae, 0x36a022af,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x35f022e0, 0x360022e1, 0x365022e2, 0x366022e3, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x36b022ea, 0x36c022eb, 0x36d022ec, 0x36e022ed, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x3fb02329, 0x3fc0232a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x3ef00340, 0x3f000341, 0x00000000, 0x3f100343, 0x3a900344, 0x57800345, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3f200374, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3f30037e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1ee00385, 0x1fc00386, 0x3f400387,
	0x21100388, 0x21b00389, 0x22f0038a, 0x00000000, 0x23d0038c, 0x00000000, 0x2470038e, 0x2500038f,
	0x2a600390, 0x57900391, 0x57a00392, 0x57b00393, 0x57c00394, 0x57d00395, 0x57e00396, 0x57f00397,
	0x58000398, 0x58100399, 0x5820039a, 0x5830039b, 0x5840039c, 0x5850039d, 0x5860039e, 0x5870039f,
	0x588003a0, 0x589003a1, 0x00000000, 0x58a003a3, 0x58b003a4, 0x58c003a5, 0x58d003a6, 0x58e003a7,
	0x58f003a8, 0x590003a9, 0x232003aa, 0x24a003ab, 0x266003ac, 0x27e003ad, 0x288003ae, 0x29f003af,
	0x2c3003b0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x591003c2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x2a3003ca, 0x2c1003cb, 0x2b3003cc, 0x2bd003cd, 0x2d2003ce, 0x00000000,
	0x592003d0, 0x593003d1, 0x00000000, 0x2e7003d3, 0x2e8003d4, 0x594003d5, 0x595003d6, 0x00000000,
	0x00000000, 0x00000000, 0x596003da, 0x00000000, 0x597003dc, 0x00000000, 0x598003de, 0x00000000,
	0x599003e0, 0x00000000, 0x59a003e2, 0x00000000, 0x59b003e4, 0x00000000, 0x59c003e6, 0x00000000,
	0x59d003e8, 0x00000000, 0x59e003ea, 0x00000000, 0x59f003ec, 0x00000000, 0x5a0003ee, 0x00000000,
	0x5a1003f0, 0x5a2003f1, 0x5a3003f2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2ed00400, 0x2ef00401, 0x5a400402, 0x2ec00403, 0x5a500404, 0x5a600405, 0x5a700406, 0x2e900407,
	0x5a800408, 0x5a900409, 0x5aa0040a, 0x5ab0040b, 0x2f70040c, 0x2f30040d, 0x2fa0040e, 0x5ac0040f,
	0x5ad00410, 0x5ae00411, 0x45a0f95d, 0x5af00412, 0x5b000413, 0x5b100414, 0x5b200415, 0x5b300416,
	0x5b400417, 0x2f500419, 0x5b500418, 0x5b60041a, 0x5b70041b, 0x5b80041c, 0x5b90041d, 0x5ba0041e,
	0x5bb0041f, 0x5bc00420, 0x5bd00421, 0x5be00422, 0x5bf00423, 0x5c000424, 0x5c100425, 0x5c200426,
	0x5c300427, 0x5c400428, 0x5c500429, 0x5c60042a, 0x5c70042b, 0x5c80042c, 0x5c90042d, 0x5ca0042e,
	0x5cb0042f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x30b00439, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x30300450, 0x30500451, 0x00000000, 0x30200453, 0x00000000, 0x00000000, 0x00000000, 0x31600457,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x30d0045c, 0x3090045d, 0x3100045e, 0x00000000,
	0x5cc00460, 0x00000000, 0x5cd00462, 0x00000000, 0x5ce00464, 0x00000000, 0x5cf00466, 0x00000000,
	0x5d000468, 0x00000000, 0x5d10046a, 0x00000000, 0x5d20046c, 0x00000000, 0x5d30046e, 0x00000000,
	0x5d400470, 0x00000000, 0x5d500472, 0x00000000, 0x5d600474, 0x00000000, 0x31700476, 0x31800477,
	0x5d700478, 0x00000000, 0x5d80047a, 0x00000000, 0x5d90047c, 0x00000000, 0x5da0047e, 0x00000000,
	0x5db00480, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5dc0048c, 0x00000000, 0x5dd0048e, 0x00000000,
	0x5de00490, 0x00000000, 0x5df00492, 0x00000000, 0x5e000494, 0x00000000, 0x5e100496, 0x00000000,
	0x5e200498, 0x00000000, 0x5e30049a, 0x00000000, 0x5e40049c, 0x00000000, 0x5e50049e, 0x00000000,
	0x5e6004a0, 0x00000000, 0x5e7004a2, 0x00000000, 0x5e8004a4, 0x00000000, 0x5e9004a6, 0x00000000,
	0x5ea004a8, 0x00000000, 0x5eb004aa, 0x00000000, 0x5ec004ac, 0x00000000, 0x5ed004ae, 0x00000000,
	0x5ee004b0, 0x00000000, 0x5ef004b2, 0x00000000, 0x5f0004b4, 0x00000000, 0x5f1004b6, 0x634024b7,
	0x5f2004b8, 0x636024b9, 0x5f3004ba, 0x638024bb, 0x5f4004bc, 0x63a024bd, 0x5f5004be, 0x63c024bf,
	0x63d024c0, 0x2f0004c1, 0x306004c2, 0x5f6004c3, 0x641024c4, 0x642024c5, 0x643024c6, 0x5f7004c7,
	0x645024c8, 0x646024c9, 0x647024ca, 0x5f8004cb, 0x649024cc, 0x64a024cd, 0x64b024ce, 0x64c024cf,
	0x2ea004d0, 0x300004d1, 0x2eb004d2, 0x301004d3, 0x5f9004d4, 0x00000000, 0x2ee004d6, 0x304004d7,
	0x5fa004d8, 0x00000000, 0x319004da, 0x31a004db, 0x2f1004dc, 0x307004dd, 0x2f2004de, 0x308004df,
	0x5fb004e0, 0x00000000, 0x2f4004e2, 0x30a004e3, 0x2f6004e4, 0x30c004e5, 0x2f8004e6, 0x30e004e7,
	0x5fc004e8, 0x00000000, 0x31b004ea, 0x31c004eb, 0x2ff004ec, 0x315004ed, 0x2f9004ee, 0x30f004ef,
	0x2fb004f0, 0x311004f1, 0x2fc004f2, 0x312004f3, 0x2fd004f4, 0x313004f5, 0x00000000, 0x00000000,
	0x2fe004f8, 0x314004f9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x64d0ff21, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x64e0ff22,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x5fd00531, 0x5fe00532, 0x5ff00533, 0x60000534, 0x60100535, 0x60200536, 0x60300537,
	0x60400538, 0x60500539, 0x6060053a, 0x6070053b, 0x6080053c, 0x6090053d, 0x60a0053e, 0x60b0053f,
	0x60c00540, 0x395030c0, 0x60d00541, 0x60e00542, 0x60f00543, 0x61000544, 0x61100545, 0x61200546,
	0x61300547, 0x61400548, 0x61500549, 0x6160054a, 0x6170054b, 0x6180054c, 0x6190054d, 0x396030c2,
	0x61a0054e, 0x61b0054f, 0x61c00550, 0x61d00551, 0x61e00552, 0x61f00553, 0x62000554, 0x62100555,
	0x62200556, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6500ff24, 0x00000000, 0x00000000,
	0x00000000, 0x4c80f9cb, 0x00000000, 0x00000000, 0x397030c5, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x398030c7, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6510ff25, 0x00000000, 0x00000000, 0x00000000,
	0x399030c9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x6520ff26, 0x00000000, 0x00000000, 0x4c90f9cc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x39b030d1, 0x00000000, 0x6530ff27, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x39c030d3, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x39d030d4, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x3fa0212a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x6540ff28, 0x00000000, 0x39e030d6, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x3a0030d9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3a1030da,
	0x6550ff29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3a2030dc, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3a3030dd, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6560ff2a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x31e00622, 0x31f00623, 0x32100624, 0x32000625, 0x32200626, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6570ff2b, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6580ff2c, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x65d0ff31, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6590ff2d, 0x00000000, 0x00000000, 0x3eb0fb4b,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x65a0ff2e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x38a030f4, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x65b0ff2f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x325006c0, 0x00000000, 0x323006c2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x3a6030f9, 0x65c0ff30, 0x00000000, 0x324006d3, 0x00000000, 0x00000000, 0x00000000, 0x3a7030fa,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x62302160, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x62402161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x62502162, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x3ec0fb4c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x62702164, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x62802165, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x62902166,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x62b02168, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x62c02169, 0x65e0ff32,
	0x00000000, 0x00000000, 0x00000000, 0x62d0216a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x62e0216b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x62f0216c, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x6300216d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6310216e,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6320216f, 0x00000000, 0x65f0ff33, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3ff0f902,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6600ff34, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6610ff35, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x6620ff36, 0x00000000, 0x00000000, 0x00000000, 0x633024b6,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x635024b8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x637024ba, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x6630ff37, 0x00000000, 0x00000000, 0x639024bc, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x63b024be,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x63e024c1, 0x00000000,
	0x00000000, 0x6640ff38, 0x00000000, 0x63f024c2, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x640024c3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x4040f907, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x644024c7, 0x00000000, 0x00000000, 0x00000000,
	0x6650ff39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x648024cb, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6660ff3a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4090f90c, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x50d0fa15, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x3fd0f900, 0x3fe0f901, 0x349021cd, 0x4000f903, 0x4010f904, 0x4020f905, 0x4030f906, 0x34b021ce,
	0x4050f908, 0x4060f909, 0x4070f90a, 0x4080f90b, 0x34a021cf, 0x40a0f90d, 0x40b0f90e, 0x40c0f90f,
	0x40d0f910, 0x40e0f911, 0x40f0f912, 0x4100f913, 0x4110f914, 0x4120f915, 0x4130f916, 0x4140f917,
	0x4150f918, 0x4160f919, 0x4170f91a, 0x4180f91b, 0x4190f91c, 0x41a0f91d, 0x41b0f91e, 0x41c0f91f,
	0x41d0f920, 0x41e0f921, 0x41f0f922, 0x4200f923, 0x4210f924, 0x4220f925, 0x4230f926, 0x4240f927,
	0x4250f928, 0x32600929, 0x4270f92a, 0x4280f92b, 0x4290f92c, 0x42a0f92d, 0x42b0f92e, 0x42c0f92f,
	0x42d0f930, 0x32700931, 0x42f0f932, 0x4300f933, 0x32800934, 0x4320f935, 0x4330f936, 0x4340f937,
	0x4350f938, 0x4360f939, 0x4370f93a, 0x4380f93b, 0x4390f93c, 0x43a0f93d, 0x43b0f93e, 0x43c0f93f,
	0x43d0f940, 0x43e0f941, 0x43f0f942, 0x4400f943, 0x4410f944, 0x4420f945, 0x4430f946, 0x4440f947,
	0x4450f948, 0x4460f949, 0x4470f94a, 0x4480f94b, 0x4490f94c, 0x44a0f94d, 0x44b0f94e, 0x44c0f94f,
	0x44d0f950, 0x44e0f951, 0x44f0f952, 0x4500f953, 0x4510f954, 0x4520f955, 0x4530f956, 0x4540f957,
	0x3aa00958, 0x3ab00959, 0x3ac0095a, 0x3ad0095b, 0x3ae0095c, 0x3af0095d, 0x3b00095e, 0x3b10095f,
	0x45d0f960, 0x45e0f961, 0x45f0f962, 0x4600f963, 0x4610f964, 0x4620f965, 0x4630f966, 0x4640f967,
	0x4650f968, 0x4660f969, 0x4670f96a, 0x4680f96b, 0x4690f96c, 0x46a0f96d, 0x46b0f96e, 0x46c0f96f,
	0x46d0f970, 0x46e0f971, 0x46f0f972, 0x4700f973, 0x4710f974, 0x4720f975, 0x4730f976, 0x4740f977,
	0x4750f978, 0x4760f979, 0x4770f97a, 0x4780f97b, 0x4790f97c, 0x47a0f97d, 0x47b0f97e, 0x47c0f97f,
	0x47d0f980, 0x47e0f981, 0x47f0f982, 0x4800f983, 0x4810f984, 0x4820f985, 0x4830f986, 0x4840f987,
	0x4850f988, 0x4860f989, 0x4870f98a, 0x4880f98b, 0x4890f98c, 0x48a0f98d, 0x48b0f98e, 0x48c0f98f,
	0x48d0f990, 0x48e0f991, 0x48f0f992, 0x4900f993, 0x4910f994, 0x4920f995, 0x4930f996, 0x4940f997,
	0x4950f998, 0x4960f999, 0x4970f99a, 0x4980f99b, 0x4990f99c, 0x49a0f99d, 0x49b0f99e, 0x49c0f99f,
	0x49d0f9a0, 0x49e0f9a1, 0x49f0f9a2, 0x4a00f9a3, 0x4a10f9a4, 0x4a20f9a5, 0x4a30f9a6, 0x4a40f9a7,
	0x4a50f9a8, 0x4a60f9a9, 0x4a70f9aa, 0x4a80f9ab, 0x4a90f9ac, 0x4aa0f9ad, 0x4ab0f9ae, 0x4ac0f9af,
	0x4ad0f9b0, 0x4ae0f9b1, 0x4af0f9b2, 0x4b00f9b3, 0x4b10f9b4, 0x4b20f9b5, 0x4b30f9b6, 0x4b40f9b7,
	0x4b50f9b8, 0x4b60f9b9, 0x4b70f9ba, 0x4b80f9bb, 0x4b90f9bc, 0x4ba0f9bd, 0x4bb0f9be, 0x4bc0f9bf,
	0x4bd0f9c0, 0x4be0f9c1, 0x4bf0f9c2, 0x4c00f9c3, 0x4c10f9c4, 0x4c20f9c5, 0x4c30f9c6, 0x4c40f9c7,
	0x4c50f9c8, 0x4c60f9c9, 0x4c70f9ca, 0x329009cb, 0x32a009cc, 0x4ca0f9cd, 0x4cb0f9ce, 0x4cc0f9cf,
	0x4cd0f9d0, 0x4ce0f9d1, 0x4cf0f9d2, 0x4d00f9d3, 0x4d10f9d4, 0x4d20f9d5, 0x4d30f9d6, 0x4d40f9d7,
	0x4d50f9d8, 0x4d60f9d9, 0x4d70f9da, 0x4d80f9db, 0x3b2009dc, 0x3b3009dd, 0x4db0f9de, 0x3b4009df,
	0x4dd0f9e0, 0x4de0f9e1, 0x4df0f9e2, 0x4e00f9e3, 0x4e10f9e4, 0x4e20f9e5, 0x4e30f9e6, 0x4e40f9e7,
	0x4e50f9e8, 0x4e60f9e9, 0x4e70f9ea, 0x4e80f9eb, 0x4e90f9ec, 0x4ea0f9ed, 0x4eb0f9ee, 0x4ec0f9ef,
	0x4ed0f9f0, 0x4ee0f9f1, 0x4ef0f9f2, 0x4f00f9f3, 0x4f10f9f4, 0x4f20f9f5, 0x4f30f9f6, 0x4f40f9f7,
	0x4f50f9f8, 0x4f60f9f9, 0x4f70f9fa, 0x4f80f9fb, 0x4f90f9fc, 0x4fa0f9fd, 0x4fb0f9fe, 0x4fc0f9ff,
	0x4fd0fa00, 0x4fe0fa01, 0x4ff0fa02, 0x5000fa03, 0x5010fa04, 0x5020fa05, 0x5030fa06, 0x5040fa07,
	0x5050fa08, 0x5060fa09, 0x5070fa0a, 0x5080fa0b, 0x5090fa0c, 0x50a0fa0d, 0x00000000, 0x00000000,
	0x50b0fa10, 0x00000000, 0x50c0fa12, 0x00000000, 0x00000000, 0x34c02204, 0x50e0fa16, 0x50f0fa17,
	0x5100fa18, 0x5110fa19, 0x5120fa1a, 0x5130fa1b, 0x5140fa1c, 0x5150fa1d, 0x5160fa1e, 0x00000000,
	0x5170fa20, 0x00000000, 0x5180fa22, 0x00000000, 0x00000000, 0x4dc0f9df, 0x51a0fa26, 0x00000000,
	0x00000000, 0x00000000, 0x51b0fa2a, 0x51c0fa2b, 0x51d0fa2c, 0x51e0fa2d, 0x34d02209, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x3b500a33, 0x00000000, 0x00000000, 0x3b600a36, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x34e0220c, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x3b700a59, 0x3b800a5a, 0x3b900a5b, 0x00000000, 0x00000000, 0x3ba00a5e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4570f95a, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5190fa25, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x4580f95b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x35002226,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x31d0fb1d, 0x00000000, 0x3ce0fb1f,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x3cf0fb2a, 0x3d00fb2b, 0x3d10fb2c, 0x3d20fb2d, 0x3d30fb2e, 0x3d40fb2f,
	0x3d50fb30, 0x3d60fb31, 0x3d70fb32, 0x3d80fb33, 0x3d90fb34, 0x3da0fb35, 0x3db0fb36, 0x00000000,
	0x3dc0fb38, 0x3dd0fb39, 0x3de0fb3a, 0x3df0fb3b, 0x3e00fb3c, 0x00000000, 0x3e10fb3e, 0x00000000,
	0x3e20fb40, 0x3e30fb41, 0x00000000, 0x3e40fb43, 0x3e50fb44, 0x00000000, 0x3e60fb46, 0x3e70fb47,
	0x32c00b48, 0x3e90fb49, 0x3ea0fb4a, 0x32b00b4b, 0x32d00b4c, 0x3ed0fb4d, 0x3ee0fb4e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x64f0ff23, 0x00000000, 0x00000000, 0x3bb00b5c, 0x3bc00b5d, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x32e00b94, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x32f00bca, 0x33100bcb, 0x33000bcc, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4260f929, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x33200c48, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x62602163, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x33300cc0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33600cc7,
	0x33700cc8, 0x00000000, 0x33400cca, 0x33500ccb, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x42e0f931, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x33800d4a, 0x33a00d4b, 0x33900d4c, 0x4310f934, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x3f501fbe, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x3e80fb48, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x33b00dda, 0x00000000, 0x33c00ddc, 0x33d00ddd, 0x33e00dde, 0x3f601fef,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x01f01e00, 0x11101e01, 0x02101e02, 0x11301e03, 0x02201e04, 0x11401e05, 0x02301e06, 0x11501e07,
	0x02901e08, 0x11b01e09, 0x02a01e0a, 0x11c01e0b, 0x02c01e0c, 0x11e01e0d, 0x02f01e0e, 0x12101e0f,
	0x02d01e10, 0x11f01e11, 0x02e01e12, 0x12001e13, 0x03901e14, 0x12b01e15, 0x03a01e16, 0x12c01e17,
	0x04701e18, 0x13901e19, 0x04801e1a, 0x13a01e1b, 0x04501e1c, 0x13701e1d, 0x04901e1e, 0x13b01e1f,
	0x04c01e20, 0x13e01e21, 0x05201e22, 0x14401e23, 0x05501e24, 0x14701e25, 0x05301e26, 0x14501e27,
	0x05601e28, 0x14801e29, 0x05701e2a, 0x14901e2b, 0x06701e2c, 0x15901e2d, 0x06001e2e, 0x15201e2f,
	0x06901e30, 0x15c01e31, 0x06b01e32, 0x15e01e33, 0x06d01e34, 0x16001e35, 0x07001e36, 0x16301e37,
	0x07101e38, 0x16401e39, 0x07401e3a, 0x16701e3b, 0x07301e3c, 0x16601e3d, 0x07501e3e, 0x16801e3f,
	0x07601e40, 0x16901e41, 0x07701e42, 0x16a01e43, 0x07b01e44, 0x16e01e45, 0x07d01e46, 0x17001e47,
	0x08001e48, 0x17301e49, 0x07f01e4a, 0x17201e4b, 0x08901e4c, 0x17c01e4d, 0x08b01e4e, 0x17e01e4f,
	0x08d01e50, 0x18001e51, 0x08e01e52, 0x18101e53, 0x0a301e54, 0x19601e55, 0x0a401e56, 0x19701e57,
	0x0a601e58, 0x19901e59, 0x0aa01e5a, 0x19d01e5b, 0x0ab01e5c, 0x19e01e5d, 0x0ad01e5e, 0x1a001e5f,
	0x0b101e60, 0x1a401e61, 0x0b401e62, 0x1a701e63, 0x0af01e64, 0x1a201e65, 0x0b301e66, 0x1a601e67,
	0x0b501e68, 0x1a801e69, 0x0b801e6a, 0x1ab01e6b, 0x0ba01e6c, 0x1ae01e6d, 0x0be01e6e, 0x1b201e6f,
	0x0bd01e70, 0x1b101e71, 0x0d901e72, 0x1cd01e73, 0x0dc01e74, 0x1d001e75, 0x0db01e76, 0x1cf01e77,
	0x0c301e78, 0x1b701e79, 0x0c501e7a, 0x1b901e7b, 0x0dd01e7c, 0x1d101e7d, 0x0de01e7e, 0x1d201e7f,
	0x0df01e80, 0x1d301e81, 0x0e001e82, 0x1d401e83, 0x0e301e84, 0x1d701e85, 0x0e201e86, 0x1d601e87,
	0x0e401e88, 0x1d901e89, 0x0e501e8a, 0x1da01e8b, 0x0e601e8c, 0x1db01e8d, 0x0ec01e8e, 0x1e101e8f,
	0x0f101e90, 0x1e701e91, 0x0f401e92, 0x1ea01e93, 0x0f501e94, 0x1eb01e95, 0x14a01e96, 0x1ac01e97,
	0x1d801e98, 0x1e401e99, 0x00000000, 0x1f701e9b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x01c01ea0, 0x10e01ea1, 0x01501ea2, 0x10801ea3, 0x00701ea4, 0x0fa01ea5, 0x00601ea6, 0x0f901ea7,
	0x00901ea8, 0x0fc01ea9, 0x00801eaa, 0x0fb01eab, 0x01d01eac, 0x10f01ead, 0x00e01eae, 0x10101eaf,
	0x00d01eb0, 0x10001eb1, 0x01001eb2, 0x10301eb3, 0x00f01eb4, 0x10201eb5, 0x01e01eb6, 0x11001eb7,
	0x04201eb8, 0x13401eb9, 0x03e01eba, 0x13001ebb, 0x03701ebc, 0x12901ebd, 0x03401ebe, 0x12601ebf,
	0x03301ec0, 0x12501ec1, 0x03601ec2, 0x12801ec3, 0x03501ec4, 0x12701ec5, 0x04301ec6, 0x13501ec7,
	0x06101ec8, 0x15301ec9, 0x06501eca, 0x15701ecb, 0x09f01ecc, 0x19201ecd, 0x09401ece, 0x18701ecf,
	0x08501ed0, 0x17801ed1, 0x08401ed2, 0x17701ed3, 0x08701ed4, 0x17a01ed5, 0x08601ed6, 0x17901ed7,
	0x0a001ed8, 0x19301ed9, 0x09b01eda, 0x18e01edb, 0x09a01edc, 0x18d01edd, 0x09d01ede, 0x19001edf,
	0x09c01ee0, 0x18f01ee1, 0x09e01ee2, 0x19101ee3, 0x0d801ee4, 0x1cc01ee5, 0x0cc01ee6, 0x1c001ee7,
	0x0d401ee8, 0x1c801ee9, 0x0d301eea, 0x1c701eeb, 0x0d601eec, 0x1ca01eed, 0x0d501eee, 0x1c901eef,
	0x0d701ef0, 0x1cb01ef1, 0x0e701ef2, 0x1dc01ef3, 0x0ef01ef4, 0x1e501ef5, 0x0ee01ef6, 0x1e301ef7,
	0x0ea01ef8, 0x1df01ef9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x26a01f00, 0x27201f01, 0x26b01f02, 0x27301f03, 0x26d01f04, 0x27501f05, 0x26f01f06, 0x27701f07,
	0x1ff01f08, 0x20701f09, 0x20001f0a, 0x20801f0b, 0x20201f0c, 0x20a01f0d, 0x20401f0e, 0x20c01f0f,
	0x28001f10, 0x28301f11, 0x28101f12, 0x28401f13, 0x28201f14, 0x28501f15, 0x00000000, 0x00000000,
	0x21301f18, 0x21601f19, 0x21401f1a, 0x21701f1b, 0x21501f1c, 0x21801f1d, 0x00000000, 0x00000000,
	0x28b01f20, 0x29301f21, 0x28c01f22, 0x29401f23, 0x28e01f24, 0x29601f25, 0x29001f26, 0x29801f27,
	0x21c01f28, 0x22401f29, 0x21d01f2a, 0x22501f2b, 0x21f01f2c, 0x22701f2d, 0x22101f2e, 0x22901f2f,
	0x2a801f30, 0x2ac01f31, 0x2a901f32, 0x2ad01f33, 0x2aa01f34, 0x2ae01f35, 0x2ab01f36, 0x2af01f37,
	0x23301f38, 0x23701f39, 0x23401f3a, 0x23801f3b, 0x23501f3c, 0x23901f3d, 0x23601f3e, 0x23a01f3f,
	0x2b401f40, 0x2b701f41, 0x2b501f42, 0x2b801f43, 0x2b601f44, 0x2b901f45, 0x3bd00f43, 0x00000000,
	0x23e01f48, 0x24101f49, 0x23f01f4a, 0x24201f4b, 0x24001f4c, 0x24301f4d, 0x3be00f4d, 0x00000000,
	0x2c601f50, 0x2ca01f51, 0x2c701f52, 0x2cb01f53, 0x2c801f54, 0x2cc01f55, 0x2c901f56, 0x2cd01f57,
	0x3bf00f52, 0x24b01f59, 0x3c000f57, 0x24c01f5b, 0x3c100f5c, 0x24d01f5d, 0x00000000, 0x24e01f5f,
	0x2d401f60, 0x2dc01f61, 0x2d501f62, 0x2dd01f63, 0x2d701f64, 0x2df01f65, 0x2d901f66, 0x2e101f67,
	0x25201f68, 0x25a01f69, 0x25301f6a, 0x25b01f6b, 0x25501f6c, 0x25d01f6d, 0x25701f6e, 0x25f01f6f,
	0x26301f70, 0x26501f71, 0x27d01f72, 0x27f01f73, 0x28601f74, 0x28901f75, 0x29e01f76, 0x2a001f77,
	0x2b101f78, 0x2b201f79, 0x2bc01f7a, 0x2be01f7b, 0x2cf01f7c, 0x2d101f7d, 0x3c200f69, 0x3c300f73,
	0x27101f80, 0x27901f81, 0x26c01f82, 0x27401f83, 0x26e01f84, 0x27601f85, 0x27001f86, 0x27801f87,
	0x20601f88, 0x20e01f89, 0x20101f8a, 0x20901f8b, 0x20301f8c, 0x20b01f8d, 0x20501f8e, 0x20d01f8f,
	0x29201f90, 0x29a01f91, 0x28d01f92, 0x29501f93, 0x28f01f94, 0x29701f95, 0x29101f96, 0x29901f97,
	0x22301f98, 0x22b01f99, 0x21e01f9a, 0x22601f9b, 0x22001f9c, 0x22801f9d, 0x22201f9e, 0x22a01f9f,
	0x2db01fa0, 0x2e301fa1, 0x2d601fa2, 0x2de01fa3, 0x2d801fa4, 0x2e001fa5, 0x2da01fa6, 0x2e201fa7,
	0x25901fa8, 0x26101fa9, 0x25401faa, 0x25c01fab, 0x25601fac, 0x25e01fad, 0x25801fae, 0x26001faf,
	0x26901fb0, 0x26801fb1, 0x26401fb2, 0x27c01fb3, 0x26701fb4, 0x3c400f75, 0x27a01fb6, 0x27b01fb7,
	0x1fe01fb8, 0x1fd01fb9, 0x1fa01fba, 0x1fb01fbb, 0x20f01fbc, 0x3c500f76, 0x3c600f78, 0x3c700f81,
	0x3c800f93, 0x1ef01fc1, 0x28701fc2, 0x29d01fc3, 0x28a01fc4, 0x3c900f9d, 0x29b01fc6, 0x29c01fc7,
	0x21001fc8, 0x21201fc9, 0x21901fca, 0x21a01fcb, 0x22c01fcc, 0x34001fcd, 0x34101fce, 0x34201fcf,
	0x2a201fd0, 0x2a101fd1, 0x2a401fd2, 0x2a501fd3, 0x3ca00fa2, 0x3cb00fa7, 0x2b001fd6, 0x2a701fd7,
	0x23101fd8, 0x23001fd9, 0x22d01fda, 0x22e01fdb, 0x3cc00fac, 0x34301fdd, 0x34401fde, 0x34501fdf,
	0x2c001fe0, 0x2bf01fe1, 0x2c201fe2, 0x2c401fe3, 0x2ba01fe4, 0x2bb01fe5, 0x2ce01fe6, 0x2c501fe7,
	0x24901fe8, 0x24801fe9, 0x24501fea, 0x24601feb, 0x24401fec, 0x1ec01fed, 0x1ed01fee, 0x3cd00fb9,
	0x00000000, 0x00000000, 0x2d001ff2, 0x2e601ff3, 0x2d301ff4, 0x00000000, 0x2e401ff6, 0x2e501ff7,
	0x23b01ff8, 0x23c01ff9, 0x24f01ffa, 0x25101ffb, 0x26201ffc, 0x1f001ffd, 0x00000000, 0x00000000
	};

// Hash table access functions
const int KDecompositionHashBitmask = 0xfff;

inline int DecompositionHashStart(long a)
	{
	return a & 0xfff;
	}

inline int DecompositionHashStep(long a)
	{
	a *= a >> 12;
	return ((a<<1) + 1) & 0xfff;
	}

// Table mapping KNonSingletonDecompositions to the hash table entry that
// indexes it
const unsigned short KCompositionMapping[] =
	{
	0x026e, 0x0260, 0x026f, 0x00c0, 0x00c1, 0x00c2, 0x0ea6, 0x0ea4,
	0x0eaa, 0x0ea8, 0x00c3, 0x0100, 0x0102, 0x0eb0, 0x0eae, 0x0eb4,
	0x0eb2, 0x0226, 0x01e0, 0x00c4, 0x01de, 0x0ea2, 0x00c5, 0x012b,
	0x01fa, 0x01cd, 0x0200, 0x0202, 0x0ea0, 0x0eac, 0x0eb6, 0x0e00,
	0x0104, 0x0e02, 0x0e04, 0x0e06, 0x0106, 0x0108, 0x010a, 0x010c,
	0x00c7, 0x0e08, 0x0e0a, 0x010e, 0x0e0c, 0x0e10, 0x0e12, 0x0e0e,
	0x00c8, 0x00c9, 0x00ca, 0x0ec0, 0x0ebe, 0x0ec4, 0x0ec2, 0x0ebc,
	0x0112, 0x0e14, 0x0e16, 0x0114, 0x0116, 0x00cb, 0x0eba, 0x011a,
	0x0204, 0x0206, 0x0eb8, 0x0ec6, 0x0228, 0x0e1c, 0x0118, 0x0e18,
	0x0e1a, 0x0e1e, 0x01f4, 0x011c, 0x0e20, 0x011e, 0x0120, 0x01e6,
	0x0122, 0x0124, 0x0e22, 0x0e26, 0x021e, 0x0e24, 0x0e28, 0x0e2a,
	0x00cc, 0x00cd, 0x00ce, 0x0128, 0x012a, 0x012c, 0x0130, 0x00cf,
	0x0e2e, 0x0ec8, 0x01cf, 0x0208, 0x020a, 0x0eca, 0x012e, 0x0e2c,
	0x0134, 0x0e30, 0x01e8, 0x0e32, 0x0136, 0x0e34, 0x0139, 0x013d,
	0x0e36, 0x0e38, 0x013b, 0x0e3c, 0x0e3a, 0x0e3e, 0x0e40, 0x0e42,
	0x01f8, 0x0143, 0x00d1, 0x0e44, 0x0147, 0x0e46, 0x0145, 0x0e4a,
	0x0e48, 0x00d2, 0x00d3, 0x00d4, 0x0ed2, 0x0ed0, 0x0ed6, 0x0ed4,
	0x00d5, 0x0e4c, 0x022c, 0x0e4e, 0x014c, 0x0e50, 0x0e52, 0x014e,
	0x022e, 0x0230, 0x00d6, 0x022a, 0x0ece, 0x0150, 0x01d1, 0x020c,
	0x020e, 0x01a0, 0x0edc, 0x0eda, 0x0ee0, 0x0ede, 0x0ee2, 0x0ecc,
	0x0ed8, 0x01ea, 0x01ec, 0x0e54, 0x0e56, 0x0154, 0x0e58, 0x0158,
	0x0210, 0x0212, 0x0e5a, 0x0e5c, 0x0156, 0x0e5e, 0x015a, 0x0e64,
	0x015c, 0x0e60, 0x0160, 0x0e66, 0x0e62, 0x0e68, 0x0218, 0x015e,
	0x0e6a, 0x0164, 0x0e6c, 0x021a, 0x0162, 0x0e70, 0x0e6e, 0x00d9,
	0x00da, 0x00db, 0x0168, 0x0e78, 0x016a, 0x0e7a, 0x016c, 0x00dc,
	0x01db, 0x01d7, 0x01d5, 0x01d9, 0x0ee6, 0x016e, 0x0170, 0x01d3,
	0x0214, 0x0216, 0x01af, 0x0eea, 0x0ee8, 0x0eee, 0x0eec, 0x0ef0,
	0x0ee4, 0x0e72, 0x0172, 0x0e76, 0x0e74, 0x0e7c, 0x0e7e, 0x0e80,
	0x0e82, 0x0174, 0x0e86, 0x0e84, 0x0e88, 0x0e8a, 0x0e8c, 0x0ef2,
	0x00dd, 0x0176, 0x0ef8, 0x0232, 0x0e8e, 0x0178, 0x0ef6, 0x0ef4,
	0x0179, 0x0e90, 0x017b, 0x017d, 0x0e92, 0x0e94, 0x00e0, 0x00e1,
	0x00e2, 0x0ea7, 0x0ea5, 0x0eab, 0x0ea9, 0x00e3, 0x0101, 0x0103,
	0x0eb1, 0x0eaf, 0x0eb5, 0x0eb3, 0x0227, 0x01e1, 0x00e4, 0x01df,
	0x0ea3, 0x00e5, 0x01fb, 0x01ce, 0x0201, 0x0203, 0x0ea1, 0x0ead,
	0x0eb7, 0x0e01, 0x0105, 0x0e03, 0x0e05, 0x0e07, 0x0107, 0x0109,
	0x010b, 0x010d, 0x00e7, 0x0e09, 0x0e0b, 0x010f, 0x0e0d, 0x0e11,
	0x0e13, 0x0e0f, 0x00e8, 0x00e9, 0x00ea, 0x0ec1, 0x0ebf, 0x0ec5,
	0x0ec3, 0x0ebd, 0x0113, 0x0e15, 0x0e17, 0x0115, 0x0117, 0x00eb,
	0x0ebb, 0x011b, 0x0205, 0x0207, 0x0eb9, 0x0ec7, 0x0229, 0x0e1d,
	0x0119, 0x0e19, 0x0e1b, 0x0e1f, 0x01f5, 0x011d, 0x0e21, 0x011f,
	0x0121, 0x01e7, 0x0123, 0x0125, 0x0e23, 0x0e27, 0x021f, 0x0e25,
	0x0e29, 0x0e2b, 0x0e96, 0x00ec, 0x00ed, 0x00ee, 0x0129, 0x012d,
	0x012f, 0x00ef, 0x0e2f, 0x0ec9, 0x01d0, 0x0209, 0x020b, 0x0ecb,
	0x0131, 0x0e2d, 0x0135, 0x01f0, 0x0e31, 0x01e9, 0x0e33, 0x0137,
	0x0e35, 0x013a, 0x013e, 0x0e37, 0x0e39, 0x013c, 0x0e3d, 0x0e3b,
	0x0e3f, 0x0e41, 0x0e43, 0x01f9, 0x0144, 0x00f1, 0x0e45, 0x0148,
	0x0e47, 0x0146, 0x0e4b, 0x0e49, 0x00f2, 0x00f3, 0x00f4, 0x0ed3,
	0x0ed1, 0x0ed7, 0x0ed5, 0x00f5, 0x0e4d, 0x022d, 0x0e4f, 0x014d,
	0x0e51, 0x0e53, 0x014f, 0x022f, 0x0231, 0x00f6, 0x022b, 0x0ecf,
	0x0151, 0x01d2, 0x020d, 0x020f, 0x01a1, 0x0edd, 0x0edb, 0x0ee1,
	0x0edf, 0x0ee3, 0x0ecd, 0x0ed9, 0x01eb, 0x01ed, 0x0e55, 0x0e57,
	0x0155, 0x0e59, 0x0159, 0x0211, 0x0213, 0x0e5b, 0x0e5d, 0x0157,
	0x0e5f, 0x015b, 0x0e65, 0x015d, 0x0e61, 0x0161, 0x0e67, 0x0e63,
	0x0e69, 0x0219, 0x015f, 0x0e6b, 0x0e97, 0x0165, 0x0e6d, 0x021b,
	0x0163, 0x0e71, 0x0e6f, 0x00f9, 0x00fa, 0x00fb, 0x0169, 0x0e79,
	0x016b, 0x0e7b, 0x016d, 0x00fc, 0x01dc, 0x01d8, 0x01d6, 0x01da,
	0x0ee7, 0x016f, 0x0171, 0x01d4, 0x0215, 0x0217, 0x01b0, 0x0eeb,
	0x0ee9, 0x0eef, 0x0eed, 0x0ef1, 0x0ee5, 0x0e73, 0x0173, 0x0e77,
	0x0e75, 0x0e7d, 0x0e7f, 0x0e81, 0x0e83, 0x0175, 0x0e87, 0x0e85,
	0x0e98, 0x0e89, 0x0e8b, 0x0e8d, 0x0ef3, 0x00fd, 0x0177, 0x0ef9,
	0x0233, 0x0e8f, 0x00ff, 0x0ef7, 0x0e99, 0x0ef5, 0x017a, 0x0e91,
	0x017c, 0x017e, 0x0e93, 0x0e95, 0x0fed, 0x0fee, 0x0385, 0x0fc1,
	0x0ffd, 0x01fc, 0x01e2, 0x01fe, 0x01fd, 0x01e3, 0x01ff, 0x0e9b,
	0x01ee, 0x01ef, 0x0fba, 0x0fbb, 0x0386, 0x0fb9, 0x0fb8, 0x0f08,
	0x0f0a, 0x0f8a, 0x0f0c, 0x0f8c, 0x0f0e, 0x0f8e, 0x0f88, 0x0f09,
	0x0f0b, 0x0f8b, 0x0f0d, 0x0f8d, 0x0f0f, 0x0f8f, 0x0f89, 0x0fbc,
	0x0fc8, 0x0388, 0x0fc9, 0x0f18, 0x0f1a, 0x0f1c, 0x0f19, 0x0f1b,
	0x0f1d, 0x0fca, 0x0fcb, 0x0389, 0x0f28, 0x0f2a, 0x0f9a, 0x0f2c,
	0x0f9c, 0x0f2e, 0x0f9e, 0x0f98, 0x0f29, 0x0f2b, 0x0f9b, 0x0f2d,
	0x0f9d, 0x0f2f, 0x0f9f, 0x0f99, 0x0fcc, 0x0fda, 0x0fdb, 0x038a,
	0x0fd9, 0x0fd8, 0x03aa, 0x0f38, 0x0f3a, 0x0f3c, 0x0f3e, 0x0f39,
	0x0f3b, 0x0f3d, 0x0f3f, 0x0ff8, 0x0ff9, 0x038c, 0x0f48, 0x0f4a,
	0x0f4c, 0x0f49, 0x0f4b, 0x0f4d, 0x0fec, 0x0fea, 0x0feb, 0x038e,
	0x0fe9, 0x0fe8, 0x03ab, 0x0f59, 0x0f5b, 0x0f5d, 0x0f5f, 0x0ffa,
	0x038f, 0x0ffb, 0x0f68, 0x0f6a, 0x0faa, 0x0f6c, 0x0fac, 0x0f6e,
	0x0fae, 0x0fa8, 0x0f69, 0x0f6b, 0x0fab, 0x0f6d, 0x0fad, 0x0f6f,
	0x0faf, 0x0fa9, 0x0ffc, 0x0f70, 0x0fb2, 0x0f71, 0x03ac, 0x0fb4,
	0x0fb1, 0x0fb0, 0x0f00, 0x0f02, 0x0f82, 0x0f04, 0x0f84, 0x0f06,
	0x0f86, 0x0f80, 0x0f01, 0x0f03, 0x0f83, 0x0f05, 0x0f85, 0x0f07,
	0x0f87, 0x0f81, 0x0fb6, 0x0fb7, 0x0fb3, 0x0f72, 0x03ad, 0x0f73,
	0x0f10, 0x0f12, 0x0f14, 0x0f11, 0x0f13, 0x0f15, 0x0f74, 0x0fc2,
	0x03ae, 0x0f75, 0x0fc4, 0x0f20, 0x0f22, 0x0f92, 0x0f24, 0x0f94,
	0x0f26, 0x0f96, 0x0f90, 0x0f21, 0x0f23, 0x0f93, 0x0f25, 0x0f95,
	0x0f27, 0x0f97, 0x0f91, 0x0fc6, 0x0fc7, 0x0fc3, 0x0f76, 0x03af,
	0x0f77, 0x0fd1, 0x0fd0, 0x03ca, 0x0fd2, 0x0fd3, 0x0390, 0x0fd7,
	0x0f30, 0x0f32, 0x0f34, 0x0f36, 0x0f31, 0x0f33, 0x0f35, 0x0f37,
	0x0fd6, 0x0f78, 0x0f79, 0x03cc, 0x0f40, 0x0f42, 0x0f44, 0x0f41,
	0x0f43, 0x0f45, 0x0fe4, 0x0fe5, 0x0f7a, 0x03cd, 0x0f7b, 0x0fe1,
	0x0fe0, 0x03cb, 0x0fe2, 0x03b0, 0x0fe3, 0x0fe7, 0x0f50, 0x0f52,
	0x0f54, 0x0f56, 0x0f51, 0x0f53, 0x0f55, 0x0f57, 0x0fe6, 0x0f7c,
	0x0ff2, 0x0f7d, 0x03ce, 0x0ff4, 0x0f60, 0x0f62, 0x0fa2, 0x0f64,
	0x0fa4, 0x0f66, 0x0fa6, 0x0fa0, 0x0f61, 0x0f63, 0x0fa3, 0x0f65,
	0x0fa5, 0x0f67, 0x0fa7, 0x0fa1, 0x0ff6, 0x0ff7, 0x0ff3, 0x03d3,
	0x03d4, 0x0407, 0x04d0, 0x04d2, 0x0403, 0x0400, 0x04d6, 0x0401,
	0x04c1, 0x04dc, 0x04de, 0x040d, 0x04e2, 0x0419, 0x04e4, 0x040c,
	0x04e6, 0x04ee, 0x040e, 0x04f0, 0x04f2, 0x04f4, 0x04f8, 0x04ec,
	0x04d1, 0x04d3, 0x0453, 0x0450, 0x04d7, 0x0451, 0x04c2, 0x04dd,
	0x04df, 0x045d, 0x04e3, 0x0439, 0x04e5, 0x045c, 0x04e7, 0x04ef,
	0x045e, 0x04f1, 0x04f3, 0x04f5, 0x04f9, 0x04ed, 0x0457, 0x0476,
	0x0477, 0x04da, 0x04db, 0x04ea, 0x04eb, 0x0b1d, 0x0622, 0x0623,
	0x0625, 0x0624, 0x0626, 0x06c2, 0x06d3, 0x06c0, 0x0929, 0x0931,
	0x0934, 0x09cb, 0x09cc, 0x0b4b, 0x0b48, 0x0b4c, 0x0b94, 0x0bca,
	0x0bcc, 0x0bcb, 0x0c48, 0x0cc0, 0x0cca, 0x0ccb, 0x0cc7, 0x0cc8,
	0x0d4a, 0x0d4c, 0x0d4b, 0x0dda, 0x0ddc, 0x0ddd, 0x0dde, 0x0026,
	0x0fcd, 0x0fce, 0x0fcf, 0x0fdd, 0x0fde, 0x0fdf, 0x019a, 0x019b,
	0x01ae, 0x0902, 0x090c, 0x0907, 0x0a15, 0x0a2e, 0x0a3d, 0x0224,
	0x0abf, 0x0241, 0x0244, 0x0247, 0x0249, 0x026d, 0x0262, 0x0270,
	0x0271, 0x0274, 0x0275, 0x0278, 0x0279, 0x0280, 0x0281, 0x02e0,
	0x02e1, 0x0284, 0x0285, 0x0288, 0x0289, 0x02e2, 0x02e3, 0x02ac,
	0x02ad, 0x02ae, 0x02af, 0x02ea, 0x02eb, 0x02ec, 0x02ed, 0x0094,
	0x004c, 0x004e, 0x0050, 0x0052, 0x0054, 0x0056, 0x0058, 0x005a,
	0x005c, 0x005e, 0x0060, 0x0062, 0x0065, 0x0067, 0x0069, 0x0070,
	0x0071, 0x0073, 0x0074, 0x0076, 0x0077, 0x0079, 0x007a, 0x007c,
	0x007d, 0x009e, 0x06ad, 0x00ac, 0x00ae, 0x00b0, 0x00b2, 0x00b4,
	0x00b6, 0x00b8, 0x00ba, 0x00bc, 0x00be, 0x0541, 0x054f, 0x0564,
	0x0572, 0x0580, 0x00d0, 0x05b8, 0x05c6, 0x05cd, 0x05db, 0x00d7,
	0x05f0, 0x05f7, 0x0605, 0x060c, 0x00f7, 0x00f8, 0x06d0, 0x06d7,
	0x00fe
	};

// Table containing all the decomposition and folding strings longer
// than 2 UTF16 characters
const unsigned short KLongDecompositions[] =
	{
	0x0397, 0x0313, 0x0300, 0x0345, 0x03B1, 0x0313, 0x0300, 0x0345,
	0x0397, 0x0314, 0x0300, 0x0345, 0x03C9, 0x0313, 0x0300, 0x0345,
	0x0391, 0x0314, 0x0342, 0x0345, 0x03B7, 0x0313, 0x0342, 0x0345,
	0x0397, 0x0314, 0x0301, 0x0345, 0x03B7, 0x0314, 0x0342, 0x0345,
	0x03A9, 0x0313, 0x0342, 0x0345, 0x03B1, 0x0313, 0x0301, 0x0345,
	0x03B1, 0x0314, 0x0300, 0x0345, 0x03B1, 0x0314, 0x0301, 0x0345,
	0x0391, 0x0313, 0x0342, 0x0345, 0x03A9, 0x0314, 0x0342, 0x0345,
	0x0397, 0x0313, 0x0301, 0x0345, 0x03C9, 0x0314, 0x0342, 0x0345,
	0x03C9, 0x0313, 0x0342, 0x0345, 0x0397, 0x0314, 0x0342, 0x0345,
	0x0397, 0x0313, 0x0342, 0x0345, 0x03B7, 0x0314, 0x0301, 0x0345,
	0x0391, 0x0314, 0x0301, 0x0345, 0x03A9, 0x0314, 0x0301, 0x0345,
	0x03B7, 0x0313, 0x0301, 0x0345, 0x03B7, 0x0314, 0x0300, 0x0345,
	0x0391, 0x0313, 0x0301, 0x0345, 0x0391, 0x0314, 0x0300, 0x0345,
	0x03B1, 0x0314, 0x0342, 0x0345, 0x03A9, 0x0313, 0x0301, 0x0345,
	0x03A9, 0x0314, 0x0300, 0x0345, 0x03B7, 0x0313, 0x0300, 0x0345,
	0x03C9, 0x0314, 0x0301, 0x0345, 0x0391, 0x0313, 0x0300, 0x0345,
	0x03B1, 0x0313, 0x0342, 0x0345, 0x03A9, 0x0313, 0x0300, 0x0345,
	0x03C9, 0x0313, 0x0301, 0x0345, 0x03C9, 0x0314, 0x0300, 0x0345,
	0x03C5, 0x0313, 0x0342, 0x039F, 0x0314, 0x0301, 0x0075, 0x031B,
	0x0309, 0x0041, 0x0306, 0x0309, 0x0061, 0x0302, 0x0309, 0x0043,
	0x0327, 0x0301, 0x03B1, 0x0313, 0x0345, 0x0045, 0x0302, 0x0300,
	0x006F, 0x0304, 0x0300, 0x0045, 0x0302, 0x0301, 0x006F, 0x0304,
	0x0301, 0x0399, 0x0314, 0x0300, 0x03B5, 0x0314, 0x0300, 0x0045,
	0x0302, 0x0303, 0x0399, 0x0314, 0x0301, 0x03B5, 0x0314, 0x0301,
	0x004F, 0x0308, 0x0304, 0x0DD9, 0x0DCF, 0x0DCA, 0x0045, 0x0302,
	0x0309, 0x03A9, 0x0313, 0x0345, 0x039F, 0x0313, 0x0300, 0x03B7,
	0x0301, 0x0345, 0x03B1, 0x0342, 0x0345, 0x039F, 0x0313, 0x0301,
	0x0049, 0x0308, 0x0301, 0x004C, 0x0323, 0x0304, 0x006F, 0x0303,
	0x0301, 0x0399, 0x0313, 0x0300, 0x05E9, 0x05BC, 0x05C1, 0x03B5,
	0x0313, 0x0300, 0x05E9, 0x05BC, 0x05C2, 0x0399, 0x0313, 0x0301,
	0x03B5, 0x0313, 0x0301, 0x006F, 0x0303, 0x0304, 0x004F, 0x0307,
	0x0304, 0x0055, 0x0304, 0x0308, 0x0061, 0x0323, 0x0302, 0x006F,
	0x0303, 0x0308, 0x0061, 0x0323, 0x0306, 0x03B7, 0x0300, 0x0345,
	0x03B9, 0x0308, 0x0342, 0x03C9, 0x0301, 0x0345, 0x0073, 0x0301,
	0x0307, 0x0075, 0x031B, 0x0323, 0x0055, 0x0303, 0x0301, 0x006F,
	0x0302, 0x0300, 0x006F, 0x0302, 0x0301, 0x0045, 0x0323, 0x0302,
	0x006F, 0x0302, 0x0303, 0x0391, 0x0314, 0x0345, 0x03B9, 0x0314,
	0x0342, 0x006F, 0x031B, 0x0300, 0x006F, 0x031B, 0x0301, 0x006F,
	0x0302, 0x0309, 0x006F, 0x031B, 0x0303, 0x03C5, 0x0308, 0x0300,
	0x03A5, 0x0314, 0x0342, 0x03C5, 0x0308, 0x0301, 0x006F, 0x031B,
	0x0309, 0x0075, 0x0308, 0x0300, 0x03C9, 0x0300, 0x0345, 0x0075,
	0x0308, 0x0301, 0x0073, 0x0323, 0x0307, 0x0075, 0x0308, 0x0304,
	0x03C5, 0x0314, 0x0300, 0x03C5, 0x0314, 0x0301, 0x0391, 0x0313,
	0x0345, 0x004F, 0x0328, 0x0304, 0x03B9, 0x0313, 0x0342, 0x0055,
	0x031B, 0x0300, 0x0061, 0x0308, 0x0304, 0x0041, 0x0302, 0x0300,
	0x0055, 0x031B, 0x0301, 0x0041, 0x0302, 0x0301, 0x0395, 0x0314,
	0x0300, 0x0395, 0x0314, 0x0301, 0x0055, 0x031B, 0x0303, 0x0041,
	0x0302, 0x0303, 0x0072, 0x0323, 0x0304, 0x0075, 0x0308, 0x030C,
	0x0CC6, 0x0CC2, 0x0CD5, 0x0073, 0x030C, 0x0307, 0x0041, 0x0302,
	0x0309, 0x0055, 0x031B, 0x0309, 0x0065, 0x0304, 0x0300, 0x0065,
	0x0304, 0x0301, 0x03B7, 0x0314, 0x0345, 0x0061, 0x030A, 0x0301,
	0x03C5, 0x0314, 0x0342, 0x004F, 0x0304, 0x0300, 0x03C5, 0x0313,
	0x0300, 0x004F, 0x0304, 0x0301, 0x03C5, 0x0313, 0x0301, 0x006F,
	0x0323, 0x0302, 0x0065, 0x0327, 0x0306, 0x0061, 0x0307, 0x0304,
	0x0395, 0x0313, 0x0300, 0x0395, 0x0313, 0x0301, 0x03B7, 0x0313,
	0x0345, 0x006F, 0x031B, 0x0323, 0x004F, 0x0303, 0x0301, 0x0061,
	0x0306, 0x0300, 0x0061, 0x0306, 0x0301, 0x004F, 0x0303, 0x0304,
	0x0061, 0x0306, 0x0303, 0x03C9, 0x0314, 0x0345, 0x004F, 0x0303,
	0x0308, 0x0041, 0x0323, 0x0302, 0x03B1, 0x0301, 0x0345, 0x0399,
	0x0314, 0x0342, 0x0061, 0x0306, 0x0309, 0x03B1, 0x0314, 0x0345,
	0x0041, 0x0323, 0x0306, 0x03B7, 0x0342, 0x0345, 0x0063, 0x0327,
	0x0301, 0x004F, 0x031B, 0x0323, 0x0053, 0x0301, 0x0307, 0x0065,
	0x0302, 0x0300, 0x006F, 0x0328, 0x0304, 0x0065, 0x0302, 0x0301,
	0x0075, 0x031B, 0x0300, 0x0065, 0x0302, 0x0303, 0x0055, 0x031B,
	0x0323, 0x006F, 0x0308, 0x0304, 0x004F, 0x0302, 0x0300, 0x004F,
	0x0302, 0x0301, 0x03BF, 0x0314, 0x0300, 0x03BF, 0x0314, 0x0301,
	0x004F, 0x0302, 0x0303, 0x03B9, 0x0308, 0x0300, 0x0041, 0x0306,
	0x0300, 0x0061, 0x0302, 0x0300, 0x03B9, 0x0308, 0x0301, 0x0065,
	0x0302, 0x0309, 0x03C9, 0x0313, 0x0345, 0x004F, 0x031B, 0x0300,
	0x004F, 0x031B, 0x0301, 0x03B1, 0x0300, 0x0345, 0x004F, 0x0302,
	0x0309, 0x004F, 0x031B, 0x0303, 0x0399, 0x0313, 0x0342, 0x0075,
	0x031B, 0x0301, 0x0069, 0x0308, 0x0301, 0x006C, 0x0323, 0x0304,
	0x004F, 0x031B, 0x0309, 0x0041, 0x0306, 0x0301, 0x03B9, 0x0314,
	0x0300, 0x0061, 0x0302, 0x0301, 0x03B9, 0x0314, 0x0301, 0x0055,
	0x0308, 0x0300, 0x03C9, 0x0342, 0x0345, 0x0053, 0x0323, 0x0307,
	0x0055, 0x0308, 0x0301, 0x0055, 0x0308, 0x0304, 0x0075, 0x031B,
	0x0303, 0x0041, 0x0306, 0x0303, 0x006F, 0x0307, 0x0304, 0x03A5,
	0x0314, 0x0300, 0x03A5, 0x0314, 0x0301, 0x03BF, 0x0313, 0x0300,
	0x0075, 0x0304, 0x0308, 0x03BF, 0x0313, 0x0301, 0x0397, 0x0314,
	0x0345, 0x0041, 0x0308, 0x0304, 0x0061, 0x0302, 0x0303, 0x0052,
	0x0323, 0x0304, 0x0053, 0x030C, 0x0307, 0x0055, 0x0308, 0x030C,
	0x03A9, 0x0314, 0x0345, 0x03B9, 0x0313, 0x0300, 0x03C5, 0x0308,
	0x0342, 0x039F, 0x0314, 0x0300, 0x03B9, 0x0313, 0x0301, 0x0075,
	0x0303, 0x0301, 0x0045, 0x0304, 0x0300, 0x0045, 0x0304, 0x0301,
	0x0065, 0x0323, 0x0302, 0x0041, 0x030A, 0x0301, 0x0045, 0x0327,
	0x0306, 0x004F, 0x0323, 0x0302, 0x0397, 0x0313, 0x0345, 0x0041,
	0x0307, 0x0304
	};

// Table containing decompositions longer than one UTF16 character.
// The top of the table contains all compositions, sorted lexicographically.
// Any decompositions of length 2 are in the table as a pair of values,
// decompositions longer than that are represented by a KLongD followed by
// a value whose top four bits indicate the length of the decomposition minus
// three and whose bottom 12 bits indicate an index into the KLongDecompositions
// array where the decomposition starts.
const long KLongD = 0;
const unsigned short KNonSingletonDecompositions[] =
	{
	0x003C, 0x0338, 0x003D, 0x0338, 0x003E, 0x0338, 0x0041, 0x0300,
	0x0041, 0x0301, 0x0041, 0x0302, KLongD, 0x0165, KLongD, 0x016B,
	KLongD, 0x0177, KLongD, 0x0186, 0x0041, 0x0303, 0x0041, 0x0304,
	0x0041, 0x0306, KLongD, 0x0216, KLongD, 0x0243, KLongD, 0x0261,
	KLongD, 0x0099, 0x0041, 0x0307, KLongD, 0x02AF, 0x0041, 0x0308,
	KLongD, 0x0279, 0x0041, 0x0309, 0x0041, 0x030A, 0x0041, 0x030A,
	KLongD, 0x02A3, 0x0041, 0x030C, 0x0041, 0x030F, 0x0041, 0x0311,
	0x0041, 0x0323, KLongD, 0x01D1, KLongD, 0x01E0, 0x0041, 0x0325,
	0x0041, 0x0328, 0x0042, 0x0307, 0x0042, 0x0323, 0x0042, 0x0331,
	0x0043, 0x0301, 0x0043, 0x0302, 0x0043, 0x0307, 0x0043, 0x030C,
	0x0043, 0x0327, KLongD, 0x009F, 0x0044, 0x0307, 0x0044, 0x030C,
	0x0044, 0x0323, 0x0044, 0x0327, 0x0044, 0x032D, 0x0044, 0x0331,
	0x0045, 0x0300, 0x0045, 0x0301, 0x0045, 0x0302, KLongD, 0x00A5,
	KLongD, 0x00AB, KLongD, 0x00B7, KLongD, 0x00C6, 0x0045, 0x0303,
	0x0045, 0x0304, KLongD, 0x029A, KLongD, 0x029D, 0x0045, 0x0306,
	0x0045, 0x0307, 0x0045, 0x0308, 0x0045, 0x0309, 0x0045, 0x030C,
	0x0045, 0x030F, 0x0045, 0x0311, 0x0045, 0x0323, KLongD, 0x011D,
	0x0045, 0x0327, KLongD, 0x02A6, 0x0045, 0x0328, 0x0045, 0x032D,
	0x0045, 0x0330, 0x0046, 0x0307, 0x0047, 0x0301, 0x0047, 0x0302,
	0x0047, 0x0304, 0x0047, 0x0306, 0x0047, 0x0307, 0x0047, 0x030C,
	0x0047, 0x0327, 0x0048, 0x0302, 0x0048, 0x0307, 0x0048, 0x0308,
	0x0048, 0x030C, 0x0048, 0x0323, 0x0048, 0x0327, 0x0048, 0x032E,
	0x0049, 0x0300, 0x0049, 0x0301, 0x0049, 0x0302, 0x0049, 0x0303,
	0x0049, 0x0304, 0x0049, 0x0306, 0x0049, 0x0307, 0x0049, 0x0308,
	KLongD, 0x00D8, 0x0049, 0x0309, 0x0049, 0x030C, 0x0049, 0x030F,
	0x0049, 0x0311, 0x0049, 0x0323, 0x0049, 0x0328, 0x0049, 0x0330,
	0x004A, 0x0302, 0x004B, 0x0301, 0x004B, 0x030C, 0x004B, 0x0323,
	0x004B, 0x0327, 0x004B, 0x0331, 0x004C, 0x0301, 0x004C, 0x030C,
	0x004C, 0x0323, KLongD, 0x00DB, 0x004C, 0x0327, 0x004C, 0x032D,
	0x004C, 0x0331, 0x004D, 0x0301, 0x004D, 0x0307, 0x004D, 0x0323,
	0x004E, 0x0300, 0x004E, 0x0301, 0x004E, 0x0303, 0x004E, 0x0307,
	0x004E, 0x030C, 0x004E, 0x0323, 0x004E, 0x0327, 0x004E, 0x032D,
	0x004E, 0x0331, 0x004F, 0x0300, 0x004F, 0x0301, 0x004F, 0x0302,
	KLongD, 0x0204, KLongD, 0x0207, KLongD, 0x0210, KLongD, 0x022E,
	0x004F, 0x0303, KLongD, 0x01BC, KLongD, 0x01C5, KLongD, 0x01CE,
	0x004F, 0x0304, KLongD, 0x019B, KLongD, 0x01A1, 0x004F, 0x0306,
	0x004F, 0x0307, KLongD, 0x00F6, 0x004F, 0x0308, KLongD, 0x00C0,
	0x004F, 0x0309, 0x004F, 0x030B, 0x004F, 0x030C, 0x004F, 0x030F,
	0x004F, 0x0311, 0x004F, 0x031B, KLongD, 0x0225, KLongD, 0x0228,
	KLongD, 0x0231, KLongD, 0x0240, KLongD, 0x01E9, 0x004F, 0x0323,
	KLongD, 0x02A9, 0x004F, 0x0328, KLongD, 0x0159, 0x0050, 0x0301,
	0x0050, 0x0307, 0x0052, 0x0301, 0x0052, 0x0307, 0x0052, 0x030C,
	0x0052, 0x030F, 0x0052, 0x0311, 0x0052, 0x0323, KLongD, 0x027F,
	0x0052, 0x0327, 0x0052, 0x0331, 0x0053, 0x0301, KLongD, 0x01EC,
	0x0053, 0x0302, 0x0053, 0x0307, 0x0053, 0x030C, KLongD, 0x0282,
	0x0053, 0x0323, KLongD, 0x0255, 0x0053, 0x0326, 0x0053, 0x0327,
	0x0054, 0x0307, 0x0054, 0x030C, 0x0054, 0x0323, 0x0054, 0x0326,
	0x0054, 0x0327, 0x0054, 0x032D, 0x0054, 0x0331, 0x0055, 0x0300,
	0x0055, 0x0301, 0x0055, 0x0302, 0x0055, 0x0303, KLongD, 0x0114,
	0x0055, 0x0304, KLongD, 0x00F9, 0x0055, 0x0306, 0x0055, 0x0308,
	KLongD, 0x024F, KLongD, 0x0258, KLongD, 0x025B, KLongD, 0x0285,
	0x0055, 0x0309, 0x0055, 0x030A, 0x0055, 0x030B, 0x0055, 0x030C,
	0x0055, 0x030F, 0x0055, 0x0311, 0x0055, 0x031B, KLongD, 0x015F,
	KLongD, 0x0168, KLongD, 0x0174, KLongD, 0x0189, KLongD, 0x01FE,
	0x0055, 0x0323, 0x0055, 0x0324, 0x0055, 0x0328, 0x0055, 0x032D,
	0x0055, 0x0330, 0x0056, 0x0303, 0x0056, 0x0323, 0x0057, 0x0300,
	0x0057, 0x0301, 0x0057, 0x0302, 0x0057, 0x0307, 0x0057, 0x0308,
	0x0057, 0x0323, 0x0058, 0x0307, 0x0058, 0x0308, 0x0059, 0x0300,
	0x0059, 0x0301, 0x0059, 0x0302, 0x0059, 0x0303, 0x0059, 0x0304,
	0x0059, 0x0307, 0x0059, 0x0308, 0x0059, 0x0309, 0x0059, 0x0323,
	0x005A, 0x0301, 0x005A, 0x0302, 0x005A, 0x0307, 0x005A, 0x030C,
	0x005A, 0x0323, 0x005A, 0x0331, 0x0061, 0x0300, 0x0061, 0x0301,
	0x0061, 0x0302, KLongD, 0x0219, KLongD, 0x0249, KLongD, 0x027C,
	KLongD, 0x009C, 0x0061, 0x0303, 0x0061, 0x0304, 0x0061, 0x0306,
	KLongD, 0x01BF, KLongD, 0x01C2, KLongD, 0x01C8, KLongD, 0x01DA,
	0x0061, 0x0307, KLongD, 0x01AD, 0x0061, 0x0308, KLongD, 0x0162,
	0x0061, 0x0309, 0x0061, 0x030A, KLongD, 0x0195, 0x0061, 0x030C,
	0x0061, 0x030F, 0x0061, 0x0311, 0x0061, 0x0323, KLongD, 0x00FC,
	KLongD, 0x0102, 0x0061, 0x0325, 0x0061, 0x0328, 0x0062, 0x0307,
	0x0062, 0x0323, 0x0062, 0x0331, 0x0063, 0x0301, 0x0063, 0x0302,
	0x0063, 0x0307, 0x0063, 0x030C, 0x0063, 0x0327, KLongD, 0x01E6,
	0x0064, 0x0307, 0x0064, 0x030C, 0x0064, 0x0323, 0x0064, 0x0327,
	0x0064, 0x032D, 0x0064, 0x0331, 0x0065, 0x0300, 0x0065, 0x0301,
	0x0065, 0x0302, KLongD, 0x01EF, KLongD, 0x01F5, KLongD, 0x01FB,
	KLongD, 0x021F, 0x0065, 0x0303, 0x0065, 0x0304, KLongD, 0x018C,
	KLongD, 0x018F, 0x0065, 0x0306, 0x0065, 0x0307, 0x0065, 0x0308,
	0x0065, 0x0309, 0x0065, 0x030C, 0x0065, 0x030F, 0x0065, 0x0311,
	0x0065, 0x0323, KLongD, 0x02A0, 0x0065, 0x0327, KLongD, 0x01AA,
	0x0065, 0x0328, 0x0065, 0x032D, 0x0065, 0x0330, 0x0066, 0x0307,
	0x0067, 0x0301, 0x0067, 0x0302, 0x0067, 0x0304, 0x0067, 0x0306,
	0x0067, 0x0307, 0x0067, 0x030C, 0x0067, 0x0327, 0x0068, 0x0302,
	0x0068, 0x0307, 0x0068, 0x0308, 0x0068, 0x030C, 0x0068, 0x0323,
	0x0068, 0x0327, 0x0068, 0x032E, 0x0068, 0x0331, 0x0069, 0x0300,
	0x0069, 0x0301, 0x0069, 0x0302, 0x0069, 0x0303, 0x0069, 0x0304,
	0x0069, 0x0306, 0x0069, 0x0308, KLongD, 0x023A, 0x0069, 0x0309,
	0x0069, 0x030C, 0x0069, 0x030F, 0x0069, 0x0311, 0x0069, 0x0323,
	0x0069, 0x0328, 0x0069, 0x0330, 0x006A, 0x0302, 0x006A, 0x030C,
	0x006B, 0x0301, 0x006B, 0x030C, 0x006B, 0x0323, 0x006B, 0x0327,
	0x006B, 0x0331, 0x006C, 0x0301, 0x006C, 0x030C, 0x006C, 0x0323,
	KLongD, 0x023D, 0x006C, 0x0327, 0x006C, 0x032D, 0x006C, 0x0331,
	0x006D, 0x0301, 0x006D, 0x0307, 0x006D, 0x0323, 0x006E, 0x0300,
	0x006E, 0x0301, 0x006E, 0x0303, 0x006E, 0x0307, 0x006E, 0x030C,
	0x006E, 0x0323, 0x006E, 0x0327, 0x006E, 0x032D, 0x006E, 0x0331,
	0x006F, 0x0300, 0x006F, 0x0301, 0x006F, 0x0302, KLongD, 0x0117,
	KLongD, 0x011A, KLongD, 0x0120, KLongD, 0x012F, 0x006F, 0x0303,
	KLongD, 0x00DE, KLongD, 0x00F3, KLongD, 0x00FF, 0x006F, 0x0304,
	KLongD, 0x00A8, KLongD, 0x00AE, 0x006F, 0x0306, 0x006F, 0x0307,
	KLongD, 0x0264, 0x006F, 0x0308, KLongD, 0x0201, 0x006F, 0x0309,
	0x006F, 0x030B, 0x006F, 0x030C, 0x006F, 0x030F, 0x006F, 0x0311,
	0x006F, 0x031B, KLongD, 0x0129, KLongD, 0x012C, KLongD, 0x0132,
	KLongD, 0x013E, KLongD, 0x01B9, 0x006F, 0x0323, KLongD, 0x01A7,
	0x006F, 0x0328, KLongD, 0x01F2, 0x0070, 0x0301, 0x0070, 0x0307,
	0x0072, 0x0301, 0x0072, 0x0307, 0x0072, 0x030C, 0x0072, 0x030F,
	0x0072, 0x0311, 0x0072, 0x0323, KLongD, 0x017A, 0x0072, 0x0327,
	0x0072, 0x0331, 0x0073, 0x0301, KLongD, 0x010E, 0x0073, 0x0302,
	0x0073, 0x0307, 0x0073, 0x030C, KLongD, 0x0183, 0x0073, 0x0323,
	KLongD, 0x014A, 0x0073, 0x0326, 0x0073, 0x0327, 0x0074, 0x0307,
	0x0074, 0x0308, 0x0074, 0x030C, 0x0074, 0x0323, 0x0074, 0x0326,
	0x0074, 0x0327, 0x0074, 0x032D, 0x0074, 0x0331, 0x0075, 0x0300,
	0x0075, 0x0301, 0x0075, 0x0302, 0x0075, 0x0303, KLongD, 0x0297,
	0x0075, 0x0304, KLongD, 0x0270, 0x0075, 0x0306, 0x0075, 0x0308,
	KLongD, 0x0141, KLongD, 0x0147, KLongD, 0x014D, KLongD, 0x017D,
	0x0075, 0x0309, 0x0075, 0x030A, 0x0075, 0x030B, 0x0075, 0x030C,
	0x0075, 0x030F, 0x0075, 0x0311, 0x0075, 0x031B, KLongD, 0x01F8,
	KLongD, 0x0237, KLongD, 0x025E, KLongD, 0x0096, KLongD, 0x0111,
	0x0075, 0x0323, 0x0075, 0x0324, 0x0075, 0x0328, 0x0075, 0x032D,
	0x0075, 0x0330, 0x0076, 0x0303, 0x0076, 0x0323, 0x0077, 0x0300,
	0x0077, 0x0301, 0x0077, 0x0302, 0x0077, 0x0307, 0x0077, 0x0308,
	0x0077, 0x030A, 0x0077, 0x0323, 0x0078, 0x0307, 0x0078, 0x0308,
	0x0079, 0x0300, 0x0079, 0x0301, 0x0079, 0x0302, 0x0079, 0x0303,
	0x0079, 0x0304, 0x0079, 0x0307, 0x0079, 0x0308, 0x0079, 0x0309,
	0x0079, 0x030A, 0x0079, 0x0323, 0x007A, 0x0301, 0x007A, 0x0302,
	0x007A, 0x0307, 0x007A, 0x030C, 0x007A, 0x0323, 0x007A, 0x0331,
	0x00A8, 0x0300, 0x00A8, 0x0301, 0x00A8, 0x0301, 0x00A8, 0x0342,
	0x00B4, 0xFFFF, 0x00C6, 0x0301, 0x00C6, 0x0304, 0x00D8, 0x0301,
	0x00E6, 0x0301, 0x00E6, 0x0304, 0x00F8, 0x0301, 0x017F, 0x0307,
	0x01B7, 0x030C, 0x0292, 0x030C, 0x0391, 0x0300, 0x0391, 0x0301,
	0x0391, 0x0301, 0x0391, 0x0304, 0x0391, 0x0306, 0x0391, 0x0313,
	KLongD, 0x007C, KLongD, 0x107C, KLongD, 0x0060, KLongD, 0x1060,
	KLongD, 0x0030, KLongD, 0x1030, KLongD, 0x0156, 0x0391, 0x0314,
	KLongD, 0x0064, KLongD, 0x1064, KLongD, 0x0050, KLongD, 0x1050,
	KLongD, 0x0010, KLongD, 0x1010, KLongD, 0x0123, 0x0391, 0x0345,
	0x0395, 0x0300, 0x0395, 0x0301, 0x0395, 0x0301, 0x0395, 0x0313,
	KLongD, 0x01B0, KLongD, 0x01B3, 0x0395, 0x0314, KLongD, 0x016E,
	KLongD, 0x0171, 0x0397, 0x0300, 0x0397, 0x0301, 0x0397, 0x0301,
	0x0397, 0x0313, KLongD, 0x0000, KLongD, 0x1000, KLongD, 0x0038,
	KLongD, 0x1038, KLongD, 0x0048, KLongD, 0x1048, KLongD, 0x02AC,
	0x0397, 0x0314, KLongD, 0x0008, KLongD, 0x1008, KLongD, 0x0018,
	KLongD, 0x1018, KLongD, 0x0044, KLongD, 0x1044, KLongD, 0x0276,
	0x0397, 0x0345, 0x0399, 0x0300, 0x0399, 0x0301, 0x0399, 0x0301,
	0x0399, 0x0304, 0x0399, 0x0306, 0x0399, 0x0308, 0x0399, 0x0313,
	KLongD, 0x00E1, KLongD, 0x00ED, KLongD, 0x0234, 0x0399, 0x0314,
	KLongD, 0x00B1, KLongD, 0x00BA, KLongD, 0x01D7, 0x039F, 0x0300,
	0x039F, 0x0301, 0x039F, 0x0301, 0x039F, 0x0313, KLongD, 0x00CC,
	KLongD, 0x00D5, 0x039F, 0x0314, KLongD, 0x0291, KLongD, 0x0093,
	0x03A1, 0x0314, 0x03A5, 0x0300, 0x03A5, 0x0301, 0x03A5, 0x0301,
	0x03A5, 0x0304, 0x03A5, 0x0306, 0x03A5, 0x0308, 0x03A5, 0x0314,
	KLongD, 0x0267, KLongD, 0x026A, KLongD, 0x0138, 0x03A9, 0x0300,
	0x03A9, 0x0301, 0x03A9, 0x0301, 0x03A9, 0x0313, KLongD, 0x0084,
	KLongD, 0x1084, KLongD, 0x006C, KLongD, 0x106C, KLongD, 0x0020,
	KLongD, 0x1020, KLongD, 0x00C9, 0x03A9, 0x0314, KLongD, 0x0070,
	KLongD, 0x1070, KLongD, 0x0054, KLongD, 0x1054, KLongD, 0x0034,
	KLongD, 0x1034, KLongD, 0x0288, 0x03A9, 0x0345, 0x03B1, 0x0300,
	KLongD, 0x022B, 0x03B1, 0x0301, 0x03B1, 0x0301, KLongD, 0x01D4,
	0x03B1, 0x0304, 0x03B1, 0x0306, 0x03B1, 0x0313, KLongD, 0x0004,
	KLongD, 0x1004, KLongD, 0x0024, KLongD, 0x1024, KLongD, 0x0080,
	KLongD, 0x1080, KLongD, 0x00A2, 0x03B1, 0x0314, KLongD, 0x0028,
	KLongD, 0x1028, KLongD, 0x002C, KLongD, 0x102C, KLongD, 0x0068,
	KLongD, 0x1068, KLongD, 0x01DD, 0x03B1, 0x0342, KLongD, 0x00D2,
	0x03B1, 0x0345, 0x03B5, 0x0300, 0x03B5, 0x0301, 0x03B5, 0x0301,
	0x03B5, 0x0313, KLongD, 0x00E7, KLongD, 0x00F0, 0x03B5, 0x0314,
	KLongD, 0x00B4, KLongD, 0x00BD, 0x03B7, 0x0300, KLongD, 0x0105,
	0x03B7, 0x0301, 0x03B7, 0x0301, KLongD, 0x00CF, 0x03B7, 0x0313,
	KLongD, 0x0074, KLongD, 0x1074, KLongD, 0x0058, KLongD, 0x1058,
	KLongD, 0x0014, KLongD, 0x1014, KLongD, 0x01B6, 0x03B7, 0x0314,
	KLongD, 0x005C, KLongD, 0x105C, KLongD, 0x004C, KLongD, 0x104C,
	KLongD, 0x001C, KLongD, 0x101C, KLongD, 0x0192, 0x03B7, 0x0342,
	KLongD, 0x01E3, 0x03B7, 0x0345, 0x03B9, 0x0300, 0x03B9, 0x0301,
	0x03B9, 0x0301, 0x03B9, 0x0304, 0x03B9, 0x0306, 0x03B9, 0x0308,
	KLongD, 0x0213, KLongD, 0x021C, KLongD, 0x021C, KLongD, 0x0108,
	0x03B9, 0x0313, KLongD, 0x028B, KLongD, 0x0294, KLongD, 0x015C,
	0x03B9, 0x0314, KLongD, 0x0246, KLongD, 0x024C, KLongD, 0x0126,
	0x03B9, 0x0342, 0x03BF, 0x0300, 0x03BF, 0x0301, 0x03BF, 0x0301,
	0x03BF, 0x0313, KLongD, 0x026D, KLongD, 0x0273, 0x03BF, 0x0314,
	KLongD, 0x020A, KLongD, 0x020D, 0x03C1, 0x0313, 0x03C1, 0x0314,
	0x03C5, 0x0300, 0x03C5, 0x0301, 0x03C5, 0x0301, 0x03C5, 0x0304,
	0x03C5, 0x0306, 0x03C5, 0x0308, KLongD, 0x0135, KLongD, 0x013B,
	KLongD, 0x013B, KLongD, 0x028E, 0x03C5, 0x0313, KLongD, 0x019E,
	KLongD, 0x01A4, KLongD, 0x0090, 0x03C5, 0x0314, KLongD, 0x0150,
	KLongD, 0x0153, KLongD, 0x0198, 0x03C5, 0x0342, 0x03C9, 0x0300,
	KLongD, 0x0144, 0x03C9, 0x0301, 0x03C9, 0x0301, KLongD, 0x010B,
	0x03C9, 0x0313, KLongD, 0x000C, KLongD, 0x100C, KLongD, 0x0088,
	KLongD, 0x1088, KLongD, 0x0040, KLongD, 0x1040, KLongD, 0x0222,
	0x03C9, 0x0314, KLongD, 0x008C, KLongD, 0x108C, KLongD, 0x0078,
	KLongD, 0x1078, KLongD, 0x003C, KLongD, 0x103C, KLongD, 0x01CB,
	0x03C9, 0x0342, KLongD, 0x0252, 0x03C9, 0x0345, 0x03D2, 0x0301,
	0x03D2, 0x0308, 0x0406, 0x0308, 0x0410, 0x0306, 0x0410, 0x0308,
	0x0413, 0x0301, 0x0415, 0x0300, 0x0415, 0x0306, 0x0415, 0x0308,
	0x0416, 0x0306, 0x0416, 0x0308, 0x0417, 0x0308, 0x0418, 0x0300,
	0x0418, 0x0304, 0x0418, 0x0306, 0x0418, 0x0308, 0x041A, 0x0301,
	0x041E, 0x0308, 0x0423, 0x0304, 0x0423, 0x0306, 0x0423, 0x0308,
	0x0423, 0x030B, 0x0427, 0x0308, 0x042B, 0x0308, 0x042D, 0x0308,
	0x0430, 0x0306, 0x0430, 0x0308, 0x0433, 0x0301, 0x0435, 0x0300,
	0x0435, 0x0306, 0x0435, 0x0308, 0x0436, 0x0306, 0x0436, 0x0308,
	0x0437, 0x0308, 0x0438, 0x0300, 0x0438, 0x0304, 0x0438, 0x0306,
	0x0438, 0x0308, 0x043A, 0x0301, 0x043E, 0x0308, 0x0443, 0x0304,
	0x0443, 0x0306, 0x0443, 0x0308, 0x0443, 0x030B, 0x0447, 0x0308,
	0x044B, 0x0308, 0x044D, 0x0308, 0x0456, 0x0308, 0x0474, 0x030F,
	0x0475, 0x030F, 0x04D8, 0x0308, 0x04D9, 0x0308, 0x04E8, 0x0308,
	0x04E9, 0x0308, 0x05D9, 0x05B4, 0x0627, 0x0653, 0x0627, 0x0654,
	0x0627, 0x0655, 0x0648, 0x0654, 0x064A, 0x0654, 0x06C1, 0x0654,
	0x06D2, 0x0654, 0x06D5, 0x0654, 0x0928, 0x093C, 0x0930, 0x093C,
	0x0933, 0x093C, 0x09C7, 0x09BE, 0x09C7, 0x09D7, 0x0B47, 0x0B3E,
	0x0B47, 0x0B56, 0x0B47, 0x0B57, 0x0B92, 0x0BD7, 0x0BC6, 0x0BBE,
	0x0BC6, 0x0BD7, 0x0BC7, 0x0BBE, 0x0C46, 0x0C56, 0x0CBF, 0x0CD5,
	0x0CC6, 0x0CC2, KLongD, 0x0180, 0x0CC6, 0x0CD5, 0x0CC6, 0x0CD6,
	0x0D46, 0x0D3E, 0x0D46, 0x0D57, 0x0D47, 0x0D3E, 0x0DD9, 0x0DCA,
	0x0DD9, 0x0DCF, KLongD, 0x00C3, 0x0DD9, 0x0DDF, 0x1025, 0x102E,
	0x1FBF, 0x0300, 0x1FBF, 0x0301, 0x1FBF, 0x0342, 0x1FFE, 0x0300,
	0x1FFE, 0x0301, 0x1FFE, 0x0342, 0x2190, 0x0338, 0x2192, 0x0338,
	0x2194, 0x0338, 0x21D0, 0x0338, 0x21D2, 0x0338, 0x21D4, 0x0338,
	0x2203, 0x0338, 0x2208, 0x0338, 0x220B, 0x0338, 0x2223, 0x0338,
	0x2225, 0x0338, 0x223C, 0x0338, 0x2243, 0x0338, 0x2245, 0x0338,
	0x2248, 0x0338, 0x224D, 0x0338, 0x2261, 0x0338, 0x2264, 0x0338,
	0x2265, 0x0338, 0x2272, 0x0338, 0x2273, 0x0338, 0x2276, 0x0338,
	0x2277, 0x0338, 0x227A, 0x0338, 0x227B, 0x0338, 0x227C, 0x0338,
	0x227D, 0x0338, 0x2282, 0x0338, 0x2283, 0x0338, 0x2286, 0x0338,
	0x2287, 0x0338, 0x2291, 0x0338, 0x2292, 0x0338, 0x22A2, 0x0338,
	0x22A8, 0x0338, 0x22A9, 0x0338, 0x22AB, 0x0338, 0x22B2, 0x0338,
	0x22B3, 0x0338, 0x22B4, 0x0338, 0x22B5, 0x0338, 0x3046, 0x3099,
	0x304B, 0x3099, 0x304D, 0x3099, 0x304F, 0x3099, 0x3051, 0x3099,
	0x3053, 0x3099, 0x3055, 0x3099, 0x3057, 0x3099, 0x3059, 0x3099,
	0x305B, 0x3099, 0x305D, 0x3099, 0x305F, 0x3099, 0x3061, 0x3099,
	0x3064, 0x3099, 0x3066, 0x3099, 0x3068, 0x3099, 0x306F, 0x3099,
	0x306F, 0x309A, 0x3072, 0x3099, 0x3072, 0x309A, 0x3075, 0x3099,
	0x3075, 0x309A, 0x3078, 0x3099, 0x3078, 0x309A, 0x307B, 0x3099,
	0x307B, 0x309A, 0x309D, 0x3099, 0x30A6, 0x3099, 0x30AB, 0x3099,
	0x30AD, 0x3099, 0x30AF, 0x3099, 0x30B1, 0x3099, 0x30B3, 0x3099,
	0x30B5, 0x3099, 0x30B7, 0x3099, 0x30B9, 0x3099, 0x30BB, 0x3099,
	0x30BD, 0x3099, 0x30BF, 0x3099, 0x30C1, 0x3099, 0x30C4, 0x3099,
	0x30C6, 0x3099, 0x30C8, 0x3099, 0x30CF, 0x3099, 0x30CF, 0x309A,
	0x30D2, 0x3099, 0x30D2, 0x309A, 0x30D5, 0x3099, 0x30D5, 0x309A,
	0x30D8, 0x3099, 0x30D8, 0x309A, 0x30DB, 0x3099, 0x30DB, 0x309A,
	0x30EF, 0x3099, 0x30F0, 0x3099, 0x30F1, 0x3099, 0x30F2, 0x3099,
	0x30FD, 0x3099, 0x0308, 0x0301, 0x0915, 0x093C, 0x0916, 0x093C,
	0x0917, 0x093C, 0x091C, 0x093C, 0x0921, 0x093C, 0x0922, 0x093C,
	0x092B, 0x093C, 0x092F, 0x093C, 0x09A1, 0x09BC, 0x09A2, 0x09BC,
	0x09AF, 0x09BC, 0x0A32, 0x0A3C, 0x0A38, 0x0A3C, 0x0A16, 0x0A3C,
	0x0A17, 0x0A3C, 0x0A1C, 0x0A3C, 0x0A2B, 0x0A3C, 0x0B21, 0x0B3C,
	0x0B22, 0x0B3C, 0x0F42, 0x0FB7, 0x0F4C, 0x0FB7, 0x0F51, 0x0FB7,
	0x0F56, 0x0FB7, 0x0F5B, 0x0FB7, 0x0F40, 0x0FB5, 0x0F71, 0x0F72,
	0x0F71, 0x0F74, 0x0FB2, 0x0F80, 0x0FB3, 0x0F80, 0x0F71, 0x0F80,
	0x0F92, 0x0FB7, 0x0F9C, 0x0FB7, 0x0FA1, 0x0FB7, 0x0FA6, 0x0FB7,
	0x0FAB, 0x0FB7, 0x0F90, 0x0FB5, 0x05F2, 0x05B7, 0x05E9, 0x05C1,
	0x05E9, 0x05C2, KLongD, 0x00E4, KLongD, 0x00EA, 0x05D0, 0x05B7,
	0x05D0, 0x05B8, 0x05D0, 0x05BC, 0x05D1, 0x05BC, 0x05D2, 0x05BC,
	0x05D3, 0x05BC, 0x05D4, 0x05BC, 0x05D5, 0x05BC, 0x05D6, 0x05BC,
	0x05D8, 0x05BC, 0x05D9, 0x05BC, 0x05DA, 0x05BC, 0x05DB, 0x05BC,
	0x05DC, 0x05BC, 0x05DE, 0x05BC, 0x05E0, 0x05BC, 0x05E1, 0x05BC,
	0x05E3, 0x05BC, 0x05E4, 0x05BC, 0x05E6, 0x05BC, 0x05E7, 0x05BC,
	0x05E8, 0x05BC, 0x05E9, 0x05BC, 0x05EA, 0x05BC, 0x05D5, 0x05B9,
	0x05D1, 0x05BF, 0x05DB, 0x05BF, 0x05E4, 0x05BF
	};

// Table of folded decompositions which either have more than one UTF16, or
// their normal decompositions have more than one UTF16
const unsigned short KNonSingletonFolds[] =
	{
	0x003C, 0x0338, 0x003D, 0x0338, 0x003E, 0x0338, 0x0061, 0x0300,
	0x0061, 0x0301, 0x0061, 0x0302, KLongD, 0x0219, KLongD, 0x0249,
	KLongD, 0x027C, KLongD, 0x009C, 0x0061, 0x0303, 0x0061, 0x0304,
	0x0061, 0x0306, KLongD, 0x01BF, KLongD, 0x01C2, KLongD, 0x01C8,
	KLongD, 0x01DA, 0x0061, 0x0307, KLongD, 0x01AD, 0x0061, 0x0308,
	KLongD, 0x0162, 0x0061, 0x0309, 0x0061, 0x030A, 0x0061, 0x030A,
	KLongD, 0x0195, 0x0061, 0x030C, 0x0061, 0x030F, 0x0061, 0x0311,
	0x0061, 0x0323, KLongD, 0x00FC, KLongD, 0x0102, 0x0061, 0x0325,
	0x0061, 0x0328, 0x0062, 0x0307, 0x0062, 0x0323, 0x0062, 0x0331,
	0x0063, 0x0301, 0x0063, 0x0302, 0x0063, 0x0307, 0x0063, 0x030C,
	0x0063, 0x0327, KLongD, 0x01E6, 0x0064, 0x0307, 0x0064, 0x030C,
	0x0064, 0x0323, 0x0064, 0x0327, 0x0064, 0x032D, 0x0064, 0x0331,
	0x0065, 0x0300, 0x0065, 0x0301, 0x0065, 0x0302, KLongD, 0x01EF,
	KLongD, 0x01F5, KLongD, 0x01FB, KLongD, 0x021F, 0x0065, 0x0303,
	0x0065, 0x0304, KLongD, 0x018C, KLongD, 0x018F, 0x0065, 0x0306,
	0x0065, 0x0307, 0x0065, 0x0308, 0x0065, 0x0309, 0x0065, 0x030C,
	0x0065, 0x030F, 0x0065, 0x0311, 0x0065, 0x0323, KLongD, 0x02A0,
	0x0065, 0x0327, KLongD, 0x01AA, 0x0065, 0x0328, 0x0065, 0x032D,
	0x0065, 0x0330, 0x0066, 0x0307, 0x0067, 0x0301, 0x0067, 0x0302,
	0x0067, 0x0304, 0x0067, 0x0306, 0x0067, 0x0307, 0x0067, 0x030C,
	0x0067, 0x0327, 0x0068, 0x0302, 0x0068, 0x0307, 0x0068, 0x0308,
	0x0068, 0x030C, 0x0068, 0x0323, 0x0068, 0x0327, 0x0068, 0x032E,
	0x0069, 0x0300, 0x0069, 0x0301, 0x0069, 0x0302, 0x0069, 0x0303,
	0x0069, 0x0304, 0x0069, 0x0306, 0x0069, 0xFFFF, 0x0069, 0x0308,
	KLongD, 0x023A, 0x0069, 0x0309, 0x0069, 0x030C, 0x0069, 0x030F,
	0x0069, 0x0311, 0x0069, 0x0323, 0x0069, 0x0328, 0x0069, 0x0330,
	0x006A, 0x0302, 0x006B, 0x0301, 0x006B, 0x030C, 0x006B, 0x0323,
	0x006B, 0x0327, 0x006B, 0x0331, 0x006C, 0x0301, 0x006C, 0x030C,
	0x006C, 0x0323, KLongD, 0x023D, 0x006C, 0x0327, 0x006C, 0x032D,
	0x006C, 0x0331, 0x006D, 0x0301, 0x006D, 0x0307, 0x006D, 0x0323,
	0x006E, 0x0300, 0x006E, 0x0301, 0x006E, 0x0303, 0x006E, 0x0307,
	0x006E, 0x030C, 0x006E, 0x0323, 0x006E, 0x0327, 0x006E, 0x032D,
	0x006E, 0x0331, 0x006F, 0x0300, 0x006F, 0x0301, 0x006F, 0x0302,
	KLongD, 0x0117, KLongD, 0x011A, KLongD, 0x0120, KLongD, 0x012F,
	0x006F, 0x0303, KLongD, 0x00DE, KLongD, 0x00F3, KLongD, 0x00FF,
	0x006F, 0x0304, KLongD, 0x00A8, KLongD, 0x00AE, 0x006F, 0x0306,
	0x006F, 0x0307, KLongD, 0x0264, 0x006F, 0x0308, KLongD, 0x0201,
	0x006F, 0x0309, 0x006F, 0x030B, 0x006F, 0x030C, 0x006F, 0x030F,
	0x006F, 0x0311, 0x006F, 0x031B, KLongD, 0x0129, KLongD, 0x012C,
	KLongD, 0x0132, KLongD, 0x013E, KLongD, 0x01B9, 0x006F, 0x0323,
	KLongD, 0x01A7, 0x006F, 0x0328, KLongD, 0x01F2, 0x0070, 0x0301,
	0x0070, 0x0307, 0x0072, 0x0301, 0x0072, 0x0307, 0x0072, 0x030C,
	0x0072, 0x030F, 0x0072, 0x0311, 0x0072, 0x0323, KLongD, 0x017A,
	0x0072, 0x0327, 0x0072, 0x0331, 0x0073, 0x0301, KLongD, 0x010E,
	0x0073, 0x0302, 0x0073, 0x0307, 0x0073, 0x030C, KLongD, 0x0183,
	0x0073, 0x0323, KLongD, 0x014A, 0x0073, 0x0326, 0x0073, 0x0327,
	0x0074, 0x0307, 0x0074, 0x030C, 0x0074, 0x0323, 0x0074, 0x0326,
	0x0074, 0x0327, 0x0074, 0x032D, 0x0074, 0x0331, 0x0075, 0x0300,
	0x0075, 0x0301, 0x0075, 0x0302, 0x0075, 0x0303, KLongD, 0x0297,
	0x0075, 0x0304, KLongD, 0x0270, 0x0075, 0x0306, 0x0075, 0x0308,
	KLongD, 0x0141, KLongD, 0x0147, KLongD, 0x014D, KLongD, 0x017D,
	0x0075, 0x0309, 0x0075, 0x030A, 0x0075, 0x030B, 0x0075, 0x030C,
	0x0075, 0x030F, 0x0075, 0x0311, 0x0075, 0x031B, KLongD, 0x01F8,
	KLongD, 0x0237, KLongD, 0x025E, KLongD, 0x0096, KLongD, 0x0111,
	0x0075, 0x0323, 0x0075, 0x0324, 0x0075, 0x0328, 0x0075, 0x032D,
	0x0075, 0x0330, 0x0076, 0x0303, 0x0076, 0x0323, 0x0077, 0x0300,
	0x0077, 0x0301, 0x0077, 0x0302, 0x0077, 0x0307, 0x0077, 0x0308,
	0x0077, 0x0323, 0x0078, 0x0307, 0x0078, 0x0308, 0x0079, 0x0300,
	0x0079, 0x0301, 0x0079, 0x0302, 0x0079, 0x0303, 0x0079, 0x0304,
	0x0079, 0x0307, 0x0079, 0x0308, 0x0079, 0x0309, 0x0079, 0x0323,
	0x007A, 0x0301, 0x007A, 0x0302, 0x007A, 0x0307, 0x007A, 0x030C,
	0x007A, 0x0323, 0x007A, 0x0331, 0x0061, 0x0300, 0x0061, 0x0301,
	0x0061, 0x0302, KLongD, 0x0219, KLongD, 0x0249, KLongD, 0x027C,
	KLongD, 0x009C, 0x0061, 0x0303, 0x0061, 0x0304, 0x0061, 0x0306,
	KLongD, 0x01BF, KLongD, 0x01C2, KLongD, 0x01C8, KLongD, 0x01DA,
	0x0061, 0x0307, KLongD, 0x01AD, 0x0061, 0x0308, KLongD, 0x0162,
	0x0061, 0x0309, 0x0061, 0x030A, KLongD, 0x0195, 0x0061, 0x030C,
	0x0061, 0x030F, 0x0061, 0x0311, 0x0061, 0x0323, KLongD, 0x00FC,
	KLongD, 0x0102, 0x0061, 0x0325, 0x0061, 0x0328, 0x0062, 0x0307,
	0x0062, 0x0323, 0x0062, 0x0331, 0x0063, 0x0301, 0x0063, 0x0302,
	0x0063, 0x0307, 0x0063, 0x030C, 0x0063, 0x0327, KLongD, 0x01E6,
	0x0064, 0x0307, 0x0064, 0x030C, 0x0064, 0x0323, 0x0064, 0x0327,
	0x0064, 0x032D, 0x0064, 0x0331, 0x0065, 0x0300, 0x0065, 0x0301,
	0x0065, 0x0302, KLongD, 0x01EF, KLongD, 0x01F5, KLongD, 0x01FB,
	KLongD, 0x021F, 0x0065, 0x0303, 0x0065, 0x0304, KLongD, 0x018C,
	KLongD, 0x018F, 0x0065, 0x0306, 0x0065, 0x0307, 0x0065, 0x0308,
	0x0065, 0x0309, 0x0065, 0x030C, 0x0065, 0x030F, 0x0065, 0x0311,
	0x0065, 0x0323, KLongD, 0x02A0, 0x0065, 0x0327, KLongD, 0x01AA,
	0x0065, 0x0328, 0x0065, 0x032D, 0x0065, 0x0330, 0x0066, 0x0307,
	0x0067, 0x0301, 0x0067, 0x0302, 0x0067, 0x0304, 0x0067, 0x0306,
	0x0067, 0x0307, 0x0067, 0x030C, 0x0067, 0x0327, 0x0068, 0x0302,
	0x0068, 0x0307, 0x0068, 0x0308, 0x0068, 0x030C, 0x0068, 0x0323,
	0x0068, 0x0327, 0x0068, 0x032E, 0x0068, 0x0331, 0x0069, 0x0300,
	0x0069, 0x0301, 0x0069, 0x0302, 0x0069, 0x0303, 0x0069, 0x0304,
	0x0069, 0x0306, 0x0069, 0x0308, KLongD, 0x023A, 0x0069, 0x0309,
	0x0069, 0x030C, 0x0069, 0x030F, 0x0069, 0x0311, 0x0069, 0x0323,
	0x0069, 0x0328, 0x0069, 0x0330, 0x006A, 0x0302, 0x006A, 0x030C,
	0x006B, 0x0301, 0x006B, 0x030C, 0x006B, 0x0323, 0x006B, 0x0327,
	0x006B, 0x0331, 0x006C, 0x0301, 0x006C, 0x030C, 0x006C, 0x0323,
	KLongD, 0x023D, 0x006C, 0x0327, 0x006C, 0x032D, 0x006C, 0x0331,
	0x006D, 0x0301, 0x006D, 0x0307, 0x006D, 0x0323, 0x006E, 0x0300,
	0x006E, 0x0301, 0x006E, 0x0303, 0x006E, 0x0307, 0x006E, 0x030C,
	0x006E, 0x0323, 0x006E, 0x0327, 0x006E, 0x032D, 0x006E, 0x0331,
	0x006F, 0x0300, 0x006F, 0x0301, 0x006F, 0x0302, KLongD, 0x0117,
	KLongD, 0x011A, KLongD, 0x0120, KLongD, 0x012F, 0x006F, 0x0303,
	KLongD, 0x00DE, KLongD, 0x00F3, KLongD, 0x00FF, 0x006F, 0x0304,
	KLongD, 0x00A8, KLongD, 0x00AE, 0x006F, 0x0306, 0x006F, 0x0307,
	KLongD, 0x0264, 0x006F, 0x0308, KLongD, 0x0201, 0x006F, 0x0309,
	0x006F, 0x030B, 0x006F, 0x030C, 0x006F, 0x030F, 0x006F, 0x0311,
	0x006F, 0x031B, KLongD, 0x0129, KLongD, 0x012C, KLongD, 0x0132,
	KLongD, 0x013E, KLongD, 0x01B9, 0x006F, 0x0323, KLongD, 0x01A7,
	0x006F, 0x0328, KLongD, 0x01F2, 0x0070, 0x0301, 0x0070, 0x0307,
	0x0072, 0x0301, 0x0072, 0x0307, 0x0072, 0x030C, 0x0072, 0x030F,
	0x0072, 0x0311, 0x0072, 0x0323, KLongD, 0x017A, 0x0072, 0x0327,
	0x0072, 0x0331, 0x0073, 0x0301, KLongD, 0x010E, 0x0073, 0x0302,
	0x0073, 0x0307, 0x0073, 0x030C, KLongD, 0x0183, 0x0073, 0x0323,
	KLongD, 0x014A, 0x0073, 0x0326, 0x0073, 0x0327, 0x0074, 0x0307,
	0x0074, 0x0308, 0x0074, 0x030C, 0x0074, 0x0323, 0x0074, 0x0326,
	0x0074, 0x0327, 0x0074, 0x032D, 0x0074, 0x0331, 0x0075, 0x0300,
	0x0075, 0x0301, 0x0075, 0x0302, 0x0075, 0x0303, KLongD, 0x0297,
	0x0075, 0x0304, KLongD, 0x0270, 0x0075, 0x0306, 0x0075, 0x0308,
	KLongD, 0x0141, KLongD, 0x0147, KLongD, 0x014D, KLongD, 0x017D,
	0x0075, 0x0309, 0x0075, 0x030A, 0x0075, 0x030B, 0x0075, 0x030C,
	0x0075, 0x030F, 0x0075, 0x0311, 0x0075, 0x031B, KLongD, 0x01F8,
	KLongD, 0x0237, KLongD, 0x025E, KLongD, 0x0096, KLongD, 0x0111,
	0x0075, 0x0323, 0x0075, 0x0324, 0x0075, 0x0328, 0x0075, 0x032D,
	0x0075, 0x0330, 0x0076, 0x0303, 0x0076, 0x0323, 0x0077, 0x0300,
	0x0077, 0x0301, 0x0077, 0x0302, 0x0077, 0x0307, 0x0077, 0x0308,
	0x0077, 0x030A, 0x0077, 0x0323, 0x0078, 0x0307, 0x0078, 0x0308,
	0x0079, 0x0300, 0x0079, 0x0301, 0x0079, 0x0302, 0x0079, 0x0303,
	0x0079, 0x0304, 0x0079, 0x0307, 0x0079, 0x0308, 0x0079, 0x0309,
	0x0079, 0x030A, 0x0079, 0x0323, 0x007A, 0x0301, 0x007A, 0x0302,
	0x007A, 0x0307, 0x007A, 0x030C, 0x007A, 0x0323, 0x007A, 0x0331,
	0x00A8, 0x0300, 0x00A8, 0x0301, 0x00A8, 0x0301, 0x00A8, 0x0342,
	0x00B4, 0xFFFF, 0x00E6, 0x0301, 0x00E6, 0x0304, 0x00F8, 0x0301,
	0x00E6, 0x0301, 0x00E6, 0x0304, 0x00F8, 0x0301, 0x0073, 0x0307,
	0x0292, 0x030C, 0x0292, 0x030C, 0x03B1, 0x0300, 0x03B1, 0x0301,
	0x03B1, 0x0301, 0x03B1, 0x0304, 0x03B1, 0x0306, 0x03B1, 0x0313,
	KLongD, 0x0004, KLongD, 0x1004, KLongD, 0x0024, KLongD, 0x1024,
	KLongD, 0x0080, KLongD, 0x1080, KLongD, 0x00A2, 0x03B1, 0x0314,
	KLongD, 0x0028, KLongD, 0x1028, KLongD, 0x002C, KLongD, 0x102C,
	KLongD, 0x0068, KLongD, 0x1068, KLongD, 0x01DD, 0x03B1, 0x0345,
	0x03B5, 0x0300, 0x03B5, 0x0301, 0x03B5, 0x0301, 0x03B5, 0x0313,
	KLongD, 0x00E7, KLongD, 0x00F0, 0x03B5, 0x0314, KLongD, 0x00B4,
	KLongD, 0x00BD, 0x03B7, 0x0300, 0x03B7, 0x0301, 0x03B7, 0x0301,
	0x03B7, 0x0313, KLongD, 0x0074, KLongD, 0x1074, KLongD, 0x0058,
	KLongD, 0x1058, KLongD, 0x0014, KLongD, 0x1014, KLongD, 0x01B6,
	0x03B7, 0x0314, KLongD, 0x005C, KLongD, 0x105C, KLongD, 0x004C,
	KLongD, 0x104C, KLongD, 0x001C, KLongD, 0x101C, KLongD, 0x0192,
	0x03B7, 0x0345, 0x03B9, 0x0300, 0x03B9, 0x0301, 0x03B9, 0x0301,
	0x03B9, 0x0304, 0x03B9, 0x0306, 0x03B9, 0x0308, 0x03B9, 0x0313,
	KLongD, 0x028B, KLongD, 0x0294, KLongD, 0x015C, 0x03B9, 0x0314,
	KLongD, 0x0246, KLongD, 0x024C, KLongD, 0x0126, 0x03BF, 0x0300,
	0x03BF, 0x0301, 0x03BF, 0x0301, 0x03BF, 0x0313, KLongD, 0x026D,
	KLongD, 0x0273, 0x03BF, 0x0314, KLongD, 0x020A, KLongD, 0x020D,
	0x03C1, 0x0314, 0x03C5, 0x0300, 0x03C5, 0x0301, 0x03C5, 0x0301,
	0x03C5, 0x0304, 0x03C5, 0x0306, 0x03C5, 0x0308, 0x03C5, 0x0314,
	KLongD, 0x0150, KLongD, 0x0153, KLongD, 0x0198, 0x03C9, 0x0300,
	0x03C9, 0x0301, 0x03C9, 0x0301, 0x03C9, 0x0313, KLongD, 0x000C,
	KLongD, 0x100C, KLongD, 0x0088, KLongD, 0x1088, KLongD, 0x0040,
	KLongD, 0x1040, KLongD, 0x0222, 0x03C9, 0x0314, KLongD, 0x008C,
	KLongD, 0x108C, KLongD, 0x0078, KLongD, 0x1078, KLongD, 0x003C,
	KLongD, 0x103C, KLongD, 0x01CB, 0x03C9, 0x0345, 0x03B1, 0x0300,
	KLongD, 0x022B, 0x03B1, 0x0301, 0x03B1, 0x0301, KLongD, 0x01D4,
	0x03B1, 0x0304, 0x03B1, 0x0306, 0x03B1, 0x0313, KLongD, 0x0004,
	KLongD, 0x1004, KLongD, 0x0024, KLongD, 0x1024, KLongD, 0x0080,
	KLongD, 0x1080, KLongD, 0x00A2, 0x03B1, 0x0314, KLongD, 0x0028,
	KLongD, 0x1028, KLongD, 0x002C, KLongD, 0x102C, KLongD, 0x0068,
	KLongD, 0x1068, KLongD, 0x01DD, 0x03B1, 0x0342, KLongD, 0x00D2,
	0x03B1, 0x0345, 0x03B5, 0x0300, 0x03B5, 0x0301, 0x03B5, 0x0301,
	0x03B5, 0x0313, KLongD, 0x00E7, KLongD, 0x00F0, 0x03B5, 0x0314,
	KLongD, 0x00B4, KLongD, 0x00BD, 0x03B7, 0x0300, KLongD, 0x0105,
	0x03B7, 0x0301, 0x03B7, 0x0301, KLongD, 0x00CF, 0x03B7, 0x0313,
	KLongD, 0x0074, KLongD, 0x1074, KLongD, 0x0058, KLongD, 0x1058,
	KLongD, 0x0014, KLongD, 0x1014, KLongD, 0x01B6, 0x03B7, 0x0314,
	KLongD, 0x005C, KLongD, 0x105C, KLongD, 0x004C, KLongD, 0x104C,
	KLongD, 0x001C, KLongD, 0x101C, KLongD, 0x0192, 0x03B7, 0x0342,
	KLongD, 0x01E3, 0x03B7, 0x0345, 0x03B9, 0x0300, 0x03B9, 0x0301,
	0x03B9, 0x0301, 0x03B9, 0x0304, 0x03B9, 0x0306, 0x03B9, 0x0308,
	KLongD, 0x0213, KLongD, 0x021C, KLongD, 0x021C, KLongD, 0x0108,
	0x03B9, 0x0313, KLongD, 0x028B, KLongD, 0x0294, KLongD, 0x015C,
	0x03B9, 0x0314, KLongD, 0x0246, KLongD, 0x024C, KLongD, 0x0126,
	0x03B9, 0x0342, 0x03BF, 0x0300, 0x03BF, 0x0301, 0x03BF, 0x0301,
	0x03BF, 0x0313, KLongD, 0x026D, KLongD, 0x0273, 0x03BF, 0x0314,
	KLongD, 0x020A, KLongD, 0x020D, 0x03C1, 0x0313, 0x03C1, 0x0314,
	0x03C5, 0x0300, 0x03C5, 0x0301, 0x03C5, 0x0301, 0x03C5, 0x0304,
	0x03C5, 0x0306, 0x03C5, 0x0308, KLongD, 0x0135, KLongD, 0x013B,
	KLongD, 0x013B, KLongD, 0x028E, 0x03C5, 0x0313, KLongD, 0x019E,
	KLongD, 0x01A4, KLongD, 0x0090, 0x03C5, 0x0314, KLongD, 0x0150,
	KLongD, 0x0153, KLongD, 0x0198, 0x03C5, 0x0342, 0x03C9, 0x0300,
	KLongD, 0x0144, 0x03C9, 0x0301, 0x03C9, 0x0301, KLongD, 0x010B,
	0x03C9, 0x0313, KLongD, 0x000C, KLongD, 0x100C, KLongD, 0x0088,
	KLongD, 0x1088, KLongD, 0x0040, KLongD, 0x1040, KLongD, 0x0222,
	0x03C9, 0x0314, KLongD, 0x008C, KLongD, 0x108C, KLongD, 0x0078,
	KLongD, 0x1078, KLongD, 0x003C, KLongD, 0x103C, KLongD, 0x01CB,
	0x03C9, 0x0342, KLongD, 0x0252, 0x03C9, 0x0345, 0x03D2, 0x0301,
	0x03D2, 0x0308, 0x0456, 0x0308, 0x0430, 0x0306, 0x0430, 0x0308,
	0x0433, 0x0301, 0x0435, 0x0300, 0x0435, 0x0306, 0x0435, 0x0308,
	0x0436, 0x0306, 0x0436, 0x0308, 0x0437, 0x0308, 0x0438, 0x0300,
	0x0438, 0x0304, 0x0438, 0x0306, 0x0438, 0x0308, 0x043A, 0x0301,
	0x043E, 0x0308, 0x0443, 0x0304, 0x0443, 0x0306, 0x0443, 0x0308,
	0x0443, 0x030B, 0x0447, 0x0308, 0x044B, 0x0308, 0x044D, 0x0308,
	0x0430, 0x0306, 0x0430, 0x0308, 0x0433, 0x0301, 0x0435, 0x0300,
	0x0435, 0x0306, 0x0435, 0x0308, 0x0436, 0x0306, 0x0436, 0x0308,
	0x0437, 0x0308, 0x0438, 0x0300, 0x0438, 0x0304, 0x0438, 0x0306,
	0x0438, 0x0308, 0x043A, 0x0301, 0x043E, 0x0308, 0x0443, 0x0304,
	0x0443, 0x0306, 0x0443, 0x0308, 0x0443, 0x030B, 0x0447, 0x0308,
	0x044B, 0x0308, 0x044D, 0x0308, 0x0456, 0x0308, 0x0475, 0x030F,
	0x0475, 0x030F, 0x04D9, 0x0308, 0x04D9, 0x0308, 0x04E9, 0x0308,
	0x04E9, 0x0308, 0x05D9, 0x05B4, 0x0627, 0x0653, 0x0627, 0x0654,
	0x0627, 0x0655, 0x0648, 0x0654, 0x064A, 0x0654, 0x06C1, 0x0654,
	0x06D2, 0x0654, 0x06D5, 0x0654, 0x0928, 0x093C, 0x0930, 0x093C,
	0x0933, 0x093C, 0x09C7, 0x09BE, 0x09C7, 0x09D7, 0x0B47, 0x0B3E,
	0x0B47, 0x0B56, 0x0B47, 0x0B57, 0x0B92, 0x0BD7, 0x0BC6, 0x0BBE,
	0x0BC6, 0x0BD7, 0x0BC7, 0x0BBE, 0x0C46, 0x0C56, 0x0CBF, 0x0CD5,
	0x0CC6, 0x0CC2, KLongD, 0x0180, 0x0CC6, 0x0CD5, 0x0CC6, 0x0CD6,
	0x0D46, 0x0D3E, 0x0D46, 0x0D57, 0x0D47, 0x0D3E, 0x0DD9, 0x0DCA,
	0x0DD9, 0x0DCF, KLongD, 0x00C3, 0x0DD9, 0x0DDF, 0x1025, 0x102E,
	0x1FBF, 0x0300, 0x1FBF, 0x0301, 0x1FBF, 0x0342, 0x1FFE, 0x0300,
	0x1FFE, 0x0301, 0x1FFE, 0x0342, 0x2190, 0x0338, 0x2192, 0x0338,
	0x2194, 0x0338, 0x21D0, 0x0338, 0x21D2, 0x0338, 0x21D4, 0x0338,
	0x2203, 0x0338, 0x2208, 0x0338, 0x220B, 0x0338, 0x2223, 0x0338,
	0x2225, 0x0338, 0x223C, 0x0338, 0x2243, 0x0338, 0x2245, 0x0338,
	0x2248, 0x0338, 0x224D, 0x0338, 0x2261, 0x0338, 0x2264, 0x0338,
	0x2265, 0x0338, 0x2272, 0x0338, 0x2273, 0x0338, 0x2276, 0x0338,
	0x2277, 0x0338, 0x227A, 0x0338, 0x227B, 0x0338, 0x227C, 0x0338,
	0x227D, 0x0338, 0x2282, 0x0338, 0x2283, 0x0338, 0x2286, 0x0338,
	0x2287, 0x0338, 0x2291, 0x0338, 0x2292, 0x0338, 0x22A2, 0x0338,
	0x22A8, 0x0338, 0x22A9, 0x0338, 0x22AB, 0x0338, 0x22B2, 0x0338,
	0x22B3, 0x0338, 0x22B4, 0x0338, 0x22B5, 0x0338, 0x3046, 0x3099,
	0x304B, 0x3099, 0x304D, 0x3099, 0x304F, 0x3099, 0x3051, 0x3099,
	0x3053, 0x3099, 0x3055, 0x3099, 0x3057, 0x3099, 0x3059, 0x3099,
	0x305B, 0x3099, 0x305D, 0x3099, 0x305F, 0x3099, 0x3061, 0x3099,
	0x3064, 0x3099, 0x3066, 0x3099, 0x3068, 0x3099, 0x306F, 0x3099,
	0x306F, 0x309A, 0x3072, 0x3099, 0x3072, 0x309A, 0x3075, 0x3099,
	0x3075, 0x309A, 0x3078, 0x3099, 0x3078, 0x309A, 0x307B, 0x3099,
	0x307B, 0x309A, 0x309D, 0x3099, 0x30A6, 0x3099, 0x30AB, 0x3099,
	0x30AD, 0x3099, 0x30AF, 0x3099, 0x30B1, 0x3099, 0x30B3, 0x3099,
	0x30B5, 0x3099, 0x30B7, 0x3099, 0x30B9, 0x3099, 0x30BB, 0x3099,
	0x30BD, 0x3099, 0x30BF, 0x3099, 0x30C1, 0x3099, 0x30C4, 0x3099,
	0x30C6, 0x3099, 0x30C8, 0x3099, 0x30CF, 0x3099, 0x30CF, 0x309A,
	0x30D2, 0x3099, 0x30D2, 0x309A, 0x30D5, 0x3099, 0x30D5, 0x309A,
	0x30D8, 0x3099, 0x30D8, 0x309A, 0x30DB, 0x3099, 0x30DB, 0x309A,
	0x30EF, 0x3099, 0x30F0, 0x3099, 0x30F1, 0x3099, 0x30F2, 0x3099,
	0x30FD, 0x3099, 0x0308, 0x0301, 0x0915, 0x093C, 0x0916, 0x093C,
	0x0917, 0x093C, 0x091C, 0x093C, 0x0921, 0x093C, 0x0922, 0x093C,
	0x092B, 0x093C, 0x092F, 0x093C, 0x09A1, 0x09BC, 0x09A2, 0x09BC,
	0x09AF, 0x09BC, 0x0A32, 0x0A3C, 0x0A38, 0x0A3C, 0x0A16, 0x0A3C,
	0x0A17, 0x0A3C, 0x0A1C, 0x0A3C, 0x0A2B, 0x0A3C, 0x0B21, 0x0B3C,
	0x0B22, 0x0B3C, 0x0F42, 0x0FB7, 0x0F4C, 0x0FB7, 0x0F51, 0x0FB7,
	0x0F56, 0x0FB7, 0x0F5B, 0x0FB7, 0x0F40, 0x0FB5, 0x0F71, 0x0F72,
	0x0F71, 0x0F74, 0x0FB2, 0x0F80, 0x0FB3, 0x0F80, 0x0F71, 0x0F80,
	0x0F92, 0x0FB7, 0x0F9C, 0x0FB7, 0x0FA1, 0x0FB7, 0x0FA6, 0x0FB7,
	0x0FAB, 0x0FB7, 0x0F90, 0x0FB5, 0x05F2, 0x05B7, 0x05E9, 0x05C1,
	0x05E9, 0x05C2, KLongD, 0x00E4, KLongD, 0x00EA, 0x05D0, 0x05B7,
	0x05D0, 0x05B8, 0x05D0, 0x05BC, 0x05D1, 0x05BC, 0x05D2, 0x05BC,
	0x05D3, 0x05BC, 0x05D4, 0x05BC, 0x05D5, 0x05BC, 0x05D6, 0x05BC,
	0x05D8, 0x05BC, 0x05D9, 0x05BC, 0x05DA, 0x05BC, 0x05DB, 0x05BC,
	0x05DC, 0x05BC, 0x05DE, 0x05BC, 0x05E0, 0x05BC, 0x05E1, 0x05BC,
	0x05E3, 0x05BC, 0x05E4, 0x05BC, 0x05E6, 0x05BC, 0x05E7, 0x05BC,
	0x05E8, 0x05BC, 0x05E9, 0x05BC, 0x05EA, 0x05BC, 0x05D5, 0x05B9,
	0x05D1, 0x05BF, 0x05DB, 0x05BF, 0x05E4, 0x05BF
	};

// Table of singleton decompositions and characters with singleton folds
const unsigned short KSingletonDecompositions[] =
	{
	0x0300, 0x0301, 0x0313, 0x02B9, 0x003B, 0x00B7, 0x03B9, 0x0060,
	0x2002, 0x2003, 0x03A9, 0x004B, 0x3008, 0x3009, 0x8C48, 0x66F4,
	0x8ECA, 0x8CC8, 0x6ED1, 0x4E32, 0x53E5, 0x9F9C, 0x9F9C, 0x5951,
	0x91D1, 0x5587, 0x5948, 0x61F6, 0x7669, 0x7F85, 0x863F, 0x87BA,
	0x88F8, 0x908F, 0x6A02, 0x6D1B, 0x70D9, 0x73DE, 0x843D, 0x916A,
	0x99F1, 0x4E82, 0x5375, 0x6B04, 0x721B, 0x862D, 0x9E1E, 0x5D50,
	0x6FEB, 0x85CD, 0x8964, 0x62C9, 0x81D8, 0x881F, 0x5ECA, 0x6717,
	0x6D6A, 0x72FC, 0x90CE, 0x4F86, 0x51B7, 0x52DE, 0x64C4, 0x6AD3,
	0x7210, 0x76E7, 0x8001, 0x8606, 0x865C, 0x8DEF, 0x9732, 0x9B6F,
	0x9DFA, 0x788C, 0x797F, 0x7DA0, 0x83C9, 0x9304, 0x9E7F, 0x8AD6,
	0x58DF, 0x5F04, 0x7C60, 0x807E, 0x7262, 0x78CA, 0x8CC2, 0x96F7,
	0x58D8, 0x5C62, 0x6A13, 0x6DDA, 0x6F0F, 0x7D2F, 0x7E37, 0x96FB,
	0x52D2, 0x808B, 0x51DC, 0x51CC, 0x7A1C, 0x7DBE, 0x83F1, 0x9675,
	0x8B80, 0x62CF, 0x6A02, 0x8AFE, 0x4E39, 0x5BE7, 0x6012, 0x7387,
	0x7570, 0x5317, 0x78FB, 0x4FBF, 0x5FA9, 0x4E0D, 0x6CCC, 0x6578,
	0x7D22, 0x53C3, 0x585E, 0x7701, 0x8449, 0x8AAA, 0x6BBA, 0x8FB0,
	0x6C88, 0x62FE, 0x82E5, 0x63A0, 0x7565, 0x4EAE, 0x5169, 0x51C9,
	0x6881, 0x7CE7, 0x826F, 0x8AD2, 0x91CF, 0x52F5, 0x5442, 0x5973,
	0x5EEC, 0x65C5, 0x6FFE, 0x792A, 0x95AD, 0x9A6A, 0x9E97, 0x9ECE,
	0x529B, 0x66C6, 0x6B77, 0x8F62, 0x5E74, 0x6190, 0x6200, 0x649A,
	0x6F23, 0x7149, 0x7489, 0x79CA, 0x7DF4, 0x806F, 0x8F26, 0x84EE,
	0x9023, 0x934A, 0x5217, 0x52A3, 0x54BD, 0x70C8, 0x88C2, 0x8AAA,
	0x5EC9, 0x5FF5, 0x637B, 0x6BAE, 0x7C3E, 0x7375, 0x4EE4, 0x56F9,
	0x5BE7, 0x5DBA, 0x601C, 0x73B2, 0x7469, 0x7F9A, 0x8046, 0x9234,
	0x96F6, 0x9748, 0x9818, 0x4F8B, 0x79AE, 0x91B4, 0x96B8, 0x60E1,
	0x4E86, 0x50DA, 0x5BEE, 0x5C3F, 0x6599, 0x6A02, 0x71CE, 0x7642,
	0x84FC, 0x907C, 0x9F8D, 0x6688, 0x962E, 0x5289, 0x677B, 0x67F3,
	0x6D41, 0x6E9C, 0x7409, 0x7559, 0x786B, 0x7D10, 0x985E, 0x516D,
	0x622E, 0x9678, 0x502B, 0x5D19, 0x6DEA, 0x8F2A, 0x5F8B, 0x6144,
	0x6817, 0x7387, 0x9686, 0x5229, 0x540F, 0x5C65, 0x6613, 0x674E,
	0x68A8, 0x6CE5, 0x7406, 0x75E2, 0x7F79, 0x88CF, 0x88E1, 0x91CC,
	0x96E2, 0x533F, 0x6EBA, 0x541D, 0x71D0, 0x7498, 0x85FA, 0x96A3,
	0x9C57, 0x9E9F, 0x6797, 0x6DCB, 0x81E8, 0x7ACB, 0x7B20, 0x7C92,
	0x72C0, 0x7099, 0x8B58, 0x4EC0, 0x8336, 0x523A, 0x5207, 0x5EA6,
	0x62D3, 0x7CD6, 0x5B85, 0x6D1E, 0x66B4, 0x8F3B, 0x884C, 0x964D,
	0x898B, 0x5ED3, 0x5140, 0x55C0, 0x585A, 0x6674, 0x51DE, 0x732A,
	0x76CA, 0x793C, 0x795E, 0x7965, 0x798F, 0x9756, 0x7CBE, 0x7FBD,
	0x8612, 0x8AF8, 0x9038, 0x90FD, 0x98EF, 0x98FC, 0x9928, 0x9DB4
	};

// Table of singleton folds
const unsigned short KSingletonFolds[] =
	{
	0x0300, 0x0301, 0x0313, 0x02B9, 0x003B, 0x00B7, 0x03B9, 0x0060,
	0x2002, 0x2003, 0x03C9, 0x006B, 0x3008, 0x3009, 0x8C48, 0x66F4,
	0x8ECA, 0x8CC8, 0x6ED1, 0x4E32, 0x53E5, 0x9F9C, 0x9F9C, 0x5951,
	0x91D1, 0x5587, 0x5948, 0x61F6, 0x7669, 0x7F85, 0x863F, 0x87BA,
	0x88F8, 0x908F, 0x6A02, 0x6D1B, 0x70D9, 0x73DE, 0x843D, 0x916A,
	0x99F1, 0x4E82, 0x5375, 0x6B04, 0x721B, 0x862D, 0x9E1E, 0x5D50,
	0x6FEB, 0x85CD, 0x8964, 0x62C9, 0x81D8, 0x881F, 0x5ECA, 0x6717,
	0x6D6A, 0x72FC, 0x90CE, 0x4F86, 0x51B7, 0x52DE, 0x64C4, 0x6AD3,
	0x7210, 0x76E7, 0x8001, 0x8606, 0x865C, 0x8DEF, 0x9732, 0x9B6F,
	0x9DFA, 0x788C, 0x797F, 0x7DA0, 0x83C9, 0x9304, 0x9E7F, 0x8AD6,
	0x58DF, 0x5F04, 0x7C60, 0x807E, 0x7262, 0x78CA, 0x8CC2, 0x96F7,
	0x58D8, 0x5C62, 0x6A13, 0x6DDA, 0x6F0F, 0x7D2F, 0x7E37, 0x96FB,
	0x52D2, 0x808B, 0x51DC, 0x51CC, 0x7A1C, 0x7DBE, 0x83F1, 0x9675,
	0x8B80, 0x62CF, 0x6A02, 0x8AFE, 0x4E39, 0x5BE7, 0x6012, 0x7387,
	0x7570, 0x5317, 0x78FB, 0x4FBF, 0x5FA9, 0x4E0D, 0x6CCC, 0x6578,
	0x7D22, 0x53C3, 0x585E, 0x7701, 0x8449, 0x8AAA, 0x6BBA, 0x8FB0,
	0x6C88, 0x62FE, 0x82E5, 0x63A0, 0x7565, 0x4EAE, 0x5169, 0x51C9,
	0x6881, 0x7CE7, 0x826F, 0x8AD2, 0x91CF, 0x52F5, 0x5442, 0x5973,
	0x5EEC, 0x65C5, 0x6FFE, 0x792A, 0x95AD, 0x9A6A, 0x9E97, 0x9ECE,
	0x529B, 0x66C6, 0x6B77, 0x8F62, 0x5E74, 0x6190, 0x6200, 0x649A,
	0x6F23, 0x7149, 0x7489, 0x79CA, 0x7DF4, 0x806F, 0x8F26, 0x84EE,
	0x9023, 0x934A, 0x5217, 0x52A3, 0x54BD, 0x70C8, 0x88C2, 0x8AAA,
	0x5EC9, 0x5FF5, 0x637B, 0x6BAE, 0x7C3E, 0x7375, 0x4EE4, 0x56F9,
	0x5BE7, 0x5DBA, 0x601C, 0x73B2, 0x7469, 0x7F9A, 0x8046, 0x9234,
	0x96F6, 0x9748, 0x9818, 0x4F8B, 0x79AE, 0x91B4, 0x96B8, 0x60E1,
	0x4E86, 0x50DA, 0x5BEE, 0x5C3F, 0x6599, 0x6A02, 0x71CE, 0x7642,
	0x84FC, 0x907C, 0x9F8D, 0x6688, 0x962E, 0x5289, 0x677B, 0x67F3,
	0x6D41, 0x6E9C, 0x7409, 0x7559, 0x786B, 0x7D10, 0x985E, 0x516D,
	0x622E, 0x9678, 0x502B, 0x5D19, 0x6DEA, 0x8F2A, 0x5F8B, 0x6144,
	0x6817, 0x7387, 0x9686, 0x5229, 0x540F, 0x5C65, 0x6613, 0x674E,
	0x68A8, 0x6CE5, 0x7406, 0x75E2, 0x7F79, 0x88CF, 0x88E1, 0x91CC,
	0x96E2, 0x533F, 0x6EBA, 0x541D, 0x71D0, 0x7498, 0x85FA, 0x96A3,
	0x9C57, 0x9E9F, 0x6797, 0x6DCB, 0x81E8, 0x7ACB, 0x7B20, 0x7C92,
	0x72C0, 0x7099, 0x8B58, 0x4EC0, 0x8336, 0x523A, 0x5207, 0x5EA6,
	0x62D3, 0x7CD6, 0x5B85, 0x6D1E, 0x66B4, 0x8F3B, 0x884C, 0x964D,
	0x898B, 0x5ED3, 0x5140, 0x55C0, 0x585A, 0x6674, 0x51DE, 0x732A,
	0x76CA, 0x793C, 0x795E, 0x7965, 0x798F, 0x9756, 0x7CBE, 0x7FBD,
	0x8612, 0x8AF8, 0x9038, 0x90FD, 0x98EF, 0x98FC, 0x9928, 0x9DB4,
	0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
	0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 0x0070,
	0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
	0x0079, 0x007A, 0x03BC, 0x00E6, 0x00F0, 0x00F8, 0x00FE, 0x0111,
	0x0127, 0x0069, 0x0133, 0x0140, 0x0142, 0x014B, 0x0153, 0x0167,
	0x0073, 0x0253, 0x0183, 0x0185, 0x0254, 0x0188, 0x0256, 0x0257,
	0x018C, 0x01DD, 0x0259, 0x025B, 0x0192, 0x0260, 0x0263, 0x0269,
	0x0268, 0x0199, 0x026F, 0x0272, 0x0275, 0x01A3, 0x01A5, 0x0280,
	0x01A8, 0x0283, 0x01AD, 0x0288, 0x028A, 0x028B, 0x01B4, 0x01B6,
	0x0292, 0x01B9, 0x01BD, 0x01C6, 0x01C6, 0x01C9, 0x01C9, 0x01CC,
	0x01CC, 0x01E5, 0x01F3, 0x01F3, 0x0195, 0x01BF, 0x021D, 0x0223,
	0x0225, 0x03B9, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6,
	0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE,
	0x03BF, 0x03C0, 0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7,
	0x03C8, 0x03C9, 0x03C3, 0x03B2, 0x03B8, 0x03C6, 0x03C0, 0x03DB,
	0x03DD, 0x03DF, 0x03E1, 0x03E3, 0x03E5, 0x03E7, 0x03E9, 0x03EB,
	0x03ED, 0x03EF, 0x03BA, 0x03C1, 0x03C3, 0x0452, 0x0454, 0x0455,
	0x0456, 0x0458, 0x0459, 0x045A, 0x045B, 0x045F, 0x0430, 0x0431,
	0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437, 0x0438, 0x043A,
	0x043B, 0x043C, 0x043D, 0x043E, 0x043F, 0x0440, 0x0441, 0x0442,
	0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044A,
	0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 0x0461, 0x0463, 0x0465,
	0x0467, 0x0469, 0x046B, 0x046D, 0x046F, 0x0471, 0x0473, 0x0475,
	0x0479, 0x047B, 0x047D, 0x047F, 0x0481, 0x048D, 0x048F, 0x0491,
	0x0493, 0x0495, 0x0497, 0x0499, 0x049B, 0x049D, 0x049F, 0x04A1,
	0x04A3, 0x04A5, 0x04A7, 0x04A9, 0x04AB, 0x04AD, 0x04AF, 0x04B1,
	0x04B3, 0x04B5, 0x04B7, 0x04B9, 0x04BB, 0x04BD, 0x04BF, 0x04C4,
	0x04C8, 0x04CC, 0x04D5, 0x04D9, 0x04E1, 0x04E9, 0x0561, 0x0562,
	0x0563, 0x0564, 0x0565, 0x0566, 0x0567, 0x0568, 0x0569, 0x056A,
	0x056B, 0x056C, 0x056D, 0x056E, 0x056F, 0x0570, 0x0571, 0x0572,
	0x0573, 0x0574, 0x0575, 0x0576, 0x0577, 0x0578, 0x0579, 0x057A,
	0x057B, 0x057C, 0x057D, 0x057E, 0x057F, 0x0580, 0x0581, 0x0582,
	0x0583, 0x0584, 0x0585, 0x0586, 0x2170, 0x2171, 0x2172, 0x2173,
	0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0x217A, 0x217B,
	0x217C, 0x217D, 0x217E, 0x217F, 0x24D0, 0x24D1, 0x24D2, 0x24D3,
	0x24D4, 0x24D5, 0x24D6, 0x24D7, 0x24D8, 0x24D9, 0x24DA, 0x24DB,
	0x24DC, 0x24DD, 0x24DE, 0x24DF, 0x24E0, 0x24E1, 0x24E2, 0x24E3,
	0x24E4, 0x24E5, 0x24E6, 0x24E7, 0x24E8, 0x24E9, 0xFF41, 0xFF42,
	0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 0xFF48, 0xFF49, 0xFF4A,
	0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 0xFF52,
	0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A
	};

// Total size: 31438 bytes
