/*******************************************************************************
 * Copyright (c) 2008 IBM Wind River Systems, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Markus Schorn - Initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousDeclarator;
import org.eclipse.core.runtime.Assert;

/**
 * Handles ambiguities when parsing declarators.
 * <br>
 * Example: void f(int (D));  // is D a type?
 * @since 5.0.1
 */
public class CPPASTAmbiguousDeclarator extends CPPASTAmbiguity implements IASTAmbiguousDeclarator {

    private IASTDeclarator[] dtors = new IASTDeclarator[2];
    private int dtorPos=-1;

    
    public CPPASTAmbiguousDeclarator(IASTDeclarator... decls) {
		for(IASTDeclarator d : decls) {
			if (d != null) {
				addDeclarator(d);
			}
		}
	}

	public void addDeclarator(IASTDeclarator d) {
    	if (d != null) {
    		dtors = (IASTDeclarator[]) ArrayUtil.append(IASTDeclarator.class, dtors, ++dtorPos, d);
    		d.setParent(this);
			d.setPropertyInParent(SUBDECLARATOR);
    	}
    }

    public IASTDeclarator[] getDeclarators() {
    	dtors = (IASTDeclarator[]) ArrayUtil.removeNullsAfter(IASTDeclarator.class, dtors, dtorPos ); 
        return dtors;
    }

    @Override
	protected IASTNode[] getNodes() {
        return getDeclarators();
    }

	public IASTInitializer getInitializer() {
		return dtors[0].getInitializer();
	}

	public IASTName getName() {
		return dtors[0].getName();
	}

	public IASTDeclarator getNestedDeclarator() {
		return dtors[0].getNestedDeclarator();
	}

	public IASTPointerOperator[] getPointerOperators() {
		return dtors[0].getPointerOperators();
	}
	
	public int getRoleForName(IASTName name) {
		return dtors[0].getRoleForName(name);
	}

	public void addPointerOperator(IASTPointerOperator operator) {
		Assert.isLegal(false);
	}

	public void setInitializer(IASTInitializer initializer) {
		Assert.isLegal(false);
	}

	public void setName(IASTName name) {
		Assert.isLegal(false);
	}

	public void setNestedDeclarator(IASTDeclarator nested) {
		Assert.isLegal(false);
	}
}
