/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.local;

import java.math.BigDecimal;
import org.eclipse.tm.internal.tcf.core.Token;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IDiagnostics;

public class DiagnosticsService
implements IDiagnostics {
    private final IChannel channel;

    public DiagnosticsService(IChannel channel) {
        this.channel = channel;
        channel.addCommandServer(this, new CommandServer());
    }

    public String getName() {
        return "Diagnostics";
    }

    public IToken echo(final String s, final IDiagnostics.DoneEcho done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            public void run() {
                done.doneEcho(token, null, s);
            }
        });
        return token;
    }

    public IToken echoFP(final BigDecimal n, final IDiagnostics.DoneEchoFP done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            public void run() {
                done.doneEchoFP(token, null, n);
            }
        });
        return token;
    }

    public IToken getTestList(final IDiagnostics.DoneGetTestList done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            public void run() {
                done.doneGetTestList(token, null, new String[0]);
            }
        });
        return token;
    }

    public IToken runTest(final String s, final IDiagnostics.DoneRunTest done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            public void run() {
                done.doneRunTest(token, new Exception("Test suite not found: " + s), null);
            }
        });
        return token;
    }

    public IToken cancelTest(String context_id, final IDiagnostics.DoneCancelTest done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            public void run() {
                done.doneCancelTest(token, null);
            }
        });
        return token;
    }

    public IToken getSymbol(String context_id, String symbol_name, final IDiagnostics.DoneGetSymbol done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            public void run() {
                done.doneGetSymbol(token, new Exception("Invalid context"), null);
            }
        });
        return token;
    }

    public IToken createTestStreams(int inp_buf_size, int out_buf_size, final IDiagnostics.DoneCreateTestStreams done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            public void run() {
                done.doneCreateTestStreams(token, new Exception("Not implemented"), null, null);
            }
        });
        return token;
    }

    public IToken disposeTestStream(String id, final IDiagnostics.DoneDisposeTestStream done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            public void run() {
                done.doneDisposeTestStream(token, new Exception("Invalid context"));
            }
        });
        return token;
    }

    public IToken not_implemented_command(final IDiagnostics.DoneNotImplementedCommand done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            public void run() {
                done.doneNotImplementedCommand(token, new Exception("Not implemented"));
            }
        });
        return token;
    }

    private class CommandServer
    implements IChannel.ICommandServer {
        private CommandServer() {
        }

        public void command(IToken token, String name, byte[] data) {
            try {
                this.command(token, name, JSON.parseSequence(data));
            }
            catch (Throwable x) {
                DiagnosticsService.this.channel.terminate(x);
            }
        }

        private void command(IToken token, String name, Object[] args) throws Exception {
            if (name.equals("echo")) {
                if (args.length != 1) {
                    throw new Exception("Invalid number of arguments");
                }
                String s = (String)args[0];
                DiagnosticsService.this.channel.sendResult(token, JSON.toJSONSequence(new Object[]{s}));
            } else if (name.equals("echoFP")) {
                if (args.length != 1) {
                    throw new Exception("Invalid number of arguments");
                }
                Number n = (Number)args[0];
                DiagnosticsService.this.channel.sendResult(token, JSON.toJSONSequence(new Object[]{n}));
            } else if (name.equals("getTestList")) {
                if (args.length != 0) {
                    throw new Exception("Invalid number of arguments");
                }
                Object[] objectArray = new Object[2];
                objectArray[1] = new String[0];
                DiagnosticsService.this.channel.sendResult(token, JSON.toJSONSequence(objectArray));
            } else {
                DiagnosticsService.this.channel.rejectCommand(token);
            }
        }
    }
}

