/*
 * Decompiled with CFR 0.152.
 */
package com.kirkk.analyzer.framework.bcel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;

public class PackageVisitor
extends EmptyVisitor {
    private JavaClass javaClass;
    private ArrayList imports;
    private ArrayList strings;

    public PackageVisitor(JavaClass javaClass) {
        this.javaClass = javaClass;
        this.imports = new ArrayList();
        this.strings = new ArrayList();
    }

    public void visitConstantClass(ConstantClass constantClass) {
        String string = constantClass.getBytes(this.javaClass.getConstantPool());
        if (string.indexOf("/") != -1) {
            string = this.stripClassName(string);
            string = string.replace('/', '.');
            if (!this.imports.contains(string = this.cleanClass(string)) && !this.javaClass.getPackageName().equals(string)) {
                this.imports.add(string);
            }
        }
    }

    public void visitConstantUtf8(ConstantUtf8 constantUtf8) {
        String string = constantUtf8.toString().substring(constantUtf8.toString().indexOf(34) + 1, constantUtf8.toString().lastIndexOf(34));
        if (this.isValidJavaClass(string) && !this.strings.contains(string)) {
            String[] stringArray = this.separateClasses(string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                String string2 = stringArray[i];
                String string3 = this.stripClassName(string2);
                String string4 = this.cleanClass(string3 = string3.replace('/', '.'));
                if (this.imports.contains(string4) || this.javaClass.getPackageName().equals(string4)) continue;
                this.imports.add(string4);
            }
        }
    }

    public void visitConstantString(ConstantString constantString) {
        this.strings.add(constantString.getBytes(this.javaClass.getConstantPool()).toString());
    }

    private boolean isValidJavaClass(String string) {
        if (string.indexOf("/") == -1) {
            return false;
        }
        if (!string.startsWith("(") && !string.startsWith("L")) {
            return false;
        }
        return string.endsWith("V") || string.endsWith(";") || string.endsWith(")");
    }

    private String[] separateClasses(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(47) == -1) continue;
            stringArray[n] = string2;
            ++n;
        }
        return stringArray;
    }

    private String cleanClass(String string) {
        int n = string.lastIndexOf(76);
        String string2 = string;
        if (n != -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private String stripClassName(String string) {
        String string2 = string.substring(0, string.lastIndexOf("/"));
        return string2;
    }

    public List getAllImports() {
        return this.imports;
    }

    public List getImports(List list) {
        Iterator iterator = this.imports.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!list.isEmpty()) {
                Iterator iterator2 = list.iterator();
                boolean bl = false;
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (!string.startsWith(string2)) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(string);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }
}

