/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:29 $
 * $Revision: 1.16 $
 */

/*
 *	Routines
 *	--------
 *		__init_critical_regions
 *		__kill_critical_regions
 *		__begin_critical_region
 *		__end_critical_region
 */

#ifndef _MSL_CRITICAL_REGIONS_WIN32_H
#define _MSL_CRITICAL_REGIONS_WIN32_H

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

_MSL_BEGIN_EXTERN_C	/*- cc 010410 -*/

	_MSL_IMP_EXP_C extern CRITICAL_SECTION __cs[num_critical_regions];

	_MSL_INLINE void _MSL_CDECL __init_critical_regions(void) _MSL_CANT_THROW
	{
			int i;
			for (i = 0; i < num_critical_regions; i++)
					InitializeCriticalSection(&__cs[i]);
	}

	_MSL_INLINE void _MSL_CDECL __kill_critical_regions(void) _MSL_CANT_THROW
	{
			int i;
			for (i = 0; i < num_critical_regions; i++)
					DeleteCriticalSection(&__cs[i]);
	}
	
#if _MSL_THREADSAFE
	_MSL_INLINE void _MSL_CDECL __begin_critical_region(int region) _MSL_CANT_THROW
	{
			EnterCriticalSection(&__cs[region]);	
	}

	_MSL_INLINE void _MSL_CDECL __end_critical_region(int region) _MSL_CANT_THROW
	{
			LeaveCriticalSection(&__cs[region]);
	}
#endif /* _MSL_THREADSAFE */


_MSL_END_EXTERN_C	/*- cc 010410 -*/

#endif /* _MSL_CRITICAL_REGIONS_WIN32_H */

/* Change record:
 * hh  971206 expanded _extern macro
 * hh  980122 Replaced <windows.h> with the following TWO includes because it is seriously
 *            broken.  The following 2 includes must be carefully ordered as shown, because
 *            they are broken too.
 * mf  980624 don't include x86_prefix.h
 * cc  010410 updated to new namespace macros
 * JWW 020130 Changed _MWMT to _MSL_THREADSAFE for consistency's sake
 * hh  020603 Added no throw spec to functions
 * JWW 030528 Use _MSL_INLINE instead of __inline to get inlining without declaring functions static
 */