#============================================================================ 
#Name        : variants.py 
#Part of     : Helium 

#Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
#All rights reserved.
#This component and the accompanying materials are made available
#under the terms of the License "Eclipse Public License v1.0"
#which accompanies this distribution, and is available
#at the URL "http://www.eclipse.org/legal/epl-v10.html".
#
#Initial Contributors:
#Nokia Corporation - initial contribution.
#
#Contributors:
#
#Description:
#===============================================================================
"""retrieve the variant info from  the iMaker _info.txt file"""

def parseInfo(filename):
    """ Parsing the _info.txt files generated by iMaker. The function returns a dict containing
        the variant information.
    """
    info = open(filename, "r")
    data = {}
    for line in info:
        line = line.strip()
        if line.startswith("Default Lang.") and ':' in line:
            data['default'] = line.split(":")[1].strip()
        elif line.startswith("Language IDs") and ':' in line:
            data['language.ids'] = line.split(":")[1].strip().split(r' ')
        elif line.startswith("Languages") and ':' in line:
            data['languages'] = line.split(":")[1].strip().split(r' ')
        elif line.startswith("Name") and ':' in line:
            data['name'] = line.split(":")[1].strip()
    return data

