/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodParamPadCheck
extends AbstractOptionCheck<PadOption> {
    private boolean mAllowLineBreaks;

    public MethodParamPadCheck() {
        super(PadOption.NOSPACE, PadOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 136, 27, 9, 42};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST parenAST;
        if (aAST.getType() == 27) {
            parenAST = aAST;
        } else {
            parenAST = aAST.findFirstToken(76);
            if (parenAST == null) {
                return;
            }
        }
        String line = this.getLines()[parenAST.getLineNo() - 1];
        if (Utils.whitespaceBefore(parenAST.getColumnNo(), line)) {
            if (!this.mAllowLineBreaks) {
                this.log(parenAST, "line.previous", parenAST.getText());
            }
        } else {
            int before = parenAST.getColumnNo() - 1;
            if (PadOption.NOSPACE == this.getAbstractOption() && Character.isWhitespace(line.charAt(before))) {
                this.log(parenAST, "ws.preceded", parenAST.getText());
            } else if (PadOption.SPACE == this.getAbstractOption() && !Character.isWhitespace(line.charAt(before))) {
                this.log(parenAST, "ws.notPreceded", parenAST.getText());
            }
        }
    }

    public void setAllowLineBreaks(boolean aAllowLineBreaks) {
        this.mAllowLineBreaks = aAllowLineBreaks;
    }
}

