/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.db;

import com.nokia.helium.jpa.entity.metadata.Metadata;
import com.nokia.helium.jpa.entity.metadata.MetadataUtil;
import java.io.File;
import org.apache.log4j.Logger;

public class ORMMetadataDB {
    private static Logger log = Logger.getLogger(ORMMetadataDB.class);
    private static final int LOG_ENTRY_CACHE_LIMIT = 500;
    private static final int DB_SCHEMA_VERSION = 1;
    private String dbPath;

    public ORMMetadataDB(String databasePath) {
        log.debug((Object)("initializing ORMMetadataDB: dbPath: " + databasePath));
        File actualPath = new File(databasePath);
        String fileName = actualPath.getName();
        this.dbPath = new File(actualPath.getParent(), fileName.toLowerCase()).getPath();
        MetadataUtil.initializeORM((String)this.dbPath);
    }

    public void addLogEntry(Metadata.LogEntry entry) {
        MetadataUtil.addEntry((String)this.dbPath, (Metadata.LogEntry)entry);
    }

    public void removeEntries(String logPath) {
        MetadataUtil.removeEntries((String)this.dbPath, (String)logPath);
    }

    public void finalizeMetadata(String logPath) {
        MetadataUtil.finalizeMetadata((String)logPath);
    }

    public void finalizeDB() {
        MetadataUtil.finalizeORM((String)this.dbPath);
    }
}

