/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.checktools;

import com.nokia.helium.checktools.CheckToolException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class ToolChecker {
    private int errorCount;

    public void verifyIsExpectedToolVersionConfigured(String expVersion, String errorMsg) {
        if (expVersion == null || expVersion != null && expVersion.trim().isEmpty()) {
            this.raiseError(errorMsg);
        }
    }

    public void verifyToolVersion(String command, String expVersion, String versionString2match, String errorMsg) {
        String[] versions = expVersion.split(",");
        String installedVersion = this.getInstalledToolVersion(command);
        boolean valid = false;
        for (int i = 0; i < versions.length; ++i) {
            if (valid) continue;
            valid = installedVersion.contains(versionString2match + versions[i]);
        }
        if (!valid) {
            System.out.println("Installed Version : " + installedVersion);
            this.raiseError(errorMsg);
        } else {
            System.out.println("Done");
        }
    }

    public void raiseError(String message) {
        this.incrementErrorCount();
        throw new CheckToolException(message);
    }

    public String getInstalledToolVersion(String cmd) {
        String input = null;
        String error = null;
        try {
            Process toolProcess = Runtime.getRuntime().exec(cmd);
            input = this.toString(toolProcess.getInputStream());
            error = this.toString(toolProcess.getErrorStream());
        }
        catch (Throwable th) {
            throw new CheckToolException(th);
        }
        return input.isEmpty() ? error : input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(InputStream is) throws Exception {
        OutputStream os = null;
        String versionString = null;
        try {
            int read;
            byte[] buffer = new byte[4096];
            os = new ByteArrayOutputStream();
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            versionString = os.toString();
        }
        finally {
            try {
                os.close();
                is.close();
            }
            catch (Exception e2) {
                Object e2 = null;
            }
        }
        return versionString;
    }

    private void incrementErrorCount() {
        ++this.errorCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }
}

