/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.core.LogSource;
import com.nokia.helium.metadata.db.MetaDataDb;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetadataSource
extends LogSource {
    private static Logger logger = Logger.getLogger(MetadataSource.class);
    private String db;
    private String log;

    public void setDb(String db) {
        this.db = db;
    }

    public String getDb() {
        return this.db;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public String getLog() {
        return this.log;
    }

    public File getFilename() {
        MetaDataDb mdb = new MetaDataDb(this.db);
        String sql = "select * from metadata INNER JOIN logfiles ON logfiles.id=metadata.logpath_id INNER JOIN priority ON priority.id=metadata.priority_id where priority='ERROR' and path like '%" + this.log + "'";
        List<Map<String, Object>> records = mdb.getRecords(sql);
        try {
            File temp = File.createTempFile("templog.", ".xml");
            temp.deleteOnExit();
            BufferedWriter output = new BufferedWriter(new FileWriter(temp));
            output.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<log filename=\"" + this.log + "\">\n<build>\n");
            for (Map<String, Object> map : records) {
                output.write("<message priority=\"error\"><![CDATA[" + map.get("data") + "]]></message>\n");
            }
            output.write("</build>\n</log>");
            output.close();
            return temp;
        }
        catch (Exception ex) {
            logger.info((Object)"Exception generating xml file for metadata");
            logger.debug((Object)"Exception in metadata source", (Throwable)ex);
            return null;
        }
    }
}

