/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.gui.DateChooser;
import com.sardak.antform.interfaces.ActionListenerComponent;
import com.sardak.antform.interfaces.Requirable;
import com.sardak.antform.types.DefaultProperty;
import com.sardak.antform.util.FontStyleAttribute;
import java.awt.Font;
import javax.swing.JComponent;
import org.apache.tools.ant.Task;

public class DateProperty
extends DefaultProperty
implements Requirable,
ActionListenerComponent {
    private String dateFormat;
    private boolean required;
    private DateChooser chooser;
    private String fontName;
    private int fontSize = -1;
    private int fontStyle = 0;

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(FontStyleAttribute fsa) {
        this.fontStyle = fsa.getFontStyle();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void addToControlPanel(ControlPanel panel) {
        this.chooser = new DateChooser(this.dateFormat);
        panel.getStylesheetHandler().addDateChooser(this.chooser);
        this.chooser.setEnabled(this.isEditable());
        if (this.fontName != null || this.fontSize == -1) {
            Font f = this.chooser.getFont();
            String name = this.fontName == null ? f.getFontName() : this.fontName;
            int size = this.fontSize > 0 ? this.fontSize : f.getSize();
            this.chooser.setFont(new Font(name, this.fontStyle, size));
        }
        this.initComponent(this.chooser, panel);
    }

    public boolean validate(Task task) {
        boolean isValid = super.validate(task, "Date");
        if (this.getDateFormat() == null) {
            task.log("DateProperty : attribute \"dateformat\" missing.");
            isValid = false;
        }
        return isValid;
    }

    public void ok() {
        this.getProject().setProperty(this.getProperty(), this.chooser.getText());
    }

    public void reset() {
        this.chooser.setText(this.getCurrentProjectPropertyValue());
    }

    public boolean requiredStatusOk() {
        boolean ok = true;
        if (this.isRequired() && "".equals(this.chooser.getText())) {
            ok = false;
            this.chooser.requestFocus();
        }
        return ok;
    }

    public JComponent getFocusableComponent() {
        return this.chooser;
    }
}

