/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import java.io.File;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocPackageCheck
extends AbstractFileSetCheck {
    private boolean mAllowLegacy;
    private final Set<File> mDirectoriesChecked = Sets.newHashSet();

    public JavadocPackageCheck() {
        this.setFileExtensions(new String[]{"java"});
    }

    @Override
    public void beginProcessing(String aCharset) {
        super.beginProcessing(aCharset);
        this.mDirectoriesChecked.clear();
    }

    @Override
    protected void processFiltered(File aFile, List<String> aLines) {
        File dir = aFile.getParentFile();
        if (this.mDirectoriesChecked.contains(dir)) {
            return;
        }
        this.mDirectoriesChecked.add(dir);
        File packageInfo = new File(dir, "package-info.java");
        File packageHtml = new File(dir, "package.html");
        if (packageInfo.exists()) {
            if (packageHtml.exists()) {
                this.log(0, "javadoc.legacyPackageHtml", new Object[0]);
            }
        } else if (!this.mAllowLegacy || !packageHtml.exists()) {
            this.log(0, "javadoc.packageInfo", new Object[0]);
        }
    }

    public void setAllowLegacy(boolean aAllowLegacy) {
        this.mAllowLegacy = aAllowLegacy;
    }
}

