/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.conglomerate.ScanControllerRowSource;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.sort.Scan;
import org.apache.derby.impl.store.access.sort.SortBuffer;

public class SortBufferRowSource
extends Scan
implements ScanControllerRowSource {
    SortBuffer sortBuffer = null;
    protected TransactionManager tran = null;
    private int maxFreeListSize;
    private boolean writingToDisk;
    private SortObserver sortObserver;

    SortBufferRowSource(SortBuffer sortBuffer, TransactionManager transactionManager, SortObserver sortObserver, boolean bl, int n) {
        this.sortBuffer = sortBuffer;
        this.tran = transactionManager;
        this.sortObserver = sortObserver;
        this.writingToDisk = bl;
        this.maxFreeListSize = n;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() {
        if (this.sortBuffer == null) {
            return null;
        }
        DataValueDescriptor[] dataValueDescriptorArray = this.sortBuffer.removeFirst();
        if (dataValueDescriptorArray != null && this.writingToDisk) {
            this.sortObserver.addToFreeList(dataValueDescriptorArray, this.maxFreeListSize);
        }
        return dataValueDescriptorArray;
    }

    public boolean needsRowLocation() {
        return false;
    }

    public boolean needsToClone() {
        return false;
    }

    public void rowLocation(RowLocation rowLocation) {
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public void close() {
        if (this.sortBuffer != null) {
            this.sortBuffer.close();
            this.sortBuffer = null;
        }
        this.tran.closeMe(this);
    }

    public boolean closeForEndTransaction(boolean bl) {
        this.close();
        return true;
    }

    public void closeRowSource() {
        this.close();
    }

    public boolean next() throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    public void fetchWithoutQualify(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    public void fetch(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    public final boolean fetchNext(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }
}

