/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
#include <liboil/liboilfunction.h>
#include <liboil/liboil.h>
#include <stdio.h>
#include <stdlib.h>

#include <liboil/globals.h>

#define LOG_FILE "c:\\logs\\testapps_oil_resample_linear_argb.txt"
#include "std_log_result.h"
#define LOG_FILENAME_LINE __FILE__, __LINE__

void create_xml(int result)
{
    if(result)
        assert_failed = 1;
    
    testResultXml("testapps_oil_resample_linear_argb");
    close_log_file();
}
#define TEST_ARRAY_SIZE 24

int main()
{
	uint32_t src[] = {0x00000000, 0x00000000, 0xFF00FF00, 0x00FF0000, 0x0000FF00, 0x000000FF, 0xF0F0F0F0, 0x0F0F0F0F, 0xFFFFFFFF, 0xFFFFFFFF, 0xABCD0123, 0x45678901, 0x1A2B3C4D, 0x8A9BD1CE, 0xABC0000F, 0xFFFF0000, 0x00FFF000, 0x09682B1F, 0x193D7C2A, 0x72914650, 0xBF780002, 0xAB666BF7, 0x78822307, 0x45111990};
	uint32_t unix_result[]= {0x0,0x0,0xff00ff00,0xff0000,0xff00,0xff,0xf0f0f0f0,0xf0f0f0f,0xffffffff,0xffffffff,0xabcd0123,0x45678901,0x1a2b3c4d,0x8a9bd1ce,0xabc0000f,0xffff0000,0xfff000,0x9682b1f,0x193d7c2a,0x72914650,0xbf780002,0xab666bf7,0x78822307,0x0,0x0,0xfe00fe00,0xfe0000,0xfe00,0xfe,0xefefefef,0xf0f0f0f,0xffffffff,0xfefefefe,0xaacc0122,0x44668801,0x1a2b3c4d,0x8a9bd0cd,0xabc0000e,0xfeff0000,0xfeef00,0x9672b1f,0x193d7b2a,0x7290454f,0xbe770002,0xaa666af6,0x77812207,0x0,0x76007600,0x88768800,0x887600,0x8876,0x6f6f6ff8,0x87878787,0x7e7e7e7e,0xffffffff,0xd7e78898,0x7b9d4013,0x314b6524,0x4e5f8188,0x99ac6f75,0xd2dd0008,0x88ff6f00,0x4b8940e,0x10545024,0x4264623b,0x9585252b,0xb56f3173,0x93734987,0x604d1e46,0x0,0x9f009f00,0x5f9f5f00,0x5f9f00,0x5f9f,0x969696f5,0x63636363,0xa5a5a5a5,0xffffffff,0xcadf6075,0x6b8d560d,0x2a415830,0x6071999d,0x9eb24e56,0xdfe70005,0x5fff9600,0x5a07413,0x134d5d25,0x50715a41,0xa2811a1f,0xb26c429b,0x8b773e61,0x583b1c5c,0x0,0xfd00fd00,0x1fd0100,0x1fd00,0x1fd,0xeeeeeef0,0x10101010,0xfdfdfdfd,0xffffffff,0xabcd0224,0x45678701,0x1a2b3c4c,0x899acfcc,0xaabf0110,0xfefe0000,0x1ffee00,0x8692c1e,0x183d7b29,0x7190464f,0xbe780002,0xab666af5,0x78812308,0x4511198e,0x0,0xfe00fe00,0xfe0000,0xfe00,0xfe,0xefefeff0,0xf0f0f0f,0xfefefefe,0xffffffff,0xabcd0123,0x45678801,0x1a2b3c4c,0x899ad0cd,0xaabf000f,0xfefe0000,0xffef00,0x8682b1e,0x183d7b29,0x7190464f,0xbe780002,0xab666af6,0x78812307,0x4511198f,0x0,0xff00ff00,0xff00,0xf0f0f0f0,0xffffffff,0xabcd0123,0x1a2b3c4d,0xabc0000f,0xfff000,0x193d7c2a,0xbf780002,0x0,0xfe00fe00,0xfe00,0xefefefef,0xffffffff,0xaacc0122,0x1a2b3c4d,0xabc0000e,0xfeef00,0x193d7b2a,0xbe770002,0x0,0x88768800,0x8876,0x87878787,0xffffffff,0x7b9d4013,0x4e5f8188,0xd2dd0008,0x4b8940e,0x4264623b,0xb56f3173,0x0,0x5f9f5f00,0x5f9f,0x63636363,0xffffffff,0x6b8d560d,0x6071999d,0xdfe70005,0x5a07413,0x50715a41,0xb26c429b,0x0,0x1fd0100,0x1fd,0x10101010,0xffffffff,0x45678701,0x899acfcc,0xfefe0000,0x8692c1e,0x7190464f,0xab666af5,0x0,0xfe0000,0xfe,0xf0f0f0f,0xffffffff,0x45678801,0x899ad0cd,0xfefe0000,0x8682b1e,0x7190464f,0xab666af6,0x0,0xff00,0xffffffff,0x1a2b3c4d,0xfff000,0x0,0xfe00,0xffffffff,0x1a2b3c4d,0xfeef00,0x0,0x8876,0xffffffff,0x4e5f8188,0x4b8940e,0x0,0x5f9f,0xffffffff,0x6071999d,0x5a07413,0x0,0x1fd,0xffffffff,0x899acfcc,0x8692c1e,0x0,0xfe,0xffffffff,0x899ad0cd,0x8682b1e};
	uint32_t dest[TEST_ARRAY_SIZE];
	uint32_t mul[] = { 0x00000000,
			  0x00000100, 
			  0x00007700,
			  0x0000A000,
			  0x0000FE00,
			  0x0000FF00,
			};
	uint32_t inc[] = { 0x00010000, TEST_ARRAY_SIZE-1,
			  0x00020000, TEST_ARRAY_SIZE/2 - 1,
			  0x00040000, TEST_ARRAY_SIZE/4 - 1,
			};
	uint32_t i,j,k;
	uint32_t in[2];
	int ref=0;

	oil_init();
	for (j=0; j<(sizeof(inc)/sizeof(uint32_t)); j=j+2){
		in[1] = inc[j];
		printf("\nFor in[1]=%10x\n", inc[j]);
		std_log(LOG_FILENAME_LINE,"\nFor in[1]=%10x\n", inc[j]);
		for (i=0; i<(sizeof(mul)/sizeof(uint32_t)); i++){
			in[0] = mul[i];
			oil_resample_linear_argb(dest, src, (int)inc[j+1], in);
			for (k=0; k<inc[j+1]; k++)
			{
				printf("%x,%x\n",unix_result[ref],dest[k]);
				if(unix_result[ref]!=dest[k])
					{
					printf("Test failed@ %x,%x,%x,%x",unix_result[ref],dest[k],ref,k);
					assert_failed=1;
					}
				ref++;
			}
		}
	}
	if(assert_failed)
          std_log(LOG_FILENAME_LINE,"Test Fail");
    else
          std_log(LOG_FILENAME_LINE,"Test Successful");
    create_xml(0);
	return 0;
}
