/*
* Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
* FUNCTION
* <<localtime>>---convert time to local representation
* INDEX
* localtime
* ANSI_SYNOPSIS
* #include <time.h>
* struct tm *localtime(time_t *<[clock]>);
* struct tm *localtime_r(time_t *<[clock]>, struct tm *<[res]>);
* TRAD_SYNOPSIS
* #include <time.h>
* struct tm *localtime(<[clock]>)
* time_t *<[clock]>;
* struct tm *localtime(<[clock]>, <[res]>)
* time_t *<[clock]>;
* struct tm *<[res]>;
* <<localtime>> converts the time at <[clock]> into local time, then
* converts its representation from the arithmetic representation to the
* traditional representation defined by <<struct tm>>.
* <<localtime>> constructs the traditional time representation in static
* storage; each call to <<gmtime>> or <<localtime>> will overwrite the
* information generated by previous calls to either function.
* <<mktime>> is the inverse of <<localtime>>.
* RETURNS
* A pointer to the traditional time representation (<<struct tm>>).
* PORTABILITY
* ANSI C requires <<localtime>>.
* <<localtime>> requires no supporting OS subroutines.
* 
*
*/



#include <time.h>
#include <sys/reent.h>

#ifndef _REENT_ONLY

/**
Convert time_t value to tm structure as local time.
Converts timer to tm structure adjusting to the local time zone.
@return A pointer to a tm structure.
This structure is statically allocated and shared by gmtime, 
localtime and ctime functions.
Each time one of these functions is called the content 
of the structure is overwritten.
@param tim_p pointer to a time_t value, 
usually returned by time function.
*/
EXPORT_C struct tm *
localtime (const time_t * tim_p)
{
  return localtime_r (tim_p, &(_REENT->_struct_tm));
}

#endif
