// Copyright (c) 2002-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

// EPOC includes
#include <e32base.h>
#include <mmf/common/mmfutilities.h>
#ifdef SYMBIAN_ENABLE_SPLIT_HEADERS
#include <mmf/common/mmfhelper.h>
#endif
#include <s32file.h>
#include <mmf/utils/rateconvert.h>

// Test system includes
#include <e32std.h>	
#include "TSU_MMF_BASECL_DataPath.h"
#include "TSU_MMF_BASECLSuite.h"
#include "TSU_MMF_BASECL_TestFormat.h"

//tests 0200 - 0380


TInt CTestAsyncEventHandler::SendEventToClient(const TMMFEvent& aEvent)
	{
	iEvent = aEvent;
	if (iEvent.iEventType == KMMFErrorCategoryDataPathGeneralError ||
		iEvent.iEventType == KMMFEventCategoryPlaybackComplete)
		{
		iActiveScheduler = CActiveScheduler::Current();
		iActiveScheduler->Stop();
		}
	return KErrNone;
	}

TMMFEvent& CTestAsyncEventHandler::EventReceived()
	{
	return iEvent;
	}

void CTestDataPathEventMonitorObserver::HandleEvent(const TMMFEvent& aEvent)
	{
	iEvent = aEvent;
	CActiveScheduler* activeScheduler;
	activeScheduler = CActiveScheduler::Current();
	activeScheduler->Stop();
	}

TMMFEvent& CTestDataPathEventMonitorObserver::EventReceived()
	{
	return iEvent;
	}



//active timer object to create an asynchronous source event
CMMF_TSU_BASECL_MakeAsyncDataPathCall::CMMF_TSU_BASECL_MakeAsyncDataPathCall() : CTimer(EPriorityStandard)
	{
#ifdef _DEBUG
	TRAPD(err, CTimer::ConstructL());
	ASSERT(err == KErrNone);	// CTimer::ConstructL failed
#else
	TRAP_IGNORE(CTimer::ConstructL());
#endif
	}

CMMF_TSU_BASECL_MakeAsyncDataPathCall::~CMMF_TSU_BASECL_MakeAsyncDataPathCall()
	{
	Cancel();
	}


void CMMF_TSU_BASECL_MakeAsyncDataPathCall::CallPauseAfter(CMMFDataPath* aDataPath, TTimeIntervalMicroSeconds32 aTimeInterval)
	{
	iDataPath = aDataPath;
	iCallPause = ETrue;
	if (!IsAdded())
		CActiveScheduler::Add( this ) ;
	After(aTimeInterval);	
	}

void CMMF_TSU_BASECL_MakeAsyncDataPathCall::CallStopAfter(CMMFDataPath* aDataPath, TTimeIntervalMicroSeconds32 aTimeInterval)
	{
	iDataPath = aDataPath;
	iCallStop = ETrue;
	if (!IsAdded()) CActiveScheduler::Add( this ) ;
	After(aTimeInterval);	
	}

void CMMF_TSU_BASECL_MakeAsyncDataPathCall::CallPauseAfter(RMMFDataPathProxy& aDataPathProxy, TTimeIntervalMicroSeconds32 aTimeInterval)
	{
	iDataPathProxy = aDataPathProxy;
	iCallPauseProxy = ETrue;
	if (!IsAdded()) CActiveScheduler::Add( this ) ;
	After(aTimeInterval);	
	}

void CMMF_TSU_BASECL_MakeAsyncDataPathCall::CallStopAfter(RMMFDataPathProxy& aDataPathProxy, TTimeIntervalMicroSeconds32 aTimeInterval)
	{
	iDataPathProxy = aDataPathProxy;
	iCallStopProxy = ETrue;
	if (!IsAdded()) CActiveScheduler::Add( this ) ;
	After(aTimeInterval);	
	}

void CMMF_TSU_BASECL_MakeAsyncDataPathCall::RunL()
	{
	if (iCallPause)
		{
		iDataPath->Pause();
		iCallPause = EFalse;
		}
	if (iCallStop)
		{
		iDataPath->Stop();
		iCallStop = EFalse;
		}
	if (iCallPauseProxy)
		{
		iDataPathProxy.Pause();
		iCallPauseProxy = EFalse;
		}
	if (iCallStopProxy)
		{
		iDataPathProxy.Stop();
		iCallStopProxy = EFalse;
		}

	CActiveScheduler* activeScheduler;
	activeScheduler = CActiveScheduler::Current();
	activeScheduler->Stop();
	}


CTestStep_MMF_BASECL_DataPath::CTestStep_MMF_BASECL_DataPath()
	{
	}


CTestStep_MMF_BASECL_DataPath::~CTestStep_MMF_BASECL_DataPath()
	{
	}


/**
 * Pre-amble for datapath test step
 * Sets __MM_HEAP_MARK for memory leak detection
 * Sets Uids, Creates an active scheduler, the datapath async event handler and ensures the 
 * codec constructor test file is deleted
 */
TVerdict CTestStep_MMF_BASECL_DataPath::DoTestStepPreambleL()
{
 __MM_HEAP_MARK;
 TVerdict  verdict = EPass;

 iTestCodecUid.iUid = KMmfUidTSUBASECLTestCodec;
 iTestDataSourceUid.iUid = KMmfUidTSUBASECLTestSource;

 iTestDataSinkUid.iUid = KMmfUidTSUBASECLTestSink;

 iActiveScheduler = CActiveScheduler::Current();
 if (!iActiveScheduler) iActiveScheduler = new(ELeave)CActiveScheduler;
 CActiveScheduler::Install(iActiveScheduler);

 iTestAsyncEventHandler = new(ELeave)CTestAsyncEventHandler;

 //check that the test file generated by the test codec is always deleted at the start of each test
 RFs fsSession;
 User::LeaveIfError(fsSession.Connect());

 _LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
 TPtrC fileName(KTestFileName);

 RFile testFile; //handle to test file to verify that the test codec has been created
 TInt err = testFile.Open(fsSession,fileName,EFileWrite);
 testFile.Close();
 if (err == KErrNone)
	{ //file already exists so delete it
	err = fsSession.Delete(fileName);
	if (err != KErrNone) 
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not delete MMF_BASECL DP test codec file err = %d" ), err );
		}	 
	 }
 else if (err != KErrNotFound)
	{
	verdict = EInconclusive;
	}

 fsSession.Close();

 return verdict;

}


/**
 * Post-amble for datapath test step
 * deletes heap object created in pre-amble
 * Sets __MM_HEAP_MARKEND for memory leak detection
 * Final close for Ecom session
 */
TVerdict CTestStep_MMF_BASECL_DataPath::DoTestStepPostambleL()
	{
	delete iTestAsyncEventHandler;
	delete iActiveScheduler;

// xxx free ecom resources This should fix EFail on test 200
// this line is currently removed as the ECom fix is in mainline
// but not yet in a hurricane build
//	REComSession::FinalClose(); 

	__MM_HEAP_MARKEND;

	return TVerdict(EPass);
	}



CTestStep_MMF_BASECL_DataPathPlay::CTestStep_MMF_BASECL_DataPathPlay()
	{
	}


CTestStep_MMF_BASECL_DataPathPlay::~CTestStep_MMF_BASECL_DataPathPlay()
	{
	}


/**
 *
 * Procedure ised by datapath 'play' tests 
 * Sets datapath playing and waits for an event from the data path
 * and verifies if the event is an KMMFEventCategoryPlaybackComplete event with code KErrNone
 * 
 * @param aSrcInitDataStructure 
 * source initialisation data
 *
 * @param aSinkInitDataStructure 
 * sink initialisation data
 *
 * @param aUseNullCodec
 * sets src & sink to the same data type forcing a NULL codec
 *
 */
TVerdict CTestStep_MMF_BASECL_DataPathPlay::DoTestDataPathPlayL
 (
 TMMF_BASECL_TestSrcSinkConfig aSrcInitDataStruct,
 TMMF_BASECL_TestSrcSinkConfig aSinkInitDataStruct,
 TBool aUseNullCodec
 )
	{
	TVerdict verdict = EPass;
	CMMFDataPath* dataPath = NULL;
	MDataSource* testDataSource = NULL;
	MDataSink* testDataSink = NULL;
	CMMFFormatDecode* testDataFormatDecode = NULL;

	TMMF_BASECL_TestSrcSinkConfigPckg srcInitData(aSrcInitDataStruct);
	TMMF_BASECL_TestSrcSinkConfigPckg sinkInitData(aSinkInitDataStruct);


	TRAPD(err,testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcInitData));
	if (err==KErrNone)
		{
		TRAP(err,testDataFormatDecode = CMMFFormatDecode::NewL(KMmfUidTSUBASECLTestFormatDecodeUid, testDataSource));	
		}
	if (err==KErrNone)
		{
		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, sinkInitData));	
		}

	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
		delete testDataSource;
		delete testDataFormatDecode;
		delete testDataSink;
		return verdict;
		}

	//set the sink FourCC to that of source - to ensure a null codec data path is instantiated
	if (aUseNullCodec) 
		testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId()); 

	TRAP(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create datapath = %d" ), err );
		delete dataPath;
		delete testDataSource;
		delete testDataFormatDecode;
		delete testDataSink;
		return verdict;
		}

	TRAP(err, dataPath->AddDataSourceL(testDataFormatDecode));
	if (err==KErrNone)
		{
		TRAP(err, dataPath->AddDataSinkL(testDataSink));		
		}
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not add source and/or sink = %d" ), err );
		delete dataPath;
		delete testDataSource;
		delete testDataFormatDecode;
		delete testDataSink;
		return verdict;
		}

	TRAP(err, dataPath->PrimeL());
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
		delete dataPath;
		delete testDataSource;
		delete testDataFormatDecode;
		delete testDataSink;
		return verdict;
		}

	TRAP(err, dataPath->PlayL());
	if ((err) || 
		(dataPath->State() != CMMFDataPath::EPlaying) && 
		(dataPath->State() != CMMFDataPath::ERecording) &&
		(dataPath->State() != CMMFDataPath::EConverting))
	 {
		verdict = EFail;
		INFO_PRINTF2(_L("PlayL Failed error = %d" ), err );
		delete dataPath;
		delete testDataSource;
		delete testDataFormatDecode;
		delete testDataSink;
		return verdict;
	 }
	else
	 { //PlayL seemed OK but check source and sink have been primed correctly
	 iActiveScheduler->Start(); //start the active scheduler
	 }

	//check source and sink are both in the stop state
	CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	if (castedTestDataSource->State() != EStopped) verdict = EFail;
	CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	if (castedTestDataSink->State() != EStopped) verdict = EFail;

	//check that the play was stopped by an EOF
	TMMFEvent ResultOfPlay = iTestAsyncEventHandler->EventReceived();
	if ((ResultOfPlay.iEventType != KMMFEventCategoryPlaybackComplete)
		|| (ResultOfPlay.iErrorCode != KErrNone))
		{
		verdict = EFail;
		INFO_PRINTF2(_L("error during play = %d" ), ResultOfPlay.iErrorCode );
		}

	delete dataPath;
	delete testDataSource;
	delete testDataFormatDecode;
	delete testDataSink;

	return verdict;
	}


/**
 *
 * Procedure used by datapath proxy 'play' tests 
 * Sets datapath playing and waits for an event from the data path
 * and verifies if the event is an EOF event
 * 
 * @param aSrcInitDataStructure 
 * source initialisation data
 *
 * @param aSinkInitDataStructure 
 * sink initialisation data
 *
 * @param aUseNullCodec
 * sets src & sink to the same data type forcing a NULL codec
 *
 */
TVerdict CTestStep_MMF_BASECL_DataPathPlay::DoTestDataPathProxyPlayL
 (
 TMMF_BASECL_TestSrcSinkConfig aSrcInitDataStruct,
 TMMF_BASECL_TestSrcSinkConfig aSinkInitDataStruct,
 TBool aUseNullCodec
 )
	{
	TVerdict verdict = EPass;
	RMMFDataPathProxy dataPathProxy;
	MDataSource* testDataSource = NULL;
	MDataSink* testDataSink = NULL;
	CMMFFormatDecode* testDataFormatDecode = NULL;

	// increase this thread's priority, otherwise there's a 
	// good chance (especially under Cedar) that the conversion
	// will complete before this thread checks the state == EPlaying
	RThread thread;
	TThreadId threadId = thread.Id();
	TInt error = thread.Open(threadId);
	if (error != KErrNone)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not open thread, error = %d" ), error );
		}
	thread.SetPriority(EPriorityMore);
	thread.Close();
	


	TInt err = dataPathProxy.CreateSubThread();
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create dataPath subthread = %d" ), err );
		}
	if (!err)
		{
		TMMF_BASECL_TestSrcSinkConfigPckg srcInitData(aSrcInitDataStruct);
		TMMF_BASECL_TestSrcSinkConfigPckg sinkInitData(aSinkInitDataStruct);
		TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcInitData));
		if (err==KErrNone)
			{
			TRAP(err,testDataFormatDecode = CMMFFormatDecode::NewL(KMmfUidTSUBASECLTestFormatDecodeUid, testDataSource));		
			}


		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, sinkInitData));
		if (err)
			{
			verdict = EInconclusive;
			INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
			}
		}
	
	if (!err)
		{		
		//set the sink FourCC to that of source - to ensure a null codec data path is instantiated
		if (aUseNullCodec) 
			testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId());
	
		err = dataPathProxy.LoadDataPath();
		if (err) verdict = EInconclusive;
		err = dataPathProxy.AddDataSource(testDataFormatDecode);
		if (err) verdict = EInconclusive;
		err = dataPathProxy.AddDataSink(testDataSink);
		if (err) verdict = EInconclusive;

		if (err)
			{
			verdict = EInconclusive;
			INFO_PRINTF2(_L("Could not add src and/or sink = %d" ), err );
			}
		}

	if (!err)
		{
		CMMFDataPathEventMonitor* dataPathEventMonitor = NULL;
		CTestDataPathEventMonitorObserver* dataPathEventMonitorObserver = NULL;
		TRAP(err,dataPathEventMonitorObserver = new(ELeave)CTestDataPathEventMonitorObserver);
		if (err)
			{
			verdict = EInconclusive;
			INFO_PRINTF2(_L("Could not create dataPathEventMonitorObserver = %d" ), err );
			}
		TRAP(err,dataPathEventMonitor = CMMFDataPathEventMonitor::NewL(*dataPathEventMonitorObserver, dataPathProxy));	
		if (err)
			{
			verdict = EInconclusive;
			INFO_PRINTF2(_L("Could not create dataPathEventMonitor = %d" ), err );
			}

		err = dataPathProxy.Prime();
		if (err)
			{
			verdict = EFail;
			INFO_PRINTF2(_L("Prime Failed error = %d" ), err );
			}

		//note that if any of the above fails then Play will fail too
		err = dataPathProxy.Play();

		if (!err) 
			{
			TInt dataPathState;
			err = dataPathProxy.State(dataPathState);
			if (!err) 
				{ //check data path is in the playing state
				if ((dataPathState != CMMFDataPath::EPlaying) &&
					(dataPathState != CMMFDataPath::ERecording) &&
					(dataPathState != CMMFDataPath::EConverting))
					err = KErrGeneral;
				}
			}

		if (err)
			{
			verdict = EFail;
			INFO_PRINTF2(_L("Play Failed error = %d" ), err );
			}
		else
			{ //Prime & Play have gone OK so start active scheduler to initiate data transfer
			dataPathEventMonitor->Start();
			iActiveScheduler->Start();
			//Data path is now transferring data in another thread

			//When code gets to here an event has occured in the data path flow
			//and the active scheduler is stopped
			//check source and sink are both in the stop state
			CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
			if (castedTestDataSource->State() != EStopped) verdict = EFail;
			CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
			if (castedTestDataSink->State() != EStopped) verdict = EFail;

			//check that the play was stopped by an EOF
			TMMFEvent ResultOfPlay = dataPathEventMonitorObserver->EventReceived();
			if ((ResultOfPlay.iEventType != KMMFEventCategoryPlaybackComplete)
				|| (ResultOfPlay.iErrorCode != KErrNone))
				{
				verdict = EFail;
				INFO_PRINTF2(_L("error during play = %d" ), ResultOfPlay.iErrorCode );
				}
			}
		delete dataPathEventMonitor;
		delete dataPathEventMonitorObserver;
		}

	dataPathProxy.Close();
	delete testDataSource;
	delete testDataSink;
	delete testDataFormatDecode;
 
	return verdict;
	}



CTestStep_MMF_BASECL_U_0200::CTestStep_MMF_BASECL_U_0200()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0200-LP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0200::DoTestStepL( void )
/** 
 * This test verifies that the required ECOM plugins necessary
 * to run the datapath tests are on the registary and
 * can be instantiated without error.
 * with test data added client side and verified server side
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 CMMFCodec* testCodec = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;
 CMMFFormatEncode* testFormatEncode = NULL;
 REComSession ecomSession;
 RImplInfoPtrArray ecomPluginArray;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 0;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TBool resourceFound = EFalse;
 TInt ii; //for loop counter - put here to avoid arm4 compilation warning
 
 TUid codecInterfaceUid;
 codecInterfaceUid.iUid = KMmfUidPluginInterfaceCodec;

 TRAPD(err, ecomSession.OpenL());
 if (err)
	 {
	 INFO_PRINTF2(_L("Could not open ECOM session err = %d" ), err );
	 verdict = EInconclusive;
	 return verdict;
	 }


 TRAP(err, ecomSession.ListImplementationsL(codecInterfaceUid, ecomPluginArray));
 if (err)
	 {
	 INFO_PRINTF2(_L("Problem getting ECOM List Implementations err = %d" ), err );
	 }
 else
	 {
	 for ( ii = 0 ; ii < ecomPluginArray.Count() ; ii++ )
		{
		CImplementationInformation* testCodecInfo = ecomPluginArray[ii];
		if (testCodecInfo->ImplementationUid() == iTestCodecUid)
			{ //test codec has been found
			resourceFound = ETrue;		 
			}
		}
	 }
 
 if (!resourceFound)
	 {
	 verdict = EFail;
	 INFO_PRINTF1(_L("Test Codec ECOM Plugin Resource Not Found !"));
	 }
 else
	 {
	 INFO_PRINTF1(_L("Test Codec ECOM Plugin Resource Found OK"));
	 }
 ecomPluginArray.ResetAndDestroy();


 TUid dataSourceInterfaceUid;
 dataSourceInterfaceUid.iUid = KMmfUidPluginInterfaceDataSource ;
 resourceFound = EFalse;
 TRAP(err, ecomSession.ListImplementationsL(dataSourceInterfaceUid, ecomPluginArray));
 if (err)
	 {
	 INFO_PRINTF2(_L("Problem getting ECOM List Implementations err = %d" ), err );
	 }
 else
	 {
	 for ( ii = 0 ; ii < ecomPluginArray.Count() ; ii++ )
		{
		CImplementationInformation* testSourceInfo = ecomPluginArray[ii];
		if (testSourceInfo->ImplementationUid() == iTestDataSourceUid)
			{ //test source has been found
			resourceFound = ETrue;		 
			}
		}
	 }

 if (!resourceFound)
	 {
	 verdict = EFail;
	 INFO_PRINTF1(_L("Test DataSource ECOM Plugin Resource Found Not Found !"));
	 }
 else
	 {
	 INFO_PRINTF1(_L("Test DataSource ECOM Plugin Resource Found OK"));
	 }
 ecomPluginArray.ResetAndDestroy();


 TUid dataSinkInterfaceUid;
 dataSinkInterfaceUid.iUid = KMmfUidPluginInterfaceDataSink ;
 resourceFound = EFalse;
 TRAP(err, ecomSession.ListImplementationsL(dataSinkInterfaceUid, ecomPluginArray));
 if (err)
	 {
	 INFO_PRINTF2(_L("Problem getting ECOM List Implementations err = %d" ), err );
	 }
 else
	 {
	 for ( ii = 0 ; ii < ecomPluginArray.Count() ; ii++ )
		{
		CImplementationInformation* testSinkInfo = ecomPluginArray[ii];
		if (testSinkInfo->ImplementationUid() == iTestDataSinkUid)
			{ //test source has been found
			resourceFound = ETrue;		 
			}
		 }
	 }

 if (!resourceFound)
	 {
	 verdict = EFail;
	 INFO_PRINTF1(_L("Test DataSink ECOM Plugin Resource Not Found !"));
	 }
 else
	 {
	 INFO_PRINTF1(_L("Test DataSink ECOM Plugin Resource Found OK"));
	 }
 ecomPluginArray.ResetAndDestroy();

 TUid formatDecodeInterfaceUid;
 formatDecodeInterfaceUid.iUid = KMmfUidPluginInterfaceFormatDecode;
 TUid testFormatDecodeUid;
 testFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;
 resourceFound = EFalse;
 TRAP(err, ecomSession.ListImplementationsL(formatDecodeInterfaceUid, ecomPluginArray));
 if (err)
	 {
	 INFO_PRINTF2(_L("Problem getting ECOM List Implementations err = %d" ), err );
	 }
 else
	 {
	 for ( ii = 0 ; ii < ecomPluginArray.Count() ; ii++ )
		{
		CImplementationInformation* testFormatDecodeInfo = ecomPluginArray[ii];
		if (testFormatDecodeInfo->ImplementationUid() == testFormatDecodeUid)
			{ //test source has been found
			resourceFound = ETrue;		 
			}
		}
	 }

 if (!resourceFound)
	 {
	 verdict = EFail;
	 INFO_PRINTF1(_L("Test FormatDecode ECOM Plugin Resource Not Found !"));
	 }
 else
	 {
	 INFO_PRINTF1(_L("Test FormatDecode ECOM Plugin Resource Found OK"));
	 }
 ecomPluginArray.ResetAndDestroy();

 TUid formatEncodeInterfaceUid;
 formatEncodeInterfaceUid.iUid =  KMmfUidPluginInterfaceFormatEncode;
 TUid testFormatEncodeUid;
 testFormatEncodeUid.iUid = KMmfUidTSUBASECLTestFormatEncode;
 resourceFound = EFalse;
 TRAP(err, ecomSession.ListImplementationsL(formatEncodeInterfaceUid, ecomPluginArray));
 if (err)
	 {
	 INFO_PRINTF2(_L("Problem getting ECOM List Implementations err = %d" ), err );
	 }
 else
	 {
	 for ( ii = 0 ; ii < ecomPluginArray.Count() ; ii++ )
		{
		CImplementationInformation* testFormatEncodeInfo = ecomPluginArray[ii];
		if (testFormatEncodeInfo->ImplementationUid() == testFormatEncodeUid)
			{ //test source has been found
			resourceFound = ETrue;		 
			}
		}
	 }

 if (!resourceFound)
	 {
	 verdict = EFail;
	 INFO_PRINTF1(_L("Test FormatEncode ECOM Plugin Resource Not Found !"));
	 }
 else
	 {
	 INFO_PRINTF1(_L("Test FormatEncode ECOM Plugin Resource Found OK"));
	 }
 ecomPluginArray.ResetAndDestroy();


 ecomSession.Close();


 //make sure codec test file is deleted
 RFs fsSession;
 User::LeaveIfError(fsSession.Connect());

 _LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");

 TPtrC fileName(KTestFileName);

 RFile testFile; //handle to test file to verify that the test codec has been created
 err = testFile.Open(fsSession,fileName,EFileWrite);
 testFile.Close();
 if (err == KErrNone)
	{ //file already exists so delete it
	err = fsSession.Delete(fileName);
	if (err != KErrNone) 
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not delete MMF_BASECL DP test codec file err = %d" ), err );
		}	 
	 }
 else if (err != KErrNotFound)
	{
	verdict = EInconclusive;
	}
 //verify codec can be instantiated and that codec construct test file is present
 TRAP(err, testCodec = CMMFCodec::NewL(iTestCodecUid));
 if ((err) || (!testCodec))
	 {
	 verdict = EFail;
	 INFO_PRINTF2(_L("could not instantiate test codec %d" ), err );
	 }
 else INFO_PRINTF1(_L("test codec instantiated OK" ));
 err = testFile.Open(fsSession,fileName,EFileWrite);
 testFile.Close();
 if (err != KErrNone) verdict = EFail; //codec has not written the test file so can't assume codec was created
 else
	{ //codec created test file OK so delete it
	err = fsSession.Delete(fileName);
	if (err != KErrNone) 
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
		}
	}
 fsSession.Close();

 //verify source ,sink & formats can be instantiated
 TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
 if ((err) || (!testDataSource))
	 {
	 verdict = EFail;
	 INFO_PRINTF2(_L("could not instantiate test data source %d" ), err );
	 }
 else INFO_PRINTF1(_L("test data source instantiated OK" ));


 TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
 if ((err) || (!testDataSink))
	 {
	 verdict = EFail;
	 INFO_PRINTF2(_L("could not instantiate test data sink %d" ), err );
	 }
 else INFO_PRINTF1(_L("test data sink instantiated OK" ));


 TRAP(err, testFormatDecode = CMMFFormatDecode::NewL(testFormatDecodeUid, testDataSource));
 if ((err) || (!testFormatDecode))
	 {
	 verdict = EFail;
	 INFO_PRINTF2(_L("could not instantiate test format decode %d" ), err );
	 }
 else INFO_PRINTF1(_L("test format decode instantiated OK" ));


 TRAP(err, testFormatEncode = CMMFFormatEncode::NewL(testFormatEncodeUid, testDataSink));
 if ((err) || (!testFormatEncode))
	 {
	 verdict = EFail;
	 INFO_PRINTF2(_L("could not instantiate test format encode %d" ), err );
	 }
 else INFO_PRINTF1(_L("test format encode instantiated OK" ));
 

 delete testCodec;
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;
 delete testFormatEncode;

 User::After(1000000); //Ecom shutdown

 return verdict;
 }


CTestStep_MMF_BASECL_U_0201::CTestStep_MMF_BASECL_U_0201()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0201-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0201::DoTestStepL( void )
/** Verfiy CMMFDataPath creation 
 * Use case: N/A
 * @test Req. under test REQ172.7.23
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath;
 dataPath = NULL;

 TRAPD(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));

 if ((err)||(!dataPath))
	 {
	 INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	 verdict = EFail;
	 }

 delete dataPath;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0202::CTestStep_MMF_BASECL_U_0202()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0202-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0202::DoTestStepL( void )
/** Verfiy CMMFDataPath creation specifying the use of a specific codec
 * In order to verify the codec has been instantiated the 
 * test codec creates a file in its constructor
 * Use case: N/A
 * @test Req. under test REQ172.7.23
 */
 {
 TVerdict verdict = EPass;
 CMMFDataPath* dataPath;
 dataPath = NULL;

 TRAPD(err, dataPath = CMMFDataPath::NewL(iTestCodecUid, *iTestAsyncEventHandler));

 if ((err)||(!dataPath))
	 {
	 INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	 verdict = EFail;
	 }

 //the test codec should create a test file if it has been instantiated
 RFs fsSession;
 User::LeaveIfError(fsSession.Connect());
 _LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
 TPtrC fileName(KTestFileName);

 RFile testFile; //handle to test file to verify that the test codec has been created
 err = testFile.Open(fsSession,fileName,EFileWrite);
 testFile.Close();
 if (err != KErrNone) verdict = EFail; //codec has not written the test file so can't assume codec was created
 else
	{ //codec created test file OK so delete it
	err = fsSession.Delete(fileName);
	if (err != KErrNone) 
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
		}
	}
 fsSession.Close();
 delete dataPath;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0203::CTestStep_MMF_BASECL_U_0203()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0203-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0203::DoTestStepL( void )
/** 
 * CMMFDataPath instantiation test specifying a TMediaId
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 CMMFDataPath* dataPath;
 dataPath = NULL;

 TUid testMediaUid;
 testMediaUid.iUid = KMMFBASECLTestMediaId;
 TMediaId testMediaId(testMediaUid);

 TRAPD(err, dataPath = CMMFDataPath::NewL(testMediaId,*iTestAsyncEventHandler));

 if ((err)||(!dataPath)) 
	 {
	 INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	 verdict = EFail;
	 }

 delete dataPath;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0204::CTestStep_MMF_BASECL_U_0204()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0204-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0204::DoTestStepL( void )
/** 
 * CMMFDataPath instantiation test specifying a TMediaId and a codec uid
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 CMMFDataPath* dataPath = NULL;

 TUid testMediaUid;
 testMediaUid.iUid = KMMFBASECLTestMediaId;
 TMediaId testMediaId(testMediaUid);

 TRAPD(err, dataPath = CMMFDataPath::NewL(iTestCodecUid, testMediaId,*iTestAsyncEventHandler));

 if ((err)||(!dataPath))
	 {
	 INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	 verdict = EFail;
	 }

 //the test codec should create a test file if it has been instantiated
 RFs fsSession;
 User::LeaveIfError(fsSession.Connect());
 _LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
 TPtrC fileName(KTestFileName);

 RFile testFile; //handle to test file to verify that the test codec has been created
 err = testFile.Open(fsSession,fileName,EFileWrite);
 testFile.Close();
 if (err != KErrNone) verdict = EFail; //codec has not written the test file so can't assume codec was created
 else
	{ //codec created test file OK so delete it
	err = fsSession.Delete(fileName);
	if (err != KErrNone) 
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
		}
	}
 fsSession.Close();
 delete dataPath;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0205::CTestStep_MMF_BASECL_U_0205()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0205-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0205::DoTestStepL( void )
/** 
 * CMMFDataPath AddDataSource/Sink without using a supplied codec uid
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 0;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TRAPD(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
 if (!err) TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
	delete testDataSource;
	delete testDataSink;
	return verdict;
	}

 TRAP(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));
 if ((err)||(!dataPath))
	{
	INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 TRAP(err, dataPath->AddDataSourceL(testDataSource));

 if (err != KErrNone) 
	{
	verdict = EFail;
	INFO_PRINTF2(_L("Add Data Source Failed error = %d" ), err );
	}

 TRAP(err, dataPath->AddDataSinkL(testDataSink));

 if (err != KErrNone) 
	{
	verdict = EFail;
	INFO_PRINTF2(_L("Add Data Sink Failed error = %d" ), err );
	}
 
 //verify source and sink have been added
 //note the dataPath is the sink to the data source and visa versa ie the code below is correct!
 if (dataPath->SourceDataTypeCode(TMediaId()) != testDataSink->SinkDataTypeCode(TMediaId())) 
	 verdict = EFail;
 if (dataPath->SinkDataTypeCode(TMediaId()) != testDataSource->SourceDataTypeCode(TMediaId())) 
	 verdict = EFail;

 //verify that the correct codec has been instantiated
 RFs fsSession;
 err = fsSession.Connect();
 if (err != KErrNone) 
	{
	verdict = EFail;
	INFO_PRINTF2(_L("Failed to connect to file server error = %d" ), err );
	}

 RFile testFile; //handle to test file to verify that the test codec has been created
 _LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
 TPtrC fileName(KTestFileName);
 err = testFile.Open(fsSession,fileName,EFileWrite);
 testFile.Close();
 if (err != KErrNone) verdict = EFail; //codec has not written the test file so can't assume codec was created
 else
	{ //codec created test file OK so delete it
	err = fsSession.Delete(fileName);
	if (err != KErrNone) 
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
		}
	}
 fsSession.Close();

 delete dataPath;
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0206::CTestStep_MMF_BASECL_U_0206()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0206-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0206::DoTestStepL( void )
/** 
 * CMMFDataPath AddDataSource/Sink using a supplied codec Uid
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;


 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 0;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TRAPD(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
 if (!err) TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
	delete testDataSource;
	delete testDataSink;
	return verdict;
	}

 dataPath = CMMFDataPath::NewL(iTestCodecUid, *iTestAsyncEventHandler);
 if ((err)||(!dataPath))
	{
	INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 //delete codec test file - note that unlike the datapath instantiation 
 //where no codec Uid is specified the above instantiation should instantiate the codec before
 //the source and sink are added
 RFs fsSession;
 err = fsSession.Connect();
 if (err != KErrNone) 
	{
	verdict = EFail;
	INFO_PRINTF2(_L("Failed to connect to file server error = %d" ), err );
	}
 _LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
 TPtrC fileName(KTestFileName);
 err = fsSession.Delete(fileName);
 if (err != KErrNone) 
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
	}

 TRAP(err, dataPath->AddDataSourceL(testDataSource));

 if (err != KErrNone) 
	{
	verdict = EFail;
	INFO_PRINTF2(_L("Add Data Source Failed error = %d" ), err );
	}

 TRAP(err, dataPath->AddDataSinkL(testDataSink));

 if (err != KErrNone) 
	{
	verdict = EFail;
	INFO_PRINTF2(_L("Add Data Sink Failed error = %d" ), err );
	}
 
 //verify source and sink have been added
 //note the dataPath is the sink to the data source and visa versa ie the code below is correct!
 if (dataPath->SourceDataTypeCode(TMediaId()) != testDataSink->SinkDataTypeCode(TMediaId())) 
	 verdict = EFail;
 if (dataPath->SinkDataTypeCode(TMediaId()) != testDataSource->SourceDataTypeCode(TMediaId())) 
	 verdict = EFail;

 //verify no extra codec has been added
 RFile testFile; 
 err = testFile.Open(fsSession,fileName,EFileWrite);
 testFile.Close();
 if (err != KErrNotFound) verdict = EFail; //the codec test file should not be present

 fsSession.Close();

 delete dataPath;
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0207::CTestStep_MMF_BASECL_U_0207()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0207-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0207::DoTestStepL( void )
/** 
 * CMMFDataPath PrimeL using supplied codec Uid
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;


 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 0;
 srcSinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TRAPD(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
 if (!err) TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
	delete testDataSource;
	delete testDataSink;
	return verdict;
	}

 dataPath = CMMFDataPath::NewL(iTestCodecUid, *iTestAsyncEventHandler);
 if ((err)||(!dataPath))
	{
	INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}
 
 TRAP(err, dataPath->AddDataSinkL(testDataSink));
 if (!err) TRAP(err, dataPath->AddDataSourceL(testDataSource));
 if (err)
	{
	INFO_PRINTF2(_L("Problem adding src and/or sink err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 TRAP(err, dataPath->PrimeL());
 if (err)
	 {
	 verdict = EFail;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }
 else
	 { //PrimeL seemed OK but check source and sink have been primed correctly
	 CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	 if (castedTestDataSource->State() != EPrimed) verdict = EFail;
	 if (!castedTestDataSource->BufferCreated()) verdict = EFail;

	 CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	 if (castedTestDataSink->State() != EPrimed) verdict = EFail;
	 if (!castedTestDataSink->BufferCreated()) verdict = EFail;
	 }

 delete dataPath;
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0208::CTestStep_MMF_BASECL_U_0208()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0208-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0208::DoTestStepL( void )
/** 
 * CMMFDataPath NULL codec instantiation test
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 0;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TRAPD(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
 if (!err) TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
	delete testDataSource;
	delete testDataSink;
	return verdict;
	}

 //set the sink FourCC to that of source - to ensure a null codec data path is instantiated
 testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId()); 

 TRAP(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));
 if ((err)||(!dataPath))
	{
	INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 TRAP(err, dataPath->AddDataSourceL(testDataSource));

 if (err != KErrNone) 
	{
	verdict = EFail;
	INFO_PRINTF2(_L("Add Data Source Failed error = %d" ), err );
	}

 TRAP(err, dataPath->AddDataSinkL(testDataSink));

 if (err != KErrNone) 
	{
	verdict = EFail;
	INFO_PRINTF2(_L("Add Data Sink Failed error = %d" ), err );
	}
 
 //verify source and sink have been added and that the dp has the same 4CC codes for both
 //note the dataPath is the sink to the data source and visa versa ie the code below is correct!
 if (dataPath->SourceDataTypeCode(TMediaId()) != testDataSink->SinkDataTypeCode(TMediaId())) 
	 verdict = EFail;
 if (dataPath->SinkDataTypeCode(TMediaId()) != testDataSource->SourceDataTypeCode(TMediaId())) 
	 verdict = EFail;
 if (dataPath->SourceDataTypeCode(TMediaId()) != dataPath->SinkDataTypeCode(TMediaId()))
	 verdict = EFail;

 //verify that the test codec has not been instantiated by checking the test codec file
 RFs fsSession;
 err = fsSession.Connect();
 if (err != KErrNone) 
	{
	verdict = EFail;
	INFO_PRINTF2(_L("Failed to connect to file server error = %d" ), err );
	}
 _LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
 TPtrC fileName(KTestFileName);
 RFile testFile; //handle to test file to verify that the test codec has been created
 err = testFile.Open(fsSession,fileName,EFileWrite);
 testFile.Close();
 if (err == KErrNone) 
	{ //test file should not have been created as this implies thew test codec was instantiated
	verdict = EFail; 
	//delete test file
	err = fsSession.Delete(fileName);
	if (err != KErrNone) 
		{
		INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
		}
	}
 else if (err != KErrNotFound) 
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("There was a problem opening the codec test file = %d" ), err );
	}
	 
 fsSession.Close();

 delete dataPath;
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


 CTestStep_MMF_BASECL_U_0209::CTestStep_MMF_BASECL_U_0209()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0209-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0209::DoTestStepL( void )
/** 
 * CMMFDataPath PrimeL using NULL codec and DP owning both buffers
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 0;
 srcSinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TRAPD(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
 if (!err) TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
	delete testDataSource;
	delete testDataSink;
	return verdict;
	}

 //set the sink FourCC to that of source - to ensure a null codec data path is instantiated
 testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId()); 

 dataPath = CMMFDataPath::NewL(iTestCodecUid, *iTestAsyncEventHandler);
 if ((err)||(!dataPath))
	{
	INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 TRAP(err, dataPath->AddDataSourceL(testDataSource));
 if (!err) TRAP(err, dataPath->AddDataSinkL(testDataSink));
 if (err)
	{
	INFO_PRINTF2(_L("Problem adding src and/or sink err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 TRAP(err, dataPath->PrimeL());
 if ((err) || (dataPath->State() != CMMFDataPath::EPrimed))
	 {
	 verdict = EFail;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }
 else
	 { //PrimeL seemed OK but check source and sink have been primed correctly
	 //and that both a source and sink buffer have both been created
	 // note the sink buffer is subsequently deleted by the null codec but it is not possible to test for this
	 CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	 if (castedTestDataSource->State() != EPrimed) verdict = EFail;
	 if (!castedTestDataSource->BufferCreated()) verdict = EFail;

	 CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	 if (castedTestDataSink->State() != EPrimed) verdict = EFail;
	 if (!castedTestDataSink->BufferCreated()) verdict = EFail;
	 }

 delete dataPath;
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0210::CTestStep_MMF_BASECL_U_0210()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0210-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0210::DoTestStepL( void )
/** 
 * CMMFDataPath PrimeL using NULL codec and source owning its own buffer
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;

 TMMF_BASECL_TestSrcSinkConfig SourceInitDataStruct;
 SourceInitDataStruct.iSizeInFrames = 0;
 SourceInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 SourceInitDataStruct.iOwnsBuffer = ETrue;
 SourceInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfig SinkInitDataStruct;
 SinkInitDataStruct.iSizeInFrames = 0;
 SinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 SinkInitDataStruct.iOwnsBuffer = EFalse;
 SinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg SourceInitData(SourceInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg SinkInitData(SinkInitDataStruct);

 TRAPD(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, SourceInitData));
 if (!err) TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, SinkInitData));
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
	delete testDataSource;
	delete testDataSink;
	return verdict;
	}

 //set the sink FourCC to that of source - to ensure a null codec data path is instantiated
 testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId()); 

 TRAP(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));
 if ((err)||(!dataPath))
	{
	INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 TRAP(err, dataPath->AddDataSourceL(testDataSource));
 if (!err) TRAP(err, dataPath->AddDataSinkL(testDataSink));
 if (err)
	{
	INFO_PRINTF2(_L("Problem adding src and/or sink err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 TRAP(err, dataPath->PrimeL());
 if (err || (dataPath->State() != CMMFDataPath::EPrimed))
	 {
	 verdict = EFail;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }
 else
	 { //PrimeL seemed OK but check source and sink have been primed correctly
	 //and that both a source and sink buffer have both been created
	 // note the sink buffer is subsequently deleted by the null codec but it is not possible to test for this

	 CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	 if (castedTestDataSource->State() != EPrimed) verdict = EFail;
	 if (!castedTestDataSource->BufferCreated()) verdict = EFail;

	 CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	 if (castedTestDataSink->State() != EPrimed) verdict = EFail;
	 if (castedTestDataSink->BufferCreated()) verdict = EFail; //only source is created
	 }

 delete dataPath;
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0211::CTestStep_MMF_BASECL_U_0211()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0211-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0211::DoTestStepL( void )
/** 
 * CMMFDataPath PrimeL using NULL codec and sink owning its own buffer
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;

 TMMF_BASECL_TestSrcSinkConfig SourceInitDataStruct;
 SourceInitDataStruct.iSizeInFrames = 0;
 SourceInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 SourceInitDataStruct.iOwnsBuffer = EFalse;
 SourceInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfig SinkInitDataStruct;
 SinkInitDataStruct.iSizeInFrames = 0;
 SinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 SinkInitDataStruct.iOwnsBuffer = ETrue;
 SinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg SourceInitData(SourceInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg SinkInitData(SinkInitDataStruct);

 TRAPD(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, SourceInitData));
 if (!err) TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, SinkInitData));
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
	delete testDataSource;
	delete testDataSink;
	return verdict;
	}

 //set the sink FourCC to that of source - to ensure a null codec data path is instantiated
 testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId()); 

 TRAP(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));
 if ((err)||(!dataPath))
	{
	INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 TRAP(err, dataPath->AddDataSourceL(testDataSource));
 if (!err) TRAP(err, dataPath->AddDataSinkL(testDataSink));
 if (err)
	{
	INFO_PRINTF2(_L("Problem adding src and/or sink err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 TRAP(err, dataPath->PrimeL());
 if (err || (dataPath->State() != CMMFDataPath::EPrimed))
	 {
	 verdict = EFail;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }
 else
	 { //PrimeL seemed OK but check source and sink have been primed correctly
		//and that a source buffer has been created
		//Since we are using a Null codec and the source can create a buffer, there should be no sink buffer
	 CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	 if (castedTestDataSource->State() != EPrimed) verdict = EFail;
	 if (!castedTestDataSource->BufferCreated()) verdict = EFail;

	 CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	 if (castedTestDataSink->State() != EPrimed) verdict = EFail;
	 if (castedTestDataSink->BufferCreated()) verdict = EFail;
	 }

 delete dataPath;
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0212::CTestStep_MMF_BASECL_U_0212()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0212-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0212::DoTestStepL( void )
/** 
 * CMMFDataPath PrimeL using NULL codec and source and sink owning their own buffer
 * Note that the default buffer assignment behaviour when both the source and sink
 * owns the buffer is that the source buffer is assigned and not the sink buffer
 * and this is the assumption made by this test
 * This could change !
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;

 TMMF_BASECL_TestSrcSinkConfig SourceInitDataStruct;
 SourceInitDataStruct.iSizeInFrames = 0;
 SourceInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 SourceInitDataStruct.iOwnsBuffer = ETrue;
 SourceInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfig SinkInitDataStruct;
 SinkInitDataStruct.iSizeInFrames = 0;
 SinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 SinkInitDataStruct.iOwnsBuffer = ETrue;
 SinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg SourceInitData(SourceInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg SinkInitData(SinkInitDataStruct);

 TRAPD(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, SourceInitData));
 if (!err) TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, SinkInitData));
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
	delete testDataSource;
	delete testDataSink;
	return verdict;
	}

 //set the sink FourCC to that of source - to ensure a null codec data path is instantiated
 testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId()); 

 TRAP(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));
 if ((err)||(!dataPath))
	{
	INFO_PRINTF2(_L("Could not instantiate data path err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 TRAP(err, dataPath->AddDataSourceL(testDataSource));
 if (!err) TRAP(err, dataPath->AddDataSinkL(testDataSink));
 if (err)
	{
	INFO_PRINTF2(_L("Problem adding src and/or sink err = %d" ), err );
	verdict = EInconclusive;
	delete testDataSource;
	delete testDataSink;
	delete dataPath;
	return verdict;
	}

 TRAP(err, dataPath->PrimeL());
 if (err || (dataPath->State() != CMMFDataPath::EPrimed))
	 {
	 verdict = EFail;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }
 else
	 { //PrimeL seemed OK but check source and sink have been primed correctly
		//and that a source buffer has been created
		//Since we are using a Null codec and the source can create a buffer, there should be no sink buffer
	 CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	 if (castedTestDataSource->State() != EPrimed) verdict = EFail;
	 if (!castedTestDataSource->BufferCreated()) verdict = EFail; //should default to sink ie no src buffer

	 CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	 if (castedTestDataSink->State() != EPrimed) verdict = EFail;
	 if (castedTestDataSink->BufferCreated()) verdict = EFail;
	 }

 delete dataPath;
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0213::CTestStep_MMF_BASECL_U_0213()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0213-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0213::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using syncronous src/sink and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 1;
 srcSinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 return DoTestDataPathPlayL(srcSinkInitDataStruct, srcSinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0214::CTestStep_MMF_BASECL_U_0214()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0214-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0214::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous src  and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = EFalse;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0215::CTestStep_MMF_BASECL_U_0215()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0215-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0215::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous sink  and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0216::CTestStep_MMF_BASECL_U_0216()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0216-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0216::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink  and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0217::CTestStep_MMF_BASECL_U_0217()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0217-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0217::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, src owning its buffer
 * and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0218::CTestStep_MMF_BASECL_U_0218()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0218-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0218::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0219::CTestStep_MMF_BASECL_U_0219()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0219-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0219::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0220::CTestStep_MMF_BASECL_U_0220()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0220-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0220::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous src/sink and EProcessComplete NULL codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0221::CTestStep_MMF_BASECL_U_0221()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0221-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0221::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, src owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0222::CTestStep_MMF_BASECL_U_0222()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0222-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0222::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0223::CTestStep_MMF_BASECL_U_0223()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0223-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0223::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0224::CTestStep_MMF_BASECL_U_0224()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0224-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0224::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, src owning its buffer
 * and EProcessInComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = 8;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0225::CTestStep_MMF_BASECL_U_0225()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0225-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0225::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * and EProcessInComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = 8;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0226::CTestStep_MMF_BASECL_U_0226()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0226-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0226::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, src owning its buffer
 * and EDstNotFilled codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 2; //frames are only half size
 srcInitDataStruct.iCreatedBufferSize = 8;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0227::CTestStep_MMF_BASECL_U_0227()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0227-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0227::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * and EDstNotFilled codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 2; //frames are only half size
 srcInitDataStruct.iCreatedBufferSize = 8;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0228::CTestStep_MMF_BASECL_U_0228()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0228-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0228::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using syncronous src/sink and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4;
 srcSinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 return DoTestDataPathPlayL(srcSinkInitDataStruct, srcSinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0229::CTestStep_MMF_BASECL_U_0229()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0229-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0229::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous src  and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = EFalse;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0230::CTestStep_MMF_BASECL_U_0230()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0230-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0230::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous sink  and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0231::CTestStep_MMF_BASECL_U_0231()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0231-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0231::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink  and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0232::CTestStep_MMF_BASECL_U_0232()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0232-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0232::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, src owning its buffer
 * and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0233::CTestStep_MMF_BASECL_U_0233()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0233-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0233::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0234::CTestStep_MMF_BASECL_U_0234()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0234-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0234::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }

//note if using a codec both source and sink can't own the same buffer??
//as owning it implies that the buffer must be used by both source and sink
//which is impossible?? -with null codec only??

CTestStep_MMF_BASECL_U_0235::CTestStep_MMF_BASECL_U_0235()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0235-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0235::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous src/sink and EProcessComplete NULL codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0236::CTestStep_MMF_BASECL_U_0236()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0236-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0236::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, src owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0237::CTestStep_MMF_BASECL_U_0237()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0237-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0237::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0238::CTestStep_MMF_BASECL_U_0238()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0238-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0238::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0239::CTestStep_MMF_BASECL_U_0239()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0239-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0239::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, src owning its buffer
 * and EProcessInComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = 8;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0240::CTestStep_MMF_BASECL_U_0240()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0240-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0240::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * and EProcessInComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = 8;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0241::CTestStep_MMF_BASECL_U_0241()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0241-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0241::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, src owning its buffer
 * and EDstNotFilled codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = 8;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0242::CTestStep_MMF_BASECL_U_0242()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0242-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0242::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * and EDstNotFilled codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = 8;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0243::CTestStep_MMF_BASECL_U_0243()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0243-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0243::DoTestStepL( void )
/** 
 * CMMFDataPath PlayL using asyncronous source & sink, sink owning its buffer
 * with mismatched src/sink buffer sizes such that the source buffer does not
 * divide evenly into the sink - causes alternating EDstNotFilled/EProcessIncomplete
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = 30;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0244::CTestStep_MMF_BASECL_U_0244()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0244-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0244::DoTestStepL( void )
/** 
 * CMMFDataPath Pause 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;
 CMMF_TSU_BASECL_MakeAsyncDataPathCall* asyncDataPathCaller= NULL;

 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;
 
 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 8; //just an arbitary size
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;  //sink does frame timing so make it async
 sinkInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfigPckg srcInitData(srcInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg sinkInitData(sinkInitDataStruct);

 testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcInitData);
 testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, sinkInitData);
 testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource);
 
 dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler);
 asyncDataPathCaller = new(ELeave)CMMF_TSU_BASECL_MakeAsyncDataPathCall;

 TRAPD(err, dataPath->AddDataSourceL(testFormatDecode));
 if (!err) TRAP(err, dataPath->AddDataSinkL(testDataSink));
 if (!err) TRAP(err, dataPath->PrimeL());

 TRAP(err, dataPath->PlayL()); //if any of the above fail this will also fail

 if (err)
	 {
	 verdict = EInconclusive;
	 INFO_PRINTF2(_L("PlayL Failed error = %d" ), err );
	 }
 else
	 { //PlayL seemed OK so cause a Pause after a period of time
	 asyncDataPathCaller->CallPauseAfter(dataPath, KMMFPauseAfterDelay); //alow enough time for 4 frames but not 5
	 iActiveScheduler->Start(); //start the active scheduler
	 }
 
 if (!err)
	{
	//datapath should be in the primed state when paused
	INFO_PRINTF1(_L("Return from Active scheduler OK - Should now be Paused"));
	if (dataPath->State() != CMMFDataPath::EPrimed) verdict = EFail;

	//check data source and data sink are stopped.
	//NB: the data path never Pauses sinks or sources; this is because initial the DevSound
	//implementations of Pause are similar to Stop.
	CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	if (castedTestDataSource->State() != EPaused) verdict = EFail;
	CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	if (castedTestDataSink->State() != EStopped) verdict = EFail;

	//check that the current source frame is to within +/- one frame of the delay
	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());
	TUint expectedCurrentFrame = KMMFPauseAfterDelay/I64LOW(frameTimeInterval.Int64()); //should be to within +/- 1 of this value
	TUint actualCurrentFrame = castedTestDataSource->CurrentFrame(); 
	if ((actualCurrentFrame < expectedCurrentFrame-1) || (actualCurrentFrame > expectedCurrentFrame+1))
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Actual frm differs from expected frm - act frame = %d" ), actualCurrentFrame );
		}

	//now check that Play can be resumed after pause
	TRAP(err, dataPath->PlayL());

	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("PlayL Failed after resume from Pause error = %d" ), err );
		}
	else
		{ //PlayL seemed OK so resume data transfer
		iActiveScheduler->Start(); //restart the active scheduler
		}
	if (!err)
		{
		//check source and sink are both in the stop state
		if (castedTestDataSource->State() != EStopped)
			verdict = EFail;
		if (castedTestDataSink->State() != EStopped)
			verdict = EFail;

		//check that the play was stopped by an EOF
		TMMFEvent ResultOfPlay = iTestAsyncEventHandler->EventReceived();
		if ((ResultOfPlay.iEventType != KMMFEventCategoryPlaybackComplete)
			 || (ResultOfPlay.iErrorCode != KErrNone))
			{
			verdict = EFail;
			INFO_PRINTF2(_L("error during play = %d" ), ResultOfPlay.iErrorCode );
			}

		//check that the play resumed from where it left off in the paused state - (Play resets source first frame)
		if (castedTestDataSource->FirstFrame() != actualCurrentFrame+1) 
			{
			INFO_PRINTF1(_L("Play did not resume from previous position" ));
			verdict = EFail;
			}
		}
	 }

 delete asyncDataPathCaller;
 delete dataPath;
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;
 
 return verdict;
 }


 CTestStep_MMF_BASECL_U_0245::CTestStep_MMF_BASECL_U_0245()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0245-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0245::DoTestStepL( void )
/** 
 * CMMFDataPath Stop 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;
 CMMF_TSU_BASECL_MakeAsyncDataPathCall* asyncDataPathCaller= NULL;

 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;
 

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 8; //just use an arbitary size
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue; //sink does frame timing so make it async

 TMMF_BASECL_TestSrcSinkConfigPckg srcInitData(srcInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg sinkInitData(sinkInitDataStruct);

 testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcInitData);
 testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, sinkInitData);
 testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource);
 
 dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler);
 asyncDataPathCaller = new(ELeave)CMMF_TSU_BASECL_MakeAsyncDataPathCall;

 TRAPD(err,dataPath->AddDataSourceL(testFormatDecode));
 if (!err) TRAP(err, dataPath->AddDataSinkL(testDataSink));
 if (!err) TRAP(err, dataPath->PrimeL());

 if (!err) TRAP(err, dataPath->PlayL()); //if any of the bove fails so will this

 if (err)
	 {
	 verdict = EInconclusive;
	 INFO_PRINTF2(_L("PlayL Failed error = %d" ), err );
	 }
 else
	 { //PlayL seemed OK so cause a Stop after a period of time
	 asyncDataPathCaller->CallStopAfter(dataPath, KMMFPauseAfterDelay); //alow enough time for 4 frames but not 5
	 iActiveScheduler->Start(); //start the active scheduler
	 }

 if (!err)
	{
	//check data path is stopped
	INFO_PRINTF1(_L("Return from Active scheduler OK - Should now be Stopped"));
	if (dataPath->State() != CMMFDataPath::EStopped) verdict = EFail;

	//check data source and data sink are stopped.
	CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	if (castedTestDataSource->State() != EStopped) verdict = EFail;
	CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	if (castedTestDataSink->State() != EStopped) verdict = EFail;

	//check that the current source frame is to within +/- one frame of the delay
	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());
	TUint expectedCurrentFrame = KMMFPauseAfterDelay/I64LOW(frameTimeInterval.Int64()); //should be to within +/- 1 of this value
	TUint actualCurrentFrame = castedTestDataSource->CurrentFrame(); 
	if ((actualCurrentFrame < expectedCurrentFrame-1) || (actualCurrentFrame > expectedCurrentFrame+1))
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Actual frm differs from expected frm - act frame = %d" ), actualCurrentFrame );
		}

	//check no errors occurred during play
	TMMFEvent ResultOfPlay = iTestAsyncEventHandler->EventReceived();
	if ((ResultOfPlay.iEventType.iUid != 0)
		|| (ResultOfPlay.iErrorCode != KErrNone))
		{
		verdict = EFail;
		INFO_PRINTF2(_L("error during play = %d" ), ResultOfPlay.iErrorCode );
		}
	 }

 delete asyncDataPathCaller;
 delete dataPath;
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;
 
 return verdict;
 }


CTestStep_MMF_BASECL_U_0246::CTestStep_MMF_BASECL_U_0246()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0246-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0246::DoTestStepL( void )
/** 
 * CMMFDataPath Reset 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfigPckg srcInitData(srcInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg sinkInitData(sinkInitDataStruct);

 testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcInitData);
 testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, sinkInitData);
 
 dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler);
 
 TRAPD(err, dataPath->AddDataSourceL(testDataSource));
 if (!err) TRAP(err, dataPath->AddDataSinkL(testDataSink));
 if (!err) TRAP(err, dataPath->PrimeL());
 if (err)
	 {
	 verdict = EInconclusive;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }
 else
	{
	TRAPD(err, dataPath->ResetL());

	if ((err) || (dataPath->State() != CMMFDataPath::EStopped))
		{
		verdict = EFail;
		INFO_PRINTF2(_L("ResetL Failed error = %d" ), err );
		}
	else
		{ //check source & sink logged off
		CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
		if (castedTestDataSource->State() != ELoggedOff) verdict = EFail;
		 CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
		if (castedTestDataSink->State() != ELoggedOff) verdict = EFail;
		 }
	}

 delete dataPath;
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


//247 - 259 insert any other Play, Pause, Stop tests here

CTestStep_MMF_BASECL_U_0260::CTestStep_MMF_BASECL_U_0260()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0260-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0260::DoTestStepL( void )
/** 
 * CMMFDataPath Position()/SetPosition() using non format source & sink, sink 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;

// TUid testDataFormatDecodeUid;
// testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;	// EABI warning removal - variable was set but never used

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData);
 testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData);

 dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler);

 dataPath->AddDataSourceL(testDataSource);
 dataPath->AddDataSinkL(testDataSink);

 TTimeIntervalMicroSeconds position;
 TTimeIntervalMicroSeconds testPosition(300000);

 position = dataPath->Position();
 if (position != TTimeIntervalMicroSeconds(0)) verdict = EFail;

 TRAPD(err,dataPath->PrimeL()); //if any of the above failed this would fail too
 if (err)
	 {
	 verdict = EInconclusive;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }

 if (!err)
	{
	position = dataPath->Position(); //check position again after Prime
	if (position != TTimeIntervalMicroSeconds(0)) verdict = EFail;

	TRAPD(err, dataPath->SetPositionL(testPosition));
	if (err != KErrNotSupported)  //it is not possible to set the position on non format src/sink
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Failed due to set position on non format src/sink = %d" ), err );
		}

	position = dataPath->Position();
	if (position != TTimeIntervalMicroSeconds(0)) verdict = EFail;
	}

 delete dataPath;
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0261::CTestStep_MMF_BASECL_U_0261()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0261-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0261::DoTestStepL( void )
/** 
 * CMMFDataPath Position()/SetPosition() using format source & non format sink 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;

 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData);
 testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData);
 TRAPD(err, testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));

 if (err != KErrNone) 
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Failed to load test format decode error = %d" ), err );
	}

 dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler);

 dataPath->AddDataSourceL(testFormatDecode);
 dataPath->AddDataSinkL(testDataSink);

 TTimeIntervalMicroSeconds position;
 TTimeIntervalMicroSeconds testPosition(KMMFTestDataPathPosition);

 position = dataPath->Position();
 if (position != TTimeIntervalMicroSeconds(0)) verdict = EFail;

 TRAP(err,dataPath->PrimeL()); //if any of the above fails so will this
 if (err)
	 {
	 verdict = EInconclusive;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }

 if (!err)
	{
	position = dataPath->Position(); //check position again after Prime
	if (position != TTimeIntervalMicroSeconds(0)) verdict = EFail;

	TRAPD(error, dataPath->SetPositionL(testPosition));
	 if (error != KErrNone) 
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Failed to set position = %d" ), err );
		}

	position = dataPath->Position();
	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());

	//note position can only be set to a granularity of the formats frametime interval
	if (position <= TTimeIntervalMicroSeconds(testPosition.Int64() - frameTimeInterval.Int64())) 
																			verdict = EFail;
	if (position >= TTimeIntervalMicroSeconds(testPosition.Int64() + frameTimeInterval.Int64())) 
																			verdict = EFail;
	}

 delete dataPath;
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0262::CTestStep_MMF_BASECL_U_0262()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0262-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0262::DoTestStepL( void )
/** 
 * CMMFDataPath Position()/SetPosition() using non format source & format sink 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatEncode* testFormatEncode = NULL;

 TUid testDataFormatEncodeUid;
 testDataFormatEncodeUid.iUid = KMmfUidTSUBASECLTestFormatEncode;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4; //just an arbitary size
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData);
 testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData);
 TRAPD(err, testFormatEncode = CMMFFormatEncode::NewL(testDataFormatEncodeUid, testDataSink));

 if (err != KErrNone) 
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Failed to load test format encode error = %d" ), err );
	}

 dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler);

 dataPath->AddDataSourceL(testDataSource);
 dataPath->AddDataSinkL(testFormatEncode);

 TTimeIntervalMicroSeconds position;
 TTimeIntervalMicroSeconds testPosition(KMMFTestDataPathPosition);

 position = dataPath->Position();
 if (position != TTimeIntervalMicroSeconds(0)) verdict = EFail;

 TRAP(err,dataPath->PrimeL()); //if any of the above fails so will this
 if (err)
	 {
	 verdict = EInconclusive;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }

 if(!err)
	{
	position = dataPath->Position(); //check position again after Prime
	if (position != TTimeIntervalMicroSeconds(0)) verdict = EFail;

	TRAP(err, dataPath->SetPositionL(testPosition));
	if (err != KErrNone) 
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Failed to set position = %d" ), err );
		}

	position = dataPath->Position();
	TTimeIntervalMicroSeconds frameTimeInterval = testFormatEncode->FrameTimeInterval(TMediaId());

	//note position can only be set to a granularity of the formats frametime interval
	if (position <= TTimeIntervalMicroSeconds(testPosition.Int64() - frameTimeInterval.Int64())) 
																			verdict = EFail;
	if (position >= TTimeIntervalMicroSeconds(testPosition.Int64() + frameTimeInterval.Int64())) 
																			verdict = EFail;
	}

 delete dataPath;
 delete testDataSource;
 delete testDataSink;
 delete testFormatEncode;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0263::CTestStep_MMF_BASECL_U_0263()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0263-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0263::DoTestStepL( void )
/** 
 * CMMFDataPath Position()/SetPosition() using format source & format sink 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;
 CMMFFormatEncode* testFormatEncode = NULL;

 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;
 TUid testDataFormatEncodeUid;
 testDataFormatEncodeUid.iUid = KMmfUidTSUBASECLTestFormatEncode;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4; //just an arbitary size
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData);
 testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData);
 TRAPD(err, testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));

 if (err != KErrNone) 
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Failed to load test format decode error = %d" ), err );
	}

 TRAP(err, testFormatEncode = CMMFFormatEncode::NewL(testDataFormatEncodeUid, testDataSink));

 if (err != KErrNone) 
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Failed to load test format encode error = %d" ), err );
	}

 dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler);

 dataPath->AddDataSourceL(testFormatDecode);
 dataPath->AddDataSinkL(testFormatEncode);

 TTimeIntervalMicroSeconds position;
 TTimeIntervalMicroSeconds testPosition(KMMFTestDataPathPosition);

 position = dataPath->Position();
 if (position != TTimeIntervalMicroSeconds(0)) verdict = EFail;

 TRAP(err,dataPath->PrimeL()); //if any of the above fails so will this
 if (err)
	 {
	 verdict = EInconclusive;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }

 if(!err)
	{
	position = dataPath->Position(); //check position again after Prime
	if (position != TTimeIntervalMicroSeconds(0)) verdict = EFail;

	TRAP(err, dataPath->SetPositionL(testPosition));
	if (err != KErrNone) 
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Failed to set position = %d" ), err );
		}

	position = dataPath->Position();

	//default to decode frame time interval
	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());

	//note position can only be set to a granularity of the formats frametime interval
	if (position <= TTimeIntervalMicroSeconds(testPosition.Int64() - frameTimeInterval.Int64())) 
																			verdict = EFail;
	if (position >= TTimeIntervalMicroSeconds(testPosition.Int64() + frameTimeInterval.Int64())) 
																			verdict = EFail;
	}

 delete dataPath;
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;
 delete testFormatEncode;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0264::CTestStep_MMF_BASECL_U_0264()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0264-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0264::DoTestStepL( void )
/** 
 * CMMFDataPath Position()/SetPosition() using format source positioning beyond the end of source 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;

 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4; //just an arbitary size
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TRAPD(err,testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
 if (!err) TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
 if (!err) TRAP(err, testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));
 if (err != KErrNone) 
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Failed to load test format decode error = %d" ), err );
	}

 TRAP(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));

 if (!err) TRAP(err, dataPath->AddDataSourceL(testFormatDecode));
 if (!err) TRAP(err, dataPath->AddDataSinkL(testDataSink));

 TTimeIntervalMicroSeconds position;
 TTimeIntervalMicroSeconds testPosition;
 TTimeIntervalMicroSeconds duration;

 if (!err) TRAP(err,dataPath->PrimeL()); //if any of the above fails so will this
 if (err)
	 {
	 verdict = EInconclusive;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }

 if (!err)
	{
	duration = testFormatDecode->Duration(TMediaId());
	testPosition = TTimeIntervalMicroSeconds(duration.Int64()+1); //position 1 uS beyond EOF

	TRAP(err, dataPath->SetPositionL(testPosition));
	if (err != KErrNone) 
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Set Position error = %d" ), err );
		}

	position = dataPath->Position();
 
	//position should now be at the end of the format
	if (position != duration) verdict = EFail;
	}

 delete dataPath;
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;
 return verdict;
 }


CTestStep_MMF_BASECL_U_0265::CTestStep_MMF_BASECL_U_0265()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0265-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0265::DoTestStepL( void )
/** 
 * CMMFDataPath Position()/SetPosition() using format sink positioning beyond the end of source 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatEncode* testFormatEncode = NULL;

 TUid testDataFormatEncodeUid;
 testDataFormatEncodeUid.iUid = KMmfUidTSUBASECLTestFormatEncode;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4; //just an arbitary size
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TRAPD(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
 if (!err) TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
 if (!err) TRAP(err, testFormatEncode = CMMFFormatEncode::NewL(testDataFormatEncodeUid, testDataSink));
 if (err != KErrNone) 
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Failed to load test format decode error = %d" ), err );
	}

 TRAP(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));

 if (!err) TRAP(err, dataPath->AddDataSourceL(testDataSource));
 if (!err) TRAP(err, dataPath->AddDataSinkL(testFormatEncode));

 TTimeIntervalMicroSeconds position;
 TTimeIntervalMicroSeconds testPosition;
 TTimeIntervalMicroSeconds duration;

 if (!err) TRAP(err,dataPath->PrimeL()); //if any of the above fails so will this
 if (err)
	 {
	 verdict = EInconclusive;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }

 if (!err)
	{
	duration = testFormatEncode->Duration(TMediaId());
	testPosition = TTimeIntervalMicroSeconds(duration.Int64()+1); //position 1 uS beyond EOF

	TRAP(err, dataPath->SetPositionL(testPosition));
	if (err != KErrNone) 
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Set Position error = %d" ), err );
		}

	position = dataPath->Position();
 
	//position should now be at the end of the format
	if (position != duration) verdict = EFail;
	}

 delete dataPath;
 delete testDataSource;
 delete testDataSink;
 delete testFormatEncode;
 return verdict;
 }


CTestStep_MMF_BASECL_U_0266::CTestStep_MMF_BASECL_U_0266()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0266-HP");
 }

TVerdict CTestStep_MMF_BASECL_U_0266::DoTestStepL( void )
/** 
 * CMMFDataPath SetPlayWindow() 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;
 
 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;
 

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = KMMFNumFramesPlayWindowTest; //just use an arbitary size but more than 4 to allow play window
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfigPckg srcInitData(srcInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg sinkInitData(sinkInitDataStruct);

 TRAPD(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcInitData));
 TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, sinkInitData));
 TRAP(err,testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
	delete testDataSource;
	delete testDataSink;
	return verdict;
	}

 TRAP(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));

 if (!err) TRAP(err, dataPath->AddDataSourceL(testFormatDecode));
 if (!err) TRAP(err, dataPath->AddDataSinkL(testDataSink));
 if (!err) TRAP(err,dataPath->PrimeL()); //if any of the above fails so will this
 if (err)
	 {
	 verdict = EInconclusive;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }

 if (!err)
	{
	TRAP(err,dataPath->SetPlayWindowL(TTimeIntervalMicroSeconds(KMMFStartOfPlayWindow), TTimeIntervalMicroSeconds(KMMFEndOfPlayWindow)));
	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Error setting Play window= %d" ), err );
		}

	TRAP(err, dataPath->PlayL());

	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("PlayL Failed after Set Play Window error = %d" ), err );
		}
	else
		{ //PlayL seemed OK but check source and sink have been primed correctly
		iActiveScheduler->Start(); //start the active scheduler
		}
	 }

 if (verdict == EPass)
	{
	//check source and sink are both in the stop state
	CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	if (castedTestDataSource->State() != EStopped) verdict = EFail;
	CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	if (castedTestDataSink->State() != EStopped) verdict = EFail;

	//check that the play was stopped by an EOF
	TMMFEvent ResultOfPlay = iTestAsyncEventHandler->EventReceived();
	if ((ResultOfPlay.iEventType != KMMFEventCategoryPlaybackComplete)
		 || (ResultOfPlay.iErrorCode != KErrNone))
		{
		verdict = EFail;
		INFO_PRINTF2(_L("error during play = %d" ), ResultOfPlay.iErrorCode );
		}

	//check that the first and last frames match that set by the PlayWindow
	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());
	if (frameTimeInterval <= TTimeIntervalMicroSeconds(0)) 
		{
		if (verdict == EPass) verdict = EInconclusive;
		INFO_PRINTF2(_L("Bad format frametime interval = %d" ), err );
		}
	else
		{
		/*
		time	frame
		0		1
		100000	2	play starts here - 1st frame == 2
		200000	3
		300000	4	play ends at end of this frame, and we never ask for frame 4.
		400000	5
		*/

		TUint expectedStartFrameNumber = (KMMFStartOfPlayWindow/I64LOW(frameTimeInterval.Int64())) + 1; //+1 because frames start at 1
		TUint expectedEndFrameNumber = (KMMFEndOfPlayWindow/I64LOW(frameTimeInterval.Int64()));
		if (expectedStartFrameNumber != castedTestDataSource->FirstFrame()) verdict = EFail;
		if (expectedEndFrameNumber != castedTestDataSource->CurrentFrame()) verdict = EFail;
		}
	 }

 delete dataPath;
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0267::CTestStep_MMF_BASECL_U_0267()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0267-HP");
 }

TVerdict CTestStep_MMF_BASECL_U_0267::DoTestStepL( void )
/** 
 * CMMFDataPath ClearPlayWindow() 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 
 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;
 
 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;
 

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = KMMFNumFramesPlayWindowTest; //just use an arbitary size but more than 4 to allow play window
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfigPckg srcInitData(srcInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg sinkInitData(sinkInitDataStruct);

 TRAPD(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcInitData));
 if (!err) TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, sinkInitData));
 if (!err) TRAP(err, testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
	delete testDataSource;
	delete testDataSink;
	delete testFormatDecode;
	return verdict;
	}

 TRAP(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));

 if (!err) TRAP(err, dataPath->AddDataSourceL(testFormatDecode));
 if (!err) TRAP(err, dataPath->AddDataSinkL(testDataSink));
 if (!err) TRAP(err,dataPath->PrimeL()); //if any of the above fails so will this
 if (err)
	 {
	 verdict = EInconclusive;
	 INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
	 }

 if (!err)
	{
	dataPath->SetPlayWindowL(TTimeIntervalMicroSeconds(KMMFStartOfPlayWindow), TTimeIntervalMicroSeconds(KMMFEndOfPlayWindow));
	TRAPD(err, dataPath->PlayL());
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("PlayL Failed error = %d" ), err );
		}
	else
		{ //PlayL seemed OK but check source and sink have been primed correctly
		iActiveScheduler->Start(); //start the active scheduler
		}
	 }

 if (verdict == EPass)
	{
	//check source and sink are both in the stop state
	CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	if (castedTestDataSource->State() != EStopped) verdict = EInconclusive;
	CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	if (castedTestDataSink->State() != EStopped) verdict = EInconclusive;

	//check that the play was stopped by an EOF
	TMMFEvent ResultOfPlay = iTestAsyncEventHandler->EventReceived();
	if ((ResultOfPlay.iEventType != KMMFEventCategoryPlaybackComplete)
		|| (ResultOfPlay.iErrorCode != KErrNone))
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("error during play = %d" ), ResultOfPlay.iErrorCode );
		}

	//check that the first and last frames match that set by the PlayWindow
	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());
	if (frameTimeInterval <= TTimeIntervalMicroSeconds(0)) 
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Bad format frametime interval = %d" ), err );
		}
	else
		{
		TUint expectedStartFrameNumber = (KMMFStartOfPlayWindow/I64LOW(frameTimeInterval.Int64())) + 1; //+1 because frames start at 1
		TUint expectedEndFrameNumber = (KMMFEndOfPlayWindow/I64LOW(frameTimeInterval.Int64()));
		if (expectedStartFrameNumber != castedTestDataSource->FirstFrame()) verdict = EFail;
		if (expectedEndFrameNumber != castedTestDataSource->CurrentFrame()) verdict = EFail;
		}

	//clear the play window
	TRAP(err, dataPath->ClearPlayWindowL());
	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Clear play Window failed error = %d" ), err );
		}

	//check that the position has now been set to the start
	if (dataPath->Position() != TTimeIntervalMicroSeconds(0)) verdict = EFail;

	dataPath->PrimeL(); //reprime the datapath ready for another play
	
	TRAP(err, dataPath->PlayL()); //if the prime failed so should this
	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("PlayL Failed after clearing play window error = %d" ), err );
		}
	else
		{ //PlayL seemed OK but check source and sink have been primed correctly
		iActiveScheduler->Start(); //start the active scheduler
		}
	if (verdict == EPass)
		{
		//check source and sink are both in the stop state
		if (castedTestDataSource->State() != EStopped) verdict = EFail;
		if (castedTestDataSink->State() != EStopped) verdict = EFail;

		//check that the play was stopped by an EOF
		ResultOfPlay = iTestAsyncEventHandler->EventReceived();
		if ((ResultOfPlay.iEventType != KMMFEventCategoryPlaybackComplete)
			|| (ResultOfPlay.iErrorCode != KErrNone))
			{
			if (verdict == EPass) verdict = EInconclusive;
			INFO_PRINTF2(_L("error during play = %d" ), ResultOfPlay.iErrorCode );
			}

		//this time the expected start and end framenumbers should be the full play window
		if (castedTestDataSource->FirstFrame() != 1) verdict = EFail;
		if (castedTestDataSource->CurrentFrame() != KMMFNumFramesPlayWindowTest) verdict = EFail;//+1 because datapath reads 1 frame beyond EOF to determine EOF
		}
	}

 delete dataPath;
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;

 return verdict;
	
 }

 //tests 268-279 Incase I've forgotten any positioning tests

 CTestStep_MMF_BASECL_U_0280::CTestStep_MMF_BASECL_U_0280()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0280-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0280::DoTestStepL( void )
/** Verfiy CMMFDataPath OOM 
 * Use case: N/A
 * @test Req. under test REQ172.7.23
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;

 
 TInt KMaxFailRate = 100000;
 TBool complete = EFalse;
 TInt failCount;
 for (failCount=1; !complete && failCount<KMaxFailRate; ++failCount)
	{
	__UHEAP_SETFAIL(RHeap::EFailNext, failCount);
	TRAPD(err, dataPath = CMMFDataPath::NewL(*iTestAsyncEventHandler));
	if (err == KErrNone)
		{//need to check if next alloc fails
		TAny *testAlloc = User::Alloc(1); // when this fails, we passed through all allocs within test
		if (testAlloc==NULL)
			{
			// usefull for debugging
			}
		else
			{
			User::Free(testAlloc);
			complete = ETrue;
			}
		//check a datapath has been created
	    if (!dataPath) 
			{
			verdict = EFail;
			complete = ETrue;
			}
		else 
			{
			delete dataPath;
			dataPath = NULL;
			}
		}
	else if (err != KErrNoMemory)
		{
		verdict = EFail; // bad error code
		complete = ETrue;
		}
	}

 if (failCount >= KMaxFailRate-1) verdict = EFail;

 __UHEAP_RESET;
 delete dataPath;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0281::CTestStep_MMF_BASECL_U_0281()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0281-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0281::DoTestStepL( void )
/** Verfiy CMMFDataPath OOM with codec creation 
 * Use case: N/A
 * @test Req. under test REQ172.7.23
 */
 {
 TVerdict verdict = EPass;

 CMMFDataPath* dataPath = NULL;

 //the test codec should create a test file if it has been instantiated
 RFs fsSession;
 User::LeaveIfError(fsSession.Connect());
 _LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
 TPtrC fileName(KTestFileName);

 RFile testFile; //handle to test file to verify that the test codec has been created

 TInt KMaxFailRate = 100000;
 TBool complete = EFalse;
 TInt failCount;
 for (failCount=1; !complete && failCount<KMaxFailRate; ++failCount)
	{
	__UHEAP_SETFAIL(RHeap::EFailNext, failCount);
	TRAPD(err, dataPath = CMMFDataPath::NewL(iTestCodecUid, *iTestAsyncEventHandler));
	if (err == KErrNone)
		{//need to check if next alloc fails
		TAny *testAlloc = User::Alloc(1); // when this fails, we passed through all allocs within test
		if (testAlloc==NULL)
			{
			// usefull for debugging
			}
		else
			{
			User::Free(testAlloc);
			complete = ETrue;
			}
		//check a datapath has been created
	    if (!dataPath) 
			{
			verdict = EFail;
			complete = ETrue;
			}
		else 
			{
			delete dataPath;
			dataPath = NULL;
			}
		if (verdict == EPass)
			{
			//data path ok check the codec test file has been created and delete it
			err = testFile.Open(fsSession,fileName,EFileWrite);
			testFile.Close();
			if (err != KErrNone) verdict = EFail; //codec has not written the test file so can't assume codec was created
			else
				{ //codec created test file OK so delete it
				err = fsSession.Delete(fileName);
				if (err != KErrNone) 
					{
					verdict = EInconclusive;
					INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
					}
				}
			}
		
		} //if (err == KErrNone)
	else if (err != KErrNoMemory)
		{
		verdict = EFail; // bad error code
		complete = ETrue;
		}
	}

 if (failCount >= KMaxFailRate-1) verdict = EFail;

 __UHEAP_RESET;
 fsSession.Close();
 delete dataPath;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0282::CTestStep_MMF_BASECL_U_0282()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0282-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0282::DoTestStepL( void )
/** 
 * CMMFDataPath Buffer Creation in PrimeL OOM
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 CMMFDataPath* dataPath = NULL;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;


 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 0;
 srcSinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData);
 testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData);

 dataPath = CMMFDataPath::NewL(iTestCodecUid, *iTestAsyncEventHandler);

 dataPath->AddDataSourceL(testDataSource);
 dataPath->AddDataSinkL(testDataSink);

 TInt KMaxFailRate = 100000;
 TBool complete = EFalse;
 TInt failCount;
 for (failCount=1; !complete && failCount<KMaxFailRate; ++failCount)
	{
	__UHEAP_SETFAIL(RHeap::EFailNext, failCount);
	TRAPD(err, dataPath->PrimeL());
	if (err == KErrNone)
		{//need to check if next alloc fails
		TAny *testAlloc = User::Alloc(1); // when this fails, we passed through all allocs within test
		if (testAlloc==NULL)
			{
			// Usefull for debugging
			}
		else
			{
			User::Free(testAlloc);
			complete = ETrue;
			}
		//check the data path is primed
		if (dataPath->State() != CMMFDataPath::EPrimed) 
			{
			verdict = EFail;
			complete = ETrue;
			}
		}
	else if (err != KErrNoMemory)
		{
		verdict = EFail; // bad error code
		complete = ETrue;
		}
	}

 if (failCount >= KMaxFailRate-1) verdict = EFail;

 __UHEAP_RESET;

 delete dataPath;
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }
//tests 283-299 any other data path tests


//data path proxy tests

CTestStep_MMF_BASECL_U_0300::CTestStep_MMF_BASECL_U_0300()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0300-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0300::DoTestStepL( void )
/** Verfiy RMMFDataPathProxy subthread creation
 * Use case: N/A
 * @test Req. under test REQ172.7.23
 */
 {
 TVerdict verdict = EPass;

 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();

 if (err) verdict = EFail;
 if (!dataPathProxy.SubThreadId()) verdict = EFail;

 dataPathProxy.Close();

 return verdict;
 }


CTestStep_MMF_BASECL_U_0301::CTestStep_MMF_BASECL_U_0301()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0301-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0301::DoTestStepL( void )
/** Verfiy CMMFDataPath creation via RMMFDataPathProxy
 * Use case: N/A
 * @test Req. under test REQ172.7.23
 */
 {
 TVerdict verdict = EPass;

 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();

 if (err) verdict = EInconclusive;

 else
	{
	err = dataPathProxy.LoadDataPath();

	//note it is not directly possible to determine if an actual CMMFDataPath has been created
	//all we can do is check for errors and assume that if err = KErrNone the datapath 
	//creation was ok
	if (err) verdict = EFail;

	dataPathProxy.Close();
	}

 return verdict;
 }


CTestStep_MMF_BASECL_U_0302::CTestStep_MMF_BASECL_U_0302()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0302-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0302::DoTestStepL( void )
/** Verfiy CMMFDataPath creation via RMMFDataPathProxy specifying the use of a specific codec
 * In order to verify the codec has been instantiated the 
 * test codec creates a file in its constructor
 * Use case: N/A
 * @test Req. under test REQ172.7.23
 */
 {
 TVerdict verdict = EPass;

 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();

 if (err) verdict = EInconclusive;
 else
	{
	err = dataPathProxy.LoadDataPath(iTestCodecUid);

	//note it is not directly possible to determine if an actual CMMFDataPath has been created
	//all we can do is check for errors and assume that if err = KErrNone the datapath 
	//creation was ok
	//it is possible to determine whether the test codec has been created however
	if (err) verdict = EFail;

	//the test codec should create a test file if it has been instantiated
	RFs fsSession;
	User::LeaveIfError(fsSession.Connect());
	_LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
	TPtrC fileName(KTestFileName);

	RFile testFile; //handle to test file to verify that the test codec has been created
	err = testFile.Open(fsSession,fileName,EFileWrite);
	testFile.Close();
	if (err != KErrNone) verdict = EFail; //codec has not written the test file so can't assume codec was created
	else
		{ //codec created test file OK so delete it
		err = fsSession.Delete(fileName);
		if (err != KErrNone) 
			{
			verdict = EInconclusive;
			INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
			}
		}
	fsSession.Close();
	dataPathProxy.Close();
	}

 return verdict;
 }


CTestStep_MMF_BASECL_U_0303::CTestStep_MMF_BASECL_U_0303()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0303-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0303::DoTestStepL( void )
/** 
 * CMMFDataPath instantiation via RMMFDataPathProxy test specifying a TMediaId
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 TUid testMediaUid;
 testMediaUid.iUid = KMMFBASECLTestMediaId;
 TMediaId testMediaId(testMediaUid);

 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();

 if (err) verdict = EInconclusive;

 else
	{
	err = dataPathProxy.LoadDataPath(testMediaId);

	//note it is not directly possible to determine if an actual CMMFDataPath has been created
	//all we can do is check for errors and assume that if err = KErrNone the datapath 
	//creation was ok
	if (err) verdict = EFail;

	dataPathProxy.Close();
	}
 
 return verdict;
 }


CTestStep_MMF_BASECL_U_0304::CTestStep_MMF_BASECL_U_0304()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0304-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0304::DoTestStepL( void )
/** 
 * CMMFDataPath instantiation via RMMFDataPathProxy test specifying a TMediaId and a codec uid
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 TUid testMediaUid;
 testMediaUid.iUid = KMMFBASECLTestMediaId;
 TMediaId testMediaId(testMediaUid);

 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();

 if (err) verdict = EInconclusive;
 else
	{
	err = dataPathProxy.LoadDataPath(iTestCodecUid, testMediaId);

	//note it is not directly possible to determine if an actual CMMFDataPath has been created
	//all we can do is check for errors and assume that if err = KErrNone the datapath 
	//creation was ok
	//it is possible to determine whether the test codec has been created however
	if (err) verdict = EFail;

	//the test codec should create a test file if it has been instantiated
	RFs fsSession;
	User::LeaveIfError(fsSession.Connect());
	_LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
	TPtrC fileName(KTestFileName);

	RFile testFile; //handle to test file to verify that the test codec has been created
	err = testFile.Open(fsSession,fileName,EFileWrite);
	testFile.Close();
	if (err != KErrNone) verdict = EFail; //codec has not written the test file so can't assume codec was created
	else
		{ //codec created test file OK so delete it
		err = fsSession.Delete(fileName);
		if (err != KErrNone) 
			{
			verdict = EInconclusive;
			INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
			}
		}
	fsSession.Close();
	dataPathProxy.Close();
	}
 
 return verdict;
 }


CTestStep_MMF_BASECL_U_0305::CTestStep_MMF_BASECL_U_0305()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0305-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0305::DoTestStepL( void )
/** 
 * RMMFDataPathProxy AddDataSource/Sink without using a supplied codec uid
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();
 if (err) verdict = EInconclusive;

 if (!err)
	{
	TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
	srcSinkInitDataStruct.iSizeInFrames = 0;
	srcSinkInitDataStruct.iCreatedBufferSize = 0;
	srcSinkInitDataStruct.iOwnsBuffer = EFalse;
	srcSinkInitDataStruct.iAsynchronous = EFalse;

	TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

	testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData);
	testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData);

	err = dataPathProxy.LoadDataPath();

	if (err) verdict = EInconclusive;
	else
		{
		err = dataPathProxy.AddDataSource(testDataSource);

		if (err != KErrNone) 
			{
			verdict = EFail;
			INFO_PRINTF2(_L("Add Data Source Failed error = %d" ), err );
			}

		err = dataPathProxy.AddDataSink(testDataSink);

		if (err != KErrNone) 
			{
			verdict = EFail;
			INFO_PRINTF2(_L("Add Data Sink Failed error = %d" ), err );
			}

		//verify that the correct codec has been instantiated
		RFs fsSession;
		User::LeaveIfError(fsSession.Connect());
		RFile testFile; //handle to test file to verify that the test codec has been created
		_LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
		TPtrC fileName(KTestFileName);
		err = testFile.Open(fsSession,fileName,EFileWrite);
		testFile.Close();
		if (err != KErrNone) verdict = EFail; //codec has not written the test file so can't assume codec was created
		else
			{ //codec created test file OK so delete it
			err = fsSession.Delete(fileName);
			if (err != KErrNone) 
				{
				if (verdict == EPass) verdict = EInconclusive;
				INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
				}
			}
		fsSession.Close();
		}
	 }

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0306::CTestStep_MMF_BASECL_U_0306()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0306-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0306::DoTestStepL( void )
/** 
 * RMMFDataPathProxy AddDataSource/Sink using a supplied codec Uid
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();
 if (err) verdict = EInconclusive;

 if (!err)
	{
	TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
	srcSinkInitDataStruct.iSizeInFrames = 0;
	srcSinkInitDataStruct.iCreatedBufferSize = 0;
	srcSinkInitDataStruct.iOwnsBuffer = EFalse;
	srcSinkInitDataStruct.iAsynchronous = EFalse;

	TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

	testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData);
	testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData);

	err = dataPathProxy.LoadDataPath(iTestCodecUid);
	if (err) verdict = EInconclusive;
	else
		{
		//delete codec test file - note that unlike the datapath instantiation 
		//where no codec Uid is specified the above instantiation should instantiate the codec before
		//the source and sink are added
		RFs fsSession;
		User::LeaveIfError(fsSession.Connect());
		_LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
		TPtrC fileName(KTestFileName);
		TInt err = fsSession.Delete(fileName);
		if (err != KErrNone) 
			{
			verdict = EInconclusive;
			INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
			}

		err = dataPathProxy.AddDataSource(testDataSource);

		if (err != KErrNone) 
			{
			verdict = EFail;
			INFO_PRINTF2(_L("Add Data Source Failed error = %d" ), err );
			}

		err = dataPathProxy.AddDataSink(testDataSink);

		if (err != KErrNone) 
			{
			verdict = EFail;
			INFO_PRINTF2(_L("Add Data Sink Failed error = %d" ), err );
			}

		//verify no extra codec has been added
		RFile testFile; 
		err = testFile.Open(fsSession,fileName,EFileWrite);
		testFile.Close();
			if (err != KErrNotFound) verdict = EFail; //the codec test file should not be present

		fsSession.Close();
		}
	}

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0307::CTestStep_MMF_BASECL_U_0307()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0307-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0307::DoTestStepL( void )
/** 
 * RMMFDataPathProxy PrimeL using supplied codec Uid
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();
 if (err) verdict = EInconclusive;

 if (!err)
	{
	TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
	srcSinkInitDataStruct.iSizeInFrames = 0;
	srcSinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
	srcSinkInitDataStruct.iOwnsBuffer = EFalse;
	srcSinkInitDataStruct.iAsynchronous = EFalse;

	TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

	testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData);
	testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData);

	err = dataPathProxy.LoadDataPath(iTestCodecUid);
	if (err==KErrNone)
		err = dataPathProxy.AddDataSource(testDataSource);
	if (err==KErrNone)
		err = dataPathProxy.AddDataSink(testDataSink);

	if (err==KErrNone)
		err =  dataPathProxy.Prime();
	
	if (err==KErrNone) 
		{
		TInt dataPathState;
		err = dataPathProxy.State(dataPathState);
		if (dataPathState != CMMFDataPath::EPrimed) 
			err = KErrGeneral;
		}

	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("PrimeL (or previous) Failed error = %d" ), err );
		}
	else
		{ //PrimeL seemed OK but check source and sink have been primed correctly
		CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
		if (castedTestDataSource->State() != EPrimed) 
			verdict = EFail;
		if (!castedTestDataSource->BufferCreated()) 
			verdict = EFail;

		CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
		if (castedTestDataSink->State() != EPrimed) 
			verdict = EFail;
		if (!castedTestDataSink->BufferCreated()) 
			verdict = EFail;
		}

	dataPathProxy.Close();
	delete testDataSource;
	delete testDataSink;
	}

 return verdict;
 }



CTestStep_MMF_BASECL_U_0308::CTestStep_MMF_BASECL_U_0308()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0308-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0308::DoTestStepL( void )
/** 
 * RMMFDataPathProxy null codec instantiation test
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();
 if (err) verdict = EInconclusive;

 if (!err)
	{
	TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
	srcSinkInitDataStruct.iSizeInFrames = 0;
	srcSinkInitDataStruct.iCreatedBufferSize = 0;
	srcSinkInitDataStruct.iOwnsBuffer = EFalse;
	srcSinkInitDataStruct.iAsynchronous = EFalse;

	TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

	testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData);
	testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData);

	//set the sink FourCC to that of source - to ensure a null ocdec data path is instantiated
	testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId()); 

	err = dataPathProxy.LoadDataPath();
	if (err) verdict = EInconclusive;

	err = dataPathProxy.AddDataSource(testDataSource);

	if (err != KErrNone) 
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Add Data Source Failed error = %d" ), err );
		}

	if (err) dataPathProxy.AddDataSink(testDataSink);

	if (err != KErrNone) 
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Add Data Sink Failed error = %d" ), err );
		}
 
	//verify that the test codec has not been instantiated by checking the test codec file
	RFs fsSession;
	User::LeaveIfError(fsSession.Connect());
	_LIT(KTestFileName,"c:\\MMF_TSU_BASECL_TestCodecCreated");
	TPtrC fileName(KTestFileName);
	RFile testFile; //handle to test file to verify that the test codec has been created
	err = testFile.Open(fsSession,fileName,EFileWrite);
	testFile.Close();
	if (err == KErrNone) 
		{ //test file should not have been created as this implies thew test codec was instantiated
		verdict = EFail; 
		//delete test file
		err = fsSession.Delete(fileName);
		if (err != KErrNone) 
			{
			INFO_PRINTF2(_L("Could not delete created MMF_BASECL DP test codec file err = %d" ), err );
			}
		}
	else if (err != KErrNotFound) 
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("There was a problem opening the codec test file = %d" ), err );
		}
	 
	fsSession.Close();

	dataPathProxy.Close();
	delete testDataSource;
	delete testDataSink;
	}

 return verdict;
 }


 CTestStep_MMF_BASECL_U_0309::CTestStep_MMF_BASECL_U_0309()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0309-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0309::DoTestStepL( void )
/** 
 * RMMFDataPathProxy PrimeL using null codec and DP owning both buffers
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();
 if (err) verdict = EInconclusive;

 if (!err)
	{
	TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
	srcSinkInitDataStruct.iSizeInFrames = 0;
	srcSinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
	srcSinkInitDataStruct.iOwnsBuffer = EFalse;
	srcSinkInitDataStruct.iAsynchronous = EFalse;

	TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

	testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData);
	testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData);

	//set the sink FourCC to that of source - to ensure a null codec data path is instantiated
	testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId()); 

	err = dataPathProxy.LoadDataPath();
	if (err) verdict = EInconclusive;
	err = dataPathProxy.AddDataSource(testDataSource);
	if (err) verdict = EInconclusive;
	err = dataPathProxy.AddDataSink(testDataSink);
	if (err) verdict = EInconclusive;

	err = dataPathProxy.Prime();
	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
		}
	else
		{ //PrimeL seemed OK but check source and sink have been primed correctly
		//and that a source buffer has been created
		//Since we are using a Null codec and the source can create a buffer, there should be no sink buffer

		CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
		if (castedTestDataSource->State() != EPrimed) verdict = EFail;
		if (!castedTestDataSource->BufferCreated()) verdict = EFail;

		CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
		if (castedTestDataSink->State() != EPrimed) verdict = EFail;
		if (castedTestDataSink->BufferCreated()) verdict = EFail;
		}

	dataPathProxy.Close();
	delete testDataSource;
	delete testDataSink;
	}

 return verdict;
 }


CTestStep_MMF_BASECL_U_0310::CTestStep_MMF_BASECL_U_0310()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0310-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0310::DoTestStepL( void )
/** 
 * RMMFDataPathProxy PrimeL using null codec and source owning its own buffer
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();
 if (err) verdict = EInconclusive;

 if (!err)
	{
	TMMF_BASECL_TestSrcSinkConfig SourceInitDataStruct;
	SourceInitDataStruct.iSizeInFrames = 0;
	SourceInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
	SourceInitDataStruct.iOwnsBuffer = ETrue;
	SourceInitDataStruct.iAsynchronous = EFalse;

	TMMF_BASECL_TestSrcSinkConfig SinkInitDataStruct;
	SinkInitDataStruct.iSizeInFrames = 0;
	SinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
	SinkInitDataStruct.iOwnsBuffer = EFalse;
	SinkInitDataStruct.iAsynchronous = EFalse;

	TMMF_BASECL_TestSrcSinkConfigPckg SourceInitData(SourceInitDataStruct);
	TMMF_BASECL_TestSrcSinkConfigPckg SinkInitData(SinkInitDataStruct);

	testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, SourceInitData);
	testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, SinkInitData);

	//set the sink FourCC to that of source - to ensure a null codec data path is instantiated
	testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId()); 

	err = dataPathProxy.LoadDataPath();
	if (err) verdict = EInconclusive;
	err = dataPathProxy.AddDataSource(testDataSource);
	if (err) verdict = EInconclusive;
	err = dataPathProxy.AddDataSink(testDataSink);
	if (err) verdict = EInconclusive;

	err = dataPathProxy.Prime();

	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
		}
	else
		{ //PrimeL seemed OK but check source and sink have been primed correctly
		//and that a source buffer has been created
		//Since we are using a Null codec and the source can create a buffer, there should be no sink buffer
		CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
		if (castedTestDataSource->State() != EPrimed) verdict = EFail;
		if (!castedTestDataSource->BufferCreated()) verdict = EFail;

		CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
		if (castedTestDataSink->State() != EPrimed) verdict = EFail;
		if (castedTestDataSink->BufferCreated()) verdict = EFail; //both source and sink get called
		}

	dataPathProxy.Close();
	delete testDataSource;
	delete testDataSink;
	}

 return verdict;
 }


CTestStep_MMF_BASECL_U_0311::CTestStep_MMF_BASECL_U_0311()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0311-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0311::DoTestStepL( void )
/** 
 * RMMFDataPathProxy PrimeL using null codec and sink owning its own buffer
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();
 if (err) verdict = EInconclusive;

 if (!err)
	{
	TMMF_BASECL_TestSrcSinkConfig SourceInitDataStruct;
	SourceInitDataStruct.iSizeInFrames = 0;
	SourceInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
	SourceInitDataStruct.iOwnsBuffer = EFalse;
	SourceInitDataStruct.iAsynchronous = EFalse;

	TMMF_BASECL_TestSrcSinkConfig SinkInitDataStruct;
	SinkInitDataStruct.iSizeInFrames = 0;
	SinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
	SinkInitDataStruct.iOwnsBuffer = ETrue;
	SinkInitDataStruct.iAsynchronous = EFalse;

	TMMF_BASECL_TestSrcSinkConfigPckg SourceInitData(SourceInitDataStruct);
	TMMF_BASECL_TestSrcSinkConfigPckg SinkInitData(SinkInitDataStruct);

	testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, SourceInitData);
	testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, SinkInitData);

	//set the sink FourCC to that of source - to ensure a null codec data path is instantiated
	testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId()); 

	err = dataPathProxy.LoadDataPath();
	if (err) verdict = EInconclusive;
	err = dataPathProxy.AddDataSource(testDataSource);
	if (err) verdict = EInconclusive;
	err = dataPathProxy.AddDataSink(testDataSink);
	if (err) verdict = EInconclusive;

	err = dataPathProxy.Prime();

	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
		}
	else
		{ //PrimeL seemed OK but check source and sink have been primed correctly
		//and that both a source and sink buffer have both been created
		// note the sink buffer is subsequently deleted by the null codec but it is not possible to test for this
		CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
		if (castedTestDataSource->State() != EPrimed) verdict = EFail;
		if (!castedTestDataSource->BufferCreated()) verdict = EFail;

		CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
		if (castedTestDataSink->State() != EPrimed) verdict = EFail;
		if (castedTestDataSink->BufferCreated()) verdict = EFail;
		}

	dataPathProxy.Close();
	delete testDataSource;
	delete testDataSink;
	}

 return verdict;
 }


CTestStep_MMF_BASECL_U_0312::CTestStep_MMF_BASECL_U_0312()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0312-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0312::DoTestStepL( void )
/** 
 * CMMFDataPath PrimeL using null codec and source and sink owning their own buffer
 * Note that the default buffer assignment behaviour when both the source and sink
 * owns the buffer is that the source buffer is assigned and not the sink buffer
 * and this is the assumption made by this test
 * This could change !
 * Use case: N/A
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 RMMFDataPathProxy dataPathProxy;

 TInt err = dataPathProxy.CreateSubThread();
 if (err) verdict = EInconclusive;

 if (!err)
	{
	TMMF_BASECL_TestSrcSinkConfig SourceInitDataStruct;
	SourceInitDataStruct.iSizeInFrames = 0;
	SourceInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
	SourceInitDataStruct.iOwnsBuffer = ETrue;
	SourceInitDataStruct.iAsynchronous = EFalse;

	TMMF_BASECL_TestSrcSinkConfig SinkInitDataStruct;
	SinkInitDataStruct.iSizeInFrames = 0;
	SinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
	SinkInitDataStruct.iOwnsBuffer = ETrue;
	SinkInitDataStruct.iAsynchronous = EFalse;

	TMMF_BASECL_TestSrcSinkConfigPckg SourceInitData(SourceInitDataStruct);
	TMMF_BASECL_TestSrcSinkConfigPckg SinkInitData(SinkInitDataStruct);

	testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, SourceInitData);
	testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, SinkInitData);

	//set the sink FourCC to that of source - to ensure a null codec data path is instantiated
	testDataSink->SetSinkDataTypeCode(testDataSource->SourceDataTypeCode(TMediaId()), TMediaId()); 

	err = dataPathProxy.LoadDataPath();
	if (err) verdict = EInconclusive;
	err = dataPathProxy.AddDataSource(testDataSource);
	if (err) verdict = EInconclusive;
	err = dataPathProxy.AddDataSink(testDataSink);
	if (err) verdict = EInconclusive;

	err = dataPathProxy.Prime();
	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("PrimeL Failed error = %d" ), err );
		}
	else
		{ //PrimeL seemed OK but check source and sink have been primed correctly
		//and that both a source and sink buffer have both been created
		// note the sink buffer is subsequently deleted by the null codec but it is not possible to test for this
		CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
		if (castedTestDataSource->State() != EPrimed) verdict = EFail;
		if (!castedTestDataSource->BufferCreated()) verdict = EFail; 

		CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
		if (castedTestDataSink->State() != EPrimed) verdict = EFail;
		if (castedTestDataSink->BufferCreated()) verdict = EFail; //should default to source ie no sink buffer
		}

	dataPathProxy.Close();
	delete testDataSource;
	delete testDataSink;
	}

 return verdict;
 }


CTestStep_MMF_BASECL_U_0313::CTestStep_MMF_BASECL_U_0313()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0313-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0313::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using syncronous src/sink and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 1;
 srcSinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 return DoTestDataPathProxyPlayL(srcSinkInitDataStruct, srcSinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0314::CTestStep_MMF_BASECL_U_0314()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0314-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0314::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous src and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = EFalse;
 
 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0315::CTestStep_MMF_BASECL_U_0315()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0315-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0315::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous sink and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0316::CTestStep_MMF_BASECL_U_0316()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0316-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0316::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous src/sink and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0317::CTestStep_MMF_BASECL_U_0317()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0317-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0317::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous src/sink and EProcessComplete codec operation
 * src owning its own buffer
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;
 
 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0318::CTestStep_MMF_BASECL_U_0318()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0318-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0318::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, sink owning its buffer
 * and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0319::CTestStep_MMF_BASECL_U_0319()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0319-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0319::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, src&sink owning its buffer
 * and EProcessComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }

//note if using a codec both source and sink can't own the same buffer??
//as owning it implies that the buffer must be used by both source and sink
//which is impossible?? -with null codec only??

CTestStep_MMF_BASECL_U_0320::CTestStep_MMF_BASECL_U_0320()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0320-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0320::DoTestStepL( void )
/** 
 * RMMFDataPathProxy PlayL using asyncronous src/sink and EProcessComplete NULL codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0321::CTestStep_MMF_BASECL_U_0321()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0321-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0321::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, src owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0322::CTestStep_MMF_BASECL_U_0322()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0322-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0322::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, sink owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0323::CTestStep_MMF_BASECL_U_0323()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0323-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0323::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, sink owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0324::CTestStep_MMF_BASECL_U_0324()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0324-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0324::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, src owning its buffer
 * and EProcessInComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = 8; //dont use default size
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0325::CTestStep_MMF_BASECL_U_0325()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0325-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0325::DoTestStepL( void )
/** 
 * RMMFDataPathProxy PlayL using asyncronous source & sink, sink owning its buffer
 * and EProcessInComplete codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 1;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = 8; //dont use default size
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0326::CTestStep_MMF_BASECL_U_0326()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0326-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0326::DoTestStepL( void )
/** 
 * RMMFDataPathProxy PlayL using asyncronous source & sink, src owning its buffer
 * and EDstNotFilled codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 2; //frames are only half size
 srcInitDataStruct.iCreatedBufferSize = 8; //dont use default size
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0327::CTestStep_MMF_BASECL_U_0327()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0327-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0327::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, sink owning its buffer
 * and EDstNotFilled codec operation
 * Processing 1 buffer from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 2; //frames are only half size
 srcInitDataStruct.iCreatedBufferSize = 8; //dont use default size
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0328::CTestStep_MMF_BASECL_U_0328()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0328-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0328::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using syncronous src/sink and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4;
 srcSinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 return DoTestDataPathProxyPlayL(srcSinkInitDataStruct, srcSinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0329::CTestStep_MMF_BASECL_U_0329()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0329-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0329::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous src  and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = EFalse;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0330::CTestStep_MMF_BASECL_U_0330()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0330-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0330::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous sink  and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0331::CTestStep_MMF_BASECL_U_0331()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0331-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0331::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink  and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0332::CTestStep_MMF_BASECL_U_0332()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0332-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0332::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, src owning its buffer
 * and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0333::CTestStep_MMF_BASECL_U_0333()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0333-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0333::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, sink owning its buffer
 * and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0334::CTestStep_MMF_BASECL_U_0334()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0334-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0334::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, sink owning its buffer
 * and EProcessComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }

//note if using a codec both source and sink can't own the same buffer??
//as owning it implies that the buffer must be used by both source and sink
//which is impossible?? -with null codec only??

CTestStep_MMF_BASECL_U_0335::CTestStep_MMF_BASECL_U_0335()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0335-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0335::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous src/sink and EProcessComplete NULL codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0336::CTestStep_MMF_BASECL_U_0336()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0336-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0336::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, src owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0337::CTestStep_MMF_BASECL_U_0337()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0337-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0337::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, sink owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0338::CTestStep_MMF_BASECL_U_0338()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0338-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0338::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, sink owning its buffer
 * EProcessComplete NULL codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct, ETrue);
 }


CTestStep_MMF_BASECL_U_0339::CTestStep_MMF_BASECL_U_0339()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0339-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0339::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, src owning its buffer
 * and EProcessInComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = 8; //dont use default size
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0340::CTestStep_MMF_BASECL_U_0340()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0340-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0340::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, sink owning its buffer
 * and EProcessInComplete codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = 8; //dont use default size
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0341::CTestStep_MMF_BASECL_U_0341()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0341-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0341::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, src owning its buffer
 * and EDstNotFilled codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = 8; //dont use default size
 srcInitDataStruct.iOwnsBuffer = ETrue;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = EFalse;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0342::CTestStep_MMF_BASECL_U_0342()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0342-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0342::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, sink owning its buffer
 * and EDstNotFilled codec operation
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = 8; //dont use default size
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0343::CTestStep_MMF_BASECL_U_0343()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0343-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0343::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Play using asyncronous source & sink, sink owning its buffer
 * with mismatched src/sink buffer sizes such that the source buffer does not
 * divide evenly into the sink - causes alternating EDstNotFilled/EProcessIncomplete
 * Processing 4 buffers from the source
 * @test Req. under test REQ172.7.25
 */
 {

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 4;
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = 30; //some arbitary size
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 return DoTestDataPathProxyPlayL(srcInitDataStruct, sinkInitDataStruct);
 }


CTestStep_MMF_BASECL_U_0344::CTestStep_MMF_BASECL_U_0344()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0344-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0344::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Pause 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 RMMFDataPathProxy dataPathProxy;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;
 CMMF_TSU_BASECL_MakeAsyncDataPathCall* asyncDataPathCaller= NULL;

 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 8; //just use an arbitary size
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfigPckg srcInitData(srcInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg sinkInitData(sinkInitDataStruct);

 TInt err = dataPathProxy.CreateSubThread();
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create dataPath subthread = %d" ), err );
	}

 if (!err)
	{	
	TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcInitData));
	if (err==KErrNone)
		{
		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, sinkInitData));
		}
	if (err==KErrNone)
		{
		TRAP(err, testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));
		}
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
		}
	}
	
 if (!err)
	{
	CMMFDataPathEventMonitor* dataPathEventMonitor = NULL;
	CTestDataPathEventMonitorObserver* dataPathEventMonitorObserver = NULL;

	dataPathEventMonitorObserver = new(ELeave)CTestDataPathEventMonitorObserver;		
 
	dataPathProxy.LoadDataPath();
	asyncDataPathCaller = new(ELeave)CMMF_TSU_BASECL_MakeAsyncDataPathCall;

	dataPathProxy.AddDataSource(testFormatDecode);
	dataPathProxy.AddDataSink(testDataSink);
	dataPathProxy.Prime();
	err= dataPathProxy.Play();

	// N.B. timer is not accurate enough to allow an exact measure of KMMFPauseAfterDelay us
	// so measure time here and take another measurement after async function
	// slight caveat here is that if this process gets paused by the kernel for whatever reason
	// then the actual time reading [postTime] will be greater than expected and will exceed
	// the actual current frame causing the test to fail.  In almost all cases this will NOT happen

	// get time pre call to active scheduler
	TTime preTime;
	preTime.UniversalTime();
	
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("PlayL Failed error = %d" ), err );
		}
	else
		{ //PlayL seemed OK so cause a Pause after a period of time
		INFO_PRINTF1(_L("PlayL OK - Starting active scheduler"));

		asyncDataPathCaller->CallPauseAfter(dataPathProxy, KMMFPauseAfterDelay); //alow enough time for 4 frames but not 5

		iActiveScheduler->Start(); //start the active scheduler
		}

	// get actual current time
	TTime postTime;
	postTime.UniversalTime();

	//datapath should be in the primed state when paused
	INFO_PRINTF1(_L("Should now be in Paused State"));
	TInt dataPathState;
	err = dataPathProxy.State(dataPathState);
	if (dataPathState != CMMFDataPath::EPrimed) err = KErrGeneral;
	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Pause Failed error = %d" ), err );
		}

	//check data source and data sink are STOPPED. datapath now stopps source & sinks when pausing
	CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	if (castedTestDataSource->State() != EPaused) 
		{
		verdict = EFail;
		INFO_PRINTF1(_L("Error - Source was not paused"));
		}

	CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	if (castedTestDataSink->State() != EStopped)
		{
		verdict = EFail;
		INFO_PRINTF1(_L("Error - Sink was not paused"));
		}

	//check that the current source frame is to within +/- one frame of the delay
	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());
		
	// get difference in u seconds
	TInt64 usDiff = postTime.Int64() - preTime.Int64();
	
	// should not be less than KMMFPauseAfterDelay us.  However if is > then update the value
	TInt64 reqDelay( KMMFPauseAfterDelay );
	if (usDiff > reqDelay) reqDelay = usDiff;
	
	// get actual current frame
	TUint actualCurrentFrame = castedTestDataSource->CurrentFrame(); 
	TUint expectedCurrentFrame = I64LOW(reqDelay / frameTimeInterval.Int64());
	//Expected frame should be within +/- 2 of actual frame value, considering the inaccuracies in the timer.
	if ((actualCurrentFrame < expectedCurrentFrame-2) || (actualCurrentFrame > expectedCurrentFrame+2))
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Actual frm differs from expected frm - act frame = %d" ), actualCurrentFrame );
		INFO_PRINTF3(_L("Required delay = %d;  Expected frame = %d" ), I64LOW(reqDelay), expectedCurrentFrame );
		}

	//now check that Play can be resumed after pause
	TRAP(err,dataPathEventMonitor = CMMFDataPathEventMonitor::NewL(*dataPathEventMonitorObserver, dataPathProxy));
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create dataPathEventMonitor = %d" ), err );
		}

	err = dataPathProxy.Play();

	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("PlayL Failed after resume from Pause error = %d" ), err );
		}
	else
		{ //PlayL seemed OK so resume data transfer
		INFO_PRINTF1(_L("PlayL OK - ReStarting active scheduler after pause"));
		dataPathEventMonitor->Start();
		iActiveScheduler->Start(); //restart the active scheduler
		}

	//check source and sink are both in the stop state
	if (castedTestDataSource->State() != EStopped)
		{
		verdict = EFail;
		INFO_PRINTF1(_L("Src not in stopped state"));
		}

	if (castedTestDataSink->State() != EStopped)
		{
		verdict = EFail;
		INFO_PRINTF1(_L("Sink not in stopped state"));
		}

	//check that the play was stopped by an EOF
	TMMFEvent ResultOfPlay = dataPathEventMonitorObserver->EventReceived();
	if ((ResultOfPlay.iEventType != KMMFEventCategoryPlaybackComplete)
		|| (ResultOfPlay.iErrorCode != KErrNone))
		{
		verdict = EFail;
		INFO_PRINTF2(_L("error during play = %d" ), ResultOfPlay.iErrorCode );
		}

	//check that the play resumed from where it left off in the paused state - (Play resets source first frame)
	if (castedTestDataSource->FirstFrame() != actualCurrentFrame+1) 
		{
		INFO_PRINTF1(_L("Play did not resume from previuos position" ));
		verdict = EFail;
		}
	
	delete dataPathEventMonitor;
	delete dataPathEventMonitorObserver;
	delete asyncDataPathCaller;
	}

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;
 
 return verdict;
 }


 CTestStep_MMF_BASECL_U_0345::CTestStep_MMF_BASECL_U_0345()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0345-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0345::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Stop 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 RMMFDataPathProxy dataPathProxy;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;
 CMMF_TSU_BASECL_MakeAsyncDataPathCall* asyncDataPathCaller= NULL;

 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 8; //just use an arbitary size
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfigPckg srcInitData(srcInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg sinkInitData(sinkInitDataStruct);

 TInt err = dataPathProxy.CreateSubThread();
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create dataPath subthread = %d" ), err );
	}

 if (!err)
	{	
	TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcInitData));
	if (err==KErrNone)
		{
		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, sinkInitData));
		}
	if (err==KErrNone)
		{
		TRAP(err, testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));	
		}
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
		}
	}
	
 if (!err)
	{		
	dataPathProxy.LoadDataPath();
	asyncDataPathCaller = new(ELeave)CMMF_TSU_BASECL_MakeAsyncDataPathCall;

	dataPathProxy.AddDataSource(testFormatDecode);
	dataPathProxy.AddDataSink(testDataSink);
	dataPathProxy.Prime();
	err= dataPathProxy.Play(); //if any of the above fails so will this

	// N.B. timer is not accurate enough to allow an exact measure of KMMFPauseAfterDelay us
	// so measure time here and take another measurement after async function
	// slight caveat here is that if this process gets paused by the kernel for whatever reason
	// then the actual time reading [postTime] will be greater than expected and will exceed
	// the actual current frame causing the test to fail.  In almost all cases this will NOT happen

	// get time pre call to active scheduler
	TTime preTime;
	preTime.UniversalTime();
	
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("PlayL Failed error = %d" ), err );
		}
	else
		{ //PlayL seemed OK so cause a Pause after a period of time
		INFO_PRINTF1(_L("PlayL OK - Starting active scheduler"));
		asyncDataPathCaller->CallStopAfter(dataPathProxy, KMMFPauseAfterDelay); //alow enough time for 4 frames but not 5
		
		iActiveScheduler->Start(); //start the active scheduler
		}

	// get actual current time
	TTime postTime;
	postTime.UniversalTime();

	//datapath should be in the stopped state
	INFO_PRINTF1(_L("Should now be in Stopped State"));
	TInt dataPathState;
	err = dataPathProxy.State(dataPathState);
	if (dataPathState != CMMFDataPath::EStopped) err = KErrGeneral;
	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Stop Failed error = %d" ), err );
		}

	//check data source and data sink are stopped.
	CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	if (castedTestDataSource->State() != EStopped) 
		{
		verdict = EFail;
		INFO_PRINTF1(_L("Src not in stopped state"));
		}
	CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	if (castedTestDataSink->State() != EStopped)
		{
		verdict = EFail;
		INFO_PRINTF1(_L("Sink not in stopped state"));
		}

	//check that the current source frame is to within +/- one frame of the delay
	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());
		
	// get difference in u seconds
	TInt64 usDiff = postTime.Int64() - preTime.Int64();
	
	// should not be less than KMMFPauseAfterDelay us.  However if is > then update the value
	TInt64 reqDelay( KMMFPauseAfterDelay );
	if (usDiff > reqDelay) reqDelay = usDiff;
	
	// get actual current frame
	TUint actualCurrentFrame = castedTestDataSource->CurrentFrame(); 
	TUint expectedCurrentFrame = I64LOW(reqDelay / frameTimeInterval.Int64());
	//Expected frame should be within +/- 2 of actual frame value, considering the inaccuracies in the timer.	
	if ((actualCurrentFrame < expectedCurrentFrame-2) || (actualCurrentFrame > expectedCurrentFrame+2))
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Actual frm differs from expected frm - act frame = %d" ), actualCurrentFrame );
		INFO_PRINTF3(_L("Required delay = %d;  Expected frame = %d" ), I64LOW(reqDelay), expectedCurrentFrame );
		}

	delete asyncDataPathCaller;
	}

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;

 return verdict;

 }


 CTestStep_MMF_BASECL_U_0360::CTestStep_MMF_BASECL_U_0360()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0360-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0360::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Position()/SetPosition() using non format source & sink, sink 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 RMMFDataPathProxy dataPathProxy;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TInt err = dataPathProxy.CreateSubThread();
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create dataPath subthread = %d" ), err );
	}

 if (!err)
	{
	TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
	if (err==KErrNone)
		{
		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
		}
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
		}
	 }

 if (!err)
	{
	dataPathProxy.LoadDataPath();
	dataPathProxy.AddDataSource(testDataSource);
	dataPathProxy.AddDataSink(testDataSink);

	TTimeIntervalMicroSeconds position;
	TTimeIntervalMicroSeconds testPosition(300000);

	err = dataPathProxy.GetPosition(position);
	if ((err)||(position != TTimeIntervalMicroSeconds(0))) verdict = EFail;

	dataPathProxy.Prime();

	err = dataPathProxy.GetPosition(position); //check position again after Prime
	if ((err) || (position != TTimeIntervalMicroSeconds(0))) verdict = EFail;

	err = dataPathProxy.SetPosition(testPosition);
	if (err != KErrNotSupported)  //it is not possible to set the position on non format src/sink
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Failed due to set position on non format src/sink = %d" ), err );
		}

	err = dataPathProxy.GetPosition(position);
	if ((err) || (position != TTimeIntervalMicroSeconds(0))) verdict = EFail;
	}

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;

 return verdict;
 }
 

CTestStep_MMF_BASECL_U_0361::CTestStep_MMF_BASECL_U_0361()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0361-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0361::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Position()/SetPosition() using format source 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 RMMFDataPathProxy dataPathProxy;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;

 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TInt err = dataPathProxy.CreateSubThread();
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create dataPath subthread = %d" ), err );
	}

 if (!err)
	{
	TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
	if (err==KErrNone)
		{
		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
		}
	if (err==KErrNone)
		{
		TRAP(err, testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));
		}
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
		}
	 }

 if (!err)
	{
	dataPathProxy.LoadDataPath();
	dataPathProxy.AddDataSource(testFormatDecode);
	dataPathProxy.AddDataSink(testDataSink);

	TTimeIntervalMicroSeconds position;
	TTimeIntervalMicroSeconds testPosition(300000);

	err = dataPathProxy.GetPosition(position);
	if ((err)||(position != TTimeIntervalMicroSeconds(0))) verdict = EFail;

	dataPathProxy.Prime();

	err = dataPathProxy.GetPosition(position); //check position again after Prime
	if ((err) || (position != TTimeIntervalMicroSeconds(0))) verdict = EFail;

	err = dataPathProxy.SetPosition(testPosition);
	if (err != KErrNone)  //it is not possible to set the position on non format src/sink
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Failed due to set position on format src = %d" ), err );
		}

	err = dataPathProxy.GetPosition(position);

    if (err) verdict = EFail;

	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());

	//note position can only be set to a granularity of the formats frametime interval
	if (position <= TTimeIntervalMicroSeconds(testPosition.Int64() - frameTimeInterval.Int64())) 
																			verdict = EFail;
	if (position >= TTimeIntervalMicroSeconds(testPosition.Int64() + frameTimeInterval.Int64())) 
																			verdict = EFail;
	}

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0362::CTestStep_MMF_BASECL_U_0362()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0362-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0362::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Position()/SetPosition() using format sink, sink 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 RMMFDataPathProxy dataPathProxy;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatEncode* testFormatEncode = NULL;

 TUid testDataFormatEncodeUid;
 testDataFormatEncodeUid.iUid = KMmfUidTSUBASECLTestFormatEncode;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TInt err = dataPathProxy.CreateSubThread();
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create dataPath subthread = %d" ), err );
	}

 if (!err)
	{
	TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
	if (err==KErrNone)
		{
		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
		}
	if (err==KErrNone)
		{
		TRAP(err, testFormatEncode = CMMFFormatEncode::NewL(testDataFormatEncodeUid, testDataSink));
		}
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
		}
	 }

 if (!err)
	{
	dataPathProxy.LoadDataPath();
	dataPathProxy.AddDataSource(testDataSource);
	dataPathProxy.AddDataSink(testFormatEncode);

	TTimeIntervalMicroSeconds position;
	TTimeIntervalMicroSeconds testPosition(300000);

	err = dataPathProxy.GetPosition(position);
	if ((err)||(position != TTimeIntervalMicroSeconds(0))) verdict = EFail;

	dataPathProxy.Prime();

	err = dataPathProxy.GetPosition(position); //check position again after Prime
	if ((err) || (position != TTimeIntervalMicroSeconds(0))) verdict = EFail;

	err = dataPathProxy.SetPosition(testPosition);
	if (err != KErrNone)  //it is not possible to set the position on non format src/sink
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Failed due to set position on format src = %d" ), err );
		}

	err = dataPathProxy.GetPosition(position);

    if (err) verdict = EFail;

	TTimeIntervalMicroSeconds frameTimeInterval = testFormatEncode->FrameTimeInterval(TMediaId());

	//note position can only be set to a granularity of the formats frametime interval
	if (position <= TTimeIntervalMicroSeconds(testPosition.Int64() - frameTimeInterval.Int64())) 
																			verdict = EFail;
	if (position >= TTimeIntervalMicroSeconds(testPosition.Int64() + frameTimeInterval.Int64())) 
																			verdict = EFail;
	}

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;
 delete testFormatEncode;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0363::CTestStep_MMF_BASECL_U_0363()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0363-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0363::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Position()/SetPosition() using format src & sink 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 RMMFDataPathProxy dataPathProxy;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;
 CMMFFormatEncode* testFormatEncode = NULL;

 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;
 TUid testDataFormatEncodeUid;
 testDataFormatEncodeUid.iUid = KMmfUidTSUBASECLTestFormatEncode;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TInt err = dataPathProxy.CreateSubThread();
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create dataPath subthread = %d" ), err );
	}

 if (!err)
	{
	TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
	if (err==KErrNone)
		{
		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
		}
	if (err==KErrNone)
		{
		TRAP(err, testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));
		}
	if (err==KErrNone)
		{
		TRAP(err, testFormatEncode = CMMFFormatEncode::NewL(testDataFormatEncodeUid, testDataSink));
		}
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
		}
	 }

 if (!err)
	{
	dataPathProxy.LoadDataPath();
	dataPathProxy.AddDataSource(testFormatDecode);
	dataPathProxy.AddDataSink(testFormatEncode);

	TTimeIntervalMicroSeconds position;
	TTimeIntervalMicroSeconds testPosition(300000);

	err = dataPathProxy.GetPosition(position);
	if ((err)||(position != TTimeIntervalMicroSeconds(0))) verdict = EFail;

	dataPathProxy.Prime();

	err = dataPathProxy.GetPosition(position); //check position again after Prime
	if ((err) || (position != TTimeIntervalMicroSeconds(0))) verdict = EFail;

	err = dataPathProxy.SetPosition(testPosition);
	if (err != KErrNone)  //it is not possible to set the position on non format src/sink
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Failed due to set position on format src = %d" ), err );
		}

	err = dataPathProxy.GetPosition(position);

    if (err) verdict = EFail;

	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());

	//note position can only be set to a granularity of the formats frametime interval
	if (position <= TTimeIntervalMicroSeconds(testPosition.Int64() - frameTimeInterval.Int64())) 
																			verdict = EFail;
	if (position >= TTimeIntervalMicroSeconds(testPosition.Int64() + frameTimeInterval.Int64())) 
																			verdict = EFail;
	}

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;
 delete testFormatEncode;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0364::CTestStep_MMF_BASECL_U_0364()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0364-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0364::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Position()/SetPosition() using format source positioning beyond the end of source 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 RMMFDataPathProxy dataPathProxy;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;

 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TInt err = dataPathProxy.CreateSubThread();
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create dataPath subthread = %d" ), err );
	}

 if (!err)
	{
	TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
	if (err==KErrNone)
		{
		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
		}
	if (err==KErrNone)
		{
		TRAP(err, testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));
		}
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
		}
	 }

 if (!err)
	{
	dataPathProxy.LoadDataPath();
	dataPathProxy.AddDataSource(testFormatDecode);
	dataPathProxy.AddDataSink(testDataSink);

	TTimeIntervalMicroSeconds position;
	TTimeIntervalMicroSeconds testPosition;
	TTimeIntervalMicroSeconds duration;

	dataPathProxy.Prime();

	duration = testFormatDecode->Duration(TMediaId());
	testPosition = TTimeIntervalMicroSeconds(duration.Int64()+1); //position 1 uS beyond EOF

	err = dataPathProxy.SetPosition(testPosition);
	if (err != KErrNone)  //it is not possible to set the position on non format src/sink
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Failed due to set position on format src = %d" ), err );
		}

	err = dataPathProxy.GetPosition(position); //check position again

	if (err) verdict = EFail;

	//position should now be at the end of the format
	if (position != duration) verdict = EFail;
	}

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0365::CTestStep_MMF_BASECL_U_0365()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0365-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0365::DoTestStepL( void )
/** 
 * RMMFDataPathProxy Position()/SetPosition() using format sink positioning beyond the end of source 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;

 RMMFDataPathProxy dataPathProxy;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatEncode* testFormatEncode = NULL;

 TUid testDataFormatEncodeUid;
 testDataFormatEncodeUid.iUid = KMmfUidTSUBASECLTestFormatEncode;

 TMMF_BASECL_TestSrcSinkConfig srcSinkInitDataStruct;
 srcSinkInitDataStruct.iSizeInFrames = 4;
 srcSinkInitDataStruct.iCreatedBufferSize = 0;
 srcSinkInitDataStruct.iOwnsBuffer = EFalse;
 srcSinkInitDataStruct.iAsynchronous = EFalse;

 TMMF_BASECL_TestSrcSinkConfigPckg srcSinkInitData(srcSinkInitDataStruct);

 TInt err = dataPathProxy.CreateSubThread();
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create dataPath subthread = %d" ), err );
	}

 if (!err)
	{
	TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcSinkInitData));
	if (err==KErrNone)
		{
		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, srcSinkInitData));
		}
	if (err==KErrNone)
		{
		TRAP(err, testFormatEncode = CMMFFormatEncode::NewL(testDataFormatEncodeUid, testDataSink));
		}
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
		}
	 }

 if (!err)
	{
	dataPathProxy.LoadDataPath();
	dataPathProxy.AddDataSource(testDataSource);
	dataPathProxy.AddDataSink(testFormatEncode);

	TTimeIntervalMicroSeconds position;
	TTimeIntervalMicroSeconds testPosition;
	TTimeIntervalMicroSeconds duration;

	dataPathProxy.Prime();

	duration = testFormatEncode->Duration(TMediaId());
	testPosition = TTimeIntervalMicroSeconds(duration.Int64()+1); //position 1 uS beyond EOF

	err = dataPathProxy.SetPosition(testPosition);
	if (err != KErrNone)  //it is not possible to set the position on non format src/sink
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Failed due to set position on format src = %d" ), err );
		}

	err = dataPathProxy.GetPosition(position); //check position again

	if (err) verdict = EFail;

	//position should now be at the end of the format
	if (position != duration) verdict = EFail;
	}

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;
 delete testFormatEncode;

 return verdict;
 }


CTestStep_MMF_BASECL_U_0366::CTestStep_MMF_BASECL_U_0366()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0366-HP");
 }

TVerdict CTestStep_MMF_BASECL_U_0366::DoTestStepL( void )
/** 
 * RMMFDataPathProxy SetPlayWindow() 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 RMMFDataPathProxy dataPathProxy;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;
 
 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;
 

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 6; //just use an arbitary size
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfigPckg srcInitData(srcInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg sinkInitData(sinkInitDataStruct);

 TInt err = dataPathProxy.CreateSubThread();
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create dataPath subthread = %d" ), err );
	}

 if (!err)
	{
	TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcInitData));
	if (err==KErrNone)
		{
		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, sinkInitData));	
		}
	if (err==KErrNone)
		{
		TRAP(err, testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));
		}
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
		}
	 }

 if (!err)
	{
	CMMFDataPathEventMonitor* dataPathEventMonitor = NULL;
	CTestDataPathEventMonitorObserver* dataPathEventMonitorObserver = NULL;
	dataPathEventMonitorObserver = new(ELeave)CTestDataPathEventMonitorObserver;
	TRAP(err,dataPathEventMonitor = CMMFDataPathEventMonitor::NewL(*dataPathEventMonitorObserver, dataPathProxy));
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create datapath event monitor = %d" ), err );
		}

	dataPathProxy.LoadDataPath();
	dataPathProxy.AddDataSource(testFormatDecode);
	dataPathProxy.AddDataSink(testDataSink);
	dataPathProxy.Prime();

	err = dataPathProxy.SetPlayWindow(TTimeIntervalMicroSeconds(KMMFStartOfPlayWindow), TTimeIntervalMicroSeconds(KMMFEndOfPlayWindow));

	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Could not set play window = %d" ), err );
		}

	err = dataPathProxy.Play();

	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("PlayL Failed error = %d" ), err );
		}
	else
		{ //PlayL seemed OK but check source and sink have been primed correctly
		dataPathEventMonitor->Start();
		iActiveScheduler->Start(); //start the active scheduler
		}

	//check source and sink are both in the stop state
	CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	if (castedTestDataSource->State() != EStopped) verdict = EInconclusive;
	CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	if (castedTestDataSink->State() != EStopped) verdict = EInconclusive;

	//check that the play was stopped by an EOF
	TMMFEvent ResultOfPlay = dataPathEventMonitorObserver->EventReceived();
	if ((ResultOfPlay.iEventType != KMMFEventCategoryPlaybackComplete)
		|| (ResultOfPlay.iErrorCode != KErrNone))
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("error during play = %d" ), ResultOfPlay.iErrorCode );
		}

	//check that the first and last frames match that set by the PlayWindow
	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());
	if (frameTimeInterval <= TTimeIntervalMicroSeconds(0)) 
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Bad format frametime interval = %d" ), err );
		 }
	else
		{
		TUint expectedStartFrameNumber = (KMMFStartOfPlayWindow/I64LOW(frameTimeInterval.Int64())) + 1; //+1 because frames start at 1
		TUint expectedEndFrameNumber = (KMMFEndOfPlayWindow/I64LOW(frameTimeInterval.Int64()));
		if (expectedStartFrameNumber != castedTestDataSource->FirstFrame()) verdict = EFail;
		if (expectedEndFrameNumber != castedTestDataSource->CurrentFrame()) verdict = EFail;
		}

	delete dataPathEventMonitorObserver;
	delete dataPathEventMonitor;
	}

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;

 return verdict;
 }


 CTestStep_MMF_BASECL_U_0367::CTestStep_MMF_BASECL_U_0367()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0367-HP");
 }

TVerdict CTestStep_MMF_BASECL_U_0367::DoTestStepL( void )
/** 
 * RMMFDataPathProxy ClearPlayWindow() 
 * @test Req. under test REQ172.7.25
 */
 {
 TVerdict verdict = EPass;
 RMMFDataPathProxy dataPathProxy;
 MDataSource* testDataSource = NULL;
 MDataSink* testDataSink = NULL;
 CMMFFormatDecode* testFormatDecode = NULL;
 
 TUid testDataFormatDecodeUid;
 testDataFormatDecodeUid.iUid = KMmfUidTSUBASECLTestFormatDecode;
 

 TMMF_BASECL_TestSrcSinkConfig srcInitDataStruct;
 srcInitDataStruct.iSizeInFrames = 6; //just use an arbitary size
 srcInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 srcInitDataStruct.iOwnsBuffer = EFalse;
 srcInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfig sinkInitDataStruct;
 sinkInitDataStruct.iSizeInFrames = 0;
 sinkInitDataStruct.iCreatedBufferSize = KMMFDefaultSrcSinkFrameSize;
 sinkInitDataStruct.iOwnsBuffer = ETrue;
 sinkInitDataStruct.iAsynchronous = ETrue;

 TMMF_BASECL_TestSrcSinkConfigPckg srcInitData(srcInitDataStruct);
 TMMF_BASECL_TestSrcSinkConfigPckg sinkInitData(sinkInitDataStruct);

 TInt err = dataPathProxy.CreateSubThread();
 if (err)
	{
	verdict = EInconclusive;
	INFO_PRINTF2(_L("Could not create dataPath subthread = %d" ), err );
	}

 if (!err)
	{
	TRAP(err, testDataSource = MDataSource::NewSourceL(iTestDataSourceUid, srcInitData));
	if (err==KErrNone)
		{
		TRAP(err, testDataSink = MDataSink::NewSinkL(iTestDataSinkUid, sinkInitData));
		}
	if (err==KErrNone)
		{
		TRAP(err, testFormatDecode = CMMFFormatDecode::NewL(testDataFormatDecodeUid, testDataSource));
		}
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create source and/or sink = %d" ), err );
		}
	 }

 if (!err)
	{
	CMMFDataPathEventMonitor* dataPathEventMonitor = NULL;
	CTestDataPathEventMonitorObserver* dataPathEventMonitorObserver = NULL;
	dataPathEventMonitorObserver = new(ELeave)CTestDataPathEventMonitorObserver;
	TRAP(err,dataPathEventMonitor = CMMFDataPathEventMonitor::NewL(*dataPathEventMonitorObserver, dataPathProxy));
	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not create datapath event monitor = %d" ), err );
		}

	dataPathProxy.LoadDataPath();
	dataPathProxy.AddDataSource(testFormatDecode);
	dataPathProxy.AddDataSink(testDataSink);
	dataPathProxy.Prime();

	err = dataPathProxy.SetPlayWindow(TTimeIntervalMicroSeconds(KMMFStartOfPlayWindow), TTimeIntervalMicroSeconds(KMMFEndOfPlayWindow));

	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Could not set play window = %d" ), err );
		}

	err = dataPathProxy.Play();

	if (err)
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("PlayL Failed error = %d" ), err );
		}
	else
		{ //PlayL seemed OK but check source and sink have been primed correctly
		dataPathEventMonitor->Start();
		iActiveScheduler->Start(); //start the active scheduler
		}

	//check source and sink are both in the stop state
	CMMF_TSU_BASECL_TestSource* castedTestDataSource = STATIC_CAST(CMMF_TSU_BASECL_TestSource*, testDataSource);
	if (castedTestDataSource->State() != EStopped) verdict = EInconclusive;
	CMMF_TSU_BASECL_TestSink* castedTestDataSink = STATIC_CAST(CMMF_TSU_BASECL_TestSink*, testDataSink);
	if (castedTestDataSink->State() != EStopped) verdict = EInconclusive;

	//check that the play was stopped by an EOF
	TMMFEvent ResultOfPlay = dataPathEventMonitorObserver->EventReceived();
	if ((ResultOfPlay.iEventType != KMMFEventCategoryPlaybackComplete)
		|| (ResultOfPlay.iErrorCode != KErrNone))
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("error during play = %d" ), ResultOfPlay.iErrorCode );
		}

	dataPathEventMonitor->Cancel(); //cancel any outstanding requests

	//check that the first and last frames match that set by the PlayWindow
	TTimeIntervalMicroSeconds frameTimeInterval = testFormatDecode->FrameTimeInterval(TMediaId());
	if (frameTimeInterval <= TTimeIntervalMicroSeconds(0)) 
		{
		verdict = EInconclusive;
		INFO_PRINTF2(_L("Bad format frametime interval = %d" ), err );
		 }
	else
		{
		TUint expectedStartFrameNumber = (KMMFStartOfPlayWindow/I64LOW(frameTimeInterval.Int64())) + 1; //+1 because frames start at 1
		TUint expectedEndFrameNumber = (KMMFEndOfPlayWindow/I64LOW(frameTimeInterval.Int64()));
		if (expectedStartFrameNumber != castedTestDataSource->FirstFrame()) verdict = EInconclusive;
		if (expectedEndFrameNumber != castedTestDataSource->CurrentFrame()) verdict = EInconclusive;
		}

	//clear the play window
	err = dataPathProxy.ClearPlayWindow();
	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Could not clear play window = %d" ), err );
		}

	//check that the position has now been set to the start
	TTimeIntervalMicroSeconds position;
	err = dataPathProxy.GetPosition(position);
	if ((err)||(position != TTimeIntervalMicroSeconds(0))) verdict = EFail;

	dataPathProxy.Prime(); //reprime the datapath ready for another play
	
	err = dataPathProxy.Play();
	if (err)
		{
		verdict = EFail;
		INFO_PRINTF2(_L("Failure to replay error = %d" ), err );
		}
	else
		{
		dataPathEventMonitor->Start();
		iActiveScheduler->Start(); //start the active scheduler
		}

	//check source and sink are both in the stop state
	if (castedTestDataSource->State() != EStopped) verdict = EFail;
	if (castedTestDataSink->State() != EStopped) verdict = EFail;

	//check that the play was stopped by an EOF
	ResultOfPlay = dataPathEventMonitorObserver->EventReceived();
	if ((ResultOfPlay.iEventType != KMMFEventCategoryPlaybackComplete)
		|| (ResultOfPlay.iErrorCode != KErrNone))
		{
		verdict = EFail;
		INFO_PRINTF2(_L("error during play = %d" ), ResultOfPlay.iErrorCode );
		}

	//this time the expected start and end framenumbers should be the full play window
	if (castedTestDataSource->FirstFrame() != 1) verdict = EFail;
	if (castedTestDataSource->CurrentFrame() != 6) verdict = EFail;

	delete dataPathEventMonitorObserver;
	delete dataPathEventMonitor;
	}

 dataPathProxy.Close();
 delete testDataSource;
 delete testDataSink;
 delete testFormatDecode;

 return verdict;
 }

//368-379 reserved for any other positioning tests 

 CTestStep_MMF_BASECL_U_0380::CTestStep_MMF_BASECL_U_0380()
/** Constructor
 */
 {
 iTestStepName = _L("MM-MMF-BASECL-U-0380-HP");
 }
 

TVerdict CTestStep_MMF_BASECL_U_0380::DoTestStepL( void )
/** Verfiy RMMFDataPathProxy OOM 
 * Use case: N/A
 * @test Req. under test REQ172.7.23
 */
	{

	INFO_PRINTF1( _L("RThread::Heap() not support on EKA2, pass test") );
	return EPass;
	
	}
	
//
// RTestStep_RateConvertBase - base class for rate converter
//

RTestStep_RateConvertBase::RTestStep_RateConvertBase():
	iFromRate(8000), iToRate(8000)
	{
	for (TInt i=0; i<KNumBuffers; i++)
		{
		iInputBuffer[i] = NULL;
		iOutputBuffer[i] = NULL;
		}
	}
	
void RTestStep_RateConvertBase::CloseTest()
	{
	for (TInt i=0; i<KNumBuffers; i++)
		{
		delete iInputBuffer[i];
		iInputBuffer[i] = NULL;
		delete iOutputBuffer[i];
		iOutputBuffer[i] = NULL;
		}
	iFs.Close();
	}
	
//
// Read params from .ini file
void RTestStep_RateConvertBase::SetupParams()
	{
	if (!GetIntFromConfig(iDefaultParamSet, _L("FromRate"), iFromRate))
 		{
 		INFO_PRINTF3(_L("%S::FromRate not found in config file - use default %d"), &iDefaultParamSet, iFromRate);
 		}
	if (!GetIntFromConfig(iDefaultParamSet, _L("ToRate"), iToRate))
 		{
 		INFO_PRINTF3(_L("%S::ToRate not found in config file - use default %d"), &iDefaultParamSet, iToRate);
 		}
	if (!GetIntFromConfig(iDefaultParamSet, _L("FromChannels"), iFromChannels))
 		{
 		INFO_PRINTF3(_L("%S::FromChannels not found in config file - use default %d"), &iDefaultParamSet, iFromChannels);
 		}
	if (!GetIntFromConfig(iDefaultParamSet, _L("ToChannels"), iToChannels))
 		{
 		INFO_PRINTF3(_L("%S::ToChannels not found in config file - use default %d"), &iDefaultParamSet, iToChannels);
 		}
 	TPtrC fileToCompare;
	if(GetStringFromConfig(iDefaultParamSet, _L("FileToCompare"), fileToCompare))
		{
		iFileToCompare = fileToCompare;
		}
	else
		{
 		INFO_PRINTF2(_L("%S::FileToCompare not found in config file - skip compare"), &iDefaultParamSet);
		}
	if (!GetIntFromConfig(iDefaultParamSet, _L("ExpectedDestinationBufferSize"), iExpectedDestinationBufferSize))
 		{
 		INFO_PRINTF2(_L("%S::ExpectedDestinationBufferSize not found in config file - skip check"), &iDefaultParamSet);
 		}
	}


TInt RTestStep_RateConvertBase::CompareFilesL(const TDesC& aReference, const TDesC& aGenerated)
	{
	RFileReadStream referenceStream;
	CleanupClosePushL(referenceStream);
	TInt error = referenceStream.Open(iFs,aReference,0);
	if (error)
		{
		ERR_PRINTF3(_L("Can't open reference file %S (%d)"), &aReference, error);
		User::Leave(error);
		}
	
	RFileReadStream generatedStream;
	CleanupClosePushL(generatedStream);
	error = generatedStream.Open(iFs,aGenerated,0);
	if (error)
		{
		ERR_PRINTF3(_L("Can't open generated file %S (%d)"), &aGenerated, error);
		User::Leave(error);
		}
	
	TInt result = 0;
	TInt offset = 0;
	for (;;)
		{
		TInt refVal = 0;
		TRAPD(err1, refVal = referenceStream.ReadInt16L());
		
		TInt genVal = 0;
		TRAPD(err2, genVal = generatedStream.ReadInt16L());
		
		if (err1 || err2)
			{
			if (err1==KErrEof && err2==KErrEof)
				{
				// normal exit
				break;
				}
			else
				{
				ERR_PRINTF4(_L("Unexpected error after word %d (%d,%d)"), offset, err1, err2);
				result = -1;
				break;				
				}
			}
		if (refVal != genVal)
			{
			result = refVal - genVal;
			INFO_PRINTF4(_L("Files differ at word %d, (%d vs %d)"), offset, refVal, genVal);
			break;
			}
		offset += 1;
		}
	CleanupStack::PopAndDestroy(2, &referenceStream);
	return result;
	}



//
// RTestStep_MMF_BASECL_U_1000 - sample rate converter test
//

RTestStep_MMF_BASECL_U_1000* RTestStep_MMF_BASECL_U_1000::NewL()
	{
	RTestStep_MMF_BASECL_U_1000* result = new (ELeave) RTestStep_MMF_BASECL_U_1000;
	return result;
	}

RTestStep_MMF_BASECL_U_1000::RTestStep_MMF_BASECL_U_1000():
	iConverter(NULL), iFactory(NULL)
	{
	iTestStepName = _L("MM-MMF-BASECL-U-1000-HP");
	iHeapSize = 1024*1024; // allow 1M
	}
	
void RTestStep_MMF_BASECL_U_1000::CloseTest()
	{
	delete iFactory; iFactory = NULL;
	RTestStep_RateConvertBase::CloseTest();
	}
	
void RTestStep_MMF_BASECL_U_1000::KickoffTestL()
	{
	// reset the defaults 
	iFromRate = iToRate = 8000;
	iFromChannels = iToChannels = 1;
	iExpectedDestinationBufferSize = -1;
	iFileToCompare.Zero();
	iConverter = NULL;
	
	// read params from .ini file
	SetupParams();

 	INFO_PRINTF5(_L("Test conversion from %d to %d Samples/sec. Channels from %d to %d"), 
 				iFromRate, iToRate, iFromChannels, iToChannels);
	
	User::LeaveIfError(iFs.Connect());
	iFactory = new (ELeave) CMMFChannelAndSampleRateConverterFactory;
	
	iConverter = iFactory->CreateConverterL(iFromRate, iFromChannels, iToRate, iToChannels); 
	
	// we want to configure tone generator and give us 4 buffers worth of 100Hz data
	iToneGen.SetFrequencyAndDuration(100,10000000); // 100Hz, 10s - much longer than we need!
	iToneGen.Configure(
		iFromRate, // 8Khz
		iFromChannels,	  // mono
		0,
		0,
		0
		);

	for (TInt i=0; i<KNumBuffers; i++)
		{
		iInputBuffer[i] = CMMFDataBuffer::NewL(KBasicBufferSize);
		User::LeaveIfError(iToneGen.FillBuffer(iInputBuffer[i]->Data()));
		}

	RFileWriteStream writeStream;
#if 0
	// if required for debugging, write initial buffers to C:/Generated100HzTone.raw
	CleanupClosePushL(writeStream);
	User::LeaveIfError(writeStream.Replace(iFs, _L("C:\\Generated100HzTone.raw"),EFileWrite));
	for (TInt i=0; i<KNumBuffers; i++)
		{
		writeStream.WriteL(iInputBuffer[i]->Data());
		}
	writeStream.CommitL();
	CleanupStack::PopAndDestroy(&writeStream);
#endif
	
	// convert input to output
	for (TInt i=0; i<KNumBuffers; i++)
		{
		// allow plenty of room in output buffers. Worse case is mono->stereo and upsample together
		iOutputBuffer[i] = CMMFDataBuffer::NewL(KBasicBufferSize*4); 
		TInt destSize = iConverter->Convert(*(iInputBuffer[i]), *(iOutputBuffer[i]));
		if (iOutputBuffer[i]->Data().Length()!=destSize)
			{
	 		ERR_PRINTF4(_L("Output buffer size (%d) not that returned (%d) (iteration %d)"), iOutputBuffer[i]->Data().Length(), destSize, i);
			StopTest(KErrNone, EFail);
			return;
			}
		}
	
	// save output
	CleanupClosePushL(writeStream);
	TFileName outputFileName;
	outputFileName.Format(_L("C:\\Converted100HzTone%d_%d_%d_%d.raw"), 
					iFromRate, iFromChannels, iToRate, iToChannels);
	User::LeaveIfError(writeStream.Replace(iFs, outputFileName, EFileWrite));
	for (TInt i=0; i<KNumBuffers; i++)
		{
		writeStream.WriteL(iOutputBuffer[i]->Data());
		}
	writeStream.CommitL();
	CleanupStack::PopAndDestroy(&writeStream);
	
	if (iFileToCompare.Length()>0)
		{
		TInt compareResult = CompareFilesL(iFileToCompare, outputFileName);
		if (compareResult!=0)
			{
			StopTest(EFail);
			return;
			}
		}
		
	if (iExpectedDestinationBufferSize>=0)
		{
		TInt destinationBufferSize = iConverter->MaxConvertBufferSize(KBasicBufferSize);
		if (destinationBufferSize != iExpectedDestinationBufferSize)
			{
	 		INFO_PRINTF3(_L("Found destination buffer size (%d) not that expected (%d)"), destinationBufferSize, iExpectedDestinationBufferSize);
	 		StopTest(EFail);
			return;
			}
		}
	
	StopTest(); // normal end of test
	}
	
//
// RTestStep_MMF_BASECL_U_1100 - internal sample rate converter test
//

RTestStep_MMF_BASECL_U_1100* RTestStep_MMF_BASECL_U_1100::NewL()
	{
	RTestStep_MMF_BASECL_U_1100* result = new (ELeave) RTestStep_MMF_BASECL_U_1100;
	return result;
	}

RTestStep_MMF_BASECL_U_1100::RTestStep_MMF_BASECL_U_1100():
	iConverter(NULL)
	{
	iTestStepName = _L("MM-MMF-BASECL-U-1100-HP");
	iHeapSize = 1024*1024; // allow 1M
	}
	
void RTestStep_MMF_BASECL_U_1100::CloseTest()
	{
	delete iConverter; iConverter = NULL;
	RTestStep_RateConvertBase::CloseTest();
	}
	
void RTestStep_MMF_BASECL_U_1100::KickoffTestL()
	{
	// reset the defaults 
	iFromRate = iToRate = 8000;
	iFromChannels = iToChannels = 1;
	iExpectedDestinationBufferSize = -1;
	iFileToCompare.Zero();
	iConverter = NULL;
	// read params from .ini file
	SetupParams();

 	INFO_PRINTF5(_L("Test conversion from %d to %d Samples/sec. Channels from %d to %d"), 
 				iFromRate, iToRate, iFromChannels, iToChannels);
	
	User::LeaveIfError(iFs.Connect());
	
	iConverter = CChannelAndSampleRateConverter::CreateL(iFromRate, iFromChannels, iToRate, iToChannels); 
		
	// we want to configure tone generator and give us 4 buffers worth of 100Hz data
	iToneGen.SetFrequencyAndDuration(100,10000000); // 100Hz, 10s - much longer than we need!
	iToneGen.Configure(
		iFromRate, // 8Khz
		iFromChannels,	  // mono
		0,
		0,
		0
		);

	for (TInt i=0; i<KNumBuffers; i++)
		{
		iInputBuffer[i] = CMMFDataBuffer::NewL(KBasicBufferSize);
		User::LeaveIfError(iToneGen.FillBuffer(iInputBuffer[i]->Data()));
		}

	RFileWriteStream writeStream;
#if 0
	// if required for debugging, write initial buffers to C:/Generated100HzTone.raw
	CleanupClosePushL(writeStream);
	User::LeaveIfError(writeStream.Replace(iFs, _L("C:\\Generated100HzTone.raw"),EFileWrite));
	for (TInt i=0; i<KNumBuffers; i++)
		{
		writeStream.WriteL(iInputBuffer[i]->Data());
		}
	writeStream.CommitL();
	CleanupStack::PopAndDestroy(&writeStream);
#endif
	
	// convert input to output
	for (TInt i=0; i<KNumBuffers; i++)
		{
		// allow plenty of room in output buffers. Worse case is mono->stereo and upsample together
		iOutputBuffer[i] = CMMFDataBuffer::NewL(KBasicBufferSize*4); 
		TInt sizeConverted = iConverter->Convert((iInputBuffer[i])->Data(), (iOutputBuffer[i])->Data());
		if (iInputBuffer[i]->Data().Length()!=sizeConverted)
			{
			// since the output buffer size should be big enough, expect to convert who of input buffers
	 		ERR_PRINTF4(_L("Input buffer size (%d) not that returned (%d) (iteration %d)"), iInputBuffer[i]->Data().Length(), sizeConverted, i);
			StopTest(KErrNone, EFail);
			return;
			}
		}
	
	// save output
	CleanupClosePushL(writeStream);
	TFileName outputFileName;
	outputFileName.Format(_L("C:\\Converted100HzTone%d_%d_%d_%d.raw"), 
					iFromRate, iFromChannels, iToRate, iToChannels);
	User::LeaveIfError(writeStream.Replace(iFs, outputFileName, EFileWrite));
	for (TInt i=0; i<KNumBuffers; i++)
		{
		writeStream.WriteL(iOutputBuffer[i]->Data());
		}
	writeStream.CommitL();
	CleanupStack::PopAndDestroy(&writeStream);
	
	if (iFileToCompare.Length()>0)
		{
		TInt compareResult = CompareFilesL(iFileToCompare, outputFileName);
		if (compareResult!=0)
			{
			StopTest(EFail);
			return;
			}
		}
		
	if (iExpectedDestinationBufferSize>=0)
		{
		TInt destinationBufferSize = iConverter->MaxConvertBufferSize(KBasicBufferSize);
		if (destinationBufferSize != iExpectedDestinationBufferSize)
			{
	 		ERR_PRINTF3(_L("Found destination buffer size (%d) not that expected (%d)"), destinationBufferSize, iExpectedDestinationBufferSize);
	 		StopTest(EFail);
			return;
			}
		}
	
	StopTest(); // normal end of test
	}
	
//
// RTestStep_MMF_BASECL_U_1200 - internal sample rate converter test with short buffers
//

RTestStep_MMF_BASECL_U_1200* RTestStep_MMF_BASECL_U_1200::NewL()
	{
	RTestStep_MMF_BASECL_U_1200* result = new (ELeave) RTestStep_MMF_BASECL_U_1200;
	return result;
	}

RTestStep_MMF_BASECL_U_1200::RTestStep_MMF_BASECL_U_1200():
	iConverter(NULL)
	{
	iTestStepName = _L("MM-MMF-BASECL-U-1200-HP");
	iHeapSize = 1024*1024; // allow 1M
	}
	
void RTestStep_MMF_BASECL_U_1200::CloseTest()
	{
	delete iConverter; 
	iConverter = NULL;
	iOutpBuffer.Close();
	RTestStep_RateConvertBase::CloseTest();
	}
	
void RTestStep_MMF_BASECL_U_1200::KickoffTestL()
	{
	// reset the defaults 
	iFromRate = iToRate = 8000;
	iFromChannels = iToChannels = 1;
	iExpectedDestinationBufferSize = -1;
	iOutputBufferSize = 1024;
	iFileToCompare.Zero();
	iConverter = NULL;
	// read params from .ini file
	SetupParams();
	if (!GetIntFromConfig(iDefaultParamSet, _L("OutputBufferSize"), iExpectedDestinationBufferSize))
 		{
 		INFO_PRINTF2(_L("%S::OutputBufferSize not found in config file - use default"), &iDefaultParamSet);
 		}

 	INFO_PRINTF6(_L("Test conversion from %d to %d Samples/sec. Channels from %d to %d. Output buffer size %d"), 
 				iFromRate, iToRate, iFromChannels, iToChannels, iOutputBufferSize);
	
	User::LeaveIfError(iFs.Connect());
	
	iConverter = CChannelAndSampleRateConverter::CreateL(iFromRate, iFromChannels, iToRate, iToChannels); 
		
	// we want to configure tone generator and give us 4 buffers worth of 100Hz data
	iToneGen.SetFrequencyAndDuration(100,10000000); // 100Hz, 10s - much longer than we need!
	iToneGen.Configure(
		iFromRate, // 8Khz
		iFromChannels,	  // mono
		0,
		0,
		0
		);

	for (TInt i=0; i<KNumBuffers; i++)
		{
		iInputBuffer[i] = CMMFDataBuffer::NewL(KBasicBufferSize);
		User::LeaveIfError(iToneGen.FillBuffer(iInputBuffer[i]->Data()));
		}

	RFileWriteStream writeStream;
#if 0
	// if required for debugging, write initial buffers to C:/Generated100HzTone.raw
	CleanupClosePushL(writeStream);
	User::LeaveIfError(writeStream.Replace(iFs, _L("C:\\Generated100HzTone.raw"),EFileWrite));
	for (TInt i=0; i<KNumBuffers; i++)
		{
		writeStream.WriteL(iInputBuffer[i]->Data());
		}
	writeStream.CommitL();
	CleanupStack::PopAndDestroy(&writeStream);
#endif
	
	// the forloop of the simple 1000 and 1100 tests is more complex because we don't
	// necessarily convert all input buffer on each loop
	
	TInt inputCount = 0;
	TInt inputOffset = 0;
	iOutpBuffer.CreateL(iOutputBufferSize);
	
	// output file
	CleanupClosePushL(writeStream);
	TFileName outputFileName;
	outputFileName.Format(_L("C:\\Converted100HzTone%d_%d_%d_%d.raw"), 
					iFromRate, iFromChannels, iToRate, iToChannels);
	User::LeaveIfError(writeStream.Replace(iFs, outputFileName, EFileWrite));

	for(;;)
		{
		TPtrC8 bufferDescriptor (iInputBuffer[inputCount]->Data());
		TPtrC8 inputBuffer = bufferDescriptor.Mid(inputOffset);
		TInt sizeConverted = iConverter->Convert(inputBuffer, iOutpBuffer);
		writeStream.WriteL(iOutpBuffer);
		if (sizeConverted > inputBuffer.Length())
			{
	 		ERR_PRINTF3(_L("Size converted (%d) exceeded input buffer size (%d)"), sizeConverted, inputBuffer.Length());
	 		CleanupStack::PopAndDestroy(&writeStream);
	 		StopTest(EFail);
			return;			
			}
		else if (sizeConverted < inputBuffer.Length())
			{
			inputOffset += sizeConverted;
			}
		else
			{
			ASSERT(sizeConverted==inputBuffer.Length());
			inputCount += 1;
			inputOffset = 0;
			if (inputCount==KNumBuffers)
				{
				break; // normal end of loop
				}
			}
		}
	
	writeStream.CommitL();
	CleanupStack::PopAndDestroy(&writeStream);
	
	if (iFileToCompare.Length()>0)
		{
		TInt compareResult = CompareFilesL(iFileToCompare, outputFileName);
		if (compareResult!=0)
			{
			StopTest(EFail);
			return;
			}
		}
		
	if (iExpectedDestinationBufferSize>=0)
		{
		TInt destinationBufferSize = iConverter->MaxConvertBufferSize(KBasicBufferSize);
		if (destinationBufferSize != iExpectedDestinationBufferSize)
			{
	 		INFO_PRINTF3(_L("Found destination buffer size (%d) not that expected (%d)"), destinationBufferSize, iExpectedDestinationBufferSize);
	 		StopTest(EFail);
			return;
			}
		}
	
	StopTest(); // normal end of test
	}
