// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Unicode character information tables.
// Written by the READTYPE program.
// Please read the 'Unicode Character Data and Line Break data Update History.doc' file for detailed history of updates to this file.
// This file was generated by the READTYPE tool using UCD 5.0.
// The contents of this file were generated automatically. Please do not edit this manually.
//
//

#include <unicode.h>


// Declarations for tables held in unitable.cpp and used by unicode.cpp.
extern const TStandardUnicodeDataSet TheStandardUnicodeDataSet[];
extern const TUnicodePlane ThePlanes[17];


const TUint16 ThePlane00TrieIndex1[4096] = 
	{
	0x0000,0x000e,0x001e,0x002e,0x003d,0x0042,0x0052,0x0057,0x0066,0x8000,0x0076,0x0086,0x8010,0x0096,0x8013,0x00a6,
	0x00b6,0x00b6,0x00b6,0x00c6,0x00d0,0x00b6,0x00b6,0x00da,0x00ea,0x00fa,0x010a,0x011a,0x012a,0x0138,0x00b6,0x0148,
	0x00b6,0x00b6,0x0158,0x0164,0x0173,0x0183,0x0193,0x01a3,0x01b3,0x01c1,0x8016,0x01d1,0x01df,0x01ef,0x01ff,0x8011,
	0x805b,0x020f,0x021e,0x022a,0x0237,0x0247,0x0254,0x0264,0x0273,0x0283,0x0291,0x02a1,0x02af,0x02bf,0x00b6,0x02cf,
	0x807a,0x8010,0x8010,0x8013,0x8013,0x8075,0x00b6,0x00b6,0x02df,0x00b6,0x00b6,0x00b6,0x02ef,0x00b6,0x00b6,0x00b6,
	0x00b6,0x02ff,0x8065,0x030e,0x807f,0x0317,0x0327,0x8081,0x0330,0x033f,0x034d,0x035d,0x036d,0x8096,0x037d,0x038d,
	0x039d,0x03ad,0x03bd,0x03c2,0x03d2,0x03e2,0x03f2,0x0402,0x809a,0x809a,0x809a,0x809a,0x809a,0x040e,0x041d,0x042d,
	0x043d,0x044d,0x809a,0x045d,0x046c,0x809a,0x03bf,0x8065,0x809a,0x809a,0x0479,0x0488,0x0498,0x8096,0x04a2,0x04b0,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x04bf,0x8039,0x8039,0x04c5,0x04d4,0x04e4,0x04f2,0x0502,0x0512,0x051e,0x0525,0x0534,0x0543,0x0552,0x0561,0x0571,
	0x0580,0x051e,0x0525,0x058f,0x059e,0x05ac,0x05bb,0x05cb,0x05da,0x05e6,0x0525,0x05f5,0x0604,0x0614,0x0561,0x0623,
	0x0512,0x051e,0x0525,0x0633,0x0641,0x064f,0x065e,0x066e,0x067c,0x068b,0x069b,0x06a9,0x06b9,0x06c7,0x06d1,0x06e1,
	0x06f0,0x06fc,0x0525,0x0708,0x0717,0x0725,0x065e,0x8065,0x0733,0x06fc,0x0525,0x073c,0x074c,0x075a,0x0561,0x0769,
	0x0733,0x06fc,0x0525,0x06a9,0x0779,0x06c7,0x065e,0x8065,0x0787,0x0790,0x8039,0x079e,0x07ae,0x07bd,0x8065,0x07cd,
	0x07dc,0x8039,0x8039,0x07eb,0x07fb,0x080b,0x8065,0x8065,0x081a,0x0828,0x0838,0x0847,0x0857,0x0867,0x8065,0x8065,
	0x0877,0x0884,0x0894,0x08a0,0x05e0,0x8039,0x08b0,0x08bf,0x08cf,0x08df,0x8062,0x08e8,0x08f6,0x0906,0x8065,0x8065,
	0x8039,0x8039,0x0916,0x0925,0x0935,0x0945,0x8065,0x8065,0x8065,0x8065,0x80c6,0x80c6,0x0955,0x8039,0x8039,0x0965,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x0975,0x8039,0x8039,0x8039,0x8039,0x097c,0x8039,0x8039,0x8039,0x8039,0x0984,
	0x8039,0x8039,0x8039,0x8039,0x0994,0x09a4,0x8039,0x8039,0x0994,0x8039,0x8039,0x099c,0x09ac,0x05e1,0x8039,0x8039,
	0x8039,0x09ac,0x8039,0x8039,0x8039,0x09b4,0x09c4,0x09d1,0x8039,0x09e1,0x8039,0x8039,0x8039,0x8039,0x8039,0x09f1,
	0x07dc,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x0a01,0x0a10,0x0a20,0x0a25,0x8039,0x8039,0x8039,0x8039,0x0a35,0x0a44,
	0x0521,0x0a54,0x8039,0x0a64,0x8039,0x0a74,0x0521,0x0a84,0x8039,0x8039,0x8039,0x0a94,0x0aa2,0x0ab0,0x0ac0,0x0ad0,
	0x0ae0,0x0af0,0x8039,0x8039,0x0b00,0x8039,0x8039,0x0b08,0x8039,0x8039,0x0b18,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8039,0x0b28,0x0b38,0x0b48,0x0b58,0x8039,0x0b68,0x09f1,0x8039,0x8039,0x0984,0x80ac,0x0b78,0x0b88,0x8015,0x8015,
	0x8039,0x0b98,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x0ba8,0x8039,0x8039,0x0bb4,0x0bc2,0x0bd2,0x0be1,0x0bee,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8016,0x8016,0x0bfe,0x8059,0x8059,0x8059,0x0c0c,0x0c14,0x8016,0x01c6,0x8059,0x8059,0x0c24,0x8065,0x8065,0x0c2f,
	0x00b6,0x00b6,0x00b6,0x00b6,0x00b6,0x00b6,0x00b6,0x00b6,0x00b6,0x0c3f,0x00b6,0x00b6,0x00b6,0x00b6,0x00b6,0x0c4f,
	0x0c5f,0x0c6f,0x0c5f,0x0c5f,0x0c6f,0x0c7f,0x0c5f,0x0c8f,0x0c9f,0x0c9f,0x0c9f,0x0caf,0x0cbe,0x0cce,0x0cde,0x0cee,
	0x0cfe,0x0d0e,0x0d1e,0x0d2e,0x0d3d,0x0d4b,0x0d5b,0x0d6b,0x0d7b,0x0d8b,0x8007,0x0d9b,0x8065,0x0dab,0x0dba,0x8065,
	0x0dca,0x0dda,0x0de8,0x0df8,0x0e08,0x0e17,0x0e27,0x0e37,0x0e47,0x0e57,0x0e67,0x8015,0x0e76,0x0e86,0x8015,0x0e92,
	0x0ea1,0x0eb0,0x0ebb,0x0ec7,0x0ed2,0x0ee0,0x0eef,0x800e,0x0efd,0x0f0c,0x0f1a,0x0f21,0x0f31,0x0f3d,0x0f43,0x800e,
	0x0f53,0x8015,0x0f5d,0x0f68,0x807b,0x807b,0x807b,0x0f6e,0x8015,0x0f7b,0x800f,0x0f87,0x8015,0x0f8b,0x0f99,0x8065,
	0x8015,0x8015,0x0fa9,0x8065,0x0fb9,0x8065,0x810c,0x0fc9,0x0fd1,0x0fd9,0x807b,0x0fe5,0x810f,0x8110,0x0ff5,0x1000,
	0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x0e6e,0x0e74,0x8015,0x8015,0x0e8e,
	0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x1010,0x8015,0x8015,0x1020,0x1030,0x103d,0x8065,0x8065,0x8065,0x8065,
	0x104c,0x8015,0x1058,0x8015,0x1061,0x1070,0x107f,0x1089,0x1099,0x10a5,0x8015,0x10ac,0x10bc,0x10cc,0x10db,0x800f,
	0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,
	0x800f,0x800f,0x800f,0x800f,0x800f,0x800f,0x800f,0x800f,0x10eb,0x10f3,0x800e,0x1103,0x1113,0x1121,0x1130,0x113c,
	0x114a,0x1154,0x1162,0x1171,0x800f,0x1180,0x118c,0x119b,0x800e,0x800e,0x11a7,0x800e,0x800e,0x11b6,0x11c5,0x11d4,
	0x8015,0x0fb9,0x11e4,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x807f,0x807f,0x030f,0x8081,0x8081,0x11f4,0x1204,0x1211,0x00b6,0x00b6,0x00b6,0x00b6,0x00b6,0x00b6,0x1221,0x122c,
	0x811d,0x811d,0x123c,0x8039,0x8039,0x8039,0x124c,0x8065,0x8039,0x0a10,0x125c,0x125c,0x125c,0x125c,0x8065,0x8065,
	0x126c,0x127a,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8015,0x128a,0x8015,0x8015,0x8015,0x8015,0x8015,0x11e4,
	0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x8015,0x1295,0x8065,0x12a5,
	0x12b5,0x12c3,0x12d3,0x12e3,0x07dc,0x8039,0x8039,0x8039,0x8039,0x12f3,0x1303,0x8039,0x8039,0x8039,0x8039,0x1308,
	0x07d8,0x8039,0x0b28,0x07dc,0x8039,0x8039,0x8039,0x8039,0x1317,0x1327,0x8039,0x0b08,0x8015,0x8065,0x8065,0x8039,
	0x807b,0x132d,0x133d,0x807b,0x1349,0x1359,0x807b,0x1369,0x1379,0x807b,0x807b,0x1388,0x1398,0x807b,0x807b,0x13a8,
	0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x807b,0x139d,0x807b,0x807b,0x807b,0x807b,0x807b,0x13b8,0x807b,0x13c8,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x13d8,0x8015,0x8015,0x8015,0x8015,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x0b04,0x8065,0x8065,0x8065,0x8065,
	0x8039,0x13e8,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x0b28,0x8015,0x8015,0x8015,0x0fa9,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8011,0x13f8,0x1408,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x1418,0x8039,0x1425,0x8065,0x8039,0x8039,0x8039,0x1435,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x1445,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,
	0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,
	0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,
	0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,
	0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,
	0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,
	0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,
	0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,0x812b,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x0b68,0x8039,0x8039,0x8039,0x08b0,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x0984,0x8065,0x8065,
	0x1455,0x1462,0x1471,0x147b,0x148b,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x149b,0x8065,0x14a8,0x809a,0x809a,
	0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,
	0x809a,0x809a,0x809a,0x14ab,0x8065,0x809a,0x809a,0x809a,0x809a,0x14a9,0x809a,0x809a,0x14bb,0x8065,0x8065,0x14cb,
	0x8062,0x14db,0x14eb,0x14fb,0x1507,0x1517,0x1527,0x1537,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x809a,0x153d,
	0x154d,0x155d,0x003d,0x0042,0x0052,0x156d,0x157d,0x1316,0x8039,0x1583,0x8039,0x1317,0x1593,0x159b,0x15ab,0x15ba
	};
const TUint16 ThePlane00TrieIndex2[5578] = 
	{
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0x0002,0x0001,0x0003,0x0002,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0002,0x0002,0x0002,0x0001,0x0004,0x0005,
	0x0005,0x0006,0x0007,0x0006,0x0005,0x0005,0x0008,0x0009,0x0005,0x000a,0x000b,0x000c,0x000b,0x000b,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000b,0x0005,0x000e,0x000f,0x000e,0x0005,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0008,0x0005,0x0009,0x0011,0x0012,0x0011,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,
	0x0013,0x0013,0x0008,0x000f,0x0009,0x000f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0002,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0014,0x0005,0x0007,0x0007,0x0007,0x0007,0x0015,0x0015,0x0011,0x0015,
	0x0016,0x0017,0x000f,0x0018,0x0015,0x0011,0x0019,0x001a,0x001b,0x001b,0x0011,0x001c,0x0015,0x0005,0x0011,0x001d,0x0016,0x001e,0x001f,0x001f,0x001f,0x0005,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x000f,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0016,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x000f,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0020,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,
	0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0023,0x0024,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0016,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0016,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,
	0x0021,0x0022,0x0025,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0026,0x0027,0x0028,0x0021,0x0022,0x0021,0x0022,0x0029,0x0021,0x0022,0x002a,0x002a,0x0021,0x0022,0x0016,0x002b,0x002c,0x002d,0x0021,0x0022,0x002a,0x002e,0x002f,
	0x0030,0x0031,0x0021,0x0022,0x0032,0x0016,0x0030,0x0033,0x0034,0x0035,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0036,0x0021,0x0022,0x0036,0x0016,0x0016,0x0021,0x0022,0x0036,0x0021,0x0022,0x0037,0x0037,0x0021,0x0022,0x0021,
	0x0022,0x0038,0x0021,0x0022,0x0016,0x0039,0x0021,0x0022,0x0016,0x003a,0x0039,0x0039,0x0039,0x0039,0x003b,0x003c,0x003d,0x003b,0x003c,0x003d,0x003b,0x003c,0x003d,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,
	0x0022,0x0021,0x0022,0x0021,0x0022,0x003e,0x0021,0x0022,0x0016,0x003b,0x003c,0x003d,0x0021,0x0022,0x003f,0x0040,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0041,0x0016,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,
	0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0042,0x0021,0x0022,0x0043,0x0044,0x0016,0x0021,0x0022,0x0045,0x0046,0x0047,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,
	0x0022,0x0021,0x0022,0x0016,0x0016,0x0016,0x0048,0x0049,0x0016,0x004a,0x004a,0x0016,0x004b,0x0016,0x004c,0x0016,0x0016,0x0016,0x0016,0x004a,0x0016,0x0016,0x004d,0x0016,0x0016,0x0016,0x0016,0x004e,0x004f,0x0016,0x0050,0x0016,
	0x0016,0x0016,0x004f,0x0016,0x0016,0x0051,0x0016,0x0016,0x0052,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0053,0x0016,0x0016,0x0054,0x0016,0x0016,0x0054,0x0016,0x0016,0x0016,0x0016,0x0054,0x0055,0x0056,0x0056,0x0057,
	0x0016,0x0016,0x0016,0x0058,0x0016,0x0039,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0059,0x0059,0x0059,0x0059,0x0059,0x0059,0x0059,0x0059,0x0059,0x005a,0x005a,0x0059,0x0059,0x0059,0x0059,
	0x0059,0x0011,0x0011,0x0011,0x0011,0x005a,0x005a,0x005a,0x005a,0x005a,0x005a,0x005a,0x005a,0x005a,0x005a,0x0059,0x0059,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0059,
	0x0059,0x0059,0x0059,0x0059,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0059,0x0011,0x005b,0x005b,0x005b,0x005b,0x005b,0x005c,0x005d,0x005d,0x005d,0x005d,0x005c,0x005e,0x005d,0x005d,0x005d,0x005d,0x005f,
	0x005f,0x005d,0x005d,0x005d,0x005d,0x005f,0x005f,0x005d,0x005d,0x005d,0x005d,0x005d,0x005d,0x005d,0x0060,0x0060,0x0060,0x0060,0x0060,0x005d,0x005d,0x005d,0x005d,0x005b,0x005b,0x005b,0x005b,0x005b,0x0061,0x005b,0x005d,0x005d,
	0x005d,0x005b,0x005b,0x005b,0x005d,0x005d,0x0062,0x005b,0x005b,0x005b,0x005d,0x005d,0x005d,0x005d,0x005b,0x005c,0x005d,0x005d,0x005b,0x0063,0x0064,0x0064,0x0063,0x005b,0x005b,0x005b,0x005b,0x005b,0x005b,0x005b,0x005b,0x005b,
	0x005b,0x005b,0x005b,0x005b,0x0065,0x0065,0x0065,0x0065,0x0011,0x0011,0x0065,0x0065,0x0065,0x0065,0x0059,0x0034,0x0034,0x0034,0x0005,0x0065,0x0065,0x0065,0x0065,0x0011,0x0011,0x0066,0x0005,0x0067,0x0067,0x0067,0x0065,0x0068,
	0x0065,0x0069,0x0069,0x0016,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0065,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x006a,0x006b,0x006b,
	0x006b,0x0016,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x006c,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x006d,0x006e,0x006e,0x0065,0x006f,
	0x0070,0x0071,0x0071,0x0071,0x0072,0x0073,0x0016,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0074,0x0075,0x0076,0x0016,0x0077,0x0078,0x000f,0x0021,0x0022,0x0079,0x0021,0x0022,0x0016,0x0041,0x0041,0x0041,0x0021,
	0x0022,0x007b,0x005b,0x005b,0x005b,0x005b,0x0065,0x007c,0x007c,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x007d,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x007e,0x0021,
	0x0022,0x0021,0x0022,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x007f,0x007f,0x007f,0x007f,0x007f,0x007f,0x007f,0x007f,0x007f,0x007f,0x007f,0x007f,0x007f,0x007f,0x007f,0x0065,0x0065,
	0x0059,0x0080,0x0080,0x0080,0x0080,0x0080,0x0080,0x0065,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0016,0x0065,0x0080,0x0082,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x005d,0x005b,0x005b,0x005b,0x005b,0x005d,0x005b,0x005b,0x005b,0x0083,0x005d,0x005b,0x005b,0x005b,0x005b,0x005d,0x005d,0x005d,0x005d,0x005d,0x005d,0x005b,0x005b,0x005d,0x005b,0x005b,0x0083,0x0084,0x005b,0x0085,0x0086,0x0087,
	0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008e,0x008f,0x0090,0x0091,0x0092,0x0093,0x0092,0x0094,0x0095,0x0092,0x005b,0x005d,0x0092,0x008d,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0096,0x0096,0x0096,
	0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0065,0x0065,0x0065,0x0065,0x0065,0x0096,0x0096,0x0096,0x0092,0x0092,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0097,0x0097,0x0097,
	0x0097,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0098,0x000b,0x0099,0x0015,0x0015,0x005b,0x005b,0x005b,0x005b,0x005b,0x005b,0x0065,0x0065,0x0065,0x0065,0x0065,0x0099,0x0065,0x0065,0x0099,0x0099,0x0065,0x009a,0x009a,
	0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x0065,0x0065,0x0065,0x0065,0x0065,0x009b,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009c,0x009d,0x009e,
	0x009f,0x00a0,0x00a1,0x00a2,0x00a3,0x005b,0x005b,0x005d,0x005d,0x005b,0x005b,0x005b,0x005b,0x005b,0x005d,0x005b,0x005b,0x0065,0x00a4,0x00a4,0x00a4,0x00a4,0x00a4,0x00a4,0x00a4,0x00a4,0x00a4,0x00a4,0x0006,0x00a5,0x00a5,0x0099,
	0x009a,0x009a,0x00a6,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x0099,0x009a,0x005b,0x005b,0x005b,0x005b,0x005b,0x005b,0x005b,0x0097,0x007c,0x005b,0x005b,0x005b,
	0x005d,0x005b,0x009b,0x009b,0x005b,0x005b,0x0015,0x005d,0x005b,0x005b,0x005d,0x009a,0x009a,0x00a7,0x00a7,0x00a7,0x00a7,0x00a7,0x00a7,0x00a7,0x00a7,0x00a7,0x00a7,0x009a,0x009a,0x009a,0x00a8,0x00a8,0x009a,0x0099,0x0099,0x0099,
	0x0099,0x0099,0x0099,0x0099,0x0099,0x0099,0x0099,0x0099,0x0099,0x0099,0x0099,0x0065,0x0018,0x009a,0x00a9,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x005b,0x005d,0x005b,
	0x005b,0x005d,0x005b,0x005b,0x005d,0x005d,0x005d,0x005b,0x005d,0x005d,0x005b,0x005d,0x005b,0x005b,0x005d,0x005b,0x005d,0x005b,0x005d,0x005b,0x005d,0x005b,0x005b,0x0065,0x0065,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x0062,
	0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x009a,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00aa,0x00aa,0x00aa,0x00aa,0x00aa,0x00aa,0x00aa,0x00aa,
	0x00aa,0x00aa,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x005b,0x005b,0x005b,0x005b,0x005b,0x005d,0x005b,0x00ab,0x00ab,0x0015,0x0005,0x0005,0x0005,0x00ab,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0062,0x0062,0x00ac,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x00ad,0x0039,0x00ac,0x00ac,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x00ac,0x00ac,0x00ac,
	0x00ac,0x00ae,0x0065,0x0065,0x0039,0x005b,0x005d,0x005b,0x005b,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0062,0x0062,0x0080,0x0080,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,
	0x00af,0x00af,0x0080,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0062,0x00ac,0x00ac,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,
	0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,
	0x00ad,0x0039,0x00ac,0x00ac,0x0062,0x0062,0x0062,0x0062,0x0065,0x0065,0x00ac,0x00ac,0x0065,0x0065,0x00ac,0x00ac,0x00ae,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00ac,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,
	0x0065,0x0039,0x0039,0x0062,0x0062,0x0065,0x0065,0x00b0,0x00b0,0x00b0,0x00b0,0x00b0,0x00b0,0x00b0,0x00b0,0x00b0,0x00b0,0x0039,0x0039,0x0007,0x0007,0x00b1,0x00b1,0x00b1,0x00b1,0x00b2,0x00b3,0x007b,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0062,0x0062,0x00ac,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0039,0x0065,0x0039,0x0039,0x0065,0x0039,0x0039,0x0065,0x0039,0x0039,0x0065,0x0065,0x00ad,0x0065,0x00ac,0x00ac,0x0062,
	0x0062,0x0065,0x0065,0x0065,0x0065,0x0062,0x0062,0x0065,0x0065,0x0062,0x0062,0x00ae,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x0062,0x0062,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0062,0x0062,0x00ac,0x0065,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,
	0x0065,0x00ad,0x0039,0x00ac,0x00ac,0x0062,0x0062,0x0062,0x0062,0x0062,0x0065,0x0062,0x0062,0x00ac,0x0065,0x00ac,0x00ac,0x00ae,0x0065,0x0065,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0007,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0065,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x00ad,
	0x0039,0x00ac,0x0062,0x0062,0x0062,0x0065,0x0065,0x0065,0x00ac,0x00ac,0x0065,0x0065,0x00ac,0x00ac,0x00ae,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0062,0x00ac,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0065,0x0039,0x0039,
	0x0065,0x0065,0x0065,0x0065,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x00af,0x007b,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0062,0x0039,
	0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0039,0x0039,0x0065,0x0039,0x0065,0x0039,0x0039,0x0065,0x0065,0x0065,0x0039,0x0039,
	0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x00ac,0x00ac,0x0062,0x00ac,0x00ac,0x0065,0x0065,0x0065,0x00ac,
	0x00ac,0x00ac,0x0065,0x00ac,0x00ac,0x00ac,0x00ae,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00ac,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00b0,0x00b0,0x00b0,0x00b0,0x00b0,0x00b0,0x00b0,0x00b0,0x00b0,
	0x00b0,0x00b4,0x00b5,0x00b6,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0007,0x0015,0x0065,0x0065,0x0065,0x0065,0x0065,0x00ac,0x00ac,0x00ac,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0062,0x0062,0x00ac,0x00ac,0x00ac,0x00ac,0x0065,0x0062,0x0062,0x0062,
	0x0065,0x0062,0x0062,0x0062,0x00ae,0x0065,0x0065,0x0065,0x0065,0x0065,0x00b7,0x00b8,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00ac,0x00ac,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x00ad,0x0039,0x00ac,0x00b9,0x00ac,0x00ac,0x00ac,0x00ac,0x00ac,0x0065,0x00b9,0x00ac,0x00ac,0x0065,0x00ac,0x00ac,0x0062,0x00ae,0x0065,0x0065,0x0065,0x0065,0x0065,0x00ac,
	0x00ac,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0065,0x0015,0x0015,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00ac,0x0062,0x0062,0x0062,0x0065,0x0065,0x00ac,
	0x00ac,0x00ac,0x0065,0x00ac,0x00ac,0x00ac,0x00ae,0x0065,0x0065,0x00ac,0x00ac,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x00ae,0x0065,0x0065,0x0065,0x0065,0x00ac,0x00ac,0x0062,
	0x0062,0x0062,0x0065,0x0062,0x0065,0x00ac,0x00ac,0x00ac,0x00ac,0x00ac,0x00ac,0x00ac,0x00ac,0x0065,0x0065,0x00ac,0x00ac,0x0080,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0062,0x0039,0x0039,0x0062,0x0062,0x0062,0x0062,0x00ba,0x00ba,0x00ae,0x0065,0x0065,0x0065,0x0065,0x0007,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0059,0x0062,0x00bb,0x00bb,0x00bb,0x00bb,0x0062,0x0062,0x0062,0x0080,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x0080,0x0080,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0065,0x0039,0x0065,
	0x0065,0x0039,0x0039,0x0065,0x0039,0x0065,0x0065,0x0039,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0065,0x0039,0x0065,0x0039,
	0x0065,0x0065,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0062,0x0039,0x0039,0x0062,0x0062,0x0062,0x0062,0x00bd,0x00bd,0x0065,0x0062,0x0062,0x0039,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0059,0x0065,0x00be,
	0x00be,0x00be,0x00be,0x0062,0x0062,0x0065,0x0065,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x0065,0x0065,0x0039,0x0039,0x0065,0x0065,0x0039,0x007b,0x007b,0x007b,0x0080,0x0080,0x0080,0x0080,0x0080,
	0x0080,0x0080,0x0080,0x0080,0x0080,0x0080,0x0080,0x007b,0x007b,0x007b,0x007b,0x007b,0x005d,0x005d,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c1,0x00c1,
	0x00c1,0x00c1,0x00c1,0x00c1,0x007b,0x005d,0x007b,0x005d,0x007b,0x005e,0x0008,0x0009,0x0008,0x0009,0x00ac,0x00ac,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x00c2,0x00c3,0x0062,0x00c4,0x0062,0x0062,0x0062,0x0062,0x0062,0x00c3,0x00c3,0x00c3,0x00c3,0x0062,0x00ac,0x00c3,0x0062,0x005b,0x005b,0x00ae,0x0080,0x005b,0x005b,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0062,
	0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0065,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0065,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x005d,0x007b,0x007b,0x007b,
	0x007b,0x007b,0x007b,0x0065,0x0065,0x007b,0x0080,0x0080,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,
	0x0039,0x0065,0x00ac,0x0062,0x0062,0x0062,0x00ac,0x0062,0x0065,0x0065,0x0065,0x0062,0x00ad,0x00ac,0x00ae,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00c5,0x00c5,0x00c5,0x00c5,0x00c5,0x00c5,0x00c5,0x00c5,0x00c5,0x00c5,0x0080,
	0x0080,0x0080,0x0080,0x0080,0x0080,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x00ac,0x00ac,0x0062,0x0062,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00c6,0x00c6,0x00c6,0x00c6,0x00c6,0x00c6,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0080,0x0059,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,
	0x0039,0x0039,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,
	0x0065,0x0065,0x0065,0x005b,0x007b,0x0080,0x0080,0x0080,0x0080,0x0080,0x0080,0x0080,0x0080,0x00c7,0x00c7,0x00c7,0x00c7,0x00c7,0x00c7,0x00c7,0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,0x00d0,0x00d1,0x0065,0x0065,
	0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0080,0x0080,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0004,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0008,0x0009,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0080,0x0080,0x0080,0x00d2,0x00d2,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0062,0x0062,0x00ae,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0062,0x0062,0x00ae,0x0080,0x0080,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0062,0x0062,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0039,0x0065,0x0062,0x0062,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x00d3,0x00d3,0x00ac,0x0062,0x0062,0x0062,0x0062,0x0062,
	0x0062,0x0062,0x00ac,0x00ac,0x00ac,0x00ac,0x00ac,0x00ac,0x0062,0x00ac,0x00ac,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x00ae,0x0062,0x0080,0x0080,0x0080,0x0059,0x0080,0x0080,0x0080,0x0007,0x0039,0x005b,0x0065,0x0065,
	0x00d4,0x00d4,0x00d4,0x00d4,0x00d4,0x00d4,0x00d4,0x00d4,0x00d4,0x00d4,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00d5,0x00d5,0x00d5,0x00d5,0x00d5,0x00d5,0x00d5,0x00d5,0x00d5,0x00d5,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,0x0082,0x0005,0x0005,0x0005,0x0005,0x0062,0x0062,0x0062,0x0004,0x0065,0x00d6,0x00d6,0x00d6,0x00d6,0x00d6,0x00d6,0x00d6,0x00d6,0x00d6,0x00d6,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0039,0x0039,0x0039,0x0059,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0084,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0062,0x0062,0x0062,0x00ac,0x00ac,0x00ac,0x00ac,0x0062,
	0x0062,0x00d7,0x00d7,0x00d7,0x0065,0x0065,0x0065,0x0065,0x00ac,0x00ac,0x0062,0x00ac,0x00ac,0x00ac,0x00ac,0x00ac,0x00ac,0x0083,0x005b,0x005d,0x0065,0x0065,0x0065,0x0065,0x0015,0x0065,0x0065,0x0065,0x0005,0x0005,0x00d8,0x00d8,
	0x00d8,0x00d8,0x00d8,0x00d8,0x00d8,0x00d8,0x00d8,0x00d8,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x00ac,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x00ac,0x00ac,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x00bf,0x0065,0x0065,0x0065,0x0065,0x0005,0x0005,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x005b,
	0x005d,0x00ac,0x00ac,0x00ac,0x0065,0x0065,0x0080,0x0080,0x0062,0x0062,0x0062,0x0062,0x00ac,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x00ad,0x00ac,0x0062,0x0062,0x0062,0x0062,0x0062,0x00ac,
	0x0062,0x00ac,0x00ac,0x00ac,0x0062,0x00ac,0x00d9,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x00bc,0x0080,0x0080,0x0080,0x0080,
	0x0080,0x0080,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x005b,0x005d,0x005b,0x005b,0x005b,0x005b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0065,0x0065,0x0065,0x0016,0x0016,
	0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0059,0x0059,0x0059,0x0059,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0059,0x0016,0x0016,0x0016,
	0x0016,0x00da,0x0016,0x0016,0x005b,0x005b,0x005d,0x005b,0x005b,0x005b,0x005b,0x005b,0x005b,0x005b,0x005d,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x005b,0x005d,0x0021,
	0x0022,0x0021,0x0022,0x0021,0x0022,0x0016,0x0016,0x0016,0x0016,0x0016,0x00db,0x0065,0x0065,0x0065,0x0065,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00dc,
	0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,0x00dd,0x00dd,0x00dd,0x00dd,0x00dd,0x00dd,0x00dd,0x00dd,0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,0x0065,0x0065,0x00dd,0x00dd,0x00dd,0x00dd,0x00dd,0x00dd,0x0065,0x0065,0x0016,
	0x00dc,0x0016,0x00dc,0x0016,0x00dc,0x0016,0x00dc,0x0065,0x00dd,0x0065,0x00dd,0x0065,0x00dd,0x0065,0x00dd,0x00de,0x00de,0x00df,0x00df,0x00df,0x00df,0x00e0,0x00e0,0x00e1,0x00e1,0x00e2,0x00e2,0x00e3,0x00e3,0x0065,0x0065,0x00dc,
	0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,0x00e4,0x00e4,0x00e4,0x00e4,0x00e4,0x00e4,0x00e4,0x00e4,0x00dc,0x00dc,0x0016,0x00e5,0x0016,0x0065,0x0016,0x0016,0x00dd,0x00dd,0x00e6,0x00e6,0x00e7,0x0011,0x00e8,0x0011,0x0011,
	0x0016,0x00e5,0x0016,0x0065,0x0016,0x0016,0x00e9,0x00e9,0x00e9,0x00e9,0x00e7,0x0011,0x0011,0x0011,0x00dc,0x00dc,0x0016,0x0016,0x0065,0x0065,0x0016,0x0016,0x00dd,0x00dd,0x00ea,0x00ea,0x0065,0x0011,0x0011,0x0011,0x00dc,0x00dc,
	0x0016,0x0016,0x0016,0x0076,0x0016,0x0016,0x00dd,0x00dd,0x00eb,0x00eb,0x0079,0x0011,0x0011,0x0011,0x0065,0x0065,0x0016,0x00e5,0x0016,0x0065,0x0016,0x0016,0x00ec,0x00ec,0x00ed,0x00ed,0x00e7,0x0011,0x0011,0x0065,0x0004,0x0004,
	0x0004,0x0004,0x0004,0x0004,0x0004,0x0004,0x0004,0x0004,0x0004,0x0018,0x0018,0x0018,0x00d3,0x00ee,0x0082,0x0082,0x0082,0x0082,0x0082,0x0082,0x0005,0x0005,0x0017,0x001e,0x0008,0x0017,0x0017,0x001e,0x0008,0x0017,0x0005,0x0005,
	0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,0x00ef,0x00f0,0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x0014,0x0006,0x0006,0x0006,0x0006,0x0006,0x0005,0x0005,0x0005,0x0005,0x0017,0x001e,0x0005,0x0005,0x0005,0x0005,0x0012,0x0005,0x0005,
	0x0005,0x00f6,0x0008,0x0009,0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,0x000f,0x0005,0x0012,0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,0x0004,0x0018,0x0018,0x0018,0x0018,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x00f7,0x0016,0x0065,0x0065,0x00f7,0x00f7,0x00f7,0x00f7,0x00f7,0x00f7,0x000a,0x000a,0x000f,0x0008,0x0009,0x0016,0x00f8,0x00f8,0x00f8,0x00f8,0x00f8,
	0x00f8,0x00f8,0x00f8,0x00f8,0x00f8,0x000a,0x000a,0x000f,0x0008,0x0009,0x0065,0x0059,0x0059,0x0059,0x0059,0x0059,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0007,0x0007,0x0007,0x0007,0x0007,
	0x0007,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x005b,0x005b,0x0060,0x0060,0x005b,0x005b,0x005b,0x005b,0x0060,0x0060,0x0060,0x005b,0x005b,0x007c,0x007c,0x007c,0x005b,0x007c,0x007c,0x007c,0x0060,
	0x0060,0x005b,0x005d,0x005b,0x0060,0x0060,0x005d,0x005d,0x005d,0x005d,0x0015,0x0015,0x0071,0x0015,0x0015,0x0015,0x0015,0x0071,0x0015,0x0015,0x0016,0x0071,0x0071,0x0071,0x0016,0x0016,0x0071,0x0071,0x0071,0x0016,0x0015,0x0071,
	0x0015,0x0015,0x0015,0x0071,0x0071,0x0071,0x0071,0x0071,0x0015,0x0015,0x0015,0x0015,0x0071,0x0015,0x00f9,0x0015,0x0071,0x0015,0x00fa,0x00fb,0x0071,0x0071,0x0019,0x0016,0x0071,0x0071,0x00fc,0x0071,0x0016,0x0039,0x0039,0x0039,
	0x0039,0x0016,0x0015,0x0015,0x0016,0x0016,0x0071,0x0071,0x000e,0x000f,0x000f,0x000f,0x000f,0x0071,0x0016,0x0016,0x0016,0x0016,0x0015,0x000f,0x0015,0x0015,0x00fd,0x0065,0x0065,0x0065,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
	0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x00fe,0x00ff,0x00ff,0x00ff,0x00ff,0x00ff,0x00ff,0x00ff,0x00ff,0x00ff,0x00ff,0x00ff,0x00ff,0x0100,0x0101,0x0102,0x0103,0x0104,0x0104,0x0104,0x0104,0x0104,0x0104,0x0104,0x0104,0x0104,
	0x0104,0x0104,0x0104,0x0105,0x0106,0x0107,0x0108,0x0109,0x010a,0x010b,0x0021,0x0022,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x000f,0x000f,0x000f,0x000f,0x000f,0x0015,0x0015,0x0015,0x0015,
	0x0015,0x000f,0x000f,0x0015,0x0015,0x0015,0x0015,0x000f,0x0015,0x0015,0x000f,0x0015,0x0015,0x000f,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x000f,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,
	0x0015,0x0015,0x0015,0x0015,0x000f,0x000f,0x0015,0x0015,0x000f,0x0015,0x000f,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,
	0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000e,0x000a,0x001a,0x000f,0x000e,0x000e,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000f,0x000e,
	0x000f,0x000e,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,
	0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000f,0x000e,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000e,0x000e,0x000e,
	0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000f,0x000f,
	0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,
	0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x000e,0x000e,0x000e,0x000e,0x0015,
	0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0008,0x0009,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0015,0x000f,0x0015,0x0015,0x0015,0x0015,0x0015,
	0x007b,0x0015,0x0015,0x0015,0x0015,0x0015,0x000f,0x000f,0x000f,0x000f,0x000f,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x000f,0x000f,0x000f,0x000f,0x0015,0x0015,0x0015,0x0015,0x0015,
	0x0015,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,
	0x0015,0x0015,0x0015,0x0015,0x0065,0x0065,0x0065,0x0065,0x0065,0x010c,0x010c,0x010c,0x010c,0x010d,0x010d,0x010d,0x010d,0x010d,0x010d,0x010d,0x010d,0x010d,0x010d,0x010d,0x010d,0x010e,0x010e,0x010e,0x010e,0x010e,0x010e,0x010e,
	0x010e,0x010e,0x010e,0x010e,0x010e,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x010f,0x010f,0x010f,0x010f,0x010f,0x010f,0x010f,0x010f,0x010f,0x010f,0x0110,0x0110,0x0110,0x0110,0x0110,0x0110,0x0110,0x0110,0x0110,0x0110,0x0111,
	0x0112,0x0112,0x0112,0x0112,0x0112,0x0113,0x0113,0x0113,0x0113,0x0113,0x0113,0x0113,0x0113,0x0113,0x0113,0x0114,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x000f,
	0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0065,0x0065,0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x007b,0x0015,0x0015,0x0015,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0015,0x0015,0x0015,0x0015,0x0065,0x0015,0x0015,0x0015,0x0015,0x0065,0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,
	0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0065,0x0015,0x0065,0x0015,0x0015,0x0015,0x0065,0x0065,0x0065,0x0015,0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0065,
	0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0008,0x0009,0x0008,0x0009,0x0008,0x0009,0x0008,0x0009,0x0115,0x0115,0x0115,0x0115,0x0115,0x0115,0x0115,0x0115,0x0115,0x0115,0x0116,0x0116,0x0116,0x0116,0x0116,0x0116,0x0116,
	0x0116,0x0116,0x0116,0x0117,0x0117,0x0117,0x0117,0x0117,0x0117,0x0015,0x0065,0x0065,0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0065,0x000e,0x000f,0x000f,0x000e,
	0x000e,0x0008,0x0009,0x000f,0x000f,0x000f,0x000f,0x0065,0x0065,0x0065,0x0065,0x0065,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000f,0x000f,0x000e,0x000e,0x000e,
	0x000e,0x0008,0x0009,0x0008,0x0009,0x0008,0x0009,0x0065,0x0065,0x0065,0x0065,0x000f,0x000f,0x000f,0x0008,0x0009,0x0008,0x0009,0x0008,0x0009,0x0008,0x0009,0x0008,0x0009,0x0008,0x0009,0x0008,0x0009,0x000f,0x000f,0x000e,0x000e,
	0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,0x000e,0x000f,0x000f,0x000f,
	0x000f,0x000e,0x000e,0x000e,0x000f,0x000e,0x000e,0x000f,0x000f,0x0008,0x0009,0x0008,0x0009,0x000e,0x000f,0x000f,0x000f,0x000e,0x000f,0x000e,0x000e,0x000e,0x000f,0x000f,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,
	0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x0008,0x0009,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,
	0x000e,0x000f,0x000e,0x000e,0x000f,0x000f,0x000e,0x000f,0x000e,0x000f,0x000f,0x000e,0x000f,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,
	0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000f,0x000e,0x000f,0x000f,0x000e,0x000e,
	0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,
	0x000f,0x000f,0x000e,0x000f,0x000e,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000f,0x000f,0x000f,0x000e,0x000f,0x000f,0x000f,0x000e,0x000e,0x000e,0x000e,0x000e,
	0x000f,0x000e,0x000f,0x000f,0x0015,0x0015,0x0015,0x0015,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,0x0081,
	0x0081,0x0081,0x0081,0x0065,0x0021,0x0022,0x0118,0x0119,0x011a,0x011b,0x011c,0x0021,0x0022,0x0021,0x0022,0x0021,0x0022,0x0065,0x0065,0x0065,0x0065,0x0016,0x0021,0x0022,0x0016,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0021,0x0022,0x0021,0x0022,0x0016,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0005,0x0005,0x0005,0x0005,0x001f,0x0005,0x0005,0x011d,0x011d,0x011d,0x011d,
	0x011d,0x011d,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0059,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0005,0x0005,0x0017,0x001e,0x0017,0x001e,0x0005,0x0005,0x0005,0x0017,0x001e,0x0005,0x0017,0x001e,0x0005,0x0005,0x0005,0x0005,0x0005,0x0005,
	0x0005,0x0082,0x0065,0x0065,0x0065,0x0065,0x0017,0x001e,0x0065,0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0065,0x0065,0x0065,0x0065,0x0004,0x0005,0x0005,0x0005,0x0015,0x0059,0x0039,0x011e,0x0008,0x0009,0x0008,
	0x0009,0x0008,0x0009,0x0008,0x0009,0x0015,0x0015,0x0008,0x0009,0x0008,0x0009,0x0008,0x0009,0x0008,0x0009,0x0082,0x0008,0x0009,0x0009,0x0015,0x011f,0x011f,0x011f,0x011f,0x011f,0x011f,0x011f,0x011f,0x011f,0x0120,0x0084,0x005c,
	0x0083,0x0121,0x0121,0x0082,0x0059,0x0059,0x0059,0x0059,0x0059,0x0015,0x0015,0x0122,0x0123,0x0124,0x0059,0x0039,0x0005,0x0015,0x0015,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0125,0x0125,0x0011,0x0011,
	0x0059,0x0059,0x0039,0x0082,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0005,0x0059,0x0059,0x0059,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x007b,0x007b,0x0126,0x0126,0x0126,0x0126,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0015,0x0015,0x0065,0x0127,0x0127,0x0127,
	0x0127,0x0127,0x0127,0x0127,0x0127,0x0127,0x0127,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0015,0x0128,0x0128,0x0128,0x0128,0x0128,0x0128,
	0x0128,0x0128,0x0128,0x0128,0x0128,0x0128,0x0128,0x0128,0x0128,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0015,0x0015,0x0015,0x007b,0x0129,0x0129,0x0129,0x0129,0x0129,0x0129,0x0129,
	0x0129,0x0129,0x0129,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x012a,0x012a,0x012a,0x012a,0x012a,0x012a,0x012a,0x012a,0x012a,0x012a,0x012a,0x012a,0x012a,0x012a,0x012a,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,
	0x007b,0x007b,0x007b,0x007b,0x0015,0x0015,0x0015,0x0015,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0065,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,
	0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0015,0x0015,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0015,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0059,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x005a,
	0x005a,0x005a,0x005a,0x0065,0x0065,0x0065,0x0065,0x0065,0x0011,0x0011,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x00d7,0x0039,0x0039,0x0039,0x00ae,0x0039,
	0x0039,0x0039,0x0039,0x0062,0x0039,0x0039,0x0039,0x0039,0x00ac,0x00ac,0x0062,0x0062,0x00ac,0x0015,0x0015,0x0015,0x0015,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0005,0x0005,0x0005,0x0005,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0016,0x0016,0x0016,0x0016,0x0016,0x0065,0x0065,0x0065,0x0065,0x0065,0x0096,0x012d,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x000a,0x0096,0x0096,0x0096,0x0096,0x0096,
	0x0096,0x0096,0x0065,0x0096,0x0096,0x0096,0x0096,0x0096,0x0065,0x0096,0x0065,0x0096,0x0096,0x0065,0x0096,0x0096,0x0065,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x009a,0x009a,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x012e,0x012f,0x009a,0x009a,0x009a,0x009a,0x009a,
	0x009a,0x009a,0x009a,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x0098,0x0015,0x0065,0x0065,0x0005,0x0005,0x0005,0x0005,0x0005,
	0x0005,0x0005,0x012e,0x012f,0x0005,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x005b,0x005b,0x005b,0x005b,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0005,0x0082,0x0082,0x0012,0x0012,
	0x012e,0x012f,0x012e,0x012f,0x012e,0x012f,0x012e,0x012f,0x012e,0x012f,0x012e,0x012f,0x0005,0x0005,0x012e,0x012f,0x0005,0x0005,0x0005,0x0005,0x0012,0x0012,0x0012,0x000b,0x0005,0x000b,0x0065,0x0005,0x000b,0x0005,0x0005,0x0082,
	0x0008,0x0009,0x0008,0x0009,0x0008,0x0009,0x0006,0x0005,0x0005,0x000a,0x000c,0x000e,0x000e,0x000f,0x0065,0x0005,0x0007,0x0006,0x0005,0x0065,0x0065,0x0065,0x0065,0x009a,0x009a,0x009a,0x009a,0x009a,0x0065,0x009a,0x009a,0x009a,
	0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x009a,0x0065,0x0065,0x0018,0x0065,0x0005,0x0005,0x0006,0x0007,0x0006,0x0005,0x0005,0x0008,0x0009,0x0005,0x000a,0x000b,0x000c,0x000b,0x000b,0x0130,0x0130,0x0130,
	0x0130,0x0130,0x0130,0x0130,0x0130,0x0130,0x0130,0x000b,0x0005,0x000e,0x000f,0x000e,0x0005,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0013,0x0008,0x000f,0x0009,0x000f,0x0008,0x0009,0x0005,0x0008,
	0x0009,0x0005,0x0005,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0059,0x0059,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0065,0x0065,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0007,0x0007,0x000f,0x0011,0x0015,0x0007,0x0007,0x0065,0x0015,0x000f,0x000f,0x000f,0x000f,0x0015,0x0015,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0131,0x0131,0x0131,0x0015,0x0015,0x0065,0x0065
	};
const TUint16 ThePlane01TrieIndex1[1024] = 
	{
	0x0000,0x003f,0x8039,0x007f,0x00bf,0x00ff,0x0138,0x8065,0x8065,0x8065,0x8065,0x8065,0x0178,0x01b7,0x01f7,0x0233,
	0x0273,0x02a3,0x02c5,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x0305,0x8065,0x8065,0x8065,0x0344,0x8065,0x8065,0x8065,0x0384,0x03c4,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x0404,0x8065,0x8065,
	0x0444,0x0484,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x807b,0x807b,0x807b,0x04c4,0x0504,0x052e,0x056b,0x0599,0x8015,0x05d9,0x8065,0x8065,0x8015,0x0619,0x8065,0x8065,
	0x0659,0x068d,0x06cb,0x0708,0x0744,0x0784,0x07be,0x07ca,0x07d6,0x07e2,0x0818,0x0857,0x085d,0x0863,0x0869,0x08a6,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 ThePlane01TrieIndex2[2278] = 
	{
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0039,0x0039,0x0065,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0080,
	0x0005,0x007b,0x0065,0x0065,0x0065,0x0065,0x0132,0x0132,0x0132,0x0132,0x0132,0x0132,0x0132,0x0132,0x0132,0x0132,0x0133,0x0134,0x0135,0x0136,0x0137,0x0138,0x0139,0x013a,0x013b,0x013c,0x00b2,0x00b2,0x013d,0x00b2,0x00b2,0x00b2,
	0x00b2,0x00b6,0x00b2,0x00b2,0x00b2,0x013e,0x00b2,0x00b2,0x00b2,0x00b2,0x00d1,0x00b2,0x00b2,0x00b2,0x00b2,0x00b2,0x00b2,0x00b2,0x00b2,0x0065,0x0065,0x0065,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x013f,
	0x013f,0x0140,0x0141,0x0142,0x0143,0x0144,0x0145,0x0146,0x0147,0x0148,0x0149,0x0143,0x014a,0x0144,0x014b,0x014c,0x014d,0x014e,0x0143,0x014a,0x014f,0x0145,0x0150,0x0151,0x0152,0x0153,0x0153,0x0154,0x0155,0x0156,0x0154,0x0157,
	0x0151,0x0152,0x0153,0x0154,0x0158,0x0159,0x015a,0x015b,0x015c,0x015d,0x0145,0x0143,0x0143,0x0143,0x0143,0x0143,0x014a,0x0144,0x015e,0x015f,0x001f,0x001f,0x001f,0x001f,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,
	0x0015,0x0015,0x0160,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0127,0x0161,0x0162,0x0163,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0164,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0165,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0080,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0080,0x0166,0x0166,0x0167,0x0168,0x0169,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,
	0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016a,0x016b,0x016b,0x016b,0x016b,0x016b,
	0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x016b,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0065,0x0065,0x016c,0x016c,0x016c,0x016c,0x016c,0x016c,0x016c,0x016c,0x016c,0x016c,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0065,0x0065,0x0096,0x0065,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,
	0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0065,0x0096,0x0096,0x0065,0x0065,
	0x0065,0x0096,0x0065,0x0065,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x016d,0x016e,0x016f,0x0170,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0005,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0096,0x0062,0x0062,0x0062,0x0065,0x0062,0x0062,0x0065,0x0065,0x0065,0x0065,0x0065,0x0062,0x005d,0x0062,0x005b,0x0096,0x0096,0x0096,0x0096,0x0065,0x0096,0x0096,0x0096,0x0065,0x0096,0x0096,0x0096,
	0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0096,0x0065,0x0065,0x0065,0x0065,0x005b,0x0060,0x005d,0x0065,
	0x0065,0x0065,0x0065,0x00ae,0x0171,0x0171,0x0171,0x0171,0x0172,0x0173,0x0174,0x0175,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0092,0x0092,0x0092,0x0092,0x0092,0x0092,0x0092,0x0092,0x0092,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0176,0x0176,0x0176,0x0176,0x0176,0x0176,0x0176,0x0176,0x0177,0x0177,0x0177,0x0177,0x0177,0x0177,0x0177,0x0178,0x0178,0x0178,0x0178,0x0178,0x0178,0x0179,0x0179,0x0179,0x0179,0x0179,0x0179,0x0179,
	0x0179,0x0179,0x017a,0x017a,0x017a,0x017a,0x017a,0x017b,0x017b,0x017c,0x017c,0x017c,0x017c,0x017c,0x017c,0x017c,0x017d,0x017d,0x017d,0x017e,0x017e,0x017e,0x0165,0x0165,0x017f,0x017f,0x017f,0x0180,0x0180,0x0180,0x0181,0x0182,
	0x0182,0x0183,0x0184,0x0185,0x0184,0x0184,0x0185,0x0186,0x0186,0x0187,0x0187,0x0188,0x0189,0x018a,0x018b,0x018b,0x018b,0x018b,0x018b,0x018c,0x018c,0x018c,0x018c,0x018d,0x018d,0x018e,0x0165,0x0165,0x018f,0x018f,0x0190,0x0190,
	0x0190,0x0190,0x0190,0x0190,0x0190,0x0190,0x0190,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0080,0x0080,0x0080,0x0080,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,
	0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,
	0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0065,0x0065,0x0065,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,
	0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0191,0x0191,0x0060,0x0060,0x0060,0x007b,0x007b,0x007b,0x0192,0x0191,0x0191,0x0191,0x0191,
	0x0191,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x005d,0x005d,0x005d,0x005d,0x005d,0x007b,0x007b,0x005b,0x005b,0x005b,0x005b,0x005b,0x005d,0x005d,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,
	0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x005b,0x005b,0x005b,0x005b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,
	0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x007b,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0015,0x0015,0x005b,0x005b,0x005b,0x0015,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,
	0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0015,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x00c8,0x00c8,0x00c8,0x00c8,0x00c8,0x00c8,0x00c8,
	0x00c8,0x00c8,0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,0x00d0,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,
	0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,
	0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0016,0x0016,0x0016,0x0016,0x0016,
	0x0016,0x0016,0x0065,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,
	0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,
	0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0071,0x0065,0x0071,0x0071,0x0065,0x0065,0x0071,0x0065,0x0065,0x0071,0x0071,0x0065,0x0065,0x0071,0x0071,0x0071,0x0071,0x0065,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,
	0x0071,0x0016,0x0016,0x0016,0x0016,0x0065,0x0016,0x0065,0x0016,0x0016,0x0016,0x0016,0x0065,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,
	0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,
	0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0071,0x0071,0x0065,0x0071,0x0071,0x0071,0x0071,0x0065,0x0065,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0065,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,
	0x0071,0x0065,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0071,0x0071,0x0065,0x0071,
	0x0071,0x0071,0x0071,0x0065,0x0071,0x0071,0x0071,0x0071,0x0071,0x0065,0x0071,0x0065,0x0065,0x0065,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0065,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,
	0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,
	0x0071,0x0071,0x0071,0x0071,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0071,0x0071,
	0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,
	0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,
	0x0071,0x0071,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0065,0x0065,
	0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0193,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,
	0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0194,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,
	0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0071,0x0193,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,
	0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0194,0x0016,0x0016,0x0016,0x0016,0x0016,0x0016,0x0071,0x0016,0x0065,0x0065,0x0195,0x0195,0x0195,0x0195,0x0195,0x0195,0x0195,0x0195,0x0195,0x0195,0x0196,0x0196,
	0x0196,0x0196,0x0196,0x0196,0x0196,0x0196,0x0196,0x0196,0x0197,0x0197,0x0197,0x0197,0x0197,0x0197,0x0197,0x0197,0x0197,0x0197,0x0198,0x0198,0x0198,0x0198,0x0198,0x0198,0x0198,0x0198,0x0198,0x0198,0x0199,0x0199,0x0199,0x0199,
	0x0199,0x0199,0x0199,0x0199,0x0199,0x0199
	};
const TUint16 ThePlane02TrieIndex1[512] = 
	{
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,
	0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x8039,0x0000,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8039,0x8039,0x8039,0x8039,0x0039,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 ThePlane02TrieIndex2[185] = 
	{
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,
	0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0039,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065
	};
const TUint16 ThePlane03TrieIndex1[8] = 
	{
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 * const ThePlane03TrieIndex2 = NULL;
const TUint16 ThePlane04TrieIndex1[8] = 
	{
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 * const ThePlane04TrieIndex2 = NULL;
const TUint16 ThePlane05TrieIndex1[8] = 
	{
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 * const ThePlane05TrieIndex2 = NULL;
const TUint16 ThePlane06TrieIndex1[8] = 
	{
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 * const ThePlane06TrieIndex2 = NULL;
const TUint16 ThePlane07TrieIndex1[8] = 
	{
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 * const ThePlane07TrieIndex2 = NULL;
const TUint16 ThePlane08TrieIndex1[8] = 
	{
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 * const ThePlane08TrieIndex2 = NULL;
const TUint16 ThePlane09TrieIndex1[8] = 
	{
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 * const ThePlane09TrieIndex2 = NULL;
const TUint16 ThePlane10TrieIndex1[8] = 
	{
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 * const ThePlane10TrieIndex2 = NULL;
const TUint16 ThePlane11TrieIndex1[8] = 
	{
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 * const ThePlane11TrieIndex2 = NULL;
const TUint16 ThePlane12TrieIndex1[8] = 
	{
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 * const ThePlane12TrieIndex2 = NULL;
const TUint16 ThePlane13TrieIndex1[8] = 
	{
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 * const ThePlane13TrieIndex2 = NULL;
const TUint16 ThePlane14TrieIndex1[128] = 
	{
	0x0000,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,
	0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065,0x8065
	};
const TUint16 ThePlane14TrieIndex2[512] = 
	{
	0x0065,0x0018,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,
	0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,
	0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,
	0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,
	0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,
	0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,
	0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,
	0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,
	0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,
	0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,
	0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0062,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065,0x0065
	};
const TUint16 ThePlane15TrieIndex1[256] = 
	{
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x0000
	};
const TUint16 ThePlane15TrieIndex2[256] = 
	{
	0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,
	0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,
	0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,
	0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,
	0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,
	0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,
	0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,
	0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x012c,0x0065,0x0065
	};
const TUint16 ThePlane16TrieIndex1[8] = 
	{
	0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c,0x812c
	};
const TUint16 * const ThePlane16TrieIndex2 = NULL;
static const TUnicodeData TheUnicodeData[] =
	{ // 410 entries
	{ 128, 14, 0, 0, 0, 0 },	// 0x0 (0)
	{ 128, 16, 0, 0, 0, 0 },	// 0x1 (1)
	{ 128, 15, 0, 0, 0, 0 },	// 0x2 (2)
	{ 128, 17, 0, 0, 0, 0 },	// 0x3 (3)
	{ 112, 17, 0, 0, 0, 0 },	// 0x4 (4)
	{ 86, 18, 0, 0, 0, 0 },	// 0x5 (5)
	{ 86, 10, 0, 0, 0, 0 },	// 0x6 (6)
	{ 97, 10, 0, 0, 0, 0 },	// 0x7 (7)
	{ 82, 18, 0, 0, 0, 8 },	// 0x8 (8)
	{ 83, 18, 0, 0, 0, 8 },	// 0x9 (9)
	{ 96, 9, 0, 0, 0, 0 },	// 0xA (10)
	{ 86, 12, 0, 0, 0, 0 },	// 0xB (11)
	{ 81, 9, 0, 0, 0, 0 },	// 0xC (12)
	{ 64, 8, 0, -48, 0, 16 },	// 0xD (13)
	{ 96, 18, 0, 0, 0, 8 },	// 0xE (14)
	{ 96, 18, 0, 0, 0, 0 },	// 0xF (15)
	{ 0, 0, 0, 0, 32, 1 },	// 0x10 (16)
	{ 98, 18, 0, 0, 0, 0 },	// 0x11 (17)
	{ 80, 18, 0, 0, 0, 0 },	// 0x12 (18)
	{ 1, 0, 0, 0, 32, 2 },	// 0x13 (19)
	{ 112, 12, 0, 0, 0, 0 },	// 0x14 (20)
	{ 99, 18, 0, 0, 0, 0 },	// 0x15 (21)
	{ 1, 0, 0, 0, 0, 0 },	// 0x16 (22)
	{ 84, 18, 0, 0, 0, 8 },	// 0x17 (23)
	{ 129, 14, 0, 0, 0, 0 },	// 0x18 (24)
	{ 99, 10, 0, 0, 0, 0 },	// 0x19 (25)
	{ 96, 10, 0, 0, 0, 0 },	// 0x1A (26)
	{ 66, 8, 0, 80, 0, 16 },	// 0x1B (27)
	{ 1, 0, 0, 0, -743, 2 },	// 0x1C (28)
	{ 66, 8, 0, 72, 0, 16 },	// 0x1D (29)
	{ 85, 18, 0, 0, 0, 8 },	// 0x1E (30)
	{ 66, 18, 0, 0, 0, 112 },	// 0x1F (31)
	{ 1, 0, 0, 0, -121, 2 },	// 0x20 (32)
	{ 0, 0, 0, 0, 1, 1 },	// 0x21 (33)
	{ 1, 0, 0, 0, 1, 2 },	// 0x22 (34)
	{ 0, 0, 0, 0, -199, 1 },	// 0x23 (35)
	{ 1, 0, 0, 0, 232, 2 },	// 0x24 (36)
	{ 0, 0, 0, 0, -121, 1 },	// 0x25 (37)
	{ 1, 0, 0, 0, 300, 2 },	// 0x26 (38)
	{ 1, 0, 0, 0, -195, 2 },	// 0x27 (39)
	{ 0, 0, 0, 0, 210, 1 },	// 0x28 (40)
	{ 0, 0, 0, 0, 206, 1 },	// 0x29 (41)
	{ 0, 0, 0, 0, 205, 1 },	// 0x2A (42)
	{ 0, 0, 0, 0, 79, 1 },	// 0x2B (43)
	{ 0, 0, 0, 0, 202, 1 },	// 0x2C (44)
	{ 0, 0, 0, 0, 203, 1 },	// 0x2D (45)
	{ 0, 0, 0, 0, 207, 1 },	// 0x2E (46)
	{ 1, 0, 0, 0, -97, 2 },	// 0x2F (47)
	{ 0, 0, 0, 0, 211, 1 },	// 0x30 (48)
	{ 0, 0, 0, 0, 209, 1 },	// 0x31 (49)
	{ 1, 0, 0, 0, -163, 2 },	// 0x32 (50)
	{ 0, 0, 0, 0, 213, 1 },	// 0x33 (51)
	{ 1, 0, 0, 0, -130, 2 },	// 0x34 (52)
	{ 0, 0, 0, 0, 214, 1 },	// 0x35 (53)
	{ 0, 0, 0, 0, 218, 1 },	// 0x36 (54)
	{ 0, 0, 0, 0, 217, 1 },	// 0x37 (55)
	{ 0, 0, 0, 0, 219, 1 },	// 0x38 (56)
	{ 16, 0, 0, 0, 0, 0 },	// 0x39 (57)
	{ 1, 0, 0, 0, -56, 2 },	// 0x3A (58)
	{ 0, 0, 0, 0, 2, 5 },	// 0x3B (59)
	{ 2, 0, 0, 0, 1, 7 },	// 0x3C (60)
	{ 1, 0, 0, 0, 2, 6 },	// 0x3D (61)
	{ 1, 0, 0, 0, 79, 2 },	// 0x3E (62)
	{ 0, 0, 0, 0, -97, 1 },	// 0x3F (63)
	{ 0, 0, 0, 0, -56, 1 },	// 0x40 (64)
	{ 0, 0, 0, 0, -130, 1 },	// 0x41 (65)
	{ 0, 0, 0, 0, 10795, 1 },	// 0x42 (66)
	{ 0, 0, 0, 0, -163, 1 },	// 0x43 (67)
	{ 0, 0, 0, 0, 10792, 1 },	// 0x44 (68)
	{ 0, 0, 0, 0, -195, 1 },	// 0x45 (69)
	{ 0, 0, 0, 0, 69, 1 },	// 0x46 (70)
	{ 0, 0, 0, 0, 71, 1 },	// 0x47 (71)
	{ 1, 0, 0, 0, 210, 2 },	// 0x48 (72)
	{ 1, 0, 0, 0, 206, 2 },	// 0x49 (73)
	{ 1, 0, 0, 0, 205, 2 },	// 0x4A (74)
	{ 1, 0, 0, 0, 202, 2 },	// 0x4B (75)
	{ 1, 0, 0, 0, 203, 2 },	// 0x4C (76)
	{ 1, 0, 0, 0, 207, 2 },	// 0x4D (77)
	{ 1, 0, 0, 0, 209, 2 },	// 0x4E (78)
	{ 1, 0, 0, 0, 211, 2 },	// 0x4F (79)
	{ 1, 0, 0, 0, -10743, 2 },	// 0x50 (80)
	{ 1, 0, 0, 0, 213, 2 },	// 0x51 (81)
	{ 1, 0, 0, 0, 214, 2 },	// 0x52 (82)
	{ 1, 0, 0, 0, -10727, 2 },	// 0x53 (83)
	{ 1, 0, 0, 0, 218, 2 },	// 0x54 (84)
	{ 1, 0, 0, 0, 69, 2 },	// 0x55 (85)
	{ 1, 0, 0, 0, 217, 2 },	// 0x56 (86)
	{ 1, 0, 0, 0, 71, 2 },	// 0x57 (87)
	{ 1, 0, 0, 0, 219, 2 },	// 0x58 (88)
	{ 32, 0, 0, 0, 0, 0 },	// 0x59 (89)
	{ 32, 18, 0, 0, 0, 0 },	// 0x5A (90)
	{ 48, 13, 230, 0, 0, 0 },	// 0x5B (91)
	{ 48, 13, 232, 0, 0, 0 },	// 0x5C (92)
	{ 48, 13, 220, 0, 0, 0 },	// 0x5D (93)
	{ 48, 13, 216, 0, 0, 0 },	// 0x5E (94)
	{ 48, 13, 202, 0, 0, 0 },	// 0x5F (95)
	{ 48, 13, 1, 0, 0, 0 },	// 0x60 (96)
	{ 48, 13, 240, 0, -84, 2 },	// 0x61 (97)
	{ 48, 13, 0, 0, 0, 0 },	// 0x62 (98)
	{ 48, 13, 233, 0, 0, 0 },	// 0x63 (99)
	{ 48, 13, 234, 0, 0, 0 },	// 0x64 (100)
	{ 242, 0, 0, 0, 0, 0 },	// 0x65 (101)
	{ 0, 0, 0, 0, 38, 1 },	// 0x66 (102)
	{ 0, 0, 0, 0, 37, 1 },	// 0x67 (103)
	{ 0, 0, 0, 0, 64, 1 },	// 0x68 (104)
	{ 0, 0, 0, 0, 63, 1 },	// 0x69 (105)
	{ 1, 0, 0, 0, 38, 2 },	// 0x6A (106)
	{ 1, 0, 0, 0, 37, 2 },	// 0x6B (107)
	{ 1, 0, 0, 0, 31, 2 },	// 0x6C (108)
	{ 1, 0, 0, 0, 64, 2 },	// 0x6D (109)
	{ 1, 0, 0, 0, 63, 2 },	// 0x6E (110)
	{ 1, 0, 0, 0, 62, 2 },	// 0x6F (111)
	{ 1, 0, 0, 0, 57, 2 },	// 0x70 (112)
	{ 0, 0, 0, 0, 0, 0 },	// 0x71 (113)
	{ 1, 0, 0, 0, 47, 2 },	// 0x72 (114)
	{ 1, 0, 0, 0, 54, 2 },	// 0x73 (115)
	{ 1, 0, 0, 0, 86, 2 },	// 0x74 (116)
	{ 1, 0, 0, 0, 80, 2 },	// 0x75 (117)
	{ 1, 0, 0, 0, -7, 2 },	// 0x76 (118)
	{ 0, 0, 0, 0, -60, 1 },	// 0x77 (119)
	{ 1, 0, 0, 0, 96, 2 },	// 0x78 (120)
	{ 0, 0, 0, 0, -7, 1 },	// 0x79 (121)
	{ 0, 0, 0, 0, 80, 1 },	// 0x7A (122)
	{ 99, 0, 0, 0, 0, 0 },	// 0x7B (123)
	{ 50, 13, 0, 0, 0, 0 },	// 0x7C (124)
	{ 0, 0, 0, 0, 15, 1 },	// 0x7D (125)
	{ 1, 0, 0, 0, 15, 2 },	// 0x7E (126)
	{ 0, 0, 0, 0, 48, 1 },	// 0x7F (127)
	{ 86, 0, 0, 0, 0, 0 },	// 0x80 (128)
	{ 1, 0, 0, 0, 48, 2 },	// 0x81 (129)
	{ 81, 18, 0, 0, 0, 0 },	// 0x82 (130)
	{ 48, 13, 222, 0, 0, 0 },	// 0x83 (131)
	{ 48, 13, 228, 0, 0, 0 },	// 0x84 (132)
	{ 48, 13, 10, 0, 0, 0 },	// 0x85 (133)
	{ 48, 13, 11, 0, 0, 0 },	// 0x86 (134)
	{ 48, 13, 12, 0, 0, 0 },	// 0x87 (135)
	{ 48, 13, 13, 0, 0, 0 },	// 0x88 (136)
	{ 48, 13, 14, 0, 0, 0 },	// 0x89 (137)
	{ 48, 13, 15, 0, 0, 0 },	// 0x8A (138)
	{ 48, 13, 16, 0, 0, 0 },	// 0x8B (139)
	{ 48, 13, 17, 0, 0, 0 },	// 0x8C (140)
	{ 48, 13, 18, 0, 0, 0 },	// 0x8D (141)
	{ 48, 13, 19, 0, 0, 0 },	// 0x8E (142)
	{ 48, 13, 20, 0, 0, 0 },	// 0x8F (143)
	{ 48, 13, 21, 0, 0, 0 },	// 0x90 (144)
	{ 48, 13, 22, 0, 0, 0 },	// 0x91 (145)
	{ 86, 3, 0, 0, 0, 0 },	// 0x92 (146)
	{ 48, 13, 23, 0, 0, 0 },	// 0x93 (147)
	{ 48, 13, 24, 0, 0, 0 },	// 0x94 (148)
	{ 48, 13, 25, 0, 0, 0 },	// 0x95 (149)
	{ 16, 3, 0, 0, 0, 0 },	// 0x96 (150)
	{ 129, 4, 0, 0, 0, 0 },	// 0x97 (151)
	{ 97, 4, 0, 0, 0, 0 },	// 0x98 (152)
	{ 86, 4, 0, 0, 0, 0 },	// 0x99 (153)
	{ 16, 4, 0, 0, 0, 0 },	// 0x9A (154)
	{ 32, 4, 0, 0, 0, 0 },	// 0x9B (155)
	{ 48, 13, 27, 0, 0, 0 },	// 0x9C (156)
	{ 48, 13, 28, 0, 0, 0 },	// 0x9D (157)
	{ 48, 13, 29, 0, 0, 0 },	// 0x9E (158)
	{ 48, 13, 30, 0, 0, 0 },	// 0x9F (159)
	{ 48, 13, 31, 0, 0, 0 },	// 0xA0 (160)
	{ 48, 13, 32, 0, 0, 0 },	// 0xA1 (161)
	{ 48, 13, 33, 0, 0, 0 },	// 0xA2 (162)
	{ 48, 13, 34, 0, 0, 0 },	// 0xA3 (163)
	{ 64, 11, 0, -96, 0, 16 },	// 0xA4 (164)
	{ 86, 11, 0, 0, 0, 0 },	// 0xA5 (165)
	{ 48, 13, 35, 0, 0, 0 },	// 0xA6 (166)
	{ 64, 8, 0, 16, 0, 16 },	// 0xA7 (167)
	{ 99, 4, 0, 0, 0, 0 },	// 0xA8 (168)
	{ 48, 13, 36, 0, 0, 0 },	// 0xA9 (169)
	{ 64, 3, 0, 64, 0, 16 },	// 0xAA (170)
	{ 32, 3, 0, 0, 0, 0 },	// 0xAB (171)
	{ 49, 0, 0, 0, 0, 0 },	// 0xAC (172)
	{ 48, 13, 7, 0, 0, 0 },	// 0xAD (173)
	{ 48, 13, 9, 0, 0, 0 },	// 0xAE (174)
	{ 64, 0, 0, -102, 0, 16 },	// 0xAF (175)
	{ 64, 0, 0, 26, 0, 16 },	// 0xB0 (176)
	{ 66, 0, 0, 13, 0, 16 },	// 0xB1 (177)
	{ 66, 0, 0, 0, 0, 0 },	// 0xB2 (178)
	{ 66, 0, 0, 23, 0, 16 },	// 0xB3 (179)
	{ 66, 0, 0, 26, 0, 16 },	// 0xB4 (180)
	{ 66, 0, 0, 115, 0, 16 },	// 0xB5 (181)
	{ 66, 0, 0, 0, 0, 48 },	// 0xB6 (182)
	{ 48, 13, 84, 0, 0, 0 },	// 0xB7 (183)
	{ 48, 13, 91, 0, 0, 0 },	// 0xB8 (184)
	{ 48, 0, 0, 0, 0, 0 },	// 0xB9 (185)
	{ 48, 13, 103, 0, 0, 0 },	// 0xBA (186)
	{ 48, 13, 107, 0, 0, 0 },	// 0xBB (187)
	{ 64, 0, 0, -80, 0, 16 },	// 0xBC (188)
	{ 48, 13, 118, 0, 0, 0 },	// 0xBD (189)
	{ 48, 13, 122, 0, 0, 0 },	// 0xBE (190)
	{ 64, 0, 0, 48, 0, 16 },	// 0xBF (191)
	{ 64, 0, 0, -32, 0, 16 },	// 0xC0 (192)
	{ 66, 0, 0, 0, 0, 112 },	// 0xC1 (193)
	{ 48, 13, 129, 0, 0, 0 },	// 0xC2 (194)
	{ 48, 13, 130, 0, 0, 0 },	// 0xC3 (195)
	{ 48, 13, 132, 0, 0, 0 },	// 0xC4 (196)
	{ 64, 0, 0, -64, 0, 16 },	// 0xC5 (197)
	{ 0, 0, 0, 0, 7264, 1 },	// 0xC6 (198)
	{ 66, 0, 0, -104, 0, 16 },	// 0xC7 (199)
	{ 66, 0, 0, -95, 0, 16 },	// 0xC8 (200)
	{ 66, 0, 0, -86, 0, 16 },	// 0xC9 (201)
	{ 66, 0, 0, -77, 0, 16 },	// 0xCA (202)
	{ 66, 0, 0, -68, 0, 16 },	// 0xCB (203)
	{ 66, 0, 0, -59, 0, 16 },	// 0xCC (204)
	{ 66, 0, 0, -50, 0, 16 },	// 0xCD (205)
	{ 66, 0, 0, -41, 0, 16 },	// 0xCE (206)
	{ 66, 0, 0, -32, 0, 16 },	// 0xCF (207)
	{ 66, 0, 0, -23, 0, 16 },	// 0xD0 (208)
	{ 66, 0, 0, 0, 0, 80 },	// 0xD1 (209)
	{ 65, 0, 0, 35, 0, 16 },	// 0xD2 (210)
	{ 129, 0, 0, 0, 0, 0 },	// 0xD3 (211)
	{ 64, 0, 0, 32, 0, 16 },	// 0xD4 (212)
	{ 66, 18, 0, 16, 0, 16 },	// 0xD5 (213)
	{ 64, 0, 0, -16, 0, 16 },	// 0xD6 (214)
	{ 49, 13, 0, 0, 0, 0 },	// 0xD7 (215)
	{ 64, 0, 0, -70, 0, 16 },	// 0xD8 (216)
	{ 49, 0, 9, 0, 0, 0 },	// 0xD9 (217)
	{ 1, 0, 0, 0, -3814, 2 },	// 0xDA (218)
	{ 1, 0, 0, 0, 59, 2 },	// 0xDB (219)
	{ 1, 0, 0, 0, -8, 2 },	// 0xDC (220)
	{ 0, 0, 0, 0, -8, 1 },	// 0xDD (221)
	{ 1, 0, 0, 0, -74, 2 },	// 0xDE (222)
	{ 1, 0, 0, 0, -86, 2 },	// 0xDF (223)
	{ 1, 0, 0, 0, -100, 2 },	// 0xE0 (224)
	{ 1, 0, 0, 0, -128, 2 },	// 0xE1 (225)
	{ 1, 0, 0, 0, -112, 2 },	// 0xE2 (226)
	{ 1, 0, 0, 0, -126, 2 },	// 0xE3 (227)
	{ 2, 0, 0, 0, -8, 1 },	// 0xE4 (228)
	{ 1, 0, 0, 0, -9, 2 },	// 0xE5 (229)
	{ 0, 0, 0, 0, -74, 1 },	// 0xE6 (230)
	{ 2, 0, 0, 0, -9, 1 },	// 0xE7 (231)
	{ 1, 0, 0, 0, 7205, 2 },	// 0xE8 (232)
	{ 0, 0, 0, 0, -86, 1 },	// 0xE9 (233)
	{ 0, 0, 0, 0, -100, 1 },	// 0xEA (234)
	{ 0, 0, 0, 0, -112, 1 },	// 0xEB (235)
	{ 0, 0, 0, 0, -128, 1 },	// 0xEC (236)
	{ 0, 0, 0, 0, -126, 1 },	// 0xED (237)
	{ 129, 3, 0, 0, 0, 0 },	// 0xEE (238)
	{ 113, 17, 0, 0, 0, 0 },	// 0xEF (239)
	{ 114, 15, 0, 0, 0, 0 },	// 0xF0 (240)
	{ 129, 1, 0, 0, 0, 0 },	// 0xF1 (241)
	{ 129, 5, 0, 0, 0, 0 },	// 0xF2 (242)
	{ 129, 7, 0, 0, 0, 0 },	// 0xF3 (243)
	{ 129, 2, 0, 0, 0, 0 },	// 0xF4 (244)
	{ 129, 6, 0, 0, 0, 0 },	// 0xF5 (245)
	{ 96, 12, 0, 0, 0, 0 },	// 0xF6 (246)
	{ 66, 8, 0, -112, 0, 16 },	// 0xF7 (247)
	{ 66, 8, 0, -128, 0, 16 },	// 0xF8 (248)
	{ 0, 0, 0, 0, -7517, 1 },	// 0xF9 (249)
	{ 0, 0, 0, 0, -8383, 1 },	// 0xFA (250)
	{ 0, 0, 0, 0, -8262, 1 },	// 0xFB (251)
	{ 0, 0, 0, 0, 28, 1 },	// 0xFC (252)
	{ 1, 0, 0, 0, 28, 2 },	// 0xFD (253)
	{ 66, 18, 0, -94, 0, 16 },	// 0xFE (254)
	{ 65, 0, 0, -95, 16, 17 },	// 0xFF (255)
	{ 65, 0, 0, -58, 16, 17 },	// 0x100 (256)
	{ 65, 0, 0, -9, 16, 17 },	// 0x101 (257)
	{ 65, 0, 0, 0, 16, 33 },	// 0x102 (258)
	{ 65, 0, 0, 0, 16, 49 },	// 0x103 (259)
	{ 65, 0, 0, -111, 16, 18 },	// 0x104 (260)
	{ 65, 0, 0, -74, 16, 18 },	// 0x105 (261)
	{ 65, 0, 0, -25, 16, 18 },	// 0x106 (262)
	{ 65, 0, 0, 0, 16, 34 },	// 0x107 (263)
	{ 65, 0, 0, 0, 16, 50 },	// 0x108 (264)
	{ 65, 0, 0, 0, 0, 48 },	// 0x109 (265)
	{ 65, 0, 0, 0, 0, 64 },	// 0x10A (266)
	{ 65, 0, 0, 0, 0, 80 },	// 0x10B (267)
	{ 66, 18, 0, -95, 0, 16 },	// 0x10C (268)
	{ 66, 18, 0, -115, 0, 16 },	// 0x10D (269)
	{ 66, 8, 0, 121, 0, 16 },	// 0x10E (270)
	{ 99, 0, 0, 0, 26, 1 },	// 0x10F (271)
	{ 99, 0, 0, 0, 26, 2 },	// 0x110 (272)
	{ 66, 18, 0, 22, 0, 16 },	// 0x111 (273)
	{ 66, 18, 0, 32, 0, 16 },	// 0x112 (274)
	{ 66, 18, 0, 12, 0, 16 },	// 0x113 (275)
	{ 66, 18, 0, 1, 0, 16 },	// 0x114 (276)
	{ 66, 18, 0, -117, 0, 16 },	// 0x115 (277)
	{ 66, 18, 0, -127, 0, 16 },	// 0x116 (278)
	{ 66, 18, 0, 119, 0, 16 },	// 0x117 (279)
	{ 0, 0, 0, 0, -10743, 1 },	// 0x118 (280)
	{ 0, 0, 0, 0, -3814, 1 },	// 0x119 (281)
	{ 0, 0, 0, 0, -10727, 1 },	// 0x11A (282)
	{ 1, 0, 0, 0, 10795, 2 },	// 0x11B (283)
	{ 1, 0, 0, 0, 10792, 2 },	// 0x11C (284)
	{ 1, 0, 0, 0, 7264, 2 },	// 0x11D (285)
	{ 65, 0, 0, -7, 0, 16 },	// 0x11E (286)
	{ 65, 0, 0, -32, 0, 16 },	// 0x11F (287)
	{ 48, 13, 218, 0, 0, 0 },	// 0x120 (288)
	{ 48, 13, 224, 0, 0, 0 },	// 0x121 (289)
	{ 65, 0, 0, -46, 0, 16 },	// 0x122 (290)
	{ 65, 0, 0, -37, 0, 16 },	// 0x123 (291)
	{ 65, 0, 0, -28, 0, 16 },	// 0x124 (292)
	{ 48, 13, 8, 0, 0, 0 },	// 0x125 (293)
	{ 66, 0, 0, 111, 0, 16 },	// 0x126 (294)
	{ 66, 0, 0, -31, 0, 16 },	// 0x127 (295)
	{ 66, 18, 0, -60, 0, 16 },	// 0x128 (296)
	{ 66, 0, 0, -127, 0, 16 },	// 0x129 (297)
	{ 66, 18, 0, 115, 0, 16 },	// 0x12A (298)
	{ 240, 0, 0, 0, 0, 0 },	// 0x12B (299)
	{ 241, 0, 0, 0, 0, 0 },	// 0x12C (300)
	{ 48, 13, 26, 0, 0, 0 },	// 0x12D (301)
	{ 82, 18, 0, 0, 0, 0 },	// 0x12E (302)
	{ 83, 18, 0, 0, 0, 0 },	// 0x12F (303)
	{ 64, 8, 0, -16, 0, 16 },	// 0x130 (304)
	{ 129, 18, 0, 0, 0, 0 },	// 0x131 (305)
	{ 66, 0, 0, -6, 0, 16 },	// 0x132 (306)
	{ 66, 0, 0, 3, 0, 16 },	// 0x133 (307)
	{ 66, 0, 0, 12, 0, 16 },	// 0x134 (308)
	{ 66, 0, 0, 21, 0, 16 },	// 0x135 (309)
	{ 66, 0, 0, 30, 0, 16 },	// 0x136 (310)
	{ 66, 0, 0, 39, 0, 16 },	// 0x137 (311)
	{ 66, 0, 0, 48, 0, 16 },	// 0x138 (312)
	{ 66, 0, 0, 57, 0, 16 },	// 0x139 (313)
	{ 66, 0, 0, 66, 0, 16 },	// 0x13A (314)
	{ 66, 0, 0, 75, 0, 16 },	// 0x13B (315)
	{ 66, 0, 0, -82, 0, 16 },	// 0x13C (316)
	{ 66, 0, 0, 0, 0, 32 },	// 0x13D (317)
	{ 66, 0, 0, 0, 0, 64 },	// 0x13E (318)
	{ 65, 18, 0, 0, 0, 112 },	// 0x13F (319)
	{ 65, 18, 0, -65, 0, 16 },	// 0x140 (320)
	{ 65, 18, 0, -62, 0, 16 },	// 0x141 (321)
	{ 65, 18, 0, -18, 0, 16 },	// 0x142 (322)
	{ 65, 18, 0, 0, 0, 32 },	// 0x143 (323)
	{ 65, 18, 0, 0, 0, 64 },	// 0x144 (324)
	{ 65, 18, 0, 0, 0, 0 },	// 0x145 (325)
	{ 65, 18, 0, -67, 0, 16 },	// 0x146 (326)
	{ 65, 18, 0, -63, 0, 16 },	// 0x147 (327)
	{ 65, 18, 0, -24, 0, 16 },	// 0x148 (328)
	{ 65, 18, 0, 25, 0, 16 },	// 0x149 (329)
	{ 65, 18, 0, 0, 0, 48 },	// 0x14A (330)
	{ 65, 18, 0, -74, 0, 16 },	// 0x14B (331)
	{ 65, 18, 0, -70, 0, 16 },	// 0x14C (332)
	{ 65, 18, 0, -31, 0, 16 },	// 0x14D (333)
	{ 65, 18, 0, 18, 0, 16 },	// 0x14E (334)
	{ 65, 18, 0, 0, 0, 80 },	// 0x14F (335)
	{ 65, 18, 0, -77, 0, 16 },	// 0x150 (336)
	{ 65, 18, 0, -87, 0, 16 },	// 0x151 (337)
	{ 65, 18, 0, -88, 0, 16 },	// 0x152 (338)
	{ 65, 18, 0, -89, 0, 16 },	// 0x153 (339)
	{ 65, 18, 0, -90, 0, 16 },	// 0x154 (340)
	{ 65, 18, 0, -91, 0, 16 },	// 0x155 (341)
	{ 65, 18, 0, -92, 0, 16 },	// 0x156 (342)
	{ 65, 18, 0, -86, 0, 16 },	// 0x157 (343)
	{ 65, 18, 0, -71, 0, 16 },	// 0x158 (344)
	{ 65, 18, 0, -52, 0, 16 },	// 0x159 (345)
	{ 65, 18, 0, -53, 0, 16 },	// 0x15A (346)
	{ 65, 18, 0, -54, 0, 16 },	// 0x15B (347)
	{ 65, 18, 0, -55, 0, 16 },	// 0x15C (348)
	{ 65, 18, 0, -6, 0, 16 },	// 0x15D (349)
	{ 65, 18, 0, -110, 0, 16 },	// 0x15E (350)
	{ 65, 18, 0, -66, 0, 16 },	// 0x15F (351)
	{ 66, 18, 0, 118, 0, 16 },	// 0x160 (352)
	{ 66, 0, 0, -28, 0, 16 },	// 0x161 (353)
	{ 66, 0, 0, -24, 0, 16 },	// 0x162 (354)
	{ 66, 0, 0, 15, 0, 16 },	// 0x163 (355)
	{ 65, 0, 0, 25, 0, 16 },	// 0x164 (356)
	{ 65, 0, 0, 0, 0, 0 },	// 0x165 (357)
	{ 65, 0, 0, 48, 0, 16 },	// 0x166 (358)
	{ 65, 0, 0, 55, 0, 16 },	// 0x167 (359)
	{ 65, 0, 0, 64, 0, 16 },	// 0x168 (360)
	{ 65, 0, 0, -113, 0, 16 },	// 0x169 (361)
	{ 0, 0, 0, 0, 40, 1 },	// 0x16A (362)
	{ 1, 0, 0, 0, 40, 2 },	// 0x16B (363)
	{ 64, 0, 0, 96, 0, 16 },	// 0x16C (364)
	{ 66, 3, 0, -21, 0, 16 },	// 0x16D (365)
	{ 66, 3, 0, -13, 0, 16 },	// 0x16E (366)
	{ 66, 3, 0, -4, 0, 16 },	// 0x16F (367)
	{ 66, 3, 0, 75, 0, 16 },	// 0x170 (368)
	{ 66, 3, 0, -63, 0, 16 },	// 0x171 (369)
	{ 66, 3, 0, -58, 0, 16 },	// 0x172 (370)
	{ 66, 3, 0, -49, 0, 16 },	// 0x173 (371)
	{ 66, 3, 0, 30, 0, 16 },	// 0x174 (372)
	{ 66, 3, 0, 0, 0, 48 },	// 0x175 (373)
	{ 65, 0, 0, 2, 0, 16 },	// 0x176 (374)
	{ 65, 0, 0, -5, 0, 16 },	// 0x177 (375)
	{ 65, 0, 0, -11, 0, 16 },	// 0x178 (376)
	{ 65, 0, 0, -20, 0, 16 },	// 0x179 (377)
	{ 65, 0, 0, -29, 0, 16 },	// 0x17A (378)
	{ 65, 0, 0, -33, 0, 16 },	// 0x17B (379)
	{ 65, 0, 0, -34, 0, 16 },	// 0x17C (380)
	{ 65, 0, 0, -43, 0, 16 },	// 0x17D (381)
	{ 65, 0, 0, -44, 0, 16 },	// 0x17E (382)
	{ 65, 0, 0, -51, 0, 16 },	// 0x17F (383)
	{ 65, 0, 0, -52, 0, 16 },	// 0x180 (384)
	{ 65, 0, 0, -55, 0, 16 },	// 0x181 (385)
	{ 65, 0, 0, -56, 0, 16 },	// 0x182 (386)
	{ 65, 0, 0, -57, 0, 16 },	// 0x183 (387)
	{ 65, 0, 0, -58, 0, 16 },	// 0x184 (388)
	{ 65, 0, 0, -59, 0, 16 },	// 0x185 (389)
	{ 65, 0, 0, -60, 0, 16 },	// 0x186 (390)
	{ 65, 0, 0, -61, 0, 16 },	// 0x187 (391)
	{ 65, 0, 0, -62, 0, 16 },	// 0x188 (392)
	{ 65, 0, 0, -63, 0, 16 },	// 0x189 (393)
	{ 65, 0, 0, -64, 0, 16 },	// 0x18A (394)
	{ 65, 0, 0, -72, 0, 16 },	// 0x18B (395)
	{ 65, 0, 0, -78, 0, 16 },	// 0x18C (396)
	{ 65, 0, 0, -79, 0, 16 },	// 0x18D (397)
	{ 65, 0, 0, -80, 0, 16 },	// 0x18E (398)
	{ 65, 0, 0, -87, 0, 16 },	// 0x18F (399)
	{ 65, 0, 0, 0, 0, 112 },	// 0x190 (400)
	{ 49, 0, 216, 0, 0, 0 },	// 0x191 (401)
	{ 49, 0, 226, 0, 0, 0 },	// 0x192 (402)
	{ 96, 0, 0, 0, 0, 0 },	// 0x193 (403)
	{ 96, 0, 0, 0, 0, 8 },	// 0x194 (404)
	{ 64, 8, 0, 50, 0, 16 },	// 0x195 (405)
	{ 64, 8, 0, 40, 0, 16 },	// 0x196 (406)
	{ 64, 8, 0, 30, 0, 16 },	// 0x197 (407)
	{ 64, 8, 0, 20, 0, 16 },	// 0x198 (408)
	{ 64, 8, 0, 10, 0, 16 }	// 0x199 (409)
	};

const TUnicodePlane ThePlanes[17] =
	{
	{4, 0xFFF0, 0x000F },
	{6, 0xFFC0, 0x003F },
	{7, 0xFF80, 0x007F },
	{13, 0xE000, 0x1FFF },
	{13, 0xE000, 0x1FFF },
	{13, 0xE000, 0x1FFF },
	{13, 0xE000, 0x1FFF },
	{13, 0xE000, 0x1FFF },
	{13, 0xE000, 0x1FFF },
	{13, 0xE000, 0x1FFF },
	{13, 0xE000, 0x1FFF },
	{13, 0xE000, 0x1FFF },
	{13, 0xE000, 0x1FFF },
	{13, 0xE000, 0x1FFF },
	{9, 0xFE00, 0x01FF },
	{8, 0xFF00, 0x00FF },
	{13, 0xE000, 0x1FFF }
	};

const TStandardUnicodeDataSet TheStandardUnicodeDataSet[] =
	{ // 17 entries
	{ ThePlane00TrieIndex1, ThePlane00TrieIndex2, TheUnicodeData },
	{ ThePlane01TrieIndex1, ThePlane01TrieIndex2, TheUnicodeData },
	{ ThePlane02TrieIndex1, ThePlane02TrieIndex2, TheUnicodeData },
	{ ThePlane03TrieIndex1, ThePlane03TrieIndex2, TheUnicodeData },
	{ ThePlane04TrieIndex1, ThePlane04TrieIndex2, TheUnicodeData },
	{ ThePlane05TrieIndex1, ThePlane05TrieIndex2, TheUnicodeData },
	{ ThePlane06TrieIndex1, ThePlane06TrieIndex2, TheUnicodeData },
	{ ThePlane07TrieIndex1, ThePlane07TrieIndex2, TheUnicodeData },
	{ ThePlane08TrieIndex1, ThePlane08TrieIndex2, TheUnicodeData },
	{ ThePlane09TrieIndex1, ThePlane09TrieIndex2, TheUnicodeData },
	{ ThePlane10TrieIndex1, ThePlane10TrieIndex2, TheUnicodeData },
	{ ThePlane11TrieIndex1, ThePlane11TrieIndex2, TheUnicodeData },
	{ ThePlane12TrieIndex1, ThePlane12TrieIndex2, TheUnicodeData },
	{ ThePlane13TrieIndex1, ThePlane13TrieIndex2, TheUnicodeData },
	{ ThePlane14TrieIndex1, ThePlane14TrieIndex2, TheUnicodeData },
	{ ThePlane15TrieIndex1, ThePlane15TrieIndex2, TheUnicodeData },
	{ ThePlane16TrieIndex1, ThePlane16TrieIndex2, TheUnicodeData }
	};

const TUint16 TUnicode::FoldTable[256] = 
	{
	0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
	0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
	0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
	0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
	0x0040,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
	0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x005b,0x005c,0x005d,0x005e,0x005f,
	0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
	0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f,
	0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
	0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
	0x0020,0x00a1,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,0x00a8,0x00a9,0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,
	0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,0x00b8,0x00b9,0x00ba,0x00bb,0x00bc,0x00bd,0x00be,0x00bf,
	0x0061,0x0061,0x0061,0x0061,0x0061,0x0061,0x00e6,0x0063,0x0065,0x0065,0x0065,0x0065,0x0069,0x0069,0x0069,0x0069,
	0x00f0,0x006e,0x006f,0x006f,0x006f,0x006f,0x006f,0x00d7,0x00f8,0x0075,0x0075,0x0075,0x0075,0x0079,0x00fe,0x00df,
	0x0061,0x0061,0x0061,0x0061,0x0061,0x0061,0x00e6,0x0063,0x0065,0x0065,0x0065,0x0065,0x0069,0x0069,0x0069,0x0069,
	0x00f0,0x006e,0x006f,0x006f,0x006f,0x006f,0x006f,0x00f7,0x00f8,0x0075,0x0075,0x0075,0x0075,0x0079,0x00fe,0x0079
	};
const TUint16 TUnicode::CjkWidthFoldTable[256] = 
	{
	0xff00,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
	0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
	0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
	0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f,
	0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
	0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x2985,
	0x2986,0x3002,0x300c,0x300d,0x3001,0x30fb,0x30f2,0x30a1,0x30a3,0x30a5,0x30a7,0x30a9,0x30e3,0x30e5,0x30e7,0x30c3,
	0x30fc,0x30a2,0x30a4,0x30a6,0x30a8,0x30aa,0x30ab,0x30ad,0x30af,0x30b1,0x30b3,0x30b5,0x30b7,0x30b9,0x30bb,0x30bd,
	0x30bf,0x30c1,0x30c4,0x30c6,0x30c8,0x30ca,0x30cb,0x30cc,0x30cd,0x30ce,0x30cf,0x30d2,0x30d5,0x30d8,0x30db,0x30de,
	0x30df,0x30e0,0x30e1,0x30e2,0x30e4,0x30e6,0x30e8,0x30e9,0x30ea,0x30eb,0x30ec,0x30ed,0x30ef,0x30f3,0x3099,0x309a,
	0x3164,0x3131,0x3132,0x3133,0x3134,0x3135,0x3136,0x3137,0x3138,0x3139,0x313a,0x313b,0x313c,0x313d,0x313e,0x313f,
	0x3140,0x3141,0x3142,0x3143,0x3144,0x3145,0x3146,0x3147,0x3148,0x3149,0x314a,0x314b,0x314c,0x314d,0x314e,0xffbf,
	0xffc0,0xffc1,0x314f,0x3150,0x3151,0x3152,0x3153,0x3154,0xffc8,0xffc9,0x3155,0x3156,0x3157,0x3158,0x3159,0x315a,
	0xffd0,0xffd1,0x315b,0x315c,0x315d,0x315e,0x315f,0x3160,0xffd8,0xffd9,0x3161,0x3162,0x3163,0xffdd,0xffde,0xffdf,
	0x00a2,0x00a3,0x00ac,0x00af,0x00a6,0x00a5,0x20a9,0xffe7,0x2502,0x2190,0x2191,0x2192,0x2193,0x25a0,0x25cb,0xffef,
	0xfff0,0xfff1,0xfff2,0xfff3,0xfff4,0xfff5,0xfff6,0xfff7,0xfff8,0xfff9,0xfffa,0xfffb,0xfffc,0xfffd,0xfffe,0xffff
	};

// The tables and structures contain 34435 bytes of data.
