// Copyright (c) 1999-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// e32test\system\d_kucopy.cpp
// Test kumemget, kumemput under the assumption that memcpy works
// 
//

#include <kernel/kernel.h>
#include "d_kucopy.h"

_LIT(KLddName,"KUCopy");

const TInt KBufSize=4096;

static const TUint32 RandomData[2048]=
	{
	0x15b138c1, 0x19548df5, 0xc4751abd, 0xb3915667,
	0xccaed7f9, 0x0b28fb4e, 0x0a209d05, 0x0cc01e4e,
	0x8784e75f, 0x0db78374, 0xfeec8e54, 0xb7930c53,
	0x6b0cb099, 0x7e8fcfa4, 0x43bda3e9, 0xfbe04e4a,
	0xf91488b4, 0x3401071a, 0x0a71232a, 0x170a30e5,
	0xa88b42fa, 0x606a077b, 0x9042bab9, 0xe38ac364,
	0x5df3246d, 0x1cbf43fd, 0x7a607658, 0xba55b089,
	0x06224826, 0xa7934e6a, 0x672f0147, 0xc383fc9b,
	0xde0843ad, 0x6b3ef765, 0x5ae92e1c, 0x3f9554f7,
	0x4a85ded3, 0xf8afd0e3, 0x0159d864, 0x1d2aade0,
	0xa44b5cb4, 0xe7eee024, 0x9df539cd, 0x1d664d30,
	0xea60283e, 0x77b3f364, 0x04efb9fc, 0xf9e81360,
	0xfdc2066c, 0x5e87c6de, 0x532e065d, 0xc9f2dfb1,
	0xc9027348, 0xc3b5b59f, 0x3a832967, 0xafd7ee4e,
	0xa90f1db7, 0xa55cf48e, 0x1de69b99, 0x674adbb8,
	0x1e1eec3d, 0xe1cca802, 0x3a6677a7, 0x7a494c77,
	0x29e3d4a5, 0xa9bbb0c9, 0x6fd14e99, 0xa3013d7c,
	0xc257529b, 0x1402180d, 0xab81d6be, 0xc8ab07d5,
	0xd428dea8, 0x67fee92b, 0xdd6dc943, 0x3222d783,
	0xb4695087, 0x4f3cdcb0, 0x6a5568fd, 0x63a56244,
	0xe7f6ff5d, 0x1c0eae6e, 0x64e1b179, 0x29674a2a,
	0xe0110b14, 0x60b9c381, 0xac64fb06, 0x9982141b,
	0x6d80bcd5, 0xbd0d05ba, 0x0edd2230, 0xd54d9c4c,
	0xb3620510, 0x79e00516, 0x3ca16141, 0x0844a024,
	0xce201cf0, 0x66df0815, 0xc3eed834, 0x0c742cdd,
	0x44f7c221, 0xde59fcf5, 0x70e3a974, 0x82e69c94,
	0x28ba0cc1, 0xb4911d29, 0xcb9a122d, 0x44efdd58,
	0x5fa26b56, 0x0964553d, 0x41e1fe80, 0xbf18f4b1,
	0xd0c76754, 0x9e16fa4b, 0x20afcf2f, 0x6ca5115d,
	0xe74756da, 0x86ce0301, 0xa3571bb5, 0xa010d7db,
	0xdd75d63a, 0xb3d94020, 0xcdeeacce, 0x8c3bbea4,
	0xfdf7908d, 0x07f31839, 0xb27a173b, 0x784ebc19,
	0x57e6cb72, 0xc74449cd, 0x273ef695, 0x7cf62c85,
	0xdcb34b89, 0xdae1386a, 0xfef633da, 0x1c46b829,
	0x65a1ca4e, 0xae740fc0, 0x17c6069c, 0x6b8ac5f6,
	0x999a0b62, 0xec7b2b76, 0xc48af9f3, 0xcdda4024,
	0x42ef643c, 0xd7347f6d, 0x2c6ced70, 0x58e17336,
	0x3b43da2f, 0x20031f17, 0xa1f0f594, 0xdfa13730,
	0x7ca39c52, 0x0794ee50, 0x4d2f73fa, 0xd1a814e7,
	0xe99a74ea, 0x53839f4d, 0x10351ea5, 0xd9f0d2cd,
	0xe1d4b77b, 0xbb9de004, 0x03ceb03e, 0xeae4b6b1,
	0x3e1948b9, 0x0b8734e4, 0xf68dd51a, 0xa61740ec,
	0x27056206, 0x45a2d559, 0x0f84fa54, 0xc86731ac,
	0x172959a4, 0x9e0ee532, 0xa154588c, 0x1522ed14,
	0x244034ce, 0x116cfb71, 0xc70161c8, 0xf59c3fbd,
	0xb935c44d, 0x80de3a2b, 0x23cdaf29, 0x4b144325,
	0xe1b87f89, 0x7724a8b6, 0xf1193b4a, 0xeb383316,
	0xf6ad76e1, 0xac38a1b3, 0x5c076519, 0xd8522f09,
	0xced98b69, 0x7fda5249, 0x1ac9b888, 0x16ec5d2a,
	0xcea4827f, 0x2f75b3c8, 0xcc86552c, 0x0311eaa7,
	0x1f2284a1, 0xa7db582d, 0x666f7a70, 0x4490b971,
	0x29df4e25, 0x600df112, 0x6f17de78, 0x4a6c6b9a,
	0xe38f9bf5, 0x8878957d, 0x4d6b9e68, 0x1f534ec1,
	0x3b45b4d4, 0xc6ef9604, 0x9a1782a3, 0x3521f203,
	0x85b0c15a, 0xcecdcc41, 0xbba2fd9a, 0xf208d1ed,
	0xf41ab7b7, 0x51762ecc, 0xca57dbc3, 0x1897dc68,
	0xf18d612c, 0xaed47a7b, 0x10cd8c31, 0x50a5d312,
	0xf563c6df, 0x46dc1702, 0x621e2da0, 0xd3d51bed,
	0x38545e73, 0xd9cd12a5, 0x3dccda8e, 0x534e8873,
	0xc120782b, 0xe7128264, 0xdbaf0c88, 0x9d1f0f95,
	0xbe76dc2d, 0xb2f9b539, 0x422f4ebe, 0x55fc4200,
	0xeede2fed, 0x9591ceaf, 0xd6221a35, 0xcab251b1,
	0xc04234dc, 0xc36cd658, 0xacd3e1e1, 0x6877e677,
	0xca5c8f9e, 0x2dd7a512, 0x6cbaf442, 0x991953b0,
	0xd9b7a443, 0x169fe348, 0x757b76f3, 0x8dd283a4,
	0xeed30f3f, 0x479a73e6, 0x04f359bc, 0x37e26fa0,
	0x3d0b3400, 0xadc590dc, 0x0fef0890, 0xf77e8b3f,
	0x930cbcaf, 0x024cae73, 0x4bc16385, 0xb3d8eaff,
	0x5743800b, 0x93a1793f, 0xde43417b, 0xdb361d0e,
	0x8c4be643, 0xf841cca5, 0xe0eab85c, 0x5bf09991,
	0x24615e8e, 0x87d8473a, 0xc79f8fe4, 0x9b318e41,
	0x557cd277, 0x67991f42, 0x2238ad82, 0x9bc47f7d,
	0x0a15ef1f, 0xdbfb0a30, 0x5d5e80cd, 0xc6a39c0c,
	0xda9103af, 0x7d727600, 0x99d9329d, 0xdfc544b2,
	0xbba989e3, 0xc54af8a5, 0x4d2f2880, 0x541f9101,
	0xd31fd5b1, 0x14d4fb95, 0xc5d32197, 0xd0f0edc4,
	0xe6a43888, 0x30da9f49, 0xb199d4bd, 0x45873e06,
	0xd123f211, 0x57b0ec73, 0xa51f4c68, 0x26492450,
	0x81619a3e, 0x5913288e, 0x1e0175a7, 0x185acb56,
	0x209807a2, 0x90362ad2, 0x2ab637c2, 0x76273c83,
	0x48dbaacc, 0x1ec1148a, 0x1e282ba7, 0x8dae6d09,
	0x2007a484, 0xea4b9ce6, 0xcceba2bd, 0xdc5e0c9b,
	0x0ee6b6a3, 0xec196590, 0x6055b4cd, 0x6b660cd0,
	0xd57e0b3f, 0x8a0cfd3f, 0x0ad58e32, 0xdd89eac1,
	0xf068ea66, 0x7692125a, 0x1a6ca88b, 0xc7bee83e,
	0x0d5c94ca, 0xcfe2e69b, 0x4998c7d4, 0x28b12161,
	0x064e80d4, 0x6b2a06d8, 0x95f88a33, 0xc25f793c,
	0x16bc7df5, 0xcc816232, 0xf0639e1f, 0x41d03b12,
	0xa35937bc, 0xc2d757f3, 0x14149ab8, 0xc3a1c166,
	0x7dc6876f, 0x5695b6de, 0xf027346d, 0x0b554a83,
	0xd1029851, 0xc1045038, 0xa581a244, 0x48e495ac,
	0x6d288c04, 0xbe540de7, 0x1ff4770c, 0xc88af70e,
	0xcb359734, 0x3ce98854, 0x86f18c45, 0x5bbc9399,
	0x64e7df82, 0xcf8bc339, 0xdbf67c23, 0x8a3906b2,
	0x5577a60e, 0x50db360a, 0x9b0d32b5, 0x9eadc0b0,
	0x135de16d, 0xd7b82dcd, 0x6900c076, 0xb8870bb3,
	0x2cf8b716, 0x1d0d3a5b, 0xdd2320ff, 0xdc9e6db6,
	0x08945652, 0x412f0f3b, 0xd0643a9b, 0xab9ba7f4,
	0x6fb29501, 0x1e895b68, 0x1af22c1b, 0x2fb8a4f6,
	0x1d9333a2, 0x3df3ba0e, 0x25593f52, 0x8159b7bc,
	0xdbd71663, 0x1c8dbaf9, 0x55e94822, 0x3e7687f6,
	0x7744248f, 0x79eae5d9, 0x12a8e3c6, 0x07681195,
	0x82ad50e0, 0x1458a935, 0x80bf0c91, 0x30969541,
	0xf11f55b1, 0x0dd4ba05, 0xcd4a01d6, 0x46b86480,
	0xa5143811, 0x110b0d18, 0x38540509, 0x5c7a9743,
	0x07497bd5, 0x1419ecab, 0x14c64719, 0xee12bd6d,
	0xdcdf837b, 0x165870d8, 0x0c21b8ae, 0x1d9a3d8e,
	0xad15f416, 0x09cb9a97, 0xbd4cb69f, 0x15cfaa13,
	0x7046e20d, 0xd603ac66, 0xd1c7bb2f, 0x13512ca2,
	0x9b62bfe7, 0x664f2997, 0x41bee0d0, 0x4ed27485,
	0x00216a40, 0x96b4bc4b, 0x009eee2c, 0x6eadb1fc,
	0xec49163a, 0xe7472569, 0x01f502ab, 0xd0d03c58,
	0xebad9096, 0xacdfa286, 0xac47bb87, 0x2d9baf1a,
	0x2c3c754e, 0xd14ad7b3, 0xc5de5784, 0x07976bbb,
	0x7570028a, 0xba90aaec, 0x57e69008, 0x42f3cc2b,
	0x1dbb57ce, 0x3ba1485d, 0x095574bb, 0xd3e10763,
	0xf986bc29, 0x9701c764, 0xd7f6aecd, 0x01178777,
	0xf8fcbc34, 0x37bd1d61, 0xca089210, 0x6c254fca,
	0x62ee01cb, 0xd16bbdf3, 0x536aebcf, 0x07098597,
	0x1bddb376, 0x56d9bcd6, 0xb0a1b561, 0x4306ce80,
	0xcd6b6b96, 0xd00cd8cb, 0xa58ad63d, 0x7fa6bce4,
	0xd41d1333, 0xbb3db22a, 0x06bc797e, 0xc4c9d0f3,
	0xff6bd78f, 0x42cd1feb, 0x709838fc, 0x3bc3dfc2,
	0x201dcde0, 0xccd0ea3d, 0x68cba392, 0x0e5cf12c,
	0xc83cb415, 0xaf5f00ff, 0x27a07205, 0x94f0604d,
	0xcc7cece1, 0x28f064ff, 0x9237cb5c, 0xb5ae2ef4,
	0xb8385cf9, 0xd9d3b3e1, 0xd7d7c48d, 0x97a33b3c,
	0xf8625218, 0x5910ac9d, 0x2641842a, 0x8b626aa3,
	0x631b0360, 0x01bb81ab, 0xb8c77b59, 0xabd62711,
	0xb79a08f1, 0x7b4213cc, 0x9c9dc02f, 0x924c1933,
	0x08b53c12, 0xd79bb370, 0xd0fad4b7, 0xc5361608,
	0x83fb833b, 0xf9ce7e01, 0x1b072eb0, 0xff6898ae,
	0xf63ea334, 0x912c1888, 0x891e84d5, 0xacc218a6,
	0xf7eb632d, 0xcdc76d4a, 0x90371fa6, 0x39e1ec4d,
	0x02342605, 0xc37a4f35, 0x454e73ce, 0x459bddbe,
	0x9f16072e, 0x2ff9e168, 0x89ea782a, 0xe3779222,
	0x0899e998, 0x9ad57d61, 0x1abcaf1b, 0x47afe3f7,
	0x5de88425, 0x26b61079, 0xf25c9719, 0x305fd889,
	0x65a77a1e, 0xc5725158, 0x47acacd6, 0xe91b38fa,
	0xc702300d, 0x4081cc0e, 0xbc800dcf, 0x5e9cf30e,
	0x607e9f80, 0xd9c7425c, 0x18c660a2, 0x6a6916f7,
	0xa45bf13e, 0x6d3e1e4c, 0xd77bc251, 0xd798fc51,
	0x64096868, 0x2482367c, 0x3126d82c, 0x7511ab47,
	0x203ca7a0, 0x5a645676, 0x68554dbe, 0x60f140d0,
	0x2475a22f, 0x48182596, 0x265570ae, 0x44205c15,
	0x27d17c77, 0x842fc679, 0x3e7070db, 0x983581ee,
	0x940429b7, 0x08996452, 0x12099309, 0x90345087,
	0x8d125092, 0xe3800671, 0x71a71422, 0xc991a688,
	0x7ea054ae, 0x3a1ac9f6, 0xb1920fe2, 0x78372072,
	0x4e1cb4d8, 0xec43d4a8, 0x4b6b6ee2, 0x935b9e44,
	0xf0498026, 0xe026ae11, 0x1af246a7, 0xa91359c2,
	0xe11582f0, 0x28a5c3f2, 0x486dc57f, 0xf8611d39,
	0xede31042, 0xc7f5a45e, 0x39bf31b4, 0xefc4d626,
	0x3a8008bb, 0x1dcbb581, 0x35bdc99b, 0x464750a9,
	0xd6293536, 0x7847fd1f, 0x43f20ab0, 0x81520d4d,
	0x607dd0a1, 0x6d34fe83, 0xf97240d6, 0xd8b44de0,
	0x28842478, 0x5605975c, 0x72770c89, 0x49f312db,
	0x95d43030, 0x89e91086, 0xd5fce51c, 0xa4afb8c4,
	0xa9db96ff, 0xed8235a7, 0xd59b678a, 0x5cb5160e,
	0x7f3a6cf4, 0x99527fef, 0x6b57c942, 0xc93fc832,
	0x981ccd98, 0x80d7eec1, 0x3e87e488, 0xe10b7c54,
	0xc740f25e, 0x6c859fe7, 0x6fbcb908, 0x7c4edb40,
	0xd3936099, 0x5fc025b0, 0xadbb1803, 0xe75db274,
	0x28899bb2, 0x8dffe506, 0xb8af9909, 0xa5c756d8,
	0xa78e2114, 0xb1d65b97, 0x3d525e1e, 0xbb48c4bb,
	0xd1efdf43, 0x1503def1, 0xb76ef40e, 0x34f79948,
	0x63ef4a9a, 0xc55e0918, 0x823e8caf, 0xa9d5bcca,
	0x8f267697, 0x20fa4944, 0x34e967ec, 0x8c0a7b36,
	0xe1b65380, 0x15e3289e, 0x387877c8, 0x9b40b250,
	0x46855d40, 0x7696a9c9, 0x51d7c1f9, 0xd4f47db3,
	0xada10403, 0xc690be68, 0xe8aed1be, 0x994c814b,
	0x84b2f8ee, 0xedd792aa, 0x0fc169a9, 0x117a25c3,
	0x2ae1204f, 0x87746850, 0x853f3c7b, 0xb1582528,
	0x5afe973b, 0xc40cf7dd, 0x2d7ba939, 0x2c2e465e,
	0x7272c408, 0x1579e353, 0x9489c8e1, 0x56caf11c,
	0x0474b8c9, 0x49b6c8ff, 0xc85498fa, 0xada5e6a7,
	0x08b883d8, 0x0c61c12a, 0x1a224137, 0x2902520b,
	0xb1a1921f, 0xc1f13510, 0xf3a995b2, 0xe08fe4d1,
	0x8e0aea88, 0x69adf3de, 0xebeb1751, 0xc48097e0,
	0xeb3e4543, 0x91cb1bbd, 0x795e5a4b, 0x590b98b5,
	0x150e9d0a, 0x6357e8b0, 0x4f20f0aa, 0x289adadc,
	0xb9e0a6f0, 0x569f5611, 0xde2eb6ea, 0x0479fb32,
	0x9d8fd441, 0xb383f118, 0xe6d076e1, 0x74062c30,
	0xd8c01b94, 0x6dd94b17, 0xa25ddfae, 0x0cd40f1a,
	0x469ba3e4, 0x99739865, 0x753f9b61, 0x4329d982,
	0x3c0ccf01, 0xd2f67aaf, 0x8ed1c5ba, 0xdb334f6e,
	0x596f4221, 0xd895bc99, 0xb7834534, 0xef92ec63,
	0x590f43a1, 0x58bdb45b, 0x771b6d5c, 0x0d58767b,
	0x81cb8321, 0x78d7d61d, 0xc10a371e, 0x43f4ffb0,
	0x6e017938, 0x20933e95, 0x23a0cd70, 0x9d076f68,
	0x38753433, 0x4f79aeee, 0x3d5234a2, 0x3de3398f,
	0x2d696e11, 0x0055a70d, 0xda5a0e23, 0x4dcf33cd,
	0x55db4cbb, 0x1e2617bf, 0xee68f539, 0x7867ed1a,
	0xc2e25aa3, 0x44db191c, 0x13fc4db1, 0xcd253a0a,
	0xb5323656, 0x79fc7cb4, 0xfb3571e9, 0x2a842a5c,
	0xd7e7d850, 0x1676ed4f, 0x65ef80f9, 0x4af854d3,
	0x2031186a, 0x819e242c, 0xa28dd83e, 0x8cc504d3,
	0x162fb30b, 0x70276e87, 0xcefbcbac, 0x5bc7206a,
	0x5fe535cb, 0x7cae2d2f, 0x5c85e35f, 0xf0770ea8,
	0x88d10fd9, 0x549512a5, 0xfb60d6e4, 0xf0de247f,
	0x9a28eb9d, 0x43ada1f4, 0x7bc99746, 0xa490a1ea,
	0x5856f570, 0x437c7e8f, 0xe656c122, 0x9f394962,
	0xdb0a8901, 0xc51558d1, 0xb707b718, 0xa0f25183,
	0x75611f97, 0xab49f57f, 0x4af30e10, 0x95988e51,
	0xc2295b0a, 0x74a40acf, 0x7afef2c8, 0x5253fc41,
	0x16edef4e, 0x558212ff, 0x0beef9c1, 0x6a6b6a46,
	0x0391d51a, 0x1c994b44, 0x9af8ec0d, 0xc3bcaa3d,
	0x2b7d87a9, 0x4dc45708, 0xe392a5bd, 0x5b928767,
	0x85bf3be8, 0x31611ee2, 0x095eafe4, 0xee511917,
	0x66b9fae0, 0x2cf2ffbf, 0x39828c47, 0xb4053d63,
	0x89d4a62c, 0x8e889bfe, 0xcefba110, 0xdd6cdd5e,
	0xa3638499, 0x69f854d3, 0x31b11972, 0x894fa42d,
	0xbee509f8, 0x8fed0c02, 0x9736af72, 0x216c75af,
	0xd7ecc7a9, 0x278cf1ac, 0x5cdcbd1b, 0xe5bfe0d6,
	0x0cd290a6, 0x2f632aa5, 0x251bc703, 0x2efdd16e,
	0x4a680c11, 0xa5f51c57, 0x833ff618, 0x3efe78e3,
	0xf8f103fe, 0xec476f3b, 0x00d00790, 0x80110bc9,
	0x50b410ef, 0xe954f6e2, 0xbbc450cd, 0x18eef9e8,
	0x63e9faca, 0xae585780, 0xd25426e5, 0x2b4441c6,
	0xd1be4df8, 0x8c00ae3c, 0x4ce393d0, 0x1f4cc81c,
	0xc327a83c, 0x1b1015af, 0x0cd2fa1a, 0xa9c8d791,
	0xd99d7651, 0x3baba892, 0x275cf63c, 0xdccdb6d2,
	0xb50bf039, 0xe5866644, 0x94a77a68, 0x3df53eeb,
	0x4d142ba4, 0xe4305b91, 0x77a13ab2, 0xa87bb7de,
	0xef40351b, 0x74f1adc2, 0xa0a4fceb, 0x1f9ccf8c,
	0x4336a3f5, 0x4ba40540, 0xe5860cf8, 0x120c875c,
	0xc1738fb9, 0x58425258, 0x8904a1bc, 0x0e999037,
	0x9e4fb1ff, 0x34382bbc, 0x18a7d454, 0x7116ad3b,
	0x5258e3b8, 0x2717f3ad, 0x6cb12f1d, 0xa4a94dc4,
	0x4688e28a, 0xad6cdb93, 0x9b0f5479, 0x38c039b0,
	0x9ffb1527, 0xfeaff579, 0x00006abc, 0x86abfd34,
	0xfc86b152, 0x155679fc, 0x6d34fa2d, 0x7938aa85,
	0x36340621, 0xdb781ea7, 0x6c567996, 0xd1b251d0,
	0x4dc42c34, 0x64215058, 0x27152a5d, 0x412f413c,
	0x548465d6, 0x6c1f542a, 0xc34d0621, 0xb1c4980c,
	0x91628510, 0x60e04486, 0x34384100, 0x9e0c2960,
	0x8d901c69, 0x470e9a44, 0x4a230980, 0x15898598,
	0x929d4be5, 0x9df0fc2d, 0xc13aa205, 0x4abd05a9,
	0x75041584, 0xfbda457f, 0xd9badf24, 0x412f2b80,
	0xd22f98e2, 0x9099e578, 0xd61b7fdd, 0xdcf06221,
	0xe85a2f95, 0x56d442a7, 0xef405fa7, 0xf25a50f6,
	0x5c224db9, 0x0acab670, 0x2e0259d8, 0x329cafc5,
	0xd3b20ad9, 0xc97499fb, 0xad25f62f, 0x89f00388,
	0xc4c08d88, 0x6ab8c06f, 0xb95a9ba2, 0x75176a80,
	0x4c23b182, 0x1d09f911, 0x9115e599, 0x96d36ba1,
	0xfdd3aa0d, 0xc4490942, 0x72b0a38a, 0x3360f2f3,
	0x169f4810, 0x7fcea3f4, 0xd5d81ca7, 0xeb2670e1,
	0x929d2159, 0x1b5b0119, 0x3dbc1357, 0x5feb7c55,
	0x1830efa9, 0x82e2effa, 0xef8ed905, 0x9a573527,
	0xbe79e174, 0x412bb4a8, 0x9bdf53e9, 0xb8d13279,
	0xcf4f05c8, 0x17fb039b, 0xbbc43a71, 0x9e4504dc,
	0x9f6f4b98, 0xbb0e2e7c, 0xbf60dcc8, 0x527ceb43,
	0xe78a4bd9, 0x5778b09b, 0x20b5ea46, 0xcefe99cc,
	0x8ee38408, 0x7f3145f7, 0x2bc7d047, 0xe8e796ad,
	0x8d191387, 0x57b4fcb8, 0xe411f01d, 0x6d092ede,
	0x24697529, 0x856622c2, 0xa09f3b68, 0xa3f9178b,
	0xc08437cd, 0xa33ec1d5, 0x3d823332, 0xbdf23246,
	0x7ddd7efe, 0xe90151ef, 0x619e5eee, 0x5521ca25,
	0x3632b671, 0xb07e403f, 0x3c3cd3dc, 0x5323acdc,
	0x135c175b, 0xc8dbb720, 0x5f1fde61, 0xd269f216,
	0x76159e6a, 0x62ec691b, 0xf7e78bf3, 0x834cfdcd,
	0x0e7aae01, 0x2ddd45dd, 0x42b376c5, 0x9635e201,
	0x953ae853, 0x64184268, 0x362aa256, 0xb1303a38,
	0x5b3b98af, 0x94173516, 0xb95af11e, 0xf3bc97b4,
	0xb0a500d0, 0x085f80ed, 0xfc211fb4, 0xefebc124,
	0xcbe7ac2c, 0x1f3117e5, 0x1ee6da1c, 0xe2d2a323,
	0x5b5b6424, 0x1beff3ac, 0xf2cd36fa, 0xaa0931dd,
	0xc619448f, 0x77445533, 0xfef11576, 0xee2fe459,
	0x89526ab9, 0xe202ab7c, 0xdbb69805, 0x045b1c47,
	0x33e9fd1d, 0x06252eec, 0xd1fc5a69, 0xad58b7e1,
	0x5dd24e2d, 0x8a0bffb6, 0x7afe9874, 0xd4f80175,
	0xea6b5e1c, 0x40d46b03, 0x66da03ec, 0x1353c0c3,
	0x35a5d33b, 0xc7e155e3, 0xf6ae959b, 0x120efbed,
	0x66b9ab9d, 0x29e50750, 0xc4878fe0, 0x1abdc65b,
	0xd13b5e3e, 0x5d7e4ac8, 0xca13a9c5, 0x5f95811b,
	0xf7db7ff0, 0x4c12bb39, 0x0dbacd47, 0x2a091403,
	0x0444ba45, 0xc98601ba, 0x84d8a890, 0xc8e558c6,
	0x31fecf7c, 0xf408a8fe, 0xf08bbb77, 0xc3f2a184,
	0xcbe11c7c, 0x7437497d, 0x4e8c7056, 0x60435e2f,
	0x05c35f4b, 0xb71514d4, 0x8ac7c2c6, 0x394f82f7,
	0xe488bf33, 0x79b76802, 0xca5b98a4, 0xdca78198,
	0x164a41a8, 0xaf3faa27, 0xad3dafc0, 0x0c62d726,
	0x2b430927, 0x2533f6c0, 0xadf5f1bf, 0x09e10841,
	0x94749d67, 0x83ec368d, 0x029ecb6f, 0x6df99368,
	0x2fca4b48, 0xb351ae91, 0x4341c37c, 0xbd972a67,
	0x2c6de7f5, 0x4849a77e, 0x3e53305a, 0x2c2c3aef,
	0xd5b8e02c, 0x64deb65b, 0xd90ae6bd, 0x42eea770,
	0x4b005708, 0x20f0a98b, 0x1ae0e56b, 0x8326ca87,
	0xad3b1f90, 0x676489be, 0x7b29a36d, 0xa7a20bcc,
	0xf36dcad0, 0xa51bef39, 0xec7e695b, 0x10aa85a7,
	0x200f30d3, 0x630aae59, 0x1b60c69a, 0x81d9cb50,
	0xdc59e86d, 0xf0aa2b3c, 0x5ae6d030, 0x40706c1f,
	0x26f9c460, 0x0f3ae2c3, 0xa9b14bfa, 0xc06709fb,
	0x10ac35f7, 0x4b096e4b, 0x33600413, 0x99f13b96,
	0xdf41f03f, 0x70a30f15, 0x88a0df00, 0xc9a0631a,
	0x62e197a3, 0x280af951, 0x3b906f11, 0x9b392e3b,
	0x5f7f22ea, 0x5d9134ac, 0x3d82598e, 0x3b59cf72,
	0x815bcfac, 0xfc572813, 0x0caaa4c3, 0x2c1960a0,
	0x0006b050, 0x6b065e98, 0x506aaa4a, 0x8291fd0c,
	0x5e983b6f, 0xacfae778, 0x780af43c, 0x9346b32a,
	0x2291fbbc, 0x0ef33d31, 0x34aa8dd2, 0x328865c1,
	0x9f182b11, 0x4d3d015b, 0x768b37c5, 0x0839cb61,
	0x18aaf43a, 0x2316d82c, 0x7c09abd6, 0xa4b9bfa0,
	0xc9a6d34a, 0x09e7c93b, 0x7860531b, 0xb901921d,
	0xc5a11554, 0xf385c592, 0x259bc090, 0xaec4eaa4,
	0x19c834ce, 0x8fa8f29d, 0xc8fda5c1, 0x3e22c102,
	0xb3014bb1, 0x4d3bb10b, 0x1d8d695d, 0x5853612b,
	0x9a3b0936, 0x7d8ee343, 0xd0f34cae, 0xdcb34b9c,
	0x5ae06060, 0x2b763287, 0x76936e2a, 0x8dab1fcf,
	0xf7297095, 0x6c9dee83, 0x68a6c1cb, 0xd84fdd61,
	0x11f1ffaf, 0x970206a7, 0xebeb7ded, 0x422b6ad4,
	0x17b8f411, 0x849d6241, 0x146aa066, 0x20333230,
	0x233a9b2b, 0xb82ff617, 0x2376893c, 0xf9288b0c,
	0xf4248ac4, 0x32be0649, 0xf93b9cb7, 0x4556ba0e,
	0xc90bb197, 0xdf9ca532, 0x259d70c0, 0xc5c2b43c,
	0x49a29e84, 0x0d390f91, 0x96659eae, 0x92d8267a,
	0xcb0bbf8d, 0xde7d0221, 0x3f1c92e1, 0x56a05c1a,
	0xae9184e4, 0x4f068682, 0x4feb67bf, 0x918e4ac7,
	0x2c6b57a5, 0x234ff9e6, 0x6e399a10, 0xaebdc7e3,
	0x8b20db43, 0xc8245123, 0xa1001281, 0xd1a8145a,
	0x6991acb4, 0x2e0394ba, 0x2e4a68b9, 0xb1aeaf46,
	0x32233481, 0x2a5988e5, 0x0da294a8, 0xaf9bc0ad,
	0xebc73eea, 0x860d3715, 0x9077c28d, 0xb4133a07,
	0xe9a9e399, 0x6aed6762, 0x63009581, 0x38d8594d,
	0x19f8fd39, 0x032feeae, 0x7f7d10a0, 0xeeb486bb,
	0x3f31f0ae, 0x8092105e, 0x614cee3b, 0xfe45c8f9,
	0xa3ad7e46, 0x0632df40, 0x2eed6d4e, 0xc1a25abd,
	0x457af909, 0x0d2dec56, 0x585393ae, 0x15132886,
	0x3801f7c3, 0x037ccbd6, 0x4d03013b, 0x169231f4,
	0xa856527f, 0x310cda2f, 0x55249845, 0xe3161213,
	0x90aa3003, 0x6b552eb4, 0xe741d92e, 0x6e320a74,
	0x17be4441, 0xef9b3cd9, 0x44000a2c, 0xa2a2cf3c,
	0x7da2a044, 0x14d5116f, 0x5b7c7d00, 0x6a6e3826,
	0xd6b57178, 0x3c4d3b78, 0xcd911165, 0x77dedfcf,
	0x56139a86, 0x92a1a469, 0x53164705, 0xcdfb7f5d,
	0x51086abe, 0x2e2fd7bd, 0xea6c3578, 0x366199da,
	0x02ad6cc7, 0xd79acb1a, 0x477cc1fa, 0xefa1ce07,
	0x6b3091b0, 0xbc834310, 0x6a70a72f, 0x3f4aa063,
	0x35a3636b, 0xace70b7b, 0xa6c43fd1, 0x909f06e1,
	0x382190f2, 0x851fe028, 0xbc8d7bdc, 0x89fb7571,
	0xf3aaa582, 0x538d77f9, 0xfeb92417, 0x6d1de4da,
	0x68c354e1, 0x012fba62, 0x7b31fa82, 0x2230df62,
	0x1cee4e7f, 0xea90d996, 0xf8d10346, 0x6c5ce766,
	0xf8581c36, 0xfdef61c5, 0x88ebe86c, 0x7af33399,
	0x0e400928, 0x87b28cef, 0x6b17b0c6, 0xce87b48b,
	0x1c0b6b85, 0x38bde649, 0x423a6707, 0x076d43f5,
	0x5789f482, 0x348cd909, 0xd7d6f1f9, 0x84f4e0b3,
	0x8c71489e, 0xd2b14964, 0x7dcee36e, 0xd0d19cba,
	0x71a36947, 0x0e45c447, 0xdb669f95, 0x844a178e,
	0x635dedf2, 0xef71d80e, 0x6a380aa4, 0xb5b64e09,
	0x3e3bb4e7, 0x2453a836, 0xa8aabe91, 0xffbc40b3,
	0x3bd513e4, 0xccd4c53f, 0x2a39903c, 0x0c1f08df,
	0xf6827b07, 0xdcf1404c, 0xfa7c6f81, 0xbbc62c7c,
	0xbf24ddcc, 0x124eafc2, 0xe3db79dc, 0xc6707089,
	0x6430ae07, 0xb8f82c8c, 0x5eb4d3ad, 0x6260bff0,
	0xbacf5454, 0xa822e0a8, 0x7a1bf7f5, 0x8272a3dd,
	0xeb048f5e, 0xbd77ac78, 0x247c547b, 0xd779974a,
	0x72c86c89, 0xbfacadbe, 0x150db78f, 0xd1fe26d8,
	0x0a9293c5, 0x2c751b25, 0xc788d1ea, 0x6edace18,
	0x9b8ceeb4, 0x832d3f68, 0x92601692, 0x48592fcc,
	0xb6d05c8b, 0x5ea09baf, 0xa6eab7b9, 0x780ecc5c,
	0x50c2a322, 0x025371b4, 0x3632fbb9, 0x34a2ee96,
	0xb4b81c00, 0xdb9c03b9, 0xadf59b03, 0x8f4af575,
	0x68f22c35, 0x96ba4f71, 0x6faa3142, 0x14c139ed,
	0x19fe4d69, 0x6829b036, 0x2f17baea, 0x6c257bb7,
	0x61a9cbc1, 0x2c68f726, 0x19461a07, 0x6d037bd3,
	0x813c85fa, 0x08c1e271, 0x1a47e09c, 0xf32a3f7c,
	0xda62d218, 0x4010ed0d, 0x2ed8a46b, 0x1d2ae3e7,
	0x20ab03f9, 0x206a13fa, 0x310aaaed, 0xb22b8e54,
	0x61f08135, 0x38eb1314, 0x2d44cb5e, 0x5a17800e,
	0x550b2557, 0x98d0eb26, 0xc2da19be, 0xc0f6e0d0,
	0x0e76708f, 0x6033ce44, 0x8cfdafed, 0x9c800e3e,
	0xcea3ebf5, 0x59eea064, 0x46f1145d, 0x323d590d,
	0x4c8e784e, 0x41c3d83b, 0x1d625dcb, 0xab6d9453,
	0x0cf3fae6, 0xb9d796ee, 0x2585292f, 0x40506092,
	0xa6211a2b, 0x42b2393e, 0x82caf4b3, 0xee2e44bb,
	0x135c9368, 0x4098cdbd, 0xac97bc17, 0xad8aa4d3,
	0x7c8865a1, 0x381e2151, 0x7e1a0749, 0x1f799253,
	0x1699f840, 0x14c8fd6c, 0x85b2b6ed, 0x69b78ded,
	0xcc051a36, 0xb7a1e661, 0x45b6e76b, 0xccadcf7f,
	0x3aa11415, 0x8c11d2cb, 0xdb2454d7, 0xa8df50e6,
	0x2161ca65, 0x0c16b5f3, 0xed54642c, 0xb0e8f918,
	0xd7e5f1f2, 0x34eddbb7, 0xc7cd91a7, 0x3afcbb7c,
	0x56c998d2, 0xb2e9e747, 0xc7008fd3, 0xeb7d795e,
	0x222b5e8d, 0xa4fd7509, 0x052e2ad6, 0x603a7368,
	0x972bb0c6, 0xf099b76a, 0xe33a7586, 0xd6c557af,
	0x3e185836, 0x1a8f4db3, 0xf99c9940, 0x355a4ff5,
	0xbe527c1f, 0xf8e8c181, 0x706c77c6, 0x7f4a5c17,
	0x9a6457ad, 0x8848f352, 0x4b115d18, 0x30592d89,
	0x8af40e6b, 0x859cbf6c, 0x09389f25, 0x8d6e1744,
	0x27c349de, 0x277c4698, 0xd7d7ae31, 0x1108c608,
	0x04e4e34a, 0x4c46d561, 0x4b757e07, 0xf25ac026,
	0x552f0541, 0xdac39f0c, 0xd49102cf, 0x7a6476c1,
	0xfa5e24c5, 0x1f634394, 0xbb88ea72, 0xd363580f,
	0x5c3159c4, 0xbb84e75a, 0x13b7d296, 0x74f28e04,
	0x1299062b, 0x992e3a87, 0x2f3f6fb0, 0x6164b1ce,
	0x7baebf5d, 0xd62282cc, 0xc33d8d55, 0xb94b9d3e,
	0x657628c8, 0x50379167, 0x510dbda3, 0x735ce9e4,
	0x77303381, 0x38a00a4a, 0x9cf4acea, 0x04b4f63e,
	0x4d399fcc, 0xbf600410, 0x5ff107f7, 0x3f87f003,
	0xe0c3c60d, 0xcc013fc6, 0xf5fcf0bc, 0xb5f5b301,
	0x01cac99c, 0x2c7ca609, 0xdc5ecec1, 0x02c3774c,
	0xb61570c7, 0x0c06c8a3, 0xea895af9, 0x60eb3b72,
	0x03c2bd85, 0x2a390c61, 0x05da966d, 0x2b8b998e,
	0x2c5d2e02, 0xc4cebb4d, 0x89d3853b, 0xfcba7d56,
	0x59885b33, 0xa977170e, 0xa5cb61db, 0xe4f80ea2,
	0x72962078, 0x5b4c9588, 0xe4fec48b, 0x9e37dba6,
	0xb2a186f9, 0x413f576f, 0x55e95ee9, 0x3f1a3c85,
	0x3c454d86, 0xcafaca6c, 0xc9dba9ab, 0xde776932,
	0x99a89d03, 0xc50472d1, 0xa5af2332, 0x20e4b397,
	0x5b4b2c7f, 0x1f6267c9, 0xa9cda978, 0x0e71545b,
	0x127d1b0a, 0x588e280d, 0xcec7c8ea, 0x9bed4dcb,
	0x992a1f77, 0x6d62796d, 0x9127e5a4, 0xb6c9b9be,
	0xc0ff30d0, 0x9372915f, 0x60acbea5, 0x7bbc08e9,
	0x7d5093a1, 0xb79252a9, 0xfee3b6ba, 0xc41a771c,
	0xc57cf7d9, 0xadc3e130, 0xe8f2fe17, 0x5b980ab2,
	0x2d67278f, 0x64cb658b, 0x043d0286, 0x5236e460,
	0x475d7645, 0xf4cae46e, 0x54239775, 0x13669a8c,
	0xe01b8347, 0xc839bd20, 0x7fced96c, 0xd271a191,
	0x7321c7fa, 0xa5ef49a3, 0xa66d9eb7, 0x0addbff6,
	0x5e91ba12, 0x34e9fe47, 0x8590877a, 0xcabfef16,
	0x9bae9e31, 0xa434555b, 0x974f93d9, 0x329a5ac5,
	0x3ce17eac, 0x899a77cf, 0xe3b1c5dc, 0xed852c36,
	0x2401f45b, 0x0d454af9, 0xd20d385c, 0x3a835f86,
	0x28b9cd48, 0x88886e2c, 0xc2a6fb3c, 0x0ee0bd70,
	0x0ca75e72, 0x73b48802, 0x715a6314, 0x9e9c7863,
	0x88c804bd, 0x442fd61c, 0x5f762ef9, 0x4d5483a9,
	0xee90df3d, 0xfabbb035, 0x465e8c7f, 0x4be8b281,
	0x2edc4bad, 0x53d4f0eb, 0xe6e4c61b, 0xbf13d8fc,
	0xe206225e, 0x1326f01d, 0x6692ae67, 0x99af2ea9,
	0x3e3d04b7, 0x4f55f6ae, 0xf8c014db, 0x7d2dbdbf,
	0x654d288b, 0x602e2247, 0x52336400, 0x9f59bbf5,
	0xd41380bb, 0xd2027d7d, 0xced6e253, 0x894e49bd,
	0x203cf6dd, 0x5f73ae99, 0x95504e19, 0xce49bbe8,
	0x7c9a5a3d, 0x9beef4a0, 0x22bd787b, 0xc6d90050,
	0x7369871e, 0xa1c52993, 0x027ba4ee, 0x3b7331c0,
	0x2ea59a0a, 0x4ef269ea, 0x01e794eb, 0x79bd7dee,
	0x6b005847, 0x30045f23, 0xddf0124e, 0xefdce7da,
	0xb993d874, 0x614eaa2e, 0xda05b8b7, 0x3689af33,
	0x01b7e782, 0xfea3dc2b, 0x42935a3c, 0x94ea6450,
	0xec303ceb, 0x75d6a928, 0xd079d993, 0xf5a5d393,
	0xa7ebd3b7, 0x6ece9f37, 0x5e943a72, 0xeced33f7,
	0xa549e3af, 0x4c9e051e, 0x461ee6ee, 0xcd619fa1,
	0x7f4ad824, 0x12272d30, 0x7bc09124, 0x34f20bdd,
	0x3ac4d642, 0xd0064621, 0x0c6133d6, 0x950df0bb,
	0x958d4105, 0x1ed6f16f, 0xe07d86b0, 0x2855c1dd,
	0x4837346d, 0xd75d4743, 0x3fda905c, 0x36e88b40,
	0x93c04c9c, 0x4d29e29c, 0xb8bd3ac5, 0x8ff2c59d,
	0xeba0bc74, 0xfe1711db, 0x0e16380c, 0xe48bd24e,
	0xcf6105d1, 0x77ed9596, 0x62aface1, 0xcb99cac9,
	0x796072f2, 0xbb9f12c0, 0xace383ae, 0x6e4b2733,
	0x8556abcc, 0xa8179f67, 0x2dfdbd6c, 0x4d281a64,
	0xa7324741, 0x77ed34de, 0x68bb7ce4, 0x8393f64b,
	0x7ead4ccf, 0x6b9a50de, 0x10c0c963, 0x04f654fe,
	0xe734c40c, 0x3fdaa1fb, 0xb5f2eba2, 0xf4435a95,
	0x4f88f9b2, 0x285f5e5c, 0xe1ca6132, 0xd6f61df6,
	0x0aa46e51, 0x43b72313, 0xd3eaacb7, 0x433e2268,
	0x43b9950f, 0xb88c310f, 0x1f56e972, 0xe13c5aaa,
	0xb5348606, 0x12fa222c, 0xab5fdba3, 0xa815d750,
	0x897fe33f, 0xba8c0a37, 0x1de574c5, 0xd9bee7f9,
	0x02a0e3d6, 0x8f6d191d, 0x962755ec, 0xbe4d6112,
	0x8937981a, 0x3d1a6fdc, 0xb870fc69, 0x53feeb0b,
	0x474fc1f1, 0x5fb8f503, 0x208c4889, 0x54ceb108,
	0x4177dc93, 0x5d72db9e, 0x830085ff, 0x49dfb662,
	0x5f89fec9, 0xb0286466, 0x5e5257d6, 0x0a544b4e,
	0x419ec1be, 0xccd48c12, 0x2eab64e3, 0xa11b8860,
	0x680bc2b0, 0x882ee9da, 0xaa8ade45, 0xf8a130a8,
	0xef5a16a1, 0xd6c7163c, 0x9a0042be, 0x492bc5cd,
	0x98c93b6a, 0x5fd23848, 0x0c6d9ce2, 0xdff8e38e,
	0xe1c49fdb, 0x391ffc7c, 0x6348380a, 0xb224b727,
	0x12602ab5, 0x8b9b4de3, 0x711391e0, 0x8197c0e9,
	0x3cc573b8, 0xc9593549, 0xf7f805db, 0x7ba1b557,
	0xa685a0c3, 0x894ee8f5, 0x2a2826d8, 0x1779921b,
	0x929d7024, 0x1e4cf9f6, 0xc0b910f0, 0xf153876d,
	0x40df17bb, 0x51143ecc, 0xeb66d1d0, 0x18ae6962,
	0xeac11a1d, 0x64c15b42, 0xa7d487dc, 0x1b978257,
	0x75eeb675, 0x51900e23, 0xa82a3d93, 0x77cc29b5,
	0x797d434d, 0x688a772e, 0x1337daa4, 0x7431aa11,
	0x20b9c703, 0x0c2cd343, 0x4b225d13, 0x8040168d,
	0xc148d752, 0x6dd14d74, 0x223fe499, 0xef566cb9,
	0x9160af4a, 0xc244fb81, 0x2e9a6f29, 0x31bfa48f,
	0x6297246e, 0xc30d7e07, 0xb666c465, 0xb7753945,
	0x882ec420, 0x28556095, 0x4223e468, 0x9f577bc1,
	0x3817ae61, 0xe6edc95e, 0x2fe30651, 0x27949151,
	0xdadf5505, 0x183ffb01, 0x73afeaba, 0x477c512a,
	0xe6ac86ff, 0xbb39b8cc, 0x46101807, 0x22887e2b,
	0x16a68e7f, 0xe3b4b904, 0xba4a1726, 0xfc576456,
	0x086ed2ad, 0xe91db7c7, 0x2ff2a91c, 0xbd689f58,
	0xd741c2d8, 0x778d6614, 0xeda7fdd0, 0x090efe78,
	0xeb60f18a, 0x7aa8df6f, 0xb0a294bd, 0xf11a954f,
	0x51d9bfba, 0x33177cec, 0x6e457892, 0x60ab9a43,
	0x89f1f5be, 0xdba31765, 0x5ca7de78, 0xd3b46207,
	0x2ffa43fc, 0x33c2e2c2, 0x37cd521d, 0xcec775e2,
	0x903d93f2, 0x9121e0eb, 0x569e451c, 0x4f1ee67f,
	0xc9e88fa1, 0x6c0e5110, 0x53162db9, 0x4b508269,
	0xad8edbec, 0x3b79ae41, 0x8758cf55, 0x4f59335f,
	0x34996ae6, 0x0ce2d5bd, 0x2b2ab86c, 0x3e139fd7,
	0x26f4bd84, 0xd8a21348, 0x4d658d72, 0x7e65e15f,
	0x612706bd, 0xc0f85f51, 0x658939f0, 0x215b9eed,
	0xa94315e2, 0xe5ffa4ae, 0x88b53adc, 0x17f75c11,
	0x7e3ab9eb, 0x1483edbd, 0xb49a2d97, 0x78946142,
	0xfa5e1f04, 0x9cdf464f, 0xba0b5887, 0x688ddacb,
	0x69ea5bfb, 0x114a9ce9, 0x216bdc62, 0x2d73cce6,
	0x2a7784d4, 0x6d7684bd, 0x5ef097b1, 0xa60351b8,
	0xe61a26bd, 0xd166ce48, 0x8457ef61, 0x3cdde47d,
	0x4029263c, 0x32775039, 0x6c383edf, 0x35f1ec30,
	0x843bfe5b, 0xfdf840f2, 0x7af307d6, 0x0d04e33b,
	0x48b1c516, 0xb809890b, 0xc49478cc, 0xa5c6f63a,
	0x3d80d8c5, 0x134c3d56, 0x4a737a0c, 0x12997c2f,
	0x9e8e47ff, 0x2b38d14c, 0x1888a92e, 0x86d6bcfa,
	0x28a4fcf7, 0x5b9d0bc2, 0x7d72a236, 0x149a3052,
	0xa94832bd, 0xd78fc426, 0x1785836b, 0x53f4748a
	};

class DDeviceKUCopy : public DLogicalDevice
	{
public:
	DDeviceKUCopy();
	virtual TInt Install();
	virtual void GetCaps(TDes8& aDes) const;
	virtual TInt Create(DLogicalChannelBase*& aChannel);
	};
class DKUCopy : public DLogicalChannelBase
	{
public:
	virtual ~DKUCopy();
protected:
	virtual TInt DoCreate(TInt aUnit, const TDesC8* anInfo, const TVersion& aVer);
	virtual TInt Request(TInt aFunction, TAny* a1, TAny* a2);
private:
	TUint8* iBuf;
	TClientRequest* iClientRequest;
	};

DECLARE_STANDARD_LDD()
	{
	return new DDeviceKUCopy;
	}

DDeviceKUCopy::DDeviceKUCopy()
//
// Constructor
//
	{
	//iParseMask=0;
	//iUnitsMask=0;
	iVersion=TVersion(1,0,0);
	}

TInt DDeviceKUCopy::Install()
//
// Install the device driver.
//
	{
	return SetName(&KLddName);
	}

void DDeviceKUCopy::GetCaps(TDes8&) const
//
// Return the Comm capabilities.
//
	{
	}

TInt DDeviceKUCopy::Create(DLogicalChannelBase*& aChannel)
//
// Create a channel on the device.
//
	{
	aChannel=new DKUCopy;
	return aChannel?KErrNone:KErrNoMemory;
	}

DKUCopy::~DKUCopy()
	{
	Kern::DestroyClientRequest(iClientRequest);
	Kern::Free(iBuf);
	}

TInt DKUCopy::DoCreate(TInt /*aUnit*/, const TDesC8* /*anInfo*/, const TVersion& aVer)
//
// Create the channel from the passed info.
//
	{
	if (!Kern::QueryVersionSupported(TVersion(1,0,1),aVer))
		return KErrNotSupported;
	iBuf=(TUint8*)Kern::Alloc(KBufSize);
	if (!iBuf)
		return KErrNoMemory;
	TInt r = Kern::CreateClientRequest(iClientRequest);
	if (r != KErrNone)
		return r;
	return KErrNone;
	}

TInt DKUCopy::Request(TInt aFunction, TAny* a1, TAny* a2)
//
// Client requests
//
	{
	TInt r=KErrNone;
	switch (aFunction)
		{
		case RKUCopy::EControlPut:
			{
			SCopyInfo info;
			kumemget(&info, a1, sizeof(info));
			kumemput( (TUint8*)info.iPtr, ((const TUint8*)RandomData)+info.iOffset, info.iLength );
			break;
			}
		case RKUCopy::EControlGet:
			{
			SCopyInfo info;
			kumemget(&info, a1, sizeof(info));
			wordmove(iBuf,RandomData,KBufSize);
			kumemget( iBuf+info.iOffset, info.iPtr, info.iLength );
			break;
			}
		case RKUCopy::EControlPut32:
			{
			SCopyInfo info;
			kumemget(&info, a1, sizeof(info));
			kumemput32( (TUint8*)info.iPtr, ((const TUint8*)RandomData)+info.iOffset, info.iLength );
			break;
			}
		case RKUCopy::EControlGet32:
			{
			SCopyInfo info;
			kumemget(&info, a1, sizeof(info));
			wordmove(iBuf,RandomData,KBufSize);
			kumemget32( iBuf+info.iOffset, info.iPtr, info.iLength );
			break;
			}
		case RKUCopy::EControlSet:
			{
			SSetInfo info;
			kumemget(&info, a1, sizeof(info));
			kumemset( info.iPtr, (TUint8)info.iValue, info.iLength );
			break;
			}
		case RKUCopy::EControlLength:
			r=KBufSize;
			break;
		case RKUCopy::EControlRead:
			{
			kumemput(a1,iBuf,KBufSize);
			break;
			}
		case RKUCopy::EControlRandomLength:
			r=(TInt)sizeof(RandomData);
			break;
		case RKUCopy::EControlReadRandom:
			kumemput(a1,RandomData,sizeof(RandomData));
			break;
		case RKUCopy::EControlDesPut8:
			{
			TPtr8 buf(iBuf,0,KBufSize);
			Kern::KUDesGet(buf,*(const TDesC8*)a2);
			Kern::KUDesPut(*(TDes8*)a1,buf);
			break;
			}
		case RKUCopy::EControlDesGet8:
			{
			TPtr8 buf(iBuf,0,KBufSize);
			Kern::KUDesGet(buf,*(const TDesC8*)a2);
			Kern::KUDesPut(*((TDes8*)a1),buf);
			break;
			}
		case RKUCopy::EControlDesInfo8:
			{
			SDesInfo info;
			info.iPtr=(TAny*)Kern::KUDesInfo(*(const TDesC8*)a1,info.iLength,info.iMaxLength);
			kumemput(a2,&info,sizeof(info));
			break;
			}
		case RKUCopy::EControlKernBufAddr:
			r=(TInt)iBuf;
			break;
		case RKUCopy::EControlRequestComplete:
			Kern::RequestComplete(*(TRequestStatus**)&a1, KErrNone);
			break;
		case RKUCopy::EControlRequestCompleteLocal:
			Kern::RequestComplete(*(TRequestStatus**)&a1, KErrNone);
			break;
		case RKUCopy::EControlQueueRequestComplete:
			r = iClientRequest->SetStatus((TRequestStatus*)a1);
			Kern::QueueRequestComplete(&Kern::CurrentThread(), iClientRequest, KErrNone);
			break;
		default:
			r=KErrNotSupported;
			break;
		}
	return r;
	}

