// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// This is a unit test module which defines the test code that 
// exercise CFont::GetCharacterPosition() functionality.
// 
//

/**
 @file
 @test
 @internalComponent
*/


//
// -- INCLUDE FILES ---------------------------------------------------------
//


#include <e32std.h>
#include <biditext.h>
#include <bidi.h>
#include <linebreak.h>
#include <bidivisual.h>
#include "GlyphSel.h"
#include "TGlyphSel.h"
#include <graphics/openfontconstants.h>
#include <graphics/openfontrasterizer.h>


//
// -- CONSTANTS -------------------------------------------------------------
//

/**
 This define when set introduces a delay to start up to allow Glowcode to
 be set up to collect statistics.
*/
//#define _GLOWCODE_LAUNCH_DELAY 1


/** RTest object for unit test output */
//RTest TEST(_L("TGlyphSel - CFont Glyph Selection"));

/** Thread name for test cases involving a new thread. */
_LIT(KThread2NameFirst, "GlyphSelPanicTest_First");
_LIT(KThread2NameSecond, "GlyphSelPanicTest_Second");

/*Beginning of Indic language font file constants declaration*/

_LIT16(KTestHindiFontFile, "C:\\TNR_Dev_OT.ttf");
_LIT16(KTestHindiFontFaceName, "Devanagari OT Eval");

//_LIT16(KTestIndicFontFile, "C:\\s60ssb_v435.ttf");
_LIT16(KTestIndicFontFile, "C:\\s60ssb_v500.ttf");
_LIT16(KTestIndicFontFaceName, "Series 60 Sans");

//_LIT16(KTestTeluguFontFile, "C:\\s60ssb_v500.ttf");
//_LIT16(KTestTeluguFontFaceName, "Series 60 Sans");

_LIT16(KTestGB18030FontFile, "C:\\TestExtB.ttf");
_LIT16(KTestGB18030FontFaceName, "Test Font for CJK ExtB");

/*End of Indic language font file constants declaration*/
//
// -- THAI TEST DATA --------------------------------------------------------
//


/**
 An array of Thai characters each of which is individually passed into
 GetCharacterPosition() for testing.
*/
LOCAL_D const TText16 Thai_SimpleChars[] = {
	 // Digits test 0..9
	0x0E50, 0x0E51, 0x0E52, 0x0E53, 0x0E54,
	0x0E55, 0x0E56, 0x0E57, 0x0E58, 0x0E59,

	// Consonants
	0x0E01, 0x0E02, 0x0E03, 0x0E04, 0x0E05, 0x0E06, 0x0E07, 
	0x0E08, 0x0E09, 0x0E0A, 0x0E0B, 0x0E0C, 0x0E0D, 0x0E0E, 0x0E0F, 
	0x0E10, 0x0E11, 0x0E12, 0x0E13, 0x0E14, 0x0E15, 0x0E16, 0x0E17, 
	0x0E18, 0x0E19, 0x0E1A, 0x0E1B, 0x0E1C, 0x0E1D, 0x0E1E, 0x0E1F, 
	0x0E20, 0x0E21, 0x0E22, 0x0E23, 0x0E24, 0x0E25, 0x0E26, 0x0E27, 
	0x0E28, 0x0E29, 0x0E2A, 0x0E2B, 0x0E2C, 0x0E2D, 0x0E2E, 

	// Independent vowels
	0x0E30, 0x0E32, // 0x0E33, Sara Am decomposed, not simple
	0x0E40, 0x0E41, 0x0E42, 0x0E43, 0x0E44, 

	// Independent signs
	0x0E2F, 0x0E3F, 0x0E45, 0x0E46, 0x0E4F, 0x0E5A, 0x0E5B, 

	// Array end
	0xFFFF,
	};

/**
 Data structure used to hold the in and out data of one invoke
 of the CFont::GetCharacterPosition() API.
*/
struct TTestInput_PositionParam
	{
	TInt	iTextLen;
	TText16	iText[4];
	TInt	iPosInText;
	TInt	oPosInText;
	TInt	oOutputLen;
	TText16	oOutput[CFont::TPositionParam::EMaxOutputGlyphs];
	};

/**
 This array of structs is used in the test routine 
 CTGlyphSelection::TestThai_ValidGlyphClusters() for verifying
 GetCharacterPosition() constructs Thai PUA glyph clusters correctly.
*/
LOCAL_D const TTestInput_PositionParam Thai_ValidGlyphClusters[] = {
//    --INPUT----------------			--OUTPUT----------------------

//  TEST A1..A8 handled in Thai_SimpleChars table.

//0.TEST A9 - Decomposed SARA AM
	{ 2, {0x0E01, 0x0E33}, 1,			2, 1, {0x0E33}},
	{ 2, {0x0E1B, 0x0E33}, 1,			2, 2, {0xF711, 0x0E32}},
	{ 2, {0x0E41, 0x0E33}, 1,			2, 2, {KUnicodeDottedCircle, 0x0E33}},
	{ 1, {0x0E33}, 0,					1, 2, {KUnicodeDottedCircle, 0x0E33}},
	{ 3, {0x0E19, 0x0E49, 0x0E33}, 0,	3, 4, {0x0E19, 0x0E4D, 0x0E49, 0x0E32}},

//5.TEST A9.1 - SARA AM exlcuded from cluster when vowel present
	{ 3, {0x0E19, 0x0E35, 0x0E33}, 0,           2, 2, {0x0E19, 0x0E35}},
	{ 3, {0x0E19, 0x0E39, 0x0E33}, 0,           2, 2, {0x0E19, 0x0E39}},
	{ 4, {0x0E19, 0x0E35, 0x0E48, 0x0E33}, 0,   3, 3, {0x0E19, 0x0E35, 0x0E48}},

//8.TEST B1 - Normal right aligned vowel/sign above short consonant
	{ 2, {0x0E04, 0x0E35}, 0,			2, 2, {0x0E04, 0x0E35}},
	{ 2, {0x0E01, 0x0E4D}, 0,			2, 2, {0x0E01, 0x0E4D}},

//10.TEST B2 - Left aligned vowel/sign above tall consonant
	{ 2, {0x0E1B, 0x0E34}, 0,			2, 2, {0x0E1B, 0xF701}},
	{ 2, {0x0E1D, 0x0E35}, 0,			2, 2, {0x0E1D, 0xF702}},
	{ 2, {0x0E1F, 0x0E36}, 0,			2, 2, {0x0E1F, 0xF703}},
	{ 2, {0x0E2C, 0x0E37}, 0,			2, 2, {0x0E2C, 0xF704}},
	{ 2, {0x0E1B, 0x0E31}, 0,			2, 2, {0x0E1B, 0xF710}},
	{ 2, {0x0E1D, 0x0E4D}, 0,			2, 2, {0x0E1D, 0xF711}},
	{ 2, {0x0E1F, 0x0E47}, 0,			2, 2, {0x0E1F, 0xF712}},
	
//17.TEST B3 - Normal right aligned vowel below short consonant
	{ 2, {0x0E2C, 0x0E3A}, 0,			2, 2, {0x0E2C, 0x0E3A}},
	{ 2, {0x0E0C, 0x0E38}, 0,			2, 2, {0x0E0C, 0x0E38}},

//19.TEST B4 - Vowel below consonant with joint decender 
	{ 2, {0x0E0E, 0x0E38}, 0,			2, 2, {0x0E0E, 0xF718}},
	{ 2, {0x0E0F, 0x0E39}, 0,			2, 2, {0x0E0F, 0xF719}},
	{ 2, {0x0E0F, 0x0E3A}, 0,			2, 2, {0x0E0F, 0xF71A}},
	{ 2, {0x0E24, 0x0E38}, 0,			2, 2, {0x0E24, 0xF718}},
	{ 2, {0x0E26, 0x0E39}, 0,			2, 2, {0x0E26, 0xF719}},

//24.TEST B5 - Vowel below consonant with disjoint decender
	{ 2, {0x0E10, 0x0E38}, 0,			2, 2, {0xF700, 0x0E38}},
	{ 2, {0x0E0D, 0x0E39}, 0,			2, 2, {0xF70F, 0x0E39}},
	{ 2, {0x0E10, 0x0E3A}, 0,			2, 2, {0xF700, 0x0E3A}},
 
//27.TEST C1 - Tone mark/sign above short consonant
	{ 2, {0x0E14, 0x0E48}, 0,			2, 2, {0x0E14, 0xF70A}},
	{ 2, {0x0E16, 0x0E49}, 0,			2, 2, {0x0E16, 0xF70B}},
	{ 2, {0x0E17, 0x0E4A}, 0,			2, 2, {0x0E17, 0xF70C}},
	{ 2, {0x0E19, 0x0E4B}, 0,			2, 2, {0x0E19, 0xF70D}},
	{ 2, {0x0E20, 0x0E4C}, 0,			2, 2, {0x0E20, 0xF70E}},
	// with lower vowel char in between the two?
	{ 3, {0x0E16, 0x0E39, 0x0E49}, 0,	3, 3, {0x0E16, 0x0E39, 0xF70B}},

//33.TEST C2 - Upper Vowel & tone makr/sign above short consonant
	{ 3, {0x0E01, 0x0E34, 0x0E48}, 0,	3, 3, {0x0E01, 0x0E34, 0x0E48}},
	{ 3, {0x0E02, 0x0E35, 0x0E49}, 0,	3, 3, {0x0E02, 0x0E35, 0x0E49}},
	{ 3, {0x0E04, 0x0E36, 0x0E4A}, 0,	3, 3, {0x0E04, 0x0E36, 0x0E4A}},
	{ 3, {0x0E08, 0x0E37, 0x0E4B}, 0,	3, 3, {0x0E08, 0x0E37, 0x0E4B}},
	{ 3, {0x0E09, 0x0E34, 0x0E4C}, 0,	3, 3, {0x0E09, 0x0E34, 0x0E4C}},
	{ 3, {0x0E11, 0x0E47, 0x0E4C}, 0,	2, 2, {0x0E11, 0x0E47}},

//39.TEST C2.1 - Lower Vowel & tone makr/sign above short consonant
	{ 3, {0x0E01, 0x0E38, 0x0E48}, 0,	3, 3, {0x0E01, 0x0E38, 0xF70A}},
	{ 3, {0x0E02, 0x0E39, 0x0E49}, 0,	3, 3, {0x0E02, 0x0E39, 0xF70B}},
	{ 3, {0x0E04, 0x0E38, 0x0E4A}, 0,	3, 3, {0x0E04, 0x0E38, 0xF70C}},
	{ 3, {0x0E08, 0x0E39, 0x0E4B}, 0,	3, 3, {0x0E08, 0x0E39, 0xF70D}},
	{ 3, {0x0E09, 0x0E38, 0x0E4C}, 0,	3, 3, {0x0E09, 0x0E38, 0xF70E}},
	{ 3, {0x0E09, 0x0E39, 0x0E4C}, 0,	2, 2, {0x0E09, 0x0E39}},

//45.TEST C3 - Left aligned tone mark/sign above tall consonant
	{ 2, {0x0E1B, 0x0E48}, 0,			2, 2, {0x0E1B, 0xF705}},
	{ 2, {0x0E1D, 0x0E49}, 0,			2, 2, {0x0E1D, 0xF706}},
	{ 2, {0x0E1F, 0x0E4A}, 0,			2, 2, {0x0E1F, 0xF707}},
	{ 2, {0x0E2C, 0x0E4B}, 0,			2, 2, {0x0E2C, 0xF708}},
	{ 2, {0x0E1B, 0x0E4C}, 0,			2, 2, {0x0E1B, 0xF709}},

//50.TEST C4 - Left aligned vowel & tone mark/sign above tall consonant
	{ 3, {0x0E1B, 0x0E34, 0x0E48}, 0,	3, 3, {0x0E1B, 0xF701, 0xF713}},
	{ 3, {0x0E1D, 0x0E35, 0x0E49}, 0,	3, 3, {0x0E1D, 0xF702, 0xF714}},
	{ 3, {0x0E1F, 0x0E36, 0x0E4A}, 0,	3, 3, {0x0E1F, 0xF703, 0xF715}},
	{ 3, {0x0E2C, 0x0E37, 0x0E4B}, 0,	3, 3, {0x0E2C, 0xF704, 0xF716}},
	{ 3, {0x0E1B, 0x0E34, 0x0E4C}, 0,	3, 3, {0x0E1B, 0xF701, 0xF717}},

//55. INC043221 - Tone marks are not readable with tall consonants and Sara Am
// Test that the nikhahit part of a sara am causes the same effects as top
// vowels.
// Test 4 already does one suitable test.
	{ 3, {0x0E1B, 0x0E49, 0x0E33}, 0,	3, 4, {0x0E1B, 0xF711, 0xF714, 0x0E32}},

//56. INC127996 - Tone mark/diacritic displayed incorrectly when combinded 
//	with long tail consonanat and below vowel. Test that in context 
//	'short consonanat + below vowel + Tone Mark/diacritic', mark/diacritic
//	can be replaced by corresonding PUA code.
	{ 3, {0x0E0D, 0x0E39, 0x0E49}, 0, 	3, 3, {0xF70F, 0x0E39, 0xF70B}},
	{ 3, {0x0E0E, 0x0E38, 0x0E48}, 0,	3, 3, {0x0E0E, 0xF718, 0xF70A}},
	{ 3, {0x0E0F, 0x0E39, 0x0E4A}, 0,	3, 3, {0x0E0F, 0xF719, 0xF70C}},
	{ 3, {0x0E26, 0x0E39, 0x0E4B}, 0,	3, 3, {0x0E26, 0xF719, 0xF70D}},
	{ 3, {0x0E24, 0x0E38, 0x0E49}, 0,	3, 3, {0x0E24, 0xF718, 0xF70B}},
	{ 3, {0x0E10, 0x0E38, 0x0E4C}, 0,	3, 3, {0xF700, 0x0E38, 0xF70E}},

//62.TABLE END
	{ -1, {0}, -1,						-1, 0, {0}}
	};

/**
 Data structure used to hold the in and out data of two invokes
 of the CFont::GetCharacterPosition() API.
*/
struct TTestInput_Invoke
	{
	TInt                iPosInText;
	TInt				oPosInText;
	TInt				oOutputLen;
	TText16				oOutput[CFont::TPositionParam::EMaxOutputGlyphs];
	};

/**
 Data structure used to hold the in and out data of two invokes
 of the CFont::GetCharacterPosition() API.
*/
struct TTestInput_PositionParam2
	{
	TInt				iTextLen;
	TText16				iText[4];
	TTestInput_Invoke   oOut[2];
	};

/**
 Data structure used to hold the in and out data of two invokes
 of the CFont::GetCharacterPosition() API.
*/
struct TTestInput_PositionParam6
	{
	TInt				iTextLen;
	TText16				iText[6];
	TTestInput_Invoke   oOut[6];
	};

//	{-1, 1, 1, {0} } } indicate end of sequence
//	The most significant bit of glyph index is trimmed off when stored
LOCAL_D const TTestInput_PositionParam6 Indic_GurmukhiDigit[] = {
		{ 1, {0x0a66}, { {0, 1, 1, {0x12fe} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0a67}, { {0, 1, 1, {0x12ff} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0a68}, { {0, 1, 1, {0x1300} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0a69}, { {0, 1, 1, {0x1301} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0a6a}, { {0, 1, 1, {0x1302} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0a6b}, { {0, 1, 1, {0x1303} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0a6c}, { {0, 1, 1, {0x1304} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0a6d}, { {0, 1, 1, {0x1305} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0a6e}, { {0, 1, 1, {0x1306} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0a6f}, { {0, 1, 1, {0x1307} }, {-1, 1, 1, {0} } } },
		//	Consonant + digit
		{ 2, {0x0a15, 0x0a66}, { {0, 1, 1, {0x12cd}}, {1, 2, 1, {0x12fe}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a17, 0x0a67}, { {0, 1, 1, {0x12cf}}, {1, 2, 1, {0x12ff}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a19, 0x0a68}, { {0, 1, 1, {0x12d1}}, {1, 2, 1, {0x1300}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a25, 0x0a69}, { {0, 1, 1, {0x12dd}}, {1, 2, 1, {0x1301}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a27, 0x0a6a}, { {0, 1, 1, {0x12df}}, {1, 2, 1, {0x1302}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a28, 0x0a6b}, { {0, 1, 1, {0x12e0}}, {1, 2, 1, {0x1303}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a29, 0x0a6c}, { {0, 1, 1, {0x0000}}, {1, 2, 1, {0x1304}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3a, 0x0a6d}, { {0, 1, 1, {0x0000}}, {1, 2, 1, {0x1305}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3b, 0x0a6e}, { {0, 1, 1, {0x0000}}, {1, 2, 1, {0x1306}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3c, 0x0a6f}, { {0, 1, 2, {0x058f, 0x12ee}}, {1, 2, 1, {0x1307}}, {-1, 1, 1, {0} } } },
		//	Modifier + digit
		{ 2, {0x0a3e, 0x0a66}, { {0, 1, 2, {0x058f, 0x12ef}}, {1, 2, 1, {0x12fe}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3e, 0x0a67}, { {0, 1, 2, {0x058f, 0x12ef}}, {1, 2, 1, {0x12ff}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3e, 0x0a68}, { {0, 1, 2, {0x058f, 0x12ef}}, {1, 2, 1, {0x1300}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3e, 0x0a69}, { {0, 1, 2, {0x058f, 0x12ef}}, {1, 2, 1, {0x1301}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3e, 0x0a6a}, { {0, 1, 2, {0x058f, 0x12ef}}, {1, 2, 1, {0x1302}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3e, 0x0a6b}, { {0, 1, 2, {0x058f, 0x12ef}}, {1, 2, 1, {0x1303}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3e, 0x0a6c}, { {0, 1, 2, {0x058f, 0x12ef}}, {1, 2, 1, {0x1304}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3e, 0x0a6d}, { {0, 1, 2, {0x058f, 0x12ef}}, {1, 2, 1, {0x1305}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3e, 0x0a6e}, { {0, 1, 2, {0x058f, 0x12ef}}, {1, 2, 1, {0x1306}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a3e, 0x0a6f}, { {0, 1, 2, {0x058f, 0x12ef}}, {1, 2, 1, {0x1307}}, {-1, 1, 1, {0} } } },
		//	Vowel + digit
		{ 2, {0x0a73, 0x0a66}, { {0, 1, 1, {0x130b}}, {1, 2, 1, {0x12fe}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a67}, { {0, 1, 1, {0x130b}}, {1, 2, 1, {0x12ff}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a68}, { {0, 1, 1, {0x130b}}, {1, 2, 1, {0x1300}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a69}, { {0, 1, 1, {0x130b}}, {1, 2, 1, {0x1301}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a6a}, { {0, 1, 1, {0x130b}}, {1, 2, 1, {0x1302}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a6b}, { {0, 1, 1, {0x130b}}, {1, 2, 1, {0x1303}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a6c}, { {0, 1, 1, {0x130b}}, {1, 2, 1, {0x1304}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a6d}, { {0, 1, 1, {0x130b}}, {1, 2, 1, {0x1305}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a6e}, { {0, 1, 1, {0x130b}}, {1, 2, 1, {0x1306}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a6f}, { {0, 1, 1, {0x130b}}, {1, 2, 1, {0x1307}}, {-1, 1, 1, {0} } } },
		//	Virama + digit
		{ 2, {0x0a4d, 0x0a66}, { {0, 1, 2, {0x058f, 0x12f8}}, {1, 2, 1, {0x12fe}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a4d, 0x0a67}, { {0, 1, 2, {0x058f, 0x12f8}}, {1, 2, 1, {0x12ff}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a4d, 0x0a68}, { {0, 1, 2, {0x058f, 0x12f8}}, {1, 2, 1, {0x1300}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a4d, 0x0a69}, { {0, 1, 2, {0x058f, 0x12f8}}, {1, 2, 1, {0x1301}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a4d, 0x0a6a}, { {0, 1, 2, {0x058f, 0x12f8}}, {1, 2, 1, {0x1302}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a4d, 0x0a6b}, { {0, 1, 2, {0x058f, 0x12f8}}, {1, 2, 1, {0x1303}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a4d, 0x0a6c}, { {0, 1, 2, {0x058f, 0x12f8}}, {1, 2, 1, {0x1304}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a4d, 0x0a6d}, { {0, 1, 2, {0x058f, 0x12f8}}, {1, 2, 1, {0x1305}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a4d, 0x0a6e}, { {0, 1, 2, {0x058f, 0x12f8}}, {1, 2, 1, {0x1306}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a4d, 0x0a6f}, { {0, 1, 2, {0x058f, 0x12f8}}, {1, 2, 1, {0x1307}}, {-1, 1, 1, {0} } } },
		//	Consonant + digit + Matra
		{ 3, {0x0a15, 0x0a66, 0x0a3e}, { {0, 1, 1, {0x12cd}}, {1, 2, 1, {0x12fe}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a16, 0x0a67, 0x0a3e}, { {0, 1, 1, {0x12ce}}, {1, 2, 1, {0x12ff}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a17, 0x0a68, 0x0a3e}, { {0, 1, 1, {0x12cf}}, {1, 2, 1, {0x1300}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a18, 0x0a69, 0x0a3e}, { {0, 1, 1, {0x12d0}}, {1, 2, 1, {0x1301}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a19, 0x0a6a, 0x0a3e}, { {0, 1, 1, {0x12d1}}, {1, 2, 1, {0x1302}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a25, 0x0a6b, 0x0a3e}, { {0, 1, 1, {0x12dd}}, {1, 2, 1, {0x1303}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a2a, 0x0a6c, 0x0a3e}, { {0, 1, 1, {0x12e1}}, {1, 2, 1, {0x1304}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a2d, 0x0a6d, 0x0a3e}, { {0, 1, 1, {0x12e4}}, {1, 2, 1, {0x1305}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a30, 0x0a6e, 0x0a3e}, { {0, 1, 1, {0x12e7}}, {1, 2, 1, {0x1306}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a33, 0x0a6f, 0x0a3e}, { {0, 1, 1, {0x12e9}}, {1, 2, 1, {0x1307}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ -1, {0}, -1,						-1, 0, {0}}
};


LOCAL_D const TTestInput_PositionParam6 Indic_MalayalamDigit[] = {
		{ 1, {0x0d66}, { {0, 1, 1, {0x123e} }, {-1, 1, 1, {0} } }  },
		{ 1, {0x0d67}, { {0, 1, 1, {0x123f} }, {-1, 1, 1, {0} }  } },
		{ 1, {0x0d68}, { {0, 1, 1, {0x1240} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0d69}, { {0, 1, 1, {0x1241} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0d6a}, { {0, 1, 1, {0x1242} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0d6b}, { {0, 1, 1, {0x1243} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0d6c}, { {0, 1, 1, {0x1244} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0d6d}, { {0, 1, 1, {0x1245} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0d6e}, { {0, 1, 1, {0x1246} }, {-1, 1, 1, {0} } } },
		{ 1, {0x0d6f}, { {0, 1, 1, {0x1247} }, {-1, 1, 1, {0} } } },
		//	Consonant + digit
		{ 2, {0x0d15, 0x0d66}, { {0, 1, 1, {0x120a}}, {1, 2, 1, {0x123e}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d15, 0x0d67}, { {0, 1, 1, {0x120a}}, {1, 2, 1, {0x123f}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d17, 0x0d68}, { {0, 1, 1, {0x120c}}, {1, 2, 1, {0x1240}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d19, 0x0d69}, { {0, 1, 1, {0x120e}}, {1, 2, 1, {0x1241}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d25, 0x0d6a}, { {0, 1, 1, {0x121a}}, {1, 2, 1, {0x1242}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d26, 0x0d6b}, { {0, 1, 1, {0x121b}}, {1, 2, 1, {0x1243}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d15, 0x0d6c}, { {0, 1, 1, {0x120a}}, {1, 2, 1, {0x1244}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d30, 0x0d6d}, { {0, 1, 1, {0x1224}}, {1, 2, 1, {0x1245}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d31, 0x0d6e}, { {0, 1, 1, {0x1225}}, {1, 2, 1, {0x1246}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d32, 0x0d6f}, { {0, 1, 1, {0x1226}}, {1, 2, 1, {0x1247}}, {-1, 1, 1, {0} }  } },
		//	Modifier + digit
		{ 2, {0x0d03, 0x0d66}, { {0, 1, 2, {0x058f, 0x11fb}}, {1, 2, 1, {0x123e}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d03, 0x0d67}, { {0, 1, 2, {0x058f, 0x11fb}}, {1, 2, 1, {0x123f}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d03, 0x0d68}, { {0, 1, 2, {0x058f, 0x11fb}}, {1, 2, 1, {0x1240}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d03, 0x0d69}, { {0, 1, 2, {0x058f, 0x11fb}}, {1, 2, 1, {0x1241}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d03, 0x0d6a}, { {0, 1, 2, {0x058f, 0x11fb}}, {1, 2, 1, {0x1242}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d02, 0x0d6b}, { {0, 1, 2, {0x058f, 0x11fa}}, {1, 2, 1, {0x1243}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d02, 0x0d6c}, { {0, 1, 2, {0x058f, 0x11fa}}, {1, 2, 1, {0x1244}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d02, 0x0d6d}, { {0, 1, 2, {0x058f, 0x11fa}}, {1, 2, 1, {0x1245}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d02, 0x0d6e}, { {0, 1, 2, {0x058f, 0x11fa}}, {1, 2, 1, {0x1246}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d02, 0x0d6f}, { {0, 1, 2, {0x058f, 0x11fa}}, {1, 2, 1, {0x1247}}, {-1, 1, 1, {0} }  } },
		//	Vowel + digit
		{ 2, {0x0d3e, 0x0d66}, { {0, 1, 2, {0x058f, 0x122e}}, {1, 2, 1, {0x123e}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d3f, 0x0d67}, { {0, 1, 2, {0x058f, 0x122f}}, {1, 2, 1, {0x123f}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d40, 0x0d68}, { {0, 1, 2, {0x058f, 0x1230}}, {1, 2, 1, {0x1240}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d41, 0x0d69}, { {0, 1, 2, {0x058f, 0x1231}}, {1, 2, 1, {0x1241}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d42, 0x0d6a}, { {0, 1, 2, {0x058f, 0x1232}}, {1, 2, 1, {0x1242}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d43, 0x0d6b}, { {0, 1, 2, {0x058f, 0x1233}}, {1, 2, 1, {0x1243}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d46, 0x0d6c}, { {0, 1, 2, {0x1234, 0x058f}}, {1, 2, 1, {0x1244}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d47, 0x0d6d}, { {0, 1, 2, {0x1235, 0x058f}}, {1, 2, 1, {0x1245}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d48, 0x0d6e}, { {0, 1, 2, {0x1236, 0x058f}}, {1, 2, 1, {0x1246}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d4c, 0x0d6f}, { {0, 1, 2, {0x058f, 0x123b}}, {1, 2, 1, {0x1247}}, {-1, 1, 1, {0} }  } },
		//	Virama + digit
		{ 2, {0x0d4d, 0x0d66}, { {0, 1, 2, {0x058f, 0x123a}}, {1, 2, 1, {0x123e}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d4d, 0x0d67}, { {0, 1, 2, {0x058f, 0x123a}}, {1, 2, 1, {0x123f}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d4d, 0x0d68}, { {0, 1, 2, {0x058f, 0x123a}}, {1, 2, 1, {0x1240}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d4d, 0x0d69}, { {0, 1, 2, {0x058f, 0x123a}}, {1, 2, 1, {0x1241}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d4d, 0x0d6a}, { {0, 1, 2, {0x058f, 0x123a}}, {1, 2, 1, {0x1242}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d4d, 0x0d6b}, { {0, 1, 2, {0x058f, 0x123a}}, {1, 2, 1, {0x1243}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d4d, 0x0d6c}, { {0, 1, 2, {0x058f, 0x123a}}, {1, 2, 1, {0x1244}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d4d, 0x0d6d}, { {0, 1, 2, {0x058f, 0x123a}}, {1, 2, 1, {0x1245}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d4d, 0x0d6e}, { {0, 1, 2, {0x058f, 0x123a}}, {1, 2, 1, {0x1246}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d4d, 0x0d6f}, { {0, 1, 2, {0x058f, 0x123a}}, {1, 2, 1, {0x1247}}, {-1, 1, 1, {0} }  } },
		//	Consonant + digit + Matra
		{ 3, {0x0d15, 0x0d66, 0x0d3e}, { {0, 1, 1, {0x120a}}, {1, 2, 1, {0x123e}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d20, 0x0d67, 0x0d3f}, { {0, 1, 1, {0x1215}}, {1, 2, 1, {0x123f}}, {2, 3, 2, {0x058f, 0x122f}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d22, 0x0d68, 0x0d40}, { {0, 1, 1, {0x1217}}, {1, 2, 1, {0x1240}}, {2, 3, 2, {0x058f, 0x1230}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d27, 0x0d69, 0x0d41}, { {0, 1, 1, {0x121c}}, {1, 2, 1, {0x1241}}, {2, 3, 2, {0x058f, 0x1231}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d28, 0x0d6a, 0x0d42}, { {0, 1, 1, {0x121d}}, {1, 2, 1, {0x1242}}, {2, 3, 2, {0x058f, 0x1232}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d2A, 0x0d6b, 0x0d43}, { {0, 1, 1, {0x121e}}, {1, 2, 1, {0x1243}}, {2, 3, 2, {0x058f, 0x1233}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d2D, 0x0d6c, 0x0d46}, { {0, 1, 1, {0x1221}}, {1, 2, 1, {0x1244}}, {2, 3, 2, {0x1234, 0x058f}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d32, 0x0d6d, 0x0d47}, { {0, 1, 1, {0x1226}}, {1, 2, 1, {0x1245}}, {2, 3, 2, {0x1235, 0x058f}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d34, 0x0d6e, 0x0d48}, { {0, 1, 1, {0x1228}}, {1, 2, 1, {0x1246}}, {2, 3, 2, {0x1236, 0x058f}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d39, 0x0d6f, 0x0d4a}, { {0, 1, 1, {0x122d}}, {1, 2, 1, {0x1247}}, {2, 3, 3, {0x1234, 0x058f, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ -1, {0}, -1,						-1, 0, {0}}
};

LOCAL_D const TTestInput_PositionParam6 Indic_GurmukhiAndLatin[] = {
		//	Gurmukhi sequence + Latin
		{ 3, {0x0a05, 0x0a70, 0x0077}, { {0, 2, 2, {0x12c3, 0x1308}}, {1, 2, 1, {0x1308}}, {2, 3, 1, {0x0077}}, {-1, 1, 1, {0} } } },
		//	Latin + Gurmukhi sequence
		{ 3, {0x0063, 0x0a19, 0x0a48}, { {0, 1, 1, {0x0063}}, {1, 3, 2, {0x12d1, 0x12f5}}, {2, 3, 1, {0x12f5}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0064, 0x0a3f, 0x0a71}, { {0, 1, 1, {0x0064}}, {1, 2, 2, {0x12f0, 0x058f}}, {2, 3, 2, {0x058f, 0x1309}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0066, 0x0a69, 0x0a3e}, { {0, 1, 1, {0x0066}}, {1, 2, 1, {0x1301}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0068, 0x0a6a, 0x0a3e}, { {0, 1, 1, {0x0068}}, {1, 2, 1, {0x1302}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x002e, 0x0a6b, 0x0a3e}, { {0, 1, 1, {0x0772}}, {1, 2, 1, {0x1303}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0074, 0x0a6c, 0x0a3e}, { {0, 1, 1, {0x0074}}, {1, 2, 1, {0x1304}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x002c, 0x0a6d, 0x0a3e}, { {0, 1, 1, {0x0770}}, {1, 2, 1, {0x1305}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0078, 0x0a6e, 0x0a3e}, { {0, 1, 1, {0x0078}}, {1, 2, 1, {0x1306}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x007a, 0x0a6f, 0x0a3e}, { {0, 1, 1, {0x007a}}, {1, 2, 1, {0x1307}}, {2, 3, 2, {0x058f, 0x12ef}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a6f, 0x0a3e, 0x0078}, { {0, 1, 1, {0x1307}}, {1, 2, 2, {0x058f, 0x12ef}}, {2, 3, 1, {0x0078}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a6f, 0x0a3e, 0x002e}, { {0, 1, 1, {0x1307}}, {1, 2, 2, {0x058f, 0x12ef}}, {2, 3, 1, {0x0772}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a6f, 0x0a3e, 0x0066}, { {0, 1, 1, {0x1307}}, {1, 2, 2, {0x058f, 0x12ef}}, {2, 3, 1, {0x0066}}, {-1, 1, 1, {0} } } },
		{ -1, {0}, -1,						-1, 0, {0}}
};


LOCAL_D const TTestInput_PositionParam6 Indic_MalayalamAndLatin[] = {
		//	Malayalam sequence + Latin
		//{ 3, {0x0d05, 0x0d70, 0x0077}, { {0, 1, 1, {0x11fc}}, {1, 2, 1, {0x0000}}, {2, 3, 1, {0x0077}}, {-1, 1, 1, {0} }  } },
		//	Latin + Malayalam sequence
		{ 3, {0x0063, 0x0d19, 0x0d48}, { {0, 1, 1, {0x0063}}, {1, 3, 2, {0x1236, 0x120e}}, {2, 3, 1, {0x1236}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0066, 0x0d69, 0x0d3e}, { {0, 1, 1, {0x0066}}, {1, 2, 1, {0x1241}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0068, 0x0d6a, 0x0d3e}, { {0, 1, 1, {0x0068}}, {1, 2, 1, {0x1242}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x002e, 0x0d6b, 0x0d3e}, { {0, 1, 1, {0x0c87}}, {1, 2, 1, {0x1243}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0074, 0x0d6c, 0x0d3e}, { {0, 1, 1, {0x0074}}, {1, 2, 1, {0x1244}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x002c, 0x0d6d, 0x0d3e}, { {0, 1, 1, {0x0c85}}, {1, 2, 1, {0x1245}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0078, 0x0d6e, 0x0d3e}, { {0, 1, 1, {0x0078}}, {1, 2, 1, {0x1246}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x007a, 0x0d6f, 0x0d3e}, { {0, 1, 1, {0x007a}}, {1, 2, 1, {0x1247}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ -1, {0}, -1,						-1, 0, {0}}
};


LOCAL_D const TTestInput_PositionParam6 Indic_GurmukhiModifierAfterConsonantViramaZWJ[] = {
		//	Consonant + Virama + ZWJ + Modifier
		{ 4, {0x0a15, 0x0a4d, 0x200d, 0x0A01}, { {0, 4, 2, {0x1335, 0x12c0}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x12c0}}, {3, 4, 1, {0x12c0}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0a16, 0x0a4d, 0x200d, 0x0A02}, { {0, 4, 2, {0x1336, 0x12c1}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x12c1}}, {3, 4, 1, {0x12c1}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0a17, 0x0a4d, 0x200d, 0x0A03}, { {0, 4, 2, {0x1337, 0x12c2}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x12c2}}, {3, 4, 1, {0x12c2}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0a18, 0x0a4d, 0x200d, 0x0A70}, { {0, 4, 2, {0x1338, 0x1308}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x1308}}, {3, 4, 1, {0x1308}}, {-1, 1, 1, {0} } } },
		{ -1, {0}, -1,						-1, 0, {0}}
};


LOCAL_D const TTestInput_PositionParam6 Indic_MalayalamModifierAfterConsonantViramaZWJ[] = {
		//	Consonant + Virama + ZWJ + Modifier
		{ 4, {0x0d15, 0x0d4d, 0x200d, 0x0d02}, { {0, 4, 2, {0x1248, 0x11fa}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x11fa}}, {3, 4, 1, {0x11fa}}, {-1, 1, 1, {0} }  } },
		{ 4, {0x0d25, 0x0d4d, 0x200d, 0x0d02}, { {0, 4, 2, {0x1258, 0x11fa}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x11fa}}, {3, 4, 1, {0x11fa}}, {-1, 1, 1, {0} }  } },
		{ 4, {0x0d33, 0x0d4d, 0x200d, 0x0d03}, { {0, 3, 1, {0x1275}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x11fb}}, {3, 4, 1, {0x11fb}}, {-1, 1, 1, {0} }  } },
		{ 4, {0x0d34, 0x0d4d, 0x200d, 0x0d03}, { {0, 4, 2, {0x1266, 0x11fb}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x11fb}}, {3, 4, 1, {0x11fb}}, {-1, 1, 1, {0} }  } },
		{ -1, {0}, -1,						-1, 0, {0}}
};

LOCAL_D const TTestInput_PositionParam6 Indic_GurmukhiConsonantLeading[] = {
		//	Consonant + Nukta
		{ 2, {0x0a17, 0x0A3C}, { {0, 2, 1, {0x12fa}}, {-1, 1, 1, {0} } } },
		//	Consonant + dependent vowel, two sequences to check context shaping
		{ 2, {0x0a15, 0x0A4C}, { {0, 2, 2, {0x12cd, 0x12f7}}, {1, 2, 1, {0x12f7}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A4C}, { {0, 2, 2, {0x12ce, 0x12f7}}, {1, 2, 1, {0x12f7}}, {-1, 1, 1, {0} } } },
		//	Consonant + Matra /i/, and other Matras
		{ 2, {0x0a16, 0x0A3f}, { {0, 2, 2, {0x12f0, 0x12ce}}, {1, 2, 1, {0x12f0}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A3e}, { {0, 2, 2, {0x12ce, 0x12ef}}, {1, 2, 1, {0x12ef}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A40}, { {0, 2, 2, {0x12ce, 0x12f1}}, {1, 2, 1, {0x12f1}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A41}, { {0, 2, 2, {0x12ce, 0x12f2}}, {1, 2, 1, {0x12f2}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A42}, { {0, 2, 2, {0x12ce, 0x12f3}}, {1, 2, 1, {0x12f3}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A43}, { {0, 1, 1, {0x12ce}}, {1, 2, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A44}, { {0, 1, 1, {0x12ce}}, {1, 2, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A45}, { {0, 1, 1, {0x12ce}}, {1, 2, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A46}, { {0, 1, 1, {0x12ce}}, {1, 2, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A47}, { {0, 2, 2, {0x12ce, 0x12f4}}, {1, 2, 1, {0x12f4}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A48}, { {0, 2, 2, {0x12ce, 0x12f5}}, {1, 2, 1, {0x12f5}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A49}, { {0, 1, 1, {0x12ce}}, {1, 2, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A4a}, { {0, 1, 1, {0x12ce}}, {1, 2, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A4b}, { {0, 2, 2, {0x12ce, 0x12f6}}, {1, 2, 1, {0x12f6}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a16, 0x0A4c}, { {0, 2, 2, {0x12ce, 0x12f7}}, {1, 2, 1, {0x12f7}}, {-1, 1, 1, {0} } } },
		//0d24 + 0d4d + 0d30
		//0d28 + 0d4d + //0d24 + 0d4d + 0d30
		//0d38 + 0d4d + //0d15 + 0d4d + 0d30
		//	Consonant + Virama + HA(RA/VA/YA)
		{ 3, {0x0a15, 0x0a4d, 0x0a39}, { {0, 3, 2, {0x12cd, 0x1331}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x1331}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a15, 0x0a4d, 0x0a30}, { {0, 3, 1, {0x13e7}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a15, 0x0a4d, 0x0a35}, { {0, 3, 2, {0x1399, 0x1333}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x1333}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a15, 0x0a4d, 0x0a2f}, { {0, 3, 2, {0x12cd, 0x1373}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x1373}}, {-1, 1, 1, {0} } } },
		//	Consonant + Addak
		{ 2, {0x0a16, 0x0A71}, { {0, 2, 2, {0x12ce, 0x1309}}, {1, 2, 1, {0x1309}}, {-1, 1, 1, {0} } } },
		//	Consonant + bindi
		{ 2, {0x0a16, 0x0A02}, { {0, 2, 2, {0x12ce, 0x12c1}}, {1, 2, 1, {0x12c1}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a16, 0x0a40, 0x0A02}, { {0, 3, 2, {0x12ce, 0x13f0}}, {1, 2, 1, {0x13f0}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a16, 0x0a4b, 0x0A02}, { {0, 3, 2, {0x12ce, 0x13f3}}, {1, 2, 1, {0x13f3}}, {-1, 1, 1, {0} } } },
		//	Consonant + Tippi
		{ 2, {0x0a25, 0x0A70}, { {0, 2, 2, {0x12dd, 0x1308}}, {1, 2, 1, {0x1308}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a25, 0x0a3f, 0x0A70}, { {0, 3, 3, {0x12f0, 0x12dd, 0x1308}}, {1, 2, 1, {0x12f0}}, {2, 3, 1, {0x1308}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0a25, 0x0a41, 0x0A70}, { {0, 3, 3, {0x12dd, 0x12f2, 0x1308}}, {1, 2, 1, {0x12f2}}, {2, 3, 1, {0x1308}}, {-1, 1, 1, {0} } } },
		//	Nukta, corresponding consonant, Nukta pair
		{ 1, {0x0a33}, { {0, 1, 1, {0x12e9}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a32, 0x0A3c}, { {0, 2, 1, {0x12e9}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a36}, { {0, 1, 1, {0x12eb}},{-1, 1, 1, {0} } } },
		{ 2, {0x0a38, 0x0A3c}, { {0, 2, 1, {0x12eb}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a59}, { {0, 1, 1, {0x12f9}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0aa1, 0x0A3c}, { {0, 1, 1, {0x096e}}, {1, 2, 2, {0x058f, 0x12ee}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a5a}, { {0, 1, 1, {0x12fa}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a17, 0x0A3c}, { {0, 2, 1, {0x12fa}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a5b}, { {0, 1, 1, {0x12fb}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a1c, 0x0A3c}, { {0, 2, 1, {0x12fb}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a5e}, { {0, 1, 1, {0x12fd}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a2b, 0x0A3c}, { {0, 2, 1, {0x12fd}}, {-1, 1, 1, {0} } } },
		{ -1, {0}, -1,						-1, 0, {0}}
};



LOCAL_D const TTestInput_PositionParam6 Indic_MalayalamConsonantLeading[] = {
		//	Consonant, and its split representation
		{ 2, {0x0d15, 0x0d14}, { {0, 1, 1, {0x120a}}, {1, 2, 1, {0x1209}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d15, 0x0d12, 0x0d57}, { {0, 1, 1, {0x120a}}, {1, 3, 3, {0x1207, 0x058f, 0x123b}}, {2, 3, 2, {0x058f, 0x123b}}, {-1, 1, 1, {0} }  } },
		
		{ 2, {0x0d15, 0x0d4a}, { {0, 2, 3, {0x1234, 0x120a, 0x122e}}, {1, 2, 2, {0x1234, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d15, 0x0d46, 0x0d3e}, { {0, 3, 3, {0x1234, 0x120a, 0x122e}}, {1, 2, 1, {0x1234}}, {2, 3, 1, {0x122e}}, {-1, 1, 1, {0} }  } },

		{ 2, {0x0d17, 0x0d4b}, { {0, 2, 3, {0x1235, 0x120c, 0x122e}}, {1, 2, 2, {0x1235, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d17, 0x0d47, 0x0d3e}, { {0, 3, 3, {0x1235, 0x120c, 0x122e}}, {1, 2, 1, {0x1235}}, {2, 3, 1, {0x122e}}, {-1, 1, 1, {0} }  } },

		{ 2, {0x0d19, 0x0d4c}, { {0, 2, 2, {0x120e, 0x123b}}, {1, 2, 1, {0x123b}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d19, 0x0d46, 0x0d57}, { {0, 3, 2, {0x120e, 0x123b}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x123b}}, {-1, 1, 1, {0} }  } },

		//	Consonant + dependent vowel, two sequences to check context shaping
		{ 2, {0x0d15, 0x0d0a}, { {0, 1, 1, {0x120a}}, {1, 2, 1, {0x1201}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d16, 0x0d0a}, { {0, 1, 1, {0x120b}}, {1, 2, 1, {0x1201}}, {-1, 1, 1, {0} }  } },
		
		//	Consonant + Matra /-e/, /-ee/, /-ai/ 
		{ 2, {0x0d16, 0x0d46}, { {0, 2, 2, {0x1234, 0x120b}}, {1, 2, 1, {0x1234}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d17, 0x0d47}, { {0, 2, 2, {0x1235, 0x120c}}, {1, 2, 1, {0x1235}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d18, 0x0d48}, { {0, 2, 2, {0x1236, 0x120d}}, {1, 2, 1, {0x1236}}, {-1, 1, 1, {0} }  } },
		
		//	Consonant and Matras /-o/, /-oo/, /-au/ to shaper
		//	Consonant and 0x0d4c (first form of Matra /-au/ ) to shaper,
		//	Consonant, 0x0d46 and 0x0d57 (second form of Matra /-au/) to shaper002E
		{ 2, {0x0d16, 0x0d4A}, { {0, 2, 3, {0x1234, 0x120b, 0x122e}}, {1, 2, 2, {0x1234, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d17, 0x0d4B}, { {0, 2, 3, {0x1235, 0x120c, 0x122e}}, {1, 2, 2, {0x1235, 0x122e}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d18, 0x0d4C}, { {0, 2, 2, {0x120d, 0x123b}}, {1, 2, 1, {0x123b}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d15, 0x0d46, 0x0d57}, { {0, 3, 2, {0x120a, 0x123b}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x123b}}, {-1, 1, 1, {0} }  } },
		
		//	Consonant + 0x0d4d + Consonant
		{ 3, {0x0d15, 0x0d4d, 0x0d15}, { {0, 3, 1, {0x1277}}, {-1, 1, 1, {0} }  } },
		{ 4, {0x0d31, 0x0d4d, 0x0d31, 0x0d4d}, { {0, 4, 2, {0x12a7, 0x123a}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x123a}}, {3, 4, 1, {0x123a}}, {-1, 1, 1, {0} }  } },
		
		//	Consonant (NNA, NA, RA, LA, LLA) + Virama + ZWJ to shaper
		//	KA + Virama + ZWJ to shaper.
		// 	other Consonant + Virama + ZWJ to shaper.
		{ 3, {0x0d23, 0x0d4d, 0x200d}, { {0, 3, 1, {0x1272}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d28, 0x0d4d, 0x200d}, { {0, 3, 1, {0x1273}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d32, 0x0d4d, 0x200d}, { {0, 3, 1, {0x1276}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d33, 0x0d4d, 0x200d}, { {0, 3, 1, {0x1275}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d15, 0x0d4d, 0x200d}, { {0, 3, 1, {0x1248}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d16, 0x0d4d, 0x200d}, { {0, 3, 1, {0x1249}}, {-1, 1, 1, {0} }  } },
		
		//	RA + Virama + ZWJ to shaper,
		//	RRA + Viram + ZWJ to shaper.
		{ 3, {0x0d30, 0x0d4d, 0x200d}, { {0, 3, 1, {0x1274}}, {-1, 1, 1, {0} }  } },
		{ 3, {0x0d31, 0x0d4d, 0x200d}, { {0, 3, 1, {0x1263}}, {-1, 1, 1, {0} }  } },
		
		//	Chillu and Modifier to shaper
		//	Chillu and Virama to shaper
		{ 4, {0x0d31, 0x0d4d, 0x200d, 0x0d05}, { {0, 3, 1, {0x1263}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x11fc}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d15, 0x0d4d, 0x200d, 0x0d14}, { {0, 3, 1, {0x1248}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x1209}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d31, 0x0d4d, 0x200d, 0x0d4d}, { {0, 3, 1, {0x1263}}, {1, 2, 0, {0x0000}}, {2, 4, 2, {0x058f, 0x123a}}, {3, 4, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d15, 0x0d4d, 0x200d, 0x0d4d}, { {0, 3, 1, {0x1248}}, {1, 2, 0, {0x0000}}, {2, 4, 2, {0x058f, 0x123a}}, {3, 4, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },

		//	AAR
		{ 3, {0x0d06, 0x0d4d, 0x200d}, { {0, 1, 1, {0x11fd}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} }  } },
		{ 2, {0x0d06, 0x0d4d}, { {0, 1, 1, {0x11fd}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} }  } },

		//	K.KA, K.TA, K.SSA, G.NA, G.MA, 
		//	NG.KA, NG.NGA, J.JA, J.NYA, NY.NYA, TT.TTA, NN.MA, T.BHA, T.MA, 
		//	T.SA, D.DA, D.DHA, 
		//	N.TA, N.DA, N.DHA, N.NA, 
		//	M.PA, M.MA, 
		//	SH.CA, S.THA, 
		//	H.NA, H.MA and LL.LLA
		{ 3, {0x0d15, 0x0d4d, 0x0d15}, { {0, 3, 1, {0x1277}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d15, 0x0d4d, 0x0d24}, { {0, 3, 1, {0x1278}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d15, 0x0d4d, 0x0d37}, { {0, 3, 1, {0x127b}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d17, 0x0d4d, 0x0d28}, { {0, 3, 1, {0x127e}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d17, 0x0d4d, 0x0d2e}, { {0, 3, 1, {0x127d}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d19, 0x0d4d, 0x0d15}, { {0, 3, 1, {0x1280}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d19, 0x0d4d, 0x0d19}, { {0, 3, 1, {0x1281}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d1c, 0x0d4d, 0x0d1c}, { {0, 3, 1, {0x1284}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d1c, 0x0d4d, 0x0d1e}, { {0, 3, 1, {0x1285}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d1f, 0x0d4d, 0x0d1f}, { {0, 3, 1, {0x1288}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d23, 0x0d4d, 0x0d2e}, { {0, 3, 1, {0x128b}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d24, 0x0d4d, 0x0d2d}, { {0, 3, 1, {0x128e}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d24, 0x0d4d, 0x0d2e}, { {0, 3, 1, {0x128f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d24, 0x0d4d, 0x0d38}, { {0, 3, 1, {0x1290}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d26, 0x0d4d, 0x0d26}, { {0, 3, 1, {0x1293}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d26, 0x0d4d, 0x0d27}, { {0, 3, 1, {0x1294}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d28, 0x0d4d, 0x0d24}, { {0, 3, 1, {0x129a}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d28, 0x0d4d, 0x0d26}, { {0, 3, 1, {0x1295}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d28, 0x0d4d, 0x0d27}, { {0, 3, 1, {0x1296}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d28, 0x0d4d, 0x0d28}, { {0, 3, 1, {0x1297}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d2e, 0x0d4d, 0x0d2a}, { {0, 3, 1, {0x12a4}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d2e, 0x0d4d, 0x0d2e}, { {0, 3, 1, {0x12a3}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d36, 0x0d4d, 0x0d1a}, { {0, 3, 1, {0x12ab}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d38, 0x0d4d, 0x0d25}, { {0, 3, 1, {0x12b1}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d39, 0x0d4d, 0x0d28}, { {0, 3, 1, {0x12b4}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d39, 0x0d4d, 0x0d2e}, { {0, 3, 1, {0x12b3}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d33, 0x0d4d, 0x0d23}, { {0, 3, 2, {0x1265, 0x1218}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x1218}}, {-1, 1, 1, {0} } } },
		
		//	One of (KA, GA, PA, BA, MA, LA, SHA, SA, HA), Virama and LA to shaper
		{ 3, {0x0d15, 0x0d4d, 0x0d32}, { {0, 3, 1, {0x127a}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d17, 0x0d4d, 0x0d32}, { {0, 3, 1, {0x127f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d2a, 0x0d4d, 0x0d32}, { {0, 3, 1, {0x129d}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d2c, 0x0d4d, 0x0d32}, { {0, 3, 1, {0x12a2}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d2e, 0x0d4d, 0x0d32}, { {0, 3, 1, {0x12a5}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d32, 0x0d4d, 0x0d32}, { {0, 3, 1, {0x12a8}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d36, 0x0d4d, 0x0d32}, { {0, 3, 1, {0x12ad}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d38, 0x0d4d, 0x0d32}, { {0, 3, 1, {0x12b2}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d39, 0x0d4d, 0x0d32}, { {0, 3, 1, {0x12b5}}, {-1, 1, 1, {0} } } },
		
		//	CA, Virama and CA to shaper
		//	BA, Virama and BA to shaper
		//	YA, Virama and YA to shaper
		//	VA, Virama and VA to shaper
		//	other Consonant, Virama and the same Consonant to shaper.
		{ 3, {0x0d1a, 0x0d4d, 0x0d1a}, { {0, 3, 1, {0x1282}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d2c, 0x0d4d, 0x0d2c}, { {0, 3, 1, {0x129f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d2f, 0x0d4d, 0x0d2f}, { {0, 3, 1, {0x12a6}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d35, 0x0d4d, 0x0d35}, { {0, 3, 1, {0x12aa}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d15, 0x0d4d, 0x0d15}, { {0, 3, 1, {0x1277}}, {-1, 1, 1, {0} } } },

		//	G.GA, C.CHA, K.TTA, SS.TTA, DD.DDA, NN.NNA, B.DA, B.DHA, P.PA, RR.RRA, SH.SHA, S.SA clusters to shaper
		{ 3, {0x0d17, 0x0d4d, 0x0d17}, { {0, 3, 1, {0x127c}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d2c, 0x0d4d, 0x0d26}, { {0, 3, 1, {0x12a0}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d1a, 0x0d4d, 0x0d1b}, { {0, 3, 1, {0x1283}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d2c, 0x0d4d, 0x0d27}, { {0, 3, 1, {0x12a1}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d15, 0x0d4d, 0x0d1f}, { {0, 3, 1, {0x1279}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d2a, 0x0d4d, 0x0d2a}, { {0, 3, 1, {0x129c}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d37, 0x0d4d, 0x0d1f}, { {0, 3, 1, {0x12ae}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d31, 0x0d4d, 0x0d31}, { {0, 3, 1, {0x12a7}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d21, 0x0d4d, 0x0d21}, { {0, 3, 1, {0x1289}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d36, 0x0d4d, 0x0d36}, { {0, 3, 1, {0x12ac}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d23, 0x0d4d, 0x0d23}, { {0, 3, 1, {0x128c}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d38, 0x0d4d, 0x0d38}, { {0, 3, 1, {0x12b0}}, {-1, 1, 1, {0} } } },
		
		
		//	Consonant clusters from REQ1.3.11 to shaper.
		//	Already covered in other sequence
		//	S.RR.RRA to shaper,
		//	N.RR.RRA to shaper
		{ 5, {0x0d38, 0x0d4d, 0x0d31, 0x0d4d, 0x0d31}, { {0, 5, 1, {0x12af}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d28, 0x0d4d, 0x0d31, 0x0d31}, { {0, 3, 2, {0x125b, 0x1225}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x1225}}, {3, 4, 1, {0x1225}}, {-1, 1, 1, {0} } } },
		
		//	N.RRA
		{ 4, {0x0d28, 0x0d4d, 0x200d, 0x0d31}, { {0, 4, 1, {0x1299}}, {-1, 1, 1, {0} } } },
		
		//	NA, Virama, ZWJ, RRA to shaper
		//	NA, Virama, ZWJ, ZWNJ, RRA to shaper
		{ 4, {0x0d28, 0x0d4d, 0x200d, 0x0d31}, { {0, 4, 1, {0x1299}}, {-1, 1, 1, {0} } } },
		{ 5, {0x0d28, 0x0d4d, 0x200d, 0x200c, 0x0d31}, { {0, 3, 1, {0x1273}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 0, {0x0000}}, {4, 5, 1, {0x1225}}, {-1, 1, 1, {0} } } },
		
		//	Consonant cluster and YA to shaper
		//	Consonant cluster and VA to shaper
		{ 4, {0x0d15, 0x0d4d, 0x0d30, 0x0d3f}, { {0, 4, 3, {0x1271, 0x120a, 0x122f}}, {1, 2, 0, {0x0000}}, {2, 4, 2, {0x1271, 0x122f}}, {3, 4, 1, {0x122f}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d15, 0x0d4d, 0x0d30, 0x0d35}, { {0, 3, 2, {0x1271, 0x120a}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x1271}}, {3, 4, 1, {0x1229}}, {-1, 1, 1, {0} } } },
		
		//	YA, YAKAR to shaper
		//	VA, VAKAR to shaper
		{ 3, {0x0d15, 0x0d4d, 0x0d2f}, { {0, 3, 2, {0x120a, 0x126f}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x126f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d15, 0x0d4d, 0x0d35}, { {0, 3, 2, {0x120a, 0x1270}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x1270}}, {-1, 1, 1, {0} } } },
		{ 5, {0x0d15, 0x0d4d, 0x0d30, 0x0d4d, 0x0d2f}, { {0, 5, 3, {0x1271, 0x120a, 0x126f}}, {1, 2, 0, {0x0000}}, {2, 5, 2, {0x1271, 0x126f}}, {3, 4, 0, {0x0000}}, {4, 5, 1, {0x126f}}, {-1, 1, 1, {0} } } },
		{ 5, {0x0d15, 0x0d4d, 0x0d30, 0x0d4d, 0x0d35}, { {0, 5, 3, {0x1271, 0x120a, 0x1270}}, {1, 2, 0, {0x0000}}, {2, 5, 2, {0x1271, 0x1270}}, {3, 4, 0, {0x0000}}, {4, 5, 1, {0x1270}}, {-1, 1, 1, {0} } } },
		{ 5, {0x0d15, 0x0d4d, 0x0d2f, 0x0d4d, 0x0d30}, { {0, 5, 3, {0x1248, 0x1271, 0x1223}}, {1, 2, 0, {0x0000}}, {2, 5, 2, {0x1271, 0x1223}}, {3, 4, 0, {0x0000}}, {4, 5, 1, {0x1271}}, {-1, 1, 1, {0} } } },
		{ 5, {0x0d15, 0x0d4d, 0x0d35, 0x0d4d, 0x0d30}, { {0, 5, 3, {0x1248, 0x1271, 0x1229}}, {1, 2, 0, {0x0000}}, {2, 5, 2, {0x1271, 0x1229}}, {3, 4, 0, {0x0000}}, {4, 5, 1, {0x1271}}, {-1, 1, 1, {0} } } },

		//	one of (LLA, LLLA, RRA) and YA to shaper
		//	one of (LLA, LLLA, RRA) and VA to shaper
		{ 2, {0x0d33, 0x0d2f}, { {0, 1, 1, {0x1227}}, {1, 2, 1, {0x1223}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d34, 0x0d2f}, { {0, 1, 1, {0x1228}}, {1, 2, 1, {0x1223}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d31, 0x0d2f}, { {0, 1, 1, {0x1225}}, {1, 2, 1, {0x1223}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d33, 0x0d35}, { {0, 1, 1, {0x1227}}, {1, 2, 1, {0x1229}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d34, 0x0d35}, { {0, 1, 1, {0x1228}}, {1, 2, 1, {0x1229}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d31, 0x0d35}, { {0, 1, 1, {0x1225}}, {1, 2, 1, {0x1229}}, {-1, 1, 1, {0} } } },
		//	KSSA
		//0d15, 0d4d, 0d37
		//	Consonant cluster and RA to shaper
		{ 4, {0x0d15, 0x0d4d, 0x0d30, 0x0d30}, { {0, 3, 2, {0x1271, 0x120a}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x1271}}, {3, 4, 1, {0x1224}}, {-1, 1, 1, {0} } } },

		//	one of (LLA, LLLA, RRA) and RA to shaper
		{ 2, {0x0d33, 0x0d30}, { {0, 1, 1, {0x1227}}, {1, 2, 1, {0x1224}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d34, 0x0d30}, { {0, 1, 1, {0x1228}}, {1, 2, 1, {0x1224}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d31, 0x0d30}, { {0, 1, 1, {0x1225}}, {1, 2, 1, {0x1224}}, {-1, 1, 1, {0} } } },
		
		//	YAKAR/VAKAR and RA to shaper.
		{ 4, {0x0d15, 0x0d4d, 0x0d2f, 0x0d30}, { {0, 3, 2, {0x120a, 0x126f}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x126f}}, {3, 4, 1, {0x1224}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d15, 0x0d4d, 0x0d35, 0x0d30}, { {0, 3, 2, {0x120a, 0x1270}}, {1, 2, 0, {0x0000}}, {2, 3, 1, {0x1270}}, {3, 4, 1, {0x1224}}, {-1, 1, 1, {0} } } },

		//	Chillu
		//	Chillu and Vowel to shaper
		//	Chillu and Consonant to shaper
		//	Chillu and Modifier to shaper
		//	Chillu and Virama to shaper
		{ 4, {0x0d06, 0x0d23, 0x0d4d, 0x200d}, { {0, 1, 1, {0x11fd}}, {1, 4, 1, {0x1272}}, {2, 3, 0, {0x058f, 0x123a}}, {3, 4, 0, {0x0d30}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d06, 0x0d28, 0x0d4d, 0x200d}, { {0, 1, 1, {0x11fd}}, {1, 4, 1, {0x1273}}, {2, 3, 0, {0x058f, 0x123a}}, {3, 4, 0, {0x0d30}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d06, 0x0d30, 0x0d4d, 0x200d}, { {0, 1, 1, {0x11fd}}, {1, 4, 1, {0x1274}}, {2, 3, 0, {0x058f, 0x123a}}, {3, 4, 0, {0x0d30}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d06, 0x0d32, 0x0d4d, 0x200d}, { {0, 1, 1, {0x11fd}}, {1, 4, 1, {0x1276}}, {2, 3, 0, {0x058f, 0x123a}}, {3, 4, 0, {0x0d30}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d06, 0x0d33, 0x0d4d, 0x200d}, { {0, 1, 1, {0x11fd}}, {1, 4, 1, {0x1275}}, {2, 3, 0, {0x058f, 0x123a}}, {3, 4, 0, {0x0d30}}, {-1, 1, 1, {0} } } },

		{ 4, {0x0d23, 0x0d4d, 0x200d, 0x0d06}, { {0, 3, 1, {0x1272}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x11fd}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d28, 0x0d4d, 0x200d, 0x0d09}, { {0, 3, 1, {0x1273}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x1200}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d30, 0x0d4d, 0x200d, 0x0d0a}, { {0, 3, 1, {0x1274}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x1201}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d32, 0x0d4d, 0x200d, 0x0d0f}, { {0, 3, 1, {0x1276}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x1205}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d33, 0x0d4d, 0x200d, 0x0d13}, { {0, 3, 1, {0x1275}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x1208}}, {-1, 1, 1, {0} } } },

		{ 4, {0x0d23, 0x0d4d, 0x200d, 0x0d16}, { {0, 3, 1, {0x1272}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x120b}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d28, 0x0d4d, 0x200d, 0x0d19}, { {0, 3, 1, {0x1273}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x120e}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d30, 0x0d4d, 0x200d, 0x0d1a}, { {0, 3, 1, {0x1274}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x120f}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d32, 0x0d4d, 0x200d, 0x0d1f}, { {0, 3, 1, {0x1276}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x1214}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d33, 0x0d4d, 0x200d, 0x0d31}, { {0, 3, 1, {0x1275}}, {1, 2, 0, {0x0000}}, {2, 3, 0, {0x0000}}, {3, 4, 1, {0x1225}}, {-1, 1, 1, {0} } } },

		{ 4, {0x0d23, 0x0d4d, 0x200d, 0x0d02}, { {0, 3, 1, {0x1272}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x11fa}}, {3, 4, 1, {0x11fa}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d28, 0x0d4d, 0x200d, 0x0d02}, { {0, 3, 1, {0x1273}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x11fa}}, {3, 4, 1, {0x11fa}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d30, 0x0d4d, 0x200d, 0x0d03}, { {0, 3, 1, {0x1274}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x11fb}}, {3, 4, 1, {0x11fb}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d32, 0x0d4d, 0x200d, 0x0d03}, { {0, 3, 1, {0x1276}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x11fb}}, {3, 4, 1, {0x11fb}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d33, 0x0d4d, 0x200d, 0x0d03}, { {0, 3, 1, {0x1275}}, {1, 2, 0, {0x0000}}, {2, 4, 1, {0x11fb}}, {3, 4, 1, {0x11fb}}, {-1, 1, 1, {0} } } },

		{ 4, {0x0d23, 0x0d4d, 0x200d, 0x0d4d}, { {0, 3, 1, {0x1272}}, {1, 2, 0, {0x0000}}, {2, 4, 2, {0x058f, 0x123a}}, {3, 4, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d28, 0x0d4d, 0x200d, 0x0d4d}, { {0, 3, 1, {0x1273}}, {1, 2, 0, {0x0000}}, {2, 4, 2, {0x058f, 0x123a}}, {3, 4, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d30, 0x0d4d, 0x200d, 0x0d4d}, { {0, 3, 1, {0x1274}}, {1, 2, 0, {0x0000}}, {2, 4, 2, {0x058f, 0x123a}}, {3, 4, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d32, 0x0d4d, 0x200d, 0x0d4d}, { {0, 3, 1, {0x1276}}, {1, 2, 0, {0x0000}}, {2, 4, 2, {0x058f, 0x123a}}, {3, 4, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 4, {0x0d33, 0x0d4d, 0x200d, 0x0d4d}, { {0, 3, 1, {0x1275}}, {1, 2, 0, {0x0000}}, {2, 4, 2, {0x058f, 0x123a}}, {3, 4, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ -1, {0}, -1,						-1, 0, {0}}
};

LOCAL_D const TTestInput_PositionParam6 Indic_GurmukhiVowelLeading[] = {
		//	ARA, IRI, URA, independent vowel to shaper
		{ 1, {0x0a05}, { {0, 1, 1, {0x12c3}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a06}, { {0, 1, 1, {0x12c4}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a07}, { {0, 1, 1, {0x12c5}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a08}, { {0, 1, 1, {0x12c6}}, {-1, 1, 1, {0} } } },		
		{ 1, {0x0a09}, { {0, 1, 1, {0x12c7}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a0a}, { {0, 1, 1, {0x12c8}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a0b}, { {0, 1, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a0c}, { {0, 1, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a0d}, { {0, 1, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a0e}, { {0, 1, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a0f}, { {0, 1, 1, {0x12c9}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a10}, { {0, 1, 1, {0x12ca}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a11}, { {0, 1, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a12}, { {0, 1, 1, {0x0000}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a13}, { {0, 1, 1, {0x12cb}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a14}, { {0, 1, 1, {0x12cc}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a72}, { {0, 1, 1, {0x130a}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0a73}, { {0, 1, 1, {0x130b}}, {-1, 1, 1, {0} } } },
		//	Valid bear + vowel
		{ 2, {0x0a05, 0x0a3e}, { {0, 2, 2, {0x12c3, 0x12ef}}, {1, 2, 1, {0x12ef}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a05, 0x0a48}, { {0, 2, 2, {0x12c3, 0x12f5}}, {1, 2, 1, {0x12f5}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a05, 0x0a4c}, { {0, 2, 2, {0x12c3, 0x12f7}}, {1, 2, 1, {0x12f7}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a72, 0x0a3f}, { {0, 2, 2, {0x12f0, 0x130a}}, {1, 2, 1, {0x12f0}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a72, 0x0a40}, { {0, 2, 2, {0x130a, 0x12f1}}, {1, 2, 1, {0x12f1}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a72, 0x0a47}, { {0, 2, 2, {0x130a, 0x12f4}}, {1, 2, 1, {0x12f4}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a41}, { {0, 2, 1, {0x12c7}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a42}, { {0, 2, 1, {0x12c8}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a4b}, { {0, 2, 1, {0x12cb}}, {-1, 1, 1, {0} } } },
		//	Invalid bear + vowel sequence
		{ 2, {0x0a72, 0x0a4b}, { {0, 1, 1, {0x130a}}, {1, 2, 2, {0x058f, 0x12f6}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a05, 0x0a4b}, { {0, 1, 1, {0x12c3}}, {1, 2, 2, {0x058f, 0x12f6}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0a73, 0x0a3f}, { {0, 1, 1, {0x130b}}, {1, 2, 2, {0x12f0, 0x058f}}, {-1, 1, 1, {0} } } },
		{ -1, {0}, -1,						-1, 0, {0}}
};


LOCAL_D const TTestInput_PositionParam6 Indic_MalayalamVowelLeading[] = {
		//	Vowel
		{ 1, {0x0d05}, { {0, 1, 1, {0x11fc}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d06}, { {0, 1, 1, {0x11fd}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d07}, { {0, 1, 1, {0x11fe}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d08}, { {0, 1, 1, {0x11ff}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d09}, { {0, 1, 1, {0x1200}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d0a}, { {0, 1, 1, {0x1201}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d0b}, { {0, 1, 1, {0x1202}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d60}, { {0, 1, 1, {0x123c}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d0c}, { {0, 1, 1, {0x1203}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d61}, { {0, 1, 1, {0x123d}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d0e}, { {0, 1, 1, {0x1204}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d0f}, { {0, 1, 1, {0x1205}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d10}, { {0, 1, 1, {0x1206}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d12}, { {0, 1, 1, {0x1207}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d13}, { {0, 1, 1, {0x1208}}, {-1, 1, 1, {0} } } },
		{ 1, {0x0d14}, { {0, 1, 1, {0x1209}}, {-1, 1, 1, {0} } } },
		//	Vowel + modifer 
		{ 2, {0x0d05, 0x0d02}, { {0, 2, 2, {0x11fc, 0x11fa}}, {1, 2, 1, {0x11fa}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d06, 0x0d02}, { {0, 2, 2, {0x11fd, 0x11fa}}, {1, 2, 1, {0x11fa}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d07, 0x0d02}, { {0, 2, 2, {0x11fe, 0x11fa}}, {1, 2, 1, {0x11fa}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d08, 0x0d02}, { {0, 2, 2, {0x11ff, 0x11fa}}, {1, 2, 1, {0x11fa}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d09, 0x0d02}, { {0, 2, 2, {0x1200, 0x11fa}}, {1, 2, 1, {0x11fa}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0a, 0x0d02}, { {0, 2, 2, {0x1201, 0x11fa}}, {1, 2, 1, {0x11fa}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0b, 0x0d02}, { {0, 2, 2, {0x1202, 0x11fa}}, {1, 2, 1, {0x11fa}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d60, 0x0d02}, { {0, 2, 2, {0x123c, 0x11fa}}, {1, 2, 1, {0x11fa}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0c, 0x0d03}, { {0, 2, 2, {0x1203, 0x11fb}}, {1, 2, 1, {0x11fb}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d61, 0x0d03}, { {0, 2, 2, {0x123d, 0x11fb}}, {1, 2, 1, {0x11fb}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0e, 0x0d03}, { {0, 2, 2, {0x1204, 0x11fb}}, {1, 2, 1, {0x11fb}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0f, 0x0d03}, { {0, 2, 2, {0x1205, 0x11fb}}, {1, 2, 1, {0x11fb}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d10, 0x0d03}, { {0, 2, 2, {0x1206, 0x11fb}}, {1, 2, 1, {0x11fb}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d12, 0x0d03}, { {0, 2, 2, {0x1207, 0x11fb}}, {1, 2, 1, {0x11fb}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d13, 0x0d03}, { {0, 2, 2, {0x1208, 0x11fb}}, {1, 2, 1, {0x11fb}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d14, 0x0d03}, { {0, 2, 2, {0x1209, 0x11fb}}, {1, 2, 1, {0x11fb}}, {-1, 1, 1, {0} } } },
		//	Vowel, Modifier, Matra
		{ 3, {0x0d05, 0x0d02, 0x0d3e}, { {0, 2, 2, {0x11fc, 0x11fa}}, {1, 2, 1, {0x11fa}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d06, 0x0d02, 0x0d3f}, { {0, 2, 2, {0x11fd, 0x11fa}}, {1, 2, 1, {0x11fa}}, {2, 3, 2, {0x058f, 0x122f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d07, 0x0d02, 0x0d40}, { {0, 2, 2, {0x11fe, 0x11fa}}, {1, 2, 1, {0x11fa}}, {2, 3, 2, {0x058f, 0x1230}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d08, 0x0d02, 0x0d41}, { {0, 2, 2, {0x11ff, 0x11fa}}, {1, 2, 1, {0x11fa}}, {2, 3, 2, {0x058f, 0x1231}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d09, 0x0d02, 0x0d42}, { {0, 2, 2, {0x1200, 0x11fa}}, {1, 2, 1, {0x11fa}}, {2, 3, 2, {0x058f, 0x1232}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d0a, 0x0d02, 0x0d43}, { {0, 2, 2, {0x1201, 0x11fa}}, {1, 2, 1, {0x11fa}}, {2, 3, 2, {0x058f, 0x1233}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d0b, 0x0d02, 0x0d46}, { {0, 2, 2, {0x1202, 0x11fa}}, {1, 2, 1, {0x11fa}}, {2, 3, 2, {0x1234, 0x058f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d60, 0x0d02, 0x0d47}, { {0, 2, 2, {0x123c, 0x11fa}}, {1, 2, 1, {0x11fa}}, {2, 3, 2, {0x1235, 0x058f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d0c, 0x0d03, 0x0d48}, { {0, 2, 2, {0x1203, 0x11fb}}, {1, 2, 1, {0x11fb}}, {2, 3, 2, {0x1236, 0x058f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d61, 0x0d03, 0x0d4a}, { {0, 2, 2, {0x123d, 0x11fb}}, {1, 2, 1, {0x11fb}}, {2, 3, 3, {0x1234, 0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d0e, 0x0d03, 0x0d4b}, { {0, 2, 2, {0x1204, 0x11fb}}, {1, 2, 1, {0x11fb}}, {2, 3, 3, {0x1235, 0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d0f, 0x0d03, 0x0d4c}, { {0, 2, 2, {0x1205, 0x11fb}}, {1, 2, 1, {0x11fb}}, {2, 3, 2, {0x058f, 0x123b}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d10, 0x0d03, 0x0d3e}, { {0, 2, 2, {0x1206, 0x11fb}}, {1, 2, 1, {0x11fb}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d12, 0x0d03, 0x0d3f}, { {0, 2, 2, {0x1207, 0x11fb}}, {1, 2, 1, {0x11fb}}, {2, 3, 2, {0x058f, 0x122f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d13, 0x0d03, 0x0d40}, { {0, 2, 2, {0x1208, 0x11fb}}, {1, 2, 1, {0x11fb}}, {2, 3, 2, {0x058f, 0x1230}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d14, 0x0d03, 0x0d4c}, { {0, 2, 2, {0x1209, 0x11fb}}, {1, 2, 1, {0x11fb}}, {2, 3, 2, {0x058f, 0x123b}}, {-1, 1, 1, {0} } } },
		
		//	Vowel, Virama,
		{ 2, {0x0d05, 0x0d4d}, { {0, 1, 1, {0x11fc}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d06, 0x0d4d}, { {0, 1, 1, {0x11fd}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d07, 0x0d4d}, { {0, 1, 1, {0x11fe}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d08, 0x0d4d}, { {0, 1, 1, {0x11ff}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d09, 0x0d4d}, { {0, 1, 1, {0x1200}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0a, 0x0d4d}, { {0, 1, 1, {0x1201}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0b, 0x0d4d}, { {0, 1, 1, {0x1202}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d60, 0x0d4d}, { {0, 1, 1, {0x123c}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0c, 0x0d4d}, { {0, 1, 1, {0x1203}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d61, 0x0d4d}, { {0, 1, 1, {0x123d}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0e, 0x0d4d}, { {0, 1, 1, {0x1204}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0f, 0x0d4d}, { {0, 1, 1, {0x1205}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d10, 0x0d4d}, { {0, 1, 1, {0x1206}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d12, 0x0d4d}, { {0, 1, 1, {0x1207}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d13, 0x0d4d}, { {0, 1, 1, {0x1208}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d14, 0x0d4d}, { {0, 1, 1, {0x1209}}, {1, 2, 2, {0x058f, 0x123a}}, {-1, 1, 1, {0} } } },

		//	Vowel, Matra,
		{ 2, {0x0d05, 0x0d3e}, { {0, 1, 1, {0x11fc}}, {1, 2, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d06, 0x0d3f}, { {0, 1, 1, {0x11fd}}, {1, 2, 2, {0x058f, 0x122f}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d07, 0x0d40}, { {0, 1, 1, {0x11fe}}, {1, 2, 2, {0x058f, 0x1230}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d08, 0x0d41}, { {0, 1, 1, {0x11ff}}, {1, 2, 2, {0x058f, 0x1231}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d09, 0x0d42}, { {0, 1, 1, {0x1200}}, {1, 2, 2, {0x058f, 0x1232}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0a, 0x0d43}, { {0, 1, 1, {0x1201}}, {1, 2, 2, {0x058f, 0x1233}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0b, 0x0d46}, { {0, 1, 1, {0x1202}}, {1, 2, 2, {0x1234, 0x058f}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d60, 0x0d47}, { {0, 1, 1, {0x123c}}, {1, 2, 2, {0x1235, 0x058f}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0c, 0x0d48}, { {0, 1, 1, {0x1203}}, {1, 2, 2, {0x1236, 0x058f}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d61, 0x0d4a}, { {0, 1, 1, {0x123d}}, {1, 2, 3, {0x1234, 0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0e, 0x0d4b}, { {0, 1, 1, {0x1204}}, {1, 2, 3, {0x1235, 0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d0f, 0x0d4c}, { {0, 1, 1, {0x1205}}, {1, 2, 2, {0x058f, 0x123b}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d10, 0x0d3e}, { {0, 1, 1, {0x1206}}, {1, 2, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d12, 0x0d3f}, { {0, 1, 1, {0x1207}}, {1, 2, 2, {0x058f, 0x122f}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d13, 0x0d40}, { {0, 1, 1, {0x1208}}, {1, 2, 2, {0x058f, 0x1230}}, {-1, 1, 1, {0} } } },
		{ 2, {0x0d14, 0x0d4c}, { {0, 1, 1, {0x1209}}, {1, 2, 2, {0x058f, 0x123b}}, {-1, 1, 1, {0} } } },
		//	Vowel Virma, Matra
		{ 3, {0x0d05, 0x0d4d, 0x0d3e}, { {0, 1, 1, {0x11fc}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d06, 0x0d4d, 0x0d3f}, { {0, 1, 1, {0x11fd}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x058f, 0x122f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d07, 0x0d4d, 0x0d40}, { {0, 1, 1, {0x11fe}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x058f, 0x1230}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d08, 0x0d4d, 0x0d41}, { {0, 1, 1, {0x11ff}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x058f, 0x1231}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d09, 0x0d4d, 0x0d42}, { {0, 1, 1, {0x1200}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x058f, 0x1232}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d0a, 0x0d4d, 0x0d43}, { {0, 1, 1, {0x1201}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x058f, 0x1233}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d0b, 0x0d4d, 0x0d46}, { {0, 1, 1, {0x1202}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x1234, 0x058f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d60, 0x0d4d, 0x0d47}, { {0, 1, 1, {0x123c}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x1235, 0x058f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d0c, 0x0d4d, 0x0d48}, { {0, 1, 1, {0x1203}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x1236, 0x058f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d61, 0x0d4d, 0x0d4a}, { {0, 1, 1, {0x123d}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 3, {0x1234, 0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d0e, 0x0d4d, 0x0d4b}, { {0, 1, 1, {0x1204}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 3, {0x1235, 0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d0f, 0x0d4d, 0x0d4c}, { {0, 1, 1, {0x1205}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x058f, 0x123b}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d10, 0x0d4d, 0x0d3e}, { {0, 1, 1, {0x1206}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x058f, 0x122e}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d12, 0x0d4d, 0x0d3f}, { {0, 1, 1, {0x1207}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x058f, 0x122f}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d13, 0x0d4d, 0x0d40}, { {0, 1, 1, {0x1208}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x058f, 0x1230}}, {-1, 1, 1, {0} } } },
		{ 3, {0x0d14, 0x0d4d, 0x0d4c}, { {0, 1, 1, {0x1209}}, {1, 2, 2, {0x058f, 0x123a}}, {2, 3, 2, {0x058f, 0x123b}}, {-1, 1, 1, {0} } } },
		{ -1, {0}, -1,						-1, 0, {0}}
};

/**
 This array of structs is used in the test routine 
 CTGlyphSelection::TestThai_InvalidGlyphClusters() to verify that
 GetCharacterPosition() correctly uses the dotted circle character
 when it crosses a glyph cluster boundary and finds invalid combining
 characters.
*/
LOCAL_D const TTestInput_PositionParam2 Thai_GlyphClusterBoundaries[] = {
//    --TEXT----------------	--INVOKE 1---------------		--INVOKE 2----------------

//0.TEST D1 - Control character - skipped

//0.TEST D2 - Non Thai letter
	{ 2, {0x0E3F, 0x0E5B}, 	 	{{0, 1, 1, {0x0E3F}},			{1, 2, 1, {0x0E5B}}}},
	{ 2, {0x0041, 0x0E03}, 	 	{{0, 1, 1, {0x0041}},			{1, 2, 1, {0x0E03}}}},
	{ 2, {0x0E2F, 0x0E40}, 	 	{{0, 1, 1, {0x0E2F}},			{1, 2, 1, {0x0E40}}}},
	{ 2, {0x0E3F, 0x0E30}, 	 	{{0, 1, 1, {0x0E3F}},			{1, 2, 1, {0x0E30}}}},
	{ 2, {0x0E46, 0x0E45}, 	 	{{0, 1, 1, {0x0E46}},			{1, 2, 1, {0x0E45}}}},
	{ 2, {0x0E4F, 0x0E24}, 	 	{{0, 1, 1, {0x0E4F}},			{1, 2, 1, {0x0E24}}}},

	{ 2, {0x0E50, 0x0E38}, 	 	{{0, 1, 1, {0x0E50}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 2, {0x0E51, 0x0E39}, 	 	{{0, 1, 1, {0x0E51}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 2, {0x0E52, 0x0E3A}, 	 	{{0, 1, 1, {0x0E52}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 2, {0x0E55, 0x0E49}, 	 	{{0, 1, 1, {0x0E55}},			{1, 2, 2, {KUnicodeDottedCircle, 0xF70B}}}},
	{ 2, {0x0E56, 0x0E4C}, 	 	{{0, 1, 1, {0x0E56}},			{1, 2, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 2, {0x0E58, 0x0E47}, 	 	{{0, 1, 1, {0x0E58}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 2, {0x0E59, 0x0E4E}, 	 	{{0, 1, 1, {0x0E59}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 2, {0x0E5A, 0x0E34}, 	 	{{0, 1, 1, {0x0E5A}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 2, {0x0E5B, 0x0E31}, 	 	{{0, 1, 1, {0x0E5B}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 2, {0x005A, 0x0E37}, 	 	{{0, 1, 1, {0x005A}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//16.TEST D3 - Thai consonant
	{ 2, {0x0E01, 0x0E3F},	 	{{0, 1, 1, {0x0E01}},			{1, 2, 1, {0x0E3F}}}},
	{ 2, {0x0E01, 0x0E03}, 	 	{{0, 1, 1, {0x0E01}},			{1, 2, 1, {0x0E03}}}},
	{ 2, {0x0E02, 0x0E40}, 	 	{{0, 1, 1, {0x0E02}},			{1, 2, 1, {0x0E40}}}},
	{ 2, {0x0E03, 0x0E30}, 	 	{{0, 1, 1, {0x0E03}},			{1, 2, 1, {0x0E30}}}},
	{ 2, {0x0E04, 0x0E45}, 	 	{{0, 1, 1, {0x0E04}},			{1, 2, 1, {0x0E45}}}},
	{ 2, {0x0E05, 0x0E24}, 	 	{{0, 1, 1, {0x0E05}},			{1, 2, 1, {0x0E24}}}},

	{ 2, {0x0E06, 0x0E38}, 	 	{{0, 2, 2, {0x0E06, 0x0E38}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E07, 0x0E39}, 	 	{{0, 2, 2, {0x0E07, 0x0E39}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E23, 0x0E3A}, 	 	{{0, 2, 2, {0x0E23, 0x0E3A}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E25, 0x0E49}, 	 	{{0, 2, 2, {0x0E25, 0xF70B}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E27, 0x0E4C}, 	 	{{0, 2, 2, {0x0E27, 0xF70E}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E28, 0x0E47}, 	 	{{0, 2, 2, {0x0E28, 0x0E47}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E29, 0x0E4E}, 	 	{{0, 2, 2, {0x0E29, 0x0E4E}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E2A, 0x0E34}, 	 	{{0, 2, 2, {0x0E2A, 0x0E34}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E2D, 0x0E31}, 	 	{{0, 2, 2, {0x0E2D, 0x0E31}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E2E, 0x0E37}, 	 	{{0, 2, 2, {0x0E2E, 0x0E37}},	{-1, -1, 0, {0}}}},

//32.TEST D4 - Thai leading vowel
	{ 2, {0x0E40, 0x0E3F}, 	 	{{0, 1, 1, {0x0E40}},			{1, 2, 1, {0x0E3F}}}},
	{ 2, {0x0E41, 0x0E03}, 	 	{{0, 1, 1, {0x0E41}},			{1, 2, 1, {0x0E03}}}},
	{ 2, {0x0E42, 0x0E40}, 	 	{{0, 1, 1, {0x0E42}},			{1, 2, 1, {0x0E40}}}},
	{ 2, {0x0E43, 0x0E30}, 	 	{{0, 1, 1, {0x0E43}},			{1, 2, 1, {0x0E30}}}},
	{ 2, {0x0E44, 0x0E45}, 	 	{{0, 1, 1, {0x0E44}},			{1, 2, 1, {0x0E45}}}},
	{ 2, {0x0E44, 0x0E24}, 	 	{{0, 1, 1, {0x0E44}},			{1, 2, 1, {0x0E24}}}},

	{ 2, {0x0E40, 0x0E38},		{{0, 1, 1, {0x0E40}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 2, {0x0E41, 0x0E39}, 	 	{{0, 1, 1, {0x0E41}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 2, {0x0E42, 0x0E3A}, 	 	{{0, 1, 1, {0x0E42}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 2, {0x0E43, 0x0E49}, 	 	{{0, 1, 1, {0x0E43}},			{1, 2, 2, {KUnicodeDottedCircle, 0xF70B}}}},
	{ 2, {0x0E44, 0x0E4C}, 	 	{{0, 1, 1, {0x0E44}},			{1, 2, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 2, {0x0E40, 0x0E47}, 	 	{{0, 1, 1, {0x0E40}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 2, {0x0E41, 0x0E4E}, 	 	{{0, 1, 1, {0x0E41}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 2, {0x0E42, 0x0E34}, 	 	{{0, 1, 1, {0x0E42}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 2, {0x0E43, 0x0E31}, 	 	{{0, 1, 1, {0x0E43}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 2, {0x0E44, 0x0E37}, 	 	{{0, 1, 1, {0x0E44}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//48.TEST D5 - Thai following vowel 1
	{ 2, {0x0E30, 0x0E3F}, 	 	{{0, 1, 1, {0x0E30}},				{1, 2, 1, {0x0E3F}}}},
	{ 2, {0x0E32, 0x0E03}, 	 	{{0, 1, 1, {0x0E32}},				{1, 2, 1, {0x0E03}}}},
	{ 2, {0x0E33, 0x0E40}, 	 	{{0, 1, 2, {KUnicodeDottedCircle, 0x0E33}},{1, 2, 1, {0x0E40}}}},
	{ 2, {0x0E30, 0x0E30}, 	 	{{0, 1, 1, {0x0E30}},				{1, 2, 1, {0x0E30}}}},
	{ 2, {0x0E32, 0x0E45}, 	 	{{0, 1, 1, {0x0E32}},				{1, 2, 1, {0x0E45}}}},
	{ 2, {0x0E33, 0x0E24}, 	 	{{0, 1, 2, {KUnicodeDottedCircle, 0x0E33}},{1, 2, 1, {0x0E24}}}},

	{ 2, {0x0E30, 0x0E38},		{{0, 1, 1, {0x0E30}},				{1, 2, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 2, {0x0E32, 0x0E39}, 	 	{{0, 1, 1, {0x0E32}},				{1, 2, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 2, {0x0E33, 0x0E3A}, 	 	{{0, 1, 2, {KUnicodeDottedCircle, 0x0E33}},{1, 2, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 2, {0x0E30, 0x0E49}, 	 	{{0, 1, 1, {0x0E30}},				{1, 2, 2, {KUnicodeDottedCircle, 0xF70B}}}},
	{ 2, {0x0E32, 0x0E4C}, 	 	{{0, 1, 1, {0x0E32}},				{1, 2, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 2, {0x0E33, 0x0E47}, 	 	{{0, 1, 2, {KUnicodeDottedCircle, 0x0E33}},{1, 2, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 2, {0x0E30, 0x0E4E}, 	 	{{0, 1, 1, {0x0E30}},				{1, 2, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 2, {0x0E32, 0x0E34}, 	 	{{0, 1, 1, {0x0E32}},				{1, 2, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 2, {0x0E33, 0x0E31}, 	 	{{0, 1, 2, {KUnicodeDottedCircle, 0x0E33}},{1, 2, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 2, {0x0E30, 0x0E37}, 	 	{{0, 1, 1, {0x0E30}},				{1, 2, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//64.TEST D6 - Thai following vowel 2
	{ 2, {0x0E45, 0x0E3F}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 1, {0x0E3F}}}},
	{ 2, {0x0E45, 0x0E03}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 1, {0x0E03}}}},
	{ 2, {0x0E45, 0x0E40}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 1, {0x0E40}}}},
	{ 2, {0x0E45, 0x0E30}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 1, {0x0E30}}}},
	{ 2, {0x0E45, 0x0E45}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 1, {0x0E45}}}},
	{ 2, {0x0E45, 0x0E24}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 1, {0x0E24}}}},

	{ 2, {0x0E45, 0x0E38},		{{0, 1, 1, {0x0E45}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 2, {0x0E45, 0x0E39}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 2, {0x0E45, 0x0E3A}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 2, {0x0E45, 0x0E49}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 2, {KUnicodeDottedCircle, 0xF70B}}}},
	{ 2, {0x0E45, 0x0E4C}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 2, {0x0E45, 0x0E47}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 2, {0x0E45, 0x0E4E}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 2, {0x0E45, 0x0E34}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 2, {0x0E45, 0x0E31}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 2, {0x0E45, 0x0E37}, 	 	{{0, 1, 1, {0x0E45}},			{1, 2, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//80.TEST D7 - Thai following vowel 3
	{ 2, {0x0E24, 0x0E3F}, 	 	{{0, 1, 1, {0x0E24}},			{1, 2, 1, {0x0E3F}}}},
	{ 2, {0x0E26, 0x0E03}, 	 	{{0, 1, 1, {0x0E26}},			{1, 2, 1, {0x0E03}}}},
	{ 2, {0x0E24, 0x0E40}, 	 	{{0, 1, 1, {0x0E24}},			{1, 2, 1, {0x0E40}}}},
	{ 2, {0x0E26, 0x0E30}, 	 	{{0, 1, 1, {0x0E26}},			{1, 2, 1, {0x0E30}}}},
	{ 2, {0x0E24, 0x0E45}, 	 	{{0, 1, 1, {0x0E24}},			{1, 2, 1, {0x0E45}}}},
	{ 2, {0x0E26, 0x0E24}, 	 	{{0, 1, 1, {0x0E26}},			{1, 2, 1, {0x0E24}}}},

	{ 2, {0x0E24, 0x0E38},		{{0, 2, 2, {0x0E24, 0xF718}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E26, 0x0E39}, 	 	{{0, 2, 2, {0x0E26, 0xF719}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E24, 0x0E3A}, 	 	{{0, 2, 2, {0x0E24, 0xF71A}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E26, 0x0E49}, 	 	{{0, 2, 2, {0x0E26, 0xF70B}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E24, 0x0E4C}, 	 	{{0, 2, 2, {0x0E24, 0xF70E}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E26, 0x0E47}, 	 	{{0, 2, 2, {0x0E26, 0x0E47}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E24, 0x0E4E}, 	 	{{0, 2, 2, {0x0E24, 0x0E4E}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E26, 0x0E34}, 	 	{{0, 2, 2, {0x0E26, 0x0E34}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E24, 0x0E31}, 	 	{{0, 2, 2, {0x0E24, 0x0E31}},	{-1, -1, 0, {0}}}},
	{ 2, {0x0E26, 0x0E37}, 	 	{{0, 2, 2, {0x0E26, 0x0E37}},	{-1, -1, 0, {0}}}},

//96.TEST D8 - Thai NO NU & Below Vowel 1
	{ 3, {0x0E19, 0x0E38, 0x0E3F}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 1, {0x0E3F}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E03}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 1, {0x0E03}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E40}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 1, {0x0E40}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E30}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 1, {0x0E30}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E45}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 1, {0x0E45}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E24}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 1, {0x0E24}}}},

	{ 3, {0x0E19, 0x0E38, 0x0E38},		{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E39}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E3A}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E49}, 	 	{{0, 3, 3, {0x0E19, 0x0E38, 0xF70B}},	{-1, -1, 0, {0}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E4C}, 	 	{{0, 3, 3, {0x0E19, 0x0E38, 0xF70E}},	{-1, -1, 0, {0}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E47}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E4E}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E34}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E31}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 3, {0x0E19, 0x0E38, 0x0E37}, 	 	{{0, 2, 2, {0x0E19, 0x0E38}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//112.TEST D9 - Thai NO NU & Below Vowel 2
	{ 3, {0x0E19, 0x0E39, 0x0E3F}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 1, {0x0E3F}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E03}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 1, {0x0E03}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E40}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 1, {0x0E40}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E30}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 1, {0x0E30}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E45}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 1, {0x0E45}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E24}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 1, {0x0E24}}}},

	{ 3, {0x0E19, 0x0E39, 0x0E38},		{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E39}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E3A}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E49}, 	 	{{0, 3, 3, {0x0E19, 0x0E39, 0xF70B}},	{-1, -1, 0, {0}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E4C}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E47}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E4E}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E34}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E31}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 3, {0x0E19, 0x0E39, 0x0E37}, 	 	{{0, 2, 2, {0x0E19, 0x0E39}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//128.TEST D10 - Thai NO NU & Below Diacritic
	{ 3, {0x0E19, 0x0E3A, 0x0E3F}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 1, {0x0E3F}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E03}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 1, {0x0E03}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E40}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 1, {0x0E40}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E30}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 1, {0x0E30}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E45}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 1, {0x0E45}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E24}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 1, {0x0E24}}}},

	{ 3, {0x0E19, 0x0E3A, 0x0E38},		{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E39}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E3A}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E49}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70B}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E4C}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E47}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E4E}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E34}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E31}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 3, {0x0E19, 0x0E3A, 0x0E37}, 	 	{{0, 2, 2, {0x0E19, 0x0E3A}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//144.TEST D11 - Thai NO NU & Tone mark
	{ 3, {0x0E19, 0x0E48, 0x0E3F}, 	 	{{0, 2, 2, {0x0E19, 0xF70A}},			{2, 3, 1, {0x0E3F}}}},
	{ 3, {0x0E19, 0x0E49, 0x0E03}, 	 	{{0, 2, 2, {0x0E19, 0xF70B}},			{2, 3, 1, {0x0E03}}}},
	{ 3, {0x0E19, 0x0E4A, 0x0E40}, 	 	{{0, 2, 2, {0x0E19, 0xF70C}},			{2, 3, 1, {0x0E40}}}},
	{ 3, {0x0E19, 0x0E4B, 0x0E30}, 	 	{{0, 2, 2, {0x0E19, 0xF70D}},			{2, 3, 1, {0x0E30}}}},
	{ 3, {0x0E19, 0x0E48, 0x0E45}, 	 	{{0, 2, 2, {0x0E19, 0xF70A}},			{2, 3, 1, {0x0E45}}}},
	{ 3, {0x0E19, 0x0E49, 0x0E24}, 	 	{{0, 2, 2, {0x0E19, 0xF70B}},			{2, 3, 1, {0x0E24}}}},

	{ 3, {0x0E19, 0x0E4A, 0x0E38},		{{0, 2, 2, {0x0E19, 0xF70C}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 3, {0x0E19, 0x0E4B, 0x0E39}, 	 	{{0, 2, 2, {0x0E19, 0xF70D}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 3, {0x0E19, 0x0E48, 0x0E3A}, 	 	{{0, 2, 2, {0x0E19, 0xF70A}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 3, {0x0E19, 0x0E49, 0x0E49}, 	 	{{0, 2, 2, {0x0E19, 0xF70B}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70B}}}},
	{ 3, {0x0E19, 0x0E4A, 0x0E4C}, 	 	{{0, 2, 2, {0x0E19, 0xF70C}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 3, {0x0E19, 0x0E4B, 0x0E47}, 	 	{{0, 2, 2, {0x0E19, 0xF70D}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E19, 0x0E48, 0x0E4E}, 	 	{{0, 2, 2, {0x0E19, 0xF70A}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 3, {0x0E19, 0x0E49, 0x0E34}, 	 	{{0, 2, 2, {0x0E19, 0xF70B}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 3, {0x0E19, 0x0E4A, 0x0E31}, 	 	{{0, 2, 2, {0x0E19, 0xF70C}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 3, {0x0E19, 0x0E4B, 0x0E37}, 	 	{{0, 2, 2, {0x0E19, 0xF70D}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//160.TEST D12 - Thai NO NU & Above Diacritic 1
	{ 3, {0x0E19, 0x0E4C, 0x0E3F}, 	 	{{0, 2, 2, {0x0E19, 0xF70E}},			{2, 3, 1, {0x0E3F}}}},
	{ 3, {0x0E19, 0x0E4D, 0x0E03}, 	 	{{0, 2, 2, {0x0E19, 0x0E4D}},			{2, 3, 1, {0x0E03}}}},
	{ 3, {0x0E19, 0x0E4C, 0x0E40}, 	 	{{0, 2, 2, {0x0E19, 0xF70E}},			{2, 3, 1, {0x0E40}}}},
	{ 3, {0x0E19, 0x0E4D, 0x0E30}, 	 	{{0, 2, 2, {0x0E19, 0x0E4D}},			{2, 3, 1, {0x0E30}}}},
	{ 3, {0x0E19, 0x0E4C, 0x0E45}, 	 	{{0, 2, 2, {0x0E19, 0xF70E}},			{2, 3, 1, {0x0E45}}}},
	{ 3, {0x0E19, 0x0E4D, 0x0E24}, 	 	{{0, 2, 2, {0x0E19, 0x0E4D}},			{2, 3, 1, {0x0E24}}}},

	{ 3, {0x0E19, 0x0E4C, 0x0E38},		{{0, 2, 2, {0x0E19, 0xF70E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 3, {0x0E19, 0x0E4D, 0x0E39}, 	 	{{0, 2, 2, {0x0E19, 0x0E4D}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 3, {0x0E19, 0x0E4C, 0x0E3A}, 	 	{{0, 2, 2, {0x0E19, 0xF70E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 3, {0x0E19, 0x0E4D, 0x0E49}, 	 	{{0, 2, 2, {0x0E19, 0x0E4D}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70B}}}},
	{ 3, {0x0E19, 0x0E4C, 0x0E4C}, 	 	{{0, 2, 2, {0x0E19, 0xF70E}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 3, {0x0E19, 0x0E4D, 0x0E47}, 	 	{{0, 2, 2, {0x0E19, 0x0E4D}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E19, 0x0E4C, 0x0E4E}, 	 	{{0, 2, 2, {0x0E19, 0xF70E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 3, {0x0E19, 0x0E4D, 0x0E34}, 	 	{{0, 2, 2, {0x0E19, 0x0E4D}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 3, {0x0E19, 0x0E4C, 0x0E31}, 	 	{{0, 2, 2, {0x0E19, 0xF70E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 3, {0x0E19, 0x0E4D, 0x0E37}, 	 	{{0, 2, 2, {0x0E19, 0x0E4D}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//176.TEST D13 - Thai NO NU & Above Diacritic 2
	{ 3, {0x0E19, 0x0E47, 0x0E3F}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 1, {0x0E3F}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E03}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 1, {0x0E03}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E40}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 1, {0x0E40}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E30}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 1, {0x0E30}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E45}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 1, {0x0E45}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E24}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 1, {0x0E24}}}},

	{ 3, {0x0E19, 0x0E47, 0x0E38},		{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E39}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E3A}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E49}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70B}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E4C}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E47}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E4E}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E34}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E31}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 3, {0x0E19, 0x0E47, 0x0E37}, 	 	{{0, 2, 2, {0x0E19, 0x0E47}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//176.TEST D14 - Thai NO NU & Above Diacritic 3
	{ 3, {0x0E19, 0x0E4E, 0x0E3F}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 1, {0x0E3F}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E03}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 1, {0x0E03}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E40}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 1, {0x0E40}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E30}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 1, {0x0E30}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E45}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 1, {0x0E45}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E24}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 1, {0x0E24}}}},

	{ 3, {0x0E19, 0x0E4E, 0x0E38},		{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E39}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E3A}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E49}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70B}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E4C}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E47}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E4E}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E34}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E31}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 3, {0x0E19, 0x0E4E, 0x0E37}, 	 	{{0, 2, 2, {0x0E19, 0x0E4E}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//192.TEST D15 - Thai NO NU & Above Vowel 1
	{ 3, {0x0E19, 0x0E34, 0x0E3F}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 1, {0x0E3F}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E03}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 1, {0x0E03}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E40}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 1, {0x0E40}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E30}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 1, {0x0E30}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E45}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 1, {0x0E45}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E24}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 1, {0x0E24}}}},

	{ 3, {0x0E19, 0x0E34, 0x0E38},		{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E39}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E3A}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E49}, 	 	{{0, 3, 3, {0x0E19, 0x0E34, 0x0E49}},	{-1, -1, 0, {0}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E4C}, 	 	{{0, 3, 3, {0x0E19, 0x0E34, 0x0E4C}},	{-1, -1, 0, {0}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E47}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E4E}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E34}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E31}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 3, {0x0E19, 0x0E34, 0x0E37}, 	 	{{0, 2, 2, {0x0E19, 0x0E34}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//208.TEST D16 - Thai NO NU & Above Vowel 2
	{ 3, {0x0E19, 0x0E31, 0x0E3F}, 	 	{{0, 2, 2, {0x0E19, 0x0E31}},			{2, 3, 1, {0x0E3F}}}},
	{ 3, {0x0E19, 0x0E36, 0x0E03}, 	 	{{0, 2, 2, {0x0E19, 0x0E36}},			{2, 3, 1, {0x0E03}}}},
	{ 3, {0x0E19, 0x0E31, 0x0E40}, 	 	{{0, 2, 2, {0x0E19, 0x0E31}},			{2, 3, 1, {0x0E40}}}},
	{ 3, {0x0E19, 0x0E36, 0x0E30}, 	 	{{0, 2, 2, {0x0E19, 0x0E36}},			{2, 3, 1, {0x0E30}}}},
	{ 3, {0x0E19, 0x0E31, 0x0E45}, 	 	{{0, 2, 2, {0x0E19, 0x0E31}},			{2, 3, 1, {0x0E45}}}},
	{ 3, {0x0E19, 0x0E36, 0x0E24}, 	 	{{0, 2, 2, {0x0E19, 0x0E36}},			{2, 3, 1, {0x0E24}}}},

	{ 3, {0x0E19, 0x0E31, 0x0E38},		{{0, 2, 2, {0x0E19, 0x0E31}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 3, {0x0E19, 0x0E36, 0x0E39}, 	 	{{0, 2, 2, {0x0E19, 0x0E36}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 3, {0x0E19, 0x0E31, 0x0E3A}, 	 	{{0, 2, 2, {0x0E19, 0x0E31}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 3, {0x0E19, 0x0E36, 0x0E49}, 	 	{{0, 3, 3, {0x0E19, 0x0E36, 0x0E49}},	{-1, -1, 0, {0}}}},
	{ 3, {0x0E19, 0x0E31, 0x0E4C}, 	 	{{0, 2, 2, {0x0E19, 0x0E31}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 3, {0x0E19, 0x0E36, 0x0E47}, 	 	{{0, 2, 2, {0x0E19, 0x0E36}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E19, 0x0E31, 0x0E4E}, 	 	{{0, 2, 2, {0x0E19, 0x0E31}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 3, {0x0E19, 0x0E36, 0x0E34}, 	 	{{0, 2, 2, {0x0E19, 0x0E36}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 3, {0x0E19, 0x0E31, 0x0E31}, 	 	{{0, 2, 2, {0x0E19, 0x0E31}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 3, {0x0E19, 0x0E36, 0x0E37}, 	 	{{0, 2, 2, {0x0E19, 0x0E36}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//240.TEST D17 - Thai NO NU & Above Vowel 3
	{ 3, {0x0E19, 0x0E35, 0x0E3F}, 	 	{{0, 2, 2, {0x0E19, 0x0E35}},			{2, 3, 1, {0x0E3F}}}},
	{ 3, {0x0E19, 0x0E37, 0x0E03}, 	 	{{0, 2, 2, {0x0E19, 0x0E37}},			{2, 3, 1, {0x0E03}}}},
	{ 3, {0x0E19, 0x0E35, 0x0E40}, 	 	{{0, 2, 2, {0x0E19, 0x0E35}},			{2, 3, 1, {0x0E40}}}},
	{ 3, {0x0E19, 0x0E37, 0x0E30}, 	 	{{0, 2, 2, {0x0E19, 0x0E37}},			{2, 3, 1, {0x0E30}}}},
	{ 3, {0x0E19, 0x0E35, 0x0E45}, 	 	{{0, 2, 2, {0x0E19, 0x0E35}},			{2, 3, 1, {0x0E45}}}},
	{ 3, {0x0E19, 0x0E37, 0x0E24}, 	 	{{0, 2, 2, {0x0E19, 0x0E37}},			{2, 3, 1, {0x0E24}}}},

	{ 3, {0x0E19, 0x0E35, 0x0E38},		{{0, 2, 2, {0x0E19, 0x0E35}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E38}}}},
	{ 3, {0x0E19, 0x0E37, 0x0E39}, 	 	{{0, 2, 2, {0x0E19, 0x0E37}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E39}}}},
	{ 3, {0x0E19, 0x0E35, 0x0E3A}, 	 	{{0, 2, 2, {0x0E19, 0x0E35}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E3A}}}},
	{ 3, {0x0E19, 0x0E37, 0x0E49}, 	 	{{0, 3, 3, {0x0E19, 0x0E37, 0x0E49}},	{-1, -1, 0, {0}}}},
	{ 3, {0x0E19, 0x0E35, 0x0E4C}, 	 	{{0, 2, 2, {0x0E19, 0x0E35}},			{2, 3, 2, {KUnicodeDottedCircle, 0xF70E}}}},
	{ 3, {0x0E19, 0x0E37, 0x0E47},		{{0, 2, 2, {0x0E19, 0x0E37}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E19, 0x0E35, 0x0E4E}, 	 	{{0, 2, 2, {0x0E19, 0x0E35}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E4E}}}},
	{ 3, {0x0E19, 0x0E37, 0x0E34}, 	 	{{0, 2, 2, {0x0E19, 0x0E37}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E34}}}},
	{ 3, {0x0E19, 0x0E35, 0x0E31}, 	 	{{0, 2, 2, {0x0E19, 0x0E35}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E31}}}},
	{ 3, {0x0E19, 0x0E37, 0x0E37}, 	 	{{0, 2, 2, {0x0E19, 0x0E37}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E37}}}},

//256.TEST D18a - Test Thai combining marks stack over a dotted circle.
	{ 2, {0x0E36, 0x0E48}, 	 			{{0, 2, 3, {KUnicodeDottedCircle, 0x0E36, 0x0E48}},	{-1, -1, 0, {0}}}},

//257.TEST D18b - Test non-thai consonant preceding two tone/signs in a row
	{ 2, {0x0041, 0x0E48, 0x0E49},		{{1, 2, 2, {KUnicodeDottedCircle, 0xF70A}},	{2, 3, 2, {KUnicodeDottedCircle, 0xF70B}}}},

//258. TEST DEF038524 - Test WTT2.0 Rare 4 optional combinations 0xBE, 0xDE, 0xE7, 0xF7
//3 Not supported, but render should degrade display to not overstrike at a minimum. 1 is supported.
	{ 3, {0x0E01, 0x0E35, 0x0E47},		{{0, 2, 2, {0x0E01, 0x0E35}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E01, 0x0E37, 0x0E47},		{{0, 2, 2, {0x0E01, 0x0E37}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E47}}}},
	{ 3, {0x0E01, 0x0E38, 0x0E4D},		{{0, 3, 3, {0x0E01, 0x0E38, 0x0E4D}},	{-1, -1, 0, {0}}}},
	{ 3, {0x0E01, 0x0E34, 0x0E4D},		{{0, 2, 2, {0x0E01, 0x0E34}},			{2, 3, 2, {KUnicodeDottedCircle, 0x0E4D}}}},

//246.TABLE END
	{ -1, {0}, 	 				{{-1, -1, 0, {0}},				{-1, -1, 0, {0}}}}
	};


//
// --- CLASS CTGlyphSelection --------------------------------------------
//


CTGlyphSelection::CTGlyphSelection(CTestStep* aStep) :
	CTGraphicsBase(aStep),
	iTestFont(NULL),
	iTestGraphicsDevice(NULL),
	iTestGraphicsContext(NULL)
	{
	}


CTGlyphSelection::~CTGlyphSelection()
/**
 This method cleans up after testing is finished. It releases memory
 allocated by the test obejct at a point before object destruction.
*/
	{
	delete iTestGraphicsContext;
	delete iTestGraphicsDevice;
	delete iTestFont;
	iFs.Close();
	}

void CTGlyphSelection::ConstructL()
	{
	CreateTestGraphicsContextL();
	User::LeaveIfError(iFs.Connect());
	}

void CTGlyphSelection::CreateTestGraphicsContextL()
/**
 This method sets-up the context data for the proceeding test cases.
*/
	{
	// Setup 400 pixel dummy graphics test device.
	TSize windowSize(400, 400);
	iTestGraphicsDevice = CTestGraphicsDevice::NewL(windowSize);

	// Create a dummy graphics test context.
	CGraphicsContext* tContext = NULL;	
	TEST(iTestGraphicsDevice->CreateContext(tContext) == KErrNone);
	iTestGraphicsContext = static_cast<CTestGraphicsContext*>(tContext);

	// Allocate the dummy test font to be used.
	iTestFont = new (ELeave) CTestFont;
	}


LOCAL_C TInt TestApiBoundaries_TC2(TAny* aData)
/**
 This is a root thread function which runs as part of the test case
 CTGlyphSelection::TestApiBoundaries(). It tests a panic
 is produced when an invalid text descriptor is supplied in the
 TPositionParam argument.
*/
	{
	CTGlyphSelection* testPtr = (CTGlyphSelection*)aData;

	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;

	testPtr->iTestFont->GetCharacterPosition(param);

	// Line above panics if component in UDEB is working OK; 
	// should never get here if component is in UDEB.

	// If component is in UREL, then could reach here.
	
	return (0);
	}


LOCAL_C TInt TestApiBoundaries_TC5(TAny* aData)
/**
 This is a root thread function which runs as part of the test case
 CTGlyphSelection::TestApiBoundaries(). It tests a panic
 is produced when a negative text position is supplied in the
 TPositionParam argument.
*/
	{
	CTGlyphSelection* testPtr = (CTGlyphSelection*)aData;

	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;
	_LIT16(KText_aaaa, "aaaa");
	param.iText.Set(KText_aaaa);
	param.iPosInText = -10;
	param.iPen.iX = param.iPen.iY = 0;

	testPtr->iTestFont->GetCharacterPosition(param);

	// Line above panics if component in UDEB is working OK; 
	// should never get here if component is in UDEB.

	// If component is in UREL, then could reach here.

	return (0);
	}


void CTGlyphSelection::TestApiBoundaries()
/**
 This method is a test case to exercise GetCharacterPosition() with
 parameter values at range boundaries and in some cases out-or-raange.
*/
	{
	TBool r;
	TBuf<20> testText(0);

	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	// 1: Check input arguments in paramter not modified
	testText = _L16("a");
	param.iText.Set(testText);
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iDirection == CFont::EHorizontal
		   && param.iFlags == CFont::TPositionParam::EFLogicalOrder
		   && param.iText.Ptr() == testText.Ptr());

	// 2: Check invalid iText descriptor panics (when component in UDEB)
	//    When component built in UREL, behaviour is undefined, so do not test.
	TRequestStatus threadStatus;
	RThread thread;
	TInt rc;
	TBool jit;
	jit = User::JustInTime();
	User::SetJustInTime(EFalse);
	rc = thread.Create(KThread2NameFirst, TestApiBoundaries_TC2, 
		KDefaultStackSize, KMinHeapSize, KMinHeapSize*4, this);
	TEST(KErrNone == rc);
	thread.Logon(threadStatus);
	thread.Resume();
	User::WaitForRequest(threadStatus);
	
	if (thread.ExitType() == EExitPanic)
		{
		TEST (thread.ExitReason() == EGdiPanic_InvalidInputParam);
		INFO_PRINTF2(_L("Exit reason %d"), thread.ExitReason());
		TExitCategoryName exitCategory = thread.ExitCategory();
		INFO_PRINTF2(_L("Exit category %S"), &exitCategory);			
		}
	else
		{
		// Function does not panic on invalid input; 
		// Warn that this is only valid behaviour if the GDI component being tested is built in UREL mode
		// and there is a problem if the function has not panicked if the GDI component is build in UDEB mode
		INFO_PRINTF1(_L("Warning: GetCharacterPosition() when given invalid iText descriptor has not panicked - this is only ok if the GDI component is built in UREL mode. If the GDI component is built in UDEB mode, then there is a problem."));
		}	
	thread.Close();
	User::SetJustInTime(jit);

	// 3: Zero length text descriptor
	testText = _L("");
	param.iText.Set(testText);
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(!r && param.iPen.iX == 0 
		    && param.iOutputGlyphs == 0);

	// 4: Position in text beyond descriptor length
	testText = _L16("a");
	param.iText.Set(testText);
	param.iPosInText = 5;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(!r && param.iPen.iX == 0 
		   && param.iOutputGlyphs == 0);

	// 5: Position in text is negative, should panic (when component in UDEB)
	//    When component built in UREL, behaviour is undefined, so do not test.
	jit = User::JustInTime();
	User::SetJustInTime(EFalse);
	rc = thread.Create(KThread2NameSecond, TestApiBoundaries_TC5, 
		KDefaultStackSize, KMinHeapSize, KMinHeapSize*4, this);
	TEST(KErrNone == rc);
	thread.Logon(threadStatus);
	thread.Resume();
	User::WaitForRequest(threadStatus);

	if (thread.ExitType() == EExitPanic)
		{
		TEST (thread.ExitReason() == EGdiPanic_InvalidInputParam);
		INFO_PRINTF2(_L("Exit reason %d"), thread.ExitReason());
		TExitCategoryName exitCategory = thread.ExitCategory();
		INFO_PRINTF2(_L("Exit category %S"), &exitCategory);			
		}
	else
		{
		// Function does not panic on invalid input; 
		// Warn that this is only valid behaviour if the GDI component being tested is built in UREL mode
		// and there is a problem if the function has not panicked if the GDI component is build in UDEB mode
		INFO_PRINTF1(_L("Warning: GetCharacterPosition() when given negative iPosInText has not panicked - this is only ok if the GDI component is built in UREL mode. If the GDI component is built in UDEB mode, then there is a problem."));
		}	

	thread.Close();
	User::SetJustInTime(jit);

	// 6: Check 'No-char-data' condition handled
	testText = _L16("A\033C");
	param.iText.Set(testText);
	param.iPosInText = 1;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST( !r
		   && param.iPosInText == 2
		   && param.iPen.iX == 0 
		   && param.iOutputGlyphs == 0);

	// 7: Check "Not-a-Char" condition handled
	testText = _L16("\xFFFF\xFFFE\xFFFF\xFFFF\xFFFF\xFFFE\xFFFF\xFFFF\xFFFF\xFFFE\xFFFF\xFFFF");
	param.iText.Set(testText);
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(  r
		   && param.iPosInText == 1
		   && param.iPen.iX == 0 
		   && param.iOutputGlyphs == 0);

	param.iPosInText = 5;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(  r
		   && param.iPosInText == 6
		   && param.iPen.iX == 0 
		   && param.iOutputGlyphs == 0);

	// 8. Check that a cluster cannot be made from heterogeneous elements
	// (in this case a 6 with a Hindi virama)
	testText = _L16("6\x94D");
	param.iText.Set(testText);
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iOutputGlyphs == 1);
	}

inline TBool IsSupplementary(TUint aChar)
/**
@param aChar The 32-bit code point value of a Unicode character.

@return True, if aChar is supplementary character; false, otherwise.
*/
	{
	return (aChar > 0xFFFF);
	}

inline TBool IsSurrogate(TText16 aInt16)
/**
@return True, if aText16 is high surrogate or low surrogate; false, otherwise.
*/
	{
	return (aInt16 & 0xF800) == 0xD800;
	}

inline TText16 GetHighSurrogate(TUint aChar)
/**
Retrieve the high surrogate of a supplementary character.

@param aChar The 32-bit code point value of a Unicode character.

@return High surrogate of aChar, if aChar is a supplementary character; 
        aChar itself, if aChar is not a supplementary character.
*/
	{
	return STATIC_CAST(TText16, 0xD7C0 + (aChar >> 10));
	}

inline TText16 GetLowSurrogate(TUint aChar)
/**
Retrieve the low surrogate of a supplementary character.

@param aChar The 32-bit code point value of a Unicode character.

@return Low surrogate of aChar, if aChar is a supplementary character; 
        zero, if aChar is not a supplementary character.
*/
	{
	return STATIC_CAST(TText16, 0xDC00 | (aChar & 0x3FF));
	}

void CTGlyphSelection::TestCodepoint(TUint aCodepoint, CFont* aFont)
/**
 This helper routine is used by the test case 
 CTGlyphSelection::TestCtrlCharsIgnored().
@param aCodepoint
 The Unicode character to test.
@param aFont
 The font to use in the test.
*/
	{
	TInt expectResultPosInText;

	const TInt KTestTextLen = 5;
	TBuf<16> testText(KTestTextLen);
	testText[0] = 'a';
	testText[1] = 'b';
	if (IsSupplementary(aCodepoint))
		{
		testText[2] = GetHighSurrogate(aCodepoint);
		testText[3] = GetLowSurrogate(aCodepoint);
		expectResultPosInText = 4;
		}
	else
		{
		testText[2] = aCodepoint;
		testText[3] = 'c';
		expectResultPosInText = 3;
		}
	testText[4] = 'd';

	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;
	param.iText.Set(testText);
	param.iPen.iX = param.iPen.iY = 0;
	param.iPosInText = 2; 
	TBool r = aFont->GetCharacterPosition(param);

	TEST(r && param.iPosInText == expectResultPosInText
		   && param.iPen.iX == 0 
		   && param.iOutputGlyphs == 0);
	}


void CTGlyphSelection::TestCtrlCharsIgnored()
/**
 This method is a test case to test GetCharacterPosition() copes
 with formatting and control characters in the text supplied by
 ignoring them.
*/
	{
	static const TUint testData[] = {
		// 1: Formatting control codes Unicode3-p499&p500
		0x200C, 0x200D, 0x200E, 0x200F,
		0x202A, 0x202B, 0x202C, 0x202D, 0x202E,
		// 3: Non-character codes Unicode3-p846 U+FFFE?
		// Original:
		// 0xFFFF 
		// 4: Latin Ctrl codes U+0000..U+001F, U+007F Unicode3-p???
		// 5: Latin Supplement Ctrl code U+0080..U+009F Unicode3-p???
		// 6: Supplementary characters (scripts outside BMP still not supported)
		};
	static const TUint testDataLength = sizeof(testData)/sizeof(testData[0]);

	for (TUint i = 0; i < testDataLength; i++)
		TestCodepoint(testData[i], iTestFont);
	}


void CTGlyphSelection::TestLatinChars()
/**
 This method is a test case to test GetCharacterPosition() correctly
 processes characters from the Latin code page returning appropriate glyphs
 codes.
*/
	{
	TBool r;
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;
	_LIT16(KText_aBc_1, "aBc 1");
	param.iText.Set(KText_aBc_1);

	// 1: Latin glyph at start of text
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 1 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 'a');

	// 2: Latin glyph in middle of text
	param.iPosInText = 1;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 2 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 'B');

	// 3: Latin glyph at end of text
	param.iPosInText = 4;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 5 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == '1');

	// 4: Latin space glyph 
	param.iPosInText = 3;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 4 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == ' ');
	}	


void CTGlyphSelection::TestSoftHyphen()
/**
 This method is a test case to test GetCharacterPosition() correctly
 processes soft hyphen chars by ignoring them if they are NOT at the
 end of the text (aka end of the line).
*/
	{
	TBool r;
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;
	_LIT16(KText_DKNY, "DK\xadNY\xad");
	param.iText.Set(KText_DKNY);

	// 1: Invoke on char before hyphen position 
	// This test returns only the glyph of the char before the hyphen
	// treating the hyphen as another base char which end scanning. 
	param.iPosInText = 1;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 2 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 'K');

	// 2: Invoke on hyphen position
	// This test should show it ignores and skips soft hyphens returning
	// no hyphen glyph. This is because soft hyphen are not visible when
	// in middle of lines.
	param.iPosInText = 2;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 3 
		   && param.iPen.iX == 0
		   && param.iOutputGlyphs == 0);

	// 3: Invoke on hyphen position when hyphen at end of text
	// This test should result in the hyphen glyph being returned as it
	// is expect to be visible when it is at the end of the text supplied.
	param.iPosInText = 5;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 6 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x00AD);

	}	


void CTGlyphSelection::TestSurrogates()
/**
 This method is a test case to test GetCharacterPosition() correctly
 processes surrogate pairs.
*/
	{
	static const TUint validPairs[] = {
	//  Hi		Lo		Code		Hi		Lo		Code		Hi		Lo		Code
		0xD800, 0xDC00, 0x00010000, 0xD800, 0xDE9A, 0x0001029A, 0xD800, 0xDFFF, 0x000103FF,
		0xD89A, 0xDC00, 0x00036800, 0xD89A, 0xDE9A, 0x00036A9A, 0xD89A, 0xDFFF, 0x00036BFF,
		0xDBFF, 0xDC00, 0x0010FC00, 0xDBFF, 0xDE9A, 0x0010FE9A, 0xDBFF, 0xDFFF, 0x0010FFFF
		};
	static const TUint validPairsLength = sizeof(validPairs)/sizeof(TText16);

	TBool r;
	TBuf<20> testText(0);
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	// 1: Test valid surrogate pair chars
	testText.SetLength(5);
	testText[0] = 'a';
	testText[3] = 'D';
	testText[4] = '1';
	param.iText.Set(testText);
	for (TUint i = 0; i < validPairsLength/3; i+=3)
		{
		testText[1] = (TText16) validPairs[i];
		testText[2] = (TText16) validPairs[i+1];
		param.iPosInText = 1;
		param.iPen.iX = param.iPen.iY = 0;
		r = iTestFont->GetCharacterPosition(param);
		TEST(r && param.iPosInText == 3
				&& param.iPen.iX == 10
				&& param.iOutputGlyphs == 1
				&& param.iOutput[0].iCode == validPairs[i+2]);
		}

	// 2: Test unpaired high surrogate chars
	testText[1] = 0xD809;
	testText[2] = 'a';
	param.iPosInText = 1;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 2
		   && param.iPen.iX == 0
		   && param.iOutputGlyphs == 0);

	// 3: Test unpaired low surrogate chars
	testText[1] = 'a';
	testText[2] = 0xDC09;
	param.iPosInText = 2;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 3
		   && param.iPen.iX == 0
		   && param.iOutputGlyphs == 0);

	// 4: Test latin/surrogate boundry ensuring surrogate not skipped!
	testText[1] = (TText16) validPairs[0];
	testText[2] = (TText16) validPairs[1];
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 1
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode =='a');
	}


/**
@SYMTestCaseID TI18N-GDI-CIT-4077
@SYMTestCaseDesc Automated GDI testing for GB18030 ExtB
@SYMTestPriority High
@SYMTestActions  Attempt to get glyph information for GB18030 ExtB characters.
@SYMTestExpectedResults The expected glyph clusters for given Unicode charactors must be returned
@SYMPREQ 2471: UTF-16 compliant text handling
*/
void CTGlyphSelection::TestNonBmpCharsInGB18030(CFbsFont* aFont)
	{
	INFO_PRINTF1(_L("Test GB18030 non-BMP Glyphs"));	
	// Do the testing
	
	TBool r;
	TBuf<30> testText(0);
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	testText.SetLength(4);
	
	// 201AD = D840, DDAD
	testText[0] = 0xD840;
	testText[1] = 0xDDAD;
	
	// 253BB = D854, DFBB
	testText[2] = 0xD854;
	testText[3] = 0xDFBB;
		
	param.iText.Set(testText);
	
	RShapeInfo aShapeInfo;

	// Do the testing
	
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param, aShapeInfo);

	TEST(r && param.iPosInText == 2 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x000201AD);

	INFO_PRINTF5(_L("The result of this shaping is %d %d %d 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);

	param.iPosInText = 2;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param, aShapeInfo);

	TEST(r && param.iPosInText == 4 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x000253BB);

	
	INFO_PRINTF5(_L("The result of this shaping is %d %d %d 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	// Close aShapeInfo which releases any memory it is occupying
	if (aShapeInfo.IsOpen())
		aShapeInfo.Close();
		   
	}


void CTGlyphSelection::TestCombiningLatinChars()
/**
 This method is a test case to test GetCharacterPosition() correctly
 processes regular latin characters with diacritics.
*/
	{
	TBool r;
	TBuf<20> testText(0);
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	testText.SetLength(10);
	testText[0] = 'A';
	testText[1] = ' ';
	testText[2] = 'A';
	testText[3] = 0x0300; // Above Grave Acent
	testText[4] = 'I';
	testText[5] = 0x0330; // Below Tidle 
	testText[6] = 'o';
	testText[7] = 0x0308; // Above Diaeresis
	testText[8] = 0x032F; // Below Inverted Breve
	testText[9] = 'M';
	param.iText.Set(testText);

	// 1: Latin base with following space
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 1 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 'A');

	// 2: Latin base with 1 combining above diacritic
	param.iPosInText = 2;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	// Will Compose A (0x41) followed by grave accent (0x300) into A grave (0xC0)
	TEST(r && param.iPosInText == 4 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0xC0
		   && param.iOutput[0].iBounds.iTl == TPoint(0,-10)
		   && param.iOutput[0].iBounds.iBr == TPoint(10,2));

	// 3: Latin base with 1 combining below diacritic
	param.iPosInText = 4;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	// Will compose I (0x49) with tilde below (0x330) into I with tilde below (0x1E2C)
	TEST(r && param.iPosInText == 6 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x1E2C
		   && param.iOutput[0].iBounds.iTl == TPoint(0,-10)
		   && param.iOutput[0].iBounds.iBr == TPoint(10,2));

	// 4: Latin base with 2 combining diacritic
	param.iPosInText = 6;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 9 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 3
		   && param.iOutput[0].iCode == 'o'
		   && param.iOutput[0].iBounds.iTl == TPoint(0,-10)
		   && param.iOutput[0].iBounds.iBr == TPoint(10,2)
		   && param.iOutput[1].iCode == 0x0308
		   && param.iOutput[1].iBounds.iTl == TPoint(0,-23)
		   && param.iOutput[1].iBounds.iBr == TPoint(10,-11)
		   && param.iOutput[2].iCode == 0x032F
		   && param.iOutput[2].iBounds.iTl == TPoint(0,3)
		   && param.iOutput[2].iBounds.iBr == TPoint(10,15));

	// 5: Latin base with 9 combining chars, should exceed max output!
	testText[0] = 'a';
	testText[1] = 0x0300; // Above Grave Acent
	testText[2] = 0x0330; // Below Tidle 
	testText[3] = 0x0308; // Above Diaeresis
	testText[4] = 0x032F; // Below Inverted Breve
	testText[5] = 0x0300; // Above Grave Acent
	testText[6] = 0x0330; // Below Tidle 
	testText[7] = 0x0308; // Above Diaeresis
	testText[8] = 0x032F; // Below Inverted Breve
	testText[9] = 0x0300; // Above Grave Acent
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 8 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 8
		   && param.iOutput[0].iCode == 'a'
		   && param.iOutput[7].iCode == 0x0308);
	}

/* 
Used for cleanup of RImplInfoArray implementationArray below 
This method is stolen from FbsTop.cpp
*/

LOCAL_C void ResetAndDestroyRImplInfoPtrArray(TAny* aPtr)
	{
	RImplInfoPtrArray* array = reinterpret_cast <RImplInfoPtrArray*> (aPtr);
	array->ResetAndDestroy();
	}
	
LOCAL_C void LoadOpenFontLibraries(CFontStore* aFontStore)
	{

	RImplInfoPtrArray implementationArray;
	TCleanupItem cleanup(ResetAndDestroyRImplInfoPtrArray, &implementationArray);
	CleanupStack::PushL(cleanup);
	TInt error;
	TInt ecomerror;
	TInt ecomnotready;
	TUid uid = {KUidOpenFontRasterizerPlunginInterface};

	// Making sure that no race situation arises
	// If ECom is not ready, give it another chance and try again. if it still doesn't work 
	// after the third try, then it just carries on quietly and fails... 
	for (ecomnotready =0; ecomnotready <3; ecomnotready++)
		{
		TRAP(ecomerror,REComSession::ListImplementationsL(uid,implementationArray));
		if (!ecomerror)
			{
			break;
			}
		else
			{
			ecomerror = 0; 	
			User::After(0);
			}
		}

	const TInt availCount = implementationArray.Count();
	for (TInt count=0;count<availCount;++count)
		{
		const CImplementationInformation* info = implementationArray[count];
		TUid rasterizerUid = info->ImplementationUid();
 		// Create a rasterizer
 		COpenFontRasterizer* rasterizer=0;
 		TRAP(error,rasterizer = COpenFontRasterizer::NewL(rasterizerUid));
 		if (!error)
   			{
   			// Install it in the font store.
   			TRAP(error,aFontStore->InstallRasterizerL(rasterizer));
   			if (error)
   				delete rasterizer;
   			}
		}
	CleanupStack::PopAndDestroy(&implementationArray); 

	}
	
void CTGlyphSelection::TestIsolatedCombiningLatinChars()
/**
 This method is a test case to test GetCharacterPosition() correctly
 processes isloated combining marks.
*/
	{
	// Need to use a valid font so that GetCharacterPosition will be able to find the necessary glyph information.
	_LIT16(KTestFontFile, "C:\\s60ssb_v500.ttf");
	_LIT16(KTestFontFaceName, "Series 60 Sans");
	
	// create a font store for testing
	CFontStore* fontStore = CFontStore::NewL(&User::Heap());
	//load all ecom implemented rasterizer dlls. installs the rasterizer.	
	LoadOpenFontLibraries(fontStore);
	// test font preparation
	fontStore->iKPixelWidthInTwips = 11860; //This value is default
	//add any required font files
	TUid err = fontStore->AddFileL(KTestFontFile);
	TFontSpec testFontSpec(KTestFontFaceName,200); 
	 
	CFbsBitmap* bmp = new(ELeave) CFbsBitmap;
	
	TInt ret = bmp->Create(TSize(100,100),EGray2);
	if (ret == KErrNotSupported)
		return;
	else
		User::LeaveIfError(ret);

	CFbsBitmapDevice* device = NULL;
	TRAPD(err2,device = CFbsBitmapDevice::NewL(bmp));
	TEST(err2 == KErrNone);

	CFbsBitGc* gc = NULL;
	User::LeaveIfError(device->CreateContext(gc));
	// Font file Creation
	CFbsFont* testFont = NULL;
	User::LeaveIfError(device->GetNearestFontToDesignHeightInTwips(testFont,testFontSpec));
	gc->UseFont(testFont);
	CleanupStack::PushL(testFont);
	
	// Now start the test case:
	
	TBool r;
	TBuf<20> testText(0);
	CFont::TPositionParam param;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;
	
	testText.SetLength(7);
	testText[0] = 0x0323; 	//Below Dot
	testText[1] = ' ';
	testText[2] = 0x0300;   //Above Grave Acent
	testText[3] = ' ';
	testText[4] = 0x0323;	//Below Dot
	testText[5] = 0x0300;	//Above Grave Acent
	testText[6] = 0x0301; 	//Above Acute Acent
	param.iText.Set(testText);
	
	// 1: Test the bounds for combining below mark in isolation
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = testFont->GetCharacterPosition(param);

	TEST(r && param.iPosInText == 1 
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x0323);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen == TPoint(0,0)
		   && param.iOutput[0].iBounds.iTl == TPoint(-6,1)
		   && param.iOutput[0].iBounds.iBr == TPoint(-4,3));
	#endif
	
	// 2: Test the bounds for combining above mark in isolation
	param.iPosInText = 1;
	param.iPen.iX = param.iPen.iY = 0;
	r = testFont->GetCharacterPosition(param);

	TEST(r && param.iPosInText == 3
		   && param.iOutputGlyphs == 2 
		   && param.iOutput[1].iCode == 0x0300);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen == TPoint(4,0) 
		   && param.iOutput[1].iBounds.iTl == TPoint(-2,-15)
		   && param.iOutput[1].iBounds.iBr == TPoint(2,-12));
	#endif
		
	// 3: Test the bounds for multiple combing marks in isolation
	param.iPosInText = 3;
	param.iPen.iX = param.iPen.iY = 0;
	r = testFont->GetCharacterPosition(param);

	TEST(r && param.iPosInText == 7 
		   && param.iOutputGlyphs == 4
		   && param.iOutput[1].iCode == 0x0323
		   && param.iOutput[2].iCode == 0x0300
		   && param.iOutput[3].iCode == 0x0301);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen == TPoint(4,0)
		   && param.iOutput[1].iBounds.iTl == TPoint(-1,1)
		   && param.iOutput[1].iBounds.iBr == TPoint(1,3)
           && param.iOutput[2].iBounds.iTl == TPoint(-2,-16)
           && param.iOutput[2].iBounds.iBr == TPoint(2,-13)
           && param.iOutput[3].iBounds.iTl == TPoint(-2,-20)
           && param.iOutput[3].iBounds.iBr == TPoint(2,-17));
	#endif
	
	// Done with the font, pop it off.
	CleanupStack::Pop(testFont);
	
	//Cleaning the memory
	delete bmp;
	delete device;
	delete gc;
	fontStore->RemoveFile(err);
	delete fontStore;
	REComSession::FinalClose();
	}


void CTGlyphSelection::TestContextInShapeInfo()
/**
 This method is a test case to test GetCharacterPosition2() correctly
 handle context.
*/
	{
	TBool r;
	TBuf<20> testText(0);
	CFont::TPositionParam param;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;
	RShapeInfo shapeInfo;
	
	//test control characters which has not defined processFun in TTableEntry
	testText.SetLength(7);
	testText[0] = 0xffff; 	//control character, test for the range { 0xFFFE,   0xFFFF,   0}
	testText[1] = '1';
	testText[2] = 0x200E;   //control character, test for the range { 0x200C,   0x200F,   0}
	testText[3] = '.';  
	testText[4] = 'a';
	testText[5] = 0x202A;   //control character, test for the range { 0x202A,   0x202E,   0}
	testText[6] = ',';
		
	param.iText.Set(testText);
	
	// 1. Test '0xffff' as NULL context at position zero - 
	// 0xffff should not be taken as context, and character '1' can be rendered correctly 
	param.iPosInText = 1;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition2(param, shapeInfo);
	TEST(r && param.iPosInText == 2 
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 49);
	
	// 2. Test '0x200E' - 0x200E is not rendered, either not treated as context.
	// character '.' and 'a' should be rendered correctly.
	param.iPosInText = 2;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition2(param, shapeInfo);
	TEST(r && param.iPosInText == 3 
		   && param.iOutputGlyphs == 0);
			
	param.iPosInText = 3;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition2(param, shapeInfo);
	TEST(r && param.iPosInText == 4 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 46);

	param.iPosInText = 4;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition2(param, shapeInfo);
	TEST(r && param.iPosInText == 5 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 'a');
	
	// 3. Test '0x202A' - 0x202A is not rendered, either not treated as context.
	// character ',' should be rendered correctly. 
	param.iPosInText = 5;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition2(param, shapeInfo);
	TEST(r && param.iPosInText == 6 
		   && param.iOutputGlyphs == 0);
	
	param.iPosInText = 6;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition2(param, shapeInfo);
	TEST(r && param.iPosInText == 7 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 44);
	}

/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-1580
@SYMTestCaseDesc Automated GDI testing for Hindi
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid and invalid Hindi glyph clusters.
@SYMTestExpectedResults The expected glyph clusters for given Unicode charactors must be returned
@SYMPREQ 18: Hindi for Bravo
*/
void CTGlyphSelection::TestHindiChars(CFbsFont* aFont)
	{
	INFO_PRINTF1(_L("Test Hindi Glyphs"));	
	// Do the testing
	
	TBool r;
	TBuf<30> testText(0);
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	testText.SetLength(30);
	
	testText[0] = 0x0930;
	testText[1] = 0x093C;
	testText[2] = 0x094D;
	testText[3] = 0x0915;
	
	testText[4] = 0x0915;
	testText[5] = 0x094D;
	testText[6] = 0x0915;
	
	testText[7] = 0x0930;
	testText[8] = 0x094D;
	testText[9] = 0x0915;
	
	testText[10] = 0x0915;
	testText[11] = 0x094D;
	testText[12] = 0x0930;
	
	testText[13] = 0x0915;
	testText[14] = 0x094D;
	testText[15] = 0x0937;
	
	testText[16] = 0x0915;
	testText[17] = 0x094D;
	testText[18] = 0x0930;
	testText[19] = 0x094D;
	testText[20] = 0x092A;
	
	/*	When the following character 0x0036 is shaped, the context will be taken into consideration when
		determining the glyph for 0x0036 
		The context for 0x0036 is the Devanagari character 0x092A at position (iPosInText) 20
	**/
	testText[21] = 0x0036;
	testText[22] = 0x094D;
	
	testText[23] = 0x0020;
	
	// INC101103: Strings containing ZWJ do not get rendered properly for Hindi 
	testText[24] = 0x092E;
	testText[25] = 0x094D;
	testText[26] = 0x200D;
	testText[27] = 0x092E; 
	testText[28] = 0x093F;
	testText[29] = 0x200D;
		
	param.iText.Set(testText);
	
	RShapeInfo aShapeInfo;

	// Do the testing
	
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param, aShapeInfo);

	TEST(r && param.iPosInText == 4 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000108
		   && param.iOutput[1].iCode == 0x80000072);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 17);
	#endif
	
	INFO_PRINTF6(_L("The result of this shaping is %d %d %d 0x%x 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);

	param.iPosInText = 4;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param, aShapeInfo);

	TEST(r && param.iPosInText == 7 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x800001C2);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping is %d %d %d 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 7;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param, aShapeInfo);

	TEST(r && param.iPosInText == 10 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000072
		   && param.iOutput[1].iCode == 0x80000130);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 11);
	#endif
	
	INFO_PRINTF6(_L("The result of this shaping is %d %d %d 0x%x 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 10;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param, aShapeInfo);

	TEST(r && param.iPosInText == 13 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000136);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping is %d %d %d 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 13;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param, aShapeInfo);

	TEST(r && param.iPosInText == 16 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x800001BE);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping is %d %d %d 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);

	param.iPosInText = 16;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param, aShapeInfo);

	TEST(r && param.iPosInText == 21 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x8000017A
		   && param.iOutput[1].iCode == 0x80000087);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 18);
	#endif
	
	INFO_PRINTF6(_L("The result of this shaping is %d %d %d 0x%x 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);

	/*	The following shaping will consider the context when determining the glyph for 0x0036 Digit character 
		The context for 0x0036 is the Devanagari character 0x092A at position (iPosInText) 20
	**/
	param.iPosInText = 21;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param, aShapeInfo);

	TEST(r && param.iPosInText == 22 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000016);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 9);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping is %d %d %d 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);

	// INC101103: Strings containing ZWJ do not get rendered properly for Hindi 
	param.iPosInText = 24;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param, aShapeInfo);
	// We are mainly testing the position in text after rendering, which should be at the end of the syllable
	// that should include the ZWJ and any consonant that follows it
	TEST(r && param.iPosInText == 29 
		   && param.iOutputGlyphs == 3
		   && param.iOutput[0].iCode == 0x80000272
		   && param.iOutput[1].iCode == 0x80000105
		   && param.iOutput[2].iCode == 0x8000008B);
		   
	// Close aShapeInfo which releases any memory it is occupying
	if (aShapeInfo.IsOpen())
		aShapeInfo.Close();
		   
	}
	
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-3381
@SYMTestCaseDesc Automated GDI testing for Kannada
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid and invalid Kannada glyph clusters.
@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 19: Kannada for Ogmha
*/
	
void CTGlyphSelection::TestKannadaChars(CFbsFont* aFont)
	{
INFO_PRINTF1(_L("Test Kannada Glyphs"));
	
	TBuf<79> testText(0);
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	testText.SetLength(79);
	//Testdata for kannada Langauage
	
	testText[0] = 0x0C95;
	testText[1] = 0x0CCD;
	testText[2] = 0x0020; 
	
	testText[3] = 0x0CAF;
	testText[4] = 0x0CCD;
	testText[5] = 0x0020;
	
	testText[6] = 0x0C99;
	testText[7] = 0x0CCD;
	testText[8] = 0x0020;
	
	testText[9] = 0x0CA3;
	testText[10] = 0x0CCD;
	testText[11] = 0x0020;
	
	testText[12] = 0x0C95;
	testText[13] = 0x0CC3;
	
	testText[14] = 0x0CA4;
	testText[15] = 0x0CC6;
	
	testText[16] = 0x0C9D;
	testText[17] = 0x0CBE;
	
	testText[18] = 0x0C9E;
	testText[19] = 0x0CBE;
	
	testText[20] = 0x0CA3;
	testText[21] = 0x0CBE;
	
	testText[22] = 0x0CB3;
	testText[23] = 0x0CC6;
	
	testText[24] = 0x0C9D;
	testText[25] = 0x0CC6;
	
	testText[26] = 0x0CAC;
	testText[27] = 0x0CC6;
	
	testText[28] = 0x0C9F;
	testText[29] = 0x0CC6;
	
	testText[30] = 0x0C99;
	testText[31] = 0x0CC6;
	
	testText[32] = 0x0CA3;
	testText[33] = 0x0CC6;
	
	testText[34] = 0x0C95;
	testText[35] = 0x0CBF;
	
	testText[36] = 0x0CB8;
	testText[37] = 0x0CBF;
	
	testText[38] = 0x0CA1;
	testText[39] = 0x0CBF;
	
	testText[40] = 0x0CA6;
	testText[41] = 0x0CBF;
	
	testText[42] = 0x0C9D;
	testText[43] = 0x0CBF;
	
	testText[44] = 0x0C9D;
	testText[45] = 0x0CC1;
	
	testText[46] = 0x0CB5;
	testText[47] = 0x0CC1;
	
	testText[48] = 0x0C95;
	testText[49] = 0x0CC2;
	
	testText[50] = 0x0CAA;
	testText[51] = 0x0CC2;
	
	testText[52] = 0x0CAE;
	testText[53] = 0x0CCC;
	
	testText[54] = 0x0C95;
	
	testText[55] = 0x0CB0;
	testText[56] = 0x200D;
	testText[57] = 0x0CCD;
	testText[58] = 0x0CAE;
	
	testText[59] = 0x0020;
	
	testText[60] = 0x0CB0;
	testText[61] = 0x200D;
	testText[62] = 0x0CCD;
	testText[63] = 0x0CB0;
	testText[64] = 0x200D;
	testText[65] = 0x0CCD;
	
	
	testText[66] = 0x0CB0;
	testText[67] = 0x200D;
	testText[68] = 0x0CCD;
	testText[69] = 0x0CB0;
	testText[70] = 0x0CCD;
	testText[71] = 0x0CB0;
	testText[72] = 0x0CCD;
	testText[73] = 0x0CB0;
	testText[74] = 0x0CCD;
	testText[75] = 0x0CB0;
	
	// DEF103276: Kannada rendering: IcuLayoutEngine does not recongnise 0X0C8E as a vowel
	testText[76] = 0x0020;
	testText[77] = 0x0C8E;
	testText[78] = 0x0C82;
	// End of DEF103276: Kannada rendering: IcuLayoutEngine does not recongnise 0X0C8E as a vowel

	param.iText.Set(testText);

	// Do the testing
	
	TBool r;
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	RShapeInfo shapeInfo;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==2 
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x80000839);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 16);
	#endif
	
	INFO_PRINTF5(_L("The values of this shaping of Ka + Virama are iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
    
	param.iPosInText = 3;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 5
		   && param.iOutputGlyphs ==1
		   && param.iOutput[0].iCode == 0x80000852 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 27);
	#endif
	
	INFO_PRINTF5(_L("The values of this shaping Ya + Virama are iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 6;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 8
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode ==0x8000083D);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 19);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for Nya + Virama iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 9;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 11
		   && param.iOutputGlyphs ==1 
		   && param.iOutput[0].iCode == 0x80000847);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 20);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for NNA + Virama iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 12;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 14
		   && param.iOutputGlyphs == 2 
		   && param.iOutput[0].iCode == 0x800007A8
		   && param.iOutput[1].iCode == 0x800007D2);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif

	INFO_PRINTF6(_L("The result of this shaping for Ka + Matra Vocalic R iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);

	param.iPosInText = 14;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 16
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x8000088f);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 11);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for Ta + Matra AA iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);

	param.iPosInText = 16;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 18
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x8000081E 
		   && param.iOutput[1].iCode == 0x800007CD);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 29);
	#endif
	
	INFO_PRINTF6(_L("The result of this shaping  for Jha + Matra AA iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 18;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 20
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800007b1
		   && param.iOutput[1].iCode == 0x800007cd);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 23);
	#endif
	
	INFO_PRINTF6(_L("The result of this shaping for Nya + Matra AA iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	
	param.iPosInText = 20;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 22
		   && param.iOutputGlyphs == 2 
		   && param.iOutput[0].iCode == 0x80000823
		   && param.iOutput[1].iCode == 0x800007CD );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 21);
	#endif
	    
	INFO_PRINTF6(_L("The result of this shaping for Nna + Matra AA iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 22;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 24
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x8000089C);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for  LLa + Matra E iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 24;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 26
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x80000889);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 22);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for Jha + Matra E iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	 
	 param.iPosInText = 26;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 28
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000896 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for Ba + Matra E iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 28;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 30
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x8000088a);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for Tta + Matra E iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 30;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 32
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800007ac
		   && param.iOutput[1].iCode == 0x800007d4 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 19);
	#endif
	
	INFO_PRINTF6(_L("The result of this shaping for Nya + Matra E iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 32;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 34
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x8000088e);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 14);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for Nna + Matra E iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 34;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 36
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000860 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif
		
	INFO_PRINTF5(_L("The result of this shaping for Ka + Matra I iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 36;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 38
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x8000087e );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 11);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for Sa + Matra I iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 38;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 40
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x8000086a);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for Dda + Matra I iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 40;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 42
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x8000086f);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for Va + Matra I iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 42;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 44
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x80000867 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 22);
	#endif
	
	INFO_PRINTF5(_L("The result of this shaping for Jha + Matra I iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 44;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 46
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800007b0 
		   && param.iOutput[1].iCode == 0x800007d0);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 28);
	#endif
	
	INFO_PRINTF6(_L("The result of this shaping for Jha + Matra U iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 46;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 48
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800007c6
		   && param.iOutput[1].iCode == 0x800007d0);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 18);
	#endif
	
	INFO_PRINTF6(_L("The result of this shaping for Va + Matra U iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);


	param.iPosInText = 48;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 50
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800007a8
		   && param.iOutput[1].iCode == 0x800007d1 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 20);
	#endif
	
	INFO_PRINTF6(_L("The result of this shaping for Ka Matra UU iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode,param.iOutput[1].iCode);	

	param.iPosInText = 50;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 52 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800007bc
		   && param.iOutput[1].iCode == 0x800008a5);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 21);
	#endif
	
	INFO_PRINTF6(_L("The result of this shaping for Pa + Matra UU iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);	
	
	
	param.iPosInText = 52;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 54 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x8000082d  
		   && param.iOutput[1].iCode == 0x800007d9);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 26);
	#endif

	INFO_PRINTF6(_L("The result of this shaping for Ma + Matra UU iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);	
		
	param.iPosInText = 55;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 59 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800007c2 
		   && param.iOutput[1].iCode == 0x80000809);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 17);
	#endif
	
	INFO_PRINTF6(_L("The result of this shaping for Ma + Matra UU iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);	
			
	param.iPosInText = 60;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	TEST(r && param.iPosInText == 64 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800007c2 
		   && param.iOutput[1].iCode == 0x8000080b);
	INFO_PRINTF6(_L("Results are iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x "), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);	
			
	param.iPosInText = 66;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	TEST(r && param.iPosInText == 75 
		   && param.iOutputGlyphs == 5
		   && param.iOutput[0].iCode == 0x800007c2 
		   && param.iOutput[1].iCode == 0x8000080b
		   && param.iOutput[2].iCode == 0x800008db
		   && param.iOutput[3].iCode == 0x800008db
		   && param.iOutput[4].iCode == 0x800007da);
	INFO_PRINTF7(_L("Results are iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode);
	
	// DEF103276: Kannada rendering: IcuLayoutEngine does not recongnise 0X0C8E as a vowel
	param.iPosInText = 77;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	TEST(r && param.iPosInText == 79 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800007A2
		   && param.iOutput[1].iCode == 0x80000798);

	INFO_PRINTF5(_L("DEF103276 Vowel E + Anusvara: iPosInText=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);	
	//End of DEF103276: Kannada rendering: IcuLayoutEngine does not recongnise 0X0C8E as a vowel
			
	}
	
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-3360
@SYMTestCaseDesc Automated GDI testing for Marathi
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid and invalid Marathi glyph clusters.
@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 19: Marathi for Ogmha
*/

void CTGlyphSelection::TestMarathiChars(CFbsFont* aFont)
	{
	INFO_PRINTF1(_L("Test Marathi Glyphs"));	
	
	TBool r;
	TBuf<47> testText(0);
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	testText.SetLength(47);
	
	//Testdata
	testText[0] = 0x0905; 
	testText[1] = 0x0945;
	
	testText[2] = 0x0931;
	testText[3] = 0x094D;
	testText[4] = 0x0915;
	
	testText[5] = 0x0930;
	testText[6] = 0x094D;
	testText[7] = 0x200D;
	testText[8] = 0x0915;
	
	testText[9] = 0x0905;
	testText[10] = 0x200D;
	testText[11] = 0x0945;
	
	testText[12] = 0x0909;
	testText[13] = 0x0945;
	
	testText[14] = 0x0915;
	testText[15] = 0x200D;
	testText[16] = 0x0945;
	
	// DEF102132: Marathi - Certain sequence of characters does not work correctly
	testText[17] = 0x0905;
	testText[18] = 0x0945;
	testText[19] = 0x0901;
	
	testText[20] = 0x0905;
	testText[21] = 0x200D;
	testText[22] = 0x0945;
	testText[23] = 0x0901;
	// End of DEF102132: Marathi - Certain sequence of characters does not work correctly

	
	// DEF102858: Marathi - State table does not allow explicit half forms followed by modifiers
	testText[24] = 0x0020;
	
	testText[25] = 0x0930;
	testText[26] = 0x094D;
	testText[27] = 0x200D;
	testText[28] = 0x0901;
	// End of DEF102858: Marathi - State table does not allow explicit half forms followed by modifiers
	
	// INC104705  Marathi input: Incorrect movement of cursor with eyelash ra forming ligature. 
	testText[29] = 0x0020;
	
	testText[30] = 0x0930; 
	testText[31] = 0x094D;
	testText[32] = 0x200D;
	testText[33] = 0x0930; 
	testText[34] = 0x094D;
	testText[35] = 0x200D;
	testText[36] = 0x0930; 
	testText[37] = 0x094D;
	testText[38] = 0x200D;
	testText[39] = 0x0930; 
	testText[40] = 0x094D;
	testText[41] = 0x200D;
	testText[42] = 0x0930; 
	testText[43] = 0x094D;
	testText[44] = 0x200D;
	// End of INC104705  Marathi input: Incorrect movement of cursor with eyelash ra forming ligature. 

	// INC116507: Halant get attached with an independent vowel.
	testText[45] = 0x0905;
	testText[46] = 0x094D;
	// End of INC116507: Halant get attached with an independent vowel.
	
	//To Do
	
	param.iText.Set(testText); 
	
	// Test CANDRA A: Independent Vowel A + CANDRA E
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	RShapeInfo shapeInfo;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 2 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000528 
		   && param.iOutput[1].iCode == 0x80000566);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF6(_L("The result of shaping CANDRA A is %d %d %d 0x%x 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);

	
	// Test Eyelash RA post Unicode 3.0: RRA + VIRAMA + CONSONANT
	param.iPosInText = 2 ;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 5 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800005d3
		   && param.iOutput[1].iCode == 0x80000538);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 18);
	#endif
	
	INFO_PRINTF6(_L("The result of shaping post Unicode 3.0 Eyelash RA is %d %d %d 0x%x 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	// Test Eyelash RA pre Unicode 3.0: RA + VIRAMA + ZWJ + CONSONANT
	param.iPosInText = 5;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 9 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800005d3
		   && param.iOutput[1].iCode == 0x80000538);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 18);
	#endif
	
	INFO_PRINTF6(_L("The result of shaping pre Unicode 3.0 Eyelash RA is %d %d %d 0x%x 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	// Test second form of CANDRA A: Independent Vowel A + ZWJ + CANDRA E
	param.iPosInText = 9;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 12 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000528
		   && param.iOutput[1].iCode == 0x80000566 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF6(_L("The result of shaping second form of CANDRA A is %d %d %d 0x%x 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	// Test that CANDRA E does not join with any other independent vowel
	param.iPosInText = 12;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 13 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x8000052c);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 9);
	#endif

	INFO_PRINTF5(_L("The result of shaping any other Independent Vowel + CANDRA E is %d %d %d 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	// Test that the second form of CANDRA A (i.e. using ZWJ) doesn't work for CONSONANTS (illegal)
	param.iPosInText = 14;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 15 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000538);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 11);
	#endif
	
	INFO_PRINTF5(_L("The result of shaping CONSONANT + ZWJ + CANDRA E is %d %d %d 0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	// DEF102132: Marathi - Certain sequence of characters does not work correctly
	param.iPosInText = 17;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 20 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000528
		   && param.iOutput[1].iCode == 0x8000069d);

	
	INFO_PRINTF5(_L("DEF102132 Independent Vowel A + CANDRA E + Vowel Modifier %d %d 0x%x 0x%x"), param.iPosInText, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 20;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 23 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000528
		   && param.iOutput[1].iCode == 0x8000069d);
	
	INFO_PRINTF5(_L("DEF102132 Independent Vowel A + ZWJ + CANDRA E + Vowel Modifier %d %d 0x%x 0x%x"), param.iPosInText, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
  	// End of DEF102132: Marathi - Certain sequence of characters does not work correctly
  	
	// DEF102858: Marathi - State table does not allow explicit half forms followed by modifiers
	param.iPosInText = 25;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	TEST(r && param.iPosInText == 29 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800005D3
		   && param.iOutput[1].iCode == 0x80000524);
	
	INFO_PRINTF5(_L("DEF102858 Ra + Virama + ZWJ + Modifier %d %d 0x%x 0x%x"), param.iPosInText, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	// End of DEF102858: Marathi - State table does not allow explicit half forms followed by modifiers
	
	// INC104705  Marathi input: Incorrect movement of cursor with eyelash ra forming ligature. 
	param.iPosInText = 30;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	TEST(r && param.iPosInText == 42 
		   && param.iOutputGlyphs == 5
		   && param.iOutput[0].iCode == 0x800005D3
		   && param.iOutput[1].iCode == 0x800005D3
		   && param.iOutput[2].iCode == 0x800005B8
		   && param.iOutput[3].iCode == 0x80000553
		   && param.iOutput[4].iCode == 0x8000056E);
	#if defined __WINS__ || defined __WINSCW__
	TEST(param.iPen.iX == 20);
	#endif
	
	INFO_PRINTF7(_L("INC104705 Ra + Virama + ZWJ + Ra + Virama + ZWJ + Ra + Virama + ZWJ + Ra + Virama + ZWJ + Ra + Virama + ZWJ  %d %d 0x%x 0x%x 0x%x 0x%x"), param.iPosInText, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode, param.iOutput[3].iCode);
	// End of INC104705  Marathi input: Incorrect movement of cursor with eyelash ra forming ligature. 
	
	// INC116507: Halant get attached with an independent vowel.
	param.iPosInText = 45;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 47 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x8000058F
		   && param.iOutput[1].iCode == 0x8000056E);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 21);
	#endif

	INFO_PRINTF6(_L("INC116507: Independent Vowel A + Halant  %d %d %d 0x%x 0x%x"), param.iPosInText, param.iOutputGlyphs, param.iPen.iX, param.iOutput[0].iCode, param.iOutput[1].iCode);
	// End of INC116507: Halant get attached with an independent vowel.

	}
	
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-3417
@SYMTestCaseDesc Automated GDI testing for Gujarati
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid and invalid gujarati glyph clusters.
@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 19: Gujarati for Ogmha
*/
	
	
void CTGlyphSelection::TestGujaratiChars(CFbsFont* aFont)
	{
	INFO_PRINTF1(_L("Test Gujarati Glyphs"));
	
	// Do the testing
	
	TBool r;
	TBuf<162> testText(0);
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	testText.SetLength(162);
	//Testdata for gujarati Langauage
	
	testText[0] = 0x0AAC;
	testText[1] = 0x0ACD;
	testText[2] = 0x200D;
	testText[3] = 0x0020;
	
	testText[4] = 0x0A96;
	testText[5] = 0x0ACD;
	testText[6] = 0x0A97;
	testText[7] = 0x0ACD;
	testText[8] = 0x0A98;
	testText[9] = 0x0ACD;
	testText[10] = 0x0A9A;
	
	testText[11] = 0x0A95;
	testText[12] = 0x0ACD;
	testText[13] = 0x0A9C;	
	testText[14] = 0x200D;
	testText[15] = 0x0020;

	testText[16] = 0x0A99;
	testText[17] = 0x0ACD;
	testText[18] = 0x0A9B;
	testText[19] = 0x0ACD;
	testText[20] = 0x0A9F;
	testText[21] = 0x0ACD;
	testText[22] = 0x0AA0;
	
	//Requirement (GUJ003)
	
	testText[23] = 0x0A95;
	testText[24] = 0x0ACD;
	testText[25] = 0x0AB7;
	
	
	testText[26] = 0x0A95;
	testText[27] = 0x0ACD;
	testText[28] = 0x0AB7;
	testText[29] = 0x0ACD;
	testText[30] = 0x0AA4;
	
	testText[31] = 0x0A9C;
	testText[32] = 0x0ACD;
	testText[33] = 0x0AB7;
	testText[34] = 0x0ACD;
	testText[35] = 0x0AA4;
	
	testText[36] = 0x0A9C;
	testText[37] = 0x0ACD;
	testText[38] = 0x0A9E;
	testText[39] = 0x0ACD;
	testText[40] = 0x0AA4;
	
	//Requirement (GUJ 005)
	
	testText[41] = 0x0AB0;
	testText[42] = 0x0ACD;
	testText[43] = 0x0A95;
	
	testText[44] = 0x0AB0;
	testText[45] = 0x0ACD;
	testText[46] = 0x0A95;
	testText[47] = 0x0AC9;
	
	testText[48] = 0x0AB0;
	testText[49] = 0x0ACD;
	testText[50] = 0x0A95;
	testText[51] = 0x0A82;
	
	testText[52] = 0x0AB0;
	testText[53] = 0x0ACD;
	testText[54] = 0x0A95;
	testText[55] = 0x0AC9;
	testText[56] = 0x0A82;
	testText[57] = 0x0020;
	
	//Requirement (GUJ 006)
	
	testText[58] = 0x0A97;
	testText[59] = 0x0ACD;
	testText[60] = 0x0AB0;
	
	testText[61] = 0x0A9A;
	testText[62] = 0x0ACD;
	testText[63] = 0x0AB0;
	
	testText[64] = 0x0A97;
	testText[65] = 0x0ACD;
	testText[66] = 0x0AB0;
	testText[67] = 0x0ACD;
	testText[68] = 0x0AA4;
	
	testText[69] = 0x0A9A;
	testText[70] = 0x0ACD;
	testText[71] = 0x0AB0;
	testText[72] = 0x0ACD;
	testText[73] = 0x0AA4;
	
	//Requirement (GUJ 007)
	
	testText[74] = 0x0A95;
	testText[75] = 0x0ACD;
	testText[76] = 0x0AB0;
	
	testText[77] = 0x0A9C;
	testText[78] = 0x0ACD;
	testText[79] = 0x0AB0;
	
	testText[80] = 0x0A95;
	testText[81] = 0x0ACD;
	testText[82] = 0x0AB0;
	testText[83] = 0x0ACD;
	testText[84] = 0x0AA4;
	
	testText[85] = 0x0A9C;
	testText[86] = 0x0ACD;
	testText[87] = 0x0AB0;
	testText[88] = 0x0ACD;
	testText[89] = 0x0AA4;
	
	//Requirement (GUJ 008)
	
	testText[90] = 0x0A9B;
	testText[91] = 0x0ACD;
	testText[92] = 0x0AB0;
	
	testText[93] = 0x0AAF;
	testText[94] = 0x0ACD;
	testText[95] = 0x0AB0;
	
	testText[96] = 0x0A9B;
	testText[97] = 0x0ACD;
	testText[98] = 0x0AB0;
	testText[99] = 0x0ACD;
	testText[100]= 0x0AA4;
	
	testText[101] = 0x0AAF;
	testText[102] = 0x0ACD;
	testText[103] = 0x0AB0;
	
	testText[104] = 0x0AAF;
	testText[105] = 0x0ACD;
	testText[106] = 0x0AB0;
	testText[107] = 0x0ACD;
	testText[108] = 0x0AA4;
	
	testText[109] = 0x0AB0;
	testText[110] = 0x0ACD;
	testText[111] = 0x0AB0;
	testText[112] = 0x0ACD;
	testText[113] = 0x0AB0;
	
	//Requirement (GUJ 009)
	
	testText[114] = 0x0A9F;
	testText[115] = 0x0ACD;
	testText[116] = 0x0AAF;
	
	testText[117] = 0x0A9B;
	testText[118] = 0x0ACD;
	testText[119] = 0x0AAF;
	
	testText[120] = 0x0AA2;
	testText[121] = 0x0ACD;
	testText[122] = 0x0AAF;
	
	testText[123] = 0x0A97;
	testText[124] = 0x0ACD;
	testText[125] = 0x0AAF;
	
	//Requirement (GUJ 010)
	
	testText[126] = 0x0A9F;
	testText[127] = 0x0ACD;
	testText[128] = 0x0AA0;
	
	testText[129] = 0x0AA6;
	testText[130] = 0x0ACD;
	testText[131] = 0x0AB5;
	
	testText[132] = 0x0A9F;
	testText[133] = 0x0ACD;
	testText[134] = 0x0AA0;
	testText[135] = 0x0ACD;
	testText[136] = 0x0AA4;
	
	
	testText[137] = 0x0AA6;
	testText[138] = 0x0ACD;
	testText[139] = 0x0AB5;
	testText[140] = 0x0ACD;
	testText[141] = 0x0AA4;
	
	//Requirement (GUJ 011)
	
	testText[142] = 0x0AB0;
	testText[143] = 0x0AC2;
	
	testText[144] = 0x0AB9;
	testText[145] = 0x0AC3;
	
	testText[146] = 0x0AA6;
	testText[147] = 0x0AC3;
	
	testText[148] = 0x0A9C;
	testText[149] = 0x0AC0;
	
	//Subscript ligutares
	
	
	testText[150] = 0x0A95;
	testText[151] = 0x0A81;
	
	testText[152] = 0x0A95;
	testText[153] = 0x0ABE;
	testText[154] = 0x0A81;
	
	testText[155] = 0x0A95;
	testText[156] = 0x0AC1;
	testText[157] = 0x0A81;
	
	testText[158] = 0x0A8D;
	testText[159] = 0x0A81;
	
	testText[160] = 0x0A88;
	testText[161] = 0x0A81;
	
	
	
	param.iText.Set(testText); 
				
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	RShapeInfo shapeInfo;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  3
		   && param.iOutputGlyphs == 1  
		   && param.iOutput[0].iCode == 0x800009ec);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 9);
	#endif
	
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 	4;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  11
		   && param.iOutputGlyphs ==  4
		   && param.iOutput[0].iCode == 0x800009d7
		   && param.iOutput[1].iCode == 0x800009d8
		   && param.iOutput[2].iCode == 0x800009d9
		   && param.iOutput[3].iCode == 0x80000967 );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 34);
	#endif

	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode);
	
	param.iPosInText = 11;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==	14  
		   && param.iOutputGlyphs == 2  
		   && param.iOutput[0].iCode == 0x800009d6
		   && param.iOutput[1].iCode == 0x80000969   );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 22);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 16;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  23
		   && param.iOutputGlyphs == 3 
		   && param.iOutput[0].iCode == 0x800009da
		   && param.iOutput[1].iCode == 0x800009dc
		   && param.iOutput[2].iCode == 0x80000aad);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 30);
	#endif
	
		
	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode);
	
	param.iPosInText = 	23;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 26
		   && param.iOutputGlyphs == 1  
		   && param.iOutput[0].iCode == 0x800009d2 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
		
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);

	
	param.iPosInText = 26;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 31
		   && param.iOutputGlyphs == 2  
		   && param.iOutput[0].iCode == 0x800009f8
		   && param.iOutput[1].iCode == 0x80000971);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 18);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 	31;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  36
		   && param.iOutputGlyphs == 3
		   && param.iOutput[0].iCode == 0x800009dd
		   && param.iOutput[1].iCode == 0x800009f5
		   && param.iOutput[2].iCode == 0x80000971);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 30);
	#endif
	
	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode);	
	
	param.iPosInText = 36;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 41
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800009f9
		   && param.iOutput[1].iCode == 0x80000971);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 17);
	#endif

	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 	41;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 44
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode ==  0x80000962
		   && param.iOutput[1].iCode == 0x800009d4);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 8);
	#endif
		
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 44;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 48 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000962
		   && param.iOutput[1].iCode == 0x80000ae1 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 48;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 52
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000962
		   && param.iOutput[1].iCode == 0x80000ae9);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 8);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 52;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 57  
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000962
		   && param.iOutput[1].iCode == 0x80000ae2);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif

	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 58;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  61
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode ==	0x80000a1e );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 11);
	#endif
		
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 	61;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  64
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000a21 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif

	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 64;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 69 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000a64
		   && param.iOutput[1].iCode == 0x80000971 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 17);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 	69;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 74
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000a67
		   && param.iOutput[1].iCode == 0x80000971);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 16);
	#endif
		
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 	74;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  77
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000a1c);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 8);
	#endif
		
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 	77;
	param.iPen.iX = param.iPen.iY = 0;
		
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  80
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000a23);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 15);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		
	param.iPosInText = 80;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 85
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000a62
		   && param.iOutput[1].iCode == 0x80000971);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 17);
	#endif
		
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 85;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  90
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000a69
		   && param.iOutput[1].iCode == 0x80000971);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 24);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText =90;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 93
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000a22 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 93;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 96
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000a35 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 96;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  101
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000a68 
		   && param.iOutput[1].iCode == 0x80000971);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 21);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 101;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 104
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000a35 );
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 104;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 109
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000a7b 
		   && param.iOutput[1].iCode == 0x80000971 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 16);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 109;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  114
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000a36
		   && param.iOutput[1].iCode == 0x800009d4 );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 7);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 114;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  117
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000aae);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 17);
	#endif
		
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 117;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  120
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000aab );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 21);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 120;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  123
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000ab5 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 18);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 123;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  126
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x800009d8
		   && param.iOutput[1].iCode == 0x8000097b);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 17);
	#endif

	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 126;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  129
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000aad);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 9);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		
	param.iPosInText = 129;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  132
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000ac0 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif
		
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText =132;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText ==  137
		   && param.iOutputGlyphs == 3
		   && param.iOutput[0].iCode == 0x800009e0
		   && param.iOutput[1].iCode == 0x800009e1
		   && param.iOutput[2].iCode == 0x80000971);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 26);
	#endif
	
	
	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode);	
	
	param.iPosInText = 137;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 142 
		   && param.iOutputGlyphs == 3
		   && param.iOutput[0].iCode == 0x800009e7 
		   && param.iOutput[1].iCode == 0x800009f3
		   && param.iOutput[2].iCode == 0x80000971);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 23);
	#endif
	
	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode);	
	
	param.iPosInText = 142;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 144
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000b04);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 7);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 144;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 146
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000b05);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 9);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 146;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 148
		   && param.iOutputGlyphs ==  1
		   && param.iOutput[0].iCode == 0x80000b02);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 7);
	#endif

	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 148;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 150
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000aff);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 16);
	#endif

	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 150;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 152 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000962
		   && param.iOutput[1].iCode ==0x80000951);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 8);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);

	param.iPosInText = 152;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 155
		   && param.iOutputGlyphs == 3
		   && param.iOutput[0].iCode == 0x80000962
		   && param.iOutput[1].iCode == 0x80000986
		   && param.iOutput[2].iCode == 0x80000951);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif

	
	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode);	
	
	param.iPosInText = 155;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  158
		   && param.iOutputGlyphs == 3
		   && param.iOutput[0].iCode == 0x80000962
		   && param.iOutput[1].iCode == 0x80000989
		   && param.iOutput[2].iCode == 0x80000951);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 8);
	#endif

	
	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode);	
	param.iPosInText = 158;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  160
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000aee);
		   
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 14);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 160;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  162
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000aed);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	}
	
	 
void CTGlyphSelection::TestBengaliChars(CFbsFont* aFont)
	{
	INFO_PRINTF1(_L("Test Bengali Glyphs"));
	
	// Do the testing
	
	TBool r;
	TBuf<115> testText(0);
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	testText.SetLength(115);
	// Make sure there is no garbage values in the memory we are using.
	for (TInt i = 0; i < testText.Length(); i++)
		testText[i]=0xFFFF;
	
	//Testdata for Bengali language
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4002"));
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4002
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various invalid Bengali glyph clusters to test the requirement.
				 			If any part of stored text (e.g. received or downloaded document) is not properly encoded in logical order, the relevant text handling processes must treat that part as an invalid sequence of text and use appropriate fallback mechanisms. Invalid sequences of characters must be rendered as incomplete syllables and rendering engine must be able to handle invalid coding appropriately	
@SYMTestExpectedResults 	Rendering engine will render as incomplete syllables
@SYMPREQ 					1766 Bengali for Sphinx
@SYMREQ 					8741 Bengali Text Rendering
*/
	
	// BEN002: Test invalid sequences
	testText[0] = 0x09C7;
	testText[1] = 0x0995;
	testText[2] = 0x0995;
	testText[3] = 0x09C1;
	testText[4] = 0x09C1;
	testText[5] = 0x0995;
	testText[6] = 0x09CD;
	testText[7] = 0x09C1;
	testText[8] = 0x0995;
	testText[9] = 0x0981;
	testText[10] = 0x09C1;
	
	param.iText.Set(testText);
	RShapeInfo shapeInfo;
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 1
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000ce5
			   && param.iOutput[1].iCode == 0x8000058f);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 15);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
		
	param.iPosInText = 1;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 2
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000cbc);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 2;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 4
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000ebe);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		
	param.iPosInText = 4;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 5
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x8000058f
			   && param.iOutput[1].iCode == 0x80000ce1
	   );
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 9);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
		
	param.iPosInText = 5;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 7
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000cbc
			   && param.iOutput[1].iCode == 0x80000ce9
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 7;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 8
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x8000058f
			   && param.iOutput[1].iCode == 0x80000ce1
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 9);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
		
	param.iPosInText = 8;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 10
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000cbc
			   && param.iOutput[1].iCode == 0x80000cad
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 10;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 11
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x8000058f
			   && param.iOutput[1].iCode == 0x80000ce1
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 9);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	TRAPD(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4003"));
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4003
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  
							Passing both Bengali and Latin scripts simultaneously
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766 Bengali for Sphinx
@SYMREQ 					8741 Bengali Text Rendering
*/
	//BEN003
	testText[11] = 0x0995;
	testText[12] = 0x0041; // Unicode value for A
	testText[13] = 0x09E6;	//Bengali digit 1
	
	param.iPosInText = 11;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 12
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000cbc
			   );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 12;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 13	
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x41
	  	);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x "), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 13;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 14
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode ==0x80000cf3
			   );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4004"));
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4004
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various valid  Bengali glyph clusters to test the reequirement.
							Text rendering in Bengali must be based on syllables and the text rendering engine must be capable of handling the Bengali syllabic structure. If a single word is longer than one row, the line can only be broken at syllable border.
							Invalid sequences of characters must be rendered as incomplete syllables
							
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	// BEN004: 
	testText[14] = 0x0985;
	testText[15] = 0x09A4;
	testText[16] = 0x09CD;
	testText[17] = 0x09AF;
	testText[18] = 0x09A8;
	testText[19] = 0x09CD;
	testText[20] = 0x09A4;
	
	param.iPosInText = 14;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 15
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000cb0
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 14);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		
	param.iPosInText = 15;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 18
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode ==0x80000ccb
			   && param.iOutput[1].iCode ==0x80000d6e
			   );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 16);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode,param.iOutput[1].iCode);
	
	param.iPosInText = 18;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 21
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000e14
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4005"));
// BEN005
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4005
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various valid Bengali glyph clusters to test the requirment
							Text rendering must be able to display specified character sequences using ligatures and set of ligatures (stable/unstable) must be font dependent / configurable.
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	testText[21] = 0x0995;
	testText[22] = 0x09CD;
	testText[23] = 0x09B7;
	
	testText[24] = 0x09A4;
	testText[25] = 0x09CD;
	testText[26] = 0x09B0;
	
	testText[27] = 0x09A6;
	testText[28] = 0x09CD;
	testText[29] = 0x09A6;
	
	
	param.iPosInText = 21;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 24
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000d25
			   );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 15);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		
	param.iPosInText = 24;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 27
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode ==0x80000d89
			   );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		
	param.iPosInText = 27;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 30
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000e0a
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4006"));
// BEN006
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4006
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority		 	High
@SYMTestActions  			Attempt to compose various valid Bengali glyph clusters to test 
							whether tamil digits are recongized as numerals. 
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	testText[30] = 0x09E6; // Bengali 1
	testText[31] = 0x0030; //Basic Latin 0
	
	
	param.iPosInText = 30;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 31
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000cf3
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 31;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 32
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000774	 
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 8);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x "), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4007"));
//BEN 008
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4007
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various valid
							All text handling processes ((rendering, editing, searching, sorting etc.)  MUST treat the sequence of a base consonant and a nukta equivalently to Nukta consonants
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	testText[32] = 0x09AF;
	testText[33] = 0x09BC;
	testText[34] = 0x09DF;
	
	param.iPosInText = 32;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 34
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000cee	 
			   );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x "), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4008"));
// BEN011
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4008
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various valid Bengali glyph clusters to test 
							Rendering engine must be capable of handling joining formatters.
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	testText[35] = 0x0995;
	testText[36] = 0x09CD;
	testText[37] = 0x09B7;
	
	testText[38] = 0x0995;
	testText[39] = 0x09CD;
	testText[40] = 0x200C;
	testText[42] = 0x09B7;
	
	testText[43] = 0x0995;
	testText[44] = 0x09CD;
	testText[45] = 0x200D;
	testText[46] = 0x09B7;
	
	
	param.iPosInText = 35;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 38
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000d25
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 15);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		
	param.iPosInText = 38;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 40
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000cbc
			   && param.iOutput[1].iCode == 0x80000ce9
			   );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode,param.iOutput[1].iCode);
		
	param.iPosInText = 43;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 47
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000d2a
			   && param.iOutput[1].iCode == 0x80000cd9
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 22);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
		
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4009"));
// BEN012
	
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4009
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various valid Bengali glyph clusters to test
 							If consonant /ya/, /ra/, /la/, /ma/, /na/ or /ba/, is the last element of a consonant cluster, the consonant assumes a phala form.
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	testText[47] = 0x09AA;
	testText[48] = 0x09CD;
	testText[49] = 0x09AF;
	
	testText[50] = 0x09AA;
	testText[51] = 0x09CD;
	testText[52] = 0x09A8;
	
	// Not working with Series60Sans font:
	testText[53] = 0x09AA;
	testText[54] = 0x09CD;
	testText[55] = 0x09AE;
	
	param.iPosInText = 47;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 50
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000cd0
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 15);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 50;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 53
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000e25
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 11);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	// Not working with Series60Sans font:
	param.iPosInText = 53;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 56
	   && param.iOutputGlyphs == 2
	   && param.iOutput[0].iCode == 0x80000d3e 
	   && param.iOutput[1].iCode == 0x80000cd4
	  	);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 19);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);	
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4010"));
// BEN013	
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4010
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various valid Bengali glyph clusters to tet 
							Sequence <virama, ya>, i.e. ya-phala, MUST be allowed after independent vowels /a/ and /e/.
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	testText[56] = 0x0985;
	testText[57] = 0x09CD;
	testText[58] = 0x09AF;
	testText[59] = 0x09BE;
	
	// Double ya -> Ya, ya-phala
	testText[60] = 0x09AA;
	testText[61] = 0x09CD;
	testText[62] = 0x09AF;
	testText[63] = 0x09CD;
	testText[64] = 0x09AF;
	
	param.iPosInText = 56;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPosInText == 57
			   && param.iPen.iX == 14
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000cb0
			   );
	#elif defined __ARMCC__
	TEST(r && param.iPosInText == 57
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000cb0
			   );
	#endif
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 57;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 58
			   && param.iOutputGlyphs == 0	
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 0);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 60;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 65
			   && param.iOutputGlyphs == 3
			   && param.iOutput[0].iCode == 0x80000d3e
			   && param.iOutput[1].iCode == 0x80000cd5
			   && param.iOutput[2].iCode == 0x80000d6e
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 23);
	#endif
	
	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4011"));
	// BEN014
	/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4011
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various valid and glyph clusters to test 
						 	When consonant /ga/, /nna/, /na/, /pa/, /la/, /sha/, /ssa/ or /sa/ is a dead consonant, and none of the other consonant cluster formation rules apply, the consonant MUST be rendered with a stemless half form.
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	testText[65] = 0x0997;
	testText[66] = 0x09CD;
	testText[67] = 0x099C;
	
	testText[68] = 0x09AA;
	testText[69] = 0x09CD;
	testText[70] = 0x099C;
	
	
	param.iPosInText = 65;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 68
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000d2c
			   && param.iOutput[1].iCode == 0x80000cc3
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 21);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
		
	param.iPosInText = 68;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 71
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000d3e
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 23);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
		
	
	// BEN015
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4012"));
	/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4012
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various valid Bengali glyph clusters to test 
 							When /ka/, /nga/, /ca/, /tta/, /dda/, /ta/ or /da/ is a dead consonant, and none of the other consonant cluster formation rules apply, the consonant MUST be rendered with a miniature half form.
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	testText[71] = 0x0995;
	testText[72] = 0x09CD;
	testText[73] = 0x099C;
	
	
	param.iPosInText = 71;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 74
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000d2a  
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 26);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);

	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4013"));
	// BEN016
	
	/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4013
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various valid Bengali glyph clusters to test
 							The consonant pairs /k.ka/, /ng.kha/, /c.nya/, /nn.nna/, /n.tha/, /n.pha/, /m.ta/, /m.tha/, /m.pha/, /m.bha/, /l.ka/, /l.ga/, /l.pa/, /ss.ka/, /ss.pha/, /s.ka/, /s.kha/, /s.ta/, /s.tha/, /s.pha/, /h.nna/ MUST be representend as stacks of two consonants.
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	// Ma does not stack correctly on top with Series60Sans font, produces half form instead. Font defect.
	testText[74] = 0x09AE;
	testText[75] = 0x09CD;
	testText[76] = 0x09A5;
	
	testText[77] = 0x09AE;
	testText[78] = 0x09CD;
	testText[79] = 0x09AB;
	// Ma does not stack correctly on top, produces half form instead.
	testText[80] = 0x09AE;
	testText[81] = 0x09CD;
	testText[82] = 0x0995;
	
	testText[83] = 0x09A8;
	testText[84] = 0x09CD;
	testText[85] = 0x09A5;
	
	
	//Combination pa,virama,ma produces incorrect glyph mapping: Font defect.

	param.iPosInText = 74;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 77		 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000d42 
		   && param.iOutput[1].iCode == 0x80000ccc
	);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 21);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	
	param.iPosInText = 77;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 80
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000e30
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 19);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	// Ma does not stack correctly on top, produces half form instead.
	param.iPosInText = 80;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 83
	   && param.iOutputGlyphs == 2
	   && param.iOutput[0].iCode == 0x80000d42
	);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 22);
	#endif

	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	
	param.iPosInText = 83;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 86
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000e15
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4014"));
	// BEN017
	
	/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4014
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various valid Bengali glyph clusters to test
 							Consonant pairs /k.tta/, /k.ta/, /k.ssa/, /k.sa/, /g.ga/, /g.dha/, /ng.ka/, /ng.ga/, /j.ja/, /j.jha/, /j.nya/, /ny.ca/, /ny.cha/, /ny.ja/, /ny.jha/, /tt.tta/, /nn.ttha/, /nn.dda/, /t.ta/, /t.tha/, /d.da/, /d.dha/, /d.ba/, /d.bha/, /n.ta/, /n.dha/, /p.ta/, /b.ja/, /b.da/, /b.dha/, /m.pa/, /ss.tta/, /ss.ttha/, /ss.nna/, /s.pa/, /h.na/ /h.ma/ MUST be displayed as ligatures, if they appear at the end of a consonant cluster.
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	testText[86] = 0x0995;
	testText[87] = 0x09CD;
	testText[88] = 0x099F;
	
	testText[89] = 0x0995;
	testText[90] = 0x09CD;
	testText[91] = 0x09A4;
	
	// Not sure if this is forming the correct ligature
	testText[92] = 0x09AE;
	testText[93] = 0x09CD;
	testText[94] = 0x09AA;
		
	// Not sure if this is forming the correct ligature
	testText[95] = 0x09B8;
	testText[96] = 0x09CD;
	testText[97] = 0x09AA;
	
	testText[98] = 0x09B9;
	testText[99] = 0x09CD;
	testText[100] = 0x09A8;
	
	param.iPosInText = 86;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 89
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000dd7
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 89;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 92
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000dd9
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 15);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 92;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 95
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000e2f
			   );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 19);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		
	param.iPosInText = 95;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 98
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000e56
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 20);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);	
	
	param.iPosInText = 98;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 101	
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000e5d	
			   );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4015"));
// BEN020
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-4015
@SYMTestCaseDesc 			Automated GDI testing for Bengali
@SYMTestPriority 			High
@SYMTestActions  			Attempt to compose various valid Bengali glyph clusters to test that
 							If RA is the first consonant cluster, it must assume the form of Repha.
@SYMTestExpectedResults 	The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 					1766: Bengali for Sphinx
@SYMREQ 					8741:  Bengali Text Rendering
*/
	testText[101] = 0x09B0;
	testText[102] = 0x09CD;
	testText[103] = 0x0995;
	
	testText[104] = 0x09B0;
	testText[105] = 0x200C;
	testText[106] = 0x09CD;
	testText[107] = 0x09AF;
	
	param.iPosInText = 101;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 104
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000cbc
			   && param.iOutput[1].iCode == 0x80000d27
			   );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
		
	param.iPosInText =104;
	param.iPen.iX = param.iPen.iY = 0;
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 105
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000cd6
			   );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 9);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		
	}


void CTGlyphSelection::TestTamilChars(CFbsFont* aFont)
	{
INFO_PRINTF1(_L("Test Tamil Glyphs"));
 
  	TBool r;
	TBuf<162> testText(0);
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	testText.SetLength(162);
	// Make sure there is no garbage values in the memory we are using.
	for (TInt i = 0; i < testText.Length(); i++)
		testText[i]=0xFFFF;
	param.iText.Set(testText);
	RShapeInfo shapeInfo;
	//Testdata for Tamil Langauage
	TRAPD(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4016"));
/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4016
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test 
  	 a)The Tamil alphabets are listed in contiguous Unicode range(U+0B80U+0BFF),  This also contains Tamil Numbers.
	 b)The Tamil alphabets are listed in contiguous Unicode range(U+0B80U+0BFF),  This also contains Tamil Numbers.
	 c)Internal data storage should always be in the logical order, but the rendering of it may be different to that of the logical order
	 d)Combination of Unicode sequences must be rendered as valid blocks.  In Tamil some character sequences are invalid and therefore only the sequences which follow the logical order as described in Req 1.2.3 should be rendered properly
	 e)If the text being rendered contains a mixture of scripts, the text in each script should be rendered according to the rules of that particular script.
@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/
	testText[0] = 0x0B95; //Tamil Ka
	testText[1] = 0x0B8E; //Tamil e
	testText[2] = 0x0061; //Latin A
	testText[3] = 0x0905; // Hindi Ka
	testText[4] = 0x0020;
	// Do the testing
	param.iPosInText = 0 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);

	TEST(r && param.iPosInText == 1  
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000bf6);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 1 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  2 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000bf0);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 14);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 2 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 3
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x61 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	param.iPosInText = 3 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 4  
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000528);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 12);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	/*Req 02 1.2.3, 1.3.21, 1.3.21.1, 1.3.21.2 1.3.21.3
	
	1.2.3 The attachment presents the logical order used to present Tamil text. In the schematic samples, square brackets are used to presents the components that may be omitted. 
	1.3.21 If the text-rendering engine detects invalid sequences of characters, it should render the invalid sequences using an appropriate fallback rendering mechanism
Please see the attachment for examples
	1.3.21.1 For normal rendering, combining Tamil characters must be preceded by a valid base character. 
	1.3.21.2 Combining Tamil characters that do not follow a valid base character must be rendered using an appropriate fallback rendering.
	1.3.21.3 Device must not hang or crash because of unexpected character sequences.*/
	
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4017"));
//Req 03 
	
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4017
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test 
				 It is reasonably common to mix Latin, Tamil as well as other script in texts.  This must include the numerals.
@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/
	testText[4] = 0x0036;//Latin 06
	testText[5] = 0x0BEC;//Tamil 06
	
	param.iPosInText = 4 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 5  
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x8000077A);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 8);
	#endif

	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		
	param.iPosInText = 5 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 6  
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000c20);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 16);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);

	/*Req 04 1.3.4, 1.3.20
	1.3.4   1. Tamil is a semi-syllabic script and in Tamil text rendering the basic unit for handling text must be the orthographic syllable.
			2. Therefore, a text-rendering engine should first identify a syllable and then analyze the syllable. Based on the analysis, text-rendering engine should then be able to select and/or shape the glyphs required for rendering the syllable and to perform contextual positioning of glyphs inside a syllable.
			3. After a syllable has been formed it must be considered an indivisible and invariable unit.
			4. The shape of a syllable is not affected by surrounding syllables.
	1.3.20 Syllable is the smallest unbreakable component in Tamil*/
	
	/*Req 07 1.3.5
	
	1.3.5 	1. In Tamil, when ligatures are used there is a possibility that the shaping of the previous consonant will depend on the next consonant the user enters
			2. In Tamil, there is a possibility that even though the characters are entered one by one the position of the matras change depending on the consonant and the type of the matra
	
	Req 08 1.3.19
	
	1.3.19 In Tamil white space is used as a word boundary. Line breaking should be based on word boundaries
	
	
	Req 09 1.2.4
	
	1.2.4 For compatibility with legacy encodings, split matra and vowel representations must be recognized as identical to the single code representations (preferred)
	*/
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4018"));
//Req 10 1.3.6	
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4018
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test the requirement.
				 Tamil character shaping MUST be based on combining character sequences. All shaping processes (splitting, reordering, glyph selection) MUST occur in the context of combining character sequence.
@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/
	testText[6] = 0x0BAA; // Pa
	testText[7] = 0x0BCD; //Virama
	testText[8] = 0x0B95; //Ka
	testText[9] = 0x0BCD; //Virama
	testText[10] = 0x0B9F; //Tta
	testText[11] = 0x0BC7; //-e
	
	testText[12] = 0x0BAA;//Pa
	testText[13] = 0x0BCD;//Virama
	testText[14] = 0x0B95;//Ka
	testText[15] = 0x0BCC;//AU
	
	testText[16] = 0x0B95; //Ka
	testText[17] = 0x0BCD; //Virama
	testText[18] = 0x0BB7; //Ssa
	testText[19] = 0x0BCB; //OO
	
	param.iPosInText = 6 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 12    
		   && param.iOutputGlyphs == 4
		   && param.iOutput[0].iCode == 0x80000c3a
		   && param.iOutput[1].iCode == 0x80000c30  
		   && param.iOutput[2].iCode == 0x80000c13
		   && param.iOutput[3].iCode == 0x80000bfb);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 51);
	#endif
	
	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[3].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[3].iCode);
	
	param.iPosInText = 12 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  16 
		   && param.iOutputGlyphs ==4 
		   && param.iOutput[0].iCode == 0x80000c3a 
		   && param.iOutput[1].iCode == 0x80000c12 
		   && param.iOutput[2].iCode == 0x80000bf6
		   && param.iOutput[3].iCode == 0x80000c19);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 56);
	#endif
	
	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[3].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[3].iCode);
	
	param.iPosInText = 16 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 20  
		   && param.iOutputGlyphs == 3
		   && param.iOutput[0].iCode == 0x80000c13
		   && param.iOutput[1].iCode == 0x80000c2f  
		   && param.iOutput[2].iCode == 0x80000c0d);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 54);
	#endif
	
	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4019"));
//Req 11
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4019
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test the requirement
				 Matras /-e/, /-ee/ and /-ai/ are reordered with the consonant they follow in memory order.
@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/

	testText[20] = 0x0B95; //Ka
	testText[21] = 0x0BC7; //-e
	
	param.iPosInText = 20 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 22  
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000c13 
		   && param.iOutput[1].iCode == 0x80000bf6 );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 26);
	#endif
	
	INFO_PRINTF6(_L("The values are iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode); 
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4020"));
//Req 12 1.3.5.2
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4020
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test the requirment
				 Matras /-o/, /-oo/ and /-au/ are split into two halves that enclose the consonant they follow in memory order.
@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/

	testText[22] = 0x0B95; //Ka
	testText[23] = 0x0BCA; //O
	
	
	param.iPosInText = 22 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  24 
		   && param.iOutputGlyphs == 3
		   && param.iOutput[0].iCode == 0x80000c12
		   && param.iOutput[1].iCode == 0x80000bf6   
		   && param.iOutput[2].iCode == 0x80000c0d);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 37);
	#endif
	
	INFO_PRINTF7(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x iOutput[2].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode, param.iOutput[2].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4021"));
	//Req 13 
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4021
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test the requirment.
				Tamil Modifier "Ayatham" MUST be treated as an independent character
@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/

	testText[24] = 0x0B95; //Ka
	testText[25] = 0x0B83; //Aythem
	testText[26] = 0x0B85; //A
	
	param.iPosInText = 24;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  25 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000bf6);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4022"));
//Req 14 
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4022
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test the requirement. 
			 	Rendering Engine MUST be capable of handling TAMIL ANUSVARA
				It has been suggested that this character be deprecated in Unicode
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/
	
	testText[27] = 0x0B95; //Ka
	testText[28] = 0x0B82; //Anusvara
	testText[29] = 0x0B95; //Ka
	
	param.iPosInText = 27;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  29 
		   && param.iOutputGlyphs == 2 
		   && param.iOutput[0].iCode == 0x80000bf6
		   && param.iOutput[1].iCode == 0x80000be8);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 19);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	param.iPosInText = 29;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  30 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000bf6 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif 
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4023"));
//Req 15
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4023
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test the requirment
				 Tamil consonant /ra/ changes its shape, when a virama is applied to it.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/

	testText[30] = 0x0BB0; //Ra
	testText[31] = 0x0BCD; //Virama
	testText[32] = 0x8205; //ZWJ
	
	
	param.iPosInText =  30;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  32 
		   && param.iOutputGlyphs == 2 
		   && param.iOutput[0].iCode == 0x80000c03 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 10);
	#endif 
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4024"));
//Req 16 
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4024
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test 
				Matra /-aa/ is combined to consonants in regular fashion. No extra shaping is required.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/

	testText[33] = 0x0B95; //Ka
	testText[34] = 0x0B82; //Anusvara
	
	param.iPosInText = 33 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 35  
		   && param.iOutputGlyphs == 2 
		   && param.iOutput[0].iCode == 0x80000bf6 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 19);
	#endif 
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4025"));
//Req 17 1.3.11
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4025
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test 
					Matras /-i/ and /-ii/ MUST form a ligature with consonant /tta/.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/

	testText[35] = 0x0B9F; //Tta
	testText[36] = 0x0BBF; //I
	
	testText[37] = 0x0B9F; //Tta
	testText[38] = 0x0BC0; //Ii
	
	param.iPosInText = 35 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  37 
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000c51);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 15);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	
	param.iPosInText = 37 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  39
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x80000c52);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif 
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4026"));
//Req 18 	
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4026
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test 
				Consonant /ra/ takes an alternate shape when combined with matras /-i/ and /-ii/.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/	
	testText[39] = 0x0BB0; //Ra
	testText[40] = 0x0BBF; //I
	
	testText[41] = 0x0BB0; //Ra
	testText[42] = 0x0BC0; //Ii
	
	param.iPosInText = 39 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 41  
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000c0d
		   && param.iOutput[1].iCode == 0x80000c0e );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif 
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 41 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  43
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000c0d 
		   && param.iOutput[1].iCode == 0x80000c0f);
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4027"));
//Req 19 
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4027
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test the requirement
				 Matras /-i/ and /-ii/ take an alternate form when applied to consonants /nga/, /pa/, /ya/ and /va/.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/
	testText[43] = 0x0B99; //Nga
	testText[44] = 0x0BBF; //I
	
	testText[45] = 0x0B99; //Nga
	testText[46] = 0x0BC0; //Ii
	
	param.iPosInText = 43 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  45 
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000bf7
		   && param.iOutput[1].iCode == 0x80000c0e );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 19);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	param.iPosInText = 45 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  47
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000c4a );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 17);
	#endif 
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4028"));
	
//Req 20 		
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4028
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test the requirement. 
				 Matras /-u/ and /-uu/ join in ligature form with all other consonants than /ha/, /ja/, /sa/, /ssa/ and /k.ssa/.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/
	testText[47] = 0x0B9C; //Ja
	testText[48] = 0x0BC1; //U
	
	testText[49] = 0x0B9C; //Ja
	testText[50] = 0x0BC2; //Uu
	
	param.iPosInText = 47 ;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 49  
		   && param.iOutputGlyphs == 2 
		   && param.iOutput[0].iCode == 0x80000bf9
		   && param.iOutput[1].iCode == 0x80000c10);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 26);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	
	param.iPosInText = 49;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText ==  51
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000bf9
		   && param.iOutput[1].iCode == 0x80000c11 );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 29);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4029"));
//Req 21 1.3.15		
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4029
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test the requirement. 
				 Matra /-ai/ is combined to consonants in regular fashion. No extra shaping is required. 
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/
	testText[51] = 0x0B95; //Ka
	testText[52] = 0x0BC8; //Ai
	
	param.iPosInText = 51;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 53  		   
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x80000c14
		   && param.iOutput[1].iCode == 0x80000bf6);

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 31);
	#endif
	
	INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4030"));
//Req 22
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4030
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test the requirement
				 Consonant cluster <ka, virama, ssa> MUST always form conjunct consonant /k.ssa/, which behaves as if it were a proper consonant of its own
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/
	testText[53] = 0x0B95; //Ka
	testText[54] = 0x0BCD; //Virama
	testText[55] = 0x0BB7; //Ssa
	
	param.iPosInText =  53;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 56  
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x80000c2f );

	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 31);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4031"));
//Req 23 1.3.17
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4031
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test 
				Character sequence <sa, virama, ra, matra_ii> MUST be rendered as a ligature form /s.rii/.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/
	testText[56] = 0x0BB8; //Sa
	testText[57] = 0x0BCD; //Virama
	testText[58] = 0x0BB0; //Ra
	testText[59] = 0x0BC0; //Matra I
	
	param.iPosInText = 56;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 60  
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x80000c79 );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 27);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4032"));
//Req 24 1.3.18
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4032
@SYMTestCaseDesc Automated GDI testing for Tamil
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Tamil glyph clusters to test 
				Vertical position of the glyphs for combining characters virama, matras /-i/ and /-ii/ must be determined separately in relation to the relevant base glyph
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8742:Tamil Text Rendering
*/
	testText[60] = 0x0B95; //Ka
	testText[62] = 0x0BCD; //Virama
	testText[63] = 0x8205; //ZWJ
	
	param.iPosInText = 60;
	param.iPen.iX = param.iPen.iY = 0;
	
	r = aFont->GetCharacterPosition2(param,shapeInfo);
	
	TEST(r && param.iPosInText == 61  
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 0x80000bf6 );
	
	#if defined __WINS__ || defined __WINSCW__
	TEST(r && param.iPen.iX == 13);
	#endif
	
	INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	}

/**
@SYMTestCaseID			GRAPHICS-SYSLIB-GDI-CIT-3479
@SYMTestCaseDesc		Automated GDI testing for correct localised punctuation after indic characters
@SYMTestPriority		High
@SYMTestActions			Attempt to compose various valid Indic strings with western punctuation
@SYMTestExpectedResults The expected punctuation glyphs for the implied locale should be returned
@SYMDEF					DEF106651
*/
void CTGlyphSelection::TestGlyphs(CFont* aFont, CFont::TPositionParam& aParam,
	const TPtrC16& aText, const TPtrC16& aExpectedGlyphs)
	{
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-3479"));
	TUint16* glyphs = CONST_CAST(TUint16*,aExpectedGlyphs.Ptr());
	const TInt mask = 0x80000000-1;
	TBool r;
	RShapeInfo shapeInfo;
	aParam.iText.Set(aText); 
	aParam.iPosInText = aParam.iPen.iX = aParam.iPen.iY = 0;
	while(aParam.iPosInText < aParam.iText.Length())
		{
		r = aFont->GetCharacterPosition2(aParam,shapeInfo);
		//INFO_PRINTF3(_L("Glyph %d Icode 0x%x"),*glyphs,aParam.iOutput[0].iCode);
		TEST(r && ((aParam.iOutput[0].iCode & mask) == *glyphs++));
		}
	shapeInfo.Close();
	TRAPD(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	}
void CTGlyphSelection::TestTeluguChars(CFbsFont* aFont)
	{
INFO_PRINTF1(_L("Test Telugu Glyphs"));
 
  	TBool r;
	TBuf<162> testText(0);
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	testText.SetLength(162);
	// Make sure there is no garbage values in the memory we are using.
	for (TInt i = 0; i < testText.Length(); i++)
		testText[i]=0xFFFF;
	
	param.iText.Set(testText);
	RShapeInfo shapeInfo;

	//Testdata for Telugu Langauage
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4033"));
/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4033
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
				 These consonants contain a small tick mark (crest) at the top of the glyph. This graphical detail can be considered to be a vocalic stem that indirectly indicates the inherent vowel /-a/. VIRAMA replaces the vocalic stem.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/
//	Req 4.1
	
		testText[0] =  0x0C15;
		testText[1] =  0x0C4D;
		param.iPosInText = 0 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 2  
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f49 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 9);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAPD(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4034"));
/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4034
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
				?VIRAMA attaches the upward stroke at the right of the glyph.	
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/		
		testText[2] =  0x0C16;		
		testText[3] =  0x0C4D;	
		
		param.iPosInText = 2 ;
		
		 param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		
		TEST(r && param.iPosInText ==  4 
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f4a);

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 13);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4035"));
/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4035
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?VIRAMA is attached to a stroke at the upper right corner.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/
		
		testText[4] =  0x0C23;
		testText[5] =  0x0C4D;
		
		param.iPosInText = 4 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 6  
			   && param.iOutputGlyphs == 1 
			   && param.iOutput[0].iCode == 0x80000f57 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 13);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4036"));
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4036
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
Matras MATRA VOCALIC R and MATRA VOCALIC RR never attach the consonant glyph causing shape changes, but they are always placed at the right of the consonant glyph.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/		
	//Req 4.2
		testText[6] =  0x0C2E;
		testText[7] =  0x0C43;
		
		param.iPosInText = 6 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText ==  8 
			   && param.iOutputGlyphs == 2 
			   && param.iOutput[0].iCode == 0x80000f21
			   && param.iOutput[1].iCode == 0x80000f31 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 24);
		#endif
		
		INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4037"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4037
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
Matras MATRA VOCALIC R and MATRA VOCALIC RR never attach the consonant glyph causing shape changes, but they are always placed at the right of the consonant glyph.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
		testText[8] =  0x0C32;
		
		testText[9] =  0x0C44;
		
		param.iPosInText = 8 ;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);	
		
		TEST(r && param.iPosInText ==  10 
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000f25
			   && param.iOutput[1].iCode == 0x80000f32);

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 22);
		#endif
		
		INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4038"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4038
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Matras MATRA VOCALIC R and MATRA VOCALIC RR never attach the consonant glyph causing shape changes, but they are always placed at the right of the consonant glyph.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/		
	//Req 4.2.1
		testText[10] = 0x0C15; 
		testText[11] = 0x0C3E;
		
		param.iPosInText = 10 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 12  
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f6d );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 13);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4039"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4039
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?MATRA AA attaches to the upwards left curving stroke
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
		testText[12] = 0x0C1F;
		testText[13] = 0x0C3E;
		param.iPosInText = 12 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 14  
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f77 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 16);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4040"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4040
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?MATRA AA attaches the upwards (left curving) stroke at the top of the glyph
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/
		testText[14] = 0x0C1C;
		testText[15] = 0x0C3E;
		
		param.iPosInText = 14 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 16  
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f74 );
	
		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 15);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4041"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4041
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?MATRA AA is drawn on top of the glyph
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
		testText[16] = 0x0C23;
		testText[17] = 0x0C3E;
		
		param.iPosInText = 16 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 18  
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f7b );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 16);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4042"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4042
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?MATRA AA attaches to the upwards left curving stroke, the vowel stem remains intact
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
		testText[18] = 0x0C2B;
		testText[19] = 0x0C3E;
		
		param.iPosInText = 18 ;
		param.iPen.iX = param.iPen.iY = 0;
						
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 20  
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f82 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 16);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4043"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4043
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?MATRA AA replaces the vowel stem, the upwards left curving stroke is extended
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
		testText[20] = 0x0C2A;
		testText[21] = 0x0C3E;
	
		param.iPosInText = 20 ;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);

		TEST(r && param.iPosInText == 22   
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f81);

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 16);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4044"));
	//Req 4.2.2
	/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4044
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign replaces the vowel stem
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/
		testText[22] = 0x0C26;
		testText[23] = 0x0C3F;
		
		param.iPosInText = 22 ;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText ==  24 
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000fa2 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 11);
		#endif
			
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4045"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4045
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?The upwards left curving stroke extends, vowel sign attaches to the extended stroke
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/
		testText[24] = 0x0C16;
		testText[25] = 0x0C3F;
	
		param.iPosInText = 24 ;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 26  
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f92);

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 12);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4046"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4046
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign attaches the upward stroke at the top of the glyph
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
		testText[26] = 0x0C1C;
		testText[27] = 0x0C3F;
	
		param.iPosInText = 26 ;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 28  
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f98 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 12);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4047"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4047
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign attaches the upward stroke at the top of the glyph
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/		
		testText[28] = 0x0C1E;
		testText[29] = 0x0C40;
		
		param.iPosInText = 28 ;
		param.iPen.iX = param.iPen.iY = 0;
				
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 30  
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000fbe );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 14);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4048"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4048
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign attaches to the right upper corner of the glyph
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/		
		testText[30] = 0x0C1F;
		testText[31] = 0x0C3F;
	
		param.iPosInText = 30;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);

		TEST(r && param.iPosInText == 32  
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode ==  0x80000f9b );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 12);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4049"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4049
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign takes a loop form that replaces the vowel stem
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/		
		testText[32] = 0x0C1D;
		testText[33] = 0x0C3F;
	
		param.iPosInText = 32 ;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText ==  34 
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode ==  0x80000f99 );
	
		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 19);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4050"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4050
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?The upwards left curving stroke extends, vowel sign replaces the vowel stem at the tip of the extended stroke 
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
		testText[34] = 0x0C1B;
		testText[35] = 0x0C3F;
	
	 	param.iPosInText =34 ;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 36 
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f97 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 12);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4051"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4051
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign replaces the upwards curving stroke at the top of the glyph
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/		
		testText[36] = 0x0C1C;
		testText[37] = 0x0C3F;
	
		param.iPosInText = 36 ;
		param.iPen.iX = param.iPen.iY = 0;
					
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 38  
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000f98 );
		
		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 12);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4052"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4052
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel stem is removed.
?Vowel stem is removed and MATRA II takes a form that looks like MATRA AA
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/		
		testText[38] = 0x0C2F;
		testText[39] = 0x0C3F;
	
		param.iPosInText = 38 ;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 40 
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000faa );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 19);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4053"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4053
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign attaches to the right of the consonant glyph, vowel stem remains intact
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
		testText[40] = 0x0C15;
		testText[41] = 0x0C41;
	
		param.iPosInText = 40 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText ==42   
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000fd9 );
		
		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 14);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4054"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4054
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign takes a miniature form which attaches to the stroke at the top of the consonant glyph
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
		testText[42] = 0x0C19;
		testText[43] = 0x0C41;
	
		param.iPosInText = 42 ;
		param.iPen.iX = param.iPen.iY = 0;
						
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText ==  44 
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80000fda );
		
		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 15);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4055"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4055
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign attaches the consonant sign from below. Vowel stem remains intact.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
		testText[44] = 0x0C2E;
		testText[45] = 0x0C41;
	
		param.iPosInText = 44 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 46   
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000f21 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 21);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		
		testText[46] = 0x0C36;
		testText[47] = 0x0C41;
	
		param.iPosInText = 46 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 48   
			   && param.iOutputGlyphs == 2 
			   && param.iOutput[0].iCode == 0x80000f28 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 14);
		#endif
			
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4056"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4056
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign replaces the vowel stem
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/		
//	Req 4.2.4
		testText[48] = 0x0C28;
		testText[49] = 0x0C46;
	
		param.iPosInText = 48 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 50   
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80001000 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 11);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4057"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4057
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign replaces the vowel stem
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/		
		testText[50] = 0x0C1B;
		testText[51] = 0x0C47;
		
		param.iPosInText = 50 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText ==  52 
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80001017 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 12);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4058"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4058
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign replaces the vowel stem
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/		
		testText[52] = 0x0C1D;	
		testText[53] = 0x0C48;
		
		param.iPosInText = 52 ;
		param.iPen.iX = param.iPen.iY = 0;
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText ==  54 
			   && param.iOutputGlyphs == 2
			   && param.iOutput[0].iCode == 0x80000ff5
			   && param.iOutput[1].iCode == 0x80000f3b );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 19);
		#endif
		
		INFO_PRINTF6(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x iOutput[1].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode, param.iOutput[1].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4059"));	
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4059
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign replaces the vowel stem.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
	// Req 4.2.5
		testText[54] = 0x0C15;
		testText[55] = 0x0C4A;
		
		param.iPosInText = 54 ;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText ==  56 
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x80001059 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 13);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4060"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4060
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign replaces the vowel stem.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
	
		testText[56] = 0x0C21;
		testText[57] = 0x0C4B;
		
		param.iPosInText = 56 ;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText ==  58 
			   && param.iOutputGlyphs == 1 
			   && param.iOutput[0].iCode == 0x80001089 );

		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 14);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
		TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    		if (err!=KErrNone)
    			INFO_PRINTF1(_L("Failed to record test result"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-4061"));
		/*	
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CIT-4061
@SYMTestCaseDesc Automated GDI testing for Telugu
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid Telugu glyph clusters to test   	 
?Vowel sign replaces the vowel stem.
@@SYMTestExpectedResults The expected glyph clusters for given Unicode characters must be returned
@SYMPREQ 1766: Tamil for Sphinx
@SYMREQ 8743:Tamil Text Rendering
*/	
		testText[58] = 0x0C26;
		testText[59] = 0x0C4C;
		
		param.iPosInText = 58 ;
		param.iPen.iX = param.iPen.iY = 0;
		
		r = aFont->GetCharacterPosition2(param,shapeInfo);
		
		TEST(r && param.iPosInText == 60   
			   && param.iOutputGlyphs == 1
			   && param.iOutput[0].iCode == 0x800010b2 );
	
		#if defined __WINS__ || defined __WINSCW__
		TEST(r && param.iPen.iX == 14);
		#endif
		
		INFO_PRINTF5(_L("The values are  iPosInText=%d iPen.iX=%d iOutputGlyphs=%d iOutput[0].iCode=0x%x"), param.iPosInText, param.iPen.iX, param.iOutputGlyphs, param.iOutput[0].iCode);
	}
	
void CTGlyphSelection::TestIndicPunctuation(CFbsFont* aFont)
	{
	INFO_PRINTF1(_L("Test Indic Punctuation"));

	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;
	
	//INFO_PRINTF1(_L("// punctuation string after Kannada text"));
	TestGlyphs(aFont,param,_L("\xC95!?#@"),_L("\x7A8\x920\x93C\x922\x23"));
	//INFO_PRINTF1(_L("// punctuation string before Kannada text"));
	TestGlyphs(aFont,param,_L("!?#@\xC95"),_L("\x21\x3F\x23\x40\x7A8"));
	//INFO_PRINTF1(_L("// punctuation string before and after Kannada text"));
	TestGlyphs(aFont,param,_L("  \"\xC95\"  "),_L("\x20\x20\x22\x7A8\x22\x20\x20"));
	//INFO_PRINTF1(_L("// punctuation before and after latin text followed by punctuation before and after kannada text"));
	TestGlyphs(aFont,param,_L("\x201c\x041\x201D (\xc95)"),_L("\x201c\x41\x201d\x20\x28\x7a8\x29"));
	//INFO_PRINTF1(_L("// mixed kannada/ latin with punctuation surrounded by whitespace inbetween"));
	TestGlyphs(aFont,param,_L("\xc95 , \x041"),_L("\x7a8\x20\x929\x20\x41"));
	//INFO_PRINTF1(_L("// mixed kannada/ latin with punctuation surrounded by whitespace inbetween (reversed)"));
	TestGlyphs(aFont,param,_L("\x041 , \xc95"),_L("\x41\x20\x2C\x20\x7a8"));
	//INFO_PRINTF1(_L("// mixed kannada/ latin with punctuation next to latin"));
	TestGlyphs(aFont,param,_L("\x041, \xc95"),_L("\x41\x2C\x20\x7a8"));
	//INFO_PRINTF1(_L("// mixed kannada/ latin with punctuation next to kannada"));
	TestGlyphs(aFont,param,_L("\x041 ,\xc95"),_L("\x41\x20\x2C\x7a8"));
	//INFO_PRINTF1(_L("// mixed kannada/ latin with punctuation next to latin and seperating tab"));
	TestGlyphs(aFont,param,_L("\x041,\t\xc95"),_L("\x41\x2C\x9\x7a8"));
	//INFO_PRINTF1(_L("// mixed kannada/ latin with punctuation next to kannada and seperating tab"));
	TestGlyphs(aFont,param,_L("\x041\t,\xc95"),_L("\x41\x9\x2C\x7a8"));
	//INFO_PRINTF1(_L("// devanagari digits with colons"));
	TestGlyphs(aFont,param,_L("\x966\x03a\x967\x03a\x968\x03a\x969\x03a\x96a\x03a\x96b\x03a\x96c\x03a\x96d\x03a\x96e\x03a\x96f\x03a"),
										_L("\x582\x77e\x583\x77e\x584\x77e\x585\x77e\x586\x77e\x587\x77e\x588\x77e\x589\x77e\x58a\x77e\x58b\x77e"));
	//INFO_PRINTF1(_L("// string of only punctuation"));
	TestGlyphs(aFont,param,_L("\x002D\x002D\x002D\x002D\x002D\x002D"),_L("\x002D\x002D\x002D\x002D\x002D\x002D"));
	//INFO_PRINTF1(_L("// one Kannada character followed my multiple punctuation and non-punctuaion"));
	TestGlyphs(aFont,param,_L("\x0C95!\x0022\x00A3$%^&*()-={}[]:@~;'#<>?,./"),
										_L("\x07A8\x0920\x0022\x00A3\x0024\x0923\x005E\x0009\x0927\x0028\x0029\x092A\x003D\x007B\x007D\x005B\x005D\x0937\x0023\x007E\x0938\x0027\x0922\x003C\x003E\x093C\x0929\x092B\x092C"));
	}
	


void CTGlyphSelection::TestIndicCharsL()
	{
	// create a font store for testing
	CFontStore* fontStore = CFontStore::NewL(&User::Heap());
	
	//load all ecom implemented rasterizer dlls. installs the rasterizer.	
	LoadOpenFontLibraries(fontStore);
		// test font preparation
	fontStore->iKPixelWidthInTwips = 11860; //This value is default

	//add any required font files
	TUid err = fontStore->AddFileL(KTestHindiFontFile);

	TFontSpec testHindiFontSpec(KTestHindiFontFaceName,200); 
	
	TUid err1 = fontStore->AddFileL(KTestIndicFontFile);

	TFontSpec testIndicFontSpec(KTestIndicFontFaceName,200);
	 
	CFbsBitmap* bmp = new(ELeave) CFbsBitmap;
	
	TInt ret = bmp->Create(TSize(100,100),EGray2);
	if (ret == KErrNotSupported)
		return;
	else
		User::LeaveIfError(ret);

	CFbsBitmapDevice* device = NULL;
	TRAPD(err2,device = CFbsBitmapDevice::NewL(bmp));
	TEST(err2 == KErrNone);

	CFbsBitGc* gc = NULL;
	User::LeaveIfError(device->CreateContext(gc));
	// Font file Creation
	CFbsFont* hindiFont = NULL;
	User::LeaveIfError(device->GetNearestFontToDesignHeightInTwips(hindiFont,testHindiFontSpec));
	gc->UseFont(hindiFont);
	CleanupStack::PushL(hindiFont);
	
	//Testcode for Hindi language
	((CTGlyphSelectionStep*)iStep)->RecordTestResultL();
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-1580"));
	TestHindiChars(hindiFont);
	((CTGlyphSelectionStep*)iStep)->RecordTestResultL();
	
	CleanupStack::Pop(hindiFont);
	
	// Font file Creation
	CFbsFont* indicFont = NULL;
	User::LeaveIfError(device->GetNearestFontToDesignHeightInTwips(indicFont,testIndicFontSpec));
	gc->UseFont(indicFont);
	CleanupStack::PushL(indicFont);
	
	//Testcode for Kannada, Marathi,Gujarati,Bengali language
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-3381"));
	TestKannadaChars(indicFont);
	((CTGlyphSelectionStep*)iStep)->RecordTestResultL();
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-3360"));
	TestMarathiChars(indicFont);
	((CTGlyphSelectionStep*)iStep)->RecordTestResultL();
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-3417"));
	TestGujaratiChars(indicFont);
	TestBengaliChars(indicFont);
	TestTamilChars(indicFont);
	TestTeluguChars(indicFont);
	TestIndicPunctuation(indicFont);
	CleanupStack::Pop(indicFont);
			
	//Cleaning the memory
	delete bmp;
	delete device;
	delete gc;
	fontStore->RemoveFile(err);
	fontStore->RemoveFile(err1);
	delete fontStore;
	REComSession::FinalClose();
	}

	
/**
@SYMTestCaseID GRAPHICS-SYSLIB-GDI-CT-0221
@SYMTestCaseDesc Test support for Vietnamese characters.
@SYMTestPriority High
@SYMTestActions  Attempt to compose various valid and invalid Vietnamese glyph clusters.
@SYMTestExpectedResults The test must not fail.
@SYMPREQ 402: GDI for Bravo.
*/
void CTGlyphSelection::TestVietnameseChars()
	{
/**
 This method is a test case to test GetCharacterPosition() correctly
 processes Vietnamese characters.
*/
	TBool r;
	TBuf<41> testText(0);
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	testText.SetLength(41);
	
	testText[0] = 0x0055; // capital U
	testText[1] = 0x031B; // combining horn - expect 0x01AF (succeed)

	testText[2] = 0x0055; // capital U
	testText[3] = 0x0027; // apostrophe - expect 0x0055 (fail)

	testText[4] = 0x0055; // capital U
	testText[5] = 0x02B9; // modifier prime - expect 0x0055 (fail)

	testText[6] = 0x0055; // capital U
	testText[7] = 0x02BC; // modifier apostrophe - expect 0x0055 (fail)

	testText[8] = 0x0055; // capital U
	testText[9] = 0x0315; // combining comma above right - expect 0x0055, 0x0315 (fail)

	testText[10] = 0x0055; // capital U
	testText[11] = 0x2019; // right single quote mark - expect 0x0055 (fail)

	testText[12] = 0x01AF; // capital U with horn
	testText[13] = 0x0020; // space - expect 0x01AF (succeed)

	testText[14] = 0x0045; // capital E
	testText[15] = 0x031B; // combining horn - expect 0x0045, 0x031B (fail)

	testText[16] = 0x0041; // capital A
	testText[17] = 0x0306; // combining breve
	testText[18] = 0x0301; // combining acute - expect 0x1EAE (succeed)

	testText[19] = 0x0102; // capital A with breve
	testText[20] = 0x0301; // combining acute - expect 0x1EAE (succeed)

	testText[21] = 0x0041; // capital A
	testText[22] = 0x0301; // combining acute
	testText[23] = 0x0306; // combining breve - expect 0x0041, 0x0301, 0x0306 (fail)

	testText[24] = 0x0041; // capital A
	testText[25] = 0x0323; // combining dot below
	testText[26] = 0x0306; // combining breve - expect 0x1EB6 (succeed)

	testText[27] = 0x1EA0; // capital A with dot below
	testText[28] = 0x0306; // combining breve - expect 0x1EB6 (succeed)

	testText[29] = 0x0102; // capital A with breve
	testText[30] = 0x0323; // combining dot below - expect 0x0102, 0x0323 (fail)

	testText[31] = 0x0045; // capital A
	testText[32] = 0x0302; // combining circumflex
	testText[33] = 0x0301; // combining acute - expect 0x1EBE (succeed)

	testText[34] = 0x00CA; // capital A with circumflex
	testText[35] = 0x0301; // combining acute - expect 0x1EBE (succeed)

	testText[36] = 0x004F; // capital O
	testText[37] = 0x031B; // combining horn
	testText[38] = 0x0309; // combining hook above - expect 0x1EDE (succeed)

	testText[39] = 0x01A0; // capital O with horn
	testText[40] = 0x0309; // combining hook above - expect 0x1EDE (succeed)

	param.iText.Set(testText);

	// 1: Capital U with combining horn
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 2 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x01AF);

	// 2: Capital U with apostrophe
	param.iPosInText = 2;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 3 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x0055);

	// 3: Capital U with modifier prime
	param.iPosInText = 4;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 5 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x0055);

	// 4: Capital U with modifier apostrophe
	param.iPosInText = 6;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 7 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x0055);

	// 5: Capital U with combining comma above right
	param.iPosInText = 8;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 10 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x0055
		   && param.iOutput[1].iCode == 0x0315);

	// 6: Capital U with right single quote
	param.iPosInText = 10;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 11 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x0055);

	// 7: Capital U with horn plus space
	param.iPosInText = 12;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 13 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x01AF);

	// 8: Capital E with combining horn
	param.iPosInText = 14;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 16 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x0045
		   && param.iOutput[1].iCode == 0x031B);

	// 9: Capital A with combining breve with combining acute
	param.iPosInText = 16;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 19 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x1EAE);

	// 10: Capital A with breve with combining acute
	param.iPosInText = 19;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 21 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x1EAE);

	// 11: Capital A with combining acute with combining breve
	param.iPosInText = 21;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 24 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 3
		   && param.iOutput[0].iCode == 0x0041
		   && param.iOutput[1].iCode == 0x0301
		   && param.iOutput[2].iCode == 0x0306);

	// 12: Capital A with combining dot below with combining breve
	param.iPosInText = 24;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 27 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x1EB6);

	// 13: Capital A with dot below with combining breve
	param.iPosInText = 27;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 29 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x1EB6);

	// 14: Capital A with breve with combining dot below
	param.iPosInText = 29;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 31 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 2
		   && param.iOutput[0].iCode == 0x0102
		   && param.iOutput[1].iCode == 0x0323);

	// 15: Capital A with combining circumflex with combining acute
	param.iPosInText = 31;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 34 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x1EBE);

	// 16: Capital A with circumflex with combining acute
	param.iPosInText = 34;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 36 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x1EBE);

	// 17: Capital O with combining horn with combing hook above
	param.iPosInText = 36;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 39 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x1EDE);

	// 18: Capital O with horn with combing hook above
	param.iPosInText = 39;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 41 
		   && param.iPen.iX == 10
		   && param.iOutputGlyphs == 1
		   && param.iOutput[0].iCode == 0x1EDE);
	}


void CTGlyphSelection::TestNonBmpCharsL()
	{
	// create a font store for testing
	CFontStore* fontStore = CFontStore::NewL(&User::Heap());
	
	//load all ecom implemented rasterizer dlls. installs the rasterizer.	
	LoadOpenFontLibraries(fontStore);
		// test font preparation
	fontStore->iKPixelWidthInTwips = 11860; //This value is default

	//add any required font files
	TUid err = fontStore->AddFileL(KTestGB18030FontFile);

	TFontSpec testGB18030FontSpec(KTestGB18030FontFaceName,200); 
	 
	CFbsBitmap* bmp = new(ELeave) CFbsBitmap;
	
	TInt ret = bmp->Create(TSize(100,100),EGray2);
	if (ret == KErrNotSupported)
		return;
	else
		User::LeaveIfError(ret);

	CFbsBitmapDevice* device = NULL;
	TRAPD(err2,device = CFbsBitmapDevice::NewL(bmp));
	TEST(err2 == KErrNone);

	CFbsBitGc* gc = NULL;
	User::LeaveIfError(device->CreateContext(gc));
	// Font file Creation
	CFbsFont* gb18030Font = NULL;
	User::LeaveIfError(device->GetNearestFontToDesignHeightInTwips(gb18030Font,testGB18030FontSpec));
	gc->UseFont(gb18030Font);
	CleanupStack::PushL(gb18030Font);
	
	//Testcode for GB18030
	((CTGlyphSelectionStep*)iStep)->RecordTestResultL();
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("TI18N-GDI-CIT-4077"));
	TestNonBmpCharsInGB18030(gb18030Font);
	((CTGlyphSelectionStep*)iStep)->RecordTestResultL();
	
	CleanupStack::Pop(gb18030Font);
	
	//Cleaning the memory
	delete bmp;
	delete device;
	delete gc;
	fontStore->RemoveFile(err);
	delete fontStore;
	REComSession::FinalClose();
	}


void CTGlyphSelection::TestTextDirection()
/**
 This method is a test case to test GetCharacterPosition() correctly
 produces glyph bounding boxes and utilizes various pen offsets in
 a horizontal and vertical context.
*/
	{
	TBool r;
	TBuf<20> testText(0);
	CFont::TPositionParam param;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	testText.SetLength(5);
	testText[0] = 'a';
	testText[1] = 'B';
	testText[2] = 'c';
	testText[3] = ' ';
	testText[4] = '1';
	param.iText.Set(testText);

	// 1: Test horizontal text pen advancement & bounds
	param.iDirection = CFont::EHorizontal;
	param.iPosInText = 0;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 1 
		   && param.iPen == TPoint(10,0)
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 'a'
		   && param.iOutput[0].iBounds.iTl == TPoint(0,-10)
		   && param.iOutput[0].iBounds.iBr == TPoint(10,2));
		   // add check for bounds

	// 2: Test horizontal text pen advancement with +ve pen offset
	param.iPosInText = 4;
	param.iPen.iX = 20;
	param.iPen.iY = 12;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 5 
		   && param.iPen == TPoint(30,12)
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == '1'
		   && param.iOutput[0].iBounds.iTl == TPoint(20,2)
		   && param.iOutput[0].iBounds.iBr == TPoint(30,14));

	// 3: Test horizontal text pen advancement with -ve pen offset
	param.iPosInText = 4;
	param.iPen.iX = -10;
	param.iPen.iY = -24;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 5 
		   && param.iPen == TPoint(0,-24)
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == '1'
		   && param.iOutput[0].iBounds.iTl == TPoint(-10,-34)
		   && param.iOutput[0].iBounds.iBr == TPoint(0,-22));

	// 4: Test vertical text pen advancement & bounds
	param.iDirection = CFont::EVertical;
	param.iPosInText = 1;
	param.iPen.iX = param.iPen.iY = 0;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 2 
		   && param.iPen == TPoint(0,12)
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == 'B'
		   && param.iOutput[0].iBounds.iTl == TPoint(0,0)
		   && param.iOutput[0].iBounds.iBr == TPoint(10,12));

	// 5: Test vertical text pen advancement with +ve pen offset
	param.iPosInText = 4;
	param.iPen.iX = 20;
	param.iPen.iY = 12;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 5 
		   && param.iPen == TPoint(20,24)
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == '1'
		   && param.iOutput[0].iBounds.iTl == TPoint(20,12)
		   && param.iOutput[0].iBounds.iBr == TPoint(30,24));

	// 6: Test vertical text pen advancement with -ve pen offset
	param.iPosInText = 4;
	param.iPen.iX = -10;
	param.iPen.iY = -24;
	r = iTestFont->GetCharacterPosition(param);
	TEST(r && param.iPosInText == 5 
		   && param.iPen == TPoint(-10,-12)
		   && param.iOutputGlyphs == 1 
		   && param.iOutput[0].iCode == '1'
		   && param.iOutput[0].iBounds.iTl == TPoint(-10,-24)
		   && param.iOutput[0].iBounds.iBr == TPoint(0,-12));
	}

void CTGlyphSelection::TestAllUnicodeChars()
/**
 This method is a test case to test GetCharacterPosition() correctly
 processes all the characters in the Unicode code space 0x0000 to 
 0xffff.
*/
	{
	TBool r;
	TBuf<8> testText(0);
	CFont::TPositionParam param;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	TInt errors = 0;
	testText.SetLength(1);
	for (TUint i = 0xd802; i <= 0xffff; i++)
		{
		testText[0] = (TText16) i;
		if (i==0x1b) continue; // Skip as CTestFont designed to fail here r==0.
		param.iText.Set(testText);
		param.iDirection = CFont::EHorizontal;
		param.iPosInText = 0;
		param.iPen.iX = param.iPen.iY = 0;
		r = iTestFont->GetCharacterPosition(param);
		if (!r || param.iPosInText != 1)
			{
			errors++;
			//RDebug::Print(_L("%04x(%d,%d,%d), "), i, r, param.iPosInText, param.iOutputGlyphs );
			//if (errors%8 == 0)
			//	RDebug::Print(_L("\n"));
			}
		}

	TEST (errors == 0);
	}

/** Tests that ligatures (presently just Lam-Alef in Arabic) work correctly
when diacritics are required on one, both or neither character comprising the
ligature. */
void CTGlyphSelection::TestLigaturesWithDiacritics()
	{
	// independent letters
	const TText KAlef = 0x627;
	const TText KLam = 0x644;
	const TText KBeh = 0x628;
	// dependent marks
	const TText KFatha = 0x64E;
	const TText KDamma = 0x64F;
	// ligature forms
	const TText KLamAlefIsolated = 0xFEFB;
	const TText KLamAlefFinal = 0xFEFC;

	struct TTestCase
		{
		// Logical order input.
		TText iInputL[8];
		// Visual order input, should be equivalent to iInputL.
		TText iInputV[8];
		// Which cluster to test
		TInt iClusterUnderTestStartL;
		TInt iClusterUnderTestStartV;
		// Expected glyphs to appear (in any order, but...)
		TInt iGlyphs[8];
		// ...number of glyphs from the start of iGlyphs that
		// are in order of their expected x-coordinates (of their
		// centres)
		TInt iGlyphsInOrder;
		};
	const TTestCase KTestCases[] =
		{
		{{KLam, KAlef, 0}, {KAlef, KLam, 0},
			0, 0, {KLamAlefIsolated, 0}, 1},
		{{KBeh, KLam, KAlef, KBeh, 0}, {KBeh, KAlef, KLam, KBeh, 0},
			1, 1, {KLamAlefFinal, 0}, 1},
		{{KLam, KFatha, KAlef, 0}, {KAlef, KLam, KFatha, 0},
			0, 0, {KLamAlefIsolated, KFatha, 0}, 1},
		{{KBeh, KLam, KFatha, KAlef, KBeh, 0}, {KBeh, KAlef, KLam, KFatha, KBeh, 0},
			1, 1, {KLamAlefFinal, KFatha, 0}, 1},
		{{KLam, KAlef, KDamma, 0}, {KAlef, KDamma, KLam, 0},
			0, 0, {KLamAlefIsolated, KDamma, 0}, 1},
		{{KBeh, KLam, KAlef, KDamma, KBeh, 0}, {KBeh, KAlef, KDamma, KLam, KBeh, 0},
			1, 1, {KLamAlefFinal, KDamma, 0}, 1},
		{{KLam, KFatha, KAlef, KDamma, 0}, {KAlef, KDamma, KLam, KFatha, 0},
			0, 0, {KDamma, KFatha, KLamAlefIsolated, 0}, 2},
		{{KBeh, KLam, KFatha, KAlef, KDamma, KBeh, 0},
			{KBeh, KAlef, KDamma, KLam, KFatha, KBeh, 0},
			1, 1, {KDamma, KFatha, KLamAlefFinal, 0}, 2},
		};
	TBuf<8> input;
	CFont::TPositionParam param;
	for (TInt testCase = 0;
		testCase != sizeof(KTestCases)/sizeof(KTestCases[0]);
		++testCase)
		{
		const TTestCase& t = KTestCases[testCase];
		for (TInt logical = 0; logical != 2; ++logical)
			{
			const TText* in = logical?
				t.iInputL : t.iInputV;
			input.Zero();
			while (*in)
				input.Append(*in++);
			param.iText.Set(input);
			param.iPosInText = logical?
				t.iClusterUnderTestStartL : t.iClusterUnderTestStartV;
			param.iFlags = static_cast<TUint16>(logical?
				CFont::TPositionParam::EFLogicalOrder : 0);
			param.iPen.SetXY(0, 0);
			TBool r = iTestFont->GetCharacterPosition(param);
			TEST(r);
			TInt currentX = KMinTInt;
			TInt expectedGlyphNo = 0;
			while (t.iGlyphs[expectedGlyphNo] != 0)
				{
				// FInd the expected glyph in the output.
				TInt outputGlyph = 0;
				while (outputGlyph != param.iOutputGlyphs
					&& static_cast<TInt>(param.iOutput[outputGlyph].iCode)
					!= t.iGlyphs[expectedGlyphNo])
					{
					++outputGlyph;
					}
				TEST(outputGlyph < param.iOutputGlyphs);
				TInt x = param.iOutput[outputGlyph].iBounds.Center().iX;
				TEST(t.iGlyphsInOrder <= expectedGlyphNo
					|| currentX < x);
				currentX = x;
				++expectedGlyphNo;
				}
			TEST(expectedGlyphNo == param.iOutputGlyphs);
			}
		}
	}
	
 #if defined(__GCC32__)
 typedef wchar_t __TText;
 #elif defined(__VC32__)
 typedef TUint16 __TText;
 #elif defined(__CW32__)
 typedef TUint16 __TText;
 #elif !defined(__TText_defined)
 #error  no typedef for __TText
 #endif
 const __TText* KLatinNoSideBearings = L"ABCDE";
 const __TText* KLatinLeftSideBearing = L"WABCD";
 const __TText* KLatinRightSideBearing = L"ABCDW";
 const __TText* KLatinBothSideBearings = L"WABCW";
 const __TText* KArabicAlefWaw = L"\x627\x648";
 const __TText* KArabicWawAlef = L"\x648\x627";
 const __TText* KGb18030NoSideBearings = L"\xD840\xDC00xyz\xD87E\xDE1D";
 const __TText* KGb18030LeftSideBearings = L"W\xD840\xDC00xy\xD87E\xDE1D";
 const __TText* KGb18030RightSideBearings = L"\xD840\xDC00xy\xD87E\xDE1DW";
 const __TText* KGb18030BothSideBearings = L"W\xD840\xDC00x\xD87E\xDE1DW";
 struct TMeasureTextTest
 	{
 	const __TText* iText;
 	TInt iExpectedAdvanceLogical;
 	TInt iExpectedAdvanceL2R;
 	TInt iExpectedBoundsL2RLeft;
 	TInt iExpectedBoundsL2RRight;
 	TInt iExpectedBoundsL2RTop;
 	TInt iExpectedBoundsL2RBottom;
 	TInt iExpectedAdvanceR2L;
 	TInt iExpectedBoundsR2LLeft;
 	TInt iExpectedBoundsR2LRight;
 	TInt iExpectedBoundsR2LTop;
 	TInt iExpectedBoundsR2LBottom;
 	};
 const TMeasureTextTest KMeasureTextResults[] =
 	{
 	{KLatinNoSideBearings, 50, 50, 0, 50, -10, 2, 50, 0, 50, -10, 2},
 	{KLatinLeftSideBearing, 50, 50, -1, 50, -10, 2, 50, 0, 51, -10, 2},
 	{KLatinRightSideBearing, 50, 50, 0, 51, -10, 2, 50, -1, 50, -10, 2},
 	{KLatinBothSideBearings, 50, 50, -1, 51, -10, 2, 50, -1, 51, -10, 2},
 	{KArabicAlefWaw, 20, 20, 0, 20, -10, 2, 20, -5, 20, -10, 2},
 	{KArabicWawAlef, 20, 20, -5, 20, -10, 2, 20, 0, 20, -10, 2},
 	// ones containing surrogate pairs
 	{KGb18030NoSideBearings, 50, 50, 0, 50, -10, 2, 50, 0, 50, -10, 2},
 	{KGb18030LeftSideBearings, 50, 50, -1, 50, -10, 2, 50, 0, 51, -10, 2},
 	{KGb18030RightSideBearings, 50, 50, 0, 51, -10, 2, 50, -1, 50, -10, 2},
 	{KGb18030BothSideBearings, 50, 50, -1, 51, -10, 2, 50, -1, 51, -10, 2},
 	};
 /** Tests CFont::MeasureText */
 void CTGlyphSelection::TestMeasureText()
 	{
 	CFont::TMeasureTextInput input;
 	CFont::TMeasureTextOutput output;
 	TInt advance;
 	for (TInt i = 0;
 		i != sizeof(KMeasureTextResults)/sizeof(KMeasureTextResults[0]); ++i)
 		{
 		TPtrC text(reinterpret_cast<const TText16*>(
 			KMeasureTextResults[i].iText));
 		advance = iTestFont->MeasureText(text, &input, &output);
 		TEST(advance == KMeasureTextResults[i].iExpectedAdvanceLogical);
 		input.iFlags = CFont::TMeasureTextInput::EFVisualOrder;
 		advance = iTestFont->MeasureText(text, &input, &output);
 		TEST(advance == KMeasureTextResults[i].iExpectedAdvanceL2R);
 		TEST(output.iBounds.iTl.iX == KMeasureTextResults[i].iExpectedBoundsL2RLeft);
 		TEST(output.iBounds.iBr.iX == KMeasureTextResults[i].iExpectedBoundsL2RRight);
 		TEST(output.iBounds.iTl.iY == KMeasureTextResults[i].iExpectedBoundsL2RTop);
 		TEST(output.iBounds.iBr.iY == KMeasureTextResults[i].iExpectedBoundsL2RBottom);
 		input.iFlags = CFont::TMeasureTextInput::EFVisualOrderRightToLeft;
 		advance = iTestFont->MeasureText(text, &input, &output);
 		TEST(advance == KMeasureTextResults[i].iExpectedAdvanceR2L);
 		TEST(output.iBounds.iTl.iX == KMeasureTextResults[i].iExpectedBoundsR2LLeft);
 		TEST(output.iBounds.iBr.iX == KMeasureTextResults[i].iExpectedBoundsR2LRight);
 		TEST(output.iBounds.iTl.iY == KMeasureTextResults[i].iExpectedBoundsR2LTop);
 		TEST(output.iBounds.iBr.iY == KMeasureTextResults[i].iExpectedBoundsR2LBottom);
 		}

	INFO_PRINTF1(_L("Test fix for INC086257 - EFIncludePenPositionInBoundsCheck"));
	// left-to-right w/o flag and bounds set to just fit string disregarding sidebearings
	input.iFlags = 0;
	input.iMaxBounds = 50;
	iTestFont->MeasureText(_L("XXXXX"), &input, &output);
	TEST(output.iChars == 5);
	// set flag, string should no longer fit (break happens)
	input.iFlags = CFont::TMeasureTextInput::EFIncludePenPositionInBoundsCheck;
	iTestFont->MeasureText(_L("XXXXX"), &input, &output);
	TEST(output.iChars == 4);
	// right-to-left w/o flag and bounds set to just fit string disregarding sidebearings
	input.iFlags = CFont::TMeasureTextInput::EFVisualOrderRightToLeft;
	iTestFont->MeasureText(_L("\x5EA\x5EA\x5EA\x5EA\x5EA"), &input, &output);
	TEST(output.iChars == 5);
	// set flag, string should no longer fit (break happens)
	input.iFlags |= CFont::TMeasureTextInput::EFIncludePenPositionInBoundsCheck;
	iTestFont->MeasureText(_L("\x5EA\x5EA\x5EA\x5EA\x5EA"), &input, &output);
	TEST(output.iChars == 4);
	// top-to-bottom w/o flag and bounds set to just fit string disregarding endbearings
	input.iFlags = 0;
	input.iMaxBounds = 60;
	input.iDirection = CFont::EVertical;
	iTestFont->MeasureText(_L("\x304B\x304B\x304B\x304B\x304B"), &input, &output);
	TEST(output.iChars == 5);
	// set flag, string should no longer fit (break happens)
	input.iFlags = CFont::TMeasureTextInput::EFIncludePenPositionInBoundsCheck;
	iTestFont->MeasureText(_L("\x304B\x304B\x304B\x304B\x304B"), &input, &output);
	TEST(output.iChars == 4);
 	}
 
void CTGlyphSelection::RunTestCaseL(TInt aCurTestCase)
/**
 This method will execute each test case method in the class
 logging its progress as it does so.
*/
	{
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(KUnknownSYMTestCaseIDName);
	switch(aCurTestCase)
		{
	case 1:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0200
*/
        ((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0200"));
		INFO_PRINTF1(_L("Test API Boundaries"));
		TestApiBoundaries();
		break;
	case 2:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0201
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0201"));
		INFO_PRINTF1(_L("Test CTRL Chars"));
		TestCtrlCharsIgnored();
		break;
	case 3:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0202
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0202"));
		INFO_PRINTF1(_L("Test Latin Chars"));
		TestLatinChars();
		break;
	case 4:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0203
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0203"));
		INFO_PRINTF1(_L("Test Soft Hypen Char"));
		TestSoftHyphen();
		break;
	case 5:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0204
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0204"));
		INFO_PRINTF1(_L("Test Surrogate Pairs"));
		TestSurrogates();
		INFO_PRINTF1(_L("Test Supplementary Chars"));
		TestNonBmpCharsL();
		break;
	case 6:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0205
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0205"));
		INFO_PRINTF1(_L("Test Combining Latin Chars"));
		TestCombiningLatinChars();
		break;
	case 7:
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0221"));
		INFO_PRINTF1(_L("Test Vietnamese Chars"));
		TestVietnameseChars();
		break;
	case 8:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0206
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0206"));
   		INFO_PRINTF1(_L("Test Vertical/Horizontal Text Bounds"));
   		TestTextDirection();
   		break;
 	case 9:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0207
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0207"));
   		INFO_PRINTF1(_L("Test All Unicode Characters"));
   		TestAllUnicodeChars();
   		break;
 	case 10:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0208
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0208"));
   		INFO_PRINTF1(_L("Test Ligatures with Diacritics"));
   		TestLigaturesWithDiacritics();
   		break;
 	case 11:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0209
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0209"));
 		INFO_PRINTF1(_L("Test CFont::MeasureText()"));
 		TestMeasureText();
 		break;
  	case 12:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0210
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0210"));
  		INFO_PRINTF1(_L("Test Indic Glyphs"));
  		TestIndicCharsL();	
		break;
   	case 13:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0211
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0211"));
  		INFO_PRINTF1(_L("Test Thai Rendering"));
   		ExecuteThaiTests();	
   		break;
   	case 14:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0212
*/
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0212"));
		INFO_PRINTF1(_L("Test isolated Combining Latin Chars"));
		TestIsolatedCombiningLatinChars();
		break;
   	case 15:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0213
*/
   		INFO_PRINTF1(_L("Test Indic Gurmukhi and Malayalam Chars"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0213"));
   		ExecuteIndicGurmukhiMalayalamTests();
   		break;
   	case 16:
/**
@SYMTestCaseID 				GRAPHICS-SYSLIB-GDI-CIT-0214
*/
   		INFO_PRINTF1(_L("Test Rendering Context"));
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CIT-0214"));
   		TestContextInShapeInfo();
   		break;
   	case 17:
   		TestComplete();
		((CTGlyphSelectionStep*)iStep)->SetTestStepID(KNotATestSYMTestCaseIDName);
		((CTGlyphSelectionStep*)iStep)->CloseTMSGraphicsStep();
   		break;	
   		}
	((CTGlyphSelectionStep*)iStep)->RecordTestResultL();
	}

void CTGlyphSelection::TestPerformance()
/**
 This method tests the performance of the API under test
 by executing a 10000 cycles of each test case.
**/
	{
	TStopWatch profile;
	INFO_PRINTF1(_L("Test Performance..."));

	profile.Start();
	for (TInt i = 0; i < 10000; i++)
		{
		TestCtrlCharsIgnored();
		TestLatinChars();
		TestSoftHyphen();
		TestSurrogates();
		TestCombiningLatinChars();
		TestTextDirection();
		
		}
	TUint numMilliSecs = profile.Stop();

	INFO_PRINTF3(_L("Performance test end %d.%d s\n"),numMilliSecs/1000,numMilliSecs%1000);
	}


void CTGlyphSelection::TestThai_SimpleChars()
/**
 This routine tests individual Thai base characters pumping them 
 through the CFont::GetCharacterPosition() API.
*/
	{
	TBool r;
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;
	TBuf<5> testText(0);
	testText.SetLength(1);
	param.iText.Set(testText);

	for (TUint i=0; Thai_SimpleChars[i] != 0xFFFF; i++)
		{
		testText[0] = Thai_SimpleChars[i];
		param.iPosInText = 0;
		param.iPen.iX = param.iPen.iY = 0;

		r = iTestFont->GetCharacterPosition(param);

		TEST(r && param.iPosInText == 1 
			   && param.iPen.iX == 10
			   && param.iOutputGlyphs == 1 
			   && param.iOutput[0].iCode == Thai_SimpleChars[i]);
		}
	}


void CTGlyphSelection::TestThai_ValidGlyphClusters()
/**
 This routine tests combining sequences of Thai base & mark 
 characters pumping them through the CFont::GetCharacterPosition() API.
 The sequences mainly test the correct formation of Thay Glyph clusters
 and the PUA substutions that take place.
*/
	{
	TInt failures=0;
	TBool r;
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	for (TUint i=0; Thai_ValidGlyphClusters[i].iTextLen != -1; i++)
		{
		TBuf<8> testText(Thai_ValidGlyphClusters[i].iText);
		param.iText.Set(testText);
		param.iPosInText = Thai_ValidGlyphClusters[i].iPosInText;
		param.iPen.iX = param.iPen.iY = 0;

		r = iTestFont->GetCharacterPosition(param);

		if (r && param.iPosInText == Thai_ValidGlyphClusters[i].oPosInText
			   && param.iOutputGlyphs == Thai_ValidGlyphClusters[i].oOutputLen)
			{
			for (TInt j=0; j<Thai_ValidGlyphClusters[i].oOutputLen; j++)
				{
				if (param.iOutput[j].iCode != Thai_ValidGlyphClusters[i].oOutput[j])
					{
					INFO_PRINTF4(_L("FAILURE: Glyph code invariance, Complex TEST(%d), %x != %x\n"), i, param.iOutput[j].iCode, Thai_ValidGlyphClusters[i].oOutput[j]);
					failures++;
					break;
					}
				}
			}
		else
			{
			INFO_PRINTF2(_L("FAILURE: Bad output result from GetCharacterPosition, Complex TEST(%d)\n"), i);
			failures++;
			}
		}

	TEST(failures == 0);
	}


void CTGlyphSelection::TestThai_InvalidGlyphClusters()
/**
 This routine tests Thai base & mark cluster boundaries to ensure where 
 requried the KUnicodeDottedCircle char is used when an invalid sequence is 
 processed. Test data from the global Thai_GlyphClusterBoundaries 
 variable is pumped through the CFont::GetCharacterPosition() API.
*/
	{
	TInt failures=0;
	TBool r;
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;

	for (TUint i=0; Thai_GlyphClusterBoundaries[i].iTextLen != -1; i++)
		{
		TBuf<8> testText(Thai_GlyphClusterBoundaries[i].iText);
		param.iText.Set(testText);

		for (TUint k=0; k<2; k++)
			{
			if (Thai_GlyphClusterBoundaries[i].oOut[k].iPosInText == -1)
				continue;

			param.iPosInText = Thai_GlyphClusterBoundaries[i].oOut[k].iPosInText;
			param.iPen.iX = param.iPen.iY = 0;

			r = iTestFont->GetCharacterPosition(param);

			if (r && param.iPosInText == Thai_GlyphClusterBoundaries[i].oOut[k].oPosInText
				   && param.iOutputGlyphs == Thai_GlyphClusterBoundaries[i].oOut[k].oOutputLen)
				{
				for (TInt j=0; j<Thai_GlyphClusterBoundaries[i].oOut[k].oOutputLen; j++)
					{
					if (!(param.iOutput[j].iCode == Thai_GlyphClusterBoundaries[i].oOut[k].oOutput[j]))
						{
						INFO_PRINTF5(_L("FAILURE: Glyph code invariance, Complex TEST(%d,%d), %x != %x\n"), i, k, param.iOutput[j].iCode, Thai_GlyphClusterBoundaries[i].oOut[k].oOutput[j]);
						failures++;
						break;
						}
					}
				}
			else
				{
				INFO_PRINTF3(_L("FAILURE: Bad output result from GetCharacterPosition, Complex TEST(%d,%d)\n"), i, k);
				failures++;
				}

			}
		}

	if (failures)
		RDebug::Print(_L("TOTAL FAILURES: %d\n"), failures);
	TEST(failures == 0);
	}

/**
@SYMTestCaseID          GRAPHICS-SYSLIB-GDI-CT-4062
@SYMTestCaseDesc        Tests that a punctuation character following the special-case
                        character Thai SaraAm is rendered as a punctuation, not
                        another SaraAm character.
@SYMTestPriority        High
@SYMTestActions         Compare input string and corresponding output glyph codes
@SYMTestExpectedResults In this case, the string and the codes should match.
@SYMDEF                 INC118424
*/
void CTGlyphSelection::TestThai_INC118424()
	{
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;
	
	//punctuation after SaraAm
	TestGlyphs(iTestFont,param,_L("\xE04\xE33:\?>"),_L("\xE04\xE33:\?>"));
	}

/**
 This fuction tests Indic Gurmukhi and Malayalam support
*/
void CTGlyphSelection::ExecuteIndicGurmukhiMalayalamTests()
	{
	// create a font store for testing
	CFontStore* fontStore = CFontStore::NewL(&User::Heap());
	
	//load all ecom implemented rasterizer dlls. installs the rasterizer.	
	LoadOpenFontLibraries(fontStore);
		// test font preparation
	fontStore->iKPixelWidthInTwips = 11860; //This value is default

	//add any required font files
	TUid err1 = fontStore->AddFileL(KTestIndicFontFile);

	TFontSpec testIndicFontSpec(KTestIndicFontFaceName,200);
	 
	CFbsBitmap* bmp = new(ELeave) CFbsBitmap;
	
	TInt ret = bmp->Create(TSize(100,100),EGray2);
	if (ret == KErrNotSupported)
		return;
	else
		User::LeaveIfError(ret);

	CFbsBitmapDevice* device = NULL;
	TRAPD(err2,device = CFbsBitmapDevice::NewL(bmp));
	TEST(err2 == KErrNone);

	CFbsBitGc* gc = NULL;
	User::LeaveIfError(device->CreateContext(gc));
	
	// Font file Creation
	CFbsFont* indicFont = NULL;
	User::LeaveIfError(device->GetNearestFontToDesignHeightInTwips(indicFont,testIndicFontSpec));
	gc->UseFont(indicFont);
	CleanupStack::PushL(indicFont);
	
	//Testcode for Kannada, Marathi,Gujarati,Bengali language
	// Test Indic Gurmukhi digit.
	TInt err;
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	INFO_PRINTF1(_L("Test Indic Gurmukhi digits"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-TI18N-GDI-CIT-4063"));
	TestGurmukhiDigit( *indicFont );
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	INFO_PRINTF1(_L("Test Indic Gurmukhi and Latin"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-TI18N-GDI-CIT-4064"));
	TestGurmukhiAndLatin( *indicFont );
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	INFO_PRINTF1(_L("Test Indic DEF102858 on Gurmukhi"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-TI18N-GDI-CIT-4065"));
	TestGurmukhiModifierAfterConsonantViramaZWJ( *indicFont );
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	INFO_PRINTF1(_L("Test Indic Gurmukhi consonant leading"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-TI18N-GDI-CIT-4066"));
	TestGurmukhiWithConsonantInitial( *indicFont );
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	INFO_PRINTF1(_L("Test Indic Gurmukhi vowel leading"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-TI18N-GDI-CIT-4068"));
	TestGurmukhiWithVowelInitial( *indicFont );
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	INFO_PRINTF1(_L("Test Indic Malayalam digits"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-TI18N-GDI-CIT-4067"));
	TestMalayalamDigit( *indicFont );
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	INFO_PRINTF1(_L("Test Indic Malayalam and Latin"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-TI18N-GDI-CIT-4069"));
	TestMalayalamAndLatin( *indicFont );
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	INFO_PRINTF1(_L("Test Indic DEF102858 on Malayalam"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-TI18N-GDI-CIT-4070"));
	TestMalayalamModifierAfterConsonantViramaZWJ( *indicFont );
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	INFO_PRINTF1(_L("Test Indic Malayalam consonant leading"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-TI18N-GDI-CIT-4071"));
	TestMalayalamWithConsonantInitial( *indicFont );
	TRAP(err,((CTGlyphSelectionStep*)iStep)->RecordTestResultL());
    	if (err!=KErrNone)
    		INFO_PRINTF1(_L("Failed to record test result"));
	INFO_PRINTF1(_L("Test Indic Malayalam vowel leading"));
	((CTGlyphSelectionStep*)iStep)->SetTestStepID(_L("GRAPHICS-TI18N-GDI-CIT-4072"));
	TestMalayalamWithVowelInitial( *indicFont );
	CleanupStack::Pop(indicFont);
			
	//Cleaning the memory
	delete bmp;
	delete device;
	delete gc;
	fontStore->RemoveFile(err1);
	delete fontStore;
	REComSession::FinalClose();
	}
/**
 This function tests the Thai Font Rendering feature of the CFont class
 in the GDI.dll and in particular the modifications made to 
 CFont::GetCharacterPosition() to support the Unicocde Thai code page.
 First introduced during the Sirocco project (A3.1.1)
@SYMFssID Graphics/GDI/GDI/1
@SYMFssID Graphics/GDI/GDI/2
*/

void CTGlyphSelection::ExecuteThaiTests()
	{
	// Test individual Thai digits, letters and sign characters.
	INFO_PRINTF1(_L("Test Thai simple charecters"));
	TestThai_SimpleChars();

	// Test complex Thai char sequences.
	INFO_PRINTF1(_L("Test valid Thai glyph clusters"));
	TestThai_ValidGlyphClusters();

	// Test Thai glyph cluster boundaries.
	INFO_PRINTF1(_L("Test invalid Thai glyph clusters"));
	TestThai_InvalidGlyphClusters();

	// Test Thai SaraAm-punctuation exception.
	INFO_PRINTF1(_L("Test fix for INC118424"));
	TestThai_INC118424();
	}


/*  
 * Note:
 *       This is just a easy way to help generate the test data info
 *       Any new added test data should do manually check firstly to check the correction before using this function
 */
// #define GEN_GURMUKHIMALAYALAMTESTDATA
void CTGlyphSelection::GenerateGurmukhiMalayalamData( const TDesC& filename, const TTestInput_PositionParam6* testArray, const CFbsFont& aFont )
    {
    RFile file;
    file.Replace( iFs, filename, EFileWrite );
    
    CFont::TPositionParam param;
    param.iDirection = CFont::EHorizontal;
    param.iFlags = CFont::TPositionParam::EFLogicalOrder;
    RShapeInfo shapeInfo;

    if (!testArray)
        {
        return;
        }

    for (TUint i = 0; testArray[i].iTextLen != -1; i++)
        {
        TTestInput_PositionParam6 currentArray = testArray[i];
        TBuf<8> testText(testArray[i].iText);
        param.iText.Set(testText);
        
        TBuf8<256> datatext;
        datatext.SetLength(0);
        //{ 1, {0x0a66}, { {0, 1, 1, {0x12fe} }, {-1, 1, 1, {0} } } },
        datatext.Format(_L8("{ %d, {"), testArray[i].iTextLen);  // 1, 
        
        for (TUint i = 0; i<testText.Length(); i++)
            {
            TBuf8<8> tmp;
            tmp.Format(_L8("0x%x, "), currentArray.iText[i]); // {0x0a66},
            datatext.Append(tmp);
            }
        datatext = datatext.Left(datatext.Length()-2);
        datatext.Append(_L8("}, { "));

        if (shapeInfo.IsOpen())
            shapeInfo.Close();

        for (TUint k = 0; k < 6; k++)
            {
            param.iPosInText = k;
            param.iPen.iX = param.iPen.iY = 0;
            TBool ret = aFont.GetCharacterPosition2(param, shapeInfo);
            if (0 == param.iOutputGlyphs)
                continue;
            
            TBuf8<16> tmp;
            tmp.Format(_L8("{%d, %d, %d, {"), k, param.iPosInText, param.iOutputGlyphs);
            datatext.Append(tmp);
            
            for (TInt j = 0; j < param.iOutputGlyphs; j++)
                {
                TText16 aCode = param.iOutput[j].iCode;
                TBuf8<128> tmp;
                tmp.Format(_L8("0x%x, "), aCode);
                datatext.Append(tmp);
                } //end for
            datatext = datatext.Left(datatext.Length()-2);
            datatext.Append(_L8("}}, "));
            } //end for
        datatext.Append(_L8(" {-1, 1, 1, {0}} } }, \n"));
        
        file.Write(datatext);
        } //end for
    
    file.Close();
    return;
    }

void CTGlyphSelection::DoEachGurmukhiMalayalamCase( const TTestInput_PositionParam6* testArray, const CFbsFont& aFont )
	{
	TInt failures=0;
	TBool r;
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iFlags = CFont::TPositionParam::EFLogicalOrder;
	RShapeInfo shapeInfo;
	
	if ( !testArray )
		{
		return;
		}
	
	for (TUint i=0; testArray[i].iTextLen != -1; i++)
		{
		TBuf<8> testText(testArray[i].iText);
		param.iText.Set(testText);
		if(shapeInfo.IsOpen())
		    shapeInfo.Close();
		
		for (TUint k=0; k<6; k++)
			{
			//	If it's end of sequence
			if ( testArray[i].oOut[k].iPosInText == -1)
				break;
	
			param.iPosInText = testArray[i].oOut[k].iPosInText;
			param.iPen.iX = param.iPen.iY = 0;
	
			r = aFont.GetCharacterPosition2(param, shapeInfo);
			
			if (r && param.iPosInText == testArray[i].oOut[k].oPosInText
				   && param.iOutputGlyphs == testArray[i].oOut[k].oOutputLen)
				{
				for (TInt j=0; j<testArray[i].oOut[k].oOutputLen; j++)
					{
					//	Trim off the highest bit
					TText16 aCode = param.iOutput[j].iCode;
					if (!( aCode == testArray[i].oOut[k].oOutput[j]))
						{
						INFO_PRINTF5(_L("FAILURE: Glyph code invariance, Complex TEST(%d,%d), %x != %x\n"), i, k, param.iOutput[j].iCode, testArray[i].oOut[k].oOutput[j]);
						failures++;
						break;
						}
					}
				}
			else
				{
				INFO_PRINTF4(_L("FAILURE: Bad output result from GetCharacterPosition, Complex TEST(%d,%d,%d)\n"), i, k, param.iOutputGlyphs);
				failures++;
				}
	
			}
		}
	
	if (failures)
		RDebug::Print(_L("TOTAL FAILURES: %d\n"), failures);
	TEST(failures == 0);
	}
/**
@SYMTestCaseID          GRAPHICS-TI18N-GDI-CIT-4063
@SYMTestCaseDesc        Case to check Gurmukhi digit support
@SYMTestPriority        High
@SYMTestActions         Call to CFont::GetCharacterPosition2/CFont::MeasureText to check the following
						1.Pass Gurmukhi digit (0xa66 ~ 0x0a6f) sequence
						2.Pass any Consonant + Gurmukhi digit sequence 
						3.Pass any Consonant + Gurmukhi digit + Matra sequence
						4.Repetitive callss with Unicode sequence from the first 3 action items 
						5.Pass Modifer + digit sequence
						6.Pass Vowel and digit sequence
						7.Pass Virama and digit sequence 
@SYMTestExpectedResults 1.Glyph count, character count for digit is 1 for each digit, and glyph indices depends on font
						2.Digit is recognized as a separate syllable
						3.Matra and digit is not combined together
						4.The shaper returned the same result as first 3 results
						5.digit is recognized, and not combined with Modifier
						6.digit is recognized, and not combined with Vowel.
						7.digit is recognized, and not combined with Virama.
@SYMPREQ 1922: Gurmukhi support
*/
void CTGlyphSelection::TestGurmukhiDigit( const CFbsFont& aFont )
	{
	DoEachGurmukhiMalayalamCase( (TTestInput_PositionParam6*)Indic_GurmukhiDigit, aFont );
	
#ifdef GEN_GURMUKHIMALAYALAMTESTDATA
	_LIT(KValidFontPath, "c:\\GurmukhiDigit.txt");
	GenerateGurmukhiMalayalamData(KValidFontPath, (TTestInput_PositionParam6*)Indic_GurmukhiDigit, aFont );
#endif
	}

/**
@SYMTestCaseID          GRAPHICS-TI18N-GDI-CIT-4064
@SYMTestCaseDesc        case to check if shaper can render Gurmukhi with other implemented Indic scripts and Latin
@SYMTestPriority        High
@SYMTestActions         Call to CFont::GetCharacterPosition2/CFont::MeasureText to check the following
						1.Pass Gurmukhi sentence and Latin to the function
						2.Pass Latin and Gurmukhi setence.
						3.Pass syllable, Latin and syllable
						4.Pass phoneme, Latin and phoneme
						5.Pass Gurmukhi syllable and other Indic scripts together.
						6.Pass Gurmukhi phoneme and other Indic script phoneme
@SYMTestExpectedResults Gurumuki and Latin characters dont mess up. Gurmukhi phoneme doesnt combine with Latin into a new syllable, 
						Gurmukhi phoneme doesnt form a syllable with other Indic script.
@SYMPREQ 1922: Gurmukhi support
*/
void CTGlyphSelection::TestGurmukhiAndLatin( const CFbsFont& aFont )
	{
	DoEachGurmukhiMalayalamCase( (TTestInput_PositionParam6*)Indic_GurmukhiAndLatin, aFont );

#ifdef GEN_GURMUKHIMALAYALAMTESTDATA
    _LIT(KValidFontPath, "c:\\GurmukhiAndLatin.txt");
    GenerateGurmukhiMalayalamData(KValidFontPath, (TTestInput_PositionParam6*)Indic_GurmukhiDigit, aFont );
#endif
	}

/**
@SYMTestCaseID          GRAPHICS-TI18N-GDI-CIT-4065
@SYMTestCaseDesc        case to check Gurmukhi modifier after Consonant, Virama, ZWJ
@SYMTestPriority        High
@SYMTestActions         Call to CFont::GetCharacterPosition2/CFont::MeasureText to check the following
						1.Pass Consonant + Virama + ZWJ + Modifier
@SYMTestExpectedResults Modifier is part of the syllable.
@SYMPREQ 1922: Gurmukhi support, make sure DEF102858 fixing does not cause side effect
*/
void CTGlyphSelection::TestGurmukhiModifierAfterConsonantViramaZWJ( const CFbsFont& aFont )
	{
	DoEachGurmukhiMalayalamCase( (TTestInput_PositionParam6*)Indic_GurmukhiModifierAfterConsonantViramaZWJ, aFont );
	
#ifdef GEN_GURMUKHIMALAYALAMTESTDATA
    _LIT(KValidFontPath, "c:\\GurmukhiModifierAfterConsonantViramaZWJ.txt");
    GenerateGurmukhiMalayalamData(KValidFontPath, (TTestInput_PositionParam6*)Indic_GurmukhiDigit, aFont );
#endif
	}

/**
@SYMTestCaseID          GRAPHICS-TI18N-GDI-CIT-4066
@SYMTestCaseDesc        case to check syllable with consonant in initial position
@SYMTestPriority        High
@SYMTestActions         Call to CFont::GetCharacterPosition2/CFont::MeasureText to check the following using data from above requirements, each requirement above gives a consonant leading Unicode sequence. Each sequence falls into one of the following structure, then pass it to the calling.
						1.Pass  consonant and Nukta sequence
						2.Pass two consonant and dependent vowel sequences to shaper, save both returned results. The consonant is first sequence is difference with that of the second sequence..
						3.Pass consonant and matra /i/ t sequence 
						4.Pass the following Consonant, Virama and HA sequence 
						  Another sequence:  Consonant , Virama and RA
						  Another sequence:  Consonant, Virama and VA
						  Another sequence:  Consonant, Virama and YA
						5.Pass Consonant  and Addak sequence to shaper 
						  Pass Consonant, Addak and Consonant to shaper
						6.Pass Consonant and BINDI sequence:  
						  Sequence1:Consonant and BINDI,
						  Sequence2: Consonant, dependent vowel which is shown to the right of base consonant and BINDI,
						  Sequence3: Consonant, dependent vowel which is shown to the top of the base consonant and BINDI
						  Pass Consonant and TIPPI sequence:
						  Sequence1: Consonant and TIPPI, 
						  Sequence2: Consonant, dependent vowel which is shown to the left of the base consonant and TIPPI.
						  Sequence3: Consonant, dependent vowel which is shown to the bottom of the base consonant and TIPPI.
						7.Pass Nukta, equavalent consonant, Nukta sequence to shaper sepeartely, save both result
@SYMTestExpectedResults 1.nukta is combined to the base consonant according to the returned shape info
						2.The matra position is different between two ShapeText calls according to the returned shaped info.
						3.matra /i/ is combined to the left of the base consonant in position
						4.HA, RA, VA is on bottom of the base consonant and subscripted, YA in final form according to the returned shape info.
						5.Addak is on top of consonant, addak belongs to the consonant precedes it.
						6.BINDI is on top,  TIPPI is on bottom
						7.The combinations character count, glyph count, glyph indices info is the same as  the single nuktas
@SYMPREQ 1922: Gurmukhi support
*/
void CTGlyphSelection::TestGurmukhiWithConsonantInitial( const CFbsFont& aFont )
	{
	DoEachGurmukhiMalayalamCase( (TTestInput_PositionParam6*)Indic_GurmukhiConsonantLeading, aFont );
	
#ifdef GEN_GURMUKHIMALAYALAMTESTDATA
    _LIT(KValidFontPath, "c:\\GurmukhiWithConsonantInitial.txt");
    GenerateGurmukhiMalayalamData(KValidFontPath, (TTestInput_PositionParam6*)Indic_GurmukhiDigit, aFont );
#endif
	}


/**
@SYMTestCaseID          GRAPHICS-TI18N-GDI-CIT-4067
@SYMTestCaseDesc        Case to check Malayalam digit support
@SYMTestPriority        High
@SYMTestActions         Call to CFont::GetCharacterPosition2/CFont::MeasureText to check the following
						1.Pass Malayalam digit (0xd66 ~ 0x0d6f) sequence
						2.Pass any Consonant + Malayalam digit sequence 
						3.Pass any Consonant + Malayalam digit + Matra sequence
						4.Repetitive callss with Unicode sequence from the first 3 action items 
						5.Pass Modifer + digit sequence
						6.Pass Vowel and digit sequence
						7.Pass Virama and digit sequence 
@SYMTestExpectedResults 1.Glyph count, character count for digit is 1 for each digit, and glyph indices depends on font
						2.Digit is recognized as a separate syllable
						3.Matra and digit is not combined together
						4.The shaper returned the same result as first 3 results
						5.digit is recognized, and not combined with Modifier
						6.digit is recognized, and not combined with Vowel.
						7.digit is recognized, and not combined with Virama.
@SYMPREQ 1922: Malayalam support
*/
void CTGlyphSelection::TestMalayalamDigit( const CFbsFont& aFont )
	{
	DoEachGurmukhiMalayalamCase( (TTestInput_PositionParam6*)Indic_MalayalamDigit, aFont );
	
#ifdef GEN_GURMUKHIMALAYALAMTESTDATA
    _LIT(KValidFontPath, "c:\\MalayalamDigit.txt");
    GenerateGurmukhiMalayalamData(KValidFontPath, (TTestInput_PositionParam6*)Indic_GurmukhiDigit, aFont );
#endif	
	}

/**
@SYMTestCaseID          GRAPHICS-TI18N-GDI-CIT-4068
@SYMTestCaseDesc        case to check syllable with vowel in initial position
@SYMTestPriority        High
@SYMTestActions         Call to CFont::GetCharacterPosition2/CFont::MeasureText to check the following using data from above requirements, 
						each requirement above gives a vowel leading Unicode sequence. Each sequence falls into one of the following structure, 
						then pass it to the calling.
						1.Pass ARA, IRI to shaper, pass URA sequence
						2.Pass valid bearer  and vowel pair sequence
						  Pass invalid bearer and vowel pair sequence
@SYMTestExpectedResults 1.ARA character count is 1, IRI, URA character count is 0
						2.valid combination is combined together, invalid is not combined together
@SYMPREQ 1922: Gurmukhi support
*/
void CTGlyphSelection::TestGurmukhiWithVowelInitial( const CFbsFont& aFont )
	{
	DoEachGurmukhiMalayalamCase( (TTestInput_PositionParam6*)Indic_GurmukhiVowelLeading, aFont );
	
#ifdef GEN_GURMUKHIMALAYALAMTESTDATA
    _LIT(KValidFontPath, "c:\\GurmukhiWithVowelInitial.txt");
    GenerateGurmukhiMalayalamData(KValidFontPath, (TTestInput_PositionParam6*)Indic_GurmukhiDigit, aFont );
#endif  
	}

/**
@SYMTestCaseID          GRAPHICS-TI18N-GDI-CIT-4069
@SYMTestCaseDesc        case to check if shaper can render Malayalam with other implemented Indic scripts and Latin
@SYMTestPriority        High
@SYMTestActions         Call to CFont::GetCharacterPosition2/CFont::MeasureText to check the following
						1.Pass Malayalam sentence and Latin to the function
						2.Pass Latin and Gurmukhi setence.
						3.Pass syllable, Latin and syllable
						4.Pass phoneme, Latin and phoneme
						5.Pass Malayalam syllable and other Indic scripts together.
						6.Pass Malayalam phoneme and other Indic script phoneme
@SYMTestExpectedResults Malayalam and Latin characters dont mess up. Malayalam phoneme doesnt combine with Latin into a new syllable, 
						Malayalam phoneme doesnt form a syllable with other Indic script.
@SYMPREQ 1922: Malayalam support
*/
void CTGlyphSelection::TestMalayalamAndLatin( const CFbsFont& aFont )
	{
	DoEachGurmukhiMalayalamCase( (TTestInput_PositionParam6*)Indic_MalayalamAndLatin, aFont );
	
#ifdef GEN_GURMUKHIMALAYALAMTESTDATA
    _LIT(KValidFontPath, "c:\\MalayalamAndLatin.txt");
    GenerateGurmukhiMalayalamData(KValidFontPath, (TTestInput_PositionParam6*)Indic_GurmukhiDigit, aFont );
#endif  
	}

/**
@SYMTestCaseID          GRAPHICS-TI18N-GDI-CIT-4070
@SYMTestCaseDesc        case to check  Malayalam modifier after Consonant, Virama, ZWJ
@SYMTestPriority        High
@SYMTestActions         Call to CFont::GetCharacterPosition2/CFont::MeasureText to check the following
						1. Pass Consonant + Virama + ZWJ + Modifier
@SYMTestExpectedResults Modifier is part of the syllable.
@SYMPREQ 1922: Malayalam support, make sure DEF102858 fixing does not cause side effect 
*/
void CTGlyphSelection::TestMalayalamModifierAfterConsonantViramaZWJ( const CFbsFont& aFont )
	{
	DoEachGurmukhiMalayalamCase( (TTestInput_PositionParam6*)Indic_MalayalamModifierAfterConsonantViramaZWJ, aFont );
	
#ifdef GEN_GURMUKHIMALAYALAMTESTDATA
    _LIT(KValidFontPath, "c:\\MalayalamModifierAfterConsonantViramaZWJ.txt");
    GenerateGurmukhiMalayalamData(KValidFontPath, (TTestInput_PositionParam6*)Indic_GurmukhiDigit, aFont );
#endif  
	}

/**
@SYMTestCaseID          GRAPHICS-TI18N-GDI-CIT-4071
@SYMTestCaseDesc        case to check syllable with consonant in initial position
@SYMTestPriority        High
@SYMTestActions         Call to CFont::GetCharacterPosition2/CFont::MeasureText to check the following using data from above requirements, 
						each requirement above gives a consonant leading Unicode sequence. Each sequence falls into one of the following structure, 
						then pass it to the calling.
						1.Pass consonant + vowel single code, and  consonant + its split representation to shaper
						  The following Single representation /Split representation is passed to shaper
						  0x0d14/0x0d12 + 0x0d57, 0x0d4a/0x0d46 + 0x0d3e, 0x0d4b/0x0d47 + 0x0d3e
						  0x0d4c/0x0d46 + 0x0d57
						2.Pass two Consonant and dependent Vowel sequences to shaper, save both returned results. 
						  The Consonant is first sequence is difference with that of the second sequence, and the dependent Vowel is identical.
						3.Pass Consonant and Matras /-e/, /-ee/, /-ai/ to shaper. 
						4.Pass Consonant and Matras /-o/, /-oo/, /-au/ to shaper
						  Pass Consonant and 0x0d4c (first form of Matra /-au/ ) to shaper,
						  Pass Consonant, 0x0d46 and 0x0d57 (second form of Matra /-au/) to shaper002E
						5.Pass Consonant + 0x0d4d + Consonant to shaper
						  Pass Consonant + Virama + Consonant + 0x0d4d to shaper
						6.Pass Consonant (NNA, NA, RA, LA, LLA) + Virama + ZWJ to shaper
						  Pass KA + Virama + ZWJ to shaper.
						  Pass other Consonant + Virama + ZWJ to shaper.
						7.Pass RA + Virama + ZWJ to shaper,
						  Pass RRA + Viram + ZWJ to shaper.
						8.Pass Chillu ( one of 6 special consontants + Virama + ZWJ) and Vowel to shaper
						  Pass Chillu and Modifier to shaper
						  Pass Chillu and Virama to shaper
						9.Pass one of (KA, GA, PA, BA, MA, LA, SHA, SA, HA), Virama and LA to shaper
						10.Pass CA, Virama and CA to shaper
						   Pass BA, Virama and BA to shaper
						   Pass YA, Virama and YA to shaper
						   Pass VA, Virama and VA to shaper
						   PASS other Consonant, Virama and the same Consonant to shaper.
						11.Pass G.GA, C.CHA, K.TTA, SS.TTA, DD.DDA, NN.NNA, B.DA, B.DHA, P.PA, RR.RRA, SH.SHA, S.SA clusters to shaper.
						12.Pass Consonant clusters from REQ1.3.11 to shaper.
						13.Pass S.RR.RRA to shaper,
						   Pass N.RR.RRA to shaper
@SYMTestExpectedResults 1.First sequence is equivalent to the second sequence 
						2.The dependent vowel position is different between the two sequence
						3.The visual position of the Matras is different with the logical order (The same as Keyboard input order).
						4.The Matra is split into halves from visual effect. And the second form of Matra /-au/ is recognized the same as the first form of it.
						5.0x0d4d is recognized as a Virama in first sequence, its recognized as MATRA (mid-u sound) in the second sequence
						6.Virama and ZWJ is interpreted as Chillaksharam for the 6 consonants, for others its not interpreted that way.
						7.Both sequences will interprete RA Chillu.
						8.The combining character should not combine with Chillu.
						9.LA takes subscript shape.
						10.CA, BA, YA, VA double should result in a ligature, other consonants dont.
						11.The latter consonant in the cluster becomes a miniature subscript.
						12.sequence forms a ligature.
						13.sequence forms a ligature
@SYMPREQ 1922: Malayalam support
*/
void CTGlyphSelection::TestMalayalamWithConsonantInitial( const CFbsFont& aFont )
	{
	DoEachGurmukhiMalayalamCase( (TTestInput_PositionParam6*)Indic_MalayalamConsonantLeading, aFont );
	
#ifdef GEN_GURMUKHIMALAYALAMTESTDATA
    _LIT(KValidFontPath, "c:\\MalayalamWithConsonantInitial.txt");
    GenerateGurmukhiMalayalamData(KValidFontPath, (TTestInput_PositionParam6*)Indic_GurmukhiDigit, aFont );
#endif  
	}

/**
@SYMTestCaseID          GRAPHICS-TI18N-GDI-CIT-4072
@SYMTestCaseDesc        case to check if shaper can render Malayalam with other implemented Indic scripts and Latin
@SYMTestPriority        High
@SYMTestActions         Call to CFont::GetCharacterPosition2/CFont::MeasureText to check the following
						1.Pass Malayalam sentence and Latin to the function
						2.Pass Latin and Malayalam setence.
						3.Pass syllable, Latin and syllable
						4.Pass phoneme, Latin and phoneme
						5.Pass Malayalam syllable and other Indic scripts together.
						6.Pass Malayalam phoneme and other Indic script phoneme
@SYMTestExpectedResults Malayalam and Latin characters dont mess up. Malayalam phoneme doesnt combine with Latin into a new syllable, 
						Malayalam phoneme doesnt form a syllable with other Indic script.
@SYMPREQ 1922: Malayalam support
*/
void CTGlyphSelection::TestMalayalamWithVowelInitial( const CFbsFont& aFont )
	{
	DoEachGurmukhiMalayalamCase( (TTestInput_PositionParam6*)Indic_MalayalamVowelLeading, aFont );
	
#ifdef GEN_GURMUKHIMALAYALAMTESTDATA
    _LIT(KValidFontPath, "c:\\MalayalamWithVowelInitial.txt");
    GenerateGurmukhiMalayalamData(KValidFontPath, (TTestInput_PositionParam6*)Indic_GurmukhiDigit, aFont );
#endif 
	}


//--------------

__CONSTRUCT_STEP__(GlyphSelection)

void CTGlyphSelectionStep::TestSetupL()
	{
#ifdef _GLOWCODE_LAUNCH_DELAY
	INFO_PRINTF1(_L("Time delay...."));
	TTime t1, t2;
	t1.UniversalTime();
	t1 += TTimeIntervalSeconds(15);
	do 
		{
		t2.UniversalTime();
		}
	while (t2 < t1);
#endif
	}
