// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include <e32std.h>

/**
This lookup table is used for outline and shadow fonts. Four entries of this table represent 
the percentage of Outline, Shadow, Fill and Background colour to be used to get the final colour to be 
displayed on screen.

The following formula is used to blend four colours:

blendedXXXColor = (XXXOutlinePenColor * FourColorBlendLookup[index][KOutlineColorIndex] + 
			   		XXXShadowColor * FourColorBlendLookup[index][KShadowColorIndex] +
			  		XXXFillColor * FourColorBlendLookup[index][KFillColorIndex] + 
			  		backgroundColor.XXX() * FourColorBlendLookup[index][KBackgroundColorIndex]) >> 8;
where XXX can be Red, Green or Blue
and index is the 8-bit value which will be provided by the rasterizer to decide which 
entry of lookup table should be used. Right shift by eight will divide the calculated value in % with 
256 to get the actual colour.

This table is provided by Monotype and MUST NOT be changed.
*/
extern const TInt FourColorBlendLookup[256][4] = {
	{ 0, 0, 0, 255 },
	{ 0, 0, 17, 238 },
	{ 0, 0, 34, 221 },
	{ 0, 0, 51, 204 },
	{ 0, 0, 68, 187 },
	{ 0, 0, 85, 170 },
	{ 0, 0, 102, 153 },
	{ 0, 0, 119, 136 },
	{ 0, 0, 136, 119 },
	{ 0, 0, 153, 102 },
	{ 0, 0, 170, 85 },
	{ 0, 0, 187, 68 },
	{ 0, 0, 204, 51 },
	{ 0, 0, 221, 34 },
	{ 0, 0, 238, 17 },
	{ 0, 0, 255, 0 },
	{ 0, 17, 0, 238 },
	{ 0, 34, 0, 221 },
	{ 0, 51, 0, 204 },
	{ 0, 68, 0, 187 },
	{ 0, 85, 0, 170 },
	{ 0, 102, 0, 153 },
	{ 0, 119, 0, 136 },
	{ 0, 136, 0, 119 },
	{ 0, 153, 0, 102 },
	{ 0, 170, 0, 85 },
	{ 0, 187, 0, 68 },
	{ 0, 204, 0, 51 },
	{ 0, 221, 0, 34 },
	{ 0, 238, 0, 17 },
	{ 0, 255, 0, 0 },
	{ 17, 0, 0, 238 },
	{ 34, 0, 0, 221 },
	{ 51, 0, 0, 204 },
	{ 68, 0, 0, 187 },
	{ 85, 0, 0, 170 },
	{ 102, 0, 0, 153 },
	{ 119, 0, 0, 136 },
	{ 136, 0, 0, 119 },
	{ 153, 0, 0, 102 },
	{ 170, 0, 0, 85 },
	{ 187, 0, 0, 68 },
	{ 204, 0, 0, 51 },
	{ 221, 0, 0, 34 },
	{ 238, 0, 0, 17 },
	{ 255, 0, 0, 0 },
	{ 0, 17, 238, 0 },
	{ 0, 34, 221, 0 },
	{ 0, 51, 204, 0 },
	{ 0, 68, 187, 0 },
	{ 0, 85, 170, 0 },
	{ 0, 102, 153, 0 },
	{ 0, 119, 136, 0 },
	{ 0, 136, 119, 0 },
	{ 0, 153, 102, 0 },
	{ 0, 170, 85 ,0 },
	{ 0, 187, 68 ,0 },
	{ 0, 204, 51, 0 },
	{ 0, 221, 34, 0 },
	{ 0, 238, 17, 0 },
	{ 238, 17, 0, 0 },
	{ 221, 34, 0, 0 },
	{ 204, 51, 0, 0 },
	{ 187, 68, 0, 0 },
	{ 170, 85, 0, 0 },
	{ 153, 102, 0, 0 },
	{ 136, 119, 0, 0 },
	{ 119, 136, 0, 0 },
	{ 102, 153, 0, 0 },
	{ 85, 170, 0, 0 },
	{ 68, 187, 0, 0 },
	{ 51, 204, 0, 0 },
	{ 34, 221, 0, 0 },
	{ 17, 238, 0, 0 },
	{ 238, 0, 17, 0 },
	{ 221, 0, 34, 0 }, 
	{ 204, 0, 51, 0 },
	{ 187, 0, 68, 0 },
	{ 170, 0, 85, 0 },
	{ 153, 0, 102, 0 },
	{ 136, 0, 119, 0 },
	{ 119, 0, 136, 0 }, 
	{ 102, 0, 153, 0 }, 
	{ 85, 0, 170, 0 } ,
	{ 68, 0, 187, 0 },
	{ 51, 0, 204, 0 }, 
	{ 34, 0, 221, 0 }, 
	{ 17, 0, 238, 0 }, 
	{ 210, 23, 0, 22 }, 
	{ 179, 60, 0, 16 }, 
	{ 145, 94, 0, 16 }, 
	{ 119, 119, 0, 17 }, 
	{ 94, 145, 0, 16 }, 
	{ 60, 179, 0, 16 }, 
	{ 23, 210, 0, 22 }, 
	{ 176, 40, 0, 39 }, 
	{ 142, 74, 0, 39 }, 
	{ 113, 96, 0, 46 }, 
	{ 91, 125, 0, 39 }, 
	{ 62, 147, 0, 46 }, 
	{ 40, 176, 0, 39 }, 
	{ 179, 17, 0, 59 },
	{ 147, 45, 0, 63 },
	{ 17, 179, 0, 59 },
	{ 145, 17, 0, 93 },
	{ 125, 40, 0, 90 },
	{ 108, 74, 0, 73 },
	{ 74, 108, 0, 73 },
	{ 85, 85, 0, 85 },
	{ 40, 142, 0, 73 },
	{ 119, 17, 0, 119 },
	{ 96, 45, 0, 114 },
	{ 74, 74, 0, 107 },
	{ 45, 113, 0, 97 },
	{ 17, 145, 0, 93 },
	{ 94, 17, 0, 144 },
	{ 74, 40, 0, 141 },
	{ 45, 62, 0, 148 },
	{ 40, 91, 0, 124 },
	{ 17, 119, 0, 119 },
	{ 17, 94, 0, 144 }, 
	{ 60, 17, 0, 178 }, 
	{ 40, 40, 0, 175 }, 
	{ 17, 60, 0, 178 }, 
	{ 23, 23, 0, 209 }, 
	{ 0, 210, 23, 22 },
	{ 0, 179, 60, 16 },
	{ 0, 145, 94, 16 },
	{ 0, 119, 119, 17 },
	{ 0, 94 ,145, 16 },
	{ 0, 60 ,179, 16 },
	{ 0, 23, 210, 22 },
	{ 0, 176, 40, 39 },
	{ 0, 142, 74, 39 },
	{ 0, 113, 96, 46 },
	{ 0, 91, 125, 39 },
	{ 0, 62, 147, 46 },
	{ 0, 40, 176, 39 },
	{ 0, 179, 17, 59 },
	{ 0, 147, 45, 63 },
	{ 0, 17, 179, 59 },
	{ 0, 145, 17, 93 },
	{ 0, 125, 40, 90 },
	{ 0, 108, 74, 73 },
	{ 0, 74, 108, 73 },
	{ 0, 85, 85, 85 },
	{ 0, 40, 142, 73 }, 
	{ 0, 119, 17, 119 },
	{ 0, 96, 45, 114 },
	{ 0, 74, 74, 107 },
	{ 0, 45, 113, 97 },
	{ 0, 17, 145, 93 },
	{ 0, 94, 17, 144 },
	{ 0, 74, 40, 141 },
	{ 0, 45, 62, 148 },
	{ 0, 40, 91, 124 },
	{ 0, 17, 119, 119 },
	{ 0, 17, 94, 144 },
	{ 0, 60, 17, 178 },
	{ 0, 40, 40, 175 },
	{ 0, 17, 60, 178 },
	{ 0, 23, 23, 209 },
	{ 23, 0, 210, 22 },
	{ 60, 0, 179, 16 },
	{ 94, 0, 145, 16 },
	{ 119, 0, 119, 17 },
	{ 145, 0, 94, 16 },
	{ 179, 0, 60, 16 },
	{ 210, 0, 23, 22 },
	{ 40, 0, 176, 39 },
	{ 74, 0, 142, 39 },
	{ 96, 0, 113, 46 },
	{ 125, 0, 91, 39 },
	{ 147, 0, 62, 46 },
	{ 176, 0, 40, 39 },
	{ 17, 0, 179, 59 },
	{ 45, 0, 147, 63 },
	{ 179, 0, 17, 59 },
	{ 17, 0, 145, 93 },
	{ 40, 0, 125, 90 },
	{ 74, 0, 108, 73 },
	{ 108, 0, 74, 73 },
	{ 85, 0, 85, 85 },
	{ 142, 0, 40, 73 },
	{ 17, 0, 119, 119 },
	{ 45, 0, 96, 114 },
	{ 74, 0, 74, 107 },
	{ 113, 0, 45, 97 },
	{ 145, 0, 17, 93 },
	{ 17, 0, 94, 144 },
	{ 40, 0, 74, 141 },
	{ 62, 0, 45, 148 },
	{ 91, 0, 40, 124 },
	{ 119, 0, 17, 119 },
	{ 94, 0, 17, 144 },
	{ 17, 0, 60, 178 },
	{ 40, 0, 40, 175 },
	{ 60, 0, 17, 178 },
	{ 23, 0, 23, 209 },
	{ 209, 23, 23, 0 },
	{ 178, 17, 60, 0 },
	{ 144, 17, 94, 0 },
	{ 119, 17, 119, 0 },
	{ 93, 17, 145, 0 },
	{ 59, 17, 179, 0 },
	{ 22, 23, 210, 0 },
	{ 175, 40, 40, 0 },
	{ 141, 40, 74, 0 },
	{ 114, 45, 96, 0 },
	{ 90, 40, 125, 0 },
	{ 63, 45, 147, 0 },
	{ 39, 40, 176, 0 },
	{ 178, 60, 17, 0 },
	{ 148, 62, 45, 0 },
	{ 16, 60, 179, 0 },
	{ 144, 94, 17, 0 },
	{ 124, 91, 40, 0 },
	{ 107, 74, 74, 0 },
	{ 73, 74, 108, 0 },
	{ 85, 85, 85, 0 },
	{ 39, 74, 142, 0 }, 
	{ 119, 119, 17, 0 },
	{ 97, 113, 45, 0 },
	{ 73, 108, 74, 0 },
	{ 46, 96, 113, 0 },
	{ 16, 94, 145, 0 },
	{ 93, 145, 17, 0 },
	{ 73, 142, 40, 0 },
	{ 46, 147, 62, 0 },
	{ 39, 125, 91, 0 },
	{ 17, 119, 119, 0 },
	{ 16, 145, 94, 0 },
	{ 59, 179, 17, 0 },
	{ 39, 176, 40, 0 },
	{ 16, 179, 60, 0 },
	{ 22, 210, 23, 0 },
	{ 32, 32 ,32, 159 },
	{ 32, 32 ,74, 117 },
	{ 32, 32 ,116, 75 },
	{ 32, 32 ,158, 33 },
	{ 74, 32, 32, 117 },
	{ 74, 32, 74, 75 }, 
	{ 74, 32, 116, 33 },
	{ 116, 32, 32, 75 },
	{ 116, 32, 74, 33 },
	{ 158, 32, 32, 33 },
	{ 32, 74, 32, 117 },
	{ 32, 74, 74, 75 },
	{ 32, 74, 116, 33 },
	{ 74, 74, 32, 75 },
	{ 74, 74, 74, 33 },
	{ 116, 74, 32, 33 },
	{ 32, 116, 32, 75 },
	{ 32, 116, 74, 33 },
	{ 74, 116, 32, 33 },
	{ 32, 158, 32, 33 },
	};
