/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.commdb.data;

import com.symbian.commdb.data.TableEntry;
import com.symbian.commdb.data.TableTemplate;
import java.util.Vector;

public class Table {
    private String m_tableName;
    private Vector m_tableEntries;
    private TableTemplate m_tableTemplate;

    public Table(TableTemplate tableTemplate) {
        this.m_tableTemplate = tableTemplate;
        this.m_tableName = new String("");
        this.m_tableEntries = new Vector();
    }

    public String GetTableName() {
        return new String(this.m_tableName);
    }

    public TableTemplate GetTableTemplate() {
        return this.m_tableTemplate;
    }

    public int GetNumberOfTableEntries() {
        return this.m_tableEntries.size();
    }

    public TableEntry GetTableEntry(int n) {
        TableEntry tableEntry;
        try {
            tableEntry = (TableEntry)this.m_tableEntries.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        return tableEntry;
    }

    public int GetTableEntryIndex(TableEntry tableEntry) {
        for (int i = 0; i < this.m_tableEntries.size(); ++i) {
            TableEntry tableEntry2 = (TableEntry)this.m_tableEntries.elementAt(i);
            if (tableEntry2 != tableEntry) continue;
            return i;
        }
        return -1;
    }

    public TableEntry GetTableEntry(String string, String string2) {
        for (int i = 0; i < this.m_tableEntries.size(); ++i) {
            TableEntry tableEntry = (TableEntry)this.m_tableEntries.elementAt(i);
            String string3 = tableEntry.GetParameterValue(string);
            if (!string2.equals(string3)) continue;
            return tableEntry;
        }
        return null;
    }

    public String toXML() {
        String string = "<" + this.m_tableName + ">\n";
        for (int i = 0; i < this.m_tableEntries.size(); ++i) {
            TableEntry tableEntry = (TableEntry)this.m_tableEntries.elementAt(i);
            string = string + tableEntry.toXML();
        }
        return string + "</" + this.m_tableName + ">\n\n";
    }

    public void SetTableName(String string) {
        this.m_tableName = new String(string);
    }

    public TableEntry CreateTableEntry() {
        TableEntry tableEntry = new TableEntry(this.m_tableTemplate);
        this.m_tableEntries.add(tableEntry);
        return tableEntry;
    }

    public boolean RemoveTableEntry(int n) {
        try {
            this.m_tableEntries.removeElementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        return true;
    }

    public void RemoveAllTableEntries() {
        this.m_tableEntries.clear();
    }
}

