/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGSymbolElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGAnimatedString.h"
#include "PlatformString.h"
#include "SVGSymbolElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGSymbolElementTableEntries[] =
{
    { "xmlspace", JSSVGSymbolElement::XmlspaceAttrNum, DontDelete, 0, 0 },
    { "className", JSSVGSymbolElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "externalResourcesRequired", JSSVGSymbolElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, &JSSVGSymbolElementTableEntries[7] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "preserveAspectRatio", JSSVGSymbolElement::PreserveAspectRatioAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmllang", JSSVGSymbolElement::XmllangAttrNum, DontDelete, 0, 0 },
    { "style", JSSVGSymbolElement::StyleAttrNum, DontDelete|ReadOnly, 0, &JSSVGSymbolElementTableEntries[8] },
    { "viewBox", JSSVGSymbolElement::ViewBoxAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGSymbolElementTable = 
{
    2, 9, JSSVGSymbolElementTableEntries, 7
};

/* Hash table for prototype */

static const HashEntry JSSVGSymbolElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGSymbolElementPrototypeTable = 
{
    2, 1, JSSVGSymbolElementPrototypeTableEntries, 1
};

const ClassInfo JSSVGSymbolElementPrototype::info = { "SVGSymbolElementPrototype", 0, &JSSVGSymbolElementPrototypeTable, 0 };

JSObject* JSSVGSymbolElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGSymbolElementPrototype>(exec, "[[JSSVGSymbolElement.prototype]]");
}

const ClassInfo JSSVGSymbolElement::info = { "SVGSymbolElement", &JSSVGElement::info, &JSSVGSymbolElementTable, 0 };

JSSVGSymbolElement::JSSVGSymbolElement(ExecState* exec, SVGSymbolElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGSymbolElementPrototype::self(exec));
}

bool JSSVGSymbolElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGSymbolElement, JSSVGElement>(exec, &JSSVGSymbolElementTable, this, propertyName, slot);
}

JSValue* JSSVGSymbolElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case XmllangAttrNum: {
        SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case ViewBoxAttrNum: {
        SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedRect> obj = imp->viewBoxAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedRect>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedRect>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedRect>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case PreserveAspectRatioAttrNum: {
        SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedPreserveAspectRatio>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedPreserveAspectRatio>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedPreserveAspectRatio>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    }
    return 0;
}

void JSSVGSymbolElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGSymbolElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGSymbolElementTable, this);
}

void JSSVGSymbolElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}


}

#endif // ENABLE(SVG)
