/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGAnimatedString.h"

#include <wtf/GetPtr.h>

#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGAnimatedStringTableEntries[] =
{
    { "baseVal", JSSVGAnimatedString::BaseValAttrNum, DontDelete, 0, 0 },
    { "animVal", JSSVGAnimatedString::AnimValAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGAnimatedStringTable = 
{
    2, 2, JSSVGAnimatedStringTableEntries, 2
};

/* Hash table for prototype */

static const HashEntry JSSVGAnimatedStringPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedStringPrototypeTable = 
{
    2, 1, JSSVGAnimatedStringPrototypeTableEntries, 1
};

const ClassInfo JSSVGAnimatedStringPrototype::info = { "SVGAnimatedStringPrototype", 0, &JSSVGAnimatedStringPrototypeTable, 0 };

JSObject* JSSVGAnimatedStringPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGAnimatedStringPrototype>(exec, "[[JSSVGAnimatedString.prototype]]");
}

const ClassInfo JSSVGAnimatedString::info = { "SVGAnimatedString", 0, &JSSVGAnimatedStringTable, 0 };

JSSVGAnimatedString::JSSVGAnimatedString(ExecState* exec, SVGAnimatedString* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGAnimatedStringPrototype::self(exec));
}

JSSVGAnimatedString::~JSSVGAnimatedString()
{
    SVGDocumentExtensions::forgetGenericContext<SVGAnimatedString>(m_impl.get());
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGAnimatedString::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedString, KJS::DOMObject>(exec, &JSSVGAnimatedStringTable, this, propertyName, slot);
}

JSValue* JSSVGAnimatedString::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case BaseValAttrNum: {
        SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(impl());

        return jsString(imp->baseVal());
    }
    case AnimValAttrNum: {
        SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(impl());

        return jsString(imp->animVal());
    }
    }
    return 0;
}

void JSSVGAnimatedString::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGAnimatedString, KJS::DOMObject>(exec, propertyName, value, attr, &JSSVGAnimatedStringTable, this);
}

void JSSVGAnimatedString::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case BaseValAttrNum: {
        SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(impl());

        imp->setBaseVal(value->toString(exec));
        break;
    }
    }
    SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(impl());

    ASSERT(exec && exec->dynamicInterpreter());
    Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
    if (!activeFrame)
        return;

    SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
    if (extensions && extensions->hasGenericContext<SVGAnimatedString>(imp)) {
        const SVGElement* context = extensions->genericContext<SVGAnimatedString>(imp);
        ASSERT(context);

        context->notifyAttributeChange();
    }

}

KJS::JSValue* toJS(KJS::ExecState* exec, SVGAnimatedString* obj)
{
    return KJS::cacheDOMObject<SVGAnimatedString, JSSVGAnimatedString>(exec, obj);
}
SVGAnimatedString* toSVGAnimatedString(KJS::JSValue* val)
{
    return val->isObject(&JSSVGAnimatedString::info) ? static_cast<JSSVGAnimatedString*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
