/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSTextEvent.h"

#include <wtf/GetPtr.h>

#include "JSDOMWindow.h"
#include "PlatformString.h"
#include "TextEvent.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSTextEventTableEntries[] =
{
    { "data", JSTextEvent::DataAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSTextEventTable = 
{
    2, 1, JSTextEventTableEntries, 1
};

/* Hash table for prototype */

static const HashEntry JSTextEventPrototypeTableEntries[] =
{
    { "initTextEvent", JSTextEvent::InitTextEventFuncNum, DontDelete|Function, 5, 0 }
};

static const HashTable JSTextEventPrototypeTable = 
{
    2, 1, JSTextEventPrototypeTableEntries, 1
};

const ClassInfo JSTextEventPrototype::info = { "TextEventPrototype", 0, &JSTextEventPrototypeTable, 0 };

JSObject* JSTextEventPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSTextEventPrototype>(exec, "[[JSTextEvent.prototype]]");
}

bool JSTextEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSTextEventPrototypeFunction, JSObject>(exec, &JSTextEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSTextEvent::info = { "TextEvent", &JSUIEvent::info, &JSTextEventTable, 0 };

JSTextEvent::JSTextEvent(ExecState* exec, TextEvent* impl)
    : JSUIEvent(exec, impl)
{
    setPrototype(JSTextEventPrototype::self(exec));
}

bool JSTextEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextEvent, JSUIEvent>(exec, &JSTextEventTable, this, propertyName, slot);
}

JSValue* JSTextEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DataAttrNum: {
        TextEvent* imp = static_cast<TextEvent*>(impl());

        return jsString(imp->data());
    }
    }
    return 0;
}

JSValue* JSTextEventPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSTextEvent::info))
      return throwError(exec, TypeError);

    TextEvent* imp = static_cast<TextEvent*>(static_cast<JSTextEvent*>(thisObj)->impl());

    switch (id) {
    case JSTextEvent::InitTextEventFuncNum: {
        String typeArg = args[0]->toString(exec);
        bool canBubbleArg = args[1]->toBoolean(exec);
        bool cancelableArg = args[2]->toBoolean(exec);
        DOMWindow* viewArg = toDOMWindow(args[3]);
        String dataArg = args[4]->toString(exec);

        imp->initTextEvent(typeArg, canBubbleArg, cancelableArg, viewArg, dataArg);
        return jsUndefined();
    }
    }
    return 0;
}

}
