/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNodeList.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "ExceptionCode.h"
#include "JSNode.h"
#include "Node.h"
#include "NodeList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSNodeListTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "length", JSNodeList::LengthAttrNum, DontDelete|ReadOnly, 0, &JSNodeListTableEntries[2] },
    { "constructor", JSNodeList::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSNodeListTable = 
{
    2, 3, JSNodeListTableEntries, 2
};

/* Hash table for constructor */

static const HashEntry JSNodeListConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSNodeListConstructorTable = 
{
    2, 1, JSNodeListConstructorTableEntries, 1
};

class JSNodeListConstructor : public DOMObject {
public:
    JSNodeListConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSNodeListPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSNodeListConstructor::info = { "NodeListConstructor", 0, &JSNodeListConstructorTable, 0 };

bool JSNodeListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNodeListConstructor, DOMObject>(exec, &JSNodeListConstructorTable, this, propertyName, slot);
}

JSValue* JSNodeListConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSNodeListPrototypeTableEntries[] =
{
    { "item", JSNodeList::ItemFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSNodeListPrototypeTable = 
{
    2, 1, JSNodeListPrototypeTableEntries, 1
};

const ClassInfo JSNodeListPrototype::info = { "NodeListPrototype", 0, &JSNodeListPrototypeTable, 0 };

JSObject* JSNodeListPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNodeListPrototype>(exec, "[[JSNodeList.prototype]]");
}

bool JSNodeListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSNodeListPrototypeFunction, JSObject>(exec, &JSNodeListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSNodeList::info = { "NodeList", 0, &JSNodeListTable, 0 };

JSNodeList::JSNodeList(ExecState* exec, NodeList* impl)
    : m_impl(impl)
{
    setPrototype(JSNodeListPrototype::self(exec));
}

JSNodeList::~JSNodeList()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSNodeList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = Lookup::findEntry(&JSNodeListTable, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSNodeList>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<NodeList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<NodeList*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return KJS::DOMObject::getOwnPropertySlot(exec, propertyName, slot);
}

JSValue* JSNodeList::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case LengthAttrNum: {
        NodeList* imp = static_cast<NodeList*>(impl());

        return jsNumber(imp->length());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSNodeList::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNodeListConstructor>(exec, "[[NodeList.constructor]]");
}
JSValue* JSNodeListPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNodeList::info))
      return throwError(exec, TypeError);

    NodeList* imp = static_cast<NodeList*>(static_cast<JSNodeList*>(thisObj)->impl());

    switch (id) {
    case JSNodeList::ItemFuncNum: {
        bool indexOk;
        int index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }
        if (index < 0) {
            setDOMException(exec, INDEX_SIZE_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->item(index)));
        return result;
    }
    }
    return 0;
}

JSValue* JSNodeList::indexGetter(ExecState* exec, JSObject* originalObject, const Identifier& propertyName, const PropertySlot& slot)
{
    JSNodeList* thisObj = static_cast<JSNodeList*>(slot.slotBase());
    return toJS(exec, static_cast<NodeList*>(thisObj->impl())->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, NodeList* obj)
{
    return KJS::cacheDOMObject<NodeList, JSNodeList>(exec, obj);
}
NodeList* toNodeList(KJS::JSValue* val)
{
    return val->isObject(&JSNodeList::info) ? static_cast<JSNodeList*>(val)->impl() : 0;
}

}
