/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGPolylineElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGPointList.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "PlatformString.h"
#include "SVGElement.h"
#include "SVGPointList.h"
#include "SVGPolylineElement.h"
#include "SVGStringList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGPolylineElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "transform", JSSVGPolylineElement::TransformAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmlspace", JSSVGPolylineElement::XmlspaceAttrNum, DontDelete, 0, 0 },
    { "requiredFeatures", JSSVGPolylineElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, &JSSVGPolylineElementTableEntries[13] },
    { "farthestViewportElement", JSSVGPolylineElement::FarthestViewportElementAttrNum, DontDelete|ReadOnly, 0, &JSSVGPolylineElementTableEntries[16] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "style", JSSVGPolylineElement::StyleAttrNum, DontDelete|ReadOnly, 0, &JSSVGPolylineElementTableEntries[15] },
    { "systemLanguage", JSSVGPolylineElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "className", JSSVGPolylineElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "externalResourcesRequired", JSSVGPolylineElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "requiredExtensions", JSSVGPolylineElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmllang", JSSVGPolylineElement::XmllangAttrNum, DontDelete, 0, &JSSVGPolylineElementTableEntries[14] },
    { "nearestViewportElement", JSSVGPolylineElement::NearestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "points", JSSVGPolylineElement::PointsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "animatedPoints", JSSVGPolylineElement::AnimatedPointsAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGPolylineElementTable = 
{
    2, 17, JSSVGPolylineElementTableEntries, 13
};

/* Hash table for prototype */

static const HashEntry JSSVGPolylineElementPrototypeTableEntries[] =
{
    { "hasExtension", JSSVGPolylineElement::HasExtensionFuncNum, DontDelete|Function, 1, &JSSVGPolylineElementPrototypeTableEntries[6] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getBBox", JSSVGPolylineElement::GetBBoxFuncNum, DontDelete|Function, 0, &JSSVGPolylineElementPrototypeTableEntries[5] },
    { "getTransformToElement", JSSVGPolylineElement::GetTransformToElementFuncNum, DontDelete|Function, 1, 0 },
    { "getCTM", JSSVGPolylineElement::GetCTMFuncNum, DontDelete|Function, 0, 0 },
    { "getScreenCTM", JSSVGPolylineElement::GetScreenCTMFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSSVGPolylineElementPrototypeTable = 
{
    2, 7, JSSVGPolylineElementPrototypeTableEntries, 5
};

const ClassInfo JSSVGPolylineElementPrototype::info = { "SVGPolylineElementPrototype", 0, &JSSVGPolylineElementPrototypeTable, 0 };

JSObject* JSSVGPolylineElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGPolylineElementPrototype>(exec, "[[JSSVGPolylineElement.prototype]]");
}

bool JSSVGPolylineElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGPolylineElementPrototypeFunction, JSObject>(exec, &JSSVGPolylineElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGPolylineElement::info = { "SVGPolylineElement", &JSSVGElement::info, &JSSVGPolylineElementTable, 0 };

JSSVGPolylineElement::JSSVGPolylineElement(ExecState* exec, SVGPolylineElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGPolylineElementPrototype::self(exec));
}

bool JSSVGPolylineElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPolylineElement, JSSVGElement>(exec, &JSSVGPolylineElementTable, this, propertyName, slot);
}

JSValue* JSSVGPolylineElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case RequiredFeaturesAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case XmllangAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case TransformAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedTransformList>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedTransformList>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedTransformList>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case NearestViewportElementAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
    }
    case FarthestViewportElementAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
    }
    case PointsAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->points()));
    }
    case AnimatedPointsAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->animatedPoints()));
    }
    }
    return 0;
}

void JSSVGPolylineElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGPolylineElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGPolylineElementTable, this);
}

void JSSVGPolylineElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}

JSValue* JSSVGPolylineElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGPolylineElement::info))
      return throwError(exec, TypeError);

    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(static_cast<JSSVGPolylineElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGPolylineElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    case JSSVGPolylineElement::GetBBoxFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->getBBox()));
        return result;
    }
    case JSSVGPolylineElement::GetCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getCTM()));
        return result;
    }
    case JSSVGPolylineElement::GetScreenCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getScreenCTM()));
        return result;
    }
    case JSSVGPolylineElement::GetTransformToElementFuncNum: {
        ExceptionCode ec = 0;
        SVGElement* element = toSVGElement(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getTransformToElement(element, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
