/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSStyleSheet.h"

#include <wtf/GetPtr.h>

#include "CSSRule.h"
#include "CSSRuleList.h"
#include "CSSStyleSheet.h"
#include "ExceptionCode.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCSSStyleSheetTableEntries[] =
{
    { "cssRules", JSCSSStyleSheet::CssRulesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "ownerRule", JSCSSStyleSheet::OwnerRuleAttrNum, DontDelete|ReadOnly, 0, &JSCSSStyleSheetTableEntries[3] },
    { "rules", JSCSSStyleSheet::RulesAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSCSSStyleSheetTable = 
{
    2, 4, JSCSSStyleSheetTableEntries, 3
};

/* Hash table for prototype */

static const HashEntry JSCSSStyleSheetPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "deleteRule", JSCSSStyleSheet::DeleteRuleFuncNum, DontDelete|Function, 1, &JSCSSStyleSheetPrototypeTableEntries[4] },
    { "insertRule", JSCSSStyleSheet::InsertRuleFuncNum, DontDelete|Function, 2, 0 },
    { "removeRule", JSCSSStyleSheet::RemoveRuleFuncNum, DontDelete|Function, 1, 0 },
    { "addRule", JSCSSStyleSheet::AddRuleFuncNum, DontDelete|Function, 3, 0 }
};

static const HashTable JSCSSStyleSheetPrototypeTable = 
{
    2, 5, JSCSSStyleSheetPrototypeTableEntries, 4
};

const ClassInfo JSCSSStyleSheetPrototype::info = { "CSSStyleSheetPrototype", 0, &JSCSSStyleSheetPrototypeTable, 0 };

JSObject* JSCSSStyleSheetPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSStyleSheetPrototype>(exec, "[[JSCSSStyleSheet.prototype]]");
}

bool JSCSSStyleSheetPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSCSSStyleSheetPrototypeFunction, JSObject>(exec, &JSCSSStyleSheetPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSStyleSheet::info = { "CSSStyleSheet", &JSStyleSheet::info, &JSCSSStyleSheetTable, 0 };

JSCSSStyleSheet::JSCSSStyleSheet(ExecState* exec, CSSStyleSheet* impl)
    : JSStyleSheet(exec, impl)
{
    setPrototype(JSCSSStyleSheetPrototype::self(exec));
}

bool JSCSSStyleSheet::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleSheet, JSStyleSheet>(exec, &JSCSSStyleSheetTable, this, propertyName, slot);
}

JSValue* JSCSSStyleSheet::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case OwnerRuleAttrNum: {
        CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(impl());

        return toJS(exec, WTF::getPtr(imp->ownerRule()));
    }
    case CssRulesAttrNum: {
        CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(impl());

        return toJS(exec, WTF::getPtr(imp->cssRules()));
    }
    case RulesAttrNum: {
        CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(impl());

        return toJS(exec, WTF::getPtr(imp->rules()));
    }
    }
    return 0;
}

JSValue* JSCSSStyleSheetPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleSheet::info))
      return throwError(exec, TypeError);

    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(static_cast<JSCSSStyleSheet*>(thisObj)->impl());

    switch (id) {
    case JSCSSStyleSheet::InsertRuleFuncNum: {
        ExceptionCode ec = 0;
        String rule = args[0]->toString(exec);
        bool indexOk;
        unsigned index = args[1]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = jsNumber(imp->insertRule(rule, index, ec));
        setDOMException(exec, ec);
        return result;
    }
    case JSCSSStyleSheet::DeleteRuleFuncNum: {
        ExceptionCode ec = 0;
        bool indexOk;
        unsigned index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }

        imp->deleteRule(index, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSCSSStyleSheet::AddRuleFuncNum: {
        ExceptionCode ec = 0;
        String selector = args[0]->toString(exec);
        String style = args[1]->toString(exec);

        int argsCount = args.size();
        if (argsCount < 3) {

            KJS::JSValue* result = jsNumber(imp->addRule(selector, style, ec));
            setDOMException(exec, ec);
            return result;
        }

        bool indexOk;
        unsigned index = args[2]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = jsNumber(imp->addRule(selector, style, index, ec));
        setDOMException(exec, ec);
        return result;
    }
    case JSCSSStyleSheet::RemoveRuleFuncNum: {
        ExceptionCode ec = 0;

        int argsCount = args.size();
        if (argsCount < 1) {
            imp->removeRule(ec);
            setDOMException(exec, ec);
            return jsUndefined();
        }

        bool indexOk;
        unsigned index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }

        imp->removeRule(index, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    }
    return 0;
}

}
