/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLTextAreaElement.h"

#include <wtf/GetPtr.h>

#include "ExceptionCode.h"
#include "HTMLFormElement.h"
#include "HTMLTextAreaElement.h"
#include "JSHTMLFormElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLTextAreaElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "tabIndex", JSHTMLTextAreaElement::TabIndexAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "defaultValue", JSHTMLTextAreaElement::DefaultValueAttrNum, DontDelete, 0, &JSHTMLTextAreaElementTableEntries[16] },
    { 0, 0, 0, 0, 0 },
    { "rows", JSHTMLTextAreaElement::RowsAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "accessKey", JSHTMLTextAreaElement::AccessKeyAttrNum, DontDelete, 0, 0 },
    { "form", JSHTMLTextAreaElement::FormAttrNum, DontDelete|ReadOnly, 0, &JSHTMLTextAreaElementTableEntries[14] },
    { 0, 0, 0, 0, 0 },
    { "disabled", JSHTMLTextAreaElement::DisabledAttrNum, DontDelete, 0, &JSHTMLTextAreaElementTableEntries[15] },
    { "readOnly", JSHTMLTextAreaElement::ReadOnlyAttrNum, DontDelete, 0, &JSHTMLTextAreaElementTableEntries[18] },
    { "cols", JSHTMLTextAreaElement::ColsAttrNum, DontDelete, 0, 0 },
    { "name", JSHTMLTextAreaElement::NameAttrNum, DontDelete, 0, &JSHTMLTextAreaElementTableEntries[17] },
    { "type", JSHTMLTextAreaElement::TypeAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "value", JSHTMLTextAreaElement::ValueAttrNum, DontDelete, 0, 0 },
    { "selectionStart", JSHTMLTextAreaElement::SelectionStartAttrNum, DontDelete, 0, &JSHTMLTextAreaElementTableEntries[19] },
    { "selectionEnd", JSHTMLTextAreaElement::SelectionEndAttrNum, DontDelete, 0, 0 },
    { "constructor", JSHTMLTextAreaElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLTextAreaElementTable = 
{
    2, 20, JSHTMLTextAreaElementTableEntries, 14
};

/* Hash table for constructor */

static const HashEntry JSHTMLTextAreaElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLTextAreaElementConstructorTable = 
{
    2, 1, JSHTMLTextAreaElementConstructorTableEntries, 1
};

class JSHTMLTextAreaElementConstructor : public DOMObject {
public:
    JSHTMLTextAreaElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLTextAreaElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLTextAreaElementConstructor::info = { "HTMLTextAreaElementConstructor", 0, &JSHTMLTextAreaElementConstructorTable, 0 };

bool JSHTMLTextAreaElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTextAreaElementConstructor, DOMObject>(exec, &JSHTMLTextAreaElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLTextAreaElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLTextAreaElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "focus", JSHTMLTextAreaElement::FocusFuncNum, DontDelete|Function, 0, 0 },
    { "blur", JSHTMLTextAreaElement::BlurFuncNum, DontDelete|Function, 0, &JSHTMLTextAreaElementPrototypeTableEntries[4] },
    { "select", JSHTMLTextAreaElement::SelectFuncNum, DontDelete|Function, 0, &JSHTMLTextAreaElementPrototypeTableEntries[5] },
    { "setSelectionRange", JSHTMLTextAreaElement::SetSelectionRangeFuncNum, DontDelete|Function, 2, 0 }
};

static const HashTable JSHTMLTextAreaElementPrototypeTable = 
{
    2, 6, JSHTMLTextAreaElementPrototypeTableEntries, 4
};

const ClassInfo JSHTMLTextAreaElementPrototype::info = { "HTMLTextAreaElementPrototype", 0, &JSHTMLTextAreaElementPrototypeTable, 0 };

JSObject* JSHTMLTextAreaElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLTextAreaElementPrototype>(exec, "[[JSHTMLTextAreaElement.prototype]]");
}

bool JSHTMLTextAreaElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSHTMLTextAreaElementPrototypeFunction, JSObject>(exec, &JSHTMLTextAreaElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLTextAreaElement::info = { "HTMLTextAreaElement", &JSHTMLElement::info, &JSHTMLTextAreaElementTable, 0 };

JSHTMLTextAreaElement::JSHTMLTextAreaElement(ExecState* exec, HTMLTextAreaElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLTextAreaElementPrototype::self(exec));
}

bool JSHTMLTextAreaElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTextAreaElement, JSHTMLElement>(exec, &JSHTMLTextAreaElementTable, this, propertyName, slot);
}

JSValue* JSHTMLTextAreaElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DefaultValueAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsString(imp->defaultValue());
    }
    case FormAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case AccessKeyAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsString(imp->accessKey());
    }
    case ColsAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsNumber(imp->cols());
    }
    case DisabledAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsBoolean(imp->disabled());
    }
    case NameAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsString(imp->name());
    }
    case ReadOnlyAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsBoolean(imp->readOnly());
    }
    case RowsAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsNumber(imp->rows());
    }
    case TabIndexAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsNumber(imp->tabIndex());
    }
    case TypeAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsString(imp->type());
    }
    case ValueAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsString(imp->value());
    }
    case SelectionStartAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsNumber(imp->selectionStart());
    }
    case SelectionEndAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        return jsNumber(imp->selectionEnd());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLTextAreaElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLTextAreaElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLTextAreaElementTable, this);
}

void JSHTMLTextAreaElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case DefaultValueAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        imp->setDefaultValue(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AccessKeyAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        imp->setAccessKey(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ColsAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        imp->setCols(value->toInt32(exec));
        break;
    }
    case DisabledAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        imp->setDisabled(value->toBoolean(exec));
        break;
    }
    case NameAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ReadOnlyAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        imp->setReadOnly(value->toBoolean(exec));
        break;
    }
    case RowsAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        imp->setRows(value->toInt32(exec));
        break;
    }
    case TabIndexAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        imp->setTabIndex(value->toInt32(exec));
        break;
    }
    case ValueAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        imp->setValue(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SelectionStartAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        imp->setSelectionStart(value->toInt32(exec));
        break;
    }
    case SelectionEndAttrNum: {
        HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(impl());

        imp->setSelectionEnd(value->toInt32(exec));
        break;
    }
    }
}

JSValue* JSHTMLTextAreaElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLTextAreaElementConstructor>(exec, "[[HTMLTextAreaElement.constructor]]");
}
JSValue* JSHTMLTextAreaElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLTextAreaElement::info))
      return throwError(exec, TypeError);

    HTMLTextAreaElement* imp = static_cast<HTMLTextAreaElement*>(static_cast<JSHTMLTextAreaElement*>(thisObj)->impl());

    switch (id) {
    case JSHTMLTextAreaElement::BlurFuncNum: {

        imp->blur();
        return jsUndefined();
    }
    case JSHTMLTextAreaElement::FocusFuncNum: {

        imp->focus();
        return jsUndefined();
    }
    case JSHTMLTextAreaElement::SelectFuncNum: {

        imp->select();
        return jsUndefined();
    }
    case JSHTMLTextAreaElement::SetSelectionRangeFuncNum: {
        bool startOk;
        int start = args[0]->toInt32(exec, startOk);
        if (!startOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }
        bool endOk;
        int end = args[1]->toInt32(exec, endOk);
        if (!endOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }

        imp->setSelectionRange(start, end);
        return jsUndefined();
    }
    }
    return 0;
}

}
