/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGElement.h"
#include "JSSVGSVGElement.h"
#include "PlatformString.h"
#include "SVGElement.h"
#include "SVGSVGElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "id", JSSVGElement::IdAttrNum, DontDelete, 0, &JSSVGElementTableEntries[4] },
    { "xmlbase", JSSVGElement::XmlbaseAttrNum, DontDelete, 0, 0 },
    { "ownerSVGElement", JSSVGElement::OwnerSVGElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "viewportElement", JSSVGElement::ViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGElementTable = 
{
    2, 5, JSSVGElementTableEntries, 4
};

/* Hash table for prototype */

static const HashEntry JSSVGElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGElementPrototypeTable = 
{
    2, 1, JSSVGElementPrototypeTableEntries, 1
};

const ClassInfo JSSVGElementPrototype::info = { "SVGElementPrototype", 0, &JSSVGElementPrototypeTable, 0 };

JSObject* JSSVGElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGElementPrototype>(exec, "[[JSSVGElement.prototype]]");
}

const ClassInfo JSSVGElement::info = { "SVGElement", &JSElement::info, &JSSVGElementTable, 0 };

JSSVGElement::JSSVGElement(ExecState* exec, SVGElement* impl)
    : JSElement(exec, impl)
{
    setPrototype(JSSVGElementPrototype::self(exec));
}

bool JSSVGElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElement, JSElement>(exec, &JSSVGElementTable, this, propertyName, slot);
}

JSValue* JSSVGElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case IdAttrNum: {
        SVGElement* imp = static_cast<SVGElement*>(impl());

        return jsString(imp->id());
    }
    case XmlbaseAttrNum: {
        SVGElement* imp = static_cast<SVGElement*>(impl());

        return jsString(imp->xmlbase());
    }
    case OwnerSVGElementAttrNum: {
        SVGElement* imp = static_cast<SVGElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->ownerSVGElement()));
    }
    case ViewportElementAttrNum: {
        SVGElement* imp = static_cast<SVGElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->viewportElement()));
    }
    }
    return 0;
}

void JSSVGElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGElement, JSElement>(exec, propertyName, value, attr, &JSSVGElementTable, this);
}

void JSSVGElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case IdAttrNum: {
        SVGElement* imp = static_cast<SVGElement*>(impl());

        ExceptionCode ec = 0;
        imp->setId(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    case XmlbaseAttrNum: {
        SVGElement* imp = static_cast<SVGElement*>(impl());

        ExceptionCode ec = 0;
        imp->setXmlbase(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

SVGElement* toSVGElement(KJS::JSValue* val)
{
    return val->isObject(&JSSVGElement::info) ? static_cast<JSSVGElement*>(val)->impl() : 0;
}

SVGElement* JSSVGElement::impl() const
{
    return static_cast<SVGElement*>(JSElement::impl());
}

}

#endif // ENABLE(SVG)
