/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDocumentFragment.h"

#include <wtf/GetPtr.h>

#include "DocumentFragment.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSDocumentFragmentTableEntries[] =
{
    { "constructor", JSDocumentFragment::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSDocumentFragmentTable = 
{
    2, 1, JSDocumentFragmentTableEntries, 1
};

/* Hash table for constructor */

static const HashEntry JSDocumentFragmentConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSDocumentFragmentConstructorTable = 
{
    2, 1, JSDocumentFragmentConstructorTableEntries, 1
};

class JSDocumentFragmentConstructor : public DOMObject {
public:
    JSDocumentFragmentConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSDocumentFragmentPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSDocumentFragmentConstructor::info = { "DocumentFragmentConstructor", 0, &JSDocumentFragmentConstructorTable, 0 };

bool JSDocumentFragmentConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentFragmentConstructor, DOMObject>(exec, &JSDocumentFragmentConstructorTable, this, propertyName, slot);
}

JSValue* JSDocumentFragmentConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSDocumentFragmentPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSDocumentFragmentPrototypeTable = 
{
    2, 1, JSDocumentFragmentPrototypeTableEntries, 1
};

const ClassInfo JSDocumentFragmentPrototype::info = { "DocumentFragmentPrototype", 0, &JSDocumentFragmentPrototypeTable, 0 };

JSObject* JSDocumentFragmentPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDocumentFragmentPrototype>(exec, "[[JSDocumentFragment.prototype]]");
}

const ClassInfo JSDocumentFragment::info = { "DocumentFragment", &JSEventTargetNode::info, &JSDocumentFragmentTable, 0 };

JSDocumentFragment::JSDocumentFragment(ExecState* exec, DocumentFragment* impl)
    : JSEventTargetNode(exec, impl)
{
    setPrototype(JSDocumentFragmentPrototype::self(exec));
}

bool JSDocumentFragment::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentFragment, JSEventTargetNode>(exec, &JSDocumentFragmentTable, this, propertyName, slot);
}

JSValue* JSDocumentFragment::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSDocumentFragment::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDocumentFragmentConstructor>(exec, "[[DocumentFragment.constructor]]");
}

}
