/*
* Copyright (c) 2004 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Bip controller class declaration.
*
*/


#ifndef _BIPCONTROLLER_H
#define _BIPCONTROLLER_H

//INCLUDES

#include <e32base.h>
#include <obex.h>
#include <obexutilsmessagehandler.h>
#include <obexutilsuilayer.h>
#include <obexutilsdialog.h>
#include "obexutilspropertynotifier.h"
#include "debug.h"
#include <SrcsInterface.h>
#include <obexutilspropertynotifier.h>
#include <obexutilsglobalprogressdialog.h>
#include <btengsettings.h>
#include "btengdevman.h"
#include <obexutilsdialog.h>

// FORWARD DECLARATIONS

class CBIPCapabilityHandler;
class CBIPImageHandler;


// CLASS DECLARATION

/**
*  The main controller for Basic Imaging Profile.
*/
NONSHARABLE_CLASS (CBIPController): public CSrcsInterface, public MObexServerNotify,
                                    public MObexUtilsPropertyNotifyHandler, 
                                    public MGlobalProgressCallback, public MGlobalNoteCallback,
                                    public MBTEngDevManObserver
    {
public:
    static CBIPController* NewL();
    ~CBIPController();
    
private: // from CSrcsInterface
    TBool IsOBEXActive();
    void SetMediaType(TSrcsMediaType aMediaType);
    TInt SetObexServer(CObexServer* aServer);

private: // from MObexServerNotify
    void ErrorIndication(TInt aError);
    void TransportUpIndication();
    void TransportDownIndication();
    TInt ObexConnectIndication(const TObexConnectInfo& aRemoteInfo, const TDesC8& aInfo);
    void ObexDisconnectIndication(const TDesC8& aInfo);
    CObexBufObject* PutRequestIndication();
    TInt PutPacketIndication();
    TInt PutCompleteIndication();
    CObexBufObject* GetRequestIndication(CObexBaseObject* aRequiredObject);
    TInt GetPacketIndication();
    TInt GetCompleteIndication();
    TInt SetPathIndication(const CObex::TSetPathInfo& aPathInfo, const TDesC8& aInfo);
    void AbortIndication();
    
private: // from MObexUtilsPropertyNotifyHandler
    void HandleNotifyL(TMemoryPropertyCheckType aCheckType);
    
private: // from MGlobalProgressCallback
    void HandleGlobalProgressDialogL(TInt aSoftkey); 
    
private: // from MGlobalNoteCallback
    void HandleGlobalNoteDialogL(TInt aSoftkey);
    
private: // from MBTEngDevManObserver
    void HandleGetDevicesComplete(TInt aErr, CBTDeviceArray* aDeviceArray);
    
private:
    CBIPController();
    void ConstructL();
    
    void CancelTransfer();
    
    void HandleError(TBool aAbort);
    void HandleGetCapabilityRequestL();
    void HandlePutImageRequestL();
    TInt HandlePutCompleteIndication();
    TInt RemoveCapabilityObject();
    
    TBool CheckCapacityL();
    void LaunchReceivingIndicatorL();
    inline TBool ReceivingIndicatorActive() const { return (iProgressDialog || iWaitDialog); }
    void UpdateReceivingIndicator();
    void CloseReceivingIndicator(TBool aResetDisplayedState = ETrue);
    TInt GetDriveWithMaximumFreeSpaceL();
    
private:
    enum TBipTransferState
        {
        ETransferIdle,
        ETransferPut,
        ETransferGet,
        ETransferPutDiskError,
        ETransferPutInitError,
        ETransferPutCancel,
        };
    
private: // Data
    CBIPCapabilityHandler*      iBIPCapabilityHandler;
    CObexBufObject*             iBTObject;
    CObexServer*                iBTObexServer;
    TBipTransferState           iBTTransferState;
    TInt                        iDrive;
    CBIPImageHandler*           iBIPImageHandler;
    CObexBufObject*             iGetObject;
    CObexUtilsPropertyNotifier* iLowMemoryActiveCDrive;
    CObexUtilsPropertyNotifier* iLowMemoryActiveMMC;
    TMsvId                      iMsvIdParent;
    TMsvId                      iMsvIdAttach;
    RFile                       iFile;
    RFs                         iFs;
    TFileName                   iFullPathFilename;
    TFileName                   iCapabilityFileName;
    TFileName                   iDefaultFolder;
    TFileName                   iPreviousDefaultFolder;
    CBufFlat                    *iBuf;
    TBool                       iLengthHeaderReceived;
    TInt                        iTotalSizeByte;
    CGlobalProgressDialog*      iProgressDialog;
    CGlobalDialog*              iWaitDialog;
    TBool                       iNoteDisplayed;
    CBTEngDevMan*               iDevMan;
    CBTDeviceArray*             iResultArray;
    TBTDeviceName               iRemoteDeviceName;
    TFileName                   iReceivingFileName;
    TFileName                   iCenRepFolder;
    };
    
_LIT(KBipPanicCategory, "BIP");
enum TBipPanicCode
    {
    EBipPanicNotBluetoothMediaType = 0,
    };

#endif      //_BIPCONTROLLER_H

// End of File
