/*
    Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/****************************************************************************
*************** This file has been generated. DO NOT MODIFY! ****************
****************************************************************************/

#include "tst_qscriptvalue.h"

void tst_QScriptValue::equals_initData()
{
    QTest::addColumn<QScriptValue>("other");
    QTest::addColumn<bool>("expected");
    initScriptValues();
}

static QString equals_array[] = {
    "QScriptValue() <=> QScriptValue()",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->nullValue()",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(QScriptValue::NullValue) <=> engine->undefinedValue()",
    "QScriptValue(true) <=> QScriptValue(true)",
    "QScriptValue(true) <=> QScriptValue(0, true)",
    "QScriptValue(true) <=> QScriptValue(engine, true)",
    "QScriptValue(true) <=> engine->evaluate(\"true\")",
    "QScriptValue(false) <=> QScriptValue(false)",
    "QScriptValue(false) <=> QScriptValue(0)",
    "QScriptValue(false) <=> QScriptValue(0.0)",
    "QScriptValue(false) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(false) <=> QScriptValue(QString())",
    "QScriptValue(false) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(false) <=> QScriptValue(0, false)",
    "QScriptValue(false) <=> QScriptValue(0, 0)",
    "QScriptValue(false) <=> QScriptValue(0, 0.0)",
    "QScriptValue(false) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(false) <=> QScriptValue(0, QString())",
    "QScriptValue(false) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(false) <=> QScriptValue(engine, false)",
    "QScriptValue(false) <=> QScriptValue(engine, 0)",
    "QScriptValue(false) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(false) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(false) <=> QScriptValue(engine, QString())",
    "QScriptValue(false) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(false) <=> engine->evaluate(\"[]\")",
    "QScriptValue(false) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(false) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(false) <=> engine->evaluate(\"false\")",
    "QScriptValue(false) <=> engine->evaluate(\"0\")",
    "QScriptValue(false) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(false) <=> engine->evaluate(\"''\")",
    "QScriptValue(false) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(0) <=> QScriptValue(false)",
    "QScriptValue(0) <=> QScriptValue(0)",
    "QScriptValue(0) <=> QScriptValue(0.0)",
    "QScriptValue(0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0) <=> QScriptValue(QString())",
    "QScriptValue(0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0) <=> QScriptValue(0, false)",
    "QScriptValue(0) <=> QScriptValue(0, 0)",
    "QScriptValue(0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0) <=> QScriptValue(0, QString())",
    "QScriptValue(0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0) <=> QScriptValue(engine, false)",
    "QScriptValue(0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0) <=> QScriptValue(engine, QString())",
    "QScriptValue(0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0) <=> engine->evaluate(\"false\")",
    "QScriptValue(0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0) <=> engine->evaluate(\"''\")",
    "QScriptValue(0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0.0) <=> QScriptValue(false)",
    "QScriptValue(0.0) <=> QScriptValue(0)",
    "QScriptValue(0.0) <=> QScriptValue(0.0)",
    "QScriptValue(0.0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0.0) <=> QScriptValue(QString())",
    "QScriptValue(0.0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0.0) <=> QScriptValue(0, false)",
    "QScriptValue(0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0.0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0.0) <=> QScriptValue(0, QString())",
    "QScriptValue(0.0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0.0) <=> QScriptValue(engine, false)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0.0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0.0) <=> QScriptValue(engine, QString())",
    "QScriptValue(0.0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0.0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"false\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"''\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(123.0) <=> QScriptValue(123.0)",
    "QScriptValue(123.0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(123.0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(123.0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(123.0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(-6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(qInf()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(qInf()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(qInf()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(qInf())",
    "QScriptValue(\"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(0, qInf())",
    "QScriptValue(\"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(engine, qInf())",
    "QScriptValue(\"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(-qInf())",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, -qInf())",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, -qInf())",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(false)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0.0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, false)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, 0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, false)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"[]\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(QString()) <=> QScriptValue(false)",
    "QScriptValue(QString()) <=> QScriptValue(0)",
    "QScriptValue(QString()) <=> QScriptValue(0.0)",
    "QScriptValue(QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(QString())",
    "QScriptValue(QString()) <=> QScriptValue(0, false)",
    "QScriptValue(QString()) <=> QScriptValue(0, 0)",
    "QScriptValue(QString()) <=> QScriptValue(0, 0.0)",
    "QScriptValue(QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(QString()) <=> QScriptValue(engine, false)",
    "QScriptValue(QString()) <=> QScriptValue(engine, 0)",
    "QScriptValue(QString()) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(QString()) <=> engine->evaluate(\"[]\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"false\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"0\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(false)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0.0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, false)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, 0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, false)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(123.0)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->nullValue()",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->undefinedValue()",
    "QScriptValue(0, true) <=> QScriptValue(true)",
    "QScriptValue(0, true) <=> QScriptValue(0, true)",
    "QScriptValue(0, true) <=> QScriptValue(engine, true)",
    "QScriptValue(0, true) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, false) <=> QScriptValue(false)",
    "QScriptValue(0, false) <=> QScriptValue(0)",
    "QScriptValue(0, false) <=> QScriptValue(0.0)",
    "QScriptValue(0, false) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, false) <=> QScriptValue(QString())",
    "QScriptValue(0, false) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, false) <=> QScriptValue(0, false)",
    "QScriptValue(0, false) <=> QScriptValue(0, 0)",
    "QScriptValue(0, false) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, false) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, false) <=> QScriptValue(0, QString())",
    "QScriptValue(0, false) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, false) <=> QScriptValue(engine, false)",
    "QScriptValue(0, false) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, false) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, false) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, false) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, false) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, false) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, 0) <=> QScriptValue(false)",
    "QScriptValue(0, 0) <=> QScriptValue(0)",
    "QScriptValue(0, 0) <=> QScriptValue(0.0)",
    "QScriptValue(0, 0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, 0) <=> QScriptValue(QString())",
    "QScriptValue(0, 0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, 0) <=> QScriptValue(0, false)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 0)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, 0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, 0) <=> QScriptValue(0, QString())",
    "QScriptValue(0, 0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, 0) <=> QScriptValue(engine, false)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, 0) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, 0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, 0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, 0.0) <=> QScriptValue(false)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(QString())",
    "QScriptValue(0, 0.0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, false)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, QString())",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, false)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, 123.0) <=> QScriptValue(123.0)",
    "QScriptValue(0, 123.0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, 0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, 0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, 0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, 0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(0, qInf()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, qInf()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, qInf()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(qInf())",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(0, qInf())",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(-qInf())",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, -qInf())",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, -qInf())",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(false)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0.0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, false)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, 0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, false)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, QString()) <=> QScriptValue(false)",
    "QScriptValue(0, QString()) <=> QScriptValue(0)",
    "QScriptValue(0, QString()) <=> QScriptValue(0.0)",
    "QScriptValue(0, QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(QString())",
    "QScriptValue(0, QString()) <=> QScriptValue(0, false)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, 0)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, false)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(false)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0.0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, false)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, 0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, false)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(123.0)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->nullValue()",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->undefinedValue()",
    "QScriptValue(engine, true) <=> QScriptValue(true)",
    "QScriptValue(engine, true) <=> QScriptValue(0, true)",
    "QScriptValue(engine, true) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, true) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, false) <=> QScriptValue(false)",
    "QScriptValue(engine, false) <=> QScriptValue(0)",
    "QScriptValue(engine, false) <=> QScriptValue(0.0)",
    "QScriptValue(engine, false) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, false) <=> QScriptValue(QString())",
    "QScriptValue(engine, false) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, false) <=> QScriptValue(0, false)",
    "QScriptValue(engine, false) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, false) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, false) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, false) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, false) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, false) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, false) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, false) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, false) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, 0) <=> QScriptValue(false)",
    "QScriptValue(engine, 0) <=> QScriptValue(0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(QString())",
    "QScriptValue(engine, 0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(0, false)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, 0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, 0.0) <=> QScriptValue(false)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(QString())",
    "QScriptValue(engine, 0.0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, false)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, 123.0) <=> QScriptValue(123.0)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, 0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, 0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(engine, qInf()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, qInf()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, qInf()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(qInf())",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(-qInf())",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, -qInf())",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, -qInf())",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(false)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0.0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, false)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(false)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0.0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString())",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, false)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(false)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0.0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, false)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(123.0)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(false)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(QString())",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"{}\") <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(QScriptValue::NullValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->evaluate(\"{}\") <=> engine->evaluate(\"{}\")",
    "engine->evaluate(\"{}\") <=> engine->evaluate(\"undefined\")",
    "engine->evaluate(\"{}\") <=> engine->evaluate(\"null\")",
    "engine->evaluate(\"{}\") <=> engine->nullValue()",
    "engine->evaluate(\"{}\") <=> engine->undefinedValue()",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"Date.prototype\") <=> engine->evaluate(\"Date.prototype\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(false)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(QString())",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"Object\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Array\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Number\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"Function\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"(function() { throw new Error('foo' })\") <=> engine->evaluate(\"(function() { throw new Error('foo' })\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"/foo/\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(false)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(QString())",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"a = new Object( a.foo = 22; a.foo\") <=> engine->evaluate(\"a = new Object( a.foo = 22; a.foo\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"undefined\") <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(QScriptValue::NullValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->evaluate(\"undefined\") <=> engine->evaluate(\"{}\")",
    "engine->evaluate(\"undefined\") <=> engine->evaluate(\"undefined\")",
    "engine->evaluate(\"undefined\") <=> engine->evaluate(\"null\")",
    "engine->evaluate(\"undefined\") <=> engine->nullValue()",
    "engine->evaluate(\"undefined\") <=> engine->undefinedValue()",
    "engine->evaluate(\"null\") <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"{}\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"undefined\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"null\")",
    "engine->evaluate(\"null\") <=> engine->nullValue()",
    "engine->evaluate(\"null\") <=> engine->undefinedValue()",
    "engine->evaluate(\"true\") <=> QScriptValue(true)",
    "engine->evaluate(\"true\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"false\") <=> QScriptValue(false)",
    "engine->evaluate(\"false\") <=> QScriptValue(0)",
    "engine->evaluate(\"false\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"false\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(QString())",
    "engine->evaluate(\"false\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"false\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"122\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"122\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"124\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"124\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"124\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"124\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"0\") <=> QScriptValue(false)",
    "engine->evaluate(\"0\") <=> QScriptValue(0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(QString())",
    "engine->evaluate(\"0\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"0\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"0.0\") <=> QScriptValue(false)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(QString())",
    "engine->evaluate(\"0.0\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"123.0\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(-6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, -6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, -6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"-6.37e-8\")",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"0x10000\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"0x10001\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"Infinity\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(-qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, -qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, -qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"-Infinity\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"''\") <=> QScriptValue(false)",
    "engine->evaluate(\"''\") <=> QScriptValue(0)",
    "engine->evaluate(\"''\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"''\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(QString())",
    "engine->evaluate(\"''\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(false)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"'12.4'\")",
    "engine->nullValue() <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->nullValue() <=> QScriptValue(QScriptValue::NullValue)",
    "engine->nullValue() <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->nullValue() <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->nullValue() <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->nullValue() <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->nullValue() <=> engine->evaluate(\"{}\")",
    "engine->nullValue() <=> engine->evaluate(\"undefined\")",
    "engine->nullValue() <=> engine->evaluate(\"null\")",
    "engine->nullValue() <=> engine->nullValue()",
    "engine->nullValue() <=> engine->undefinedValue()",
    "engine->undefinedValue() <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> QScriptValue(QScriptValue::NullValue)",
    "engine->undefinedValue() <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->undefinedValue() <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->undefinedValue() <=> engine->evaluate(\"{}\")",
    "engine->undefinedValue() <=> engine->evaluate(\"undefined\")",
    "engine->undefinedValue() <=> engine->evaluate(\"null\")",
    "engine->undefinedValue() <=> engine->nullValue()",
    "engine->undefinedValue() <=> engine->undefinedValue()"};

void tst_QScriptValue::equals_makeData(const char *expr)
{
    static QSet<QString> equals;
    if (equals.isEmpty()) {
        equals.reserve(1085);
        for (unsigned i = 0; i < 1085; ++i)
            equals.insert(equals_array[i]);
    }
    QHash<QString, QScriptValue>::const_iterator it;
    for (it = m_values.constBegin(); it != m_values.constEnd(); ++it) {
        QString tag = QString::fromLatin1("%20 <=> %21").arg(expr).arg(it.key());
        newRow(tag.toLatin1()) << it.value() << equals.contains(tag);
    }
}

void tst_QScriptValue::equals_test(const char *, const QScriptValue& value)
{
    QFETCH(QScriptValue, other);
    QFETCH(bool, expected);
    QCOMPARE(value.equals(other), expected);
}

DEFINE_TEST_FUNCTION(equals)


void tst_QScriptValue::strictlyEquals_initData()
{
    QTest::addColumn<QScriptValue>("other");
    QTest::addColumn<bool>("expected");
    initScriptValues();
}

static QString strictlyEquals_array[] = {
    "QScriptValue() <=> QScriptValue()",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(true) <=> QScriptValue(true)",
    "QScriptValue(true) <=> QScriptValue(0, true)",
    "QScriptValue(true) <=> QScriptValue(engine, true)",
    "QScriptValue(true) <=> engine->evaluate(\"true\")",
    "QScriptValue(false) <=> QScriptValue(false)",
    "QScriptValue(false) <=> QScriptValue(0, false)",
    "QScriptValue(false) <=> QScriptValue(engine, false)",
    "QScriptValue(false) <=> engine->evaluate(\"false\")",
    "QScriptValue(int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(0) <=> QScriptValue(0)",
    "QScriptValue(0) <=> QScriptValue(0.0)",
    "QScriptValue(0) <=> QScriptValue(0, 0)",
    "QScriptValue(0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0.0) <=> QScriptValue(0)",
    "QScriptValue(0.0) <=> QScriptValue(0.0)",
    "QScriptValue(0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(123.0) <=> QScriptValue(123.0)",
    "QScriptValue(123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(-6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(QString())",
    "QScriptValue(QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(0, true) <=> QScriptValue(true)",
    "QScriptValue(0, true) <=> QScriptValue(0, true)",
    "QScriptValue(0, true) <=> QScriptValue(engine, true)",
    "QScriptValue(0, true) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, false) <=> QScriptValue(false)",
    "QScriptValue(0, false) <=> QScriptValue(0, false)",
    "QScriptValue(0, false) <=> QScriptValue(engine, false)",
    "QScriptValue(0, false) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, 0) <=> QScriptValue(0)",
    "QScriptValue(0, 0) <=> QScriptValue(0.0)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 0)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, 0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, 0.0) <=> QScriptValue(0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, 123.0) <=> QScriptValue(123.0)",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, 0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, 0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, 0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, 0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(0, qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(QString())",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(engine, true) <=> QScriptValue(true)",
    "QScriptValue(engine, true) <=> QScriptValue(0, true)",
    "QScriptValue(engine, true) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, true) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, false) <=> QScriptValue(false)",
    "QScriptValue(engine, false) <=> QScriptValue(0, false)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, false) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, 0) <=> QScriptValue(0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, 123.0) <=> QScriptValue(123.0)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, 0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, 0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(engine, qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString())",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"{}\") <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> engine->evaluate(\"{}\")",
    "engine->evaluate(\"{}\") <=> engine->evaluate(\"undefined\")",
    "engine->evaluate(\"{}\") <=> engine->undefinedValue()",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"Date.prototype\") <=> engine->evaluate(\"Date.prototype\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"Object\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Array\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Number\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"Function\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"(function() { throw new Error('foo' })\") <=> engine->evaluate(\"(function() { throw new Error('foo' })\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"/foo/\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"a = new Object( a.foo = 22; a.foo\") <=> engine->evaluate(\"a = new Object( a.foo = 22; a.foo\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"undefined\") <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> engine->evaluate(\"{}\")",
    "engine->evaluate(\"undefined\") <=> engine->evaluate(\"undefined\")",
    "engine->evaluate(\"undefined\") <=> engine->undefinedValue()",
    "engine->evaluate(\"null\") <=> QScriptValue(QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"null\")",
    "engine->evaluate(\"null\") <=> engine->nullValue()",
    "engine->evaluate(\"true\") <=> QScriptValue(true)",
    "engine->evaluate(\"true\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"false\") <=> QScriptValue(false)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"122\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"122\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"124\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"124\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"124\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"124\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"0\") <=> QScriptValue(0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"123.0\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(-6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, -6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, -6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"-6.37e-8\")",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"0x10000\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"0x10001\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"Infinity\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(-qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, -qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, -qInf())",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"-Infinity\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"''\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(QString())",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"'12.4'\")",
    "engine->nullValue() <=> QScriptValue(QScriptValue::NullValue)",
    "engine->nullValue() <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->nullValue() <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->nullValue() <=> engine->evaluate(\"null\")",
    "engine->nullValue() <=> engine->nullValue()",
    "engine->undefinedValue() <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> engine->evaluate(\"{}\")",
    "engine->undefinedValue() <=> engine->evaluate(\"undefined\")",
    "engine->undefinedValue() <=> engine->undefinedValue()"};

void tst_QScriptValue::strictlyEquals_makeData(const char* expr)
{
    static QSet<QString> equals;
    if (equals.isEmpty()) {
        equals.reserve(503);
        for (unsigned i = 0; i < 503; ++i)
            equals.insert(strictlyEquals_array[i]);
    }
    QHash<QString, QScriptValue>::const_iterator it;
    for (it = m_values.constBegin(); it != m_values.constEnd(); ++it) {
        QString tag = QString::fromLatin1("%20 <=> %21").arg(expr).arg(it.key());
        newRow(tag.toLatin1()) << it.value() << equals.contains(tag);
    }
}

void tst_QScriptValue::strictlyEquals_test(const char*, const QScriptValue& value)
{
    QFETCH(QScriptValue, other);
    QFETCH(bool, expected);
    QCOMPARE(value.strictlyEquals(other), expected);
}

DEFINE_TEST_FUNCTION(strictlyEquals)


void tst_QScriptValue::instanceOf_initData()
{
    QTest::addColumn<QScriptValue>("other");
    QTest::addColumn<bool>("expected");
    initScriptValues();
}

static QString instanceOf_array[] = {
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Date.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Object\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Object\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Array\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Array\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Number\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Number\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Function\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Function\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { throw new Error('foo' })\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"a = new Object( a.foo = 22; a.foo\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"Object\")"};

void tst_QScriptValue::instanceOf_makeData(const char *expr)
{
    static QSet<QString> equals;
    if (equals.isEmpty()) {
        equals.reserve(29);
        for (unsigned i = 0; i < 29; ++i)
            equals.insert(instanceOf_array[i]);
    }
    QHash<QString, QScriptValue>::const_iterator it;
    for (it = m_values.constBegin(); it != m_values.constEnd(); ++it) {
        QString tag = QString::fromLatin1("%20 <=> %21").arg(expr).arg(it.key());
        newRow(tag.toLatin1()) << it.value() << equals.contains(tag);
    }
}

void tst_QScriptValue::instanceOf_test(const char *, const QScriptValue& value)
{
    QFETCH(QScriptValue, other);
    QFETCH(bool, expected);
    QCOMPARE(value.instanceOf(other), expected);
}

DEFINE_TEST_FUNCTION(instanceOf)
