/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSPositionError.h"

#include "KURL.h"
#include "PositionError.h"
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSPositionError);

/* Hash table */

static const HashTableValue JSPositionErrorTableValues[4] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorCode), (intptr_t)0 },
    { "message", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorMessage), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPositionErrorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSPositionErrorTableValues, 0 };
#else
    { 9, 7, JSPositionErrorTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSPositionErrorConstructorTableValues[4] =
{
    { "PERMISSION_DENIED", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorPERMISSION_DENIED), (intptr_t)0 },
    { "POSITION_UNAVAILABLE", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorPOSITION_UNAVAILABLE), (intptr_t)0 },
    { "TIMEOUT", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorTIMEOUT), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPositionErrorConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSPositionErrorConstructorTableValues, 0 };
#else
    { 9, 7, JSPositionErrorConstructorTableValues, 0 };
#endif

class JSPositionErrorConstructor : public DOMConstructorObject {
public:
    JSPositionErrorConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSPositionErrorConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSPositionErrorPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSPositionErrorConstructor::s_info = { "PositionErrorConstructor", 0, &JSPositionErrorConstructorTable, 0 };

bool JSPositionErrorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPositionErrorConstructor, DOMObject>(exec, &JSPositionErrorConstructorTable, this, propertyName, slot);
}

bool JSPositionErrorConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPositionErrorConstructor, DOMObject>(exec, &JSPositionErrorConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSPositionErrorPrototypeTableValues[4] =
{
    { "PERMISSION_DENIED", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorPERMISSION_DENIED), (intptr_t)0 },
    { "POSITION_UNAVAILABLE", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorPOSITION_UNAVAILABLE), (intptr_t)0 },
    { "TIMEOUT", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorTIMEOUT), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPositionErrorPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSPositionErrorPrototypeTableValues, 0 };
#else
    { 9, 7, JSPositionErrorPrototypeTableValues, 0 };
#endif

const ClassInfo JSPositionErrorPrototype::s_info = { "PositionErrorPrototype", 0, &JSPositionErrorPrototypeTable, 0 };

JSObject* JSPositionErrorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPositionError>(exec, globalObject);
}

bool JSPositionErrorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPositionErrorPrototype, JSObject>(exec, &JSPositionErrorPrototypeTable, this, propertyName, slot);
}

bool JSPositionErrorPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPositionErrorPrototype, JSObject>(exec, &JSPositionErrorPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSPositionError::s_info = { "PositionError", 0, &JSPositionErrorTable, 0 };

JSPositionError::JSPositionError(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<PositionError> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSPositionError::~JSPositionError()
{
    forgetDOMObject(this, impl());
}

JSObject* JSPositionError::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSPositionErrorPrototype(JSPositionErrorPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSPositionError::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPositionError, Base>(exec, &JSPositionErrorTable, this, propertyName, slot);
}

bool JSPositionError::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPositionError, Base>(exec, &JSPositionErrorTable, this, propertyName, descriptor);
}

JSValue jsPositionErrorCode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPositionError* castedThis = static_cast<JSPositionError*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PositionError* imp = static_cast<PositionError*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->code());
    return result;
}

JSValue jsPositionErrorMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPositionError* castedThis = static_cast<JSPositionError*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PositionError* imp = static_cast<PositionError*>(castedThis->impl());
    JSValue result = jsString(exec, imp->message());
    return result;
}

JSValue jsPositionErrorConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPositionError* domObject = static_cast<JSPositionError*>(asObject(slotBase));
    return JSPositionError::getConstructor(exec, domObject->globalObject());
}
JSValue JSPositionError::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPositionErrorConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsPositionErrorPERMISSION_DENIED(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsPositionErrorPOSITION_UNAVAILABLE(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsPositionErrorTIMEOUT(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, PositionError* object)
{
    return getDOMObjectWrapper<JSPositionError>(exec, globalObject, object);
}
PositionError* toPositionError(JSC::JSValue value)
{
    return value.inherits(&JSPositionError::s_info) ? static_cast<JSPositionError*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(GEOLOCATION)
