/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLBodyElement.h"

#include "EventListener.h"
#include "HTMLBodyElement.h"
#include "HTMLNames.h"
#include "JSEventListener.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLBodyElement);

/* Hash table */

static const HashTableValue JSHTMLBodyElementTableValues[17] =
{
    { "aLink", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementALink), (intptr_t)setJSHTMLBodyElementALink },
    { "background", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementBackground), (intptr_t)setJSHTMLBodyElementBackground },
    { "bgColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementBgColor), (intptr_t)setJSHTMLBodyElementBgColor },
    { "link", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementLink), (intptr_t)setJSHTMLBodyElementLink },
    { "text", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementText), (intptr_t)setJSHTMLBodyElementText },
    { "vLink", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementVLink), (intptr_t)setJSHTMLBodyElementVLink },
    { "onbeforeunload", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnbeforeunload), (intptr_t)setJSHTMLBodyElementOnbeforeunload },
    { "onhashchange", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnhashchange), (intptr_t)setJSHTMLBodyElementOnhashchange },
    { "onmessage", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnmessage), (intptr_t)setJSHTMLBodyElementOnmessage },
    { "onoffline", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnoffline), (intptr_t)setJSHTMLBodyElementOnoffline },
    { "ononline", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnonline), (intptr_t)setJSHTMLBodyElementOnonline },
    { "onpopstate", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnpopstate), (intptr_t)setJSHTMLBodyElementOnpopstate },
    { "onresize", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnresize), (intptr_t)setJSHTMLBodyElementOnresize },
    { "onstorage", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnstorage), (intptr_t)setJSHTMLBodyElementOnstorage },
    { "onunload", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnunload), (intptr_t)setJSHTMLBodyElementOnunload },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLBodyElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSHTMLBodyElementTableValues, 0 };
#else
    { 35, 31, JSHTMLBodyElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLBodyElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLBodyElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLBodyElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLBodyElementConstructorTableValues, 0 };
#endif

class JSHTMLBodyElementConstructor : public DOMConstructorObject {
public:
    JSHTMLBodyElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLBodyElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLBodyElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLBodyElementConstructor::s_info = { "HTMLBodyElementConstructor", 0, &JSHTMLBodyElementConstructorTable, 0 };

bool JSHTMLBodyElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBodyElementConstructor, DOMObject>(exec, &JSHTMLBodyElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLBodyElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLBodyElementConstructor, DOMObject>(exec, &JSHTMLBodyElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLBodyElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLBodyElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLBodyElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLBodyElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLBodyElementPrototype::s_info = { "HTMLBodyElementPrototype", 0, &JSHTMLBodyElementPrototypeTable, 0 };

JSObject* JSHTMLBodyElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLBodyElement>(exec, globalObject);
}

const ClassInfo JSHTMLBodyElement::s_info = { "HTMLBodyElement", &JSHTMLElement::s_info, &JSHTMLBodyElementTable, 0 };

JSHTMLBodyElement::JSHTMLBodyElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLBodyElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLBodyElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLBodyElementPrototype(JSHTMLBodyElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLBodyElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBodyElement, Base>(exec, &JSHTMLBodyElementTable, this, propertyName, slot);
}

bool JSHTMLBodyElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLBodyElement, Base>(exec, &JSHTMLBodyElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLBodyElementALink(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::alinkAttr));
    return result;
}

JSValue jsHTMLBodyElementBackground(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::backgroundAttr));
    return result;
}

JSValue jsHTMLBodyElementBgColor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::bgcolorAttr));
    return result;
}

JSValue jsHTMLBodyElementLink(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::linkAttr));
    return result;
}

JSValue jsHTMLBodyElementText(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::textAttr));
    return result;
}

JSValue jsHTMLBodyElementVLink(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::vlinkAttr));
    return result;
}

JSValue jsHTMLBodyElementOnbeforeunload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforeunload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsHTMLBodyElementOnhashchange(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    if (EventListener* listener = imp->onhashchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsHTMLBodyElementOnmessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    if (EventListener* listener = imp->onmessage()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsHTMLBodyElementOnoffline(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    if (EventListener* listener = imp->onoffline()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsHTMLBodyElementOnonline(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    if (EventListener* listener = imp->ononline()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsHTMLBodyElementOnpopstate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    if (EventListener* listener = imp->onpopstate()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsHTMLBodyElementOnresize(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    if (EventListener* listener = imp->onresize()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsHTMLBodyElementOnstorage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    if (EventListener* listener = imp->onstorage()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsHTMLBodyElementOnunload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* castedThis = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThis->impl());
    if (EventListener* listener = imp->onunload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsHTMLBodyElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBodyElement* domObject = static_cast<JSHTMLBodyElement*>(asObject(slotBase));
    return JSHTMLBodyElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLBodyElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLBodyElement, Base>(exec, propertyName, value, &JSHTMLBodyElementTable, this, slot);
}

void setJSHTMLBodyElementALink(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLBodyElement* castedThisObj = static_cast<JSHTMLBodyElement*>(thisObject);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::alinkAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLBodyElementBackground(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLBodyElement* castedThisObj = static_cast<JSHTMLBodyElement*>(thisObject);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::backgroundAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLBodyElementBgColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLBodyElement* castedThisObj = static_cast<JSHTMLBodyElement*>(thisObject);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::bgcolorAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLBodyElementLink(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLBodyElement* castedThisObj = static_cast<JSHTMLBodyElement*>(thisObject);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::linkAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLBodyElementText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLBodyElement* castedThisObj = static_cast<JSHTMLBodyElement*>(thisObject);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::textAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLBodyElementVLink(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLBodyElement* castedThisObj = static_cast<JSHTMLBodyElement*>(thisObject);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::vlinkAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLBodyElementOnbeforeunload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(static_cast<JSHTMLBodyElement*>(thisObject)->impl());
    imp->setOnbeforeunload(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSHTMLBodyElementOnhashchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(static_cast<JSHTMLBodyElement*>(thisObject)->impl());
    imp->setOnhashchange(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSHTMLBodyElementOnmessage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(static_cast<JSHTMLBodyElement*>(thisObject)->impl());
    imp->setOnmessage(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSHTMLBodyElementOnoffline(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(static_cast<JSHTMLBodyElement*>(thisObject)->impl());
    imp->setOnoffline(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSHTMLBodyElementOnonline(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(static_cast<JSHTMLBodyElement*>(thisObject)->impl());
    imp->setOnonline(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSHTMLBodyElementOnpopstate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(static_cast<JSHTMLBodyElement*>(thisObject)->impl());
    imp->setOnpopstate(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSHTMLBodyElementOnresize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(static_cast<JSHTMLBodyElement*>(thisObject)->impl());
    imp->setOnresize(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSHTMLBodyElementOnstorage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(static_cast<JSHTMLBodyElement*>(thisObject)->impl());
    imp->setOnstorage(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSHTMLBodyElementOnunload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(static_cast<JSHTMLBodyElement*>(thisObject)->impl());
    imp->setOnunload(createJSAttributeEventListener(exec, value, thisObject));
}

JSValue JSHTMLBodyElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLBodyElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
