/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageData.h"

#include "ImageData.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSImageData);

/* Hash table */

static const HashTableValue JSImageDataTableValues[4] =
{
    { "width", DontDelete|ReadOnly, (intptr_t)jsImageDataWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsImageDataHeight, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsImageDataConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSImageDataTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSImageDataTableValues, 0 };
#else
    { 9, 7, JSImageDataTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSImageDataConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSImageDataConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSImageDataConstructorTableValues, 0 };
#else
    { 1, 0, JSImageDataConstructorTableValues, 0 };
#endif

class JSImageDataConstructor : public DOMConstructorObject {
public:
    JSImageDataConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSImageDataConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSImageDataPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSImageDataConstructor::s_info = { "ImageDataConstructor", 0, &JSImageDataConstructorTable, 0 };

bool JSImageDataConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSImageDataConstructor, DOMObject>(exec, &JSImageDataConstructorTable, this, propertyName, slot);
}

bool JSImageDataConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSImageDataConstructor, DOMObject>(exec, &JSImageDataConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSImageDataPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSImageDataPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSImageDataPrototypeTableValues, 0 };
#else
    { 1, 0, JSImageDataPrototypeTableValues, 0 };
#endif

const ClassInfo JSImageDataPrototype::s_info = { "ImageDataPrototype", 0, &JSImageDataPrototypeTable, 0 };

JSObject* JSImageDataPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSImageData>(exec, globalObject);
}

const ClassInfo JSImageData::s_info = { "ImageData", 0, &JSImageDataTable, 0 };

JSImageData::JSImageData(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<ImageData> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSImageData::~JSImageData()
{
    forgetDOMObject(this, impl());
}

JSObject* JSImageData::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSImageDataPrototype(JSImageDataPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSImageData::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSImageData, Base>(exec, &JSImageDataTable, this, propertyName, slot);
}

bool JSImageData::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSImageData, Base>(exec, &JSImageDataTable, this, propertyName, descriptor);
}

JSValue jsImageDataWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSImageData* castedThis = static_cast<JSImageData*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ImageData* imp = static_cast<ImageData*>(castedThis->impl());
    return jsNumber(exec, imp->width());
}

JSValue jsImageDataHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSImageData* castedThis = static_cast<JSImageData*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ImageData* imp = static_cast<ImageData*>(castedThis->impl());
    return jsNumber(exec, imp->height());
}

JSValue jsImageDataConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSImageData* domObject = static_cast<JSImageData*>(asObject(slot.slotBase()));
    return JSImageData::getConstructor(exec, domObject->globalObject());
}
JSValue JSImageData::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSImageDataConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

ImageData* toImageData(JSC::JSValue value)
{
    return value.inherits(&JSImageData::s_info) ? static_cast<JSImageData*>(asObject(value))->impl() : 0;
}

}
