/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtDeclarative module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/

import Qt 4.7
import GraphicsLayouts 4.7

Item {
    id: resizable

    width: 800
    height: 400

    QGraphicsWidget {
        size.width: parent.width/2
        size.height: parent.height

        layout: QGraphicsLinearLayout {
            LayoutItem {
                minimumSize: "100x100"
                maximumSize: "300x300"
                preferredSize: "100x100"
                Rectangle { color: "yellow"; anchors.fill: parent }
            }
            LayoutItem {
                minimumSize: "100x100"
                maximumSize: "400x400"
                preferredSize: "200x200"
                Rectangle { color: "green"; anchors.fill: parent }
            }
        }
    }
    QGraphicsWidget {
        x: parent.width/2
        size.width: parent.width/2
        size.height: parent.height

        layout: QGraphicsGridLayout {
            LayoutItem {
                QGraphicsGridLayout.row: 0
                QGraphicsGridLayout.column: 0
                minimumSize: "100x100"
                maximumSize: "300x300"
                preferredSize: "100x100"
                Rectangle { color: "red"; anchors.fill: parent }
            }
            LayoutItem {
                QGraphicsGridLayout.row: 1
                QGraphicsGridLayout.column: 0
                minimumSize: "100x100"
                maximumSize: "200x200"
                preferredSize: "100x100"
                Rectangle { color: "orange"; anchors.fill: parent }
            }
            LayoutItem {
                QGraphicsGridLayout.row: 2
                QGraphicsGridLayout.column: 0
                minimumSize: "100x100"
                maximumSize: "300x300"
                preferredSize: "200x200"
                Rectangle { color: "yellow"; anchors.fill: parent }
            }
            LayoutItem {
                QGraphicsGridLayout.row: 0
                QGraphicsGridLayout.column: 1
                minimumSize: "100x100"
                maximumSize: "200x200"
                preferredSize: "200x200"
                Rectangle { color: "green"; anchors.fill: parent }
            }
            LayoutItem {
                QGraphicsGridLayout.row: 1
                QGraphicsGridLayout.column: 1
                minimumSize: "100x100"
                maximumSize: "400x400"
                preferredSize: "200x200"
                Rectangle { color: "blue"; anchors.fill: parent }
            }
        }
    }
}
