/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSValidityState.h"

#include "ValidityState.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSValidityState);

/* Hash table */

static const HashTableValue JSValidityStateTableValues[10] =
{
    { "valueMissing", DontDelete|ReadOnly, (intptr_t)jsValidityStateValueMissing, (intptr_t)0 },
    { "typeMismatch", DontDelete|ReadOnly, (intptr_t)jsValidityStateTypeMismatch, (intptr_t)0 },
    { "patternMismatch", DontDelete|ReadOnly, (intptr_t)jsValidityStatePatternMismatch, (intptr_t)0 },
    { "tooLong", DontDelete|ReadOnly, (intptr_t)jsValidityStateTooLong, (intptr_t)0 },
    { "rangeUnderflow", DontDelete|ReadOnly, (intptr_t)jsValidityStateRangeUnderflow, (intptr_t)0 },
    { "rangeOverflow", DontDelete|ReadOnly, (intptr_t)jsValidityStateRangeOverflow, (intptr_t)0 },
    { "stepMismatch", DontDelete|ReadOnly, (intptr_t)jsValidityStateStepMismatch, (intptr_t)0 },
    { "customError", DontDelete|ReadOnly, (intptr_t)jsValidityStateCustomError, (intptr_t)0 },
    { "valid", DontDelete|ReadOnly, (intptr_t)jsValidityStateValid, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSValidityStateTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1023, JSValidityStateTableValues, 0 };
#else
    { 34, 31, JSValidityStateTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSValidityStatePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSValidityStatePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSValidityStatePrototypeTableValues, 0 };
#else
    { 1, 0, JSValidityStatePrototypeTableValues, 0 };
#endif

const ClassInfo JSValidityStatePrototype::s_info = { "ValidityStatePrototype", 0, &JSValidityStatePrototypeTable, 0 };

JSObject* JSValidityStatePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSValidityState>(exec, globalObject);
}

const ClassInfo JSValidityState::s_info = { "ValidityState", 0, &JSValidityStateTable, 0 };

JSValidityState::JSValidityState(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<ValidityState> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSValidityState::~JSValidityState()
{
    forgetDOMObject(this, impl());
}

JSObject* JSValidityState::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSValidityStatePrototype(JSValidityStatePrototype::createStructure(globalObject->objectPrototype()));
}

bool JSValidityState::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSValidityState, Base>(exec, &JSValidityStateTable, this, propertyName, slot);
}

bool JSValidityState::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSValidityState, Base>(exec, &JSValidityStateTable, this, propertyName, descriptor);
}

JSValue jsValidityStateValueMissing(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    return jsBoolean(imp->valueMissing());
}

JSValue jsValidityStateTypeMismatch(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    return jsBoolean(imp->typeMismatch());
}

JSValue jsValidityStatePatternMismatch(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    return jsBoolean(imp->patternMismatch());
}

JSValue jsValidityStateTooLong(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    return jsBoolean(imp->tooLong());
}

JSValue jsValidityStateRangeUnderflow(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    return jsBoolean(imp->rangeUnderflow());
}

JSValue jsValidityStateRangeOverflow(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    return jsBoolean(imp->rangeOverflow());
}

JSValue jsValidityStateStepMismatch(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    return jsBoolean(imp->stepMismatch());
}

JSValue jsValidityStateCustomError(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    return jsBoolean(imp->customError());
}

JSValue jsValidityStateValid(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    return jsBoolean(imp->valid());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ValidityState* object)
{
    return getDOMObjectWrapper<JSValidityState>(exec, globalObject, object);
}
ValidityState* toValidityState(JSC::JSValue value)
{
    return value.inherits(&JSValidityState::s_info) ? static_cast<JSValidityState*>(asObject(value))->impl() : 0;
}

}
