/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLCanvasElement.h"

#include "HTMLCanvasElement.h"
#include "JSCanvasRenderingContext2D.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLCanvasElement);

/* Hash table */

static const HashTableValue JSHTMLCanvasElementTableValues[4] =
{
    { "width", DontDelete, (intptr_t)jsHTMLCanvasElementWidth, (intptr_t)setJSHTMLCanvasElementWidth },
    { "height", DontDelete, (intptr_t)jsHTMLCanvasElementHeight, (intptr_t)setJSHTMLCanvasElementHeight },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLCanvasElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLCanvasElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSHTMLCanvasElementTableValues, 0 };
#else
    { 9, 7, JSHTMLCanvasElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLCanvasElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLCanvasElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLCanvasElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLCanvasElementConstructorTableValues, 0 };
#endif

class JSHTMLCanvasElementConstructor : public DOMConstructorObject {
public:
    JSHTMLCanvasElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLCanvasElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLCanvasElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLCanvasElementConstructor::s_info = { "HTMLCanvasElementConstructor", 0, &JSHTMLCanvasElementConstructorTable, 0 };

bool JSHTMLCanvasElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLCanvasElementConstructor, DOMObject>(exec, &JSHTMLCanvasElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLCanvasElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLCanvasElementConstructor, DOMObject>(exec, &JSHTMLCanvasElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLCanvasElementPrototypeTableValues[3] =
{
    { "toDataURL", DontDelete|Function, (intptr_t)jsHTMLCanvasElementPrototypeFunctionToDataURL, (intptr_t)1 },
    { "getContext", DontDelete|Function, (intptr_t)jsHTMLCanvasElementPrototypeFunctionGetContext, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLCanvasElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSHTMLCanvasElementPrototypeTableValues, 0 };
#else
    { 4, 3, JSHTMLCanvasElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLCanvasElementPrototype::s_info = { "HTMLCanvasElementPrototype", 0, &JSHTMLCanvasElementPrototypeTable, 0 };

JSObject* JSHTMLCanvasElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLCanvasElement>(exec, globalObject);
}

bool JSHTMLCanvasElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLCanvasElementPrototypeTable, this, propertyName, slot);
}

bool JSHTMLCanvasElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLCanvasElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHTMLCanvasElement::s_info = { "HTMLCanvasElement", &JSHTMLElement::s_info, &JSHTMLCanvasElementTable, 0 };

JSHTMLCanvasElement::JSHTMLCanvasElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLCanvasElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLCanvasElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLCanvasElementPrototype(JSHTMLCanvasElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLCanvasElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLCanvasElement, Base>(exec, &JSHTMLCanvasElementTable, this, propertyName, slot);
}

bool JSHTMLCanvasElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLCanvasElement, Base>(exec, &JSHTMLCanvasElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLCanvasElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLCanvasElement* castedThis = static_cast<JSHTMLCanvasElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(castedThis->impl());
    return jsNumber(exec, imp->width());
}

JSValue jsHTMLCanvasElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLCanvasElement* castedThis = static_cast<JSHTMLCanvasElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(castedThis->impl());
    return jsNumber(exec, imp->height());
}

JSValue jsHTMLCanvasElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLCanvasElement* domObject = static_cast<JSHTMLCanvasElement*>(asObject(slot.slotBase()));
    return JSHTMLCanvasElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLCanvasElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLCanvasElement, Base>(exec, propertyName, value, &JSHTMLCanvasElementTable, this, slot);
}

void setJSHTMLCanvasElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(static_cast<JSHTMLCanvasElement*>(thisObject)->impl());
    imp->setWidth(value.toInt32(exec));
}

void setJSHTMLCanvasElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(static_cast<JSHTMLCanvasElement*>(thisObject)->impl());
    imp->setHeight(value.toInt32(exec));
}

JSValue JSHTMLCanvasElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLCanvasElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsHTMLCanvasElementPrototypeFunctionToDataURL(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLCanvasElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLCanvasElement* castedThisObj = static_cast<JSHTMLCanvasElement*>(asObject(thisValue));
    HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& type = valueToStringWithUndefinedOrNullCheck(exec, args.at(0));


    JSC::JSValue result = jsString(exec, imp->toDataURL(type, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsHTMLCanvasElementPrototypeFunctionGetContext(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLCanvasElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLCanvasElement* castedThisObj = static_cast<JSHTMLCanvasElement*>(asObject(thisValue));
    HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(castedThisObj->impl());
    const UString& contextId = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getContext(contextId)));
    return result;
}


}
